/* game-controller.c generated by valac 0.56.18, the Vala compiler
 * generated from game-controller.vala, do not modify */

/* game-controller.vala
 *
 * Copyright 2022 Vojtěch Perník
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WG_TYPE_GAME_CONTROLLER (wg_game_controller_get_type ())
#define WG_GAME_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_TYPE_GAME_CONTROLLER, WGGameController))
#define WG_GAME_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_TYPE_GAME_CONTROLLER, WGGameControllerClass))
#define WG_IS_GAME_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_TYPE_GAME_CONTROLLER))
#define WG_IS_GAME_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_TYPE_GAME_CONTROLLER))
#define WG_GAME_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_TYPE_GAME_CONTROLLER, WGGameControllerClass))

typedef struct _WGGameController WGGameController;
typedef struct _WGGameControllerClass WGGameControllerClass;
typedef struct _WGGameControllerPrivate WGGameControllerPrivate;

#define WG_DATA_PARSER_TYPE_WORD (wg_data_parser_word_get_type ())
#define WG_DATA_PARSER_WORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_DATA_PARSER_TYPE_WORD, WGDataParserWord))
#define WG_DATA_PARSER_WORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_DATA_PARSER_TYPE_WORD, WGDataParserWordClass))
#define WG_DATA_PARSER_IS_WORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_DATA_PARSER_TYPE_WORD))
#define WG_DATA_PARSER_IS_WORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_DATA_PARSER_TYPE_WORD))
#define WG_DATA_PARSER_WORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_DATA_PARSER_TYPE_WORD, WGDataParserWordClass))

typedef struct _WGDataParserWord WGDataParserWord;
typedef struct _WGDataParserWordClass WGDataParserWordClass;

#define WG_TYPE_GRID (wg_grid_get_type ())
#define WG_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_TYPE_GRID, WGGrid))
#define WG_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_TYPE_GRID, WGGridClass))
#define WG_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_TYPE_GRID))
#define WG_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_TYPE_GRID))
#define WG_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_TYPE_GRID, WGGridClass))

typedef struct _WGGrid WGGrid;
typedef struct _WGGridClass WGGridClass;
enum  {
	WG_GAME_CONTROLLER_0_PROPERTY,
	WG_GAME_CONTROLLER_CORRECT_WORD_PROPERTY,
	WG_GAME_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* wg_game_controller_properties[WG_GAME_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	WG_CELL_STATE_CORRECT,
	WG_CELL_STATE_WRONG,
	WG_CELL_STATE_WRONG_POSITION,
	WG_CELL_STATE_UNKNOWN,
	WG_CELL_STATE_NONE
} WGCellState;

#define WG_TYPE_CELL_STATE (wg_cell_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	WG_GAME_CONTROLLER_GAME_OVER_SIGNAL,
	WG_GAME_CONTROLLER_CHANGE_LETTER_STATE_SIGNAL,
	WG_GAME_CONTROLLER_NUM_SIGNALS
};
static guint wg_game_controller_signals[WG_GAME_CONTROLLER_NUM_SIGNALS] = {0};

struct _WGGameController {
	AdwBin parent_instance;
	WGGameControllerPrivate * priv;
};

struct _WGGameControllerClass {
	AdwBinClass parent_class;
};

struct _WGGameControllerPrivate {
	WGDataParserWord* _correct_word;
	WGDataParserWord** dictionary;
	gint dictionary_length1;
	gint _dictionary_size_;
	WGGrid* grid;
};

static gint WGGameController_private_offset;
static gpointer wg_game_controller_parent_class = NULL;

VALA_EXTERN GType wg_game_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGGameController, g_object_unref)
VALA_EXTERN GType wg_data_parser_word_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGDataParserWord, g_object_unref)
VALA_EXTERN GType wg_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGGrid, g_object_unref)
VALA_EXTERN WGDataParserWord** wg_data_parser_get_dictionary (gint* result_length1);
VALA_EXTERN WGGrid* wg_grid_new (void);
VALA_EXTERN WGGrid* wg_grid_construct (GType object_type);
VALA_EXTERN void wg_game_controller_new_word (WGGameController* self);
static void wg_game_controller_set_correct_word (WGGameController* self,
                                          WGDataParserWord* value);
VALA_EXTERN WGDataParserWord* wg_game_controller_get_correct_word (WGGameController* self);
VALA_EXTERN const gchar* wg_data_parser_word_get_word (WGDataParserWord* self);
VALA_EXTERN void wg_grid_new_game (WGGrid* self);
VALA_EXTERN gboolean wg_game_controller_grab_focus (WGGameController* self);
VALA_EXTERN GType wg_cell_state_get_type (void) G_GNUC_CONST ;
static GList* wg_game_controller_check_word (WGGameController* self,
                                      gchar** written_word,
                                      gint written_word_length1);
VALA_EXTERN gboolean wg_data_parser_check_if_word_exists (gchar** characters,
                                              gint characters_length1);
VALA_EXTERN gchar** wg_data_parser_word_get_characters (WGDataParserWord* self,
                                            gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint __lambda9_ (gint a,
                 gint b);
static gint ___lambda9__gcompare_func (gconstpointer a,
                                gconstpointer b);
VALA_EXTERN void wg_game_controller_insert (WGGameController* self,
                                const gchar* text);
VALA_EXTERN void wg_grid_insert (WGGrid* self,
                     const gchar* text);
VALA_EXTERN void wg_game_controller_backspace (WGGameController* self);
VALA_EXTERN void wg_grid_backspace (WGGrid* self);
VALA_EXTERN void wg_game_controller_confirm (WGGameController* self);
VALA_EXTERN void wg_grid_confirm (WGGrid* self);
VALA_EXTERN WGGameController* wg_game_controller_new (void);
VALA_EXTERN WGGameController* wg_game_controller_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static GObject * wg_game_controller_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static GList* _wg_game_controller_check_word_wg_grid_confirmed (WGGrid* _sender,
                                                         gchar** row_content,
                                                         gint row_content_length1,
                                                         gpointer self);
static void _wg_game_controller___lambda10_ (WGGameController* self,
                                      gboolean win);
static void __wg_game_controller___lambda10__wg_grid_game_over (WGGrid* _sender,
                                                         gboolean win,
                                                         gpointer self);
static void wg_game_controller_finalize (GObject * obj);
static GType wg_game_controller_get_type_once (void);
static void _vala_wg_game_controller_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_wg_game_controller_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
wg_game_controller_get_instance_private (WGGameController* self)
{
	return G_STRUCT_MEMBER_P (self, WGGameController_private_offset);
}

void
wg_game_controller_new_word (WGGameController* self)
{
	gint32 word_index = 0;
	WGDataParserWord** _tmp0_;
	gint _tmp0__length1;
	WGDataParserWord** _tmp1_;
	gint _tmp1__length1;
	WGDataParserWord* _tmp2_;
	WGDataParserWord* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	WGGrid* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dictionary;
	_tmp0__length1 = self->priv->dictionary_length1;
	word_index = g_random_int_range ((gint32) 0, (gint32) _tmp0__length1);
	_tmp1_ = self->priv->dictionary;
	_tmp1__length1 = self->priv->dictionary_length1;
	_tmp2_ = _tmp1_[(guint) word_index];
	wg_game_controller_set_correct_word (self, _tmp2_);
	_tmp3_ = self->priv->_correct_word;
	_tmp4_ = wg_data_parser_word_get_word (_tmp3_);
	_tmp5_ = _tmp4_;
	g_debug (_ ("Current word: %s\n"), _tmp5_);
	_tmp6_ = self->priv->grid;
	wg_grid_new_game (_tmp6_);
}

gboolean
wg_game_controller_grab_focus (WGGameController* self)
{
	WGGrid* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->grid;
	result = gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gint
__lambda9_ (gint a,
            gint b)
{
	gint result;
	result = ((gint) (a > b)) - ((gint) (a < b));
	return result;
}

static gint
___lambda9__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda9_ ((gint) ((gintptr) a), (gint) ((gintptr) b));
	return result;
}

static GList*
wg_game_controller_check_word (WGGameController* self,
                               gchar** written_word,
                               gint written_word_length1)
{
	GHashTable* res_table = NULL;
	GHashTable* _tmp0_;
	gchar** _written_word = NULL;
	WGDataParserWord* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _written_word_length1;
	gint __written_word_size_;
	gchar** _remaining_word = NULL;
	WGDataParserWord* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_ = 0;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _remaining_word_length1;
	gint __remaining_word_size_;
	gchar** checked_characters = NULL;
	gchar** _tmp41_;
	gint checked_characters_length1;
	gint _checked_characters_size_;
	GList* keys = NULL;
	GHashTable* _tmp60_;
	GList* _tmp61_;
	GList* res = NULL;
	GList* _tmp62_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!wg_data_parser_check_if_word_exists (written_word, (gint) written_word_length1)) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_hash_table_new_full (NULL, NULL, NULL, NULL);
	res_table = _tmp0_;
	_tmp1_ = self->priv->_correct_word;
	_tmp2_ = wg_data_parser_word_get_characters (_tmp1_, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_written_word = _tmp5_;
	_written_word_length1 = _tmp5__length1;
	__written_word_size_ = _written_word_length1;
	_tmp6_ = self->priv->_correct_word;
	_tmp7_ = wg_data_parser_word_get_characters (_tmp6_, &_tmp8_);
	_tmp7__length1 = _tmp8_;
	_tmp9_ = _tmp7_;
	_tmp9__length1 = _tmp7__length1;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup2 (_tmp9_, _tmp9__length1) : _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_remaining_word = _tmp10_;
	_remaining_word_length1 = _tmp10__length1;
	__remaining_word_size_ = _remaining_word_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gchar* correct_cell = NULL;
				WGDataParserWord* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_ = 0;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* written_cell = NULL;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < written_word_length1)) {
					break;
				}
				_tmp13_ = self->priv->_correct_word;
				_tmp14_ = wg_data_parser_word_get_characters (_tmp13_, &_tmp15_);
				_tmp14__length1 = _tmp15_;
				_tmp16_ = _tmp14_;
				_tmp16__length1 = _tmp14__length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = g_strdup (_tmp17_);
				correct_cell = _tmp18_;
				_tmp19_ = written_word[i];
				_tmp20_ = g_strdup (_tmp19_);
				written_cell = _tmp20_;
				_tmp21_ = written_cell;
				_tmp22_ = correct_cell;
				if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
					GHashTable* _tmp23_;
					const gchar* _tmp24_;
					gchar** _tmp25_;
					gint _tmp25__length1;
					gchar** _tmp26_;
					gint _tmp26__length1;
					_tmp23_ = res_table;
					g_hash_table_insert (_tmp23_, (gpointer) ((gintptr) i), (gpointer) ((gintptr) WG_CELL_STATE_CORRECT));
					_tmp24_ = written_cell;
					g_signal_emit (self, wg_game_controller_signals[WG_GAME_CONTROLLER_CHANGE_LETTER_STATE_SIGNAL], 0, _tmp24_, WG_CELL_STATE_CORRECT);
					_tmp25_ = _remaining_word;
					_tmp25__length1 = _remaining_word_length1;
					_g_free0 (_tmp25_[i]);
					_tmp25_[i] = NULL;
					_tmp26_ = _written_word;
					_tmp26__length1 = _written_word_length1;
					_g_free0 (_tmp26_[i]);
					_tmp26_[i] = NULL;
				} else {
					GHashTable* _tmp27_;
					const gchar* _tmp28_;
					_tmp27_ = res_table;
					g_hash_table_insert (_tmp27_, (gpointer) ((gintptr) i), (gpointer) ((gintptr) WG_CELL_STATE_WRONG));
					_tmp28_ = written_cell;
					g_signal_emit (self, wg_game_controller_signals[WG_GAME_CONTROLLER_CHANGE_LETTER_STATE_SIGNAL], 0, _tmp28_, WG_CELL_STATE_WRONG);
				}
				_g_free0 (written_cell);
				_g_free0 (correct_cell);
			}
		}
	}
	{
		gint w = 0;
		w = 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = w;
					w = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				if (!(w < written_word_length1)) {
					break;
				}
				_tmp31_ = _written_word;
				_tmp31__length1 = _written_word_length1;
				_tmp32_ = _tmp31_[w];
				if (_tmp32_ == NULL) {
					continue;
				}
				{
					gint r = 0;
					r = 0;
					{
						gboolean _tmp33_ = FALSE;
						_tmp33_ = TRUE;
						while (TRUE) {
							const gchar* _tmp35_;
							gchar** _tmp36_;
							gint _tmp36__length1;
							const gchar* _tmp37_;
							if (!_tmp33_) {
								gint _tmp34_;
								_tmp34_ = r;
								r = _tmp34_ + 1;
							}
							_tmp33_ = FALSE;
							if (!(r < 5)) {
								break;
							}
							_tmp35_ = written_word[w];
							_tmp36_ = _remaining_word;
							_tmp36__length1 = _remaining_word_length1;
							_tmp37_ = _tmp36_[r];
							if (g_strcmp0 (_tmp35_, _tmp37_) == 0) {
								GHashTable* _tmp38_;
								const gchar* _tmp39_;
								gchar** _tmp40_;
								gint _tmp40__length1;
								_tmp38_ = res_table;
								g_hash_table_insert (_tmp38_, (gpointer) ((gintptr) w), (gpointer) ((gintptr) WG_CELL_STATE_WRONG_POSITION));
								_tmp39_ = written_word[w];
								g_signal_emit (self, wg_game_controller_signals[WG_GAME_CONTROLLER_CHANGE_LETTER_STATE_SIGNAL], 0, _tmp39_, WG_CELL_STATE_WRONG_POSITION);
								_tmp40_ = _remaining_word;
								_tmp40__length1 = _remaining_word_length1;
								_g_free0 (_tmp40_[r]);
								_tmp40_[r] = NULL;
								break;
							}
						}
					}
				}
			}
		}
	}
	_tmp41_ = g_new0 (gchar*, 0 + 1);
	checked_characters = _tmp41_;
	checked_characters_length1 = 0;
	_checked_characters_size_ = checked_characters_length1;
	{
		gchar** character_collection = NULL;
		gint character_collection_length1 = 0;
		gint _character_collection_size_ = 0;
		gint character_it = 0;
		character_collection = written_word;
		character_collection_length1 = written_word_length1;
		for (character_it = 0; character_it < character_collection_length1; character_it = character_it + 1) {
			gchar* _tmp42_;
			gchar* character = NULL;
			_tmp42_ = g_strdup (character_collection[character_it]);
			character = _tmp42_;
			{
				const gchar* _tmp43_;
				gchar** _tmp44_;
				gint _tmp44__length1;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gint count_in_correct = 0;
				gint count_in_written = 0;
				WGDataParserWord* _tmp47_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				gint _tmp49_ = 0;
				gchar** _tmp50_;
				gint _tmp50__length1;
				_tmp43_ = character;
				_tmp44_ = checked_characters;
				_tmp44__length1 = checked_characters_length1;
				if (_vala_string_array_contains (_tmp44_, _tmp44__length1, _tmp43_)) {
					_g_free0 (character);
					continue;
				}
				_tmp45_ = character;
				_tmp46_ = g_strdup (_tmp45_);
				_vala_array_add3 (&checked_characters, &checked_characters_length1, &_checked_characters_size_, _tmp46_);
				count_in_correct = 0;
				count_in_written = 0;
				_tmp47_ = self->priv->_correct_word;
				_tmp48_ = wg_data_parser_word_get_characters (_tmp47_, &_tmp49_);
				_tmp48__length1 = _tmp49_;
				_tmp50_ = _tmp48_;
				_tmp50__length1 = _tmp48__length1;
				{
					gchar** _character_collection = NULL;
					gint _character_collection_length1 = 0;
					gint __character_collection_size_ = 0;
					gint _character_it = 0;
					_character_collection = _tmp50_;
					_character_collection_length1 = _tmp50__length1;
					for (_character_it = 0; _character_it < _character_collection_length1; _character_it = _character_it + 1) {
						gchar* _tmp51_;
						gchar* _character = NULL;
						_tmp51_ = g_strdup (_character_collection[_character_it]);
						_character = _tmp51_;
						{
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							_tmp52_ = _character;
							_tmp53_ = character;
							if (g_strcmp0 (_tmp52_, _tmp53_) == 0) {
								gint _tmp54_;
								_tmp54_ = count_in_correct;
								count_in_correct = _tmp54_ + 1;
							}
							_g_free0 (_character);
						}
					}
				}
				{
					gchar** _character_collection = NULL;
					gint _character_collection_length1 = 0;
					gint __character_collection_size_ = 0;
					gint _character_it = 0;
					_character_collection = written_word;
					_character_collection_length1 = written_word_length1;
					for (_character_it = 0; _character_it < _character_collection_length1; _character_it = _character_it + 1) {
						gchar* _tmp55_;
						gchar* _character = NULL;
						_tmp55_ = g_strdup (_character_collection[_character_it]);
						_character = _tmp55_;
						{
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							_tmp56_ = _character;
							_tmp57_ = character;
							if (g_strcmp0 (_tmp56_, _tmp57_) == 0) {
								gint _tmp58_;
								_tmp58_ = count_in_written;
								count_in_written = _tmp58_ + 1;
							}
							_g_free0 (_character);
						}
					}
				}
				if (count_in_correct == 0) {
					_g_free0 (character);
					continue;
				}
				if (count_in_written == 0) {
					_g_free0 (character);
					continue;
				}
				if (count_in_correct > count_in_written) {
					const gchar* _tmp59_;
					_tmp59_ = character;
					g_signal_emit (self, wg_game_controller_signals[WG_GAME_CONTROLLER_CHANGE_LETTER_STATE_SIGNAL], 0, _tmp59_, WG_CELL_STATE_WRONG_POSITION);
				}
				_g_free0 (character);
			}
		}
	}
	_tmp60_ = res_table;
	_tmp61_ = g_hash_table_get_keys (_tmp60_);
	keys = _tmp61_;
	keys = g_list_sort (keys, ___lambda9__gcompare_func);
	res = NULL;
	_tmp62_ = keys;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp62_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			gint i = 0;
			i = (gint) ((gintptr) i_it->data);
			{
				GHashTable* _tmp63_;
				gconstpointer _tmp64_;
				_tmp63_ = res_table;
				_tmp64_ = g_hash_table_lookup (_tmp63_, (gpointer) ((gintptr) i));
				res = g_list_append (res, (gpointer) ((gintptr) _tmp64_));
			}
		}
	}
	result = res;
	(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
	checked_characters = (_vala_array_free (checked_characters, checked_characters_length1, (GDestroyNotify) g_free), NULL);
	_remaining_word = (_vala_array_free (_remaining_word, _remaining_word_length1, (GDestroyNotify) g_free), NULL);
	_written_word = (_vala_array_free (_written_word, _written_word_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (res_table);
	return result;
}

void
wg_game_controller_insert (WGGameController* self,
                           const gchar* text)
{
	WGGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	wg_game_controller_grab_focus (self);
	_tmp0_ = self->priv->grid;
	wg_grid_insert (_tmp0_, text);
}

void
wg_game_controller_backspace (WGGameController* self)
{
	WGGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	wg_game_controller_grab_focus (self);
	_tmp0_ = self->priv->grid;
	wg_grid_backspace (_tmp0_);
}

void
wg_game_controller_confirm (WGGameController* self)
{
	WGGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	wg_game_controller_grab_focus (self);
	_tmp0_ = self->priv->grid;
	wg_grid_confirm (_tmp0_);
}

WGGameController*
wg_game_controller_construct (GType object_type)
{
	WGGameController * self = NULL;
	self = (WGGameController*) g_object_new (object_type, NULL);
	return self;
}

WGGameController*
wg_game_controller_new (void)
{
	return wg_game_controller_construct (WG_TYPE_GAME_CONTROLLER);
}

WGDataParserWord*
wg_game_controller_get_correct_word (WGGameController* self)
{
	WGDataParserWord* result;
	WGDataParserWord* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_correct_word;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
wg_game_controller_set_correct_word (WGGameController* self,
                                     WGDataParserWord* value)
{
	WGDataParserWord* old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_game_controller_get_correct_word (self);
	if (old_value != value) {
		WGDataParserWord* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_correct_word);
		self->priv->_correct_word = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, wg_game_controller_properties[WG_GAME_CONTROLLER_CORRECT_WORD_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_ENUM) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_enum (param_values + 2), data2);
}

static GList*
_wg_game_controller_check_word_wg_grid_confirmed (WGGrid* _sender,
                                                  gchar** row_content,
                                                  gint row_content_length1,
                                                  gpointer self)
{
	GList* result;
	result = wg_game_controller_check_word ((WGGameController*) self, row_content, row_content_length1);
	return result;
}

static void
_wg_game_controller___lambda10_ (WGGameController* self,
                                 gboolean win)
{
	g_signal_emit (self, wg_game_controller_signals[WG_GAME_CONTROLLER_GAME_OVER_SIGNAL], 0, win);
}

static void
__wg_game_controller___lambda10__wg_grid_game_over (WGGrid* _sender,
                                                    gboolean win,
                                                    gpointer self)
{
	_wg_game_controller___lambda10_ ((WGGameController*) self, win);
}

static GObject *
wg_game_controller_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WGGameController * self;
	WGGrid* _tmp0_;
	WGGrid* _tmp1_;
	WGGrid* _tmp2_;
	parent_class = G_OBJECT_CLASS (wg_game_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_GAME_CONTROLLER, WGGameController);
	_tmp0_ = self->priv->grid;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->grid;
	g_signal_connect_object (_tmp1_, "confirmed", (GCallback) _wg_game_controller_check_word_wg_grid_confirmed, self, 0);
	_tmp2_ = self->priv->grid;
	g_signal_connect_object (_tmp2_, "game-over", (GCallback) __wg_game_controller___lambda10__wg_grid_game_over, self, 0);
	return obj;
}

static void
wg_game_controller_class_init (WGGameControllerClass * klass,
                               gpointer klass_data)
{
	wg_game_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WGGameController_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_wg_game_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wg_game_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = wg_game_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = wg_game_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_GAME_CONTROLLER_CORRECT_WORD_PROPERTY, wg_game_controller_properties[WG_GAME_CONTROLLER_CORRECT_WORD_PROPERTY] = g_param_spec_object ("correct-word", "correct-word", "correct-word", WG_DATA_PARSER_TYPE_WORD, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	wg_game_controller_signals[WG_GAME_CONTROLLER_GAME_OVER_SIGNAL] = g_signal_new ("game-over", WG_TYPE_GAME_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	wg_game_controller_signals[WG_GAME_CONTROLLER_CHANGE_LETTER_STATE_SIGNAL] = g_signal_new ("change-letter-state", WG_TYPE_GAME_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_ENUM, G_TYPE_NONE, 2, G_TYPE_STRING, WG_TYPE_CELL_STATE);
}

static void
wg_game_controller_instance_init (WGGameController * self,
                                  gpointer klass)
{
	gint _tmp0_ = 0;
	WGDataParserWord** _tmp1_;
	WGGrid* _tmp2_;
	self->priv = wg_game_controller_get_instance_private (self);
	_tmp1_ = wg_data_parser_get_dictionary (&_tmp0_);
	self->priv->dictionary = _tmp1_;
	self->priv->dictionary_length1 = _tmp0_;
	self->priv->_dictionary_size_ = self->priv->dictionary_length1;
	_tmp2_ = wg_grid_new ();
	g_object_ref_sink (_tmp2_);
	self->priv->grid = _tmp2_;
}

static void
wg_game_controller_finalize (GObject * obj)
{
	WGGameController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_TYPE_GAME_CONTROLLER, WGGameController);
	_g_object_unref0 (self->priv->_correct_word);
	self->priv->dictionary = (_vala_array_free (self->priv->dictionary, self->priv->dictionary_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->grid);
	G_OBJECT_CLASS (wg_game_controller_parent_class)->finalize (obj);
}

static GType
wg_game_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WGGameControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wg_game_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WGGameController), 0, (GInstanceInitFunc) wg_game_controller_instance_init, NULL };
	GType wg_game_controller_type_id;
	wg_game_controller_type_id = g_type_register_static (adw_bin_get_type (), "WGGameController", &g_define_type_info, 0);
	WGGameController_private_offset = g_type_add_instance_private (wg_game_controller_type_id, sizeof (WGGameControllerPrivate));
	return wg_game_controller_type_id;
}

GType
wg_game_controller_get_type (void)
{
	static volatile gsize wg_game_controller_type_id__once = 0;
	if (g_once_init_enter (&wg_game_controller_type_id__once)) {
		GType wg_game_controller_type_id;
		wg_game_controller_type_id = wg_game_controller_get_type_once ();
		g_once_init_leave (&wg_game_controller_type_id__once, wg_game_controller_type_id);
	}
	return wg_game_controller_type_id__once;
}

static void
_vala_wg_game_controller_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	WGGameController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_TYPE_GAME_CONTROLLER, WGGameController);
	switch (property_id) {
		case WG_GAME_CONTROLLER_CORRECT_WORD_PROPERTY:
		g_value_set_object (value, wg_game_controller_get_correct_word (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wg_game_controller_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	WGGameController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_TYPE_GAME_CONTROLLER, WGGameController);
	switch (property_id) {
		case WG_GAME_CONTROLLER_CORRECT_WORD_PROPERTY:
		wg_game_controller_set_correct_word (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

