/* TasklistButton.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TasklistButton.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include "tasklistapplet.h"
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "plugin.h"
#include <libxfce4windowing/libxfce4windowing.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>

#define BUTTON_MAX_WIDTH 232
#define LABEL_MAX_WIDTH 24
#define BUTTON_PADDING 8
#define DEFAULT_ICON_SIZE 32
#define ICON_PADDING 18
#define TARGET_ICON_SCALE (2.0 / 3.0)
#define FORMULA_SWAP_POINT (ICON_PADDING * 3)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	TASKLIST_BUTTON_0_PROPERTY,
	TASKLIST_BUTTON_POPOVER_MANAGER_PROPERTY,
	TASKLIST_BUTTON_WINDOW_PROPERTY,
	TASKLIST_BUTTON_SHOW_LABEL_PROPERTY,
	TASKLIST_BUTTON_SHOW_ICON_PROPERTY,
	TASKLIST_BUTTON_NUM_PROPERTIES
};
static GParamSpec* tasklist_button_properties[TASKLIST_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoLanguage_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoLanguage_free (var), NULL)))
#define _pango_font_metrics_unref0(var) ((var == NULL) ? NULL : (var = (pango_font_metrics_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

struct _TasklistButtonPrivate {
	GtkLabel* label;
	GtkImage* icon;
	GSettings* settings;
	TasklistButtonPopover* popover;
	GtkAllocation definite_allocation;
	BudgiePopoverManager* _popover_manager;
	XfwWindow* _window;
	gboolean _show_label;
	gboolean _show_icon;
	gint target_icon_size;
};

static gint TasklistButton_private_offset;
static gpointer tasklist_button_parent_class = NULL;
static GType tasklist_button_type_id = 0;

static void tasklist_button_on_settings_changed (TasklistButton* self,
                                          const gchar* key);
static void _tasklist_button_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static gboolean tasklist_button_update_state_cb (TasklistButton* self);
static void tasklist_button_on_size_allocate (TasklistButton* self,
                                       GtkAllocation* allocation);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static gint tasklist_button_get_css_width (TasklistButton* self,
                                    GtkWidget* widget);
static gboolean _tasklist_button_update_state_cb_gsource_func (gpointer self);
static void tasklist_button_real_get_preferred_width (GtkWidget* base,
                                               gint* minimum_width,
                                               gint* natural_width);
static gint tasklist_button_get_char_width (TasklistButton* self);
static void tasklist_button_on_window_icon_changed (TasklistButton* self);
static void tasklist_button_on_window_name_changed (TasklistButton* self);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void _vala_PangoLanguage_free (PangoLanguage* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gboolean tasklist_button_real_scroll_event (GtkWidget* base,
                                            GdkEventScroll* event);
static GObject * tasklist_button_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _tasklist_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                 GtkAllocation* allocation,
                                                                 gpointer self);
static void _tasklist_button_on_window_name_changed_libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                                    gpointer self);
static void _tasklist_button_on_window_icon_changed_libxfce4windowing_window_icon_changed (XfwWindow* _sender,
                                                                                    gpointer self);
static void tasklist_button_finalize (GObject * obj);
static void _vala_tasklist_button_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_tasklist_button_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
tasklist_button_get_instance_private (TasklistButton* self)
{
	return G_STRUCT_MEMBER_P (self, TasklistButton_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tasklist_button_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	tasklist_button_on_settings_changed ((TasklistButton*) self, key);
}

TasklistButton*
tasklist_button_construct (GType object_type,
                           XfwWindow* window,
                           BudgiePopoverManager* popover_manager,
                           GSettings* settings)
{
	TasklistButton * self = NULL;
	GSettings* _tmp0_;
	TasklistButtonPopover* _tmp1_;
	TasklistButtonPopover* _tmp2_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (popover_manager != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (TasklistButton*) g_object_new (object_type, "window", window, "popover-manager", popover_manager, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_signal_connect_object (settings, "changed", (GCallback) _tasklist_button_on_settings_changed_g_settings_changed, self, 0);
	tasklist_button_on_settings_changed (self, "show-labels");
	tasklist_button_on_settings_changed (self, "show-icons");
	_tmp1_ = tasklist_button_popover_new (self, window);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp1_;
	_tmp2_ = self->priv->popover;
	budgie_popover_manager_register_popover (popover_manager, (GtkWidget*) self, (GtkPopover*) _tmp2_);
	return self;
}

TasklistButton*
tasklist_button_new (XfwWindow* window,
                     BudgiePopoverManager* popover_manager,
                     GSettings* settings)
{
	return tasklist_button_construct (TYPE_TASKLIST_BUTTON, window, popover_manager, settings);
}

void
tasklist_button_gracefully_die (TasklistButton* self)
{
	GtkSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_object_get (_tmp0_, "gtk-enable-animations", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gtk_widget_hide ((GtkWidget*) self);
		gtk_widget_destroy ((GtkWidget*) self);
		return;
	}
	gtk_widget_hide ((GtkWidget*) self);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
tasklist_button_on_settings_changed (TasklistButton* self,
                                     const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("show-labels")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp3_;
				_tmp3_ = self->priv->settings;
				tasklist_button_set_show_label (self, g_settings_get_boolean (_tmp3_, key));
				tasklist_button_update_state_cb (self);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("show-icons")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp4_;
				_tmp4_ = self->priv->settings;
				tasklist_button_set_show_icon (self, g_settings_get_boolean (_tmp4_, key));
				tasklist_button_update_state_cb (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static gboolean
_tasklist_button_update_state_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = tasklist_button_update_state_cb ((TasklistButton*) self);
	return result;
}

static void
tasklist_button_on_size_allocate (TasklistButton* self,
                                  GtkAllocation* allocation)
{
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	gint max = 0;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	gint min_width = 0;
	GtkWidget* _tmp5_;
	gint min_image_width = 0;
	gboolean _tmp6_ = FALSE;
	GtkAllocation _tmp7_;
	GtkAllocation _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = self->priv->definite_allocation;
	_tmp1_ = *allocation;
	if (_cairo_rectangle_int_equal (&_tmp0_, &_tmp1_) == TRUE) {
		return;
	}
	_tmp2_ = self->priv->definite_allocation;
	GTK_WIDGET_CLASS (tasklist_button_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), &_tmp2_);
	_tmp3_ = *allocation;
	_tmp4_ = *allocation;
	max = (gint) fmin ((gdouble) _tmp3_.width, (gdouble) _tmp4_.height);
	if (max > FORMULA_SWAP_POINT) {
		self->priv->target_icon_size = max - BUTTON_PADDING;
	} else {
		self->priv->target_icon_size = (gint) round (TARGET_ICON_SCALE * max);
	}
	min_width = tasklist_button_get_css_width (self, (GtkWidget*) self);
	_tmp5_ = gtk_bin_get_child ((GtkBin*) self);
	min_width += tasklist_button_get_css_width (self, _tmp5_);
	min_image_width = (self->priv->target_icon_size + min_width) + (2 * BUTTON_PADDING);
	_tmp7_ = *allocation;
	if (_tmp7_.width < (min_image_width + (2 * BUTTON_PADDING))) {
		GtkAllocation _tmp8_;
		_tmp8_ = *allocation;
		_tmp6_ = _tmp8_.width >= min_image_width;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		tasklist_button_set_show_label (self, FALSE);
	} else {
		GSettings* _tmp9_;
		_tmp9_ = self->priv->settings;
		if (g_settings_get_boolean (_tmp9_, "show-labels")) {
			tasklist_button_set_show_label (self, TRUE);
		} else {
			tasklist_button_set_show_label (self, FALSE);
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tasklist_button_update_state_cb_gsource_func, g_object_ref (self), g_object_unref);
	_tmp10_ = *allocation;
	self->priv->definite_allocation = _tmp10_;
}

static void
tasklist_button_real_get_preferred_width (GtkWidget* base,
                                          gint* minimum_width,
                                          gint* natural_width)
{
	TasklistButton * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint min_width = 0;
	gint char_width = 0;
	gboolean _tmp0_;
	self = (TasklistButton*) base;
	min_width = tasklist_button_get_css_width (self, (GtkWidget*) self);
	char_width = tasklist_button_get_char_width (self);
	_vala_minimum_width = min_width + (2 * BUTTON_PADDING);
	_vala_natural_width = (min_width + (2 * BUTTON_PADDING)) + (2 * BUTTON_PADDING);
	_tmp0_ = self->priv->_show_label;
	if (_tmp0_) {
		_vala_minimum_width = _vala_minimum_width + char_width;
		_vala_natural_width = _vala_natural_width + (char_width * LABEL_MAX_WIDTH);
	}
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static gboolean
tasklist_button_update_state_cb (TasklistButton* self)
{
	GtkImage* _tmp0_;
	gboolean _tmp1_;
	GtkLabel* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->icon;
	_tmp1_ = self->priv->_show_icon;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _tmp1_);
	_tmp2_ = self->priv->label;
	_tmp3_ = self->priv->_show_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_);
	tasklist_button_on_window_icon_changed (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = G_SOURCE_REMOVE;
	return result;
}

static void
tasklist_button_on_window_name_changed (TasklistButton* self)
{
	gchar* name = NULL;
	XfwWindow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = xfw_window_get_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->label;
	gtk_label_set_label (_tmp3_, name);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, name);
	_g_free0 (name);
}

static void
tasklist_button_on_window_icon_changed (TasklistButton* self)
{
	gint _tmp0_ = 0;
	gint size = 0;
	GdkPixbuf* pixbuf = NULL;
	XfwWindow* _tmp1_;
	GdkPixbuf* _tmp2_;
	GtkImage* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->target_icon_size == 0) {
		_tmp0_ = DEFAULT_ICON_SIZE;
	} else {
		_tmp0_ = self->priv->target_icon_size;
	}
	size = _tmp0_;
	_tmp1_ = self->priv->_window;
	_tmp2_ = xfw_window_get_icon (_tmp1_, size, gtk_widget_get_scale_factor ((GtkWidget*) self));
	pixbuf = _tmp2_;
	_tmp3_ = self->priv->icon;
	gtk_image_set_from_pixbuf (_tmp3_, pixbuf);
}

static gint
tasklist_button_get_css_width (TasklistButton* self,
                               GtkWidget* widget)
{
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStateFlags state = 0U;
	GtkBorder margin = {0};
	GtkBorder _tmp2_ = {0};
	GtkBorder padding = {0};
	GtkBorder _tmp3_ = {0};
	GtkBorder border = {0};
	GtkBorder _tmp4_ = {0};
	gint16 min_width = 0;
	GtkBorder _tmp5_;
	GtkBorder _tmp6_;
	GtkBorder _tmp7_;
	GtkBorder _tmp8_;
	GtkBorder _tmp9_;
	GtkBorder _tmp10_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (widget != NULL, 0);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	state = gtk_style_context_get_state (context);
	gtk_style_context_get_margin (context, state, &_tmp2_);
	margin = _tmp2_;
	gtk_style_context_get_padding (context, state, &_tmp3_);
	padding = _tmp3_;
	gtk_style_context_get_border (context, state, &_tmp4_);
	border = _tmp4_;
	_tmp5_ = margin;
	_tmp6_ = margin;
	min_width = _tmp5_.left + _tmp6_.right;
	_tmp7_ = padding;
	_tmp8_ = padding;
	min_width += _tmp7_.left + _tmp8_.right;
	_tmp9_ = border;
	_tmp10_ = border;
	min_width += _tmp9_.left + _tmp10_.right;
	result = (gint) min_width;
	_g_object_unref0 (context);
	return result;
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

static void
_vala_PangoLanguage_free (PangoLanguage* self)
{
	g_boxed_free (pango_language_get_type (), self);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static gint
tasklist_button_get_char_width (TasklistButton* self)
{
	PangoContext* context = NULL;
	GtkLabel* _tmp0_;
	PangoContext* _tmp1_;
	PangoContext* _tmp2_;
	GtkStyleContext* style = NULL;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	PangoFontDescription* description = NULL;
	GValue _tmp6_ = {0};
	GValue _tmp7_;
	void* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoFontMetrics* metrics = NULL;
	PangoLanguage* _tmp11_;
	PangoLanguage* _tmp12_;
	PangoFontMetrics* _tmp13_;
	PangoFontMetrics* _tmp14_;
	gint width = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->label;
	_tmp1_ = gtk_widget_get_pango_context ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = self->priv->label;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	style = _tmp5_;
	gtk_style_context_get_property (style, GTK_STYLE_PROPERTY_FONT, gtk_style_context_get_state (style), &_tmp6_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_value_get_boxed (&_tmp7_);
	_tmp9_ = __vala_PangoFontDescription_copy0 ((PangoFontDescription*) _tmp8_);
	_tmp10_ = _tmp9_;
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	description = _tmp10_;
	_tmp11_ = pango_context_get_language (context);
	_tmp12_ = _tmp11_;
	_tmp13_ = pango_context_get_metrics (context, description, _tmp12_);
	_tmp14_ = _tmp13_;
	__vala_PangoLanguage_free0 (_tmp12_);
	metrics = _tmp14_;
	width = pango_font_metrics_get_approximate_char_width (metrics);
	result = (((gint) width) + 512) >> 10;
	_pango_font_metrics_unref0 (metrics);
	__vala_PangoFontDescription_free0 (description);
	_g_object_unref0 (style);
	_g_object_unref0 (context);
	return result;
}

static gboolean
tasklist_button_real_scroll_event (GtkWidget* base,
                                   GdkEventScroll* event)
{
	TasklistButton * self;
	gboolean result;
	self = (TasklistButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

BudgiePopoverManager*
tasklist_button_get_popover_manager (TasklistButton* self)
{
	BudgiePopoverManager* result;
	BudgiePopoverManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_popover_manager;
	result = _tmp0_;
	return result;
}

static void
tasklist_button_set_popover_manager (TasklistButton* self,
                                     BudgiePopoverManager* value)
{
	BudgiePopoverManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasklist_button_get_popover_manager (self);
	if (old_value != value) {
		BudgiePopoverManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_popover_manager);
		self->priv->_popover_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasklist_button_properties[TASKLIST_BUTTON_POPOVER_MANAGER_PROPERTY]);
	}
}

XfwWindow*
tasklist_button_get_window (TasklistButton* self)
{
	XfwWindow* result;
	XfwWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
tasklist_button_set_window (TasklistButton* self,
                            XfwWindow* value)
{
	XfwWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasklist_button_get_window (self);
	if (old_value != value) {
		XfwWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasklist_button_properties[TASKLIST_BUTTON_WINDOW_PROPERTY]);
	}
}

gboolean
tasklist_button_get_show_label (TasklistButton* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_label;
	return result;
}

void
tasklist_button_set_show_label (TasklistButton* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = tasklist_button_get_show_label (self);
	if (old_value != value) {
		self->priv->_show_label = value;
		g_object_notify_by_pspec ((GObject *) self, tasklist_button_properties[TASKLIST_BUTTON_SHOW_LABEL_PROPERTY]);
	}
}

gboolean
tasklist_button_get_show_icon (TasklistButton* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_icon;
	return result;
}

void
tasklist_button_set_show_icon (TasklistButton* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = tasklist_button_get_show_icon (self);
	if (old_value != value) {
		self->priv->_show_icon = value;
		g_object_notify_by_pspec ((GObject *) self, tasklist_button_properties[TASKLIST_BUTTON_SHOW_ICON_PROPERTY]);
	}
}

static void
_tasklist_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                            GtkAllocation* allocation,
                                                            gpointer self)
{
	tasklist_button_on_size_allocate ((TasklistButton*) self, allocation);
}

static void
_tasklist_button_on_window_name_changed_libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                               gpointer self)
{
	tasklist_button_on_window_name_changed ((TasklistButton*) self);
}

static void
_tasklist_button_on_window_icon_changed_libxfce4windowing_window_icon_changed (XfwWindow* _sender,
                                                                               gpointer self)
{
	tasklist_button_on_window_icon_changed ((TasklistButton*) self);
}

static GObject *
tasklist_button_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasklistButton * self;
	GtkStyleContext* _tmp0_;
	GtkBox* container = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkImage* _tmp3_;
	GtkLabel* _tmp4_ = NULL;
	GtkBox* _tmp5_;
	GtkImage* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	XfwWindow* _tmp9_;
	XfwWindow* _tmp10_;
	parent_class = G_OBJECT_CLASS (tasklist_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_BUTTON, TasklistButton);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "launcher");
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	container = _tmp1_;
	_tmp2_ = container;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	gtk_label_set_max_width_chars (_tmp4_, LABEL_MAX_WIDTH);
	gtk_label_set_ellipsize (_tmp4_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp4_;
	_tmp5_ = container;
	_tmp6_ = self->priv->icon;
	gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) BUTTON_PADDING);
	_tmp7_ = container;
	_tmp8_ = self->priv->label;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, TRUE, TRUE, (guint) BUTTON_PADDING);
	tasklist_button_on_window_name_changed (self);
	tasklist_button_on_window_icon_changed (self);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _tasklist_button_on_size_allocate_gtk_widget_size_allocate, self, 0);
	_tmp9_ = self->priv->_window;
	g_signal_connect_object (_tmp9_, "name-changed", (GCallback) _tasklist_button_on_window_name_changed_libxfce4windowing_window_name_changed, self, 0);
	_tmp10_ = self->priv->_window;
	g_signal_connect_object (_tmp10_, "icon-changed", (GCallback) _tasklist_button_on_window_icon_changed_libxfce4windowing_window_icon_changed, self, 0);
	_g_object_unref0 (container);
	return obj;
}

static void
tasklist_button_class_init (TasklistButtonClass * klass,
                            gpointer klass_data)
{
	tasklist_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasklistButton_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) tasklist_button_real_get_preferred_width;
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) tasklist_button_real_scroll_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_tasklist_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tasklist_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = tasklist_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasklist_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLIST_BUTTON_POPOVER_MANAGER_PROPERTY, tasklist_button_properties[TASKLIST_BUTTON_POPOVER_MANAGER_PROPERTY] = g_param_spec_object ("popover-manager", "popover-manager", "popover-manager", budgie_popover_manager_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLIST_BUTTON_WINDOW_PROPERTY, tasklist_button_properties[TASKLIST_BUTTON_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", xfw_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLIST_BUTTON_SHOW_LABEL_PROPERTY, tasklist_button_properties[TASKLIST_BUTTON_SHOW_LABEL_PROPERTY] = g_param_spec_boolean ("show-label", "show-label", "show-label", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLIST_BUTTON_SHOW_ICON_PROPERTY, tasklist_button_properties[TASKLIST_BUTTON_SHOW_ICON_PROPERTY] = g_param_spec_boolean ("show-icon", "show-icon", "show-icon", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tasklist_button_instance_init (TasklistButton * self,
                               gpointer klass)
{
	self->priv = tasklist_button_get_instance_private (self);
	self->priv->target_icon_size = 0;
}

static void
tasklist_button_finalize (GObject * obj)
{
	TasklistButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TASKLIST_BUTTON, TasklistButton);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->_popover_manager);
	_g_object_unref0 (self->priv->_window);
	G_OBJECT_CLASS (tasklist_button_parent_class)->finalize (obj);
}

GType
tasklist_button_get_type (void)
{
	return tasklist_button_type_id;
}

GType
tasklist_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasklistButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklist_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasklistButton), 0, (GInstanceInitFunc) tasklist_button_instance_init, NULL };
	tasklist_button_type_id = g_type_module_register_type (module, gtk_toggle_button_get_type (), "TasklistButton", &g_define_type_info, 0);
	TasklistButton_private_offset = sizeof (TasklistButtonPrivate);
	return tasklist_button_type_id;
}

static void
_vala_tasklist_button_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	TasklistButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TASKLIST_BUTTON, TasklistButton);
	switch (property_id) {
		case TASKLIST_BUTTON_POPOVER_MANAGER_PROPERTY:
		g_value_set_object (value, tasklist_button_get_popover_manager (self));
		break;
		case TASKLIST_BUTTON_WINDOW_PROPERTY:
		g_value_set_object (value, tasklist_button_get_window (self));
		break;
		case TASKLIST_BUTTON_SHOW_LABEL_PROPERTY:
		g_value_set_boolean (value, tasklist_button_get_show_label (self));
		break;
		case TASKLIST_BUTTON_SHOW_ICON_PROPERTY:
		g_value_set_boolean (value, tasklist_button_get_show_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tasklist_button_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	TasklistButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TASKLIST_BUTTON, TasklistButton);
	switch (property_id) {
		case TASKLIST_BUTTON_POPOVER_MANAGER_PROPERTY:
		tasklist_button_set_popover_manager (self, g_value_get_object (value));
		break;
		case TASKLIST_BUTTON_WINDOW_PROPERTY:
		tasklist_button_set_window (self, g_value_get_object (value));
		break;
		case TASKLIST_BUTTON_SHOW_LABEL_PROPERTY:
		tasklist_button_set_show_label (self, g_value_get_boolean (value));
		break;
		case TASKLIST_BUTTON_SHOW_ICON_PROPERTY:
		tasklist_button_set_show_icon (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

