// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by goyacc -o proto.y.go -l -p proto proto.y. DO NOT EDIT.
package parser

import __yyfmt__ "fmt"

//lint:file-ignore SA4006 generated parser has unused values

import (
	"math"
	"strings"

	"github.com/bufbuild/protocompile/ast"
)

type protoSymType struct {
	yys          int
	file         *ast.FileNode
	syn          *ast.SyntaxNode
	ed           *ast.EditionNode
	fileElements []ast.FileElement
	pkg          nodeWithRunes[*ast.PackageNode]
	imprt        nodeWithRunes[*ast.ImportNode]
	msg          nodeWithRunes[*ast.MessageNode]
	msgElements  []ast.MessageElement
	fld          *ast.FieldNode
	msgFld       nodeWithRunes[*ast.FieldNode]
	mapFld       nodeWithRunes[*ast.MapFieldNode]
	mapType      *ast.MapTypeNode
	grp          *ast.GroupNode
	msgGrp       nodeWithRunes[*ast.GroupNode]
	oo           nodeWithRunes[*ast.OneofNode]
	ooElement    ast.OneofElement
	ooElements   []ast.OneofElement
	ext          nodeWithRunes[*ast.ExtensionRangeNode]
	resvd        nodeWithRunes[*ast.ReservedNode]
	en           nodeWithRunes[*ast.EnumNode]
	enElements   []ast.EnumElement
	env          nodeWithRunes[*ast.EnumValueNode]
	extend       nodeWithRunes[*ast.ExtendNode]
	extElement   ast.ExtendElement
	extElements  []ast.ExtendElement
	svc          nodeWithRunes[*ast.ServiceNode]
	svcElements  []ast.ServiceElement
	mtd          nodeWithRunes[*ast.RPCNode]
	mtdMsgType   *ast.RPCTypeNode
	mtdElements  []ast.RPCElement
	optRaw       *ast.OptionNode
	opt          nodeWithRunes[*ast.OptionNode]
	opts         *compactOptionSlices
	refRaw       *ast.FieldReferenceNode
	ref          nodeWithRunes[*ast.FieldReferenceNode]
	optNms       *fieldRefSlices
	cmpctOpts    *ast.CompactOptionsNode
	rng          *ast.RangeNode
	rngs         *rangeSlices
	names        *nameSlices
	cidPart      nodeWithRunes[*ast.IdentNode]
	cid          *identSlices
	tid          ast.IdentValueNode
	sl           *valueSlices
	msgLitFlds   *messageFieldList
	msgLitFld    *ast.MessageFieldNode
	v            ast.ValueNode
	il           ast.IntValueNode
	str          []*ast.StringLiteralNode
	s            *ast.StringLiteralNode
	i            *ast.UintLiteralNode
	f            *ast.FloatLiteralNode
	id           *ast.IdentNode
	b            *ast.RuneNode
	bs           []*ast.RuneNode
	err          error
}

const _STRING_LIT = 57346
const _INT_LIT = 57347
const _FLOAT_LIT = 57348
const _NAME = 57349
const _SYNTAX = 57350
const _EDITION = 57351
const _IMPORT = 57352
const _WEAK = 57353
const _PUBLIC = 57354
const _PACKAGE = 57355
const _OPTION = 57356
const _TRUE = 57357
const _FALSE = 57358
const _INF = 57359
const _NAN = 57360
const _REPEATED = 57361
const _OPTIONAL = 57362
const _REQUIRED = 57363
const _DOUBLE = 57364
const _FLOAT = 57365
const _INT32 = 57366
const _INT64 = 57367
const _UINT32 = 57368
const _UINT64 = 57369
const _SINT32 = 57370
const _SINT64 = 57371
const _FIXED32 = 57372
const _FIXED64 = 57373
const _SFIXED32 = 57374
const _SFIXED64 = 57375
const _BOOL = 57376
const _STRING = 57377
const _BYTES = 57378
const _GROUP = 57379
const _ONEOF = 57380
const _MAP = 57381
const _EXTENSIONS = 57382
const _TO = 57383
const _MAX = 57384
const _RESERVED = 57385
const _ENUM = 57386
const _MESSAGE = 57387
const _EXTEND = 57388
const _SERVICE = 57389
const _RPC = 57390
const _STREAM = 57391
const _RETURNS = 57392
const _EXPORT = 57393
const _LOCAL = 57394
const _ERROR = 57395

var protoToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"_STRING_LIT",
	"_INT_LIT",
	"_FLOAT_LIT",
	"_NAME",
	"_SYNTAX",
	"_EDITION",
	"_IMPORT",
	"_WEAK",
	"_PUBLIC",
	"_PACKAGE",
	"_OPTION",
	"_TRUE",
	"_FALSE",
	"_INF",
	"_NAN",
	"_REPEATED",
	"_OPTIONAL",
	"_REQUIRED",
	"_DOUBLE",
	"_FLOAT",
	"_INT32",
	"_INT64",
	"_UINT32",
	"_UINT64",
	"_SINT32",
	"_SINT64",
	"_FIXED32",
	"_FIXED64",
	"_SFIXED32",
	"_SFIXED64",
	"_BOOL",
	"_STRING",
	"_BYTES",
	"_GROUP",
	"_ONEOF",
	"_MAP",
	"_EXTENSIONS",
	"_TO",
	"_MAX",
	"_RESERVED",
	"_ENUM",
	"_MESSAGE",
	"_EXTEND",
	"_SERVICE",
	"_RPC",
	"_STREAM",
	"_RETURNS",
	"_EXPORT",
	"_LOCAL",
	"_ERROR",
	"'='",
	"';'",
	"':'",
	"'{'",
	"'}'",
	"'\\\\'",
	"'/'",
	"'?'",
	"'.'",
	"','",
	"'>'",
	"'<'",
	"'+'",
	"'-'",
	"'('",
	"')'",
	"'['",
	"']'",
	"'*'",
	"'&'",
	"'^'",
	"'%'",
	"'$'",
	"'#'",
	"'@'",
	"'!'",
	"'~'",
	"'`'",
}

var protoStatenames = [...]string{}

const protoEofCode = 1
const protoErrCode = 2
const protoInitialStackSize = 16

var protoExca = [...]int16{
	-1, 0,
	1, 6,
	-2, 21,
	-1, 1,
	1, -1,
	-2, 0,
	-1, 2,
	1, 1,
	-2, 21,
	-1, 3,
	1, 2,
	-2, 21,
	-1, 14,
	1, 7,
	-2, 0,
	-1, 94,
	54, 61,
	63, 61,
	71, 61,
	-2, 62,
	-1, 110,
	57, 38,
	60, 38,
	64, 38,
	69, 38,
	71, 38,
	-2, 35,
	-1, 122,
	54, 61,
	63, 61,
	71, 61,
	-2, 63,
	-1, 132,
	58, 266,
	-2, 0,
	-1, 135,
	57, 38,
	60, 38,
	64, 38,
	69, 38,
	71, 38,
	-2, 36,
	-1, 155,
	58, 232,
	-2, 0,
	-1, 161,
	58, 219,
	-2, 0,
	-1, 163,
	58, 267,
	-2, 0,
	-1, 219,
	58, 279,
	-2, 0,
	-1, 224,
	58, 84,
	64, 84,
	-2, 0,
	-1, 235,
	58, 233,
	-2, 0,
	-1, 298,
	58, 220,
	-2, 0,
	-1, 408,
	58, 280,
	-2, 0,
	-1, 436,
	55, 546,
	-2, 629,
	-1, 437,
	55, 547,
	-2, 630,
	-1, 441,
	54, 592,
	70, 592,
	-2, 548,
	-1, 442,
	54, 593,
	70, 593,
	-2, 549,
	-1, 443,
	54, 594,
	70, 594,
	-2, 550,
	-1, 444,
	54, 595,
	70, 595,
	-2, 551,
	-1, 445,
	54, 596,
	70, 596,
	-2, 552,
	-1, 446,
	54, 597,
	70, 597,
	-2, 553,
	-1, 447,
	54, 598,
	70, 598,
	-2, 554,
	-1, 448,
	54, 599,
	70, 599,
	-2, 555,
	-1, 449,
	54, 600,
	70, 600,
	-2, 556,
	-1, 450,
	54, 601,
	70, 601,
	-2, 557,
	-1, 451,
	54, 602,
	70, 602,
	-2, 558,
	-1, 452,
	54, 603,
	70, 603,
	-2, 559,
	-1, 453,
	54, 604,
	70, 604,
	-2, 560,
	-1, 454,
	54, 605,
	70, 605,
	-2, 561,
	-1, 455,
	54, 606,
	70, 606,
	-2, 562,
	-1, 456,
	54, 607,
	70, 607,
	-2, 563,
	-1, 457,
	54, 608,
	70, 608,
	-2, 564,
	-1, 458,
	54, 609,
	70, 609,
	-2, 565,
	-1, 459,
	54, 610,
	70, 610,
	-2, 566,
	-1, 460,
	54, 611,
	70, 611,
	-2, 567,
	-1, 461,
	54, 612,
	70, 612,
	-2, 568,
	-1, 462,
	54, 613,
	70, 613,
	-2, 569,
	-1, 463,
	54, 614,
	70, 614,
	-2, 570,
	-1, 464,
	54, 615,
	70, 615,
	-2, 571,
	-1, 465,
	54, 616,
	70, 616,
	-2, 572,
	-1, 466,
	54, 617,
	70, 617,
	-2, 573,
	-1, 467,
	54, 618,
	70, 618,
	-2, 574,
	-1, 468,
	54, 619,
	70, 619,
	-2, 575,
	-1, 469,
	54, 620,
	70, 620,
	-2, 576,
	-1, 470,
	54, 621,
	70, 621,
	-2, 577,
	-1, 471,
	54, 622,
	70, 622,
	-2, 578,
	-1, 472,
	54, 623,
	70, 623,
	-2, 579,
	-1, 473,
	54, 624,
	70, 624,
	-2, 580,
	-1, 474,
	54, 625,
	70, 625,
	-2, 581,
	-1, 475,
	54, 626,
	70, 626,
	-2, 582,
	-1, 476,
	54, 627,
	70, 627,
	-2, 583,
	-1, 477,
	54, 628,
	70, 628,
	-2, 584,
	-1, 478,
	54, 631,
	70, 631,
	-2, 585,
	-1, 479,
	54, 632,
	70, 632,
	-2, 586,
	-1, 480,
	54, 633,
	70, 633,
	-2, 587,
	-1, 481,
	54, 634,
	70, 634,
	-2, 588,
	-1, 482,
	54, 635,
	70, 635,
	-2, 589,
	-1, 483,
	54, 636,
	70, 636,
	-2, 590,
	-1, 484,
	54, 637,
	70, 637,
	-2, 591,
	-1, 486,
	55, 546,
	-2, 629,
	-1, 487,
	55, 547,
	-2, 630,
	-1, 565,
	58, 158,
	-2, 0,
	-1, 628,
	71, 147,
	-2, 144,
	-1, 640,
	58, 159,
	-2, 0,
	-1, 718,
	69, 53,
	-2, 50,
	-1, 778,
	71, 147,
	-2, 145,
	-1, 807,
	69, 53,
	-2, 51,
	-1, 851,
	58, 290,
	-2, 0,
	-1, 864,
	58, 291,
	-2, 0,
}

const protoPrivate = 57344

const protoLast = 2259

var protoAct = [...]int16{
	155, 7, 865, 7, 7, 528, 154, 18, 531, 530,
	142, 527, 641, 607, 105, 425, 715, 707, 718, 629,
	601, 625, 34, 36, 104, 628, 512, 42, 513, 221,
	492, 8, 409, 109, 38, 526, 549, 256, 299, 115,
	491, 439, 440, 119, 21, 20, 90, 223, 355, 116,
	117, 118, 164, 107, 19, 168, 160, 91, 110, 43,
	95, 98, 776, 236, 103, 94, 111, 44, 45, 46,
	47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 80, 81, 82, 83, 84, 85, 86,
	87, 88, 89, 540, 543, 421, 149, 138, 139, 140,
	768, 133, 125, 766, 426, 542, 95, 709, 97, 427,
	146, 145, 161, 127, 128, 129, 130, 144, 219, 613,
	822, 709, 550, 220, 825, 765, 544, 826, 858, 615,
	123, 602, 616, 764, 141, 148, 550, 161, 122, 161,
	550, 550, 134, 243, 294, 550, 296, 135, 149, 300,
	618, 9, 612, 566, 9, 9, 426, 561, 547, 9,
	611, 836, 539, 228, 810, 563, 550, 804, 514, 550,
	550, 797, 550, 557, 550, 153, 552, 550, 514, 306,
	240, 238, 406, 404, 550, 503, 149, 830, 43, 550,
	239, 248, 550, 293, 426, 295, 352, 610, 419, 420,
	594, 9, 9, 569, 417, 704, 418, 410, 593, 573,
	571, 563, 416, 423, 779, 430, 698, 120, 808, 9,
	791, 519, 501, 243, 428, 872, 120, 405, 136, 124,
	515, 710, 879, 877, 873, 869, 863, 862, 228, 23,
	515, 860, 852, 848, 840, 499, 9, 24, 835, 847,
	25, 26, 415, 812, 785, 507, 506, 505, 504, 414,
	240, 238, 407, 434, 438, 488, 502, 494, 495, 500,
	239, 248, 43, 489, 490, 351, 496, 433, 508, 431,
	297, 30, 27, 31, 32, 234, 300, 838, 28, 29,
	832, 771, 565, 159, 113, 499, 158, 157, 156, 137,
	132, 131, 126, 5, 6, 113, 113, 9, 709, 787,
	33, 353, 821, 780, 598, 597, 306, 509, 521, 500,
	510, 121, 13, 12, 412, 101, 102, 99, 100, 637,
	595, 35, 516, 564, 231, 230, 26, 867, 39, 40,
	15, 41, 845, 843, 772, 9, 232, 233, 769, 26,
	9, 706, 705, 850, 693, 37, 114, 112, 493, 632,
	630, 621, 600, 596, 113, 520, 638, 35, 517, 518,
	413, 43, 576, 577, 578, 579, 580, 581, 582, 583,
	584, 585, 586, 587, 864, 411, 4, 218, 523, 10,
	11, 408, 22, 162, 163, 301, 410, 298, 241, 511,
	302, 246, 498, 497, 639, 640, 235, 254, 245, 242,
	644, 166, 244, 541, 165, 548, 643, 237, 225, 522,
	554, 524, 224, 538, 604, 712, 647, 525, 169, 249,
	716, 108, 713, 356, 533, 533, 536, 535, 649, 173,
	228, 257, 304, 551, 717, 358, 545, 546, 651, 43,
	127, 128, 555, 175, 260, 553, 575, 422, 424, 529,
	147, 143, 92, 93, 227, 96, 626, 623, 642, 627,
	559, 17, 16, 14, 3, 2, 567, 1, 570, 572,
	0, 0, 0, 0, 0, 588, 589, 590, 591, 0,
	0, 0, 0, 556, 0, 0, 0, 0, 0, 43,
	129, 130, 560, 0, 0, 558, 0, 0, 562, 0,
	0, 0, 568, 0, 0, 574, 0, 0, 0, 592,
	609, 0, 0, 0, 0, 0, 608, 619, 0, 0,
	622, 0, 0, 599, 631, 0, 0, 0, 614, 633,
	0, 0, 634, 635, 0, 0, 603, 0, 533, 694,
	695, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 696, 617, 620, 95, 0, 0, 0, 0, 0,
	0, 0, 0, 699, 636, 702, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 697, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 767, 0,
	701, 773, 774, 770, 703, 0, 0, 0, 0, 700,
	0, 781, 0, 783, 0, 0, 0, 708, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 777, 0,
	0, 0, 778, 786, 0, 0, 0, 0, 775, 0,
	95, 0, 0, 0, 0, 0, 788, 782, 0, 784,
	0, 0, 0, 0, 0, 0, 0, 0, 792, 0,
	95, 789, 790, 0, 43, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 793, 0, 0, 0, 0, 0,
	0, 796, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 795, 799, 0, 801, 0, 0, 805,
	794, 802, 0, 806, 0, 807, 803, 0, 0, 0,
	0, 0, 798, 800, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 609, 0, 814, 0, 0, 816, 608, 813, 809,
	0, 0, 0, 818, 0, 819, 820, 0, 0, 146,
	145, 817, 0, 0, 0, 829, 144, 0, 0, 533,
	0, 0, 0, 834, 831, 0, 811, 823, 0, 815,
	0, 0, 0, 839, 148, 0, 841, 837, 833, 0,
	0, 0, 0, 0, 0, 828, 824, 827, 0, 0,
	146, 145, 842, 846, 0, 0, 851, 144, 0, 849,
	0, 854, 844, 0, 0, 853, 0, 0, 0, 0,
	0, 0, 0, 868, 861, 148, 0, 0, 0, 866,
	855, 856, 0, 0, 874, 871, 0, 875, 0, 0,
	876, 0, 866, 0, 0, 870, 0, 0, 0, 878,
	857, 606, 859, 35, 152, 150, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
	78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
	88, 89, 0, 0, 0, 0, 149, 0, 0, 0,
	0, 0, 0, 0, 426, 0, 532, 0, 0, 0,
	605, 35, 152, 150, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
	0, 0, 0, 0, 149, 0, 0, 0, 0, 0,
	0, 0, 426, 0, 532, 0, 0, 534, 35, 152,
	150, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
	83, 84, 85, 86, 87, 88, 89, 0, 0, 0,
	0, 149, 0, 0, 0, 0, 0, 0, 0, 426,
	0, 532, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 87, 88, 89, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 226, 97, 0, 0, 624, 44, 45, 46,
	47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 80, 81, 82, 83, 84, 85, 86,
	87, 88, 89, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 537, 0, 226, 0, 0, 0,
	229, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
	83, 84, 85, 86, 87, 88, 89, 0, 0, 0,
	0, 0, 222, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 229, 35, 152, 150, 44, 45,
	46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
	66, 67, 68, 69, 70, 71, 72, 73, 74, 75,
	76, 77, 78, 79, 80, 81, 82, 83, 84, 85,
	86, 87, 88, 89, 0, 0, 0, 0, 149, 0,
	0, 0, 0, 0, 226, 0, 0, 0, 151, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
	75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
	85, 86, 87, 88, 89, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	35, 514, 229, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 83, 84, 85, 86, 87, 88, 89, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 515, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 106,
	719, 720, 721, 722, 723, 724, 725, 726, 727, 728,
	729, 730, 731, 732, 733, 734, 735, 736, 737, 738,
	739, 740, 741, 742, 743, 744, 745, 746, 747, 748,
	749, 750, 751, 752, 753, 754, 755, 756, 757, 758,
	759, 760, 711, 761, 762, 763, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 714, 441, 442, 443, 444,
	445, 446, 447, 448, 449, 450, 451, 452, 453, 454,
	455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
	465, 466, 467, 468, 469, 470, 471, 472, 473, 474,
	475, 476, 477, 486, 487, 478, 479, 480, 481, 482,
	483, 484, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 485, 441, 442, 443, 444, 445, 446, 447, 448,
	449, 450, 451, 452, 453, 454, 455, 456, 457, 458,
	459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
	469, 470, 471, 472, 473, 474, 475, 476, 477, 436,
	437, 478, 479, 480, 481, 482, 483, 484, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 435, 359, 360,
	361, 362, 363, 364, 365, 366, 367, 368, 369, 370,
	371, 372, 373, 374, 375, 376, 377, 378, 379, 380,
	381, 382, 383, 384, 385, 386, 387, 388, 432, 389,
	390, 391, 392, 393, 394, 395, 396, 397, 398, 399,
	400, 401, 402, 403, 0, 0, 0, 0, 0, 247,
	0, 0, 0, 357, 261, 262, 263, 264, 265, 266,
	267, 26, 268, 269, 270, 271, 172, 171, 170, 272,
	273, 274, 275, 276, 277, 278, 279, 280, 281, 282,
	283, 284, 285, 286, 0, 253, 259, 252, 287, 288,
	255, 30, 27, 31, 289, 290, 291, 292, 250, 251,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 258,
	359, 360, 361, 362, 363, 364, 365, 366, 367, 368,
	369, 370, 371, 372, 373, 374, 375, 376, 377, 378,
	379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
	354, 389, 390, 391, 392, 393, 394, 395, 396, 397,
	398, 399, 400, 401, 402, 403, 0, 0, 0, 0,
	0, 167, 0, 0, 0, 357, 176, 177, 178, 179,
	180, 181, 182, 183, 184, 185, 186, 187, 172, 171,
	170, 188, 189, 190, 191, 192, 193, 194, 195, 196,
	197, 198, 199, 200, 201, 202, 0, 203, 204, 205,
	206, 207, 208, 209, 210, 211, 212, 213, 214, 215,
	216, 217, 0, 0, 0, 0, 0, 645, 0, 0,
	0, 174, 652, 653, 654, 655, 656, 657, 658, 646,
	659, 660, 661, 662, 0, 0, 0, 663, 664, 665,
	666, 667, 668, 669, 670, 671, 672, 673, 674, 675,
	676, 677, 648, 678, 679, 680, 681, 682, 683, 684,
	685, 686, 687, 688, 689, 690, 691, 692, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 650, 231, 230,
	44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
	84, 85, 86, 87, 88, 89, 35, 493, 0, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
	75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
	85, 86, 87, 88, 89, 303, 0, 0, 0, 0,
	307, 308, 309, 310, 311, 312, 313, 26, 314, 315,
	316, 317, 318, 319, 320, 321, 322, 323, 324, 325,
	326, 327, 328, 329, 330, 331, 332, 333, 334, 335,
	336, 337, 338, 339, 340, 341, 305, 342, 343, 344,
	345, 346, 347, 348, 349, 350, 429, 0, 0, 0,
	0, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
	83, 84, 85, 86, 87, 88, 89, 44, 45, 46,
	47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 80, 81, 82, 83, 84, 85, 86,
	87, 88, 89, 719, 720, 721, 722, 723, 724, 725,
	726, 727, 728, 729, 730, 731, 732, 733, 734, 735,
	736, 737, 738, 739, 740, 741, 742, 743, 744, 745,
	746, 747, 748, 749, 750, 751, 752, 753, 754, 755,
	756, 757, 758, 759, 760, 0, 761, 762, 763,
}

var protoPact = [...]int16{
	315, -1000, 272, 272, -1000, 289, 288, 257, 275, -1000,
	-1000, -1000, 383, 383, 257, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 347, 2160, 60, 2160, 303, 301,
	2160, 1457, 2160, -1000, 322, -1000, 321, -1000, 310, 383,
	383, 383, 184, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	287, -1000, 60, 187, -1000, -1000, -1000, 1457, 265, 2160,
	2160, 2160, 2160, 264, 263, -1000, 2160, -1000, 2160, 186,
	-1000, 262, -1000, -1000, -1000, -1000, 310, 310, 310, -1000,
	2160, 1271, -1000, -1000, -1000, 126, 272, 261, 260, 259,
	256, 272, 1849, -1000, -1000, -1000, -1000, 272, -1000, -1000,
	-1000, -1000, 272, -1000, -1000, 380, -1000, -1000, -1000, 1204,
	-1000, 349, -1000, -1000, 247, 1737, 272, 272, 272, 272,
	242, 2063, 237, 1849, -1000, -1000, -1000, 276, 1793, 2160,
	-1000, -1000, -1000, 185, 2160, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 224, 342,
	-1000, 221, -1000, -1000, 1332, 169, 163, 59, -1000, 2114,
	-1000, -1000, -1000, -1000, 272, 1737, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 1681, 2160,
	1625, 1569, 373, 2160, 2160, 2012, -1000, 180, 2160, 140,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 220, 219, 218, 217, 272, 2063, -1000,
	-1000, -1000, -1000, -1000, 286, 1396, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 272, -1000, -1000, 2160, 2160, 179, 2160, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 284, 2160, 175, 272, 342, -1000,
	-1000, -1000, -1000, 2160, -1000, -1000, -1000, -1000, -1000, -1000,
	947, 947, -1000, -1000, -1000, -1000, 1140, 111, 54, 75,
	-1000, -1000, 2160, 2160, 124, 2160, 2160, 2160, 142, 272,
	272, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 2160, 2160, 2160, 139, 272,
	272, 122, -1000, 312, 255, 119, 168, 167, 166, 380,
	-1000, 2160, 175, 368, 272, 272, 272, 272, -1000, -1000,
	193, 165, -1000, 309, -1000, 378, -1000, 281, 280, 2160,
	175, 377, -1000, -1000, -1000, 83, -1000, -1000, -1000, -1000,
	380, -1000, 1963, -1000, 879, -1000, 153, -1000, 109, -1000,
	68, -1000, -1000, 2160, -1000, 95, 116, 376, -1000, 272,
	1075, 175, 375, 272, -1000, 275, 175, 374, 272, -1000,
	275, 272, 272, 373, 344, 1905, 369, -1000, 272, 272,
	-1000, 383, -1000, 2160, -1000, 173, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 120, 193, 272, 183, -1000, 367, 366, -1000,
	72, 201, 1513, -1000, 82, -1000, 52, -1000, -1000, -1000,
	-1000, -1000, 149, -1000, 49, 363, 272, 254, 359, -1000,
	272, 120, -1000, -9, -1000, -1000, 60, 171, -1000, 279,
	120, -1000, 120, -1000, -1000, -1000, -1000, -1000, -1000, 216,
	1905, -1000, -1000, -1000, -1000, 274, 60, 2160, 2160, 178,
	2160, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 120, -1000, -1000, 380, -1000, 1457, -1000,
	272, -1000, -1000, -1000, -1000, 134, 72, -1000, 273, -1000,
	83, 1457, 118, -1000, 2160, -1000, 2206, 176, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 1014, -1000, -1000, -1000, 127,
	215, 272, 120, -1000, -1000, 272, -1000, -1000, -1000, -1000,
	1271, -1000, 272, -1000, 272, 272, -1000, -1000, 278, 86,
	90, 2160, 175, -1000, 272, 143, -1000, 272, 253, -1000,
	273, -1000, 211, 112, -1000, -1000, -1000, -1000, -1000, -1000,
	272, 250, 272, 206, -1000, 272, -1000, -1000, -1000, -1000,
	-1000, 1271, 358, -1000, 273, 357, 272, 212, -1000, -1000,
	-1000, 205, 272, -1000, -1000, 272, -1000, 204, 272, -1000,
	272, -1000, 273, 72, -1000, 91, 203, 272, -1000, 199,
	198, 355, 272, 197, -1000, -1000, -1000, 273, 272, 188,
	-1000, 196, -1000, 272, 355, -1000, -1000, -1000, -1000, 272,
	-1000, 195, 272, -1000, -1000, -1000, -1000, -1000, 194, -1000,
}

var protoPgo = [...]int16{
	0, 497, 495, 494, 406, 360, 493, 492, 491, 489,
	488, 7, 25, 21, 487, 486, 485, 484, 483, 65,
	57, 19, 482, 36, 35, 10, 481, 11, 15, 5,
	8, 480, 479, 13, 478, 477, 28, 33, 476, 474,
	473, 468, 465, 464, 462, 55, 42, 41, 58, 53,
	18, 16, 27, 461, 459, 458, 453, 452, 14, 451,
	450, 24, 449, 448, 446, 48, 445, 444, 443, 442,
	47, 29, 438, 437, 436, 434, 432, 431, 430, 429,
	428, 427, 54, 63, 426, 6, 12, 425, 424, 423,
	422, 421, 420, 37, 30, 26, 40, 419, 418, 45,
	38, 417, 56, 415, 44, 52, 414, 413, 9, 412,
	32, 411, 407, 405, 2, 404, 373, 20, 17, 0,
	31,
}

var protoR1 = [...]int8{
	0, 1, 1, 1, 1, 1, 1, 4, 6, 6,
	5, 5, 5, 5, 5, 5, 5, 5, 120, 120,
	119, 119, 118, 118, 2, 3, 7, 7, 7, 7,
	8, 52, 52, 58, 58, 59, 59, 49, 49, 48,
	53, 53, 54, 54, 55, 55, 56, 56, 57, 57,
	60, 60, 51, 51, 50, 10, 11, 18, 18, 19,
	20, 20, 22, 22, 21, 21, 16, 25, 25, 26,
	26, 26, 26, 30, 30, 30, 30, 31, 31, 108,
	108, 28, 28, 71, 70, 70, 69, 69, 69, 69,
	69, 69, 72, 72, 72, 17, 17, 17, 17, 24,
	24, 24, 27, 27, 27, 27, 35, 35, 29, 29,
	29, 32, 32, 32, 67, 67, 33, 33, 34, 34,
	34, 68, 68, 61, 61, 62, 62, 62, 62, 63,
	63, 64, 64, 65, 65, 66, 66, 45, 45, 45,
	23, 23, 14, 14, 15, 15, 13, 13, 12, 9,
	9, 77, 77, 79, 79, 79, 79, 76, 88, 88,
	87, 87, 86, 86, 86, 86, 86, 74, 74, 74,
	74, 78, 78, 78, 78, 80, 80, 80, 80, 81,
	38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 98, 98, 96, 96, 94, 94, 94, 97,
	97, 95, 95, 95, 36, 36, 91, 91, 92, 92,
	93, 93, 89, 89, 90, 90, 99, 99, 99, 102,
	102, 101, 101, 100, 100, 100, 100, 103, 103, 82,
	82, 82, 85, 85, 84, 84, 83, 83, 83, 83,
	83, 83, 83, 83, 83, 83, 83, 73, 73, 73,
	73, 73, 73, 73, 73, 73, 73, 73, 73, 73,
	73, 73, 73, 73, 73, 104, 107, 107, 106, 106,
	105, 105, 105, 105, 75, 75, 75, 75, 109, 112,
	112, 111, 111, 110, 110, 110, 113, 113, 117, 117,
	116, 116, 115, 115, 114, 114, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39, 39, 40,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	40, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 46, 46, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 47, 47, 47, 47, 47, 47, 47, 47,
	47, 47, 37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37,
}

var protoR2 = [...]int8{
	0, 1, 1, 1, 2, 2, 0, 2, 2, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
	1, 0, 1, 0, 4, 4, 3, 4, 4, 4,
	3, 1, 3, 1, 2, 1, 2, 1, 1, 2,
	1, 3, 1, 3, 1, 3, 1, 3, 1, 2,
	1, 2, 1, 1, 2, 5, 5, 1, 1, 2,
	1, 1, 1, 2, 1, 2, 3, 1, 1, 1,
	1, 1, 1, 1, 2, 1, 2, 2, 2, 1,
	2, 3, 2, 1, 1, 2, 1, 2, 2, 2,
	2, 1, 3, 2, 3, 1, 3, 5, 3, 1,
	1, 1, 1, 1, 2, 1, 1, 1, 1, 3,
	2, 3, 2, 3, 1, 3, 1, 1, 3, 2,
	3, 1, 3, 1, 2, 1, 3, 3, 2, 1,
	2, 1, 2, 1, 2, 1, 2, 1, 1, 1,
	3, 2, 1, 2, 1, 2, 1, 1, 2, 3,
	1, 8, 9, 9, 10, 7, 8, 6, 0, 1,
	2, 1, 1, 1, 1, 2, 1, 5, 6, 3,
	4, 7, 8, 5, 6, 5, 6, 3, 4, 6,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 4, 4, 1, 3, 1, 3, 3, 1,
	3, 1, 3, 3, 1, 2, 4, 1, 4, 1,
	3, 3, 1, 3, 1, 3, 6, 7, 7, 1,
	2, 2, 1, 1, 1, 1, 1, 4, 5, 6,
	7, 7, 1, 2, 2, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 6, 7, 5,
	6, 4, 5, 3, 4, 5, 6, 4, 5, 6,
	4, 3, 3, 3, 3, 6, 0, 1, 2, 1,
	1, 1, 2, 1, 6, 7, 5, 6, 6, 1,
	2, 2, 1, 1, 1, 1, 6, 9, 4, 3,
	1, 2, 2, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
}

var protoChk = [...]int16{
	-1000, -1, -2, -3, -4, 8, 9, -119, -120, 55,
	-4, -4, 54, 54, -6, -5, -7, -8, -11, -82,
	-99, -104, -109, 2, 10, 13, 14, 45, 51, 52,
	44, 46, 47, 55, -108, 4, -108, -5, -108, 11,
	12, 14, -52, -37, 7, 8, 9, 10, 11, 12,
	13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
	23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
	33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	-21, -20, -22, -18, -19, -37, -16, 68, -37, 44,
	45, 44, 45, -37, -61, -58, 62, -49, -59, -37,
	-48, -37, 55, 4, 55, -119, -108, -108, -108, -119,
	62, 54, -19, -20, 62, -61, 57, -37, -37, -37,
	-37, 57, 57, -58, -49, -48, 62, 57, -119, -119,
	-119, -37, -25, -26, -28, -108, -30, -31, -37, 57,
	6, 67, 5, 69, -85, -119, 57, 57, 57, 57,
	-102, -119, -107, -106, -105, -75, -77, 2, -45, -63,
	21, 20, 19, -54, 62, -40, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 16, 17, 18, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
	34, 35, 36, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, -112, -119,
	-119, -71, 58, -70, -69, -72, 2, -17, -37, 70,
	6, 5, 17, 18, 58, -84, -83, -73, -99, -82,
	-104, -98, -79, -11, -76, -80, -91, 2, -45, -62,
	51, 52, 40, 38, -81, 43, -93, -53, 62, 39,
	-39, 7, 8, 9, 10, 11, 12, 13, 15, 16,
	17, 18, 22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35, 36, 41, 42, 47,
	48, 49, 50, -102, -85, -102, -85, 58, -101, -100,
	-11, -103, -92, 2, -44, 43, -93, 7, 8, 9,
	10, 11, 12, 13, 15, 16, 17, 18, 19, 20,
	21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
	31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 58, -105, 55, 37, -65, -56, 62, -42, 7,
	8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
	18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 36, 38,
	39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, -37, 62, -52, 58, -111, -110,
	-11, -113, 2, 48, 58, -70, 63, 55, 63, 55,
	56, 56, -35, -29, -34, -28, 65, 70, -58, 2,
	-119, -83, 37, -65, -37, 62, 44, 45, -37, -47,
	-46, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
	36, 37, 38, 39, 40, 41, 42, 43, 46, 47,
	48, 49, 50, 51, 52, 62, 44, 45, -37, -47,
	-46, -96, -94, 5, -37, -37, -96, -89, -90, -108,
	-37, 62, -52, 65, 58, 58, 58, 58, -119, -100,
	54, -97, -95, -36, 5, 67, -119, -37, -37, 62,
	-52, 54, -37, -119, -110, -37, -24, -27, -29, -32,
	-108, -30, 67, -37, 70, -24, -71, 64, -68, 71,
	2, -29, 71, 60, 71, -37, -37, 54, -119, -23,
	70, -52, 54, -23, -119, -120, -52, 54, -23, -119,
	-120, 55, -23, 63, 41, 57, 54, -119, -23, 55,
	-119, 63, -119, 63, -37, -38, 24, 25, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, -119, -119,
	-119, -119, -36, 63, 55, 41, 5, 54, 54, -37,
	5, -117, 68, -37, -67, 71, 2, -33, -27, -29,
	64, 71, 63, 71, -58, 54, 57, -23, 54, -119,
	-23, 5, -119, -14, 71, -13, -15, -9, -12, -21,
	5, -119, 5, -119, -119, -119, -94, 5, 42, -88,
	-87, -86, -10, -74, -78, 2, 14, -64, 37, -55,
	62, -41, 7, 8, 9, 10, 11, 12, 13, 15,
	16, 17, 18, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 31, 32, 33, 34, 35, 36, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 5, -119, -119, -108, -37, 63, -119,
	-23, -95, -119, -36, 42, 5, 5, -118, -23, 55,
	50, 49, -66, -57, 62, -51, -60, -43, -50, 7,
	8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
	18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 50, 51, 52, 71, 63, 71, -29, 71, 5,
	-85, 57, 5, -119, -119, -23, 71, -13, -12, 63,
	54, -119, -23, -119, -23, 58, -86, 55, -21, -37,
	-37, 62, -52, -119, -23, -61, -119, 57, -23, -118,
	-23, -118, -117, -61, 69, -58, -51, -50, 62, -33,
	57, -23, 58, -85, -119, -23, -119, -25, -119, -119,
	-119, 54, 54, -118, -23, 54, 57, -23, -37, -119,
	64, -85, 57, -118, -119, 57, 69, -85, 57, -119,
	58, -119, -25, 5, -118, 5, -85, 57, 58, -85,
	-116, -119, 58, -85, -119, -118, -118, -23, 57, -23,
	58, -85, 58, 58, -115, -114, -11, 2, -119, 58,
	-118, -85, 57, 58, -119, -114, -119, 58, -85, 58,
}

var protoDef = [...]int16{
	-2, -2, -2, -2, 3, 0, 0, 0, 20, 18,
	4, 5, 0, 0, -2, 9, 10, 11, 12, 13,
	14, 15, 16, 17, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 19, 0, 79, 0, 8, 21, 0,
	0, 0, 21, 31, 592, 593, 594, 595, 596, 597,
	598, 599, 600, 601, 602, 603, 604, 605, 606, 607,
	608, 609, 610, 611, 612, 613, 614, 615, 616, 617,
	618, 619, 620, 621, 622, 623, 624, 625, 626, 627,
	628, 629, 630, 631, 632, 633, 634, 635, 636, 637,
	0, 64, 0, 60, -2, 57, 58, 0, 0, 0,
	0, 0, 0, 0, 0, 123, 0, 33, 0, 37,
	-2, 0, 24, 80, 25, 26, 21, 21, 21, 30,
	0, 0, -2, 65, 59, 0, 21, 0, 0, 0,
	0, 21, -2, 124, 34, -2, 39, 21, 27, 28,
	29, 32, 21, 67, 68, 69, 70, 71, 72, 0,
	73, 0, 75, 66, 0, -2, 21, 21, 21, 21,
	0, -2, 0, -2, 269, 270, 271, 273, 0, 0,
	137, 138, 139, 129, 0, 42, 329, 330, 331, 332,
	333, 334, 335, 336, 337, 338, 339, 340, 341, 342,
	343, 344, 345, 346, 347, 348, 349, 350, 351, 352,
	353, 354, 355, 356, 357, 358, 359, 360, 361, 362,
	363, 364, 365, 366, 367, 368, 369, 370, 0, -2,
	56, 0, 82, 83, -2, 86, 91, 0, 95, 0,
	74, 76, 77, 78, 21, -2, 235, 236, 237, 238,
	239, 240, 241, 242, 243, 244, 245, 246, 0, 0,
	0, 0, 0, 0, 0, 0, 207, 125, 0, 322,
	40, 296, 297, 298, 299, 300, 301, 302, 303, 304,
	305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
	315, 316, 317, 318, 319, 320, 321, 323, 324, 325,
	326, 327, 328, 0, 0, 0, 0, 21, -2, 222,
	223, 224, 225, 226, 0, 0, 209, 371, 372, 373,
	374, 375, 376, 377, 378, 379, 380, 381, 382, 383,
	384, 385, 386, 387, 388, 389, 390, 391, 392, 393,
	394, 395, 396, 397, 398, 399, 400, 401, 402, 403,
	404, 405, 406, 407, 408, 409, 410, 411, 412, 413,
	414, 21, 268, 272, 0, 0, 133, 0, 46, 456,
	457, 458, 459, 460, 461, 462, 463, 464, 465, 466,
	467, 468, 469, 470, 471, 472, 473, 474, 475, 476,
	477, 478, 479, 480, 481, 482, 483, 484, 485, 486,
	487, 488, 489, 490, 491, 492, 493, 494, 495, 496,
	497, 498, 499, 500, 0, 0, 130, 21, -2, 282,
	283, 284, 285, 0, 81, 85, 87, 88, 89, 90,
	0, 0, 93, 106, 107, 108, 0, 0, 0, 0,
	229, 234, 0, 0, 21, 0, -2, -2, 0, 21,
	0, -2, -2, -2, -2, -2, -2, -2, -2, -2,
	-2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
	-2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
	-2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
	-2, -2, -2, -2, -2, 0, -2, -2, 0, 21,
	0, 0, 194, 196, 0, 21, 0, 21, 21, 212,
	214, 0, 128, 0, 21, 21, 21, 21, 216, 221,
	0, 0, 199, 201, 204, 0, 265, 0, 0, 0,
	134, 0, 43, 278, 281, 0, 94, 99, 100, 101,
	102, 103, 0, 105, 0, 92, 0, 110, 0, 119,
	0, 121, 96, 0, 98, 0, 21, 0, 253, 21,
	0, 126, 0, 21, 261, 262, 127, 0, 21, 263,
	264, 21, 21, 0, 0, -2, 0, 177, 21, 21,
	210, 0, 211, 0, 41, 0, 180, 181, 182, 183,
	184, 185, 186, 187, 188, 189, 190, 191, 217, 230,
	218, 231, 21, 0, 21, 0, 205, 0, 0, 47,
	23, 0, 0, 104, 0, 112, 0, 114, 116, 117,
	109, 118, 0, 120, 0, 0, 21, 0, 0, 251,
	21, 21, 254, 0, 141, 142, 0, 146, -2, 150,
	21, 257, 21, 260, 192, 193, 195, 197, 198, 0,
	-2, 161, 162, 163, 164, 166, 0, 0, 0, 131,
	0, 44, 415, 416, 417, 418, 419, 420, 421, 422,
	423, 424, 425, 426, 427, 428, 429, 430, 431, 432,
	433, 434, 435, 436, 437, 438, 439, 440, 441, 442,
	443, 444, 445, 446, 447, 448, 449, 450, 451, 452,
	453, 454, 455, 21, 178, 206, 213, 215, 0, 227,
	21, 200, 208, 202, 203, 0, 23, 276, 23, 22,
	0, 0, 0, 135, 0, 48, 0, 52, -2, 501,
	502, 503, 504, 505, 506, 507, 508, 509, 510, 511,
	512, 513, 514, 515, 516, 517, 518, 519, 520, 521,
	522, 523, 524, 525, 526, 527, 528, 529, 530, 531,
	532, 533, 534, 535, 536, 537, 538, 539, 540, 541,
	542, 543, 544, 545, 111, 0, 113, 122, 97, 0,
	0, 21, 21, 252, 249, 21, 140, 143, -2, 148,
	0, 255, 21, 258, 21, 21, 160, 165, 0, 23,
	0, 0, 132, 175, 21, 0, 228, 21, 0, 274,
	23, 277, 21, 0, 289, 136, 49, -2, 54, 115,
	21, 0, 21, 0, 247, 21, 250, 149, 256, 259,
	157, 0, 0, 169, 23, 0, 21, 0, 45, 176,
	179, 0, 21, 275, 286, 21, 288, 0, 21, 155,
	21, 248, 23, 23, 170, 0, 0, 21, 151, 0,
	0, -2, 21, 0, 156, 55, 167, 23, 21, 0,
	173, 0, 152, 21, -2, 293, 294, 295, 153, 21,
	168, 0, 21, 174, 287, 292, 154, 171, 0, 172,
}

var protoTok1 = [...]int8{
	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 79, 3, 77, 76, 75, 73, 3,
	68, 69, 72, 66, 63, 67, 62, 60, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 56, 55,
	65, 54, 64, 61, 78, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 70, 59, 71, 74, 3, 81, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 57, 3, 58, 80,
}

var protoTok2 = [...]int8{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53,
}

var protoTok3 = [...]int8{
	0,
}

var protoErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

/*	parser for yacc output	*/

var (
	protoDebug        = 0
	protoErrorVerbose = false
)

type protoLexer interface {
	Lex(lval *protoSymType) int
	Error(s string)
}

type protoParser interface {
	Parse(protoLexer) int
	Lookahead() int
}

type protoParserImpl struct {
	lval  protoSymType
	stack [protoInitialStackSize]protoSymType
	char  int
}

func (p *protoParserImpl) Lookahead() int {
	return p.char
}

func protoNewParser() protoParser {
	return &protoParserImpl{}
}

const protoFlag = -1000

func protoTokname(c int) string {
	if c >= 1 && c-1 < len(protoToknames) {
		if protoToknames[c-1] != "" {
			return protoToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func protoStatname(s int) string {
	if s >= 0 && s < len(protoStatenames) {
		if protoStatenames[s] != "" {
			return protoStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func protoErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !protoErrorVerbose {
		return "syntax error"
	}

	for _, e := range protoErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + protoTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := int(protoPact[state])
	for tok := TOKSTART; tok-1 < len(protoToknames); tok++ {
		if n := base + tok; n >= 0 && n < protoLast && int(protoChk[int(protoAct[n])]) == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if protoDef[state] == -2 {
		i := 0
		for protoExca[i] != -1 || int(protoExca[i+1]) != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; protoExca[i] >= 0; i += 2 {
			tok := int(protoExca[i])
			if tok < TOKSTART || protoExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if protoExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += protoTokname(tok)
	}
	return res
}

func protolex1(lex protoLexer, lval *protoSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = int(protoTok1[0])
		goto out
	}
	if char < len(protoTok1) {
		token = int(protoTok1[char])
		goto out
	}
	if char >= protoPrivate {
		if char < protoPrivate+len(protoTok2) {
			token = int(protoTok2[char-protoPrivate])
			goto out
		}
	}
	for i := 0; i < len(protoTok3); i += 2 {
		token = int(protoTok3[i+0])
		if token == char {
			token = int(protoTok3[i+1])
			goto out
		}
	}

out:
	if token == 0 {
		token = int(protoTok2[1]) /* unknown char */
	}
	if protoDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", protoTokname(token), uint(char))
	}
	return char, token
}

func protoParse(protolex protoLexer) int {
	return protoNewParser().Parse(protolex)
}

func (protorcvr *protoParserImpl) Parse(protolex protoLexer) int {
	var proton int
	var protoVAL protoSymType
	var protoDollar []protoSymType
	_ = protoDollar // silence set and not used
	protoS := protorcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	protostate := 0
	protorcvr.char = -1
	prototoken := -1 // protorcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		protostate = -1
		protorcvr.char = -1
		prototoken = -1
	}()
	protop := -1
	goto protostack

ret0:
	return 0

ret1:
	return 1

protostack:
	/* put a state and value onto the stack */
	if protoDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", protoTokname(prototoken), protoStatname(protostate))
	}

	protop++
	if protop >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoS[protop] = protoVAL
	protoS[protop].yys = protostate

protonewstate:
	proton = int(protoPact[protostate])
	if proton <= protoFlag {
		goto protodefault /* simple state */
	}
	if protorcvr.char < 0 {
		protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
	}
	proton += prototoken
	if proton < 0 || proton >= protoLast {
		goto protodefault
	}
	proton = int(protoAct[proton])
	if int(protoChk[proton]) == prototoken { /* valid shift */
		protorcvr.char = -1
		prototoken = -1
		protoVAL = protorcvr.lval
		protostate = proton
		if Errflag > 0 {
			Errflag--
		}
		goto protostack
	}

protodefault:
	/* default state action */
	proton = int(protoDef[protostate])
	if proton == -2 {
		if protorcvr.char < 0 {
			protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if protoExca[xi+0] == -1 && int(protoExca[xi+1]) == protostate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			proton = int(protoExca[xi+0])
			if proton < 0 || proton == prototoken {
				break
			}
		}
		proton = int(protoExca[xi+1])
		if proton < 0 {
			goto ret0
		}
	}
	if proton == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			protolex.Error(protoErrorMessage(protostate, prototoken))
			Nerrs++
			if protoDebug >= 1 {
				__yyfmt__.Printf("%s", protoStatname(protostate))
				__yyfmt__.Printf(" saw %s\n", protoTokname(prototoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for protop >= 0 {
				proton = int(protoPact[protoS[protop].yys]) + protoErrCode
				if proton >= 0 && proton < protoLast {
					protostate = int(protoAct[proton]) /* simulate a shift of "error" */
					if int(protoChk[protostate]) == protoErrCode {
						goto protostack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if protoDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", protoS[protop].yys)
				}
				protop--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if protoDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", protoTokname(prototoken))
			}
			if prototoken == protoEofCode {
				goto ret1
			}
			protorcvr.char = -1
			prototoken = -1
			goto protonewstate /* try again in the same state */
		}
	}

	/* reduction by production proton */
	if protoDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", proton, protoStatname(protostate))
	}

	protont := proton
	protopt := protop
	_ = protopt // guard against "declared and not used"

	protop -= int(protoR2[proton])
	// protop is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if protop+1 >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoVAL = protoS[protop+1]

	/* consult goto table to find next state */
	proton = int(protoR1[proton])
	protog := int(protoPgo[proton])
	protoj := protog + protoS[protop].yys + 1

	if protoj >= protoLast {
		protostate = int(protoAct[protog])
	} else {
		protostate = int(protoAct[protoj])
		if int(protoChk[protostate]) != -proton {
			protostate = int(protoAct[protog])
		}
	}
	// dummy call; replaced with literal code
	switch protont {

	case 1:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 2:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNodeWithEdition(lex.info, protoDollar[1].ed, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 3:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, protoDollar[1].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 4:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, protoDollar[2].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 5:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNodeWithEdition(lex.info, protoDollar[1].ed, protoDollar[2].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 6:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 7:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.fileElements = prependRunes(toFileElement, protoDollar[1].bs, protoDollar[2].fileElements)
		}
	case 8:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.fileElements = append(protoDollar[1].fileElements, protoDollar[2].fileElements...)
		}
	case 9:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = protoDollar[1].fileElements
		}
	case 10:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].imprt.Node, protoDollar[1].imprt.Runes)
		}
	case 11:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].pkg.Node, protoDollar[1].pkg.Runes)
		}
	case 12:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 13:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].msg.Node, protoDollar[1].msg.Runes)
		}
	case 14:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].en.Node, protoDollar[1].en.Runes)
		}
	case 15:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].extend.Node, protoDollar[1].extend.Runes)
		}
	case 16:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].svc.Node, protoDollar[1].svc.Runes)
		}
	case 17:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = nil
		}
	case 18:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.bs = []*ast.RuneNode{protoDollar[1].b}
		}
	case 19:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.bs = append(protoDollar[1].bs, protoDollar[2].b)
		}
	case 20:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.bs = protoDollar[1].bs
		}
	case 21:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.bs = nil
		}
	case 22:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.b = protoDollar[1].b
		}
	case 23:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: expecting ';'")
			protoVAL.b = nil
		}
	case 24:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.syn = ast.NewSyntaxNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 25:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.ed = ast.NewEditionNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 26:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.imprt = newNodeWithRunes(ast.NewImportNodeWithModifier(protoDollar[1].id.ToKeyword(), nil, toStringValueNode(protoDollar[2].str), semi), extra...)
		}
	case 27:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.imprt = newNodeWithRunes(ast.NewImportNodeWithModifier(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), toStringValueNode(protoDollar[3].str), semi), extra...)
		}
	case 28:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.imprt = newNodeWithRunes(ast.NewImportNodeWithModifier(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), toStringValueNode(protoDollar[3].str), semi), extra...)
		}
	case 29:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.imprt = newNodeWithRunes(ast.NewImportNodeWithModifier(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), toStringValueNode(protoDollar[3].str), semi), extra...)
		}
	case 30:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.pkg = newNodeWithRunes(ast.NewPackageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].cid.toIdentValueNode(nil), semi), extra...)
		}
	case 31:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 32:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 33:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 34:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 35:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 36:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 37:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id)
		}
	case 38:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected '.'")
			protoVAL.cidPart = protoDollar[1].cidPart
		}
	case 39:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id, protoDollar[2].b)
		}
	case 40:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 41:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 42:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 43:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 44:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 45:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 46:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 47:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 48:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 49:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 50:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 51:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 52:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id)
		}
	case 53:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected '.'")
			protoVAL.cidPart = protoDollar[1].cidPart
		}
	case 54:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id, protoDollar[2].b)
		}
	case 55:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[2].optNms.refs, protoDollar[2].optNms.dots)
			protoVAL.optRaw = ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, protoDollar[5].b)
		}
	case 56:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[2].optNms.refs, protoDollar[2].optNms.dots)
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.opt = newNodeWithRunes(ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, semi), extra...)
		}
	case 57:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.refRaw = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 58:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.refRaw = protoDollar[1].refRaw
		}
	case 59:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.ref = newNodeWithRunes(protoDollar[1].refRaw, protoDollar[2].b)
		}
	case 60:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ref = newNodeWithRunes(protoDollar[1].refRaw)
		}
	case 61:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected '.'")
			protoVAL.ref = protoDollar[1].ref
		}
	case 62:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{protoDollar[1].ref.Node}, dots: protoDollar[1].ref.Runes}
		}
	case 63:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, protoDollar[2].ref.Node)
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].ref.Runes...)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 64:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{protoDollar[1].ref.Node}, dots: protoDollar[1].ref.Runes}
		}
	case 65:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, protoDollar[2].ref.Node)
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].ref.Runes...)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 66:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.refRaw = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].tid, protoDollar[3].b)
		}
	case 69:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = toStringValueNode(protoDollar[1].str)
		}
	case 72:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].id
		}
	case 73:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].f
		}
	case 74:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 75:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].i
		}
	case 76:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].i.Val > math.MaxInt64+1 {
				// can't represent as int so treat as float literal
				protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].i)
			} else {
				protoVAL.v = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
			}
		}
	case 77:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 78:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 79:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.str = []*ast.StringLiteralNode{protoDollar[1].s}
		}
	case 80:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.str = append(protoDollar[1].str, protoDollar[2].s)
		}
	case 81:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 82:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 85:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFlds != nil {
				protoDollar[1].msgLitFlds.next = protoDollar[2].msgLitFlds
				protoVAL.msgLitFlds = protoDollar[1].msgLitFlds
			} else {
				protoVAL.msgLitFlds = protoDollar[2].msgLitFlds
			}
		}
	case 86:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 87:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 88:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 89:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 90:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 91:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 92:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].refRaw != nil && protoDollar[2].b != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].refRaw, protoDollar[2].b, protoDollar[3].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 93:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].refRaw != nil && protoDollar[2].v != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].refRaw, nil, protoDollar[2].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 94:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.msgLitFld = nil
		}
	case 95:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.refRaw = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 96:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.refRaw = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b)
		}
	case 97:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.refRaw = ast.NewAnyTypeReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b, protoDollar[4].cid.toIdentValueNode(nil), protoDollar[5].b)
		}
	case 98:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.refRaw = nil
		}
	case 102:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = toStringValueNode(protoDollar[1].str)
		}
	case 104:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			kw := protoDollar[2].id.ToKeyword()
			switch strings.ToLower(kw.Val) {
			case "inf", "infinity", "nan":
				// these are acceptable
			default:
				// anything else is not
				protolex.(*protoLex).Error(`only identifiers "inf", "infinity", or "nan" may appear after negative sign`)
			}
			// we'll validate the identifier later
			f := ast.NewSpecialFloatLiteralNode(kw)
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 105:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].id
		}
	case 109:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 110:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 111:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 112:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 113:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
		}
	case 114:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 115:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 118:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 119:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 120:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
		}
	case 121:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 122:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 123:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 124:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 125:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 126:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[3].cid.prefix(protoDollar[1].id, protoDollar[2].b)
			protoVAL.tid = protoDollar[3].cid.toIdentValueNode(nil)
		}
	case 127:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[3].cid.prefix(protoDollar[1].id, protoDollar[2].b)
			protoVAL.tid = protoDollar[3].cid.toIdentValueNode(nil)
		}
	case 128:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 129:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 130:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 131:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 132:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 133:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 134:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 135:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 136:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 140:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, protoDollar[2].opts.options, protoDollar[2].opts.commas, protoDollar[3].b)
		}
	case 141:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protolex.(*protoLex).Error("compact options must have at least one option")
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 142:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opts = &compactOptionSlices{options: []*ast.OptionNode{protoDollar[1].opt.Node}, commas: protoDollar[1].opt.Runes}
		}
	case 143:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].opts.options = append(protoDollar[1].opts.options, protoDollar[2].opt.Node)
			protoDollar[1].opts.commas = append(protoDollar[1].opts.commas, protoDollar[2].opt.Runes...)
			protoVAL.opts = protoDollar[1].opts
		}
	case 144:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opts = &compactOptionSlices{options: []*ast.OptionNode{protoDollar[1].opt.Node}, commas: protoDollar[1].opt.Runes}
		}
	case 145:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].opts.options = append(protoDollar[1].opts.options, protoDollar[2].opt.Node)
			protoDollar[1].opts.commas = append(protoDollar[1].opts.commas, protoDollar[2].opt.Runes...)
			protoVAL.opts = protoDollar[1].opts
		}
	case 146:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opt = newNodeWithRunes(protoDollar[1].optRaw)
		}
	case 147:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected ','")
			protoVAL.opt = protoDollar[1].opt
		}
	case 148:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.opt = newNodeWithRunes(protoDollar[1].optRaw, protoDollar[2].b)
		}
	case 149:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[1].optNms.refs, protoDollar[1].optNms.dots)
			protoVAL.optRaw = ast.NewCompactOptionNode(optName, protoDollar[2].b, protoDollar[3].v)
		}
	case 150:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[1].optNms.refs, protoDollar[1].optNms.dots)
			protolex.(*protoLex).Error("compact option must have a value")
			protoVAL.optRaw = ast.NewCompactOptionNode(optName, nil, nil)
		}
	case 151:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 152:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgElements, protoDollar[9].b)
		}
	case 153:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithRunes(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b), protoDollar[9].bs...)
		}
	case 154:
		protoDollar = protoS[protopt-10 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithRunes(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgElements, protoDollar[9].b), protoDollar[10].bs...)
		}
	case 155:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithRunes(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, nil, nil, nil, protoDollar[4].b, protoDollar[5].msgElements, protoDollar[6].b), protoDollar[7].bs...)
		}
	case 156:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithRunes(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, nil, nil, protoDollar[4].cmpctOpts, protoDollar[5].b, protoDollar[6].msgElements, protoDollar[7].b), protoDollar[8].bs...)
		}
	case 157:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.oo = newNodeWithRunes(ast.NewOneofNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].ooElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 158:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.ooElements = nil
		}
	case 160:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].ooElement != nil {
				protoVAL.ooElements = append(protoDollar[1].ooElements, protoDollar[2].ooElement)
			} else {
				protoVAL.ooElements = protoDollar[1].ooElements
			}
		}
	case 161:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].ooElement != nil {
				protoVAL.ooElements = []ast.OneofElement{protoDollar[1].ooElement}
			} else {
				protoVAL.ooElements = nil
			}
		}
	case 162:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].optRaw
		}
	case 163:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].fld
		}
	case 164:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].grp
		}
	case 165:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 166:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 167:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 168:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 169:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, nil, nil, nil, protoDollar[3].b)
		}
	case 170:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, nil, nil, protoDollar[3].cmpctOpts, protoDollar[4].b)
		}
	case 171:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b, protoDollar[6].msgElements, protoDollar[7].b)
		}
	case 172:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 173:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, nil, nil, nil, protoDollar[3].b, protoDollar[4].msgElements, protoDollar[5].b)
		}
	case 174:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, nil, nil, protoDollar[3].cmpctOpts, protoDollar[4].b, protoDollar[5].msgElements, protoDollar[6].b)
		}
	case 175:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.mapFld = newNodeWithRunes(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semi), extra...)
		}
	case 176:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.mapFld = newNodeWithRunes(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semi), extra...)
		}
	case 177:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.mapFld = newNodeWithRunes(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, nil, nil, nil, semi), extra...)
		}
	case 178:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.mapFld = newNodeWithRunes(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, nil, nil, protoDollar[3].cmpctOpts, semi), extra...)
		}
	case 179:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mapType = ast.NewMapTypeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, protoDollar[3].id, protoDollar[4].b, protoDollar[5].tid, protoDollar[6].b)
		}
	case 192:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `extensions 1 to 10` and `extensions 1` followed by `to = 10`.
			protoVAL.ext = newNodeWithRunes(ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, nil, protoDollar[3].b), protoDollar[4].bs...)
		}
	case 193:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.ext = newNodeWithRunes(ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].cmpctOpts, semi), extra...)
		}
	case 194:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 195:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 196:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, nil, nil, nil)
		}
	case 197:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), protoDollar[3].i, nil)
		}
	case 198:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 199:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 200:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 201:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, nil, nil, nil)
		}
	case 202:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), protoDollar[3].il, nil)
		}
	case 203:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 204:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.il = protoDollar[1].i
		}
	case 205:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.il = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 206:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `reserved 1 to 10` and `reserved 1` followed by `to = 10`.
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b), protoDollar[4].bs...)
		}
	case 208:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `reserved 1 to 10` and `reserved 1` followed by `to = 10`.
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b), protoDollar[4].bs...)
		}
	case 210:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedNamesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].names.names, protoDollar[2].names.commas, semi), extra...)
		}
	case 211:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedIdentifiersNode(protoDollar[1].id.ToKeyword(), protoDollar[2].names.idents, protoDollar[2].names.commas, semi), extra...)
		}
	case 212:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameSlices{names: []ast.StringValueNode{toStringValueNode(protoDollar[1].str)}}
		}
	case 213:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].names.names = append(protoDollar[1].names.names, toStringValueNode(protoDollar[3].str))
			protoDollar[1].names.commas = append(protoDollar[1].names.commas, protoDollar[2].b)
			protoVAL.names = protoDollar[1].names
		}
	case 214:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 215:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].names.idents = append(protoDollar[1].names.idents, protoDollar[3].id)
			protoDollar[1].names.commas = append(protoDollar[1].names.commas, protoDollar[2].b)
			protoVAL.names = protoDollar[1].names
		}
	case 216:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.en = newNodeWithRunes(ast.NewEnumNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].enElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 217:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.en = newNodeWithRunes(ast.NewEnumNodeWithVisibility(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].enElements, protoDollar[6].b), protoDollar[7].bs...)
		}
	case 218:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.en = newNodeWithRunes(ast.NewEnumNodeWithVisibility(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].enElements, protoDollar[6].b), protoDollar[7].bs...)
		}
	case 219:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = prependRunes(toEnumElement, protoDollar[1].bs, nil)
		}
	case 220:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.enElements = prependRunes(toEnumElement, protoDollar[1].bs, protoDollar[2].enElements)
		}
	case 221:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.enElements = append(protoDollar[1].enElements, protoDollar[2].enElements...)
		}
	case 222:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = protoDollar[1].enElements
		}
	case 223:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toElements[ast.EnumElement](toEnumElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 224:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toElements[ast.EnumElement](toEnumElement, protoDollar[1].env.Node, protoDollar[1].env.Runes)
		}
	case 225:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toElements[ast.EnumElement](toEnumElement, protoDollar[1].resvd.Node, protoDollar[1].resvd.Runes)
		}
	case 226:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = nil
		}
	case 227:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.env = newNodeWithRunes(ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, nil, semi), extra...)
		}
	case 228:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.env = newNodeWithRunes(ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, protoDollar[4].cmpctOpts, semi), extra...)
		}
	case 229:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.msg = newNodeWithRunes(ast.NewMessageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].msgElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 230:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.msg = newNodeWithRunes(ast.NewMessageNodeWithVisibility(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].msgElements, protoDollar[6].b), protoDollar[7].bs...)
		}
	case 231:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.msg = newNodeWithRunes(ast.NewMessageNodeWithVisibility(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].msgElements, protoDollar[6].b), protoDollar[7].bs...)
		}
	case 232:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = prependRunes(toMessageElement, protoDollar[1].bs, nil)
		}
	case 233:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgElements = prependRunes(toMessageElement, protoDollar[1].bs, protoDollar[2].msgElements)
		}
	case 234:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgElements = append(protoDollar[1].msgElements, protoDollar[2].msgElements...)
		}
	case 235:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = protoDollar[1].msgElements
		}
	case 236:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].msgFld.Node, protoDollar[1].msgFld.Runes)
		}
	case 237:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].en.Node, protoDollar[1].en.Runes)
		}
	case 238:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].msg.Node, protoDollar[1].msg.Runes)
		}
	case 239:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].extend.Node, protoDollar[1].extend.Runes)
		}
	case 240:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].ext.Node, protoDollar[1].ext.Runes)
		}
	case 241:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].msgGrp.Node, protoDollar[1].msgGrp.Runes)
		}
	case 242:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 243:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].oo.Node, protoDollar[1].oo.Runes)
		}
	case 244:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].mapFld.Node, protoDollar[1].mapFld.Runes)
		}
	case 245:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].resvd.Node, protoDollar[1].resvd.Runes)
		}
	case 246:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = nil
		}
	case 247:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, semis), extra...)
		}
	case 248:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[7].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, semis), extra...)
		}
	case 249:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semis), extra...)
		}
	case 250:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semis), extra...)
		}
	case 251:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, nil, nil, nil, semis), extra...)
		}
	case 252:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, nil, nil, protoDollar[4].cmpctOpts, semis), extra...)
		}
	case 253:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, nil, nil, nil, semis), extra...)
		}
	case 254:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, nil, nil, protoDollar[3].cmpctOpts, semis), extra...)
		}
	case 255:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semis), extra...)
		}
	case 256:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semis), extra...)
		}
	case 257:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, nil, nil, protoDollar[3].cmpctOpts, semis), extra...)
		}
	case 258:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semis), extra...)
		}
	case 259:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semis), extra...)
		}
	case 260:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, nil, nil, protoDollar[3].cmpctOpts, semis), extra...)
		}
	case 261:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, nil, nil, nil, semis), extra...)
		}
	case 262:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, nil, nil, nil, semis), extra...)
		}
	case 263:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, nil, nil, nil, semis), extra...)
		}
	case 264:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].id, protoDollar[2].id, nil, nil, nil, semis), extra...)
		}
	case 265:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.extend = newNodeWithRunes(ast.NewExtendNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].b, protoDollar[4].extElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 266:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.extElements = nil
		}
	case 268:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].extElement != nil {
				protoVAL.extElements = append(protoDollar[1].extElements, protoDollar[2].extElement)
			} else {
				protoVAL.extElements = protoDollar[1].extElements
			}
		}
	case 269:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].extElement != nil {
				protoVAL.extElements = []ast.ExtendElement{protoDollar[1].extElement}
			} else {
				protoVAL.extElements = nil
			}
		}
	case 270:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].fld
		}
	case 271:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].grp
		}
	case 272:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 273:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 274:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 275:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 276:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 277:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 278:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.svc = newNodeWithRunes(ast.NewServiceNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].svcElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 279:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = prependRunes(toServiceElement, protoDollar[1].bs, nil)
		}
	case 280:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.svcElements = prependRunes(toServiceElement, protoDollar[1].bs, protoDollar[2].svcElements)
		}
	case 281:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.svcElements = append(protoDollar[1].svcElements, protoDollar[2].svcElements...)
		}
	case 282:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = protoDollar[1].svcElements
		}
	case 283:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = toElements[ast.ServiceElement](toServiceElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 284:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = toElements[ast.ServiceElement](toServiceElement, protoDollar[1].mtd.Node, protoDollar[1].mtd.Runes)
		}
	case 285:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = nil
		}
	case 286:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.mtd = newNodeWithRunes(ast.NewRPCNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, semi), extra...)
		}
	case 287:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.mtd = newNodeWithRunes(ast.NewRPCNodeWithBody(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, protoDollar[6].b, protoDollar[7].mtdElements, protoDollar[8].b), protoDollar[9].bs...)
		}
	case 288:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, protoDollar[2].id.ToKeyword(), protoDollar[3].tid, protoDollar[4].b)
		}
	case 289:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, nil, protoDollar[2].tid, protoDollar[3].b)
		}
	case 290:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = prependRunes(toMethodElement, protoDollar[1].bs, nil)
		}
	case 291:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.mtdElements = prependRunes(toMethodElement, protoDollar[1].bs, protoDollar[2].mtdElements)
		}
	case 292:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.mtdElements = append(protoDollar[1].mtdElements, protoDollar[2].mtdElements...)
		}
	case 293:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = protoDollar[1].mtdElements
		}
	case 294:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = toElements[ast.RPCElement](toMethodElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 295:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = nil
		}
	}
	goto protostack /* stack new state and value */
}
