/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CSIVolumeSourceApplyConfiguration represents a declarative configuration of the CSIVolumeSource type for use
// with apply.
//
// Represents a source location of a volume to mount, managed by an external CSI driver
type CSIVolumeSourceApplyConfiguration struct {
	// driver is the name of the CSI driver that handles this volume.
	// Consult with your admin for the correct name as registered in the cluster.
	Driver *string `json:"driver,omitempty"`
	// readOnly specifies a read-only configuration for the volume.
	// Defaults to false (read/write).
	ReadOnly *bool `json:"readOnly,omitempty"`
	// fsType to mount. Ex. "ext4", "xfs", "ntfs".
	// If not provided, the empty value is passed to the associated CSI driver
	// which will determine the default filesystem to apply.
	FSType *string `json:"fsType,omitempty"`
	// volumeAttributes stores driver-specific properties that are passed to the CSI
	// driver. Consult your driver's documentation for supported values.
	VolumeAttributes map[string]string `json:"volumeAttributes,omitempty"`
	// nodePublishSecretRef is a reference to the secret object containing
	// sensitive information to pass to the CSI driver to complete the CSI
	// NodePublishVolume and NodeUnpublishVolume calls.
	// This field is optional, and  may be empty if no secret is required. If the
	// secret object contains more than one secret, all secret references are passed.
	NodePublishSecretRef *LocalObjectReferenceApplyConfiguration `json:"nodePublishSecretRef,omitempty"`
}

// CSIVolumeSourceApplyConfiguration constructs a declarative configuration of the CSIVolumeSource type for use with
// apply.
func CSIVolumeSource() *CSIVolumeSourceApplyConfiguration {
	return &CSIVolumeSourceApplyConfiguration{}
}

// WithDriver sets the Driver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Driver field is set to the value of the last call.
func (b *CSIVolumeSourceApplyConfiguration) WithDriver(value string) *CSIVolumeSourceApplyConfiguration {
	b.Driver = &value
	return b
}

// WithReadOnly sets the ReadOnly field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReadOnly field is set to the value of the last call.
func (b *CSIVolumeSourceApplyConfiguration) WithReadOnly(value bool) *CSIVolumeSourceApplyConfiguration {
	b.ReadOnly = &value
	return b
}

// WithFSType sets the FSType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FSType field is set to the value of the last call.
func (b *CSIVolumeSourceApplyConfiguration) WithFSType(value string) *CSIVolumeSourceApplyConfiguration {
	b.FSType = &value
	return b
}

// WithVolumeAttributes puts the entries into the VolumeAttributes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the VolumeAttributes field,
// overwriting an existing map entries in VolumeAttributes field with the same key.
func (b *CSIVolumeSourceApplyConfiguration) WithVolumeAttributes(entries map[string]string) *CSIVolumeSourceApplyConfiguration {
	if b.VolumeAttributes == nil && len(entries) > 0 {
		b.VolumeAttributes = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.VolumeAttributes[k] = v
	}
	return b
}

// WithNodePublishSecretRef sets the NodePublishSecretRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodePublishSecretRef field is set to the value of the last call.
func (b *CSIVolumeSourceApplyConfiguration) WithNodePublishSecretRef(value *LocalObjectReferenceApplyConfiguration) *CSIVolumeSourceApplyConfiguration {
	b.NodePublishSecretRef = value
	return b
}
