// Code generated by smithy-go-codegen DO NOT EDIT.

package kms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a random byte string that is cryptographically secure.
//
// You must use the NumberOfBytes parameter to specify the length of the random
// byte string. There is no default value for string length.
//
// By default, the random byte string is generated in KMS. To generate the byte
// string in the CloudHSM cluster associated with an CloudHSM key store, use the
// CustomKeyStoreId parameter.
//
// GenerateRandom also supports [Amazon Web Services Nitro Enclaves], which provide an isolated compute environment in
// Amazon EC2. To call GenerateRandom for a Nitro enclave or NitroTPM, use the [Amazon Web Services Nitro Enclaves SDK] or
// any Amazon Web Services SDK. Use the Recipient parameter to provide the
// attestation document for the attested environment. Instead of plaintext bytes,
// the response includes the plaintext bytes encrypted under the public key from
// the attestation document ( CiphertextForRecipient ). For information about the
// interaction between KMS and Amazon Web Services Nitro Enclaves or Amazon Web
// Services NitroTPM, see [Cryptographic attestation support in KMS]in the Key Management Service Developer Guide.
//
// For more information about entropy and random number generation, see [Entropy and random number generation] in the
// Key Management Service Developer Guide.
//
// Cross-account use: Not applicable. GenerateRandom does not use any
// account-specific resources, such as KMS keys.
//
// Required permissions: [kms:GenerateRandom] (IAM policy)
//
// Eventual consistency: The KMS API follows an eventual consistency model. For
// more information, see [KMS eventual consistency].
//
// [Cryptographic attestation support in KMS]: https://docs.aws.amazon.com/kms/latest/developerguide/cryptographic-attestation.html
// [kms:GenerateRandom]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html
// [Amazon Web Services Nitro Enclaves]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave.html
// [KMS eventual consistency]: https://docs.aws.amazon.com/kms/latest/developerguide/accessing-kms.html#programming-eventual-consistency
// [Amazon Web Services Nitro Enclaves SDK]: https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk
// [Entropy and random number generation]: https://docs.aws.amazon.com/kms/latest/developerguide/kms-cryptography.html#entropy-and-random-numbers
func (c *Client) GenerateRandom(ctx context.Context, params *GenerateRandomInput, optFns ...func(*Options)) (*GenerateRandomOutput, error) {
	if params == nil {
		params = &GenerateRandomInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GenerateRandom", params, optFns, c.addOperationGenerateRandomMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GenerateRandomOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GenerateRandomInput struct {

	// Generates the random byte string in the CloudHSM cluster that is associated
	// with the specified CloudHSM key store. To find the ID of a custom key store, use
	// the DescribeCustomKeyStoresoperation.
	//
	// External key store IDs are not valid for this parameter. If you specify the ID
	// of an external key store, GenerateRandom throws an UnsupportedOperationException
	// .
	CustomKeyStoreId *string

	// The length of the random byte string. This parameter is required.
	NumberOfBytes *int32

	// A signed [attestation document] from an Amazon Web Services Nitro enclave or NitroTPM, and the
	// encryption algorithm to use with the public key in the attestation document. The
	// only valid encryption algorithm is RSAES_OAEP_SHA_256 .
	//
	// This parameter supports the [Amazon Web Services Nitro Enclaves SDK] or any Amazon Web Services SDK for Amazon Web
	// Services Nitro Enclaves. It supports any Amazon Web Services SDK for Amazon Web
	// Services NitroTPM.
	//
	// When you use this parameter, instead of returning plaintext bytes, KMS encrypts
	// the plaintext bytes under the public key in the attestation document, and
	// returns the resulting ciphertext in the CiphertextForRecipient field in the
	// response. This ciphertext can be decrypted only with the private key in the
	// attested environment. The Plaintext field in the response is null or empty.
	//
	// For information about the interaction between KMS and Amazon Web Services Nitro
	// Enclaves or Amazon Web Services NitroTPM, see [Cryptographic attestation support in KMS]in the Key Management Service
	// Developer Guide.
	//
	// [Cryptographic attestation support in KMS]: https://docs.aws.amazon.com/kms/latest/developerguide/cryptographic-attestation.html
	// [attestation document]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave-how.html#term-attestdoc
	// [Amazon Web Services Nitro Enclaves SDK]: https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk
	Recipient *types.RecipientInfo

	noSmithyDocumentSerde
}

type GenerateRandomOutput struct {

	// The plaintext random bytes encrypted with the public key from the attestation
	// document. This ciphertext can be decrypted only by using a private key from the
	// attested environment.
	//
	// This field is included in the response only when the Recipient parameter in the
	// request includes a valid attestation document from an Amazon Web Services Nitro
	// enclave or NitroTPM. For information about the interaction between KMS and
	// Amazon Web Services Nitro Enclaves or Amazon Web Services NitroTPM, see [Cryptographic attestation support in KMS]in the
	// Key Management Service Developer Guide.
	//
	// [Cryptographic attestation support in KMS]: https://docs.aws.amazon.com/kms/latest/developerguide/cryptographic-attestation.html
	CiphertextForRecipient []byte

	// The random byte string. When you use the HTTP API or the Amazon Web Services
	// CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
	//
	// If the response includes the CiphertextForRecipient field, the Plaintext field
	// is null or empty.
	Plaintext []byte

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGenerateRandomMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGenerateRandom{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGenerateRandom{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GenerateRandom"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGenerateRandom(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGenerateRandom(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GenerateRandom",
	}
}
