/* theme_panel.c generated by valac 0.56.17, the Vala compiler
 * generated from theme_panel.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gee.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_THEME_PANEL (widgets_theme_panel_get_type ())
#define WIDGETS_THEME_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_THEME_PANEL, WidgetsThemePanel))
#define WIDGETS_THEME_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_THEME_PANEL, WidgetsThemePanelClass))
#define WIDGETS_IS_THEME_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_THEME_PANEL))
#define WIDGETS_IS_THEME_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_THEME_PANEL))
#define WIDGETS_THEME_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_THEME_PANEL, WidgetsThemePanelClass))

typedef struct _WidgetsThemePanel WidgetsThemePanel;
typedef struct _WidgetsThemePanelClass WidgetsThemePanelClass;
typedef struct _WidgetsThemePanelPrivate WidgetsThemePanelPrivate;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;

#define WIDGETS_TYPE_SWITCHER (widgets_switcher_get_type ())
#define WIDGETS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcher))
#define WIDGETS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))
#define WIDGETS_IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))

typedef struct _WidgetsSwitcher WidgetsSwitcher;
typedef struct _WidgetsSwitcherClass WidgetsSwitcherClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;
enum  {
	WIDGETS_THEME_PANEL_0_PROPERTY,
	WIDGETS_THEME_PANEL_NUM_PROPERTIES
};
static GParamSpec* widgets_theme_panel_properties[WIDGETS_THEME_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define WIDGETS_TYPE_THEME_LIST (widgets_theme_list_get_type ())
#define WIDGETS_THEME_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_THEME_LIST, WidgetsThemeList))
#define WIDGETS_THEME_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_THEME_LIST, WidgetsThemeListClass))
#define WIDGETS_IS_THEME_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_THEME_LIST))
#define WIDGETS_IS_THEME_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_THEME_LIST))
#define WIDGETS_THEME_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_THEME_LIST, WidgetsThemeListClass))

typedef struct _WidgetsThemeList WidgetsThemeList;
typedef struct _WidgetsThemeListClass WidgetsThemeListClass;
typedef struct _Block48Data Block48Data;
typedef struct _WidgetsThemeListPrivate WidgetsThemeListPrivate;

#define WIDGETS_TYPE_THEME_BUTTON (widgets_theme_button_get_type ())
#define WIDGETS_THEME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_THEME_BUTTON, WidgetsThemeButton))
#define WIDGETS_THEME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_THEME_BUTTON, WidgetsThemeButtonClass))
#define WIDGETS_IS_THEME_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_THEME_BUTTON))
#define WIDGETS_IS_THEME_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_THEME_BUTTON))
#define WIDGETS_THEME_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_THEME_BUTTON, WidgetsThemeButtonClass))

typedef struct _WidgetsThemeButton WidgetsThemeButton;
typedef struct _WidgetsThemeButtonClass WidgetsThemeButtonClass;
typedef void (*WidgetsThemePanelUpdatePageAfterEdit) (gpointer user_data);

struct _WidgetsThemePanel {
	GtkHBox parent_instance;
	WidgetsThemePanelPrivate * priv;
	WidgetsConfigWindow* parent_window;
	WidgetsSwitcher* switcher;
	WidgetsWorkspaceManager* workspace_manager;
	WidgetsWorkspace* workspace;
	GdkRGBA background_color;
	GdkRGBA line_dark_color;
	GdkRGBA line_light_color;
	GtkBox* home_page_box;
	GtkScrolledWindow* scrolledwindow;
	GtkWidget* focus_widget;
	GKeyFile* config_file;
	gint back_button_margin_left;
	gint back_button_margin_top;
	gint split_line_margin_left;
	gint theme_button_padding;
	gint theme_list_margin_bottom;
	gint theme_list_margin_top;
	gint width;
};

struct _WidgetsThemePanelClass {
	GtkHBoxClass parent_class;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

struct _Block48Data {
	int _ref_count_;
	WidgetsThemePanel* self;
	WidgetsThemeList* theme_list;
};

struct _WidgetsThemeList {
	GtkVBox parent_instance;
	WidgetsThemeListPrivate * priv;
	gint theme_button_padding;
	GeeHashMap* theme_button_map;
	WidgetsThemeButton* active_theme_button;
};

struct _WidgetsThemeListClass {
	GtkVBoxClass parent_class;
};

static gpointer widgets_theme_panel_parent_class = NULL;
VALA_EXTERN gint constant_THEME_SLIDER_WIDTH;
VALA_EXTERN gint constant_THEME_BUTTON_HEIGHT;

VALA_EXTERN GType widgets_theme_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsThemePanel, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType widgets_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSwitcher, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN WidgetsThemePanel* widgets_theme_panel_new (WidgetsWorkspace* space,
                                            WidgetsWorkspaceManager* manager);
VALA_EXTERN WidgetsThemePanel* widgets_theme_panel_construct (GType object_type,
                                                  WidgetsWorkspace* space,
                                                  WidgetsWorkspaceManager* manager);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN WidgetsSwitcher* widgets_switcher_new (gint w);
VALA_EXTERN WidgetsSwitcher* widgets_switcher_construct (GType object_type,
                                             gint w);
VALA_EXTERN void widgets_theme_panel_show_home_page (WidgetsThemePanel* self,
                                         GtkWidget* start_widget);
static gboolean widgets_theme_panel_on_draw (WidgetsThemePanel* self,
                                      GtkWidget* widget,
                                      cairo_t* cr);
static gboolean _widgets_theme_panel_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                       cairo_t* cr,
                                                       gpointer self);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN GType widgets_theme_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsThemeList, g_object_unref)
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static void ___lambda105_ (WidgetsThemePanel* self,
                    GtkWidget* w);
VALA_EXTERN void widgets_theme_panel_init_scrollbar (WidgetsThemePanel* self);
static void ____lambda105__gtk_widget_realize (GtkWidget* _sender,
                                        gpointer self);
VALA_EXTERN WidgetsThemeList* widgets_theme_list_new (const gchar* default_theme);
VALA_EXTERN WidgetsThemeList* widgets_theme_list_construct (GType object_type,
                                                const gchar* default_theme);
static void ___lambda107_ (WidgetsThemePanel* self,
                    const gchar* active_theme_name);
VALA_EXTERN void config_config_set_theme (ConfigConfig* self,
                              const gchar* theme_name);
static void ____lambda107__widgets_theme_list_active_theme (WidgetsThemeList* _sender,
                                                     const gchar* theme_name,
                                                     gpointer self);
VALA_EXTERN void widgets_switcher_add_to_left_box (WidgetsSwitcher* self,
                                       GtkWidget* start_widget);
static void ___lambda108_ (Block48Data* _data48_,
                    GtkWidget* w);
static gboolean __lambda109_ (Block48Data* _data48_);
VALA_EXTERN GType widgets_theme_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsThemeButton, g_object_unref)
static gboolean ___lambda109__gsource_func (gpointer self);
static void ____lambda108__gtk_widget_show (GtkWidget* _sender,
                                     gpointer self);
static void widgets_theme_panel_finalize (GObject * obj);
static GType widgets_theme_panel_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_widgets_theme_panel_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                              cairo_t* cr,
                                              gpointer self)
{
	gboolean result;
	result = widgets_theme_panel_on_draw ((WidgetsThemePanel*) self, _sender, cr);
	return result;
}

WidgetsThemePanel*
widgets_theme_panel_construct (GType object_type,
                               WidgetsWorkspace* space,
                               WidgetsWorkspaceManager* manager)
{
	WidgetsThemePanel * self = NULL;
	WidgetsWorkspace* _tmp0_;
	WidgetsWorkspaceManager* _tmp1_;
	GKeyFile* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	WidgetsWorkspace* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	WidgetsWorkspace* _tmp9_;
	GtkWidget* _tmp10_;
	WidgetsConfigWindow* _tmp11_;
	WidgetsSwitcher* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	WidgetsSwitcher* _tmp15_;
	g_return_val_if_fail (space != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	self = (WidgetsThemePanel*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	_tmp0_ = _g_object_ref0 (space);
	_g_object_unref0 (self->workspace);
	self->workspace = _tmp0_;
	_tmp1_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->workspace_manager);
	self->workspace_manager = _tmp1_;
	_tmp2_ = g_key_file_new ();
	_g_key_file_unref0 (self->config_file);
	self->config_file = _tmp2_;
	utils_hex_to_rgba ("#ffffff", 0.1, &_tmp3_);
	self->line_dark_color = _tmp3_;
	utils_hex_to_rgba ("#000000", 0.1, &_tmp4_);
	self->line_light_color = _tmp4_;
	_tmp5_ = self->workspace;
	_tmp6_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp5_);
	_tmp7_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->focus_widget);
	self->focus_widget = _tmp8_;
	_tmp9_ = self->workspace;
	_tmp10_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp9_);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	_g_object_unref0 (self->parent_window);
	self->parent_window = _tmp11_;
	_tmp12_ = widgets_switcher_new (self->width);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->switcher);
	self->switcher = _tmp12_;
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->home_page_box);
	self->home_page_box = _tmp13_;
	gtk_widget_set_size_request ((GtkWidget*) self, self->width, -1);
	_tmp14_ = self->home_page_box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp14_, self->width, -1);
	_tmp15_ = self->switcher;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
	widgets_theme_panel_show_home_page (self, NULL);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_theme_panel_on_draw_gtk_widget_draw, self, 0);
	return self;
}

WidgetsThemePanel*
widgets_theme_panel_new (WidgetsWorkspace* space,
                         WidgetsWorkspaceManager* manager)
{
	return widgets_theme_panel_construct (WIDGETS_TYPE_THEME_PANEL, space, manager);
}

static gboolean
widgets_theme_panel_on_draw (WidgetsThemePanel* self,
                             GtkWidget* widget,
                             cairo_t* cr)
{
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp0_;
	GtkAllocation rect = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GtkAllocation _tmp14_;
	GtkAllocation _tmp15_;
	GtkAllocation _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	gtk_widget_get_allocation (widget, &_tmp1_);
	rect = _tmp1_;
	{
		gchar* _tmp2_ = NULL;
		WidgetsConfigWindow* _tmp3_;
		ConfigConfig* _tmp4_;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		GdkRGBA _tmp7_ = {0};
		_tmp3_ = self->parent_window;
		_tmp4_ = _tmp3_->config;
		_tmp5_ = _tmp4_->config_file;
		_tmp6_ = g_key_file_get_string (_tmp5_, "theme", "background", &_inner_error0_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		utils_hex_to_rgba (_tmp2_, 1.0, &_tmp7_);
		self->background_color = _tmp7_;
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_print ("ThemePanel init: %s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = self->background_color;
	_tmp12_ = self->background_color;
	_tmp13_ = self->background_color;
	cairo_set_source_rgba (cr, _tmp11_.red, _tmp12_.green, _tmp13_.blue, 0.8);
	_tmp14_ = rect;
	_tmp15_ = rect;
	draw_draw_rectangle (cr, 1, 0, _tmp14_.width - 1, _tmp15_.height, TRUE);
	if (is_light_theme) {
		GdkRGBA _tmp16_;
		_tmp16_ = self->line_light_color;
		utils_set_context_color (cr, &_tmp16_);
	} else {
		GdkRGBA _tmp17_;
		_tmp17_ = self->line_dark_color;
		utils_set_context_color (cr, &_tmp17_);
	}
	_tmp18_ = rect;
	draw_draw_rectangle (cr, 0, 0, 1, _tmp18_.height, TRUE);
	result = FALSE;
	return result;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		WidgetsThemePanel* self;
		self = _data48_->self;
		_g_object_unref0 (_data48_->theme_list);
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}

static void
___lambda105_ (WidgetsThemePanel* self,
               GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	widgets_theme_panel_init_scrollbar (self);
}

static void
____lambda105__gtk_widget_realize (GtkWidget* _sender,
                                   gpointer self)
{
	___lambda105_ ((WidgetsThemePanel*) self, _sender);
}

static void
___lambda107_ (WidgetsThemePanel* self,
               const gchar* active_theme_name)
{
	WidgetsConfigWindow* _tmp0_;
	ConfigConfig* _tmp1_;
	g_return_if_fail (active_theme_name != NULL);
	_tmp0_ = self->parent_window;
	_tmp1_ = _tmp0_->config;
	config_config_set_theme (_tmp1_, active_theme_name);
	widgets_theme_panel_init_scrollbar (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
____lambda107__widgets_theme_list_active_theme (WidgetsThemeList* _sender,
                                                const gchar* theme_name,
                                                gpointer self)
{
	___lambda107_ ((WidgetsThemePanel*) self, theme_name);
}

static gboolean
__lambda109_ (Block48Data* _data48_)
{
	WidgetsThemePanel* self;
	gint widget_x = 0;
	gint widget_y = 0;
	WidgetsThemeList* _tmp0_;
	WidgetsThemeButton* _tmp1_;
	WidgetsThemeList* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkAllocation rect = {0};
	GtkAllocation _tmp5_ = {0};
	GtkAdjustment* adjust = NULL;
	GtkScrolledWindow* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAllocation _tmp9_;
	gboolean result;
	self = _data48_->self;
	_tmp0_ = _data48_->theme_list;
	_tmp1_ = _tmp0_->active_theme_button;
	_tmp2_ = _data48_->theme_list;
	gtk_widget_translate_coordinates ((GtkWidget*) _tmp1_, (GtkWidget*) _tmp2_, 0, 0, &_tmp3_, &_tmp4_);
	widget_x = _tmp3_;
	widget_y = _tmp4_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp5_);
	rect = _tmp5_;
	_tmp6_ = self->scrolledwindow;
	_tmp7_ = gtk_scrolled_window_get_vadjustment (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	adjust = _tmp8_;
	_tmp9_ = rect;
	gtk_adjustment_set_value (adjust, (gdouble) (widget_y - ((_tmp9_.height - constant_THEME_BUTTON_HEIGHT) / 2)));
	result = FALSE;
	_g_object_unref0 (adjust);
	return result;
}

static gboolean
___lambda109__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda109_ (self);
	return result;
}

static void
___lambda108_ (Block48Data* _data48_,
               GtkWidget* w)
{
	WidgetsThemePanel* self;
	self = _data48_->self;
	g_return_if_fail (w != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda109__gsource_func, block48_data_ref (_data48_), block48_data_unref);
}

static void
____lambda108__gtk_widget_show (GtkWidget* _sender,
                                gpointer self)
{
	___lambda108_ (self, _sender);
}

void
widgets_theme_panel_show_home_page (WidgetsThemePanel* self,
                                    GtkWidget* start_widget)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		Block48Data* _data48_;
		GtkScrolledWindow* _tmp0_;
		GtkScrolledWindow* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkScrolledWindow* _tmp3_;
		GtkScrolledWindow* _tmp4_;
		GtkScrolledWindow* _tmp5_;
		GtkWidget* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkBox* _tmp8_;
		GtkScrolledWindow* _tmp9_;
		gchar* theme_name = NULL;
		WidgetsConfigWindow* _tmp10_;
		ConfigConfig* _tmp11_;
		GKeyFile* _tmp12_;
		gchar* _tmp13_;
		WidgetsThemeList* _tmp14_;
		WidgetsThemeList* _tmp15_;
		WidgetsThemeList* _tmp16_;
		WidgetsThemeList* _tmp17_;
		GtkScrolledWindow* _tmp18_;
		WidgetsThemeList* _tmp19_;
		WidgetsSwitcher* _tmp20_;
		GtkBox* _tmp21_;
		_data48_ = g_slice_new0 (Block48Data);
		_data48_->_ref_count_ = 1;
		_data48_->self = g_object_ref (self);
		_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		g_object_ref_sink (_tmp0_);
		_g_object_unref0 (self->scrolledwindow);
		self->scrolledwindow = _tmp0_;
		_tmp1_ = self->scrolledwindow;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "scrolledwindow");
		_tmp3_ = self->scrolledwindow;
		gtk_scrolled_window_set_policy (_tmp3_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		_tmp4_ = self->scrolledwindow;
		gtk_scrolled_window_set_shadow_type (_tmp4_, GTK_SHADOW_NONE);
		_tmp5_ = self->scrolledwindow;
		_tmp6_ = gtk_scrolled_window_get_vscrollbar (_tmp5_);
		_tmp7_ = gtk_widget_get_style_context (_tmp6_);
		gtk_style_context_add_class (_tmp7_, "light_scrollbar");
		_tmp8_ = self->home_page_box;
		_tmp9_ = self->scrolledwindow;
		gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
		g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) ____lambda105__gtk_widget_realize, self, 0);
		_tmp10_ = self->parent_window;
		_tmp11_ = _tmp10_->config;
		_tmp12_ = _tmp11_->config_file;
		_tmp13_ = g_key_file_get_string (_tmp12_, "general", "theme", &_inner_error0_);
		theme_name = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block48_data_unref (_data48_);
			_data48_ = NULL;
			goto __catch0_g_error;
		}
		_tmp14_ = widgets_theme_list_new (theme_name);
		g_object_ref_sink (_tmp14_);
		_data48_->theme_list = _tmp14_;
		_tmp15_ = _data48_->theme_list;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, self->theme_list_margin_top);
		_tmp16_ = _data48_->theme_list;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, self->theme_list_margin_bottom);
		_tmp17_ = _data48_->theme_list;
		g_signal_connect_object (_tmp17_, "active-theme", (GCallback) ____lambda107__widgets_theme_list_active_theme, self, 0);
		_tmp18_ = self->scrolledwindow;
		_tmp19_ = _data48_->theme_list;
		gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
		_tmp20_ = self->switcher;
		_tmp21_ = self->home_page_box;
		widgets_switcher_add_to_left_box (_tmp20_, (GtkWidget*) _tmp21_);
		g_signal_connect_data ((GtkWidget*) self, "show", (GCallback) ____lambda108__gtk_widget_show, block48_data_ref (_data48_), (GClosureNotify) block48_data_unref, 0);
		gtk_widget_show_all ((GtkWidget*) self);
		_g_free0 (theme_name);
		block48_data_unref (_data48_);
		_data48_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_print ("ThemePanel show_home_page: %s\n", _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
widgets_theme_panel_init_scrollbar (WidgetsThemePanel* self)
{
	GtkScrolledWindow* _tmp0_;
	GtkWidget* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkWidget* _tmp4_;
	GtkStyleContext* _tmp5_;
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->scrolledwindow;
	_tmp1_ = gtk_scrolled_window_get_vscrollbar (_tmp0_);
	_tmp2_ = gtk_widget_get_style_context (_tmp1_);
	gtk_style_context_remove_class (_tmp2_, "light_scrollbar");
	_tmp3_ = self->scrolledwindow;
	_tmp4_ = gtk_scrolled_window_get_vscrollbar (_tmp3_);
	_tmp5_ = gtk_widget_get_style_context (_tmp4_);
	gtk_style_context_remove_class (_tmp5_, "dark_scrollbar");
	_tmp6_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	if (is_light_theme) {
		GtkScrolledWindow* _tmp7_;
		GtkWidget* _tmp8_;
		GtkStyleContext* _tmp9_;
		_tmp7_ = self->scrolledwindow;
		_tmp8_ = gtk_scrolled_window_get_vscrollbar (_tmp7_);
		_tmp9_ = gtk_widget_get_style_context (_tmp8_);
		gtk_style_context_add_class (_tmp9_, "light_scrollbar");
	} else {
		GtkScrolledWindow* _tmp10_;
		GtkWidget* _tmp11_;
		GtkStyleContext* _tmp12_;
		_tmp10_ = self->scrolledwindow;
		_tmp11_ = gtk_scrolled_window_get_vscrollbar (_tmp10_);
		_tmp12_ = gtk_widget_get_style_context (_tmp11_);
		gtk_style_context_add_class (_tmp12_, "dark_scrollbar");
	}
}

static void
widgets_theme_panel_class_init (WidgetsThemePanelClass * klass,
                                gpointer klass_data)
{
	widgets_theme_panel_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_theme_panel_finalize;
}

static void
widgets_theme_panel_instance_init (WidgetsThemePanel * self,
                                   gpointer klass)
{
	self->back_button_margin_left = 8;
	self->back_button_margin_top = 6;
	self->split_line_margin_left = 1;
	self->theme_button_padding = 5;
	self->theme_list_margin_bottom = 5;
	self->theme_list_margin_top = 5;
	self->width = constant_THEME_SLIDER_WIDTH;
}

static void
widgets_theme_panel_finalize (GObject * obj)
{
	WidgetsThemePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_THEME_PANEL, WidgetsThemePanel);
	_g_object_unref0 (self->parent_window);
	_g_object_unref0 (self->switcher);
	_g_object_unref0 (self->workspace_manager);
	_g_object_unref0 (self->workspace);
	_g_object_unref0 (self->home_page_box);
	_g_object_unref0 (self->scrolledwindow);
	_g_object_unref0 (self->focus_widget);
	_g_key_file_unref0 (self->config_file);
	G_OBJECT_CLASS (widgets_theme_panel_parent_class)->finalize (obj);
}

static GType
widgets_theme_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsThemePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_theme_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsThemePanel), 0, (GInstanceInitFunc) widgets_theme_panel_instance_init, NULL };
	GType widgets_theme_panel_type_id;
	widgets_theme_panel_type_id = g_type_register_static (gtk_hbox_get_type (), "WidgetsThemePanel", &g_define_type_info, 0);
	return widgets_theme_panel_type_id;
}

GType
widgets_theme_panel_get_type (void)
{
	static volatile gsize widgets_theme_panel_type_id__once = 0;
	if (g_once_init_enter (&widgets_theme_panel_type_id__once)) {
		GType widgets_theme_panel_type_id;
		widgets_theme_panel_type_id = widgets_theme_panel_get_type_once ();
		g_once_init_leave (&widgets_theme_panel_type_id__once, widgets_theme_panel_type_id);
	}
	return widgets_theme_panel_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

