/* DebugInfo.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DebugInfo.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#define _XOPEN_SOURCE

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "deja.h"
#include <glib/gstdio.h>
#include <time.h>
#include <locale.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DEBUG_INFO (debug_info_get_type ())
#define DEBUG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEBUG_INFO, DebugInfo))
#define DEBUG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEBUG_INFO, DebugInfoClass))
#define IS_DEBUG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEBUG_INFO))
#define IS_DEBUG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEBUG_INFO))
#define DEBUG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEBUG_INFO, DebugInfoClass))

typedef struct _DebugInfo DebugInfo;
typedef struct _DebugInfoClass DebugInfoClass;
typedef struct _DebugInfoPrivate DebugInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ParamSpecDebugInfo ParamSpecDebugInfo;

struct _DebugInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DebugInfoPrivate * priv;
};

struct _DebugInfoClass {
	GTypeClass parent_class;
	void (*finalize) (DebugInfo *self);
};

struct _ParamSpecDebugInfo {
	GParamSpec parent_instance;
};

static gpointer debug_info_parent_class = NULL;

VALA_EXTERN gpointer debug_info_ref (gpointer instance);
VALA_EXTERN void debug_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_debug_info (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_debug_info (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_debug_info (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_debug_info (const GValue* value);
VALA_EXTERN GType debug_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DebugInfo, debug_info_unref)
VALA_EXTERN gchar* debug_info_get_debug_info (void);
static gchar* debug_info_get_system_info (DejaDupLogObscurer* obscurer);
static gchar* debug_info_get_gsettings (DejaDupLogObscurer* obscurer,
                                 const gchar* schema);
static gchar* _debug_info_get_file_timestamp (const gchar* filename);
VALA_EXTERN DebugInfo* debug_info_new (void);
VALA_EXTERN DebugInfo* debug_info_construct (GType object_type);
static void debug_info_finalize (DebugInfo * obj);
static GType debug_info_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

gchar*
debug_info_get_debug_info (void)
{
	DejaDupLogObscurer* obscurer = NULL;
	DejaDupLogObscurer* _tmp0_;
	gchar* text = NULL;
	DejaDupLogObscurer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* gsettings = NULL;
	DejaDupLogObscurer* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	DejaDupDuplicityLogger* dup_logger = NULL;
	DejaDupDuplicityLogger* _tmp14_;
	DejaDupDuplicityLogger* _tmp15_;
	gchar* restic_log = NULL;
	DejaDupLogObscurer* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* result;
	_tmp0_ = deja_dup_log_obscurer_new ();
	obscurer = _tmp0_;
	_tmp1_ = obscurer;
	_tmp2_ = debug_info_get_system_info (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("System Details:\n%s", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	text = _tmp5_;
	_tmp6_ = obscurer;
	_tmp7_ = debug_info_get_gsettings (_tmp6_, APPLICATION_ID);
	gsettings = _tmp7_;
	_tmp8_ = gsettings;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = text;
		_tmp10_ = gsettings;
		_tmp11_ = g_strdup_printf ("\nGSettings:\n%s", _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
		_g_free0 (text);
		text = _tmp13_;
		_g_free0 (_tmp12_);
	}
	_tmp14_ = deja_dup_duplicity_logger_from_cache_log ();
	dup_logger = _tmp14_;
	_tmp15_ = dup_logger;
	if (_tmp15_ != NULL) {
		DejaDupDuplicityLogger* _tmp16_;
		gchar* log = NULL;
		DejaDupDuplicityLogger* _tmp17_;
		DejaDupLogObscurer* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* timestamp = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp16_ = dup_logger;
		deja_dup_duplicity_logger_read_sync (_tmp16_);
		_tmp17_ = dup_logger;
		_tmp18_ = obscurer;
		_tmp19_ = deja_dup_duplicity_logger_get_obscured_tail (_tmp17_, _tmp18_);
		log = _tmp19_;
		_tmp20_ = text;
		_tmp21_ = g_strconcat (_tmp20_, "\nLatest Duplicity Log:", NULL);
		_g_free0 (text);
		text = _tmp21_;
		_tmp22_ = deja_dup_duplicity_logger_get_cachefile ();
		_tmp23_ = _tmp22_;
		_tmp24_ = _debug_info_get_file_timestamp (_tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		timestamp = _tmp25_;
		_tmp26_ = timestamp;
		if (_tmp26_ != NULL) {
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp27_ = text;
			_tmp28_ = timestamp;
			_tmp29_ = g_strdup_printf (" (%s)", _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
			_g_free0 (text);
			text = _tmp31_;
			_g_free0 (_tmp30_);
		}
		_tmp32_ = text;
		_tmp33_ = log;
		_tmp34_ = g_strconcat ("\n", _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
		_g_free0 (text);
		text = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (timestamp);
		_g_free0 (log);
	}
	_tmp37_ = obscurer;
	_tmp38_ = deja_dup_restic_logger_from_cache_log (_tmp37_);
	restic_log = _tmp38_;
	_tmp39_ = restic_log;
	if (_tmp39_ != NULL) {
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* timestamp = NULL;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp40_ = text;
		_tmp41_ = g_strconcat (_tmp40_, "\nLatest Restic Log:", NULL);
		_g_free0 (text);
		text = _tmp41_;
		_tmp42_ = deja_dup_restic_logger_get_cachefile ();
		_tmp43_ = _tmp42_;
		_tmp44_ = _debug_info_get_file_timestamp (_tmp43_);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		timestamp = _tmp45_;
		_tmp46_ = timestamp;
		if (_tmp46_ != NULL) {
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp47_ = text;
			_tmp48_ = timestamp;
			_tmp49_ = g_strdup_printf (" (%s)", _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp47_, _tmp50_, NULL);
			_g_free0 (text);
			text = _tmp51_;
			_g_free0 (_tmp50_);
		}
		_tmp52_ = text;
		_tmp53_ = restic_log;
		_tmp54_ = g_strconcat ("\n", _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat (_tmp52_, _tmp55_, NULL);
		_g_free0 (text);
		text = _tmp56_;
		_g_free0 (_tmp55_);
		_g_free0 (timestamp);
	}
	_tmp57_ = text;
	_tmp58_ = string_chomp (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_strdup_printf ("```\n%s\n```", _tmp59_);
	_tmp61_ = _tmp60_;
	_g_free0 (_tmp59_);
	result = _tmp61_;
	_g_free0 (restic_log);
	_g_object_unref0 (dup_logger);
	_g_free0 (gsettings);
	_g_free0 (text);
	_g_object_unref0 (obscurer);
	return result;
}

static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}

static gchar*
g_time_to_string (struct tm *self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("%04d-%02d-%02d %02d:%02d:%02d", (*self).tm_year + 1900, (*self).tm_mon + 1, (*self).tm_mday, (*self).tm_hour, (*self).tm_min, (*self).tm_sec);
	result = _tmp0_;
	return result;
}

static gchar*
_debug_info_get_file_timestamp (const gchar* filename)
{
	GStatBuf statbuf = {0};
	struct tm time = {0};
	GStatBuf _tmp0_;
	struct tm _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* result;
	if (filename == NULL) {
		result = NULL;
		return result;
	}
	g_stat (filename, &statbuf);
	_tmp0_ = statbuf;
	g_time_local (_tmp0_.st_mtime, &_tmp1_);
	time = _tmp1_;
	_tmp2_ = g_time_to_string (&time);
	result = _tmp2_;
	return result;
}

static gchar*
debug_info_get_system_info (DejaDupLogObscurer* obscurer)
{
	gchar* version = NULL;
	gchar* _tmp0_;
	gchar* install_env_name = NULL;
	DejaDupInstallEnv* _tmp1_;
	DejaDupInstallEnv* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	DejaDupToolPlugin* tool = NULL;
	DejaDupToolPlugin* _tmp11_;
	gchar* text = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp55_;
	DejaDupInstallEnv* _tmp56_;
	DejaDupInstallEnv* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (obscurer != NULL, NULL);
	_tmp0_ = g_strdup (VERSION);
	version = _tmp0_;
	_tmp1_ = deja_dup_install_env_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_install_env_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	install_env_name = _tmp4_;
	_tmp5_ = install_env_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = version;
		_tmp7_ = install_env_name;
		_tmp8_ = g_strdup_printf (" (%s)", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
		_g_free0 (version);
		version = _tmp10_;
		_g_free0 (_tmp9_);
	}
	_tmp11_ = deja_dup_get_default_tool ();
	tool = _tmp11_;
	_tmp12_ = g_strdup ("");
	text = _tmp12_;
	_tmp13_ = text;
	_tmp14_ = g_get_os_info (G_OS_INFO_KEY_PRETTY_NAME);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("OS=%s\n", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
	_g_free0 (text);
	text = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_tmp19_ = text;
	_tmp20_ = g_getenv ("XDG_SESSION_DESKTOP");
	_tmp21_ = g_strdup_printf ("Desktop=%s\n", _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
	_g_free0 (text);
	text = _tmp23_;
	_g_free0 (_tmp22_);
	_tmp24_ = text;
	_tmp25_ = setlocale (LC_MESSAGES, NULL);
	_tmp26_ = g_strdup_printf ("Locale=%s\n", _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
	_g_free0 (text);
	text = _tmp28_;
	_g_free0 (_tmp27_);
	_tmp29_ = text;
	_tmp30_ = g_get_home_dir ();
	_tmp31_ = deja_dup_log_obscurer_replace_path (obscurer, _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strdup_printf ("Home=%s\n", _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
	_g_free0 (text);
	text = _tmp35_;
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp36_ = text;
	_tmp37_ = version;
	_tmp38_ = g_strdup_printf ("Version=%s\n", _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
	_g_free0 (text);
	text = _tmp40_;
	_g_free0 (_tmp39_);
	_tmp41_ = text;
	_tmp42_ = deja_dup_tool_plugin_get_name (tool);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strdup_printf ("Tool Name=%s\n", _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp41_, _tmp45_, NULL);
	_g_free0 (text);
	text = _tmp46_;
	_g_free0 (_tmp45_);
	{
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp48_ = deja_dup_tool_plugin_get_version (tool, &_inner_error0_);
		_tmp47_ = _tmp48_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp49_ = text;
		_tmp50_ = g_strdup_printf ("Tool Version=%s\n", _tmp47_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strconcat (_tmp49_, _tmp51_, NULL);
		_g_free0 (text);
		text = _tmp52_;
		_g_free0 (_tmp51_);
		_g_free0 (_tmp47_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp53_;
		gchar* _tmp54_;
		g_clear_error (&_inner_error0_);
		_tmp53_ = text;
		_tmp54_ = g_strconcat (_tmp53_, "Tool Version=(unknown)\n", NULL);
		_g_free0 (text);
		text = _tmp54_;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (text);
		_g_object_unref0 (tool);
		_g_free0 (install_env_name);
		_g_free0 (version);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp55_ = text;
	_tmp56_ = deja_dup_install_env_instance ();
	_tmp57_ = _tmp56_;
	_tmp58_ = deja_dup_install_env_get_debug_info (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_strconcat (_tmp55_, _tmp59_, NULL);
	_g_free0 (text);
	text = _tmp60_;
	_g_free0 (_tmp59_);
	_g_object_unref0 (_tmp57_);
	result = text;
	_g_object_unref0 (tool);
	_g_free0 (install_env_name);
	_g_free0 (version);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
debug_info_get_gsettings (DejaDupLogObscurer* obscurer,
                          const gchar* schema)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gboolean has_content = FALSE;
	gchar* text = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GSettings* _tmp7_;
	GSettingsSchema* _tmp8_;
	GSettingsSchema* _tmp9_;
	GSettingsSchema* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GSettings* _tmp55_;
	gchar** _tmp56_;
	gchar** _tmp57_;
	gchar* result;
	g_return_val_if_fail (obscurer != NULL, NULL);
	_tmp0_ = g_settings_new (schema);
	settings = _tmp0_;
	has_content = FALSE;
	_tmp1_ = settings;
	g_object_get (_tmp1_, "schema-id", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("[%s]\n", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	text = _tmp6_;
	_tmp7_ = settings;
	g_object_get (_tmp7_, "settings-schema", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp12_ = _tmp11_ = g_settings_schema_list_keys (_tmp10_);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _vala_array_length (_tmp11_);
	_g_settings_schema_unref0 (_tmp10_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp13_;
		key_collection_length1 = _tmp13__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp14_;
			gchar* key = NULL;
			_tmp14_ = g_strdup (key_collection[key_it]);
			key = _tmp14_;
			{
				GVariant* val = NULL;
				GSettings* _tmp15_;
				const gchar* _tmp16_;
				GVariant* _tmp17_;
				GVariant* _tmp18_;
				_tmp15_ = settings;
				_tmp16_ = key;
				_tmp17_ = g_settings_get_user_value (_tmp15_, _tmp16_);
				val = _tmp17_;
				_tmp18_ = val;
				if (_tmp18_ != NULL) {
					gchar* val_str = NULL;
					GVariant* _tmp19_;
					gchar* _tmp20_;
					gboolean _tmp21_ = FALSE;
					const gchar* _tmp22_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp19_ = val;
					_tmp20_ = g_variant_print (_tmp19_, FALSE);
					val_str = _tmp20_;
					_tmp22_ = key;
					if (g_strcmp0 (_tmp22_, "folder") == 0) {
						_tmp21_ = TRUE;
					} else {
						const gchar* _tmp23_;
						_tmp23_ = key;
						_tmp21_ = g_strcmp0 (_tmp23_, "name") == 0;
					}
					if (_tmp21_) {
						GVariant* _tmp24_;
						const gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp24_ = val;
						_tmp25_ = g_variant_get_string (_tmp24_, NULL);
						_tmp26_ = deja_dup_log_obscurer_replace_path (obscurer, _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strdup_printf ("'%s'", _tmp27_);
						_g_free0 (val_str);
						val_str = _tmp28_;
						_g_free0 (_tmp27_);
					} else {
						gboolean _tmp29_ = FALSE;
						const gchar* _tmp30_;
						_tmp30_ = key;
						if (g_strcmp0 (_tmp30_, "include-list") == 0) {
							_tmp29_ = TRUE;
						} else {
							const gchar* _tmp31_;
							_tmp31_ = key;
							_tmp29_ = g_strcmp0 (_tmp31_, "exclude-list") == 0;
						}
						if (_tmp29_) {
							gchar* inner = NULL;
							GVariant* _tmp32_;
							gsize _tmp33_ = 0;
							gchar** _tmp34_;
							gchar** _tmp35_;
							gint _tmp35__length1;
							gint _tmp36_ = 0;
							gchar** _tmp37_;
							gchar** _tmp38_;
							gint _tmp38__length1;
							gchar* _tmp39_;
							gchar* _tmp40_;
							const gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp32_ = val;
							_tmp34_ = g_variant_dup_strv (_tmp32_, &_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp35__length1 = _tmp33_;
							_tmp37_ = deja_dup_log_obscurer_replace_paths (obscurer, _tmp35_, (gint) _tmp33_, &_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp38__length1 = _tmp36_;
							_tmp39_ = _vala_g_strjoinv ("', '", _tmp38_, (gint) _tmp36_);
							_tmp40_ = _tmp39_;
							_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
							_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
							inner = _tmp40_;
							_tmp41_ = inner;
							_tmp42_ = g_strdup_printf ("['%s']", _tmp41_);
							_g_free0 (val_str);
							val_str = _tmp42_;
							_g_free0 (inner);
						} else {
							const gchar* _tmp43_;
							_tmp43_ = key;
							if (g_strcmp0 (_tmp43_, "uri") == 0) {
								GVariant* _tmp44_;
								const gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								_tmp44_ = val;
								_tmp45_ = g_variant_get_string (_tmp44_, NULL);
								_tmp46_ = deja_dup_log_obscurer_replace_uri (obscurer, _tmp45_);
								_tmp47_ = _tmp46_;
								_tmp48_ = g_strdup_printf ("'%s'", _tmp47_);
								_g_free0 (val_str);
								val_str = _tmp48_;
								_g_free0 (_tmp47_);
							}
						}
					}
					_tmp49_ = text;
					_tmp50_ = key;
					_tmp51_ = val_str;
					_tmp52_ = g_strdup_printf ("%s=%s\n", _tmp50_, _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strconcat (_tmp49_, _tmp53_, NULL);
					_g_free0 (text);
					text = _tmp54_;
					_g_free0 (_tmp53_);
					has_content = TRUE;
					_g_free0 (val_str);
				}
				_g_variant_unref0 (val);
				_g_free0 (key);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp55_ = settings;
	_tmp57_ = _tmp56_ = g_settings_list_children (_tmp55_);
	{
		gchar** child_collection = NULL;
		gint child_collection_length1 = 0;
		gint _child_collection_size_ = 0;
		gint child_it = 0;
		child_collection = _tmp57_;
		child_collection_length1 = _vala_array_length (_tmp56_);
		for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
			gchar* _tmp58_;
			gchar* child = NULL;
			_tmp58_ = g_strdup (child_collection[child_it]);
			child = _tmp58_;
			{
				gchar* child_text = NULL;
				GSettings* _tmp59_;
				const gchar* _tmp60_;
				GSettings* _tmp61_;
				GSettings* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				const gchar* _tmp68_;
				_tmp59_ = settings;
				_tmp60_ = child;
				_tmp61_ = g_settings_get_child (_tmp59_, _tmp60_);
				_tmp62_ = _tmp61_;
				g_object_get (_tmp62_, "schema-id", &_tmp63_, NULL);
				_tmp64_ = _tmp63_;
				_tmp65_ = _tmp64_;
				_tmp66_ = debug_info_get_gsettings (obscurer, _tmp65_);
				_tmp67_ = _tmp66_;
				_g_free0 (_tmp65_);
				_g_object_unref0 (_tmp62_);
				child_text = _tmp67_;
				_tmp68_ = child_text;
				if (_tmp68_ != NULL) {
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					_tmp69_ = text;
					_tmp70_ = child_text;
					_tmp71_ = g_strdup_printf ("\n%s", _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = g_strconcat (_tmp69_, _tmp72_, NULL);
					_g_free0 (text);
					text = _tmp73_;
					_g_free0 (_tmp72_);
					has_content = TRUE;
				}
				_g_free0 (child_text);
				_g_free0 (child);
			}
		}
		child_collection = (_vala_array_free (child_collection, child_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (has_content) {
		result = text;
		_g_object_unref0 (settings);
		return result;
	} else {
		result = NULL;
		_g_free0 (text);
		_g_object_unref0 (settings);
		return result;
	}
}

DebugInfo*
debug_info_construct (GType object_type)
{
	DebugInfo* self = NULL;
	self = (DebugInfo*) g_type_create_instance (object_type);
	return self;
}

DebugInfo*
debug_info_new (void)
{
	return debug_info_construct (TYPE_DEBUG_INFO);
}

static void
value_debug_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_debug_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		debug_info_unref (value->data[0].v_pointer);
	}
}

static void
value_debug_info_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = debug_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_debug_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_debug_info_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DebugInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = debug_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_debug_info_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	DebugInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = debug_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_debug_info (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecDebugInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DEBUG_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_debug_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DEBUG_INFO), NULL);
	return value->data[0].v_pointer;
}

void
value_set_debug_info (GValue* value,
                      gpointer v_object)
{
	DebugInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DEBUG_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DEBUG_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		debug_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		debug_info_unref (old);
	}
}

void
value_take_debug_info (GValue* value,
                       gpointer v_object)
{
	DebugInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DEBUG_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DEBUG_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		debug_info_unref (old);
	}
}

static void
debug_info_class_init (DebugInfoClass * klass,
                       gpointer klass_data)
{
	debug_info_parent_class = g_type_class_peek_parent (klass);
	((DebugInfoClass *) klass)->finalize = debug_info_finalize;
}

static void
debug_info_instance_init (DebugInfo * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
debug_info_finalize (DebugInfo * obj)
{
	DebugInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DEBUG_INFO, DebugInfo);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
debug_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_debug_info_init, value_debug_info_free_value, value_debug_info_copy_value, value_debug_info_peek_pointer, "p", value_debug_info_collect_value, "p", value_debug_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DebugInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) debug_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DebugInfo), 0, (GInstanceInitFunc) debug_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType debug_info_type_id;
	debug_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DebugInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return debug_info_type_id;
}

GType
debug_info_get_type (void)
{
	static gsize debug_info_type_id__once = 0;
	if (g_once_init_enter (&debug_info_type_id__once)) {
		GType debug_info_type_id;
		debug_info_type_id = debug_info_get_type_once ();
		g_once_init_leave (&debug_info_type_id__once, debug_info_type_id);
	}
	return debug_info_type_id__once;
}

gpointer
debug_info_ref (gpointer instance)
{
	DebugInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
debug_info_unref (gpointer instance)
{
	DebugInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DEBUG_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

