// Generated from libavcodec/vulkan/ffv1_vlc.comp
const char *ff_source_ffv1_vlc_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"#define VLC_STATE_SIZE 8\n"
"layout(buffer_reference, buffer_reference_align = VLC_STATE_SIZE) buffer VlcState {\n"
"    uint32_t error_sum;\n"
"    int16_t  drift;\n"
"    int8_t   bias;\n"
"    uint8_t  count;\n"
"};\n"
"\n"
"void update_vlc_state(inout VlcState state, const int v)\n"
"{\n"
"    int drift = state.drift;\n"
"    int count = state.count;\n"
"    int bias = state.bias;\n"
"    state.error_sum += uint16_t(abs(v));\n"
"    drift           += v;\n"
"\n"
"    if (count == 128) { // FIXME: variable\n"
"        count           >>= 1;\n"
"        drift           >>= 1;\n"
"        state.error_sum >>= 1;\n"
"    }\n"
"    count++;\n"
"\n"
"    if (drift <= -count) {\n"
"        bias = max(bias - 1, -128);\n"
"        drift = max(drift + count, -count + 1);\n"
"    } else if (drift > 0) {\n"
"        bias = min(bias + 1, 127);\n"
"        drift = min(drift - count, 0);\n"
"    }\n"
"\n"
"    state.bias = int8_t(bias);\n"
"    state.drift = int16_t(drift);\n"
"    state.count = uint8_t(count);\n"
"}\n"
"\n"
"struct Symbol {\n"
"    uint32_t bits;\n"
"    uint32_t val;\n"
"};\n"
"\n"
"Symbol set_ur_golomb(int i, int k, int limit, int esc_len)\n"
"{\n"
"    int e;\n"
"    Symbol sym;\n"
"\n"
"#ifdef DEBUG\n"
"    if (i < 0)\n"
"        debugPrintfEXT(\"Error: i is zero!\");\n"
"#endif\n"
"\n"
"    e = i >> k;\n"
"    if (e < limit) {\n"
"        sym.bits = e + k + 1;\n"
"        sym.val = (1 << k) + zero_extend(i, k);\n"
"    } else {\n"
"        sym.bits = limit + esc_len;\n"
"        sym.val = i - limit + 1;\n"
"    }\n"
"\n"
"    return sym;\n"
"}\n"
"\n"
"/**\n"
" * write signed golomb rice code (ffv1).\n"
" */\n"
"Symbol set_sr_golomb(int i, int k, int limit, int esc_len)\n"
"{\n"
"    int v;\n"
"\n"
"    v  = -2 * i - 1;\n"
"    v ^= (v >> 31);\n"
"\n"
"    return set_ur_golomb(v, k, limit, esc_len);\n"
"}\n"
"\n"
"Symbol get_vlc_symbol(inout VlcState state, int v, int bits)\n"
"{\n"
"    int i, k, code;\n"
"    Symbol sym;\n"
"    v = fold(v - int(state.bias), bits);\n"
"\n"
"    i = state.count;\n"
"    k = 0;\n"
"    while (i < state.error_sum) { // FIXME: optimize\n"
"        k++;\n"
"        i += i;\n"
"    }\n"
"\n"
"#ifdef DEBUG\n"
"    if (k > 16)\n"
"        debugPrintfEXT(\"Error: k > 16!\");\n"
"#endif\n"
"\n"
"    code = v ^ ((2 * state.drift + state.count) >> 31);\n"
"\n"
"    update_vlc_state(state, v);\n"
"\n"
"    return set_sr_golomb(code, k, 12, bits);\n"
"}\n"
"\n"
"uint get_ur_golomb(inout GetBitContext gb, int k, int limit, int esc_len)\n"
"{\n"
"    for (uint i = 0; i < 12; i++)\n"
"        if (get_bit(gb))\n"
"            return get_bits(gb, k) + (i << k);\n"
"\n"
"    return get_bits(gb, esc_len) + 11;\n"
"}\n"
"\n"
"int get_sr_golomb(inout GetBitContext gb, int k, int limit, int esc_len)\n"
"{\n"
"    int v = int(get_ur_golomb(gb, k, limit, esc_len));\n"
"    return (v >> 1) ^ -(v & 1);\n"
"}\n"
"\n"
"int read_vlc_symbol(inout GetBitContext gb, inout VlcState state, int bits)\n"
"{\n"
"    int k, i, v, ret;\n"
"\n"
"    i = state.count;\n"
"    k = 0;\n"
"    while (i < state.error_sum) { // FIXME: optimize\n"
"        k++;\n"
"        i += i;\n"
"    }\n"
"\n"
"    v = get_sr_golomb(gb, k, 12, bits);\n"
"\n"
"    v ^= ((2 * state.drift + state.count) >> 31);\n"
"\n"
"    ret = fold(v + state.bias, bits);\n"
"\n"
"    update_vlc_state(state, v);\n"
"\n"
"    return ret;\n"
"}\n"
;
