/* PropertyTarget.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PropertyTarget.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include "gala.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_PROPERTY_TARGET_0_PROPERTY,
	GALA_PROPERTY_TARGET_ACTION_PROPERTY,
	GALA_PROPERTY_TARGET_TARGET_PROPERTY,
	GALA_PROPERTY_TARGET_PROPERTY_PROPERTY,
	GALA_PROPERTY_TARGET_INTERVAL_PROPERTY,
	GALA_PROPERTY_TARGET_NUM_PROPERTIES
};
static GParamSpec* gala_property_target_properties[GALA_PROPERTY_TARGET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaPropertyTargetPrivate {
	GalaGestureAction _action;
	GObject* _target;
	gchar* _property;
	ClutterInterval* _interval;
};

static gint GalaPropertyTarget_private_offset;
static gpointer gala_property_target_parent_class = NULL;
static GalaGestureTargetIface * gala_property_target_gala_gesture_target_parent_iface = NULL;

static void gala_property_target_on_target_disposed (GalaPropertyTarget* self);
static void _gala_property_target_on_target_disposed_gweak_notify (gpointer self,
                                                            GObject* object);
static void gala_property_target_set_target (GalaPropertyTarget* self,
                                      GObject* value);
static void gala_property_target_real_propagate (GalaGestureTarget* base,
                                          GalaGestureTargetUpdateType update_type,
                                          GalaGestureAction action,
                                          gdouble progress);
static void gala_property_target_finalize (GObject * obj);
static GType gala_property_target_get_type_once (void);
static void _vala_gala_property_target_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_property_target_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gala_property_target_get_instance_private (GalaPropertyTarget* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPropertyTarget_private_offset);
}

static void
_gala_property_target_on_target_disposed_gweak_notify (gpointer self,
                                                       GObject* object)
{
	gala_property_target_on_target_disposed ((GalaPropertyTarget*) self);
}

GalaPropertyTarget*
gala_property_target_construct (GType object_type,
                                GalaGestureAction action,
                                GObject* target,
                                const gchar* property,
                                GType value_type,
                                GValue* from_value,
                                GValue* to_value)
{
	GalaPropertyTarget * self = NULL;
	GValue _tmp0_;
	GValue _tmp1_;
	ClutterInterval* _tmp2_;
	ClutterInterval* _tmp3_;
	GObject* _tmp4_;
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (property != NULL, NULL);
	g_return_val_if_fail (from_value != NULL, NULL);
	g_return_val_if_fail (to_value != NULL, NULL);
	_tmp0_ = *from_value;
	_tmp1_ = *to_value;
	_tmp2_ = clutter_interval_new_with_values (value_type, &_tmp0_, &_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	self = (GalaPropertyTarget*) g_object_new (object_type, "action", action, "property", property, "interval", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	gala_property_target_set_target (self, target);
	_tmp4_ = self->priv->_target;
	g_object_weak_ref (_tmp4_, _gala_property_target_on_target_disposed_gweak_notify, self);
	return self;
}

GalaPropertyTarget*
gala_property_target_new (GalaGestureAction action,
                          GObject* target,
                          const gchar* property,
                          GType value_type,
                          GValue* from_value,
                          GValue* to_value)
{
	return gala_property_target_construct (GALA_TYPE_PROPERTY_TARGET, action, target, property, value_type, from_value, to_value);
}

static void
gala_property_target_on_target_disposed (GalaPropertyTarget* self)
{
	g_return_if_fail (self != NULL);
	gala_property_target_set_target (self, NULL);
}

static void
gala_property_target_real_propagate (GalaGestureTarget* base,
                                     GalaGestureTargetUpdateType update_type,
                                     GalaGestureAction action,
                                     gdouble progress)
{
	GalaPropertyTarget * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GObject* _tmp2_;
	GObject* _tmp4_;
	const gchar* _tmp5_;
	ClutterInterval* _tmp6_;
	GValue _tmp7_;
	self = (GalaPropertyTarget*) base;
	_tmp2_ = self->priv->_target;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = update_type != GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GalaGestureAction _tmp3_;
		_tmp3_ = self->priv->_action;
		_tmp0_ = action != _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->_target;
	_tmp5_ = self->priv->_property;
	_tmp6_ = self->priv->_interval;
	_tmp7_ = *clutter_interval_compute (_tmp6_, progress);
	g_object_set_property (_tmp4_, _tmp5_, &_tmp7_);
}

GalaGestureAction
gala_property_target_get_action (GalaPropertyTarget* self)
{
	GalaGestureAction result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_action;
	return result;
}

static void
gala_property_target_set_action (GalaPropertyTarget* self,
                                 GalaGestureAction value)
{
	GalaGestureAction old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_property_target_get_action (self);
	if (old_value != value) {
		self->priv->_action = value;
		g_object_notify_by_pspec ((GObject *) self, gala_property_target_properties[GALA_PROPERTY_TARGET_ACTION_PROPERTY]);
	}
}

GObject*
gala_property_target_get_target (GalaPropertyTarget* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target;
	result = _tmp0_;
	return result;
}

static void
gala_property_target_set_target (GalaPropertyTarget* self,
                                 GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_property_target_get_target (self);
	if (old_value != value) {
		self->priv->_target = value;
		g_object_notify_by_pspec ((GObject *) self, gala_property_target_properties[GALA_PROPERTY_TARGET_TARGET_PROPERTY]);
	}
}

const gchar*
gala_property_target_get_property (GalaPropertyTarget* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_property;
	result = _tmp0_;
	return result;
}

static void
gala_property_target_set_property (GalaPropertyTarget* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_property_target_get_property (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_property);
		self->priv->_property = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_property_target_properties[GALA_PROPERTY_TARGET_PROPERTY_PROPERTY]);
	}
}

ClutterInterval*
gala_property_target_get_interval (GalaPropertyTarget* self)
{
	ClutterInterval* result;
	ClutterInterval* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interval;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_property_target_set_interval (GalaPropertyTarget* self,
                                   ClutterInterval* value)
{
	ClutterInterval* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_property_target_get_interval (self);
	if (old_value != value) {
		ClutterInterval* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_interval);
		self->priv->_interval = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_property_target_properties[GALA_PROPERTY_TARGET_INTERVAL_PROPERTY]);
	}
}

static void
gala_property_target_class_init (GalaPropertyTargetClass * klass,
                                 gpointer klass_data)
{
	gala_property_target_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPropertyTarget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_property_target_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_property_target_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_property_target_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PROPERTY_TARGET_ACTION_PROPERTY, gala_property_target_properties[GALA_PROPERTY_TARGET_ACTION_PROPERTY] = g_param_spec_enum ("action", "action", "action", GALA_TYPE_GESTURE_ACTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PROPERTY_TARGET_TARGET_PROPERTY, gala_property_target_properties[GALA_PROPERTY_TARGET_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PROPERTY_TARGET_PROPERTY_PROPERTY, gala_property_target_properties[GALA_PROPERTY_TARGET_PROPERTY_PROPERTY] = g_param_spec_string ("property", "property", "property", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PROPERTY_TARGET_INTERVAL_PROPERTY, gala_property_target_properties[GALA_PROPERTY_TARGET_INTERVAL_PROPERTY] = g_param_spec_object ("interval", "interval", "interval", clutter_interval_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_property_target_gala_gesture_target_interface_init (GalaGestureTargetIface * iface,
                                                         gpointer iface_data)
{
	gala_property_target_gala_gesture_target_parent_iface = g_type_interface_peek_parent (iface);
	iface->propagate = (void (*) (GalaGestureTarget*, GalaGestureTargetUpdateType, GalaGestureAction, gdouble)) gala_property_target_real_propagate;
}

static void
gala_property_target_instance_init (GalaPropertyTarget * self,
                                    gpointer klass)
{
	self->priv = gala_property_target_get_instance_private (self);
}

static void
gala_property_target_finalize (GObject * obj)
{
	GalaPropertyTarget * self;
	GObject* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PROPERTY_TARGET, GalaPropertyTarget);
	_tmp0_ = self->priv->_target;
	if (_tmp0_ != NULL) {
		GObject* _tmp1_;
		_tmp1_ = self->priv->_target;
		g_object_weak_unref (_tmp1_, _gala_property_target_on_target_disposed_gweak_notify, self);
	}
	_g_free0 (self->priv->_property);
	_g_object_unref0 (self->priv->_interval);
	G_OBJECT_CLASS (gala_property_target_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_property_target_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPropertyTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_property_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPropertyTarget), 0, (GInstanceInitFunc) gala_property_target_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_target_info = { (GInterfaceInitFunc) gala_property_target_gala_gesture_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_property_target_type_id;
	gala_property_target_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaPropertyTarget", &g_define_type_info, 0);
	g_type_add_interface_static (gala_property_target_type_id, GALA_TYPE_GESTURE_TARGET, &gala_gesture_target_info);
	GalaPropertyTarget_private_offset = g_type_add_instance_private (gala_property_target_type_id, sizeof (GalaPropertyTargetPrivate));
	return gala_property_target_type_id;
}

GType
gala_property_target_get_type (void)
{
	static gsize gala_property_target_type_id__once = 0;
	if (g_once_init_enter (&gala_property_target_type_id__once)) {
		GType gala_property_target_type_id;
		gala_property_target_type_id = gala_property_target_get_type_once ();
		g_once_init_leave (&gala_property_target_type_id__once, gala_property_target_type_id);
	}
	return gala_property_target_type_id__once;
}

static void
_vala_gala_property_target_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaPropertyTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PROPERTY_TARGET, GalaPropertyTarget);
	switch (property_id) {
		case GALA_PROPERTY_TARGET_ACTION_PROPERTY:
		g_value_set_enum (value, gala_property_target_get_action (self));
		break;
		case GALA_PROPERTY_TARGET_TARGET_PROPERTY:
		g_value_set_object (value, gala_property_target_get_target (self));
		break;
		case GALA_PROPERTY_TARGET_PROPERTY_PROPERTY:
		g_value_set_string (value, gala_property_target_get_property (self));
		break;
		case GALA_PROPERTY_TARGET_INTERVAL_PROPERTY:
		g_value_set_object (value, gala_property_target_get_interval (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_property_target_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaPropertyTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PROPERTY_TARGET, GalaPropertyTarget);
	switch (property_id) {
		case GALA_PROPERTY_TARGET_ACTION_PROPERTY:
		gala_property_target_set_action (self, g_value_get_enum (value));
		break;
		case GALA_PROPERTY_TARGET_TARGET_PROPERTY:
		gala_property_target_set_target (self, g_value_get_object (value));
		break;
		case GALA_PROPERTY_TARGET_PROPERTY_PROPERTY:
		gala_property_target_set_property (self, g_value_get_string (value));
		break;
		case GALA_PROPERTY_TARGET_INTERVAL_PROPERTY:
		gala_property_target_set_interval (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

