/* ShadowEffect.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ShadowEffect.vala, do not modify */

/*
 * Copyright 2014 Tom Beckmann
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#define _GNU_SOURCE

#include "gala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cogl/cogl.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <glib-object.h>
#include <graphene-gobject.h>
#include <gobject/gvaluecollector.h>

#define GALA_SHADOW_EFFECT_INITIAL_OPACITY 0.25f
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_SHADOW_EFFECT_0_PROPERTY,
	GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY,
	GALA_SHADOW_EFFECT_MONITOR_SCALE_PROPERTY,
	GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY,
	GALA_SHADOW_EFFECT_BORDER_RADIUS_PROPERTY,
	GALA_SHADOW_EFFECT_NUM_PROPERTIES
};
static GParamSpec* gala_shadow_effect_properties[GALA_SHADOW_EFFECT_NUM_PROPERTIES];

#define GALA_SHADOW_EFFECT_TYPE_SHADOW (gala_shadow_effect_shadow_get_type ())
#define GALA_SHADOW_EFFECT_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadow))
#define GALA_SHADOW_EFFECT_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadowClass))
#define GALA_SHADOW_EFFECT_IS_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_SHADOW_EFFECT_TYPE_SHADOW))
#define GALA_SHADOW_EFFECT_IS_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_SHADOW_EFFECT_TYPE_SHADOW))
#define GALA_SHADOW_EFFECT_SHADOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadowClass))

typedef struct _GalaShadowEffectShadow GalaShadowEffectShadow;
typedef struct _GalaShadowEffectShadowClass GalaShadowEffectShadowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GalaShadowEffectShadowPrivate GalaShadowEffectShadowPrivate;
#define _gala_shadow_effect_shadow_unref0(var) ((var == NULL) ? NULL : (var = (gala_shadow_effect_shadow_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _GalaShadowEffectParamSpecShadow GalaShadowEffectParamSpecShadow;

struct _GalaShadowEffectPrivate {
	gchar* _css_class;
	gfloat _monitor_scale;
	guint8 _shadow_opacity;
	gint _border_radius;
	gint shadow_size;
	CoglPipeline* pipeline;
	gchar* current_key;
};

struct _GalaShadowEffectShadow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaShadowEffectShadowPrivate * priv;
	gint users;
	CoglTexture* texture;
};

struct _GalaShadowEffectShadowClass {
	GTypeClass parent_class;
	void (*finalize) (GalaShadowEffectShadow *self);
};

struct _Block4Data {
	int _ref_count_;
	gchar* key;
};

struct _GalaShadowEffectParamSpecShadow {
	GParamSpec parent_instance;
};

static gint GalaShadowEffect_private_offset;
static gpointer gala_shadow_effect_parent_class = NULL;
static GeeHashMap* gala_shadow_effect_shadow_cache;
static GeeHashMap* gala_shadow_effect_shadow_cache = NULL;
static GeeHashMap* gala_shadow_effect_shadows_marked_for_dropping;
static GeeHashMap* gala_shadow_effect_shadows_marked_for_dropping = NULL;
static gpointer gala_shadow_effect_shadow_parent_class = NULL;

static void gala_shadow_effect_decrement_shadow_users (const gchar* key);
static gpointer gala_shadow_effect_shadow_ref (gpointer instance);
static void gala_shadow_effect_shadow_unref (gpointer instance);
static GParamSpec* gala_shadow_effect_param_spec_shadow (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void gala_shadow_effect_value_set_shadow (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static void gala_shadow_effect_value_take_shadow (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer gala_shadow_effect_value_get_shadow (const GValue* value) G_GNUC_UNUSED ;
static GType gala_shadow_effect_shadow_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void gala_shadow_effect_real_set_actor (ClutterActorMeta* base,
                                        ClutterActor* actor);
static CoglTexture* gala_shadow_effect_get_shadow (GalaShadowEffect* self,
                                            CoglContext* context,
                                            gint width,
                                            gint height,
                                            gint shadow_size,
                                            gint border_radius);
static void gala_shadow_effect_increment_shadow_users (const gchar* key);
static CoglTexture* gala_shadow_effect_get_shadow_texture (GalaShadowEffect* self,
                                                    CoglContext* context,
                                                    gint width,
                                                    gint height,
                                                    gint shadow_size,
                                                    gint corner_radius);
static GalaShadowEffectShadow* gala_shadow_effect_shadow_new (CoglTexture* _texture);
static GalaShadowEffectShadow* gala_shadow_effect_shadow_construct (GType object_type,
                                                             CoglTexture* _texture);
static void gala_shadow_effect_real_paint (ClutterEffect* base,
                                    ClutterPaintNode* node,
                                    ClutterPaintContext* context,
                                    ClutterEffectPaintFlags flags);
static void gala_shadow_effect_get_bounding_box (GalaShadowEffect* self,
                                          ClutterActorBox* result);
static gboolean gala_shadow_effect_real_modify_paint_volume (ClutterEffect* base,
                                                      ClutterPaintVolume* volume);
static void gala_shadow_effect_queue_shadow_drop (const gchar* key);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda22_ (Block4Data* _data4_);
static gboolean ___lambda22__gsource_func (gpointer self);
static void gala_shadow_effect_shadow_finalize (GalaShadowEffectShadow * obj);
static GType gala_shadow_effect_shadow_get_type_once (void);
static void gala_shadow_effect_finalize (GObject * obj);
static GType gala_shadow_effect_get_type_once (void);
static void _vala_gala_shadow_effect_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gala_shadow_effect_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
gala_shadow_effect_get_instance_private (GalaShadowEffect* self)
{
	return G_STRUCT_MEMBER_P (self, GalaShadowEffect_private_offset);
}

GalaShadowEffect*
gala_shadow_effect_construct (GType object_type,
                              const gchar* css_class,
                              gfloat monitor_scale)
{
	GalaShadowEffect * self = NULL;
	g_return_val_if_fail (css_class != NULL, NULL);
	self = (GalaShadowEffect*) g_object_new (object_type, "css-class", css_class, "monitor-scale", monitor_scale, NULL);
	return self;
}

GalaShadowEffect*
gala_shadow_effect_new (const gchar* css_class,
                        gfloat monitor_scale)
{
	return gala_shadow_effect_construct (GALA_TYPE_SHADOW_EFFECT, css_class, monitor_scale);
}

static void
gala_shadow_effect_real_set_actor (ClutterActorMeta* base,
                                   ClutterActor* actor)
{
	GalaShadowEffect * self;
	self = (GalaShadowEffect*) base;
	CLUTTER_ACTOR_META_CLASS (gala_shadow_effect_parent_class)->set_actor ((ClutterActorMeta*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_effect_get_type (), ClutterEffect), actor);
	if (actor != NULL) {
		ClutterBackend* _tmp0_;
		CoglContext* _tmp1_;
		CoglPipeline* _tmp2_;
		_tmp0_ = clutter_get_default_backend ();
		_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
		_tmp2_ = cogl_pipeline_new (_tmp1_);
		_g_object_unref0 (self->priv->pipeline);
		self->priv->pipeline = _tmp2_;
	} else {
		_g_object_unref0 (self->priv->pipeline);
		self->priv->pipeline = NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static CoglTexture*
gala_shadow_effect_get_shadow (GalaShadowEffect* self,
                               CoglContext* context,
                               gint width,
                               gint height,
                               gint shadow_size,
                               gint border_radius)
{
	gchar* old_key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GalaShadowEffectShadow* shadow = NULL;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	gpointer _tmp9_;
	GalaShadowEffectShadow* _tmp10_;
	CoglTexture* texture = NULL;
	CoglTexture* _tmp15_;
	CoglTexture* _tmp16_;
	CoglTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = self->priv->current_key;
	_tmp1_ = g_strdup (_tmp0_);
	old_key = _tmp1_;
	_tmp2_ = g_strdup_printf ("%ix%i:%i:%i", width, height, shadow_size, border_radius);
	_g_free0 (self->priv->current_key);
	self->priv->current_key = _tmp2_;
	_tmp3_ = old_key;
	_tmp4_ = self->priv->current_key;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		result = NULL;
		_g_free0 (old_key);
		return result;
	}
	_tmp5_ = old_key;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = old_key;
		gala_shadow_effect_decrement_shadow_users (_tmp6_);
	}
	_tmp7_ = gala_shadow_effect_shadow_cache;
	_tmp8_ = self->priv->current_key;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
	shadow = (GalaShadowEffectShadow*) _tmp9_;
	_tmp10_ = shadow;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		GalaShadowEffectShadow* _tmp12_;
		CoglTexture* _tmp13_;
		CoglTexture* _tmp14_;
		_tmp11_ = self->priv->current_key;
		gala_shadow_effect_increment_shadow_users (_tmp11_);
		_tmp12_ = shadow;
		_tmp13_ = _tmp12_->texture;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		result = _tmp14_;
		_gala_shadow_effect_shadow_unref0 (shadow);
		_g_free0 (old_key);
		return result;
	}
	_tmp15_ = gala_shadow_effect_get_shadow_texture (self, context, width, height, shadow_size, border_radius);
	texture = _tmp15_;
	_tmp16_ = texture;
	if (_tmp16_ != NULL) {
		GeeHashMap* _tmp17_;
		const gchar* _tmp18_;
		CoglTexture* _tmp19_;
		GalaShadowEffectShadow* _tmp20_;
		GalaShadowEffectShadow* _tmp21_;
		_tmp17_ = gala_shadow_effect_shadow_cache;
		_tmp18_ = self->priv->current_key;
		_tmp19_ = texture;
		_tmp20_ = gala_shadow_effect_shadow_new (_tmp19_);
		_tmp21_ = _tmp20_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp18_, _tmp21_);
		_gala_shadow_effect_shadow_unref0 (_tmp21_);
	}
	result = texture;
	_gala_shadow_effect_shadow_unref0 (shadow);
	_g_free0 (old_key);
	return result;
}

static void
gala_shadow_effect_real_paint (ClutterEffect* base,
                               ClutterPaintNode* node,
                               ClutterPaintContext* context,
                               ClutterEffectPaintFlags flags)
{
	GalaShadowEffect * self;
	ClutterActorBox bounding_box = {0};
	ClutterActorBox _tmp0_ = {0};
	gint width = 0;
	ClutterActorBox _tmp1_;
	ClutterActorBox _tmp2_;
	gint height = 0;
	ClutterActorBox _tmp3_;
	ClutterActorBox _tmp4_;
	CoglTexture* shadow = NULL;
	CoglFramebuffer* _tmp5_;
	CoglContext* _tmp6_;
	gfloat _tmp7_;
	gint _tmp8_;
	gfloat _tmp9_;
	CoglTexture* _tmp10_;
	CoglTexture* _tmp11_;
	gfloat opacity = 0.0F;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	guint8 _tmp16_;
	CoglColor alpha = {0};
	CoglPipeline* _tmp17_;
	CoglColor _tmp18_;
	CoglFramebuffer* _tmp19_;
	CoglPipeline* _tmp20_;
	ClutterActorBox _tmp21_;
	ClutterActorBox _tmp22_;
	ClutterActorBox _tmp23_;
	ClutterActorBox _tmp24_;
	ClutterActor* _tmp25_;
	ClutterActor* _tmp26_;
	self = (GalaShadowEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (context != NULL);
	gala_shadow_effect_get_bounding_box (self, &_tmp0_);
	bounding_box = _tmp0_;
	_tmp1_ = bounding_box;
	_tmp2_ = bounding_box;
	width = (gint) (_tmp1_.x2 - _tmp2_.x1);
	_tmp3_ = bounding_box;
	_tmp4_ = bounding_box;
	height = (gint) (_tmp3_.y2 - _tmp4_.y1);
	_tmp5_ = clutter_paint_context_get_framebuffer (context);
	_tmp6_ = cogl_framebuffer_get_context (_tmp5_);
	_tmp7_ = self->priv->_monitor_scale;
	_tmp8_ = self->priv->_border_radius;
	_tmp9_ = self->priv->_monitor_scale;
	_tmp10_ = gala_shadow_effect_get_shadow (self, _tmp6_, width, height, gala_utils_scale_to_int (self->priv->shadow_size, _tmp7_), gala_utils_scale_to_int (_tmp8_, _tmp9_));
	shadow = _tmp10_;
	_tmp11_ = shadow;
	if (_tmp11_ != NULL) {
		CoglPipeline* _tmp12_;
		CoglTexture* _tmp13_;
		_tmp12_ = self->priv->pipeline;
		_tmp13_ = shadow;
		cogl_pipeline_set_layer_texture (_tmp12_, 0, _tmp13_);
	}
	_tmp14_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->_shadow_opacity;
	opacity = (((clutter_actor_get_paint_opacity (_tmp15_) * _tmp16_) * GALA_SHADOW_EFFECT_INITIAL_OPACITY) / 255.0f) / 255.0f;
	cogl_color_init_from_4f (&alpha, 1.0f, 1.0f, 1.0f, opacity);
	cogl_color_premultiply (&alpha);
	_tmp17_ = self->priv->pipeline;
	_tmp18_ = alpha;
	cogl_pipeline_set_color (_tmp17_, &_tmp18_);
	_tmp19_ = clutter_paint_context_get_framebuffer (context);
	_tmp20_ = self->priv->pipeline;
	_tmp21_ = bounding_box;
	_tmp22_ = bounding_box;
	_tmp23_ = bounding_box;
	_tmp24_ = bounding_box;
	cogl_framebuffer_draw_rectangle (_tmp19_, _tmp20_, _tmp21_.x1, _tmp22_.y1, _tmp23_.x2, _tmp24_.y2);
	_tmp25_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp26_ = _tmp25_;
	clutter_actor_continue_paint (_tmp26_, context);
	_g_object_unref0 (shadow);
}

static void
gala_shadow_effect_get_bounding_box (GalaShadowEffect* self,
                                     ClutterActorBox* result)
{
	gint size = 0;
	gfloat _tmp0_;
	ClutterActorBox bounding_box = {0};
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitor_scale;
	size = gala_utils_scale_to_int (self->priv->shadow_size, _tmp0_);
	memset (&bounding_box, 0, sizeof (ClutterActorBox));
	clutter_actor_box_set_origin (&bounding_box, (gfloat) (-size), (gfloat) (-size));
	_tmp1_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = clutter_actor_get_width (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = clutter_actor_get_height (_tmp6_);
	_tmp8_ = _tmp7_;
	clutter_actor_box_set_size (&bounding_box, _tmp4_ + (size * 2), _tmp8_ + (size * 2));
	*result = bounding_box;
	return;
}

static gboolean
gala_shadow_effect_real_modify_paint_volume (ClutterEffect* base,
                                             ClutterPaintVolume* volume)
{
	GalaShadowEffect * self;
	ClutterActorBox bounding_box = {0};
	ClutterActorBox _tmp0_ = {0};
	gfloat origin_x = 0.0F;
	gfloat origin_y = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	graphene_point3d_t origin = {0};
	graphene_point3d_t _tmp3_ = {0};
	graphene_point3d_t _tmp4_;
	gboolean result;
	self = (GalaShadowEffect*) base;
	g_return_val_if_fail (volume != NULL, FALSE);
	gala_shadow_effect_get_bounding_box (self, &_tmp0_);
	bounding_box = _tmp0_;
	clutter_paint_volume_set_width (volume, clutter_actor_box_get_width (&bounding_box));
	clutter_paint_volume_set_height (volume, clutter_actor_box_get_height (&bounding_box));
	clutter_actor_box_get_origin (&bounding_box, &_tmp1_, &_tmp2_);
	origin_x = _tmp1_;
	origin_y = _tmp2_;
	clutter_paint_volume_get_origin (volume, &_tmp3_);
	origin = _tmp3_;
	origin.x = origin.x + origin_x;
	origin.y = origin.y + origin_y;
	_tmp4_ = origin;
	clutter_paint_volume_set_origin (volume, &_tmp4_);
	result = TRUE;
	return result;
}

static void
gala_shadow_effect_increment_shadow_users (const gchar* key)
{
	GalaShadowEffectShadow* shadow = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GalaShadowEffectShadow* _tmp2_;
	GalaShadowEffectShadow* _tmp3_;
	gint _tmp4_;
	guint timeout_id = 0U;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_ = NULL;
	gboolean _tmp7_;
	g_return_if_fail (key != NULL);
	_tmp0_ = gala_shadow_effect_shadow_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	shadow = (GalaShadowEffectShadow*) _tmp1_;
	_tmp2_ = shadow;
	if (_tmp2_ == NULL) {
		_gala_shadow_effect_shadow_unref0 (shadow);
		return;
	}
	_tmp3_ = shadow;
	_tmp4_ = _tmp3_->users;
	_tmp3_->users = _tmp4_ + 1;
	_tmp5_ = gala_shadow_effect_shadows_marked_for_dropping;
	_tmp7_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, key, &_tmp6_);
	timeout_id = (guint) ((guintptr) _tmp6_);
	if (_tmp7_) {
		g_source_remove (timeout_id);
	}
	_gala_shadow_effect_shadow_unref0 (shadow);
}

static void
gala_shadow_effect_decrement_shadow_users (const gchar* key)
{
	GalaShadowEffectShadow* shadow = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GalaShadowEffectShadow* _tmp2_;
	GalaShadowEffectShadow* _tmp3_;
	gint _tmp4_;
	g_return_if_fail (key != NULL);
	_tmp0_ = gala_shadow_effect_shadow_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	shadow = (GalaShadowEffectShadow*) _tmp1_;
	_tmp2_ = shadow;
	if (_tmp2_ == NULL) {
		_gala_shadow_effect_shadow_unref0 (shadow);
		return;
	}
	_tmp3_ = shadow;
	_tmp3_->users = _tmp3_->users - 1;
	_tmp4_ = _tmp3_->users;
	if (_tmp4_ == 0) {
		gala_shadow_effect_queue_shadow_drop (key);
	}
	_gala_shadow_effect_shadow_unref0 (shadow);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_free0 (_data4_->key);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda22_ (Block4Data* _data4_)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gboolean result;
	_tmp0_ = gala_shadow_effect_shadow_cache;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _data4_->key, NULL);
	_tmp1_ = gala_shadow_effect_shadows_marked_for_dropping;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, _data4_->key, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda22__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda22_ (self);
	return result;
}

static void
gala_shadow_effect_queue_shadow_drop (const gchar* key)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (key != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = g_strdup (key);
	_g_free0 (_data4_->key);
	_data4_->key = _tmp0_;
	_tmp1_ = gala_shadow_effect_shadows_marked_for_dropping;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _data4_->key, (gpointer) ((guintptr) g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda22__gsource_func, block4_data_ref (_data4_), block4_data_unref)));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static CoglTexture*
gala_shadow_effect_get_shadow_texture (GalaShadowEffect* self,
                                       CoglContext* context,
                                       gint width,
                                       gint height,
                                       gint shadow_size,
                                       gint corner_radius)
{
	guint8* data = NULL;
	guint8* _tmp0_;
	gint data_length1;
	gint _data_size_;
	guint8* precomputed_colors = NULL;
	guint8* _tmp1_;
	gint precomputed_colors_length1;
	gint _precomputed_colors_size_;
	gint total_offset = 0;
	gint target_row = 0;
	gint target_col = 0;
	gint target_square = 0;
	GError* _inner_error0_ = NULL;
	CoglTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = g_new0 (guint8, width * height);
	data = _tmp0_;
	data_length1 = width * height;
	_data_size_ = data_length1;
	_tmp1_ = g_new0 (guint8, shadow_size + 1);
	precomputed_colors = _tmp1_;
	precomputed_colors_length1 = shadow_size + 1;
	_precomputed_colors_size_ = precomputed_colors_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gdouble normalized = 0.0;
				guint8* _tmp4_;
				gint _tmp4__length1;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i <= shadow_size)) {
					break;
				}
				normalized = ((gdouble) i) / shadow_size;
				_tmp4_ = precomputed_colors;
				_tmp4__length1 = precomputed_colors_length1;
				_tmp4_[i] = (guint8) (((normalized * normalized) * (3.0 - (2.0 * normalized))) * 255.0);
			}
		}
	}
	total_offset = shadow_size + corner_radius;
	target_row = height - total_offset;
	{
		gint row = 0;
		row = total_offset;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint current_row = 0;
				gint current_row_end = 0;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = row;
					row = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(row < target_row)) {
					break;
				}
				current_row = row * width;
				current_row_end = (current_row + width) - 1;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							guint8 current_color = 0U;
							guint8* _tmp9_;
							gint _tmp9__length1;
							guint8 _tmp10_;
							guint8* _tmp11_;
							gint _tmp11__length1;
							guint8* _tmp12_;
							gint _tmp12__length1;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = i;
								i = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							if (!(i <= shadow_size)) {
								break;
							}
							_tmp9_ = precomputed_colors;
							_tmp9__length1 = precomputed_colors_length1;
							_tmp10_ = _tmp9_[i];
							current_color = _tmp10_;
							_tmp11_ = data;
							_tmp11__length1 = data_length1;
							_tmp11_[current_row + i] = current_color;
							_tmp12_ = data;
							_tmp12__length1 = data_length1;
							_tmp12_[current_row_end - i] = current_color;
						}
					}
				}
			}
		}
	}
	target_col = width - total_offset;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint current_row = 0;
				gint end_row = 0;
				guint8 current_color = 0U;
				guint8* _tmp15_;
				gint _tmp15__length1;
				guint8 _tmp16_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = row;
					row = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				if (!(row <= shadow_size)) {
					break;
				}
				current_row = row * width;
				end_row = ((height - row) * width) - 1;
				_tmp15_ = precomputed_colors;
				_tmp15__length1 = precomputed_colors_length1;
				_tmp16_ = _tmp15_[row];
				current_color = _tmp16_;
				{
					gint col = 0;
					col = total_offset;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							guint8* _tmp19_;
							gint _tmp19__length1;
							guint8* _tmp20_;
							gint _tmp20__length1;
							if (!_tmp17_) {
								gint _tmp18_;
								_tmp18_ = col;
								col = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							if (!(col < target_col)) {
								break;
							}
							_tmp19_ = data;
							_tmp19__length1 = data_length1;
							_tmp19_[current_row + col] = current_color;
							_tmp20_ = data;
							_tmp20__length1 = data_length1;
							_tmp20_[end_row - col] = current_color;
						}
					}
				}
			}
		}
	}
	target_square = shadow_size + corner_radius;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint current_row = 0;
				gint current_row_end = 0;
				gint end_row = 0;
				gint end_row_end = 0;
				gint dy = 0;
				gint dy_squared = 0;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = y;
					y = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(y < target_square)) {
					break;
				}
				current_row = width * y;
				current_row_end = (current_row + width) - 1;
				end_row = ((height - 1) - y) * width;
				end_row_end = (end_row + width) - 1;
				dy = target_square - y;
				dy_squared = dy * dy;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gint dx = 0;
							gint squared_distance = 0;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = x;
								x = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							if (!(x < target_square)) {
								break;
							}
							dx = target_square - x;
							squared_distance = (dx * dx) + dy_squared;
							if (squared_distance > (target_square * target_square)) {
								continue;
							}
							if (squared_distance >= (corner_radius * corner_radius)) {
								gdouble sin = 0.0;
								gdouble cos = 0.0;
								gdouble _tmp25_ = 0.0;
								gdouble _tmp26_ = 0.0;
								gdouble real_dx = 0.0;
								gdouble real_dy = 0.0;
								gdouble normalized = 0.0;
								guint8 current_color = 0U;
								guint8* _tmp27_;
								gint _tmp27__length1;
								guint8* _tmp28_;
								gint _tmp28__length1;
								guint8* _tmp29_;
								gint _tmp29__length1;
								guint8* _tmp30_;
								gint _tmp30__length1;
								sincos (atan2 ((gdouble) dy, (gdouble) dx), &_tmp25_, &_tmp26_);
								sin = _tmp25_;
								cos = _tmp26_;
								real_dx = dx - (corner_radius * cos);
								real_dy = dy - (corner_radius * sin);
								normalized = ((gdouble) sqrt ((real_dx * real_dx) + (real_dy * real_dy))) / shadow_size;
								current_color = (guint8) (1.0 - (((normalized * normalized) * (3.0 - (2.0 * normalized))) * 255.0));
								if (((gint) current_color) == 0) {
									current_color = (guint8) 255;
								}
								_tmp27_ = data;
								_tmp27__length1 = data_length1;
								_tmp27_[current_row + x] = current_color;
								_tmp28_ = data;
								_tmp28__length1 = data_length1;
								_tmp28_[current_row_end - x] = current_color;
								_tmp29_ = data;
								_tmp29__length1 = data_length1;
								_tmp29_[end_row + x] = current_color;
								_tmp30_ = data;
								_tmp30__length1 = data_length1;
								_tmp30_[end_row_end - x] = current_color;
							}
						}
					}
				}
			}
		}
	}
	{
		CoglTexture2D* _tmp31_ = NULL;
		guint8* _tmp32_;
		gint _tmp32__length1;
		CoglTexture2D* _tmp33_;
		CoglTexture2D* _tmp34_;
		_tmp32_ = data;
		_tmp32__length1 = data_length1;
		_tmp33_ = (CoglTexture2D*) cogl_texture_2d_new_from_data (context, width, height, COGL_PIXEL_FORMAT_A_8, width, _tmp32_, &_inner_error0_);
		_tmp31_ = _tmp33_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp34_ = _tmp31_;
		_tmp31_ = NULL;
		result = (CoglTexture*) _tmp34_;
		_g_object_unref0 (_tmp31_);
		precomputed_colors = (g_free (precomputed_colors), NULL);
		data = (g_free (data), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("ShadowEffect.vala:277: ShadowEffect: Couldn't create texture");
		result = NULL;
		precomputed_colors = (g_free (precomputed_colors), NULL);
		data = (g_free (data), NULL);
		return result;
	}
	__finally0:
	precomputed_colors = (g_free (precomputed_colors), NULL);
	data = (g_free (data), NULL);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

const gchar*
gala_shadow_effect_get_css_class (GalaShadowEffect* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_css_class;
	result = _tmp0_;
	return result;
}

void
gala_shadow_effect_set_css_class (GalaShadowEffect* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_css_class);
	self->priv->_css_class = _tmp0_;
	_tmp1_ = value;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("workspace-switcher")))) {
		switch (0) {
			default:
			{
				self->priv->shadow_size = 3;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("window")))) {
		switch (0) {
			default:
			{
				self->priv->shadow_size = 26;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				self->priv->shadow_size = 9;
				break;
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY]);
}

gfloat
gala_shadow_effect_get_monitor_scale (GalaShadowEffect* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_shadow_effect_set_monitor_scale (GalaShadowEffect* self,
                                      gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shadow_effect_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_MONITOR_SCALE_PROPERTY]);
	}
}

guint8
gala_shadow_effect_get_shadow_opacity (GalaShadowEffect* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_shadow_opacity;
	return result;
}

void
gala_shadow_effect_set_shadow_opacity (GalaShadowEffect* self,
                                       guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shadow_effect_get_shadow_opacity (self);
	if (old_value != value) {
		self->priv->_shadow_opacity = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY]);
	}
}

gint
gala_shadow_effect_get_border_radius (GalaShadowEffect* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_border_radius;
	return result;
}

void
gala_shadow_effect_set_border_radius (GalaShadowEffect* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shadow_effect_get_border_radius (self);
	if (old_value != value) {
		self->priv->_border_radius = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_BORDER_RADIUS_PROPERTY]);
	}
}

static GalaShadowEffectShadow*
gala_shadow_effect_shadow_construct (GType object_type,
                                     CoglTexture* _texture)
{
	GalaShadowEffectShadow* self = NULL;
	CoglTexture* _tmp0_;
	g_return_val_if_fail (_texture != NULL, NULL);
	self = (GalaShadowEffectShadow*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (_texture);
	_g_object_unref0 (self->texture);
	self->texture = _tmp0_;
	self->users = 1;
	return self;
}

static GalaShadowEffectShadow*
gala_shadow_effect_shadow_new (CoglTexture* _texture)
{
	return gala_shadow_effect_shadow_construct (GALA_SHADOW_EFFECT_TYPE_SHADOW, _texture);
}

static void
gala_shadow_effect_value_shadow_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_shadow_effect_value_shadow_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_shadow_effect_shadow_unref (value->data[0].v_pointer);
	}
}

static void
gala_shadow_effect_value_shadow_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_shadow_effect_shadow_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_shadow_effect_value_shadow_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_shadow_effect_value_shadow_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaShadowEffectShadow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_shadow_effect_shadow_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_shadow_effect_value_shadow_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	GalaShadowEffectShadow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_shadow_effect_shadow_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gala_shadow_effect_param_spec_shadow (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	GalaShadowEffectParamSpecShadow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_SHADOW_EFFECT_TYPE_SHADOW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gala_shadow_effect_value_get_shadow (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_SHADOW_EFFECT_TYPE_SHADOW), NULL);
	return value->data[0].v_pointer;
}

static void
gala_shadow_effect_value_set_shadow (GValue* value,
                                     gpointer v_object)
{
	GalaShadowEffectShadow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_SHADOW_EFFECT_TYPE_SHADOW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_SHADOW_EFFECT_TYPE_SHADOW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_shadow_effect_shadow_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_shadow_effect_shadow_unref (old);
	}
}

static void
gala_shadow_effect_value_take_shadow (GValue* value,
                                      gpointer v_object)
{
	GalaShadowEffectShadow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_SHADOW_EFFECT_TYPE_SHADOW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_SHADOW_EFFECT_TYPE_SHADOW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_shadow_effect_shadow_unref (old);
	}
}

static void
gala_shadow_effect_shadow_class_init (GalaShadowEffectShadowClass * klass,
                                      gpointer klass_data)
{
	gala_shadow_effect_shadow_parent_class = g_type_class_peek_parent (klass);
	((GalaShadowEffectShadowClass *) klass)->finalize = gala_shadow_effect_shadow_finalize;
}

static void
gala_shadow_effect_shadow_instance_init (GalaShadowEffectShadow * self,
                                         gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_shadow_effect_shadow_finalize (GalaShadowEffectShadow * obj)
{
	GalaShadowEffectShadow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadow);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->texture);
}

 G_GNUC_NO_INLINE static GType
gala_shadow_effect_shadow_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_shadow_effect_value_shadow_init, gala_shadow_effect_value_shadow_free_value, gala_shadow_effect_value_shadow_copy_value, gala_shadow_effect_value_shadow_peek_pointer, "p", gala_shadow_effect_value_shadow_collect_value, "p", gala_shadow_effect_value_shadow_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaShadowEffectShadowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_shadow_effect_shadow_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaShadowEffectShadow), 0, (GInstanceInitFunc) gala_shadow_effect_shadow_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_shadow_effect_shadow_type_id;
	gala_shadow_effect_shadow_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaShadowEffectShadow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_shadow_effect_shadow_type_id;
}

static GType
gala_shadow_effect_shadow_get_type (void)
{
	static gsize gala_shadow_effect_shadow_type_id__once = 0;
	if (g_once_init_enter (&gala_shadow_effect_shadow_type_id__once)) {
		GType gala_shadow_effect_shadow_type_id;
		gala_shadow_effect_shadow_type_id = gala_shadow_effect_shadow_get_type_once ();
		g_once_init_leave (&gala_shadow_effect_shadow_type_id__once, gala_shadow_effect_shadow_type_id);
	}
	return gala_shadow_effect_shadow_type_id__once;
}

static gpointer
gala_shadow_effect_shadow_ref (gpointer instance)
{
	GalaShadowEffectShadow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gala_shadow_effect_shadow_unref (gpointer instance)
{
	GalaShadowEffectShadow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_SHADOW_EFFECT_SHADOW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
gala_shadow_effect_class_init (GalaShadowEffectClass * klass,
                               gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gala_shadow_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaShadowEffect_private_offset);
	((ClutterActorMetaClass *) klass)->set_actor = (void (*) (ClutterActorMeta*, ClutterActor*)) gala_shadow_effect_real_set_actor;
	((ClutterEffectClass *) klass)->paint = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*, ClutterEffectPaintFlags)) gala_shadow_effect_real_paint;
	((ClutterEffectClass *) klass)->modify_paint_volume = (gboolean (*) (ClutterEffect*, ClutterPaintVolume*)) gala_shadow_effect_real_modify_paint_volume;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_shadow_effect_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_shadow_effect_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_shadow_effect_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY] = g_param_spec_string ("css-class", "css-class", "css-class", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_MONITOR_SCALE_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY] = g_param_spec_uchar ("shadow-opacity", "shadow-opacity", "shadow-opacity", 0, G_MAXUINT8, (guint8) 255, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_BORDER_RADIUS_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_BORDER_RADIUS_PROPERTY] = g_param_spec_int ("border-radius", "border-radius", "border-radius", G_MININT, G_MAXINT, 9, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GALA_SHADOW_EFFECT_TYPE_SHADOW, (GBoxedCopyFunc) gala_shadow_effect_shadow_ref, (GDestroyNotify) gala_shadow_effect_shadow_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_shadow_effect_shadow_cache);
	gala_shadow_effect_shadow_cache = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_shadow_effect_shadows_marked_for_dropping);
	gala_shadow_effect_shadows_marked_for_dropping = _tmp1_;
}

static void
gala_shadow_effect_instance_init (GalaShadowEffect * self,
                                  gpointer klass)
{
	self->priv = gala_shadow_effect_get_instance_private (self);
	self->priv->_shadow_opacity = (guint8) 255;
	self->priv->_border_radius = 9;
	self->priv->current_key = NULL;
}

static void
gala_shadow_effect_finalize (GObject * obj)
{
	GalaShadowEffect * self;
	const gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect);
	_tmp0_ = self->priv->current_key;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->current_key;
		gala_shadow_effect_decrement_shadow_users (_tmp1_);
	}
	_g_free0 (self->priv->_css_class);
	_g_object_unref0 (self->priv->pipeline);
	_g_free0 (self->priv->current_key);
	G_OBJECT_CLASS (gala_shadow_effect_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_shadow_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaShadowEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_shadow_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaShadowEffect), 0, (GInstanceInitFunc) gala_shadow_effect_instance_init, NULL };
	GType gala_shadow_effect_type_id;
	gala_shadow_effect_type_id = g_type_register_static (clutter_effect_get_type (), "GalaShadowEffect", &g_define_type_info, 0);
	GalaShadowEffect_private_offset = g_type_add_instance_private (gala_shadow_effect_type_id, sizeof (GalaShadowEffectPrivate));
	return gala_shadow_effect_type_id;
}

GType
gala_shadow_effect_get_type (void)
{
	static gsize gala_shadow_effect_type_id__once = 0;
	if (g_once_init_enter (&gala_shadow_effect_type_id__once)) {
		GType gala_shadow_effect_type_id;
		gala_shadow_effect_type_id = gala_shadow_effect_get_type_once ();
		g_once_init_leave (&gala_shadow_effect_type_id__once, gala_shadow_effect_type_id);
	}
	return gala_shadow_effect_type_id__once;
}

static void
_vala_gala_shadow_effect_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GalaShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect);
	switch (property_id) {
		case GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY:
		g_value_set_string (value, gala_shadow_effect_get_css_class (self));
		break;
		case GALA_SHADOW_EFFECT_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_shadow_effect_get_monitor_scale (self));
		break;
		case GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_shadow_effect_get_shadow_opacity (self));
		break;
		case GALA_SHADOW_EFFECT_BORDER_RADIUS_PROPERTY:
		g_value_set_int (value, gala_shadow_effect_get_border_radius (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_shadow_effect_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GalaShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect);
	switch (property_id) {
		case GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY:
		gala_shadow_effect_set_css_class (self, g_value_get_string (value));
		break;
		case GALA_SHADOW_EFFECT_MONITOR_SCALE_PROPERTY:
		gala_shadow_effect_set_monitor_scale (self, g_value_get_float (value));
		break;
		case GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY:
		gala_shadow_effect_set_shadow_opacity (self, g_value_get_uchar (value));
		break;
		case GALA_SHADOW_EFFECT_BORDER_RADIUS_PROPERTY:
		gala_shadow_effect_set_border_radius (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

