/* Tooltip.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Tooltip.vala, do not modify */

/*
 * Copyright 2021 José Expósito <jose.exposito89@gmail.com>
 * Copyright 2021-2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "gala.h"
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_TOOLTIP (gala_tooltip_get_type ())
#define GALA_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOOLTIP, GalaTooltip))
#define GALA_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOOLTIP, GalaTooltipClass))
#define GALA_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOOLTIP))
#define GALA_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOOLTIP))
#define GALA_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOOLTIP, GalaTooltipClass))

typedef struct _GalaTooltip GalaTooltip;
typedef struct _GalaTooltipClass GalaTooltipClass;
typedef struct _GalaTooltipPrivate GalaTooltipPrivate;
enum  {
	GALA_TOOLTIP_0_PROPERTY,
	GALA_TOOLTIP_MONITOR_SCALE_PROPERTY,
	GALA_TOOLTIP_NUM_PROPERTIES
};
static GParamSpec* gala_tooltip_properties[GALA_TOOLTIP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaTooltip {
	ClutterActor parent_instance;
	GalaTooltipPrivate * priv;
};

struct _GalaTooltipClass {
	ClutterActorClass parent_class;
};

struct _GalaTooltipPrivate {
	gfloat _monitor_scale;
	GalaText* text_actor;
};

static gint GalaTooltip_private_offset;
static gpointer gala_tooltip_parent_class = NULL;

VALA_EXTERN GType gala_tooltip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaTooltip, g_object_unref)
VALA_EXTERN GalaTooltip* gala_tooltip_new (gfloat monitor_scale);
VALA_EXTERN GalaTooltip* gala_tooltip_construct (GType object_type,
                                     gfloat monitor_scale);
VALA_EXTERN void gala_tooltip_set_text (GalaTooltip* self,
                            const gchar* new_text);
VALA_EXTERN gfloat gala_tooltip_get_monitor_scale (GalaTooltip* self);
VALA_EXTERN void gala_tooltip_set_monitor_scale (GalaTooltip* self,
                                     gfloat value);
static GObject * gala_tooltip_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void gala_tooltip_finalize (GObject * obj);
static GType gala_tooltip_get_type_once (void);
static void _vala_gala_tooltip_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_gala_tooltip_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
gala_tooltip_get_instance_private (GalaTooltip* self)
{
	return G_STRUCT_MEMBER_P (self, GalaTooltip_private_offset);
}

GalaTooltip*
gala_tooltip_construct (GType object_type,
                        gfloat monitor_scale)
{
	GalaTooltip * self = NULL;
	self = (GalaTooltip*) g_object_new (object_type, "monitor-scale", monitor_scale, NULL);
	return self;
}

GalaTooltip*
gala_tooltip_new (gfloat monitor_scale)
{
	return gala_tooltip_construct (GALA_TYPE_TOOLTIP, monitor_scale);
}

void
gala_tooltip_set_text (GalaTooltip* self,
                       const gchar* new_text)
{
	GalaText* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->text_actor;
	clutter_text_set_text ((ClutterText*) _tmp0_, new_text);
}

gfloat
gala_tooltip_get_monitor_scale (GalaTooltip* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_tooltip_set_monitor_scale (GalaTooltip* self,
                                gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_tooltip_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_tooltip_properties[GALA_TOOLTIP_MONITOR_SCALE_PROPERTY]);
	}
}

static GObject *
gala_tooltip_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaTooltip * self;
	GalaText* _tmp0_ = NULL;
	GalaText* _tmp1_;
	ClutterBinLayout* _tmp2_;
	ClutterBinLayout* _tmp3_;
	GalaRoundedCornersEffect* rounded_corners_effect = NULL;
	gfloat _tmp4_;
	GalaRoundedCornersEffect* _tmp5_;
	GalaRoundedCornersEffect* _tmp6_;
	GalaRoundedCornersEffect* _tmp7_;
	parent_class = G_OBJECT_CLASS (gala_tooltip_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOOLTIP, GalaTooltip);
	_tmp0_ = gala_text_new ();
	clutter_actor_set_margin_left ((ClutterActor*) _tmp0_, (gfloat) 6);
	clutter_actor_set_margin_top ((ClutterActor*) _tmp0_, (gfloat) 6);
	clutter_actor_set_margin_bottom ((ClutterActor*) _tmp0_, (gfloat) 6);
	clutter_actor_set_margin_right ((ClutterActor*) _tmp0_, (gfloat) 6);
	clutter_text_set_ellipsize ((ClutterText*) _tmp0_, PANGO_ELLIPSIZE_MIDDLE);
	clutter_text_set_color ((ClutterText*) _tmp0_, &GALA_DRAWING_COLOR_TOOLTIP_TEXT_COLOR);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->text_actor);
	self->priv->text_actor = _tmp0_;
	_tmp1_ = self->priv->text_actor;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp1_);
	_tmp2_ = (ClutterBinLayout*) clutter_bin_layout_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	clutter_actor_set_layout_manager ((ClutterActor*) self, (ClutterLayoutManager*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	clutter_actor_set_background_color ((ClutterActor*) self, &GALA_DRAWING_COLOR_TOOLTIP_BACKGROUND);
	_tmp4_ = self->priv->_monitor_scale;
	_tmp5_ = gala_rounded_corners_effect_new ((gfloat) 3, _tmp4_);
	g_object_ref_sink (_tmp5_);
	rounded_corners_effect = _tmp5_;
	_tmp6_ = rounded_corners_effect;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp6_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = rounded_corners_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp7_);
	_g_object_unref0 (rounded_corners_effect);
	return obj;
}

static void
gala_tooltip_class_init (GalaTooltipClass * klass,
                         gpointer klass_data)
{
	gala_tooltip_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaTooltip_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_tooltip_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_tooltip_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_tooltip_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_tooltip_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_TOOLTIP_MONITOR_SCALE_PROPERTY, gala_tooltip_properties[GALA_TOOLTIP_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gala_tooltip_instance_init (GalaTooltip * self,
                            gpointer klass)
{
	self->priv = gala_tooltip_get_instance_private (self);
}

static void
gala_tooltip_finalize (GObject * obj)
{
	GalaTooltip * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOOLTIP, GalaTooltip);
	_g_object_unref0 (self->priv->text_actor);
	G_OBJECT_CLASS (gala_tooltip_parent_class)->finalize (obj);
}

/**
 * Clutter actor to display text in a tooltip-like component.
 */
 G_GNUC_NO_INLINE static GType
gala_tooltip_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaTooltipClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_tooltip_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaTooltip), 0, (GInstanceInitFunc) gala_tooltip_instance_init, NULL };
	GType gala_tooltip_type_id;
	gala_tooltip_type_id = g_type_register_static (clutter_actor_get_type (), "GalaTooltip", &g_define_type_info, 0);
	GalaTooltip_private_offset = g_type_add_instance_private (gala_tooltip_type_id, sizeof (GalaTooltipPrivate));
	return gala_tooltip_type_id;
}

GType
gala_tooltip_get_type (void)
{
	static gsize gala_tooltip_type_id__once = 0;
	if (g_once_init_enter (&gala_tooltip_type_id__once)) {
		GType gala_tooltip_type_id;
		gala_tooltip_type_id = gala_tooltip_get_type_once ();
		g_once_init_leave (&gala_tooltip_type_id__once, gala_tooltip_type_id);
	}
	return gala_tooltip_type_id__once;
}

static void
_vala_gala_tooltip_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GalaTooltip * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_TOOLTIP, GalaTooltip);
	switch (property_id) {
		case GALA_TOOLTIP_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_tooltip_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_tooltip_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GalaTooltip * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_TOOLTIP, GalaTooltip);
	switch (property_id) {
		case GALA_TOOLTIP_MONITOR_SCALE_PROPERTY:
		gala_tooltip_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

