/* application-notification-plugin-context.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-notification-plugin-context.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2019-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include "geary-client-46.0.h"
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_REQUIRED_FIELDS GEARY_EMAIL_FIELD_FLAGS
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT (application_notification_plugin_context_get_type ())
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContextClass))
#define APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT))
#define APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContextClass))

typedef struct _ApplicationNotificationPluginContext ApplicationNotificationPluginContext;
typedef struct _ApplicationNotificationPluginContextClass ApplicationNotificationPluginContextClass;
typedef struct _ApplicationNotificationPluginContextPrivate ApplicationNotificationPluginContextPrivate;

#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION (application_notification_plugin_context_monitor_information_get_type ())
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_MONITOR_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION, ApplicationNotificationPluginContextMonitorInformation))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_MONITOR_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION, ApplicationNotificationPluginContextMonitorInformationClass))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_IS_MONITOR_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_IS_MONITOR_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_MONITOR_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION, ApplicationNotificationPluginContextMonitorInformationClass))

typedef struct _ApplicationNotificationPluginContextMonitorInformation ApplicationNotificationPluginContextMonitorInformation;
typedef struct _ApplicationNotificationPluginContextMonitorInformationClass ApplicationNotificationPluginContextMonitorInformationClass;

#define APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS (application_plugin_manager_plugin_globals_get_type ())
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_GLOBALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS, ApplicationPluginManagerPluginGlobals))
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_GLOBALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS, ApplicationPluginManagerPluginGlobalsClass))
#define APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_GLOBALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS))
#define APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_GLOBALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS))
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_GLOBALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_GLOBALS, ApplicationPluginManagerPluginGlobalsClass))

typedef struct _ApplicationPluginManagerPluginGlobals ApplicationPluginManagerPluginGlobals;
typedef struct _ApplicationPluginManagerPluginGlobalsClass ApplicationPluginManagerPluginGlobalsClass;

#define APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_CONTEXT (application_plugin_manager_plugin_context_get_type ())
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_CONTEXT, ApplicationPluginManagerPluginContext))
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_CONTEXT, ApplicationPluginManagerPluginContextClass))
#define APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_CONTEXT))
#define APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_CONTEXT))
#define APPLICATION_PLUGIN_MANAGER_PLUGIN_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_PLUGIN_MANAGER_TYPE_PLUGIN_CONTEXT, ApplicationPluginManagerPluginContextClass))

typedef struct _ApplicationPluginManagerPluginContext ApplicationPluginManagerPluginContext;
typedef struct _ApplicationPluginManagerPluginContextClass ApplicationPluginManagerPluginContextClass;
enum  {
	APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_0_PROPERTY,
	APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TOTAL_NEW_MESSAGES_PROPERTY,
	APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* application_notification_plugin_context_properties[APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _application_plugin_manager_plugin_globals_unref0(var) ((var == NULL) ? NULL : (var = (application_plugin_manager_plugin_globals_unref (var), NULL)))
#define _application_plugin_manager_plugin_context_unref0(var) ((var == NULL) ? NULL : (var = (application_plugin_manager_plugin_context_unref (var), NULL)))

#define APPLICATION_TYPE_FOLDER_STORE_FACTORY (application_folder_store_factory_get_type ())
#define APPLICATION_FOLDER_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactory))
#define APPLICATION_FOLDER_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactoryClass))
#define APPLICATION_IS_FOLDER_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY))
#define APPLICATION_IS_FOLDER_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_FOLDER_STORE_FACTORY))
#define APPLICATION_FOLDER_STORE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_FOLDER_STORE_FACTORY, ApplicationFolderStoreFactoryClass))

typedef struct _ApplicationFolderStoreFactory ApplicationFolderStoreFactory;
typedef struct _ApplicationFolderStoreFactoryClass ApplicationFolderStoreFactoryClass;

#define APPLICATION_TYPE_CONTROLLER (application_controller_get_type ())
#define APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationController))
#define APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))
#define APPLICATION_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))

typedef struct _ApplicationController ApplicationController;
typedef struct _ApplicationControllerClass ApplicationControllerClass;

#define APPLICATION_TYPE_ACCOUNT_INTERFACE (application_account_interface_get_type ())
#define APPLICATION_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface))
#define APPLICATION_IS_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE))
#define APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterfaceIface))

typedef struct _ApplicationAccountInterface ApplicationAccountInterface;
typedef struct _ApplicationAccountInterfaceIface ApplicationAccountInterfaceIface;

#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL (application_notification_plugin_context_contact_store_impl_get_type ())
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_CONTACT_STORE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL, ApplicationNotificationPluginContextContactStoreImpl))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_CONTACT_STORE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL, ApplicationNotificationPluginContextContactStoreImplClass))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_IS_CONTACT_STORE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_IS_CONTACT_STORE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL))
#define APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_CONTACT_STORE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL, ApplicationNotificationPluginContextContactStoreImplClass))

typedef struct _ApplicationNotificationPluginContextContactStoreImpl ApplicationNotificationPluginContextContactStoreImpl;
typedef struct _ApplicationNotificationPluginContextContactStoreImplClass ApplicationNotificationPluginContextContactStoreImplClass;
typedef struct _ApplicationNotificationPluginContextGetContactsForFolderData ApplicationNotificationPluginContextGetContactsForFolderData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ApplicationNotificationPluginContextMonitorInformationPrivate ApplicationNotificationPluginContextMonitorInformationPrivate;
typedef struct _Block35Data Block35Data;

#define APPLICATION_TYPE_EMAIL_STORE_FACTORY (application_email_store_factory_get_type ())
#define APPLICATION_EMAIL_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_EMAIL_STORE_FACTORY, ApplicationEmailStoreFactory))
#define APPLICATION_EMAIL_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_EMAIL_STORE_FACTORY, ApplicationEmailStoreFactoryClass))
#define APPLICATION_IS_EMAIL_STORE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_EMAIL_STORE_FACTORY))
#define APPLICATION_IS_EMAIL_STORE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_EMAIL_STORE_FACTORY))
#define APPLICATION_EMAIL_STORE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_EMAIL_STORE_FACTORY, ApplicationEmailStoreFactoryClass))

typedef struct _ApplicationEmailStoreFactory ApplicationEmailStoreFactory;
typedef struct _ApplicationEmailStoreFactoryClass ApplicationEmailStoreFactoryClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationNotificationPluginContextDoProcessNewEmailData ApplicationNotificationPluginContextDoProcessNewEmailData;
typedef struct _ApplicationNotificationPluginContextContactStoreImplPrivate ApplicationNotificationPluginContextContactStoreImplPrivate;
enum  {
	APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_CONTACT_STORE_IMPL_0_PROPERTY,
	APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_CONTACT_STORE_IMPL_NUM_PROPERTIES
};
static GParamSpec* application_notification_plugin_context_contact_store_impl_properties[APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_CONTACT_STORE_IMPL_NUM_PROPERTIES];
typedef struct _ApplicationNotificationPluginContextContactStoreImplSearchData ApplicationNotificationPluginContextContactStoreImplSearchData;
typedef struct _ApplicationNotificationPluginContextContactStoreImplLoadData ApplicationNotificationPluginContextContactStoreImplLoadData;
enum  {
	APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_MONITOR_INFORMATION_0_PROPERTY,
	APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_MONITOR_INFORMATION_NUM_PROPERTIES
};
static GParamSpec* application_notification_plugin_context_monitor_information_properties[APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_MONITOR_INFORMATION_NUM_PROPERTIES];

struct _ApplicationNotificationPluginContext {
	GearyBaseObject parent_instance;
	gint _total_new_messages;
	ApplicationNotificationPluginContextPrivate * priv;
};

struct _ApplicationNotificationPluginContextClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationNotificationPluginContextPrivate {
	GeeMap* folder_information;
	ApplicationClient* application;
	ApplicationPluginManagerPluginGlobals* globals;
	ApplicationPluginManagerPluginContext* plugin;
};

struct _ApplicationAccountInterfaceIface {
	GTypeInterface parent_iface;
	ApplicationAccountContext* (*get_context_for_account) (ApplicationAccountInterface* self, GearyAccountInformation* account);
	GeeCollection* (*get_account_contexts) (ApplicationAccountInterface* self);
};

struct _ApplicationNotificationPluginContextGetContactsForFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationNotificationPluginContext* self;
	PluginFolder* source;
	PluginContactStore* result;
	GearyFolder* folder;
	ApplicationPluginManagerPluginGlobals* _tmp0_;
	ApplicationFolderStoreFactory* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	GearyFolder* _tmp3_;
	ApplicationAccountContext* context;
	GearyFolder* _tmp4_;
	ApplicationClient* _tmp5_;
	ApplicationController* _tmp6_;
	ApplicationController* _tmp7_;
	GearyFolder* _tmp8_;
	GearyAccount* _tmp9_;
	GearyAccount* _tmp10_;
	GearyAccountInformation* _tmp11_;
	GearyAccountInformation* _tmp12_;
	ApplicationAccountContext* _tmp13_;
	ApplicationAccountContext* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	ApplicationAccountContext* _tmp18_;
	ApplicationContactStore* _tmp19_;
	ApplicationContactStore* _tmp20_;
	ApplicationNotificationPluginContextContactStoreImpl* _tmp21_;
	GError* _inner_error0_;
};

struct _ApplicationNotificationPluginContextMonitorInformation {
	GearyBaseObject parent_instance;
	GearyFolder* folder;
	GCancellable* cancellable;
	GeeSet* recent_ids;
	ApplicationNotificationPluginContextMonitorInformationPrivate * priv;
};

struct _ApplicationNotificationPluginContextMonitorInformationClass {
	GearyBaseObjectClass parent_class;
};

struct _Block35Data {
	int _ref_count_;
	ApplicationNotificationPluginContext* self;
	ApplicationNotificationPluginContextMonitorInformation* info;
};

struct _ApplicationNotificationPluginContextDoProcessNewEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationNotificationPluginContext* self;
	GearyFolder* folder;
	GeeCollection* email_ids;
	ApplicationNotificationPluginContextMonitorInformation* info;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	ApplicationNotificationPluginContextMonitorInformation* _tmp2_;
	GeeList* list;
	GeeList* _tmp3_;
	ApplicationNotificationPluginContextMonitorInformation* _tmp4_;
	GCancellable* _tmp5_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	GError* err;
	GError* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	GeeList* _tmp11_;
	GeeList* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	ApplicationNotificationPluginContextMonitorInformation* _tmp15_;
	GeeList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GError* _inner_error0_;
};

struct _ApplicationNotificationPluginContextContactStoreImpl {
	GearyBaseObject parent_instance;
	ApplicationNotificationPluginContextContactStoreImplPrivate * priv;
};

struct _ApplicationNotificationPluginContextContactStoreImplClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationNotificationPluginContextContactStoreImplPrivate {
	ApplicationContactStore* backing;
};

struct _ApplicationNotificationPluginContextContactStoreImplSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationNotificationPluginContextContactStoreImpl* self;
	gchar* query;
	guint min_importance;
	guint limit;
	GCancellable* cancellable;
	GeeCollection* result;
	GeeCollection* _tmp0_;
	ApplicationContactStore* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GError* _inner_error0_;
};

struct _ApplicationNotificationPluginContextContactStoreImplLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationNotificationPluginContextContactStoreImpl* self;
	GearyRFC822MailboxAddress* mailbox;
	GCancellable* cancellable;
	ApplicationContact* result;
	ApplicationContact* _tmp0_;
	ApplicationContactStore* _tmp1_;
	ApplicationContact* _tmp2_;
	ApplicationContact* _tmp3_;
	GError* _inner_error0_;
};

static gint ApplicationNotificationPluginContext_private_offset;
static gpointer application_notification_plugin_context_parent_class = NULL;
static gint ApplicationNotificationPluginContextContactStoreImpl_private_offset;
static gpointer application_notification_plugin_context_contact_store_impl_parent_class = NULL;
static PluginContactStoreIface * application_notification_plugin_context_contact_store_impl_plugin_contact_store_parent_iface = NULL;
static gpointer application_notification_plugin_context_monitor_information_parent_class = NULL;
static PluginNotificationContextIface * application_notification_plugin_context_plugin_notification_context_parent_iface = NULL;

VALA_EXTERN GType application_notification_plugin_context_get_type (void) G_GNUC_CONST ;
static GType application_notification_plugin_context_monitor_information_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN gpointer application_plugin_manager_plugin_globals_ref (gpointer instance);
VALA_EXTERN void application_plugin_manager_plugin_globals_unref (gpointer instance);
VALA_EXTERN GParamSpec* application_plugin_manager_param_spec_plugin_globals (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags);
VALA_EXTERN void application_plugin_manager_value_set_plugin_globals (GValue* value,
                                                          gpointer v_object);
VALA_EXTERN void application_plugin_manager_value_take_plugin_globals (GValue* value,
                                                           gpointer v_object);
VALA_EXTERN gpointer application_plugin_manager_value_get_plugin_globals (const GValue* value);
VALA_EXTERN GType application_plugin_manager_plugin_globals_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer application_plugin_manager_plugin_context_ref (gpointer instance);
VALA_EXTERN void application_plugin_manager_plugin_context_unref (gpointer instance);
VALA_EXTERN GParamSpec* application_plugin_manager_param_spec_plugin_context (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags);
VALA_EXTERN void application_plugin_manager_value_set_plugin_context (GValue* value,
                                                          gpointer v_object);
VALA_EXTERN void application_plugin_manager_value_take_plugin_context (GValue* value,
                                                           gpointer v_object);
VALA_EXTERN gpointer application_plugin_manager_value_get_plugin_context (const GValue* value);
VALA_EXTERN GType application_plugin_manager_plugin_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationNotificationPluginContext* application_notification_plugin_context_new (ApplicationClient* application,
                                                                                   ApplicationPluginManagerPluginGlobals* globals,
                                                                                   ApplicationPluginManagerPluginContext* plugin);
VALA_EXTERN ApplicationNotificationPluginContext* application_notification_plugin_context_construct (GType object_type,
                                                                                         ApplicationClient* application,
                                                                                         ApplicationPluginManagerPluginGlobals* globals,
                                                                                         ApplicationPluginManagerPluginContext* plugin);
static void application_notification_plugin_context_real_get_contacts_for_folder_data_free (gpointer _data);
static void application_notification_plugin_context_real_get_contacts_for_folder (PluginNotificationContext* base,
                                                                           PluginFolder* source,
                                                                           GAsyncReadyCallback _callback_,
                                                                           gpointer _user_data_);
static gboolean application_notification_plugin_context_real_get_contacts_for_folder_co (ApplicationNotificationPluginContextGetContactsForFolderData* _data_);
VALA_EXTERN GType application_folder_store_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationFolderStoreFactory* application_plugin_manager_plugin_globals_get_folders (ApplicationPluginManagerPluginGlobals* self);
VALA_EXTERN GearyFolder* application_folder_store_factory_to_engine_folder (ApplicationFolderStoreFactory* self,
                                                                PluginFolder* plugin);
VALA_EXTERN GType application_controller_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationController* application_client_get_controller (ApplicationClient* self);
VALA_EXTERN GType application_account_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationAccountContext* application_account_interface_get_context_for_account (ApplicationAccountInterface* self,
                                                                                  GearyAccountInformation* account);
static ApplicationNotificationPluginContextContactStoreImpl* application_notification_plugin_context_contact_store_impl_new (ApplicationContactStore* backing);
static ApplicationNotificationPluginContextContactStoreImpl* application_notification_plugin_context_contact_store_impl_construct (GType object_type,
                                                                                                                            ApplicationContactStore* backing);
static GType application_notification_plugin_context_contact_store_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean application_notification_plugin_context_real_should_notify_new_messages (PluginNotificationContext* base,
                                                                                  PluginFolder* target);
static gint application_notification_plugin_context_real_get_new_message_count (PluginNotificationContext* base,
                                                                         PluginFolder* target,
                                                                         GError** error);
static void application_notification_plugin_context_real_start_monitoring_folder (PluginNotificationContext* base,
                                                                           PluginFolder* target);
static void application_notification_plugin_context_on_email_locally_appended (ApplicationNotificationPluginContext* self,
                                                                        GearyFolder* folder,
                                                                        GeeCollection* email_ids);
static void _application_notification_plugin_context_on_email_locally_appended_geary_folder_email_locally_appended (GearyFolder* _sender,
                                                                                                             GeeCollection* ids,
                                                                                                             gpointer self);
static void application_notification_plugin_context_on_email_flags_changed (ApplicationNotificationPluginContext* self,
                                                                     GearyFolder* folder,
                                                                     GeeMap* ids);
static void _application_notification_plugin_context_on_email_flags_changed_geary_folder_email_flags_changed (GearyFolder* _sender,
                                                                                                       GeeMap* map,
                                                                                                       gpointer self);
static void application_notification_plugin_context_on_email_removed (ApplicationNotificationPluginContext* self,
                                                               GearyFolder* folder,
                                                               GeeCollection* ids);
static void _application_notification_plugin_context_on_email_removed_geary_folder_email_removed (GearyFolder* _sender,
                                                                                           GeeCollection* ids,
                                                                                           gpointer self);
static ApplicationNotificationPluginContextMonitorInformation* application_notification_plugin_context_monitor_information_new (GearyFolder* folder,
                                                                                                                         GCancellable* cancellable);
static ApplicationNotificationPluginContextMonitorInformation* application_notification_plugin_context_monitor_information_construct (GType object_type,
                                                                                                                               GearyFolder* folder,
                                                                                                                               GCancellable* cancellable);
static void application_notification_plugin_context_real_stop_monitoring_folder (PluginNotificationContext* base,
                                                                          PluginFolder* target);
static void application_notification_plugin_context_remove_folder (ApplicationNotificationPluginContext* self,
                                                            GearyFolder* target);
static gboolean application_notification_plugin_context_real_is_monitoring_folder (PluginNotificationContext* base,
                                                                            PluginFolder* target);
VALA_EXTERN void application_notification_plugin_context_destroy (ApplicationNotificationPluginContext* self);
VALA_EXTERN void application_notification_plugin_context_clear_new_messages (ApplicationNotificationPluginContext* self,
                                                                 GearyFolder* location,
                                                                 GeeSet* visible);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static gboolean _____lambda147_ (Block35Data* _data35_,
                          GearyEmailIdentifier* id);
static gboolean ______lambda147__gee_predicate (gconstpointer g,
                                         gpointer self);
static void application_notification_plugin_context_update_count (ApplicationNotificationPluginContext* self,
                                                           ApplicationNotificationPluginContextMonitorInformation* info,
                                                           gboolean arrived,
                                                           GeeCollection* delta);
static void application_notification_plugin_context_new_messages (ApplicationNotificationPluginContext* self,
                                                           ApplicationNotificationPluginContextMonitorInformation* info,
                                                           GeeCollection* emails);
static void application_notification_plugin_context_retire_new_messages (ApplicationNotificationPluginContext* self,
                                                                  GearyFolder* folder,
                                                                  GeeCollection* email_ids);
VALA_EXTERN PluginFolder* application_folder_store_factory_to_plugin_folder (ApplicationFolderStoreFactory* self,
                                                                 GearyFolder* engine);
VALA_EXTERN GType application_email_store_factory_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationEmailStoreFactory* application_plugin_manager_plugin_globals_get_email (ApplicationPluginManagerPluginGlobals* self);
VALA_EXTERN GeeCollection* application_email_store_factory_to_plugin_ids (ApplicationEmailStoreFactory* self,
                                                              GeeCollection* engine_ids,
                                                              ApplicationAccountContext* account);
static void application_notification_plugin_context_do_process_new_email_data_free (gpointer _data);
static void application_notification_plugin_context_do_process_new_email (ApplicationNotificationPluginContext* self,
                                                                   GearyFolder* folder,
                                                                   GeeCollection* email_ids,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static void application_notification_plugin_context_do_process_new_email_finish (ApplicationNotificationPluginContext* self,
                                                                          GAsyncResult* _res_);
static gboolean application_notification_plugin_context_do_process_new_email_co (ApplicationNotificationPluginContextDoProcessNewEmailData* _data_);
static void application_notification_plugin_context_do_process_new_email_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_);
static void application_notification_plugin_context_contact_store_impl_real_search_data_free (gpointer _data);
static void application_notification_plugin_context_contact_store_impl_real_search (PluginContactStore* base,
                                                                             const gchar* query,
                                                                             guint min_importance,
                                                                             guint limit,
                                                                             GCancellable* cancellable,
                                                                             GAsyncReadyCallback _callback_,
                                                                             gpointer _user_data_);
static gboolean application_notification_plugin_context_contact_store_impl_real_search_co (ApplicationNotificationPluginContextContactStoreImplSearchData* _data_);
static void application_notification_plugin_context_contact_store_impl_search_ready (GObject* source_object,
                                                                              GAsyncResult* _res_,
                                                                              gpointer _user_data_);
static void application_notification_plugin_context_contact_store_impl_real_load_data_free (gpointer _data);
static void application_notification_plugin_context_contact_store_impl_real_load (PluginContactStore* base,
                                                                           GearyRFC822MailboxAddress* mailbox,
                                                                           GCancellable* cancellable,
                                                                           GAsyncReadyCallback _callback_,
                                                                           gpointer _user_data_);
static gboolean application_notification_plugin_context_contact_store_impl_real_load_co (ApplicationNotificationPluginContextContactStoreImplLoadData* _data_);
static void application_notification_plugin_context_contact_store_impl_load_ready (GObject* source_object,
                                                                            GAsyncResult* _res_,
                                                                            gpointer _user_data_);
static void application_notification_plugin_context_contact_store_impl_finalize (GObject * obj);
static GType application_notification_plugin_context_contact_store_impl_get_type_once (void);
static void application_notification_plugin_context_monitor_information_finalize (GObject * obj);
static GType application_notification_plugin_context_monitor_information_get_type_once (void);
static void application_notification_plugin_context_finalize (GObject * obj);
static GType application_notification_plugin_context_get_type_once (void);
static void _vala_application_notification_plugin_context_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
application_notification_plugin_context_get_instance_private (ApplicationNotificationPluginContext* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationNotificationPluginContext_private_offset);
}

static gint
application_notification_plugin_context_real_get_total_new_messages (PluginNotificationContext* base)
{
	gint result;
	ApplicationNotificationPluginContext* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	result = self->_total_new_messages;
	return result;
}

static gpointer
_application_plugin_manager_plugin_globals_ref0 (gpointer self)
{
	return self ? application_plugin_manager_plugin_globals_ref (self) : NULL;
}

static gpointer
_application_plugin_manager_plugin_context_ref0 (gpointer self)
{
	return self ? application_plugin_manager_plugin_context_ref (self) : NULL;
}

ApplicationNotificationPluginContext*
application_notification_plugin_context_construct (GType object_type,
                                                   ApplicationClient* application,
                                                   ApplicationPluginManagerPluginGlobals* globals,
                                                   ApplicationPluginManagerPluginContext* plugin)
{
	ApplicationNotificationPluginContext * self = NULL;
	ApplicationPluginManagerPluginGlobals* _tmp0_;
	ApplicationPluginManagerPluginContext* _tmp1_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (application), NULL);
	g_return_val_if_fail (APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_GLOBALS (globals), NULL);
	g_return_val_if_fail (APPLICATION_PLUGIN_MANAGER_IS_PLUGIN_CONTEXT (plugin), NULL);
	self = (ApplicationNotificationPluginContext*) geary_base_object_construct (object_type);
	self->priv->application = application;
	_tmp0_ = _application_plugin_manager_plugin_globals_ref0 (globals);
	_application_plugin_manager_plugin_globals_unref0 (self->priv->globals);
	self->priv->globals = _tmp0_;
	_tmp1_ = _application_plugin_manager_plugin_context_ref0 (plugin);
	_application_plugin_manager_plugin_context_unref0 (self->priv->plugin);
	self->priv->plugin = _tmp1_;
	return self;
}

ApplicationNotificationPluginContext*
application_notification_plugin_context_new (ApplicationClient* application,
                                             ApplicationPluginManagerPluginGlobals* globals,
                                             ApplicationPluginManagerPluginContext* plugin)
{
	return application_notification_plugin_context_construct (APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, application, globals, plugin);
}

static void
application_notification_plugin_context_real_get_contacts_for_folder_data_free (gpointer _data)
{
	ApplicationNotificationPluginContextGetContactsForFolderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->source);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationNotificationPluginContextGetContactsForFolderData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_notification_plugin_context_real_get_contacts_for_folder (PluginNotificationContext* base,
                                                                      PluginFolder* source,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_)
{
	ApplicationNotificationPluginContext * self;
	ApplicationNotificationPluginContextGetContactsForFolderData* _data_;
	ApplicationNotificationPluginContext* _tmp0_;
	PluginFolder* _tmp1_;
	g_return_if_fail (PLUGIN_IS_FOLDER (source));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	_data_ = g_slice_new0 (ApplicationNotificationPluginContextGetContactsForFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_notification_plugin_context_real_get_contacts_for_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	application_notification_plugin_context_real_get_contacts_for_folder_co (_data_);
}

static PluginContactStore*
application_notification_plugin_context_get_contacts_for_folder_finish (PluginNotificationContext* base,
                                                                        GAsyncResult* _res_,
                                                                        GError** error)
{
	PluginContactStore* result;
	ApplicationNotificationPluginContextGetContactsForFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
application_notification_plugin_context_real_get_contacts_for_folder_co (ApplicationNotificationPluginContextGetContactsForFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->globals;
	_data_->_tmp1_ = application_plugin_manager_plugin_globals_get_folders (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = application_folder_store_factory_to_engine_folder (_data_->_tmp2_, _data_->source);
	_data_->folder = _data_->_tmp3_;
	_data_->context = NULL;
	_data_->_tmp4_ = _data_->folder;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->application;
		_data_->_tmp6_ = application_client_get_controller (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->folder;
		_data_->_tmp9_ = geary_folder_get_account (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = geary_account_get_information (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _data_->_tmp12_);
		_g_object_unref0 (_data_->context);
		_data_->context = _data_->_tmp13_;
	}
	_data_->_tmp14_ = _data_->context;
	if (_data_->_tmp14_ == NULL) {
		_data_->_tmp15_ = plugin_folder_get_display_name (_data_->source);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = g_error_new (PLUGIN_ERROR, PLUGIN_ERROR_NOT_FOUND, "No account for folder: %s", _data_->_tmp16_);
		_data_->_inner_error0_ = _data_->_tmp17_;
		if ((_data_->_inner_error0_->domain == PLUGIN_ERROR) || (_data_->_inner_error0_->domain == PLUGIN_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->context);
			_g_object_unref0 (_data_->folder);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->context);
			_g_object_unref0 (_data_->folder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp18_ = _data_->context;
	_data_->_tmp19_ = application_account_context_get_contacts (_data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = application_notification_plugin_context_contact_store_impl_new (_data_->_tmp20_);
	_data_->result = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, PLUGIN_TYPE_CONTACT_STORE, PluginContactStore);
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->folder);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Determines if notifications should be made for a specific folder.
     *
     * Notification plugins should call this to first before
     * displaying a "new mail" notification for mail in a specific
     * folder. It will return true for any monitored folder that is
     * not currently visible in the currently focused main window, if
     * any.
     */
static gboolean
application_notification_plugin_context_real_should_notify_new_messages (PluginNotificationContext* base,
                                                                         PluginFolder* target)
{
	ApplicationNotificationPluginContext * self;
	GearyFolder* folder = NULL;
	ApplicationPluginManagerPluginGlobals* _tmp0_;
	ApplicationFolderStoreFactory* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	GearyFolder* _tmp3_;
	ApplicationMainWindow* window = NULL;
	ApplicationClient* _tmp4_;
	ApplicationMainWindow* _tmp5_;
	ApplicationMainWindow* _tmp6_;
	ApplicationMainWindow* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GearyFolder* _tmp10_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	g_return_val_if_fail (PLUGIN_IS_FOLDER (target), FALSE);
	_tmp0_ = self->priv->globals;
	_tmp1_ = application_plugin_manager_plugin_globals_get_folders (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_folder_store_factory_to_engine_folder (_tmp2_, target);
	folder = _tmp3_;
	_tmp4_ = self->priv->application;
	_tmp5_ = application_client_get_last_active_main_window (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	window = _tmp7_;
	_tmp10_ = folder;
	if (_tmp10_ != NULL) {
		GeeMap* _tmp11_;
		GearyFolder* _tmp12_;
		_tmp11_ = self->priv->folder_information;
		_tmp12_ = folder;
		_tmp9_ = gee_map_has_key (_tmp11_, _tmp12_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		ApplicationMainWindow* _tmp16_;
		_tmp16_ = window;
		if (_tmp16_ == NULL) {
			_tmp15_ = TRUE;
		} else {
			ApplicationMainWindow* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = window;
			g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_window_get_type (), GtkWindow), "has-toplevel-focus", &_tmp18_, NULL);
			_tmp19_ = _tmp18_;
			_tmp15_ = !_tmp19_;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ApplicationMainWindow* _tmp20_;
			GearyFolder* _tmp21_;
			GearyFolder* _tmp22_;
			GearyFolder* _tmp23_;
			_tmp20_ = window;
			_tmp21_ = application_main_window_get_selected_folder (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = folder;
			_tmp14_ = _tmp22_ != _tmp23_;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			ApplicationMainWindow* _tmp24_;
			ConversationListView* _tmp25_;
			ConversationListView* _tmp26_;
			GtkAdjustment* _tmp27_;
			GtkAdjustment* _tmp28_;
			gdouble _tmp29_;
			gdouble _tmp30_;
			_tmp24_ = window;
			_tmp25_ = application_main_window_get_conversation_list_view (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
			_tmp28_ = _tmp27_;
			_tmp29_ = gtk_adjustment_get_value (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp13_ = _tmp30_ > 0.0;
		}
		_tmp8_ = _tmp13_;
	} else {
		_tmp8_ = FALSE;
	}
	result = _tmp8_;
	_g_object_unref0 (window);
	_g_object_unref0 (folder);
	return result;
}

/**
     * Returns the new message count for a specific folder.
     *
     * The context must have already been requested to monitor the
     * folder by a call to {@link start_monitoring_folder}.
     */
static gint
application_notification_plugin_context_real_get_new_message_count (PluginNotificationContext* base,
                                                                    PluginFolder* target,
                                                                    GError** error)
{
	ApplicationNotificationPluginContext * self;
	GearyFolder* folder = NULL;
	ApplicationPluginManagerPluginGlobals* _tmp0_;
	ApplicationFolderStoreFactory* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	GearyFolder* _tmp3_;
	ApplicationNotificationPluginContextMonitorInformation* info = NULL;
	GearyFolder* _tmp4_;
	ApplicationNotificationPluginContextMonitorInformation* _tmp8_;
	ApplicationNotificationPluginContextMonitorInformation* _tmp18_;
	GeeSet* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	g_return_val_if_fail (PLUGIN_IS_FOLDER (target), 0);
	_tmp0_ = self->priv->globals;
	_tmp1_ = application_plugin_manager_plugin_globals_get_folders (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_folder_store_factory_to_engine_folder (_tmp2_, target);
	folder = _tmp3_;
	info = NULL;
	_tmp4_ = folder;
	if (_tmp4_ != NULL) {
		GeeMap* _tmp5_;
		GearyFolder* _tmp6_;
		gpointer _tmp7_;
		_tmp5_ = self->priv->folder_information;
		_tmp6_ = folder;
		_tmp7_ = gee_map_get (_tmp5_, _tmp6_);
		_g_object_unref0 (info);
		info = (ApplicationNotificationPluginContextMonitorInformation*) _tmp7_;
	}
	_tmp8_ = info;
	if (_tmp8_ == NULL) {
		GearyFolder* _tmp9_;
		GearyFolderPath* _tmp10_;
		GearyFolderPath* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		_tmp9_ = folder;
		_tmp10_ = geary_folder_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = geary_folder_path_to_string (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_error_new (PLUGIN_ERROR, PLUGIN_ERROR_NOT_FOUND, "No such folder: %s", _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_inner_error0_ = _tmp15_;
		if (_inner_error0_->domain == PLUGIN_ERROR) {
			gint _tmp16_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_object_unref0 (folder);
			return _tmp16_;
		} else {
			gint _tmp17_ = -1;
			_g_object_unref0 (info);
			_g_object_unref0 (folder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	_tmp18_ = info;
	_tmp19_ = _tmp18_->recent_ids;
	_tmp20_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp21_ = _tmp20_;
	result = _tmp21_;
	_g_object_unref0 (info);
	_g_object_unref0 (folder);
	return result;
}

/**
     * Starts monitoring a folder for new messages.
     *
     * Notification plugins should call this to start the context
     * recording new messages for a specific folder.
     */
static void
_application_notification_plugin_context_on_email_locally_appended_geary_folder_email_locally_appended (GearyFolder* _sender,
                                                                                                        GeeCollection* ids,
                                                                                                        gpointer self)
{
	application_notification_plugin_context_on_email_locally_appended ((ApplicationNotificationPluginContext*) self, _sender, ids);
}

static void
_application_notification_plugin_context_on_email_flags_changed_geary_folder_email_flags_changed (GearyFolder* _sender,
                                                                                                  GeeMap* map,
                                                                                                  gpointer self)
{
	application_notification_plugin_context_on_email_flags_changed ((ApplicationNotificationPluginContext*) self, _sender, map);
}

static void
_application_notification_plugin_context_on_email_removed_geary_folder_email_removed (GearyFolder* _sender,
                                                                                      GeeCollection* ids,
                                                                                      gpointer self)
{
	application_notification_plugin_context_on_email_removed ((ApplicationNotificationPluginContext*) self, _sender, ids);
}

static void
application_notification_plugin_context_real_start_monitoring_folder (PluginNotificationContext* base,
                                                                      PluginFolder* target)
{
	ApplicationNotificationPluginContext * self;
	GearyFolder* folder = NULL;
	ApplicationPluginManagerPluginGlobals* _tmp0_;
	ApplicationFolderStoreFactory* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	GearyFolder* _tmp3_;
	ApplicationAccountContext* context = NULL;
	ApplicationClient* _tmp4_;
	ApplicationController* _tmp5_;
	ApplicationController* _tmp6_;
	GearyFolder* _tmp7_;
	GearyAccount* _tmp8_;
	GearyAccount* _tmp9_;
	GearyAccountInformation* _tmp10_;
	GearyAccountInformation* _tmp11_;
	ApplicationAccountContext* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GearyFolder* _tmp15_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	g_return_if_fail (PLUGIN_IS_FOLDER (target));
	_tmp0_ = self->priv->globals;
	_tmp1_ = application_plugin_manager_plugin_globals_get_folders (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_folder_store_factory_to_engine_folder (_tmp2_, target);
	folder = _tmp3_;
	_tmp4_ = self->priv->application;
	_tmp5_ = application_client_get_controller (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = folder;
	_tmp8_ = geary_folder_get_account (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = geary_account_get_information (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _tmp11_);
	context = _tmp12_;
	_tmp15_ = folder;
	if (_tmp15_ != NULL) {
		ApplicationAccountContext* _tmp16_;
		_tmp16_ = context;
		_tmp14_ = _tmp16_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GeeMap* _tmp17_;
		GearyFolder* _tmp18_;
		_tmp17_ = self->priv->folder_information;
		_tmp18_ = folder;
		_tmp13_ = !gee_map_has_key (_tmp17_, _tmp18_);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GearyFolder* _tmp19_;
		GearyFolder* _tmp20_;
		GearyFolder* _tmp21_;
		GeeMap* _tmp22_;
		GearyFolder* _tmp23_;
		GearyFolder* _tmp24_;
		ApplicationAccountContext* _tmp25_;
		GCancellable* _tmp26_;
		GCancellable* _tmp27_;
		ApplicationNotificationPluginContextMonitorInformation* _tmp28_;
		ApplicationNotificationPluginContextMonitorInformation* _tmp29_;
		_tmp19_ = folder;
		g_signal_connect_object (_tmp19_, "email-locally-appended", (GCallback) _application_notification_plugin_context_on_email_locally_appended_geary_folder_email_locally_appended, self, 0);
		_tmp20_ = folder;
		g_signal_connect_object (_tmp20_, "email-flags-changed", (GCallback) _application_notification_plugin_context_on_email_flags_changed_geary_folder_email_flags_changed, self, 0);
		_tmp21_ = folder;
		g_signal_connect_object (_tmp21_, "email-removed", (GCallback) _application_notification_plugin_context_on_email_removed_geary_folder_email_removed, self, 0);
		_tmp22_ = self->priv->folder_information;
		_tmp23_ = folder;
		_tmp24_ = folder;
		_tmp25_ = context;
		_tmp26_ = application_account_context_get_cancellable (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = application_notification_plugin_context_monitor_information_new (_tmp24_, _tmp27_);
		_tmp29_ = _tmp28_;
		gee_map_set (_tmp22_, _tmp23_, _tmp29_);
		_g_object_unref0 (_tmp29_);
	}
	_g_object_unref0 (context);
	_g_object_unref0 (folder);
}

/** Stops monitoring a folder for new messages. */
static void
application_notification_plugin_context_real_stop_monitoring_folder (PluginNotificationContext* base,
                                                                     PluginFolder* target)
{
	ApplicationNotificationPluginContext * self;
	GearyFolder* folder = NULL;
	ApplicationPluginManagerPluginGlobals* _tmp0_;
	ApplicationFolderStoreFactory* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	GearyFolder* _tmp3_;
	GearyFolder* _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	g_return_if_fail (PLUGIN_IS_FOLDER (target));
	_tmp0_ = self->priv->globals;
	_tmp1_ = application_plugin_manager_plugin_globals_get_folders (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_folder_store_factory_to_engine_folder (_tmp2_, target);
	folder = _tmp3_;
	_tmp4_ = folder;
	if (_tmp4_ != NULL) {
		GearyFolder* _tmp5_;
		_tmp5_ = folder;
		application_notification_plugin_context_remove_folder (self, _tmp5_);
	}
	_g_object_unref0 (folder);
}

/** Determines if a folder is currently being monitored. */
static gboolean
application_notification_plugin_context_real_is_monitoring_folder (PluginNotificationContext* base,
                                                                   PluginFolder* target)
{
	ApplicationNotificationPluginContext * self;
	GeeMap* _tmp0_;
	ApplicationPluginManagerPluginGlobals* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	ApplicationFolderStoreFactory* _tmp3_;
	GearyFolder* _tmp4_;
	GearyFolder* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	g_return_val_if_fail (PLUGIN_IS_FOLDER (target), FALSE);
	_tmp0_ = self->priv->folder_information;
	_tmp1_ = self->priv->globals;
	_tmp2_ = application_plugin_manager_plugin_globals_get_folders (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = application_folder_store_factory_to_engine_folder (_tmp3_, target);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_map_has_key (_tmp0_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

void
application_notification_plugin_context_destroy (ApplicationNotificationPluginContext* self)
{
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_ = 0;
	gpointer* _tmp5_;
	GearyFolder** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	_tmp0_ = self->priv->folder_information;
	_tmp1_ = gee_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_g_object_unref0 (_tmp3_);
	{
		GearyFolder** monitored_collection = NULL;
		gint monitored_collection_length1 = 0;
		gint _monitored_collection_size_ = 0;
		gint monitored_it = 0;
		monitored_collection = _tmp6_;
		monitored_collection_length1 = _tmp6__length1;
		for (monitored_it = 0; monitored_it < monitored_collection_length1; monitored_it = monitored_it + 1) {
			GearyFolder* _tmp7_;
			GearyFolder* monitored = NULL;
			_tmp7_ = _g_object_ref0 (monitored_collection[monitored_it]);
			monitored = _tmp7_;
			{
				GearyFolder* _tmp8_;
				_tmp8_ = monitored;
				application_notification_plugin_context_remove_folder (self, _tmp8_);
				_g_object_unref0 (monitored);
			}
		}
		monitored_collection = (_vala_array_free (monitored_collection, monitored_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ApplicationNotificationPluginContext* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->info);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}

static gboolean
_____lambda147_ (Block35Data* _data35_,
                 GearyEmailIdentifier* id)
{
	ApplicationNotificationPluginContext* self;
	ApplicationNotificationPluginContextMonitorInformation* _tmp0_;
	GeeSet* _tmp1_;
	gboolean result;
	self = _data35_->self;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (id, GEARY_TYPE_EMAIL_IDENTIFIER), FALSE);
	_tmp0_ = _data35_->info;
	_tmp1_ = _tmp0_->recent_ids;
	result = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), id);
	return result;
}

static gboolean
______lambda147__gee_predicate (gconstpointer g,
                                gpointer self)
{
	gboolean result;
	result = _____lambda147_ (self, (GearyEmailIdentifier*) g);
	return result;
}

void
application_notification_plugin_context_clear_new_messages (ApplicationNotificationPluginContext* self,
                                                            GearyFolder* location,
                                                            GeeSet* visible)
{
	Block35Data* _data35_;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	ApplicationNotificationPluginContextMonitorInformation* _tmp2_;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (location, GEARY_TYPE_FOLDER));
	g_return_if_fail ((visible == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (visible, GEE_TYPE_SET));
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = self->priv->folder_information;
	_tmp1_ = gee_map_get (_tmp0_, location);
	_data35_->info = (ApplicationNotificationPluginContextMonitorInformation*) _tmp1_;
	_tmp2_ = _data35_->info;
	if (_tmp2_ != NULL) {
		{
			GeeIterator* _conversation_it = NULL;
			GeeIterator* _tmp3_;
			_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (visible, GEE_TYPE_ITERABLE, GeeIterable));
			_conversation_it = _tmp3_;
			while (TRUE) {
				GeeIterator* _tmp4_;
				GearyAppConversation* conversation = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				GearyAppConversation* _tmp7_;
				GeeCollection* _tmp8_;
				GeeCollection* _tmp9_;
				GearyIterable* _tmp10_;
				GearyIterable* _tmp11_;
				gboolean _tmp12_;
				_tmp4_ = _conversation_it;
				if (!gee_iterator_next (_tmp4_)) {
					break;
				}
				_tmp5_ = _conversation_it;
				_tmp6_ = gee_iterator_get (_tmp5_);
				conversation = (GearyAppConversation*) _tmp6_;
				_tmp7_ = conversation;
				_tmp8_ = geary_app_conversation_get_email_ids (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = geary_traverse (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp11_ = _tmp10_;
				_tmp12_ = geary_iterable_any (_tmp11_, ______lambda147__gee_predicate, block35_data_ref (_data35_), block35_data_unref);
				_g_object_unref0 (_tmp11_);
				_g_object_unref0 (_tmp9_);
				if (_tmp12_) {
					GeeSet* old_ids = NULL;
					ApplicationNotificationPluginContextMonitorInformation* _tmp13_;
					GeeSet* _tmp14_;
					GeeSet* _tmp15_;
					ApplicationNotificationPluginContextMonitorInformation* _tmp16_;
					GeeHashSet* _tmp17_;
					ApplicationNotificationPluginContextMonitorInformation* _tmp18_;
					GeeSet* _tmp19_;
					_tmp13_ = _data35_->info;
					_tmp14_ = _tmp13_->recent_ids;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					old_ids = _tmp15_;
					_tmp16_ = _data35_->info;
					_tmp17_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (_tmp16_->recent_ids);
					_tmp16_->recent_ids = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_SET, GeeSet);
					_tmp18_ = _data35_->info;
					_tmp19_ = old_ids;
					application_notification_plugin_context_update_count (self, _tmp18_, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
					_g_object_unref0 (old_ids);
					_g_object_unref0 (conversation);
					break;
				}
				_g_object_unref0 (conversation);
			}
			_g_object_unref0 (_conversation_it);
		}
	}
	block35_data_unref (_data35_);
	_data35_ = NULL;
}

static void
application_notification_plugin_context_new_messages (ApplicationNotificationPluginContext* self,
                                                      ApplicationNotificationPluginContextMonitorInformation* info,
                                                      GeeCollection* emails)
{
	GeeCollection* added = NULL;
	GeeHashSet* _tmp0_;
	GeeCollection* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_IS_MONITOR_INFORMATION (info));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	added = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		GeeIterator* _email_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (emails, GEE_TYPE_ITERABLE, GeeIterable));
		_email_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			GearyEmail* email = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			GearyEmail* _tmp6_;
			GearyEmailFlags* _tmp7_;
			GearyEmailFlags* _tmp8_;
			_tmp2_ = _email_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _email_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			email = (GearyEmail*) _tmp4_;
			_tmp6_ = email;
			_tmp7_ = geary_email_get_email_flags (_tmp6_);
			_tmp8_ = _tmp7_;
			if (geary_email_flags_is_unread (_tmp8_)) {
				GeeSet* _tmp9_;
				GearyEmail* _tmp10_;
				GearyEmailIdentifier* _tmp11_;
				GearyEmailIdentifier* _tmp12_;
				_tmp9_ = info->recent_ids;
				_tmp10_ = email;
				_tmp11_ = geary_email_get_id (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp5_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				GeeCollection* _tmp13_;
				GearyEmail* _tmp14_;
				GearyEmailIdentifier* _tmp15_;
				GearyEmailIdentifier* _tmp16_;
				_tmp13_ = added;
				_tmp14_ = email;
				_tmp15_ = geary_email_get_id (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_collection_add (_tmp13_, _tmp16_);
			}
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	_tmp17_ = added;
	_tmp18_ = gee_collection_get_size (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		GeeCollection* _tmp20_;
		_tmp20_ = added;
		application_notification_plugin_context_update_count (self, info, TRUE, _tmp20_);
	}
	_g_object_unref0 (added);
}

static void
application_notification_plugin_context_retire_new_messages (ApplicationNotificationPluginContext* self,
                                                             GearyFolder* folder,
                                                             GeeCollection* email_ids)
{
	ApplicationNotificationPluginContextMonitorInformation* info = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeCollection* removed = NULL;
	GeeHashSet* _tmp2_;
	GeeCollection* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email_ids, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->folder_information;
	_tmp1_ = gee_map_get (_tmp0_, folder);
	info = (ApplicationNotificationPluginContextMonitorInformation*) _tmp1_;
	_tmp2_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	removed = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		GeeIterator* _email_id_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (email_ids, GEE_TYPE_ITERABLE, GeeIterable));
		_email_id_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GearyEmailIdentifier* email_id = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			ApplicationNotificationPluginContextMonitorInformation* _tmp7_;
			GeeSet* _tmp8_;
			GearyEmailIdentifier* _tmp9_;
			_tmp4_ = _email_id_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _email_id_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			email_id = (GearyEmailIdentifier*) _tmp6_;
			_tmp7_ = info;
			_tmp8_ = _tmp7_->recent_ids;
			_tmp9_ = email_id;
			if (gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), _tmp9_)) {
				GeeCollection* _tmp10_;
				GearyEmailIdentifier* _tmp11_;
				_tmp10_ = removed;
				_tmp11_ = email_id;
				gee_collection_add (_tmp10_, _tmp11_);
			}
			_g_object_unref0 (email_id);
		}
		_g_object_unref0 (_email_id_it);
	}
	_tmp12_ = removed;
	_tmp13_ = gee_collection_get_size (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ > 0) {
		ApplicationNotificationPluginContextMonitorInformation* _tmp15_;
		GeeCollection* _tmp16_;
		_tmp15_ = info;
		_tmp16_ = removed;
		application_notification_plugin_context_update_count (self, _tmp15_, FALSE, _tmp16_);
	}
	_g_object_unref0 (removed);
	_g_object_unref0 (info);
}

static void
application_notification_plugin_context_update_count (ApplicationNotificationPluginContext* self,
                                                      ApplicationNotificationPluginContextMonitorInformation* info,
                                                      gboolean arrived,
                                                      GeeCollection* delta)
{
	PluginFolder* folder = NULL;
	ApplicationPluginManagerPluginGlobals* _tmp0_;
	ApplicationFolderStoreFactory* _tmp1_;
	ApplicationFolderStoreFactory* _tmp2_;
	GearyFolder* _tmp3_;
	PluginFolder* _tmp4_;
	ApplicationAccountContext* context = NULL;
	ApplicationClient* _tmp5_;
	ApplicationController* _tmp6_;
	ApplicationController* _tmp7_;
	GearyFolder* _tmp8_;
	GearyAccount* _tmp9_;
	GearyAccount* _tmp10_;
	GearyAccountInformation* _tmp11_;
	GearyAccountInformation* _tmp12_;
	ApplicationAccountContext* _tmp13_;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_IS_MONITOR_INFORMATION (info));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (delta, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->globals;
	_tmp1_ = application_plugin_manager_plugin_globals_get_folders (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = info->folder;
	_tmp4_ = application_folder_store_factory_to_plugin_folder (_tmp2_, _tmp3_);
	folder = _tmp4_;
	_tmp5_ = self->priv->application;
	_tmp6_ = application_client_get_controller (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = info->folder;
	_tmp9_ = geary_folder_get_account (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = geary_account_get_information (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = application_account_interface_get_context_for_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface), _tmp12_);
	context = _tmp13_;
	if (arrived) {
		ApplicationAccountContext* _tmp15_;
		_tmp15_ = context;
		_tmp14_ = _tmp15_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gint _tmp16_;
		gint _tmp17_;
		PluginFolder* _tmp18_;
		GeeSet* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		ApplicationPluginManagerPluginGlobals* _tmp22_;
		ApplicationEmailStoreFactory* _tmp23_;
		ApplicationEmailStoreFactory* _tmp24_;
		ApplicationAccountContext* _tmp25_;
		GeeCollection* _tmp26_;
		GeeCollection* _tmp27_;
		_tmp16_ = gee_collection_get_size (delta);
		_tmp17_ = _tmp16_;
		self->_total_new_messages = self->_total_new_messages + _tmp17_;
		_tmp18_ = folder;
		_tmp19_ = info->recent_ids;
		_tmp20_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->globals;
		_tmp23_ = application_plugin_manager_plugin_globals_get_email (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = context;
		_tmp26_ = application_email_store_factory_to_plugin_ids (_tmp24_, delta, _tmp25_);
		_tmp27_ = _tmp26_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_NOTIFICATION_CONTEXT, PluginNotificationContext), "new-messages-arrived", _tmp18_, _tmp21_, _tmp27_);
		_g_object_unref0 (_tmp27_);
	} else {
		gint _tmp28_;
		gint _tmp29_;
		PluginFolder* _tmp30_;
		GeeSet* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp28_ = gee_collection_get_size (delta);
		_tmp29_ = _tmp28_;
		self->_total_new_messages = self->_total_new_messages - _tmp29_;
		_tmp30_ = folder;
		_tmp31_ = info->recent_ids;
		_tmp32_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp33_ = _tmp32_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_NOTIFICATION_CONTEXT, PluginNotificationContext), "new-messages-retired", _tmp30_, _tmp33_);
	}
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "total-new-messages");
	_g_object_unref0 (context);
	_g_object_unref0 (folder);
}

static void
application_notification_plugin_context_remove_folder (ApplicationNotificationPluginContext* self,
                                                       GearyFolder* target)
{
	ApplicationNotificationPluginContextMonitorInformation* info = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	ApplicationNotificationPluginContextMonitorInformation* _tmp2_;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, GEARY_TYPE_FOLDER));
	_tmp0_ = self->priv->folder_information;
	_tmp1_ = gee_map_get (_tmp0_, target);
	info = (ApplicationNotificationPluginContextMonitorInformation*) _tmp1_;
	_tmp2_ = info;
	if (_tmp2_ != NULL) {
		guint _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		ApplicationNotificationPluginContextMonitorInformation* _tmp6_;
		GeeSet* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		GeeMap* _tmp14_;
		g_signal_parse_name ("email-locally-appended", GEARY_TYPE_FOLDER, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (target, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _application_notification_plugin_context_on_email_locally_appended_geary_folder_email_locally_appended, self);
		g_signal_parse_name ("email-flags-changed", GEARY_TYPE_FOLDER, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (target, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _application_notification_plugin_context_on_email_flags_changed_geary_folder_email_flags_changed, self);
		g_signal_parse_name ("email-removed", GEARY_TYPE_FOLDER, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (target, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _application_notification_plugin_context_on_email_removed_geary_folder_email_removed, self);
		_tmp6_ = info;
		_tmp7_ = _tmp6_->recent_ids;
		_tmp8_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp9_ = _tmp8_;
		if (!_tmp9_) {
			ApplicationNotificationPluginContextMonitorInformation* _tmp10_;
			GeeSet* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp10_ = info;
			_tmp11_ = _tmp10_->recent_ids;
			_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp13_ = _tmp12_;
			self->_total_new_messages = self->_total_new_messages - _tmp13_;
			g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "total-new-messages");
		}
		_tmp14_ = self->priv->folder_information;
		gee_map_unset (_tmp14_, target, NULL);
	}
	_g_object_unref0 (info);
}

static void
application_notification_plugin_context_do_process_new_email_data_free (gpointer _data)
{
	ApplicationNotificationPluginContextDoProcessNewEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->email_ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationNotificationPluginContextDoProcessNewEmailData, _data_);
}

static void
application_notification_plugin_context_do_process_new_email (ApplicationNotificationPluginContext* self,
                                                              GearyFolder* folder,
                                                              GeeCollection* email_ids,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	ApplicationNotificationPluginContextDoProcessNewEmailData* _data_;
	ApplicationNotificationPluginContext* _tmp0_;
	GearyFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email_ids, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (ApplicationNotificationPluginContextDoProcessNewEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_notification_plugin_context_do_process_new_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp1_;
	_tmp2_ = _g_object_ref0 (email_ids);
	_g_object_unref0 (_data_->email_ids);
	_data_->email_ids = _tmp2_;
	application_notification_plugin_context_do_process_new_email_co (_data_);
}

static void
application_notification_plugin_context_do_process_new_email_finish (ApplicationNotificationPluginContext* self,
                                                                     GAsyncResult* _res_)
{
	ApplicationNotificationPluginContextDoProcessNewEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_notification_plugin_context_do_process_new_email_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_)
{
	ApplicationNotificationPluginContextDoProcessNewEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_notification_plugin_context_do_process_new_email_co (_data_);
}

static gboolean
application_notification_plugin_context_do_process_new_email_co (ApplicationNotificationPluginContextDoProcessNewEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->folder_information;
	_data_->_tmp1_ = gee_map_get (_data_->_tmp0_, _data_->folder);
	_data_->info = (ApplicationNotificationPluginContextMonitorInformation*) _data_->_tmp1_;
	_data_->_tmp2_ = _data_->info;
	if (_data_->_tmp2_ != NULL) {
		_data_->list = NULL;
		{
			_data_->_tmp4_ = _data_->info;
			_data_->_tmp5_ = _data_->_tmp4_->cancellable;
			_data_->_state_ = 1;
			geary_folder_list_email_by_sparse_id_async (_data_->folder, _data_->email_ids, APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_REQUIRED_FIELDS, GEARY_FOLDER_LIST_FLAGS_NONE, _data_->_tmp5_, application_notification_plugin_context_do_process_new_email_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp6_ = geary_folder_list_email_by_sparse_id_finish (_data_->folder, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp3_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp3_;
			_data_->_tmp3_ = NULL;
			_g_object_unref0 (_data_->list);
			_data_->list = _data_->_tmp7_;
			_g_object_unref0 (_data_->_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp8_ = _data_->err;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			g_warning ("application-notification-plugin-context.vala:299: Unable to list new e" \
"mail for notification: %s", _data_->_tmp9_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->list);
			_g_object_unref0 (_data_->info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->list;
		if (_data_->_tmp11_ != NULL) {
			_data_->_tmp12_ = _data_->list;
			_data_->_tmp13_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_tmp10_ = !_data_->_tmp14_;
		} else {
			_data_->_tmp10_ = FALSE;
		}
		if (_data_->_tmp10_) {
			_data_->_tmp15_ = _data_->info;
			_data_->_tmp16_ = _data_->list;
			application_notification_plugin_context_new_messages (_data_->self, _data_->_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
		} else {
			_data_->_tmp17_ = gee_collection_get_size (_data_->email_ids);
			_data_->_tmp18_ = _data_->_tmp17_;
			g_warning ("application-notification-plugin-context.vala:306: %d new emails, but n" \
"one could be listed for notification", _data_->_tmp18_);
		}
		_g_object_unref0 (_data_->list);
	}
	_g_object_unref0 (_data_->info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_notification_plugin_context_on_email_locally_appended (ApplicationNotificationPluginContext* self,
                                                                   GearyFolder* folder,
                                                                   GeeCollection* email_ids)
{
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email_ids, GEE_TYPE_COLLECTION));
	application_notification_plugin_context_do_process_new_email (self, folder, email_ids, NULL, NULL);
}

static void
application_notification_plugin_context_on_email_flags_changed (ApplicationNotificationPluginContext* self,
                                                                GearyFolder* folder,
                                                                GeeMap* ids)
{
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_MAP));
	_tmp0_ = gee_map_get_keys (ids);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	application_notification_plugin_context_retire_new_messages (self, folder, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (_tmp2_);
}

static void
application_notification_plugin_context_on_email_removed (ApplicationNotificationPluginContext* self,
                                                          GearyFolder* folder,
                                                          GeeCollection* ids)
{
	g_return_if_fail (APPLICATION_IS_NOTIFICATION_PLUGIN_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	application_notification_plugin_context_retire_new_messages (self, folder, ids);
}

static inline gpointer
application_notification_plugin_context_contact_store_impl_get_instance_private (ApplicationNotificationPluginContextContactStoreImpl* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationNotificationPluginContextContactStoreImpl_private_offset);
}

static ApplicationNotificationPluginContextContactStoreImpl*
application_notification_plugin_context_contact_store_impl_construct (GType object_type,
                                                                      ApplicationContactStore* backing)
{
	ApplicationNotificationPluginContextContactStoreImpl * self = NULL;
	ApplicationContactStore* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONTACT_STORE (backing), NULL);
	self = (ApplicationNotificationPluginContextContactStoreImpl*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (backing);
	_g_object_unref0 (self->priv->backing);
	self->priv->backing = _tmp0_;
	return self;
}

static ApplicationNotificationPluginContextContactStoreImpl*
application_notification_plugin_context_contact_store_impl_new (ApplicationContactStore* backing)
{
	return application_notification_plugin_context_contact_store_impl_construct (APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL, backing);
}

static void
application_notification_plugin_context_contact_store_impl_real_search_data_free (gpointer _data)
{
	ApplicationNotificationPluginContextContactStoreImplSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationNotificationPluginContextContactStoreImplSearchData, _data_);
}

static void
application_notification_plugin_context_contact_store_impl_real_search (PluginContactStore* base,
                                                                        const gchar* query,
                                                                        guint min_importance,
                                                                        guint limit,
                                                                        GCancellable* cancellable,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_)
{
	ApplicationNotificationPluginContextContactStoreImpl * self;
	ApplicationNotificationPluginContextContactStoreImplSearchData* _data_;
	ApplicationNotificationPluginContextContactStoreImpl* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (query != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL, ApplicationNotificationPluginContextContactStoreImpl);
	_data_ = g_slice_new0 (ApplicationNotificationPluginContextContactStoreImplSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_notification_plugin_context_contact_store_impl_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp1_;
	_data_->min_importance = min_importance;
	_data_->limit = limit;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_notification_plugin_context_contact_store_impl_real_search_co (_data_);
}

static GeeCollection*
application_notification_plugin_context_contact_store_impl_search_finish (PluginContactStore* base,
                                                                          GAsyncResult* _res_,
                                                                          GError** error)
{
	GeeCollection* result;
	ApplicationNotificationPluginContextContactStoreImplSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_notification_plugin_context_contact_store_impl_search_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_)
{
	ApplicationNotificationPluginContextContactStoreImplSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_notification_plugin_context_contact_store_impl_real_search_co (_data_);
}

static gboolean
application_notification_plugin_context_contact_store_impl_real_search_co (ApplicationNotificationPluginContextContactStoreImplSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->backing;
	_data_->_state_ = 1;
	application_contact_store_search (_data_->_tmp1_, _data_->query, _data_->min_importance, _data_->limit, _data_->cancellable, application_notification_plugin_context_contact_store_impl_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = application_contact_store_search_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_notification_plugin_context_contact_store_impl_real_load_data_free (gpointer _data)
{
	ApplicationNotificationPluginContextContactStoreImplLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mailbox);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationNotificationPluginContextContactStoreImplLoadData, _data_);
}

static void
application_notification_plugin_context_contact_store_impl_real_load (PluginContactStore* base,
                                                                      GearyRFC822MailboxAddress* mailbox,
                                                                      GCancellable* cancellable,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_)
{
	ApplicationNotificationPluginContextContactStoreImpl * self;
	ApplicationNotificationPluginContextContactStoreImplLoadData* _data_;
	ApplicationNotificationPluginContextContactStoreImpl* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mailbox, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL, ApplicationNotificationPluginContextContactStoreImpl);
	_data_ = g_slice_new0 (ApplicationNotificationPluginContextContactStoreImplLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_notification_plugin_context_contact_store_impl_real_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (mailbox);
	_g_object_unref0 (_data_->mailbox);
	_data_->mailbox = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_notification_plugin_context_contact_store_impl_real_load_co (_data_);
}

static ApplicationContact*
application_notification_plugin_context_contact_store_impl_load_finish (PluginContactStore* base,
                                                                        GAsyncResult* _res_,
                                                                        GError** error)
{
	ApplicationContact* result;
	ApplicationNotificationPluginContextContactStoreImplLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
application_notification_plugin_context_contact_store_impl_load_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_)
{
	ApplicationNotificationPluginContextContactStoreImplLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_notification_plugin_context_contact_store_impl_real_load_co (_data_);
}

static gboolean
application_notification_plugin_context_contact_store_impl_real_load_co (ApplicationNotificationPluginContextContactStoreImplLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->backing;
	_data_->_state_ = 1;
	application_contact_store_load (_data_->_tmp1_, _data_->mailbox, _data_->cancellable, application_notification_plugin_context_contact_store_impl_load_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = application_contact_store_load_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_notification_plugin_context_contact_store_impl_class_init (ApplicationNotificationPluginContextContactStoreImplClass * klass,
                                                                       gpointer klass_data)
{
	application_notification_plugin_context_contact_store_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationNotificationPluginContextContactStoreImpl_private_offset);
	G_OBJECT_CLASS (klass)->finalize = application_notification_plugin_context_contact_store_impl_finalize;
}

static void
application_notification_plugin_context_contact_store_impl_plugin_contact_store_interface_init (PluginContactStoreIface * iface,
                                                                                                gpointer iface_data)
{
	application_notification_plugin_context_contact_store_impl_plugin_contact_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (PluginContactStore*, const gchar*, guint, guint, GCancellable*, GAsyncReadyCallback, gpointer)) application_notification_plugin_context_contact_store_impl_real_search;
	iface->search_finish = (GeeCollection* (*) (PluginContactStore*, GAsyncResult*, GError**)) application_notification_plugin_context_contact_store_impl_search_finish;
	iface->load = (void (*) (PluginContactStore*, GearyRFC822MailboxAddress*, GCancellable*, GAsyncReadyCallback, gpointer)) application_notification_plugin_context_contact_store_impl_real_load;
	iface->load_finish = (ApplicationContact* (*) (PluginContactStore*, GAsyncResult*, GError**)) application_notification_plugin_context_contact_store_impl_load_finish;
}

static void
application_notification_plugin_context_contact_store_impl_instance_init (ApplicationNotificationPluginContextContactStoreImpl * self,
                                                                          gpointer klass)
{
	self->priv = application_notification_plugin_context_contact_store_impl_get_instance_private (self);
}

static void
application_notification_plugin_context_contact_store_impl_finalize (GObject * obj)
{
	ApplicationNotificationPluginContextContactStoreImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_CONTACT_STORE_IMPL, ApplicationNotificationPluginContextContactStoreImpl);
	_g_object_unref0 (self->priv->backing);
	G_OBJECT_CLASS (application_notification_plugin_context_contact_store_impl_parent_class)->finalize (obj);
}

static GType
application_notification_plugin_context_contact_store_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationNotificationPluginContextContactStoreImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_notification_plugin_context_contact_store_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationNotificationPluginContextContactStoreImpl), 0, (GInstanceInitFunc) application_notification_plugin_context_contact_store_impl_instance_init, NULL };
	static const GInterfaceInfo plugin_contact_store_info = { (GInterfaceInitFunc) application_notification_plugin_context_contact_store_impl_plugin_contact_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType application_notification_plugin_context_contact_store_impl_type_id;
	application_notification_plugin_context_contact_store_impl_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationNotificationPluginContextContactStoreImpl", &g_define_type_info, 0);
	g_type_add_interface_static (application_notification_plugin_context_contact_store_impl_type_id, PLUGIN_TYPE_CONTACT_STORE, &plugin_contact_store_info);
	ApplicationNotificationPluginContextContactStoreImpl_private_offset = g_type_add_instance_private (application_notification_plugin_context_contact_store_impl_type_id, sizeof (ApplicationNotificationPluginContextContactStoreImplPrivate));
	return application_notification_plugin_context_contact_store_impl_type_id;
}

static GType
application_notification_plugin_context_contact_store_impl_get_type (void)
{
	static volatile gsize application_notification_plugin_context_contact_store_impl_type_id__once = 0;
	if (g_once_init_enter (&application_notification_plugin_context_contact_store_impl_type_id__once)) {
		GType application_notification_plugin_context_contact_store_impl_type_id;
		application_notification_plugin_context_contact_store_impl_type_id = application_notification_plugin_context_contact_store_impl_get_type_once ();
		g_once_init_leave (&application_notification_plugin_context_contact_store_impl_type_id__once, application_notification_plugin_context_contact_store_impl_type_id);
	}
	return application_notification_plugin_context_contact_store_impl_type_id__once;
}

static ApplicationNotificationPluginContextMonitorInformation*
application_notification_plugin_context_monitor_information_construct (GType object_type,
                                                                       GearyFolder* folder,
                                                                       GCancellable* cancellable)
{
	ApplicationNotificationPluginContextMonitorInformation * self = NULL;
	GearyFolder* _tmp0_;
	GCancellable* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, GEARY_TYPE_FOLDER), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (ApplicationNotificationPluginContextMonitorInformation*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (folder);
	_g_object_unref0 (self->folder);
	self->folder = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp1_;
	return self;
}

static ApplicationNotificationPluginContextMonitorInformation*
application_notification_plugin_context_monitor_information_new (GearyFolder* folder,
                                                                 GCancellable* cancellable)
{
	return application_notification_plugin_context_monitor_information_construct (APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION, folder, cancellable);
}

static void
application_notification_plugin_context_monitor_information_class_init (ApplicationNotificationPluginContextMonitorInformationClass * klass,
                                                                        gpointer klass_data)
{
	application_notification_plugin_context_monitor_information_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = application_notification_plugin_context_monitor_information_finalize;
}

static void
application_notification_plugin_context_monitor_information_instance_init (ApplicationNotificationPluginContextMonitorInformation * self,
                                                                           gpointer klass)
{
	GeeHashSet* _tmp0_;
	self->cancellable = NULL;
	_tmp0_ = gee_hash_set_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->recent_ids = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
}

static void
application_notification_plugin_context_monitor_information_finalize (GObject * obj)
{
	ApplicationNotificationPluginContextMonitorInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION, ApplicationNotificationPluginContextMonitorInformation);
	_g_object_unref0 (self->folder);
	_g_object_unref0 (self->cancellable);
	_g_object_unref0 (self->recent_ids);
	G_OBJECT_CLASS (application_notification_plugin_context_monitor_information_parent_class)->finalize (obj);
}

static GType
application_notification_plugin_context_monitor_information_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationNotificationPluginContextMonitorInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_notification_plugin_context_monitor_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationNotificationPluginContextMonitorInformation), 0, (GInstanceInitFunc) application_notification_plugin_context_monitor_information_instance_init, NULL };
	GType application_notification_plugin_context_monitor_information_type_id;
	application_notification_plugin_context_monitor_information_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationNotificationPluginContextMonitorInformation", &g_define_type_info, 0);
	return application_notification_plugin_context_monitor_information_type_id;
}

static GType
application_notification_plugin_context_monitor_information_get_type (void)
{
	static volatile gsize application_notification_plugin_context_monitor_information_type_id__once = 0;
	if (g_once_init_enter (&application_notification_plugin_context_monitor_information_type_id__once)) {
		GType application_notification_plugin_context_monitor_information_type_id;
		application_notification_plugin_context_monitor_information_type_id = application_notification_plugin_context_monitor_information_get_type_once ();
		g_once_init_leave (&application_notification_plugin_context_monitor_information_type_id__once, application_notification_plugin_context_monitor_information_type_id);
	}
	return application_notification_plugin_context_monitor_information_type_id__once;
}

static void
application_notification_plugin_context_class_init (ApplicationNotificationPluginContextClass * klass,
                                                    gpointer klass_data)
{
	application_notification_plugin_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationNotificationPluginContext_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_notification_plugin_context_get_property;
	G_OBJECT_CLASS (klass)->finalize = application_notification_plugin_context_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TOTAL_NEW_MESSAGES_PROPERTY, application_notification_plugin_context_properties[APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TOTAL_NEW_MESSAGES_PROPERTY] = g_param_spec_int ("total-new-messages", "total-new-messages", "total-new-messages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
application_notification_plugin_context_plugin_notification_context_interface_init (PluginNotificationContextIface * iface,
                                                                                    gpointer iface_data)
{
	application_notification_plugin_context_plugin_notification_context_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_contacts_for_folder = (void (*) (PluginNotificationContext*, PluginFolder*, GAsyncReadyCallback, gpointer)) application_notification_plugin_context_real_get_contacts_for_folder;
	iface->get_contacts_for_folder_finish = (PluginContactStore* (*) (PluginNotificationContext*, GAsyncResult*, GError**)) application_notification_plugin_context_get_contacts_for_folder_finish;
	iface->should_notify_new_messages = (gboolean (*) (PluginNotificationContext*, PluginFolder*)) application_notification_plugin_context_real_should_notify_new_messages;
	iface->get_new_message_count = (gint (*) (PluginNotificationContext*, PluginFolder*, GError**)) application_notification_plugin_context_real_get_new_message_count;
	iface->start_monitoring_folder = (void (*) (PluginNotificationContext*, PluginFolder*)) application_notification_plugin_context_real_start_monitoring_folder;
	iface->stop_monitoring_folder = (void (*) (PluginNotificationContext*, PluginFolder*)) application_notification_plugin_context_real_stop_monitoring_folder;
	iface->is_monitoring_folder = (gboolean (*) (PluginNotificationContext*, PluginFolder*)) application_notification_plugin_context_real_is_monitoring_folder;
	iface->get_total_new_messages = application_notification_plugin_context_real_get_total_new_messages;
}

static void
application_notification_plugin_context_instance_init (ApplicationNotificationPluginContext * self,
                                                       gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = application_notification_plugin_context_get_instance_private (self);
	self->_total_new_messages = 0;
	_tmp0_ = gee_hash_map_new (GEARY_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TYPE_MONITOR_INFORMATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->folder_information = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
}

static void
application_notification_plugin_context_finalize (GObject * obj)
{
	ApplicationNotificationPluginContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	_g_object_unref0 (self->priv->folder_information);
	_application_plugin_manager_plugin_globals_unref0 (self->priv->globals);
	_application_plugin_manager_plugin_context_unref0 (self->priv->plugin);
	G_OBJECT_CLASS (application_notification_plugin_context_parent_class)->finalize (obj);
}

/**
 * Implementation of the notification plugin extension context.
 */
static GType
application_notification_plugin_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationNotificationPluginContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_notification_plugin_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationNotificationPluginContext), 0, (GInstanceInitFunc) application_notification_plugin_context_instance_init, NULL };
	static const GInterfaceInfo plugin_notification_context_info = { (GInterfaceInitFunc) application_notification_plugin_context_plugin_notification_context_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType application_notification_plugin_context_type_id;
	application_notification_plugin_context_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationNotificationPluginContext", &g_define_type_info, 0);
	g_type_add_interface_static (application_notification_plugin_context_type_id, PLUGIN_TYPE_NOTIFICATION_CONTEXT, &plugin_notification_context_info);
	ApplicationNotificationPluginContext_private_offset = g_type_add_instance_private (application_notification_plugin_context_type_id, sizeof (ApplicationNotificationPluginContextPrivate));
	return application_notification_plugin_context_type_id;
}

GType
application_notification_plugin_context_get_type (void)
{
	static volatile gsize application_notification_plugin_context_type_id__once = 0;
	if (g_once_init_enter (&application_notification_plugin_context_type_id__once)) {
		GType application_notification_plugin_context_type_id;
		application_notification_plugin_context_type_id = application_notification_plugin_context_get_type_once ();
		g_once_init_leave (&application_notification_plugin_context_type_id__once, application_notification_plugin_context_type_id);
	}
	return application_notification_plugin_context_type_id__once;
}

static void
_vala_application_notification_plugin_context_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	ApplicationNotificationPluginContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_NOTIFICATION_PLUGIN_CONTEXT, ApplicationNotificationPluginContext);
	switch (property_id) {
		case APPLICATION_NOTIFICATION_PLUGIN_CONTEXT_TOTAL_NEW_MESSAGES_PROPERTY:
		g_value_set_int (value, plugin_notification_context_get_total_new_messages (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_NOTIFICATION_CONTEXT, PluginNotificationContext)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

