/* imap-server-data-type.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-server-data-type.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

/**
 * A descriptor of what flavor of {@link ServerData} is found in the response.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.2]] for more information.
 */
gchar*
geary_imap_server_data_type_to_string (GearyImapServerDataType self)
{
	gchar* result;
	switch (self) {
		case GEARY_IMAP_SERVER_DATA_TYPE_CAPABILITY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("capability");
			result = _tmp0_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_EXISTS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("exists");
			result = _tmp1_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_EXPUNGE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("expunge");
			result = _tmp2_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_FETCH:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("fetch");
			result = _tmp3_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_FLAGS:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("flags");
			result = _tmp4_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_LIST:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("list");
			result = _tmp5_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_LSUB:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("lsub");
			result = _tmp6_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_NAMESPACE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("namespace");
			result = _tmp7_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_RECENT:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("recent");
			result = _tmp8_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_SEARCH:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("search");
			result = _tmp9_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_STATUS:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("status");
			result = _tmp10_;
			return result;
		}
		case GEARY_IMAP_SERVER_DATA_TYPE_XLIST:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("xlist");
			result = _tmp11_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

/**
     * Convert a {@link StringParameter} into a ServerDataType.
     *
     * @throws ImapError.PARSE_ERROR if the StringParameter is not recognized as a ServerDataType.
     */
GearyImapServerDataType
geary_imap_server_data_type_from_parameter (GearyImapStringParameter* param,
                                            GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	GError* _inner_error0_ = NULL;
	GearyImapServerDataType result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (param), 0);
	_tmp0_ = geary_imap_string_parameter_as_lower (param);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("capability")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_CAPABILITY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("exists")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_EXISTS;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("expunge")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("expunged"))))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_EXPUNGE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("fetch")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_FETCH;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("flags")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_FLAGS;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("list")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_LIST;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("lsub")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_LSUB;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("namespace")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_NAMESPACE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("recent")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_RECENT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("search")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_SEARCH;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("status")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_STATUS;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("xlist")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_SERVER_DATA_TYPE_XLIST;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				GError* _tmp6_;
				GError* _tmp7_;
				_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (param, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
				_tmp5_ = _tmp4_;
				_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "\"%s\" is not a valid server data type", _tmp5_);
				_tmp7_ = _tmp6_;
				_g_free0 (_tmp5_);
				_inner_error0_ = _tmp7_;
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return 0;
				}
			}
		}
	}
}

GearyImapStringParameter*
geary_imap_server_data_type_to_parameter (GearyImapServerDataType self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyImapAtomParameter* _tmp2_;
	GearyImapStringParameter* _tmp3_;
	GearyImapStringParameter* result;
	_tmp0_ = geary_imap_server_data_type_to_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_atom_parameter_new (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * Examines the {@link RootParameters} looking for a ServerDataType.
     *
     * IMAP server responses don't offer a regular format for server data declaretions.  This method
     * parses for the common patterns and returns the ServerDataType it detects.
     *
     * See [[http://tools.ietf.org/html/rfc3501#section-7.2]] for more information.
     */
GearyImapServerDataType
geary_imap_server_data_type_from_response (GearyImapRootParameters* root,
                                           GError** error)
{
	GearyImapStringParameter* firstparam = NULL;
	GearyImapStringParameter* _tmp0_;
	GearyImapStringParameter* _tmp1_;
	GearyImapStringParameter* secondparam = NULL;
	GearyImapStringParameter* _tmp7_;
	GearyImapStringParameter* _tmp8_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _inner_error0_ = NULL;
	GearyImapServerDataType result;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), 0);
	_tmp0_ = geary_imap_list_parameter_get_if_string (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1);
	firstparam = _tmp0_;
	_tmp1_ = firstparam;
	if (_tmp1_ != NULL) {
		GearyImapStringParameter* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GQuark _tmp6_ = 0U;
		static GQuark _tmp5_label0 = 0;
		static GQuark _tmp5_label1 = 0;
		static GQuark _tmp5_label2 = 0;
		static GQuark _tmp5_label3 = 0;
		static GQuark _tmp5_label4 = 0;
		static GQuark _tmp5_label5 = 0;
		static GQuark _tmp5_label6 = 0;
		static GQuark _tmp5_label7 = 0;
		_tmp2_ = firstparam;
		_tmp3_ = geary_imap_string_parameter_as_lower (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
		g_free (_tmp4_);
		if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("capability")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_CAPABILITY;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("flags")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_FLAGS;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("list")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_LIST;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("lsub")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_LSUB;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("namespace")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_NAMESPACE;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("search")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_SEARCH;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("status")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_STATUS;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label7) ? _tmp5_label7 : (_tmp5_label7 = g_quark_from_static_string ("xlist")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_XLIST;
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	}
	_tmp7_ = geary_imap_list_parameter_get_if_string (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2);
	secondparam = _tmp7_;
	_tmp8_ = secondparam;
	if (_tmp8_ != NULL) {
		GearyImapStringParameter* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GQuark _tmp13_ = 0U;
		static GQuark _tmp12_label0 = 0;
		static GQuark _tmp12_label1 = 0;
		static GQuark _tmp12_label2 = 0;
		static GQuark _tmp12_label3 = 0;
		static GQuark _tmp12_label4 = 0;
		_tmp9_ = secondparam;
		_tmp10_ = geary_imap_string_parameter_as_lower (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
		g_free (_tmp11_);
		if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("exists")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_EXISTS;
					_g_object_unref0 (secondparam);
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if ((_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("expunge")))) || (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("expunged"))))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_EXPUNGE;
					_g_object_unref0 (secondparam);
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp13_ == ((0 != _tmp12_label3) ? _tmp12_label3 : (_tmp12_label3 = g_quark_from_static_string ("fetch")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_FETCH;
					_g_object_unref0 (secondparam);
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else if (_tmp13_ == ((0 != _tmp12_label4) ? _tmp12_label4 : (_tmp12_label4 = g_quark_from_static_string ("recent")))) {
			switch (0) {
				default:
				{
					result = GEARY_IMAP_SERVER_DATA_TYPE_RECENT;
					_g_object_unref0 (secondparam);
					_g_object_unref0 (firstparam);
					return result;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	}
	_tmp14_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
	_tmp15_ = _tmp14_;
	_tmp16_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "\"%s\" unrecognized server data", _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_inner_error0_ = _tmp17_;
	if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (secondparam);
		_g_object_unref0 (firstparam);
		return 0;
	} else {
		_g_object_unref0 (secondparam);
		_g_object_unref0 (firstparam);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

 G_GNUC_NO_INLINE static GType
geary_imap_server_data_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_SERVER_DATA_TYPE_CAPABILITY, "GEARY_IMAP_SERVER_DATA_TYPE_CAPABILITY", "capability"}, {GEARY_IMAP_SERVER_DATA_TYPE_EXISTS, "GEARY_IMAP_SERVER_DATA_TYPE_EXISTS", "exists"}, {GEARY_IMAP_SERVER_DATA_TYPE_EXPUNGE, "GEARY_IMAP_SERVER_DATA_TYPE_EXPUNGE", "expunge"}, {GEARY_IMAP_SERVER_DATA_TYPE_FETCH, "GEARY_IMAP_SERVER_DATA_TYPE_FETCH", "fetch"}, {GEARY_IMAP_SERVER_DATA_TYPE_FLAGS, "GEARY_IMAP_SERVER_DATA_TYPE_FLAGS", "flags"}, {GEARY_IMAP_SERVER_DATA_TYPE_LIST, "GEARY_IMAP_SERVER_DATA_TYPE_LIST", "list"}, {GEARY_IMAP_SERVER_DATA_TYPE_LSUB, "GEARY_IMAP_SERVER_DATA_TYPE_LSUB", "lsub"}, {GEARY_IMAP_SERVER_DATA_TYPE_NAMESPACE, "GEARY_IMAP_SERVER_DATA_TYPE_NAMESPACE", "namespace"}, {GEARY_IMAP_SERVER_DATA_TYPE_RECENT, "GEARY_IMAP_SERVER_DATA_TYPE_RECENT", "recent"}, {GEARY_IMAP_SERVER_DATA_TYPE_SEARCH, "GEARY_IMAP_SERVER_DATA_TYPE_SEARCH", "search"}, {GEARY_IMAP_SERVER_DATA_TYPE_STATUS, "GEARY_IMAP_SERVER_DATA_TYPE_STATUS", "status"}, {GEARY_IMAP_SERVER_DATA_TYPE_XLIST, "GEARY_IMAP_SERVER_DATA_TYPE_XLIST", "xlist"}, {0, NULL, NULL}};
	GType geary_imap_server_data_type_type_id;
	geary_imap_server_data_type_type_id = g_enum_register_static ("GearyImapServerDataType", values);
	return geary_imap_server_data_type_type_id;
}

GType
geary_imap_server_data_type_get_type (void)
{
	static gsize geary_imap_server_data_type_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_server_data_type_type_id__once)) {
		GType geary_imap_server_data_type_type_id;
		geary_imap_server_data_type_type_id = geary_imap_server_data_type_get_type_once ();
		g_once_init_leave (&geary_imap_server_data_type_type_id__once, geary_imap_server_data_type_type_id);
	}
	return geary_imap_server_data_type_type_id__once;
}

