/* smtp-request.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from smtp-request.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GearySmtpParamSpecRequest GearySmtpParamSpecRequest;

struct _GearySmtpRequestPrivate {
	GearySmtpCommand _cmd;
	gchar** _args;
	gint _args_length1;
	gint __args_size_;
};

struct _GearySmtpParamSpecRequest {
	GParamSpec parent_instance;
};

static gint GearySmtpRequest_private_offset;
static gpointer geary_smtp_request_parent_class = NULL;
static gpointer geary_smtp_helo_request_parent_class = NULL;
static gpointer geary_smtp_ehlo_request_parent_class = NULL;
static gpointer geary_smtp_mail_request_parent_class = NULL;
static gpointer geary_smtp_rcpt_request_parent_class = NULL;

static void geary_smtp_request_set_cmd (GearySmtpRequest* self,
                                 GearySmtpCommand value);
static void geary_smtp_request_set_args (GearySmtpRequest* self,
                                  gchar** value,
                                  gint value_length1);
static gchar** _vala_array_dup16 (gchar** self,
                           gssize length);
static void geary_smtp_request_finalize (GearySmtpRequest * obj);
static GType geary_smtp_request_get_type_once (void);
static GType geary_smtp_helo_request_get_type_once (void);
static GType geary_smtp_ehlo_request_get_type_once (void);
static GType geary_smtp_mail_request_get_type_once (void);
static GType geary_smtp_rcpt_request_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_smtp_request_get_instance_private (GearySmtpRequest* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpRequest_private_offset);
}

GearySmtpCommand
geary_smtp_request_get_cmd (GearySmtpRequest* self)
{
	GearySmtpCommand result;
	g_return_val_if_fail (GEARY_SMTP_IS_REQUEST (self), 0);
	result = self->priv->_cmd;
	return result;
}

static void
geary_smtp_request_set_cmd (GearySmtpRequest* self,
                            GearySmtpCommand value)
{
	g_return_if_fail (GEARY_SMTP_IS_REQUEST (self));
	self->priv->_cmd = value;
}

gchar**
geary_smtp_request_get_args (GearySmtpRequest* self,
                             gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (GEARY_SMTP_IS_REQUEST (self), NULL);
	_tmp0_ = self->priv->_args;
	_tmp0__length1 = self->priv->_args_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup16 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
geary_smtp_request_set_args (GearySmtpRequest* self,
                             gchar** value,
                             gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (GEARY_SMTP_IS_REQUEST (self));
	_tmp0_ = (value != NULL) ? _vala_array_dup16 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_args = _tmp0_;
	self->priv->_args_length1 = _tmp0__length1;
	self->priv->__args_size_ = self->priv->_args_length1;
}

GearySmtpRequest*
geary_smtp_request_construct (GType object_type,
                              GearySmtpCommand cmd,
                              gchar** args,
                              gint args_length1)
{
	GearySmtpRequest* self = NULL;
	self = (GearySmtpRequest*) g_type_create_instance (object_type);
	geary_smtp_request_set_cmd (self, cmd);
	geary_smtp_request_set_args (self, args, args_length1);
	return self;
}

GearySmtpRequest*
geary_smtp_request_new (GearySmtpCommand cmd,
                        gchar** args,
                        gint args_length1)
{
	return geary_smtp_request_construct (GEARY_SMTP_TYPE_REQUEST, cmd, args, args_length1);
}

gchar*
geary_smtp_request_serialize (GearySmtpRequest* self)
{
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GString* builder = NULL;
	GString* _tmp9_;
	GString* _tmp10_;
	GearySmtpCommand _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_ = 0;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GString* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* result;
	g_return_val_if_fail (GEARY_SMTP_IS_REQUEST (self), NULL);
	_tmp1_ = geary_smtp_request_get_args (self, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	if (_tmp3_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_ = 0;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp4_ = geary_smtp_request_get_args (self, &_tmp5_);
		_tmp4__length1 = _tmp5_;
		_tmp6_ = _tmp4_;
		_tmp6__length1 = _tmp4__length1;
		_tmp0_ = _tmp6__length1 == 0;
	}
	if (_tmp0_) {
		GearySmtpCommand _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->_cmd;
		_tmp8_ = geary_smtp_command_serialize (_tmp7_);
		result = _tmp8_;
		return result;
	}
	_tmp9_ = g_string_new ("");
	builder = _tmp9_;
	_tmp10_ = builder;
	_tmp11_ = self->priv->_cmd;
	_tmp12_ = geary_smtp_command_serialize (_tmp11_);
	_tmp13_ = _tmp12_;
	g_string_append (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = geary_smtp_request_get_args (self, &_tmp15_);
	_tmp14__length1 = _tmp15_;
	_tmp16_ = _tmp14_;
	_tmp16__length1 = _tmp14__length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp16_;
		arg_collection_length1 = _tmp16__length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			gchar* _tmp17_;
			gchar* arg = NULL;
			_tmp17_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp17_;
			{
				GString* _tmp18_;
				GString* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = builder;
				g_string_append_c (_tmp18_, ' ');
				_tmp19_ = builder;
				_tmp20_ = arg;
				g_string_append (_tmp19_, _tmp20_);
				_g_free0 (arg);
			}
		}
	}
	_tmp21_ = builder;
	_tmp22_ = _tmp21_->str;
	_tmp23_ = g_strdup (_tmp22_);
	result = _tmp23_;
	_g_string_free0 (builder);
	return result;
}

gchar*
geary_smtp_request_to_string (GearySmtpRequest* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_SMTP_IS_REQUEST (self), NULL);
	_tmp0_ = geary_smtp_request_serialize (self);
	result = _tmp0_;
	return result;
}

static void
geary_smtp_value_request_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_smtp_value_request_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_smtp_request_unref (value->data[0].v_pointer);
	}
}

static void
geary_smtp_value_request_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_smtp_request_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_smtp_value_request_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_smtp_value_request_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearySmtpRequest * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_smtp_request_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_smtp_value_request_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GearySmtpRequest ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_smtp_request_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_smtp_param_spec_request (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GearySmtpParamSpecRequest* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_SMTP_TYPE_REQUEST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_smtp_value_get_request (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_REQUEST), NULL);
	return value->data[0].v_pointer;
}

void
geary_smtp_value_set_request (GValue* value,
                              gpointer v_object)
{
	GearySmtpRequest * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_SMTP_TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_smtp_request_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_smtp_request_unref (old);
	}
}

void
geary_smtp_value_take_request (GValue* value,
                               gpointer v_object)
{
	GearySmtpRequest * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_SMTP_TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_SMTP_TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_smtp_request_unref (old);
	}
}

static void
geary_smtp_request_class_init (GearySmtpRequestClass * klass,
                               gpointer klass_data)
{
	geary_smtp_request_parent_class = g_type_class_peek_parent (klass);
	((GearySmtpRequestClass *) klass)->finalize = geary_smtp_request_finalize;
	g_type_class_adjust_private_offset (klass, &GearySmtpRequest_private_offset);
}

static void
geary_smtp_request_instance_init (GearySmtpRequest * self,
                                  gpointer klass)
{
	self->priv = geary_smtp_request_get_instance_private (self);
	self->ref_count = 1;
}

static void
geary_smtp_request_finalize (GearySmtpRequest * obj)
{
	GearySmtpRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest);
	g_signal_handlers_destroy (self);
	self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL);
}

 G_GNUC_NO_INLINE static GType
geary_smtp_request_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_smtp_value_request_init, geary_smtp_value_request_free_value, geary_smtp_value_request_copy_value, geary_smtp_value_request_peek_pointer, "p", geary_smtp_value_request_collect_value, "p", geary_smtp_value_request_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpRequest), 0, (GInstanceInitFunc) geary_smtp_request_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_smtp_request_type_id;
	geary_smtp_request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearySmtpRequest", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearySmtpRequest_private_offset = g_type_add_instance_private (geary_smtp_request_type_id, sizeof (GearySmtpRequestPrivate));
	return geary_smtp_request_type_id;
}

GType
geary_smtp_request_get_type (void)
{
	static gsize geary_smtp_request_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_request_type_id__once)) {
		GType geary_smtp_request_type_id;
		geary_smtp_request_type_id = geary_smtp_request_get_type_once ();
		g_once_init_leave (&geary_smtp_request_type_id__once, geary_smtp_request_type_id);
	}
	return geary_smtp_request_type_id__once;
}

gpointer
geary_smtp_request_ref (gpointer instance)
{
	GearySmtpRequest * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_smtp_request_unref (gpointer instance)
{
	GearySmtpRequest * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_SMTP_REQUEST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GearySmtpHeloRequest*
geary_smtp_helo_request_construct (GType object_type,
                                   const gchar* domain)
{
	GearySmtpHeloRequest* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = g_strdup (domain);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (GearySmtpHeloRequest*) geary_smtp_request_construct (object_type, GEARY_SMTP_COMMAND_HELO, _tmp2_, (gint) 1);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

GearySmtpHeloRequest*
geary_smtp_helo_request_new (const gchar* domain)
{
	return geary_smtp_helo_request_construct (GEARY_SMTP_TYPE_HELO_REQUEST, domain);
}

GearySmtpHeloRequest*
geary_smtp_helo_request_construct_for_local_address (GType object_type,
                                                     GInetAddress* local_addr)
{
	GearySmtpHeloRequest* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (local_addr, g_inet_address_get_type ()), NULL);
	_tmp0_ = g_inet_address_to_string (local_addr);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("[%s]", _tmp1_);
	_tmp3_ = _tmp2_;
	self = (GearySmtpHeloRequest*) geary_smtp_helo_request_construct (object_type, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

GearySmtpHeloRequest*
geary_smtp_helo_request_new_for_local_address (GInetAddress* local_addr)
{
	return geary_smtp_helo_request_construct_for_local_address (GEARY_SMTP_TYPE_HELO_REQUEST, local_addr);
}

static void
geary_smtp_helo_request_class_init (GearySmtpHeloRequestClass * klass,
                                    gpointer klass_data)
{
	geary_smtp_helo_request_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_smtp_helo_request_instance_init (GearySmtpHeloRequest * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_smtp_helo_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpHeloRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_helo_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpHeloRequest), 0, (GInstanceInitFunc) geary_smtp_helo_request_instance_init, NULL };
	GType geary_smtp_helo_request_type_id;
	geary_smtp_helo_request_type_id = g_type_register_static (GEARY_SMTP_TYPE_REQUEST, "GearySmtpHeloRequest", &g_define_type_info, 0);
	return geary_smtp_helo_request_type_id;
}

GType
geary_smtp_helo_request_get_type (void)
{
	static gsize geary_smtp_helo_request_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_helo_request_type_id__once)) {
		GType geary_smtp_helo_request_type_id;
		geary_smtp_helo_request_type_id = geary_smtp_helo_request_get_type_once ();
		g_once_init_leave (&geary_smtp_helo_request_type_id__once, geary_smtp_helo_request_type_id);
	}
	return geary_smtp_helo_request_type_id__once;
}

GearySmtpEhloRequest*
geary_smtp_ehlo_request_construct (GType object_type,
                                   const gchar* domain)
{
	GearySmtpEhloRequest* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = g_strdup (domain);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (GearySmtpEhloRequest*) geary_smtp_request_construct (object_type, GEARY_SMTP_COMMAND_EHLO, _tmp2_, (gint) 1);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

GearySmtpEhloRequest*
geary_smtp_ehlo_request_new (const gchar* domain)
{
	return geary_smtp_ehlo_request_construct (GEARY_SMTP_TYPE_EHLO_REQUEST, domain);
}

GearySmtpEhloRequest*
geary_smtp_ehlo_request_construct_for_local_address (GType object_type,
                                                     GInetAddress* local_addr)
{
	GearySmtpEhloRequest* self = NULL;
	const gchar* _tmp0_ = NULL;
	GSocketFamily _tmp1_;
	GSocketFamily _tmp2_;
	gchar* prefix = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (local_addr, g_inet_address_get_type ()), NULL);
	_tmp1_ = g_inet_address_get_family (local_addr);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == G_SOCKET_FAMILY_IPV6) {
		_tmp0_ = "IPv6:";
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	prefix = _tmp3_;
	_tmp4_ = g_inet_address_to_string (local_addr);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("[%s%s]", prefix, _tmp5_);
	_tmp7_ = _tmp6_;
	self = (GearySmtpEhloRequest*) geary_smtp_ehlo_request_construct (object_type, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (prefix);
	return self;
}

GearySmtpEhloRequest*
geary_smtp_ehlo_request_new_for_local_address (GInetAddress* local_addr)
{
	return geary_smtp_ehlo_request_construct_for_local_address (GEARY_SMTP_TYPE_EHLO_REQUEST, local_addr);
}

static void
geary_smtp_ehlo_request_class_init (GearySmtpEhloRequestClass * klass,
                                    gpointer klass_data)
{
	geary_smtp_ehlo_request_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_smtp_ehlo_request_instance_init (GearySmtpEhloRequest * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_smtp_ehlo_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpEhloRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_ehlo_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpEhloRequest), 0, (GInstanceInitFunc) geary_smtp_ehlo_request_instance_init, NULL };
	GType geary_smtp_ehlo_request_type_id;
	geary_smtp_ehlo_request_type_id = g_type_register_static (GEARY_SMTP_TYPE_REQUEST, "GearySmtpEhloRequest", &g_define_type_info, 0);
	return geary_smtp_ehlo_request_type_id;
}

GType
geary_smtp_ehlo_request_get_type (void)
{
	static gsize geary_smtp_ehlo_request_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_ehlo_request_type_id__once)) {
		GType geary_smtp_ehlo_request_type_id;
		geary_smtp_ehlo_request_type_id = geary_smtp_ehlo_request_get_type_once ();
		g_once_init_leave (&geary_smtp_ehlo_request_type_id__once, geary_smtp_ehlo_request_type_id);
	}
	return geary_smtp_ehlo_request_type_id__once;
}

GearySmtpMailRequest*
geary_smtp_mail_request_construct (GType object_type,
                                   GearyRFC822MailboxAddress* reverse_path)
{
	GearySmtpMailRequest* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (reverse_path), NULL);
	_tmp0_ = geary_rf_c822_mailbox_address_to_rfc822_address (reverse_path);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("from:<%s>", _tmp1_);
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	self = (GearySmtpMailRequest*) geary_smtp_request_construct (object_type, GEARY_SMTP_COMMAND_MAIL, _tmp4_, (gint) 1);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp1_);
	return self;
}

GearySmtpMailRequest*
geary_smtp_mail_request_new (GearyRFC822MailboxAddress* reverse_path)
{
	return geary_smtp_mail_request_construct (GEARY_SMTP_TYPE_MAIL_REQUEST, reverse_path);
}

static void
geary_smtp_mail_request_class_init (GearySmtpMailRequestClass * klass,
                                    gpointer klass_data)
{
	geary_smtp_mail_request_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_smtp_mail_request_instance_init (GearySmtpMailRequest * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_smtp_mail_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpMailRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_mail_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpMailRequest), 0, (GInstanceInitFunc) geary_smtp_mail_request_instance_init, NULL };
	GType geary_smtp_mail_request_type_id;
	geary_smtp_mail_request_type_id = g_type_register_static (GEARY_SMTP_TYPE_REQUEST, "GearySmtpMailRequest", &g_define_type_info, 0);
	return geary_smtp_mail_request_type_id;
}

GType
geary_smtp_mail_request_get_type (void)
{
	static gsize geary_smtp_mail_request_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_mail_request_type_id__once)) {
		GType geary_smtp_mail_request_type_id;
		geary_smtp_mail_request_type_id = geary_smtp_mail_request_get_type_once ();
		g_once_init_leave (&geary_smtp_mail_request_type_id__once, geary_smtp_mail_request_type_id);
	}
	return geary_smtp_mail_request_type_id__once;
}

GearySmtpRcptRequest*
geary_smtp_rcpt_request_construct (GType object_type,
                                   GearyRFC822MailboxAddress* to)
{
	GearySmtpRcptRequest* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (to), NULL);
	_tmp0_ = geary_rf_c822_mailbox_address_to_rfc822_address (to);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("to:<%s>", _tmp1_);
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	self = (GearySmtpRcptRequest*) geary_smtp_request_construct (object_type, GEARY_SMTP_COMMAND_RCPT, _tmp4_, (gint) 1);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp1_);
	return self;
}

GearySmtpRcptRequest*
geary_smtp_rcpt_request_new (GearyRFC822MailboxAddress* to)
{
	return geary_smtp_rcpt_request_construct (GEARY_SMTP_TYPE_RCPT_REQUEST, to);
}

static void
geary_smtp_rcpt_request_class_init (GearySmtpRcptRequestClass * klass,
                                    gpointer klass_data)
{
	geary_smtp_rcpt_request_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_smtp_rcpt_request_instance_init (GearySmtpRcptRequest * self,
                                       gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_smtp_rcpt_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpRcptRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_rcpt_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpRcptRequest), 0, (GInstanceInitFunc) geary_smtp_rcpt_request_instance_init, NULL };
	GType geary_smtp_rcpt_request_type_id;
	geary_smtp_rcpt_request_type_id = g_type_register_static (GEARY_SMTP_TYPE_REQUEST, "GearySmtpRcptRequest", &g_define_type_info, 0);
	return geary_smtp_rcpt_request_type_id;
}

GType
geary_smtp_rcpt_request_get_type (void)
{
	static gsize geary_smtp_rcpt_request_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_rcpt_request_type_id__once)) {
		GType geary_smtp_rcpt_request_type_id;
		geary_smtp_rcpt_request_type_id = geary_smtp_rcpt_request_get_type_once ();
		g_once_init_leave (&geary_smtp_rcpt_request_type_id__once, geary_smtp_rcpt_request_type_id);
	}
	return geary_smtp_rcpt_request_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

