static const char* contrast_curve_cl_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <https://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright 2013 Carlos Zubieta <czubieta.dev@gmail.com>                     \n"
" */                                                                           \n"
"                                                                              \n"
"__kernel void cl_contrast_curve(__global const float2 *in,                    \n"
"                                __global       float2 *out,                   \n"
"                                __global       float  *curve,                 \n"
"                                               int     num_sampling_points)   \n"
"{                                                                             \n"
"  int gid     = get_global_id(0);                                             \n"
"  float2 in_v = in[gid];                                                      \n"
"                                                                              \n"
"  int idx = (int) fmin(num_sampling_points - 1.0f,                            \n"
"                       fmax(0.0f,                                             \n"
"                            in_v.x * num_sampling_points));                   \n"
"                                                                              \n"
"  out[gid] = (float2) (curve[idx], in_v.y);                                   \n"
"}                                                                             \n"
;
