/* gitg-action-support.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-action-support.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "config.h"
#include <gio/gio.h>
#include <libgit2-glib/ggit.h>
#include "libgitg.h"
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#define GITG_ACTION_SUPPORT_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_ACTION_SUPPORT (gitg_action_support_get_type ())
#define GITG_ACTION_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_ACTION_SUPPORT, GitgActionSupport))
#define GITG_ACTION_SUPPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_ACTION_SUPPORT, GitgActionSupportClass))
#define GITG_IS_ACTION_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_ACTION_SUPPORT))
#define GITG_IS_ACTION_SUPPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_ACTION_SUPPORT))
#define GITG_ACTION_SUPPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_ACTION_SUPPORT, GitgActionSupportClass))

typedef struct _GitgActionSupport GitgActionSupport;
typedef struct _GitgActionSupportClass GitgActionSupportClass;
typedef struct _GitgActionSupportPrivate GitgActionSupportPrivate;
enum  {
	GITG_ACTION_SUPPORT_0_PROPERTY,
	GITG_ACTION_SUPPORT_APPLICATION_PROPERTY,
	GITG_ACTION_SUPPORT_ACTION_INTERFACE_PROPERTY,
	GITG_ACTION_SUPPORT_NUM_PROPERTIES
};
static GParamSpec* gitg_action_support_properties[GITG_ACTION_SUPPORT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __vala_GgitStatusOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitStatusOptions_free (var), NULL)))
typedef struct _GitgActionSupportWorkingDirectoryDirtyData GitgActionSupportWorkingDirectoryDirtyData;

#define GITG_TYPE_SIMPLE_NOTIFICATION (gitg_simple_notification_get_type ())
#define GITG_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotification))
#define GITG_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))
#define GITG_IS_SIMPLE_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_IS_SIMPLE_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_SIMPLE_NOTIFICATION))
#define GITG_SIMPLE_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_SIMPLE_NOTIFICATION, GitgSimpleNotificationClass))

typedef struct _GitgSimpleNotification GitgSimpleNotification;
typedef struct _GitgSimpleNotificationClass GitgSimpleNotificationClass;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgActionSupportSaveStashData GitgActionSupportSaveStashData;
typedef struct _GitgActionSupportStashIfNeededData GitgActionSupportStashIfNeededData;
typedef struct _Block3Data Block3Data;

#define GITG_TYPE_REF_ACTION_CHECKOUT (gitg_ref_action_checkout_get_type ())
#define GITG_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckout))
#define GITG_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))
#define GITG_IS_REF_ACTION_CHECKOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_IS_REF_ACTION_CHECKOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REF_ACTION_CHECKOUT))
#define GITG_REF_ACTION_CHECKOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REF_ACTION_CHECKOUT, GitgRefActionCheckoutClass))

typedef struct _GitgRefActionCheckout GitgRefActionCheckout;
typedef struct _GitgRefActionCheckoutClass GitgRefActionCheckoutClass;
typedef struct _GitgActionSupportCheckoutConflictsData GitgActionSupportCheckoutConflictsData;
typedef struct _Block4Data Block4Data;
typedef struct _GitgActionSupportCommitIndexData GitgActionSupportCommitIndexData;

struct _GitgActionSupport {
	GObject parent_instance;
	GitgActionSupportPrivate * priv;
};

struct _GitgActionSupportClass {
	GObjectClass parent_class;
};

struct _GitgActionSupportPrivate {
	GitgExtApplication* _application;
	GitgExtRefActionInterface* _action_interface;
};

struct _Block1Data {
	int _ref_count_;
	GitgActionSupport* self;
	GgitStatusOptions* options;
	gboolean is_dirty;
	gpointer _async_data_;
};

struct _GitgActionSupportWorkingDirectoryDirtyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgActionSupport* self;
	gboolean result;
	Block1Data* _data1_;
	GgitStatusOptions* _tmp0_;
};

struct _Block2Data {
	int _ref_count_;
	GitgActionSupport* self;
	GgitSignature* committer;
	GitgRef* head;
	gpointer _async_data_;
};

struct _GitgActionSupportSaveStashData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgActionSupport* self;
	GitgSimpleNotification* notification;
	GitgRef* head;
	gboolean result;
	Block2Data* _data2_;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GgitSignature* _tmp3_;
	GgitSignature* _tmp4_;
	GgitSignature* _tmp5_;
	GError* err;
	GError* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_;
};

struct _GitgActionSupportStashIfNeededData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgActionSupport* self;
	GitgSimpleNotification* notification;
	GitgRef* head;
	gboolean result;
	GitgExtUserQuery* q;
	GitgExtUserQuery* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgExtApplication* _tmp3_;
	GitgExtUserQuery* _tmp4_;
	gboolean _tmp5_;
};

struct _Block3Data {
	int _ref_count_;
	GitgActionSupport* self;
	GgitIndex* index;
	gpointer _async_data_;
};

struct _GitgActionSupportCheckoutConflictsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgActionSupport* self;
	GitgSimpleNotification* notification;
	GitgRef* reference;
	GgitIndex* index;
	GitgRef* head;
	gboolean result;
	Block3Data* _data3_;
	GitgRefActionCheckout* checkout;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgExtRefActionInterface* _tmp3_;
	GitgExtRefActionInterface* _tmp4_;
	GitgExtRefActionInterface* _tmp5_;
	GitgRefActionCheckout* _tmp6_;
	GitgRefActionCheckout* _tmp7_;
	GitgRefActionCheckout* _tmp8_;
	GError* err;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	GitgActionSupport* self;
	GgitOId* oid;
	GgitTree* head_tree;
	gpointer _async_data_;
};

struct _GitgActionSupportCommitIndexData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgActionSupport* self;
	GitgSimpleNotification* notification;
	GitgRef* reference;
	GgitIndex* index;
	GgitOId** parents;
	gint parents_length1;
	GgitSignature* author;
	gchar* message;
	GgitOId* result;
	Block4Data* _data4_;
	GgitSignature* committer;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GgitSignature* _tmp3_;
	GgitSignature* _tmp4_;
	GgitSignature* _tmp5_;
	GgitSignature* _tmp6_;
	GitgStage* stage;
	GitgExtApplication* _tmp8_;
	GitgExtApplication* _tmp9_;
	GitgExtApplication* _tmp10_;
	GitgRepository* _tmp11_;
	GitgRepository* _tmp12_;
	GitgRepository* _tmp13_;
	GitgStage* _tmp14_;
	GitgStage* _tmp15_;
	GitgStage* _tmp16_;
	GitgRef* head;
	gboolean ishead;
	gboolean _tmp17_;
	GitgCommit* commit;
	GgitObject* _tmp18_;
	GgitObject* _tmp19_;
	GitgCommit* _tmp20_;
	GError* e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GitgRef* _tmp25_;
	GitgCommit* _tmp26_;
	GgitTree* _tmp27_;
	GitgCommit* _tmp28_;
	GgitOId* _tmp29_;
	GgitOId** _tmp30_;
	GitgRef* _tmp31_;
	GitgRef* _tmp32_;
	GgitOId* _tmp33_;
	GitgStage* _tmp34_;
	GgitSignature* _tmp35_;
	GgitOId* _tmp36_;
	GgitOId* _tmp37_;
	GError* _vala1_e;
	GError* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GError* _vala2_e;
	GError* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GgitOId* _tmp46_;
	GgitOId* _tmp47_;
	GError* _inner_error0_;
};

static gint GitgActionSupport_private_offset;
static gpointer gitg_action_support_parent_class = NULL;

VALA_EXTERN GType gitg_action_support_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgActionSupport, g_object_unref)
VALA_EXTERN GitgActionSupport* gitg_action_support_new (GitgExtApplication* application,
                                            GitgExtRefActionInterface* action_interface);
VALA_EXTERN GitgActionSupport* gitg_action_support_construct (GType object_type,
                                                  GitgExtApplication* application,
                                                  GitgExtRefActionInterface* action_interface);
static void gitg_action_support_working_directory_dirty_data_free (gpointer _data);
VALA_EXTERN void gitg_action_support_working_directory_dirty (GitgActionSupport* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN gboolean gitg_action_support_working_directory_dirty_finish (GitgActionSupport* self,
                                                             GAsyncResult* _res_);
static gboolean gitg_action_support_working_directory_dirty_co (GitgActionSupportWorkingDirectoryDirtyData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void _vala_GgitStatusOptions_free (GgitStatusOptions* self);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GError** error);
VALA_EXTERN GitgExtApplication* gitg_action_support_get_application (GitgActionSupport* self);
static gint __lambda5_ (Block1Data* _data1_,
                 const gchar* path,
                 GgitStatusFlags flags);
static gint ___lambda5__ggit_status_callback (const gchar* path,
                                       GgitStatusFlags status_flags,
                                       gpointer self);
static void ___lambda4__gitg_async_thread_func (gpointer self,
                                         GError** error);
static void gitg_action_support_working_directory_dirty_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void gitg_action_support_save_stash_data_free (gpointer _data);
VALA_EXTERN GType gitg_simple_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgSimpleNotification, g_object_unref)
VALA_EXTERN void gitg_action_support_save_stash (GitgActionSupport* self,
                                     GitgSimpleNotification* notification,
                                     GitgRef* head,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN gboolean gitg_action_support_save_stash_finish (GitgActionSupport* self,
                                                GAsyncResult* _res_);
static gboolean gitg_action_support_save_stash_co (GitgActionSupportSaveStashData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda11_ (Block2Data* _data2_,
                   GError** error);
static void _vala_GgitOId_free (GgitOId* self);
static void ____lambda11__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_action_support_save_stash_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN void gitg_simple_notification_error (GitgSimpleNotification* self,
                                     const gchar* message);
VALA_EXTERN gboolean gitg_action_support_reference_is_head (GitgActionSupport* self,
                                                GitgRef* reference,
                                                GitgRef** head);
static void gitg_action_support_stash_if_needed_data_free (gpointer _data);
VALA_EXTERN void gitg_action_support_stash_if_needed (GitgActionSupport* self,
                                          GitgSimpleNotification* notification,
                                          GitgRef* head,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN gboolean gitg_action_support_stash_if_needed_finish (GitgActionSupport* self,
                                                     GAsyncResult* _res_);
static gboolean gitg_action_support_stash_if_needed_co (GitgActionSupportStashIfNeededData* _data_);
static void gitg_action_support_stash_if_needed_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void gitg_action_support_checkout_conflicts_data_free (gpointer _data);
VALA_EXTERN void gitg_action_support_checkout_conflicts (GitgActionSupport* self,
                                             GitgSimpleNotification* notification,
                                             GitgRef* reference,
                                             GgitIndex* index,
                                             GitgRef* head,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN gboolean gitg_action_support_checkout_conflicts_finish (GitgActionSupport* self,
                                                        GAsyncResult* _res_);
static gboolean gitg_action_support_checkout_conflicts_co (GitgActionSupportCheckoutConflictsData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void gitg_action_support_checkout_conflicts_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
VALA_EXTERN GType gitg_ref_action_checkout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRefActionCheckout, g_object_unref)
VALA_EXTERN GitgExtRefActionInterface* gitg_action_support_get_action_interface (GitgActionSupport* self);
VALA_EXTERN GitgRefActionCheckout* gitg_ref_action_checkout_new (GitgExtApplication* application,
                                                     GitgExtRefActionInterface* action_interface,
                                                     GitgRef* reference);
VALA_EXTERN GitgRefActionCheckout* gitg_ref_action_checkout_construct (GType object_type,
                                                           GitgExtApplication* application,
                                                           GitgExtRefActionInterface* action_interface,
                                                           GitgRef* reference);
VALA_EXTERN void gitg_ref_action_checkout_checkout (GitgRefActionCheckout* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN gboolean gitg_ref_action_checkout_checkout_finish (GitgRefActionCheckout* self,
                                                   GAsyncResult* _res_);
static void ___lambda18_ (Block3Data* _data3_,
                   GError** error);
static void ____lambda18__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_action_support_commit_index_data_free (gpointer _data);
VALA_EXTERN void gitg_action_support_commit_index (GitgActionSupport* self,
                                       GitgSimpleNotification* notification,
                                       GitgRef* reference,
                                       GgitIndex* index,
                                       GgitOId** parents,
                                       gint parents_length1,
                                       GgitSignature* author,
                                       const gchar* message,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN GgitOId* gitg_action_support_commit_index_finish (GitgActionSupport* self,
                                                  GAsyncResult* _res_);
static gboolean gitg_action_support_commit_index_co (GitgActionSupportCommitIndexData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void gitg_action_support_commit_index_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void ____lambda19_ (Block4Data* _data4_,
                    GError** error);
static void _____lambda19__gitg_async_thread_func (gpointer self,
                                            GError** error);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
VALA_EXTERN void gitg_action_support_set_application (GitgActionSupport* self,
                                          GitgExtApplication* value);
VALA_EXTERN void gitg_action_support_set_action_interface (GitgActionSupport* self,
                                               GitgExtRefActionInterface* value);
static void gitg_action_support_finalize (GObject * obj);
static GType gitg_action_support_get_type_once (void);
static void _vala_gitg_action_support_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gitg_action_support_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_action_support_get_instance_private (GitgActionSupport* self)
{
	return G_STRUCT_MEMBER_P (self, GitgActionSupport_private_offset);
}

GitgActionSupport*
gitg_action_support_construct (GType object_type,
                               GitgExtApplication* application,
                               GitgExtRefActionInterface* action_interface)
{
	GitgActionSupport * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (action_interface != NULL, NULL);
	self = (GitgActionSupport*) g_object_new (object_type, "application", application, "action-interface", action_interface, NULL);
	return self;
}

GitgActionSupport*
gitg_action_support_new (GitgExtApplication* application,
                         GitgExtRefActionInterface* action_interface)
{
	return gitg_action_support_construct (GITG_TYPE_ACTION_SUPPORT, application, action_interface);
}

static void
gitg_action_support_working_directory_dirty_data_free (gpointer _data)
{
	GitgActionSupportWorkingDirectoryDirtyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgActionSupportWorkingDirectoryDirtyData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gitg_action_support_working_directory_dirty (GitgActionSupport* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GitgActionSupportWorkingDirectoryDirtyData* _data_;
	GitgActionSupport* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgActionSupportWorkingDirectoryDirtyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_action_support_working_directory_dirty_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gitg_action_support_working_directory_dirty_co (_data_);
}

gboolean
gitg_action_support_working_directory_dirty_finish (GitgActionSupport* self,
                                                    GAsyncResult* _res_)
{
	gboolean result;
	GitgActionSupportWorkingDirectoryDirtyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
_vala_GgitStatusOptions_free (GgitStatusOptions* self)
{
	g_boxed_free (ggit_status_options_get_type (), self);
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GitgActionSupport* self;
		self = _data1_->self;
		__vala_GgitStatusOptions_free0 (_data1_->options);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gint
__lambda5_ (Block1Data* _data1_,
            const gchar* path,
            GgitStatusFlags flags)
{
	GitgActionSupport* self;
	gint result;
	self = _data1_->self;
	g_return_val_if_fail (path != NULL, 0);
	_data1_->is_dirty = TRUE;
	result = -1;
	return result;
}

static gint
___lambda5__ggit_status_callback (const gchar* path,
                                  GgitStatusFlags status_flags,
                                  gpointer self)
{
	gint result;
	result = __lambda5_ (self, path, status_flags);
	return result;
}

static void
__lambda4_ (Block1Data* _data1_,
            GError** error)
{
	GitgActionSupport* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgRepository* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	_tmp0_ = gitg_action_support_get_application (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gitg_ext_application_get_repository (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	ggit_repository_file_status_foreach ((GgitRepository*) _tmp5_, _data1_->options, ___lambda5__ggit_status_callback, _data1_, &_inner_error0_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
___lambda4__gitg_async_thread_func (gpointer self,
                                    GError** error)
{
	__lambda4_ (self, error);
}

static void
gitg_action_support_working_directory_dirty_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	GitgActionSupportWorkingDirectoryDirtyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_action_support_working_directory_dirty_co (_data_);
}

static gboolean
gitg_action_support_working_directory_dirty_co (GitgActionSupportWorkingDirectoryDirtyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = ggit_status_options_new (GGIT_STATUS_OPTION_EXCLUDE_SUBMODULES, GGIT_STATUS_SHOW_WORKDIR_ONLY, NULL);
	_data_->_data1_->options = _data_->_tmp0_;
	_data_->_data1_->is_dirty = FALSE;
	_data_->_state_ = 1;
	gitg_async_thread_try (___lambda4__gitg_async_thread_func, _data_->_data1_, gitg_action_support_working_directory_dirty_ready, _data_);
	return FALSE;
	_state_1:
	gitg_async_thread_try_finish (_data_->_res_);
	_data_->result = _data_->_data1_->is_dirty;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_action_support_save_stash_data_free (gpointer _data)
{
	GitgActionSupportSaveStashData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notification);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgActionSupportSaveStashData, _data_);
}

void
gitg_action_support_save_stash (GitgActionSupport* self,
                                GitgSimpleNotification* notification,
                                GitgRef* head,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GitgActionSupportSaveStashData* _data_;
	GitgActionSupport* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GitgRef* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_data_ = g_slice_new0 (GitgActionSupportSaveStashData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_action_support_save_stash_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (head);
	_g_object_unref0 (_data_->head);
	_data_->head = _tmp2_;
	gitg_action_support_save_stash_co (_data_);
}

gboolean
gitg_action_support_save_stash_finish (GitgActionSupport* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	GitgActionSupportSaveStashData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GitgActionSupport* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->committer);
		_g_object_unref0 (_data2_->head);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
___lambda11_ (Block2Data* _data2_,
              GError** error)
{
	GitgActionSupport* self;
	gchar* message = NULL;
	GitgExtApplication* _tmp32_;
	GitgExtApplication* _tmp33_;
	GitgExtApplication* _tmp34_;
	GitgRepository* _tmp35_;
	GitgRepository* _tmp36_;
	GitgRepository* _tmp37_;
	GgitSignature* _tmp38_;
	const gchar* _tmp39_;
	GgitOId* _tmp40_;
	GgitOId* _tmp41_;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	if (_data2_->head != NULL) {
		gchar* headname = NULL;
		GitgParsedRefName* _tmp0_;
		GitgParsedRefName* _tmp1_;
		GitgParsedRefName* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = gitg_ref_get_parsed_name (_data2_->head);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gitg_parsed_ref_name_get_shortname (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
		headname = _tmp5_;
		{
			GgitRef* _tmp6_ = NULL;
			GgitRef* _tmp7_;
			GgitObject* _tmp8_ = NULL;
			GgitObject* _tmp9_;
			GgitCommit* head_commit = NULL;
			GgitCommit* _tmp10_;
			gchar* shortid = NULL;
			GgitCommit* _tmp11_;
			GgitOId* _tmp12_;
			GgitOId* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* subject = NULL;
			GgitCommit* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp7_ = ggit_ref_resolve ((GgitRef*) _data2_->head, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp9_ = ggit_ref_lookup (_tmp6_, &_inner_error0_);
			_tmp8_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				goto __catch0_g_error;
			}
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, ggit_commit_get_type ()) ? ((GgitCommit*) _tmp8_) : NULL);
			head_commit = _tmp10_;
			_tmp11_ = head_commit;
			_tmp12_ = ggit_object_get_id ((GgitObject*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = ggit_oid_to_string (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = string_slice (_tmp15_, (glong) 0, (glong) 6);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			__vala_GgitOId_free0 (_tmp13_);
			shortid = _tmp17_;
			_tmp18_ = head_commit;
			_tmp19_ = ggit_commit_get_subject (_tmp18_);
			_tmp20_ = g_strdup (_tmp19_);
			subject = _tmp20_;
			_tmp21_ = headname;
			_tmp22_ = string_to_string (_tmp21_);
			_tmp23_ = shortid;
			_tmp24_ = string_to_string (_tmp23_);
			_tmp25_ = subject;
			_tmp26_ = string_to_string (_tmp25_);
			_tmp27_ = g_strconcat ("WIP on ", _tmp22_, ": ", _tmp24_, " ", _tmp26_, NULL);
			_g_free0 (message);
			message = _tmp27_;
			_g_free0 (subject);
			_g_free0 (shortid);
			_g_object_unref0 (head_commit);
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (_tmp6_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			g_clear_error (&_inner_error0_);
			_tmp28_ = headname;
			_tmp29_ = string_to_string (_tmp28_);
			_tmp30_ = g_strconcat ("WIP on ", _tmp29_, NULL);
			_g_free0 (message);
			message = _tmp30_;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (headname);
			_g_free0 (message);
			return;
		}
		_g_free0 (headname);
	} else {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("WIP on HEAD");
		_g_free0 (message);
		message = _tmp31_;
	}
	_tmp32_ = gitg_action_support_get_application (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp35_ = gitg_ext_application_get_repository (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp38_ = _data2_->committer;
	_tmp39_ = message;
	_tmp40_ = ggit_repository_save_stash ((GgitRepository*) _tmp37_, _tmp38_, _tmp39_, GGIT_STASH_DEFAULT, &_inner_error0_);
	_tmp41_ = _tmp40_;
	__vala_GgitOId_free0 (_tmp41_);
	_g_object_unref0 (_tmp37_);
	_g_object_unref0 (_tmp34_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (message);
		return;
	}
	_g_free0 (message);
}

static void
____lambda11__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda11_ (self, error);
}

static void
gitg_action_support_save_stash_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GitgActionSupportSaveStashData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_action_support_save_stash_co (_data_);
}

static gboolean
gitg_action_support_save_stash_co (GitgActionSupportSaveStashData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data2_->head);
	_data_->_data2_->head = _data_->head;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = gitg_action_support_get_application (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gitg_ext_application_get_verified_committer (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_data2_->committer = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->_data2_->committer;
	if (_data_->_tmp5_ == NULL) {
		_data_->result = FALSE;
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		gitg_async_thread (____lambda11__gitg_async_thread_func, _data_->_data2_, gitg_action_support_save_stash_ready, _data_);
		return FALSE;
		_state_1:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->err;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		_data_->_tmp8_ = g_strdup_printf (_ ("Failed to stash changes: %s"), _data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		gitg_simple_notification_error (_data_->notification, _data_->_tmp9_);
		_g_free0 (_data_->_tmp9_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->err);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
gitg_action_support_reference_is_head (GitgActionSupport* self,
                                       GitgRef* reference,
                                       GitgRef** head)
{
	GgitBranch* branch = NULL;
	GgitBranch* _tmp0_;
	GgitBranch* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (reference != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (reference, ggit_branch_get_type ()) ? ((GgitBranch*) reference) : NULL);
	branch = _tmp0_;
	_g_object_unref0 (*head);
	*head = NULL;
	_tmp1_ = branch;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (branch);
		return result;
	}
	{
		gboolean _tmp2_ = FALSE;
		GgitBranch* _tmp3_;
		GitgRef* _tmp4_ = NULL;
		GitgExtApplication* _tmp5_;
		GitgExtApplication* _tmp6_;
		GitgExtApplication* _tmp7_;
		GitgRepository* _tmp8_;
		GitgRepository* _tmp9_;
		GitgRepository* _tmp10_;
		GitgRef* _tmp11_;
		GitgRef* _tmp12_;
		GitgRef* _tmp13_;
		_tmp3_ = branch;
		_tmp2_ = ggit_branch_is_head (_tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp2_) {
			result = FALSE;
			_g_object_unref0 (branch);
			return result;
		}
		_tmp5_ = gitg_action_support_get_application (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gitg_ext_application_get_repository (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gitg_repository_lookup_reference (_tmp10_, "HEAD", &_inner_error0_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
		_tmp4_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (*head);
		*head = _tmp13_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		_g_object_unref0 (branch);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = (*head) != NULL;
	_g_object_unref0 (branch);
	return result;
}

static void
gitg_action_support_stash_if_needed_data_free (gpointer _data)
{
	GitgActionSupportStashIfNeededData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notification);
	_g_object_unref0 (_data_->head);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgActionSupportStashIfNeededData, _data_);
}

void
gitg_action_support_stash_if_needed (GitgActionSupport* self,
                                     GitgSimpleNotification* notification,
                                     GitgRef* head,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GitgActionSupportStashIfNeededData* _data_;
	GitgActionSupport* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GitgRef* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_data_ = g_slice_new0 (GitgActionSupportStashIfNeededData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_action_support_stash_if_needed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (head);
	_g_object_unref0 (_data_->head);
	_data_->head = _tmp2_;
	gitg_action_support_stash_if_needed_co (_data_);
}

gboolean
gitg_action_support_stash_if_needed_finish (GitgActionSupport* self,
                                            GAsyncResult* _res_)
{
	gboolean result;
	GitgActionSupportStashIfNeededData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
gitg_action_support_stash_if_needed_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GitgActionSupportStashIfNeededData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_action_support_stash_if_needed_co (_data_);
}

static gboolean
gitg_action_support_stash_if_needed_co (GitgActionSupportStashIfNeededData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	gitg_action_support_working_directory_dirty (_data_->self, gitg_action_support_stash_if_needed_ready, _data_);
	return FALSE;
	_state_1:
	if (gitg_action_support_working_directory_dirty_finish (_data_->self, _data_->_res_)) {
		_data_->_tmp0_ = gitg_ext_user_query_new_full (_ ("Unstaged changes"), _ ("You appear to have unstaged changes in your working directory. Would y" \
"ou like to stash the changes before the checkout?"), GTK_MESSAGE_QUESTION, _ ("Cancel"), GTK_RESPONSE_CANCEL, _ ("Stash changes"), GTK_RESPONSE_OK, NULL);
		_data_->q = _data_->_tmp0_;
		_data_->_tmp1_ = gitg_action_support_get_application (_data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->q;
		_data_->_state_ = 2;
		gitg_ext_application_user_query_async (_data_->_tmp3_, _data_->_tmp4_, gitg_action_support_stash_if_needed_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = gitg_ext_application_user_query_finish (_data_->_tmp3_, _data_->_res_) != GTK_RESPONSE_OK;
		_g_object_unref0 (_data_->_tmp3_);
		if (_data_->_tmp5_) {
			gitg_simple_notification_error (_data_->notification, _ ("Failed with conflicts"));
			_data_->result = FALSE;
			_g_object_unref0 (_data_->q);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 3;
		gitg_action_support_save_stash (_data_->self, _data_->notification, _data_->head, gitg_action_support_stash_if_needed_ready, _data_);
		return FALSE;
		_state_3:
		if (!gitg_action_support_save_stash_finish (_data_->self, _data_->_res_)) {
			_data_->result = FALSE;
			_g_object_unref0 (_data_->q);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->q);
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_action_support_checkout_conflicts_data_free (gpointer _data)
{
	GitgActionSupportCheckoutConflictsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notification);
	_g_object_unref0 (_data_->reference);
	_g_object_unref0 (_data_->head);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgActionSupportCheckoutConflictsData, _data_);
}

void
gitg_action_support_checkout_conflicts (GitgActionSupport* self,
                                        GitgSimpleNotification* notification,
                                        GitgRef* reference,
                                        GgitIndex* index,
                                        GitgRef* head,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GitgActionSupportCheckoutConflictsData* _data_;
	GitgActionSupport* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GitgRef* _tmp2_;
	GgitIndex* _tmp3_;
	GitgRef* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_return_if_fail (reference != NULL);
	g_return_if_fail (index != NULL);
	_data_ = g_slice_new0 (GitgActionSupportCheckoutConflictsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_action_support_checkout_conflicts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (reference);
	_g_object_unref0 (_data_->reference);
	_data_->reference = _tmp2_;
	_tmp3_ = _g_object_ref0 (index);
	_g_object_unref0 (_data_->index);
	_data_->index = _tmp3_;
	_tmp4_ = _g_object_ref0 (head);
	_g_object_unref0 (_data_->head);
	_data_->head = _tmp4_;
	gitg_action_support_checkout_conflicts_co (_data_);
}

gboolean
gitg_action_support_checkout_conflicts_finish (GitgActionSupport* self,
                                               GAsyncResult* _res_)
{
	gboolean result;
	GitgActionSupportCheckoutConflictsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GitgActionSupport* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->index);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
gitg_action_support_checkout_conflicts_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GitgActionSupportCheckoutConflictsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_action_support_checkout_conflicts_co (_data_);
}

static void
___lambda18_ (Block3Data* _data3_,
              GError** error)
{
	GitgActionSupport* self;
	GgitCheckoutOptions* opts = NULL;
	GgitCheckoutOptions* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	GitgExtApplication* _tmp3_;
	GitgRepository* _tmp4_;
	GitgRepository* _tmp5_;
	GitgRepository* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	_tmp0_ = ggit_checkout_options_new ();
	opts = _tmp0_;
	ggit_checkout_options_set_strategy (opts, GGIT_CHECKOUT_SAFE);
	_tmp1_ = gitg_action_support_get_application (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_ext_application_get_repository (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	ggit_repository_checkout_index ((GgitRepository*) _tmp6_, _data3_->index, opts, &_inner_error0_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (opts);
		return;
	}
	_g_object_unref0 (opts);
}

static void
____lambda18__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda18_ (self, error);
}

static gboolean
gitg_action_support_checkout_conflicts_co (GitgActionSupportCheckoutConflictsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data3_->index);
	_data_->_data3_->index = _data_->index;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_state_ = 1;
	gitg_action_support_stash_if_needed (_data_->self, _data_->notification, _data_->head, gitg_action_support_checkout_conflicts_ready, _data_);
	return FALSE;
	_state_1:
	if (!gitg_action_support_stash_if_needed_finish (_data_->self, _data_->_res_)) {
		_data_->result = FALSE;
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->head == NULL) {
		_data_->_tmp0_ = gitg_action_support_get_application (_data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = gitg_action_support_get_action_interface (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = gitg_ref_action_checkout_new (_data_->_tmp2_, _data_->_tmp5_, _data_->reference);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp5_);
		_g_object_unref0 (_data_->_tmp2_);
		_data_->checkout = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->checkout;
		_data_->_state_ = 2;
		gitg_ref_action_checkout_checkout (_data_->_tmp8_, gitg_action_support_checkout_conflicts_ready, _data_);
		return FALSE;
		_state_2:
		if (!gitg_ref_action_checkout_checkout_finish (_data_->_tmp8_, _data_->_res_)) {
			gitg_simple_notification_error (_data_->notification, _ ("Failed with conflicts"));
			_data_->result = FALSE;
			_g_object_unref0 (_data_->checkout);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->checkout);
	}
	{
		_data_->_state_ = 3;
		gitg_async_thread (____lambda18__gitg_async_thread_func, _data_->_data3_, gitg_action_support_checkout_conflicts_ready, _data_);
		return FALSE;
		_state_3:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->err;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		_data_->_tmp11_ = g_strdup_printf (_ ("Failed to checkout conflicts: %s"), _data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		gitg_simple_notification_error (_data_->notification, _data_->_tmp12_);
		_g_free0 (_data_->_tmp12_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->err);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_action_support_commit_index_data_free (gpointer _data)
{
	GitgActionSupportCommitIndexData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notification);
	_g_object_unref0 (_data_->reference);
	_g_object_unref0 (_data_->index);
	_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	_g_object_unref0 (_data_->author);
	_g_free0 (_data_->message);
	__vala_GgitOId_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgActionSupportCommitIndexData, _data_);
}

void
gitg_action_support_commit_index (GitgActionSupport* self,
                                  GitgSimpleNotification* notification,
                                  GitgRef* reference,
                                  GgitIndex* index,
                                  GgitOId** parents,
                                  gint parents_length1,
                                  GgitSignature* author,
                                  const gchar* message,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	GitgActionSupportCommitIndexData* _data_;
	GitgActionSupport* _tmp0_;
	GitgSimpleNotification* _tmp1_;
	GitgRef* _tmp2_;
	GgitIndex* _tmp3_;
	GgitSignature* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	g_return_if_fail (reference != NULL);
	g_return_if_fail (index != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (GitgActionSupportCommitIndexData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_action_support_commit_index_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data_->notification);
	_data_->notification = _tmp1_;
	_tmp2_ = _g_object_ref0 (reference);
	_g_object_unref0 (_data_->reference);
	_data_->reference = _tmp2_;
	_tmp3_ = _g_object_ref0 (index);
	_g_object_unref0 (_data_->index);
	_data_->index = _tmp3_;
	_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	_data_->parents = parents;
	_data_->parents_length1 = parents_length1;
	_tmp4_ = _g_object_ref0 (author);
	_g_object_unref0 (_data_->author);
	_data_->author = _tmp4_;
	_tmp5_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp5_;
	gitg_action_support_commit_index_co (_data_);
}

GgitOId*
gitg_action_support_commit_index_finish (GitgActionSupport* self,
                                         GAsyncResult* _res_)
{
	GgitOId* result;
	GitgActionSupportCommitIndexData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GitgActionSupport* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->head_tree);
		__vala_GgitOId_free0 (_data4_->oid);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
gitg_action_support_commit_index_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	GitgActionSupportCommitIndexData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_action_support_commit_index_co (_data_);
}

static void
____lambda19_ (Block4Data* _data4_,
               GError** error)
{
	GitgActionSupport* self;
	GgitCheckoutOptions* opts = NULL;
	GgitCheckoutOptions* _tmp0_;
	GgitCheckoutOptions* _tmp1_;
	GgitCheckoutOptions* _tmp2_;
	GgitTree* _tmp3_;
	GgitCommit* newcommit = NULL;
	GitgExtApplication* _tmp4_;
	GitgExtApplication* _tmp5_;
	GitgExtApplication* _tmp6_;
	GitgRepository* _tmp7_;
	GitgRepository* _tmp8_;
	GitgRepository* _tmp9_;
	GgitOId* _tmp10_;
	gpointer _tmp11_;
	GgitCommit* _tmp12_;
	GgitTree* newtree = NULL;
	GgitCommit* _tmp13_;
	GgitTree* _tmp14_;
	GitgExtApplication* _tmp15_;
	GitgExtApplication* _tmp16_;
	GitgExtApplication* _tmp17_;
	GitgRepository* _tmp18_;
	GitgRepository* _tmp19_;
	GitgRepository* _tmp20_;
	GgitTree* _tmp21_;
	GgitCheckoutOptions* _tmp22_;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	_tmp0_ = ggit_checkout_options_new ();
	opts = _tmp0_;
	_tmp1_ = opts;
	ggit_checkout_options_set_strategy (_tmp1_, GGIT_CHECKOUT_SAFE);
	_tmp2_ = opts;
	_tmp3_ = _data4_->head_tree;
	ggit_checkout_options_set_baseline (_tmp2_, _tmp3_);
	_tmp4_ = gitg_action_support_get_application (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gitg_ext_application_get_repository (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = _data4_->oid;
	_tmp11_ = gitg_repository_lookup (_tmp9_, ggit_commit_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_, &_inner_error0_);
	_tmp12_ = (GgitCommit*) _tmp11_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp6_);
	newcommit = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (opts);
		return;
	}
	_tmp13_ = newcommit;
	_tmp14_ = ggit_commit_get_tree (_tmp13_);
	newtree = _tmp14_;
	_tmp15_ = gitg_action_support_get_application (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = gitg_ext_application_get_repository (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = newtree;
	_tmp22_ = opts;
	ggit_repository_checkout_tree ((GgitRepository*) _tmp20_, (GgitObject*) _tmp21_, _tmp22_, &_inner_error0_);
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (_tmp17_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (newtree);
		_g_object_unref0 (newcommit);
		_g_object_unref0 (opts);
		return;
	}
	_g_object_unref0 (newtree);
	_g_object_unref0 (newcommit);
	_g_object_unref0 (opts);
}

static void
_____lambda19__gitg_async_thread_func (gpointer self,
                                       GError** error)
{
	____lambda19_ (self, error);
}

static GgitOId*
_vala_GgitOId_copy (GgitOId* self)
{
	return g_boxed_copy (ggit_oid_get_type (), self);
}

static gpointer
__vala_GgitOId_copy0 (gpointer self)
{
	return self ? _vala_GgitOId_copy (self) : NULL;
}

static gboolean
gitg_action_support_commit_index_co (GitgActionSupportCommitIndexData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = gitg_action_support_get_application (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = gitg_ext_application_get_verified_committer (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->committer = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->committer;
	if (_data_->_tmp5_ == NULL) {
		gitg_simple_notification_error (_data_->notification, _ ("Failed to obtain author details"));
		_data_->result = NULL;
		_g_object_unref0 (_data_->committer);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->author == NULL) {
		GgitSignature* _tmp7_;
		_data_->_tmp6_ = _data_->committer;
		_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->author);
		_data_->author = _tmp7_;
	}
	_data_->_tmp8_ = gitg_action_support_get_application (_data_->self);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = gitg_ext_application_get_repository (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = gitg_repository_get_stage (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->_tmp15_;
	_g_object_unref0 (_data_->_tmp13_);
	_g_object_unref0 (_data_->_tmp10_);
	_data_->stage = _data_->_tmp16_;
	_data_->head = NULL;
	_data_->_tmp17_ = gitg_action_support_reference_is_head (_data_->self, _data_->reference, &_data_->head);
	_data_->ishead = _data_->_tmp17_;
	_data_->_data4_->oid = NULL;
	_data_->_data4_->head_tree = NULL;
	_data_->commit = NULL;
	{
		_data_->_tmp19_ = ggit_ref_lookup ((GgitRef*) _data_->reference, &_data_->_inner_error0_);
		_data_->_tmp18_ = _data_->_tmp19_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, GITG_TYPE_COMMIT) ? ((GitgCommit*) _data_->_tmp18_) : NULL);
		_g_object_unref0 (_data_->commit);
		_data_->commit = _data_->_tmp20_;
		_g_object_unref0 (_data_->_tmp18_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		_data_->_tmp23_ = g_strdup_printf (_ ("Failed to lookup commit: %s"), _data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		gitg_simple_notification_error (_data_->notification, _data_->_tmp24_);
		_g_free0 (_data_->_tmp24_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->commit);
		_g_object_unref0 (_data_->head);
		_g_object_unref0 (_data_->stage);
		_g_object_unref0 (_data_->committer);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->commit);
		_g_object_unref0 (_data_->head);
		_g_object_unref0 (_data_->stage);
		_g_object_unref0 (_data_->committer);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->ishead) {
		_data_->_tmp25_ = _data_->head;
		_data_->_state_ = 1;
		gitg_action_support_stash_if_needed (_data_->self, _data_->notification, _data_->_tmp25_, gitg_action_support_commit_index_ready, _data_);
		return FALSE;
		_state_1:
		if (!gitg_action_support_stash_if_needed_finish (_data_->self, _data_->_res_)) {
			_data_->result = NULL;
			_g_object_unref0 (_data_->commit);
			_g_object_unref0 (_data_->head);
			_g_object_unref0 (_data_->stage);
			_g_object_unref0 (_data_->committer);
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp26_ = _data_->commit;
		_data_->_tmp27_ = ggit_commit_get_tree ((GgitCommit*) _data_->_tmp26_);
		_g_object_unref0 (_data_->_data4_->head_tree);
		_data_->_data4_->head_tree = _data_->_tmp27_;
	}
	if (_data_->parents == NULL) {
		_data_->_tmp28_ = _data_->commit;
		_data_->_tmp29_ = ggit_object_get_id ((GgitObject*) _data_->_tmp28_);
		_data_->_tmp30_ = g_new0 (GgitOId*, 1 + 1);
		_data_->_tmp30_[0] = _data_->_tmp29_;
		_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		_data_->parents = _data_->_tmp30_;
		_data_->parents_length1 = 1;
	}
	{
		if (_data_->ishead) {
			_data_->_tmp32_ = _data_->head;
			_data_->_tmp31_ = _data_->_tmp32_;
		} else {
			_data_->_tmp31_ = _data_->reference;
		}
		_data_->_tmp34_ = _data_->stage;
		_data_->_tmp35_ = _data_->committer;
		_data_->_state_ = 2;
		gitg_stage_commit_index (_data_->_tmp34_, _data_->index, (GgitRef*) _data_->_tmp31_, _data_->message, _data_->author, _data_->_tmp35_, _data_->parents, (gint) _data_->parents_length1, GITG_STAGE_COMMIT_OPTIONS_NONE, gitg_action_support_commit_index_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp36_ = gitg_stage_commit_index_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp33_ = _data_->_tmp36_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp37_ = _data_->_tmp33_;
		_data_->_tmp33_ = NULL;
		__vala_GgitOId_free0 (_data_->_data4_->oid);
		_data_->_data4_->oid = _data_->_tmp37_;
		__vala_GgitOId_free0 (_data_->_tmp33_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp38_ = _data_->_vala1_e;
		_data_->_tmp39_ = _data_->_tmp38_->message;
		_data_->_tmp40_ = g_strdup_printf (_ ("Failed to create commit: %s"), _data_->_tmp39_);
		_data_->_tmp41_ = _data_->_tmp40_;
		gitg_simple_notification_error (_data_->notification, _data_->_tmp41_);
		_g_free0 (_data_->_tmp41_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_vala1_e);
		_g_object_unref0 (_data_->commit);
		_g_object_unref0 (_data_->head);
		_g_object_unref0 (_data_->stage);
		_g_object_unref0 (_data_->committer);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->commit);
		_g_object_unref0 (_data_->head);
		_g_object_unref0 (_data_->stage);
		_g_object_unref0 (_data_->committer);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->ishead) {
		{
			_data_->_state_ = 3;
			gitg_async_thread (_____lambda19__gitg_async_thread_func, _data_->_data4_, gitg_action_support_commit_index_ready, _data_);
			return FALSE;
			_state_3:
			gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->_vala2_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp42_ = _data_->_vala2_e;
			_data_->_tmp43_ = _data_->_tmp42_->message;
			_data_->_tmp44_ = g_strdup_printf (_ ("Failed to checkout index: %s"), _data_->_tmp43_);
			_data_->_tmp45_ = _data_->_tmp44_;
			gitg_simple_notification_error (_data_->notification, _data_->_tmp45_);
			_g_free0 (_data_->_tmp45_);
			_data_->result = NULL;
			_g_error_free0 (_data_->_vala2_e);
			_g_object_unref0 (_data_->commit);
			_g_object_unref0 (_data_->head);
			_g_object_unref0 (_data_->stage);
			_g_object_unref0 (_data_->committer);
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->commit);
			_g_object_unref0 (_data_->head);
			_g_object_unref0 (_data_->stage);
			_g_object_unref0 (_data_->committer);
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp46_ = _data_->_data4_->oid;
	_data_->_tmp47_ = __vala_GgitOId_copy0 (_data_->_tmp46_);
	_data_->result = _data_->_tmp47_;
	_g_object_unref0 (_data_->commit);
	_g_object_unref0 (_data_->head);
	_g_object_unref0 (_data_->stage);
	_g_object_unref0 (_data_->committer);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	_data_->parents = (_vala_array_free (_data_->parents, _data_->parents_length1, (GDestroyNotify) _vala_GgitOId_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GitgExtApplication*
gitg_action_support_get_application (GitgActionSupport* self)
{
	GitgExtApplication* result;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
gitg_action_support_set_application (GitgActionSupport* self,
                                     GitgExtApplication* value)
{
	GitgExtApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_action_support_get_application (self);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_action_support_properties[GITG_ACTION_SUPPORT_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

GitgExtRefActionInterface*
gitg_action_support_get_action_interface (GitgActionSupport* self)
{
	GitgExtRefActionInterface* result;
	GitgExtRefActionInterface* _tmp0_;
	GitgExtRefActionInterface* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_interface;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
gitg_action_support_set_action_interface (GitgActionSupport* self,
                                          GitgExtRefActionInterface* value)
{
	GitgExtRefActionInterface* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_action_support_get_action_interface (self);
	if (old_value != value) {
		GitgExtRefActionInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_interface);
		self->priv->_action_interface = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_action_support_properties[GITG_ACTION_SUPPORT_ACTION_INTERFACE_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static void
gitg_action_support_class_init (GitgActionSupportClass * klass,
                                gpointer klass_data)
{
	gitg_action_support_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgActionSupport_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_action_support_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_action_support_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_action_support_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ACTION_SUPPORT_APPLICATION_PROPERTY, gitg_action_support_properties[GITG_ACTION_SUPPORT_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_ACTION_SUPPORT_ACTION_INTERFACE_PROPERTY, gitg_action_support_properties[GITG_ACTION_SUPPORT_ACTION_INTERFACE_PROPERTY] = g_param_spec_object ("action-interface", "action-interface", "action-interface", GITG_EXT_TYPE_REF_ACTION_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gitg_action_support_instance_init (GitgActionSupport * self,
                                   gpointer klass)
{
	self->priv = gitg_action_support_get_instance_private (self);
}

static void
gitg_action_support_finalize (GObject * obj)
{
	GitgActionSupport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_ACTION_SUPPORT, GitgActionSupport);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_action_interface);
	G_OBJECT_CLASS (gitg_action_support_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_action_support_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgActionSupportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_action_support_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgActionSupport), 0, (GInstanceInitFunc) gitg_action_support_instance_init, NULL };
	GType gitg_action_support_type_id;
	gitg_action_support_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgActionSupport", &g_define_type_info, 0);
	GitgActionSupport_private_offset = g_type_add_instance_private (gitg_action_support_type_id, sizeof (GitgActionSupportPrivate));
	return gitg_action_support_type_id;
}

GType
gitg_action_support_get_type (void)
{
	static gsize gitg_action_support_type_id__once = 0;
	if (g_once_init_enter (&gitg_action_support_type_id__once)) {
		GType gitg_action_support_type_id;
		gitg_action_support_type_id = gitg_action_support_get_type_once ();
		g_once_init_leave (&gitg_action_support_type_id__once, gitg_action_support_type_id);
	}
	return gitg_action_support_type_id__once;
}

static void
_vala_gitg_action_support_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GitgActionSupport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_ACTION_SUPPORT, GitgActionSupport);
	switch (property_id) {
		case GITG_ACTION_SUPPORT_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_action_support_get_application (self));
		break;
		case GITG_ACTION_SUPPORT_ACTION_INTERFACE_PROPERTY:
		g_value_take_object (value, gitg_action_support_get_action_interface (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_action_support_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GitgActionSupport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_ACTION_SUPPORT, GitgActionSupport);
	switch (property_id) {
		case GITG_ACTION_SUPPORT_APPLICATION_PROPERTY:
		gitg_action_support_set_application (self, g_value_get_object (value));
		break;
		case GITG_ACTION_SUPPORT_ACTION_INTERFACE_PROPERTY:
		gitg_action_support_set_action_interface (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

