/* vm-configurator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include "common.h"
#include <osinfo/osinfo.h>
#include "config.h"
#include <libvirt-gobject/libvirt-gobject.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <libxml/xmlreader.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define BOXES_VM_CONFIGURATOR_BOXES_NS "boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_NS_URI "https://wiki.gnome.org/Apps/Boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_OLD_NS_URI "http://live.gnome.org/Boxes/"
#define BOXES_VM_CONFIGURATOR_SPICE_AGENT_CHANNEL "com.redhat.spice.0"
#define BOXES_VM_CONFIGURATOR_WEBDAV_CHANNEL_URI "org.spice-space.webdav.0"
#define BOXES_VM_CONFIGURATOR_BOXES_XML "<gnome-boxes>%s</gnome-boxes>"
#define BOXES_VM_CONFIGURATOR_LIVE_STATE "live"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "installation"
#define BOXES_VM_CONFIGURATOR_IMPORT_STATE "importing"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE "libvirt-system-importing"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_STATE "libvirt-cloning"
#define BOXES_VM_CONFIGURATOR_INSTALLED_STATE "installed"
#define BOXES_VM_CONFIGURATOR_LIVE_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIVE_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_IMPORT_XML "<os-state>" BOXES_VM_CONFIGURATOR_IMPORT_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLED_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLED_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_OS_ID_XML "<os-id>%s</os-id>"
#define BOXES_VM_CONFIGURATOR_MEDIA_ID_XML "<media-id>%s</media-id>"
#define BOXES_VM_CONFIGURATOR_MEDIA_XML "<media>%s</media>"
#define BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML "<num-reboots>%u</num-reboots>"
#define BOXES_VM_CONFIGURATOR_LIBOSINFO_NS "libosinfo"
#define BOXES_VM_CONFIGURATOR_LIBOSINFO_NS_URI "http://libosinfo.org/xmlns/libvirt/domain/1.0"
#define BOXES_VM_CONFIGURATOR_LIBOSINFO_XML "<libosinfo>%s</libosinfo>"
#define BOXES_VM_CONFIGURATOR_LIBOSINFO_OS_ID_XML "<os id=\"%s\"/>"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_VM_CONFIGURATOR_ERROR (boxes_vm_configurator_error_get_type ())

#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_VM_CREATOR (boxes_vm_creator_get_type ())
#define BOXES_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreator))
#define BOXES_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))
#define BOXES_IS_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CREATOR))
#define BOXES_IS_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CREATOR))
#define BOXES_VM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))

typedef struct _BoxesVMCreator BoxesVMCreator;
typedef struct _BoxesVMCreatorClass BoxesVMCreatorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesVmConfiguratorUpdateExistingDomainData BoxesVmConfiguratorUpdateExistingDomainData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))

#define BOXES_TYPE_INSTALLED_MEDIA (boxes_installed_media_get_type ())
#define BOXES_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMedia))
#define BOXES_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))
#define BOXES_IS_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_IS_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_INSTALLED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))

typedef struct _BoxesInstalledMedia BoxesInstalledMedia;
typedef struct _BoxesInstalledMediaClass BoxesInstalledMediaClass;

#define BOXES_TYPE_LIBVIRT_MEDIA (boxes_libvirt_media_get_type ())
#define BOXES_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMedia))
#define BOXES_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))
#define BOXES_IS_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_IS_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_LIBVIRT_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))

typedef struct _BoxesLibvirtMedia BoxesLibvirtMedia;
typedef struct _BoxesLibvirtMediaClass BoxesLibvirtMediaClass;

#define BOXES_TYPE_LIBVIRT_CLONED_MEDIA (boxes_libvirt_cloned_media_get_type ())
#define BOXES_LIBVIRT_CLONED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMedia))
#define BOXES_LIBVIRT_CLONED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMediaClass))
#define BOXES_IS_LIBVIRT_CLONED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA))
#define BOXES_IS_LIBVIRT_CLONED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_CLONED_MEDIA))
#define BOXES_LIBVIRT_CLONED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMediaClass))

typedef struct _BoxesLibvirtClonedMedia BoxesLibvirtClonedMedia;
typedef struct _BoxesLibvirtClonedMediaClass BoxesLibvirtClonedMediaClass;
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

typedef enum  {
	BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS
} BoxesVMConfiguratorError;
#define BOXES_VM_CONFIGURATOR_ERROR boxes_vm_configurator_error_quark ()

struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare) (BoxesInstallerMedia* self, BoxesActivityProgress* progress, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*prepare_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_to_continue_installation) (BoxesInstallerMedia* self, const gchar* vm_name);
	void (*clean_up) (BoxesInstallerMedia* self);
	void (*clean_up_preparation_cache) (BoxesInstallerMedia* self);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*setup_post_install_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	BoxesVMCreator* (*get_vm_creator) (BoxesInstallerMedia* self);
	OsinfoDeviceList* (*get_supported_devices) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_prefers_q35) (BoxesInstallerMedia* self);
	gboolean (*get_prefers_ich9) (BoxesInstallerMedia* self);
	gboolean (*get_live) (BoxesInstallerMedia* self);
	gboolean (*get_eject_after_install) (BoxesInstallerMedia* self);
	gchar* (*get_architecture) (BoxesInstallerMedia* self);
};

struct _BoxesVmConfiguratorUpdateExistingDomainData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GVirConfigDomain* domain;
	GVirConnection* connection;
	GVirConfigDomainCpu* cpu;
	GVirConfigDomainCpu* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GVirConfigDomainCpu* _tmp3_;
	GVirConfigDomainCpu* _tmp4_;
	GVirConfigCapabilities* capabilities;
	GVirConfigCapabilities* _tmp5_;
	GVirConfigCapabilities* _tmp6_;
	GError* e;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};

static gpointer boxes_vm_configurator_parent_class = NULL;
VALA_EXTERN BoxesApp* boxes_app_app;

VALA_EXTERN GQuark boxes_vm_configurator_error_quark (void);
VALA_EXTERN GType boxes_vm_configurator_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer boxes_vm_configurator_ref (gpointer instance);
VALA_EXTERN void boxes_vm_configurator_unref (gpointer instance);
VALA_EXTERN GParamSpec* boxes_param_spec_vm_configurator (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void boxes_value_set_vm_configurator (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void boxes_value_take_vm_configurator (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer boxes_value_get_vm_configurator (const GValue* value);
VALA_EXTERN GType boxes_vm_configurator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesVMConfigurator, boxes_vm_configurator_unref)
VALA_EXTERN GType boxes_installer_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesInstallerMedia, g_object_unref)
VALA_EXTERN GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media,
                                                              const gchar* target_path,
                                                              GVirConfigCapabilities* caps,
                                                              GVirConfigDomainCapabilities* domain_caps,
                                                              GError** error);
VALA_EXTERN void boxes_vm_configurator_setup_custom_xml (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps,
                                                                        BoxesInstallerMedia* install_media,
                                                                        GError** error);
VALA_EXTERN GType boxes_vm_creator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesVMCreator, g_object_unref)
static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps);
static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain,
                                           GVirConfigCapabilities* caps,
                                           GVirConfigDomainVirtType virt_type);
static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain,
                                          BoxesInstallerMedia* install_media,
                                          GVirConfigCapabilitiesGuest* guest_caps,
                                          GVirConfigDomainCapabilities* domain_caps);
static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps,
                                                       const gchar* feature_name);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain,
                                                    const gchar* target_path,
                                                    BoxesInstallerMedia* install_media,
                                                    guint8 dev_index);
VALA_EXTERN void boxes_installer_media_setup_domain_config (BoxesInstallerMedia* self,
                                                GVirConfigDomain* domain);
VALA_EXTERN GVirConfigDomainGraphicsSpice* boxes_vm_configurator_create_graphics_device (gboolean accel3d);
static GVirConfigDomainChannel* boxes_vm_configurator_create_spice_agent_channel (void);
VALA_EXTERN GVirConfigDomainChannel* boxes_vm_configurator_create_spice_webdav_channel (void);
VALA_EXTERN void boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain,
                                            BoxesInstallerMedia* install_media);
VALA_EXTERN gboolean boxes_app_is_running_in_flatpak (void);
VALA_EXTERN void boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain);
static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain,
                                              BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_mouse_config (GVirConfigDomain* domain,
                                             BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_keyboard_config (GVirConfigDomain* domain,
                                                BoxesInstallerMedia* install_media);
VALA_EXTERN gboolean boxes_installer_media_get_supports_virtio_net (BoxesInstallerMedia* self);
VALA_EXTERN gboolean boxes_installer_media_get_supports_virtio1_net (BoxesInstallerMedia* self);
VALA_EXTERN GVirConfigDomainInterface* boxes_vm_configurator_create_network_interface (GVirConfigDomain* domain,
                                                                           gboolean bridge,
                                                                           gboolean virtio);
VALA_EXTERN gboolean boxes_is_libvirt_bridge_net_available (void);
VALA_EXTERN void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain,
                                               BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain);
VALA_EXTERN void boxes_installer_media_setup_post_install_domain_config (BoxesInstallerMedia* self,
                                                             GVirConfigDomain* domain);
static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain,
                                              BoxesInstallerMedia* install_media);
VALA_EXTERN gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain);
VALA_EXTERN gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain);
VALA_EXTERN gboolean boxes_vm_configurator_is_import_config (GVirConfigDomain* domain);
VALA_EXTERN gboolean boxes_vm_configurator_is_libvirt_system_import_config (GVirConfigDomain* domain);
VALA_EXTERN gboolean boxes_vm_configurator_is_libvirt_cloning_config (GVirConfigDomain* domain);
VALA_EXTERN gboolean boxes_vm_configurator_is_boxes_installed (GVirConfigDomain* domain);
VALA_EXTERN GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name,
                                                                  gint64 storage,
                                                                  GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void);
VALA_EXTERN GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error);
VALA_EXTERN gchar* boxes_vm_configurator_get_os_id (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_libosinfo_os_id (GVirConfigDomain* domain);
VALA_EXTERN gchar* boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain,
                                                  const gchar* node_name);
VALA_EXTERN gchar* boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain);
VALA_EXTERN gchar* boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain);
VALA_EXTERN guint boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain);
VALA_EXTERN void boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain,
                                            BoxesInstallerMedia* install_media,
                                            guint num_reboots);
static void boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain,
                                              BoxesInstallerMedia* install_media,
                                              guint num_reboots,
                                              gboolean installed);
static void boxes_vm_configurator_update_existing_domain_data_free (gpointer _data);
VALA_EXTERN void boxes_vm_configurator_update_existing_domain (GVirConfigDomain* domain,
                                                   GVirConnection* connection,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void boxes_vm_configurator_update_existing_domain_finish (GAsyncResult* _res_);
static gboolean boxes_vm_configurator_update_existing_domain_co (BoxesVmConfiguratorUpdateExistingDomainData* _data_);
static gboolean boxes_vm_configurator_boxes_created_domain (GVirConfigDomain* domain);
static gboolean boxes_vm_configurator_boxes_edited_domain (GVirConfigDomain* domain);
static void boxes_vm_configurator_update_existing_domain_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void boxes_vm_configurator_update_domain_devices (GVirConfigDomain* domain,
                                                  GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN gboolean boxes_installer_media_get_supports_virtio_disk (BoxesInstallerMedia* self);
VALA_EXTERN gboolean boxes_installer_media_get_supports_virtio1_disk (BoxesInstallerMedia* self);
VALA_EXTERN gboolean boxes_installer_media_get_prefers_q35 (BoxesInstallerMedia* self);
VALA_EXTERN GType boxes_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesApp, g_object_unref)
VALA_EXTERN gboolean boxes_app_supports_uefi_installs (BoxesApp* self);
VALA_EXTERN gboolean boxes_installer_media_get_requires_efi (BoxesInstallerMedia* self);
VALA_EXTERN void boxes_installer_media_set_direct_boot_params (BoxesInstallerMedia* self,
                                                   GVirConfigDomainOs* os);
VALA_EXTERN gboolean boxes_installer_media_get_supports_virtio_gpu (BoxesInstallerMedia* self);
static GVirConfigDomainSoundModel boxes_vm_configurator_get_sound_model (BoxesInstallerMedia* install_media);
VALA_EXTERN gboolean boxes_installer_media_get_prefers_ich9 (BoxesInstallerMedia* self);
VALA_EXTERN OsinfoDevice* boxes_find_device_by_prop (OsinfoDeviceList* devices,
                                         const gchar* prop_name,
                                         const gchar* prop_value);
VALA_EXTERN OsinfoDeviceList* boxes_installer_media_get_supported_devices (BoxesInstallerMedia* self);
static void boxes_vm_configurator_set_input_config (GVirConfigDomain* domain,
                                             GVirConfigDomainInputDeviceType device_type);
VALA_EXTERN GType boxes_installed_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesInstalledMedia, g_object_unref)
VALA_EXTERN GType boxes_libvirt_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtMedia, g_object_unref)
VALA_EXTERN GType boxes_libvirt_cloned_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtClonedMedia, g_object_unref)
VALA_EXTERN gboolean boxes_installer_media_get_live (BoxesInstallerMedia* self);
static GVirConfigDomainControllerUsb* boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model,
                                                                            GVirConfigDomainControllerUsb* master,
                                                                            guint index,
                                                                            guint start_port);
static gint __lambda43_ (GVirConfigCapabilitiesGuest* caps_a,
                  GVirConfigCapabilitiesGuest* caps_b);
static gint ___lambda43__gcompare_func (gconstpointer a,
                                 gconstpointer b);
VALA_EXTERN gboolean boxes_installer_media_is_architecture_compatible (BoxesInstallerMedia* self,
                                                           const gchar* architecture);
static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps);
VALA_EXTERN BoxesVMConfigurator* boxes_vm_configurator_new (void);
VALA_EXTERN BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator * obj);
static GType boxes_vm_configurator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GQuark
boxes_vm_configurator_error_quark (void)
{
	return g_quark_from_static_string ("boxes-vm-configurator-error-quark");
}

static GType
boxes_vm_configurator_error_get_type_once (void)
{
	static const GEnumValue values[] = {{BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS, "BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS", "no-guest-caps"}, {0, NULL, NULL}};
	GType boxes_vm_configurator_error_type_id;
	boxes_vm_configurator_error_type_id = g_enum_register_static ("BoxesVMConfiguratorError", values);
	return boxes_vm_configurator_error_type_id;
}

GType
boxes_vm_configurator_error_get_type (void)
{
	static volatile gsize boxes_vm_configurator_error_type_id__once = 0;
	if (g_once_init_enter (&boxes_vm_configurator_error_type_id__once)) {
		GType boxes_vm_configurator_error_type_id;
		boxes_vm_configurator_error_type_id = boxes_vm_configurator_error_get_type_once ();
		g_once_init_leave (&boxes_vm_configurator_error_type_id__once, boxes_vm_configurator_error_type_id);
	}
	return boxes_vm_configurator_error_type_id__once;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GVirConfigDomain*
boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media,
                                            const gchar* target_path,
                                            GVirConfigCapabilities* caps,
                                            GVirConfigDomainCapabilities* domain_caps,
                                            GError** error)
{
	GVirConfigDomain* domain = NULL;
	GVirConfigDomain* _tmp0_;
	GVirConfigCapabilitiesGuest* best_caps = NULL;
	GVirConfigCapabilitiesGuest* _tmp1_;
	OsinfoResources* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	GVirConfigDomainVirtType _tmp5_ = 0;
	GVirConfigDomainVirtType virt_type = 0;
	gchar** features = NULL;
	gchar** _tmp6_;
	gint features_length1;
	gint _features_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GVirConfigDomainClock* clock = NULL;
	GVirConfigDomainClock* _tmp11_;
	GVirConfigDomainClock* _tmp12_;
	GVirConfigDomainTimer* timer = NULL;
	GVirConfigDomainTimerRtc* _tmp13_;
	GVirConfigDomainTimer* _tmp14_;
	GVirConfigDomainClock* _tmp15_;
	GVirConfigDomainTimer* _tmp16_;
	GVirConfigDomainTimerPit* _tmp17_;
	GVirConfigDomainTimer* _tmp18_;
	GVirConfigDomainClock* _tmp19_;
	GVirConfigDomainTimer* _tmp20_;
	GVirConfigDomainTimerHpet* _tmp21_;
	GVirConfigDomainTimer* _tmp22_;
	GVirConfigDomainClock* _tmp23_;
	GVirConfigDomainTimer* _tmp24_;
	GVirConfigDomainClock* _tmp25_;
	GVirConfigDomainGraphicsSpice* _tmp26_;
	GVirConfigDomainGraphicsSpice* _tmp27_;
	GVirConfigDomainChannel* _tmp28_;
	GVirConfigDomainChannel* _tmp29_;
	GVirConfigDomainChannel* _tmp30_;
	GVirConfigDomainChannel* _tmp31_;
	GVirConfigDomainPowerManagement* pm = NULL;
	GVirConfigDomainPowerManagement* _tmp32_;
	GVirConfigDomainPowerManagement* _tmp33_;
	GVirConfigDomainPowerManagement* _tmp34_;
	GVirConfigDomainPowerManagement* _tmp35_;
	GVirConfigDomainConsole* console = NULL;
	GVirConfigDomainConsole* _tmp36_;
	GVirConfigDomainConsole* _tmp37_;
	GVirConfigDomainChardevSourcePty* _tmp38_;
	GVirConfigDomainChardevSourcePty* _tmp39_;
	GVirConfigDomainConsole* _tmp40_;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gboolean supports_virtio_net = FALSE;
	GVirConfigDomainInterface* iface = NULL;
	GVirConfigDomainInterface* _tmp46_;
	GVirConfigDomainInterface* _tmp47_;
	GError* _inner_error0_ = NULL;
	GVirConfigDomain* result;
	g_return_val_if_fail (install_media != NULL, NULL);
	g_return_val_if_fail (target_path != NULL, NULL);
	g_return_val_if_fail (caps != NULL, NULL);
	g_return_val_if_fail (domain_caps != NULL, NULL);
	_tmp0_ = gvir_config_domain_new ();
	domain = _tmp0_;
	boxes_vm_configurator_setup_custom_xml (domain, install_media);
	_tmp1_ = boxes_vm_configurator_get_best_guest_caps (caps, install_media, &_inner_error0_);
	best_caps = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (domain);
			return NULL;
		} else {
			_g_object_unref0 (domain);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = install_media->resources;
	_tmp3_ = osinfo_resources_get_ram (_tmp2_);
	_tmp4_ = _tmp3_;
	gvir_config_domain_set_memory (domain, (guint64) (_tmp4_ / OSINFO_KIBIBYTES));
	if (boxes_vm_configurator_guest_kvm_enabled (best_caps)) {
		_tmp5_ = GVIR_CONFIG_DOMAIN_VIRT_KVM;
	} else {
		_tmp5_ = GVIR_CONFIG_DOMAIN_VIRT_QEMU;
	}
	virt_type = _tmp5_;
	boxes_vm_configurator_set_cpu_config (domain, caps, virt_type);
	gvir_config_domain_set_virt_type (domain, virt_type);
	boxes_vm_configurator_set_os_config (domain, install_media, best_caps, domain_caps);
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	features = _tmp6_;
	features_length1 = 0;
	_features_size_ = features_length1;
	if (boxes_vm_configurator_guest_supports_feature (best_caps, "acpi")) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("acpi");
		_vala_array_add12 (&features, &features_length1, &_features_size_, _tmp7_);
	}
	if (boxes_vm_configurator_guest_supports_feature (best_caps, "apic")) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("apic");
		_vala_array_add13 (&features, &features_length1, &_features_size_, _tmp8_);
	}
	if (boxes_vm_configurator_guest_supports_feature (best_caps, "pae")) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("pae");
		_vala_array_add14 (&features, &features_length1, &_features_size_, _tmp9_);
	}
	_tmp10_ = features;
	_tmp10__length1 = features_length1;
	gvir_config_domain_set_features (domain, _tmp10_);
	_tmp11_ = gvir_config_domain_clock_new ();
	clock = _tmp11_;
	_tmp12_ = clock;
	gvir_config_domain_clock_set_offset (_tmp12_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
	_tmp13_ = gvir_config_domain_timer_rtc_new ();
	timer = (GVirConfigDomainTimer*) _tmp13_;
	_tmp14_ = timer;
	gvir_config_domain_timer_set_tick_policy (_tmp14_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_CATCHUP);
	_tmp15_ = clock;
	_tmp16_ = timer;
	gvir_config_domain_clock_add_timer (_tmp15_, _tmp16_);
	_tmp17_ = gvir_config_domain_timer_pit_new ();
	_g_object_unref0 (timer);
	timer = (GVirConfigDomainTimer*) _tmp17_;
	_tmp18_ = timer;
	gvir_config_domain_timer_set_tick_policy (_tmp18_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_DELAY);
	_tmp19_ = clock;
	_tmp20_ = timer;
	gvir_config_domain_clock_add_timer (_tmp19_, _tmp20_);
	_tmp21_ = gvir_config_domain_timer_hpet_new ();
	_g_object_unref0 (timer);
	timer = (GVirConfigDomainTimer*) _tmp21_;
	_tmp22_ = timer;
	gvir_config_domain_timer_set_present (_tmp22_, FALSE);
	_tmp23_ = clock;
	_tmp24_ = timer;
	gvir_config_domain_clock_add_timer (_tmp23_, _tmp24_);
	_tmp25_ = clock;
	gvir_config_domain_set_clock (domain, _tmp25_);
	boxes_vm_configurator_set_target_media_config (domain, target_path, install_media, (guint8) 0);
	boxes_installer_media_setup_domain_config (install_media, domain);
	_tmp26_ = boxes_vm_configurator_create_graphics_device (FALSE);
	_tmp27_ = _tmp26_;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = boxes_vm_configurator_create_spice_agent_channel ();
	_tmp29_ = _tmp28_;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = boxes_vm_configurator_create_spice_webdav_channel ();
	_tmp31_ = _tmp30_;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp31_);
	_g_object_unref0 (_tmp31_);
	boxes_vm_configurator_add_usb_support (domain, install_media);
	if (!boxes_app_is_running_in_flatpak ()) {
		boxes_vm_configurator_add_smartcard_support (domain);
	}
	boxes_vm_configurator_set_video_config (domain, install_media);
	boxes_vm_configurator_set_sound_config (domain, install_media);
	boxes_vm_configurator_set_tablet_config (domain, install_media);
	boxes_vm_configurator_set_mouse_config (domain, install_media);
	boxes_vm_configurator_set_keyboard_config (domain, install_media);
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp32_ = gvir_config_domain_power_management_new ();
	pm = _tmp32_;
	_tmp33_ = pm;
	gvir_config_domain_power_management_set_mem_suspend_enabled (_tmp33_, FALSE);
	_tmp34_ = pm;
	gvir_config_domain_power_management_set_disk_suspend_enabled (_tmp34_, FALSE);
	_tmp35_ = pm;
	gvir_config_domain_set_power_management (domain, _tmp35_);
	_tmp36_ = gvir_config_domain_console_new ();
	console = _tmp36_;
	_tmp37_ = console;
	_tmp38_ = gvir_config_domain_chardev_source_pty_new ();
	_tmp39_ = _tmp38_;
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp37_, (GVirConfigDomainChardevSource*) _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = console;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp40_);
	_tmp42_ = boxes_installer_media_get_supports_virtio_net (install_media);
	_tmp43_ = _tmp42_;
	if (_tmp43_) {
		_tmp41_ = TRUE;
	} else {
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp44_ = boxes_installer_media_get_supports_virtio1_net (install_media);
		_tmp45_ = _tmp44_;
		_tmp41_ = _tmp45_;
	}
	supports_virtio_net = _tmp41_;
	_tmp46_ = boxes_vm_configurator_create_network_interface (domain, boxes_is_libvirt_bridge_net_available (), supports_virtio_net);
	iface = _tmp46_;
	_tmp47_ = iface;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp47_);
	result = domain;
	_g_object_unref0 (iface);
	_g_object_unref0 (console);
	_g_object_unref0 (pm);
	_g_object_unref0 (timer);
	_g_object_unref0 (clock);
	features = (_vala_array_free (features, features_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (best_caps);
	return result;
}

void
boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain,
                                          BoxesInstallerMedia* install_media)
{
	g_return_if_fail (domain != NULL);
	boxes_vm_configurator_set_post_install_os_config (domain);
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
	if (install_media != NULL) {
		boxes_installer_media_setup_post_install_domain_config (install_media, domain);
	}
	boxes_vm_configurator_mark_as_installed (domain, install_media);
}

gboolean
boxes_vm_configurator_is_install_config (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_INSTALLATION_STATE) == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
boxes_vm_configurator_is_live_config (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_LIVE_STATE) == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
boxes_vm_configurator_is_import_config (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_IMPORT_STATE) == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
boxes_vm_configurator_is_libvirt_system_import_config (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE) == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
boxes_vm_configurator_is_libvirt_cloning_config (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_STATE) == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
boxes_vm_configurator_is_boxes_installed (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = boxes_vm_configurator_get_os_state (domain);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, BOXES_VM_CONFIGURATOR_INSTALLED_STATE) == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

GVirConfigStorageVol*
boxes_vm_configurator_create_volume_config (const gchar* name,
                                            gint64 storage,
                                            GError** error)
{
	GVirConfigStorageVol* volume = NULL;
	GVirConfigStorageVol* _tmp0_;
	GVirConfigStorageVolTarget* target = NULL;
	GVirConfigStorageVolTarget* _tmp1_;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp2_;
	GVirConfigStorageVol* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gvir_config_storage_vol_new ();
	volume = _tmp0_;
	gvir_config_storage_vol_set_name (volume, name);
	gvir_config_storage_vol_set_capacity (volume, (guint64) storage);
	_tmp1_ = gvir_config_storage_vol_target_new ();
	target = _tmp1_;
	gvir_config_storage_vol_target_set_format (target, "qcow2");
	gvir_config_storage_vol_target_set_compat (target, "1.1");
	_tmp2_ = boxes_vm_configurator_get_default_permissions ();
	permissions = _tmp2_;
	gvir_config_storage_vol_target_set_permissions (target, permissions);
	gvir_config_storage_vol_set_target (volume, target);
	result = volume;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	return result;
}

GVirConfigStoragePool*
boxes_vm_configurator_get_pool_config (GError** error)
{
	gchar* pool_path = NULL;
	gchar* _tmp0_;
	GVirConfigStoragePool* pool = NULL;
	GVirConfigStoragePool* _tmp1_;
	GVirConfigStoragePoolSource* source = NULL;
	GVirConfigStoragePoolSource* _tmp2_;
	GVirConfigStoragePoolTarget* target = NULL;
	GVirConfigStoragePoolTarget* _tmp3_;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp4_;
	GVirConfigStoragePool* result;
	_tmp0_ = boxes_get_user_pkgdata ("images");
	pool_path = _tmp0_;
	_tmp1_ = gvir_config_storage_pool_new ();
	pool = _tmp1_;
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
	_tmp2_ = gvir_config_storage_pool_source_new ();
	source = _tmp2_;
	gvir_config_storage_pool_source_set_directory (source, pool_path);
	gvir_config_storage_pool_set_source (pool, source);
	_tmp3_ = gvir_config_storage_pool_target_new ();
	target = _tmp3_;
	gvir_config_storage_pool_target_set_path (target, pool_path);
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
	permissions = _tmp4_;
	gvir_config_storage_pool_target_set_permissions (target, permissions);
	gvir_config_storage_pool_set_target (pool, target);
	result = pool;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	_g_object_unref0 (source);
	_g_free0 (pool_path);
	return result;
}

gchar*
boxes_vm_configurator_get_os_id (GVirConfigDomain* domain)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = boxes_vm_configurator_get_libosinfo_os_id (domain);
	str = _tmp0_;
	_tmp1_ = str;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = boxes_vm_configurator_get_custom_xml_node (domain, "os-id");
		_g_free0 (str);
		str = _tmp2_;
	}
	result = str;
	return result;
}

gchar*
boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "media-id");
	result = _tmp0_;
	return result;
}

gchar*
boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "media");
	result = _tmp0_;
	return result;
}

guint
boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	const gchar* _tmp2_;
	guint result;
	g_return_val_if_fail (domain != NULL, 0U);
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "num-reboots");
	str = _tmp0_;
	_tmp2_ = str;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = str;
		_tmp1_ = atoi (_tmp3_);
	} else {
		_tmp1_ = 0;
	}
	result = (guint) _tmp1_;
	_g_free0 (str);
	return result;
}

void
boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain,
                                       BoxesInstallerMedia* install_media,
                                       guint num_reboots)
{
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	boxes_vm_configurator_update_custom_xml (domain, install_media, num_reboots, FALSE);
}

void
boxes_vm_configurator_setup_custom_xml (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	boxes_vm_configurator_update_custom_xml (domain, install_media, (guint) 0, FALSE);
}

static void
boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain,
                                         BoxesInstallerMedia* install_media)
{
	g_return_if_fail (domain != NULL);
	boxes_vm_configurator_update_custom_xml (domain, install_media, (guint) 0, TRUE);
}

static void
boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain,
                                      GVirConfigCapabilities* caps,
                                      GVirConfigDomainVirtType virt_type)
{
	GVirConfigCapabilitiesCpu* cpu_caps = NULL;
	GVirConfigCapabilitiesHost* _tmp0_;
	GVirConfigCapabilitiesHost* _tmp1_;
	GVirConfigCapabilitiesCpu* _tmp2_;
	GVirConfigCapabilitiesCpu* _tmp3_;
	GVirConfigCapabilitiesCpuTopology* topology = NULL;
	GVirConfigCapabilitiesCpu* _tmp4_;
	GVirConfigCapabilitiesCpuTopology* _tmp5_;
	GVirConfigCapabilitiesCpuTopology* _tmp6_;
	GVirConfigCapabilitiesCpuTopology* _tmp7_;
	GVirConfigCapabilitiesCpuTopology* _tmp8_;
	GVirConfigCapabilitiesCpuTopology* _tmp9_;
	GVirConfigDomainCpu* cpu = NULL;
	GVirConfigDomainCpu* _tmp10_;
	GVirConfigDomainCpuMode _tmp11_ = 0;
	GVirConfigDomainCpu* _tmp12_;
	GVirConfigDomainCpu* _tmp13_;
	GVirConfigCapabilitiesCpuTopology* _tmp14_;
	GVirConfigDomainCpu* _tmp15_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (caps != NULL);
	_tmp0_ = gvir_config_capabilities_get_host (caps);
	_tmp1_ = _tmp0_;
	_tmp2_ = gvir_config_capabilities_host_get_cpu (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	cpu_caps = _tmp3_;
	_tmp4_ = cpu_caps;
	_tmp5_ = gvir_config_capabilities_cpu_get_topology (_tmp4_);
	topology = _tmp5_;
	_tmp6_ = topology;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (topology);
		_g_object_unref0 (cpu_caps);
		return;
	}
	_tmp7_ = topology;
	_tmp8_ = topology;
	_tmp9_ = topology;
	g_object_set (domain, "vcpu", (gvir_config_capabilities_cpu_topology_get_sockets (_tmp7_) * gvir_config_capabilities_cpu_topology_get_cores (_tmp8_)) * gvir_config_capabilities_cpu_topology_get_threads (_tmp9_), NULL);
	_tmp10_ = gvir_config_domain_cpu_new ();
	cpu = _tmp10_;
	if (virt_type == GVIR_CONFIG_DOMAIN_VIRT_QEMU) {
		_tmp11_ = GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_MODEL;
	} else {
		_tmp11_ = GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_PASSTHROUGH;
	}
	_tmp12_ = cpu;
	gvir_config_domain_cpu_set_mode (_tmp12_, _tmp11_);
	_tmp13_ = cpu;
	_tmp14_ = topology;
	gvir_config_capabilities_cpu_set_topology ((GVirConfigCapabilitiesCpu*) _tmp13_, _tmp14_);
	_tmp15_ = cpu;
	gvir_config_domain_set_cpu (domain, _tmp15_);
	_g_object_unref0 (cpu);
	_g_object_unref0 (topology);
	_g_object_unref0 (cpu_caps);
}

static void
boxes_vm_configurator_update_existing_domain_data_free (gpointer _data)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->domain);
	_g_object_unref0 (_data_->connection);
	g_slice_free (BoxesVmConfiguratorUpdateExistingDomainData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
boxes_vm_configurator_update_existing_domain (GVirConfigDomain* domain,
                                              GVirConnection* connection,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
	GVirConfigDomain* _tmp0_;
	GVirConnection* _tmp1_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (connection != NULL);
	_data_ = g_slice_new0 (BoxesVmConfiguratorUpdateExistingDomainData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_vm_configurator_update_existing_domain_data_free);
	_tmp0_ = _g_object_ref0 (domain);
	_g_object_unref0 (_data_->domain);
	_data_->domain = _tmp0_;
	_tmp1_ = _g_object_ref0 (connection);
	_g_object_unref0 (_data_->connection);
	_data_->connection = _tmp1_;
	boxes_vm_configurator_update_existing_domain_co (_data_);
}

void
boxes_vm_configurator_update_existing_domain_finish (GAsyncResult* _res_)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
boxes_vm_configurator_update_existing_domain_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	BoxesVmConfiguratorUpdateExistingDomainData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_vm_configurator_update_existing_domain_co (_data_);
}

static gboolean
boxes_vm_configurator_update_existing_domain_co (BoxesVmConfiguratorUpdateExistingDomainData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!boxes_vm_configurator_boxes_created_domain (_data_->domain)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (boxes_vm_configurator_boxes_edited_domain (_data_->domain)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp0_ = gvir_config_domain_get_cpu (_data_->domain);
		_data_->cpu = _data_->_tmp0_;
		_data_->_tmp3_ = _data_->cpu;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->cpu;
			_data_->_tmp2_ = gvir_config_domain_cpu_get_mode (_data_->_tmp4_) != GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_PASSTHROUGH;
		} else {
			_data_->_tmp2_ = FALSE;
		}
		if (_data_->_tmp2_) {
			_data_->_tmp1_ = boxes_vm_configurator_is_boxes_installed (_data_->domain);
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->_state_ = 1;
			gvir_connection_get_capabilities_async (_data_->connection, NULL, boxes_vm_configurator_update_existing_domain_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp5_ = gvir_connection_get_capabilities_finish (_data_->connection, _data_->_res_, &_data_->_inner_error0_);
			_data_->capabilities = _data_->_tmp5_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->cpu);
				goto __catch0_g_error;
			}
			_data_->_tmp6_ = _data_->capabilities;
			boxes_vm_configurator_set_cpu_config (_data_->domain, _data_->_tmp6_, GVIR_CONFIG_DOMAIN_VIRT_KVM);
			_g_object_unref0 (_data_->capabilities);
		}
		_g_object_unref0 (_data_->cpu);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = gvir_config_domain_get_name (_data_->domain);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("vm-configurator.vala:254: Failed to update CPU config for '%s': %s", _data_->_tmp8_, _data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		boxes_vm_configurator_update_domain_devices (_data_->domain, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		g_critical ("vm-configurator.vala:260: Failed to update domain devices");
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
boxes_vm_configurator_update_domain_devices (GVirConfigDomain* domain,
                                             GError** error)
{
	GList* devices = NULL;
	GVirConfigDomainInterface* iface = NULL;
	GList* _tmp0_;
	GVirConfigDomainChannel* _tmp47_;
	GVirConfigDomainChannel* _tmp48_;
	GVirConfigDomainGraphicsSpice* _tmp49_;
	GVirConfigDomainInterface* _tmp50_;
	GList* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (domain != NULL);
	devices = NULL;
	iface = NULL;
	_tmp0_ = gvir_config_domain_get_devices (domain);
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp0_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			GVirConfigDomainDevice* _tmp1_;
			GVirConfigDomainDevice* device = NULL;
			_tmp1_ = _g_object_ref0 ((GVirConfigDomainDevice*) device_it->data);
			device = _tmp1_;
			{
				GVirConfigDomainDevice* _tmp2_;
				gchar* device_xml = NULL;
				GVirConfigDomainDevice* _tmp3_;
				gchar* _tmp4_;
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				GVirConfigDomainDevice* _tmp22_;
				_tmp2_ = device;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gvir_config_domain_graphics_get_type ())) {
					_g_object_unref0 (device);
					continue;
				}
				_tmp3_ = device;
				_tmp4_ = gvir_config_object_to_xml ((GVirConfigObject*) _tmp3_);
				device_xml = _tmp4_;
				_tmp6_ = device_xml;
				if (g_str_has_prefix (_tmp6_, "<audio")) {
					const gchar* _tmp7_;
					_tmp7_ = device_xml;
					_tmp5_ = string_contains (_tmp7_, "none");
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					gchar* server_name = NULL;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* fixed_audio_xml = NULL;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					GVirConfigObject* audio_device = NULL;
					const gchar* _tmp18_;
					GVirConfigObject* _tmp19_;
					GVirConfigObject* _tmp20_;
					GVirConfigDomainDevice* _tmp21_;
					_tmp8_ = gvir_config_domain_get_name (domain);
					_tmp9_ = _tmp8_;
					g_debug ("vm-configurator.vala:276: Fixing audio for %s\n", _tmp9_);
					_tmp10_ = g_get_user_runtime_dir ();
					_tmp11_ = g_build_filename (_tmp10_, "pulse", "native", NULL);
					server_name = _tmp11_;
					_tmp12_ = device_xml;
					_tmp13_ = server_name;
					_tmp14_ = g_strdup_printf ("pulseaudio\" serverName=\"%s\"", _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = string_replace (_tmp12_, "none\"", _tmp15_);
					_tmp17_ = _tmp16_;
					_g_free0 (_tmp15_);
					fixed_audio_xml = _tmp17_;
					_tmp18_ = fixed_audio_xml;
					_tmp19_ = gvir_config_object_new_from_xml (gvir_config_domain_device_get_type (), "audio", "", _tmp18_, &_inner_error0_);
					audio_device = _tmp19_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (fixed_audio_xml);
						_g_free0 (server_name);
						_g_free0 (device_xml);
						_g_object_unref0 (device);
						(device_collection == NULL) ? NULL : (device_collection = (_g_list_free__g_object_unref0_ (device_collection), NULL));
						_g_object_unref0 (iface);
						(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
						return;
					}
					_tmp20_ = audio_device;
					_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gvir_config_domain_device_get_type ()) ? ((GVirConfigDomainDevice*) _tmp20_) : NULL);
					devices = g_list_prepend (devices, _tmp21_);
					_g_object_unref0 (audio_device);
					_g_free0 (fixed_audio_xml);
					_g_free0 (server_name);
					_g_free0 (device_xml);
					_g_object_unref0 (device);
					continue;
				}
				_tmp22_ = device;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gvir_config_domain_interface_get_type ())) {
					GVirConfigDomainDevice* _tmp23_;
					GVirConfigDomainInterface* _tmp24_;
					_tmp23_ = device;
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gvir_config_domain_interface_get_type ()) ? ((GVirConfigDomainInterface*) _tmp23_) : NULL);
					_g_object_unref0 (iface);
					iface = _tmp24_;
				} else {
					GVirConfigDomainDevice* _tmp25_;
					_tmp25_ = device;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gvir_config_domain_channel_get_type ())) {
						GVirConfigDomainChannel* device_channel = NULL;
						GVirConfigDomainDevice* _tmp26_;
						GVirConfigDomainChannel* _tmp27_;
						GVirConfigDomainChannel* _tmp28_;
						const gchar* _tmp29_;
						_tmp26_ = device;
						_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gvir_config_domain_channel_get_type ()) ? ((GVirConfigDomainChannel*) _tmp26_) : NULL);
						device_channel = _tmp27_;
						_tmp28_ = device_channel;
						_tmp29_ = gvir_config_domain_channel_get_target_name (_tmp28_);
						if (g_strcmp0 (_tmp29_, BOXES_VM_CONFIGURATOR_WEBDAV_CHANNEL_URI) == 0) {
							_g_object_unref0 (device_channel);
							_g_free0 (device_xml);
							_g_object_unref0 (device);
							continue;
						} else {
							GVirConfigDomainChannel* _tmp30_;
							const gchar* _tmp31_;
							_tmp30_ = device_channel;
							_tmp31_ = gvir_config_domain_channel_get_target_name (_tmp30_);
							if (g_strcmp0 (_tmp31_, BOXES_VM_CONFIGURATOR_SPICE_AGENT_CHANNEL) == 0) {
								_g_object_unref0 (device_channel);
								_g_free0 (device_xml);
								_g_object_unref0 (device);
								continue;
							}
						}
						_g_object_unref0 (device_channel);
					} else {
						GVirConfigDomainDevice* _tmp32_;
						_tmp32_ = device;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, gvir_config_domain_disk_get_type ())) {
							GVirConfigDomainDisk* domain_disk = NULL;
							GVirConfigDomainDevice* _tmp33_;
							GVirConfigDomainDisk* _tmp34_;
							GVirConfigDomainDiskGuestDeviceType device_type = 0;
							GVirConfigDomainDisk* _tmp35_;
							GVirConfigDomainDevice* _tmp43_;
							GVirConfigDomainDevice* _tmp44_;
							_tmp33_ = device;
							_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gvir_config_domain_disk_get_type ()) ? ((GVirConfigDomainDisk*) _tmp33_) : NULL);
							domain_disk = _tmp34_;
							_tmp35_ = domain_disk;
							device_type = gvir_config_domain_disk_get_guest_device_type (_tmp35_);
							if (device_type == GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_CDROM) {
								GVirConfigDomainDisk* _tmp36_;
								const gchar* _tmp37_;
								_tmp36_ = domain_disk;
								_tmp37_ = gvir_config_domain_disk_get_source (_tmp36_);
								if (_tmp37_ != NULL) {
									GVirConfigDomainDisk* _tmp38_;
									const gchar* _tmp39_;
									_tmp38_ = domain_disk;
									_tmp39_ = gvir_config_domain_disk_get_source (_tmp38_);
									if (!g_file_test (_tmp39_, G_FILE_TEST_EXISTS)) {
										GVirConfigDomainDisk* _tmp40_;
										const gchar* _tmp41_;
										GVirConfigDomainDisk* _tmp42_;
										_tmp40_ = domain_disk;
										_tmp41_ = gvir_config_domain_disk_get_source (_tmp40_);
										g_debug ("vm-configurator.vala:303: CDROM media '%s' cannot be found", _tmp41_);
										_tmp42_ = domain_disk;
										gvir_config_domain_disk_set_source (_tmp42_, "");
									}
								}
							}
							_tmp43_ = device;
							_tmp44_ = _g_object_ref0 (_tmp43_);
							devices = g_list_prepend (devices, _tmp44_);
							_g_object_unref0 (domain_disk);
						} else {
							GVirConfigDomainDevice* _tmp45_;
							GVirConfigDomainDevice* _tmp46_;
							_tmp45_ = device;
							_tmp46_ = _g_object_ref0 (_tmp45_);
							devices = g_list_prepend (devices, _tmp46_);
						}
					}
				}
				_g_free0 (device_xml);
				_g_object_unref0 (device);
			}
		}
		(device_collection == NULL) ? NULL : (device_collection = (_g_list_free__g_object_unref0_ (device_collection), NULL));
	}
	_tmp47_ = boxes_vm_configurator_create_spice_webdav_channel ();
	devices = g_list_prepend (devices, (GVirConfigDomainDevice*) _tmp47_);
	_tmp48_ = boxes_vm_configurator_create_spice_agent_channel ();
	devices = g_list_prepend (devices, (GVirConfigDomainDevice*) _tmp48_);
	_tmp49_ = boxes_vm_configurator_create_graphics_device (FALSE);
	devices = g_list_prepend (devices, (GVirConfigDomainDevice*) _tmp49_);
	_tmp50_ = iface;
	if (_tmp50_ != NULL) {
		gboolean bridge = FALSE;
		gboolean virtio = FALSE;
		GVirConfigDomainInterface* _tmp51_;
		const gchar* _tmp52_;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp55_ = FALSE;
		bridge = boxes_is_libvirt_bridge_net_available ();
		_tmp51_ = iface;
		_tmp52_ = gvir_config_domain_interface_get_model (_tmp51_);
		virtio = g_strcmp0 (_tmp52_, "virtio") == 0;
		if (bridge) {
			GVirConfigDomainInterface* _tmp56_;
			_tmp56_ = iface;
			_tmp55_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, gvir_config_domain_interface_user_get_type ());
		} else {
			_tmp55_ = FALSE;
		}
		if (_tmp55_) {
			_tmp54_ = TRUE;
		} else {
			gboolean _tmp57_ = FALSE;
			if (!bridge) {
				GVirConfigDomainInterface* _tmp58_;
				_tmp58_ = iface;
				_tmp57_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, gvir_config_domain_interface_bridge_get_type ());
			} else {
				_tmp57_ = FALSE;
			}
			_tmp54_ = _tmp57_;
		}
		if (_tmp54_) {
			_tmp53_ = TRUE;
		} else {
			_tmp53_ = boxes_vm_configurator_is_libvirt_cloning_config (domain);
		}
		if (_tmp53_) {
			GVirConfigDomainInterface* _tmp59_;
			_tmp59_ = boxes_vm_configurator_create_network_interface (domain, bridge, virtio);
			devices = g_list_prepend (devices, (GVirConfigDomainDevice*) _tmp59_);
		} else {
			GVirConfigDomainInterface* _tmp60_;
			GVirConfigDomainDevice* _tmp61_;
			_tmp60_ = iface;
			_tmp61_ = _g_object_ref0 ((GVirConfigDomainDevice*) _tmp60_);
			devices = g_list_prepend (devices, _tmp61_);
		}
	}
	devices = g_list_reverse (devices);
	_tmp62_ = devices;
	gvir_config_domain_set_devices (domain, _tmp62_);
	_tmp63_ = gvir_config_domain_get_name (domain);
	_tmp64_ = _tmp63_;
	g_debug ("vm-configurator.vala:343: Updating domain devices for %s", _tmp64_);
	_g_object_unref0 (iface);
	(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
}

void
boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain,
                                               const gchar* target_path,
                                               BoxesInstallerMedia* install_media,
                                               guint8 dev_index)
{
	GVirConfigDomainDisk* disk = NULL;
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* _tmp1_;
	GVirConfigDomainDisk* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomainDiskDriver* driver = NULL;
	GVirConfigDomainDiskDriver* _tmp4_;
	GVirConfigDomainDiskDriver* _tmp5_;
	GVirConfigDomainDiskDriver* _tmp6_;
	GVirConfigDomainDiskDriver* _tmp7_;
	GVirConfigDomainDisk* _tmp8_;
	GVirConfigDomainDiskDriver* _tmp9_;
	gchar* dev_letter_str = NULL;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GVirConfigDomainDisk* _tmp34_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (target_path != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_disk_new ();
	disk = _tmp0_;
	_tmp1_ = disk;
	gvir_config_domain_disk_set_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_FILE);
	_tmp2_ = disk;
	gvir_config_domain_disk_set_guest_device_type (_tmp2_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
	_tmp3_ = disk;
	gvir_config_domain_disk_set_source (_tmp3_, target_path);
	_tmp4_ = gvir_config_domain_disk_driver_new ();
	driver = _tmp4_;
	_tmp5_ = driver;
	gvir_config_domain_disk_driver_set_name (_tmp5_, "qemu");
	_tmp6_ = driver;
	gvir_config_domain_disk_driver_set_format (_tmp6_, GVIR_CONFIG_DOMAIN_DISK_FORMAT_QCOW2);
	_tmp7_ = driver;
	gvir_config_domain_disk_driver_set_cache (_tmp7_, GVIR_CONFIG_DOMAIN_DISK_CACHE_WRITEBACK);
	_tmp8_ = disk;
	_tmp9_ = driver;
	gvir_config_domain_disk_set_driver (_tmp8_, _tmp9_);
	_tmp10_ = g_strdup_printf ("%c", (gchar) (dev_index + 97));
	dev_letter_str = _tmp10_;
	_tmp12_ = boxes_installer_media_get_supports_virtio_disk (install_media);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = boxes_installer_media_get_supports_virtio1_disk (install_media);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_;
	}
	if (_tmp11_) {
		GVirConfigDomainDisk* _tmp16_;
		GVirConfigDomainDisk* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GVirConfigDomainDiskDriver* _tmp21_;
		g_debug ("vm-configurator.vala:363: Using virtio controller for the main disk");
		_tmp16_ = disk;
		gvir_config_domain_disk_set_target_bus (_tmp16_, GVIR_CONFIG_DOMAIN_DISK_BUS_VIRTIO);
		_tmp17_ = disk;
		_tmp18_ = dev_letter_str;
		_tmp19_ = g_strconcat ("vd", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		gvir_config_domain_disk_set_target_dev (_tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = driver;
		gvir_config_domain_disk_driver_set_discard (_tmp21_, GVIR_CONFIG_DOMAIN_DISK_DRIVER_DISCARD_UNMAP);
	} else {
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp22_ = boxes_installer_media_get_prefers_q35 (install_media);
		_tmp23_ = _tmp22_;
		if (_tmp23_) {
			GVirConfigDomainDisk* _tmp24_;
			GVirConfigDomainDisk* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			g_debug ("vm-configurator.vala:370: Using SATA controller for the main disk");
			_tmp24_ = disk;
			gvir_config_domain_disk_set_target_bus (_tmp24_, GVIR_CONFIG_DOMAIN_DISK_BUS_SATA);
			_tmp25_ = disk;
			_tmp26_ = dev_letter_str;
			_tmp27_ = g_strconcat ("sd", _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			gvir_config_domain_disk_set_target_dev (_tmp25_, _tmp28_);
			_g_free0 (_tmp28_);
		} else {
			GVirConfigDomainDisk* _tmp29_;
			GVirConfigDomainDisk* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			g_debug ("vm-configurator.vala:374: Using IDE controller for the main disk");
			_tmp29_ = disk;
			gvir_config_domain_disk_set_target_bus (_tmp29_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
			_tmp30_ = disk;
			_tmp31_ = dev_letter_str;
			_tmp32_ = g_strconcat ("hd", _tmp31_, NULL);
			_tmp33_ = _tmp32_;
			gvir_config_domain_disk_set_target_dev (_tmp30_, _tmp33_);
			_g_free0 (_tmp33_);
		}
	}
	_tmp34_ = disk;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp34_);
	_g_free0 (dev_letter_str);
	_g_object_unref0 (driver);
	_g_object_unref0 (disk);
}

static void
boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain)
{
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* _tmp1_;
	GVirConfigDomainOs* old_os = NULL;
	GVirConfigDomainOs* _tmp2_;
	GList* boot_devices = NULL;
	GVirConfigDomainOs* _tmp3_;
	GList* _tmp4_;
	GVirConfigDomainOs* _tmp5_;
	GList* _tmp6_;
	GVirConfigDomainOs* _tmp7_;
	GVirConfigDomainOs* _tmp8_;
	GVirConfigDomainOs* _tmp9_;
	const gchar* _tmp10_;
	GVirConfigDomainOs* _tmp11_;
	GVirConfigDomainOs* _tmp12_;
	const gchar* _tmp13_;
	GVirConfigDomainOs* _tmp14_;
	GVirConfigDomainOs* _tmp17_;
	g_return_if_fail (domain != NULL);
	_tmp0_ = gvir_config_domain_os_new ();
	os = _tmp0_;
	_tmp1_ = os;
	gvir_config_domain_os_set_os_type (_tmp1_, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
	_tmp2_ = gvir_config_domain_get_os (domain);
	old_os = _tmp2_;
	_tmp3_ = old_os;
	_tmp4_ = gvir_config_domain_os_get_boot_devices (_tmp3_);
	boot_devices = _tmp4_;
	boot_devices = g_list_remove (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
	_tmp5_ = os;
	_tmp6_ = boot_devices;
	gvir_config_domain_os_set_boot_devices (_tmp5_, _tmp6_);
	_tmp7_ = os;
	gvir_config_domain_os_enable_boot_menu (_tmp7_, TRUE);
	_tmp8_ = os;
	_tmp9_ = old_os;
	_tmp10_ = gvir_config_domain_os_get_arch (_tmp9_);
	gvir_config_domain_os_set_arch (_tmp8_, _tmp10_);
	_tmp11_ = os;
	_tmp12_ = old_os;
	_tmp13_ = gvir_config_domain_os_get_machine (_tmp12_);
	gvir_config_domain_os_set_machine (_tmp11_, _tmp13_);
	_tmp14_ = old_os;
	if (gvir_config_domain_os_get_firmware (_tmp14_) == GVIR_CONFIG_DOMAIN_OS_FIRMWARE_EFI) {
		BoxesApp* _tmp15_;
		_tmp15_ = boxes_app_app;
		if (boxes_app_supports_uefi_installs (_tmp15_)) {
			GVirConfigDomainOs* _tmp16_;
			_tmp16_ = os;
			gvir_config_domain_os_set_firmware (_tmp16_, GVIR_CONFIG_DOMAIN_OS_FIRMWARE_EFI);
		}
	}
	_tmp17_ = os;
	gvir_config_domain_set_os (domain, _tmp17_);
	(boot_devices == NULL) ? NULL : (boot_devices = (g_list_free (boot_devices), NULL));
	_g_object_unref0 (old_os);
	_g_object_unref0 (os);
}

static void
boxes_vm_configurator_set_os_config (GVirConfigDomain* domain,
                                     BoxesInstallerMedia* install_media,
                                     GVirConfigCapabilitiesGuest* guest_caps,
                                     GVirConfigDomainCapabilities* domain_caps)
{
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* _tmp1_;
	GVirConfigDomainOs* _tmp2_;
	GVirConfigCapabilitiesGuestArch* _tmp3_;
	GVirConfigCapabilitiesGuestArch* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GList* boot_devices = NULL;
	GVirConfigDomainOs* _tmp13_;
	GVirConfigDomainOs* _tmp14_;
	GVirConfigDomainOs* _tmp15_;
	GVirConfigDomainOs* _tmp16_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	g_return_if_fail (guest_caps != NULL);
	g_return_if_fail (domain_caps != NULL);
	_tmp0_ = gvir_config_domain_os_new ();
	os = _tmp0_;
	_tmp1_ = os;
	gvir_config_domain_os_set_os_type (_tmp1_, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
	_tmp2_ = os;
	_tmp3_ = gvir_config_capabilities_guest_get_arch (guest_caps);
	_tmp4_ = _tmp3_;
	_tmp5_ = gvir_config_capabilities_guest_arch_get_name (_tmp4_);
	gvir_config_domain_os_set_arch (_tmp2_, _tmp5_);
	_g_object_unref0 (_tmp4_);
	_tmp6_ = boxes_installer_media_get_prefers_q35 (install_media);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GVirConfigDomainOs* _tmp8_;
		_tmp8_ = os;
		gvir_config_domain_os_set_machine (_tmp8_, "q35");
	}
	_tmp9_ = boxes_installer_media_get_requires_efi (install_media);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GVirConfigDomainOs* _tmp11_;
		GVirConfigDomainOs* _tmp12_;
		_tmp11_ = os;
		gvir_config_domain_os_set_firmware (_tmp11_, GVIR_CONFIG_DOMAIN_OS_FIRMWARE_EFI);
		_tmp12_ = os;
		gvir_config_domain_os_enable_firmware_feature (_tmp12_, "secure-boot", FALSE);
	}
	boot_devices = NULL;
	_tmp13_ = os;
	boxes_installer_media_set_direct_boot_params (install_media, _tmp13_);
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
	_tmp14_ = os;
	gvir_config_domain_os_set_boot_devices (_tmp14_, boot_devices);
	_tmp15_ = os;
	gvir_config_domain_os_enable_boot_menu (_tmp15_, TRUE);
	_tmp16_ = os;
	gvir_config_domain_set_os (domain, _tmp16_);
	(boot_devices == NULL) ? NULL : (boot_devices = (g_list_free (boot_devices), NULL));
	_g_object_unref0 (os);
}

static void
boxes_vm_configurator_set_video_config (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
	GVirConfigDomainVideo* video = NULL;
	GVirConfigDomainVideo* _tmp0_;
	GVirConfigDomainVideo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVirConfigDomainVideo* _tmp5_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_video_new ();
	video = _tmp0_;
	_tmp1_ = video;
	gvir_config_domain_video_set_model (_tmp1_, GVIR_CONFIG_DOMAIN_VIDEO_MODEL_QXL);
	_tmp2_ = boxes_installer_media_get_supports_virtio_gpu (install_media);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GVirConfigDomainVideo* _tmp4_;
		_tmp4_ = video;
		gvir_config_domain_video_set_model (_tmp4_, GVIR_CONFIG_DOMAIN_VIDEO_MODEL_VIRTIO);
	}
	_tmp5_ = video;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp5_);
	_g_object_unref0 (video);
}

static GVirConfigDomainSoundModel
boxes_vm_configurator_get_sound_model (BoxesInstallerMedia* install_media)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	OsinfoDevice* device = NULL;
	OsinfoDeviceList* _tmp2_;
	OsinfoDeviceList* _tmp3_;
	OsinfoDeviceList* _tmp4_;
	OsinfoDevice* _tmp5_;
	OsinfoDevice* _tmp6_;
	OsinfoDevice* _tmp7_;
	gchar* osinfo_name = NULL;
	OsinfoDevice* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* libvirt_name = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gint model = 0;
	const gchar* _tmp24_;
	GVirConfigDomainSoundModel result;
	g_return_val_if_fail (install_media != NULL, 0);
	_tmp0_ = boxes_installer_media_get_prefers_ich9 (install_media);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = (GVirConfigDomainSoundModel) GVIR_CONFIG_DOMAIN_SOUND_MODEL_ICH9;
		return result;
	}
	_tmp2_ = boxes_installer_media_get_supported_devices (install_media);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = boxes_find_device_by_prop (_tmp4_, OSINFO_DEVICE_PROP_CLASS, "audio");
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	device = _tmp6_;
	_tmp7_ = device;
	if (_tmp7_ == NULL) {
		result = (GVirConfigDomainSoundModel) GVIR_CONFIG_DOMAIN_SOUND_MODEL_ICH6;
		_g_object_unref0 (device);
		return result;
	}
	_tmp8_ = device;
	_tmp9_ = osinfo_device_get_name (_tmp8_);
	_tmp10_ = g_strdup (_tmp9_);
	osinfo_name = _tmp10_;
	_tmp11_ = g_strdup ("");
	libvirt_name = _tmp11_;
	_tmp12_ = osinfo_name;
	if (g_strcmp0 (_tmp12_, "ich9-hda") == 0) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup ("ich9");
		_g_free0 (libvirt_name);
		libvirt_name = _tmp13_;
	} else {
		const gchar* _tmp14_;
		_tmp14_ = osinfo_name;
		if (g_strcmp0 (_tmp14_, "ich6") == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("ich6");
			_g_free0 (libvirt_name);
			libvirt_name = _tmp15_;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = osinfo_name;
			if (g_strcmp0 (_tmp16_, "ac97") == 0) {
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("ac97");
				_g_free0 (libvirt_name);
				libvirt_name = _tmp17_;
			} else {
				const gchar* _tmp18_;
				_tmp18_ = osinfo_name;
				if (g_strcmp0 (_tmp18_, "pcspk") == 0) {
					gchar* _tmp19_;
					_tmp19_ = g_strdup ("pcspk");
					_g_free0 (libvirt_name);
					libvirt_name = _tmp19_;
				} else {
					const gchar* _tmp20_;
					_tmp20_ = osinfo_name;
					if (g_strcmp0 (_tmp20_, "es1370") == 0) {
						gchar* _tmp21_;
						_tmp21_ = g_strdup ("es1370");
						_g_free0 (libvirt_name);
						libvirt_name = _tmp21_;
					} else {
						const gchar* _tmp22_;
						_tmp22_ = osinfo_name;
						if (g_strcmp0 (_tmp22_, "sb16") == 0) {
							gchar* _tmp23_;
							_tmp23_ = g_strdup ("sb16");
							_g_free0 (libvirt_name);
							libvirt_name = _tmp23_;
						}
					}
				}
			}
		}
	}
	_tmp24_ = libvirt_name;
	model = boxes_get_enum_value (_tmp24_, gvir_config_domain_sound_model_get_type ());
	g_return_val_if_fail (model != -1, (GVirConfigDomainSoundModel) GVIR_CONFIG_DOMAIN_SOUND_MODEL_ICH9);
	result = (GVirConfigDomainSoundModel) model;
	_g_free0 (libvirt_name);
	_g_free0 (osinfo_name);
	_g_object_unref0 (device);
	return result;
}

static void
boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
	GVirConfigDomainSound* sound = NULL;
	GVirConfigDomainSound* _tmp0_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_sound_new ();
	sound = _tmp0_;
	gvir_config_domain_sound_set_model (sound, boxes_vm_configurator_get_sound_model (install_media));
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) sound);
	_g_object_unref0 (sound);
}

static void
boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain,
                                         BoxesInstallerMedia* install_media)
{
	OsinfoDevice* device = NULL;
	OsinfoDeviceList* _tmp0_;
	OsinfoDeviceList* _tmp1_;
	OsinfoDeviceList* _tmp2_;
	OsinfoDevice* _tmp3_;
	OsinfoDevice* _tmp4_;
	OsinfoDevice* _tmp5_;
	GVirConfigDomainInput* input = NULL;
	GVirConfigDomainInput* _tmp6_;
	GVirConfigDomainInput* _tmp7_;
	GVirConfigDomainInput* _tmp8_;
	GVirConfigDomainInput* _tmp9_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = boxes_installer_media_get_supported_devices (install_media);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = boxes_find_device_by_prop (_tmp2_, OSINFO_DEVICE_PROP_NAME, "tablet");
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	device = _tmp4_;
	_tmp5_ = device;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp6_ = gvir_config_domain_input_new ();
	input = _tmp6_;
	_tmp7_ = input;
	gvir_config_domain_input_set_device_type (_tmp7_, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
	_tmp8_ = input;
	gvir_config_domain_input_set_bus (_tmp8_, GVIR_CONFIG_DOMAIN_INPUT_BUS_USB);
	_tmp9_ = input;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp9_);
	_g_object_unref0 (input);
	_g_object_unref0 (device);
}

static void
boxes_vm_configurator_set_mouse_config (GVirConfigDomain* domain,
                                        BoxesInstallerMedia* install_media)
{
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	boxes_vm_configurator_set_input_config (domain, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_MOUSE);
}

static void
boxes_vm_configurator_set_keyboard_config (GVirConfigDomain* domain,
                                           BoxesInstallerMedia* install_media)
{
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	boxes_vm_configurator_set_input_config (domain, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_KEYBOARD);
}

static void
boxes_vm_configurator_set_input_config (GVirConfigDomain* domain,
                                        GVirConfigDomainInputDeviceType device_type)
{
	GVirConfigDomainInput* input = NULL;
	GVirConfigDomainInput* _tmp0_;
	g_return_if_fail (domain != NULL);
	_tmp0_ = gvir_config_domain_input_new ();
	input = _tmp0_;
	gvir_config_domain_input_set_device_type (input, device_type);
	gvir_config_domain_input_set_bus (input, GVIR_CONFIG_DOMAIN_INPUT_BUS_PS2);
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) input);
	_g_object_unref0 (input);
}

static GVirConfigStoragePermissions*
boxes_vm_configurator_get_default_permissions (void)
{
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp0_;
	GVirConfigStoragePermissions* result;
	_tmp0_ = gvir_config_storage_permissions_new ();
	permissions = _tmp0_;
	gvir_config_storage_permissions_set_owner (permissions, (guint) getuid ());
	gvir_config_storage_permissions_set_group (permissions, (guint) getgid ());
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
	result = permissions;
	return result;
}

static gchar*
boxes_vm_configurator_get_os_state (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "os-state");
	result = _tmp0_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
boxes_vm_configurator_get_libosinfo_os_id (GVirConfigDomain* domain)
{
	gchar* ns_uri = NULL;
	gchar* _tmp0_;
	gchar* xml = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	xmlTextReader* reader = NULL;
	const gchar* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	const gchar* _tmp11_;
	xmlTextReader* _tmp12_;
	xmlTextReader* _tmp13_;
	xmlNode* node = NULL;
	xmlTextReader* _tmp14_;
	xmlNode* _tmp15_;
	xmlNode* _tmp16_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = g_strdup (BOXES_VM_CONFIGURATOR_LIBOSINFO_NS_URI);
	ns_uri = _tmp0_;
	_tmp1_ = ns_uri;
	_tmp2_ = gvir_config_domain_get_custom_xml (domain, _tmp1_);
	xml = _tmp2_;
	_tmp3_ = xml;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_free0 (xml);
		_g_free0 (ns_uri);
		return result;
	}
	_tmp4_ = xml;
	_tmp5_ = string_get_data (_tmp4_, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = xml;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = ns_uri;
	_tmp12_ = xmlReaderForMemory ((gchar*) _tmp7_, _tmp10_, _tmp11_, NULL, (gint) XML_PARSE_COMPACT);
	reader = _tmp12_;
	_tmp13_ = reader;
	xmlTextReaderNext (_tmp13_);
	_tmp14_ = reader;
	_tmp15_ = xmlTextReaderExpand (_tmp14_);
	node = _tmp15_;
	_tmp16_ = node;
	if (_tmp16_ != NULL) {
		xmlNode* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = node;
		_tmp18_ = _tmp17_->name;
		if (g_strcmp0 (_tmp18_, "libosinfo") == 0) {
			xmlNode* _tmp19_;
			xmlNode* _tmp20_;
			_tmp19_ = node;
			_tmp20_ = _tmp19_->children;
			node = _tmp20_;
		}
		while (TRUE) {
			xmlNode* _tmp21_;
			xmlNode* _tmp22_;
			const gchar* _tmp23_;
			xmlNode* _tmp26_;
			xmlNode* _tmp27_;
			_tmp21_ = node;
			if (!(_tmp21_ != NULL)) {
				break;
			}
			_tmp22_ = node;
			_tmp23_ = _tmp22_->name;
			if (g_strcmp0 (_tmp23_, "os") == 0) {
				xmlNode* _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = node;
				_tmp25_ = (gchar*) xmlGetProp (_tmp24_, (xmlChar*) "id");
				result = _tmp25_;
				_xmlFreeTextReader0 (reader);
				_g_free0 (xml);
				_g_free0 (ns_uri);
				return result;
			}
			_tmp26_ = node;
			_tmp27_ = _tmp26_->next;
			node = _tmp27_;
		}
	}
	result = NULL;
	_xmlFreeTextReader0 (reader);
	_g_free0 (xml);
	_g_free0 (ns_uri);
	return result;
}

gchar*
boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain,
                                           const gchar* node_name)
{
	gchar* ns_uri = NULL;
	gchar* _tmp0_;
	gchar* xml = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp34_;
	gchar* result;
	g_return_val_if_fail (domain != NULL, NULL);
	g_return_val_if_fail (node_name != NULL, NULL);
	_tmp0_ = g_strdup (BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
	ns_uri = _tmp0_;
	_tmp1_ = ns_uri;
	_tmp2_ = gvir_config_domain_get_custom_xml (domain, _tmp1_);
	xml = _tmp2_;
	_tmp3_ = xml;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = g_strdup (BOXES_VM_CONFIGURATOR_BOXES_OLD_NS_URI);
		_g_free0 (ns_uri);
		ns_uri = _tmp4_;
		_tmp5_ = ns_uri;
		_tmp6_ = gvir_config_domain_get_custom_xml (domain, _tmp5_);
		_g_free0 (xml);
		xml = _tmp6_;
	}
	_tmp7_ = xml;
	if (_tmp7_ != NULL) {
		xmlTextReader* reader = NULL;
		const gchar* _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		gint _tmp10_ = 0;
		guint8* _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		const gchar* _tmp15_;
		xmlTextReader* _tmp16_;
		xmlTextReader* _tmp17_;
		xmlNode* node = NULL;
		xmlTextReader* _tmp18_;
		xmlNode* _tmp19_;
		xmlNode* _tmp20_;
		_tmp8_ = xml;
		_tmp9_ = string_get_data (_tmp8_, &_tmp10_);
		_tmp9__length1 = _tmp10_;
		_tmp11_ = _tmp9_;
		_tmp11__length1 = _tmp9__length1;
		_tmp12_ = xml;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = ns_uri;
		_tmp16_ = xmlReaderForMemory ((gchar*) _tmp11_, _tmp14_, _tmp15_, NULL, (gint) XML_PARSE_COMPACT);
		reader = _tmp16_;
		_tmp17_ = reader;
		xmlTextReaderNext (_tmp17_);
		_tmp18_ = reader;
		_tmp19_ = xmlTextReaderExpand (_tmp18_);
		node = _tmp19_;
		_tmp20_ = node;
		if (_tmp20_ != NULL) {
			xmlNode* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = node;
			_tmp22_ = _tmp21_->name;
			if (g_strcmp0 (_tmp22_, "gnome-boxes") == 0) {
				xmlNode* _tmp23_;
				xmlNode* _tmp24_;
				_tmp23_ = node;
				_tmp24_ = _tmp23_->children;
				node = _tmp24_;
			}
			while (TRUE) {
				xmlNode* _tmp25_;
				xmlNode* _tmp26_;
				const gchar* _tmp27_;
				xmlNode* _tmp32_;
				xmlNode* _tmp33_;
				_tmp25_ = node;
				if (!(_tmp25_ != NULL)) {
					break;
				}
				_tmp26_ = node;
				_tmp27_ = _tmp26_->name;
				if (g_strcmp0 (_tmp27_, node_name) == 0) {
					xmlNode* _tmp28_;
					xmlNode* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp28_ = node;
					_tmp29_ = _tmp28_->children;
					_tmp30_ = _tmp29_->content;
					_tmp31_ = g_strdup (_tmp30_);
					result = _tmp31_;
					_xmlFreeTextReader0 (reader);
					_g_free0 (xml);
					_g_free0 (ns_uri);
					return result;
				}
				_tmp32_ = node;
				_tmp33_ = _tmp32_->next;
				node = _tmp33_;
			}
		}
		_xmlFreeTextReader0 (reader);
	}
	_tmp34_ = gvir_config_domain_get_name (domain);
	g_debug ("vm-configurator.vala:577: No XML node %s' for domain '%s'.", node_name, _tmp34_);
	result = NULL;
	_g_free0 (xml);
	_g_free0 (ns_uri);
	return result;
}

static gboolean
boxes_vm_configurator_boxes_created_domain (GVirConfigDomain* domain)
{
	gchar* xml = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = gvir_config_domain_get_custom_xml (domain, BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
	xml = _tmp0_;
	_tmp1_ = xml;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = gvir_config_domain_get_custom_xml (domain, BOXES_VM_CONFIGURATOR_BOXES_OLD_NS_URI);
		_g_free0 (xml);
		xml = _tmp2_;
	}
	_tmp3_ = xml;
	result = _tmp3_ != NULL;
	_g_free0 (xml);
	return result;
}

static gboolean
boxes_vm_configurator_boxes_edited_domain (GVirConfigDomain* domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = boxes_vm_configurator_get_custom_xml_node (domain, "edited");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain,
                                         BoxesInstallerMedia* install_media,
                                         guint num_reboots,
                                         gboolean installed)
{
	gboolean _tmp0_ = FALSE;
	gchar* custom_xml = NULL;
	gchar* custom_libosinfo_xml = NULL;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (domain != NULL);
	if (install_media != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = installed;
	}
	g_return_if_fail (_tmp0_);
	custom_libosinfo_xml = NULL;
	if (installed) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (BOXES_VM_CONFIGURATOR_INSTALLED_XML);
		_g_free0 (custom_xml);
		custom_xml = _tmp1_;
	} else {
		if (BOXES_IS_LIBVIRT_CLONED_MEDIA (install_media)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (BOXES_VM_CONFIGURATOR_LIBVIRT_CLONING_XML);
			_g_free0 (custom_xml);
			custom_xml = _tmp2_;
		} else {
			if (BOXES_IS_LIBVIRT_MEDIA (install_media)) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup (BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_XML);
				_g_free0 (custom_xml);
				custom_xml = _tmp3_;
			} else {
				if (BOXES_IS_INSTALLED_MEDIA (install_media)) {
					gchar* _tmp4_;
					_tmp4_ = g_strdup (BOXES_VM_CONFIGURATOR_IMPORT_XML);
					_g_free0 (custom_xml);
					custom_xml = _tmp4_;
				} else {
					const gchar* _tmp5_ = NULL;
					gboolean _tmp6_;
					gboolean _tmp7_;
					gchar* _tmp8_;
					_tmp6_ = boxes_installer_media_get_live (install_media);
					_tmp7_ = _tmp6_;
					if (_tmp7_) {
						_tmp5_ = BOXES_VM_CONFIGURATOR_LIVE_XML;
					} else {
						_tmp5_ = BOXES_VM_CONFIGURATOR_INSTALLATION_XML;
					}
					_tmp8_ = g_strdup (_tmp5_);
					_g_free0 (custom_xml);
					custom_xml = _tmp8_;
				}
			}
		}
	}
	if (install_media != NULL) {
		OsinfoOs* _tmp9_;
		OsinfoMedia* _tmp15_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp9_ = install_media->os;
		if (_tmp9_ != NULL) {
			OsinfoOs* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = install_media->os;
			g_object_get ((OsinfoEntity*) _tmp10_, "id", &_tmp11_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_LIBOSINFO_OS_ID_XML, _tmp13_);
			_g_free0 (custom_libosinfo_xml);
			custom_libosinfo_xml = _tmp14_;
			_g_free0 (_tmp13_);
		}
		_tmp15_ = install_media->os_media;
		if (_tmp15_ != NULL) {
			const gchar* _tmp16_;
			OsinfoMedia* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp16_ = custom_xml;
			_tmp17_ = install_media->os_media;
			g_object_get ((OsinfoEntity*) _tmp17_, "id", &_tmp18_, NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_MEDIA_ID_XML, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_tmp16_, _tmp22_, NULL);
			_g_free0 (custom_xml);
			custom_xml = _tmp23_;
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
		}
		_tmp24_ = custom_xml;
		_tmp25_ = install_media->device_file;
		_tmp26_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_MEDIA_XML, _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
		_g_free0 (custom_xml);
		custom_xml = _tmp28_;
		_g_free0 (_tmp27_);
	}
	if (num_reboots != ((guint) 0)) {
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp29_ = custom_xml;
		_tmp30_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML, num_reboots);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp29_, _tmp31_, NULL);
		_g_free0 (custom_xml);
		custom_xml = _tmp32_;
		_g_free0 (_tmp31_);
	}
	_tmp33_ = custom_xml;
	_tmp34_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_BOXES_XML, _tmp33_);
	_g_free0 (custom_xml);
	custom_xml = _tmp34_;
	{
		const gchar* _tmp35_;
		_tmp35_ = custom_xml;
		gvir_config_domain_set_custom_xml (domain, _tmp35_, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (custom_libosinfo_xml);
		_g_free0 (custom_xml);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp36_ = custom_libosinfo_xml;
	if (_tmp36_ != NULL) {
		const gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp37_ = custom_libosinfo_xml;
		_tmp38_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_LIBOSINFO_XML, _tmp37_);
		_g_free0 (custom_libosinfo_xml);
		custom_libosinfo_xml = _tmp38_;
		{
			const gchar* _tmp39_;
			_tmp39_ = custom_libosinfo_xml;
			gvir_config_domain_set_custom_xml_ns_children (domain, _tmp39_, BOXES_VM_CONFIGURATOR_LIBOSINFO_NS, BOXES_VM_CONFIGURATOR_LIBOSINFO_NS_URI, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_assert_not_reached ();
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (custom_libosinfo_xml);
			_g_free0 (custom_xml);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (custom_libosinfo_xml);
	_g_free0 (custom_xml);
}

void
boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain)
{
	GVirConfigDomainSmartcardPassthrough* smartcard = NULL;
	GVirConfigDomainSmartcardPassthrough* _tmp0_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp1_;
	g_return_if_fail (domain != NULL);
	_tmp0_ = gvir_config_domain_smartcard_passthrough_new ();
	smartcard = _tmp0_;
	_tmp1_ = gvir_config_domain_chardev_source_spicevmc_new ();
	vmc = _tmp1_;
	gvir_config_domain_smartcard_passthrough_set_source (smartcard, (GVirConfigDomainChardevSource*) vmc);
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) smartcard);
	_g_object_unref0 (vmc);
	_g_object_unref0 (smartcard);
}

void
boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain,
                                       BoxesInstallerMedia* install_media)
{
	OsinfoDevice* device = NULL;
	OsinfoDeviceList* _tmp8_;
	OsinfoDeviceList* _tmp9_;
	OsinfoDeviceList* _tmp10_;
	OsinfoDevice* _tmp11_;
	OsinfoDevice* _tmp12_;
	OsinfoDevice* _tmp13_;
	GVirConfigDomainControllerUsb* master_controller = NULL;
	GVirConfigDomainControllerUsb* _tmp17_;
	GVirConfigDomainControllerUsb* _tmp18_;
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp19_;
	GVirConfigDomainControllerUsb* _tmp20_;
	GVirConfigDomainControllerUsb* _tmp21_;
	GVirConfigDomainControllerUsb* _tmp22_;
	GVirConfigDomainControllerUsb* _tmp23_;
	GVirConfigDomainControllerUsb* _tmp24_;
	GVirConfigDomainControllerUsb* _tmp25_;
	GVirConfigDomainControllerUsb* _tmp26_;
	GVirConfigDomainControllerUsb* _tmp27_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GVirConfigDomainRedirdev* usb_redir = NULL;
				GVirConfigDomainRedirdev* _tmp2_;
				GVirConfigDomainRedirdev* _tmp3_;
				GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp4_;
				GVirConfigDomainRedirdev* _tmp5_;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp6_;
				GVirConfigDomainRedirdev* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 4)) {
					break;
				}
				_tmp2_ = gvir_config_domain_redirdev_new ();
				usb_redir = _tmp2_;
				_tmp3_ = usb_redir;
				gvir_config_domain_redirdev_set_bus (_tmp3_, GVIR_CONFIG_DOMAIN_REDIRDEV_BUS_USB);
				_tmp4_ = gvir_config_domain_chardev_source_spicevmc_new ();
				vmc = _tmp4_;
				_tmp5_ = usb_redir;
				_tmp6_ = vmc;
				gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp5_, (GVirConfigDomainChardevSource*) _tmp6_);
				_tmp7_ = usb_redir;
				gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp7_);
				_g_object_unref0 (vmc);
				_g_object_unref0 (usb_redir);
			}
		}
	}
	_tmp8_ = boxes_installer_media_get_supported_devices (install_media);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = boxes_find_device_by_prop (_tmp10_, OSINFO_DEVICE_PROP_NAME, "qemu-xhci");
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	device = _tmp12_;
	_tmp13_ = device;
	if (_tmp13_ != NULL) {
		GVirConfigDomainControllerUsb* controller = NULL;
		GVirConfigDomainControllerUsb* _tmp14_;
		GVirConfigDomainControllerUsb* _tmp15_;
		GVirConfigDomainControllerUsb* _tmp16_;
		_tmp14_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_QEMU_XHCI, NULL, (guint) 0, (guint) 0);
		controller = _tmp14_;
		_tmp15_ = controller;
		gvir_config_domain_controller_set_ports ((GVirConfigDomainController*) _tmp15_, (guint) 15);
		_tmp16_ = controller;
		gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp16_);
		_g_object_unref0 (controller);
		_g_object_unref0 (device);
		return;
	}
	_tmp17_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_EHCI1, NULL, (guint) 0, (guint) 0);
	master_controller = _tmp17_;
	_tmp18_ = master_controller;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp18_);
	_tmp19_ = master_controller;
	_tmp20_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI1, _tmp19_, (guint) 0, (guint) 0);
	controller = _tmp20_;
	_tmp21_ = controller;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp21_);
	_tmp22_ = master_controller;
	_tmp23_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI2, _tmp22_, (guint) 0, (guint) 2);
	_g_object_unref0 (controller);
	controller = _tmp23_;
	_tmp24_ = controller;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp24_);
	_tmp25_ = master_controller;
	_tmp26_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI3, _tmp25_, (guint) 0, (guint) 4);
	_g_object_unref0 (controller);
	controller = _tmp26_;
	_tmp27_ = controller;
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp27_);
	_g_object_unref0 (controller);
	_g_object_unref0 (master_controller);
	_g_object_unref0 (device);
}

GVirConfigDomainInterface*
boxes_vm_configurator_create_network_interface (GVirConfigDomain* domain,
                                                gboolean bridge,
                                                gboolean virtio)
{
	GVirConfigDomainInterface* iface = NULL;
	GVirConfigDomainInterface* result;
	g_return_val_if_fail (domain != NULL, NULL);
	if (bridge) {
		const gchar* _tmp0_;
		GVirConfigDomainInterfaceBridge* bridge_iface = NULL;
		GVirConfigDomainInterfaceBridge* _tmp1_;
		GVirConfigDomainInterfaceBridge* _tmp2_;
		GVirConfigDomainInterfaceBridge* _tmp3_;
		GVirConfigDomainInterface* _tmp4_;
		_tmp0_ = gvir_config_domain_get_name (domain);
		g_debug ("vm-configurator.vala:680: Creating bridge network device for %s", _tmp0_);
		_tmp1_ = gvir_config_domain_interface_bridge_new ();
		bridge_iface = _tmp1_;
		_tmp2_ = bridge_iface;
		gvir_config_domain_interface_bridge_set_source (_tmp2_, "virbr0");
		_tmp3_ = bridge_iface;
		_tmp4_ = _g_object_ref0 ((GVirConfigDomainInterface*) _tmp3_);
		_g_object_unref0 (iface);
		iface = _tmp4_;
		_g_object_unref0 (bridge_iface);
	} else {
		const gchar* _tmp5_;
		GVirConfigDomainInterfaceUser* _tmp6_;
		_tmp5_ = gvir_config_domain_get_name (domain);
		g_debug ("vm-configurator.vala:685: Creating user network device for %s", _tmp5_);
		_tmp6_ = gvir_config_domain_interface_user_new ();
		_g_object_unref0 (iface);
		iface = (GVirConfigDomainInterface*) _tmp6_;
	}
	if (virtio) {
		GVirConfigDomainInterface* _tmp7_;
		_tmp7_ = iface;
		gvir_config_domain_interface_set_model (_tmp7_, "virtio");
	}
	result = iface;
	return result;
}

static GVirConfigDomainChannel*
boxes_vm_configurator_create_spice_agent_channel (void)
{
	GVirConfigDomainChannel* channel = NULL;
	GVirConfigDomainChannel* _tmp0_;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp1_;
	GVirConfigDomainChannel* result;
	_tmp0_ = gvir_config_domain_channel_new ();
	channel = _tmp0_;
	gvir_config_domain_channel_set_target_type (channel, GVIR_CONFIG_DOMAIN_CHANNEL_TARGET_VIRTIO);
	gvir_config_domain_channel_set_target_name (channel, BOXES_VM_CONFIGURATOR_SPICE_AGENT_CHANNEL);
	_tmp1_ = gvir_config_domain_chardev_source_spicevmc_new ();
	vmc = _tmp1_;
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) channel, (GVirConfigDomainChardevSource*) vmc);
	result = channel;
	_g_object_unref0 (vmc);
	return result;
}

GVirConfigDomainGraphicsSpice*
boxes_vm_configurator_create_graphics_device (gboolean accel3d)
{
	GVirConfigDomainGraphicsSpice* graphics = NULL;
	GVirConfigDomainGraphicsSpice* _tmp0_;
	GVirConfigDomainGraphicsSpice* result;
	_tmp0_ = gvir_config_domain_graphics_spice_new ();
	graphics = _tmp0_;
	gvir_config_domain_graphics_spice_set_autoport (graphics, FALSE);
	gvir_config_domain_graphics_spice_set_gl (graphics, accel3d);
	gvir_config_domain_graphics_spice_set_image_compression (graphics, GVIR_CONFIG_DOMAIN_GRAPHICS_SPICE_IMAGE_COMPRESSION_OFF);
	result = graphics;
	return result;
}

GVirConfigDomainChannel*
boxes_vm_configurator_create_spice_webdav_channel (void)
{
	GVirConfigDomainChannel* channel_webdav = NULL;
	GVirConfigDomainChannel* _tmp0_;
	GVirConfigDomainChardevSourceSpicePort* spice_port = NULL;
	GVirConfigDomainChardevSourceSpicePort* _tmp1_;
	GVirConfigDomainChannel* result;
	_tmp0_ = gvir_config_domain_channel_new ();
	channel_webdav = _tmp0_;
	gvir_config_domain_channel_set_target_type (channel_webdav, GVIR_CONFIG_DOMAIN_CHANNEL_TARGET_VIRTIO);
	gvir_config_domain_channel_set_target_name (channel_webdav, BOXES_VM_CONFIGURATOR_WEBDAV_CHANNEL_URI);
	_tmp1_ = gvir_config_domain_chardev_source_spiceport_new ();
	spice_port = _tmp1_;
	gvir_config_domain_chardev_source_spiceport_set_channel (spice_port, BOXES_VM_CONFIGURATOR_WEBDAV_CHANNEL_URI);
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) channel_webdav, (GVirConfigDomainChardevSource*) spice_port);
	result = channel_webdav;
	_g_object_unref0 (spice_port);
	return result;
}

static GVirConfigDomainControllerUsb*
boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model,
                                             GVirConfigDomainControllerUsb* master,
                                             guint index,
                                             guint start_port)
{
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp0_;
	GVirConfigDomainControllerUsb* _tmp1_;
	GVirConfigDomainControllerUsb* _tmp2_;
	GVirConfigDomainControllerUsb* result;
	_tmp0_ = gvir_config_domain_controller_usb_new ();
	controller = _tmp0_;
	_tmp1_ = controller;
	gvir_config_domain_controller_usb_set_model (_tmp1_, model);
	_tmp2_ = controller;
	gvir_config_domain_controller_set_index ((GVirConfigDomainController*) _tmp2_, index);
	if (master != NULL) {
		GVirConfigDomainControllerUsb* _tmp3_;
		_tmp3_ = controller;
		gvir_config_domain_controller_usb_set_master (_tmp3_, master, start_port);
	}
	result = controller;
	return result;
}

static gint
__lambda43_ (GVirConfigCapabilitiesGuest* caps_a,
             GVirConfigCapabilitiesGuest* caps_b)
{
	gchar* arch_a = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* arch_b = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp5_;
	GVirConfigCapabilitiesGuestArch* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gint result;
	g_return_val_if_fail (caps_a != NULL, 0);
	g_return_val_if_fail (caps_b != NULL, 0);
	_tmp0_ = gvir_config_capabilities_guest_get_arch (caps_a);
	_tmp1_ = _tmp0_;
	_tmp2_ = gvir_config_capabilities_guest_arch_get_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	arch_a = _tmp4_;
	_tmp5_ = gvir_config_capabilities_guest_get_arch (caps_b);
	_tmp6_ = _tmp5_;
	_tmp7_ = gvir_config_capabilities_guest_arch_get_name (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp6_);
	arch_b = _tmp9_;
	_tmp10_ = arch_a;
	if (g_strcmp0 (_tmp10_, "i686") == 0) {
		const gchar* _tmp11_;
		_tmp11_ = arch_b;
		if (g_strcmp0 (_tmp11_, "x86_64") == 0) {
			result = 1;
			_g_free0 (arch_b);
			_g_free0 (arch_a);
			return result;
		} else {
			result = -1;
			_g_free0 (arch_b);
			_g_free0 (arch_a);
			return result;
		}
	} else {
		const gchar* _tmp12_;
		_tmp12_ = arch_a;
		if (g_strcmp0 (_tmp12_, "x86_64") == 0) {
			result = -1;
			_g_free0 (arch_b);
			_g_free0 (arch_a);
			return result;
		} else {
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = arch_b;
			if (g_strcmp0 (_tmp14_, "x86_64") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = arch_b;
				_tmp13_ = g_strcmp0 (_tmp15_, "i686") == 0;
			}
			if (_tmp13_) {
				result = 1;
				_g_free0 (arch_b);
				_g_free0 (arch_a);
				return result;
			} else {
				result = 0;
				_g_free0 (arch_b);
				_g_free0 (arch_a);
				return result;
			}
		}
	}
}

static gint
___lambda43__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda43_ ((GVirConfigCapabilitiesGuest*) a, (GVirConfigCapabilitiesGuest*) b);
	return result;
}

static GVirConfigCapabilitiesGuest*
boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps,
                                           BoxesInstallerMedia* install_media,
                                           GError** error)
{
	GList* guests_caps = NULL;
	GList* _tmp0_;
	GList* compat_guests_caps = NULL;
	GList* _tmp1_;
	GList* _tmp12_;
	GList* _tmp15_;
	GError* _tmp18_;
	GError* _inner_error0_ = NULL;
	GVirConfigCapabilitiesGuest* result;
	g_return_val_if_fail (caps != NULL, NULL);
	g_return_val_if_fail (install_media != NULL, NULL);
	_tmp0_ = gvir_config_capabilities_get_guests (caps);
	guests_caps = _tmp0_;
	guests_caps = g_list_sort (guests_caps, ___lambda43__gcompare_func);
	compat_guests_caps = NULL;
	_tmp1_ = guests_caps;
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
		guest_caps_collection = _tmp1_;
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
			GVirConfigCapabilitiesGuest* _tmp2_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
			_tmp2_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
			guest_caps = _tmp2_;
			{
				gchar* guest_arch = NULL;
				GVirConfigCapabilitiesGuest* _tmp3_;
				GVirConfigCapabilitiesGuestArch* _tmp4_;
				GVirConfigCapabilitiesGuestArch* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp3_ = guest_caps;
				_tmp4_ = gvir_config_capabilities_guest_get_arch (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = gvir_config_capabilities_guest_arch_get_name (_tmp5_);
				_tmp7_ = g_strdup (_tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp5_);
				guest_arch = _tmp8_;
				_tmp9_ = guest_arch;
				if (boxes_installer_media_is_architecture_compatible (install_media, _tmp9_)) {
					GVirConfigCapabilitiesGuest* _tmp10_;
					GVirConfigCapabilitiesGuest* _tmp11_;
					_tmp10_ = guest_caps;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					compat_guests_caps = g_list_append (compat_guests_caps, _tmp11_);
				}
				_g_free0 (guest_arch);
				_g_object_unref0 (guest_caps);
			}
		}
	}
	_tmp12_ = compat_guests_caps;
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
		guest_caps_collection = _tmp12_;
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
			GVirConfigCapabilitiesGuest* _tmp13_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
			_tmp13_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
			guest_caps = _tmp13_;
			{
				GVirConfigCapabilitiesGuest* _tmp14_;
				_tmp14_ = guest_caps;
				if (boxes_vm_configurator_guest_kvm_enabled (_tmp14_)) {
					result = guest_caps;
					(compat_guests_caps == NULL) ? NULL : (compat_guests_caps = (_g_list_free__g_object_unref0_ (compat_guests_caps), NULL));
					(guests_caps == NULL) ? NULL : (guests_caps = (_g_list_free__g_object_unref0_ (guests_caps), NULL));
					return result;
				}
				_g_object_unref0 (guest_caps);
			}
		}
	}
	_tmp15_ = compat_guests_caps;
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
		guest_caps_collection = _tmp15_;
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
			GVirConfigCapabilitiesGuest* _tmp16_;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
			_tmp16_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
			guest_caps = _tmp16_;
			{
				GVirConfigCapabilitiesGuest* _tmp17_;
				_tmp17_ = guest_caps;
				if (boxes_vm_configurator_guest_is_qemu (_tmp17_)) {
					result = guest_caps;
					(compat_guests_caps == NULL) ? NULL : (compat_guests_caps = (_g_list_free__g_object_unref0_ (compat_guests_caps), NULL));
					(guests_caps == NULL) ? NULL : (guests_caps = (_g_list_free__g_object_unref0_ (guests_caps), NULL));
					return result;
				}
				_g_object_unref0 (guest_caps);
			}
		}
	}
	_tmp18_ = g_error_new_literal (BOXES_VM_CONFIGURATOR_ERROR, BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS, _ ("Incapable host system"));
	_inner_error0_ = _tmp18_;
	if (_inner_error0_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
		g_propagate_error (error, _inner_error0_);
		(compat_guests_caps == NULL) ? NULL : (compat_guests_caps = (_g_list_free__g_object_unref0_ (compat_guests_caps), NULL));
		(guests_caps == NULL) ? NULL : (guests_caps = (_g_list_free__g_object_unref0_ (guests_caps), NULL));
		return NULL;
	} else {
		(compat_guests_caps == NULL) ? NULL : (compat_guests_caps = (_g_list_free__g_object_unref0_ (compat_guests_caps), NULL));
		(guests_caps == NULL) ? NULL : (guests_caps = (_g_list_free__g_object_unref0_ (guests_caps), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gboolean
boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps)
{
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (guest_caps != NULL, FALSE);
	_tmp0_ = gvir_config_capabilities_guest_get_arch (guest_caps);
	arch = _tmp0_;
	_tmp1_ = arch;
	_tmp2_ = gvir_config_capabilities_guest_arch_get_domains (_tmp1_);
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
		domain_collection = _tmp2_;
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
			GVirConfigCapabilitiesGuestDomain* _tmp3_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
			domain = _tmp3_;
			{
				GVirConfigCapabilitiesGuestDomain* _tmp4_;
				_tmp4_ = domain;
				if (gvir_config_capabilities_guest_domain_get_virt_type (_tmp4_) == GVIR_CONFIG_DOMAIN_VIRT_KVM) {
					result = TRUE;
					_g_object_unref0 (domain);
					(domain_collection == NULL) ? NULL : (domain_collection = (_g_list_free__g_object_unref0_ (domain_collection), NULL));
					_g_object_unref0 (arch);
					return result;
				}
				_g_object_unref0 (domain);
			}
		}
		(domain_collection == NULL) ? NULL : (domain_collection = (_g_list_free__g_object_unref0_ (domain_collection), NULL));
	}
	result = FALSE;
	_g_object_unref0 (arch);
	return result;
}

static gboolean
boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps)
{
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp0_;
	GVirConfigCapabilitiesGuestArch* _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (guest_caps != NULL, FALSE);
	_tmp0_ = gvir_config_capabilities_guest_get_arch (guest_caps);
	arch = _tmp0_;
	_tmp1_ = arch;
	_tmp2_ = gvir_config_capabilities_guest_arch_get_domains (_tmp1_);
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
		domain_collection = _tmp2_;
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
			GVirConfigCapabilitiesGuestDomain* _tmp3_;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
			domain = _tmp3_;
			{
				GVirConfigCapabilitiesGuestDomain* _tmp4_;
				_tmp4_ = domain;
				if (gvir_config_capabilities_guest_domain_get_virt_type (_tmp4_) == GVIR_CONFIG_DOMAIN_VIRT_QEMU) {
					result = TRUE;
					_g_object_unref0 (domain);
					(domain_collection == NULL) ? NULL : (domain_collection = (_g_list_free__g_object_unref0_ (domain_collection), NULL));
					_g_object_unref0 (arch);
					return result;
				}
				_g_object_unref0 (domain);
			}
		}
		(domain_collection == NULL) ? NULL : (domain_collection = (_g_list_free__g_object_unref0_ (domain_collection), NULL));
	}
	result = FALSE;
	_g_object_unref0 (arch);
	return result;
}

static gboolean
boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps,
                                              const gchar* feature_name)
{
	gboolean supports = FALSE;
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (guest_caps != NULL, FALSE);
	g_return_val_if_fail (feature_name != NULL, FALSE);
	supports = FALSE;
	_tmp0_ = gvir_config_capabilities_guest_get_features (guest_caps);
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
		feature_collection = _tmp0_;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GVirConfigCapabilitiesGuestFeature* _tmp1_;
			GVirConfigCapabilitiesGuestFeature* feature = NULL;
			_tmp1_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestFeature*) feature_it->data);
			feature = _tmp1_;
			{
				GVirConfigCapabilitiesGuestFeature* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = feature;
				_tmp3_ = gvir_config_capabilities_guest_feature_get_name (_tmp2_);
				if (g_strcmp0 (feature_name, _tmp3_) == 0) {
					supports = TRUE;
					_g_object_unref0 (feature);
					break;
				}
				_g_object_unref0 (feature);
			}
		}
		(feature_collection == NULL) ? NULL : (feature_collection = (_g_list_free__g_object_unref0_ (feature_collection), NULL));
	}
	result = supports;
	return result;
}

BoxesVMConfigurator*
boxes_vm_configurator_construct (GType object_type)
{
	BoxesVMConfigurator* self = NULL;
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
	return self;
}

BoxesVMConfigurator*
boxes_vm_configurator_new (void)
{
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
}

static void
boxes_value_vm_configurator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
boxes_value_vm_configurator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		boxes_vm_configurator_unref (value->data[0].v_pointer);
	}
}

static void
boxes_value_vm_configurator_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
boxes_value_vm_configurator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
boxes_value_vm_configurator_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BoxesVMConfigurator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
boxes_value_vm_configurator_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	BoxesVMConfigurator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
boxes_param_spec_vm_configurator (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	BoxesParamSpecVMConfigurator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
boxes_value_get_vm_configurator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	return value->data[0].v_pointer;
}

void
boxes_value_set_vm_configurator (GValue* value,
                                 gpointer v_object)
{
	BoxesVMConfigurator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_vm_configurator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}

void
boxes_value_take_vm_configurator (GValue* value,
                                  gpointer v_object)
{
	BoxesVMConfigurator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}

static void
boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass,
                                  gpointer klass_data)
{
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
	((BoxesVMConfiguratorClass *) klass)->finalize = boxes_vm_configurator_finalize;
}

static void
boxes_vm_configurator_instance_init (BoxesVMConfigurator * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
boxes_vm_configurator_finalize (BoxesVMConfigurator * obj)
{
	BoxesVMConfigurator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator);
	g_signal_handlers_destroy (self);
}

static GType
boxes_vm_configurator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType boxes_vm_configurator_type_id;
	boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return boxes_vm_configurator_type_id;
}

GType
boxes_vm_configurator_get_type (void)
{
	static volatile gsize boxes_vm_configurator_type_id__once = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__once)) {
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = boxes_vm_configurator_get_type_once ();
		g_once_init_leave (&boxes_vm_configurator_type_id__once, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__once;
}

gpointer
boxes_vm_configurator_ref (gpointer instance)
{
	BoxesVMConfigurator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
boxes_vm_configurator_unref (gpointer instance)
{
	BoxesVMConfigurator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

