/* TimerBreakController.c generated by valac 0.56.17, the Vala compiler
 * generated from TimerBreakController.vala, do not modify */

/* TimerBreakController.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib.h>
#include <json-glib/json-glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_0_PROPERTY,
	BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_INTERVAL_PROPERTY,
	BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DURATION_PROPERTY,
	BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_timer_break_timer_break_controller_properties[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_COUNTING_SIGNAL,
	BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DELAYED_SIGNAL,
	BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_NUM_SIGNALS
};
static guint break_timer_daemon_timer_break_timer_break_controller_signals[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_NUM_SIGNALS] = {0};

struct _BreakTimerDaemonTimerBreakTimerBreakControllerPrivate {
	gint _interval;
	gint _duration;
	BreakTimerDaemonUtilStatefulTimer* counting_timer;
	BreakTimerDaemonUtilStatefulTimer* delayed_timer;
	gboolean is_warned;
};

static gint BreakTimerDaemonTimerBreakTimerBreakController_private_offset;
static gpointer break_timer_daemon_timer_break_timer_break_controller_parent_class = NULL;

static void break_timer_daemon_timer_break_timer_break_controller_update_countdowns (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                              BreakTimerDaemonUtilPausableTimeout* timeout,
                                                                              gint delta_millisecs);
static void _break_timer_daemon_timer_break_timer_break_controller_update_countdowns_break_timer_daemon_util_pausable_timeout_timeout_cb (BreakTimerDaemonUtilPausableTimeout* timeout,
                                                                                                                                   gint delta_millisecs,
                                                                                                                                   gpointer self);
static void __lambda12_ (BreakTimerDaemonTimerBreakTimerBreakController* self,
                  GObject* s,
                  GParamSpec* p);
static void ___lambda12__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda13_ (BreakTimerDaemonTimerBreakTimerBreakController* self,
                  GObject* s,
                  GParamSpec* p);
static void break_timer_daemon_timer_break_timer_break_controller_unwarn (BreakTimerDaemonTimerBreakTimerBreakController* self);
static void ___lambda13__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void break_timer_daemon_timer_break_timer_break_controller_detected_activity_cb (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                                 BreakTimerDaemonActivityUserActivity* activity);
static void _break_timer_daemon_timer_break_timer_break_controller_detected_activity_cb_break_timer_daemon_activity_activity_monitor_detected_activity (BreakTimerDaemonActivityActivityMonitor* _sender,
                                                                                                                                                 BreakTimerDaemonActivityUserActivity* activity,
                                                                                                                                                 gpointer self);
static void break_timer_daemon_timer_break_timer_break_controller_detected_idle_cb (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                             BreakTimerDaemonActivityUserActivity* activity);
static void _break_timer_daemon_timer_break_timer_break_controller_detected_idle_cb_break_timer_daemon_activity_activity_monitor_detected_idle (BreakTimerDaemonActivityActivityMonitor* _sender,
                                                                                                                                         BreakTimerDaemonActivityUserActivity* activity,
                                                                                                                                         gpointer self);
static void break_timer_daemon_timer_break_timer_break_controller_enabled_cb (BreakTimerDaemonTimerBreakTimerBreakController* self);
static void _break_timer_daemon_timer_break_timer_break_controller_enabled_cb_break_timer_daemon_break_break_controller_enabled (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                          gpointer self);
static void break_timer_daemon_timer_break_timer_break_controller_disabled_cb (BreakTimerDaemonTimerBreakTimerBreakController* self);
static void _break_timer_daemon_timer_break_timer_break_controller_disabled_cb_break_timer_daemon_break_break_controller_disabled (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                            gpointer self);
static void break_timer_daemon_timer_break_timer_break_controller_activated_cb (BreakTimerDaemonTimerBreakTimerBreakController* self);
static void _break_timer_daemon_timer_break_timer_break_controller_activated_cb_break_timer_daemon_break_break_controller_activated (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                              gpointer self);
static void break_timer_daemon_timer_break_timer_break_controller_finished_cb (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                        BreakTimerDaemonBreakBreakControllerFinishedReason reason);
static void _break_timer_daemon_timer_break_timer_break_controller_finished_cb_break_timer_daemon_break_break_controller_finished (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                            BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                                                                            gboolean was_active,
                                                                                                                            gpointer self);
static JsonObject* break_timer_daemon_timer_break_timer_break_controller_real_serialize (BreakTimerDaemonBreakBreakController* base);
static void break_timer_daemon_timer_break_timer_break_controller_real_deserialize (BreakTimerDaemonBreakBreakController* base,
                                                                             JsonObject** json_root);
static void break_timer_daemon_timer_break_timer_break_controller_warn (BreakTimerDaemonTimerBreakTimerBreakController* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void break_timer_daemon_timer_break_timer_break_controller_finalize (GObject * obj);
static GType break_timer_daemon_timer_break_timer_break_controller_get_type_once (void);
static void _vala_break_timer_daemon_timer_break_timer_break_controller_get_property (GObject * object,
                                                                               guint property_id,
                                                                               GValue * value,
                                                                               GParamSpec * pspec);
static void _vala_break_timer_daemon_timer_break_timer_break_controller_set_property (GObject * object,
                                                                               guint property_id,
                                                                               const GValue * value,
                                                                               GParamSpec * pspec);

static inline gpointer
break_timer_daemon_timer_break_timer_break_controller_get_instance_private (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonTimerBreakTimerBreakController_private_offset);
}

static void
_break_timer_daemon_timer_break_timer_break_controller_update_countdowns_break_timer_daemon_util_pausable_timeout_timeout_cb (BreakTimerDaemonUtilPausableTimeout* timeout,
                                                                                                                              gint delta_millisecs,
                                                                                                                              gpointer self)
{
	break_timer_daemon_timer_break_timer_break_controller_update_countdowns ((BreakTimerDaemonTimerBreakTimerBreakController*) self, timeout, delta_millisecs);
}

static void
__lambda12_ (BreakTimerDaemonTimerBreakTimerBreakController* self,
             GObject* s,
             GParamSpec* p)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->interval_countdown;
	_tmp1_ = self->priv->_interval;
	break_timer_daemon_util_countdown_set_base_duration (_tmp0_, _tmp1_);
}

static void
___lambda12__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda12_ ((BreakTimerDaemonTimerBreakTimerBreakController*) self, _sender, pspec);
}

static void
__lambda13_ (BreakTimerDaemonTimerBreakTimerBreakController* self,
             GObject* s,
             GParamSpec* p)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	gint _tmp1_;
	BreakTimerDaemonBreakBreakControllerState _tmp2_;
	BreakTimerDaemonBreakBreakControllerState _tmp3_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->duration_countdown;
	_tmp1_ = self->priv->_duration;
	break_timer_daemon_util_countdown_set_base_duration (_tmp0_, _tmp1_);
	_tmp2_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING) {
		break_timer_daemon_timer_break_timer_break_controller_unwarn (self);
	}
}

static void
___lambda13__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda13_ ((BreakTimerDaemonTimerBreakTimerBreakController*) self, _sender, pspec);
}

static void
_break_timer_daemon_timer_break_timer_break_controller_detected_activity_cb_break_timer_daemon_activity_activity_monitor_detected_activity (BreakTimerDaemonActivityActivityMonitor* _sender,
                                                                                                                                            BreakTimerDaemonActivityUserActivity* activity,
                                                                                                                                            gpointer self)
{
	break_timer_daemon_timer_break_timer_break_controller_detected_activity_cb ((BreakTimerDaemonTimerBreakTimerBreakController*) self, activity);
}

static void
_break_timer_daemon_timer_break_timer_break_controller_detected_idle_cb_break_timer_daemon_activity_activity_monitor_detected_idle (BreakTimerDaemonActivityActivityMonitor* _sender,
                                                                                                                                    BreakTimerDaemonActivityUserActivity* activity,
                                                                                                                                    gpointer self)
{
	break_timer_daemon_timer_break_timer_break_controller_detected_idle_cb ((BreakTimerDaemonTimerBreakTimerBreakController*) self, activity);
}

static void
_break_timer_daemon_timer_break_timer_break_controller_enabled_cb_break_timer_daemon_break_break_controller_enabled (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                     gpointer self)
{
	break_timer_daemon_timer_break_timer_break_controller_enabled_cb ((BreakTimerDaemonTimerBreakTimerBreakController*) self);
}

static void
_break_timer_daemon_timer_break_timer_break_controller_disabled_cb_break_timer_daemon_break_break_controller_disabled (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                       gpointer self)
{
	break_timer_daemon_timer_break_timer_break_controller_disabled_cb ((BreakTimerDaemonTimerBreakTimerBreakController*) self);
}

static void
_break_timer_daemon_timer_break_timer_break_controller_activated_cb_break_timer_daemon_break_break_controller_activated (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                         gpointer self)
{
	break_timer_daemon_timer_break_timer_break_controller_activated_cb ((BreakTimerDaemonTimerBreakTimerBreakController*) self);
}

static void
_break_timer_daemon_timer_break_timer_break_controller_finished_cb_break_timer_daemon_break_break_controller_finished (BreakTimerDaemonBreakBreakController* _sender,
                                                                                                                       BreakTimerDaemonBreakBreakControllerFinishedReason reason,
                                                                                                                       gboolean was_active,
                                                                                                                       gpointer self)
{
	break_timer_daemon_timer_break_timer_break_controller_finished_cb ((BreakTimerDaemonTimerBreakTimerBreakController*) self, reason);
}

BreakTimerDaemonTimerBreakTimerBreakController*
break_timer_daemon_timer_break_timer_break_controller_construct (GType object_type,
                                                                 BreakTimerDaemonActivityActivityMonitor* activity_monitor,
                                                                 gint fuzzy_seconds)
{
	BreakTimerDaemonTimerBreakTimerBreakController * self = NULL;
	gint _tmp0_;
	BreakTimerDaemonUtilCountdown* _tmp1_;
	gint _tmp2_;
	BreakTimerDaemonUtilCountdown* _tmp3_;
	BreakTimerDaemonUtilPausableTimeout* _tmp4_;
	g_return_val_if_fail (activity_monitor != NULL, NULL);
	self = (BreakTimerDaemonTimerBreakTimerBreakController*) break_timer_daemon_break_break_controller_construct (object_type);
	self->fuzzy_seconds = fuzzy_seconds;
	_tmp0_ = self->priv->_interval;
	_tmp1_ = break_timer_daemon_util_countdown_new (_tmp0_);
	_g_object_unref0 (self->interval_countdown);
	self->interval_countdown = _tmp1_;
	_tmp2_ = self->priv->_duration;
	_tmp3_ = break_timer_daemon_util_countdown_new (_tmp2_);
	_g_object_unref0 (self->duration_countdown);
	self->duration_countdown = _tmp3_;
	_tmp4_ = break_timer_daemon_util_pausable_timeout_new (_break_timer_daemon_timer_break_timer_break_controller_update_countdowns_break_timer_daemon_util_pausable_timeout_timeout_cb, self, 1);
	_g_object_unref0 (self->countdowns_timeout);
	self->countdowns_timeout = _tmp4_;
	g_signal_connect_object ((GObject*) self, "notify::interval", (GCallback) ___lambda12__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::duration", (GCallback) ___lambda13__g_object_notify, self, 0);
	g_signal_connect_object (activity_monitor, "detected-activity", (GCallback) _break_timer_daemon_timer_break_timer_break_controller_detected_activity_cb_break_timer_daemon_activity_activity_monitor_detected_activity, self, 0);
	g_signal_connect_object (activity_monitor, "detected-idle", (GCallback) _break_timer_daemon_timer_break_timer_break_controller_detected_idle_cb_break_timer_daemon_activity_activity_monitor_detected_idle, self, 0);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakController*) self, "enabled", (GCallback) _break_timer_daemon_timer_break_timer_break_controller_enabled_cb_break_timer_daemon_break_break_controller_enabled, self, 0);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakController*) self, "disabled", (GCallback) _break_timer_daemon_timer_break_timer_break_controller_disabled_cb_break_timer_daemon_break_break_controller_disabled, self, 0);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakController*) self, "activated", (GCallback) _break_timer_daemon_timer_break_timer_break_controller_activated_cb_break_timer_daemon_break_break_controller_activated, self, 0);
	g_signal_connect_object ((BreakTimerDaemonBreakBreakController*) self, "finished", (GCallback) _break_timer_daemon_timer_break_timer_break_controller_finished_cb_break_timer_daemon_break_break_controller_finished, self, 0);
	return self;
}

static JsonObject*
break_timer_daemon_timer_break_timer_break_controller_real_serialize (BreakTimerDaemonBreakBreakController* base)
{
	BreakTimerDaemonTimerBreakTimerBreakController * self;
	JsonObject* json_root = NULL;
	JsonObject* _tmp0_;
	BreakTimerDaemonUtilCountdown* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BreakTimerDaemonUtilCountdown* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	BreakTimerDaemonUtilPausableTimeout* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	BreakTimerDaemonUtilStatefulTimer* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	BreakTimerDaemonUtilStatefulTimer* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	JsonObject* result;
	self = (BreakTimerDaemonTimerBreakTimerBreakController*) base;
	_tmp0_ = BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_CLASS (break_timer_daemon_timer_break_timer_break_controller_parent_class)->serialize (G_TYPE_CHECK_INSTANCE_CAST (self, BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, BreakTimerDaemonBreakBreakController));
	json_root = _tmp0_;
	_tmp1_ = self->interval_countdown;
	_tmp2_ = break_timer_daemon_util_countdown_serialize (_tmp1_);
	_tmp3_ = _tmp2_;
	json_object_set_string_member (json_root, "interval_countdown", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->duration_countdown;
	_tmp5_ = break_timer_daemon_util_countdown_serialize (_tmp4_);
	_tmp6_ = _tmp5_;
	json_object_set_string_member (json_root, "duration_countdown", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->countdowns_timeout;
	_tmp8_ = break_timer_daemon_util_pausable_timeout_serialize (_tmp7_);
	_tmp9_ = _tmp8_;
	json_object_set_string_member (json_root, "countdowns_timeout", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->counting_timer;
	_tmp11_ = break_timer_daemon_util_stateful_timer_serialize (_tmp10_);
	_tmp12_ = _tmp11_;
	json_object_set_string_member (json_root, "counting_timer", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->delayed_timer;
	_tmp14_ = break_timer_daemon_util_stateful_timer_serialize (_tmp13_);
	_tmp15_ = _tmp14_;
	json_object_set_string_member (json_root, "delayed_timer", _tmp15_);
	_g_free0 (_tmp15_);
	result = json_root;
	return result;
}

static void
break_timer_daemon_timer_break_timer_break_controller_real_deserialize (BreakTimerDaemonBreakBreakController* base,
                                                                        JsonObject** json_root)
{
	BreakTimerDaemonTimerBreakTimerBreakController * self;
	BreakTimerDaemonUtilCountdown* _tmp0_;
	const gchar* _tmp1_;
	BreakTimerDaemonUtilCountdown* _tmp2_;
	const gchar* _tmp3_;
	BreakTimerDaemonUtilPausableTimeout* _tmp4_;
	const gchar* _tmp5_;
	BreakTimerDaemonUtilStatefulTimer* _tmp6_;
	const gchar* _tmp7_;
	BreakTimerDaemonUtilStatefulTimer* _tmp8_;
	const gchar* _tmp9_;
	self = (BreakTimerDaemonTimerBreakTimerBreakController*) base;
	g_return_if_fail (*json_root != NULL);
	BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_CLASS (break_timer_daemon_timer_break_timer_break_controller_parent_class)->deserialize (G_TYPE_CHECK_INSTANCE_CAST (self, BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, BreakTimerDaemonBreakBreakController), json_root);
	_tmp0_ = self->interval_countdown;
	_tmp1_ = json_object_get_string_member (*json_root, "interval_countdown");
	break_timer_daemon_util_countdown_deserialize (_tmp0_, _tmp1_, FALSE);
	_tmp2_ = self->duration_countdown;
	_tmp3_ = json_object_get_string_member (*json_root, "duration_countdown");
	break_timer_daemon_util_countdown_deserialize (_tmp2_, _tmp3_, FALSE);
	_tmp4_ = self->countdowns_timeout;
	_tmp5_ = json_object_get_string_member (*json_root, "countdowns_timeout");
	break_timer_daemon_util_pausable_timeout_deserialize (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->counting_timer;
	_tmp7_ = json_object_get_string_member (*json_root, "counting_timer");
	break_timer_daemon_util_stateful_timer_deserialize (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->delayed_timer;
	_tmp9_ = json_object_get_string_member (*json_root, "delayed_timer");
	break_timer_daemon_util_stateful_timer_deserialize (_tmp8_, _tmp9_);
}

static void
break_timer_daemon_timer_break_timer_break_controller_enabled_cb (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	BreakTimerDaemonUtilCountdown* _tmp1_;
	BreakTimerDaemonUtilPausableTimeout* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->interval_countdown;
	break_timer_daemon_util_countdown_continue (_tmp0_);
	_tmp1_ = self->duration_countdown;
	break_timer_daemon_util_countdown_pause (_tmp1_);
	_tmp2_ = self->countdowns_timeout;
	break_timer_daemon_util_pausable_timeout_start (_tmp2_);
}

static void
break_timer_daemon_timer_break_timer_break_controller_disabled_cb (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	BreakTimerDaemonUtilCountdown* _tmp1_;
	BreakTimerDaemonUtilPausableTimeout* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->interval_countdown;
	break_timer_daemon_util_countdown_pause (_tmp0_);
	_tmp1_ = self->duration_countdown;
	break_timer_daemon_util_countdown_pause (_tmp1_);
	_tmp2_ = self->countdowns_timeout;
	break_timer_daemon_util_pausable_timeout_stop (_tmp2_);
}

static void
break_timer_daemon_timer_break_timer_break_controller_activated_cb (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	BreakTimerDaemonUtilCountdown* _tmp1_;
	BreakTimerDaemonUtilStatefulTimer* _tmp2_;
	BreakTimerDaemonUtilStatefulTimer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->interval_countdown;
	break_timer_daemon_util_countdown_pause (_tmp0_);
	_tmp1_ = self->duration_countdown;
	break_timer_daemon_util_countdown_continue (_tmp1_);
	_tmp2_ = self->priv->counting_timer;
	break_timer_daemon_util_stateful_timer_reset (_tmp2_);
	_tmp3_ = self->priv->delayed_timer;
	break_timer_daemon_util_stateful_timer_reset (_tmp3_);
}

static void
break_timer_daemon_timer_break_timer_break_controller_finished_cb (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                   BreakTimerDaemonBreakBreakControllerFinishedReason reason)
{
	g_return_if_fail (self != NULL);
	if (reason > BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_FINISHED_REASON_DISABLED) {
		BreakTimerDaemonUtilCountdown* _tmp0_;
		BreakTimerDaemonUtilCountdown* _tmp1_;
		BreakTimerDaemonUtilStatefulTimer* _tmp2_;
		BreakTimerDaemonUtilStatefulTimer* _tmp3_;
		_tmp0_ = self->interval_countdown;
		break_timer_daemon_util_countdown_reset (_tmp0_);
		_tmp1_ = self->duration_countdown;
		break_timer_daemon_util_countdown_reset (_tmp1_);
		_tmp2_ = self->priv->counting_timer;
		break_timer_daemon_util_stateful_timer_reset (_tmp2_);
		_tmp3_ = self->priv->delayed_timer;
		break_timer_daemon_util_stateful_timer_reset (_tmp3_);
	}
}

static void
break_timer_daemon_timer_break_timer_break_controller_warn (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->is_warned) {
		self->priv->is_warned = TRUE;
		g_signal_emit_by_name ((BreakTimerDaemonBreakBreakController*) self, "warned");
	}
}

static void
break_timer_daemon_timer_break_timer_break_controller_unwarn (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->is_warned) {
		self->priv->is_warned = FALSE;
		g_signal_emit_by_name ((BreakTimerDaemonBreakBreakController*) self, "unwarned");
	}
}

/**
     * @return Time until the next scheduled break, in seconds.
     */
gint
break_timer_daemon_timer_break_timer_break_controller_starts_in (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->interval_countdown;
	result = break_timer_daemon_util_countdown_get_time_remaining (_tmp0_);
	return result;
}

/**
     * @return Idle time remaining until the break is satisfied.
     */
gint
break_timer_daemon_timer_break_timer_break_controller_get_time_remaining (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->duration_countdown;
	result = break_timer_daemon_util_countdown_get_time_remaining (_tmp0_);
	return result;
}

/**
     * Stops the break and starts it again at some point in the future.
     * @param resume_after the amount of time to postpone for
     */
void
break_timer_daemon_timer_break_timer_break_controller_postpone (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                gint resume_after)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	break_timer_daemon_break_break_controller_skip ((BreakTimerDaemonBreakBreakController*) self, FALSE);
	_tmp0_ = self->interval_countdown;
	_tmp1_ = self->priv->_interval;
	break_timer_daemon_util_countdown_continue_from (_tmp0_, resume_after - _tmp1_);
}

/**
     * @return Total length of the break, taking into account extra time that
     *         may have been added outside of the break's settings.
     */
gint
break_timer_daemon_timer_break_timer_break_controller_get_current_duration (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->duration_countdown;
	result = break_timer_daemon_util_countdown_get_duration (_tmp0_);
	return result;
}

static void
break_timer_daemon_timer_break_timer_break_controller_detected_idle_cb (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                        BreakTimerDaemonActivityUserActivity* activity)
{
	BreakTimerDaemonActivityUserActivity _tmp0_;
	BreakTimerDaemonActivityUserActivity _tmp2_;
	BreakTimerDaemonBreakBreakControllerState _tmp5_;
	BreakTimerDaemonBreakBreakControllerState _tmp6_;
	gint lap_time = 0;
	BreakTimerDaemonUtilStatefulTimer* _tmp11_;
	BreakTimerDaemonUtilStatefulTimer* _tmp12_;
	BreakTimerDaemonUtilStatefulTimer* _tmp16_;
	BreakTimerDaemonUtilPausableTimeout* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (activity != NULL);
	if (!break_timer_daemon_break_break_controller_is_enabled ((BreakTimerDaemonBreakBreakController*) self)) {
		return;
	}
	_tmp0_ = *activity;
	if (_tmp0_.time_since_active < ((gint64) self->fuzzy_seconds)) {
		BreakTimerDaemonActivityUserActivity _tmp1_;
		_tmp1_ = *activity;
		break_timer_daemon_timer_break_timer_break_controller_detected_activity_cb (self, &_tmp1_);
		return;
	}
	_tmp2_ = *activity;
	if (_tmp2_.time_correction > ((gint64) 0)) {
		BreakTimerDaemonUtilCountdown* _tmp3_;
		BreakTimerDaemonActivityUserActivity _tmp4_;
		_tmp3_ = self->duration_countdown;
		_tmp4_ = *activity;
		break_timer_daemon_util_countdown_advance_time (_tmp3_, (gint) _tmp4_.time_correction);
	}
	_tmp5_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING) {
		BreakTimerDaemonUtilCountdown* _tmp7_;
		BreakTimerDaemonUtilCountdown* _tmp9_;
		_tmp7_ = self->interval_countdown;
		if (break_timer_daemon_util_countdown_get_time_elapsed (_tmp7_) > 0) {
			BreakTimerDaemonUtilCountdown* _tmp8_;
			_tmp8_ = self->duration_countdown;
			break_timer_daemon_util_countdown_continue (_tmp8_);
		}
		_tmp9_ = self->interval_countdown;
		break_timer_daemon_util_countdown_pause (_tmp9_);
	} else {
		BreakTimerDaemonUtilCountdown* _tmp10_;
		_tmp10_ = self->duration_countdown;
		break_timer_daemon_util_countdown_continue (_tmp10_);
	}
	_tmp11_ = self->priv->delayed_timer;
	break_timer_daemon_util_stateful_timer_freeze (_tmp11_);
	_tmp12_ = self->priv->counting_timer;
	if (break_timer_daemon_util_stateful_timer_is_stopped (_tmp12_)) {
		BreakTimerDaemonUtilStatefulTimer* _tmp13_;
		BreakTimerDaemonActivityUserActivity _tmp14_;
		_tmp13_ = self->priv->counting_timer;
		break_timer_daemon_util_stateful_timer_start_lap (_tmp13_);
		_tmp14_ = *activity;
		lap_time = (gint) _tmp14_.idle_time;
	} else {
		BreakTimerDaemonUtilStatefulTimer* _tmp15_;
		_tmp15_ = self->priv->counting_timer;
		lap_time = (gint) break_timer_daemon_util_stateful_timer_lap_time (_tmp15_);
	}
	_tmp16_ = self->priv->counting_timer;
	g_signal_emit (self, break_timer_daemon_timer_break_timer_break_controller_signals[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_COUNTING_SIGNAL], 0, lap_time, (gint) break_timer_daemon_util_stateful_timer_elapsed (_tmp16_));
	_tmp17_ = self->countdowns_timeout;
	break_timer_daemon_util_pausable_timeout_run_once (_tmp17_);
}

static void
break_timer_daemon_timer_break_timer_break_controller_detected_activity_cb (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                            BreakTimerDaemonActivityUserActivity* activity)
{
	gint lap_time = 0;
	BreakTimerDaemonUtilStatefulTimer* _tmp0_;
	BreakTimerDaemonUtilStatefulTimer* _tmp1_;
	BreakTimerDaemonUtilCountdown* _tmp4_;
	BreakTimerDaemonBreakBreakControllerState _tmp5_;
	BreakTimerDaemonBreakBreakControllerState _tmp6_;
	BreakTimerDaemonUtilStatefulTimer* _tmp8_;
	BreakTimerDaemonUtilPausableTimeout* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (activity != NULL);
	if (!break_timer_daemon_break_break_controller_is_enabled ((BreakTimerDaemonBreakBreakController*) self)) {
		return;
	}
	_tmp0_ = self->priv->counting_timer;
	break_timer_daemon_util_stateful_timer_freeze (_tmp0_);
	_tmp1_ = self->priv->delayed_timer;
	if (break_timer_daemon_util_stateful_timer_is_stopped (_tmp1_)) {
		BreakTimerDaemonUtilStatefulTimer* _tmp2_;
		_tmp2_ = self->priv->delayed_timer;
		break_timer_daemon_util_stateful_timer_start_lap (_tmp2_);
		lap_time = 0;
	} else {
		BreakTimerDaemonUtilStatefulTimer* _tmp3_;
		_tmp3_ = self->priv->delayed_timer;
		lap_time = (gint) break_timer_daemon_util_stateful_timer_lap_time (_tmp3_);
	}
	_tmp4_ = self->duration_countdown;
	break_timer_daemon_util_countdown_pause (_tmp4_);
	_tmp5_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING) {
		BreakTimerDaemonUtilCountdown* _tmp7_;
		_tmp7_ = self->interval_countdown;
		break_timer_daemon_util_countdown_continue (_tmp7_);
	}
	_tmp8_ = self->priv->delayed_timer;
	g_signal_emit (self, break_timer_daemon_timer_break_timer_break_controller_signals[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DELAYED_SIGNAL], 0, lap_time, (gint) break_timer_daemon_util_stateful_timer_elapsed (_tmp8_));
	_tmp9_ = self->countdowns_timeout;
	break_timer_daemon_util_pausable_timeout_run_once (_tmp9_);
}

/**
     * Checks if it is time to activate the break. The break will activate as
     * soon as soon as interval_countdown reaches 0. The break's "warned"
     * signal is fired when the break is close (within its set duration) to
     * starting.
     */
static void
break_timer_daemon_timer_break_timer_break_controller_update_countdowns (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                         BreakTimerDaemonUtilPausableTimeout* timeout,
                                                                         gint delta_millisecs)
{
	BreakTimerDaemonUtilCountdown* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeout != NULL);
	_tmp0_ = self->duration_countdown;
	if (break_timer_daemon_util_countdown_is_finished (_tmp0_)) {
		BreakTimerDaemonUtilCountdown* _tmp1_;
		_tmp1_ = self->duration_countdown;
		break_timer_daemon_util_countdown_reset (_tmp1_);
		break_timer_daemon_break_break_controller_finish ((BreakTimerDaemonBreakBreakController*) self);
	} else {
		BreakTimerDaemonBreakBreakControllerState _tmp2_;
		BreakTimerDaemonBreakBreakControllerState _tmp3_;
		_tmp2_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_WAITING) {
			if (break_timer_daemon_timer_break_timer_break_controller_starts_in (self) == 0) {
				break_timer_daemon_break_break_controller_activate ((BreakTimerDaemonBreakBreakController*) self);
			} else {
				gint _tmp4_;
				_tmp4_ = self->priv->_duration;
				if (break_timer_daemon_timer_break_timer_break_controller_starts_in (self) <= _tmp4_) {
					break_timer_daemon_timer_break_timer_break_controller_warn (self);
				} else {
					break_timer_daemon_timer_break_timer_break_controller_unwarn (self);
				}
			}
		} else {
			BreakTimerDaemonBreakBreakControllerState _tmp5_;
			BreakTimerDaemonBreakBreakControllerState _tmp6_;
			_tmp5_ = break_timer_daemon_break_break_controller_get_state ((BreakTimerDaemonBreakBreakController*) self);
			_tmp6_ = _tmp5_;
			if (_tmp6_ == BREAK_TIMER_DAEMON_BREAK_BREAK_CONTROLLER_STATE_ACTIVE) {
				g_signal_emit_by_name ((BreakTimerDaemonBreakBreakController*) self, "active-changed");
			}
		}
	}
}

gint
break_timer_daemon_timer_break_timer_break_controller_get_interval (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_interval;
	return result;
}

void
break_timer_daemon_timer_break_timer_break_controller_set_interval (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_daemon_timer_break_timer_break_controller_get_interval (self);
	if (old_value != value) {
		self->priv->_interval = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_daemon_timer_break_timer_break_controller_properties[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_INTERVAL_PROPERTY]);
	}
}

gint
break_timer_daemon_timer_break_timer_break_controller_get_duration (BreakTimerDaemonTimerBreakTimerBreakController* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_duration;
	return result;
}

void
break_timer_daemon_timer_break_timer_break_controller_set_duration (BreakTimerDaemonTimerBreakTimerBreakController* self,
                                                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = break_timer_daemon_timer_break_timer_break_controller_get_duration (self);
	if (old_value != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, break_timer_daemon_timer_break_timer_break_controller_properties[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DURATION_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
break_timer_daemon_timer_break_timer_break_controller_class_init (BreakTimerDaemonTimerBreakTimerBreakControllerClass * klass,
                                                                  gpointer klass_data)
{
	break_timer_daemon_timer_break_timer_break_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonTimerBreakTimerBreakController_private_offset);
	((BreakTimerDaemonBreakBreakControllerClass *) klass)->serialize = (JsonObject* (*) (BreakTimerDaemonBreakBreakController*)) break_timer_daemon_timer_break_timer_break_controller_real_serialize;
	((BreakTimerDaemonBreakBreakControllerClass *) klass)->deserialize = (void (*) (BreakTimerDaemonBreakBreakController*, JsonObject**)) break_timer_daemon_timer_break_timer_break_controller_real_deserialize;
	G_OBJECT_CLASS (klass)->get_property = _vala_break_timer_daemon_timer_break_timer_break_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_break_timer_daemon_timer_break_timer_break_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_timer_break_timer_break_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_INTERVAL_PROPERTY, break_timer_daemon_timer_break_timer_break_controller_properties[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_INTERVAL_PROPERTY] = g_param_spec_int ("interval", "interval", "interval", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DURATION_PROPERTY, break_timer_daemon_timer_break_timer_break_controller_properties[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DURATION_PROPERTY] = g_param_spec_int ("duration", "duration", "duration", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Fires continually, as long as the break is active and counting down. */
	break_timer_daemon_timer_break_timer_break_controller_signals[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_COUNTING_SIGNAL] = g_signal_new ("counting", BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	/** Fires as long as the break is active but is not counting down. */
	break_timer_daemon_timer_break_timer_break_controller_signals[BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DELAYED_SIGNAL] = g_signal_new ("delayed", BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}

static void
break_timer_daemon_timer_break_timer_break_controller_instance_init (BreakTimerDaemonTimerBreakTimerBreakController * self,
                                                                     gpointer klass)
{
	BreakTimerDaemonUtilStatefulTimer* _tmp0_;
	BreakTimerDaemonUtilStatefulTimer* _tmp1_;
	self->priv = break_timer_daemon_timer_break_timer_break_controller_get_instance_private (self);
	_tmp0_ = break_timer_daemon_util_stateful_timer_new ();
	self->priv->counting_timer = _tmp0_;
	_tmp1_ = break_timer_daemon_util_stateful_timer_new ();
	self->priv->delayed_timer = _tmp1_;
}

static void
break_timer_daemon_timer_break_timer_break_controller_finalize (GObject * obj)
{
	BreakTimerDaemonTimerBreakTimerBreakController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, BreakTimerDaemonTimerBreakTimerBreakController);
	_g_object_unref0 (self->interval_countdown);
	_g_object_unref0 (self->duration_countdown);
	_g_object_unref0 (self->countdowns_timeout);
	_g_object_unref0 (self->priv->counting_timer);
	_g_object_unref0 (self->priv->delayed_timer);
	G_OBJECT_CLASS (break_timer_daemon_timer_break_timer_break_controller_parent_class)->finalize (obj);
}

/**
 * A type of break that times user activity. It activates after a particular
 * amount of uninterupted activity, and the break is finished after a
 * different amount of inactivity. The timer break has two timers: an interval
 * (time between breaks) and a duration (the length of each break). Once
 * started, the timer break continuously counts down for its interval, then
 * activates and counts down for its duration.
 */
static GType
break_timer_daemon_timer_break_timer_break_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonTimerBreakTimerBreakControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_timer_break_timer_break_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonTimerBreakTimerBreakController), 0, (GInstanceInitFunc) break_timer_daemon_timer_break_timer_break_controller_instance_init, NULL };
	GType break_timer_daemon_timer_break_timer_break_controller_type_id;
	break_timer_daemon_timer_break_timer_break_controller_type_id = g_type_register_static (BREAK_TIMER_DAEMON_BREAK_TYPE_BREAK_CONTROLLER, "BreakTimerDaemonTimerBreakTimerBreakController", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BreakTimerDaemonTimerBreakTimerBreakController_private_offset = g_type_add_instance_private (break_timer_daemon_timer_break_timer_break_controller_type_id, sizeof (BreakTimerDaemonTimerBreakTimerBreakControllerPrivate));
	return break_timer_daemon_timer_break_timer_break_controller_type_id;
}

GType
break_timer_daemon_timer_break_timer_break_controller_get_type (void)
{
	static volatile gsize break_timer_daemon_timer_break_timer_break_controller_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_timer_break_timer_break_controller_type_id__once)) {
		GType break_timer_daemon_timer_break_timer_break_controller_type_id;
		break_timer_daemon_timer_break_timer_break_controller_type_id = break_timer_daemon_timer_break_timer_break_controller_get_type_once ();
		g_once_init_leave (&break_timer_daemon_timer_break_timer_break_controller_type_id__once, break_timer_daemon_timer_break_timer_break_controller_type_id);
	}
	return break_timer_daemon_timer_break_timer_break_controller_type_id__once;
}

static void
_vala_break_timer_daemon_timer_break_timer_break_controller_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec)
{
	BreakTimerDaemonTimerBreakTimerBreakController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, BreakTimerDaemonTimerBreakTimerBreakController);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_INTERVAL_PROPERTY:
		g_value_set_int (value, break_timer_daemon_timer_break_timer_break_controller_get_interval (self));
		break;
		case BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DURATION_PROPERTY:
		g_value_set_int (value, break_timer_daemon_timer_break_timer_break_controller_get_duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_break_timer_daemon_timer_break_timer_break_controller_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec)
{
	BreakTimerDaemonTimerBreakTimerBreakController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BREAK_TIMER_DAEMON_TIMER_BREAK_TYPE_TIMER_BREAK_CONTROLLER, BreakTimerDaemonTimerBreakTimerBreakController);
	switch (property_id) {
		case BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_INTERVAL_PROPERTY:
		break_timer_daemon_timer_break_timer_break_controller_set_interval (self, g_value_get_int (value));
		break;
		case BREAK_TIMER_DAEMON_TIMER_BREAK_TIMER_BREAK_CONTROLLER_DURATION_PROPERTY:
		break_timer_daemon_timer_break_timer_break_controller_set_duration (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

