/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gdbo-call.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringVariantFunc)
       (void *data1,
        const gchar *arg_name,
        GVariant *arg_value,
        void *data2);
  _GDbusCodegenMarshalVoid_StringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_number,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.ofono.VoiceCall
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GDBOVoiceCall
 * @title: GDBOVoiceCall
 * @short_description: Generated C code for the org.ofono.VoiceCall D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ofono-VoiceCall.top_of_page">org.ofono.VoiceCall</link> D-Bus interface in C.
 */

enum
{
  GDBO__VOICE_CALL_PROPERTY_CHANGED,
  GDBO__VOICE_CALL_DISCONNECT_REASON,
};

static unsigned GDBO__VOICE_CALL_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.ofono.VoiceCall ---- */

static const _ExtendedGDBusArgInfo _gdbo_voice_call_method_info_get_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_gdbo_voice_call_method_info_get_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_gdbo_voice_call_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_method_info_deflect_IN_ARG_number =
{
  {
    -1,
    (gchar *) "number",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_method_info_deflect_IN_ARG_pointers[] =
{
  &_gdbo_voice_call_method_info_deflect_IN_ARG_number.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_method_info_deflect =
{
  {
    -1,
    (gchar *) "Deflect",
    (GDBusArgInfo **) &_gdbo_voice_call_method_info_deflect_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-deflect",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_method_info_hangup =
{
  {
    -1,
    (gchar *) "Hangup",
    NULL,
    NULL,
    NULL
  },
  "handle-hangup",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_method_info_answer =
{
  {
    -1,
    (gchar *) "Answer",
    NULL,
    NULL,
    NULL
  },
  "handle-answer",
  FALSE
};

static const GDBusMethodInfo * const _gdbo_voice_call_method_info_pointers[] =
{
  &_gdbo_voice_call_method_info_get_properties.parent_struct,
  &_gdbo_voice_call_method_info_deflect.parent_struct,
  &_gdbo_voice_call_method_info_hangup.parent_struct,
  &_gdbo_voice_call_method_info_answer.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_signal_info_property_changed_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_signal_info_property_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_signal_info_property_changed_ARG_pointers[] =
{
  &_gdbo_voice_call_signal_info_property_changed_ARG_name.parent_struct,
  &_gdbo_voice_call_signal_info_property_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_voice_call_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_gdbo_voice_call_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_signal_info_disconnect_reason_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_signal_info_disconnect_reason_ARG_pointers[] =
{
  &_gdbo_voice_call_signal_info_disconnect_reason_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_voice_call_signal_info_disconnect_reason =
{
  {
    -1,
    (gchar *) "DisconnectReason",
    (GDBusArgInfo **) &_gdbo_voice_call_signal_info_disconnect_reason_ARG_pointers,
    NULL
  },
  "disconnect-reason"
};

static const GDBusSignalInfo * const _gdbo_voice_call_signal_info_pointers[] =
{
  &_gdbo_voice_call_signal_info_property_changed.parent_struct,
  &_gdbo_voice_call_signal_info_disconnect_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdbo_voice_call_interface_info =
{
  {
    -1,
    (gchar *) "org.ofono.VoiceCall",
    (GDBusMethodInfo **) &_gdbo_voice_call_method_info_pointers,
    (GDBusSignalInfo **) &_gdbo_voice_call_signal_info_pointers,
    NULL,
    NULL
  },
  "voice-call",
};


/**
 * gdbo_voice_call_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ofono-VoiceCall.top_of_page">org.ofono.VoiceCall</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdbo_voice_call_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdbo_voice_call_interface_info.parent_struct;
}

/**
 * gdbo_voice_call_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GDBOVoiceCall interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdbo_voice_call_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdbo_voice_call_signal_marshal_property_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_signal_marshal_disconnect_reason (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_method_marshal_get_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_method_marshal_deflect (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_method_marshal_hangup (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_method_marshal_answer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GDBOVoiceCall:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCall.top_of_page">org.ofono.VoiceCall</link>.
 */

/**
 * GDBOVoiceCallIface:
 * @parent_iface: The parent interface.
 * @handle_answer: Handler for the #GDBOVoiceCall::handle-answer signal.
 * @handle_deflect: Handler for the #GDBOVoiceCall::handle-deflect signal.
 * @handle_get_properties: Handler for the #GDBOVoiceCall::handle-get-properties signal.
 * @handle_hangup: Handler for the #GDBOVoiceCall::handle-hangup signal.
 * @disconnect_reason: Handler for the #GDBOVoiceCall::disconnect-reason signal.
 * @property_changed: Handler for the #GDBOVoiceCall::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCall.top_of_page">org.ofono.VoiceCall</link>.
 */

typedef GDBOVoiceCallIface GDBOVoiceCallInterface;
G_DEFINE_INTERFACE (GDBOVoiceCall, gdbo_voice_call, G_TYPE_OBJECT)

static void
gdbo_voice_call_default_init (GDBOVoiceCallIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GDBOVoiceCall::handle-get-properties:
   * @object: A #GDBOVoiceCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCall.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_method_marshal_get_properties,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCall::handle-deflect:
   * @object: A #GDBOVoiceCall.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_number: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCall.Deflect">Deflect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_complete_deflect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-deflect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallIface, handle_deflect),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_method_marshal_deflect,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GDBOVoiceCall::handle-hangup:
   * @object: A #GDBOVoiceCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCall.Hangup">Hangup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_complete_hangup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hangup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallIface, handle_hangup),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_method_marshal_hangup,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCall::handle-answer:
   * @object: A #GDBOVoiceCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCall.Answer">Answer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_complete_answer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-answer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallIface, handle_answer),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_method_marshal_answer,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GDBOVoiceCall::property-changed:
   * @object: A #GDBOVoiceCall.
   * @arg_name: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-VoiceCall.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__VOICE_CALL_SIGNALS[GDBO__VOICE_CALL_PROPERTY_CHANGED] =
    g_signal_new ("property-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOVoiceCallIface, property_changed),
      NULL,
      NULL,
      gdbo_voice_call_signal_marshal_property_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GDBOVoiceCall::disconnect-reason:
   * @object: A #GDBOVoiceCall.
   * @arg_reason: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-VoiceCall.DisconnectReason">"DisconnectReason"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__VOICE_CALL_SIGNALS[GDBO__VOICE_CALL_DISCONNECT_REASON] =
    g_signal_new ("disconnect-reason",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOVoiceCallIface, disconnect_reason),
      NULL,
      NULL,
      gdbo_voice_call_signal_marshal_disconnect_reason,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * gdbo_voice_call_emit_property_changed:
 * @object: A #GDBOVoiceCall.
 * @arg_name: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-VoiceCall.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
gdbo_voice_call_emit_property_changed (
    GDBOVoiceCall *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  g_signal_emit (object, GDBO__VOICE_CALL_SIGNALS[GDBO__VOICE_CALL_PROPERTY_CHANGED], 0, arg_name, arg_value);
}

/**
 * gdbo_voice_call_emit_disconnect_reason:
 * @object: A #GDBOVoiceCall.
 * @arg_reason: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-VoiceCall.DisconnectReason">"DisconnectReason"</link> D-Bus signal.
 */
void
gdbo_voice_call_emit_disconnect_reason (
    GDBOVoiceCall *object,
    const gchar *arg_reason)
{
  g_signal_emit (object, GDBO__VOICE_CALL_SIGNALS[GDBO__VOICE_CALL_DISCONNECT_REASON], 0, arg_reason);
}

/**
 * gdbo_voice_call_call_get_properties:
 * @proxy: A #GDBOVoiceCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_call_get_properties_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_call_get_properties (
    GDBOVoiceCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_call_get_properties_finish:
 * @proxy: A #GDBOVoiceCallProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_get_properties_finish (
    GDBOVoiceCall *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_call_get_properties_sync:
 * @proxy: A #GDBOVoiceCallProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_get_properties_sync (
    GDBOVoiceCall *proxy,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_call_deflect:
 * @proxy: A #GDBOVoiceCallProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.Deflect">Deflect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_call_deflect_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_call_deflect_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_call_deflect (
    GDBOVoiceCall *proxy,
    const gchar *arg_number,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Deflect",
    g_variant_new ("(s)",
                   arg_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_call_deflect_finish:
 * @proxy: A #GDBOVoiceCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_call_deflect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_call_deflect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_deflect_finish (
    GDBOVoiceCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_call_deflect_sync:
 * @proxy: A #GDBOVoiceCallProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.Deflect">Deflect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_call_deflect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_deflect_sync (
    GDBOVoiceCall *proxy,
    const gchar *arg_number,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Deflect",
    g_variant_new ("(s)",
                   arg_number),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_call_hangup:
 * @proxy: A #GDBOVoiceCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.Hangup">Hangup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_call_hangup_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_call_hangup_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_call_hangup (
    GDBOVoiceCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Hangup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_call_hangup_finish:
 * @proxy: A #GDBOVoiceCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_call_hangup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_call_hangup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_hangup_finish (
    GDBOVoiceCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_call_hangup_sync:
 * @proxy: A #GDBOVoiceCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.Hangup">Hangup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_call_hangup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_hangup_sync (
    GDBOVoiceCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Hangup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_call_answer:
 * @proxy: A #GDBOVoiceCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.Answer">Answer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_call_answer_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_call_answer_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_call_answer (
    GDBOVoiceCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Answer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_call_answer_finish:
 * @proxy: A #GDBOVoiceCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_call_answer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_call_answer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_answer_finish (
    GDBOVoiceCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_call_answer_sync:
 * @proxy: A #GDBOVoiceCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCall.Answer">Answer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_call_answer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_call_answer_sync (
    GDBOVoiceCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Answer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_complete_get_properties:
 * @object: A #GDBOVoiceCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCall.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_complete_get_properties (
    GDBOVoiceCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/**
 * gdbo_voice_call_complete_deflect:
 * @object: A #GDBOVoiceCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCall.Deflect">Deflect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_complete_deflect (
    GDBOVoiceCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_complete_hangup:
 * @object: A #GDBOVoiceCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCall.Hangup">Hangup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_complete_hangup (
    GDBOVoiceCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_complete_answer:
 * @object: A #GDBOVoiceCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCall.Answer">Answer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_complete_answer (
    GDBOVoiceCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GDBOVoiceCallProxy:
 *
 * The #GDBOVoiceCallProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GDBOVoiceCallProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBOVoiceCallProxy.
 */

struct _GDBOVoiceCallProxyPrivate
{
  GData *qdata;
};

static void gdbo_voice_call_proxy_iface_init (GDBOVoiceCallIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallProxy, gdbo_voice_call_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GDBOVoiceCallProxy)
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL, gdbo_voice_call_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallProxy, gdbo_voice_call_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL, gdbo_voice_call_proxy_iface_init))

#endif
static void
gdbo_voice_call_proxy_finalize (GObject *object)
{
  GDBOVoiceCallProxy *proxy = GDBO_VOICE_CALL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdbo_voice_call_proxy_parent_class)->finalize (object);
}

static void
gdbo_voice_call_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdbo_voice_call_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdbo_voice_call_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdbo_voice_call_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDBO_TYPE_VOICE_CALL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDBO_TYPE_VOICE_CALL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdbo_voice_call_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GDBOVoiceCallProxy *proxy = GDBO_VOICE_CALL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdbo_voice_call_proxy_init (GDBOVoiceCallProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdbo_voice_call_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDBO_TYPE_VOICE_CALL_PROXY, GDBOVoiceCallProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdbo_voice_call_interface_info ());
}

static void
gdbo_voice_call_proxy_class_init (GDBOVoiceCallProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdbo_voice_call_proxy_finalize;
  gobject_class->get_property = gdbo_voice_call_proxy_get_property;
  gobject_class->set_property = gdbo_voice_call_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdbo_voice_call_proxy_g_signal;
  proxy_class->g_properties_changed = gdbo_voice_call_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GDBOVoiceCallProxyPrivate));
#endif
}

static void
gdbo_voice_call_proxy_iface_init (GDBOVoiceCallIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdbo_voice_call_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCall.top_of_page">org.ofono.VoiceCall</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_proxy_new_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdbo_voice_call_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDBO_TYPE_VOICE_CALL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCall", NULL);
}

/**
 * gdbo_voice_call_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdbo_voice_call_proxy_new().
 *
 * Returns: (transfer full) (type GDBOVoiceCallProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCall *
gdbo_voice_call_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDBO_VOICE_CALL (ret);
  else
    return NULL;
}

/**
 * gdbo_voice_call_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCall.top_of_page">org.ofono.VoiceCall</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GDBOVoiceCallProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCall *
gdbo_voice_call_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDBO_TYPE_VOICE_CALL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCall", NULL);
  if (ret != NULL)
    return GDBO_VOICE_CALL (ret);
  else
    return NULL;
}


/**
 * gdbo_voice_call_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdbo_voice_call_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdbo_voice_call_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDBO_TYPE_VOICE_CALL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCall", NULL);
}

/**
 * gdbo_voice_call_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdbo_voice_call_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GDBOVoiceCallProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCall *
gdbo_voice_call_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDBO_VOICE_CALL (ret);
  else
    return NULL;
}

/**
 * gdbo_voice_call_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdbo_voice_call_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GDBOVoiceCallProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCall *
gdbo_voice_call_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDBO_TYPE_VOICE_CALL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCall", NULL);
  if (ret != NULL)
    return GDBO_VOICE_CALL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GDBOVoiceCallSkeleton:
 *
 * The #GDBOVoiceCallSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GDBOVoiceCallSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBOVoiceCallSkeleton.
 */

struct _GDBOVoiceCallSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdbo_voice_call_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GDBOVoiceCallSkeleton *skeleton = GDBO_VOICE_CALL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDBO_TYPE_VOICE_CALL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDBO_TYPE_VOICE_CALL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdbo_voice_call_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GDBOVoiceCallSkeleton *skeleton = GDBO_VOICE_CALL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdbo_voice_call_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GDBOVoiceCallSkeleton *skeleton = GDBO_VOICE_CALL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdbo_voice_call_skeleton_vtable =
{
  _gdbo_voice_call_skeleton_handle_method_call,
  _gdbo_voice_call_skeleton_handle_get_property,
  _gdbo_voice_call_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdbo_voice_call_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdbo_voice_call_interface_info ();
}

static GDBusInterfaceVTable *
gdbo_voice_call_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdbo_voice_call_skeleton_vtable;
}

static GVariant *
gdbo_voice_call_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GDBOVoiceCallSkeleton *skeleton = GDBO_VOICE_CALL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdbo_voice_call_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdbo_voice_call_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdbo_voice_call_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdbo_voice_call_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCall", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdbo_voice_call_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdbo_voice_call_on_signal_property_changed (
    GDBOVoiceCall *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  GDBOVoiceCallSkeleton *skeleton = GDBO_VOICE_CALL_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_name,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCall", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdbo_voice_call_on_signal_disconnect_reason (
    GDBOVoiceCall *object,
    const gchar *arg_reason)
{
  GDBOVoiceCallSkeleton *skeleton = GDBO_VOICE_CALL_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_reason));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCall", "DisconnectReason",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdbo_voice_call_skeleton_iface_init (GDBOVoiceCallIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallSkeleton, gdbo_voice_call_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GDBOVoiceCallSkeleton)
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL, gdbo_voice_call_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallSkeleton, gdbo_voice_call_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL, gdbo_voice_call_skeleton_iface_init))

#endif
static void
gdbo_voice_call_skeleton_finalize (GObject *object)
{
  GDBOVoiceCallSkeleton *skeleton = GDBO_VOICE_CALL_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdbo_voice_call_skeleton_parent_class)->finalize (object);
}

static void
gdbo_voice_call_skeleton_init (GDBOVoiceCallSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdbo_voice_call_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDBO_TYPE_VOICE_CALL_SKELETON, GDBOVoiceCallSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdbo_voice_call_skeleton_class_init (GDBOVoiceCallSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdbo_voice_call_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdbo_voice_call_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdbo_voice_call_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdbo_voice_call_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdbo_voice_call_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GDBOVoiceCallSkeletonPrivate));
#endif
}

static void
gdbo_voice_call_skeleton_iface_init (GDBOVoiceCallIface *iface)
{
  iface->property_changed = _gdbo_voice_call_on_signal_property_changed;
  iface->disconnect_reason = _gdbo_voice_call_on_signal_disconnect_reason;
}

/**
 * gdbo_voice_call_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCall.top_of_page">org.ofono.VoiceCall</link>.
 *
 * Returns: (transfer full) (type GDBOVoiceCallSkeleton): The skeleton object.
 */
GDBOVoiceCall *
gdbo_voice_call_skeleton_new (void)
{
  return GDBO_VOICE_CALL (g_object_new (GDBO_TYPE_VOICE_CALL_SKELETON, NULL));
}

