/* contacts-io-vcard-export-operation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-io-vcard-export-operation.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <libebook-contacts/libebook-contacts.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>
#include <folks/folks.h>
#include <glib/gi18n-lib.h>
#include <folks/folks-eds.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_IO_VCARD_EXPORT_OPERATION_0_PROPERTY,
	CONTACTS_IO_VCARD_EXPORT_OPERATION_DESCRIPTION_PROPERTY,
	CONTACTS_IO_VCARD_EXPORT_OPERATION_NUM_PROPERTIES
};
static GParamSpec* contacts_io_vcard_export_operation_properties[CONTACTS_IO_VCARD_EXPORT_OPERATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsIoVcardExportOperationExecuteData ContactsIoVcardExportOperationExecuteData;
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
#define __vala_EVCardAttributeParam_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttributeParam_free (var), NULL)))

struct _ContactsIoVCardExportOperationPrivate {
	EVCardFormat vcard_format;
	gboolean avoid_eds;
	gchar* _description;
};

struct _ContactsIoVcardExportOperationExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsIoVCardExportOperation* self;
	GeeList* _individual_list;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _individual_size;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _individual_index;
	gint _tmp5_;
	gint _tmp6_;
	FolksIndividual* individual;
	GeeList* _tmp7_;
	gpointer _tmp8_;
	GeeIterator* _persona_it;
	FolksIndividual* _tmp9_;
	GeeSet* _tmp10_;
	GeeSet* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	FolksPersona* persona;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	gchar* vcard_str;
	FolksPersona* _tmp16_;
	gchar* _tmp17_;
	gsize written;
	GOutputStream* _tmp18_;
	GOutputStream* _tmp19_;
	const gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gint _tmp22_;
	guint8* _tmp23_;
	gint _tmp23__length1;
	gsize _tmp24_;
	GOutputStream* _tmp25_;
	GOutputStream* _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	gint _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gsize _tmp30_;
	GError* _inner_error0_;
};

static gint ContactsIoVCardExportOperation_private_offset;
static gpointer contacts_io_vcard_export_operation_parent_class = NULL;

static void contacts_io_vcard_export_operation_real_execute_data_free (gpointer _data);
static void contacts_io_vcard_export_operation_real_execute (ContactsOperation* base,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean contacts_io_vcard_export_operation_real_execute_co (ContactsIoVcardExportOperationExecuteData* _data_);
static gchar* contacts_io_vcard_export_operation_persona_to_vcard (ContactsIoVCardExportOperation* self,
                                                            FolksPersona* persona);
static void contacts_io_vcard_export_operation_vcard_set_avatar_details (ContactsIoVCardExportOperation* self,
                                                                  EVCard* vcard,
                                                                  FolksAvatarDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_birthday_details (ContactsIoVCardExportOperation* self,
                                                                    EVCard* vcard,
                                                                    FolksBirthdayDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_email_details (ContactsIoVCardExportOperation* self,
                                                                 EVCard* vcard,
                                                                 FolksEmailDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_favourite_details (ContactsIoVCardExportOperation* self,
                                                                     EVCard* vcard,
                                                                     FolksFavouriteDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_name_details (ContactsIoVCardExportOperation* self,
                                                                EVCard* vcard,
                                                                FolksNameDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_note_details (ContactsIoVCardExportOperation* self,
                                                                EVCard* vcard,
                                                                FolksNoteDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_phone_details (ContactsIoVCardExportOperation* self,
                                                                 EVCard* vcard,
                                                                 FolksPhoneDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_postal_address_details (ContactsIoVCardExportOperation* self,
                                                                          EVCard* vcard,
                                                                          FolksPostalAddressDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_role_details (ContactsIoVCardExportOperation* self,
                                                                EVCard* vcard,
                                                                FolksRoleDetails* details);
static void contacts_io_vcard_export_operation_vcard_set_url_details (ContactsIoVCardExportOperation* self,
                                                               EVCard* vcard,
                                                               FolksUrlDetails* details);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void contacts_io_vcard_export_operation_add_parameters_for_field_details (ContactsIoVCardExportOperation* self,
                                                                          EVCardAttribute* attr,
                                                                          FolksAbstractFieldDetails* field);
static void _vala_EVCardAttributeParam_free (EVCardAttributeParam* self);
static void contacts_io_vcard_export_operation_finalize (GObject * obj);
static GType contacts_io_vcard_export_operation_get_type_once (void);
static void _vala_contacts_io_vcard_export_operation_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
contacts_io_vcard_export_operation_get_instance_private (ContactsIoVCardExportOperation* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsIoVCardExportOperation_private_offset);
}

ContactsIoVCardExportOperation*
contacts_io_vcard_export_operation_construct (GType object_type,
                                              GeeList* individuals,
                                              GOutputStream* output)
{
	ContactsIoVCardExportOperation * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (individuals != NULL, NULL);
	g_return_val_if_fail (output != NULL, NULL);
	self = (ContactsIoVCardExportOperation*) g_object_new (object_type, "individuals", individuals, "output", output, NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) individuals);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) individuals);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (ngettext ("Exported %d contact", "Exported %d contacts", (gulong) _tmp1_), _tmp3_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp4_;
	return self;
}

ContactsIoVCardExportOperation*
contacts_io_vcard_export_operation_new (GeeList* individuals,
                                        GOutputStream* output)
{
	return contacts_io_vcard_export_operation_construct (CONTACTS_IO_TYPE_VCARD_EXPORT_OPERATION, individuals, output);
}

static void
contacts_io_vcard_export_operation_real_execute_data_free (gpointer _data)
{
	ContactsIoVcardExportOperationExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsIoVcardExportOperationExecuteData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_io_vcard_export_operation_real_execute (ContactsOperation* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	ContactsIoVCardExportOperation * self;
	ContactsIoVcardExportOperationExecuteData* _data_;
	ContactsIoVCardExportOperation* _tmp0_;
	self = (ContactsIoVCardExportOperation*) base;
	_data_ = g_slice_new0 (ContactsIoVcardExportOperationExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_io_vcard_export_operation_real_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_io_vcard_export_operation_real_execute_co (_data_);
}

static void
contacts_io_vcard_export_operation_execute_finish (ContactsOperation* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	ContactsIoVcardExportOperationExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
contacts_io_vcard_export_operation_real_execute_co (ContactsIoVcardExportOperationExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = contacts_io_export_operation_get_individuals ((ContactsIoExportOperation*) _data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_individual_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_individual_list;
		_data_->_tmp3_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_individual_size = _data_->_tmp4_;
		_data_->_individual_index = -1;
		while (TRUE) {
			_data_->_individual_index = _data_->_individual_index + 1;
			_data_->_tmp5_ = _data_->_individual_index;
			_data_->_tmp6_ = _data_->_individual_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_individual_list;
			_data_->_tmp8_ = gee_list_get (_data_->_tmp7_, _data_->_individual_index);
			_data_->individual = (FolksIndividual*) _data_->_tmp8_;
			{
				_data_->_tmp9_ = _data_->individual;
				_data_->_tmp10_ = folks_individual_get_personas (_data_->_tmp9_);
				_data_->_tmp11_ = _data_->_tmp10_;
				_data_->_tmp12_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp11_);
				_data_->_persona_it = _data_->_tmp12_;
				while (TRUE) {
					_data_->_tmp13_ = _data_->_persona_it;
					if (!gee_iterator_next (_data_->_tmp13_)) {
						break;
					}
					_data_->_tmp14_ = _data_->_persona_it;
					_data_->_tmp15_ = gee_iterator_get (_data_->_tmp14_);
					_data_->persona = (FolksPersona*) _data_->_tmp15_;
					_data_->_tmp16_ = _data_->persona;
					_data_->_tmp17_ = contacts_io_vcard_export_operation_persona_to_vcard (_data_->self, _data_->_tmp16_);
					_data_->vcard_str = _data_->_tmp17_;
					_data_->_tmp18_ = contacts_io_export_operation_get_output ((ContactsIoExportOperation*) _data_->self);
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp20_ = _data_->vcard_str;
					_data_->_tmp22_ = 0;
					_data_->_tmp21_ = string_get_data (_data_->_tmp20_, &_data_->_tmp22_);
					_data_->_tmp21__length1 = _data_->_tmp22_;
					_data_->_tmp23_ = _data_->_tmp21_;
					_data_->_tmp23__length1 = _data_->_tmp21__length1;
					_data_->_tmp24_ = 0UL;
					g_output_stream_write_all (_data_->_tmp19_, _data_->_tmp23_, (gsize) _data_->_tmp23__length1, &_data_->_tmp24_, NULL, &_data_->_inner_error0_);
					_data_->written = _data_->_tmp24_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_free0 (_data_->vcard_str);
						_g_object_unref0 (_data_->persona);
						_g_object_unref0 (_data_->_persona_it);
						_g_object_unref0 (_data_->individual);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp25_ = contacts_io_export_operation_get_output ((ContactsIoExportOperation*) _data_->self);
					_data_->_tmp26_ = _data_->_tmp25_;
					_data_->_tmp28_ = 0;
					_data_->_tmp27_ = string_get_data ("\r\n\r\n", &_data_->_tmp28_);
					_data_->_tmp27__length1 = _data_->_tmp28_;
					_data_->_tmp29_ = _data_->_tmp27_;
					_data_->_tmp29__length1 = _data_->_tmp27__length1;
					_data_->_tmp30_ = 0UL;
					g_output_stream_write_all (_data_->_tmp26_, _data_->_tmp29_, (gsize) _data_->_tmp29__length1, &_data_->_tmp30_, NULL, &_data_->_inner_error0_);
					_data_->written = _data_->_tmp30_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_free0 (_data_->vcard_str);
						_g_object_unref0 (_data_->persona);
						_g_object_unref0 (_data_->_persona_it);
						_g_object_unref0 (_data_->individual);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_g_free0 (_data_->vcard_str);
					_g_object_unref0 (_data_->persona);
				}
				_g_object_unref0 (_data_->_persona_it);
			}
			_g_object_unref0 (_data_->individual);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
contacts_io_vcard_export_operation_persona_to_vcard (ContactsIoVCardExportOperation* self,
                                                     FolksPersona* persona)
{
	gboolean _tmp0_ = FALSE;
	EVCard* vcard = NULL;
	EVCard* _tmp5_;
	EVCard* _tmp16_;
	gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, EDSF_TYPE_PERSONA)) {
		_tmp0_ = !self->priv->avoid_eds;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		EContact* contact = NULL;
		EContact* _tmp1_;
		EContact* _tmp2_;
		EContact* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = edsf_persona_get_contact (G_TYPE_CHECK_INSTANCE_CAST (persona, EDSF_TYPE_PERSONA, EdsfPersona));
		_tmp2_ = _tmp1_;
		contact = _tmp2_;
		_tmp3_ = contact;
		_tmp4_ = e_vcard_to_string ((EVCard*) _tmp3_, self->priv->vcard_format);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = e_vcard_new ();
	vcard = _tmp5_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_AVATAR_DETAILS)) {
		EVCard* _tmp6_;
		_tmp6_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_avatar_details (self, _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_AVATAR_DETAILS, FolksAvatarDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_BIRTHDAY_DETAILS)) {
		EVCard* _tmp7_;
		_tmp7_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_birthday_details (self, _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_BIRTHDAY_DETAILS, FolksBirthdayDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_EMAIL_DETAILS)) {
		EVCard* _tmp8_;
		_tmp8_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_email_details (self, _tmp8_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_FAVOURITE_DETAILS)) {
		EVCard* _tmp9_;
		_tmp9_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_favourite_details (self, _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_NAME_DETAILS)) {
		EVCard* _tmp10_;
		_tmp10_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_name_details (self, _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_NAME_DETAILS, FolksNameDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_NOTE_DETAILS)) {
		EVCard* _tmp11_;
		_tmp11_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_note_details (self, _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_NOTE_DETAILS, FolksNoteDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_PHONE_DETAILS)) {
		EVCard* _tmp12_;
		_tmp12_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_phone_details (self, _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS)) {
		EVCard* _tmp13_;
		_tmp13_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_postal_address_details (self, _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_ROLE_DETAILS)) {
		EVCard* _tmp14_;
		_tmp14_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_role_details (self, _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetails));
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_URL_DETAILS)) {
		EVCard* _tmp15_;
		_tmp15_ = vcard;
		contacts_io_vcard_export_operation_vcard_set_url_details (self, _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (persona, FOLKS_TYPE_URL_DETAILS, FolksUrlDetails));
	}
	_tmp16_ = vcard;
	_tmp17_ = e_vcard_to_string (_tmp16_, self->priv->vcard_format);
	result = _tmp17_;
	_g_object_unref0 (vcard);
	return result;
}

static void
contacts_io_vcard_export_operation_vcard_set_avatar_details (ContactsIoVCardExportOperation* self,
                                                             EVCard* vcard,
                                                             FolksAvatarDetails* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
}

static void
_vala_EVCardAttribute_free (EVCardAttribute* self)
{
	g_boxed_free (e_vcard_attribute_get_type (), self);
}

static void
contacts_io_vcard_export_operation_vcard_set_birthday_details (ContactsIoVCardExportOperation* self,
                                                               EVCard* vcard,
                                                               FolksBirthdayDetails* details)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	EVCardAttribute* attr = NULL;
	EVCardAttribute* _tmp2_;
	EVCardAttribute* _tmp3_;
	EVCardAttributeParam* _tmp4_;
	EVCardAttribute* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = folks_birthday_details_get_birthday (details);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = e_vcard_attribute_new (NULL, EVC_BDAY);
	attr = _tmp2_;
	_tmp3_ = attr;
	_tmp4_ = e_vcard_attribute_param_new (EVC_VALUE);
	e_vcard_attribute_add_param_with_value (_tmp3_, _tmp4_, "DATE");
	_tmp5_ = attr;
	attr = NULL;
	_tmp6_ = folks_birthday_details_get_birthday (details);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_format (_tmp7_, "%F");
	_tmp9_ = _tmp8_;
	e_vcard_add_attribute_with_value (vcard, _tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	__vala_EVCardAttribute_free0 (attr);
}

static EVCardAttribute*
_vala_EVCardAttribute_copy (EVCardAttribute* self)
{
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}

static gpointer
__vala_EVCardAttribute_copy0 (gpointer self)
{
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}

static void
contacts_io_vcard_export_operation_vcard_set_email_details (ContactsIoVCardExportOperation* self,
                                                            EVCard* vcard,
                                                            FolksEmailDetails* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	{
		GeeIterator* _email_field_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_email_details_get_email_addresses (details);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_email_field_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksEmailFieldDetails* email_field = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksEmailFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			gconstpointer _tmp8_;
			EVCardAttribute* attr = NULL;
			EVCardAttribute* _tmp9_;
			EVCardAttribute* _tmp10_;
			EVCardAttribute* _tmp11_;
			FolksEmailFieldDetails* _tmp12_;
			gconstpointer _tmp13_;
			gconstpointer _tmp14_;
			EVCardAttribute* _tmp15_;
			FolksEmailFieldDetails* _tmp16_;
			_tmp3_ = _email_field_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _email_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			email_field = (FolksEmailFieldDetails*) _tmp5_;
			_tmp6_ = email_field;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (g_strcmp0 ((const gchar*) _tmp8_, "") == 0) {
				_g_object_unref0 (email_field);
				continue;
			}
			_tmp9_ = e_vcard_attribute_new (NULL, EVC_EMAIL);
			attr = _tmp9_;
			_tmp10_ = attr;
			_tmp11_ = __vala_EVCardAttribute_copy0 (_tmp10_);
			_tmp12_ = email_field;
			_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			e_vcard_add_attribute_with_value (vcard, _tmp11_, (const gchar*) _tmp14_);
			_tmp15_ = attr;
			_tmp16_ = email_field;
			contacts_io_vcard_export_operation_add_parameters_for_field_details (self, _tmp15_, (FolksAbstractFieldDetails*) _tmp16_);
			__vala_EVCardAttribute_free0 (attr);
			_g_object_unref0 (email_field);
		}
		_g_object_unref0 (_email_field_it);
	}
}

static void
contacts_io_vcard_export_operation_vcard_set_favourite_details (ContactsIoVCardExportOperation* self,
                                                                EVCard* vcard,
                                                                FolksFavouriteDetails* details)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = folks_favourite_details_get_is_favourite (details);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		EVCardAttribute* attr = NULL;
		EVCardAttribute* _tmp2_;
		EVCardAttribute* _tmp3_;
		_tmp2_ = e_vcard_attribute_new (NULL, "X-FOLKS-FAVOURITE");
		attr = _tmp2_;
		_tmp3_ = attr;
		attr = NULL;
		e_vcard_add_attribute_with_value (vcard, _tmp3_, "true");
		__vala_EVCardAttribute_free0 (attr);
	}
}

static void
contacts_io_vcard_export_operation_vcard_set_name_details (ContactsIoVCardExportOperation* self,
                                                           EVCard* vcard,
                                                           FolksNameDetails* details)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FolksStructuredName* _tmp5_;
	FolksStructuredName* _tmp6_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = folks_name_details_get_full_name (details);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		EVCardAttribute* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = e_vcard_attribute_new (NULL, EVC_FN);
		_tmp3_ = folks_name_details_get_full_name (details);
		_tmp4_ = _tmp3_;
		e_vcard_add_attribute_with_value (vcard, _tmp2_, _tmp4_);
	}
	_tmp5_ = folks_name_details_get_structured_name (details);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		EVCardAttribute* attr = NULL;
		EVCardAttribute* _tmp7_;
		EVCardAttribute* _tmp8_;
		FolksStructuredName* _tmp9_;
		FolksStructuredName* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		EVCardAttribute* _tmp13_;
		FolksStructuredName* _tmp14_;
		FolksStructuredName* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		EVCardAttribute* _tmp18_;
		FolksStructuredName* _tmp19_;
		FolksStructuredName* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		EVCardAttribute* _tmp23_;
		FolksStructuredName* _tmp24_;
		FolksStructuredName* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		EVCardAttribute* _tmp28_;
		FolksStructuredName* _tmp29_;
		FolksStructuredName* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		EVCardAttribute* _tmp33_;
		_tmp7_ = e_vcard_attribute_new (NULL, EVC_N);
		attr = _tmp7_;
		_tmp8_ = attr;
		_tmp9_ = folks_name_details_get_structured_name (details);
		_tmp10_ = _tmp9_;
		_tmp11_ = folks_structured_name_get_family_name (_tmp10_);
		_tmp12_ = _tmp11_;
		e_vcard_attribute_add_value (_tmp8_, _tmp12_);
		_tmp13_ = attr;
		_tmp14_ = folks_name_details_get_structured_name (details);
		_tmp15_ = _tmp14_;
		_tmp16_ = folks_structured_name_get_given_name (_tmp15_);
		_tmp17_ = _tmp16_;
		e_vcard_attribute_add_value (_tmp13_, _tmp17_);
		_tmp18_ = attr;
		_tmp19_ = folks_name_details_get_structured_name (details);
		_tmp20_ = _tmp19_;
		_tmp21_ = folks_structured_name_get_additional_names (_tmp20_);
		_tmp22_ = _tmp21_;
		e_vcard_attribute_add_value (_tmp18_, _tmp22_);
		_tmp23_ = attr;
		_tmp24_ = folks_name_details_get_structured_name (details);
		_tmp25_ = _tmp24_;
		_tmp26_ = folks_structured_name_get_prefixes (_tmp25_);
		_tmp27_ = _tmp26_;
		e_vcard_attribute_add_value (_tmp23_, _tmp27_);
		_tmp28_ = attr;
		_tmp29_ = folks_name_details_get_structured_name (details);
		_tmp30_ = _tmp29_;
		_tmp31_ = folks_structured_name_get_suffixes (_tmp30_);
		_tmp32_ = _tmp31_;
		e_vcard_attribute_add_value (_tmp28_, _tmp32_);
		_tmp33_ = attr;
		attr = NULL;
		e_vcard_add_attribute (vcard, _tmp33_);
		__vala_EVCardAttribute_free0 (attr);
	}
	_tmp34_ = folks_name_details_get_nickname (details);
	_tmp35_ = _tmp34_;
	if (g_strcmp0 (_tmp35_, "") != 0) {
		EVCardAttribute* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp36_ = e_vcard_attribute_new (NULL, EVC_NICKNAME);
		_tmp37_ = folks_name_details_get_nickname (details);
		_tmp38_ = _tmp37_;
		e_vcard_add_attribute_with_value (vcard, _tmp36_, _tmp38_);
	}
}

static void
contacts_io_vcard_export_operation_vcard_set_note_details (ContactsIoVCardExportOperation* self,
                                                           EVCard* vcard,
                                                           FolksNoteDetails* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	{
		GeeIterator* _note_field_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_note_details_get_notes (details);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_note_field_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksNoteFieldDetails* note_field = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksNoteFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			gconstpointer _tmp8_;
			EVCardAttribute* attr = NULL;
			EVCardAttribute* _tmp9_;
			EVCardAttribute* _tmp10_;
			FolksNoteFieldDetails* _tmp11_;
			EVCardAttribute* _tmp12_;
			FolksNoteFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			_tmp3_ = _note_field_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _note_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			note_field = (FolksNoteFieldDetails*) _tmp5_;
			_tmp6_ = note_field;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (g_strcmp0 ((const gchar*) _tmp8_, "") == 0) {
				_g_object_unref0 (note_field);
				continue;
			}
			_tmp9_ = e_vcard_attribute_new (NULL, EVC_NOTE);
			attr = _tmp9_;
			_tmp10_ = attr;
			_tmp11_ = note_field;
			contacts_io_vcard_export_operation_add_parameters_for_field_details (self, _tmp10_, (FolksAbstractFieldDetails*) _tmp11_);
			_tmp12_ = attr;
			attr = NULL;
			_tmp13_ = note_field;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			e_vcard_add_attribute_with_value (vcard, _tmp12_, (const gchar*) _tmp15_);
			__vala_EVCardAttribute_free0 (attr);
			_g_object_unref0 (note_field);
		}
		_g_object_unref0 (_note_field_it);
	}
}

static void
contacts_io_vcard_export_operation_vcard_set_phone_details (ContactsIoVCardExportOperation* self,
                                                            EVCard* vcard,
                                                            FolksPhoneDetails* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	{
		GeeIterator* _phone_field_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_phone_details_get_phone_numbers (details);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_phone_field_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPhoneFieldDetails* phone_field = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPhoneFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			gconstpointer _tmp8_;
			EVCardAttribute* attr = NULL;
			EVCardAttribute* _tmp9_;
			EVCardAttribute* _tmp10_;
			FolksPhoneFieldDetails* _tmp11_;
			EVCardAttribute* _tmp12_;
			FolksPhoneFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			_tmp3_ = _phone_field_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _phone_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			phone_field = (FolksPhoneFieldDetails*) _tmp5_;
			_tmp6_ = phone_field;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (g_strcmp0 ((const gchar*) _tmp8_, "") == 0) {
				_g_object_unref0 (phone_field);
				continue;
			}
			_tmp9_ = e_vcard_attribute_new (NULL, EVC_TEL);
			attr = _tmp9_;
			_tmp10_ = attr;
			_tmp11_ = phone_field;
			contacts_io_vcard_export_operation_add_parameters_for_field_details (self, _tmp10_, (FolksAbstractFieldDetails*) _tmp11_);
			_tmp12_ = attr;
			attr = NULL;
			_tmp13_ = phone_field;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			e_vcard_add_attribute_with_value (vcard, _tmp12_, (const gchar*) _tmp15_);
			__vala_EVCardAttribute_free0 (attr);
			_g_object_unref0 (phone_field);
		}
		_g_object_unref0 (_phone_field_it);
	}
}

static void
contacts_io_vcard_export_operation_vcard_set_postal_address_details (ContactsIoVCardExportOperation* self,
                                                                     EVCard* vcard,
                                                                     FolksPostalAddressDetails* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	{
		GeeIterator* _postal_field_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_postal_address_details_get_postal_addresses (details);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_postal_field_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPostalAddressFieldDetails* postal_field = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPostalAddress* addr = NULL;
			FolksPostalAddressFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			gconstpointer _tmp8_;
			FolksPostalAddress* _tmp9_;
			EVCardAttribute* attr = NULL;
			EVCardAttribute* _tmp10_;
			EVCardAttribute* _tmp11_;
			FolksPostalAddressFieldDetails* _tmp12_;
			EVCardAttribute* _tmp13_;
			FolksPostalAddress* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			EVCardAttribute* _tmp17_;
			FolksPostalAddress* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			EVCardAttribute* _tmp21_;
			FolksPostalAddress* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			EVCardAttribute* _tmp25_;
			FolksPostalAddress* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			EVCardAttribute* _tmp29_;
			FolksPostalAddress* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			EVCardAttribute* _tmp33_;
			FolksPostalAddress* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			EVCardAttribute* _tmp37_;
			FolksPostalAddress* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			EVCardAttribute* _tmp41_;
			_tmp3_ = _postal_field_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _postal_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			postal_field = (FolksPostalAddressFieldDetails*) _tmp5_;
			_tmp6_ = postal_field;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			addr = (FolksPostalAddress*) _tmp8_;
			_tmp9_ = addr;
			if (folks_postal_address_is_empty (_tmp9_)) {
				_g_object_unref0 (postal_field);
				continue;
			}
			_tmp10_ = e_vcard_attribute_new (NULL, EVC_ADR);
			attr = _tmp10_;
			_tmp11_ = attr;
			_tmp12_ = postal_field;
			contacts_io_vcard_export_operation_add_parameters_for_field_details (self, _tmp11_, (FolksAbstractFieldDetails*) _tmp12_);
			_tmp13_ = attr;
			_tmp14_ = addr;
			_tmp15_ = folks_postal_address_get_po_box (_tmp14_);
			_tmp16_ = _tmp15_;
			e_vcard_attribute_add_value (_tmp13_, _tmp16_);
			_tmp17_ = attr;
			_tmp18_ = addr;
			_tmp19_ = folks_postal_address_get_extension (_tmp18_);
			_tmp20_ = _tmp19_;
			e_vcard_attribute_add_value (_tmp17_, _tmp20_);
			_tmp21_ = attr;
			_tmp22_ = addr;
			_tmp23_ = folks_postal_address_get_street (_tmp22_);
			_tmp24_ = _tmp23_;
			e_vcard_attribute_add_value (_tmp21_, _tmp24_);
			_tmp25_ = attr;
			_tmp26_ = addr;
			_tmp27_ = folks_postal_address_get_locality (_tmp26_);
			_tmp28_ = _tmp27_;
			e_vcard_attribute_add_value (_tmp25_, _tmp28_);
			_tmp29_ = attr;
			_tmp30_ = addr;
			_tmp31_ = folks_postal_address_get_region (_tmp30_);
			_tmp32_ = _tmp31_;
			e_vcard_attribute_add_value (_tmp29_, _tmp32_);
			_tmp33_ = attr;
			_tmp34_ = addr;
			_tmp35_ = folks_postal_address_get_postal_code (_tmp34_);
			_tmp36_ = _tmp35_;
			e_vcard_attribute_add_value (_tmp33_, _tmp36_);
			_tmp37_ = attr;
			_tmp38_ = addr;
			_tmp39_ = folks_postal_address_get_country (_tmp38_);
			_tmp40_ = _tmp39_;
			e_vcard_attribute_add_value (_tmp37_, _tmp40_);
			_tmp41_ = attr;
			attr = NULL;
			e_vcard_add_attribute (vcard, _tmp41_);
			__vala_EVCardAttribute_free0 (attr);
			_g_object_unref0 (postal_field);
		}
		_g_object_unref0 (_postal_field_it);
	}
}

static void
contacts_io_vcard_export_operation_vcard_set_role_details (ContactsIoVCardExportOperation* self,
                                                           EVCard* vcard,
                                                           FolksRoleDetails* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	{
		GeeIterator* _role_field_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_role_details_get_roles (details);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_role_field_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksRoleFieldDetails* role_field = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksRoleFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			gconstpointer _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			FolksRoleFieldDetails* _tmp17_;
			gconstpointer _tmp18_;
			gconstpointer _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp3_ = _role_field_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _role_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			role_field = (FolksRoleFieldDetails*) _tmp5_;
			_tmp6_ = role_field;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_role_get_title ((FolksRole*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, "") != 0) {
				EVCardAttribute* _tmp11_;
				FolksRoleFieldDetails* _tmp12_;
				gconstpointer _tmp13_;
				gconstpointer _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp11_ = e_vcard_attribute_new (NULL, EVC_TITLE);
				_tmp12_ = role_field;
				_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = folks_role_get_title ((FolksRole*) _tmp14_);
				_tmp16_ = _tmp15_;
				e_vcard_add_attribute_with_value (vcard, _tmp11_, _tmp16_);
			}
			_tmp17_ = role_field;
			_tmp18_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = folks_role_get_organisation_name ((FolksRole*) _tmp19_);
			_tmp21_ = _tmp20_;
			if (g_strcmp0 (_tmp21_, "") != 0) {
				EVCardAttribute* _tmp22_;
				FolksRoleFieldDetails* _tmp23_;
				gconstpointer _tmp24_;
				gconstpointer _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp22_ = e_vcard_attribute_new (NULL, EVC_ORG);
				_tmp23_ = role_field;
				_tmp24_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = folks_role_get_organisation_name ((FolksRole*) _tmp25_);
				_tmp27_ = _tmp26_;
				e_vcard_add_attribute_with_value (vcard, _tmp22_, _tmp27_);
			}
			_g_object_unref0 (role_field);
		}
		_g_object_unref0 (_role_field_it);
	}
}

static void
contacts_io_vcard_export_operation_vcard_set_url_details (ContactsIoVCardExportOperation* self,
                                                          EVCard* vcard,
                                                          FolksUrlDetails* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (vcard != NULL);
	g_return_if_fail (details != NULL);
	{
		GeeIterator* _url_field_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_url_details_get_urls (details);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_url_field_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksUrlFieldDetails* url_field = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksUrlFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			gconstpointer _tmp8_;
			EVCardAttribute* attr = NULL;
			EVCardAttribute* _tmp9_;
			EVCardAttribute* _tmp10_;
			FolksUrlFieldDetails* _tmp11_;
			EVCardAttribute* _tmp12_;
			FolksUrlFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			_tmp3_ = _url_field_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _url_field_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			url_field = (FolksUrlFieldDetails*) _tmp5_;
			_tmp6_ = url_field;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (g_strcmp0 ((const gchar*) _tmp8_, "") == 0) {
				_g_object_unref0 (url_field);
				continue;
			}
			_tmp9_ = e_vcard_attribute_new (NULL, EVC_URL);
			attr = _tmp9_;
			_tmp10_ = attr;
			_tmp11_ = url_field;
			contacts_io_vcard_export_operation_add_parameters_for_field_details (self, _tmp10_, (FolksAbstractFieldDetails*) _tmp11_);
			_tmp12_ = attr;
			attr = NULL;
			_tmp13_ = url_field;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			e_vcard_add_attribute_with_value (vcard, _tmp12_, (const gchar*) _tmp15_);
			__vala_EVCardAttribute_free0 (attr);
			_g_object_unref0 (url_field);
		}
		_g_object_unref0 (_url_field_it);
	}
}

static void
_vala_EVCardAttributeParam_free (EVCardAttributeParam* self)
{
	g_boxed_free (e_vcard_attribute_param_get_type (), self);
}

static void
contacts_io_vcard_export_operation_add_parameters_for_field_details (ContactsIoVCardExportOperation* self,
                                                                     EVCardAttribute* attr,
                                                                     FolksAbstractFieldDetails* field)
{
	GeeCollection* param_values = NULL;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (attr != NULL);
	g_return_if_fail (field != NULL);
	param_values = NULL;
	_tmp0_ = folks_abstract_field_details_get_parameter_values (field, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE);
	_g_object_unref0 (param_values);
	param_values = _tmp0_;
	_tmp2_ = param_values;
	if (_tmp2_ != NULL) {
		GeeCollection* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = param_values;
		_tmp4_ = gee_collection_get_is_empty (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		EVCardAttributeParam* param = NULL;
		EVCardAttributeParam* _tmp6_;
		EVCardAttributeParam* _tmp16_;
		_tmp6_ = e_vcard_attribute_param_new (EVC_TYPE);
		param = _tmp6_;
		{
			GeeIterator* _typestr_it = NULL;
			GeeCollection* _tmp7_;
			GeeIterator* _tmp8_;
			_tmp7_ = param_values;
			_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
			_typestr_it = _tmp8_;
			while (TRUE) {
				GeeIterator* _tmp9_;
				gchar* typestr = NULL;
				GeeIterator* _tmp10_;
				gpointer _tmp11_;
				EVCardAttributeParam* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp9_ = _typestr_it;
				if (!gee_iterator_next (_tmp9_)) {
					break;
				}
				_tmp10_ = _typestr_it;
				_tmp11_ = gee_iterator_get (_tmp10_);
				typestr = (gchar*) _tmp11_;
				_tmp12_ = param;
				_tmp13_ = typestr;
				_tmp14_ = g_utf8_strup (_tmp13_, (gssize) -1);
				_tmp15_ = _tmp14_;
				e_vcard_attribute_param_add_value (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				_g_free0 (typestr);
			}
			_g_object_unref0 (_typestr_it);
		}
		_tmp16_ = param;
		param = NULL;
		e_vcard_attribute_add_param (attr, _tmp16_);
		__vala_EVCardAttributeParam_free0 (param);
	}
	_g_object_unref0 (param_values);
}

static gchar*
contacts_io_vcard_export_operation_real_get_description (ContactsOperation* base)
{
	gchar* result;
	ContactsIoVCardExportOperation* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ContactsIoVCardExportOperation*) base;
	_tmp0_ = self->priv->_description;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
contacts_io_vcard_export_operation_class_init (ContactsIoVCardExportOperationClass * klass,
                                               gpointer klass_data)
{
	contacts_io_vcard_export_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsIoVCardExportOperation_private_offset);
	((ContactsOperationClass *) klass)->execute = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_io_vcard_export_operation_real_execute;
	((ContactsOperationClass *) klass)->execute_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) contacts_io_vcard_export_operation_execute_finish;
	CONTACTS_OPERATION_CLASS (klass)->get_description = (gchar* (*) (ContactsOperation*)) contacts_io_vcard_export_operation_real_get_description;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_io_vcard_export_operation_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_io_vcard_export_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IO_VCARD_EXPORT_OPERATION_DESCRIPTION_PROPERTY, contacts_io_vcard_export_operation_properties[CONTACTS_IO_VCARD_EXPORT_OPERATION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_io_vcard_export_operation_instance_init (ContactsIoVCardExportOperation * self,
                                                  gpointer klass)
{
	self->priv = contacts_io_vcard_export_operation_get_instance_private (self);
	self->priv->vcard_format = EVC_FORMAT_VCARD_30;
	self->priv->avoid_eds = FALSE;
}

static void
contacts_io_vcard_export_operation_finalize (GObject * obj)
{
	ContactsIoVCardExportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_IO_TYPE_VCARD_EXPORT_OPERATION, ContactsIoVCardExportOperation);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (contacts_io_vcard_export_operation_parent_class)->finalize (obj);
}

/**
 * An implementation of {@link Contacts.Io.Exporter} that serializes a contact
 * to the VCard format.
 *
 * Internally, it uses the E.VCard class to implement most of the logic.
 */
 G_GNUC_NO_INLINE static GType
contacts_io_vcard_export_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsIoVCardExportOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_io_vcard_export_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsIoVCardExportOperation), 0, (GInstanceInitFunc) contacts_io_vcard_export_operation_instance_init, NULL };
	GType contacts_io_vcard_export_operation_type_id;
	contacts_io_vcard_export_operation_type_id = g_type_register_static (CONTACTS_IO_TYPE_EXPORT_OPERATION, "ContactsIoVCardExportOperation", &g_define_type_info, 0);
	ContactsIoVCardExportOperation_private_offset = g_type_add_instance_private (contacts_io_vcard_export_operation_type_id, sizeof (ContactsIoVCardExportOperationPrivate));
	return contacts_io_vcard_export_operation_type_id;
}

GType
contacts_io_vcard_export_operation_get_type (void)
{
	static volatile gsize contacts_io_vcard_export_operation_type_id__once = 0;
	if (g_once_init_enter (&contacts_io_vcard_export_operation_type_id__once)) {
		GType contacts_io_vcard_export_operation_type_id;
		contacts_io_vcard_export_operation_type_id = contacts_io_vcard_export_operation_get_type_once ();
		g_once_init_leave (&contacts_io_vcard_export_operation_type_id__once, contacts_io_vcard_export_operation_type_id);
	}
	return contacts_io_vcard_export_operation_type_id__once;
}

static void
_vala_contacts_io_vcard_export_operation_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	ContactsIoVCardExportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_IO_TYPE_VCARD_EXPORT_OPERATION, ContactsIoVCardExportOperation);
	switch (property_id) {
		case CONTACTS_IO_VCARD_EXPORT_OPERATION_DESCRIPTION_PROPERTY:
		g_value_take_string (value, contacts_operation_get_description ((ContactsOperation*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

