/* game-save.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-save.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2025 Mahjongg Contributors*/
/* SPDX-FileCopyrightText: 2010-2013 Robert Ancell*/
/* SPDX-License-Identifier: GPL-2.0-or-later*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_SAVE (game_save_get_type ())
#define GAME_SAVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_SAVE, GameSave))
#define GAME_SAVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_SAVE, GameSaveClass))
#define IS_GAME_SAVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_SAVE))
#define IS_GAME_SAVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_SAVE))
#define GAME_SAVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_SAVE, GameSaveClass))

typedef struct _GameSave GameSave;
typedef struct _GameSaveClass GameSaveClass;
typedef struct _GameSavePrivate GameSavePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
#define _map_unref0(var) ((var == NULL) ? NULL : (var = (map_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MAPS (maps_get_type ())
#define MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAPS, Maps))
#define MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAPS, MapsClass))
#define IS_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAPS))
#define IS_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAPS))
#define MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAPS, MapsClass))

typedef struct _Maps Maps;
typedef struct _MapsClass MapsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef void (*GMarkupParserStartElementFunc) (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer user_data, GError** error);
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
typedef struct _MapPrivate MapPrivate;

#define GAME_TYPE_ITERATOR (game_iterator_get_type ())
#define GAME_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_TYPE_ITERATOR, GameIterator))
#define GAME_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_TYPE_ITERATOR, GameIteratorClass))
#define GAME_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_TYPE_ITERATOR))
#define GAME_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_TYPE_ITERATOR))
#define GAME_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_TYPE_ITERATOR, GameIteratorClass))

typedef struct _GameIterator GameIterator;
typedef struct _GameIteratorClass GameIteratorClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
typedef struct _SlotPrivate SlotPrivate;
#define _game_iterator_unref0(var) ((var == NULL) ? NULL : (var = (game_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define GAME_SAVE_TYPE_ITERATOR (game_save_iterator_get_type ())
#define GAME_SAVE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_SAVE_TYPE_ITERATOR, GameSaveIterator))
#define GAME_SAVE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_SAVE_TYPE_ITERATOR, GameSaveIteratorClass))
#define GAME_SAVE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_SAVE_TYPE_ITERATOR))
#define GAME_SAVE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_SAVE_TYPE_ITERATOR))
#define GAME_SAVE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_SAVE_TYPE_ITERATOR, GameSaveIteratorClass))

typedef struct _GameSaveIterator GameSaveIterator;
typedef struct _GameSaveIteratorClass GameSaveIteratorClass;
#define _tile_unref0(var) ((var == NULL) ? NULL : (var = (tile_unref (var), NULL)))
#define _slot_unref0(var) ((var == NULL) ? NULL : (var = (slot_unref (var), NULL)))

#define MAP_TYPE_ITERATOR (map_iterator_get_type ())
#define MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAP_TYPE_ITERATOR, MapIterator))
#define MAP_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAP_TYPE_ITERATOR, MapIteratorClass))
#define MAP_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAP_TYPE_ITERATOR))
#define MAP_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAP_TYPE_ITERATOR))
#define MAP_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAP_TYPE_ITERATOR, MapIteratorClass))

typedef struct _MapIterator MapIterator;
typedef struct _MapIteratorClass MapIteratorClass;
#define _map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (map_iterator_unref (var), NULL)))
typedef struct _GameSaveIteratorPrivate GameSaveIteratorPrivate;
#define _game_save_unref0(var) ((var == NULL) ? NULL : (var = (game_save_unref (var), NULL)))
typedef struct _GameSaveParamSpecIterator GameSaveParamSpecIterator;
typedef struct _ParamSpecGameSave ParamSpecGameSave;

struct _GameSave {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameSavePrivate * priv;
	Map* map;
	gdouble clock;
	gint move;
	gint32 seed;
};

struct _GameSaveClass {
	GTypeClass parent_class;
	void (*finalize) (GameSave *self);
};

struct _GameSavePrivate {
	gchar* map_name;
	gchar* filename;
	Tile** tiles;
	gint tiles_length1;
	gint _tiles_size_;
};

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Map* map;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};

struct _Map {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	gint h_overhang;
	gint v_overhang;
};

struct _MapClass {
	GTypeClass parent_class;
	void (*finalize) (Map *self);
};

struct _Tile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TilePrivate * priv;
	gint number;
	gboolean visible;
	gboolean highlighted;
	gint move;
	Slot* slot;
	gboolean shaking;
	gint shake_offset;
	gdouble shake_start_time;
};

struct _TileClass {
	GTypeClass parent_class;
	void (*finalize) (Tile *self);
};

struct _Slot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GTypeClass parent_class;
	void (*finalize) (Slot *self);
};

struct _GameSaveIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameSaveIteratorPrivate * priv;
};

struct _GameSaveIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (GameSaveIterator *self);
};

struct _GameSaveIteratorPrivate {
	gint index;
	GameSave* game_save;
};

struct _GameSaveParamSpecIterator {
	GParamSpec parent_instance;
};

struct _ParamSpecGameSave {
	GParamSpec parent_instance;
};

static gint GameSave_private_offset;
static gpointer game_save_parent_class = NULL;
static gint GameSaveIterator_private_offset;
static gpointer game_save_iterator_parent_class = NULL;

VALA_EXTERN gpointer game_save_ref (gpointer instance);
VALA_EXTERN void game_save_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_game_save (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_game_save (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_game_save (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_game_save (const GValue* value);
VALA_EXTERN GType game_save_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameSave, game_save_unref)
VALA_EXTERN gpointer map_ref (gpointer instance);
VALA_EXTERN void map_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_map (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags);
VALA_EXTERN void value_set_map (GValue* value,
                    gpointer v_object);
VALA_EXTERN void value_take_map (GValue* value,
                     gpointer v_object);
VALA_EXTERN gpointer value_get_map (const GValue* value);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, map_unref)
VALA_EXTERN gpointer tile_ref (gpointer instance);
VALA_EXTERN void tile_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_tile (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_tile (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_tile (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_tile (const GValue* value);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, tile_unref)
VALA_EXTERN GameSave* game_save_new (const gchar* filename);
VALA_EXTERN GameSave* game_save_construct (GType object_type,
                               const gchar* filename);
VALA_EXTERN gpointer maps_ref (gpointer instance);
VALA_EXTERN void maps_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_maps (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_maps (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_maps (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_maps (const GValue* value);
VALA_EXTERN GType maps_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Maps, maps_unref)
VALA_EXTERN gboolean game_save_load (GameSave* self,
                         Maps* maps);
static void game_save_start_element_cb (GameSave* self,
                                 GMarkupParseContext* context,
                                 const gchar* element_name,
                                 gchar** attribute_names,
                                 gint attribute_names_length1,
                                 gchar** attribute_values,
                                 gint attribute_values_length1,
                                 GError** error);
static void _game_save_start_element_cb_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                    const gchar* element_name,
                                                                    gchar** attribute_names,
                                                                    gchar** attribute_values,
                                                                    gpointer self,
                                                                    GError** error);
static void game_save_reset (GameSave* self);
VALA_EXTERN Map* maps_get_map_by_name (Maps* self,
                           const gchar* name);
static gboolean game_save_is_valid (GameSave* self,
                             Map* map);
VALA_EXTERN gpointer game_ref (gpointer instance);
VALA_EXTERN void game_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_game (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_game (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_game (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_game (const GValue* value);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, game_unref)
VALA_EXTERN void game_save_write (GameSave* self,
                      Game* game);
VALA_EXTERN gboolean game_get_can_save (Game* self);
VALA_EXTERN gint32 game_get_seed (Game* self);
VALA_EXTERN gdouble game_get_elapsed (Game* self);
VALA_EXTERN gint game_get_current_move (Game* self);
VALA_EXTERN gpointer game_iterator_ref (gpointer instance);
VALA_EXTERN void game_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_param_spec_iterator (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void game_value_set_iterator (GValue* value,
                              gpointer v_object);
VALA_EXTERN void game_value_take_iterator (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer game_value_get_iterator (const GValue* value);
VALA_EXTERN GType game_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameIterator, game_iterator_unref)
VALA_EXTERN GameIterator* game_iterator (Game* self);
VALA_EXTERN gboolean game_iterator_next (GameIterator* self);
VALA_EXTERN Tile* game_iterator_get (GameIterator* self);
VALA_EXTERN gpointer slot_ref (gpointer instance);
VALA_EXTERN void slot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slot (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_slot (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_slot (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_slot (const GValue* value);
VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, slot_unref)
VALA_EXTERN void game_save_delete (GameSave* self);
VALA_EXTERN gpointer game_save_iterator_ref (gpointer instance);
VALA_EXTERN void game_save_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_save_param_spec_iterator (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void game_save_value_set_iterator (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void game_save_value_take_iterator (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer game_save_value_get_iterator (const GValue* value);
VALA_EXTERN GType game_save_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameSaveIterator, game_save_iterator_unref)
VALA_EXTERN GameSaveIterator* game_save_iterator (GameSave* self);
VALA_EXTERN GameSaveIterator* game_save_iterator_new (GameSave* game_save);
VALA_EXTERN GameSaveIterator* game_save_iterator_construct (GType object_type,
                                                GameSave* game_save);
static gchar* game_save_get_attribute (GameSave* self,
                                gchar** attribute_names,
                                gint attribute_names_length1,
                                gchar** attribute_values,
                                gint attribute_values_length1,
                                const gchar* name,
                                const gchar* _default_);
static gdouble game_save_get_attribute_d (GameSave* self,
                                   gchar** attribute_names,
                                   gint attribute_names_length1,
                                   gchar** attribute_values,
                                   gint attribute_values_length1,
                                   const gchar* name,
                                   gdouble _default_);
VALA_EXTERN Slot* slot_new (gint x,
                gint y,
                gint layer);
VALA_EXTERN Slot* slot_construct (GType object_type,
                      gint x,
                      gint y,
                      gint layer);
VALA_EXTERN Tile* tile_new (Slot* slot);
VALA_EXTERN Tile* tile_construct (GType object_type,
                      Slot* slot);
static void _vala_array_add11 (Tile** * array,
                        gint* length,
                        gint* size,
                        Tile* value);
VALA_EXTERN gpointer map_iterator_ref (gpointer instance);
VALA_EXTERN void map_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* map_param_spec_iterator (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void map_value_set_iterator (GValue* value,
                             gpointer v_object);
VALA_EXTERN void map_value_take_iterator (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer map_value_get_iterator (const GValue* value);
VALA_EXTERN GType map_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MapIterator, map_iterator_unref)
VALA_EXTERN MapIterator* map_iterator (Map* self);
VALA_EXTERN gboolean map_iterator_next (MapIterator* self);
VALA_EXTERN Slot* map_iterator_get (MapIterator* self);
VALA_EXTERN gboolean slot_equals (Slot* self,
                      Slot* b);
VALA_EXTERN gint map_get_n_slots (Map* self);
VALA_EXTERN gboolean game_save_iterator_next (GameSaveIterator* self);
VALA_EXTERN Tile* game_save_iterator_get (GameSaveIterator* self);
static void game_save_iterator_finalize (GameSaveIterator * obj);
static GType game_save_iterator_get_type_once (void);
static void game_save_finalize (GameSave * obj);
static GType game_save_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
game_save_get_instance_private (GameSave* self)
{
	return G_STRUCT_MEMBER_P (self, GameSave_private_offset);
}

GameSave*
game_save_construct (GType object_type,
                     const gchar* filename)
{
	GameSave* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (GameSave*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (filename);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp0_;
	return self;
}

GameSave*
game_save_new (const gchar* filename)
{
	return game_save_construct (TYPE_GAME_SAVE, filename);
}

static void
_game_save_start_element_cb_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                               const gchar* element_name,
                                                               gchar** attribute_names,
                                                               gchar** attribute_values,
                                                               gpointer self,
                                                               GError** error)
{
	game_save_start_element_cb ((GameSave*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}

static gpointer
_map_ref0 (gpointer self)
{
	return self ? map_ref (self) : NULL;
}

gboolean
game_save_load (GameSave* self,
                Maps* maps)
{
	gchar* data = NULL;
	gsize length = 0UL;
	const gchar* _tmp0_;
	GMarkupParser parser = {0};
	GMarkupParser _tmp9_ = {0};
	GMarkupParseContext* parse_context = NULL;
	GMarkupParser _tmp10_;
	GMarkupParseContext* _tmp11_;
	const gchar* _tmp19_;
	Map* _tmp20_;
	Map* _tmp21_;
	Map* _tmp22_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (maps != NULL, FALSE);
	_tmp0_ = self->priv->filename;
	if (!g_file_test (_tmp0_, G_FILE_TEST_EXISTS)) {
		result = FALSE;
		_g_free0 (data);
		return result;
	}
	{
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gsize _tmp3_ = 0UL;
		_tmp1_ = self->priv->filename;
		g_file_get_contents (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
		_g_free0 (data);
		data = _tmp2_;
		length = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = self->priv->filename;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("game-save.vala:30: Could not load game save %s: %s\n", _tmp5_, _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (data);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	memset (&_tmp9_, 0, sizeof (GMarkupParser));
	_tmp9_.start_element = _game_save_start_element_cb_gmarkup_parser_start_element_func;
	parser = _tmp9_;
	_tmp10_ = parser;
	_tmp11_ = g_markup_parse_context_new (&_tmp10_, 0, self, NULL);
	parse_context = _tmp11_;
	{
		GMarkupParseContext* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = parse_context;
		_tmp13_ = data;
		g_markup_parse_context_parse (_tmp12_, _tmp13_, (gssize) length, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp14_ = FALSE;
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			_g_markup_parse_context_unref0 (parse_context);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp14_;
		}
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = self->priv->filename;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("game-save.vala:42: Could not parse game save %s: %s\n", _tmp15_, _tmp17_);
		game_save_reset (self);
		result = FALSE;
		_g_error_free0 (e);
		_g_markup_parse_context_unref0 (parse_context);
		_g_free0 (data);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_g_markup_parse_context_unref0 (parse_context);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	_tmp19_ = self->priv->map_name;
	_tmp20_ = maps_get_map_by_name (maps, _tmp19_);
	_tmp21_ = _map_ref0 (_tmp20_);
	_map_unref0 (self->map);
	self->map = _tmp21_;
	_tmp22_ = self->map;
	if (!game_save_is_valid (self, _tmp22_)) {
		const gchar* _tmp23_;
		_tmp23_ = self->priv->map_name;
		g_warning ("game-save.vala:49: Saved layout '%s' is not valid.\n", _tmp23_);
		game_save_reset (self);
		result = FALSE;
		_g_markup_parse_context_unref0 (parse_context);
		_g_free0 (data);
		return result;
	}
	result = TRUE;
	_g_markup_parse_context_unref0 (parse_context);
	_g_free0 (data);
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
game_save_write (GameSave* self,
                 Game* game)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GString* builder = NULL;
	GString* _tmp2_;
	GString* _tmp3_;
	Map* _tmp4_;
	const gchar* _tmp5_;
	gint32 _tmp6_;
	gint32 _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GString* _tmp14_;
	GString* _tmp30_;
	GString* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game_get_can_save (game);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = g_string_new ("");
	builder = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = game->map;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = game_get_seed (game);
	_tmp7_ = _tmp6_;
	_tmp8_ = game_get_elapsed (game);
	_tmp9_ = _tmp8_;
	_tmp10_ = double_to_string (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = game_get_current_move (game);
	_tmp13_ = _tmp12_;
	g_string_append_printf (_tmp3_, "<game map=\"%s\" seed=\"%d\" clock=\"%s\" move=\"%d\">\n", _tmp5_, (gint) _tmp7_, _tmp11_, _tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = builder;
	g_string_append (_tmp14_, "\t<tiles>\n");
	{
		GameIterator* _tile_it = NULL;
		GameIterator* _tmp15_;
		_tmp15_ = game_iterator (game);
		_tile_it = _tmp15_;
		while (TRUE) {
			GameIterator* _tmp16_;
			Tile* tile = NULL;
			GameIterator* _tmp17_;
			Tile* _tmp18_;
			const gchar* _tmp19_ = NULL;
			Tile* _tmp20_;
			GString* _tmp21_;
			Tile* _tmp22_;
			Tile* _tmp23_;
			Tile* _tmp24_;
			Slot* _tmp25_;
			Tile* _tmp26_;
			Slot* _tmp27_;
			Tile* _tmp28_;
			Slot* _tmp29_;
			_tmp16_ = _tile_it;
			if (!game_iterator_next (_tmp16_)) {
				break;
			}
			_tmp17_ = _tile_it;
			_tmp18_ = game_iterator_get (_tmp17_);
			tile = _tmp18_;
			_tmp20_ = tile;
			if (_tmp20_->visible) {
				_tmp19_ = "true";
			} else {
				_tmp19_ = "false";
			}
			_tmp21_ = builder;
			_tmp22_ = tile;
			_tmp23_ = tile;
			_tmp24_ = tile;
			_tmp25_ = _tmp24_->slot;
			_tmp26_ = tile;
			_tmp27_ = _tmp26_->slot;
			_tmp28_ = tile;
			_tmp29_ = _tmp28_->slot;
			g_string_append_printf (_tmp21_, "\t\t<tile number=\"%d\" visible=\"%s\" move=\"%d\" z=\"%d\" x=\"%d\" y" \
"=\"%d\"/>\n", _tmp22_->number, _tmp19_, _tmp23_->move, _tmp25_->layer, _tmp27_->x, _tmp29_->y);
		}
		_game_iterator_unref0 (_tile_it);
	}
	_tmp30_ = builder;
	g_string_append (_tmp30_, "\t</tiles>\n");
	_tmp31_ = builder;
	g_string_append (_tmp31_, "</game>\n");
	{
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		GString* _tmp36_;
		const gchar* _tmp37_;
		_tmp32_ = self->priv->filename;
		_tmp33_ = g_path_get_dirname (_tmp32_);
		_tmp34_ = _tmp33_;
		g_mkdir_with_parents (_tmp34_, 0775);
		_g_free0 (_tmp34_);
		_tmp35_ = self->priv->filename;
		_tmp36_ = builder;
		_tmp37_ = _tmp36_->str;
		g_file_set_contents (_tmp35_, _tmp37_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_string_free0 (builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp38_;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = self->priv->filename;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_warning ("game-save.vala:91: Could not save game to %s: %s", _tmp38_, _tmp40_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (builder);
}

void
game_save_delete (GameSave* self)
{
	const gchar* _tmp0_;
	gint _result_ = 0;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filename;
	if (!g_file_test (_tmp0_, G_FILE_TEST_EXISTS)) {
		return;
	}
	_tmp1_ = self->priv->filename;
	_result_ = g_remove (_tmp1_);
	if (_result_ == -1) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->filename;
		g_warning ("game-save.vala:101: Could not remove save file %s.", _tmp2_);
	}
	game_save_reset (self);
}

GameSaveIterator*
game_save_iterator (GameSave* self)
{
	GameSaveIterator* _tmp0_;
	GameSaveIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = game_save_iterator_new (self);
	result = _tmp0_;
	return result;
}

static gchar*
game_save_get_attribute (GameSave* self,
                         gchar** attribute_names,
                         gint attribute_names_length1,
                         gchar** attribute_values,
                         gint attribute_values_length1,
                         const gchar* name,
                         const gchar* _default_)
{
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attribute_names[i];
				if (!(_tmp2_ != NULL)) {
					break;
				}
				_tmp3_ = attribute_names[i];
				_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, name) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = attribute_values[i];
					_tmp8_ = g_strdup (_tmp7_);
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	_tmp9_ = g_strdup (_default_);
	result = _tmp9_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gdouble
game_save_get_attribute_d (GameSave* self,
                           gchar** attribute_names,
                           gint attribute_names_length1,
                           gchar** attribute_values,
                           gint attribute_values_length1,
                           const gchar* name,
                           gdouble _default_)
{
	gchar* a = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	_tmp0_ = game_save_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, name, NULL);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = a;
		result = double_parse (_tmp2_);
		_g_free0 (a);
		return result;
	}
	result = _default_;
	_g_free0 (a);
	return result;
}

static gpointer
_tile_ref0 (gpointer self)
{
	return self ? tile_ref (self) : NULL;
}

static void
_vala_array_add11 (Tile** * array,
                   gint* length,
                   gint* size,
                   Tile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Tile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
game_save_start_element_cb (GameSave* self,
                            GMarkupParseContext* context,
                            const gchar* element_name,
                            gchar** attribute_names,
                            gint attribute_names_length1,
                            gchar** attribute_values,
                            gint attribute_values_length1,
                            GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (element_name != NULL);
	_tmp0_ = g_utf8_strdown (element_name, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("game")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = game_save_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "map", "");
				_g_free0 (self->priv->map_name);
				self->priv->map_name = _tmp4_;
				self->seed = (gint32) ((gint) game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "seed", 0.0));
				self->clock = game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "clock", 0.0);
				self->move = (gint) game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "move", 0.0);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("tile")))) {
		switch (0) {
			default:
			{
				gint number = 0;
				gboolean visible = FALSE;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gboolean _tmp7_;
				gint move = 0;
				gint x = 0;
				gint y = 0;
				gint layer = 0;
				Slot* slot = NULL;
				Slot* _tmp8_;
				Tile* tile = NULL;
				Slot* _tmp9_;
				Tile* _tmp10_ = NULL;
				Tile* _tmp11_;
				Tile* _tmp12_;
				number = (gint) game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "number", 0.0);
				_tmp5_ = game_save_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "visible", NULL);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp6_, "true") == 0;
				_g_free0 (_tmp6_);
				visible = _tmp7_;
				move = (gint) game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "move", 0.0);
				x = (gint) game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "x", 0.0);
				y = (gint) game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "y", 0.0);
				layer = (gint) game_save_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", 0.0);
				_tmp8_ = slot_new (x, y, layer);
				slot = _tmp8_;
				_tmp9_ = slot;
				_tmp10_ = tile_new (_tmp9_);
				_tmp10_->number = number;
				_tmp10_->visible = visible;
				_tmp10_->move = move;
				tile = _tmp10_;
				_tmp11_ = tile;
				_tmp12_ = _tile_ref0 (_tmp11_);
				_vala_array_add11 (&self->priv->tiles, &self->priv->tiles_length1, &self->priv->_tiles_size_, _tmp12_);
				_tile_unref0 (tile);
				_slot_unref0 (slot);
				break;
			}
		}
	}
}

static gboolean
game_save_is_valid (GameSave* self,
                    Map* map)
{
	gint n_matched_tiles = 0;
	gint _tmp9_;
	gint _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (map == NULL) {
		result = FALSE;
		return result;
	}
	n_matched_tiles = 0;
	{
		MapIterator* _slot_it = NULL;
		MapIterator* _tmp0_;
		_tmp0_ = map_iterator (map);
		_slot_it = _tmp0_;
		while (TRUE) {
			MapIterator* _tmp1_;
			Slot* slot = NULL;
			MapIterator* _tmp2_;
			Slot* _tmp3_;
			Tile** _tmp4_;
			gint _tmp4__length1;
			_tmp1_ = _slot_it;
			if (!map_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _slot_it;
			_tmp3_ = map_iterator_get (_tmp2_);
			slot = _tmp3_;
			_tmp4_ = self->priv->tiles;
			_tmp4__length1 = self->priv->tiles_length1;
			{
				Tile** tile_collection = NULL;
				gint tile_collection_length1 = 0;
				gint _tile_collection_size_ = 0;
				gint tile_it = 0;
				tile_collection = _tmp4_;
				tile_collection_length1 = _tmp4__length1;
				for (tile_it = 0; tile_it < tile_collection_length1; tile_it = tile_it + 1) {
					Tile* tile = NULL;
					tile = tile_collection[tile_it];
					{
						Slot* _tmp5_;
						Tile* _tmp6_;
						Slot* _tmp7_;
						_tmp5_ = slot;
						_tmp6_ = tile;
						_tmp7_ = _tmp6_->slot;
						if (slot_equals (_tmp5_, _tmp7_)) {
							gint _tmp8_;
							_tmp8_ = n_matched_tiles;
							n_matched_tiles = _tmp8_ + 1;
							break;
						}
					}
				}
			}
		}
		_map_iterator_unref0 (_slot_it);
	}
	_tmp9_ = map_get_n_slots (map);
	_tmp10_ = _tmp9_;
	result = _tmp10_ == n_matched_tiles;
	return result;
}

static void
game_save_reset (GameSave* self)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_map_unref0 (self->map);
	self->map = NULL;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->map_name);
	self->priv->map_name = _tmp0_;
	self->clock = 0.0;
	self->move = 0;
	self->seed = (gint32) 0;
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1, (GDestroyNotify) tile_unref), NULL);
	self->priv->tiles = NULL;
	self->priv->tiles_length1 = 0;
	self->priv->_tiles_size_ = self->priv->tiles_length1;
}

static inline gpointer
game_save_iterator_get_instance_private (GameSaveIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GameSaveIterator_private_offset);
}

static gpointer
_game_save_ref0 (gpointer self)
{
	return self ? game_save_ref (self) : NULL;
}

GameSaveIterator*
game_save_iterator_construct (GType object_type,
                              GameSave* game_save)
{
	GameSaveIterator* self = NULL;
	GameSave* _tmp0_;
	g_return_val_if_fail (game_save != NULL, NULL);
	self = (GameSaveIterator*) g_type_create_instance (object_type);
	_tmp0_ = _game_save_ref0 (game_save);
	_game_save_unref0 (self->priv->game_save);
	self->priv->game_save = _tmp0_;
	return self;
}

GameSaveIterator*
game_save_iterator_new (GameSave* game_save)
{
	return game_save_iterator_construct (GAME_SAVE_TYPE_ITERATOR, game_save);
}

gboolean
game_save_iterator_next (GameSaveIterator* self)
{
	GameSave* _tmp0_;
	Tile** _tmp1_;
	gint _tmp1__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game_save;
	_tmp1_ = _tmp0_->priv->tiles;
	_tmp1__length1 = _tmp0_->priv->tiles_length1;
	result = self->priv->index < _tmp1__length1;
	return result;
}

Tile*
game_save_iterator_get (GameSaveIterator* self)
{
	GameSave* _tmp0_;
	Tile** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	Tile* _tmp3_;
	Tile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->game_save;
	_tmp1_ = _tmp0_->priv->tiles;
	_tmp1__length1 = _tmp0_->priv->tiles_length1;
	_tmp2_ = self->priv->index;
	self->priv->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}

static void
game_save_value_iterator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
game_save_value_iterator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		game_save_iterator_unref (value->data[0].v_pointer);
	}
}

static void
game_save_value_iterator_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = game_save_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
game_save_value_iterator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
game_save_value_iterator_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GameSaveIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = game_save_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
game_save_value_iterator_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GameSaveIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = game_save_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
game_save_param_spec_iterator (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GameSaveParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GAME_SAVE_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
game_save_value_get_iterator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_SAVE_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}

void
game_save_value_set_iterator (GValue* value,
                              gpointer v_object)
{
	GameSaveIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_SAVE_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_SAVE_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		game_save_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		game_save_iterator_unref (old);
	}
}

void
game_save_value_take_iterator (GValue* value,
                               gpointer v_object)
{
	GameSaveIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_SAVE_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_SAVE_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		game_save_iterator_unref (old);
	}
}

static void
game_save_iterator_class_init (GameSaveIteratorClass * klass,
                               gpointer klass_data)
{
	game_save_iterator_parent_class = g_type_class_peek_parent (klass);
	((GameSaveIteratorClass *) klass)->finalize = game_save_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &GameSaveIterator_private_offset);
}

static void
game_save_iterator_instance_init (GameSaveIterator * self,
                                  gpointer klass)
{
	self->priv = game_save_iterator_get_instance_private (self);
	self->ref_count = 1;
}

static void
game_save_iterator_finalize (GameSaveIterator * obj)
{
	GameSaveIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_SAVE_TYPE_ITERATOR, GameSaveIterator);
	g_signal_handlers_destroy (self);
	_game_save_unref0 (self->priv->game_save);
}

static GType
game_save_iterator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_save_value_iterator_init, game_save_value_iterator_free_value, game_save_value_iterator_copy_value, game_save_value_iterator_peek_pointer, "p", game_save_value_iterator_collect_value, "p", game_save_value_iterator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameSaveIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_save_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameSaveIterator), 0, (GInstanceInitFunc) game_save_iterator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_save_iterator_type_id;
	game_save_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameSaveIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GameSaveIterator_private_offset = g_type_add_instance_private (game_save_iterator_type_id, sizeof (GameSaveIteratorPrivate));
	return game_save_iterator_type_id;
}

GType
game_save_iterator_get_type (void)
{
	static volatile gsize game_save_iterator_type_id__once = 0;
	if (g_once_init_enter (&game_save_iterator_type_id__once)) {
		GType game_save_iterator_type_id;
		game_save_iterator_type_id = game_save_iterator_get_type_once ();
		g_once_init_leave (&game_save_iterator_type_id__once, game_save_iterator_type_id);
	}
	return game_save_iterator_type_id__once;
}

gpointer
game_save_iterator_ref (gpointer instance)
{
	GameSaveIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
game_save_iterator_unref (gpointer instance)
{
	GameSaveIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GAME_SAVE_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_game_save_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_game_save_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		game_save_unref (value->data[0].v_pointer);
	}
}

static void
value_game_save_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = game_save_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_game_save_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_game_save_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GameSave * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = game_save_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_game_save_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	GameSave ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = game_save_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_game_save (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecGameSave* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GAME_SAVE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_game_save (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GAME_SAVE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_game_save (GValue* value,
                     gpointer v_object)
{
	GameSave * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GAME_SAVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GAME_SAVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		game_save_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		game_save_unref (old);
	}
}

void
value_take_game_save (GValue* value,
                      gpointer v_object)
{
	GameSave * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GAME_SAVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GAME_SAVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		game_save_unref (old);
	}
}

static void
game_save_class_init (GameSaveClass * klass,
                      gpointer klass_data)
{
	game_save_parent_class = g_type_class_peek_parent (klass);
	((GameSaveClass *) klass)->finalize = game_save_finalize;
	g_type_class_adjust_private_offset (klass, &GameSave_private_offset);
}

static void
game_save_instance_init (GameSave * self,
                         gpointer klass)
{
	self->priv = game_save_get_instance_private (self);
	self->ref_count = 1;
}

static void
game_save_finalize (GameSave * obj)
{
	GameSave * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_SAVE, GameSave);
	g_signal_handlers_destroy (self);
	_map_unref0 (self->map);
	_g_free0 (self->priv->map_name);
	_g_free0 (self->priv->filename);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1, (GDestroyNotify) tile_unref), NULL);
}

static GType
game_save_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_game_save_init, value_game_save_free_value, value_game_save_copy_value, value_game_save_peek_pointer, "p", value_game_save_collect_value, "p", value_game_save_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameSaveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_save_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameSave), 0, (GInstanceInitFunc) game_save_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_save_type_id;
	game_save_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameSave", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GameSave_private_offset = g_type_add_instance_private (game_save_type_id, sizeof (GameSavePrivate));
	return game_save_type_id;
}

GType
game_save_get_type (void)
{
	static volatile gsize game_save_type_id__once = 0;
	if (g_once_init_enter (&game_save_type_id__once)) {
		GType game_save_type_id;
		game_save_type_id = game_save_get_type_once ();
		g_once_init_leave (&game_save_type_id__once, game_save_type_id);
	}
	return game_save_type_id__once;
}

gpointer
game_save_ref (gpointer instance)
{
	GameSave * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
game_save_unref (gpointer instance)
{
	GameSave * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GAME_SAVE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

