/* SimpleCommand.c generated by valac 0.56.17, the Vala compiler
 * generated from SimpleCommand.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011–2013 Lucas Baudin <xapantu@gmail.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_SERVICES_SIMPLE_COMMAND_0_PROPERTY,
	GRANITE_SERVICES_SIMPLE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* granite_services_simple_command_properties[GRANITE_SERVICES_SIMPLE_COMMAND_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GRANITE_SERVICES_SIMPLE_COMMAND_DONE_SIGNAL,
	GRANITE_SERVICES_SIMPLE_COMMAND_OUTPUT_CHANGED_SIGNAL,
	GRANITE_SERVICES_SIMPLE_COMMAND_STANDARD_CHANGED_SIGNAL,
	GRANITE_SERVICES_SIMPLE_COMMAND_ERROR_CHANGED_SIGNAL,
	GRANITE_SERVICES_SIMPLE_COMMAND_NUM_SIGNALS
};
static guint granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_NUM_SIGNALS] = {0};

struct _GraniteServicesSimpleCommandPrivate {
	GIOChannel* out_make;
	GIOChannel* error_out;
	gchar* dir;
	gchar* command;
	GPid pid;
};

static gint GraniteServicesSimpleCommand_private_offset;
static gpointer granite_services_simple_command_parent_class = NULL;

static void __lambda8_ (GraniteServicesSimpleCommand* self,
                 GPid pid,
                 gint exit);
static void ___lambda8__gchild_watch_func (GPid pid,
                                    gint wait_status,
                                    gpointer self);
static gboolean __lambda9_ (GraniteServicesSimpleCommand* self,
                     GIOChannel* source,
                     GIOCondition condition);
static gboolean ___lambda9__gio_func (GIOChannel* source,
                               GIOCondition condition,
                               gpointer self);
static gboolean __lambda10_ (GraniteServicesSimpleCommand* self,
                      GIOChannel* source,
                      GIOCondition condition);
static gboolean ___lambda10__gio_func (GIOChannel* source,
                                GIOCondition condition,
                                gpointer self);
static void granite_services_simple_command_finalize (GObject * obj);
static GType granite_services_simple_command_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
granite_services_simple_command_get_instance_private (GraniteServicesSimpleCommand* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteServicesSimpleCommand_private_offset);
}

/**
     * Create a new object. You will have to call `run ()` when you want to run the command.
     *
     * @param dir The working dir
     * @param command The command to execute (using absolute paths like /usr/bin/make causes less
     * strange bugs).
     *
     */
GraniteServicesSimpleCommand*
granite_services_simple_command_construct (GType object_type,
                                           const gchar* dir,
                                           const gchar* command)
{
	GraniteServicesSimpleCommand * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (dir != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	self = (GraniteServicesSimpleCommand*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (dir);
	_g_free0 (self->priv->dir);
	self->priv->dir = _tmp0_;
	_tmp1_ = g_strdup (command);
	_g_free0 (self->priv->command);
	self->priv->command = _tmp1_;
	return self;
}

GraniteServicesSimpleCommand*
granite_services_simple_command_new (const gchar* dir,
                                     const gchar* command)
{
	return granite_services_simple_command_construct (GRANITE_SERVICES_TYPE_SIMPLE_COMMAND, dir, command);
}

/**
     * Launch the command. It is async.
     */
static void
__lambda8_ (GraniteServicesSimpleCommand* self,
            GPid pid,
            gint exit)
{
	g_signal_emit (self, granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_DONE_SIGNAL], 0, exit);
}

static void
___lambda8__gchild_watch_func (GPid pid,
                               gint wait_status,
                               gpointer self)
{
	__lambda8_ ((GraniteServicesSimpleCommand*) self, pid, wait_status);
}

static gboolean
__lambda9_ (GraniteServicesSimpleCommand* self,
            GIOChannel* source,
            GIOCondition condition)
{
	gchar* output = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (source != NULL, FALSE);
	if (condition == G_IO_HUP) {
		result = FALSE;
		return result;
	}
	output = NULL;
	{
		GIOChannel* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->out_make;
		g_io_channel_read_line (_tmp0_, &_tmp1_, NULL, NULL, &_inner_error0_);
		_g_free0 (output);
		output = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->priv->command;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("SimpleCommand.vala:108: Error in the output retrieving of %s: %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = self->standard_output_str;
	_tmp7_ = output;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_g_free0 (self->standard_output_str);
	self->standard_output_str = _tmp8_;
	_tmp9_ = self->output_str;
	_tmp10_ = output;
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
	_g_free0 (self->output_str);
	self->output_str = _tmp11_;
	_tmp12_ = output;
	g_signal_emit (self, granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_STANDARD_CHANGED_SIGNAL], 0, _tmp12_);
	_tmp13_ = output;
	g_signal_emit (self, granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_OUTPUT_CHANGED_SIGNAL], 0, _tmp13_);
	result = TRUE;
	_g_free0 (output);
	return result;
}

static gboolean
___lambda9__gio_func (GIOChannel* source,
                      GIOCondition condition,
                      gpointer self)
{
	gboolean result;
	result = __lambda9_ ((GraniteServicesSimpleCommand*) self, source, condition);
	return result;
}

static gboolean
__lambda10_ (GraniteServicesSimpleCommand* self,
             GIOChannel* source,
             GIOCondition condition)
{
	gchar* output = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (source != NULL, FALSE);
	if (condition == G_IO_HUP) {
		result = FALSE;
		return result;
	}
	output = NULL;
	{
		GIOChannel* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->error_out;
		g_io_channel_read_line (_tmp0_, &_tmp1_, NULL, NULL, &_inner_error0_);
		_g_free0 (output);
		output = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->priv->command;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("SimpleCommand.vala:130: Error in the output retrieving of %s: %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = self->error_output_str;
	_tmp7_ = output;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_g_free0 (self->error_output_str);
	self->error_output_str = _tmp8_;
	_tmp9_ = self->output_str;
	_tmp10_ = output;
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
	_g_free0 (self->output_str);
	self->output_str = _tmp11_;
	_tmp12_ = output;
	g_signal_emit (self, granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_ERROR_CHANGED_SIGNAL], 0, _tmp12_);
	_tmp13_ = output;
	g_signal_emit (self, granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_OUTPUT_CHANGED_SIGNAL], 0, _tmp13_);
	result = TRUE;
	_g_free0 (output);
	return result;
}

static gboolean
___lambda10__gio_func (GIOChannel* source,
                       GIOCondition condition,
                       gpointer self)
{
	gboolean result;
	result = __lambda10_ ((GraniteServicesSimpleCommand*) self, source, condition);
	return result;
}

void
granite_services_simple_command_run (GraniteServicesSimpleCommand* self)
{
	gint standard_output = 0;
	gint standard_error = 0;
	GIOChannel* _tmp12_;
	GIOChannel* _tmp13_;
	GIOChannel* _tmp14_;
	GIOChannel* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	standard_output = 0;
	standard_error = 0;
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		GPid _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp0_ = self->priv->dir;
		_tmp1_ = self->priv->command;
		_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _vala_array_length (_tmp2_);
		g_spawn_async_with_pipes (_tmp0_, _tmp4_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp5_, NULL, &_tmp6_, &_tmp7_, &_inner_error0_);
		self->priv->pid = _tmp5_;
		standard_output = _tmp6_;
		standard_error = _tmp7_;
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = self->priv->command;
		_tmp9_ = self->priv->dir;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("SimpleCommand.vala:90: Couldn't launch command %s in the directory %s:" \
" %s", _tmp8_, _tmp9_, _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->pid, ___lambda8__gchild_watch_func, g_object_ref (self), g_object_unref);
	_tmp12_ = g_io_channel_unix_new (standard_output);
	_g_io_channel_unref0 (self->priv->out_make);
	self->priv->out_make = _tmp12_;
	_tmp13_ = self->priv->out_make;
	g_io_add_watch (_tmp13_, G_IO_IN | G_IO_HUP, ___lambda9__gio_func, self);
	_tmp14_ = g_io_channel_unix_new (standard_error);
	_g_io_channel_unref0 (self->priv->error_out);
	self->priv->error_out = _tmp14_;
	_tmp15_ = self->priv->error_out;
	g_io_add_watch (_tmp15_, G_IO_IN | G_IO_HUP, ___lambda10__gio_func, self);
}

static void
granite_services_simple_command_class_init (GraniteServicesSimpleCommandClass * klass,
                                            gpointer klass_data)
{
	granite_services_simple_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteServicesSimpleCommand_private_offset);
	G_OBJECT_CLASS (klass)->finalize = granite_services_simple_command_finalize;
	/**
	     * Emitted when the command is finished.
	     */
	granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_DONE_SIGNAL] = g_signal_new ("done", GRANITE_SERVICES_TYPE_SIMPLE_COMMAND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	/**
	     * When the output changed (std.out and std.err).
	     *
	     * @param text the new text
	     */
	granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_OUTPUT_CHANGED_SIGNAL] = g_signal_new ("output-changed", GRANITE_SERVICES_TYPE_SIMPLE_COMMAND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/**
	     * When the standard output is changed.
	     *
	     * @param text the new text from std.out
	     */
	granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_STANDARD_CHANGED_SIGNAL] = g_signal_new ("standard-changed", GRANITE_SERVICES_TYPE_SIMPLE_COMMAND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/**
	     * When the error output is changed.
	     *
	     * @param text the new text from std.err
	     */
	granite_services_simple_command_signals[GRANITE_SERVICES_SIMPLE_COMMAND_ERROR_CHANGED_SIGNAL] = g_signal_new ("error-changed", GRANITE_SERVICES_TYPE_SIMPLE_COMMAND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
granite_services_simple_command_instance_init (GraniteServicesSimpleCommand * self,
                                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = granite_services_simple_command_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->standard_output_str = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->error_output_str = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->output_str = _tmp2_;
}

static void
granite_services_simple_command_finalize (GObject * obj)
{
	GraniteServicesSimpleCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_SIMPLE_COMMAND, GraniteServicesSimpleCommand);
	_g_free0 (self->standard_output_str);
	_g_free0 (self->error_output_str);
	_g_free0 (self->output_str);
	_g_io_channel_unref0 (self->priv->out_make);
	_g_io_channel_unref0 (self->priv->error_out);
	_g_free0 (self->priv->dir);
	_g_free0 (self->priv->command);
	G_OBJECT_CLASS (granite_services_simple_command_parent_class)->finalize (obj);
}

/**
 * This class is a wrapper to run an async command. It provides useful signals.
 */
static GType
granite_services_simple_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesSimpleCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_simple_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesSimpleCommand), 0, (GInstanceInitFunc) granite_services_simple_command_instance_init, NULL };
	GType granite_services_simple_command_type_id;
	granite_services_simple_command_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesSimpleCommand", &g_define_type_info, 0);
	GraniteServicesSimpleCommand_private_offset = g_type_add_instance_private (granite_services_simple_command_type_id, sizeof (GraniteServicesSimpleCommandPrivate));
	return granite_services_simple_command_type_id;
}

GType
granite_services_simple_command_get_type (void)
{
	static volatile gsize granite_services_simple_command_type_id__once = 0;
	if (g_once_init_enter (&granite_services_simple_command_type_id__once)) {
		GType granite_services_simple_command_type_id;
		granite_services_simple_command_type_id = granite_services_simple_command_get_type_once ();
		g_once_init_leave (&granite_services_simple_command_type_id__once, granite_services_simple_command_type_id);
	}
	return granite_services_simple_command_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

