/* TimePicker.c generated by valac 0.56.17, the Vala compiler
 * generated from TimePicker.vala, do not modify */

/*
 * Copyright 2018–2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011–2013 Maxwell Barvian <maxwell@elementaryos.org>
 * Copyright 2011–2013 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_TIME_PICKER_0_PROPERTY,
	GRANITE_WIDGETS_TIME_PICKER_FORMAT_12_PROPERTY,
	GRANITE_WIDGETS_TIME_PICKER_FORMAT_24_PROPERTY,
	GRANITE_WIDGETS_TIME_PICKER_TIME_PROPERTY,
	GRANITE_WIDGETS_TIME_PICKER_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_time_picker_properties[GRANITE_WIDGETS_TIME_PICKER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GRANITE_WIDGETS_TIME_PICKER_TIME_CHANGED_SIGNAL,
	GRANITE_WIDGETS_TIME_PICKER_NUM_SIGNALS
};
static guint granite_widgets_time_picker_signals[GRANITE_WIDGETS_TIME_PICKER_NUM_SIGNALS] = {0};

struct _GraniteWidgetsTimePickerPrivate {
	gchar* _format_12;
	gchar* _format_24;
	GDateTime* _time;
	gboolean changing_time;
	gchar* old_string;
	GtkPopover* popover;
	GtkSpinButton* hours_spinbutton;
	GtkSpinButton* minutes_spinbutton;
	GraniteWidgetsModeButton* am_pm_modebutton;
};

static gint GraniteWidgetsTimePicker_private_offset;
static gpointer granite_widgets_time_picker_parent_class = NULL;

static void granite_widgets_time_picker_update_text (GraniteWidgetsTimePicker* self,
                                              gboolean no_signal);
static void granite_widgets_time_picker_update_time (GraniteWidgetsTimePicker* self,
                                              gboolean is_hour);
 G_GNUC_INTERNAL gboolean granite_date_time_is_clock_format_12h (void);
static void granite_widgets_time_picker_on_icon_press (GraniteWidgetsTimePicker* self,
                                                GtkEntryIconPosition position,
                                                GdkEvent* event);
static void granite_widgets_time_picker_real_position_dropdown (GraniteWidgetsTimePicker* self,
                                                         gint* x,
                                                         gint* y) G_GNUC_DEPRECATED ;
static void granite_widgets_time_picker_is_unfocused (GraniteWidgetsTimePicker* self);
static void granite_widgets_time_picker_parse_time (GraniteWidgetsTimePicker* self,
                                             const gchar* timestr);
static gint* _int_dup (gint* self);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static GObject * granite_widgets_time_picker_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _granite_widgets_time_picker_on_icon_press_gtk_entry_icon_release (GtkEntry* _sender,
                                                                        GtkEntryIconPosition icon_pos,
                                                                        GdkEvent* event,
                                                                        gpointer self);
static void _granite_widgets_time_picker___lambda87_ (GraniteWidgetsTimePicker* self,
                                               GtkWidget* mode);
static void __granite_widgets_time_picker___lambda87__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                                         GtkWidget* widget,
                                                                                         gpointer self);
static void _granite_widgets_time_picker___lambda88_ (GraniteWidgetsTimePicker* self);
static void __granite_widgets_time_picker___lambda88__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                              gpointer self);
static void _granite_widgets_time_picker___lambda89_ (GraniteWidgetsTimePicker* self);
static void __granite_widgets_time_picker___lambda89__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                              gpointer self);
static gboolean _granite_widgets_time_picker___lambda90_ (GraniteWidgetsTimePicker* self);
static gboolean __granite_widgets_time_picker___lambda90__gtk_spin_button_output (GtkSpinButton* _sender,
                                                                           gpointer self);
static gboolean _granite_widgets_time_picker___lambda91_ (GraniteWidgetsTimePicker* self);
static gboolean __granite_widgets_time_picker___lambda91__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                               GdkEventFocus* event,
                                                                               gpointer self);
static gboolean _granite_widgets_time_picker___lambda92_ (GraniteWidgetsTimePicker* self,
                                                   GdkEventScroll* event);
static gboolean __granite_widgets_time_picker___lambda92__gtk_widget_scroll_event (GtkWidget* _sender,
                                                                            GdkEventScroll* event,
                                                                            gpointer self);
static void _granite_widgets_time_picker_is_unfocused_gtk_entry_activate (GtkEntry* _sender,
                                                                   gpointer self);
 G_GNUC_INTERNAL void granite_init (void);
static void granite_widgets_time_picker_finalize (GObject * obj);
static GType granite_widgets_time_picker_get_type_once (void);
static void _vala_granite_widgets_time_picker_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_granite_widgets_time_picker_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
granite_widgets_time_picker_get_instance_private (GraniteWidgetsTimePicker* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsTimePicker_private_offset);
}

const gchar*
granite_widgets_time_picker_get_format_12 (GraniteWidgetsTimePicker* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_format_12;
	result = _tmp0_;
	return result;
}

static void
granite_widgets_time_picker_set_format_12 (GraniteWidgetsTimePicker* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_time_picker_get_format_12 (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_format_12);
		self->priv->_format_12 = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_time_picker_properties[GRANITE_WIDGETS_TIME_PICKER_FORMAT_12_PROPERTY]);
	}
}

const gchar*
granite_widgets_time_picker_get_format_24 (GraniteWidgetsTimePicker* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_format_24;
	result = _tmp0_;
	return result;
}

static void
granite_widgets_time_picker_set_format_24 (GraniteWidgetsTimePicker* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_time_picker_get_format_24 (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_format_24);
		self->priv->_format_24 = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_time_picker_properties[GRANITE_WIDGETS_TIME_PICKER_FORMAT_24_PROPERTY]);
	}
}

GDateTime*
granite_widgets_time_picker_get_time (GraniteWidgetsTimePicker* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	GDateTime* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_time;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp1_ = g_date_time_new_now_local ();
		_tmp2_ = _tmp1_;
		granite_widgets_time_picker_set_time (self, _tmp2_);
		_g_date_time_unref0 (_tmp2_);
	}
	_tmp3_ = self->priv->_time;
	result = _tmp3_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
granite_widgets_time_picker_set_time (GraniteWidgetsTimePicker* self,
                                      GDateTime* value)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_time);
	self->priv->_time = _tmp0_;
	self->priv->changing_time = TRUE;
	_tmp1_ = self->priv->_time;
	if (g_date_time_get_hour (_tmp1_) >= 12) {
		GraniteWidgetsModeButton* _tmp2_;
		_tmp2_ = self->priv->am_pm_modebutton;
		granite_widgets_mode_button_set_active (_tmp2_, 1);
	} else {
		GraniteWidgetsModeButton* _tmp3_;
		_tmp3_ = self->priv->am_pm_modebutton;
		granite_widgets_mode_button_set_active (_tmp3_, 0);
	}
	granite_widgets_time_picker_update_text (self, TRUE);
	self->priv->changing_time = FALSE;
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_time_picker_properties[GRANITE_WIDGETS_TIME_PICKER_TIME_PROPERTY]);
}

/**
         * Creates a new TimePicker.
         *
         * @param format_12 The desired custom 12h format. For example "%l:%M %p".
         * @param format_24 The desired custom 24h format. For example "%H:%M".
         */
GraniteWidgetsTimePicker*
granite_widgets_time_picker_construct_with_format (GType object_type,
                                                   const gchar* format_12,
                                                   const gchar* format_24)
{
	GraniteWidgetsTimePicker * self = NULL;
	g_return_val_if_fail (format_12 != NULL, NULL);
	g_return_val_if_fail (format_24 != NULL, NULL);
	self = (GraniteWidgetsTimePicker*) g_object_new (object_type, "format-12", format_12, "format-24", format_24, NULL);
	return self;
}

GraniteWidgetsTimePicker*
granite_widgets_time_picker_new_with_format (const gchar* format_12,
                                             const gchar* format_24)
{
	return granite_widgets_time_picker_construct_with_format (GRANITE_WIDGETS_TYPE_TIME_PICKER, format_12, format_24);
}

static void
granite_widgets_time_picker_update_time (GraniteWidgetsTimePicker* self,
                                         gboolean is_hour)
{
	g_return_if_fail (self != NULL);
	if (self->priv->changing_time) {
		return;
	}
	if (is_hour) {
		gint new_hour = 0;
		GtkSpinButton* _tmp0_;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp0_ = self->priv->hours_spinbutton;
		_tmp1_ = granite_widgets_time_picker_get_time (self);
		_tmp2_ = _tmp1_;
		new_hour = gtk_spin_button_get_value_as_int (_tmp0_) - g_date_time_get_hour (_tmp2_);
		if (granite_date_time_is_clock_format_12h ()) {
			gboolean _tmp3_ = FALSE;
			GtkSpinButton* _tmp4_;
			_tmp4_ = self->priv->hours_spinbutton;
			if (gtk_spin_button_get_value_as_int (_tmp4_) == 12) {
				GraniteWidgetsModeButton* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				_tmp5_ = self->priv->am_pm_modebutton;
				_tmp6_ = granite_widgets_mode_button_get_selected (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp3_ = _tmp7_ == 0;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				GDateTime* _tmp8_;
				GDateTime* _tmp9_;
				GDateTime* _tmp10_;
				_tmp8_ = self->priv->_time;
				_tmp9_ = self->priv->_time;
				_tmp10_ = g_date_time_add_hours (_tmp8_, -g_date_time_get_hour (_tmp9_));
				_g_date_time_unref0 (self->priv->_time);
				self->priv->_time = _tmp10_;
			} else {
				gboolean _tmp11_ = FALSE;
				GtkSpinButton* _tmp12_;
				_tmp12_ = self->priv->hours_spinbutton;
				if (gtk_spin_button_get_value_as_int (_tmp12_) < 12) {
					GraniteWidgetsModeButton* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					_tmp13_ = self->priv->am_pm_modebutton;
					_tmp14_ = granite_widgets_mode_button_get_selected (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp11_ = _tmp15_ == 0;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GDateTime* _tmp16_;
					GDateTime* _tmp17_;
					_tmp16_ = self->priv->_time;
					_tmp17_ = g_date_time_add_hours (_tmp16_, new_hour);
					_g_date_time_unref0 (self->priv->_time);
					self->priv->_time = _tmp17_;
				} else {
					gboolean _tmp18_ = FALSE;
					GtkSpinButton* _tmp19_;
					_tmp19_ = self->priv->hours_spinbutton;
					if (gtk_spin_button_get_value_as_int (_tmp19_) == 12) {
						GraniteWidgetsModeButton* _tmp20_;
						gint _tmp21_;
						gint _tmp22_;
						_tmp20_ = self->priv->am_pm_modebutton;
						_tmp21_ = granite_widgets_mode_button_get_selected (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp18_ = _tmp22_ == 1;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						GDateTime* _tmp23_;
						GDateTime* _tmp24_;
						GDateTime* _tmp25_;
						_tmp23_ = self->priv->_time;
						_tmp24_ = self->priv->_time;
						_tmp25_ = g_date_time_add_hours (_tmp23_, (-g_date_time_get_hour (_tmp24_)) + 12);
						_g_date_time_unref0 (self->priv->_time);
						self->priv->_time = _tmp25_;
					} else {
						gboolean _tmp26_ = FALSE;
						GtkSpinButton* _tmp27_;
						_tmp27_ = self->priv->hours_spinbutton;
						if (gtk_spin_button_get_value_as_int (_tmp27_) < 12) {
							GraniteWidgetsModeButton* _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
							_tmp28_ = self->priv->am_pm_modebutton;
							_tmp29_ = granite_widgets_mode_button_get_selected (_tmp28_);
							_tmp30_ = _tmp29_;
							_tmp26_ = _tmp30_ == 1;
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							GDateTime* _tmp31_;
							GDateTime* _tmp32_;
							GDateTime* _tmp33_;
							GDateTime* _tmp34_;
							_tmp31_ = self->priv->_time;
							_tmp32_ = g_date_time_add_hours (_tmp31_, new_hour + 12);
							_g_date_time_unref0 (self->priv->_time);
							self->priv->_time = _tmp32_;
							_tmp33_ = granite_widgets_time_picker_get_time (self);
							_tmp34_ = _tmp33_;
							if (g_date_time_get_hour (_tmp34_) <= 12) {
								GDateTime* _tmp35_;
								GDateTime* _tmp36_;
								_tmp35_ = self->priv->_time;
								_tmp36_ = g_date_time_add_hours (_tmp35_, 12);
								_g_date_time_unref0 (self->priv->_time);
								self->priv->_time = _tmp36_;
							}
						}
					}
				}
			}
		} else {
			GDateTime* _tmp37_;
			GDateTime* _tmp38_;
			_tmp37_ = self->priv->_time;
			_tmp38_ = g_date_time_add_hours (_tmp37_, new_hour);
			_g_date_time_unref0 (self->priv->_time);
			self->priv->_time = _tmp38_;
		}
	} else {
		GDateTime* _tmp39_;
		GDateTime* _tmp40_;
		GtkSpinButton* _tmp41_;
		GDateTime* _tmp42_;
		GDateTime* _tmp43_;
		GDateTime* _tmp44_;
		_tmp39_ = granite_widgets_time_picker_get_time (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = self->priv->minutes_spinbutton;
		_tmp42_ = granite_widgets_time_picker_get_time (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_date_time_add_minutes (_tmp40_, gtk_spin_button_get_value_as_int (_tmp41_) - g_date_time_get_minute (_tmp43_));
		_g_date_time_unref0 (self->priv->_time);
		self->priv->_time = _tmp44_;
	}
	granite_widgets_time_picker_update_text (self, FALSE);
}

static void
granite_widgets_time_picker_on_icon_press (GraniteWidgetsTimePicker* self,
                                           GtkEntryIconPosition position,
                                           GdkEvent* event)
{
	gboolean _tmp0_ = FALSE;
	GtkSpinButton* _tmp29_;
	GDateTime* _tmp30_;
	GDateTime* _tmp31_;
	GtkPopover* _tmp32_;
	GdkRectangle _tmp33_ = {0};
	GtkPopover* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	granite_widgets_time_picker_update_text (self, FALSE);
	self->priv->changing_time = TRUE;
	if (granite_date_time_is_clock_format_12h ()) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp1_ = granite_widgets_time_picker_get_time (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_date_time_get_hour (_tmp2_) > 12;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkSpinButton* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		_tmp3_ = self->priv->hours_spinbutton;
		_tmp4_ = granite_widgets_time_picker_get_time (self);
		_tmp5_ = _tmp4_;
		gtk_spin_button_set_value (_tmp3_, (gdouble) (g_date_time_get_hour (_tmp5_) - 12));
	} else {
		GtkSpinButton* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		_tmp6_ = self->priv->hours_spinbutton;
		_tmp7_ = granite_widgets_time_picker_get_time (self);
		_tmp8_ = _tmp7_;
		gtk_spin_button_set_value (_tmp6_, (gdouble) g_date_time_get_hour (_tmp8_));
	}
	if (granite_date_time_is_clock_format_12h ()) {
		GraniteWidgetsModeButton* _tmp9_;
		GraniteWidgetsModeButton* _tmp10_;
		GDateTime* _tmp11_;
		GDateTime* _tmp12_;
		GtkSpinButton* _tmp22_;
		_tmp9_ = self->priv->am_pm_modebutton;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->am_pm_modebutton;
		gtk_widget_show_all ((GtkWidget*) _tmp10_);
		_tmp11_ = granite_widgets_time_picker_get_time (self);
		_tmp12_ = _tmp11_;
		if (g_date_time_get_hour (_tmp12_) > 12) {
			GtkSpinButton* _tmp13_;
			GDateTime* _tmp14_;
			GDateTime* _tmp15_;
			_tmp13_ = self->priv->hours_spinbutton;
			_tmp14_ = granite_widgets_time_picker_get_time (self);
			_tmp15_ = _tmp14_;
			gtk_spin_button_set_value (_tmp13_, (gdouble) (g_date_time_get_hour (_tmp15_) - 12));
		} else {
			GDateTime* _tmp16_;
			GDateTime* _tmp17_;
			_tmp16_ = granite_widgets_time_picker_get_time (self);
			_tmp17_ = _tmp16_;
			if (g_date_time_get_hour (_tmp17_) == 0) {
				GtkSpinButton* _tmp18_;
				_tmp18_ = self->priv->hours_spinbutton;
				gtk_spin_button_set_value (_tmp18_, (gdouble) 12);
			} else {
				GtkSpinButton* _tmp19_;
				GDateTime* _tmp20_;
				GDateTime* _tmp21_;
				_tmp19_ = self->priv->hours_spinbutton;
				_tmp20_ = granite_widgets_time_picker_get_time (self);
				_tmp21_ = _tmp20_;
				gtk_spin_button_set_value (_tmp19_, (gdouble) g_date_time_get_hour (_tmp21_));
			}
		}
		_tmp22_ = self->priv->hours_spinbutton;
		gtk_spin_button_set_range (_tmp22_, (gdouble) 1, (gdouble) 12);
	} else {
		GraniteWidgetsModeButton* _tmp23_;
		GraniteWidgetsModeButton* _tmp24_;
		GtkSpinButton* _tmp25_;
		GDateTime* _tmp26_;
		GDateTime* _tmp27_;
		GtkSpinButton* _tmp28_;
		_tmp23_ = self->priv->am_pm_modebutton;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp23_, TRUE);
		_tmp24_ = self->priv->am_pm_modebutton;
		gtk_widget_hide ((GtkWidget*) _tmp24_);
		_tmp25_ = self->priv->hours_spinbutton;
		_tmp26_ = granite_widgets_time_picker_get_time (self);
		_tmp27_ = _tmp26_;
		gtk_spin_button_set_value (_tmp25_, (gdouble) g_date_time_get_hour (_tmp27_));
		_tmp28_ = self->priv->hours_spinbutton;
		gtk_spin_button_set_range (_tmp28_, (gdouble) 0, (gdouble) 23);
	}
	_tmp29_ = self->priv->minutes_spinbutton;
	_tmp30_ = granite_widgets_time_picker_get_time (self);
	_tmp31_ = _tmp30_;
	gtk_spin_button_set_value (_tmp29_, (gdouble) g_date_time_get_minute (_tmp31_));
	self->priv->changing_time = FALSE;
	_tmp32_ = self->priv->popover;
	gtk_entry_get_icon_area ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, &_tmp33_);
	g_object_set (_tmp32_, "pointing-to", &_tmp33_, NULL);
	_tmp34_ = self->priv->popover;
	gtk_widget_show_all ((GtkWidget*) _tmp34_);
}

static void
granite_widgets_time_picker_real_position_dropdown (GraniteWidgetsTimePicker* self,
                                                    gint* x,
                                                    gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	_vala_x = -1;
	_vala_y = -1;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

void
granite_widgets_time_picker_position_dropdown (GraniteWidgetsTimePicker* self,
                                               gint* x,
                                               gint* y)
{
	GraniteWidgetsTimePickerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GRANITE_WIDGETS_TIME_PICKER_GET_CLASS (self);
	if (_klass_->position_dropdown) {
		_klass_->position_dropdown (self, x, y);
	}
}

static void
granite_widgets_time_picker_is_unfocused (GraniteWidgetsTimePicker* self)
{
	gboolean _tmp0_ = FALSE;
	GtkPopover* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->popover;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->old_string;
		_tmp5_ = gtk_entry_get_text ((GtkEntry*) self);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_utf8_collate (_tmp4_, _tmp6_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp7_ = gtk_entry_get_text ((GtkEntry*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->old_string);
		self->priv->old_string = _tmp9_;
		_tmp10_ = gtk_entry_get_text ((GtkEntry*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = _tmp12_;
		granite_widgets_time_picker_parse_time (self, _tmp13_);
		_g_free0 (_tmp13_);
	}
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
granite_widgets_time_picker_parse_time (GraniteWidgetsTimePicker* self,
                                        const gchar* timestr)
{
	gchar* current = NULL;
	gchar* _tmp0_;
	gboolean is_hours = FALSE;
	gboolean is_suffix = FALSE;
	gboolean has_suffix = FALSE;
	gint* hour = NULL;
	gint* minute = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_ = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp66_ = FALSE;
	gint* _tmp71_;
	gboolean _tmp96_ = FALSE;
	gint* _tmp97_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timestr != NULL);
	_tmp0_ = g_strdup ("");
	current = _tmp0_;
	is_hours = TRUE;
	is_suffix = FALSE;
	has_suffix = FALSE;
	hour = NULL;
	minute = NULL;
	_tmp1_ = g_utf8_strdown (timestr, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp4_ = string_to_utf8 (_tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_g_free0 (_tmp2_);
	{
		gchar* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp5_;
		c_collection_length1 = _tmp5__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			gchar c = '\0';
			c = c_collection[c_it];
			{
				if (g_ascii_isdigit (c)) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = current;
					_tmp7_ = g_strdup_printf ("%s%c", _tmp6_, (gint) c);
					_g_free0 (current);
					current = _tmp7_;
				} else {
					gboolean _tmp25_ = FALSE;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gboolean _tmp28_;
					if (!is_suffix) {
						const gchar* _tmp8_;
						gboolean _tmp17_ = FALSE;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gboolean _tmp20_;
						_tmp8_ = current;
						if (g_strcmp0 (_tmp8_, "") != 0) {
							if (is_hours) {
								const gchar* _tmp9_;
								gint _tmp10_;
								gint* _tmp11_;
								gchar* _tmp12_;
								is_hours = FALSE;
								_tmp9_ = current;
								_tmp10_ = atoi (_tmp9_);
								_tmp11_ = __int_dup0 (&_tmp10_);
								_g_free0 (hour);
								hour = _tmp11_;
								_tmp12_ = g_strdup ("");
								_g_free0 (current);
								current = _tmp12_;
							} else {
								const gchar* _tmp13_;
								gint _tmp14_;
								gint* _tmp15_;
								gchar* _tmp16_;
								_tmp13_ = current;
								_tmp14_ = atoi (_tmp13_);
								_tmp15_ = __int_dup0 (&_tmp14_);
								_g_free0 (minute);
								minute = _tmp15_;
								_tmp16_ = g_strdup ("");
								_g_free0 (current);
								current = _tmp16_;
							}
						}
						_tmp18_ = g_strdup_printf ("%c", c);
						_tmp19_ = _tmp18_;
						_tmp20_ = string_contains (_tmp19_, "a");
						_g_free0 (_tmp19_);
						if (_tmp20_) {
							_tmp17_ = TRUE;
						} else {
							gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp21_ = g_strdup_printf ("%c", c);
							_tmp22_ = _tmp21_;
							_tmp17_ = string_contains (_tmp22_, "p");
							_g_free0 (_tmp22_);
						}
						if (_tmp17_) {
							const gchar* _tmp23_;
							gchar* _tmp24_;
							is_suffix = TRUE;
							_tmp23_ = current;
							_tmp24_ = g_strdup_printf ("%s%c", _tmp23_, (gint) c);
							_g_free0 (current);
							current = _tmp24_;
						}
					}
					_tmp26_ = g_strdup_printf ("%c", c);
					_tmp27_ = _tmp26_;
					_tmp28_ = string_contains (_tmp27_, "m");
					_g_free0 (_tmp27_);
					if (_tmp28_) {
						_tmp25_ = is_suffix;
					} else {
						_tmp25_ = FALSE;
					}
					if (_tmp25_) {
						gint* _tmp29_;
						gboolean _tmp33_ = FALSE;
						const gchar* _tmp34_;
						gboolean _tmp50_ = FALSE;
						const gchar* _tmp51_;
						GDateTime* _tmp58_;
						GDateTime* _tmp59_;
						gint* _tmp60_;
						GDateTime* _tmp61_;
						GDateTime* _tmp62_;
						GDateTime* _tmp63_;
						GDateTime* _tmp64_;
						_tmp29_ = hour;
						if (_tmp29_ == NULL) {
							c_collection = (g_free (c_collection), NULL);
							_g_free0 (minute);
							_g_free0 (hour);
							_g_free0 (current);
							return;
						} else {
							gint* _tmp30_;
							_tmp30_ = minute;
							if (_tmp30_ == NULL) {
								gint _tmp31_;
								gint* _tmp32_;
								_tmp31_ = 0;
								_tmp32_ = __int_dup0 (&_tmp31_);
								_g_free0 (minute);
								minute = _tmp32_;
							}
						}
						_tmp34_ = current;
						if (string_contains (_tmp34_, "a")) {
							_tmp33_ = TRUE;
						} else {
							gint* _tmp35_;
							_tmp35_ = hour;
							_tmp33_ = (*_tmp35_) >= 12;
						}
						if (_tmp33_) {
							GDateTime* _tmp36_;
							GDateTime* _tmp37_;
							gint* _tmp38_;
							GDateTime* _tmp39_;
							GDateTime* _tmp40_;
							GDateTime* _tmp41_;
							GDateTime* _tmp42_;
							_tmp36_ = granite_widgets_time_picker_get_time (self);
							_tmp37_ = _tmp36_;
							_tmp38_ = hour;
							_tmp39_ = granite_widgets_time_picker_get_time (self);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_date_time_add_hours (_tmp37_, (*_tmp38_) - g_date_time_get_hour (_tmp40_));
							_tmp42_ = _tmp41_;
							granite_widgets_time_picker_set_time (self, _tmp42_);
							_g_date_time_unref0 (_tmp42_);
						} else {
							GDateTime* _tmp43_;
							GDateTime* _tmp44_;
							gint* _tmp45_;
							GDateTime* _tmp46_;
							GDateTime* _tmp47_;
							GDateTime* _tmp48_;
							GDateTime* _tmp49_;
							_tmp43_ = granite_widgets_time_picker_get_time (self);
							_tmp44_ = _tmp43_;
							_tmp45_ = hour;
							_tmp46_ = granite_widgets_time_picker_get_time (self);
							_tmp47_ = _tmp46_;
							_tmp48_ = g_date_time_add_hours (_tmp44_, ((*_tmp45_) + 12) - g_date_time_get_hour (_tmp47_));
							_tmp49_ = _tmp48_;
							granite_widgets_time_picker_set_time (self, _tmp49_);
							_g_date_time_unref0 (_tmp49_);
						}
						_tmp51_ = current;
						if (string_contains (_tmp51_, "a")) {
							gint* _tmp52_;
							gint _tmp53_;
							_tmp52_ = hour;
							_tmp53_ = 12;
							_tmp50_ = _int_equal (_tmp52_, &_tmp53_) == TRUE;
						} else {
							_tmp50_ = FALSE;
						}
						if (_tmp50_) {
							GDateTime* _tmp54_;
							GDateTime* _tmp55_;
							GDateTime* _tmp56_;
							GDateTime* _tmp57_;
							_tmp54_ = granite_widgets_time_picker_get_time (self);
							_tmp55_ = _tmp54_;
							_tmp56_ = g_date_time_add_hours (_tmp55_, -12);
							_tmp57_ = _tmp56_;
							granite_widgets_time_picker_set_time (self, _tmp57_);
							_g_date_time_unref0 (_tmp57_);
						}
						_tmp58_ = granite_widgets_time_picker_get_time (self);
						_tmp59_ = _tmp58_;
						_tmp60_ = minute;
						_tmp61_ = granite_widgets_time_picker_get_time (self);
						_tmp62_ = _tmp61_;
						_tmp63_ = g_date_time_add_minutes (_tmp59_, (*_tmp60_) - g_date_time_get_minute (_tmp62_));
						_tmp64_ = _tmp63_;
						granite_widgets_time_picker_set_time (self, _tmp64_);
						_g_date_time_unref0 (_tmp64_);
						has_suffix = TRUE;
					}
				}
			}
		}
		c_collection = (g_free (c_collection), NULL);
	}
	if (is_hours == FALSE) {
		_tmp66_ = is_suffix == FALSE;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		const gchar* _tmp67_;
		_tmp67_ = current;
		_tmp65_ = g_strcmp0 (_tmp67_, "") != 0;
	} else {
		_tmp65_ = FALSE;
	}
	if (_tmp65_) {
		const gchar* _tmp68_;
		gint _tmp69_;
		gint* _tmp70_;
		_tmp68_ = current;
		_tmp69_ = atoi (_tmp68_);
		_tmp70_ = __int_dup0 (&_tmp69_);
		_g_free0 (minute);
		minute = _tmp70_;
	}
	_tmp71_ = hour;
	if (_tmp71_ == NULL) {
		const gchar* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		_tmp72_ = current;
		_tmp73_ = strlen (_tmp72_);
		_tmp74_ = _tmp73_;
		if (_tmp74_ < 3) {
			const gchar* _tmp75_;
			gint _tmp76_;
			gint* _tmp77_;
			gint _tmp78_;
			gint* _tmp79_;
			_tmp75_ = current;
			_tmp76_ = atoi (_tmp75_);
			_tmp77_ = __int_dup0 (&_tmp76_);
			_g_free0 (hour);
			hour = _tmp77_;
			_tmp78_ = 0;
			_tmp79_ = __int_dup0 (&_tmp78_);
			_g_free0 (minute);
			minute = _tmp79_;
		} else {
			const gchar* _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
			_tmp80_ = current;
			_tmp81_ = strlen (_tmp80_);
			_tmp82_ = _tmp81_;
			if (_tmp82_ == 4) {
				const gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gint _tmp86_;
				gint* _tmp87_;
				const gchar* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				gint _tmp91_;
				gint* _tmp92_;
				gboolean _tmp93_ = FALSE;
				gint* _tmp94_;
				_tmp83_ = current;
				_tmp84_ = string_slice (_tmp83_, (glong) 0, (glong) 2);
				_tmp85_ = _tmp84_;
				_tmp86_ = atoi (_tmp85_);
				_tmp87_ = __int_dup0 (&_tmp86_);
				_g_free0 (hour);
				hour = _tmp87_;
				_g_free0 (_tmp85_);
				_tmp88_ = current;
				_tmp89_ = string_slice (_tmp88_, (glong) 2, (glong) 4);
				_tmp90_ = _tmp89_;
				_tmp91_ = atoi (_tmp90_);
				_tmp92_ = __int_dup0 (&_tmp91_);
				_g_free0 (minute);
				minute = _tmp92_;
				_g_free0 (_tmp90_);
				_tmp94_ = hour;
				if ((*_tmp94_) > 23) {
					_tmp93_ = TRUE;
				} else {
					gint* _tmp95_;
					_tmp95_ = minute;
					_tmp93_ = (*_tmp95_) > 59;
				}
				if (_tmp93_) {
					_g_free0 (hour);
					hour = NULL;
					_g_free0 (minute);
					minute = NULL;
				}
			}
		}
	}
	_tmp97_ = hour;
	if (_tmp97_ == NULL) {
		_tmp96_ = TRUE;
	} else {
		gint* _tmp98_;
		_tmp98_ = minute;
		_tmp96_ = _tmp98_ == NULL;
	}
	if (_tmp96_) {
		granite_widgets_time_picker_update_text (self, FALSE);
		_g_free0 (minute);
		_g_free0 (hour);
		_g_free0 (current);
		return;
	}
	if (has_suffix == FALSE) {
		GDateTime* _tmp99_;
		GDateTime* _tmp100_;
		gint* _tmp101_;
		GDateTime* _tmp102_;
		GDateTime* _tmp103_;
		GDateTime* _tmp104_;
		GDateTime* _tmp105_;
		GDateTime* _tmp106_;
		GDateTime* _tmp107_;
		gint* _tmp108_;
		GDateTime* _tmp109_;
		GDateTime* _tmp110_;
		GDateTime* _tmp111_;
		GDateTime* _tmp112_;
		_tmp99_ = granite_widgets_time_picker_get_time (self);
		_tmp100_ = _tmp99_;
		_tmp101_ = hour;
		_tmp102_ = granite_widgets_time_picker_get_time (self);
		_tmp103_ = _tmp102_;
		_tmp104_ = g_date_time_add_hours (_tmp100_, (*_tmp101_) - g_date_time_get_hour (_tmp103_));
		_tmp105_ = _tmp104_;
		granite_widgets_time_picker_set_time (self, _tmp105_);
		_g_date_time_unref0 (_tmp105_);
		_tmp106_ = granite_widgets_time_picker_get_time (self);
		_tmp107_ = _tmp106_;
		_tmp108_ = minute;
		_tmp109_ = granite_widgets_time_picker_get_time (self);
		_tmp110_ = _tmp109_;
		_tmp111_ = g_date_time_add_minutes (_tmp107_, (*_tmp108_) - g_date_time_get_minute (_tmp110_));
		_tmp112_ = _tmp111_;
		granite_widgets_time_picker_set_time (self, _tmp112_);
		_g_date_time_unref0 (_tmp112_);
	}
	granite_widgets_time_picker_update_text (self, FALSE);
	_g_free0 (minute);
	_g_free0 (hour);
	_g_free0 (current);
}

static void
granite_widgets_time_picker_update_text (GraniteWidgetsTimePicker* self,
                                         gboolean no_signal)
{
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	if (granite_date_time_is_clock_format_12h ()) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = granite_widgets_time_picker_get_time (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->_format_12;
		_tmp3_ = g_date_time_format (_tmp1_, _tmp2_);
		_tmp4_ = _tmp3_;
		gtk_entry_set_text ((GtkEntry*) self, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = granite_widgets_time_picker_get_time (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_format_24;
		_tmp8_ = g_date_time_format (_tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		gtk_entry_set_text ((GtkEntry*) self, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = gtk_entry_get_text ((GtkEntry*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (self->priv->old_string);
	self->priv->old_string = _tmp12_;
	if (no_signal == FALSE) {
		g_signal_emit (self, granite_widgets_time_picker_signals[GRANITE_WIDGETS_TIME_PICKER_TIME_CHANGED_SIGNAL], 0);
	}
}

GraniteWidgetsTimePicker*
granite_widgets_time_picker_construct (GType object_type)
{
	GraniteWidgetsTimePicker * self = NULL;
	self = (GraniteWidgetsTimePicker*) g_object_new (object_type, NULL);
	return self;
}

GraniteWidgetsTimePicker*
granite_widgets_time_picker_new (void)
{
	return granite_widgets_time_picker_construct (GRANITE_WIDGETS_TYPE_TIME_PICKER);
}

static void
_granite_widgets_time_picker_on_icon_press_gtk_entry_icon_release (GtkEntry* _sender,
                                                                   GtkEntryIconPosition icon_pos,
                                                                   GdkEvent* event,
                                                                   gpointer self)
{
	granite_widgets_time_picker_on_icon_press ((GraniteWidgetsTimePicker*) self, icon_pos, event);
}

static void
_granite_widgets_time_picker___lambda87_ (GraniteWidgetsTimePicker* self,
                                          GtkWidget* mode)
{
	GraniteWidgetsModeButton* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (mode != NULL);
	if (self->priv->changing_time) {
		return;
	}
	_tmp0_ = self->priv->am_pm_modebutton;
	_tmp1_ = granite_widgets_mode_button_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		_tmp3_ = self->priv->_time;
		_tmp4_ = g_date_time_add_hours (_tmp3_, -12);
		_tmp5_ = _tmp4_;
		granite_widgets_time_picker_set_time (self, _tmp5_);
		_g_date_time_unref0 (_tmp5_);
		g_signal_emit (self, granite_widgets_time_picker_signals[GRANITE_WIDGETS_TIME_PICKER_TIME_CHANGED_SIGNAL], 0);
	} else {
		GraniteWidgetsModeButton* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->am_pm_modebutton;
		_tmp7_ = granite_widgets_mode_button_get_selected (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == 1) {
			GDateTime* _tmp9_;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			_tmp9_ = self->priv->_time;
			_tmp10_ = g_date_time_add_hours (_tmp9_, 12);
			_tmp11_ = _tmp10_;
			granite_widgets_time_picker_set_time (self, _tmp11_);
			_g_date_time_unref0 (_tmp11_);
			g_signal_emit (self, granite_widgets_time_picker_signals[GRANITE_WIDGETS_TIME_PICKER_TIME_CHANGED_SIGNAL], 0);
		} else {
			g_assert_not_reached ();
		}
	}
	granite_widgets_time_picker_update_text (self, TRUE);
}

static void
__granite_widgets_time_picker___lambda87__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                                    GtkWidget* widget,
                                                                                    gpointer self)
{
	_granite_widgets_time_picker___lambda87_ ((GraniteWidgetsTimePicker*) self, widget);
}

static void
_granite_widgets_time_picker___lambda88_ (GraniteWidgetsTimePicker* self)
{
	granite_widgets_time_picker_update_time (self, TRUE);
}

static void
__granite_widgets_time_picker___lambda88__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                         gpointer self)
{
	_granite_widgets_time_picker___lambda88_ ((GraniteWidgetsTimePicker*) self);
}

static void
_granite_widgets_time_picker___lambda89_ (GraniteWidgetsTimePicker* self)
{
	granite_widgets_time_picker_update_time (self, FALSE);
}

static void
__granite_widgets_time_picker___lambda89__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                         gpointer self)
{
	_granite_widgets_time_picker___lambda89_ ((GraniteWidgetsTimePicker*) self);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gboolean
_granite_widgets_time_picker___lambda90_ (GraniteWidgetsTimePicker* self)
{
	gdouble val = 0.0;
	GtkSpinButton* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->minutes_spinbutton;
	val = gtk_spin_button_get_value (_tmp0_);
	if (val < ((gdouble) 10)) {
		GtkSpinButton* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = self->priv->minutes_spinbutton;
		_tmp2_ = double_to_string (val);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("0", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		gtk_entry_set_text ((GtkEntry*) _tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
__granite_widgets_time_picker___lambda90__gtk_spin_button_output (GtkSpinButton* _sender,
                                                                  gpointer self)
{
	gboolean result;
	result = _granite_widgets_time_picker___lambda90_ ((GraniteWidgetsTimePicker*) self);
	return result;
}

static gboolean
_granite_widgets_time_picker___lambda91_ (GraniteWidgetsTimePicker* self)
{
	gboolean result;
	granite_widgets_time_picker_is_unfocused (self);
	result = FALSE;
	return result;
}

static gboolean
__granite_widgets_time_picker___lambda91__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                      GdkEventFocus* event,
                                                                      gpointer self)
{
	gboolean result;
	result = _granite_widgets_time_picker___lambda91_ ((GraniteWidgetsTimePicker*) self);
	return result;
}

static gboolean
_granite_widgets_time_picker___lambda92_ (GraniteWidgetsTimePicker* self,
                                          GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->direction) {
		case GDK_SCROLL_UP:
		case GDK_SCROLL_RIGHT:
		{
			GDateTime* _tmp0_;
			GDateTime* _tmp1_;
			_tmp0_ = self->priv->_time;
			_tmp1_ = g_date_time_add_minutes (_tmp0_, 1);
			_g_date_time_unref0 (self->priv->_time);
			self->priv->_time = _tmp1_;
			break;
		}
		case GDK_SCROLL_DOWN:
		case GDK_SCROLL_LEFT:
		{
			GDateTime* _tmp2_;
			GDateTime* _tmp3_;
			_tmp2_ = self->priv->_time;
			_tmp3_ = g_date_time_add_minutes (_tmp2_, -1);
			_g_date_time_unref0 (self->priv->_time);
			self->priv->_time = _tmp3_;
			break;
		}
		default:
		{
			break;
		}
	}
	granite_widgets_time_picker_update_text (self, FALSE);
	result = FALSE;
	return result;
}

static gboolean
__granite_widgets_time_picker___lambda92__gtk_widget_scroll_event (GtkWidget* _sender,
                                                                   GdkEventScroll* event,
                                                                   gpointer self)
{
	gboolean result;
	result = _granite_widgets_time_picker___lambda92_ ((GraniteWidgetsTimePicker*) self, event);
	return result;
}

static void
_granite_widgets_time_picker_is_unfocused_gtk_entry_activate (GtkEntry* _sender,
                                                              gpointer self)
{
	granite_widgets_time_picker_is_unfocused ((GraniteWidgetsTimePicker*) self);
}

static GObject *
granite_widgets_time_picker_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsTimePicker * self;
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	GThemedIcon* _tmp6_;
	GThemedIcon* _tmp7_;
	GraniteWidgetsModeButton* _tmp8_ = NULL;
	GraniteWidgetsModeButton* _tmp9_;
	GraniteWidgetsModeButton* _tmp10_;
	GraniteWidgetsModeButton* _tmp11_;
	GtkSpinButton* _tmp14_;
	GtkSpinButton* _tmp15_;
	GtkSpinButton* _tmp16_;
	GtkSpinButton* _tmp17_;
	GtkSpinButton* _tmp18_;
	GtkSpinButton* _tmp19_;
	GtkSpinButton* _tmp20_;
	GtkSpinButton* _tmp21_;
	GtkLabel* separation_label = NULL;
	GtkLabel* _tmp22_;
	GtkGrid* pop_grid = NULL;
	GtkGrid* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	GtkGrid* _tmp26_;
	GtkSpinButton* _tmp27_;
	GtkGrid* _tmp28_;
	GtkLabel* _tmp29_;
	GtkGrid* _tmp30_;
	GtkSpinButton* _tmp31_;
	GtkGrid* _tmp32_;
	GraniteWidgetsModeButton* _tmp33_;
	GtkGrid* _tmp34_;
	GtkPopover* _tmp35_;
	GtkPopover* _tmp36_;
	GtkPopover* _tmp37_;
	GtkGrid* _tmp38_;
	parent_class = G_OBJECT_CLASS (granite_widgets_time_picker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_TIME_PICKER, GraniteWidgetsTimePicker);
	_tmp0_ = self->priv->_format_12;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = granite_date_time_get_default_time_format (TRUE, FALSE);
		_tmp2_ = _tmp1_;
		granite_widgets_time_picker_set_format_12 (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = self->priv->_format_24;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = granite_date_time_get_default_time_format (FALSE, FALSE);
		_tmp5_ = _tmp4_;
		granite_widgets_time_picker_set_format_24 (self, _tmp5_);
		_g_free0 (_tmp5_);
	}
	gtk_entry_set_max_length ((GtkEntry*) self, 8);
	_tmp6_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("appointment-symbolic");
	_tmp7_ = _tmp6_;
	g_object_set ((GtkEntry*) self, "secondary-icon-gicon", (GIcon*) _tmp7_, NULL);
	_g_object_unref0 (_tmp7_);
	g_signal_connect_object ((GtkEntry*) self, "icon-release", (GCallback) _granite_widgets_time_picker_on_icon_press_gtk_entry_icon_release, self, 0);
	_tmp8_ = granite_widgets_mode_button_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp8_, GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp8_, TRUE);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->am_pm_modebutton);
	self->priv->am_pm_modebutton = _tmp8_;
	_tmp9_ = self->priv->am_pm_modebutton;
	granite_widgets_mode_button_append_text (_tmp9_, _ ("AM"));
	_tmp10_ = self->priv->am_pm_modebutton;
	granite_widgets_mode_button_append_text (_tmp10_, _ ("PM"));
	_tmp11_ = self->priv->am_pm_modebutton;
	g_signal_connect_object (_tmp11_, "mode-changed", (GCallback) __granite_widgets_time_picker___lambda87__granite_widgets_mode_button_mode_changed, self, 0);
	if (granite_date_time_is_clock_format_12h ()) {
		GtkSpinButton* _tmp12_;
		_tmp12_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 12, (gdouble) 1);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->priv->hours_spinbutton);
		self->priv->hours_spinbutton = _tmp12_;
	} else {
		GtkSpinButton* _tmp13_;
		_tmp13_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 23, (gdouble) 1);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (self->priv->hours_spinbutton);
		self->priv->hours_spinbutton = _tmp13_;
	}
	_tmp14_ = self->priv->hours_spinbutton;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp14_, GTK_ORIENTATION_VERTICAL);
	_tmp15_ = self->priv->hours_spinbutton;
	gtk_spin_button_set_wrap (_tmp15_, TRUE);
	_tmp16_ = self->priv->hours_spinbutton;
	g_signal_connect_object (_tmp16_, "value-changed", (GCallback) __granite_widgets_time_picker___lambda88__gtk_spin_button_value_changed, self, 0);
	_tmp17_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 59, (gdouble) 1);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->minutes_spinbutton);
	self->priv->minutes_spinbutton = _tmp17_;
	_tmp18_ = self->priv->minutes_spinbutton;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp18_, GTK_ORIENTATION_VERTICAL);
	_tmp19_ = self->priv->minutes_spinbutton;
	gtk_spin_button_set_wrap (_tmp19_, TRUE);
	_tmp20_ = self->priv->minutes_spinbutton;
	g_signal_connect_object (_tmp20_, "value-changed", (GCallback) __granite_widgets_time_picker___lambda89__gtk_spin_button_value_changed, self, 0);
	_tmp21_ = self->priv->minutes_spinbutton;
	g_signal_connect_object (_tmp21_, "output", (GCallback) __granite_widgets_time_picker___lambda90__gtk_spin_button_output, self, 0);
	_tmp22_ = (GtkLabel*) gtk_label_new (_ (":"));
	g_object_ref_sink (_tmp22_);
	separation_label = _tmp22_;
	_tmp23_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp23_);
	pop_grid = _tmp23_;
	_tmp24_ = pop_grid;
	gtk_grid_set_column_spacing (_tmp24_, 6);
	_tmp25_ = pop_grid;
	gtk_grid_set_row_spacing (_tmp25_, 6);
	_tmp26_ = pop_grid;
	_tmp27_ = self->priv->hours_spinbutton;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 0, 0, 1, 1);
	_tmp28_ = pop_grid;
	_tmp29_ = separation_label;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 1, 0, 1, 1);
	_tmp30_ = pop_grid;
	_tmp31_ = self->priv->minutes_spinbutton;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 2, 0, 1, 1);
	_tmp32_ = pop_grid;
	_tmp33_ = self->priv->am_pm_modebutton;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 3, 0, 1, 1);
	_tmp34_ = pop_grid;
	g_object_set ((GtkWidget*) _tmp34_, "margin", 6, NULL);
	_tmp35_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp35_;
	_tmp36_ = self->priv->popover;
	gtk_popover_set_position (_tmp36_, GTK_POS_BOTTOM);
	_tmp37_ = self->priv->popover;
	_tmp38_ = pop_grid;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_FOCUS_CHANGE_MASK | GDK_SCROLL_MASK));
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) __granite_widgets_time_picker___lambda91__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "scroll-event", (GCallback) __granite_widgets_time_picker___lambda92__gtk_widget_scroll_event, self, 0);
	g_signal_connect_object ((GtkEntry*) self, "activate", (GCallback) _granite_widgets_time_picker_is_unfocused_gtk_entry_activate, self, 0);
	granite_widgets_time_picker_update_text (self, FALSE);
	_g_object_unref0 (pop_grid);
	_g_object_unref0 (separation_label);
	return obj;
}

static void
granite_widgets_time_picker_class_init (GraniteWidgetsTimePickerClass * klass,
                                        gpointer klass_data)
{
	granite_widgets_time_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsTimePicker_private_offset);
	((GraniteWidgetsTimePickerClass *) klass)->position_dropdown = (void (*) (GraniteWidgetsTimePicker*, gint*, gint*)) granite_widgets_time_picker_real_position_dropdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_time_picker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_time_picker_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_time_picker_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_time_picker_finalize;
	/**
	         * Format used in 12h mode
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_TIME_PICKER_FORMAT_12_PROPERTY, granite_widgets_time_picker_properties[GRANITE_WIDGETS_TIME_PICKER_FORMAT_12_PROPERTY] = g_param_spec_string ("format-12", "format-12", "format-12", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * Format used in 24h mode
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_TIME_PICKER_FORMAT_24_PROPERTY, granite_widgets_time_picker_properties[GRANITE_WIDGETS_TIME_PICKER_FORMAT_24_PROPERTY] = g_param_spec_string ("format-24", "format-24", "format-24", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * Current time
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_TIME_PICKER_TIME_PROPERTY, granite_widgets_time_picker_properties[GRANITE_WIDGETS_TIME_PICKER_TIME_PROPERTY] = g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Sent when the time got changed
	         */
	granite_widgets_time_picker_signals[GRANITE_WIDGETS_TIME_PICKER_TIME_CHANGED_SIGNAL] = g_signal_new ("time-changed", GRANITE_WIDGETS_TYPE_TIME_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	granite_init ();
}

static void
granite_widgets_time_picker_instance_init (GraniteWidgetsTimePicker * self,
                                           gpointer klass)
{
	gchar* _tmp0_;
	self->priv = granite_widgets_time_picker_get_instance_private (self);
	self->priv->_time = NULL;
	self->priv->changing_time = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->old_string = _tmp0_;
}

static void
granite_widgets_time_picker_finalize (GObject * obj)
{
	GraniteWidgetsTimePicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_TIME_PICKER, GraniteWidgetsTimePicker);
	_g_free0 (self->priv->_format_12);
	_g_free0 (self->priv->_format_24);
	_g_date_time_unref0 (self->priv->_time);
	_g_free0 (self->priv->old_string);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->hours_spinbutton);
	_g_object_unref0 (self->priv->minutes_spinbutton);
	_g_object_unref0 (self->priv->am_pm_modebutton);
	G_OBJECT_CLASS (granite_widgets_time_picker_parent_class)->finalize (obj);
}

/**
     * This widget allows users to easily pick a time.
     */
static GType
granite_widgets_time_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsTimePickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_time_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsTimePicker), 0, (GInstanceInitFunc) granite_widgets_time_picker_instance_init, NULL };
	GType granite_widgets_time_picker_type_id;
	granite_widgets_time_picker_type_id = g_type_register_static (gtk_entry_get_type (), "GraniteWidgetsTimePicker", &g_define_type_info, 0);
	GraniteWidgetsTimePicker_private_offset = g_type_add_instance_private (granite_widgets_time_picker_type_id, sizeof (GraniteWidgetsTimePickerPrivate));
	return granite_widgets_time_picker_type_id;
}

GType
granite_widgets_time_picker_get_type (void)
{
	static volatile gsize granite_widgets_time_picker_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_time_picker_type_id__once)) {
		GType granite_widgets_time_picker_type_id;
		granite_widgets_time_picker_type_id = granite_widgets_time_picker_get_type_once ();
		g_once_init_leave (&granite_widgets_time_picker_type_id__once, granite_widgets_time_picker_type_id);
	}
	return granite_widgets_time_picker_type_id__once;
}

static void
_vala_granite_widgets_time_picker_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsTimePicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_TIME_PICKER, GraniteWidgetsTimePicker);
	switch (property_id) {
		case GRANITE_WIDGETS_TIME_PICKER_FORMAT_12_PROPERTY:
		g_value_set_string (value, granite_widgets_time_picker_get_format_12 (self));
		break;
		case GRANITE_WIDGETS_TIME_PICKER_FORMAT_24_PROPERTY:
		g_value_set_string (value, granite_widgets_time_picker_get_format_24 (self));
		break;
		case GRANITE_WIDGETS_TIME_PICKER_TIME_PROPERTY:
		g_value_set_boxed (value, granite_widgets_time_picker_get_time (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_time_picker_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GraniteWidgetsTimePicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_TIME_PICKER, GraniteWidgetsTimePicker);
	switch (property_id) {
		case GRANITE_WIDGETS_TIME_PICKER_FORMAT_12_PROPERTY:
		granite_widgets_time_picker_set_format_12 (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_TIME_PICKER_FORMAT_24_PROPERTY:
		granite_widgets_time_picker_set_format_24 (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_TIME_PICKER_TIME_PROPERTY:
		granite_widgets_time_picker_set_time (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

