/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "grl-dleyna-proxy-mediadevice.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__UINT_STRING_UINT64_UINT64 (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintStringUint64Uint64Func)
       (void *data1,
        guint arg_UploadId,
        const gchar *arg_UploadStatus,
        guint64 arg_Length,
        guint64 arg_Total,
        void *data2);
  _GDbusCodegenMarshalVoid_UintStringUint64Uint64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintStringUint64Uint64Func)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_uint64 (param_values + 3),
            g_marshal_value_peek_uint64 (param_values + 4),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_DisplayName,
        const gchar *arg_FilePath,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_UploadId,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_DisplayName,
        const gchar *arg_Type,
        const gchar *const *arg_ChildTypes,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_boxed (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_Title,
        const gchar *arg_Creator,
        const gchar *arg_Genre,
        const gchar *arg_Description,
        const gchar *const *arg_PlaylistItems,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringStringBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_boxed (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_Objects,
        const gchar *const *arg_Filter,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              g_marshal_value_peek_boxed (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface com.intel.dLeynaServer.MediaDevice
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GrlDleynaMediaDevice
 * @title: GrlDleynaMediaDevice
 * @short_description: Generated C code for the com.intel.dLeynaServer.MediaDevice D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-com-intel-dLeynaServer-MediaDevice.top_of_page">com.intel.dLeynaServer.MediaDevice</link> D-Bus interface in C.
 */

enum
{
  GRL_DLEYNA__MEDIA_DEVICE_CONTAINER_UPDATE_IDS,
  GRL_DLEYNA__MEDIA_DEVICE_LAST_CHANGE,
  GRL_DLEYNA__MEDIA_DEVICE_CHANGED,
  GRL_DLEYNA__MEDIA_DEVICE_UPLOAD_UPDATE,
};

static unsigned GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[4] = { 0 };

/* ---- Introspection data for com.intel.dLeynaServer.MediaDevice ---- */

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_upload_to_any_container_IN_ARG_DisplayName =
{
  {
    -1,
    (gchar *) "DisplayName",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_upload_to_any_container_IN_ARG_FilePath =
{
  {
    -1,
    (gchar *) "FilePath",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_upload_to_any_container_IN_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_upload_to_any_container_IN_ARG_DisplayName.parent_struct,
  &_grl_dleyna_media_device_method_info_upload_to_any_container_IN_ARG_FilePath.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_upload_to_any_container_OUT_ARG_UploadId =
{
  {
    -1,
    (gchar *) "UploadId",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_upload_to_any_container_OUT_ARG_Path =
{
  {
    -1,
    (gchar *) "Path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_upload_to_any_container_OUT_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_upload_to_any_container_OUT_ARG_UploadId.parent_struct,
  &_grl_dleyna_media_device_method_info_upload_to_any_container_OUT_ARG_Path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_upload_to_any_container =
{
  {
    -1,
    (gchar *) "UploadToAnyContainer",
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_upload_to_any_container_IN_ARG_pointers,
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_upload_to_any_container_OUT_ARG_pointers,
    NULL
  },
  "handle-upload-to-any-container",
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_get_upload_status_IN_ARG_UploadId =
{
  {
    -1,
    (gchar *) "UploadId",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_get_upload_status_IN_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_get_upload_status_IN_ARG_UploadId.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_UploadStatus =
{
  {
    -1,
    (gchar *) "UploadStatus",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_Length =
{
  {
    -1,
    (gchar *) "Length",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_Total =
{
  {
    -1,
    (gchar *) "Total",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_UploadStatus.parent_struct,
  &_grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_Length.parent_struct,
  &_grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_Total.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_get_upload_status =
{
  {
    -1,
    (gchar *) "GetUploadStatus",
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_get_upload_status_IN_ARG_pointers,
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_get_upload_status_OUT_ARG_pointers,
    NULL
  },
  "handle-get-upload-status",
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_get_upload_ids_OUT_ARG_Total =
{
  {
    -1,
    (gchar *) "Total",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_get_upload_ids_OUT_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_get_upload_ids_OUT_ARG_Total.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_get_upload_ids =
{
  {
    -1,
    (gchar *) "GetUploadIDs",
    NULL,
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_get_upload_ids_OUT_ARG_pointers,
    NULL
  },
  "handle-get-upload-ids",
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_cancel_upload_IN_ARG_UploadId =
{
  {
    -1,
    (gchar *) "UploadId",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_cancel_upload_IN_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_cancel_upload_IN_ARG_UploadId.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_cancel_upload =
{
  {
    -1,
    (gchar *) "CancelUpload",
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_cancel_upload_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-cancel-upload",
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_DisplayName =
{
  {
    -1,
    (gchar *) "DisplayName",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_Type =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_ChildTypes =
{
  {
    -1,
    (gchar *) "ChildTypes",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_DisplayName.parent_struct,
  &_grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_Type.parent_struct,
  &_grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_ChildTypes.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_container_in_any_container_OUT_ARG_Path =
{
  {
    -1,
    (gchar *) "Path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_create_container_in_any_container_OUT_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_create_container_in_any_container_OUT_ARG_Path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_create_container_in_any_container =
{
  {
    -1,
    (gchar *) "CreateContainerInAnyContainer",
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_create_container_in_any_container_IN_ARG_pointers,
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_create_container_in_any_container_OUT_ARG_pointers,
    NULL
  },
  "handle-create-container-in-any-container",
  FALSE
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_cancel =
{
  {
    -1,
    (gchar *) "Cancel",
    NULL,
    NULL,
    NULL
  },
  "handle-cancel",
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Title =
{
  {
    -1,
    (gchar *) "Title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Creator =
{
  {
    -1,
    (gchar *) "Creator",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Genre =
{
  {
    -1,
    (gchar *) "Genre",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Description =
{
  {
    -1,
    (gchar *) "Description",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_PlaylistItems =
{
  {
    -1,
    (gchar *) "PlaylistItems",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Title.parent_struct,
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Creator.parent_struct,
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Genre.parent_struct,
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_Description.parent_struct,
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_PlaylistItems.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container_OUT_ARG_UploadId =
{
  {
    -1,
    (gchar *) "UploadId",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container_OUT_ARG_Path =
{
  {
    -1,
    (gchar *) "Path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_create_playlist_in_any_container_OUT_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_OUT_ARG_UploadId.parent_struct,
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_OUT_ARG_Path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_create_playlist_in_any_container =
{
  {
    -1,
    (gchar *) "CreatePlaylistInAnyContainer",
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_IN_ARG_pointers,
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_create_playlist_in_any_container_OUT_ARG_pointers,
    NULL
  },
  "handle-create-playlist-in-any-container",
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_browse_objects_IN_ARG_Objects =
{
  {
    -1,
    (gchar *) "Objects",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_browse_objects_IN_ARG_Filter =
{
  {
    -1,
    (gchar *) "Filter",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_browse_objects_IN_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_browse_objects_IN_ARG_Objects.parent_struct,
  &_grl_dleyna_media_device_method_info_browse_objects_IN_ARG_Filter.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_method_info_browse_objects_OUT_ARG_Children =
{
  {
    -1,
    (gchar *) "Children",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_method_info_browse_objects_OUT_ARG_pointers[] =
{
  &_grl_dleyna_media_device_method_info_browse_objects_OUT_ARG_Children.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grl_dleyna_media_device_method_info_browse_objects =
{
  {
    -1,
    (gchar *) "BrowseObjects",
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_browse_objects_IN_ARG_pointers,
    (GDBusArgInfo **) &_grl_dleyna_media_device_method_info_browse_objects_OUT_ARG_pointers,
    NULL
  },
  "handle-browse-objects",
  FALSE
};

static const GDBusMethodInfo * const _grl_dleyna_media_device_method_info_pointers[] =
{
  &_grl_dleyna_media_device_method_info_upload_to_any_container.parent_struct,
  &_grl_dleyna_media_device_method_info_get_upload_status.parent_struct,
  &_grl_dleyna_media_device_method_info_get_upload_ids.parent_struct,
  &_grl_dleyna_media_device_method_info_cancel_upload.parent_struct,
  &_grl_dleyna_media_device_method_info_create_container_in_any_container.parent_struct,
  &_grl_dleyna_media_device_method_info_cancel.parent_struct,
  &_grl_dleyna_media_device_method_info_create_playlist_in_any_container.parent_struct,
  &_grl_dleyna_media_device_method_info_browse_objects.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_signal_info_container_update_ids_ARG_ContainerPathsIDs =
{
  {
    -1,
    (gchar *) "ContainerPathsIDs",
    (gchar *) "a(ou)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_signal_info_container_update_ids_ARG_pointers[] =
{
  &_grl_dleyna_media_device_signal_info_container_update_ids_ARG_ContainerPathsIDs.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _grl_dleyna_media_device_signal_info_container_update_ids =
{
  {
    -1,
    (gchar *) "ContainerUpdateIDs",
    (GDBusArgInfo **) &_grl_dleyna_media_device_signal_info_container_update_ids_ARG_pointers,
    NULL
  },
  "container-update-ids"
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_signal_info_last_change_ARG_StateEvent =
{
  {
    -1,
    (gchar *) "StateEvent",
    (gchar *) "a(sv)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_signal_info_last_change_ARG_pointers[] =
{
  &_grl_dleyna_media_device_signal_info_last_change_ARG_StateEvent.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _grl_dleyna_media_device_signal_info_last_change =
{
  {
    -1,
    (gchar *) "LastChange",
    (GDBusArgInfo **) &_grl_dleyna_media_device_signal_info_last_change_ARG_pointers,
    NULL
  },
  "last-change"
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_signal_info_changed_ARG_ChangedObjects =
{
  {
    -1,
    (gchar *) "ChangedObjects",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_signal_info_changed_ARG_pointers[] =
{
  &_grl_dleyna_media_device_signal_info_changed_ARG_ChangedObjects.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _grl_dleyna_media_device_signal_info_changed =
{
  {
    -1,
    (gchar *) "Changed",
    (GDBusArgInfo **) &_grl_dleyna_media_device_signal_info_changed_ARG_pointers,
    NULL
  },
  "changed"
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_signal_info_upload_update_ARG_UploadId =
{
  {
    -1,
    (gchar *) "UploadId",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_signal_info_upload_update_ARG_UploadStatus =
{
  {
    -1,
    (gchar *) "UploadStatus",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_signal_info_upload_update_ARG_Length =
{
  {
    -1,
    (gchar *) "Length",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _grl_dleyna_media_device_signal_info_upload_update_ARG_Total =
{
  {
    -1,
    (gchar *) "Total",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grl_dleyna_media_device_signal_info_upload_update_ARG_pointers[] =
{
  &_grl_dleyna_media_device_signal_info_upload_update_ARG_UploadId.parent_struct,
  &_grl_dleyna_media_device_signal_info_upload_update_ARG_UploadStatus.parent_struct,
  &_grl_dleyna_media_device_signal_info_upload_update_ARG_Length.parent_struct,
  &_grl_dleyna_media_device_signal_info_upload_update_ARG_Total.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _grl_dleyna_media_device_signal_info_upload_update =
{
  {
    -1,
    (gchar *) "UploadUpdate",
    (GDBusArgInfo **) &_grl_dleyna_media_device_signal_info_upload_update_ARG_pointers,
    NULL
  },
  "upload-update"
};

static const GDBusSignalInfo * const _grl_dleyna_media_device_signal_info_pointers[] =
{
  &_grl_dleyna_media_device_signal_info_container_update_ids.parent_struct,
  &_grl_dleyna_media_device_signal_info_last_change.parent_struct,
  &_grl_dleyna_media_device_signal_info_changed.parent_struct,
  &_grl_dleyna_media_device_signal_info_upload_update.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_location =
{
  {
    -1,
    (gchar *) "Location",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_udn =
{
  {
    -1,
    (gchar *) "UDN",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "udn",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_device_type =
{
  {
    -1,
    (gchar *) "DeviceType",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_friendly_name =
{
  {
    -1,
    (gchar *) "FriendlyName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "friendly-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_manufacturer =
{
  {
    -1,
    (gchar *) "Manufacturer",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "manufacturer",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_manufacturer_url =
{
  {
    -1,
    (gchar *) "ManufacturerUrl",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "manufacturer-url",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_model_description =
{
  {
    -1,
    (gchar *) "ModelDescription",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model-description",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_model_name =
{
  {
    -1,
    (gchar *) "ModelName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_model_number =
{
  {
    -1,
    (gchar *) "ModelNumber",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model-number",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_model_url =
{
  {
    -1,
    (gchar *) "ModelURL",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model-url",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_serial_number =
{
  {
    -1,
    (gchar *) "SerialNumber",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "serial-number",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_presentation_url =
{
  {
    -1,
    (gchar *) "PresentationURL",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "presentation-url",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_icon_url =
{
  {
    -1,
    (gchar *) "IconURL",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-url",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_dlnacaps =
{
  {
    -1,
    (gchar *) "DLNACaps",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "dlnacaps",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_search_caps =
{
  {
    -1,
    (gchar *) "SearchCaps",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "search-caps",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_sort_caps =
{
  {
    -1,
    (gchar *) "SortCaps",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sort-caps",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_sort_ext_caps =
{
  {
    -1,
    (gchar *) "SortExtCaps",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sort-ext-caps",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_feature_list =
{
  {
    -1,
    (gchar *) "FeatureList",
    (gchar *) "a(ssao)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "feature-list",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_system_update_id =
{
  {
    -1,
    (gchar *) "SystemUpdateID",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "system-update-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grl_dleyna_media_device_property_info_service_reset_token =
{
  {
    -1,
    (gchar *) "ServiceResetToken",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "service-reset-token",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _grl_dleyna_media_device_property_info_pointers[] =
{
  &_grl_dleyna_media_device_property_info_location.parent_struct,
  &_grl_dleyna_media_device_property_info_udn.parent_struct,
  &_grl_dleyna_media_device_property_info_device_type.parent_struct,
  &_grl_dleyna_media_device_property_info_friendly_name.parent_struct,
  &_grl_dleyna_media_device_property_info_manufacturer.parent_struct,
  &_grl_dleyna_media_device_property_info_manufacturer_url.parent_struct,
  &_grl_dleyna_media_device_property_info_model_description.parent_struct,
  &_grl_dleyna_media_device_property_info_model_name.parent_struct,
  &_grl_dleyna_media_device_property_info_model_number.parent_struct,
  &_grl_dleyna_media_device_property_info_model_url.parent_struct,
  &_grl_dleyna_media_device_property_info_serial_number.parent_struct,
  &_grl_dleyna_media_device_property_info_presentation_url.parent_struct,
  &_grl_dleyna_media_device_property_info_icon_url.parent_struct,
  &_grl_dleyna_media_device_property_info_dlnacaps.parent_struct,
  &_grl_dleyna_media_device_property_info_search_caps.parent_struct,
  &_grl_dleyna_media_device_property_info_sort_caps.parent_struct,
  &_grl_dleyna_media_device_property_info_sort_ext_caps.parent_struct,
  &_grl_dleyna_media_device_property_info_feature_list.parent_struct,
  &_grl_dleyna_media_device_property_info_system_update_id.parent_struct,
  &_grl_dleyna_media_device_property_info_service_reset_token.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _grl_dleyna_media_device_interface_info =
{
  {
    -1,
    (gchar *) "com.intel.dLeynaServer.MediaDevice",
    (GDBusMethodInfo **) &_grl_dleyna_media_device_method_info_pointers,
    (GDBusSignalInfo **) &_grl_dleyna_media_device_signal_info_pointers,
    (GDBusPropertyInfo **) &_grl_dleyna_media_device_property_info_pointers,
    NULL
  },
  "media-device",
};


/**
 * grl_dleyna_media_device_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-com-intel-dLeynaServer-MediaDevice.top_of_page">com.intel.dLeynaServer.MediaDevice</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
grl_dleyna_media_device_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_grl_dleyna_media_device_interface_info.parent_struct;
}

/**
 * grl_dleyna_media_device_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GrlDleynaMediaDevice interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
grl_dleyna_media_device_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "location");
  g_object_class_override_property (klass, property_id_begin++, "udn");
  g_object_class_override_property (klass, property_id_begin++, "device-type");
  g_object_class_override_property (klass, property_id_begin++, "friendly-name");
  g_object_class_override_property (klass, property_id_begin++, "manufacturer");
  g_object_class_override_property (klass, property_id_begin++, "manufacturer-url");
  g_object_class_override_property (klass, property_id_begin++, "model-description");
  g_object_class_override_property (klass, property_id_begin++, "model-name");
  g_object_class_override_property (klass, property_id_begin++, "model-number");
  g_object_class_override_property (klass, property_id_begin++, "model-url");
  g_object_class_override_property (klass, property_id_begin++, "serial-number");
  g_object_class_override_property (klass, property_id_begin++, "presentation-url");
  g_object_class_override_property (klass, property_id_begin++, "icon-url");
  g_object_class_override_property (klass, property_id_begin++, "dlnacaps");
  g_object_class_override_property (klass, property_id_begin++, "search-caps");
  g_object_class_override_property (klass, property_id_begin++, "sort-caps");
  g_object_class_override_property (klass, property_id_begin++, "sort-ext-caps");
  g_object_class_override_property (klass, property_id_begin++, "feature-list");
  g_object_class_override_property (klass, property_id_begin++, "system-update-id");
  g_object_class_override_property (klass, property_id_begin++, "service-reset-token");
  return property_id_begin - 1;
}


inline static void
grl_dleyna_media_device_signal_marshal_container_update_ids (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_signal_marshal_last_change (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_signal_marshal_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_signal_marshal_upload_update (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_STRING_UINT64_UINT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_upload_to_any_container (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_get_upload_status (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_get_upload_ids (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_cancel_upload (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_create_container_in_any_container (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_cancel (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_create_playlist_in_any_container (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
grl_dleyna_media_device_method_marshal_browse_objects (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GrlDleynaMediaDevice:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-com-intel-dLeynaServer-MediaDevice.top_of_page">com.intel.dLeynaServer.MediaDevice</link>.
 */

/**
 * GrlDleynaMediaDeviceIface:
 * @parent_iface: The parent interface.
 * @handle_browse_objects: Handler for the #GrlDleynaMediaDevice::handle-browse-objects signal.
 * @handle_cancel: Handler for the #GrlDleynaMediaDevice::handle-cancel signal.
 * @handle_cancel_upload: Handler for the #GrlDleynaMediaDevice::handle-cancel-upload signal.
 * @handle_create_container_in_any_container: Handler for the #GrlDleynaMediaDevice::handle-create-container-in-any-container signal.
 * @handle_create_playlist_in_any_container: Handler for the #GrlDleynaMediaDevice::handle-create-playlist-in-any-container signal.
 * @handle_get_upload_ids: Handler for the #GrlDleynaMediaDevice::handle-get-upload-ids signal.
 * @handle_get_upload_status: Handler for the #GrlDleynaMediaDevice::handle-get-upload-status signal.
 * @handle_upload_to_any_container: Handler for the #GrlDleynaMediaDevice::handle-upload-to-any-container signal.
 * @get_device_type: Getter for the #GrlDleynaMediaDevice:device-type property.
 * @get_dlnacaps: Getter for the #GrlDleynaMediaDevice:dlnacaps property.
 * @get_feature_list: Getter for the #GrlDleynaMediaDevice:feature-list property.
 * @get_friendly_name: Getter for the #GrlDleynaMediaDevice:friendly-name property.
 * @get_icon_url: Getter for the #GrlDleynaMediaDevice:icon-url property.
 * @get_location: Getter for the #GrlDleynaMediaDevice:location property.
 * @get_manufacturer: Getter for the #GrlDleynaMediaDevice:manufacturer property.
 * @get_manufacturer_url: Getter for the #GrlDleynaMediaDevice:manufacturer-url property.
 * @get_model_description: Getter for the #GrlDleynaMediaDevice:model-description property.
 * @get_model_name: Getter for the #GrlDleynaMediaDevice:model-name property.
 * @get_model_number: Getter for the #GrlDleynaMediaDevice:model-number property.
 * @get_model_url: Getter for the #GrlDleynaMediaDevice:model-url property.
 * @get_presentation_url: Getter for the #GrlDleynaMediaDevice:presentation-url property.
 * @get_search_caps: Getter for the #GrlDleynaMediaDevice:search-caps property.
 * @get_serial_number: Getter for the #GrlDleynaMediaDevice:serial-number property.
 * @get_service_reset_token: Getter for the #GrlDleynaMediaDevice:service-reset-token property.
 * @get_sort_caps: Getter for the #GrlDleynaMediaDevice:sort-caps property.
 * @get_sort_ext_caps: Getter for the #GrlDleynaMediaDevice:sort-ext-caps property.
 * @get_system_update_id: Getter for the #GrlDleynaMediaDevice:system-update-id property.
 * @get_udn: Getter for the #GrlDleynaMediaDevice:udn property.
 * @changed: Handler for the #GrlDleynaMediaDevice::changed signal.
 * @container_update_ids: Handler for the #GrlDleynaMediaDevice::container-update-ids signal.
 * @last_change: Handler for the #GrlDleynaMediaDevice::last-change signal.
 * @upload_update: Handler for the #GrlDleynaMediaDevice::upload-update signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-com-intel-dLeynaServer-MediaDevice.top_of_page">com.intel.dLeynaServer.MediaDevice</link>.
 */

typedef GrlDleynaMediaDeviceIface GrlDleynaMediaDeviceInterface;
G_DEFINE_INTERFACE (GrlDleynaMediaDevice, grl_dleyna_media_device, G_TYPE_OBJECT)

static void
grl_dleyna_media_device_default_init (GrlDleynaMediaDeviceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GrlDleynaMediaDevice::handle-upload-to-any-container:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_DisplayName: Argument passed by remote caller.
   * @arg_FilePath: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.UploadToAnyContainer">UploadToAnyContainer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_upload_to_any_container() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-upload-to-any-container",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_upload_to_any_container),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_upload_to_any_container,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GrlDleynaMediaDevice::handle-get-upload-status:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_UploadId: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadStatus">GetUploadStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_get_upload_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-upload-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_get_upload_status),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_get_upload_status,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * GrlDleynaMediaDevice::handle-get-upload-ids:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadIDs">GetUploadIDs()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_get_upload_ids() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-upload-ids",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_get_upload_ids),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_get_upload_ids,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GrlDleynaMediaDevice::handle-cancel-upload:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_UploadId: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CancelUpload">CancelUpload()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_cancel_upload() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel-upload",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_cancel_upload),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_cancel_upload,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * GrlDleynaMediaDevice::handle-create-container-in-any-container:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_DisplayName: Argument passed by remote caller.
   * @arg_Type: Argument passed by remote caller.
   * @arg_ChildTypes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreateContainerInAnyContainer">CreateContainerInAnyContainer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_create_container_in_any_container() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-container-in-any-container",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_create_container_in_any_container),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_create_container_in_any_container,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * GrlDleynaMediaDevice::handle-cancel:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.Cancel">Cancel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_cancel() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_cancel),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_cancel,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GrlDleynaMediaDevice::handle-create-playlist-in-any-container:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Title: Argument passed by remote caller.
   * @arg_Creator: Argument passed by remote caller.
   * @arg_Genre: Argument passed by remote caller.
   * @arg_Description: Argument passed by remote caller.
   * @arg_PlaylistItems: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreatePlaylistInAnyContainer">CreatePlaylistInAnyContainer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_create_playlist_in_any_container() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-playlist-in-any-container",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_create_playlist_in_any_container),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_create_playlist_in_any_container,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * GrlDleynaMediaDevice::handle-browse-objects:
   * @object: A #GrlDleynaMediaDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Objects: Argument passed by remote caller.
   * @arg_Filter: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.BrowseObjects">BrowseObjects()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grl_dleyna_media_device_complete_browse_objects() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-browse-objects",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, handle_browse_objects),
    g_signal_accumulator_true_handled,
    NULL,
      grl_dleyna_media_device_method_marshal_browse_objects,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRV);

  /* GObject signals for received D-Bus signals: */
  /**
   * GrlDleynaMediaDevice::container-update-ids:
   * @object: A #GrlDleynaMediaDevice.
   * @arg_ContainerPathsIDs: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.ContainerUpdateIDs">"ContainerUpdateIDs"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_CONTAINER_UPDATE_IDS] =
    g_signal_new ("container-update-ids",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, container_update_ids),
      NULL,
      NULL,
      grl_dleyna_media_device_signal_marshal_container_update_ids,
      G_TYPE_NONE,
      1, G_TYPE_VARIANT);

  /**
   * GrlDleynaMediaDevice::last-change:
   * @object: A #GrlDleynaMediaDevice.
   * @arg_StateEvent: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.LastChange">"LastChange"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_LAST_CHANGE] =
    g_signal_new ("last-change",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, last_change),
      NULL,
      NULL,
      grl_dleyna_media_device_signal_marshal_last_change,
      G_TYPE_NONE,
      1, G_TYPE_VARIANT);

  /**
   * GrlDleynaMediaDevice::changed:
   * @object: A #GrlDleynaMediaDevice.
   * @arg_ChangedObjects: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.Changed">"Changed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_CHANGED] =
    g_signal_new ("changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, changed),
      NULL,
      NULL,
      grl_dleyna_media_device_signal_marshal_changed,
      G_TYPE_NONE,
      1, G_TYPE_VARIANT);

  /**
   * GrlDleynaMediaDevice::upload-update:
   * @object: A #GrlDleynaMediaDevice.
   * @arg_UploadId: Argument.
   * @arg_UploadStatus: Argument.
   * @arg_Length: Argument.
   * @arg_Total: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.UploadUpdate">"UploadUpdate"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_UPLOAD_UPDATE] =
    g_signal_new ("upload-update",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GrlDleynaMediaDeviceIface, upload_update),
      NULL,
      NULL,
      grl_dleyna_media_device_signal_marshal_upload_update,
      G_TYPE_NONE,
      4, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT64, G_TYPE_UINT64);

  /* GObject properties for D-Bus properties: */
  /**
   * GrlDleynaMediaDevice:location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Location">"Location"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("location", "Location", "Location", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:udn:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.UDN">"UDN"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("udn", "UDN", "UDN", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:device-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DeviceType">"DeviceType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("device-type", "DeviceType", "DeviceType", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:friendly-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FriendlyName">"FriendlyName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("friendly-name", "FriendlyName", "FriendlyName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:manufacturer:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Manufacturer">"Manufacturer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("manufacturer", "Manufacturer", "Manufacturer", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:manufacturer-url:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ManufacturerUrl">"ManufacturerUrl"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("manufacturer-url", "ManufacturerUrl", "ManufacturerUrl", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:model-description:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelDescription">"ModelDescription"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("model-description", "ModelDescription", "ModelDescription", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:model-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelName">"ModelName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("model-name", "ModelName", "ModelName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:model-number:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelNumber">"ModelNumber"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("model-number", "ModelNumber", "ModelNumber", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:model-url:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelURL">"ModelURL"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("model-url", "ModelURL", "ModelURL", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:serial-number:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SerialNumber">"SerialNumber"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("serial-number", "SerialNumber", "SerialNumber", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:presentation-url:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.PresentationURL">"PresentationURL"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("presentation-url", "PresentationURL", "PresentationURL", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:icon-url:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.IconURL">"IconURL"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon-url", "IconURL", "IconURL", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:dlnacaps:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DLNACaps">"DLNACaps"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("dlnacaps", "DLNACaps", "DLNACaps", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:search-caps:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SearchCaps">"SearchCaps"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("search-caps", "SearchCaps", "SearchCaps", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:sort-caps:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortCaps">"SortCaps"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("sort-caps", "SortCaps", "SortCaps", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:sort-ext-caps:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortExtCaps">"SortExtCaps"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("sort-ext-caps", "SortExtCaps", "SortExtCaps", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:feature-list:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FeatureList">"FeatureList"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("feature-list", "FeatureList", "FeatureList", G_VARIANT_TYPE ("a(ssao)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:system-update-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SystemUpdateID">"SystemUpdateID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("system-update-id", "SystemUpdateID", "SystemUpdateID", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrlDleynaMediaDevice:service-reset-token:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ServiceResetToken">"ServiceResetToken"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("service-reset-token", "ServiceResetToken", "ServiceResetToken", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * grl_dleyna_media_device_get_location: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_location() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_location (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_location (object);
}

/**
 * grl_dleyna_media_device_dup_location: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_location (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "location", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_location: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Location">"Location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_location (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "location", value, NULL);
}

/**
 * grl_dleyna_media_device_get_udn: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.UDN">"UDN"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_udn() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_udn (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_udn (object);
}

/**
 * grl_dleyna_media_device_dup_udn: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.UDN">"UDN"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_udn (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "udn", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_udn: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.UDN">"UDN"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_udn (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "udn", value, NULL);
}

/**
 * grl_dleyna_media_device_get_device_type: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DeviceType">"DeviceType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_device_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_device_type (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_device_type (object);
}

/**
 * grl_dleyna_media_device_dup_device_type: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DeviceType">"DeviceType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_device_type (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "device-type", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_device_type: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DeviceType">"DeviceType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_device_type (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "device-type", value, NULL);
}

/**
 * grl_dleyna_media_device_get_friendly_name: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FriendlyName">"FriendlyName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_friendly_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_friendly_name (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_friendly_name (object);
}

/**
 * grl_dleyna_media_device_dup_friendly_name: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FriendlyName">"FriendlyName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_friendly_name (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "friendly-name", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_friendly_name: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FriendlyName">"FriendlyName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_friendly_name (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "friendly-name", value, NULL);
}

/**
 * grl_dleyna_media_device_get_manufacturer: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Manufacturer">"Manufacturer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_manufacturer() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_manufacturer (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_manufacturer (object);
}

/**
 * grl_dleyna_media_device_dup_manufacturer: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Manufacturer">"Manufacturer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_manufacturer (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "manufacturer", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_manufacturer: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.Manufacturer">"Manufacturer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_manufacturer (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "manufacturer", value, NULL);
}

/**
 * grl_dleyna_media_device_get_manufacturer_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ManufacturerUrl">"ManufacturerUrl"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_manufacturer_url() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_manufacturer_url (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_manufacturer_url (object);
}

/**
 * grl_dleyna_media_device_dup_manufacturer_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ManufacturerUrl">"ManufacturerUrl"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_manufacturer_url (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "manufacturer-url", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_manufacturer_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ManufacturerUrl">"ManufacturerUrl"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_manufacturer_url (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "manufacturer-url", value, NULL);
}

/**
 * grl_dleyna_media_device_get_model_description: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelDescription">"ModelDescription"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_model_description() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_model_description (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_model_description (object);
}

/**
 * grl_dleyna_media_device_dup_model_description: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelDescription">"ModelDescription"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_model_description (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "model-description", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_model_description: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelDescription">"ModelDescription"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_model_description (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "model-description", value, NULL);
}

/**
 * grl_dleyna_media_device_get_model_name: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelName">"ModelName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_model_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_model_name (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_model_name (object);
}

/**
 * grl_dleyna_media_device_dup_model_name: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelName">"ModelName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_model_name (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "model-name", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_model_name: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelName">"ModelName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_model_name (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "model-name", value, NULL);
}

/**
 * grl_dleyna_media_device_get_model_number: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelNumber">"ModelNumber"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_model_number() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_model_number (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_model_number (object);
}

/**
 * grl_dleyna_media_device_dup_model_number: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelNumber">"ModelNumber"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_model_number (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "model-number", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_model_number: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelNumber">"ModelNumber"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_model_number (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "model-number", value, NULL);
}

/**
 * grl_dleyna_media_device_get_model_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelURL">"ModelURL"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_model_url() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_model_url (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_model_url (object);
}

/**
 * grl_dleyna_media_device_dup_model_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelURL">"ModelURL"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_model_url (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "model-url", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_model_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ModelURL">"ModelURL"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_model_url (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "model-url", value, NULL);
}

/**
 * grl_dleyna_media_device_get_serial_number: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SerialNumber">"SerialNumber"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_serial_number() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_serial_number (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_serial_number (object);
}

/**
 * grl_dleyna_media_device_dup_serial_number: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SerialNumber">"SerialNumber"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_serial_number (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "serial-number", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_serial_number: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SerialNumber">"SerialNumber"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_serial_number (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "serial-number", value, NULL);
}

/**
 * grl_dleyna_media_device_get_presentation_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.PresentationURL">"PresentationURL"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_presentation_url() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_presentation_url (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_presentation_url (object);
}

/**
 * grl_dleyna_media_device_dup_presentation_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.PresentationURL">"PresentationURL"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_presentation_url (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "presentation-url", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_presentation_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.PresentationURL">"PresentationURL"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_presentation_url (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "presentation-url", value, NULL);
}

/**
 * grl_dleyna_media_device_get_icon_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.IconURL">"IconURL"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_icon_url() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_icon_url (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_icon_url (object);
}

/**
 * grl_dleyna_media_device_dup_icon_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.IconURL">"IconURL"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_icon_url (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon-url", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_icon_url: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.IconURL">"IconURL"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_icon_url (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon-url", value, NULL);
}

/**
 * grl_dleyna_media_device_get_dlnacaps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DLNACaps">"DLNACaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_dlnacaps() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
grl_dleyna_media_device_get_dlnacaps (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_dlnacaps (object);
}

/**
 * grl_dleyna_media_device_dup_dlnacaps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DLNACaps">"DLNACaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
grl_dleyna_media_device_dup_dlnacaps (GrlDleynaMediaDevice *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "dlnacaps", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_dlnacaps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.DLNACaps">"DLNACaps"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_dlnacaps (GrlDleynaMediaDevice *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "dlnacaps", value, NULL);
}

/**
 * grl_dleyna_media_device_get_search_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SearchCaps">"SearchCaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_search_caps() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
grl_dleyna_media_device_get_search_caps (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_search_caps (object);
}

/**
 * grl_dleyna_media_device_dup_search_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SearchCaps">"SearchCaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
grl_dleyna_media_device_dup_search_caps (GrlDleynaMediaDevice *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "search-caps", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_search_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SearchCaps">"SearchCaps"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_search_caps (GrlDleynaMediaDevice *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "search-caps", value, NULL);
}

/**
 * grl_dleyna_media_device_get_sort_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortCaps">"SortCaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_sort_caps() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
grl_dleyna_media_device_get_sort_caps (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_sort_caps (object);
}

/**
 * grl_dleyna_media_device_dup_sort_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortCaps">"SortCaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
grl_dleyna_media_device_dup_sort_caps (GrlDleynaMediaDevice *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "sort-caps", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_sort_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortCaps">"SortCaps"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_sort_caps (GrlDleynaMediaDevice *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "sort-caps", value, NULL);
}

/**
 * grl_dleyna_media_device_get_sort_ext_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortExtCaps">"SortExtCaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_sort_ext_caps() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
grl_dleyna_media_device_get_sort_ext_caps (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_sort_ext_caps (object);
}

/**
 * grl_dleyna_media_device_dup_sort_ext_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortExtCaps">"SortExtCaps"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
grl_dleyna_media_device_dup_sort_ext_caps (GrlDleynaMediaDevice *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "sort-ext-caps", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_sort_ext_caps: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SortExtCaps">"SortExtCaps"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_sort_ext_caps (GrlDleynaMediaDevice *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "sort-ext-caps", value, NULL);
}

/**
 * grl_dleyna_media_device_get_feature_list: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FeatureList">"FeatureList"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_feature_list() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
grl_dleyna_media_device_get_feature_list (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_feature_list (object);
}

/**
 * grl_dleyna_media_device_dup_feature_list: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FeatureList">"FeatureList"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
grl_dleyna_media_device_dup_feature_list (GrlDleynaMediaDevice *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "feature-list", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_feature_list: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.FeatureList">"FeatureList"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_feature_list (GrlDleynaMediaDevice *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "feature-list", value, NULL);
}

/**
 * grl_dleyna_media_device_get_system_update_id: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SystemUpdateID">"SystemUpdateID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
grl_dleyna_media_device_get_system_update_id (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), 0);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_system_update_id (object);
}

/**
 * grl_dleyna_media_device_set_system_update_id: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.SystemUpdateID">"SystemUpdateID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_system_update_id (GrlDleynaMediaDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "system-update-id", value, NULL);
}

/**
 * grl_dleyna_media_device_get_service_reset_token: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ServiceResetToken">"ServiceResetToken"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grl_dleyna_media_device_dup_service_reset_token() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grl_dleyna_media_device_get_service_reset_token (GrlDleynaMediaDevice *object)
{
  g_return_val_if_fail (GRL_DLEYNA_IS_MEDIA_DEVICE (object), NULL);

  return GRL_DLEYNA_MEDIA_DEVICE_GET_IFACE (object)->get_service_reset_token (object);
}

/**
 * grl_dleyna_media_device_dup_service_reset_token: (skip)
 * @object: A #GrlDleynaMediaDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ServiceResetToken">"ServiceResetToken"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grl_dleyna_media_device_dup_service_reset_token (GrlDleynaMediaDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "service-reset-token", &value, NULL);
  return value;
}

/**
 * grl_dleyna_media_device_set_service_reset_token: (skip)
 * @object: A #GrlDleynaMediaDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-intel-dLeynaServer-MediaDevice.ServiceResetToken">"ServiceResetToken"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grl_dleyna_media_device_set_service_reset_token (GrlDleynaMediaDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "service-reset-token", value, NULL);
}

/**
 * grl_dleyna_media_device_emit_container_update_ids:
 * @object: A #GrlDleynaMediaDevice.
 * @arg_ContainerPathsIDs: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.ContainerUpdateIDs">"ContainerUpdateIDs"</link> D-Bus signal.
 */
void
grl_dleyna_media_device_emit_container_update_ids (
    GrlDleynaMediaDevice *object,
    GVariant *arg_ContainerPathsIDs)
{
  g_signal_emit (object, GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_CONTAINER_UPDATE_IDS], 0, arg_ContainerPathsIDs);
}

/**
 * grl_dleyna_media_device_emit_last_change:
 * @object: A #GrlDleynaMediaDevice.
 * @arg_StateEvent: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.LastChange">"LastChange"</link> D-Bus signal.
 */
void
grl_dleyna_media_device_emit_last_change (
    GrlDleynaMediaDevice *object,
    GVariant *arg_StateEvent)
{
  g_signal_emit (object, GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_LAST_CHANGE], 0, arg_StateEvent);
}

/**
 * grl_dleyna_media_device_emit_changed:
 * @object: A #GrlDleynaMediaDevice.
 * @arg_ChangedObjects: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.Changed">"Changed"</link> D-Bus signal.
 */
void
grl_dleyna_media_device_emit_changed (
    GrlDleynaMediaDevice *object,
    GVariant *arg_ChangedObjects)
{
  g_signal_emit (object, GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_CHANGED], 0, arg_ChangedObjects);
}

/**
 * grl_dleyna_media_device_emit_upload_update:
 * @object: A #GrlDleynaMediaDevice.
 * @arg_UploadId: Argument to pass with the signal.
 * @arg_UploadStatus: Argument to pass with the signal.
 * @arg_Length: Argument to pass with the signal.
 * @arg_Total: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-intel-dLeynaServer-MediaDevice.UploadUpdate">"UploadUpdate"</link> D-Bus signal.
 */
void
grl_dleyna_media_device_emit_upload_update (
    GrlDleynaMediaDevice *object,
    guint arg_UploadId,
    const gchar *arg_UploadStatus,
    guint64 arg_Length,
    guint64 arg_Total)
{
  g_signal_emit (object, GRL_DLEYNA__MEDIA_DEVICE_SIGNALS[GRL_DLEYNA__MEDIA_DEVICE_UPLOAD_UPDATE], 0, arg_UploadId, arg_UploadStatus, arg_Length, arg_Total);
}

/**
 * grl_dleyna_media_device_call_upload_to_any_container:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_DisplayName: Argument to pass with the method invocation.
 * @arg_FilePath: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.UploadToAnyContainer">UploadToAnyContainer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_upload_to_any_container_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_upload_to_any_container_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_upload_to_any_container (
    GrlDleynaMediaDevice *proxy,
    const gchar *arg_DisplayName,
    const gchar *arg_FilePath,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UploadToAnyContainer",
    g_variant_new ("(ss)",
                   arg_DisplayName,
                   arg_FilePath),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_upload_to_any_container_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @out_UploadId: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_upload_to_any_container().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_upload_to_any_container().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_upload_to_any_container_finish (
    GrlDleynaMediaDevice *proxy,
    guint *out_UploadId,
    gchar **out_Path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uo)",
                 out_UploadId,
                 out_Path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_upload_to_any_container_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_DisplayName: Argument to pass with the method invocation.
 * @arg_FilePath: Argument to pass with the method invocation.
 * @out_UploadId: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.UploadToAnyContainer">UploadToAnyContainer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_upload_to_any_container() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_upload_to_any_container_sync (
    GrlDleynaMediaDevice *proxy,
    const gchar *arg_DisplayName,
    const gchar *arg_FilePath,
    guint *out_UploadId,
    gchar **out_Path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UploadToAnyContainer",
    g_variant_new ("(ss)",
                   arg_DisplayName,
                   arg_FilePath),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uo)",
                 out_UploadId,
                 out_Path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_get_upload_status:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_UploadId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadStatus">GetUploadStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_get_upload_status_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_get_upload_status_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_get_upload_status (
    GrlDleynaMediaDevice *proxy,
    guint arg_UploadId,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUploadStatus",
    g_variant_new ("(u)",
                   arg_UploadId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_get_upload_status_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @out_UploadStatus: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Total: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_get_upload_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_get_upload_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_get_upload_status_finish (
    GrlDleynaMediaDevice *proxy,
    gchar **out_UploadStatus,
    guint64 *out_Length,
    guint64 *out_Total,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(stt)",
                 out_UploadStatus,
                 out_Length,
                 out_Total);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_get_upload_status_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_UploadId: Argument to pass with the method invocation.
 * @out_UploadStatus: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Total: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadStatus">GetUploadStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_get_upload_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_get_upload_status_sync (
    GrlDleynaMediaDevice *proxy,
    guint arg_UploadId,
    gchar **out_UploadStatus,
    guint64 *out_Length,
    guint64 *out_Total,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUploadStatus",
    g_variant_new ("(u)",
                   arg_UploadId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(stt)",
                 out_UploadStatus,
                 out_Length,
                 out_Total);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_get_upload_ids:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadIDs">GetUploadIDs()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_get_upload_ids_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_get_upload_ids_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_get_upload_ids (
    GrlDleynaMediaDevice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUploadIDs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_get_upload_ids_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @out_Total: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_get_upload_ids().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_get_upload_ids().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_get_upload_ids_finish (
    GrlDleynaMediaDevice *proxy,
    GVariant **out_Total,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@au)",
                 out_Total);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_get_upload_ids_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @out_Total: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadIDs">GetUploadIDs()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_get_upload_ids() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_get_upload_ids_sync (
    GrlDleynaMediaDevice *proxy,
    GVariant **out_Total,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUploadIDs",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@au)",
                 out_Total);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_cancel_upload:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_UploadId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CancelUpload">CancelUpload()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_cancel_upload_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_cancel_upload_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_cancel_upload (
    GrlDleynaMediaDevice *proxy,
    guint arg_UploadId,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CancelUpload",
    g_variant_new ("(u)",
                   arg_UploadId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_cancel_upload_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_cancel_upload().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_cancel_upload().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_cancel_upload_finish (
    GrlDleynaMediaDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_cancel_upload_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_UploadId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CancelUpload">CancelUpload()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_cancel_upload() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_cancel_upload_sync (
    GrlDleynaMediaDevice *proxy,
    guint arg_UploadId,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CancelUpload",
    g_variant_new ("(u)",
                   arg_UploadId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_create_container_in_any_container:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_DisplayName: Argument to pass with the method invocation.
 * @arg_Type: Argument to pass with the method invocation.
 * @arg_ChildTypes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreateContainerInAnyContainer">CreateContainerInAnyContainer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_create_container_in_any_container_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_create_container_in_any_container_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_create_container_in_any_container (
    GrlDleynaMediaDevice *proxy,
    const gchar *arg_DisplayName,
    const gchar *arg_Type,
    const gchar *const *arg_ChildTypes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateContainerInAnyContainer",
    g_variant_new ("(ss^as)",
                   arg_DisplayName,
                   arg_Type,
                   arg_ChildTypes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_create_container_in_any_container_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @out_Path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_create_container_in_any_container().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_create_container_in_any_container().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_create_container_in_any_container_finish (
    GrlDleynaMediaDevice *proxy,
    gchar **out_Path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_Path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_create_container_in_any_container_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_DisplayName: Argument to pass with the method invocation.
 * @arg_Type: Argument to pass with the method invocation.
 * @arg_ChildTypes: Argument to pass with the method invocation.
 * @out_Path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreateContainerInAnyContainer">CreateContainerInAnyContainer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_create_container_in_any_container() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_create_container_in_any_container_sync (
    GrlDleynaMediaDevice *proxy,
    const gchar *arg_DisplayName,
    const gchar *arg_Type,
    const gchar *const *arg_ChildTypes,
    gchar **out_Path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateContainerInAnyContainer",
    g_variant_new ("(ss^as)",
                   arg_DisplayName,
                   arg_Type,
                   arg_ChildTypes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_Path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_cancel:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.Cancel">Cancel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_cancel_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_cancel_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_cancel (
    GrlDleynaMediaDevice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_cancel_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_cancel().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_cancel().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_cancel_finish (
    GrlDleynaMediaDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_cancel_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.Cancel">Cancel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_cancel() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_cancel_sync (
    GrlDleynaMediaDevice *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_create_playlist_in_any_container:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_Title: Argument to pass with the method invocation.
 * @arg_Creator: Argument to pass with the method invocation.
 * @arg_Genre: Argument to pass with the method invocation.
 * @arg_Description: Argument to pass with the method invocation.
 * @arg_PlaylistItems: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreatePlaylistInAnyContainer">CreatePlaylistInAnyContainer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_create_playlist_in_any_container_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_create_playlist_in_any_container_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_create_playlist_in_any_container (
    GrlDleynaMediaDevice *proxy,
    const gchar *arg_Title,
    const gchar *arg_Creator,
    const gchar *arg_Genre,
    const gchar *arg_Description,
    const gchar *const *arg_PlaylistItems,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreatePlaylistInAnyContainer",
    g_variant_new ("(ssss^ao)",
                   arg_Title,
                   arg_Creator,
                   arg_Genre,
                   arg_Description,
                   arg_PlaylistItems),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_create_playlist_in_any_container_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @out_UploadId: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_create_playlist_in_any_container().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_create_playlist_in_any_container().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_create_playlist_in_any_container_finish (
    GrlDleynaMediaDevice *proxy,
    guint *out_UploadId,
    gchar **out_Path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uo)",
                 out_UploadId,
                 out_Path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_create_playlist_in_any_container_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_Title: Argument to pass with the method invocation.
 * @arg_Creator: Argument to pass with the method invocation.
 * @arg_Genre: Argument to pass with the method invocation.
 * @arg_Description: Argument to pass with the method invocation.
 * @arg_PlaylistItems: Argument to pass with the method invocation.
 * @out_UploadId: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_Path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreatePlaylistInAnyContainer">CreatePlaylistInAnyContainer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_create_playlist_in_any_container() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_create_playlist_in_any_container_sync (
    GrlDleynaMediaDevice *proxy,
    const gchar *arg_Title,
    const gchar *arg_Creator,
    const gchar *arg_Genre,
    const gchar *arg_Description,
    const gchar *const *arg_PlaylistItems,
    guint *out_UploadId,
    gchar **out_Path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreatePlaylistInAnyContainer",
    g_variant_new ("(ssss^ao)",
                   arg_Title,
                   arg_Creator,
                   arg_Genre,
                   arg_Description,
                   arg_PlaylistItems),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(uo)",
                 out_UploadId,
                 out_Path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_browse_objects:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_Objects: Argument to pass with the method invocation.
 * @arg_Filter: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.BrowseObjects">BrowseObjects()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_call_browse_objects_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_call_browse_objects_sync() for the synchronous, blocking version of this method.
 */
void
grl_dleyna_media_device_call_browse_objects (
    GrlDleynaMediaDevice *proxy,
    const gchar *const *arg_Objects,
    const gchar *const *arg_Filter,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BrowseObjects",
    g_variant_new ("(^ao^as)",
                   arg_Objects,
                   arg_Filter),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grl_dleyna_media_device_call_browse_objects_finish:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @out_Children: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_call_browse_objects().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grl_dleyna_media_device_call_browse_objects().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_browse_objects_finish (
    GrlDleynaMediaDevice *proxy,
    GVariant **out_Children,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_Children);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_call_browse_objects_sync:
 * @proxy: A #GrlDleynaMediaDeviceProxy.
 * @arg_Objects: Argument to pass with the method invocation.
 * @arg_Filter: Argument to pass with the method invocation.
 * @out_Children: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.BrowseObjects">BrowseObjects()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_call_browse_objects() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grl_dleyna_media_device_call_browse_objects_sync (
    GrlDleynaMediaDevice *proxy,
    const gchar *const *arg_Objects,
    const gchar *const *arg_Filter,
    GVariant **out_Children,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BrowseObjects",
    g_variant_new ("(^ao^as)",
                   arg_Objects,
                   arg_Filter),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_Children);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grl_dleyna_media_device_complete_upload_to_any_container:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @UploadId: Parameter to return.
 * @Path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.UploadToAnyContainer">UploadToAnyContainer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_upload_to_any_container (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint UploadId,
    const gchar *Path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(uo)",
                   UploadId,
                   Path));
}

/**
 * grl_dleyna_media_device_complete_get_upload_status:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @UploadStatus: Parameter to return.
 * @Length: Parameter to return.
 * @Total: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadStatus">GetUploadStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_get_upload_status (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *UploadStatus,
    guint64 Length,
    guint64 Total)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(stt)",
                   UploadStatus,
                   Length,
                   Total));
}

/**
 * grl_dleyna_media_device_complete_get_upload_ids:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @Total: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.GetUploadIDs">GetUploadIDs()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_get_upload_ids (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *Total)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@au)",
                   Total));
}

/**
 * grl_dleyna_media_device_complete_cancel_upload:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CancelUpload">CancelUpload()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_cancel_upload (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grl_dleyna_media_device_complete_create_container_in_any_container:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @Path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreateContainerInAnyContainer">CreateContainerInAnyContainer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_create_container_in_any_container (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *Path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   Path));
}

/**
 * grl_dleyna_media_device_complete_cancel:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.Cancel">Cancel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_cancel (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * grl_dleyna_media_device_complete_create_playlist_in_any_container:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @UploadId: Parameter to return.
 * @Path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.CreatePlaylistInAnyContainer">CreatePlaylistInAnyContainer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_create_playlist_in_any_container (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint UploadId,
    const gchar *Path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(uo)",
                   UploadId,
                   Path));
}

/**
 * grl_dleyna_media_device_complete_browse_objects:
 * @object: A #GrlDleynaMediaDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @Children: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-intel-dLeynaServer-MediaDevice.BrowseObjects">BrowseObjects()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grl_dleyna_media_device_complete_browse_objects (
    GrlDleynaMediaDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *Children)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@aa{sv})",
                   Children));
}

/* ------------------------------------------------------------------------ */

/**
 * GrlDleynaMediaDeviceProxy:
 *
 * The #GrlDleynaMediaDeviceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrlDleynaMediaDeviceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrlDleynaMediaDeviceProxy.
 */

struct _GrlDleynaMediaDeviceProxyPrivate
{
  GData *qdata;
};

static void grl_dleyna_media_device_proxy_iface_init (GrlDleynaMediaDeviceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrlDleynaMediaDeviceProxy, grl_dleyna_media_device_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GrlDleynaMediaDeviceProxy)
                         G_IMPLEMENT_INTERFACE (GRL_DLEYNA_TYPE_MEDIA_DEVICE, grl_dleyna_media_device_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrlDleynaMediaDeviceProxy, grl_dleyna_media_device_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GRL_DLEYNA_TYPE_MEDIA_DEVICE, grl_dleyna_media_device_proxy_iface_init))

#endif
static void
grl_dleyna_media_device_proxy_finalize (GObject *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (grl_dleyna_media_device_proxy_parent_class)->finalize (object);
}

static void
grl_dleyna_media_device_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  info = (const _ExtendedGDBusPropertyInfo *) _grl_dleyna_media_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
grl_dleyna_media_device_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface com.intel.dLeynaServer.MediaDevice: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
grl_dleyna_media_device_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  info = (const _ExtendedGDBusPropertyInfo *) _grl_dleyna_media_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "com.intel.dLeynaServer.MediaDevice", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) grl_dleyna_media_device_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
grl_dleyna_media_device_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_grl_dleyna_media_device_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GRL_DLEYNA_TYPE_MEDIA_DEVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRL_DLEYNA_TYPE_MEDIA_DEVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
grl_dleyna_media_device_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grl_dleyna_media_device_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grl_dleyna_media_device_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
grl_dleyna_media_device_proxy_get_location (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Location");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_udn (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UDN");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_device_type (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DeviceType");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_friendly_name (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FriendlyName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_manufacturer (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Manufacturer");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_manufacturer_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ManufacturerUrl");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_model_description (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ModelDescription");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_model_name (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ModelName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_model_number (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ModelNumber");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_model_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ModelURL");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_serial_number (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SerialNumber");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_presentation_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PresentationURL");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_icon_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconURL");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
grl_dleyna_media_device_proxy_get_dlnacaps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DLNACaps");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *const *
grl_dleyna_media_device_proxy_get_search_caps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SearchCaps");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SearchCaps");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SearchCaps", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
grl_dleyna_media_device_proxy_get_sort_caps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SortCaps");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SortCaps");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SortCaps", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
grl_dleyna_media_device_proxy_get_sort_ext_caps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SortExtCaps");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SortExtCaps");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SortExtCaps", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
grl_dleyna_media_device_proxy_get_feature_list (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FeatureList");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static guint 
grl_dleyna_media_device_proxy_get_system_update_id (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SystemUpdateID");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grl_dleyna_media_device_proxy_get_service_reset_token (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceProxy *proxy = GRL_DLEYNA_MEDIA_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ServiceResetToken");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
grl_dleyna_media_device_proxy_init (GrlDleynaMediaDeviceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = grl_dleyna_media_device_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GRL_DLEYNA_TYPE_MEDIA_DEVICE_PROXY, GrlDleynaMediaDeviceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), grl_dleyna_media_device_interface_info ());
}

static void
grl_dleyna_media_device_proxy_class_init (GrlDleynaMediaDeviceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = grl_dleyna_media_device_proxy_finalize;
  gobject_class->get_property = grl_dleyna_media_device_proxy_get_property;
  gobject_class->set_property = grl_dleyna_media_device_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = grl_dleyna_media_device_proxy_g_signal;
  proxy_class->g_properties_changed = grl_dleyna_media_device_proxy_g_properties_changed;

  grl_dleyna_media_device_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrlDleynaMediaDeviceProxyPrivate));
#endif
}

static void
grl_dleyna_media_device_proxy_iface_init (GrlDleynaMediaDeviceIface *iface)
{
  iface->get_location = grl_dleyna_media_device_proxy_get_location;
  iface->get_udn = grl_dleyna_media_device_proxy_get_udn;
  iface->get_device_type = grl_dleyna_media_device_proxy_get_device_type;
  iface->get_friendly_name = grl_dleyna_media_device_proxy_get_friendly_name;
  iface->get_manufacturer = grl_dleyna_media_device_proxy_get_manufacturer;
  iface->get_manufacturer_url = grl_dleyna_media_device_proxy_get_manufacturer_url;
  iface->get_model_description = grl_dleyna_media_device_proxy_get_model_description;
  iface->get_model_name = grl_dleyna_media_device_proxy_get_model_name;
  iface->get_model_number = grl_dleyna_media_device_proxy_get_model_number;
  iface->get_model_url = grl_dleyna_media_device_proxy_get_model_url;
  iface->get_serial_number = grl_dleyna_media_device_proxy_get_serial_number;
  iface->get_presentation_url = grl_dleyna_media_device_proxy_get_presentation_url;
  iface->get_icon_url = grl_dleyna_media_device_proxy_get_icon_url;
  iface->get_dlnacaps = grl_dleyna_media_device_proxy_get_dlnacaps;
  iface->get_search_caps = grl_dleyna_media_device_proxy_get_search_caps;
  iface->get_sort_caps = grl_dleyna_media_device_proxy_get_sort_caps;
  iface->get_sort_ext_caps = grl_dleyna_media_device_proxy_get_sort_ext_caps;
  iface->get_feature_list = grl_dleyna_media_device_proxy_get_feature_list;
  iface->get_system_update_id = grl_dleyna_media_device_proxy_get_system_update_id;
  iface->get_service_reset_token = grl_dleyna_media_device_proxy_get_service_reset_token;
}

/**
 * grl_dleyna_media_device_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-intel-dLeynaServer-MediaDevice.top_of_page">com.intel.dLeynaServer.MediaDevice</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_proxy_new_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
grl_dleyna_media_device_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRL_DLEYNA_TYPE_MEDIA_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.intel.dLeynaServer.MediaDevice", NULL);
}

/**
 * grl_dleyna_media_device_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grl_dleyna_media_device_proxy_new().
 *
 * Returns: (transfer full) (type GrlDleynaMediaDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
GrlDleynaMediaDevice *
grl_dleyna_media_device_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRL_DLEYNA_MEDIA_DEVICE (ret);
  else
    return NULL;
}

/**
 * grl_dleyna_media_device_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-intel-dLeynaServer-MediaDevice.top_of_page">com.intel.dLeynaServer.MediaDevice</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrlDleynaMediaDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
GrlDleynaMediaDevice *
grl_dleyna_media_device_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRL_DLEYNA_TYPE_MEDIA_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.intel.dLeynaServer.MediaDevice", NULL);
  if (ret != NULL)
    return GRL_DLEYNA_MEDIA_DEVICE (ret);
  else
    return NULL;
}


/**
 * grl_dleyna_media_device_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like grl_dleyna_media_device_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grl_dleyna_media_device_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See grl_dleyna_media_device_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
grl_dleyna_media_device_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRL_DLEYNA_TYPE_MEDIA_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.intel.dLeynaServer.MediaDevice", NULL);
}

/**
 * grl_dleyna_media_device_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grl_dleyna_media_device_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grl_dleyna_media_device_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GrlDleynaMediaDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
GrlDleynaMediaDevice *
grl_dleyna_media_device_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRL_DLEYNA_MEDIA_DEVICE (ret);
  else
    return NULL;
}

/**
 * grl_dleyna_media_device_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like grl_dleyna_media_device_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grl_dleyna_media_device_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrlDleynaMediaDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
GrlDleynaMediaDevice *
grl_dleyna_media_device_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRL_DLEYNA_TYPE_MEDIA_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.intel.dLeynaServer.MediaDevice", NULL);
  if (ret != NULL)
    return GRL_DLEYNA_MEDIA_DEVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GrlDleynaMediaDeviceSkeleton:
 *
 * The #GrlDleynaMediaDeviceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrlDleynaMediaDeviceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrlDleynaMediaDeviceSkeleton.
 */

struct _GrlDleynaMediaDeviceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_grl_dleyna_media_device_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GRL_DLEYNA_TYPE_MEDIA_DEVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRL_DLEYNA_TYPE_MEDIA_DEVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_grl_dleyna_media_device_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grl_dleyna_media_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_grl_dleyna_media_device_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grl_dleyna_media_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _grl_dleyna_media_device_skeleton_vtable =
{
  _grl_dleyna_media_device_skeleton_handle_method_call,
  _grl_dleyna_media_device_skeleton_handle_get_property,
  _grl_dleyna_media_device_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
grl_dleyna_media_device_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return grl_dleyna_media_device_interface_info ();
}

static GDBusInterfaceVTable *
grl_dleyna_media_device_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_grl_dleyna_media_device_skeleton_vtable;
}

static GVariant *
grl_dleyna_media_device_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_grl_dleyna_media_device_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _grl_dleyna_media_device_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _grl_dleyna_media_device_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _grl_dleyna_media_device_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.intel.dLeynaServer.MediaDevice", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _grl_dleyna_media_device_emit_changed (gpointer user_data);

static void
grl_dleyna_media_device_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _grl_dleyna_media_device_emit_changed (skeleton);
}

static void
_grl_dleyna_media_device_on_signal_container_update_ids (
    GrlDleynaMediaDevice *object,
    GVariant *arg_ContainerPathsIDs)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a(ou))",
                   arg_ContainerPathsIDs));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.intel.dLeynaServer.MediaDevice", "ContainerUpdateIDs",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_grl_dleyna_media_device_on_signal_last_change (
    GrlDleynaMediaDevice *object,
    GVariant *arg_StateEvent)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a(sv))",
                   arg_StateEvent));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.intel.dLeynaServer.MediaDevice", "LastChange",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_grl_dleyna_media_device_on_signal_changed (
    GrlDleynaMediaDevice *object,
    GVariant *arg_ChangedObjects)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@aa{sv})",
                   arg_ChangedObjects));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.intel.dLeynaServer.MediaDevice", "Changed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_grl_dleyna_media_device_on_signal_upload_update (
    GrlDleynaMediaDevice *object,
    guint arg_UploadId,
    const gchar *arg_UploadStatus,
    guint64 arg_Length,
    guint64 arg_Total)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ustt)",
                   arg_UploadId,
                   arg_UploadStatus,
                   arg_Length,
                   arg_Total));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.intel.dLeynaServer.MediaDevice", "UploadUpdate",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void grl_dleyna_media_device_skeleton_iface_init (GrlDleynaMediaDeviceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrlDleynaMediaDeviceSkeleton, grl_dleyna_media_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GrlDleynaMediaDeviceSkeleton)
                         G_IMPLEMENT_INTERFACE (GRL_DLEYNA_TYPE_MEDIA_DEVICE, grl_dleyna_media_device_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrlDleynaMediaDeviceSkeleton, grl_dleyna_media_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GRL_DLEYNA_TYPE_MEDIA_DEVICE, grl_dleyna_media_device_skeleton_iface_init))

#endif
static void
grl_dleyna_media_device_skeleton_finalize (GObject *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 20; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (grl_dleyna_media_device_skeleton_parent_class)->finalize (object);
}

static void
grl_dleyna_media_device_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_grl_dleyna_media_device_emit_changed (gpointer user_data)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "com.intel.dLeynaServer.MediaDevice",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_grl_dleyna_media_device_schedule_emit_changed (GrlDleynaMediaDeviceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
grl_dleyna_media_device_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _grl_dleyna_media_device_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _grl_dleyna_media_device_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
grl_dleyna_media_device_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 20);
  info = (const _ExtendedGDBusPropertyInfo *) _grl_dleyna_media_device_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _grl_dleyna_media_device_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
grl_dleyna_media_device_skeleton_init (GrlDleynaMediaDeviceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = grl_dleyna_media_device_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GRL_DLEYNA_TYPE_MEDIA_DEVICE_SKELETON, GrlDleynaMediaDeviceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 20);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_STRING);
}

static const gchar *
grl_dleyna_media_device_skeleton_get_location (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_udn (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_device_type (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_friendly_name (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_manufacturer (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_manufacturer_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_model_description (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_model_name (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_model_number (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_model_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_serial_number (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_presentation_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_icon_url (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
grl_dleyna_media_device_skeleton_get_dlnacaps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
grl_dleyna_media_device_skeleton_get_search_caps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
grl_dleyna_media_device_skeleton_get_sort_caps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
grl_dleyna_media_device_skeleton_get_sort_ext_caps (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
grl_dleyna_media_device_skeleton_get_feature_list (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
grl_dleyna_media_device_skeleton_get_system_update_id (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grl_dleyna_media_device_skeleton_get_service_reset_token (GrlDleynaMediaDevice *object)
{
  GrlDleynaMediaDeviceSkeleton *skeleton = GRL_DLEYNA_MEDIA_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
grl_dleyna_media_device_skeleton_class_init (GrlDleynaMediaDeviceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = grl_dleyna_media_device_skeleton_finalize;
  gobject_class->get_property = grl_dleyna_media_device_skeleton_get_property;
  gobject_class->set_property = grl_dleyna_media_device_skeleton_set_property;
  gobject_class->notify       = grl_dleyna_media_device_skeleton_notify;


  grl_dleyna_media_device_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = grl_dleyna_media_device_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = grl_dleyna_media_device_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = grl_dleyna_media_device_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = grl_dleyna_media_device_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrlDleynaMediaDeviceSkeletonPrivate));
#endif
}

static void
grl_dleyna_media_device_skeleton_iface_init (GrlDleynaMediaDeviceIface *iface)
{
  iface->container_update_ids = _grl_dleyna_media_device_on_signal_container_update_ids;
  iface->last_change = _grl_dleyna_media_device_on_signal_last_change;
  iface->changed = _grl_dleyna_media_device_on_signal_changed;
  iface->upload_update = _grl_dleyna_media_device_on_signal_upload_update;
  iface->get_location = grl_dleyna_media_device_skeleton_get_location;
  iface->get_udn = grl_dleyna_media_device_skeleton_get_udn;
  iface->get_device_type = grl_dleyna_media_device_skeleton_get_device_type;
  iface->get_friendly_name = grl_dleyna_media_device_skeleton_get_friendly_name;
  iface->get_manufacturer = grl_dleyna_media_device_skeleton_get_manufacturer;
  iface->get_manufacturer_url = grl_dleyna_media_device_skeleton_get_manufacturer_url;
  iface->get_model_description = grl_dleyna_media_device_skeleton_get_model_description;
  iface->get_model_name = grl_dleyna_media_device_skeleton_get_model_name;
  iface->get_model_number = grl_dleyna_media_device_skeleton_get_model_number;
  iface->get_model_url = grl_dleyna_media_device_skeleton_get_model_url;
  iface->get_serial_number = grl_dleyna_media_device_skeleton_get_serial_number;
  iface->get_presentation_url = grl_dleyna_media_device_skeleton_get_presentation_url;
  iface->get_icon_url = grl_dleyna_media_device_skeleton_get_icon_url;
  iface->get_dlnacaps = grl_dleyna_media_device_skeleton_get_dlnacaps;
  iface->get_search_caps = grl_dleyna_media_device_skeleton_get_search_caps;
  iface->get_sort_caps = grl_dleyna_media_device_skeleton_get_sort_caps;
  iface->get_sort_ext_caps = grl_dleyna_media_device_skeleton_get_sort_ext_caps;
  iface->get_feature_list = grl_dleyna_media_device_skeleton_get_feature_list;
  iface->get_system_update_id = grl_dleyna_media_device_skeleton_get_system_update_id;
  iface->get_service_reset_token = grl_dleyna_media_device_skeleton_get_service_reset_token;
}

/**
 * grl_dleyna_media_device_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-com-intel-dLeynaServer-MediaDevice.top_of_page">com.intel.dLeynaServer.MediaDevice</link>.
 *
 * Returns: (transfer full) (type GrlDleynaMediaDeviceSkeleton): The skeleton object.
 */
GrlDleynaMediaDevice *
grl_dleyna_media_device_skeleton_new (void)
{
  return GRL_DLEYNA_MEDIA_DEVICE (g_object_new (GRL_DLEYNA_TYPE_MEDIA_DEVICE_SKELETON, NULL));
}

