

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Callbacks
    ( 

 -- * Signals


-- ** AttrClassCopyFieldCallback #signal:AttrClassCopyFieldCallback#

    AttrClassCopyFieldCallback              ,
    C_AttrClassCopyFieldCallback            ,
    dynamic_AttrClassCopyFieldCallback      ,
    genClosure_AttrClassCopyFieldCallback   ,
    mk_AttrClassCopyFieldCallback           ,
    noAttrClassCopyFieldCallback            ,
    wrap_AttrClassCopyFieldCallback         ,


-- ** AttrClassDestroyFieldCallback #signal:AttrClassDestroyFieldCallback#

    AttrClassDestroyFieldCallback           ,
    C_AttrClassDestroyFieldCallback         ,
    dynamic_AttrClassDestroyFieldCallback   ,
    genClosure_AttrClassDestroyFieldCallback,
    mk_AttrClassDestroyFieldCallback        ,
    noAttrClassDestroyFieldCallback         ,
    wrap_AttrClassDestroyFieldCallback      ,


-- ** AttrClassEqualFieldCallback #signal:AttrClassEqualFieldCallback#

    AttrClassEqualFieldCallback             ,
    C_AttrClassEqualFieldCallback           ,
    dynamic_AttrClassEqualFieldCallback     ,
    genClosure_AttrClassEqualFieldCallback  ,
    mk_AttrClassEqualFieldCallback          ,
    noAttrClassEqualFieldCallback           ,
    wrap_AttrClassEqualFieldCallback        ,


-- ** AttrDataCopyFunc #signal:AttrDataCopyFunc#

    AttrDataCopyFunc                        ,
    AttrDataCopyFunc_WithClosures           ,
    C_AttrDataCopyFunc                      ,
    drop_closures_AttrDataCopyFunc          ,
    dynamic_AttrDataCopyFunc                ,
    genClosure_AttrDataCopyFunc             ,
    mk_AttrDataCopyFunc                     ,
    noAttrDataCopyFunc                      ,
    noAttrDataCopyFunc_WithClosures         ,
    wrap_AttrDataCopyFunc                   ,


-- ** AttrFilterFunc #signal:AttrFilterFunc#

    AttrFilterFunc                          ,
    AttrFilterFunc_WithClosures             ,
    C_AttrFilterFunc                        ,
    drop_closures_AttrFilterFunc            ,
    dynamic_AttrFilterFunc                  ,
    genClosure_AttrFilterFunc               ,
    mk_AttrFilterFunc                       ,
    noAttrFilterFunc                        ,
    noAttrFilterFunc_WithClosures           ,
    wrap_AttrFilterFunc                     ,


-- ** FontsetForeachFunc #signal:FontsetForeachFunc#

    C_FontsetForeachFunc                    ,
    FontsetForeachFunc                      ,
    FontsetForeachFunc_WithClosures         ,
    drop_closures_FontsetForeachFunc        ,
    dynamic_FontsetForeachFunc              ,
    genClosure_FontsetForeachFunc           ,
    mk_FontsetForeachFunc                   ,
    noFontsetForeachFunc                    ,
    noFontsetForeachFunc_WithClosures       ,
    wrap_FontsetForeachFunc                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute

#endif

-- callback FontsetForeachFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "if %TRUE, stop iteration and return immediately."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "fontset"
          , argType =
              TInterface Name { namespace = "Pango" , name = "Fontset" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a `PangoFontset`" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "font"
          , argType = TInterface Name { namespace = "Pango" , name = "Font" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a font from @fontset"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "callback data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Callback used when enumerating fonts in a fontset.\n\nSee [method@Pango.Fontset.foreach]."
        , sinceVersion = Just "1.4"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FontsetForeachFunc =
    Ptr Pango.Fontset.Fontset ->
    Ptr Pango.Font.Font ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "fontset"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Fontset" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFontset`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType = TInterface Name { namespace = "Pango" , name = "Font" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a font from @fontset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FontsetForeachFunc :: FunPtr C_FontsetForeachFunc -> C_FontsetForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FontsetForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Pango.Fontset.IsFontset a, Pango.Font.IsFont b) =>
    FunPtr C_FontsetForeachFunc
    -> a
    -- ^ /@fontset@/: a @PangoFontset@
    -> b
    -- ^ /@font@/: a font from /@fontset@/
    -> Ptr ()
    -- ^ /@userData@/: callback data
    -> m Bool
    -- ^ __Returns:__ if 'P.True', stop iteration and return immediately.
dynamic_FontsetForeachFunc __funPtr fontset font userData = liftIO $ do
    fontset' <- unsafeManagedPtrCastPtr fontset
    font' <- unsafeManagedPtrCastPtr font
    result <- (__dynamic_C_FontsetForeachFunc __funPtr) fontset' font' userData
    let result' = (/= 0) result
    touchManagedPtr fontset
    touchManagedPtr font
    return result'

-- | Generate a function pointer callable from C code, from a `C_FontsetForeachFunc`.
foreign import ccall "wrapper"
    mk_FontsetForeachFunc :: C_FontsetForeachFunc -> IO (FunPtr C_FontsetForeachFunc)

-- | Callback used when enumerating fonts in a fontset.
-- 
-- See 'GI.Pango.Objects.Fontset.fontsetForeach'.
-- 
-- /Since: 1.4/
type FontsetForeachFunc =
    Pango.Fontset.Fontset
    -- ^ /@fontset@/: a @PangoFontset@
    -> Pango.Font.Font
    -- ^ /@font@/: a font from /@fontset@/
    -> IO Bool
    -- ^ __Returns:__ if 'P.True', stop iteration and return immediately.

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontsetForeachFunc`@.
noFontsetForeachFunc :: Maybe FontsetForeachFunc
noFontsetForeachFunc = Nothing

-- | Callback used when enumerating fonts in a fontset.
-- 
-- See 'GI.Pango.Objects.Fontset.fontsetForeach'.
-- 
-- /Since: 1.4/
type FontsetForeachFunc_WithClosures =
    Pango.Fontset.Fontset
    -- ^ /@fontset@/: a @PangoFontset@
    -> Pango.Font.Font
    -- ^ /@font@/: a font from /@fontset@/
    -> Ptr ()
    -- ^ /@userData@/: callback data
    -> IO Bool
    -- ^ __Returns:__ if 'P.True', stop iteration and return immediately.

-- | A convenience synonym for @`Nothing` :: `Maybe` `FontsetForeachFunc_WithClosures`@.
noFontsetForeachFunc_WithClosures :: Maybe FontsetForeachFunc_WithClosures
noFontsetForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FontsetForeachFunc :: FontsetForeachFunc -> FontsetForeachFunc_WithClosures
drop_closures_FontsetForeachFunc _f fontset font _ = _f fontset font

-- | Wrap the callback into a `GClosure`.
genClosure_FontsetForeachFunc :: MonadIO m => FontsetForeachFunc -> m (GClosure C_FontsetForeachFunc)
genClosure_FontsetForeachFunc cb = liftIO $ do
    let cb' = drop_closures_FontsetForeachFunc cb
    let cb'' = wrap_FontsetForeachFunc Nothing cb'
    mk_FontsetForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FontsetForeachFunc` into a `C_FontsetForeachFunc`.
wrap_FontsetForeachFunc :: 
    Maybe (Ptr (FunPtr C_FontsetForeachFunc)) ->
    FontsetForeachFunc_WithClosures ->
    C_FontsetForeachFunc
wrap_FontsetForeachFunc gi'funptrptr gi'cb fontset font userData = do
    fontset' <- (newObject Pango.Fontset.Fontset) fontset
    font' <- (newObject Pango.Font.Font) font
    result <- gi'cb  fontset' font' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback AttrFilterFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if the attribute should be selected for\n  filtering, %FALSE otherwise."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "attribute"
          , argType =
              TInterface Name { namespace = "Pango" , name = "Attribute" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a Pango attribute" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to the function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Type of a function filtering a list of attributes."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_AttrFilterFunc =
    Ptr Pango.Attribute.Attribute ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "attribute"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Pango attribute" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_AttrFilterFunc :: FunPtr C_AttrFilterFunc -> C_AttrFilterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_AttrFilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_AttrFilterFunc
    -> Pango.Attribute.Attribute
    -- ^ /@attribute@/: a Pango attribute
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the function
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the attribute should be selected for
    --   filtering, 'P.False' otherwise.
dynamic_AttrFilterFunc __funPtr attribute userData = liftIO $ do
    attribute' <- unsafeManagedPtrGetPtr attribute
    result <- (__dynamic_C_AttrFilterFunc __funPtr) attribute' userData
    let result' = (/= 0) result
    touchManagedPtr attribute
    return result'

-- | Generate a function pointer callable from C code, from a `C_AttrFilterFunc`.
foreign import ccall "wrapper"
    mk_AttrFilterFunc :: C_AttrFilterFunc -> IO (FunPtr C_AttrFilterFunc)

-- | Type of a function filtering a list of attributes.
type AttrFilterFunc =
    Pango.Attribute.Attribute
    -- ^ /@attribute@/: a Pango attribute
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the attribute should be selected for
    --   filtering, 'P.False' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `AttrFilterFunc`@.
noAttrFilterFunc :: Maybe AttrFilterFunc
noAttrFilterFunc = Nothing

-- | Type of a function filtering a list of attributes.
type AttrFilterFunc_WithClosures =
    Pango.Attribute.Attribute
    -- ^ /@attribute@/: a Pango attribute
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the function
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the attribute should be selected for
    --   filtering, 'P.False' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `AttrFilterFunc_WithClosures`@.
noAttrFilterFunc_WithClosures :: Maybe AttrFilterFunc_WithClosures
noAttrFilterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_AttrFilterFunc :: AttrFilterFunc -> AttrFilterFunc_WithClosures
drop_closures_AttrFilterFunc _f attribute _ = _f attribute

-- | Wrap the callback into a `GClosure`.
genClosure_AttrFilterFunc :: MonadIO m => AttrFilterFunc -> m (GClosure C_AttrFilterFunc)
genClosure_AttrFilterFunc cb = liftIO $ do
    let cb' = drop_closures_AttrFilterFunc cb
    let cb'' = wrap_AttrFilterFunc Nothing cb'
    mk_AttrFilterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `AttrFilterFunc` into a `C_AttrFilterFunc`.
wrap_AttrFilterFunc :: 
    Maybe (Ptr (FunPtr C_AttrFilterFunc)) ->
    AttrFilterFunc_WithClosures ->
    C_AttrFilterFunc
wrap_AttrFilterFunc gi'funptrptr gi'cb attribute userData = do
    B.ManagedPtr.withTransient  attribute $ \attribute' -> do
        result <- gi'cb  attribute' userData
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback AttrDataCopyFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "new copy of @user_data."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data to copy" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Type of a function that can duplicate user data for an attribute."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_AttrDataCopyFunc =
    Ptr () ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_AttrDataCopyFunc :: FunPtr C_AttrDataCopyFunc -> C_AttrDataCopyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_AttrDataCopyFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_AttrDataCopyFunc
    -> Ptr ()
    -- ^ /@userData@/: user data to copy
    -> m (Ptr ())
    -- ^ __Returns:__ new copy of /@userData@/.
dynamic_AttrDataCopyFunc __funPtr userData = liftIO $ do
    result <- (__dynamic_C_AttrDataCopyFunc __funPtr) userData
    return result

-- | Generate a function pointer callable from C code, from a `C_AttrDataCopyFunc`.
foreign import ccall "wrapper"
    mk_AttrDataCopyFunc :: C_AttrDataCopyFunc -> IO (FunPtr C_AttrDataCopyFunc)

-- | Type of a function that can duplicate user data for an attribute.
type AttrDataCopyFunc =
    IO (Ptr ())
    -- ^ __Returns:__ new copy of /@userData@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `AttrDataCopyFunc`@.
noAttrDataCopyFunc :: Maybe AttrDataCopyFunc
noAttrDataCopyFunc = Nothing

-- | Type of a function that can duplicate user data for an attribute.
type AttrDataCopyFunc_WithClosures =
    Ptr ()
    -- ^ /@userData@/: user data to copy
    -> IO (Ptr ())
    -- ^ __Returns:__ new copy of /@userData@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `AttrDataCopyFunc_WithClosures`@.
noAttrDataCopyFunc_WithClosures :: Maybe AttrDataCopyFunc_WithClosures
noAttrDataCopyFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_AttrDataCopyFunc :: AttrDataCopyFunc -> AttrDataCopyFunc_WithClosures
drop_closures_AttrDataCopyFunc _f _ = _f 

-- | Wrap the callback into a `GClosure`.
genClosure_AttrDataCopyFunc :: MonadIO m => AttrDataCopyFunc -> m (GClosure C_AttrDataCopyFunc)
genClosure_AttrDataCopyFunc cb = liftIO $ do
    let cb' = drop_closures_AttrDataCopyFunc cb
    let cb'' = wrap_AttrDataCopyFunc Nothing cb'
    mk_AttrDataCopyFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `AttrDataCopyFunc` into a `C_AttrDataCopyFunc`.
wrap_AttrDataCopyFunc :: 
    Maybe (Ptr (FunPtr C_AttrDataCopyFunc)) ->
    AttrDataCopyFunc_WithClosures ->
    C_AttrDataCopyFunc
wrap_AttrDataCopyFunc gi'funptrptr gi'cb userData = do
    result <- gi'cb  userData
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback AttrClassEqualFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "attr1"
          , argType =
              TInterface Name { namespace = "Pango" , name = "Attribute" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "attr2"
          , argType =
              TInterface Name { namespace = "Pango" , name = "Attribute" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_AttrClassEqualFieldCallback =
    Ptr Pango.Attribute.Attribute ->
    Ptr Pango.Attribute.Attribute ->
    IO CInt

-- Args: [ Arg
--           { argCName = "attr1"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attr2"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_AttrClassEqualFieldCallback :: FunPtr C_AttrClassEqualFieldCallback -> C_AttrClassEqualFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_AttrClassEqualFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_AttrClassEqualFieldCallback
    -> Pango.Attribute.Attribute
    -> Pango.Attribute.Attribute
    -> m Bool
dynamic_AttrClassEqualFieldCallback __funPtr attr1 attr2 = liftIO $ do
    attr1' <- unsafeManagedPtrGetPtr attr1
    attr2' <- unsafeManagedPtrGetPtr attr2
    result <- (__dynamic_C_AttrClassEqualFieldCallback __funPtr) attr1' attr2'
    let result' = (/= 0) result
    touchManagedPtr attr1
    touchManagedPtr attr2
    return result'

-- | Generate a function pointer callable from C code, from a `C_AttrClassEqualFieldCallback`.
foreign import ccall "wrapper"
    mk_AttrClassEqualFieldCallback :: C_AttrClassEqualFieldCallback -> IO (FunPtr C_AttrClassEqualFieldCallback)

-- | /No description available in the introspection data./
type AttrClassEqualFieldCallback =
    Pango.Attribute.Attribute
    -> Pango.Attribute.Attribute
    -> IO Bool

-- | A convenience synonym for @`Nothing` :: `Maybe` `AttrClassEqualFieldCallback`@.
noAttrClassEqualFieldCallback :: Maybe AttrClassEqualFieldCallback
noAttrClassEqualFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_AttrClassEqualFieldCallback :: MonadIO m => AttrClassEqualFieldCallback -> m (GClosure C_AttrClassEqualFieldCallback)
genClosure_AttrClassEqualFieldCallback cb = liftIO $ do
    let cb' = wrap_AttrClassEqualFieldCallback Nothing cb
    mk_AttrClassEqualFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `AttrClassEqualFieldCallback` into a `C_AttrClassEqualFieldCallback`.
wrap_AttrClassEqualFieldCallback :: 
    Maybe (Ptr (FunPtr C_AttrClassEqualFieldCallback)) ->
    AttrClassEqualFieldCallback ->
    C_AttrClassEqualFieldCallback
wrap_AttrClassEqualFieldCallback gi'funptrptr gi'cb attr1 attr2 = do
    B.ManagedPtr.withTransient  attr1 $ \attr1' -> do
        B.ManagedPtr.withTransient  attr2 $ \attr2' -> do
            result <- gi'cb  attr1' attr2'
            maybeReleaseFunPtr gi'funptrptr
            let result' = (P.fromIntegral . P.fromEnum) result
            return result'


-- callback AttrClassDestroyFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "attr"
          , argType =
              TInterface Name { namespace = "Pango" , name = "Attribute" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_AttrClassDestroyFieldCallback =
    Ptr Pango.Attribute.Attribute ->
    IO ()

-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_AttrClassDestroyFieldCallback :: FunPtr C_AttrClassDestroyFieldCallback -> C_AttrClassDestroyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_AttrClassDestroyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_AttrClassDestroyFieldCallback
    -> Pango.Attribute.Attribute
    -> m ()
dynamic_AttrClassDestroyFieldCallback __funPtr attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    (__dynamic_C_AttrClassDestroyFieldCallback __funPtr) attr'
    touchManagedPtr attr
    return ()

-- | Generate a function pointer callable from C code, from a `C_AttrClassDestroyFieldCallback`.
foreign import ccall "wrapper"
    mk_AttrClassDestroyFieldCallback :: C_AttrClassDestroyFieldCallback -> IO (FunPtr C_AttrClassDestroyFieldCallback)

-- | /No description available in the introspection data./
type AttrClassDestroyFieldCallback =
    Pango.Attribute.Attribute
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `AttrClassDestroyFieldCallback`@.
noAttrClassDestroyFieldCallback :: Maybe AttrClassDestroyFieldCallback
noAttrClassDestroyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_AttrClassDestroyFieldCallback :: MonadIO m => AttrClassDestroyFieldCallback -> m (GClosure C_AttrClassDestroyFieldCallback)
genClosure_AttrClassDestroyFieldCallback cb = liftIO $ do
    let cb' = wrap_AttrClassDestroyFieldCallback Nothing cb
    mk_AttrClassDestroyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `AttrClassDestroyFieldCallback` into a `C_AttrClassDestroyFieldCallback`.
wrap_AttrClassDestroyFieldCallback :: 
    Maybe (Ptr (FunPtr C_AttrClassDestroyFieldCallback)) ->
    AttrClassDestroyFieldCallback ->
    C_AttrClassDestroyFieldCallback
wrap_AttrClassDestroyFieldCallback gi'funptrptr gi'cb attr = do
    B.ManagedPtr.withTransient  attr $ \attr' -> do
        gi'cb  attr'
        maybeReleaseFunPtr gi'funptrptr


-- callback AttrClassCopyFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "attr"
          , argType =
              TInterface Name { namespace = "Pango" , name = "Attribute" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_AttrClassCopyFieldCallback =
    Ptr Pango.Attribute.Attribute ->
    IO (Ptr Pango.Attribute.Attribute)

-- Args: [ Arg
--           { argCName = "attr"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Attribute" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_AttrClassCopyFieldCallback :: FunPtr C_AttrClassCopyFieldCallback -> C_AttrClassCopyFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_AttrClassCopyFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_AttrClassCopyFieldCallback
    -> Pango.Attribute.Attribute
    -> m Pango.Attribute.Attribute
dynamic_AttrClassCopyFieldCallback __funPtr attr = liftIO $ do
    attr' <- unsafeManagedPtrGetPtr attr
    result <- (__dynamic_C_AttrClassCopyFieldCallback __funPtr) attr'
    checkUnexpectedReturnNULL "attrClassCopyFieldCallback" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    touchManagedPtr attr
    return result'

-- | Generate a function pointer callable from C code, from a `C_AttrClassCopyFieldCallback`.
foreign import ccall "wrapper"
    mk_AttrClassCopyFieldCallback :: C_AttrClassCopyFieldCallback -> IO (FunPtr C_AttrClassCopyFieldCallback)

-- | /No description available in the introspection data./
type AttrClassCopyFieldCallback =
    Pango.Attribute.Attribute
    -> IO Pango.Attribute.Attribute

-- | A convenience synonym for @`Nothing` :: `Maybe` `AttrClassCopyFieldCallback`@.
noAttrClassCopyFieldCallback :: Maybe AttrClassCopyFieldCallback
noAttrClassCopyFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_AttrClassCopyFieldCallback :: MonadIO m => AttrClassCopyFieldCallback -> m (GClosure C_AttrClassCopyFieldCallback)
genClosure_AttrClassCopyFieldCallback cb = liftIO $ do
    let cb' = wrap_AttrClassCopyFieldCallback Nothing cb
    mk_AttrClassCopyFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `AttrClassCopyFieldCallback` into a `C_AttrClassCopyFieldCallback`.
wrap_AttrClassCopyFieldCallback :: 
    Maybe (Ptr (FunPtr C_AttrClassCopyFieldCallback)) ->
    AttrClassCopyFieldCallback ->
    C_AttrClassCopyFieldCallback
wrap_AttrClassCopyFieldCallback gi'funptrptr gi'cb attr = do
    B.ManagedPtr.withTransient  attr $ \attr' -> do
        result <- gi'cb  attr'
        maybeReleaseFunPtr gi'funptrptr
        result' <- B.ManagedPtr.disownBoxed result
        return result'



