
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "ksystemclipboard_wrapper.h"

// Wrappers providing overrides
#include "ksystemclipboard_wrapper.h"

// Argument includes
#include <QString>
#include <ksystemclipboard.h>
#include <qclipboard.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KSystemClipboard_Type = nullptr;
static PyTypeObject *Sbk_KSystemClipboard_TypeF(void)
{
    return _Sbk_KSystemClipboard_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KSystemClipboardWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KSystemClipboardWrapper::KSystemClipboardWrapper(::QObject * parent) : KSystemClipboard(parent)
{
}

void KSystemClipboardWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    sbk_o_childEvent("KSystemClipboard", funcName, gil, pyOverride, event);
}

void KSystemClipboardWrapper::sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KSystemClipboardWrapper::clear(::QClipboard::Mode mode)
{
    static const char *funcName = "clear";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KSystemClipboard.clear");
        return;
    }
    sbk_o_clear("KSystemClipboard", funcName, gil, pyOverride, mode);
}

void KSystemClipboardWrapper::sbk_o_clear(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QClipboard::Mode mode)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, &mode)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, &mode)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KSystemClipboardWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    sbk_o_connectNotify("KSystemClipboard", funcName, gil, pyOverride, signal);
}

void KSystemClipboardWrapper::sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KSystemClipboardWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    sbk_o_customEvent("KSystemClipboard", funcName, gil, pyOverride, event);
}

void KSystemClipboardWrapper::sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KSystemClipboardWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KSystemClipboard", funcName, gil, pyOverride, signal);
}

bool KSystemClipboardWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return sbk_o_event("KSystemClipboard", funcName, gil, pyOverride, event);
}

bool KSystemClipboardWrapper::sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KSystemClipboardWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return sbk_o_eventFilter("KSystemClipboard", funcName, gil, pyOverride, watched, event);
}

bool KSystemClipboardWrapper::sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg2 = Py_REFCNT(pyArgArray[1]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg2 = Py_REFCNT(PyTuple_GetItem(pyArgs, 1)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(pyArgArray[1]);
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 1));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const ::QMimeData * KSystemClipboardWrapper::mimeData(::QClipboard::Mode mode) const
{
    static const char *funcName = "mimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KSystemClipboard.mimeData");
        return nullptr;
    }
    return sbk_o_mimeData("KSystemClipboard", funcName, gil, pyOverride, mode);
}

const ::QMimeData * KSystemClipboardWrapper::sbk_o_mimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QClipboard::Mode mode)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, &mode)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, &mode)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QMimeData >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMimeData *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KSystemClipboardWrapper::setMimeData(::QMimeData * mime, ::QClipboard::Mode mode)
{
    static const char *funcName = "setMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KSystemClipboard.setMimeData");
        return;
    }
    sbk_o_setMimeData("KSystemClipboard", funcName, gil, pyOverride, mime, mode);
}

void KSystemClipboardWrapper::sbk_o_setMimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMimeData * mime, ::QClipboard::Mode mode)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), mime),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, &mode)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), mime),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, &mode)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KSystemClipboardWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSystemClipboard_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    sbk_o_timerEvent("KSystemClipboard", funcName, gil, pyOverride, event);
}

void KSystemClipboardWrapper::sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

const QMetaObject *KSystemClipboardWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KSystemClipboard::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KSystemClipboardWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KSystemClipboard::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KSystemClipboardWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KSystemClipboardWrapper *>(this));
    }
    return KSystemClipboard::qt_metacast(_clname);
}

KSystemClipboardWrapper::~KSystemClipboardWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KSystemClipboard_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KSystemClipboard_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KSystemClipboard");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KSystemClipboard >()))
        return -1;

    KSystemClipboardWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KSystemClipboard", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KSystemClipboard::KSystemClipboard(QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KSystemClipboard(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KSystemClipboard(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KSystemClipboardWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KSystemClipboardWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KSystemClipboard >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KSystemClipboardFunc_clear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSystemClipboard *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSystemClipboard::clear(QClipboard::Mode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // clear(QClipboard::Mode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "clear", errInfo, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);

    // Call function/method
    {
        ::QClipboard::Mode cppArg0{QClipboard::Clipboard};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // clear(QClipboard::Mode)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KSystemClipboard.clear");
                return {};
            }
            cppSelf->clear(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSystemClipboardFunc_instance(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // instance()
        KSystemClipboard * cppResult = ::KSystemClipboard::instance();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSystemClipboardFunc_mimeData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSystemClipboard *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSystemClipboard::mimeData(QClipboard::Mode)const->const QMimeData*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // mimeData(QClipboard::Mode)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mimeData", errInfo, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);

    // Call function/method
    {
        ::QClipboard::Mode cppArg0{QClipboard::Clipboard};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mimeData(QClipboard::Mode)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KSystemClipboard.mimeData");
                return {};
            }
            const QMimeData * cppResult = const_cast<const ::KSystemClipboard *>(cppSelf)->mimeData(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSystemClipboardFunc_setMimeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSystemClipboard *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setMimeData", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSystemClipboard::setMimeData(QMimeData*,QClipboard::Mode)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMimeData_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // setMimeData(QMimeData*,QClipboard::Mode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMimeData", errInfo, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMimeData *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QClipboard::Mode cppArg1{QClipboard::Clipboard};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMimeData(QMimeData*,QClipboard::Mode)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KSystemClipboard.setMimeData");
                return {};
            }
            cppSelf->setMimeData(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSystemClipboardFunc_text(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSystemClipboard *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSystemClipboard::text(QClipboard::Mode)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QClipboard_Mode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // text(QClipboard::Mode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "text", errInfo, SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]);

    // Call function/method
    {
        ::QClipboard::Mode cppArg0{QClipboard::Clipboard};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // text(QClipboard::Mode)
            QString cppResult = cppSelf->text(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KSystemClipboard_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KSystemClipboard_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_KSystemClipboardFunc_clear), METH_O, nullptr},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_KSystemClipboardFunc_instance), METH_NOARGS|METH_STATIC, nullptr},
    {"mimeData", reinterpret_cast<PyCFunction>(Sbk_KSystemClipboardFunc_mimeData), METH_O, nullptr},
    {"setMimeData", reinterpret_cast<PyCFunction>(Sbk_KSystemClipboardFunc_setMimeData), METH_VARARGS, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KSystemClipboardFunc_text), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KSystemClipboard_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KSystemClipboard *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KSystemClipboardWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KSystemClipboard_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KSystemClipboard_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KSystemClipboard_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KSystemClipboard_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KSystemClipboard_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KSystemClipboard_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KSystemClipboard_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KSystemClipboard_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KSystemClipboard_spec = {
    "1:KGuiAddons.KSystemClipboard",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KSystemClipboard_slots
};

} //extern "C"

static void *Sbk_KSystemClipboard_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KSystemClipboard *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KSystemClipboard_PythonToCpp_KSystemClipboard_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KSystemClipboard_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KSystemClipboard_PythonToCpp_KSystemClipboard_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KSystemClipboard_TypeF()))
        return KSystemClipboard_PythonToCpp_KSystemClipboard_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KSystemClipboard_PTR_CppToPython_KSystemClipboard(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KSystemClipboard *>(const_cast<void *>(cppIn)), Sbk_KSystemClipboard_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KSystemClipboard_SignatureStrings[] = {
    "KGuiAddons.KSystemClipboard(self,parent:PySide6.QtCore.QObject)",
    "KGuiAddons.KSystemClipboard.clear(self,mode:PySide6.QtGui.QClipboard.Mode)",
    "KGuiAddons.KSystemClipboard.instance()->KGuiAddons.KSystemClipboard",
    "KGuiAddons.KSystemClipboard.mimeData(self,mode:PySide6.QtGui.QClipboard.Mode)->PySide6.QtCore.QMimeData",
    "KGuiAddons.KSystemClipboard.setMimeData(self,mime:PySide6.QtCore.QMimeData,mode:PySide6.QtGui.QClipboard.Mode)",
    "KGuiAddons.KSystemClipboard.text(self,mode:PySide6.QtGui.QClipboard.Mode)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KSystemClipboard_SignatureByteSize = 164;
static constexpr uint8_t KSystemClipboard_SignatureBytes[164] = {
    0x78, 0xda, 0xa5, 0x90, 0xcd, 0x0a, 0xc2, 0x30, 0x10, 0x84, 0xef, 0x7d, 0x92, 0x16, 0x6c, 0x8e,
    0x1e, 0x7a, 0x28, 0x48, 0x05, 0x0f, 0x21, 0x68, 0xc8, 0x13, 0xa4, 0xc9, 0x2a, 0x91, 0xfc, 0x94,
    0x64, 0x05, 0xfb, 0xf6, 0x06, 0x14, 0xfc, 0x81, 0x06, 0xc5, 0xe3, 0xb2, 0x33, 0xdf, 0xec, 0x2c,
    0xdd, 0x5d, 0xcc, 0x46, 0xeb, 0xe0, 0x13, 0xa1, 0x62, 0x4e, 0x08, 0x6e, 0xb0, 0x66, 0x1a, 0x83,
    0x8c, 0xba, 0x4e, 0x60, 0x8f, 0xab, 0x49, 0x46, 0xf0, 0xd8, 0x1d, 0x66, 0x61, 0x34, 0xac, 0x09,
    0xc7, 0x21, 0x44, 0x20, 0x7c, 0x3f, 0x9e, 0x41, 0x61, 0x53, 0xd1, 0x65, 0x3f, 0x51, 0x16, 0x64,
    0xbc, 0x53, 0x5c, 0xd0, 0xf0, 0xc2, 0xc8, 0x26, 0xc2, 0x9f, 0x42, 0x96, 0xb7, 0x65, 0x94, 0xf1,
    0x09, 0xa5, 0x57, 0x50, 0x37, 0x6d, 0x5f, 0xd0, 0x15, 0x19, 0xce, 0x38, 0xd8, 0x4a, 0x94, 0x5f,
    0x5f, 0xd4, 0xf6, 0x9f, 0xad, 0xd9, 0x03, 0x51, 0xcc, 0x49, 0x80, 0xec, 0x3d, 0x2a, 0x4f, 0xdd,
    0x12, 0xea, 0xef, 0xd7, 0x20, 0x5c, 0xf1, 0x87, 0x4a, 0x5c, 0x60, 0x34, 0xfe, 0x54, 0xdd, 0x00,
    0xbe, 0x19, 0xb5, 0xd0
};
#endif

PyTypeObject *init_KSystemClipboard(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX].type;

    Shiboken::AutoDecRef Sbk_KSystemClipboard_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KSystemClipboard_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KSystemClipboard",
        "KSystemClipboard*",
        &Sbk_KSystemClipboard_spec,
        &Shiboken::callCppDestructor< KSystemClipboard >,
        Sbk_KSystemClipboard_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KSystemClipboard_Type; // references _Sbk_KSystemClipboard_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KSystemClipboard_SignatureStrings);
#else
    InitSignatureBytes(pyType, KSystemClipboard_SignatureBytes, KSystemClipboard_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KSystemClipboard_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KSystemClipboard_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KSystemClipboard_PythonToCpp_KSystemClipboard_PTR,
        is_KSystemClipboard_PythonToCpp_KSystemClipboard_PTR_Convertible,
        KSystemClipboard_PTR_CppToPython_KSystemClipboard);

    Shiboken::Conversions::registerConverterName(converter, "KSystemClipboard");
    Shiboken::Conversions::registerConverterName(converter, "KSystemClipboard*");
    Shiboken::Conversions::registerConverterName(converter, "KSystemClipboard&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KSystemClipboard).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KSystemClipboardWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KSystemClipboard_TypeF(), &Sbk_KSystemClipboard_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KSystemClipboard::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KSystemClipboard::staticMetaObject, sizeof(KSystemClipboardWrapper));

    return pyType;
}
