/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once

#include "core/textautogenerateattachmentutils.h"
#include "textautogeneratetext_private_export.h"
#include <QWidget>
class QToolButton;
namespace TextAutoGenerateText
{
class TextAutoGenerateTextLineEdit;
class TextAutoGenerateManager;
class TextAutoGenerateToolsWidget;
class TextAutoGenerateTextLineEditAttachmentWidget;
/**
 * @brief The TextAutoGenerateTextLineEditWidget class
 * \author Laurent Montel <montel@kde.org>
 */
class TEXTAUTOGENERATETEXT_TESTS_EXPORT TextAutoGenerateTextLineEditWidget : public QWidget
{
    Q_OBJECT
public:
    explicit TextAutoGenerateTextLineEditWidget(TextAutoGenerateText::TextAutoGenerateManager *manager, QWidget *parent = nullptr);
    ~TextAutoGenerateTextLineEditWidget() override;

    [[nodiscard]] QString text() const;

    [[nodiscard]] QByteArray uuid() const;
    void setUuid(const QByteArray &newUuid);

    void setText(const QString &str);

    [[nodiscard]] QByteArray chatId() const;
    void setChatId(const QByteArray &newChatId);

    void setActivatedTools(const QList<QByteArray> &lst);
    [[nodiscard]] QList<QByteArray> activatedTools() const;

Q_SIGNALS:
    void editingFinished(const QString &str,
                         const QByteArray &uuid,
                         const QList<QByteArray> &lstTools,
                         const QList<TextAutoGenerateText::TextAutoGenerateAttachmentUtils::AttachmentElementInfo> &attachmentInfoList);
    void keyPressed(QKeyEvent *ev);

private:
    TEXTAUTOGENERATETEXT_NO_EXPORT void clearLineEdit();
    TEXTAUTOGENERATETEXT_NO_EXPORT void updateEnableState();
    TEXTAUTOGENERATETEXT_NO_EXPORT void slotCurrentModelChanged();
    TEXTAUTOGENERATETEXT_NO_EXPORT void updateAttachmentButton(bool state);
    TextAutoGenerateTextLineEdit *const mTextAutoGenerateTextLineEdit;
    TextAutoGenerateToolsWidget *const mTextAutoGenerateToolsWidget;
    TextAutoGenerateTextLineEditAttachmentWidget *const mTextLineEditAttachmentWidget;
    QToolButton *const mSendMessage;
    QToolButton *const mAttachFile;
    QToolButton *const mConfigureTools;
    TextAutoGenerateText::TextAutoGenerateManager *const mManager;
    QByteArray mUuid;
};
}
