/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// JSONPatchApplyConfiguration represents a declarative configuration of the JSONPatch type for use
// with apply.
//
// JSONPatch defines a JSON Patch.
type JSONPatchApplyConfiguration struct {
	// expression will be evaluated by CEL to create a [JSON patch](https://jsonpatch.com/).
	// ref: https://github.com/google/cel-spec
	//
	// expression must return an array of JSONPatch values.
	//
	// For example, this CEL expression returns a JSON patch to conditionally modify a value:
	//
	// [
	// JSONPatch{op: "test", path: "/spec/example", value: "Red"},
	// JSONPatch{op: "replace", path: "/spec/example", value: "Green"}
	// ]
	//
	// To define an object for the patch value, use Object types. For example:
	//
	// [
	// JSONPatch{
	// op: "add",
	// path: "/spec/selector",
	// value: Object.spec.selector{matchLabels: {"environment": "test"}}
	// }
	// ]
	//
	// To use strings containing '/' and '~' as JSONPatch path keys, use "jsonpatch.escapeKey". For example:
	//
	// [
	// JSONPatch{
	// op: "add",
	// path: "/metadata/labels/" + jsonpatch.escapeKey("example.com/environment"),
	// value: "test"
	// },
	// ]
	//
	// CEL expressions have access to the types needed to create JSON patches and objects:
	//
	// - 'JSONPatch' - CEL type of JSON Patch operations. JSONPatch has the fields 'op', 'from', 'path' and 'value'.
	// See [JSON patch](https://jsonpatch.com/) for more details. The 'value' field may be set to any of: string,
	// integer, array, map or object.  If set, the 'path' and 'from' fields must be set to a
	// [JSON pointer](https://datatracker.ietf.org/doc/html/rfc6901/) string, where the 'jsonpatch.escapeKey()' CEL
	// function may be used to escape path keys containing '/' and '~'.
	// - 'Object' - CEL type of the resource object.
	// - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec')
	// - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')
	//
	// CEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:
	//
	// - 'object' - The object from the incoming request. The value is null for DELETE requests.
	// - 'oldObject' - The existing object. The value is null for CREATE requests.
	// - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)).
	// - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind.
	// - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources.
	// - 'variables' - Map of composited variables, from its name to its lazily evaluated value.
	// For example, a variable named 'foo' can be accessed as 'variables.foo'.
	// - 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.
	// See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz
	// - 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the
	// request resource.
	//
	// CEL expressions have access to [Kubernetes CEL function libraries](https://kubernetes.io/docs/reference/using-api/cel/#cel-options-language-features-and-libraries)
	// as well as:
	//
	// - 'jsonpatch.escapeKey' - Performs JSONPatch key escaping. '~' and  '/' are escaped as '~0' and `~1' respectively).
	//
	// Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible.
	// Required.
	Expression *string `json:"expression,omitempty"`
}

// JSONPatchApplyConfiguration constructs a declarative configuration of the JSONPatch type for use with
// apply.
func JSONPatch() *JSONPatchApplyConfiguration {
	return &JSONPatchApplyConfiguration{}
}

// WithExpression sets the Expression field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Expression field is set to the value of the last call.
func (b *JSONPatchApplyConfiguration) WithExpression(value string) *JSONPatchApplyConfiguration {
	b.Expression = &value
	return b
}
