#include "nv_push_clcb97.h"

#include <stdio.h>





const char *P_PARSE_NVC997_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC997_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVCB97_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVC997_MTHD(idx);

            case NVCB97_SET_NOTIFY_A:
        return "NVCB97_SET_NOTIFY_A";
                                                                                                case NVCB97_SET_REPORT_SEMAPHORE_ADDRESS_UPPER:
        return "NVCB97_SET_REPORT_SEMAPHORE_ADDRESS_UPPER";
                case NVCB97_OFFSET_OUT_UPPER:
        return "NVCB97_OFFSET_OUT_UPPER";
                                                case NVCB97_SET_I2M_SEMAPHORE_A:
        return "NVCB97_SET_I2M_SEMAPHORE_A";
                                                                                                                                                                                                                                                                                                                                                                                    case NVCB97_SET_MME_MEM_ADDRESS_A:
        return "NVCB97_SET_MME_MEM_ADDRESS_A";
                                                                                        case NVCB97_SET_SHADER_LOCAL_MEMORY_C:
        return "NVCB97_SET_SHADER_LOCAL_MEMORY_C";
                    case NVCB97_SET_TEXTURE_HEADER_VERSION:
        return "NVCB97_SET_TEXTURE_HEADER_VERSION";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                case NVCB97_SET_ZT_FORMAT:
        return "NVCB97_SET_ZT_FORMAT";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case NVCB97_SET_REPORT_SEMAPHORE_A:
        return "NVCB97_SET_REPORT_SEMAPHORE_A";
                                                                                                                                                                                                                                                                                                                                                                                    
    }
}

void
P_DUMP_NVCB97_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVC997_MTHD_DATA(fp, idx, data, prefix);
    break;

          
    case NVCB97_SET_NOTIFY_A:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                              
    case NVCB97_SET_REPORT_SEMAPHORE_ADDRESS_UPPER:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
              
    case NVCB97_OFFSET_OUT_UPPER:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                              
    case NVCB97_SET_I2M_SEMAPHORE_A:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                                                                                                  
    case NVCB97_SET_MME_MEM_ADDRESS_A:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                      
    case NVCB97_SET_SHADER_LOCAL_MEMORY_C:

    
        parsed = (data >> 0) & ((1u << 7) - 1);
        fprintf(fp, "%s.SIZE_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                  
    case NVCB97_SET_TEXTURE_HEADER_VERSION:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                              
    case NVCB97_SET_ZT_FORMAT:

    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVCB97_SET_ZT_FORMAT_V_Z16:
            fprintf(fp, "Z16\n");
            break;
        case NVCB97_SET_ZT_FORMAT_V_Z24S8:
            fprintf(fp, "Z24S8\n");
            break;
        case NVCB97_SET_ZT_FORMAT_V_X8Z24:
            fprintf(fp, "X8Z24\n");
            break;
        case NVCB97_SET_ZT_FORMAT_V_S8Z24:
            fprintf(fp, "S8Z24\n");
            break;
        case NVCB97_SET_ZT_FORMAT_V_S8:
            fprintf(fp, "S8\n");
            break;
        case NVCB97_SET_ZT_FORMAT_V_ZF32:
            fprintf(fp, "ZF32\n");
            break;
        case NVCB97_SET_ZT_FORMAT_V_ZF32_X24S8:
            fprintf(fp, "ZF32_X24S8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
    case NVCB97_SET_REPORT_SEMAPHORE_A:

    
        parsed = (data >> 0) & ((1u << 25) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                                                                                                        }
}
