/* SPDX-FileCopyrightText: 2003 - Gustavo Giráldez <gustavo.giraldez@gmx.net>
 * SPDX-FileCopyrightText: 2005, 2006 - Marco Barisione, Emanuele Aina
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <glib.h>
#include "gtksourceinternal.h"

G_BEGIN_DECLS

typedef struct _GtkSourceRegex GtkSourceRegex;

GTK_SOURCE_INTERNAL
GtkSourceRegex	*_gtk_source_regex_new		(const gchar         *pattern,
						 GRegexCompileFlags   flags,
						 GError             **error);

GTK_SOURCE_INTERNAL
GtkSourceRegex	*_gtk_source_regex_ref		(GtkSourceRegex *regex);

GTK_SOURCE_INTERNAL
void		 _gtk_source_regex_unref	(GtkSourceRegex *regex);

GTK_SOURCE_INTERNAL
GtkSourceRegex	*_gtk_source_regex_resolve	(GtkSourceRegex *regex,
						 GtkSourceRegex *start_regex,
						 const gchar    *matched_text);

GTK_SOURCE_INTERNAL
gboolean	 _gtk_source_regex_is_resolved	(GtkSourceRegex *regex);

GTK_SOURCE_INTERNAL
gboolean	_gtk_source_regex_match		(GtkSourceRegex *regex,
						 const gchar    *line,
						 gint             byte_length,
						 gint             byte_pos);

GTK_SOURCE_INTERNAL
gchar		*_gtk_source_regex_fetch	(GtkSourceRegex *regex,
						 gint            num);

GTK_SOURCE_INTERNAL
void		 _gtk_source_regex_fetch_pos	(GtkSourceRegex *regex,
						 const gchar    *text,
						 gint            num,
						 gint           *start_pos, /* character offsets */
						 gint           *end_pos);  /* character offsets */

GTK_SOURCE_INTERNAL
void		 _gtk_source_regex_fetch_pos_bytes (GtkSourceRegex *regex,
						    gint            num,
						    gint           *start_pos_p, /* byte offsets */
						    gint           *end_pos_p);  /* byte offsets */

GTK_SOURCE_INTERNAL
void		 _gtk_source_regex_fetch_named_pos (GtkSourceRegex *regex,
						    const gchar    *text,
						    const gchar    *name,
						    gint           *start_pos, /* character offsets */
						    gint           *end_pos);  /* character offsets */

GTK_SOURCE_INTERNAL
const gchar	*_gtk_source_regex_get_pattern	(GtkSourceRegex *regex);

G_END_DECLS
