/* WingpanelManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WingpanelManager.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/meta-plugin.h>
#include <gio/gio.h>
#include <meta/meta-workspace-manager.h>
#include <meta/display.h>
#include <meta/common.h>
#include <meta/meta-background-group.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <string.h>
#include <stdlib.h>

#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_MINIMIZE_DURATION 200
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_SNAP_DURATION 250
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_WALLPAPER_TRANSITION_DURATION 150
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_WORKSPACE_SWITCH_DURATION 300
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_ACUTANCE_THRESHOLD ((gdouble) 8)
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_STD_THRESHOLD ((gdouble) 45)
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_LUMINANCE_THRESHOLD ((gdouble) 180)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BACKGROUND_STATE_LIGHT,
	BACKGROUND_STATE_DARK,
	BACKGROUND_STATE_MAXIMIZED,
	BACKGROUND_STATE_TRANSLUCENT_DARK,
	BACKGROUND_STATE_TRANSLUCENT_LIGHT
} BackgroundState;

#define TYPE_BACKGROUND_STATE (background_state_get_type ())

#define GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER (greeter_compositor_wingpanel_manager_get_type ())
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, GreeterCompositorWingpanelManager))
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, GreeterCompositorWingpanelManagerClass))
#define GREETER_COMPOSITOR_IS_WINGPANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER))
#define GREETER_COMPOSITOR_IS_WINGPANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER))
#define GREETER_COMPOSITOR_WINGPANEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, GreeterCompositorWingpanelManagerClass))

typedef struct _GreeterCompositorWingpanelManager GreeterCompositorWingpanelManager;
typedef struct _GreeterCompositorWingpanelManagerClass GreeterCompositorWingpanelManagerClass;
typedef struct _GreeterCompositorWingpanelManagerPrivate GreeterCompositorWingpanelManagerPrivate;

#define GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_COLOR_INFORMATION (greeter_compositor_background_utils_color_information_get_type ())
typedef struct _GreeterCompositorBackgroundUtilsColorInformation GreeterCompositorBackgroundUtilsColorInformation;
enum  {
	GREETER_COMPOSITOR_WINGPANEL_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_WINGPANEL_MANAGER_PANEL_HEIGHT_PROPERTY,
	GREETER_COMPOSITOR_WINGPANEL_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_wingpanel_manager_properties[GREETER_COMPOSITOR_WINGPANEL_MANAGER_NUM_PROPERTIES];

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
#define _greeter_compositor_background_utils_color_information_free0(var) ((var == NULL) ? NULL : (var = (greeter_compositor_background_utils_color_information_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GreeterCompositorWingpanelManagerUpdateBkColorInfoData GreeterCompositorWingpanelManagerUpdateBkColorInfoData;
enum  {
	GREETER_COMPOSITOR_WINGPANEL_MANAGER_STATE_CHANGED_SIGNAL,
	GREETER_COMPOSITOR_WINGPANEL_MANAGER_NUM_SIGNALS
};
static guint greeter_compositor_wingpanel_manager_signals[GREETER_COMPOSITOR_WINGPANEL_MANAGER_NUM_SIGNALS] = {0};

struct _GreeterCompositorWingpanelManager {
	GObject parent_instance;
	GreeterCompositorWingpanelManagerPrivate * priv;
};

struct _GreeterCompositorWingpanelManagerClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorBackgroundUtilsColorInformation {
	gdouble average_red;
	gdouble average_green;
	gdouble average_blue;
	gdouble mean_luminance;
	gdouble luminance_variance;
	gdouble mean_acutance;
};

struct _GreeterCompositorWingpanelManagerPrivate {
	gint _panel_height;
	BackgroundState current_state;
	GreeterCompositorBackgroundUtilsColorInformation* bk_color_info;
};

struct _Block17Data {
	int _ref_count_;
	GreeterCompositorWingpanelManager* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _GreeterCompositorWingpanelManagerUpdateBkColorInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorWingpanelManager* self;
	Block17Data* _data17_;
	gint monitor;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle monitor_geometry;
	GreeterCompositorWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MtkRectangle _tmp4_;
	GreeterCompositorWindowManager* _tmp5_;
	MtkRectangle _tmp6_;
	gint _tmp7_;
};

static gint GreeterCompositorWingpanelManager_private_offset;
static gpointer greeter_compositor_wingpanel_manager_parent_class = NULL;
static GreeterCompositorWindowManager* greeter_compositor_wingpanel_manager_wm;
static GreeterCompositorWindowManager* greeter_compositor_wingpanel_manager_wm = NULL;

VALA_EXTERN GType background_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType greeter_compositor_wingpanel_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWingpanelManager, g_object_unref)
VALA_EXTERN GType greeter_compositor_background_utils_color_information_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterCompositorBackgroundUtilsColorInformation* greeter_compositor_background_utils_color_information_dup (const GreeterCompositorBackgroundUtilsColorInformation* self);
VALA_EXTERN void greeter_compositor_background_utils_color_information_free (GreeterCompositorBackgroundUtilsColorInformation* self);
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN GreeterCompositorWingpanelManager* greeter_compositor_wingpanel_manager_new (GreeterCompositorWindowManager* _wm,
                                                                             gint panel_height);
VALA_EXTERN GreeterCompositorWingpanelManager* greeter_compositor_wingpanel_manager_construct (GType object_type,
                                                                                   GreeterCompositorWindowManager* _wm,
                                                                                   gint panel_height);
static void greeter_compositor_wingpanel_manager_connect_signals (GreeterCompositorWingpanelManager* self);
VALA_EXTERN void greeter_compositor_wingpanel_manager_update_bk_color_info (GreeterCompositorWingpanelManager* self,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
VALA_EXTERN void greeter_compositor_wingpanel_manager_update_bk_color_info_finish (GreeterCompositorWingpanelManager* self,
                                                                       GAsyncResult* _res_);
static void __lambda48_ (GreeterCompositorWingpanelManager* self,
                  GObject* obj,
                  GAsyncResult* res);
static void greeter_compositor_wingpanel_manager_update_current_workspace (GreeterCompositorWingpanelManager* self);
static void ___lambda48__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda34_ (GreeterCompositorWingpanelManager* self);
static void ___lambda34__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                             gint object,
                                                             gint p0,
                                                             MetaMotionDirection p1,
                                                             gpointer self);
VALA_EXTERN MetaBackgroundGroup* greeter_compositor_window_manager_get_background_group (GreeterCompositorWindowManager* self);
static gboolean __lambda39_ (GreeterCompositorWingpanelManager* self,
                      GSignalInvocationHint* ihint,
                      GValue* param_values,
                      guint param_values_length1);
static void __lambda47_ (GreeterCompositorWingpanelManager* self,
                  GObject* obj,
                  GAsyncResult* res);
static void greeter_compositor_wingpanel_manager_check_for_state_change (GreeterCompositorWingpanelManager* self,
                                                                  guint animation_duration);
static void ___lambda47__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean ___lambda39__gsignal_emission_hook (GSignalInvocationHint* ihint,
                                             guint n_param_values,
                                             GValue* param_values,
                                             gpointer self);
static void greeter_compositor_wingpanel_manager_register_window (GreeterCompositorWingpanelManager* self,
                                                           MetaWindow* window);
static void __lambda38_ (GreeterCompositorWingpanelManager* self,
                  MetaWindow* window);
static void greeter_compositor_wingpanel_manager_on_window_added (GreeterCompositorWingpanelManager* self,
                                                           MetaWindow* window);
static void greeter_compositor_wingpanel_manager_on_window_removed (GreeterCompositorWingpanelManager* self,
                                                             MetaWindow* window);
static void _greeter_compositor_wingpanel_manager_on_window_removed_meta_window_unmanaged (MetaWindow* _sender,
                                                                                    gpointer self);
static void ___lambda38__meta_display_window_created (MetaDisplay* _sender,
                                               MetaWindow* object,
                                               gpointer self);
static void __lambda35_ (GreeterCompositorWingpanelManager* self);
static void ___lambda35__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda36_ (GreeterCompositorWingpanelManager* self);
static void ___lambda36__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda37_ (GreeterCompositorWingpanelManager* self);
static void ___lambda37__meta_window_workspace_changed (MetaWindow* _sender,
                                                 gpointer self);
static void greeter_compositor_wingpanel_manager_update_bk_color_info_data_free (gpointer _data);
static gboolean greeter_compositor_wingpanel_manager_update_bk_color_info_co (GreeterCompositorWingpanelManagerUpdateBkColorInfoData* _data_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean _greeter_compositor_wingpanel_manager_update_bk_color_info_co_gsource_func (gpointer self);
VALA_EXTERN void greeter_compositor_background_utils_get_background_color_information (GreeterCompositorWindowManager* wm,
                                                                           gint reference_x,
                                                                           gint reference_y,
                                                                           gint reference_width,
                                                                           gint reference_height,
                                                                           GAsyncReadyCallback _callback_,
                                                                           gpointer _user_data_);
VALA_EXTERN void greeter_compositor_background_utils_get_background_color_information_finish (GAsyncResult* _res_,
                                                                                  GreeterCompositorBackgroundUtilsColorInformation* result,
                                                                                  GError** error);
static gint greeter_compositor_wingpanel_manager_get_panel_height (GreeterCompositorWingpanelManager* self);
static void __lambda46_ (Block17Data* _data17_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda46__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void greeter_compositor_wingpanel_manager_set_panel_height (GreeterCompositorWingpanelManager* self,
                                                            gint value);
static void g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void greeter_compositor_wingpanel_manager_finalize (GObject * obj);
static GType greeter_compositor_wingpanel_manager_get_type_once (void);
static void _vala_greeter_compositor_wingpanel_manager_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_greeter_compositor_wingpanel_manager_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static GType
background_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKGROUND_STATE_LIGHT, "BACKGROUND_STATE_LIGHT", "light"}, {BACKGROUND_STATE_DARK, "BACKGROUND_STATE_DARK", "dark"}, {BACKGROUND_STATE_MAXIMIZED, "BACKGROUND_STATE_MAXIMIZED", "maximized"}, {BACKGROUND_STATE_TRANSLUCENT_DARK, "BACKGROUND_STATE_TRANSLUCENT_DARK", "translucent-dark"}, {BACKGROUND_STATE_TRANSLUCENT_LIGHT, "BACKGROUND_STATE_TRANSLUCENT_LIGHT", "translucent-light"}, {0, NULL, NULL}};
	GType background_state_type_id;
	background_state_type_id = g_enum_register_static ("BackgroundState", values);
	return background_state_type_id;
}

GType
background_state_get_type (void)
{
	static volatile gsize background_state_type_id__once = 0;
	if (g_once_init_enter (&background_state_type_id__once)) {
		GType background_state_type_id;
		background_state_type_id = background_state_get_type_once ();
		g_once_init_leave (&background_state_type_id__once, background_state_type_id);
	}
	return background_state_type_id__once;
}

static inline gpointer
greeter_compositor_wingpanel_manager_get_instance_private (GreeterCompositorWingpanelManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorWingpanelManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda48_ (GreeterCompositorWingpanelManager* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	greeter_compositor_wingpanel_manager_update_bk_color_info_finish (self, res);
	greeter_compositor_wingpanel_manager_update_current_workspace (self);
}

static void
___lambda48__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda48_ ((GreeterCompositorWingpanelManager*) self, source_object, res);
	g_object_unref (self);
}

GreeterCompositorWingpanelManager*
greeter_compositor_wingpanel_manager_construct (GType object_type,
                                                GreeterCompositorWindowManager* _wm,
                                                gint panel_height)
{
	GreeterCompositorWingpanelManager * self = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_val_if_fail (_wm != NULL, NULL);
	_tmp0_ = _g_object_ref0 (_wm);
	_g_object_unref0 (greeter_compositor_wingpanel_manager_wm);
	greeter_compositor_wingpanel_manager_wm = _tmp0_;
	self = (GreeterCompositorWingpanelManager*) g_object_new (object_type, "panel-height", panel_height, NULL);
	greeter_compositor_wingpanel_manager_connect_signals (self);
	greeter_compositor_wingpanel_manager_update_bk_color_info (self, ___lambda48__gasync_ready_callback, g_object_ref (self));
	return self;
}

GreeterCompositorWingpanelManager*
greeter_compositor_wingpanel_manager_new (GreeterCompositorWindowManager* _wm,
                                          gint panel_height)
{
	return greeter_compositor_wingpanel_manager_construct (GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, _wm, panel_height);
}

static void
__lambda34_ (GreeterCompositorWingpanelManager* self)
{
	greeter_compositor_wingpanel_manager_update_current_workspace (self);
}

static void
___lambda34__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                        gint object,
                                                        gint p0,
                                                        MetaMotionDirection p1,
                                                        gpointer self)
{
	__lambda34_ ((GreeterCompositorWingpanelManager*) self);
}

static void
__lambda47_ (GreeterCompositorWingpanelManager* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	greeter_compositor_wingpanel_manager_update_bk_color_info_finish (self, res);
	greeter_compositor_wingpanel_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_WINGPANEL_MANAGER_WALLPAPER_TRANSITION_DURATION);
}

static void
___lambda47__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda47_ ((GreeterCompositorWingpanelManager*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
__lambda39_ (GreeterCompositorWingpanelManager* self,
             GSignalInvocationHint* ihint,
             GValue* param_values,
             guint param_values_length1)
{
	gboolean result;
	g_return_val_if_fail (ihint != NULL, FALSE);
	greeter_compositor_wingpanel_manager_update_bk_color_info (self, ___lambda47__gasync_ready_callback, g_object_ref (self));
	result = TRUE;
	return result;
}

static gboolean
___lambda39__gsignal_emission_hook (GSignalInvocationHint* ihint,
                                    guint n_param_values,
                                    GValue* param_values,
                                    gpointer self)
{
	gboolean result;
	result = __lambda39_ ((GreeterCompositorWingpanelManager*) self, ihint, param_values, n_param_values);
	return result;
}

static void
greeter_compositor_wingpanel_manager_connect_signals (GreeterCompositorWingpanelManager* self)
{
	MetaWorkspaceManager* manager = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	guint signal_id = 0U;
	GreeterCompositorWindowManager* _tmp3_;
	MetaBackgroundGroup* _tmp4_;
	MetaBackgroundGroup* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = greeter_compositor_wingpanel_manager_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	g_signal_connect_object (manager, "workspace-switched", (GCallback) ___lambda34__meta_workspace_manager_workspace_switched, self, 0);
	_tmp3_ = greeter_compositor_wingpanel_manager_wm;
	_tmp4_ = greeter_compositor_window_manager_get_background_group (_tmp3_);
	_tmp5_ = _tmp4_;
	signal_id = g_signal_lookup ("changed", G_TYPE_FROM_INSTANCE ((GObject*) _tmp5_));
	g_signal_add_emission_hook (signal_id, (GQuark) 0, ___lambda39__gsignal_emission_hook, g_object_ref (self), g_object_unref);
}

static void
_greeter_compositor_wingpanel_manager_on_window_removed_meta_window_unmanaged (MetaWindow* _sender,
                                                                               gpointer self)
{
	greeter_compositor_wingpanel_manager_on_window_removed ((GreeterCompositorWingpanelManager*) self, _sender);
}

static void
__lambda38_ (GreeterCompositorWingpanelManager* self,
             MetaWindow* window)
{
	g_return_if_fail (window != NULL);
	greeter_compositor_wingpanel_manager_on_window_added (self, window);
	g_signal_connect_object (window, "unmanaged", (GCallback) _greeter_compositor_wingpanel_manager_on_window_removed_meta_window_unmanaged, self, 0);
}

static void
___lambda38__meta_display_window_created (MetaDisplay* _sender,
                                          MetaWindow* object,
                                          gpointer self)
{
	__lambda38_ ((GreeterCompositorWingpanelManager*) self, object);
}

static void
greeter_compositor_wingpanel_manager_update_current_workspace (GreeterCompositorWingpanelManager* self)
{
	MetaDisplay* display = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	GList* _tmp3_;
	MetaDisplay* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = greeter_compositor_wingpanel_manager_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_display_list_all_windows (_tmp2_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp4_;
				_tmp4_ = window;
				if (meta_window_is_on_primary_monitor (_tmp4_)) {
					MetaWindow* _tmp5_;
					_tmp5_ = window;
					greeter_compositor_wingpanel_manager_register_window (self, _tmp5_);
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	_tmp6_ = display;
	g_signal_connect_object (_tmp6_, "window-created", (GCallback) ___lambda38__meta_display_window_created, self, 0);
	greeter_compositor_wingpanel_manager_check_for_state_change (self, (guint) 0);
}

static void
__lambda35_ (GreeterCompositorWingpanelManager* self)
{
	greeter_compositor_wingpanel_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_WINGPANEL_MANAGER_SNAP_DURATION);
}

static void
___lambda35__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda35_ ((GreeterCompositorWingpanelManager*) self);
}

static void
__lambda36_ (GreeterCompositorWingpanelManager* self)
{
	greeter_compositor_wingpanel_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_WINGPANEL_MANAGER_MINIMIZE_DURATION);
}

static void
___lambda36__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda36_ ((GreeterCompositorWingpanelManager*) self);
}

static void
__lambda37_ (GreeterCompositorWingpanelManager* self)
{
	greeter_compositor_wingpanel_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_WINGPANEL_MANAGER_WORKSPACE_SWITCH_DURATION);
}

static void
___lambda37__meta_window_workspace_changed (MetaWindow* _sender,
                                            gpointer self)
{
	__lambda37_ ((GreeterCompositorWingpanelManager*) self);
}

static void
greeter_compositor_wingpanel_manager_register_window (GreeterCompositorWingpanelManager* self,
                                                      MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_connect_object ((GObject*) window, "notify::maximized-vertically", (GCallback) ___lambda35__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) window, "notify::minimized", (GCallback) ___lambda36__g_object_notify, self, 0);
	g_signal_connect_object (window, "workspace-changed", (GCallback) ___lambda37__meta_window_workspace_changed, self, 0);
}

static void
greeter_compositor_wingpanel_manager_on_window_added (GreeterCompositorWingpanelManager* self,
                                                      MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	greeter_compositor_wingpanel_manager_register_window (self, window);
	greeter_compositor_wingpanel_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_WINGPANEL_MANAGER_SNAP_DURATION);
}

static void
greeter_compositor_wingpanel_manager_on_window_removed (GreeterCompositorWingpanelManager* self,
                                                        MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	greeter_compositor_wingpanel_manager_check_for_state_change (self, (guint) GREETER_COMPOSITOR_WINGPANEL_MANAGER_SNAP_DURATION);
}

static void
greeter_compositor_wingpanel_manager_update_bk_color_info_data_free (gpointer _data)
{
	GreeterCompositorWingpanelManagerUpdateBkColorInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterCompositorWingpanelManagerUpdateBkColorInfoData, _data_);
}

void
greeter_compositor_wingpanel_manager_update_bk_color_info (GreeterCompositorWingpanelManager* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	GreeterCompositorWingpanelManagerUpdateBkColorInfoData* _data_;
	GreeterCompositorWingpanelManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GreeterCompositorWingpanelManagerUpdateBkColorInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_wingpanel_manager_update_bk_color_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	greeter_compositor_wingpanel_manager_update_bk_color_info_co (_data_);
}

void
greeter_compositor_wingpanel_manager_update_bk_color_info_finish (GreeterCompositorWingpanelManager* self,
                                                                  GAsyncResult* _res_)
{
	GreeterCompositorWingpanelManagerUpdateBkColorInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		GreeterCompositorWingpanelManager* self;
		self = _data17_->self;
		(_data17_->callback_target_destroy_notify == NULL) ? NULL : (_data17_->callback_target_destroy_notify (_data17_->callback_target), NULL);
		_data17_->callback = NULL;
		_data17_->callback_target = NULL;
		_data17_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
_greeter_compositor_wingpanel_manager_update_bk_color_info_co_gsource_func (gpointer self)
{
	gboolean result;
	result = greeter_compositor_wingpanel_manager_update_bk_color_info_co (self);
	return result;
}

static gpointer
_greeter_compositor_background_utils_color_information_dup0 (gpointer self)
{
	return self ? greeter_compositor_background_utils_color_information_dup (self) : NULL;
}

static void
__lambda46_ (Block17Data* _data17_,
             GObject* obj,
             GAsyncResult* res)
{
	GreeterCompositorWingpanelManager* self;
	GError* _inner_error0_ = NULL;
	self = _data17_->self;
	g_return_if_fail (res != NULL);
	{
		GreeterCompositorBackgroundUtilsColorInformation _tmp0_ = {0};
		GreeterCompositorBackgroundUtilsColorInformation _tmp1_ = {0};
		GreeterCompositorBackgroundUtilsColorInformation* _tmp2_;
		greeter_compositor_background_utils_get_background_color_information_finish (res, &_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _greeter_compositor_background_utils_color_information_dup0 (&_tmp0_);
		_greeter_compositor_background_utils_color_information_free0 (self->priv->bk_color_info);
		self->priv->bk_color_info = _tmp2_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("WingpanelManager.vala:126: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		_data17_->callback (_data17_->callback_target);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda46__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda46_ (self, source_object, res);
	block17_data_unref (self);
}

static gboolean
greeter_compositor_wingpanel_manager_update_bk_color_info_co (GreeterCompositorWingpanelManagerUpdateBkColorInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data17_ = g_slice_new0 (Block17Data);
	_data_->_data17_->_ref_count_ = 1;
	_data_->_data17_->self = g_object_ref (_data_->self);
	_data_->_data17_->_async_data_ = _data_;
	_data_->_data17_->callback = _greeter_compositor_wingpanel_manager_update_bk_color_info_co_gsource_func;
	_data_->_data17_->callback_target = _data_;
	_data_->_data17_->callback_target_destroy_notify = NULL;
	_data_->_tmp0_ = greeter_compositor_wingpanel_manager_wm;
	_data_->_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _data_->_tmp0_);
	_data_->monitor = meta_display_get_primary_monitor (_data_->_tmp1_);
	_data_->_tmp2_ = greeter_compositor_wingpanel_manager_wm;
	_data_->_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _data_->_tmp2_);
	memset (&_data_->_tmp4_, 0, sizeof (MtkRectangle));
	meta_display_get_monitor_geometry (_data_->_tmp3_, _data_->monitor, &_data_->_tmp4_);
	_data_->monitor_geometry = _data_->_tmp4_;
	_data_->_tmp5_ = greeter_compositor_wingpanel_manager_wm;
	_data_->_tmp6_ = _data_->monitor_geometry;
	_data_->_tmp7_ = _data_->self->priv->_panel_height;
	greeter_compositor_background_utils_get_background_color_information (_data_->_tmp5_, 0, 0, _data_->_tmp6_.width, _data_->_tmp7_, ___lambda46__gasync_ready_callback, block17_data_ref (_data_->_data17_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block17_data_unref (_data_->_data17_);
	_data_->_data17_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Check if Wingpanel's background state should change.
     *
     * The state is defined as follows:
     *  - If there's a maximized window, the state should be MAXIMIZED;
     *  - If no information about the background could be gathered, it should be TRANSLUCENT;
     *  - If there's too much contrast or sharpness, it should be TRANSLUCENT;
     *  - If the background is too bright, it should be DARK;
     *  - Else it should be LIGHT.
     */
static void
greeter_compositor_wingpanel_manager_check_for_state_change (GreeterCompositorWingpanelManager* self,
                                                             guint animation_duration)
{
	gboolean has_maximized_window = FALSE;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GList* _tmp2_;
	BackgroundState new_state = 0;
	g_return_if_fail (self != NULL);
	has_maximized_window = FALSE;
	_tmp0_ = greeter_compositor_wingpanel_manager_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_list_all_windows (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* _tmp3_;
			MetaWindow* window = NULL;
			_tmp3_ = _g_object_ref0 ((MetaWindow*) window_it->data);
			window = _tmp3_;
			{
				MetaWindow* _tmp4_;
				_tmp4_ = window;
				if (meta_window_is_on_primary_monitor (_tmp4_)) {
					gboolean _tmp5_ = FALSE;
					MetaWindow* _tmp6_;
					gboolean _tmp7_;
					gboolean _tmp8_;
					_tmp6_ = window;
					g_object_get (_tmp6_, "minimized", &_tmp7_, NULL);
					_tmp8_ = _tmp7_;
					if (!_tmp8_) {
						MetaWindow* _tmp9_;
						gboolean _tmp10_;
						gboolean _tmp11_;
						_tmp9_ = window;
						g_object_get (_tmp9_, "maximized-vertically", &_tmp10_, NULL);
						_tmp11_ = _tmp10_;
						_tmp5_ = _tmp11_;
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						has_maximized_window = TRUE;
						_g_object_unref0 (window);
						break;
					}
				}
				_g_object_unref0 (window);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	if (has_maximized_window) {
		new_state = BACKGROUND_STATE_MAXIMIZED;
	} else {
		GreeterCompositorBackgroundUtilsColorInformation* _tmp12_;
		_tmp12_ = self->priv->bk_color_info;
		if (_tmp12_ == NULL) {
			new_state = BACKGROUND_STATE_TRANSLUCENT_LIGHT;
		} else {
			gdouble luminance_std = 0.0;
			GreeterCompositorBackgroundUtilsColorInformation* _tmp13_;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean bg_is_busy = FALSE;
			gboolean bg_is_dark = FALSE;
			GreeterCompositorBackgroundUtilsColorInformation* _tmp20_;
			gboolean bg_is_busy_dark = FALSE;
			GreeterCompositorBackgroundUtilsColorInformation* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp13_ = self->priv->bk_color_info;
			luminance_std = sqrt ((*_tmp13_).luminance_variance);
			if (luminance_std > GREETER_COMPOSITOR_WINGPANEL_MANAGER_STD_THRESHOLD) {
				_tmp15_ = TRUE;
			} else {
				gboolean _tmp16_ = FALSE;
				GreeterCompositorBackgroundUtilsColorInformation* _tmp17_;
				_tmp17_ = self->priv->bk_color_info;
				if ((*_tmp17_).mean_luminance < GREETER_COMPOSITOR_WINGPANEL_MANAGER_LUMINANCE_THRESHOLD) {
					GreeterCompositorBackgroundUtilsColorInformation* _tmp18_;
					_tmp18_ = self->priv->bk_color_info;
					_tmp16_ = ((*_tmp18_).mean_luminance + (1.645 * luminance_std)) > GREETER_COMPOSITOR_WINGPANEL_MANAGER_LUMINANCE_THRESHOLD;
				} else {
					_tmp16_ = FALSE;
				}
				_tmp15_ = _tmp16_;
			}
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				GreeterCompositorBackgroundUtilsColorInformation* _tmp19_;
				_tmp19_ = self->priv->bk_color_info;
				_tmp14_ = (*_tmp19_).mean_acutance > GREETER_COMPOSITOR_WINGPANEL_MANAGER_ACUTANCE_THRESHOLD;
			}
			bg_is_busy = _tmp14_;
			_tmp20_ = self->priv->bk_color_info;
			bg_is_dark = (*_tmp20_).mean_luminance > GREETER_COMPOSITOR_WINGPANEL_MANAGER_LUMINANCE_THRESHOLD;
			_tmp21_ = self->priv->bk_color_info;
			bg_is_busy_dark = ((*_tmp21_).mean_luminance * 1.25) > GREETER_COMPOSITOR_WINGPANEL_MANAGER_LUMINANCE_THRESHOLD;
			if (bg_is_busy) {
				_tmp22_ = bg_is_busy_dark;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				new_state = BACKGROUND_STATE_TRANSLUCENT_DARK;
			} else {
				if (bg_is_busy) {
					new_state = BACKGROUND_STATE_TRANSLUCENT_LIGHT;
				} else {
					if (bg_is_dark) {
						new_state = BACKGROUND_STATE_DARK;
					} else {
						new_state = BACKGROUND_STATE_LIGHT;
					}
				}
			}
		}
	}
	if (new_state != self->priv->current_state) {
		self->priv->current_state = new_state;
		g_signal_emit (self, greeter_compositor_wingpanel_manager_signals[GREETER_COMPOSITOR_WINGPANEL_MANAGER_STATE_CHANGED_SIGNAL], 0, self->priv->current_state, animation_duration);
	}
}

static gint
greeter_compositor_wingpanel_manager_get_panel_height (GreeterCompositorWingpanelManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_panel_height;
	return result;
}

static void
greeter_compositor_wingpanel_manager_set_panel_height (GreeterCompositorWingpanelManager* self,
                                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_wingpanel_manager_get_panel_height (self);
	if (old_value != value) {
		self->priv->_panel_height = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_wingpanel_manager_properties[GREETER_COMPOSITOR_WINGPANEL_MANAGER_PANEL_HEIGHT_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__ENUM_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_UINT) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
greeter_compositor_wingpanel_manager_class_init (GreeterCompositorWingpanelManagerClass * klass,
                                                 gpointer klass_data)
{
	greeter_compositor_wingpanel_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorWingpanelManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_wingpanel_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_wingpanel_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_wingpanel_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_WINGPANEL_MANAGER_PANEL_HEIGHT_PROPERTY, greeter_compositor_wingpanel_manager_properties[GREETER_COMPOSITOR_WINGPANEL_MANAGER_PANEL_HEIGHT_PROPERTY] = g_param_spec_int ("panel-height", "panel-height", "panel-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	greeter_compositor_wingpanel_manager_signals[GREETER_COMPOSITOR_WINGPANEL_MANAGER_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_UINT, G_TYPE_NONE, 2, TYPE_BACKGROUND_STATE, G_TYPE_UINT);
}

static void
greeter_compositor_wingpanel_manager_instance_init (GreeterCompositorWingpanelManager * self,
                                                    gpointer klass)
{
	self->priv = greeter_compositor_wingpanel_manager_get_instance_private (self);
	self->priv->current_state = BACKGROUND_STATE_LIGHT;
	self->priv->bk_color_info = NULL;
}

static void
greeter_compositor_wingpanel_manager_finalize (GObject * obj)
{
	GreeterCompositorWingpanelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, GreeterCompositorWingpanelManager);
	_greeter_compositor_background_utils_color_information_free0 (self->priv->bk_color_info);
	G_OBJECT_CLASS (greeter_compositor_wingpanel_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_wingpanel_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorWingpanelManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_wingpanel_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorWingpanelManager), 0, (GInstanceInitFunc) greeter_compositor_wingpanel_manager_instance_init, NULL };
	GType greeter_compositor_wingpanel_manager_type_id;
	greeter_compositor_wingpanel_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorWingpanelManager", &g_define_type_info, 0);
	GreeterCompositorWingpanelManager_private_offset = g_type_add_instance_private (greeter_compositor_wingpanel_manager_type_id, sizeof (GreeterCompositorWingpanelManagerPrivate));
	return greeter_compositor_wingpanel_manager_type_id;
}

GType
greeter_compositor_wingpanel_manager_get_type (void)
{
	static volatile gsize greeter_compositor_wingpanel_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_wingpanel_manager_type_id__once)) {
		GType greeter_compositor_wingpanel_manager_type_id;
		greeter_compositor_wingpanel_manager_type_id = greeter_compositor_wingpanel_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_wingpanel_manager_type_id__once, greeter_compositor_wingpanel_manager_type_id);
	}
	return greeter_compositor_wingpanel_manager_type_id__once;
}

static void
_vala_greeter_compositor_wingpanel_manager_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	GreeterCompositorWingpanelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, GreeterCompositorWingpanelManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_WINGPANEL_MANAGER_PANEL_HEIGHT_PROPERTY:
		g_value_set_int (value, greeter_compositor_wingpanel_manager_get_panel_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_wingpanel_manager_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	GreeterCompositorWingpanelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_WINGPANEL_MANAGER, GreeterCompositorWingpanelManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_WINGPANEL_MANAGER_PANEL_HEIGHT_PROPERTY:
		greeter_compositor_wingpanel_manager_set_panel_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

