#ifndef A6XX_XML_STRUCTS
#define A6XX_XML_STRUCTS

/* Autogenerated file, DO NOT EDIT manually! */

#ifdef __KERNEL__
#include <linux/bug.h>
#define assert(x) BUG_ON(!(x))
#else
#include <assert.h>
#endif

#ifdef __cplusplus
#define __struct_cast(X)
#else
#define __struct_cast(X) (struct X)
#endif

#ifndef FD_NO_DEPRECATED_PACK
#define FD_DEPRECATED __attribute__((deprecated))
#else
#define FD_DEPRECATED
#endif

struct A6XX_CP_RB_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_CP_RB_BASE(struct A6XX_CP_RB_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000800,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_RB_BASE(...) pack_A6XX_CP_RB_BASE(__struct_cast(A6XX_CP_RB_BASE) { __VA_ARGS__ })

struct A6XX_CP_RB_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_CP_RB_CNTL(struct A6XX_CP_RB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000802,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_RB_CNTL(...) pack_A6XX_CP_RB_CNTL(__struct_cast(A6XX_CP_RB_CNTL) { __VA_ARGS__ })

struct A7XX_CP_RB_RPTR_WR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_RB_RPTR_WR(struct A7XX_CP_RB_RPTR_WR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000803,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_RB_RPTR_WR(...) pack_A7XX_CP_RB_RPTR_WR(__struct_cast(A7XX_CP_RB_RPTR_WR) { __VA_ARGS__ })

struct A6XX_CP_RB_RPTR_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_CP_RB_RPTR_ADDR(struct A6XX_CP_RB_RPTR_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000804,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_RB_RPTR_ADDR(...) pack_A6XX_CP_RB_RPTR_ADDR(__struct_cast(A6XX_CP_RB_RPTR_ADDR) { __VA_ARGS__ })

struct A6XX_CP_RB_RPTR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_CP_RB_RPTR(struct A6XX_CP_RB_RPTR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000806,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_RB_RPTR(...) pack_A6XX_CP_RB_RPTR(__struct_cast(A6XX_CP_RB_RPTR) { __VA_ARGS__ })

struct A6XX_CP_RB_WPTR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_CP_RB_WPTR(struct A6XX_CP_RB_WPTR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000807,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_RB_WPTR(...) pack_A6XX_CP_RB_WPTR(__struct_cast(A6XX_CP_RB_WPTR) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_ADDR_BV {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_RPTR_ADDR_BV(struct A8XX_CP_RB_RPTR_ADDR_BV fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000808,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RB_RPTR_ADDR_BV(...) pack_A8XX_CP_RB_RPTR_ADDR_BV(__struct_cast(A8XX_CP_RB_RPTR_ADDR_BV) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_BV {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_RPTR_BV(struct A8XX_CP_RB_RPTR_BV fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RB_RPTR_BV(...) pack_A8XX_CP_RB_RPTR_BV(__struct_cast(A8XX_CP_RB_RPTR_BV) { __VA_ARGS__ })

struct A8XX_CP_RB_BASE_LPAC {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_BASE_LPAC(struct A8XX_CP_RB_BASE_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080b,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_RB_BASE_LPAC(...) pack_A8XX_CP_RB_BASE_LPAC(__struct_cast(A8XX_CP_RB_BASE_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_CNTL_LPAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_CNTL_LPAC(struct A8XX_CP_RB_CNTL_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RB_CNTL_LPAC(...) pack_A8XX_CP_RB_CNTL_LPAC(__struct_cast(A8XX_CP_RB_CNTL_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_WR_LPAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_RPTR_WR_LPAC(struct A8XX_CP_RB_RPTR_WR_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RB_RPTR_WR_LPAC(...) pack_A8XX_CP_RB_RPTR_WR_LPAC(__struct_cast(A8XX_CP_RB_RPTR_WR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_ADDR_LPAC {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_RPTR_ADDR_LPAC(struct A8XX_CP_RB_RPTR_ADDR_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000080f,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_RB_RPTR_ADDR_LPAC(...) pack_A8XX_CP_RB_RPTR_ADDR_LPAC(__struct_cast(A8XX_CP_RB_RPTR_ADDR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_RPTR_LPAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_RPTR_LPAC(struct A8XX_CP_RB_RPTR_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000811,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RB_RPTR_LPAC(...) pack_A8XX_CP_RB_RPTR_LPAC(__struct_cast(A8XX_CP_RB_RPTR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_RB_WPTR_LPAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RB_WPTR_LPAC(struct A8XX_CP_RB_WPTR_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000812,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RB_WPTR_LPAC(...) pack_A8XX_CP_RB_WPTR_LPAC(__struct_cast(A8XX_CP_RB_WPTR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_SMMU_STREAM_ID_LPAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SMMU_STREAM_ID_LPAC(struct A8XX_CP_SMMU_STREAM_ID_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000814,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SMMU_STREAM_ID_LPAC(...) pack_A8XX_CP_SMMU_STREAM_ID_LPAC(__struct_cast(A8XX_CP_SMMU_STREAM_ID_LPAC) { __VA_ARGS__ })

struct A6XX_CP_SQE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SQE_CNTL(struct A6XX_CP_SQE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000808,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SQE_CNTL(...) pack_A6XX_CP_SQE_CNTL(__struct_cast(A6XX_CP_SQE_CNTL) { __VA_ARGS__ })

struct A8XX_CP_SQE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_CNTL(struct A8XX_CP_SQE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000815,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_CNTL(...) pack_A8XX_CP_SQE_CNTL(__struct_cast(A8XX_CP_SQE_CNTL) { __VA_ARGS__ })

struct A8XX_CP_SQE_INSTR_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_INSTR_BASE(struct A8XX_CP_SQE_INSTR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000816,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_SQE_INSTR_BASE(...) pack_A8XX_CP_SQE_INSTR_BASE(__struct_cast(A8XX_CP_SQE_INSTR_BASE) { __VA_ARGS__ })

struct A8XX_CP_AQE_INSTR_BASE_0 {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_AQE_INSTR_BASE_0(struct A8XX_CP_AQE_INSTR_BASE_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000818,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_AQE_INSTR_BASE_0(...) pack_A8XX_CP_AQE_INSTR_BASE_0(__struct_cast(A8XX_CP_AQE_INSTR_BASE_0) { __VA_ARGS__ })

struct A8XX_CP_AQE_INSTR_BASE_1 {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_AQE_INSTR_BASE_1(struct A8XX_CP_AQE_INSTR_BASE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081a,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_AQE_INSTR_BASE_1(...) pack_A8XX_CP_AQE_INSTR_BASE_1(__struct_cast(A8XX_CP_AQE_INSTR_BASE_1) { __VA_ARGS__ })

struct A6XX_CP_CP2GMU_STATUS {
    bool							ifpc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CP2GMU_STATUS(struct A6XX_CP_CP2GMU_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000812,
        .value =
            (fields.ifpc                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_CP2GMU_STATUS(...) pack_A6XX_CP_CP2GMU_STATUS(__struct_cast(A6XX_CP_CP2GMU_STATUS) { __VA_ARGS__ })

struct A8XX_CP_CP2GMU_STATUS {
    bool							ifpc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CP2GMU_STATUS(struct A8XX_CP_CP2GMU_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000822,
        .value =
            (fields.ifpc                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_CP2GMU_STATUS(...) pack_A8XX_CP_CP2GMU_STATUS(__struct_cast(A8XX_CP_CP2GMU_STATUS) { __VA_ARGS__ })

struct A6XX_CP_HW_FAULT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_HW_FAULT(struct A6XX_CP_HW_FAULT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000821,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_HW_FAULT(...) pack_A6XX_CP_HW_FAULT(__struct_cast(A6XX_CP_HW_FAULT) { __VA_ARGS__ })

struct A6XX_CP_PROTECT_STATUS {
    uint32_t							addr;
    bool							read;
    bool							cp_halted;
    bool							access_violation;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_PROTECT_STATUS(struct A6XX_CP_PROTECT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.addr                              & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x0073ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000824,
        .value =
            (fields.addr                              <<  0) |
            (fields.read                              << 20) |
            (fields.cp_halted                         << 21) |
            (fields.access_violation                  << 22) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_PROTECT_STATUS(...) pack_A6XX_CP_PROTECT_STATUS(__struct_cast(A6XX_CP_PROTECT_STATUS) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_STATUS_PIPE {
    uint32_t							addr;
    bool							read;
    bool							cp_halted;
    bool							access_violation;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_PROTECT_STATUS_PIPE(struct A8XX_CP_PROTECT_STATUS_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.addr                              & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x0073ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084f,
        .value =
            (fields.addr                              <<  0) |
            (fields.read                              << 20) |
            (fields.cp_halted                         << 21) |
            (fields.access_violation                  << 22) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_PROTECT_STATUS_PIPE(...) pack_A8XX_CP_PROTECT_STATUS_PIPE(__struct_cast(A8XX_CP_PROTECT_STATUS_PIPE) { __VA_ARGS__ })

struct A6XX_CP_STATUS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_STATUS_1(struct A6XX_CP_STATUS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000825,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_STATUS_1(...) pack_A6XX_CP_STATUS_1(__struct_cast(A6XX_CP_STATUS_1) { __VA_ARGS__ })

struct A8XX_CP_SEMAPHORE_REG_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SEMAPHORE_REG_0(struct A8XX_CP_SEMAPHORE_REG_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000825,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SEMAPHORE_REG_0(...) pack_A8XX_CP_SEMAPHORE_REG_0(__struct_cast(A8XX_CP_SEMAPHORE_REG_0) { __VA_ARGS__ })

struct A8XX_CP_SCRATCH_GLOBAL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SCRATCH_GLOBAL_REG(uint32_t __i, struct A8XX_CP_SCRATCH_GLOBAL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000082a + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SCRATCH_GLOBAL_REG(__i, ...) pack_A8XX_CP_SCRATCH_GLOBAL_REG(__i, __struct_cast(A8XX_CP_SCRATCH_GLOBAL_REG) { __VA_ARGS__ })

struct A8XX_CP_SCRATCH_PIPE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SCRATCH_PIPE_REG(uint32_t __i, struct A8XX_CP_SCRATCH_PIPE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000830 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SCRATCH_PIPE_REG(__i, ...) pack_A8XX_CP_SCRATCH_PIPE_REG(__i, __struct_cast(A8XX_CP_SCRATCH_PIPE_REG) { __VA_ARGS__ })

struct A8XX_CP_RL_ERROR_DETAILS_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RL_ERROR_DETAILS_0(struct A8XX_CP_RL_ERROR_DETAILS_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000840,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RL_ERROR_DETAILS_0(...) pack_A8XX_CP_RL_ERROR_DETAILS_0(__struct_cast(A8XX_CP_RL_ERROR_DETAILS_0) { __VA_ARGS__ })

struct A8XX_CP_RL_ERROR_DETAILS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RL_ERROR_DETAILS_1(struct A8XX_CP_RL_ERROR_DETAILS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000841,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RL_ERROR_DETAILS_1(...) pack_A8XX_CP_RL_ERROR_DETAILS_1(__struct_cast(A8XX_CP_RL_ERROR_DETAILS_1) { __VA_ARGS__ })

struct A6XX_CP_SQE_INSTR_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SQE_INSTR_BASE(struct A6XX_CP_SQE_INSTR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000830,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_SQE_INSTR_BASE(...) pack_A6XX_CP_SQE_INSTR_BASE(__struct_cast(A6XX_CP_SQE_INSTR_BASE) { __VA_ARGS__ })

struct A6XX_CP_MISC_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_MISC_CNTL(struct A6XX_CP_MISC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000840,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_MISC_CNTL(...) pack_A6XX_CP_MISC_CNTL(__struct_cast(A6XX_CP_MISC_CNTL) { __VA_ARGS__ })

struct A8XX_CP_MISC_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_MISC_CNTL(struct A8XX_CP_MISC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_MISC_CNTL(...) pack_A8XX_CP_MISC_CNTL(__struct_cast(A8XX_CP_MISC_CNTL) { __VA_ARGS__ })

struct A8XX_CP_SQE_ICACHE_CNTL_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_ICACHE_CNTL_PIPE(struct A8XX_CP_SQE_ICACHE_CNTL_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_ICACHE_CNTL_PIPE(...) pack_A8XX_CP_SQE_ICACHE_CNTL_PIPE(__struct_cast(A8XX_CP_SQE_ICACHE_CNTL_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_DCACHE_CNTL_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_DCACHE_CNTL_PIPE(struct A8XX_CP_SQE_DCACHE_CNTL_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_DCACHE_CNTL_PIPE(...) pack_A8XX_CP_SQE_DCACHE_CNTL_PIPE(__struct_cast(A8XX_CP_SQE_DCACHE_CNTL_PIPE) { __VA_ARGS__ })

struct A8XX_CP_HW_FAULT_STATUS_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_HW_FAULT_STATUS_PIPE(struct A8XX_CP_HW_FAULT_STATUS_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_HW_FAULT_STATUS_PIPE(...) pack_A8XX_CP_HW_FAULT_STATUS_PIPE(__struct_cast(A8XX_CP_HW_FAULT_STATUS_PIPE) { __VA_ARGS__ })

struct A8XX_CP_HW_FAULT_STATUS_MASK_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_HW_FAULT_STATUS_MASK_PIPE(struct A8XX_CP_HW_FAULT_STATUS_MASK_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE(...) pack_A8XX_CP_HW_FAULT_STATUS_MASK_PIPE(__struct_cast(A8XX_CP_HW_FAULT_STATUS_MASK_PIPE) { __VA_ARGS__ })

struct A8XX_CP_INTERRUPT_STATUS_MASK_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_INTERRUPT_STATUS_MASK_PIPE(struct A8XX_CP_INTERRUPT_STATUS_MASK_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE(...) pack_A8XX_CP_INTERRUPT_STATUS_MASK_PIPE(__struct_cast(A8XX_CP_INTERRUPT_STATUS_MASK_PIPE) { __VA_ARGS__ })

struct A8XX_CP_PIPE_STATUS_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_PIPE_STATUS_PIPE(struct A8XX_CP_PIPE_STATUS_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_PIPE_STATUS_PIPE(...) pack_A8XX_CP_PIPE_STATUS_PIPE(__struct_cast(A8XX_CP_PIPE_STATUS_PIPE) { __VA_ARGS__ })

struct A8XX_CP_GPU_BATCH_ID_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_GPU_BATCH_ID_PIPE(struct A8XX_CP_GPU_BATCH_ID_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ba,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_GPU_BATCH_ID_PIPE(...) pack_A8XX_CP_GPU_BATCH_ID_PIPE(__struct_cast(A8XX_CP_GPU_BATCH_ID_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_STATUS_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_STATUS_PIPE(struct A8XX_CP_SQE_STATUS_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008bb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_STATUS_PIPE(...) pack_A8XX_CP_SQE_STATUS_PIPE(__struct_cast(A8XX_CP_SQE_STATUS_PIPE) { __VA_ARGS__ })

struct A6XX_CP_APRIV_CNTL {
    bool							cdwrite;
    bool							cdread;
    bool							scratchwt;
    bool							rbrpwb;
    bool							rbprivlevel;
    bool							rbfetch;
    bool							icache;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_APRIV_CNTL(struct A6XX_CP_APRIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000844,
        .value =
            (fields.cdwrite                           <<  6) |
            (fields.cdread                            <<  5) |
            (fields.scratchwt                         <<  4) |
            (fields.rbrpwb                            <<  3) |
            (fields.rbprivlevel                       <<  2) |
            (fields.rbfetch                           <<  1) |
            (fields.icache                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_APRIV_CNTL(...) pack_A6XX_CP_APRIV_CNTL(__struct_cast(A6XX_CP_APRIV_CNTL) { __VA_ARGS__ })

struct A8XX_CP_APRIV_CNTL_PIPE {
    bool							cdwrite;
    bool							cdread;
    bool							scratchwt;
    bool							rbrpwb;
    bool							rbprivlevel;
    bool							rbfetch;
    bool							icache;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_APRIV_CNTL_PIPE(struct A8XX_CP_APRIV_CNTL_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084d,
        .value =
            (fields.cdwrite                           <<  6) |
            (fields.cdread                            <<  5) |
            (fields.scratchwt                         <<  4) |
            (fields.rbrpwb                            <<  3) |
            (fields.rbprivlevel                       <<  2) |
            (fields.rbfetch                           <<  1) |
            (fields.icache                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_APRIV_CNTL_PIPE(...) pack_A8XX_CP_APRIV_CNTL_PIPE(__struct_cast(A8XX_CP_APRIV_CNTL_PIPE) { __VA_ARGS__ })

struct A6XX_CP_PREEMPT_THRESHOLD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_PREEMPT_THRESHOLD(struct A6XX_CP_PREEMPT_THRESHOLD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_PREEMPT_THRESHOLD(...) pack_A6XX_CP_PREEMPT_THRESHOLD(__struct_cast(A6XX_CP_PREEMPT_THRESHOLD) { __VA_ARGS__ })

struct A8XX_CP_PREEMPT_THRESHOLD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_PREEMPT_THRESHOLD(struct A8XX_CP_PREEMPT_THRESHOLD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ec,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_PREEMPT_THRESHOLD(...) pack_A8XX_CP_PREEMPT_THRESHOLD(__struct_cast(A8XX_CP_PREEMPT_THRESHOLD) { __VA_ARGS__ })

struct A6XX_CP_ROQ_THRESHOLDS_1 {
    uint32_t							mrb_start;
    uint32_t							vsd_start;
    uint32_t							ib1_start;
    uint32_t							ib2_start;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_THRESHOLDS_1(struct A6XX_CP_ROQ_THRESHOLDS_1 fields)
{
#ifndef NDEBUG
    assert(((fields.mrb_start >> 2)                  & 0xffffff00) == 0);
    assert(((fields.vsd_start >> 2)                  & 0xffffff00) == 0);
    assert(((fields.ib1_start >> 2)                  & 0xffffff00) == 0);
    assert(((fields.ib2_start >> 2)                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c1,
        .value =
            ((fields.mrb_start >> 2)                  <<  0) |
            ((fields.vsd_start >> 2)                  <<  8) |
            ((fields.ib1_start >> 2)                  << 16) |
            ((fields.ib2_start >> 2)                  << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_THRESHOLDS_1(...) pack_A6XX_CP_ROQ_THRESHOLDS_1(__struct_cast(A6XX_CP_ROQ_THRESHOLDS_1) { __VA_ARGS__ })

struct A6XX_CP_ROQ_THRESHOLDS_2 {
    uint32_t							sds_start;
    uint32_t							roq_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_THRESHOLDS_2(struct A6XX_CP_ROQ_THRESHOLDS_2 fields)
{
#ifndef NDEBUG
    assert(((fields.sds_start >> 2)                  & 0xfffffe00) == 0);
    assert(((fields.roq_size >> 2)                   & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff01ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c2,
        .value =
            ((fields.sds_start >> 2)                  <<  0) |
            ((fields.roq_size >> 2)                   << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_THRESHOLDS_2(...) pack_A6XX_CP_ROQ_THRESHOLDS_2(__struct_cast(A6XX_CP_ROQ_THRESHOLDS_2) { __VA_ARGS__ })

struct A6XX_CP_MEM_POOL_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_MEM_POOL_SIZE(struct A6XX_CP_MEM_POOL_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_MEM_POOL_SIZE(...) pack_A6XX_CP_MEM_POOL_SIZE(__struct_cast(A6XX_CP_MEM_POOL_SIZE) { __VA_ARGS__ })

struct A6XX_CP_CHICKEN_DBG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CHICKEN_DBG(struct A6XX_CP_CHICKEN_DBG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000841,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_CHICKEN_DBG(...) pack_A6XX_CP_CHICKEN_DBG(__struct_cast(A6XX_CP_CHICKEN_DBG) { __VA_ARGS__ })

struct A8XX_CP_CHICKEN_DBG_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CHICKEN_DBG_PIPE(struct A8XX_CP_CHICKEN_DBG_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008b2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_CHICKEN_DBG_PIPE(...) pack_A8XX_CP_CHICKEN_DBG_PIPE(__struct_cast(A8XX_CP_CHICKEN_DBG_PIPE) { __VA_ARGS__ })

struct A6XX_CP_ADDR_MODE_CNTL {
    enum a5xx_address_mode					cp_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ADDR_MODE_CNTL(struct A6XX_CP_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.cp_addr_mode_cntl                 & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000842,
        .value =
            (fields.cp_addr_mode_cntl                 <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ADDR_MODE_CNTL(...) pack_A6XX_CP_ADDR_MODE_CNTL(__struct_cast(A6XX_CP_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_CP_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_DBG_ECO_CNTL(struct A6XX_CP_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000843,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_DBG_ECO_CNTL(...) pack_A6XX_CP_DBG_ECO_CNTL(__struct_cast(A6XX_CP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_CP_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_DBG_ECO_CNTL(struct A8XX_CP_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_DBG_ECO_CNTL(...) pack_A8XX_CP_DBG_ECO_CNTL(__struct_cast(A8XX_CP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_CP_PROTECT_CNTL {
    bool							last_span_inf_range;
    bool							access_fault_on_viol_en;
    bool							access_prot_en;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_PROTECT_CNTL(struct A6XX_CP_PROTECT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000b) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084f,
        .value =
            (fields.last_span_inf_range               <<  3) |
            (fields.access_fault_on_viol_en           <<  1) |
            (fields.access_prot_en                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_PROTECT_CNTL(...) pack_A6XX_CP_PROTECT_CNTL(__struct_cast(A6XX_CP_PROTECT_CNTL) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_CNTL_PIPE {
    bool							last_span_inf_range;
    bool							access_fault_on_viol_en;
    bool							access_prot_en;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_PROTECT_CNTL_PIPE(struct A8XX_CP_PROTECT_CNTL_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000b) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000084e,
        .value =
            (fields.last_span_inf_range               <<  3) |
            (fields.access_fault_on_viol_en           <<  1) |
            (fields.access_prot_en                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_PROTECT_CNTL_PIPE(...) pack_A8XX_CP_PROTECT_CNTL_PIPE(__struct_cast(A8XX_CP_PROTECT_CNTL_PIPE) { __VA_ARGS__ })

struct A6XX_CP_SCRATCH_REG {
    uint32_t							cp_scratch_reg;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SCRATCH_REG(uint32_t __i, struct A6XX_CP_SCRATCH_REG fields)
{
#ifndef NDEBUG
    assert((fields.cp_scratch_reg                    & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000883 + 0x1*__i),
        .value =
            (fields.cp_scratch_reg                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SCRATCH_REG(__i, ...) pack_A6XX_CP_SCRATCH_REG(__i, __struct_cast(A6XX_CP_SCRATCH_REG) { __VA_ARGS__ })

struct A6XX_CP_PROTECT_REG {
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_PROTECT_REG(uint32_t __i, struct A6XX_CP_PROTECT_REG fields)
{
#ifndef NDEBUG
    assert((fields.base_addr                         & 0xfffc0000) == 0);
    assert((fields.mask_len                          & 0xffffe000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000850 + 0x1*__i),
        .value =
            (fields.base_addr                         <<  0) |
            (fields.mask_len                          << 18) |
            (fields.read                              << 31) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_PROTECT_REG(__i, ...) pack_A6XX_CP_PROTECT_REG(__i, __struct_cast(A6XX_CP_PROTECT_REG) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_GLOBAL_REG {
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_PROTECT_GLOBAL_REG(uint32_t __i, struct A8XX_CP_PROTECT_GLOBAL_REG fields)
{
#ifndef NDEBUG
    assert((fields.base_addr                         & 0xfffc0000) == 0);
    assert((fields.mask_len                          & 0xffffe000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000850 + 0x1*__i),
        .value =
            (fields.base_addr                         <<  0) |
            (fields.mask_len                          << 18) |
            (fields.read                              << 31) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_PROTECT_GLOBAL_REG(__i, ...) pack_A8XX_CP_PROTECT_GLOBAL_REG(__i, __struct_cast(A8XX_CP_PROTECT_GLOBAL_REG) { __VA_ARGS__ })

struct A8XX_CP_PROTECT_PIPE_REG {
    uint32_t							base_addr;
    uint32_t							mask_len;
    bool							read;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_PROTECT_PIPE_REG(uint32_t __i, struct A8XX_CP_PROTECT_PIPE_REG fields)
{
#ifndef NDEBUG
    assert((fields.base_addr                         & 0xfffc0000) == 0);
    assert((fields.mask_len                          & 0xffffe000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008a0 + 0x1*__i),
        .value =
            (fields.base_addr                         <<  0) |
            (fields.mask_len                          << 18) |
            (fields.read                              << 31) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_PROTECT_PIPE_REG(__i, ...) pack_A8XX_CP_PROTECT_PIPE_REG(__i, __struct_cast(A8XX_CP_PROTECT_PIPE_REG) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_CNTL {
    bool							stop;
    uint32_t							level;
    bool							uses_gmem;
    bool							skip_save_restore;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CONTEXT_SWITCH_CNTL(struct A6XX_CP_CONTEXT_SWITCH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.level                             & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000003c1) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a0,
        .value =
            (fields.stop                              <<  0) |
            (fields.level                             <<  6) |
            (fields.uses_gmem                         <<  8) |
            (fields.skip_save_restore                 <<  9) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_CONTEXT_SWITCH_CNTL(...) pack_A6XX_CP_CONTEXT_SWITCH_CNTL(__struct_cast(A6XX_CP_CONTEXT_SWITCH_CNTL) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_CNTL {
    bool							stop;
    uint32_t							level;
    bool							uses_gmem;
    bool							skip_save_restore;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CONTEXT_SWITCH_CNTL(struct A8XX_CP_CONTEXT_SWITCH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.level                             & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000003c1) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c0,
        .value =
            (fields.stop                              <<  0) |
            (fields.level                             <<  6) |
            (fields.uses_gmem                         <<  8) |
            (fields.skip_save_restore                 <<  9) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_CONTEXT_SWITCH_CNTL(...) pack_A8XX_CP_CONTEXT_SWITCH_CNTL(__struct_cast(A8XX_CP_CONTEXT_SWITCH_CNTL) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_SMMU_INFO {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CONTEXT_SWITCH_SMMU_INFO(struct A6XX_CP_CONTEXT_SWITCH_SMMU_INFO fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a1,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_CONTEXT_SWITCH_SMMU_INFO(...) pack_A6XX_CP_CONTEXT_SWITCH_SMMU_INFO(__struct_cast(A6XX_CP_CONTEXT_SWITCH_SMMU_INFO) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(struct A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a3,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(...) pack_A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(__struct_cast(A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(struct A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a5,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(...) pack_A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(__struct_cast(A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(struct A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008a7,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(...) pack_A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(__struct_cast(A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR) { __VA_ARGS__ })

struct A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(struct A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ab,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(...) pack_A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(__struct_cast(A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_SMMU_INFO {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CONTEXT_SWITCH_SMMU_INFO(struct A8XX_CP_CONTEXT_SWITCH_SMMU_INFO fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c1,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_CONTEXT_SWITCH_SMMU_INFO(...) pack_A8XX_CP_CONTEXT_SWITCH_SMMU_INFO(__struct_cast(A8XX_CP_CONTEXT_SWITCH_SMMU_INFO) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(struct A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c3,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(...) pack_A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR(__struct_cast(A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(struct A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c5,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(...) pack_A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR(__struct_cast(A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(struct A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008c7,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(...) pack_A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR(__struct_cast(A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR) { __VA_ARGS__ })

struct A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(struct A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008cb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(...) pack_A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS(__struct_cast(A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS) { __VA_ARGS__ })

struct A6XX_CP_PERFCTR_CP_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_PERFCTR_CP_SEL_REG(uint32_t __i, struct A6XX_CP_PERFCTR_CP_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008d0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_PERFCTR_CP_SEL_REG(__i, ...) pack_A6XX_CP_PERFCTR_CP_SEL_REG(__i, __struct_cast(A6XX_CP_PERFCTR_CP_SEL_REG) { __VA_ARGS__ })

struct A8XX_CP_PERFCTR_CP_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_PERFCTR_CP_SEL_REG(uint32_t __i, struct A8XX_CP_PERFCTR_CP_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008d0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_PERFCTR_CP_SEL_REG(__i, ...) pack_A8XX_CP_PERFCTR_CP_SEL_REG(__i, __struct_cast(A8XX_CP_PERFCTR_CP_SEL_REG) { __VA_ARGS__ })

struct A7XX_CP_BV_PERFCTR_CP_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_PERFCTR_CP_SEL_REG(uint32_t __i, struct A7XX_CP_BV_PERFCTR_CP_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000008e0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_PERFCTR_CP_SEL_REG(__i, ...) pack_A7XX_CP_BV_PERFCTR_CP_SEL_REG(__i, __struct_cast(A7XX_CP_BV_PERFCTR_CP_SEL_REG) { __VA_ARGS__ })

struct A6XX_CP_CRASH_DUMP_SCRIPT_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CRASH_DUMP_SCRIPT_BASE(struct A6XX_CP_CRASH_DUMP_SCRIPT_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000900,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_CRASH_DUMP_SCRIPT_BASE(...) pack_A6XX_CP_CRASH_DUMP_SCRIPT_BASE(__struct_cast(A6XX_CP_CRASH_DUMP_SCRIPT_BASE) { __VA_ARGS__ })

struct A6XX_CP_CRASH_DUMP_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CRASH_DUMP_CNTL(struct A6XX_CP_CRASH_DUMP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000902,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_CRASH_DUMP_CNTL(...) pack_A6XX_CP_CRASH_DUMP_CNTL(__struct_cast(A6XX_CP_CRASH_DUMP_CNTL) { __VA_ARGS__ })

struct A6XX_CP_CRASH_DUMP_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_CRASH_DUMP_STATUS(struct A6XX_CP_CRASH_DUMP_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000903,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_CRASH_DUMP_STATUS(...) pack_A6XX_CP_CRASH_DUMP_STATUS(__struct_cast(A6XX_CP_CRASH_DUMP_STATUS) { __VA_ARGS__ })

struct A8XX_CP_CRASH_DUMP_SCRIPT_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CRASH_DUMP_SCRIPT_BASE(struct A8XX_CP_CRASH_DUMP_SCRIPT_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000842,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_CRASH_DUMP_SCRIPT_BASE(...) pack_A8XX_CP_CRASH_DUMP_SCRIPT_BASE(__struct_cast(A8XX_CP_CRASH_DUMP_SCRIPT_BASE) { __VA_ARGS__ })

struct A8XX_CP_CRASH_DUMP_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CRASH_DUMP_CNTL(struct A8XX_CP_CRASH_DUMP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000844,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_CRASH_DUMP_CNTL(...) pack_A8XX_CP_CRASH_DUMP_CNTL(__struct_cast(A8XX_CP_CRASH_DUMP_CNTL) { __VA_ARGS__ })

struct A8XX_CP_CRASH_DUMP_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_CRASH_DUMP_STATUS(struct A8XX_CP_CRASH_DUMP_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000845,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_CRASH_DUMP_STATUS(...) pack_A8XX_CP_CRASH_DUMP_STATUS(__struct_cast(A8XX_CP_CRASH_DUMP_STATUS) { __VA_ARGS__ })

struct A6XX_CP_SQE_STAT_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SQE_STAT_ADDR(struct A6XX_CP_SQE_STAT_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000908,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SQE_STAT_ADDR(...) pack_A6XX_CP_SQE_STAT_ADDR(__struct_cast(A6XX_CP_SQE_STAT_ADDR) { __VA_ARGS__ })

struct A6XX_CP_SQE_STAT_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SQE_STAT_DATA(struct A6XX_CP_SQE_STAT_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000909,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SQE_STAT_DATA(...) pack_A6XX_CP_SQE_STAT_DATA(__struct_cast(A6XX_CP_SQE_STAT_DATA) { __VA_ARGS__ })

struct A6XX_CP_DRAW_STATE_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_DRAW_STATE_ADDR(struct A6XX_CP_DRAW_STATE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_DRAW_STATE_ADDR(...) pack_A6XX_CP_DRAW_STATE_ADDR(__struct_cast(A6XX_CP_DRAW_STATE_ADDR) { __VA_ARGS__ })

struct A6XX_CP_DRAW_STATE_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_DRAW_STATE_DATA(struct A6XX_CP_DRAW_STATE_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_DRAW_STATE_DATA(...) pack_A6XX_CP_DRAW_STATE_DATA(__struct_cast(A6XX_CP_DRAW_STATE_DATA) { __VA_ARGS__ })

struct A6XX_CP_ROQ_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_DBG_ADDR(struct A6XX_CP_ROQ_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_DBG_ADDR(...) pack_A6XX_CP_ROQ_DBG_ADDR(__struct_cast(A6XX_CP_ROQ_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_ROQ_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_DBG_DATA(struct A6XX_CP_ROQ_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_DBG_DATA(...) pack_A6XX_CP_ROQ_DBG_DATA(__struct_cast(A6XX_CP_ROQ_DBG_DATA) { __VA_ARGS__ })

struct A6XX_CP_MEM_POOL_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_MEM_POOL_DBG_ADDR(struct A6XX_CP_MEM_POOL_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_MEM_POOL_DBG_ADDR(...) pack_A6XX_CP_MEM_POOL_DBG_ADDR(__struct_cast(A6XX_CP_MEM_POOL_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_MEM_POOL_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_MEM_POOL_DBG_DATA(struct A6XX_CP_MEM_POOL_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_MEM_POOL_DBG_DATA(...) pack_A6XX_CP_MEM_POOL_DBG_DATA(__struct_cast(A6XX_CP_MEM_POOL_DBG_DATA) { __VA_ARGS__ })

struct A6XX_CP_SQE_UCODE_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SQE_UCODE_DBG_ADDR(struct A6XX_CP_SQE_UCODE_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000910,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SQE_UCODE_DBG_ADDR(...) pack_A6XX_CP_SQE_UCODE_DBG_ADDR(__struct_cast(A6XX_CP_SQE_UCODE_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_SQE_UCODE_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SQE_UCODE_DBG_DATA(struct A6XX_CP_SQE_UCODE_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000911,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SQE_UCODE_DBG_DATA(...) pack_A6XX_CP_SQE_UCODE_DBG_DATA(__struct_cast(A6XX_CP_SQE_UCODE_DBG_DATA) { __VA_ARGS__ })

struct A8XX_CP_SQE_STAT_ADDR_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_STAT_ADDR_PIPE(struct A8XX_CP_SQE_STAT_ADDR_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_STAT_ADDR_PIPE(...) pack_A8XX_CP_SQE_STAT_ADDR_PIPE(__struct_cast(A8XX_CP_SQE_STAT_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_STAT_DATA_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_STAT_DATA_PIPE(struct A8XX_CP_SQE_STAT_DATA_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_STAT_DATA_PIPE(...) pack_A8XX_CP_SQE_STAT_DATA_PIPE(__struct_cast(A8XX_CP_SQE_STAT_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_DRAW_STATE_ADDR_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_DRAW_STATE_ADDR_PIPE(struct A8XX_CP_DRAW_STATE_ADDR_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_DRAW_STATE_ADDR_PIPE(...) pack_A8XX_CP_DRAW_STATE_ADDR_PIPE(__struct_cast(A8XX_CP_DRAW_STATE_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_DRAW_STATE_DATA_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_DRAW_STATE_DATA_PIPE(struct A8XX_CP_DRAW_STATE_DATA_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_DRAW_STATE_DATA_PIPE(...) pack_A8XX_CP_DRAW_STATE_DATA_PIPE(__struct_cast(A8XX_CP_DRAW_STATE_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_ROQ_DBG_ADDR_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_DBG_ADDR_PIPE(struct A8XX_CP_ROQ_DBG_ADDR_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_DBG_ADDR_PIPE(...) pack_A8XX_CP_ROQ_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_ROQ_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_ROQ_DBG_DATA_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_DBG_DATA_PIPE(struct A8XX_CP_ROQ_DBG_DATA_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_DBG_DATA_PIPE(...) pack_A8XX_CP_ROQ_DBG_DATA_PIPE(__struct_cast(A8XX_CP_ROQ_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_MEM_POOL_DBG_ADDR_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_MEM_POOL_DBG_ADDR_PIPE(struct A8XX_CP_MEM_POOL_DBG_ADDR_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_MEM_POOL_DBG_ADDR_PIPE(...) pack_A8XX_CP_MEM_POOL_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_MEM_POOL_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_MEM_POOL_DBG_DATA_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_MEM_POOL_DBG_DATA_PIPE(struct A8XX_CP_MEM_POOL_DBG_DATA_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_MEM_POOL_DBG_DATA_PIPE(...) pack_A8XX_CP_MEM_POOL_DBG_DATA_PIPE(__struct_cast(A8XX_CP_MEM_POOL_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE(struct A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE(...) pack_A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SQE_UCODE_DBG_DATA_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SQE_UCODE_DBG_DATA_PIPE(struct A8XX_CP_SQE_UCODE_DBG_DATA_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008f9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SQE_UCODE_DBG_DATA_PIPE(...) pack_A8XX_CP_SQE_UCODE_DBG_DATA_PIPE(__struct_cast(A8XX_CP_SQE_UCODE_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV(struct A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fa,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV(...) pack_A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV(__struct_cast(A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV) { __VA_ARGS__ })

struct A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV(struct A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV(...) pack_A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV(__struct_cast(A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_ADDR_LPAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_FIFO_DBG_ADDR_LPAC(struct A8XX_CP_FIFO_DBG_ADDR_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_FIFO_DBG_ADDR_LPAC(...) pack_A8XX_CP_FIFO_DBG_ADDR_LPAC(__struct_cast(A8XX_CP_FIFO_DBG_ADDR_LPAC) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_DATA_LPAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_FIFO_DBG_DATA_LPAC(struct A8XX_CP_FIFO_DBG_DATA_LPAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_FIFO_DBG_DATA_LPAC(...) pack_A8XX_CP_FIFO_DBG_DATA_LPAC(__struct_cast(A8XX_CP_FIFO_DBG_DATA_LPAC) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE(struct A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008fe,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE(...) pack_A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE(__struct_cast(A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE) { __VA_ARGS__ })

struct A8XX_CP_FIFO_DBG_DATA_DDE_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_FIFO_DBG_DATA_DDE_PIPE(struct A8XX_CP_FIFO_DBG_DATA_DDE_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008ff,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_FIFO_DBG_DATA_DDE_PIPE(...) pack_A8XX_CP_FIFO_DBG_DATA_DDE_PIPE(__struct_cast(A8XX_CP_FIFO_DBG_DATA_DDE_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE(struct A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE(...) pack_A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE(__struct_cast(A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE(struct A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE(...) pack_A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE(__struct_cast(A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE) { __VA_ARGS__ })

struct A8XX_CP_SLICE_CHICKEN_DBG_PIPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SLICE_CHICKEN_DBG_PIPE(struct A8XX_CP_SLICE_CHICKEN_DBG_PIPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b93,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SLICE_CHICKEN_DBG_PIPE(...) pack_A8XX_CP_SLICE_CHICKEN_DBG_PIPE(__struct_cast(A8XX_CP_SLICE_CHICKEN_DBG_PIPE) { __VA_ARGS__ })

struct A6XX_CP_IB1_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_IB1_BASE(struct A6XX_CP_IB1_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000928,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_IB1_BASE(...) pack_A6XX_CP_IB1_BASE(__struct_cast(A6XX_CP_IB1_BASE) { __VA_ARGS__ })

struct A6XX_CP_IB1_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_IB1_REM_SIZE(struct A6XX_CP_IB1_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_IB1_REM_SIZE(...) pack_A6XX_CP_IB1_REM_SIZE(__struct_cast(A6XX_CP_IB1_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_IB2_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_IB2_BASE(struct A6XX_CP_IB2_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092b,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_IB2_BASE(...) pack_A6XX_CP_IB2_BASE(__struct_cast(A6XX_CP_IB2_BASE) { __VA_ARGS__ })

struct A6XX_CP_IB2_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_IB2_REM_SIZE(struct A6XX_CP_IB2_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_IB2_REM_SIZE(...) pack_A6XX_CP_IB2_REM_SIZE(__struct_cast(A6XX_CP_IB2_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_SDS_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SDS_BASE(struct A6XX_CP_SDS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000092e,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_SDS_BASE(...) pack_A6XX_CP_SDS_BASE(__struct_cast(A6XX_CP_SDS_BASE) { __VA_ARGS__ })

struct A6XX_CP_SDS_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SDS_REM_SIZE(struct A6XX_CP_SDS_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000930,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SDS_REM_SIZE(...) pack_A6XX_CP_SDS_REM_SIZE(__struct_cast(A6XX_CP_SDS_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_MRB_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_MRB_BASE(struct A6XX_CP_MRB_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000931,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_MRB_BASE(...) pack_A6XX_CP_MRB_BASE(__struct_cast(A6XX_CP_MRB_BASE) { __VA_ARGS__ })

struct A6XX_CP_MRB_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_MRB_REM_SIZE(struct A6XX_CP_MRB_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000933,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_MRB_REM_SIZE(...) pack_A6XX_CP_MRB_REM_SIZE(__struct_cast(A6XX_CP_MRB_REM_SIZE) { __VA_ARGS__ })

struct A6XX_CP_VSD_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_VSD_BASE(struct A6XX_CP_VSD_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000934,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_VSD_BASE(...) pack_A6XX_CP_VSD_BASE(__struct_cast(A6XX_CP_VSD_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB1_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB1_BASE(struct A8XX_CP_IB1_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000900,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_IB1_BASE(...) pack_A8XX_CP_IB1_BASE(__struct_cast(A8XX_CP_IB1_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB1_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB1_REM_SIZE(struct A8XX_CP_IB1_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000902,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_IB1_REM_SIZE(...) pack_A8XX_CP_IB1_REM_SIZE(__struct_cast(A8XX_CP_IB1_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB1_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB1_INIT_SIZE(struct A8XX_CP_IB1_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000903,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_IB1_INIT_SIZE(...) pack_A8XX_CP_IB1_INIT_SIZE(__struct_cast(A8XX_CP_IB1_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB2_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB2_BASE(struct A8XX_CP_IB2_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000904,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_IB2_BASE(...) pack_A8XX_CP_IB2_BASE(__struct_cast(A8XX_CP_IB2_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB2_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB2_REM_SIZE(struct A8XX_CP_IB2_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000906,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_IB2_REM_SIZE(...) pack_A8XX_CP_IB2_REM_SIZE(__struct_cast(A8XX_CP_IB2_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB2_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB2_INIT_SIZE(struct A8XX_CP_IB2_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000907,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_IB2_INIT_SIZE(...) pack_A8XX_CP_IB2_INIT_SIZE(__struct_cast(A8XX_CP_IB2_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB3_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB3_BASE(struct A8XX_CP_IB3_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000908,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_IB3_BASE(...) pack_A8XX_CP_IB3_BASE(__struct_cast(A8XX_CP_IB3_BASE) { __VA_ARGS__ })

struct A8XX_CP_IB3_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB3_REM_SIZE(struct A8XX_CP_IB3_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_IB3_REM_SIZE(...) pack_A8XX_CP_IB3_REM_SIZE(__struct_cast(A8XX_CP_IB3_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_IB3_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_IB3_INIT_SIZE(struct A8XX_CP_IB3_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_IB3_INIT_SIZE(...) pack_A8XX_CP_IB3_INIT_SIZE(__struct_cast(A8XX_CP_IB3_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_SDS_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SDS_BASE(struct A8XX_CP_SDS_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090c,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_SDS_BASE(...) pack_A8XX_CP_SDS_BASE(__struct_cast(A8XX_CP_SDS_BASE) { __VA_ARGS__ })

struct A8XX_CP_SDS_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SDS_REM_SIZE(struct A8XX_CP_SDS_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SDS_REM_SIZE(...) pack_A8XX_CP_SDS_REM_SIZE(__struct_cast(A8XX_CP_SDS_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_SDS_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_SDS_INIT_SIZE(struct A8XX_CP_SDS_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000090f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_SDS_INIT_SIZE(...) pack_A8XX_CP_SDS_INIT_SIZE(__struct_cast(A8XX_CP_SDS_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_MRB_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_MRB_BASE(struct A8XX_CP_MRB_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000910,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_MRB_BASE(...) pack_A8XX_CP_MRB_BASE(__struct_cast(A8XX_CP_MRB_BASE) { __VA_ARGS__ })

struct A8XX_CP_MRB_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_MRB_REM_SIZE(struct A8XX_CP_MRB_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000912,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_MRB_REM_SIZE(...) pack_A8XX_CP_MRB_REM_SIZE(__struct_cast(A8XX_CP_MRB_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_MRB_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_MRB_INIT_SIZE(struct A8XX_CP_MRB_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000913,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_MRB_INIT_SIZE(...) pack_A8XX_CP_MRB_INIT_SIZE(__struct_cast(A8XX_CP_MRB_INIT_SIZE) { __VA_ARGS__ })

struct A8XX_CP_VSD_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_VSD_BASE(struct A8XX_CP_VSD_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000914,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_VSD_BASE(...) pack_A8XX_CP_VSD_BASE(__struct_cast(A8XX_CP_VSD_BASE) { __VA_ARGS__ })

struct A8XX_CP_VSD_REM_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_VSD_REM_SIZE(struct A8XX_CP_VSD_REM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000916,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_VSD_REM_SIZE(...) pack_A8XX_CP_VSD_REM_SIZE(__struct_cast(A8XX_CP_VSD_REM_SIZE) { __VA_ARGS__ })

struct A8XX_CP_VSD_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_VSD_INIT_SIZE(struct A8XX_CP_VSD_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000917,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_VSD_INIT_SIZE(...) pack_A8XX_CP_VSD_INIT_SIZE(__struct_cast(A8XX_CP_VSD_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_ROQ_RB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_RB_STATUS(struct A6XX_CP_ROQ_RB_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000939,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_RB_STATUS(...) pack_A6XX_CP_ROQ_RB_STATUS(__struct_cast(A6XX_CP_ROQ_RB_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_IB1_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_IB1_STATUS(struct A6XX_CP_ROQ_IB1_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093a,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_IB1_STATUS(...) pack_A6XX_CP_ROQ_IB1_STATUS(__struct_cast(A6XX_CP_ROQ_IB1_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_IB2_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_IB2_STATUS(struct A6XX_CP_ROQ_IB2_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093b,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_IB2_STATUS(...) pack_A6XX_CP_ROQ_IB2_STATUS(__struct_cast(A6XX_CP_ROQ_IB2_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_SDS_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_SDS_STATUS(struct A6XX_CP_ROQ_SDS_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093c,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_SDS_STATUS(...) pack_A6XX_CP_ROQ_SDS_STATUS(__struct_cast(A6XX_CP_ROQ_SDS_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_MRB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_MRB_STATUS(struct A6XX_CP_ROQ_MRB_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093d,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_MRB_STATUS(...) pack_A6XX_CP_ROQ_MRB_STATUS(__struct_cast(A6XX_CP_ROQ_MRB_STATUS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_VSD_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_VSD_STATUS(struct A6XX_CP_ROQ_VSD_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000093e,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_VSD_STATUS(...) pack_A6XX_CP_ROQ_VSD_STATUS(__struct_cast(A6XX_CP_ROQ_VSD_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_RB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_RB_STATUS(struct A8XX_CP_ROQ_RB_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000920,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_RB_STATUS(...) pack_A8XX_CP_ROQ_RB_STATUS(__struct_cast(A8XX_CP_ROQ_RB_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_IB1_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_IB1_STATUS(struct A8XX_CP_ROQ_IB1_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000921,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_IB1_STATUS(...) pack_A8XX_CP_ROQ_IB1_STATUS(__struct_cast(A8XX_CP_ROQ_IB1_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_IB2_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_IB2_STATUS(struct A8XX_CP_ROQ_IB2_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000922,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_IB2_STATUS(...) pack_A8XX_CP_ROQ_IB2_STATUS(__struct_cast(A8XX_CP_ROQ_IB2_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_IB3_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_IB3_STATUS(struct A8XX_CP_ROQ_IB3_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000923,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_IB3_STATUS(...) pack_A8XX_CP_ROQ_IB3_STATUS(__struct_cast(A8XX_CP_ROQ_IB3_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_SDS_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_SDS_STATUS(struct A8XX_CP_ROQ_SDS_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000924,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_SDS_STATUS(...) pack_A8XX_CP_ROQ_SDS_STATUS(__struct_cast(A8XX_CP_ROQ_SDS_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_MRB_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_MRB_STATUS(struct A8XX_CP_ROQ_MRB_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000925,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_MRB_STATUS(...) pack_A8XX_CP_ROQ_MRB_STATUS(__struct_cast(A8XX_CP_ROQ_MRB_STATUS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_VSD_STATUS {
    uint32_t							rptr;
    uint32_t							wptr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_VSD_STATUS(struct A8XX_CP_ROQ_VSD_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.rptr                              & 0xfffffc00) == 0);
    assert((fields.wptr                              & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x03ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000926,
        .value =
            (fields.rptr                              <<  0) |
            (fields.wptr                              << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_VSD_STATUS(...) pack_A8XX_CP_ROQ_VSD_STATUS(__struct_cast(A8XX_CP_ROQ_VSD_STATUS) { __VA_ARGS__ })

struct A6XX_CP_IB1_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_IB1_INIT_SIZE(struct A6XX_CP_IB1_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000943,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_IB1_INIT_SIZE(...) pack_A6XX_CP_IB1_INIT_SIZE(__struct_cast(A6XX_CP_IB1_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_IB2_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_IB2_INIT_SIZE(struct A6XX_CP_IB2_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000944,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_IB2_INIT_SIZE(...) pack_A6XX_CP_IB2_INIT_SIZE(__struct_cast(A6XX_CP_IB2_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_SDS_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_SDS_INIT_SIZE(struct A6XX_CP_SDS_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000945,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_SDS_INIT_SIZE(...) pack_A6XX_CP_SDS_INIT_SIZE(__struct_cast(A6XX_CP_SDS_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_MRB_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_MRB_INIT_SIZE(struct A6XX_CP_MRB_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000946,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_MRB_INIT_SIZE(...) pack_A6XX_CP_MRB_INIT_SIZE(__struct_cast(A6XX_CP_MRB_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_VSD_INIT_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_VSD_INIT_SIZE(struct A6XX_CP_VSD_INIT_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000947,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_VSD_INIT_SIZE(...) pack_A6XX_CP_VSD_INIT_SIZE(__struct_cast(A6XX_CP_VSD_INIT_SIZE) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_RB {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_AVAIL_RB(struct A6XX_CP_ROQ_AVAIL_RB fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000948,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_AVAIL_RB(...) pack_A6XX_CP_ROQ_AVAIL_RB(__struct_cast(A6XX_CP_ROQ_AVAIL_RB) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_IB1 {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_AVAIL_IB1(struct A6XX_CP_ROQ_AVAIL_IB1 fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000949,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_AVAIL_IB1(...) pack_A6XX_CP_ROQ_AVAIL_IB1(__struct_cast(A6XX_CP_ROQ_AVAIL_IB1) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_IB2 {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_AVAIL_IB2(struct A6XX_CP_ROQ_AVAIL_IB2 fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094a,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_AVAIL_IB2(...) pack_A6XX_CP_ROQ_AVAIL_IB2(__struct_cast(A6XX_CP_ROQ_AVAIL_IB2) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_SDS {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_AVAIL_SDS(struct A6XX_CP_ROQ_AVAIL_SDS fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094b,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_AVAIL_SDS(...) pack_A6XX_CP_ROQ_AVAIL_SDS(__struct_cast(A6XX_CP_ROQ_AVAIL_SDS) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_MRB {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_AVAIL_MRB(struct A6XX_CP_ROQ_AVAIL_MRB fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094c,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_AVAIL_MRB(...) pack_A6XX_CP_ROQ_AVAIL_MRB(__struct_cast(A6XX_CP_ROQ_AVAIL_MRB) { __VA_ARGS__ })

struct A6XX_CP_ROQ_AVAIL_VSD {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ROQ_AVAIL_VSD(struct A6XX_CP_ROQ_AVAIL_VSD fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000094d,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_ROQ_AVAIL_VSD(...) pack_A6XX_CP_ROQ_AVAIL_VSD(__struct_cast(A6XX_CP_ROQ_AVAIL_VSD) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_RB {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_AVAIL_RB(struct A8XX_CP_ROQ_AVAIL_RB fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000918,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_AVAIL_RB(...) pack_A8XX_CP_ROQ_AVAIL_RB(__struct_cast(A8XX_CP_ROQ_AVAIL_RB) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_IB1 {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_AVAIL_IB1(struct A8XX_CP_ROQ_AVAIL_IB1 fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000919,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_AVAIL_IB1(...) pack_A8XX_CP_ROQ_AVAIL_IB1(__struct_cast(A8XX_CP_ROQ_AVAIL_IB1) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_IB2 {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_AVAIL_IB2(struct A8XX_CP_ROQ_AVAIL_IB2 fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091a,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_AVAIL_IB2(...) pack_A8XX_CP_ROQ_AVAIL_IB2(__struct_cast(A8XX_CP_ROQ_AVAIL_IB2) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_IB3 {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_AVAIL_IB3(struct A8XX_CP_ROQ_AVAIL_IB3 fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091b,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_AVAIL_IB3(...) pack_A8XX_CP_ROQ_AVAIL_IB3(__struct_cast(A8XX_CP_ROQ_AVAIL_IB3) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_SDS {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_AVAIL_SDS(struct A8XX_CP_ROQ_AVAIL_SDS fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091c,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_AVAIL_SDS(...) pack_A8XX_CP_ROQ_AVAIL_SDS(__struct_cast(A8XX_CP_ROQ_AVAIL_SDS) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_MRB {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_AVAIL_MRB(struct A8XX_CP_ROQ_AVAIL_MRB fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091d,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_AVAIL_MRB(...) pack_A8XX_CP_ROQ_AVAIL_MRB(__struct_cast(A8XX_CP_ROQ_AVAIL_MRB) { __VA_ARGS__ })

struct A8XX_CP_ROQ_AVAIL_VSD {
    uint32_t							rem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ROQ_AVAIL_VSD(struct A8XX_CP_ROQ_AVAIL_VSD fields)
{
#ifndef NDEBUG
    assert((fields.rem                               & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000091e,
        .value =
            (fields.rem                               << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_ROQ_AVAIL_VSD(...) pack_A8XX_CP_ROQ_AVAIL_VSD(__struct_cast(A8XX_CP_ROQ_AVAIL_VSD) { __VA_ARGS__ })

struct A6XX_CP_ALWAYS_ON_COUNTER {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ALWAYS_ON_COUNTER(struct A6XX_CP_ALWAYS_ON_COUNTER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000980,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_ALWAYS_ON_COUNTER(...) pack_A6XX_CP_ALWAYS_ON_COUNTER(__struct_cast(A6XX_CP_ALWAYS_ON_COUNTER) { __VA_ARGS__ })

struct A6XX_CP_ALWAYS_ON_CONTEXT {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_ALWAYS_ON_CONTEXT(struct A6XX_CP_ALWAYS_ON_CONTEXT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000982,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_ALWAYS_ON_CONTEXT(...) pack_A6XX_CP_ALWAYS_ON_CONTEXT(__struct_cast(A6XX_CP_ALWAYS_ON_CONTEXT) { __VA_ARGS__ })

struct A8XX_CP_ALWAYS_ON_COUNTER {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ALWAYS_ON_COUNTER(struct A8XX_CP_ALWAYS_ON_COUNTER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008e7,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_ALWAYS_ON_COUNTER(...) pack_A8XX_CP_ALWAYS_ON_COUNTER(__struct_cast(A8XX_CP_ALWAYS_ON_COUNTER) { __VA_ARGS__ })

struct A8XX_CP_ALWAYS_ON_CONTEXT {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_ALWAYS_ON_CONTEXT(struct A8XX_CP_ALWAYS_ON_CONTEXT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000008e9,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_CP_ALWAYS_ON_CONTEXT(...) pack_A8XX_CP_ALWAYS_ON_CONTEXT(__struct_cast(A8XX_CP_ALWAYS_ON_CONTEXT) { __VA_ARGS__ })

struct A6XX_CP_AHB_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_AHB_CNTL(struct A6XX_CP_AHB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000098d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_AHB_CNTL(...) pack_A6XX_CP_AHB_CNTL(__struct_cast(A6XX_CP_AHB_CNTL) { __VA_ARGS__ })

struct A8XX_CP_AHB_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_AHB_CNTL(struct A8XX_CP_AHB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000838,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_AHB_CNTL(...) pack_A8XX_CP_AHB_CNTL(__struct_cast(A8XX_CP_AHB_CNTL) { __VA_ARGS__ })

struct A6XX_CP_APERTURE_CNTL_HOST {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_APERTURE_CNTL_HOST(struct A6XX_CP_APERTURE_CNTL_HOST fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_APERTURE_CNTL_HOST(...) pack_A6XX_CP_APERTURE_CNTL_HOST(__struct_cast(A6XX_CP_APERTURE_CNTL_HOST) { __VA_ARGS__ })

struct A7XX_CP_APERTURE_CNTL_HOST {
    enum adreno_pipe						pipe;
    enum a7xx_cluster						cluster;
    uint32_t							context;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_APERTURE_CNTL_HOST(struct A7XX_CP_APERTURE_CNTL_HOST fields)
{
#ifndef NDEBUG
    assert((fields.pipe                              & 0xfffffffc) == 0);
    assert((fields.cluster                           & 0xfffffff8) == 0);
    assert((fields.context                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00003730) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a00,
        .value =
            (fields.pipe                              << 12) |
            (fields.cluster                           <<  8) |
            (fields.context                           <<  4) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_APERTURE_CNTL_HOST(...) pack_A7XX_CP_APERTURE_CNTL_HOST(__struct_cast(A7XX_CP_APERTURE_CNTL_HOST) { __VA_ARGS__ })

struct A6XX_CP_APERTURE_CNTL_SQE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_APERTURE_CNTL_SQE(struct A6XX_CP_APERTURE_CNTL_SQE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_APERTURE_CNTL_SQE(...) pack_A6XX_CP_APERTURE_CNTL_SQE(__struct_cast(A6XX_CP_APERTURE_CNTL_SQE) { __VA_ARGS__ })

struct A6XX_CP_APERTURE_CNTL_CD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_APERTURE_CNTL_CD(struct A6XX_CP_APERTURE_CNTL_CD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a03,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_APERTURE_CNTL_CD(...) pack_A6XX_CP_APERTURE_CNTL_CD(__struct_cast(A6XX_CP_APERTURE_CNTL_CD) { __VA_ARGS__ })

struct A7XX_CP_APERTURE_CNTL_CD {
    enum adreno_pipe						pipe;
    enum a7xx_cluster						cluster;
    uint32_t							context;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_APERTURE_CNTL_CD(struct A7XX_CP_APERTURE_CNTL_CD fields)
{
#ifndef NDEBUG
    assert((fields.pipe                              & 0xfffffffc) == 0);
    assert((fields.cluster                           & 0xfffffff8) == 0);
    assert((fields.context                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00003730) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a03,
        .value =
            (fields.pipe                              << 12) |
            (fields.cluster                           <<  8) |
            (fields.context                           <<  4) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_APERTURE_CNTL_CD(...) pack_A7XX_CP_APERTURE_CNTL_CD(__struct_cast(A7XX_CP_APERTURE_CNTL_CD) { __VA_ARGS__ })

struct A7XX_CP_RESERVED_REG_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_RESERVED_REG_REG(uint32_t __i, struct A7XX_CP_RESERVED_REG_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000a9c + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_RESERVED_REG_REG(__i, ...) pack_A7XX_CP_RESERVED_REG_REG(__i, __struct_cast(A7XX_CP_RESERVED_REG_REG) { __VA_ARGS__ })

struct A8XX_CP_RESERVED_REG_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_RESERVED_REG_REG(uint32_t __i, struct A8XX_CP_RESERVED_REG_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000958 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_RESERVED_REG_REG(__i, ...) pack_A8XX_CP_RESERVED_REG_REG(__i, __struct_cast(A8XX_CP_RESERVED_REG_REG) { __VA_ARGS__ })

struct A8XX_CP_APERTURE_CNTL_HOST {
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_APERTURE_CNTL_HOST(struct A8XX_CP_APERTURE_CNTL_HOST fields)
{
#ifndef NDEBUG
    assert((fields.contextid3d                       & 0xfffffffc) == 0);
    assert((fields.clusterid                         & 0xfffffff0) == 0);
    assert((fields.pipeid                            & 0xfffffff0) == 0);
    assert((fields.sliceid                           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0087ff30) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081c,
        .value =
            (fields.contextid3d                       <<  4) |
            (fields.clusterid                         <<  8) |
            (fields.pipeid                            << 12) |
            (fields.sliceid                           << 16) |
            (fields.usesliceid                        << 23) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_APERTURE_CNTL_HOST(...) pack_A8XX_CP_APERTURE_CNTL_HOST(__struct_cast(A8XX_CP_APERTURE_CNTL_HOST) { __VA_ARGS__ })

struct A8XX_CP_APERTURE_CNTL_GMU {
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_APERTURE_CNTL_GMU(struct A8XX_CP_APERTURE_CNTL_GMU fields)
{
#ifndef NDEBUG
    assert((fields.contextid3d                       & 0xfffffffc) == 0);
    assert((fields.clusterid                         & 0xfffffff0) == 0);
    assert((fields.pipeid                            & 0xfffffff0) == 0);
    assert((fields.sliceid                           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0087ff30) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081d,
        .value =
            (fields.contextid3d                       <<  4) |
            (fields.clusterid                         <<  8) |
            (fields.pipeid                            << 12) |
            (fields.sliceid                           << 16) |
            (fields.usesliceid                        << 23) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_APERTURE_CNTL_GMU(...) pack_A8XX_CP_APERTURE_CNTL_GMU(__struct_cast(A8XX_CP_APERTURE_CNTL_GMU) { __VA_ARGS__ })

struct A8XX_CP_APERTURE_CNTL_CD {
    uint32_t							contextid3d;
    uint32_t							clusterid;
    uint32_t							pipeid;
    uint32_t							sliceid;
    bool							usesliceid;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_CP_APERTURE_CNTL_CD(struct A8XX_CP_APERTURE_CNTL_CD fields)
{
#ifndef NDEBUG
    assert((fields.contextid3d                       & 0xfffffffc) == 0);
    assert((fields.clusterid                         & 0xfffffff0) == 0);
    assert((fields.pipeid                            & 0xfffffff0) == 0);
    assert((fields.sliceid                           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0087ff30) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000081e,
        .value =
            (fields.contextid3d                       <<  4) |
            (fields.clusterid                         <<  8) |
            (fields.pipeid                            << 12) |
            (fields.sliceid                           << 16) |
            (fields.usesliceid                        << 23) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_CP_APERTURE_CNTL_CD(...) pack_A8XX_CP_APERTURE_CNTL_CD(__struct_cast(A8XX_CP_APERTURE_CNTL_CD) { __VA_ARGS__ })

struct A7XX_CP_BV_PROTECT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_PROTECT_STATUS(struct A7XX_CP_BV_PROTECT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a61,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_PROTECT_STATUS(...) pack_A7XX_CP_BV_PROTECT_STATUS(__struct_cast(A7XX_CP_BV_PROTECT_STATUS) { __VA_ARGS__ })

struct A7XX_CP_BV_HW_FAULT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_HW_FAULT(struct A7XX_CP_BV_HW_FAULT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a64,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_HW_FAULT(...) pack_A7XX_CP_BV_HW_FAULT(__struct_cast(A7XX_CP_BV_HW_FAULT) { __VA_ARGS__ })

struct A7XX_CP_BV_DRAW_STATE_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_DRAW_STATE_ADDR(struct A7XX_CP_BV_DRAW_STATE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a81,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_DRAW_STATE_ADDR(...) pack_A7XX_CP_BV_DRAW_STATE_ADDR(__struct_cast(A7XX_CP_BV_DRAW_STATE_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_DRAW_STATE_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_DRAW_STATE_DATA(struct A7XX_CP_BV_DRAW_STATE_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a82,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_DRAW_STATE_DATA(...) pack_A7XX_CP_BV_DRAW_STATE_DATA(__struct_cast(A7XX_CP_BV_DRAW_STATE_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_ROQ_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_ROQ_DBG_ADDR(struct A7XX_CP_BV_ROQ_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a83,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_ROQ_DBG_ADDR(...) pack_A7XX_CP_BV_ROQ_DBG_ADDR(__struct_cast(A7XX_CP_BV_ROQ_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_ROQ_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_ROQ_DBG_DATA(struct A7XX_CP_BV_ROQ_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a84,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_ROQ_DBG_DATA(...) pack_A7XX_CP_BV_ROQ_DBG_DATA(__struct_cast(A7XX_CP_BV_ROQ_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_UCODE_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_SQE_UCODE_DBG_ADDR(struct A7XX_CP_BV_SQE_UCODE_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a85,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_SQE_UCODE_DBG_ADDR(...) pack_A7XX_CP_BV_SQE_UCODE_DBG_ADDR(__struct_cast(A7XX_CP_BV_SQE_UCODE_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_UCODE_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_SQE_UCODE_DBG_DATA(struct A7XX_CP_BV_SQE_UCODE_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a86,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_SQE_UCODE_DBG_DATA(...) pack_A7XX_CP_BV_SQE_UCODE_DBG_DATA(__struct_cast(A7XX_CP_BV_SQE_UCODE_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_STAT_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_SQE_STAT_ADDR(struct A7XX_CP_BV_SQE_STAT_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a87,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_SQE_STAT_ADDR(...) pack_A7XX_CP_BV_SQE_STAT_ADDR(__struct_cast(A7XX_CP_BV_SQE_STAT_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_SQE_STAT_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_SQE_STAT_DATA(struct A7XX_CP_BV_SQE_STAT_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a88,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_SQE_STAT_DATA(...) pack_A7XX_CP_BV_SQE_STAT_DATA(__struct_cast(A7XX_CP_BV_SQE_STAT_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_MEM_POOL_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_MEM_POOL_DBG_ADDR(struct A7XX_CP_BV_MEM_POOL_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a96,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_MEM_POOL_DBG_ADDR(...) pack_A7XX_CP_BV_MEM_POOL_DBG_ADDR(__struct_cast(A7XX_CP_BV_MEM_POOL_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_BV_MEM_POOL_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_MEM_POOL_DBG_DATA(struct A7XX_CP_BV_MEM_POOL_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a97,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_MEM_POOL_DBG_DATA(...) pack_A7XX_CP_BV_MEM_POOL_DBG_DATA(__struct_cast(A7XX_CP_BV_MEM_POOL_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_RB_RPTR_ADDR {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_RB_RPTR_ADDR(struct A7XX_CP_BV_RB_RPTR_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a98,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A7XX_CP_BV_RB_RPTR_ADDR(...) pack_A7XX_CP_BV_RB_RPTR_ADDR(__struct_cast(A7XX_CP_BV_RB_RPTR_ADDR) { __VA_ARGS__ })

struct A7XX_CP_RESOURCE_TABLE_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_RESOURCE_TABLE_DBG_ADDR(struct A7XX_CP_RESOURCE_TABLE_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a9a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_RESOURCE_TABLE_DBG_ADDR(...) pack_A7XX_CP_RESOURCE_TABLE_DBG_ADDR(__struct_cast(A7XX_CP_RESOURCE_TABLE_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_RESOURCE_TABLE_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_RESOURCE_TABLE_DBG_DATA(struct A7XX_CP_RESOURCE_TABLE_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000a9b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_RESOURCE_TABLE_DBG_DATA(...) pack_A7XX_CP_RESOURCE_TABLE_DBG_DATA(__struct_cast(A7XX_CP_RESOURCE_TABLE_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_BV_APRIV_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_APRIV_CNTL(struct A7XX_CP_BV_APRIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ad0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_APRIV_CNTL(...) pack_A7XX_CP_BV_APRIV_CNTL(__struct_cast(A7XX_CP_BV_APRIV_CNTL) { __VA_ARGS__ })

struct A7XX_CP_BV_CHICKEN_DBG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_BV_CHICKEN_DBG(struct A7XX_CP_BV_CHICKEN_DBG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ada,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_BV_CHICKEN_DBG(...) pack_A7XX_CP_BV_CHICKEN_DBG(__struct_cast(A7XX_CP_BV_CHICKEN_DBG) { __VA_ARGS__ })

struct A7XX_CP_LPAC_DRAW_STATE_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_DRAW_STATE_ADDR(struct A7XX_CP_LPAC_DRAW_STATE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b0a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_DRAW_STATE_ADDR(...) pack_A7XX_CP_LPAC_DRAW_STATE_ADDR(__struct_cast(A7XX_CP_LPAC_DRAW_STATE_ADDR) { __VA_ARGS__ })

struct A7XX_CP_LPAC_DRAW_STATE_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_DRAW_STATE_DATA(struct A7XX_CP_LPAC_DRAW_STATE_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b0b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_DRAW_STATE_DATA(...) pack_A7XX_CP_LPAC_DRAW_STATE_DATA(__struct_cast(A7XX_CP_LPAC_DRAW_STATE_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_ROQ_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_ROQ_DBG_ADDR(struct A7XX_CP_LPAC_ROQ_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b0c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_ROQ_DBG_ADDR(...) pack_A7XX_CP_LPAC_ROQ_DBG_ADDR(__struct_cast(A7XX_CP_LPAC_ROQ_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_UCODE_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_SQE_AC_UCODE_DBG_ADDR(struct A7XX_CP_SQE_AC_UCODE_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b27,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_SQE_AC_UCODE_DBG_ADDR(...) pack_A7XX_CP_SQE_AC_UCODE_DBG_ADDR(__struct_cast(A7XX_CP_SQE_AC_UCODE_DBG_ADDR) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_UCODE_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_SQE_AC_UCODE_DBG_DATA(struct A7XX_CP_SQE_AC_UCODE_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b28,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_SQE_AC_UCODE_DBG_DATA(...) pack_A7XX_CP_SQE_AC_UCODE_DBG_DATA(__struct_cast(A7XX_CP_SQE_AC_UCODE_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_STAT_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_SQE_AC_STAT_ADDR(struct A7XX_CP_SQE_AC_STAT_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b29,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_SQE_AC_STAT_ADDR(...) pack_A7XX_CP_SQE_AC_STAT_ADDR(__struct_cast(A7XX_CP_SQE_AC_STAT_ADDR) { __VA_ARGS__ })

struct A7XX_CP_SQE_AC_STAT_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_SQE_AC_STAT_DATA(struct A7XX_CP_SQE_AC_STAT_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b2a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_SQE_AC_STAT_DATA(...) pack_A7XX_CP_SQE_AC_STAT_DATA(__struct_cast(A7XX_CP_SQE_AC_STAT_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_APRIV_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_APRIV_CNTL(struct A7XX_CP_LPAC_APRIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b31,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_APRIV_CNTL(...) pack_A7XX_CP_LPAC_APRIV_CNTL(__struct_cast(A7XX_CP_LPAC_APRIV_CNTL) { __VA_ARGS__ })

struct A7XX_CP_LPAC_PROG_FIFO_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_PROG_FIFO_SIZE(struct A7XX_CP_LPAC_PROG_FIFO_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b34,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_PROG_FIFO_SIZE(...) pack_A7XX_CP_LPAC_PROG_FIFO_SIZE(__struct_cast(A7XX_CP_LPAC_PROG_FIFO_SIZE) { __VA_ARGS__ })

struct A7XX_CP_LPAC_ROQ_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_ROQ_DBG_DATA(struct A7XX_CP_LPAC_ROQ_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b35,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_ROQ_DBG_DATA(...) pack_A7XX_CP_LPAC_ROQ_DBG_DATA(__struct_cast(A7XX_CP_LPAC_ROQ_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_FIFO_DBG_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_FIFO_DBG_DATA(struct A7XX_CP_LPAC_FIFO_DBG_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b36,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_FIFO_DBG_DATA(...) pack_A7XX_CP_LPAC_FIFO_DBG_DATA(__struct_cast(A7XX_CP_LPAC_FIFO_DBG_DATA) { __VA_ARGS__ })

struct A7XX_CP_LPAC_FIFO_DBG_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_LPAC_FIFO_DBG_ADDR(struct A7XX_CP_LPAC_FIFO_DBG_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b40,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_LPAC_FIFO_DBG_ADDR(...) pack_A7XX_CP_LPAC_FIFO_DBG_ADDR(__struct_cast(A7XX_CP_LPAC_FIFO_DBG_ADDR) { __VA_ARGS__ })

struct A6XX_CP_LPAC_SQE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_LPAC_SQE_CNTL(struct A6XX_CP_LPAC_SQE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b81,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_CP_LPAC_SQE_CNTL(...) pack_A6XX_CP_LPAC_SQE_CNTL(__struct_cast(A6XX_CP_LPAC_SQE_CNTL) { __VA_ARGS__ })

struct A6XX_CP_LPAC_SQE_INSTR_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_CP_LPAC_SQE_INSTR_BASE(struct A6XX_CP_LPAC_SQE_INSTR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b82,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_CP_LPAC_SQE_INSTR_BASE(...) pack_A6XX_CP_LPAC_SQE_INSTR_BASE(__struct_cast(A6XX_CP_LPAC_SQE_INSTR_BASE) { __VA_ARGS__ })

struct A7XX_CP_AQE_INSTR_BASE_0 {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_INSTR_BASE_0(struct A7XX_CP_AQE_INSTR_BASE_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b70,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A7XX_CP_AQE_INSTR_BASE_0(...) pack_A7XX_CP_AQE_INSTR_BASE_0(__struct_cast(A7XX_CP_AQE_INSTR_BASE_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_INSTR_BASE_1 {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_INSTR_BASE_1(struct A7XX_CP_AQE_INSTR_BASE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b72,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A7XX_CP_AQE_INSTR_BASE_1(...) pack_A7XX_CP_AQE_INSTR_BASE_1(__struct_cast(A7XX_CP_AQE_INSTR_BASE_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_APRIV_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_APRIV_CNTL(struct A7XX_CP_AQE_APRIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000b78,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_APRIV_CNTL(...) pack_A7XX_CP_AQE_APRIV_CNTL(__struct_cast(A7XX_CP_AQE_APRIV_CNTL) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_ADDR_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_ROQ_DBG_ADDR_0(struct A7XX_CP_AQE_ROQ_DBG_ADDR_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ba8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_ROQ_DBG_ADDR_0(...) pack_A7XX_CP_AQE_ROQ_DBG_ADDR_0(__struct_cast(A7XX_CP_AQE_ROQ_DBG_ADDR_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_ADDR_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_ROQ_DBG_ADDR_1(struct A7XX_CP_AQE_ROQ_DBG_ADDR_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000ba9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_ROQ_DBG_ADDR_1(...) pack_A7XX_CP_AQE_ROQ_DBG_ADDR_1(__struct_cast(A7XX_CP_AQE_ROQ_DBG_ADDR_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_DATA_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_ROQ_DBG_DATA_0(struct A7XX_CP_AQE_ROQ_DBG_DATA_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bac,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_ROQ_DBG_DATA_0(...) pack_A7XX_CP_AQE_ROQ_DBG_DATA_0(__struct_cast(A7XX_CP_AQE_ROQ_DBG_DATA_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_ROQ_DBG_DATA_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_ROQ_DBG_DATA_1(struct A7XX_CP_AQE_ROQ_DBG_DATA_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bad,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_ROQ_DBG_DATA_1(...) pack_A7XX_CP_AQE_ROQ_DBG_DATA_1(__struct_cast(A7XX_CP_AQE_ROQ_DBG_DATA_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_ADDR_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_UCODE_DBG_ADDR_0(struct A7XX_CP_AQE_UCODE_DBG_ADDR_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_UCODE_DBG_ADDR_0(...) pack_A7XX_CP_AQE_UCODE_DBG_ADDR_0(__struct_cast(A7XX_CP_AQE_UCODE_DBG_ADDR_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_ADDR_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_UCODE_DBG_ADDR_1(struct A7XX_CP_AQE_UCODE_DBG_ADDR_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_UCODE_DBG_ADDR_1(...) pack_A7XX_CP_AQE_UCODE_DBG_ADDR_1(__struct_cast(A7XX_CP_AQE_UCODE_DBG_ADDR_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_DATA_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_UCODE_DBG_DATA_0(struct A7XX_CP_AQE_UCODE_DBG_DATA_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_UCODE_DBG_DATA_0(...) pack_A7XX_CP_AQE_UCODE_DBG_DATA_0(__struct_cast(A7XX_CP_AQE_UCODE_DBG_DATA_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_UCODE_DBG_DATA_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_UCODE_DBG_DATA_1(struct A7XX_CP_AQE_UCODE_DBG_DATA_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_UCODE_DBG_DATA_1(...) pack_A7XX_CP_AQE_UCODE_DBG_DATA_1(__struct_cast(A7XX_CP_AQE_UCODE_DBG_DATA_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_ADDR_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_STAT_ADDR_0(struct A7XX_CP_AQE_STAT_ADDR_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_STAT_ADDR_0(...) pack_A7XX_CP_AQE_STAT_ADDR_0(__struct_cast(A7XX_CP_AQE_STAT_ADDR_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_ADDR_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_STAT_ADDR_1(struct A7XX_CP_AQE_STAT_ADDR_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bb9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_STAT_ADDR_1(...) pack_A7XX_CP_AQE_STAT_ADDR_1(__struct_cast(A7XX_CP_AQE_STAT_ADDR_1) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_DATA_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_STAT_DATA_0(struct A7XX_CP_AQE_STAT_DATA_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bbc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_STAT_DATA_0(...) pack_A7XX_CP_AQE_STAT_DATA_0(__struct_cast(A7XX_CP_AQE_STAT_DATA_0) { __VA_ARGS__ })

struct A7XX_CP_AQE_STAT_DATA_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_CP_AQE_STAT_DATA_1(struct A7XX_CP_AQE_STAT_DATA_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000bbd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_CP_AQE_STAT_DATA_1(...) pack_A7XX_CP_AQE_STAT_DATA_1(__struct_cast(A7XX_CP_AQE_STAT_DATA_1) { __VA_ARGS__ })

struct A6XX_VSC_ADDR_MODE_CNTL {
    enum a5xx_address_mode					vsc_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VSC_ADDR_MODE_CNTL(struct A6XX_VSC_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.vsc_addr_mode_cntl                & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c01,
        .value =
            (fields.vsc_addr_mode_cntl                <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_ADDR_MODE_CNTL(...) pack_A6XX_VSC_ADDR_MODE_CNTL(__struct_cast(A6XX_VSC_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_GPR0_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_GPR0_CNTL(struct A6XX_RBBM_GPR0_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000018,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_GPR0_CNTL(...) pack_A6XX_RBBM_GPR0_CNTL(__struct_cast(A6XX_RBBM_GPR0_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS {
    bool							gpu_busy_ign_ahb;
    bool							gpu_busy_ign_ahb_cp;
    bool							hlsq_busy;
    bool							vsc_busy;
    bool							tpl1_busy;
    bool							sp_busy;
    bool							uche_busy;
    bool							vpc_busy;
    bool							vfd_busy;
    bool							tess_busy;
    bool							pc_vsd_busy;
    bool							pc_dcall_busy;
    bool							com_dcom_busy;
    bool							lrz_busy;
    bool							a2d_busy;
    bool							ccu_busy;
    bool							rb_busy;
    bool							ras_busy;
    bool							tse_busy;
    bool							vbif_busy;
    bool							gfx_dbgc_busy;
    bool							cp_busy;
    bool							cp_ahb_busy_cp_master;
    bool							cp_ahb_busy_cx_master;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_STATUS(struct A6XX_RBBM_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000210,
        .value =
            (fields.gpu_busy_ign_ahb                  << 23) |
            (fields.gpu_busy_ign_ahb_cp               << 22) |
            (fields.hlsq_busy                         << 21) |
            (fields.vsc_busy                          << 20) |
            (fields.tpl1_busy                         << 19) |
            (fields.sp_busy                           << 18) |
            (fields.uche_busy                         << 17) |
            (fields.vpc_busy                          << 16) |
            (fields.vfd_busy                          << 15) |
            (fields.tess_busy                         << 14) |
            (fields.pc_vsd_busy                       << 13) |
            (fields.pc_dcall_busy                     << 12) |
            (fields.com_dcom_busy                     << 11) |
            (fields.lrz_busy                          << 10) |
            (fields.a2d_busy                          <<  9) |
            (fields.ccu_busy                          <<  8) |
            (fields.rb_busy                           <<  7) |
            (fields.ras_busy                          <<  6) |
            (fields.tse_busy                          <<  5) |
            (fields.vbif_busy                         <<  4) |
            (fields.gfx_dbgc_busy                     <<  3) |
            (fields.cp_busy                           <<  2) |
            (fields.cp_ahb_busy_cp_master             <<  1) |
            (fields.cp_ahb_busy_cx_master             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_STATUS(...) pack_A6XX_RBBM_STATUS(__struct_cast(A6XX_RBBM_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_STATUS1(struct A6XX_RBBM_STATUS1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000211,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_STATUS1(...) pack_A6XX_RBBM_STATUS1(__struct_cast(A6XX_RBBM_STATUS1) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_STATUS2(struct A6XX_RBBM_STATUS2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000212,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_STATUS2(...) pack_A6XX_RBBM_STATUS2(__struct_cast(A6XX_RBBM_STATUS2) { __VA_ARGS__ })

struct A6XX_RBBM_STATUS3 {
    bool							smmu_stalled_on_fault;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_STATUS3(struct A6XX_RBBM_STATUS3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x01000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000213,
        .value =
            (fields.smmu_stalled_on_fault             << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_STATUS3(...) pack_A6XX_RBBM_STATUS3(__struct_cast(A6XX_RBBM_STATUS3) { __VA_ARGS__ })

struct A8XX_RBBM_STATUS {
    bool							gpu_busy_ign_ahb;
    bool							gpu_busy_ign_ahb_cp;
    bool							slice_busy_ign_cp;
    bool							cp_slice_busy;
    bool							unslice_busy_ign_ahb;
    bool							unslice_busy_ign_ahb_cp;
    bool							cp_slice_rl_busy;
    bool							unslice_top_busy;
    bool							ufc_busy;
    bool							hlsq_busy;
    bool							vsc_busy;
    bool							uche_busy;
    bool							vpc_busy;
    bool							pc_busy;
    bool							cmp_busy;
    bool							dcmp_busy;
    bool							vbif_gx_busy;
    bool							dbgc_perf_busy;
    bool							gfx_dbgc_busy;
    bool							cp_busy;
    bool							cp_ahb_busy_cp_master;
    bool							cp_ahb_busy_cx_master;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_STATUS(struct A8XX_RBBM_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00fe7fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000012,
        .value =
            (fields.gpu_busy_ign_ahb                  << 23) |
            (fields.gpu_busy_ign_ahb_cp               << 22) |
            (fields.slice_busy_ign_cp                 << 21) |
            (fields.cp_slice_busy                     << 20) |
            (fields.unslice_busy_ign_ahb              << 19) |
            (fields.unslice_busy_ign_ahb_cp           << 18) |
            (fields.cp_slice_rl_busy                  << 17) |
            (fields.unslice_top_busy                  << 14) |
            (fields.ufc_busy                          << 13) |
            (fields.hlsq_busy                         << 12) |
            (fields.vsc_busy                          << 11) |
            (fields.uche_busy                         << 10) |
            (fields.vpc_busy                          <<  9) |
            (fields.pc_busy                           <<  8) |
            (fields.cmp_busy                          <<  7) |
            (fields.dcmp_busy                         <<  6) |
            (fields.vbif_gx_busy                      <<  5) |
            (fields.dbgc_perf_busy                    <<  4) |
            (fields.gfx_dbgc_busy                     <<  3) |
            (fields.cp_busy                           <<  2) |
            (fields.cp_ahb_busy_cp_master             <<  1) |
            (fields.cp_ahb_busy_cx_master             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_STATUS(...) pack_A8XX_RBBM_STATUS(__struct_cast(A8XX_RBBM_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_STATUS1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_STATUS1(struct A8XX_RBBM_STATUS1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000013,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_STATUS1(...) pack_A8XX_RBBM_STATUS1(__struct_cast(A8XX_RBBM_STATUS1) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_GFX_STATUS(struct A8XX_RBBM_GFX_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000015,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_GFX_STATUS(...) pack_A8XX_RBBM_GFX_STATUS(__struct_cast(A8XX_RBBM_GFX_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_STATUS1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_GFX_STATUS1(struct A8XX_RBBM_GFX_STATUS1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000016,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_GFX_STATUS1(...) pack_A8XX_RBBM_GFX_STATUS1(__struct_cast(A8XX_RBBM_GFX_STATUS1) { __VA_ARGS__ })

struct A8XX_RBBM_LPAC_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_LPAC_STATUS(struct A8XX_RBBM_LPAC_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000018,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_LPAC_STATUS(...) pack_A8XX_RBBM_LPAC_STATUS(__struct_cast(A8XX_RBBM_LPAC_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_BR_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_GFX_BR_STATUS(struct A8XX_RBBM_GFX_BR_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_GFX_BR_STATUS(...) pack_A8XX_RBBM_GFX_BR_STATUS(__struct_cast(A8XX_RBBM_GFX_BR_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_GFX_BV_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_GFX_BV_STATUS(struct A8XX_RBBM_GFX_BV_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_GFX_BV_STATUS(...) pack_A8XX_RBBM_GFX_BV_STATUS(__struct_cast(A8XX_RBBM_GFX_BV_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_MISC_STATUS {
    bool							smmu_stalled_on_fault;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_MISC_STATUS(struct A8XX_RBBM_MISC_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001e,
        .value =
            (fields.smmu_stalled_on_fault             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_MISC_STATUS(...) pack_A8XX_RBBM_MISC_STATUS(__struct_cast(A8XX_RBBM_MISC_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_VBIF_GX_RESET_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_VBIF_GX_RESET_STATUS(struct A6XX_RBBM_VBIF_GX_RESET_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000215,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_VBIF_GX_RESET_STATUS(...) pack_A6XX_RBBM_VBIF_GX_RESET_STATUS(__struct_cast(A6XX_RBBM_VBIF_GX_RESET_STATUS) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_CP {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_MODE_CP(struct A7XX_RBBM_CLOCK_MODE_CP fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000260,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_MODE_CP(...) pack_A7XX_RBBM_CLOCK_MODE_CP(__struct_cast(A7XX_RBBM_CLOCK_MODE_CP) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_LRZ {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_MODE_BV_LRZ(struct A7XX_RBBM_CLOCK_MODE_BV_LRZ fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000284,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_MODE_BV_LRZ(...) pack_A7XX_RBBM_CLOCK_MODE_BV_LRZ(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_LRZ) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_GRAS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_MODE_BV_GRAS(struct A7XX_RBBM_CLOCK_MODE_BV_GRAS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000285,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_MODE_BV_GRAS(...) pack_A7XX_RBBM_CLOCK_MODE_BV_GRAS(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_GRAS) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE2_GRAS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_MODE2_GRAS(struct A7XX_RBBM_CLOCK_MODE2_GRAS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000286,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_MODE2_GRAS(...) pack_A7XX_RBBM_CLOCK_MODE2_GRAS(__struct_cast(A7XX_RBBM_CLOCK_MODE2_GRAS) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_VFD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_MODE_BV_VFD(struct A7XX_RBBM_CLOCK_MODE_BV_VFD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000287,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_MODE_BV_VFD(...) pack_A7XX_RBBM_CLOCK_MODE_BV_VFD(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_VFD) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_MODE_BV_GPC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_MODE_BV_GPC(struct A7XX_RBBM_CLOCK_MODE_BV_GPC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000288,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_MODE_BV_GPC(...) pack_A7XX_RBBM_CLOCK_MODE_BV_GPC(__struct_cast(A7XX_RBBM_CLOCK_MODE_BV_GPC) { __VA_ARGS__ })

struct A7XX_RBBM_SW_FUSE_INT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_SW_FUSE_INT_STATUS(struct A7XX_RBBM_SW_FUSE_INT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000002c0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_SW_FUSE_INT_STATUS(...) pack_A7XX_RBBM_SW_FUSE_INT_STATUS(__struct_cast(A7XX_RBBM_SW_FUSE_INT_STATUS) { __VA_ARGS__ })

struct A7XX_RBBM_SW_FUSE_INT_MASK {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_SW_FUSE_INT_MASK(struct A7XX_RBBM_SW_FUSE_INT_MASK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000002c1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_SW_FUSE_INT_MASK(...) pack_A7XX_RBBM_SW_FUSE_INT_MASK(__struct_cast(A7XX_RBBM_SW_FUSE_INT_MASK) { __VA_ARGS__ })

struct A8XX_RBBM_SW_FUSE_INT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SW_FUSE_INT_STATUS(struct A8XX_RBBM_SW_FUSE_INT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000071,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SW_FUSE_INT_STATUS(...) pack_A8XX_RBBM_SW_FUSE_INT_STATUS(__struct_cast(A8XX_RBBM_SW_FUSE_INT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_SW_FUSE_INT_MASK {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SW_FUSE_INT_MASK(struct A8XX_RBBM_SW_FUSE_INT_MASK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000072,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SW_FUSE_INT_MASK(...) pack_A8XX_RBBM_SW_FUSE_INT_MASK(__struct_cast(A8XX_RBBM_SW_FUSE_INT_MASK) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_CP_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_CP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000400 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_CP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_CP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_CP_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RBBM_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_RBBM_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_RBBM_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000041c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_RBBM_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RBBM_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RBBM_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_PC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_PC_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_PC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000424 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_PC_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_PC_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_PC_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_VFD_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_VFD_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_VFD_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000434 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_VFD_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_VFD_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_VFD_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_HLSQ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_HLSQ_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_HLSQ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000444 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_HLSQ_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_HLSQ_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_HLSQ_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_VPC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_VPC_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_VPC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000450 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_VPC_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_VPC_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_VPC_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CCU_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_CCU_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_CCU_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000045c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_CCU_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_CCU_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_CCU_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_TSE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_TSE_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_TSE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000466 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_TSE_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_TSE_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_TSE_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RAS_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_RAS_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_RAS_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000046e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_RAS_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RAS_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RAS_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_UCHE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_UCHE_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_UCHE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000476 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_UCHE_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_UCHE_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_UCHE_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_TP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_TP_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_TP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000048e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_TP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_TP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_TP_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_SP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_SP_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_SP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004a6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_SP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_SP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_SP_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RB_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_RB_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_RB_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004d6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_RB_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RB_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RB_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_VSC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_VSC_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_VSC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004e6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_VSC_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_VSC_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_VSC_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LRZ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_LRZ_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_LRZ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004ea + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_LRZ_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_LRZ_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_LRZ_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CMP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_CMP_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_CMP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000004f2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_CMP_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_CMP_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_CMP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_CP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_CP_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_CP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000300 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_CP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_CP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_CP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_RBBM_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_RBBM_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_RBBM_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000031c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_RBBM_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_RBBM_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_RBBM_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_PC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_PC_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_PC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000324 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_PC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_PC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_PC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_VFD_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_VFD_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_VFD_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000334 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_VFD_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_VFD_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_VFD_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_HLSQ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_HLSQ_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_HLSQ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000344 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_HLSQ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_HLSQ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_HLSQ_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_VPC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_VPC_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_VPC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000350 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_VPC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_VPC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_VPC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_CCU_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_CCU_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_CCU_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000035c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_CCU_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_CCU_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_CCU_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_TSE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_TSE_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_TSE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000366 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_TSE_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_TSE_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_TSE_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_RAS_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_RAS_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_RAS_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000036e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_RAS_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_RAS_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_RAS_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_UCHE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_UCHE_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_UCHE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000376 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_UCHE_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_UCHE_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_UCHE_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_TP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_TP_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_TP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000038e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_TP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_TP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_TP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_SP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_SP_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_SP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003a6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_SP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_SP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_SP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_RB_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_RB_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_RB_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003d6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_RB_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_RB_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_RB_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_VSC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_VSC_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_VSC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003e6 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_VSC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_VSC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_VSC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_LRZ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_LRZ_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_LRZ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003ea + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_LRZ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_LRZ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_LRZ_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_CMP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_CMP_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_CMP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003f2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_CMP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_CMP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_CMP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_UFC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_UFC_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_UFC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000003fa + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_UFC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_UFC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_UFC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_HLSQ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR2_HLSQ_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR2_HLSQ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000410 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR2_HLSQ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_HLSQ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_HLSQ_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_CP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR2_CP_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR2_CP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000041c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR2_CP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_CP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_CP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_SP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR2_SP_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR2_SP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000042a + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR2_SP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_SP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_SP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_TP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR2_TP_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR2_TP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000442 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR2_TP_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_TP_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_TP_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR2_UFC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR2_UFC_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR2_UFC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000044e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR2_UFC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR2_UFC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR2_UFC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_PC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_BV_PC_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_BV_PC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000460 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_BV_PC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_PC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_PC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_VFD_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_BV_VFD_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_BV_VFD_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000470 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_BV_VFD_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_VFD_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_VFD_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_VPC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_BV_VPC_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_BV_VPC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000480 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_BV_VPC_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_VPC_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_VPC_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_TSE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_BV_TSE_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_BV_TSE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000048c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_BV_TSE_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_TSE_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_TSE_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_RAS_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_BV_RAS_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_BV_RAS_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000494 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_BV_RAS_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_RAS_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_RAS_REG) { __VA_ARGS__ })

struct A7XX_RBBM_PERFCTR_BV_LRZ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_PERFCTR_BV_LRZ_REG(uint32_t __i, struct A7XX_RBBM_PERFCTR_BV_LRZ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000049c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_PERFCTR_BV_LRZ_REG(__i, ...) pack_A7XX_RBBM_PERFCTR_BV_LRZ_REG(__i, __struct_cast(A7XX_RBBM_PERFCTR_BV_LRZ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_CP_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_CP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001b0 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_CP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_CP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_CP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RBBM_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_RBBM_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_RBBM_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001cc + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_RBBM_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RBBM_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RBBM_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_PC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_PC_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_PC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001d4 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_PC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_PC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_PC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_VFD_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_VFD_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_VFD_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001e4 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_VFD_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_VFD_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_VFD_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_HLSQ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_HLSQ_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_HLSQ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000001f4 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_HLSQ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_HLSQ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_HLSQ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_VPC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_VPC_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_VPC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000200 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_VPC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_VPC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_VPC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CCU_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_CCU_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_CCU_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000020c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_CCU_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_CCU_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_CCU_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_TSE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_TSE_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_TSE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000216 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_TSE_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_TSE_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_TSE_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RAS_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_RAS_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_RAS_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000021e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_RAS_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RAS_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RAS_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_UCHE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_UCHE_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_UCHE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000226 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_UCHE_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_UCHE_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_UCHE_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_TP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_TP_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_TP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000256 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_TP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_TP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_TP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_SP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_SP_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_SP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000026e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_SP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_SP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_SP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RB_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_RB_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_RB_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000029e + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_RB_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RB_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RB_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_VSC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_VSC_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_VSC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002ae + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_VSC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_VSC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_VSC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_LRZ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_LRZ_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_LRZ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002b2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_LRZ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_LRZ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_LRZ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CMP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_CMP_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_CMP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002ba + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_CMP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_CMP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_CMP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_UFC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_UFC_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_UFC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002c2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_UFC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_UFC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_UFC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_HLSQ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR2_HLSQ_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR2_HLSQ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002e2 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR2_HLSQ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_HLSQ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_HLSQ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_CP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR2_CP_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR2_CP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002ee + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR2_CP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_CP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_CP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_SP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR2_SP_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR2_SP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000002fc + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR2_SP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_SP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_SP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_TP_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR2_TP_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR2_TP_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000314 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR2_TP_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_TP_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_TP_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR2_UFC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR2_UFC_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR2_UFC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000324 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR2_UFC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR2_UFC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR2_UFC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_PC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_PC_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_PC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000328 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_PC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_PC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_PC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_VFD_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_VFD_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_VFD_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000338 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_VFD_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_VFD_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_VFD_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_VPC_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_VPC_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_VPC_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000348 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_VPC_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_VPC_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_VPC_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_TSE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_TSE_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_TSE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000354 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_TSE_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_TSE_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_TSE_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_RAS_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_RAS_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_RAS_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000035c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_RAS_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_RAS_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_RAS_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_LRZ_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_LRZ_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_LRZ_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000364 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_LRZ_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_LRZ_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_LRZ_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_CCU_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_CCU_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_CCU_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000036c + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_CCU_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_CCU_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_CCU_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_BV_RB_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_BV_RB_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_BV_RB_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000372 + 0x2*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_BV_RB_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_BV_RB_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_BV_RB_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_CNTL(struct A6XX_RBBM_PERFCTR_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000500,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_CNTL(...) pack_A6XX_RBBM_PERFCTR_CNTL(__struct_cast(A6XX_RBBM_PERFCTR_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_CNTL(struct A8XX_RBBM_PERFCTR_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000460,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_CNTL(...) pack_A8XX_RBBM_PERFCTR_CNTL(__struct_cast(A8XX_RBBM_PERFCTR_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_LOAD_CMD0(struct A6XX_RBBM_PERFCTR_LOAD_CMD0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000501,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_LOAD_CMD0(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD0(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD0) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_LOAD_CMD1(struct A6XX_RBBM_PERFCTR_LOAD_CMD1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000502,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_LOAD_CMD1(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD1(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD1) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_LOAD_CMD2(struct A6XX_RBBM_PERFCTR_LOAD_CMD2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000503,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_LOAD_CMD2(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD2(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD2) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_CMD3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_LOAD_CMD3(struct A6XX_RBBM_PERFCTR_LOAD_CMD3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000504,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_LOAD_CMD3(...) pack_A6XX_RBBM_PERFCTR_LOAD_CMD3(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_CMD3) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_LOAD_VALUE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_LOAD_VALUE(struct A6XX_RBBM_PERFCTR_LOAD_VALUE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000505,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PERFCTR_LOAD_VALUE(...) pack_A6XX_RBBM_PERFCTR_LOAD_VALUE(__struct_cast(A6XX_RBBM_PERFCTR_LOAD_VALUE) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_RBBM_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_RBBM_SEL_REG(uint32_t __i, struct A6XX_RBBM_PERFCTR_RBBM_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000507 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, ...) pack_A6XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, __struct_cast(A6XX_RBBM_PERFCTR_RBBM_SEL_REG) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_RBBM_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_RBBM_SEL_REG(uint32_t __i, struct A8XX_RBBM_PERFCTR_RBBM_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000441 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, ...) pack_A8XX_RBBM_PERFCTR_RBBM_SEL_REG(__i, __struct_cast(A8XX_RBBM_PERFCTR_RBBM_SEL_REG) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED(struct A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000050b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED(...) pack_A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED(__struct_cast(A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED(struct A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000019e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED(...) pack_A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED(__struct_cast(A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_SRAM_INIT_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_SRAM_INIT_CMD(struct A6XX_RBBM_PERFCTR_SRAM_INIT_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000050e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_SRAM_INIT_CMD(...) pack_A6XX_RBBM_PERFCTR_SRAM_INIT_CMD(__struct_cast(A6XX_RBBM_PERFCTR_SRAM_INIT_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_SRAM_INIT_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_SRAM_INIT_CMD(struct A8XX_RBBM_PERFCTR_SRAM_INIT_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000449,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_SRAM_INIT_CMD(...) pack_A8XX_RBBM_PERFCTR_SRAM_INIT_CMD(__struct_cast(A8XX_RBBM_PERFCTR_SRAM_INIT_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS(struct A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000050f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS(...) pack_A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS(__struct_cast(A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS(struct A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000019f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS(...) pack_A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS(__struct_cast(A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS(struct A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000001a1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS(...) pack_A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS(__struct_cast(A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD(struct A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000044c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD(...) pack_A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD(__struct_cast(A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_ISDB_CNT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_ISDB_CNT(struct A6XX_RBBM_ISDB_CNT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000533,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_ISDB_CNT(...) pack_A6XX_RBBM_ISDB_CNT(__struct_cast(A6XX_RBBM_ISDB_CNT) { __VA_ARGS__ })

struct A8XX_RBBM_ISDB_CNT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_ISDB_CNT(struct A8XX_RBBM_ISDB_CNT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000002d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_ISDB_CNT(...) pack_A8XX_RBBM_ISDB_CNT(__struct_cast(A8XX_RBBM_ISDB_CNT) { __VA_ARGS__ })

struct A6XX_RBBM_NC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_NC_MODE_CNTL(struct A6XX_RBBM_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000534,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_NC_MODE_CNTL(...) pack_A6XX_RBBM_NC_MODE_CNTL(__struct_cast(A6XX_RBBM_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_NC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_NC_MODE_CNTL(struct A8XX_RBBM_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000440,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_NC_MODE_CNTL(...) pack_A8XX_RBBM_NC_MODE_CNTL(__struct_cast(A8XX_RBBM_NC_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RBBM_SNAPSHOT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_SNAPSHOT_STATUS(struct A7XX_RBBM_SNAPSHOT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000535,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_SNAPSHOT_STATUS(...) pack_A7XX_RBBM_SNAPSHOT_STATUS(__struct_cast(A7XX_RBBM_SNAPSHOT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_SNAPSHOT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SNAPSHOT_STATUS(struct A8XX_RBBM_SNAPSHOT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000002e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SNAPSHOT_STATUS(...) pack_A8XX_RBBM_SNAPSHOT_STATUS(__struct_cast(A8XX_RBBM_SNAPSHOT_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SLICE_PERFCTR_CNTL(struct A8XX_RBBM_SLICE_PERFCTR_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000500,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SLICE_PERFCTR_CNTL(...) pack_A8XX_RBBM_SLICE_PERFCTR_CNTL(__struct_cast(A8XX_RBBM_SLICE_PERFCTR_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL(struct A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000058f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL(...) pack_A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL(__struct_cast(A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG(uint32_t __i, struct A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000005e0 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG(__i, ...) pack_A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG(__i, __struct_cast(A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL_REG) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD(struct A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000005e8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD(...) pack_A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD(__struct_cast(A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD(struct A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000005eb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD(...) pack_A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD(__struct_cast(A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_SLICE_NC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SLICE_NC_MODE_CNTL(struct A8XX_RBBM_SLICE_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000005ec,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SLICE_NC_MODE_CNTL(...) pack_A8XX_RBBM_SLICE_NC_MODE_CNTL(__struct_cast(A8XX_RBBM_SLICE_NC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_IAVERTICES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_IAVERTICES(struct A6XX_RBBM_PIPESTAT_IAVERTICES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000540,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_IAVERTICES(...) pack_A6XX_RBBM_PIPESTAT_IAVERTICES(__struct_cast(A6XX_RBBM_PIPESTAT_IAVERTICES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_IAPRIMITIVES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_IAPRIMITIVES(struct A6XX_RBBM_PIPESTAT_IAPRIMITIVES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000542,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_IAPRIMITIVES(...) pack_A6XX_RBBM_PIPESTAT_IAPRIMITIVES(__struct_cast(A6XX_RBBM_PIPESTAT_IAPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_VSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_VSINVOCATIONS(struct A6XX_RBBM_PIPESTAT_VSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000544,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_VSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_VSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_VSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_HSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_HSINVOCATIONS(struct A6XX_RBBM_PIPESTAT_HSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000546,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_HSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_HSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_HSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_DSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_DSINVOCATIONS(struct A6XX_RBBM_PIPESTAT_DSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000548,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_DSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_DSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_DSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_GSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_GSINVOCATIONS(struct A6XX_RBBM_PIPESTAT_GSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000054a,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_GSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_GSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_GSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_GSPRIMITIVES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_GSPRIMITIVES(struct A6XX_RBBM_PIPESTAT_GSPRIMITIVES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000054c,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_GSPRIMITIVES(...) pack_A6XX_RBBM_PIPESTAT_GSPRIMITIVES(__struct_cast(A6XX_RBBM_PIPESTAT_GSPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_CINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_CINVOCATIONS(struct A6XX_RBBM_PIPESTAT_CINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000054e,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_CINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_CINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_CINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_CPRIMITIVES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_CPRIMITIVES(struct A6XX_RBBM_PIPESTAT_CPRIMITIVES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000550,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_CPRIMITIVES(...) pack_A6XX_RBBM_PIPESTAT_CPRIMITIVES(__struct_cast(A6XX_RBBM_PIPESTAT_CPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_PSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_PSINVOCATIONS(struct A6XX_RBBM_PIPESTAT_PSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000552,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_PSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_PSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_PSINVOCATIONS) { __VA_ARGS__ })

struct A6XX_RBBM_PIPESTAT_CSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_PIPESTAT_CSINVOCATIONS(struct A6XX_RBBM_PIPESTAT_CSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000554,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_PIPESTAT_CSINVOCATIONS(...) pack_A6XX_RBBM_PIPESTAT_CSINVOCATIONS(__struct_cast(A6XX_RBBM_PIPESTAT_CSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_IAVERTICES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_IAVERTICES(struct A8XX_RBBM_PIPESTAT_IAVERTICES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000380,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_IAVERTICES(...) pack_A8XX_RBBM_PIPESTAT_IAVERTICES(__struct_cast(A8XX_RBBM_PIPESTAT_IAVERTICES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_IAPRIMITIVES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_IAPRIMITIVES(struct A8XX_RBBM_PIPESTAT_IAPRIMITIVES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000382,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_IAPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_IAPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_IAPRIMITIVES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_VSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_VSINVOCATIONS(struct A8XX_RBBM_PIPESTAT_VSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000384,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_VSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_VSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_VSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_GSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_GSINVOCATIONS(struct A8XX_RBBM_PIPESTAT_GSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000386,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_GSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_GSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_GSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_GSPRIMITIVES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_GSPRIMITIVES(struct A8XX_RBBM_PIPESTAT_GSPRIMITIVES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000388,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_GSPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_GSPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_GSPRIMITIVES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_CINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_CINVOCATIONS(struct A8XX_RBBM_PIPESTAT_CINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000038a,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_CINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_CINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_CINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_CPRIMITIVES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_CPRIMITIVES(struct A8XX_RBBM_PIPESTAT_CPRIMITIVES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000038c,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_CPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_CPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_CPRIMITIVES) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_PSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_PSINVOCATIONS(struct A8XX_RBBM_PIPESTAT_PSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000038e,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_PSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_PSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_PSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_HSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_HSINVOCATIONS(struct A8XX_RBBM_PIPESTAT_HSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000390,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_HSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_HSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_HSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_DSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_DSINVOCATIONS(struct A8XX_RBBM_PIPESTAT_DSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000392,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_DSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_DSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_DSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_CSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_CSINVOCATIONS(struct A8XX_RBBM_PIPESTAT_CSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000394,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_CSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_CSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_CSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_ASINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_ASINVOCATIONS(struct A8XX_RBBM_PIPESTAT_ASINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000396,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_ASINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_ASINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_ASINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_MSINVOCATIONS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_MSINVOCATIONS(struct A8XX_RBBM_PIPESTAT_MSINVOCATIONS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000398,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_MSINVOCATIONS(...) pack_A8XX_RBBM_PIPESTAT_MSINVOCATIONS(__struct_cast(A8XX_RBBM_PIPESTAT_MSINVOCATIONS) { __VA_ARGS__ })

struct A8XX_RBBM_PIPESTAT_MSPRIMITIVES {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_PIPESTAT_MSPRIMITIVES(struct A8XX_RBBM_PIPESTAT_MSPRIMITIVES fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000039a,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_RBBM_PIPESTAT_MSPRIMITIVES(...) pack_A8XX_RBBM_PIPESTAT_MSPRIMITIVES(__struct_cast(A8XX_RBBM_PIPESTAT_MSPRIMITIVES) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TRUST_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TRUST_CNTL(struct A6XX_RBBM_SECVID_TRUST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f400,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SECVID_TRUST_CNTL(...) pack_A6XX_RBBM_SECVID_TRUST_CNTL(__struct_cast(A6XX_RBBM_SECVID_TRUST_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_TRUSTED_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TSB_TRUSTED_BASE(struct A6XX_RBBM_SECVID_TSB_TRUSTED_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f800,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_RBBM_SECVID_TSB_TRUSTED_BASE(...) pack_A6XX_RBBM_SECVID_TSB_TRUSTED_BASE(__struct_cast(A6XX_RBBM_SECVID_TSB_TRUSTED_BASE) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE(struct A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f802,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE(...) pack_A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE(__struct_cast(A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TSB_CNTL(struct A6XX_RBBM_SECVID_TSB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f803,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SECVID_TSB_CNTL(...) pack_A6XX_RBBM_SECVID_TSB_CNTL(__struct_cast(A6XX_RBBM_SECVID_TSB_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL {
    enum a5xx_address_mode					rbbm_secvid_tsb_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL(struct A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.rbbm_secvid_tsb_addr_mode_cntl    & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000f810,
        .value =
            (fields.rbbm_secvid_tsb_addr_mode_cntl    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL(...) pack_A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL(__struct_cast(A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RBBM_SECVID_TSB_STATUS {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_SECVID_TSB_STATUS(struct A7XX_RBBM_SECVID_TSB_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000fc00,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A7XX_RBBM_SECVID_TSB_STATUS(...) pack_A7XX_RBBM_SECVID_TSB_STATUS(__struct_cast(A7XX_RBBM_SECVID_TSB_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_VBIF_CLIENT_QOS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_VBIF_CLIENT_QOS_CNTL(struct A6XX_RBBM_VBIF_CLIENT_QOS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000010,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_VBIF_CLIENT_QOS_CNTL(...) pack_A6XX_RBBM_VBIF_CLIENT_QOS_CNTL(__struct_cast(A6XX_RBBM_VBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_GBIF_CLIENT_QOS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_GBIF_CLIENT_QOS_CNTL(struct A6XX_RBBM_GBIF_CLIENT_QOS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000011,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_GBIF_CLIENT_QOS_CNTL(...) pack_A6XX_RBBM_GBIF_CLIENT_QOS_CNTL(__struct_cast(A6XX_RBBM_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_GBIF_CLIENT_QOS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_GBIF_CLIENT_QOS_CNTL(struct A8XX_RBBM_GBIF_CLIENT_QOS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000008,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_GBIF_CLIENT_QOS_CNTL(...) pack_A8XX_RBBM_GBIF_CLIENT_QOS_CNTL(__struct_cast(A8XX_RBBM_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_GBIF_HALT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_GBIF_HALT(struct A6XX_RBBM_GBIF_HALT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000016,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_GBIF_HALT(...) pack_A6XX_RBBM_GBIF_HALT(__struct_cast(A6XX_RBBM_GBIF_HALT) { __VA_ARGS__ })

struct A8XX_RBBM_GBIF_HALT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_GBIF_HALT(struct A8XX_RBBM_GBIF_HALT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_GBIF_HALT(...) pack_A8XX_RBBM_GBIF_HALT(__struct_cast(A8XX_RBBM_GBIF_HALT) { __VA_ARGS__ })

struct A6XX_RBBM_GBIF_HALT_ACK {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_GBIF_HALT_ACK(struct A6XX_RBBM_GBIF_HALT_ACK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000017,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_GBIF_HALT_ACK(...) pack_A6XX_RBBM_GBIF_HALT_ACK(__struct_cast(A6XX_RBBM_GBIF_HALT_ACK) { __VA_ARGS__ })

struct A8XX_RBBM_GBIF_HALT_ACK {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_GBIF_HALT_ACK(struct A8XX_RBBM_GBIF_HALT_ACK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000000b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_GBIF_HALT_ACK(...) pack_A8XX_RBBM_GBIF_HALT_ACK(__struct_cast(A8XX_RBBM_GBIF_HALT_ACK) { __VA_ARGS__ })

struct A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD {
    bool							wait_gpu_idle;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD(struct A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001c,
        .value =
            (fields.wait_gpu_idle                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD(...) pack_A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD(__struct_cast(A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(struct A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(...) pack_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(struct A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(...) pack_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(__struct_cast(A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2) { __VA_ARGS__ })

struct A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(struct A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000010,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(...) pack_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(struct A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000011,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(...) pack_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2(__struct_cast(A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2) { __VA_ARGS__ })

struct A6XX_RBBM_INTERFACE_HANG_INT_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_INTERFACE_HANG_INT_CNTL(struct A6XX_RBBM_INTERFACE_HANG_INT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000001f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_INTERFACE_HANG_INT_CNTL(...) pack_A6XX_RBBM_INTERFACE_HANG_INT_CNTL(__struct_cast(A6XX_RBBM_INTERFACE_HANG_INT_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_INTERFACE_HANG_INT_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_INTERFACE_HANG_INT_CNTL(struct A8XX_RBBM_INTERFACE_HANG_INT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000002f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_INTERFACE_HANG_INT_CNTL(...) pack_A8XX_RBBM_INTERFACE_HANG_INT_CNTL(__struct_cast(A8XX_RBBM_INTERFACE_HANG_INT_CNTL) { __VA_ARGS__ })

struct A7XX_RBBM_INT_2_MASK {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_INT_2_MASK(struct A7XX_RBBM_INT_2_MASK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000003a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_INT_2_MASK(...) pack_A7XX_RBBM_INT_2_MASK(__struct_cast(A7XX_RBBM_INT_2_MASK) { __VA_ARGS__ })

struct A8XX_RBBM_INT_2_MASK {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_INT_2_MASK(struct A8XX_RBBM_INT_2_MASK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000064,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_INT_2_MASK(...) pack_A8XX_RBBM_INT_2_MASK(__struct_cast(A8XX_RBBM_INT_2_MASK) { __VA_ARGS__ })

struct A6XX_RBBM_SP_HYST_CNT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_SP_HYST_CNT(struct A6XX_RBBM_SP_HYST_CNT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000042,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SP_HYST_CNT(...) pack_A6XX_RBBM_SP_HYST_CNT(__struct_cast(A6XX_RBBM_SP_HYST_CNT) { __VA_ARGS__ })

struct A6XX_RBBM_SW_RESET_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_SW_RESET_CMD(struct A6XX_RBBM_SW_RESET_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000043,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_SW_RESET_CMD(...) pack_A6XX_RBBM_SW_RESET_CMD(__struct_cast(A6XX_RBBM_SW_RESET_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_SW_RESET_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_SW_RESET_CMD(struct A8XX_RBBM_SW_RESET_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000073,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_SW_RESET_CMD(...) pack_A8XX_RBBM_SW_RESET_CMD(__struct_cast(A8XX_RBBM_SW_RESET_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_RAC_THRESHOLD_CNT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_RAC_THRESHOLD_CNT(struct A6XX_RBBM_RAC_THRESHOLD_CNT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000044,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_RAC_THRESHOLD_CNT(...) pack_A6XX_RBBM_RAC_THRESHOLD_CNT(__struct_cast(A6XX_RBBM_RAC_THRESHOLD_CNT) { __VA_ARGS__ })

struct A8XX_RBBM_RAC_THRESHOLD_CNT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_RAC_THRESHOLD_CNT(struct A8XX_RBBM_RAC_THRESHOLD_CNT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000029,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_RAC_THRESHOLD_CNT(...) pack_A8XX_RBBM_RAC_THRESHOLD_CNT(__struct_cast(A8XX_RBBM_RAC_THRESHOLD_CNT) { __VA_ARGS__ })

struct A6XX_RBBM_BLOCK_SW_RESET_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_BLOCK_SW_RESET_CMD(struct A6XX_RBBM_BLOCK_SW_RESET_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000045,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_BLOCK_SW_RESET_CMD(...) pack_A6XX_RBBM_BLOCK_SW_RESET_CMD(__struct_cast(A6XX_RBBM_BLOCK_SW_RESET_CMD) { __VA_ARGS__ })

struct A6XX_RBBM_BLOCK_SW_RESET_CMD2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_BLOCK_SW_RESET_CMD2(struct A6XX_RBBM_BLOCK_SW_RESET_CMD2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000046,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_BLOCK_SW_RESET_CMD2(...) pack_A6XX_RBBM_BLOCK_SW_RESET_CMD2(__struct_cast(A6XX_RBBM_BLOCK_SW_RESET_CMD2) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_CNTL_GLOBAL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_CNTL_GLOBAL(struct A7XX_RBBM_CLOCK_CNTL_GLOBAL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ad,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_CNTL_GLOBAL(...) pack_A7XX_RBBM_CLOCK_CNTL_GLOBAL(__struct_cast(A7XX_RBBM_CLOCK_CNTL_GLOBAL) { __VA_ARGS__ })

struct A8XX_RBBM_CLOCK_CNTL_GLOBAL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_CLOCK_CNTL_GLOBAL(struct A8XX_RBBM_CLOCK_CNTL_GLOBAL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000009a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_CLOCK_CNTL_GLOBAL(...) pack_A8XX_RBBM_CLOCK_CNTL_GLOBAL(__struct_cast(A8XX_RBBM_CLOCK_CNTL_GLOBAL) { __VA_ARGS__ })

struct A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE(struct A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000007d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE(...) pack_A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE(__struct_cast(A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE) { __VA_ARGS__ })

struct A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE(struct A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000007e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE(...) pack_A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE(__struct_cast(A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL(struct A6XX_RBBM_CLOCK_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ae,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL(...) pack_A6XX_RBBM_CLOCK_CNTL(__struct_cast(A6XX_RBBM_CLOCK_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_SP0(struct A6XX_RBBM_CLOCK_CNTL_SP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_SP0(...) pack_A6XX_RBBM_CLOCK_CNTL_SP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_SP1(struct A6XX_RBBM_CLOCK_CNTL_SP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_SP1(...) pack_A6XX_RBBM_CLOCK_CNTL_SP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_SP2(struct A6XX_RBBM_CLOCK_CNTL_SP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_SP2(...) pack_A6XX_RBBM_CLOCK_CNTL_SP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_SP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_SP3(struct A6XX_RBBM_CLOCK_CNTL_SP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_SP3(...) pack_A6XX_RBBM_CLOCK_CNTL_SP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_SP0(struct A6XX_RBBM_CLOCK_CNTL2_SP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_SP0(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_SP1(struct A6XX_RBBM_CLOCK_CNTL2_SP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_SP1(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_SP2(struct A6XX_RBBM_CLOCK_CNTL2_SP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_SP2(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_SP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_SP3(struct A6XX_RBBM_CLOCK_CNTL2_SP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_SP3(...) pack_A6XX_RBBM_CLOCK_CNTL2_SP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_SP0(struct A6XX_RBBM_CLOCK_DELAY_SP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_SP0(...) pack_A6XX_RBBM_CLOCK_DELAY_SP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_SP1(struct A6XX_RBBM_CLOCK_DELAY_SP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000b9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_SP1(...) pack_A6XX_RBBM_CLOCK_DELAY_SP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_SP2(struct A6XX_RBBM_CLOCK_DELAY_SP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ba,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_SP2(...) pack_A6XX_RBBM_CLOCK_DELAY_SP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_SP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_SP3(struct A6XX_RBBM_CLOCK_DELAY_SP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000bb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_SP3(...) pack_A6XX_RBBM_CLOCK_DELAY_SP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_SP0(struct A6XX_RBBM_CLOCK_HYST_SP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000bc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_SP0(...) pack_A6XX_RBBM_CLOCK_HYST_SP0(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_SP1(struct A6XX_RBBM_CLOCK_HYST_SP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000bd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_SP1(...) pack_A6XX_RBBM_CLOCK_HYST_SP1(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_SP2(struct A6XX_RBBM_CLOCK_HYST_SP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000be,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_SP2(...) pack_A6XX_RBBM_CLOCK_HYST_SP2(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_SP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_SP3(struct A6XX_RBBM_CLOCK_HYST_SP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000bf,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_SP3(...) pack_A6XX_RBBM_CLOCK_HYST_SP3(__struct_cast(A6XX_RBBM_CLOCK_HYST_SP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_TP0(struct A6XX_RBBM_CLOCK_CNTL_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_TP1(struct A6XX_RBBM_CLOCK_CNTL_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_TP2(struct A6XX_RBBM_CLOCK_CNTL_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_TP3(struct A6XX_RBBM_CLOCK_CNTL_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_TP0(struct A6XX_RBBM_CLOCK_CNTL2_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_TP1(struct A6XX_RBBM_CLOCK_CNTL2_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_TP2(struct A6XX_RBBM_CLOCK_CNTL2_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_TP3(struct A6XX_RBBM_CLOCK_CNTL2_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL2_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL3_TP0(struct A6XX_RBBM_CLOCK_CNTL3_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL3_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL3_TP1(struct A6XX_RBBM_CLOCK_CNTL3_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000c9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL3_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL3_TP2(struct A6XX_RBBM_CLOCK_CNTL3_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ca,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL3_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL3_TP3(struct A6XX_RBBM_CLOCK_CNTL3_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000cb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL3_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL3_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL4_TP0(struct A6XX_RBBM_CLOCK_CNTL4_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000cc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL4_TP0(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP0(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL4_TP1(struct A6XX_RBBM_CLOCK_CNTL4_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000cd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL4_TP1(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP1(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL4_TP2(struct A6XX_RBBM_CLOCK_CNTL4_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ce,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL4_TP2(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP2(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL4_TP3(struct A6XX_RBBM_CLOCK_CNTL4_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000cf,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL4_TP3(...) pack_A6XX_RBBM_CLOCK_CNTL4_TP3(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_TP0(struct A6XX_RBBM_CLOCK_DELAY_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_TP1(struct A6XX_RBBM_CLOCK_DELAY_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_TP2(struct A6XX_RBBM_CLOCK_DELAY_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_TP3(struct A6XX_RBBM_CLOCK_DELAY_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY2_TP0(struct A6XX_RBBM_CLOCK_DELAY2_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY2_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY2_TP1(struct A6XX_RBBM_CLOCK_DELAY2_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY2_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY2_TP2(struct A6XX_RBBM_CLOCK_DELAY2_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY2_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY2_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY2_TP3(struct A6XX_RBBM_CLOCK_DELAY2_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY2_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY2_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY2_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY3_TP0(struct A6XX_RBBM_CLOCK_DELAY3_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY3_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY3_TP1(struct A6XX_RBBM_CLOCK_DELAY3_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000d9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY3_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY3_TP2(struct A6XX_RBBM_CLOCK_DELAY3_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000da,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY3_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY3_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY3_TP3(struct A6XX_RBBM_CLOCK_DELAY3_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000db,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY3_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY3_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY3_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY4_TP0(struct A6XX_RBBM_CLOCK_DELAY4_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000dc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY4_TP0(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP0(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY4_TP1(struct A6XX_RBBM_CLOCK_DELAY4_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000dd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY4_TP1(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP1(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY4_TP2(struct A6XX_RBBM_CLOCK_DELAY4_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000de,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY4_TP2(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP2(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY4_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY4_TP3(struct A6XX_RBBM_CLOCK_DELAY4_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000df,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY4_TP3(...) pack_A6XX_RBBM_CLOCK_DELAY4_TP3(__struct_cast(A6XX_RBBM_CLOCK_DELAY4_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_TP0(struct A6XX_RBBM_CLOCK_HYST_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_TP0(...) pack_A6XX_RBBM_CLOCK_HYST_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_TP1(struct A6XX_RBBM_CLOCK_HYST_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_TP1(...) pack_A6XX_RBBM_CLOCK_HYST_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_TP2(struct A6XX_RBBM_CLOCK_HYST_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_TP2(...) pack_A6XX_RBBM_CLOCK_HYST_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_TP3(struct A6XX_RBBM_CLOCK_HYST_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_TP3(...) pack_A6XX_RBBM_CLOCK_HYST_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST2_TP0(struct A6XX_RBBM_CLOCK_HYST2_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST2_TP0(...) pack_A6XX_RBBM_CLOCK_HYST2_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST2_TP1(struct A6XX_RBBM_CLOCK_HYST2_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST2_TP1(...) pack_A6XX_RBBM_CLOCK_HYST2_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST2_TP2(struct A6XX_RBBM_CLOCK_HYST2_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST2_TP2(...) pack_A6XX_RBBM_CLOCK_HYST2_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST2_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST2_TP3(struct A6XX_RBBM_CLOCK_HYST2_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST2_TP3(...) pack_A6XX_RBBM_CLOCK_HYST2_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST2_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST3_TP0(struct A6XX_RBBM_CLOCK_HYST3_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST3_TP0(...) pack_A6XX_RBBM_CLOCK_HYST3_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST3_TP1(struct A6XX_RBBM_CLOCK_HYST3_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000e9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST3_TP1(...) pack_A6XX_RBBM_CLOCK_HYST3_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST3_TP2(struct A6XX_RBBM_CLOCK_HYST3_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ea,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST3_TP2(...) pack_A6XX_RBBM_CLOCK_HYST3_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST3_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST3_TP3(struct A6XX_RBBM_CLOCK_HYST3_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000eb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST3_TP3(...) pack_A6XX_RBBM_CLOCK_HYST3_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST3_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST4_TP0(struct A6XX_RBBM_CLOCK_HYST4_TP0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ec,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST4_TP0(...) pack_A6XX_RBBM_CLOCK_HYST4_TP0(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST4_TP1(struct A6XX_RBBM_CLOCK_HYST4_TP1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ed,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST4_TP1(...) pack_A6XX_RBBM_CLOCK_HYST4_TP1(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST4_TP2(struct A6XX_RBBM_CLOCK_HYST4_TP2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ee,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST4_TP2(...) pack_A6XX_RBBM_CLOCK_HYST4_TP2(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST4_TP3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST4_TP3(struct A6XX_RBBM_CLOCK_HYST4_TP3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000ef,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST4_TP3(...) pack_A6XX_RBBM_CLOCK_HYST4_TP3(__struct_cast(A6XX_RBBM_CLOCK_HYST4_TP3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_RB0(struct A6XX_RBBM_CLOCK_CNTL_RB0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_RB0(...) pack_A6XX_RBBM_CLOCK_CNTL_RB0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_RB1(struct A6XX_RBBM_CLOCK_CNTL_RB1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_RB1(...) pack_A6XX_RBBM_CLOCK_CNTL_RB1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_RB2(struct A6XX_RBBM_CLOCK_CNTL_RB2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_RB2(...) pack_A6XX_RBBM_CLOCK_CNTL_RB2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RB3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_RB3(struct A6XX_RBBM_CLOCK_CNTL_RB3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_RB3(...) pack_A6XX_RBBM_CLOCK_CNTL_RB3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RB3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_RB0(struct A6XX_RBBM_CLOCK_CNTL2_RB0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_RB0(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB0(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_RB1(struct A6XX_RBBM_CLOCK_CNTL2_RB1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_RB1(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB1(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_RB2(struct A6XX_RBBM_CLOCK_CNTL2_RB2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_RB2(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB2(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RB3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_RB3(struct A6XX_RBBM_CLOCK_CNTL2_RB3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_RB3(...) pack_A6XX_RBBM_CLOCK_CNTL2_RB3(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RB3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_CCU0(struct A6XX_RBBM_CLOCK_CNTL_CCU0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_CCU0(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU0(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_CCU1(struct A6XX_RBBM_CLOCK_CNTL_CCU1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000f9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_CCU1(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU1(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_CCU2(struct A6XX_RBBM_CLOCK_CNTL_CCU2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000fa,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_CCU2(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU2(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_CCU3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_CCU3(struct A6XX_RBBM_CLOCK_CNTL_CCU3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000000fb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_CCU3(...) pack_A6XX_RBBM_CLOCK_CNTL_CCU3(__struct_cast(A6XX_RBBM_CLOCK_CNTL_CCU3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_RB_CCU0(struct A6XX_RBBM_CLOCK_HYST_RB_CCU0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000100,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_RB_CCU0(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU0(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU0) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_RB_CCU1(struct A6XX_RBBM_CLOCK_HYST_RB_CCU1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000101,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_RB_CCU1(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU1(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU1) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_RB_CCU2(struct A6XX_RBBM_CLOCK_HYST_RB_CCU2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000102,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_RB_CCU2(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU2(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RB_CCU3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_RB_CCU3(struct A6XX_RBBM_CLOCK_HYST_RB_CCU3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000103,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_RB_CCU3(...) pack_A6XX_RBBM_CLOCK_HYST_RB_CCU3(__struct_cast(A6XX_RBBM_CLOCK_HYST_RB_CCU3) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_RAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_RAC(struct A6XX_RBBM_CLOCK_CNTL_RAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000104,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_RAC(...) pack_A6XX_RBBM_CLOCK_CNTL_RAC(__struct_cast(A6XX_RBBM_CLOCK_CNTL_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_RAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_RAC(struct A6XX_RBBM_CLOCK_CNTL2_RAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000105,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_RAC(...) pack_A6XX_RBBM_CLOCK_CNTL2_RAC(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_RAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_RAC(struct A6XX_RBBM_CLOCK_DELAY_RAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000106,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_RAC(...) pack_A6XX_RBBM_CLOCK_DELAY_RAC(__struct_cast(A6XX_RBBM_CLOCK_DELAY_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_RAC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_RAC(struct A6XX_RBBM_CLOCK_HYST_RAC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000107,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_RAC(...) pack_A6XX_RBBM_CLOCK_HYST_RAC(__struct_cast(A6XX_RBBM_CLOCK_HYST_RAC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM(struct A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000108,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM(...) pack_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM(struct A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000109,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM(...) pack_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM(struct A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000010a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM(...) pack_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM(__struct_cast(A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_UCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_UCHE(struct A6XX_RBBM_CLOCK_CNTL_UCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000010b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL2_UCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL2_UCHE(struct A6XX_RBBM_CLOCK_CNTL2_UCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000010c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL2_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL2_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL2_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL3_UCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL3_UCHE(struct A6XX_RBBM_CLOCK_CNTL3_UCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000010d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL3_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL3_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL3_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL4_UCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL4_UCHE(struct A6XX_RBBM_CLOCK_CNTL4_UCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000010e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL4_UCHE(...) pack_A6XX_RBBM_CLOCK_CNTL4_UCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL4_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_UCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_UCHE(struct A6XX_RBBM_CLOCK_DELAY_UCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000010f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_UCHE(...) pack_A6XX_RBBM_CLOCK_DELAY_UCHE(__struct_cast(A6XX_RBBM_CLOCK_DELAY_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_UCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_UCHE(struct A6XX_RBBM_CLOCK_HYST_UCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000110,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_UCHE(...) pack_A6XX_RBBM_CLOCK_HYST_UCHE(__struct_cast(A6XX_RBBM_CLOCK_HYST_UCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_MODE_VFD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_MODE_VFD(struct A6XX_RBBM_CLOCK_MODE_VFD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000111,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_MODE_VFD(...) pack_A6XX_RBBM_CLOCK_MODE_VFD(__struct_cast(A6XX_RBBM_CLOCK_MODE_VFD) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_VFD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_VFD(struct A6XX_RBBM_CLOCK_DELAY_VFD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000112,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_VFD(...) pack_A6XX_RBBM_CLOCK_DELAY_VFD(__struct_cast(A6XX_RBBM_CLOCK_DELAY_VFD) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_VFD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_VFD(struct A6XX_RBBM_CLOCK_HYST_VFD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000113,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_VFD(...) pack_A6XX_RBBM_CLOCK_HYST_VFD(__struct_cast(A6XX_RBBM_CLOCK_HYST_VFD) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_MODE_GPC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_MODE_GPC(struct A6XX_RBBM_CLOCK_MODE_GPC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000114,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_MODE_GPC(...) pack_A6XX_RBBM_CLOCK_MODE_GPC(__struct_cast(A6XX_RBBM_CLOCK_MODE_GPC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_GPC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_GPC(struct A6XX_RBBM_CLOCK_DELAY_GPC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000115,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_GPC(...) pack_A6XX_RBBM_CLOCK_DELAY_GPC(__struct_cast(A6XX_RBBM_CLOCK_DELAY_GPC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_GPC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_GPC(struct A6XX_RBBM_CLOCK_HYST_GPC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000116,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_GPC(...) pack_A6XX_RBBM_CLOCK_HYST_GPC(__struct_cast(A6XX_RBBM_CLOCK_HYST_GPC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_HLSQ_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_HLSQ_2(struct A6XX_RBBM_CLOCK_DELAY_HLSQ_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000117,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_HLSQ_2(...) pack_A6XX_RBBM_CLOCK_DELAY_HLSQ_2(__struct_cast(A6XX_RBBM_CLOCK_DELAY_HLSQ_2) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_GMU_GX {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_GMU_GX(struct A6XX_RBBM_CLOCK_CNTL_GMU_GX fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000118,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_GMU_GX(...) pack_A6XX_RBBM_CLOCK_CNTL_GMU_GX(__struct_cast(A6XX_RBBM_CLOCK_CNTL_GMU_GX) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_GMU_GX {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_GMU_GX(struct A6XX_RBBM_CLOCK_DELAY_GMU_GX fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000119,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_GMU_GX(...) pack_A6XX_RBBM_CLOCK_DELAY_GMU_GX(__struct_cast(A6XX_RBBM_CLOCK_DELAY_GMU_GX) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_GMU_GX {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_GMU_GX(struct A6XX_RBBM_CLOCK_HYST_GMU_GX fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000011a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_GMU_GX(...) pack_A6XX_RBBM_CLOCK_HYST_GMU_GX(__struct_cast(A6XX_RBBM_CLOCK_HYST_GMU_GX) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_MODE_HLSQ {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_MODE_HLSQ(struct A6XX_RBBM_CLOCK_MODE_HLSQ fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000011b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_MODE_HLSQ(...) pack_A6XX_RBBM_CLOCK_MODE_HLSQ(__struct_cast(A6XX_RBBM_CLOCK_MODE_HLSQ) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_HLSQ {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_HLSQ(struct A6XX_RBBM_CLOCK_DELAY_HLSQ fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000011c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_HLSQ(...) pack_A6XX_RBBM_CLOCK_DELAY_HLSQ(__struct_cast(A6XX_RBBM_CLOCK_DELAY_HLSQ) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_HLSQ {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_HLSQ(struct A6XX_RBBM_CLOCK_HYST_HLSQ fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000011d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_HLSQ(...) pack_A6XX_RBBM_CLOCK_HYST_HLSQ(__struct_cast(A6XX_RBBM_CLOCK_HYST_HLSQ) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_GLOBAL_LOAD_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CGC_GLOBAL_LOAD_CMD(struct A7XX_RBBM_CGC_GLOBAL_LOAD_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000011e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CGC_GLOBAL_LOAD_CMD(...) pack_A7XX_RBBM_CGC_GLOBAL_LOAD_CMD(__struct_cast(A7XX_RBBM_CGC_GLOBAL_LOAD_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_GLOBAL_LOAD_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_CGC_GLOBAL_LOAD_CMD(struct A8XX_RBBM_CGC_GLOBAL_LOAD_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000009b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_CGC_GLOBAL_LOAD_CMD(...) pack_A8XX_RBBM_CGC_GLOBAL_LOAD_CMD(__struct_cast(A8XX_RBBM_CGC_GLOBAL_LOAD_CMD) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_P2S_TRIG_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CGC_P2S_TRIG_CMD(struct A7XX_RBBM_CGC_P2S_TRIG_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000011f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CGC_P2S_TRIG_CMD(...) pack_A7XX_RBBM_CGC_P2S_TRIG_CMD(__struct_cast(A7XX_RBBM_CGC_P2S_TRIG_CMD) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_P2S_TRIG_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_CGC_P2S_TRIG_CMD(struct A8XX_RBBM_CGC_P2S_TRIG_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000009c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_CGC_P2S_TRIG_CMD(...) pack_A8XX_RBBM_CGC_P2S_TRIG_CMD(__struct_cast(A8XX_RBBM_CGC_P2S_TRIG_CMD) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_P2S_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CGC_P2S_CNTL(struct A7XX_RBBM_CGC_P2S_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000120,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CGC_P2S_CNTL(...) pack_A7XX_RBBM_CGC_P2S_CNTL(__struct_cast(A7XX_RBBM_CGC_P2S_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_P2S_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_CGC_P2S_CNTL(struct A8XX_RBBM_CGC_P2S_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000009d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_CGC_P2S_CNTL(...) pack_A8XX_RBBM_CGC_P2S_CNTL(__struct_cast(A8XX_RBBM_CGC_P2S_CNTL) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_TEX_FCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE(struct A6XX_RBBM_CLOCK_CNTL_TEX_FCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000120,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_TEX_FCHE(...) pack_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL_TEX_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_TEX_FCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE(struct A6XX_RBBM_CLOCK_DELAY_TEX_FCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000121,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_TEX_FCHE(...) pack_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE(__struct_cast(A6XX_RBBM_CLOCK_DELAY_TEX_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_TEX_FCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_TEX_FCHE(struct A6XX_RBBM_CLOCK_HYST_TEX_FCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000122,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_TEX_FCHE(...) pack_A6XX_RBBM_CLOCK_HYST_TEX_FCHE(__struct_cast(A6XX_RBBM_CLOCK_HYST_TEX_FCHE) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_P2S_STATUS {
    bool							txdone;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CGC_P2S_STATUS(struct A7XX_RBBM_CGC_P2S_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000122,
        .value =
            (fields.txdone                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CGC_P2S_STATUS(...) pack_A7XX_RBBM_CGC_P2S_STATUS(__struct_cast(A7XX_RBBM_CGC_P2S_STATUS) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_P2S_STATUS {
    bool							txdone;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_CGC_P2S_STATUS(struct A8XX_RBBM_CGC_P2S_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000009f,
        .value =
            (fields.txdone                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_CGC_P2S_STATUS(...) pack_A8XX_RBBM_CGC_P2S_STATUS(__struct_cast(A8XX_RBBM_CGC_P2S_STATUS) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_FCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_FCHE(struct A6XX_RBBM_CLOCK_CNTL_FCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000123,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_FCHE(...) pack_A6XX_RBBM_CLOCK_CNTL_FCHE(__struct_cast(A6XX_RBBM_CLOCK_CNTL_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_FCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_FCHE(struct A6XX_RBBM_CLOCK_DELAY_FCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000124,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_FCHE(...) pack_A6XX_RBBM_CLOCK_DELAY_FCHE(__struct_cast(A6XX_RBBM_CLOCK_DELAY_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_FCHE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_FCHE(struct A6XX_RBBM_CLOCK_HYST_FCHE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000125,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_FCHE(...) pack_A6XX_RBBM_CLOCK_HYST_FCHE(__struct_cast(A6XX_RBBM_CLOCK_HYST_FCHE) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_MHUB {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_MHUB(struct A6XX_RBBM_CLOCK_CNTL_MHUB fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000126,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_MHUB(...) pack_A6XX_RBBM_CLOCK_CNTL_MHUB(__struct_cast(A6XX_RBBM_CLOCK_CNTL_MHUB) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_MHUB {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_MHUB(struct A6XX_RBBM_CLOCK_DELAY_MHUB fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000127,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_MHUB(...) pack_A6XX_RBBM_CLOCK_DELAY_MHUB(__struct_cast(A6XX_RBBM_CLOCK_DELAY_MHUB) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_MHUB {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_MHUB(struct A6XX_RBBM_CLOCK_HYST_MHUB fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000128,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_MHUB(...) pack_A6XX_RBBM_CLOCK_HYST_MHUB(__struct_cast(A6XX_RBBM_CLOCK_HYST_MHUB) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_DELAY_GLC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_DELAY_GLC(struct A6XX_RBBM_CLOCK_DELAY_GLC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000129,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_DELAY_GLC(...) pack_A6XX_RBBM_CLOCK_DELAY_GLC(__struct_cast(A6XX_RBBM_CLOCK_DELAY_GLC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_HYST_GLC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_HYST_GLC(struct A6XX_RBBM_CLOCK_HYST_GLC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000012a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_HYST_GLC(...) pack_A6XX_RBBM_CLOCK_HYST_GLC(__struct_cast(A6XX_RBBM_CLOCK_HYST_GLC) { __VA_ARGS__ })

struct A6XX_RBBM_CLOCK_CNTL_GLC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_CLOCK_CNTL_GLC(struct A6XX_RBBM_CLOCK_CNTL_GLC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000012b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_CLOCK_CNTL_GLC(...) pack_A6XX_RBBM_CLOCK_CNTL_GLC(__struct_cast(A6XX_RBBM_CLOCK_CNTL_GLC) { __VA_ARGS__ })

struct A7XX_RBBM_CLOCK_HYST2_VFD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CLOCK_HYST2_VFD(struct A7XX_RBBM_CLOCK_HYST2_VFD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000012f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CLOCK_HYST2_VFD(...) pack_A7XX_RBBM_CLOCK_HYST2_VFD(__struct_cast(A7XX_RBBM_CLOCK_HYST2_VFD) { __VA_ARGS__ })

struct A7XX_RBBM_CGC_0_PC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RBBM_CGC_0_PC(struct A7XX_RBBM_CGC_0_PC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000195,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RBBM_CGC_0_PC(...) pack_A7XX_RBBM_CGC_0_PC(__struct_cast(A7XX_RBBM_CGC_0_PC) { __VA_ARGS__ })

struct A8XX_RBBM_CGC_0_PC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_CGC_0_PC(struct A8XX_RBBM_CGC_0_PC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000010b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_CGC_0_PC(...) pack_A8XX_RBBM_CGC_0_PC(__struct_cast(A8XX_RBBM_CGC_0_PC) { __VA_ARGS__ })

struct A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(struct A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000005ff,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(...) pack_A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(__struct_cast(A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(struct A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000009,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(...) pack_A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL(__struct_cast(A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_A {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_SEL_A(struct A6XX_DBGC_CFG_DBGBUS_SEL_A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000600,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_SEL_A(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_A(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_A) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_B {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_SEL_B(struct A6XX_DBGC_CFG_DBGBUS_SEL_B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000601,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_SEL_B(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_B(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_B) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_C {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_SEL_C(struct A6XX_DBGC_CFG_DBGBUS_SEL_C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000602,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_SEL_C(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_C(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_C) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_SEL_D {
    uint32_t							ping_index;
    uint32_t							ping_blk_sel;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_SEL_D(struct A6XX_DBGC_CFG_DBGBUS_SEL_D fields)
{
#ifndef NDEBUG
    assert((fields.ping_index                        & 0xffffff00) == 0);
    assert((fields.ping_blk_sel                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000603,
        .value =
            (fields.ping_index                        <<  0) |
            (fields.ping_blk_sel                      <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_SEL_D(...) pack_A6XX_DBGC_CFG_DBGBUS_SEL_D(__struct_cast(A6XX_DBGC_CFG_DBGBUS_SEL_D) { __VA_ARGS__ })

struct A7XX_DBGC_CFG_DBGBUS_SEL_D {
    uint32_t							ping_index;
    uint32_t							ping_blk_sel;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_DBGC_CFG_DBGBUS_SEL_D(struct A7XX_DBGC_CFG_DBGBUS_SEL_D fields)
{
#ifndef NDEBUG
    assert((fields.ping_index                        & 0xffffff00) == 0);
    assert((fields.ping_blk_sel                      & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0x01ff00ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000603,
        .value =
            (fields.ping_index                        <<  0) |
            (fields.ping_blk_sel                      << 16) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_DBGC_CFG_DBGBUS_SEL_D(...) pack_A7XX_DBGC_CFG_DBGBUS_SEL_D(__struct_cast(A7XX_DBGC_CFG_DBGBUS_SEL_D) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_CNTLT {
    uint32_t							traceen;
    uint32_t							granu;
    uint32_t							segt;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_CNTLT(struct A6XX_DBGC_CFG_DBGBUS_CNTLT fields)
{
#ifndef NDEBUG
    assert((fields.traceen                           & 0xffffffc0) == 0);
    assert((fields.granu                             & 0xfffffff8) == 0);
    assert((fields.segt                              & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xf000703f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000604,
        .value =
            (fields.traceen                           <<  0) |
            (fields.granu                             << 12) |
            (fields.segt                              << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_CNTLT(...) pack_A6XX_DBGC_CFG_DBGBUS_CNTLT(__struct_cast(A6XX_DBGC_CFG_DBGBUS_CNTLT) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_CNTLM {
    uint32_t							enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_CNTLM(struct A6XX_DBGC_CFG_DBGBUS_CNTLM fields)
{
#ifndef NDEBUG
    assert((fields.enable                            & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0f000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000605,
        .value =
            (fields.enable                            << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_CNTLM(...) pack_A6XX_DBGC_CFG_DBGBUS_CNTLM(__struct_cast(A6XX_DBGC_CFG_DBGBUS_CNTLM) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_OPL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_OPL(struct A6XX_DBGC_CFG_DBGBUS_OPL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000606,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_OPL(...) pack_A6XX_DBGC_CFG_DBGBUS_OPL(__struct_cast(A6XX_DBGC_CFG_DBGBUS_OPL) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_OPE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_OPE(struct A6XX_DBGC_CFG_DBGBUS_OPE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000607,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_OPE(...) pack_A6XX_DBGC_CFG_DBGBUS_OPE(__struct_cast(A6XX_DBGC_CFG_DBGBUS_OPE) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_0(struct A6XX_DBGC_CFG_DBGBUS_IVTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000608,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_0(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_1(struct A6XX_DBGC_CFG_DBGBUS_IVTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000609,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_1(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_2(struct A6XX_DBGC_CFG_DBGBUS_IVTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_2(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTL_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTL_3(struct A6XX_DBGC_CFG_DBGBUS_IVTL_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTL_3(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTL_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTL_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_0(struct A6XX_DBGC_CFG_DBGBUS_MASKL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_0(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_1(struct A6XX_DBGC_CFG_DBGBUS_MASKL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_1(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_2(struct A6XX_DBGC_CFG_DBGBUS_MASKL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_2(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKL_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKL_3(struct A6XX_DBGC_CFG_DBGBUS_MASKL_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000060f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKL_3(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKL_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKL_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_BYTEL_0 {
    uint32_t							bytel0;
    uint32_t							bytel1;
    uint32_t							bytel2;
    uint32_t							bytel3;
    uint32_t							bytel4;
    uint32_t							bytel5;
    uint32_t							bytel6;
    uint32_t							bytel7;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_0(struct A6XX_DBGC_CFG_DBGBUS_BYTEL_0 fields)
{
#ifndef NDEBUG
    assert((fields.bytel0                            & 0xfffffff0) == 0);
    assert((fields.bytel1                            & 0xfffffff0) == 0);
    assert((fields.bytel2                            & 0xfffffff0) == 0);
    assert((fields.bytel3                            & 0xfffffff0) == 0);
    assert((fields.bytel4                            & 0xfffffff0) == 0);
    assert((fields.bytel5                            & 0xfffffff0) == 0);
    assert((fields.bytel6                            & 0xfffffff0) == 0);
    assert((fields.bytel7                            & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000610,
        .value =
            (fields.bytel0                            <<  0) |
            (fields.bytel1                            <<  4) |
            (fields.bytel2                            <<  8) |
            (fields.bytel3                            << 12) |
            (fields.bytel4                            << 16) |
            (fields.bytel5                            << 20) |
            (fields.bytel6                            << 24) |
            (fields.bytel7                            << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0(...) pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_BYTEL_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_BYTEL_1 {
    uint32_t							bytel8;
    uint32_t							bytel9;
    uint32_t							bytel10;
    uint32_t							bytel11;
    uint32_t							bytel12;
    uint32_t							bytel13;
    uint32_t							bytel14;
    uint32_t							bytel15;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_1(struct A6XX_DBGC_CFG_DBGBUS_BYTEL_1 fields)
{
#ifndef NDEBUG
    assert((fields.bytel8                            & 0xfffffff0) == 0);
    assert((fields.bytel9                            & 0xfffffff0) == 0);
    assert((fields.bytel10                           & 0xfffffff0) == 0);
    assert((fields.bytel11                           & 0xfffffff0) == 0);
    assert((fields.bytel12                           & 0xfffffff0) == 0);
    assert((fields.bytel13                           & 0xfffffff0) == 0);
    assert((fields.bytel14                           & 0xfffffff0) == 0);
    assert((fields.bytel15                           & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000611,
        .value =
            (fields.bytel8                            <<  0) |
            (fields.bytel9                            <<  4) |
            (fields.bytel10                           <<  8) |
            (fields.bytel11                           << 12) |
            (fields.bytel12                           << 16) |
            (fields.bytel13                           << 20) |
            (fields.bytel14                           << 24) |
            (fields.bytel15                           << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1(...) pack_A6XX_DBGC_CFG_DBGBUS_BYTEL_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_BYTEL_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_0(struct A6XX_DBGC_CFG_DBGBUS_IVTE_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000612,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_0(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_1(struct A6XX_DBGC_CFG_DBGBUS_IVTE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000613,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_1(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_2(struct A6XX_DBGC_CFG_DBGBUS_IVTE_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000614,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_2(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IVTE_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IVTE_3(struct A6XX_DBGC_CFG_DBGBUS_IVTE_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000615,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IVTE_3(...) pack_A6XX_DBGC_CFG_DBGBUS_IVTE_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IVTE_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_0(struct A6XX_DBGC_CFG_DBGBUS_MASKE_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000616,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_0(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_1(struct A6XX_DBGC_CFG_DBGBUS_MASKE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000617,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_1(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_2(struct A6XX_DBGC_CFG_DBGBUS_MASKE_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000618,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_2(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MASKE_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MASKE_3(struct A6XX_DBGC_CFG_DBGBUS_MASKE_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000619,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MASKE_3(...) pack_A6XX_DBGC_CFG_DBGBUS_MASKE_3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MASKE_3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_NIBBLEE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_NIBBLEE(struct A6XX_DBGC_CFG_DBGBUS_NIBBLEE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_NIBBLEE(...) pack_A6XX_DBGC_CFG_DBGBUS_NIBBLEE(__struct_cast(A6XX_DBGC_CFG_DBGBUS_NIBBLEE) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PTRC0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PTRC0(struct A6XX_DBGC_CFG_DBGBUS_PTRC0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PTRC0(...) pack_A6XX_DBGC_CFG_DBGBUS_PTRC0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PTRC0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PTRC1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PTRC1(struct A6XX_DBGC_CFG_DBGBUS_PTRC1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PTRC1(...) pack_A6XX_DBGC_CFG_DBGBUS_PTRC1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PTRC1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_LOADREG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_LOADREG(struct A6XX_DBGC_CFG_DBGBUS_LOADREG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_LOADREG(...) pack_A6XX_DBGC_CFG_DBGBUS_LOADREG(__struct_cast(A6XX_DBGC_CFG_DBGBUS_LOADREG) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_IDX {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_IDX(struct A6XX_DBGC_CFG_DBGBUS_IDX fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_IDX(...) pack_A6XX_DBGC_CFG_DBGBUS_IDX(__struct_cast(A6XX_DBGC_CFG_DBGBUS_IDX) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_CLRC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_CLRC(struct A6XX_DBGC_CFG_DBGBUS_CLRC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000061f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_CLRC(...) pack_A6XX_DBGC_CFG_DBGBUS_CLRC(__struct_cast(A6XX_DBGC_CFG_DBGBUS_CLRC) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_LOADIVT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_LOADIVT(struct A6XX_DBGC_CFG_DBGBUS_LOADIVT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000620,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_LOADIVT(...) pack_A6XX_DBGC_CFG_DBGBUS_LOADIVT(__struct_cast(A6XX_DBGC_CFG_DBGBUS_LOADIVT) { __VA_ARGS__ })

struct A6XX_DBGC_VBIF_DBG_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_VBIF_DBG_CNTL(struct A6XX_DBGC_VBIF_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000621,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_VBIF_DBG_CNTL(...) pack_A6XX_DBGC_VBIF_DBG_CNTL(__struct_cast(A6XX_DBGC_VBIF_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LO_HI_GPIO {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LO_HI_GPIO(struct A6XX_DBGC_DBG_LO_HI_GPIO fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000622,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LO_HI_GPIO(...) pack_A6XX_DBGC_DBG_LO_HI_GPIO(__struct_cast(A6XX_DBGC_DBG_LO_HI_GPIO) { __VA_ARGS__ })

struct A6XX_DBGC_EXT_TRACE_BUS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EXT_TRACE_BUS_CNTL(struct A6XX_DBGC_EXT_TRACE_BUS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000623,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EXT_TRACE_BUS_CNTL(...) pack_A6XX_DBGC_EXT_TRACE_BUS_CNTL(__struct_cast(A6XX_DBGC_EXT_TRACE_BUS_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_READ_AHB_THROUGH_DBG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_READ_AHB_THROUGH_DBG(struct A6XX_DBGC_READ_AHB_THROUGH_DBG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000624,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_READ_AHB_THROUGH_DBG(...) pack_A6XX_DBGC_READ_AHB_THROUGH_DBG(__struct_cast(A6XX_DBGC_READ_AHB_THROUGH_DBG) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC(struct A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000625,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC(...) pack_A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC(__struct_cast(A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_OVER {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_OVER(struct A6XX_DBGC_CFG_DBGBUS_OVER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000626,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_OVER(...) pack_A6XX_DBGC_CFG_DBGBUS_OVER(__struct_cast(A6XX_DBGC_CFG_DBGBUS_OVER) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT0(struct A6XX_DBGC_CFG_DBGBUS_COUNT0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000627,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT0(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT1(struct A6XX_DBGC_CFG_DBGBUS_COUNT1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000628,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT1(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT2(struct A6XX_DBGC_CFG_DBGBUS_COUNT2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000629,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT2(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT3(struct A6XX_DBGC_CFG_DBGBUS_COUNT3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT3(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT4 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT4(struct A6XX_DBGC_CFG_DBGBUS_COUNT4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT4(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT4(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT4) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_COUNT5 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_COUNT5(struct A6XX_DBGC_CFG_DBGBUS_COUNT5 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_COUNT5(...) pack_A6XX_DBGC_CFG_DBGBUS_COUNT5(__struct_cast(A6XX_DBGC_CFG_DBGBUS_COUNT5) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR(struct A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000062f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000630,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000631,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4(struct A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000632,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4(...) pack_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4(__struct_cast(A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MISR0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MISR0(struct A6XX_DBGC_CFG_DBGBUS_MISR0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000633,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MISR0(...) pack_A6XX_DBGC_CFG_DBGBUS_MISR0(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MISR0) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MISR1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MISR1(struct A6XX_DBGC_CFG_DBGBUS_MISR1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000634,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MISR1(...) pack_A6XX_DBGC_CFG_DBGBUS_MISR1(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MISR1) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_CFG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_CFG(struct A6XX_DBGC_EVT_CFG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000635,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_CFG(...) pack_A6XX_DBGC_EVT_CFG(__struct_cast(A6XX_DBGC_EVT_CFG) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_0(struct A6XX_DBGC_EVT_INTF_SEL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000636,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_0(...) pack_A6XX_DBGC_EVT_INTF_SEL_0(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_0) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_1(struct A6XX_DBGC_EVT_INTF_SEL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000637,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_1(...) pack_A6XX_DBGC_EVT_INTF_SEL_1(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_1) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_SLICE_CFG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_SLICE_CFG(struct A6XX_DBGC_EVT_SLICE_CFG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000638,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_SLICE_CFG(...) pack_A6XX_DBGC_EVT_SLICE_CFG(__struct_cast(A6XX_DBGC_EVT_SLICE_CFG) { __VA_ARGS__ })

struct A6XX_DBGC_QDSS_TIMESTAMP_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_QDSS_TIMESTAMP_0(struct A6XX_DBGC_QDSS_TIMESTAMP_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000639,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_QDSS_TIMESTAMP_0(...) pack_A6XX_DBGC_QDSS_TIMESTAMP_0(__struct_cast(A6XX_DBGC_QDSS_TIMESTAMP_0) { __VA_ARGS__ })

struct A6XX_DBGC_QDSS_TIMESTAMP_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_QDSS_TIMESTAMP_1(struct A6XX_DBGC_QDSS_TIMESTAMP_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_QDSS_TIMESTAMP_1(...) pack_A6XX_DBGC_QDSS_TIMESTAMP_1(__struct_cast(A6XX_DBGC_QDSS_TIMESTAMP_1) { __VA_ARGS__ })

struct A6XX_DBGC_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_ECO_CNTL(struct A6XX_DBGC_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_ECO_CNTL(...) pack_A6XX_DBGC_ECO_CNTL(__struct_cast(A6XX_DBGC_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_AHB_DBG_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_AHB_DBG_CNTL(struct A6XX_DBGC_AHB_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_AHB_DBG_CNTL(...) pack_A6XX_DBGC_AHB_DBG_CNTL(__struct_cast(A6XX_DBGC_AHB_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_2(struct A6XX_DBGC_EVT_INTF_SEL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000063d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_2(...) pack_A6XX_DBGC_EVT_INTF_SEL_2(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_2) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000640,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000641,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000642,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D(struct A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000643,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D(...) pack_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D(__struct_cast(A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D) { __VA_ARGS__ })

struct A6XX_DBGC_CFG_DBGBUS_MISC_MODE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_CFG_DBGBUS_MISC_MODE(struct A6XX_DBGC_CFG_DBGBUS_MISC_MODE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000644,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_CFG_DBGBUS_MISC_MODE(...) pack_A6XX_DBGC_CFG_DBGBUS_MISC_MODE(__struct_cast(A6XX_DBGC_CFG_DBGBUS_MISC_MODE) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_0(struct A6XX_DBGC_EVT_INTF_SEL_3_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000650,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_0(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_0(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_0) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_1(struct A6XX_DBGC_EVT_INTF_SEL_3_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000651,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_1(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_1(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_1) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_2(struct A6XX_DBGC_EVT_INTF_SEL_3_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000652,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_2(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_2(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_2) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_3(struct A6XX_DBGC_EVT_INTF_SEL_3_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000653,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_3(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_3(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_3) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_4 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_4(struct A6XX_DBGC_EVT_INTF_SEL_3_4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000654,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_4(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_4(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_4) { __VA_ARGS__ })

struct A6XX_DBGC_EVT_INTF_SEL_3_5 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_EVT_INTF_SEL_3_5(struct A6XX_DBGC_EVT_INTF_SEL_3_5 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000655,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_EVT_INTF_SEL_3_5(...) pack_A6XX_DBGC_EVT_INTF_SEL_3_5(__struct_cast(A6XX_DBGC_EVT_INTF_SEL_3_5) { __VA_ARGS__ })

struct A6XX_DBGC_TRACE_BUFFER_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_TRACE_BUFFER_STATUS(struct A6XX_DBGC_TRACE_BUFFER_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000660,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_TRACE_BUFFER_STATUS(...) pack_A6XX_DBGC_TRACE_BUFFER_STATUS(__struct_cast(A6XX_DBGC_TRACE_BUFFER_STATUS) { __VA_ARGS__ })

struct A6XX_DBGC_TRACE_BUFFER_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_TRACE_BUFFER_CMD(struct A6XX_DBGC_TRACE_BUFFER_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000661,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_TRACE_BUFFER_CMD(...) pack_A6XX_DBGC_TRACE_BUFFER_CMD(__struct_cast(A6XX_DBGC_TRACE_BUFFER_CMD) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR(struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000662,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR(...) pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR(__struct_cast(A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA(struct A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000663,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA(...) pack_A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA(__struct_cast(A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA) { __VA_ARGS__ })

struct A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS(struct A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000664,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS(...) pack_A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS(__struct_cast(A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS) { __VA_ARGS__ })

struct A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG(struct A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000665,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG(...) pack_A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG(__struct_cast(A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_RD_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_RD_ADDR(struct A6XX_DBGC_DBG_LOPC_SB_RD_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000666,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_RD_ADDR(...) pack_A6XX_DBGC_DBG_LOPC_SB_RD_ADDR(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_RD_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_RD_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_RD_DATA(struct A6XX_DBGC_DBG_LOPC_SB_RD_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000667,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_RD_DATA(...) pack_A6XX_DBGC_DBG_LOPC_SB_RD_DATA(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_RD_DATA) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_WR_ADDR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_WR_ADDR(struct A6XX_DBGC_DBG_LOPC_SB_WR_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000668,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_WR_ADDR(...) pack_A6XX_DBGC_DBG_LOPC_SB_WR_ADDR(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_WR_ADDR) { __VA_ARGS__ })

struct A6XX_DBGC_DBG_LOPC_SB_WR_DATA {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_DBG_LOPC_SB_WR_DATA(struct A6XX_DBGC_DBG_LOPC_SB_WR_DATA fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000669,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_DBG_LOPC_SB_WR_DATA(...) pack_A6XX_DBGC_DBG_LOPC_SB_WR_DATA(__struct_cast(A6XX_DBGC_DBG_LOPC_SB_WR_DATA) { __VA_ARGS__ })

struct A6XX_DBGC_INTERRUPT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_INTERRUPT_STATUS(struct A6XX_DBGC_INTERRUPT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000066a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_INTERRUPT_STATUS(...) pack_A6XX_DBGC_INTERRUPT_STATUS(__struct_cast(A6XX_DBGC_INTERRUPT_STATUS) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_BASE(struct A6XX_DBGC_GBIF_DBG_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000680,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_DBGC_GBIF_DBG_BASE(...) pack_A6XX_DBGC_GBIF_DBG_BASE(__struct_cast(A6XX_DBGC_GBIF_DBG_BASE) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_BUFF_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_BUFF_SIZE(struct A6XX_DBGC_GBIF_DBG_BUFF_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000682,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_BUFF_SIZE(...) pack_A6XX_DBGC_GBIF_DBG_BUFF_SIZE(__struct_cast(A6XX_DBGC_GBIF_DBG_BUFF_SIZE) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_CNTL(struct A6XX_DBGC_GBIF_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000683,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_CNTL(...) pack_A6XX_DBGC_GBIF_DBG_CNTL(__struct_cast(A6XX_DBGC_GBIF_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_CMD(struct A6XX_DBGC_GBIF_DBG_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000684,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_CMD(...) pack_A6XX_DBGC_GBIF_DBG_CMD(__struct_cast(A6XX_DBGC_GBIF_DBG_CMD) { __VA_ARGS__ })

struct A6XX_DBGC_GBIF_DBG_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_DBGC_GBIF_DBG_STATUS(struct A6XX_DBGC_GBIF_DBG_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000685,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_DBGC_GBIF_DBG_STATUS(...) pack_A6XX_DBGC_GBIF_DBG_STATUS(__struct_cast(A6XX_DBGC_GBIF_DBG_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US(struct A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000700,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US(...) pack_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US(__struct_cast(A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000701,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000702,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000703,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000704,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000707,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000708,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000709,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000070a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000070f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000710,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000711,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000712,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000713,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000714,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000715,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000716,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000720,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000721,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000722,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000723,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000724,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000730,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000731,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000732,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000740,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US(struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000742,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US(struct A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000743,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US(...) pack_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE(struct A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000744,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE(...) pack_A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE(__struct_cast(A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE(struct A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000746,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE(...) pack_A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE(__struct_cast(A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE(struct A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000747,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE(...) pack_A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE(__struct_cast(A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE(struct A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000749,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE(...) pack_A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE(__struct_cast(A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_QOS_CTRL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_GBIF_QOS_CTRL(struct A8XX_DBGC_CFG_GBIF_QOS_CTRL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000074a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_GBIF_QOS_CTRL(...) pack_A8XX_DBGC_CFG_GBIF_QOS_CTRL(__struct_cast(A8XX_DBGC_CFG_GBIF_QOS_CTRL) { __VA_ARGS__ })

struct A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER(struct A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000750,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER(...) pack_A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER(__struct_cast(A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER) { __VA_ARGS__ })

struct A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER(struct A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000751,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER(...) pack_A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER(__struct_cast(A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID(struct A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000752,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID(...) pack_A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID(__struct_cast(A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL(struct A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000753,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL(...) pack_A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US(struct A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000754,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US(...) pack_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US(__struct_cast(A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD(struct A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000755,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD(...) pack_A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD(__struct_cast(A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_INTERRUPT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LOPC_INTERRUPT_STATUS(struct A8XX_DBGC_LOPC_INTERRUPT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000759,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LOPC_INTERRUPT_STATUS(...) pack_A8XX_DBGC_LOPC_INTERRUPT_STATUS(__struct_cast(A8XX_DBGC_LOPC_INTERRUPT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_BUFFER_PTR_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LOPC_BUFFER_PTR_STATUS(struct A8XX_DBGC_LOPC_BUFFER_PTR_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000075a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LOPC_BUFFER_PTR_STATUS(...) pack_A8XX_DBGC_LOPC_BUFFER_PTR_STATUS(__struct_cast(A8XX_DBGC_LOPC_BUFFER_PTR_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_SCOPING_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_PERF_SCOPING_STATUS(struct A8XX_DBGC_PERF_SCOPING_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000075b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_PERF_SCOPING_STATUS(...) pack_A8XX_DBGC_PERF_SCOPING_STATUS(__struct_cast(A8XX_DBGC_PERF_SCOPING_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_PKT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_PERF_COUNTER_PKT_STATUS(struct A8XX_DBGC_PERF_COUNTER_PKT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000075c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_PERF_COUNTER_PKT_STATUS(...) pack_A8XX_DBGC_PERF_COUNTER_PKT_STATUS(__struct_cast(A8XX_DBGC_PERF_COUNTER_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS(struct A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000760,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS(...) pack_A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS(__struct_cast(A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_GC_ALW_MBX_PKT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_GC_ALW_MBX_PKT_STATUS(struct A8XX_DBGC_GC_ALW_MBX_PKT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000761,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_GC_ALW_MBX_PKT_STATUS(...) pack_A8XX_DBGC_GC_ALW_MBX_PKT_STATUS(__struct_cast(A8XX_DBGC_GC_ALW_MBX_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_AO_CNTR_LO_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_AO_CNTR_LO_STATUS(struct A8XX_DBGC_AO_CNTR_LO_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000762,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_AO_CNTR_LO_STATUS(...) pack_A8XX_DBGC_AO_CNTR_LO_STATUS(__struct_cast(A8XX_DBGC_AO_CNTR_LO_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_AO_CNTR_HI_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_AO_CNTR_HI_STATUS(struct A8XX_DBGC_AO_CNTR_HI_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000763,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_AO_CNTR_HI_STATUS(...) pack_A8XX_DBGC_AO_CNTR_HI_STATUS(__struct_cast(A8XX_DBGC_AO_CNTR_HI_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS(struct A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000770,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS(...) pack_A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS(__struct_cast(A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US(struct A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000780,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US(...) pack_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US(__struct_cast(A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_LPAC_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_LPAC_US(struct A8XX_DBGC_CFG_PERF_TRIG_LPAC_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000781,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_LPAC_US(...) pack_A8XX_DBGC_CFG_PERF_TRIG_LPAC_US(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_LPAC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000782,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000783,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000784,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US(struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000785,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE(struct A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000786,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE(...) pack_A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE(__struct_cast(A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE(struct A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000788,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE(...) pack_A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE(__struct_cast(A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER(struct A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000789,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER(...) pack_A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER(__struct_cast(A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL(struct A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000078a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL(...) pack_A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL(__struct_cast(A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US(struct A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000078b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US(...) pack_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US(__struct_cast(A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_MBX_PKT_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LPAC_MBX_PKT_STATUS(struct A8XX_DBGC_LPAC_MBX_PKT_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000078c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LPAC_MBX_PKT_STATUS(...) pack_A8XX_DBGC_LPAC_MBX_PKT_STATUS(__struct_cast(A8XX_DBGC_LPAC_MBX_PKT_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_PERF_SCOPING_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LPAC_PERF_SCOPING_STATUS(struct A8XX_DBGC_LPAC_PERF_SCOPING_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000078d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LPAC_PERF_SCOPING_STATUS(...) pack_A8XX_DBGC_LPAC_PERF_SCOPING_STATUS(__struct_cast(A8XX_DBGC_LPAC_PERF_SCOPING_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS(struct A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000790,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS(...) pack_A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS(__struct_cast(A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS) { __VA_ARGS__ })

struct A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S(struct A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S(...) pack_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S(__struct_cast(A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS(struct A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS(...) pack_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007a9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007aa,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007ab,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS(struct A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007ac,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS(...) pack_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007ad,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007ae,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007af,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007b9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007ba,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007bb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007bc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007bd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007be,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007bf,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S(struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007c9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007ca,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007cb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007cc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007cd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007ce,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007cf,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007d0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007d1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007d2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1(struct A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007d3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1(...) pack_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1(__struct_cast(A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S(struct A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007d4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S(...) pack_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S(__struct_cast(A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S) { __VA_ARGS__ })

struct A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S(struct A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007d5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S(...) pack_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S(__struct_cast(A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S(struct A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007e0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S(...) pack_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S(__struct_cast(A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TRIG_LPAC_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TRIG_LPAC_S(struct A8XX_DBGC_CFG_PERF_TRIG_LPAC_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007e1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TRIG_LPAC_S(...) pack_A8XX_DBGC_CFG_PERF_TRIG_LPAC_S(__struct_cast(A8XX_DBGC_CFG_PERF_TRIG_LPAC_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007e2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007e3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2(struct A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007e4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2(...) pack_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2(__struct_cast(A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2) { __VA_ARGS__ })

struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S(struct A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007e5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S(...) pack_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S(__struct_cast(A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S) { __VA_ARGS__ })

struct A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S(struct A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000007e6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S(...) pack_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S(__struct_cast(A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S) { __VA_ARGS__ })

struct A6XX_VSC_PERFCTR_VSC_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PERFCTR_VSC_SEL_REG(uint32_t __i, struct A6XX_VSC_PERFCTR_VSC_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000cd8 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PERFCTR_VSC_SEL_REG(__i, ...) pack_A6XX_VSC_PERFCTR_VSC_SEL_REG(__i, __struct_cast(A6XX_VSC_PERFCTR_VSC_SEL_REG) { __VA_ARGS__ })

struct A6XX_HLSQ_DBG_AHB_READ_APERTURE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_HLSQ_DBG_AHB_READ_APERTURE(struct A6XX_HLSQ_DBG_AHB_READ_APERTURE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000c800,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_DBG_AHB_READ_APERTURE(...) pack_A6XX_HLSQ_DBG_AHB_READ_APERTURE(__struct_cast(A6XX_HLSQ_DBG_AHB_READ_APERTURE) { __VA_ARGS__ })

struct A6XX_HLSQ_DBG_READ_SEL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_HLSQ_DBG_READ_SEL(struct A6XX_HLSQ_DBG_READ_SEL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000d000,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_HLSQ_DBG_READ_SEL(...) pack_A6XX_HLSQ_DBG_READ_SEL(__struct_cast(A6XX_HLSQ_DBG_READ_SEL) { __VA_ARGS__ })

struct A6XX_UCHE_ADDR_MODE_CNTL {
    enum a5xx_address_mode					uche_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_ADDR_MODE_CNTL(struct A6XX_UCHE_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.uche_addr_mode_cntl               & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e00,
        .value =
            (fields.uche_addr_mode_cntl               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_ADDR_MODE_CNTL(...) pack_A6XX_UCHE_ADDR_MODE_CNTL(__struct_cast(A6XX_UCHE_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_UCHE_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_UCHE_MODE_CNTL(struct A6XX_UCHE_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_MODE_CNTL(...) pack_A6XX_UCHE_MODE_CNTL(__struct_cast(A6XX_UCHE_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_UCHE_WRITE_RANGE_MAX {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_WRITE_RANGE_MAX(struct A6XX_UCHE_WRITE_RANGE_MAX fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e05,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_UCHE_WRITE_RANGE_MAX(...) pack_A6XX_UCHE_WRITE_RANGE_MAX(__struct_cast(A6XX_UCHE_WRITE_RANGE_MAX) { __VA_ARGS__ })

struct A6XX_UCHE_WRITE_THRU_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_WRITE_THRU_BASE(struct A6XX_UCHE_WRITE_THRU_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e07,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_UCHE_WRITE_THRU_BASE(...) pack_A6XX_UCHE_WRITE_THRU_BASE(__struct_cast(A6XX_UCHE_WRITE_THRU_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_WRITE_THRU_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_WRITE_THRU_BASE(struct A8XX_UCHE_WRITE_THRU_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e06,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_UCHE_WRITE_THRU_BASE(...) pack_A8XX_UCHE_WRITE_THRU_BASE(__struct_cast(A8XX_UCHE_WRITE_THRU_BASE) { __VA_ARGS__ })

struct A6XX_UCHE_TRAP_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_TRAP_BASE(struct A6XX_UCHE_TRAP_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e09,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_UCHE_TRAP_BASE(...) pack_A6XX_UCHE_TRAP_BASE(__struct_cast(A6XX_UCHE_TRAP_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_TRAP_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_TRAP_BASE(struct A8XX_UCHE_TRAP_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e08,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_UCHE_TRAP_BASE(...) pack_A8XX_UCHE_TRAP_BASE(__struct_cast(A8XX_UCHE_TRAP_BASE) { __VA_ARGS__ })

struct A6XX_UCHE_GMEM_RANGE_MIN {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_GMEM_RANGE_MIN(struct A6XX_UCHE_GMEM_RANGE_MIN fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e0b,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_UCHE_GMEM_RANGE_MIN(...) pack_A6XX_UCHE_GMEM_RANGE_MIN(__struct_cast(A6XX_UCHE_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A6XX_UCHE_GMEM_RANGE_MAX {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_GMEM_RANGE_MAX(struct A6XX_UCHE_GMEM_RANGE_MAX fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e0d,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A6XX_UCHE_GMEM_RANGE_MAX(...) pack_A6XX_UCHE_GMEM_RANGE_MAX(__struct_cast(A6XX_UCHE_GMEM_RANGE_MAX) { __VA_ARGS__ })

struct A6XX_UCHE_CACHE_WAYS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_CACHE_WAYS(struct A6XX_UCHE_CACHE_WAYS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e17,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_CACHE_WAYS(...) pack_A6XX_UCHE_CACHE_WAYS(__struct_cast(A6XX_UCHE_CACHE_WAYS) { __VA_ARGS__ })

struct A8XX_UCHE_CACHE_WAYS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CACHE_WAYS(struct A8XX_UCHE_CACHE_WAYS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e04,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_CACHE_WAYS(...) pack_A8XX_UCHE_CACHE_WAYS(__struct_cast(A8XX_UCHE_CACHE_WAYS) { __VA_ARGS__ })

struct A6XX_UCHE_FILTER_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_UCHE_FILTER_CNTL(struct A6XX_UCHE_FILTER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e18,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_FILTER_CNTL(...) pack_A6XX_UCHE_FILTER_CNTL(__struct_cast(A6XX_UCHE_FILTER_CNTL) { __VA_ARGS__ })

struct A6XX_UCHE_CLIENT_PF {
    uint32_t							perfsel;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_CLIENT_PF(struct A6XX_UCHE_CLIENT_PF fields)
{
#ifndef NDEBUG
    assert((fields.perfsel                           & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e19,
        .value =
            (fields.perfsel                           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_CLIENT_PF(...) pack_A6XX_UCHE_CLIENT_PF(__struct_cast(A6XX_UCHE_CLIENT_PF) { __VA_ARGS__ })

struct A6XX_UCHE_PERFCTR_UCHE_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_PERFCTR_UCHE_SEL_REG(uint32_t __i, struct A6XX_UCHE_PERFCTR_UCHE_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000e1c + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, ...) pack_A6XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, __struct_cast(A6XX_UCHE_PERFCTR_UCHE_SEL_REG) { __VA_ARGS__ })

struct A8XX_UCHE_PERFCTR_UCHE_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_PERFCTR_UCHE_SEL_REG(uint32_t __i, struct A8XX_UCHE_PERFCTR_UCHE_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000e20 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, ...) pack_A8XX_UCHE_PERFCTR_UCHE_SEL_REG(__i, __struct_cast(A8XX_UCHE_PERFCTR_UCHE_SEL_REG) { __VA_ARGS__ })

struct A6XX_UCHE_GBIF_GX_CONFIG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_GBIF_GX_CONFIG(struct A6XX_UCHE_GBIF_GX_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e3a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_GBIF_GX_CONFIG(...) pack_A6XX_UCHE_GBIF_GX_CONFIG(__struct_cast(A6XX_UCHE_GBIF_GX_CONFIG) { __VA_ARGS__ })

struct A8XX_UCHE_GBIF_GX_CONFIG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_GBIF_GX_CONFIG(struct A8XX_UCHE_GBIF_GX_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e12,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_GBIF_GX_CONFIG(...) pack_A8XX_UCHE_GBIF_GX_CONFIG(__struct_cast(A8XX_UCHE_GBIF_GX_CONFIG) { __VA_ARGS__ })

struct A6XX_UCHE_CMDQ_CONFIG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_CMDQ_CONFIG(struct A6XX_UCHE_CMDQ_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e3c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_CMDQ_CONFIG(...) pack_A6XX_UCHE_CMDQ_CONFIG(__struct_cast(A6XX_UCHE_CMDQ_CONFIG) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CCHE_MODE_CNTL(struct A8XX_UCHE_CCHE_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000f01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_CCHE_MODE_CNTL(...) pack_A8XX_UCHE_CCHE_MODE_CNTL(__struct_cast(A8XX_UCHE_CCHE_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_CACHE_WAYS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CCHE_CACHE_WAYS(struct A8XX_UCHE_CCHE_CACHE_WAYS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000f02,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_CCHE_CACHE_WAYS(...) pack_A8XX_UCHE_CCHE_CACHE_WAYS(__struct_cast(A8XX_UCHE_CCHE_CACHE_WAYS) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_WRITE_THRU_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CCHE_WRITE_THRU_BASE(struct A8XX_UCHE_CCHE_WRITE_THRU_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000f04,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_UCHE_CCHE_WRITE_THRU_BASE(...) pack_A8XX_UCHE_CCHE_WRITE_THRU_BASE(__struct_cast(A8XX_UCHE_CCHE_WRITE_THRU_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_TRAP_BASE {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CCHE_TRAP_BASE(struct A8XX_UCHE_CCHE_TRAP_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000f06,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_UCHE_CCHE_TRAP_BASE(...) pack_A8XX_UCHE_CCHE_TRAP_BASE(__struct_cast(A8XX_UCHE_CCHE_TRAP_BASE) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN(struct A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000f08,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN(...) pack_A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN(__struct_cast(A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN {
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN(struct A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000f0a,
        .value =
            fields.unknown | fields.qword,
    };

}

#define A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN(...) pack_A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN(__struct_cast(A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN) { __VA_ARGS__ })

struct A8XX_UCHE_CCHE_HW_DBG_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CCHE_HW_DBG_CNTL(struct A8XX_UCHE_CCHE_HW_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000f0c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_CCHE_HW_DBG_CNTL(...) pack_A8XX_UCHE_CCHE_HW_DBG_CNTL(__struct_cast(A8XX_UCHE_CCHE_HW_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_VBIF_VERSION {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_VERSION(struct A6XX_VBIF_VERSION fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003000,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_VERSION(...) pack_A6XX_VBIF_VERSION(__struct_cast(A6XX_VBIF_VERSION) { __VA_ARGS__ })

struct A6XX_VBIF_CLKON {
    bool							force_on_testbus;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_CLKON(struct A6XX_VBIF_CLKON fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000002) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003001,
        .value =
            (fields.force_on_testbus                  <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_CLKON(...) pack_A6XX_VBIF_CLKON(__struct_cast(A6XX_VBIF_CLKON) { __VA_ARGS__ })

struct A6XX_VBIF_GATE_OFF_WRREQ_EN {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_GATE_OFF_WRREQ_EN(struct A6XX_VBIF_GATE_OFF_WRREQ_EN fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000302a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_GATE_OFF_WRREQ_EN(...) pack_A6XX_VBIF_GATE_OFF_WRREQ_EN(__struct_cast(A6XX_VBIF_GATE_OFF_WRREQ_EN) { __VA_ARGS__ })

struct A6XX_VBIF_XIN_HALT_CTRL0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_XIN_HALT_CTRL0(struct A6XX_VBIF_XIN_HALT_CTRL0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003080,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_XIN_HALT_CTRL0(...) pack_A6XX_VBIF_XIN_HALT_CTRL0(__struct_cast(A6XX_VBIF_XIN_HALT_CTRL0) { __VA_ARGS__ })

struct A6XX_VBIF_XIN_HALT_CTRL1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_XIN_HALT_CTRL1(struct A6XX_VBIF_XIN_HALT_CTRL1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003081,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_XIN_HALT_CTRL1(...) pack_A6XX_VBIF_XIN_HALT_CTRL1(__struct_cast(A6XX_VBIF_XIN_HALT_CTRL1) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS_OUT_CTRL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_TEST_BUS_OUT_CTRL(struct A6XX_VBIF_TEST_BUS_OUT_CTRL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003084,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_TEST_BUS_OUT_CTRL(...) pack_A6XX_VBIF_TEST_BUS_OUT_CTRL(__struct_cast(A6XX_VBIF_TEST_BUS_OUT_CTRL) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS1_CTRL0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_TEST_BUS1_CTRL0(struct A6XX_VBIF_TEST_BUS1_CTRL0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003085,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_TEST_BUS1_CTRL0(...) pack_A6XX_VBIF_TEST_BUS1_CTRL0(__struct_cast(A6XX_VBIF_TEST_BUS1_CTRL0) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS1_CTRL1 {
    uint32_t							data_sel;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_TEST_BUS1_CTRL1(struct A6XX_VBIF_TEST_BUS1_CTRL1 fields)
{
#ifndef NDEBUG
    assert((fields.data_sel                          & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003086,
        .value =
            (fields.data_sel                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_TEST_BUS1_CTRL1(...) pack_A6XX_VBIF_TEST_BUS1_CTRL1(__struct_cast(A6XX_VBIF_TEST_BUS1_CTRL1) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS2_CTRL0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_TEST_BUS2_CTRL0(struct A6XX_VBIF_TEST_BUS2_CTRL0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003087,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_TEST_BUS2_CTRL0(...) pack_A6XX_VBIF_TEST_BUS2_CTRL0(__struct_cast(A6XX_VBIF_TEST_BUS2_CTRL0) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS2_CTRL1 {
    uint32_t							data_sel;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_TEST_BUS2_CTRL1(struct A6XX_VBIF_TEST_BUS2_CTRL1 fields)
{
#ifndef NDEBUG
    assert((fields.data_sel                          & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0x000001ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003088,
        .value =
            (fields.data_sel                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_TEST_BUS2_CTRL1(...) pack_A6XX_VBIF_TEST_BUS2_CTRL1(__struct_cast(A6XX_VBIF_TEST_BUS2_CTRL1) { __VA_ARGS__ })

struct A6XX_VBIF_TEST_BUS_OUT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_TEST_BUS_OUT(struct A6XX_VBIF_TEST_BUS_OUT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000308c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_TEST_BUS_OUT(...) pack_A6XX_VBIF_TEST_BUS_OUT(__struct_cast(A6XX_VBIF_TEST_BUS_OUT) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_SEL0(struct A6XX_VBIF_PERF_CNT_SEL0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030d0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_SEL0(...) pack_A6XX_VBIF_PERF_CNT_SEL0(__struct_cast(A6XX_VBIF_PERF_CNT_SEL0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_SEL1(struct A6XX_VBIF_PERF_CNT_SEL1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030d1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_SEL1(...) pack_A6XX_VBIF_PERF_CNT_SEL1(__struct_cast(A6XX_VBIF_PERF_CNT_SEL1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_SEL2(struct A6XX_VBIF_PERF_CNT_SEL2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030d2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_SEL2(...) pack_A6XX_VBIF_PERF_CNT_SEL2(__struct_cast(A6XX_VBIF_PERF_CNT_SEL2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_SEL3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_SEL3(struct A6XX_VBIF_PERF_CNT_SEL3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030d3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_SEL3(...) pack_A6XX_VBIF_PERF_CNT_SEL3(__struct_cast(A6XX_VBIF_PERF_CNT_SEL3) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_LOW0(struct A6XX_VBIF_PERF_CNT_LOW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030d8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_LOW0(...) pack_A6XX_VBIF_PERF_CNT_LOW0(__struct_cast(A6XX_VBIF_PERF_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_LOW1(struct A6XX_VBIF_PERF_CNT_LOW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030d9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_LOW1(...) pack_A6XX_VBIF_PERF_CNT_LOW1(__struct_cast(A6XX_VBIF_PERF_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_LOW2(struct A6XX_VBIF_PERF_CNT_LOW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030da,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_LOW2(...) pack_A6XX_VBIF_PERF_CNT_LOW2(__struct_cast(A6XX_VBIF_PERF_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_LOW3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_LOW3(struct A6XX_VBIF_PERF_CNT_LOW3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030db,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_LOW3(...) pack_A6XX_VBIF_PERF_CNT_LOW3(__struct_cast(A6XX_VBIF_PERF_CNT_LOW3) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_HIGH0(struct A6XX_VBIF_PERF_CNT_HIGH0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030e0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_HIGH0(...) pack_A6XX_VBIF_PERF_CNT_HIGH0(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_HIGH1(struct A6XX_VBIF_PERF_CNT_HIGH1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030e1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_HIGH1(...) pack_A6XX_VBIF_PERF_CNT_HIGH1(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_HIGH2(struct A6XX_VBIF_PERF_CNT_HIGH2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030e2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_HIGH2(...) pack_A6XX_VBIF_PERF_CNT_HIGH2(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_CNT_HIGH3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_CNT_HIGH3(struct A6XX_VBIF_PERF_CNT_HIGH3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000030e3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_CNT_HIGH3(...) pack_A6XX_VBIF_PERF_CNT_HIGH3(__struct_cast(A6XX_VBIF_PERF_CNT_HIGH3) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_EN0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_EN0(struct A6XX_VBIF_PERF_PWR_CNT_EN0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003100,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_EN0(...) pack_A6XX_VBIF_PERF_PWR_CNT_EN0(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_EN0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_EN1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_EN1(struct A6XX_VBIF_PERF_PWR_CNT_EN1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003101,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_EN1(...) pack_A6XX_VBIF_PERF_PWR_CNT_EN1(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_EN1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_EN2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_EN2(struct A6XX_VBIF_PERF_PWR_CNT_EN2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003102,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_EN2(...) pack_A6XX_VBIF_PERF_PWR_CNT_EN2(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_EN2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_LOW0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_LOW0(struct A6XX_VBIF_PERF_PWR_CNT_LOW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003110,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_LOW0(...) pack_A6XX_VBIF_PERF_PWR_CNT_LOW0(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_LOW1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_LOW1(struct A6XX_VBIF_PERF_PWR_CNT_LOW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003111,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_LOW1(...) pack_A6XX_VBIF_PERF_PWR_CNT_LOW1(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_LOW2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_LOW2(struct A6XX_VBIF_PERF_PWR_CNT_LOW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003112,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_LOW2(...) pack_A6XX_VBIF_PERF_PWR_CNT_LOW2(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_HIGH0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_HIGH0(struct A6XX_VBIF_PERF_PWR_CNT_HIGH0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003118,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_HIGH0(...) pack_A6XX_VBIF_PERF_PWR_CNT_HIGH0(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_HIGH1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_HIGH1(struct A6XX_VBIF_PERF_PWR_CNT_HIGH1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003119,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_HIGH1(...) pack_A6XX_VBIF_PERF_PWR_CNT_HIGH1(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_VBIF_PERF_PWR_CNT_HIGH2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VBIF_PERF_PWR_CNT_HIGH2(struct A6XX_VBIF_PERF_PWR_CNT_HIGH2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000311a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VBIF_PERF_PWR_CNT_HIGH2(...) pack_A6XX_VBIF_PERF_PWR_CNT_HIGH2(__struct_cast(A6XX_VBIF_PERF_PWR_CNT_HIGH2) { __VA_ARGS__ })

struct A8XX_GBIF_CX_CONFIG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_CX_CONFIG(struct A8XX_GBIF_CX_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_CX_CONFIG(...) pack_A8XX_GBIF_CX_CONFIG(__struct_cast(A8XX_GBIF_CX_CONFIG) { __VA_ARGS__ })

struct A6XX_GBIF_SCACHE_CNTL0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_SCACHE_CNTL0(struct A6XX_GBIF_SCACHE_CNTL0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_SCACHE_CNTL0(...) pack_A6XX_GBIF_SCACHE_CNTL0(__struct_cast(A6XX_GBIF_SCACHE_CNTL0) { __VA_ARGS__ })

struct A6XX_GBIF_SCACHE_CNTL1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_SCACHE_CNTL1(struct A6XX_GBIF_SCACHE_CNTL1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c02,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_SCACHE_CNTL1(...) pack_A6XX_GBIF_SCACHE_CNTL1(__struct_cast(A6XX_GBIF_SCACHE_CNTL1) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE0(struct A6XX_GBIF_QSB_SIDE0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c03,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE0(...) pack_A6XX_GBIF_QSB_SIDE0(__struct_cast(A6XX_GBIF_QSB_SIDE0) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE1(struct A6XX_GBIF_QSB_SIDE1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c04,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE1(...) pack_A6XX_GBIF_QSB_SIDE1(__struct_cast(A6XX_GBIF_QSB_SIDE1) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE2(struct A6XX_GBIF_QSB_SIDE2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c05,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE2(...) pack_A6XX_GBIF_QSB_SIDE2(__struct_cast(A6XX_GBIF_QSB_SIDE2) { __VA_ARGS__ })

struct A6XX_GBIF_QSB_SIDE3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_QSB_SIDE3(struct A6XX_GBIF_QSB_SIDE3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c06,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_QSB_SIDE3(...) pack_A6XX_GBIF_QSB_SIDE3(__struct_cast(A6XX_GBIF_QSB_SIDE3) { __VA_ARGS__ })

struct A6XX_GBIF_HALT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_HALT(struct A6XX_GBIF_HALT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c45,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_HALT(...) pack_A6XX_GBIF_HALT(__struct_cast(A6XX_GBIF_HALT) { __VA_ARGS__ })

struct A6XX_GBIF_HALT_ACK {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_HALT_ACK(struct A6XX_GBIF_HALT_ACK fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c46,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_HALT_ACK(...) pack_A6XX_GBIF_HALT_ACK(__struct_cast(A6XX_GBIF_HALT_ACK) { __VA_ARGS__ })

struct A8XX_GBIF_REINIT_ENABLE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_REINIT_ENABLE(struct A8XX_GBIF_REINIT_ENABLE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c49,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_REINIT_ENABLE(...) pack_A8XX_GBIF_REINIT_ENABLE(__struct_cast(A8XX_GBIF_REINIT_ENABLE) { __VA_ARGS__ })

struct A8XX_GBIF_REINIT_DONE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_REINIT_DONE(struct A8XX_GBIF_REINIT_DONE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003c4a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_REINIT_DONE(...) pack_A8XX_GBIF_REINIT_DONE(__struct_cast(A8XX_GBIF_REINIT_DONE) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_PWR_CNT_EN {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_PERF_PWR_CNT_EN(struct A6XX_GBIF_PERF_PWR_CNT_EN fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_PWR_CNT_EN(...) pack_A6XX_GBIF_PERF_PWR_CNT_EN(__struct_cast(A6XX_GBIF_PERF_PWR_CNT_EN) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_PWR_CNT_CLR {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_PERF_PWR_CNT_CLR(struct A6XX_GBIF_PERF_PWR_CNT_CLR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_PWR_CNT_CLR(...) pack_A6XX_GBIF_PERF_PWR_CNT_CLR(__struct_cast(A6XX_GBIF_PERF_PWR_CNT_CLR) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_SEL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_SEL(struct A6XX_GBIF_PERF_CNT_SEL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_SEL(...) pack_A6XX_GBIF_PERF_CNT_SEL(__struct_cast(A6XX_GBIF_PERF_CNT_SEL) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_SEL_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_SEL_1(struct A8XX_GBIF_PERF_CNT_SEL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_SEL_1(...) pack_A8XX_GBIF_PERF_CNT_SEL_1(__struct_cast(A8XX_GBIF_PERF_CNT_SEL_1) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_PWR_CNT_SEL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_PWR_CNT_SEL(struct A6XX_GBIF_PERF_PWR_CNT_SEL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_PWR_CNT_SEL(...) pack_A6XX_GBIF_PERF_PWR_CNT_SEL(__struct_cast(A6XX_GBIF_PERF_PWR_CNT_SEL) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_LOW0(struct A6XX_GBIF_PERF_CNT_LOW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_LOW0(...) pack_A6XX_GBIF_PERF_CNT_LOW0(__struct_cast(A6XX_GBIF_PERF_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_LOW1(struct A6XX_GBIF_PERF_CNT_LOW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_LOW1(...) pack_A6XX_GBIF_PERF_CNT_LOW1(__struct_cast(A6XX_GBIF_PERF_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_LOW2(struct A6XX_GBIF_PERF_CNT_LOW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_LOW2(...) pack_A6XX_GBIF_PERF_CNT_LOW2(__struct_cast(A6XX_GBIF_PERF_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_LOW3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_LOW3(struct A6XX_GBIF_PERF_CNT_LOW3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_LOW3(...) pack_A6XX_GBIF_PERF_CNT_LOW3(__struct_cast(A6XX_GBIF_PERF_CNT_LOW3) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_HIGH0(struct A6XX_GBIF_PERF_CNT_HIGH0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_HIGH0(...) pack_A6XX_GBIF_PERF_CNT_HIGH0(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_HIGH1(struct A6XX_GBIF_PERF_CNT_HIGH1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_HIGH1(...) pack_A6XX_GBIF_PERF_CNT_HIGH1(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_HIGH2(struct A6XX_GBIF_PERF_CNT_HIGH2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cca,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_HIGH2(...) pack_A6XX_GBIF_PERF_CNT_HIGH2(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH2) { __VA_ARGS__ })

struct A6XX_GBIF_PERF_CNT_HIGH3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PERF_CNT_HIGH3(struct A6XX_GBIF_PERF_CNT_HIGH3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PERF_CNT_HIGH3(...) pack_A6XX_GBIF_PERF_CNT_HIGH3(__struct_cast(A6XX_GBIF_PERF_CNT_HIGH3) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_LOW0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PWR_CNT_LOW0(struct A6XX_GBIF_PWR_CNT_LOW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PWR_CNT_LOW0(...) pack_A6XX_GBIF_PWR_CNT_LOW0(__struct_cast(A6XX_GBIF_PWR_CNT_LOW0) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_LOW1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PWR_CNT_LOW1(struct A6XX_GBIF_PWR_CNT_LOW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PWR_CNT_LOW1(...) pack_A6XX_GBIF_PWR_CNT_LOW1(__struct_cast(A6XX_GBIF_PWR_CNT_LOW1) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_LOW2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PWR_CNT_LOW2(struct A6XX_GBIF_PWR_CNT_LOW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cce,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PWR_CNT_LOW2(...) pack_A6XX_GBIF_PWR_CNT_LOW2(__struct_cast(A6XX_GBIF_PWR_CNT_LOW2) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_HIGH0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PWR_CNT_HIGH0(struct A6XX_GBIF_PWR_CNT_HIGH0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccf,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PWR_CNT_HIGH0(...) pack_A6XX_GBIF_PWR_CNT_HIGH0(__struct_cast(A6XX_GBIF_PWR_CNT_HIGH0) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_HIGH1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PWR_CNT_HIGH1(struct A6XX_GBIF_PWR_CNT_HIGH1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PWR_CNT_HIGH1(...) pack_A6XX_GBIF_PWR_CNT_HIGH1(__struct_cast(A6XX_GBIF_PWR_CNT_HIGH1) { __VA_ARGS__ })

struct A6XX_GBIF_PWR_CNT_HIGH2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GBIF_PWR_CNT_HIGH2(struct A6XX_GBIF_PWR_CNT_HIGH2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GBIF_PWR_CNT_HIGH2(...) pack_A6XX_GBIF_PWR_CNT_HIGH2(__struct_cast(A6XX_GBIF_PWR_CNT_HIGH2) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_SEL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PWR_CNT_SEL(struct A8XX_GBIF_PWR_CNT_SEL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PWR_CNT_SEL(...) pack_A8XX_GBIF_PWR_CNT_SEL(__struct_cast(A8XX_GBIF_PWR_CNT_SEL) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_0(struct A8XX_GBIF_PERF_CNT_LO_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_0(...) pack_A8XX_GBIF_PERF_CNT_LO_0(__struct_cast(A8XX_GBIF_PERF_CNT_LO_0) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_0(struct A8XX_GBIF_PERF_CNT_HI_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_0(...) pack_A8XX_GBIF_PERF_CNT_HI_0(__struct_cast(A8XX_GBIF_PERF_CNT_HI_0) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_1(struct A8XX_GBIF_PERF_CNT_LO_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc8,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_1(...) pack_A8XX_GBIF_PERF_CNT_LO_1(__struct_cast(A8XX_GBIF_PERF_CNT_LO_1) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_1(struct A8XX_GBIF_PERF_CNT_HI_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cc9,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_1(...) pack_A8XX_GBIF_PERF_CNT_HI_1(__struct_cast(A8XX_GBIF_PERF_CNT_HI_1) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_2(struct A8XX_GBIF_PERF_CNT_LO_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cca,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_2(...) pack_A8XX_GBIF_PERF_CNT_LO_2(__struct_cast(A8XX_GBIF_PERF_CNT_LO_2) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_2(struct A8XX_GBIF_PERF_CNT_HI_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccb,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_2(...) pack_A8XX_GBIF_PERF_CNT_HI_2(__struct_cast(A8XX_GBIF_PERF_CNT_HI_2) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_3(struct A8XX_GBIF_PERF_CNT_LO_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccc,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_3(...) pack_A8XX_GBIF_PERF_CNT_LO_3(__struct_cast(A8XX_GBIF_PERF_CNT_LO_3) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_3(struct A8XX_GBIF_PERF_CNT_HI_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccd,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_3(...) pack_A8XX_GBIF_PERF_CNT_HI_3(__struct_cast(A8XX_GBIF_PERF_CNT_HI_3) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_4 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_4(struct A8XX_GBIF_PERF_CNT_LO_4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cce,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_4(...) pack_A8XX_GBIF_PERF_CNT_LO_4(__struct_cast(A8XX_GBIF_PERF_CNT_LO_4) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_4 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_4(struct A8XX_GBIF_PERF_CNT_HI_4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ccf,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_4(...) pack_A8XX_GBIF_PERF_CNT_HI_4(__struct_cast(A8XX_GBIF_PERF_CNT_HI_4) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_5 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_5(struct A8XX_GBIF_PERF_CNT_LO_5 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_5(...) pack_A8XX_GBIF_PERF_CNT_LO_5(__struct_cast(A8XX_GBIF_PERF_CNT_LO_5) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_5 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_5(struct A8XX_GBIF_PERF_CNT_HI_5 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_5(...) pack_A8XX_GBIF_PERF_CNT_HI_5(__struct_cast(A8XX_GBIF_PERF_CNT_HI_5) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_6 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_6(struct A8XX_GBIF_PERF_CNT_LO_6 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_6(...) pack_A8XX_GBIF_PERF_CNT_LO_6(__struct_cast(A8XX_GBIF_PERF_CNT_LO_6) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_6 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_6(struct A8XX_GBIF_PERF_CNT_HI_6 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_6(...) pack_A8XX_GBIF_PERF_CNT_HI_6(__struct_cast(A8XX_GBIF_PERF_CNT_HI_6) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_LO_7 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_LO_7(struct A8XX_GBIF_PERF_CNT_LO_7 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_LO_7(...) pack_A8XX_GBIF_PERF_CNT_LO_7(__struct_cast(A8XX_GBIF_PERF_CNT_LO_7) { __VA_ARGS__ })

struct A8XX_GBIF_PERF_CNT_HI_7 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PERF_CNT_HI_7(struct A8XX_GBIF_PERF_CNT_HI_7 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003cd5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PERF_CNT_HI_7(...) pack_A8XX_GBIF_PERF_CNT_HI_7(__struct_cast(A8XX_GBIF_PERF_CNT_HI_7) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_LO_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PWR_CNT_LO_0(struct A8XX_GBIF_PWR_CNT_LO_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ce0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PWR_CNT_LO_0(...) pack_A8XX_GBIF_PWR_CNT_LO_0(__struct_cast(A8XX_GBIF_PWR_CNT_LO_0) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_LO_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PWR_CNT_LO_1(struct A8XX_GBIF_PWR_CNT_LO_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ce1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PWR_CNT_LO_1(...) pack_A8XX_GBIF_PWR_CNT_LO_1(__struct_cast(A8XX_GBIF_PWR_CNT_LO_1) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_LO_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PWR_CNT_LO_2(struct A8XX_GBIF_PWR_CNT_LO_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ce2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PWR_CNT_LO_2(...) pack_A8XX_GBIF_PWR_CNT_LO_2(__struct_cast(A8XX_GBIF_PWR_CNT_LO_2) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_HI_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PWR_CNT_HI_0(struct A8XX_GBIF_PWR_CNT_HI_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ce3,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PWR_CNT_HI_0(...) pack_A8XX_GBIF_PWR_CNT_HI_0(__struct_cast(A8XX_GBIF_PWR_CNT_HI_0) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_HI_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PWR_CNT_HI_1(struct A8XX_GBIF_PWR_CNT_HI_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ce4,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PWR_CNT_HI_1(...) pack_A8XX_GBIF_PWR_CNT_HI_1(__struct_cast(A8XX_GBIF_PWR_CNT_HI_1) { __VA_ARGS__ })

struct A8XX_GBIF_PWR_CNT_HI_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GBIF_PWR_CNT_HI_2(struct A8XX_GBIF_PWR_CNT_HI_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00003ce5,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GBIF_PWR_CNT_HI_2(...) pack_A8XX_GBIF_PWR_CNT_HI_2(__struct_cast(A8XX_GBIF_PWR_CNT_HI_2) { __VA_ARGS__ })

struct A6XX_VSC_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_DBG_ECO_CNTL(struct A6XX_VSC_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_DBG_ECO_CNTL(...) pack_A6XX_VSC_DBG_ECO_CNTL(__struct_cast(A6XX_VSC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_VSC_KMD_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VSC_KMD_DBG_ECO_CNTL(struct A8XX_VSC_KMD_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000df0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VSC_KMD_DBG_ECO_CNTL(...) pack_A8XX_VSC_KMD_DBG_ECO_CNTL(__struct_cast(A8XX_VSC_KMD_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_VSC_BIN_SIZE {
    uint32_t							width;
    uint32_t							height;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_BIN_SIZE(struct A6XX_VSC_BIN_SIZE fields)
{
#ifndef NDEBUG
    assert(((fields.width >> 5)                      & 0xffffff00) == 0);
    assert(((fields.height >> 4)                     & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0x0001ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c02,
        .value =
            ((fields.width >> 5)                      <<  0) |
            ((fields.height >> 4)                     <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_BIN_SIZE(...) pack_A6XX_VSC_BIN_SIZE(__struct_cast(A6XX_VSC_BIN_SIZE) { __VA_ARGS__ })

struct A6XX_VSC_SIZE_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_SIZE_BASE(struct A6XX_VSC_SIZE_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c03,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_VSC_SIZE_BASE(...) pack_A6XX_VSC_SIZE_BASE(__struct_cast(A6XX_VSC_SIZE_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VSC_EXPANDED_BIN_CNTL {
    uint32_t							nx;
    uint32_t							ny;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_EXPANDED_BIN_CNTL(struct A6XX_VSC_EXPANDED_BIN_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.nx                                & 0xfffffc00) == 0);
    assert((fields.ny                                & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x001ffffe) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c06,
        .value =
            (fields.nx                                <<  1) |
            (fields.ny                                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_EXPANDED_BIN_CNTL(...) pack_A6XX_VSC_EXPANDED_BIN_CNTL(__struct_cast(A6XX_VSC_EXPANDED_BIN_CNTL) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_CONFIG_REG {
    uint32_t							x;
    uint32_t							y;
    uint32_t							w;
    uint32_t							h;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_CONFIG_REG(uint32_t __i, struct A6XX_VSC_PIPE_CONFIG_REG fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xfffffc00) == 0);
    assert((fields.y                                 & 0xfffffc00) == 0);
    assert((fields.w                                 & 0xffffffc0) == 0);
    assert((fields.h                                 & 0xffffffc0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000c10 + 0x1*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 10) |
            (fields.w                                 << 20) |
            (fields.h                                 << 26) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_CONFIG_REG(__i, ...) pack_A6XX_VSC_PIPE_CONFIG_REG(__i, __struct_cast(A6XX_VSC_PIPE_CONFIG_REG) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_PRIM_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_PRIM_BASE(struct A6XX_VSC_PIPE_DATA_PRIM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c30,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_VSC_PIPE_DATA_PRIM_BASE(...) pack_A6XX_VSC_PIPE_DATA_PRIM_BASE(__struct_cast(A6XX_VSC_PIPE_DATA_PRIM_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VSC_PIPE_DATA_PRIM_STRIDE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_PRIM_STRIDE(struct A6XX_VSC_PIPE_DATA_PRIM_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c32,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_PRIM_STRIDE(...) pack_A6XX_VSC_PIPE_DATA_PRIM_STRIDE(__struct_cast(A6XX_VSC_PIPE_DATA_PRIM_STRIDE) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_PRIM_LENGTH {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_PRIM_LENGTH(struct A6XX_VSC_PIPE_DATA_PRIM_LENGTH fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c33,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_PRIM_LENGTH(...) pack_A6XX_VSC_PIPE_DATA_PRIM_LENGTH(__struct_cast(A6XX_VSC_PIPE_DATA_PRIM_LENGTH) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_DRAW_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_DRAW_BASE(struct A6XX_VSC_PIPE_DATA_DRAW_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c34,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_VSC_PIPE_DATA_DRAW_BASE(...) pack_A6XX_VSC_PIPE_DATA_DRAW_BASE(__struct_cast(A6XX_VSC_PIPE_DATA_DRAW_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VSC_PIPE_DATA_DRAW_STRIDE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_DRAW_STRIDE(struct A6XX_VSC_PIPE_DATA_DRAW_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c36,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_DRAW_STRIDE(...) pack_A6XX_VSC_PIPE_DATA_DRAW_STRIDE(__struct_cast(A6XX_VSC_PIPE_DATA_DRAW_STRIDE) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_DRAW_LENGTH {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_DRAW_LENGTH(struct A6XX_VSC_PIPE_DATA_DRAW_LENGTH fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000c37,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_DRAW_LENGTH(...) pack_A6XX_VSC_PIPE_DATA_DRAW_LENGTH(__struct_cast(A6XX_VSC_PIPE_DATA_DRAW_LENGTH) { __VA_ARGS__ })

struct A6XX_VSC_CHANNEL_VISIBILITY_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_VSC_CHANNEL_VISIBILITY_REG(uint32_t __i, struct A6XX_VSC_CHANNEL_VISIBILITY_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000c38 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_CHANNEL_VISIBILITY_REG(__i, ...) pack_A6XX_VSC_CHANNEL_VISIBILITY_REG(__i, __struct_cast(A6XX_VSC_CHANNEL_VISIBILITY_REG) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG(uint32_t __i, struct A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000c58 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG(__i, ...) pack_A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG(__i, __struct_cast(A6XX_VSC_PIPE_DATA_PRIM_SIZE_REG) { __VA_ARGS__ })

struct A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG(uint32_t __i, struct A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00000c78 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG(__i, ...) pack_A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG(__i, __struct_cast(A6XX_VSC_PIPE_DATA_DRAW_SIZE_REG) { __VA_ARGS__ })

struct A7XX_VSC_UNKNOWN_0D08 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VSC_UNKNOWN_0D08(struct A7XX_VSC_UNKNOWN_0D08 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000d08,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_VSC_UNKNOWN_0D08(...) pack_A7XX_VSC_UNKNOWN_0D08(__struct_cast(A7XX_VSC_UNKNOWN_0D08) { __VA_ARGS__ })

struct A7XX_UCHE_UNKNOWN_0E10 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_UCHE_UNKNOWN_0E10(struct A7XX_UCHE_UNKNOWN_0E10 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e10,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_UCHE_UNKNOWN_0E10(...) pack_A7XX_UCHE_UNKNOWN_0E10(__struct_cast(A7XX_UCHE_UNKNOWN_0E10) { __VA_ARGS__ })

struct A8XX_UCHE_VARB_IDLE_TIMEOUT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_VARB_IDLE_TIMEOUT(struct A8XX_UCHE_VARB_IDLE_TIMEOUT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e10,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_VARB_IDLE_TIMEOUT(...) pack_A8XX_UCHE_VARB_IDLE_TIMEOUT(__struct_cast(A8XX_UCHE_VARB_IDLE_TIMEOUT) { __VA_ARGS__ })

struct A7XX_UCHE_UNKNOWN_0E11 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_UCHE_UNKNOWN_0E11(struct A7XX_UCHE_UNKNOWN_0E11 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e11,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_UCHE_UNKNOWN_0E11(...) pack_A7XX_UCHE_UNKNOWN_0E11(__struct_cast(A7XX_UCHE_UNKNOWN_0E11) { __VA_ARGS__ })

struct A8XX_UCHE_CLIENT_PF {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_CLIENT_PF(struct A8XX_UCHE_CLIENT_PF fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e11,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_CLIENT_PF(...) pack_A8XX_UCHE_CLIENT_PF(__struct_cast(A8XX_UCHE_CLIENT_PF) { __VA_ARGS__ })

struct A6XX_UCHE_UNKNOWN_0E12 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_UCHE_UNKNOWN_0E12(struct A6XX_UCHE_UNKNOWN_0E12 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e12,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_UCHE_UNKNOWN_0E12(...) pack_A6XX_UCHE_UNKNOWN_0E12(__struct_cast(A6XX_UCHE_UNKNOWN_0E12) { __VA_ARGS__ })

struct A8XX_UCHE_DBG_ECO_CNTL_0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_DBG_ECO_CNTL_0(struct A8XX_UCHE_DBG_ECO_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e15,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_DBG_ECO_CNTL_0(...) pack_A8XX_UCHE_DBG_ECO_CNTL_0(__struct_cast(A8XX_UCHE_DBG_ECO_CNTL_0) { __VA_ARGS__ })

struct A8XX_UCHE_HW_DBG_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_UCHE_HW_DBG_CNTL(struct A8XX_UCHE_HW_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00000e16,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_UCHE_HW_DBG_CNTL(...) pack_A8XX_UCHE_HW_DBG_CNTL(__struct_cast(A8XX_UCHE_HW_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_CL_CNTL {
    bool							clip_disable;
    bool							znear_clip_disable;
    bool							zfar_clip_disable;
    bool							z_clamp_enable;
    bool							zero_gb_scale_z;
    bool							vp_clip_code_ignore;
    bool							vp_xform_disable;
    bool							persp_division_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_CNTL(struct A6XX_GRAS_CL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x000003e7) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008000,
        .value =
            (fields.clip_disable                      <<  0) |
            (fields.znear_clip_disable                <<  1) |
            (fields.zfar_clip_disable                 <<  2) |
            (fields.z_clamp_enable                    <<  5) |
            (fields.zero_gb_scale_z                   <<  6) |
            (fields.vp_clip_code_ignore               <<  7) |
            (fields.vp_xform_disable                  <<  8) |
            (fields.persp_division_disable            <<  9) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_CNTL(...) pack_A6XX_GRAS_CL_CNTL(__struct_cast(A6XX_GRAS_CL_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_CL_CNTL {
    bool							clip_disable;
    bool							znear_clip_disable;
    bool							zfar_clip_disable;
    bool							z_clamp_enable;
    bool							zero_gb_scale_z;
    bool							vp_clip_code_ignore;
    bool							vp_xform_disable;
    bool							persp_division_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_CNTL(struct A8XX_GRAS_CL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x000003e7) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008200,
        .value =
            (fields.clip_disable                      <<  0) |
            (fields.znear_clip_disable                <<  1) |
            (fields.zfar_clip_disable                 <<  2) |
            (fields.z_clamp_enable                    <<  5) |
            (fields.zero_gb_scale_z                   <<  6) |
            (fields.vp_clip_code_ignore               <<  7) |
            (fields.vp_xform_disable                  <<  8) |
            (fields.persp_division_disable            <<  9) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_CNTL(...) pack_A8XX_GRAS_CL_CNTL(__struct_cast(A8XX_GRAS_CL_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(struct A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.cull_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008001,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.cull_mask                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(...) pack_A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(__struct_cast(A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(struct A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.cull_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008002,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.cull_mask                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(...) pack_A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(__struct_cast(A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(struct A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.cull_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008003,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.cull_mask                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(...) pack_A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(__struct_cast(A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_ARRAY_SIZE {
    uint32_t							gras_cl_array_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_ARRAY_SIZE(struct A6XX_GRAS_CL_ARRAY_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.gras_cl_array_size                & 0xfffff800) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008004,
        .value =
            (fields.gras_cl_array_size                <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_ARRAY_SIZE(...) pack_A6XX_GRAS_CL_ARRAY_SIZE(__struct_cast(A6XX_GRAS_CL_ARRAY_SIZE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(struct A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.cull_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008201,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.cull_mask                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(...) pack_A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE(__struct_cast(A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(struct A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.cull_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008202,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.cull_mask                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(...) pack_A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE(__struct_cast(A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE {
    uint32_t							clip_mask;
    uint32_t							cull_mask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(struct A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.cull_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008203,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.cull_mask                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(...) pack_A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE(__struct_cast(A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_ARRAY_SIZE {
    uint32_t							gras_cl_array_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_ARRAY_SIZE(struct A8XX_GRAS_CL_ARRAY_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.gras_cl_array_size                & 0xfffff800) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008204,
        .value =
            (fields.gras_cl_array_size                <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_ARRAY_SIZE(...) pack_A8XX_GRAS_CL_ARRAY_SIZE(__struct_cast(A8XX_GRAS_CL_ARRAY_SIZE) { __VA_ARGS__ })

struct A8XX_GRAS_UNKNOWN_8228 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_UNKNOWN_8228(struct A8XX_GRAS_UNKNOWN_8228 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008228,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_UNKNOWN_8228(...) pack_A8XX_GRAS_UNKNOWN_8228(__struct_cast(A8XX_GRAS_UNKNOWN_8228) { __VA_ARGS__ })

struct A8XX_GRAS_UNKNOWN_8229 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_UNKNOWN_8229(struct A8XX_GRAS_UNKNOWN_8229 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008229,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_UNKNOWN_8229(...) pack_A8XX_GRAS_UNKNOWN_8229(__struct_cast(A8XX_GRAS_UNKNOWN_8229) { __VA_ARGS__ })

struct A8XX_GRAS_UNKNOWN_822A {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_UNKNOWN_822A(struct A8XX_GRAS_UNKNOWN_822A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000822a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_UNKNOWN_822A(...) pack_A8XX_GRAS_UNKNOWN_822A(__struct_cast(A8XX_GRAS_UNKNOWN_822A) { __VA_ARGS__ })

struct A8XX_GRAS_UNKNOWN_822B {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_UNKNOWN_822B(struct A8XX_GRAS_UNKNOWN_822B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000822b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_UNKNOWN_822B(...) pack_A8XX_GRAS_UNKNOWN_822B(__struct_cast(A8XX_GRAS_UNKNOWN_822B) { __VA_ARGS__ })

struct A8XX_GRAS_UNKNOWN_822C {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_UNKNOWN_822C(struct A8XX_GRAS_UNKNOWN_822C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000822c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_UNKNOWN_822C(...) pack_A8XX_GRAS_UNKNOWN_822C(__struct_cast(A8XX_GRAS_UNKNOWN_822C) { __VA_ARGS__ })

struct A8XX_GRAS_UNKNOWN_822D {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_UNKNOWN_822D(struct A8XX_GRAS_UNKNOWN_822D fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000822d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_UNKNOWN_822D(...) pack_A8XX_GRAS_UNKNOWN_822D(__struct_cast(A8XX_GRAS_UNKNOWN_822D) { __VA_ARGS__ })

struct A6XX_GRAS_CL_INTERP_CNTL {
    bool							ij_persp_pixel;
    bool							ij_persp_centroid;
    bool							ij_persp_sample;
    bool							ij_linear_pixel;
    bool							ij_linear_centroid;
    bool							ij_linear_sample;
    uint32_t							coord_mask;
    bool							unk10;
    bool							unk11;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_INTERP_CNTL(struct A6XX_GRAS_CL_INTERP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.coord_mask                        & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008005,
        .value =
            (fields.ij_persp_pixel                    <<  0) |
            (fields.ij_persp_centroid                 <<  1) |
            (fields.ij_persp_sample                   <<  2) |
            (fields.ij_linear_pixel                   <<  3) |
            (fields.ij_linear_centroid                <<  4) |
            (fields.ij_linear_sample                  <<  5) |
            (fields.coord_mask                        <<  6) |
            (fields.unk10                             << 10) |
            (fields.unk11                             << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_INTERP_CNTL(...) pack_A6XX_GRAS_CL_INTERP_CNTL(__struct_cast(A6XX_GRAS_CL_INTERP_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_CL_INTERP_CNTL {
    bool							ij_persp_pixel;
    bool							ij_persp_centroid;
    bool							ij_persp_sample;
    bool							ij_linear_pixel;
    bool							ij_linear_centroid;
    bool							ij_linear_sample;
    uint32_t							coord_mask;
    bool							unk10;
    bool							unk11;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_INTERP_CNTL(struct A8XX_GRAS_CL_INTERP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.coord_mask                        & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008080,
        .value =
            (fields.ij_persp_pixel                    <<  0) |
            (fields.ij_persp_centroid                 <<  1) |
            (fields.ij_persp_sample                   <<  2) |
            (fields.ij_linear_pixel                   <<  3) |
            (fields.ij_linear_centroid                <<  4) |
            (fields.ij_linear_sample                  <<  5) |
            (fields.coord_mask                        <<  6) |
            (fields.unk10                             << 10) |
            (fields.unk11                             << 11) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_INTERP_CNTL(...) pack_A8XX_GRAS_CL_INTERP_CNTL(__struct_cast(A8XX_GRAS_CL_INTERP_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT {
    bool							binscaleen;
    enum a7xx_bin_scale						xscale_0;
    enum a7xx_bin_scale						yscale_0;
    enum a7xx_bin_scale						xscale_1;
    enum a7xx_bin_scale						yscale_1;
    enum a7xx_bin_scale						xscale_2;
    enum a7xx_bin_scale						yscale_2;
    enum a7xx_bin_scale						xscale_3;
    enum a7xx_bin_scale						yscale_3;
    enum a7xx_bin_scale						xscale_4;
    enum a7xx_bin_scale						yscale_4;
    enum a7xx_bin_scale						xscale_5;
    enum a7xx_bin_scale						yscale_5;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_BIN_FOVEAT(struct A7XX_GRAS_BIN_FOVEAT fields)
{
#ifndef NDEBUG
    assert((fields.xscale_0                          & 0xfffffffc) == 0);
    assert((fields.yscale_0                          & 0xfffffffc) == 0);
    assert((fields.xscale_1                          & 0xfffffffc) == 0);
    assert((fields.yscale_1                          & 0xfffffffc) == 0);
    assert((fields.xscale_2                          & 0xfffffffc) == 0);
    assert((fields.yscale_2                          & 0xfffffffc) == 0);
    assert((fields.xscale_3                          & 0xfffffffc) == 0);
    assert((fields.yscale_3                          & 0xfffffffc) == 0);
    assert((fields.xscale_4                          & 0xfffffffc) == 0);
    assert((fields.yscale_4                          & 0xfffffffc) == 0);
    assert((fields.xscale_5                          & 0xfffffffc) == 0);
    assert((fields.yscale_5                          & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0xffffff40) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008008,
        .value =
            (fields.binscaleen                        <<  6) |
            (fields.xscale_0                          <<  8) |
            (fields.yscale_0                          << 10) |
            (fields.xscale_1                          << 12) |
            (fields.yscale_1                          << 14) |
            (fields.xscale_2                          << 16) |
            (fields.yscale_2                          << 18) |
            (fields.xscale_3                          << 20) |
            (fields.yscale_3                          << 22) |
            (fields.xscale_4                          << 24) |
            (fields.yscale_4                          << 26) |
            (fields.xscale_5                          << 28) |
            (fields.yscale_5                          << 30) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_BIN_FOVEAT(...) pack_A7XX_GRAS_BIN_FOVEAT(__struct_cast(A7XX_GRAS_BIN_FOVEAT) { __VA_ARGS__ })

struct A8XX_GRAS_BIN_FOVEAT {
    bool							binscaleen;
    enum a7xx_bin_scale						xscale_0;
    enum a7xx_bin_scale						yscale_0;
    enum a7xx_bin_scale						xscale_1;
    enum a7xx_bin_scale						yscale_1;
    enum a7xx_bin_scale						xscale_2;
    enum a7xx_bin_scale						yscale_2;
    enum a7xx_bin_scale						xscale_3;
    enum a7xx_bin_scale						yscale_3;
    enum a7xx_bin_scale						xscale_4;
    enum a7xx_bin_scale						yscale_4;
    enum a7xx_bin_scale						xscale_5;
    enum a7xx_bin_scale						yscale_5;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_BIN_FOVEAT(struct A8XX_GRAS_BIN_FOVEAT fields)
{
#ifndef NDEBUG
    assert((fields.xscale_0                          & 0xfffffffc) == 0);
    assert((fields.yscale_0                          & 0xfffffffc) == 0);
    assert((fields.xscale_1                          & 0xfffffffc) == 0);
    assert((fields.yscale_1                          & 0xfffffffc) == 0);
    assert((fields.xscale_2                          & 0xfffffffc) == 0);
    assert((fields.yscale_2                          & 0xfffffffc) == 0);
    assert((fields.xscale_3                          & 0xfffffffc) == 0);
    assert((fields.yscale_3                          & 0xfffffffc) == 0);
    assert((fields.xscale_4                          & 0xfffffffc) == 0);
    assert((fields.yscale_4                          & 0xfffffffc) == 0);
    assert((fields.xscale_5                          & 0xfffffffc) == 0);
    assert((fields.yscale_5                          & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0xffffff40) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008206,
        .value =
            (fields.binscaleen                        <<  6) |
            (fields.xscale_0                          <<  8) |
            (fields.yscale_0                          << 10) |
            (fields.xscale_1                          << 12) |
            (fields.yscale_1                          << 14) |
            (fields.xscale_2                          << 16) |
            (fields.yscale_2                          << 18) |
            (fields.xscale_3                          << 20) |
            (fields.yscale_3                          << 22) |
            (fields.xscale_4                          << 24) |
            (fields.yscale_4                          << 26) |
            (fields.xscale_5                          << 28) |
            (fields.yscale_5                          << 30) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_BIN_FOVEAT(...) pack_A8XX_GRAS_BIN_FOVEAT(__struct_cast(A8XX_GRAS_BIN_FOVEAT) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_0 {
    uint32_t							xoffset_0;
    uint32_t							xoffset_1;
    uint32_t							xoffset_2;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_0(struct A7XX_GRAS_BIN_FOVEAT_OFFSET_0 fields)
{
#ifndef NDEBUG
    assert(((fields.xoffset_0 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.xoffset_1 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.xoffset_2 >> 2)                  & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x3fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008009,
        .value =
            ((fields.xoffset_0 >> 2)                  <<  0) |
            ((fields.xoffset_1 >> 2)                  << 10) |
            ((fields.xoffset_2 >> 2)                  << 20) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_0(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_0) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_1 {
    uint32_t							xoffset_3;
    uint32_t							xoffset_4;
    uint32_t							xoffset_5;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_1(struct A7XX_GRAS_BIN_FOVEAT_OFFSET_1 fields)
{
#ifndef NDEBUG
    assert(((fields.xoffset_3 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.xoffset_4 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.xoffset_5 >> 2)                  & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x3fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000800a,
        .value =
            ((fields.xoffset_3 >> 2)                  <<  0) |
            ((fields.xoffset_4 >> 2)                  << 10) |
            ((fields.xoffset_5 >> 2)                  << 20) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_1(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_1) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_2 {
    uint32_t							yoffset_0;
    uint32_t							yoffset_1;
    uint32_t							yoffset_2;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_2(struct A7XX_GRAS_BIN_FOVEAT_OFFSET_2 fields)
{
#ifndef NDEBUG
    assert(((fields.yoffset_0 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.yoffset_1 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.yoffset_2 >> 2)                  & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x3fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000800b,
        .value =
            ((fields.yoffset_0 >> 2)                  <<  0) |
            ((fields.yoffset_1 >> 2)                  << 10) |
            ((fields.yoffset_2 >> 2)                  << 20) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_2(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_2) { __VA_ARGS__ })

struct A7XX_GRAS_BIN_FOVEAT_OFFSET_3 {
    uint32_t							yoffset_3;
    uint32_t							yoffset_4;
    uint32_t							yoffset_5;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_3(struct A7XX_GRAS_BIN_FOVEAT_OFFSET_3 fields)
{
#ifndef NDEBUG
    assert(((fields.yoffset_3 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.yoffset_4 >> 2)                  & 0xfffffc00) == 0);
    assert(((fields.yoffset_5 >> 2)                  & 0xfffffc00) == 0);
    assert((fields.unknown                           & 0x3fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000800c,
        .value =
            ((fields.yoffset_3 >> 2)                  <<  0) |
            ((fields.yoffset_4 >> 2)                  << 10) |
            ((fields.yoffset_5 >> 2)                  << 20) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3(...) pack_A7XX_GRAS_BIN_FOVEAT_OFFSET_3(__struct_cast(A7XX_GRAS_BIN_FOVEAT_OFFSET_3) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_XOFFSET {
    float							gras_cl_viewport_xoffset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_XOFFSET(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_XOFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_xoffset)     & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008010 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_xoffset)     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_XOFFSET(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_XOFFSET(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_XOFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_XSCALE {
    float							gras_cl_viewport_xscale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_XSCALE(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_XSCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_xscale)      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008011 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_xscale)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_XSCALE(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_XSCALE(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_XSCALE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_YOFFSET {
    float							gras_cl_viewport_yoffset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_YOFFSET(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_YOFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_yoffset)     & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008012 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_yoffset)     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_YOFFSET(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_YOFFSET(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_YOFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_YSCALE {
    float							gras_cl_viewport_yscale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_YSCALE(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_YSCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_yscale)      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008013 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_yscale)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_YSCALE(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_YSCALE(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_YSCALE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZOFFSET {
    float							gras_cl_viewport_zoffset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_ZOFFSET(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_ZOFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zoffset)     & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008014 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_zoffset)     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZOFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZSCALE {
    float							gras_cl_viewport_zscale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_ZSCALE(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_ZSCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zscale)      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008015 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_zscale)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_ZSCALE(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZSCALE(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZSCALE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_XOFFSET {
    float							gras_cl_viewport_xoffset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_XOFFSET(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_XOFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_xoffset)     & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000082d0 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_xoffset)     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_XOFFSET(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_XOFFSET(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_XOFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_XSCALE {
    float							gras_cl_viewport_xscale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_XSCALE(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_XSCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_xscale)      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000082d1 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_xscale)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_XSCALE(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_XSCALE(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_XSCALE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_YOFFSET {
    float							gras_cl_viewport_yoffset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_YOFFSET(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_YOFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_yoffset)     & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000082d2 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_yoffset)     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_YOFFSET(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_YOFFSET(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_YOFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_YSCALE {
    float							gras_cl_viewport_yscale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_YSCALE(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_YSCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_yscale)      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000082d3 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_yscale)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_YSCALE(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_YSCALE(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_YSCALE) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZOFFSET {
    float							gras_cl_viewport_zoffset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_ZOFFSET(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_ZOFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zoffset)     & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000082d4 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_zoffset)     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZOFFSET(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZOFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZSCALE {
    float							gras_cl_viewport_zscale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_ZSCALE(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_ZSCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zscale)      & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000082d5 + 0x6*__i),
        .value =
            (fui(fields.gras_cl_viewport_zscale)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_ZSCALE(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZSCALE(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZSCALE) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN {
    float							gras_cl_viewport_zclamp_min;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zclamp_min)  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008070 + 0x2*__i),
        .value =
            (fui(fields.gras_cl_viewport_zclamp_min)  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN) { __VA_ARGS__ })

struct A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX {
    float							gras_cl_viewport_zclamp_max;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(uint32_t __i, struct A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zclamp_max)  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008071 + 0x2*__i),
        .value =
            (fui(fields.gras_cl_viewport_zclamp_max)  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, ...) pack_A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, __struct_cast(A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN {
    float							gras_cl_viewport_zclamp_min;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zclamp_min)  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000080c0 + 0x2*__i),
        .value =
            (fui(fields.gras_cl_viewport_zclamp_min)  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN) { __VA_ARGS__ })

struct A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX {
    float							gras_cl_viewport_zclamp_max;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(uint32_t __i, struct A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_cl_viewport_zclamp_max)  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000080c1 + 0x2*__i),
        .value =
            (fui(fields.gras_cl_viewport_zclamp_max)  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, ...) pack_A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(__i, __struct_cast(A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX) { __VA_ARGS__ })

struct A8XX_GRAS_SU_STEREO_CNTL {
    bool							rendertargetindexincr;
    bool							viewportindexincr;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_STEREO_CNTL(struct A8XX_GRAS_SU_STEREO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x000c0000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000820c,
        .value =
            (fields.rendertargetindexincr             << 18) |
            (fields.viewportindexincr                 << 19) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_STEREO_CNTL(...) pack_A8XX_GRAS_SU_STEREO_CNTL(__struct_cast(A8XX_GRAS_SU_STEREO_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POINT_MINMAX {
    float							min;
    float							max;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_POINT_MINMAX(struct A6XX_GRAS_SU_POINT_MINMAX fields)
{
#ifndef NDEBUG
    assert((((uint32_t)(fields.min * 16.0))          & 0xffff0000) == 0);
    assert((((uint32_t)(fields.max * 16.0))          & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008091,
        .value =
            (((uint32_t)(fields.min * 16.0))          <<  0) |
            (((uint32_t)(fields.max * 16.0))          << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_POINT_MINMAX(...) pack_A6XX_GRAS_SU_POINT_MINMAX(__struct_cast(A6XX_GRAS_SU_POINT_MINMAX) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POINT_MINMAX {
    float							min;
    float							max;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_POINT_MINMAX(struct A8XX_GRAS_SU_POINT_MINMAX fields)
{
#ifndef NDEBUG
    assert((((uint32_t)(fields.min * 16.0))          & 0xffff0000) == 0);
    assert((((uint32_t)(fields.max * 16.0))          & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000820a,
        .value =
            (((uint32_t)(fields.min * 16.0))          <<  0) |
            (((uint32_t)(fields.max * 16.0))          << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_POINT_MINMAX(...) pack_A8XX_GRAS_SU_POINT_MINMAX(__struct_cast(A8XX_GRAS_SU_POINT_MINMAX) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POINT_SIZE {
    float							gras_su_point_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_POINT_SIZE(struct A6XX_GRAS_SU_POINT_SIZE fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.gras_su_point_size * 16.0)) & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008092,
        .value =
            (((int32_t)(fields.gras_su_point_size * 16.0)) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_POINT_SIZE(...) pack_A6XX_GRAS_SU_POINT_SIZE(__struct_cast(A6XX_GRAS_SU_POINT_SIZE) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POINT_SIZE {
    float							gras_su_point_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_POINT_SIZE(struct A8XX_GRAS_SU_POINT_SIZE fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.gras_su_point_size * 16.0)) & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000820b,
        .value =
            (((int32_t)(fields.gras_su_point_size * 16.0)) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_POINT_SIZE(...) pack_A8XX_GRAS_SU_POINT_SIZE(__struct_cast(A8XX_GRAS_SU_POINT_SIZE) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DEPTH_CNTL {
    bool							z_test_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_DEPTH_CNTL(struct A6XX_GRAS_SU_DEPTH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008114,
        .value =
            (fields.z_test_enable                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_DEPTH_CNTL(...) pack_A6XX_GRAS_SU_DEPTH_CNTL(__struct_cast(A6XX_GRAS_SU_DEPTH_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DEPTH_CNTL {
    bool							z_test_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_DEPTH_CNTL(struct A8XX_GRAS_SU_DEPTH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008086,
        .value =
            (fields.z_test_enable                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_DEPTH_CNTL(...) pack_A8XX_GRAS_SU_DEPTH_CNTL(__struct_cast(A8XX_GRAS_SU_DEPTH_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_STENCIL_CNTL {
    bool							stencil_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_STENCIL_CNTL(struct A6XX_GRAS_SU_STENCIL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008115,
        .value =
            (fields.stencil_enable                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_STENCIL_CNTL(...) pack_A6XX_GRAS_SU_STENCIL_CNTL(__struct_cast(A6XX_GRAS_SU_STENCIL_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_STENCIL_CNTL {
    bool							stencil_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_STENCIL_CNTL(struct A8XX_GRAS_SU_STENCIL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008087,
        .value =
            (fields.stencil_enable                    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_STENCIL_CNTL(...) pack_A8XX_GRAS_SU_STENCIL_CNTL(__struct_cast(A8XX_GRAS_SU_STENCIL_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_SU_RENDER_CNTL {
    bool							fs_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_SU_RENDER_CNTL(struct A7XX_GRAS_SU_RENDER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000080) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008116,
        .value =
            (fields.fs_disable                        <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_SU_RENDER_CNTL(...) pack_A7XX_GRAS_SU_RENDER_CNTL(__struct_cast(A7XX_GRAS_SU_RENDER_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_RENDER_CNTL {
    bool							fs_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_RENDER_CNTL(struct A8XX_GRAS_SU_RENDER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000080) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008088,
        .value =
            (fields.fs_disable                        <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_RENDER_CNTL(...) pack_A8XX_GRAS_SU_RENDER_CNTL(__struct_cast(A8XX_GRAS_SU_RENDER_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DEPTH_PLANE_CNTL {
    enum a6xx_ztest_mode					z_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_DEPTH_PLANE_CNTL(struct A6XX_GRAS_SU_DEPTH_PLANE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.z_mode                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008094,
        .value =
            (fields.z_mode                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_DEPTH_PLANE_CNTL(...) pack_A6XX_GRAS_SU_DEPTH_PLANE_CNTL(__struct_cast(A6XX_GRAS_SU_DEPTH_PLANE_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DEPTH_PLANE_CNTL {
    enum a6xx_ztest_mode					z_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_DEPTH_PLANE_CNTL(struct A8XX_GRAS_SU_DEPTH_PLANE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.z_mode                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008089,
        .value =
            (fields.z_mode                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_DEPTH_PLANE_CNTL(...) pack_A8XX_GRAS_SU_DEPTH_PLANE_CNTL(__struct_cast(A8XX_GRAS_SU_DEPTH_PLANE_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POLY_OFFSET_SCALE {
    float							gras_su_poly_offset_scale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_POLY_OFFSET_SCALE(struct A6XX_GRAS_SU_POLY_OFFSET_SCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_su_poly_offset_scale)    & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008095,
        .value =
            (fui(fields.gras_su_poly_offset_scale)    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_POLY_OFFSET_SCALE(...) pack_A6XX_GRAS_SU_POLY_OFFSET_SCALE(__struct_cast(A6XX_GRAS_SU_POLY_OFFSET_SCALE) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POLY_OFFSET_SCALE {
    float							gras_su_poly_offset_scale;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_POLY_OFFSET_SCALE(struct A8XX_GRAS_SU_POLY_OFFSET_SCALE fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_su_poly_offset_scale)    & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000808a,
        .value =
            (fui(fields.gras_su_poly_offset_scale)    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_POLY_OFFSET_SCALE(...) pack_A8XX_GRAS_SU_POLY_OFFSET_SCALE(__struct_cast(A8XX_GRAS_SU_POLY_OFFSET_SCALE) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POLY_OFFSET_OFFSET {
    float							gras_su_poly_offset_offset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_POLY_OFFSET_OFFSET(struct A6XX_GRAS_SU_POLY_OFFSET_OFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_su_poly_offset_offset)   & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008096,
        .value =
            (fui(fields.gras_su_poly_offset_offset)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET(...) pack_A6XX_GRAS_SU_POLY_OFFSET_OFFSET(__struct_cast(A6XX_GRAS_SU_POLY_OFFSET_OFFSET) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POLY_OFFSET_OFFSET {
    float							gras_su_poly_offset_offset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_POLY_OFFSET_OFFSET(struct A8XX_GRAS_SU_POLY_OFFSET_OFFSET fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_su_poly_offset_offset)   & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000808b,
        .value =
            (fui(fields.gras_su_poly_offset_offset)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET(...) pack_A8XX_GRAS_SU_POLY_OFFSET_OFFSET(__struct_cast(A8XX_GRAS_SU_POLY_OFFSET_OFFSET) { __VA_ARGS__ })

struct A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP {
    float							gras_su_poly_offset_offset_clamp;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(struct A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_su_poly_offset_offset_clamp) & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008097,
        .value =
            (fui(fields.gras_su_poly_offset_offset_clamp) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(...) pack_A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(__struct_cast(A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP) { __VA_ARGS__ })

struct A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP {
    float							gras_su_poly_offset_offset_clamp;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(struct A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_su_poly_offset_offset_clamp) & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000808c,
        .value =
            (fui(fields.gras_su_poly_offset_offset_clamp) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(...) pack_A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(__struct_cast(A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_DEPTH_BUFFER_INFO(struct A6XX_GRAS_SU_DEPTH_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.depth_format                      & 0xfffffff8) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008098,
        .value =
            (fields.depth_format                      <<  0) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_DEPTH_BUFFER_INFO(...) pack_A6XX_GRAS_SU_DEPTH_BUFFER_INFO(__struct_cast(A6XX_GRAS_SU_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_DEPTH_BUFFER_INFO(struct A8XX_GRAS_SU_DEPTH_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.depth_format                      & 0xfffffff8) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000808d,
        .value =
            (fields.depth_format                      <<  0) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_DEPTH_BUFFER_INFO(...) pack_A8XX_GRAS_SU_DEPTH_BUFFER_INFO(__struct_cast(A8XX_GRAS_SU_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    enum a6xx_shift_amount					shiftamount;
    bool							innerconservativerasen;
    uint32_t							unk4;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(struct A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.shiftamount                       & 0xfffffffc) == 0);
    assert((fields.unk4                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000003f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008099,
        .value =
            (fields.conservativerasen                 <<  0) |
            (fields.shiftamount                       <<  1) |
            (fields.innerconservativerasen            <<  3) |
            (fields.unk4                              <<  4) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(...) pack_A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    enum a6xx_shift_amount					shiftamount;
    bool							innerconservativerasen;
    uint32_t							unk4;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(struct A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.shiftamount                       & 0xfffffffc) == 0);
    assert((fields.unk4                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000003f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000820d,
        .value =
            (fields.conservativerasen                 <<  0) |
            (fields.shiftamount                       <<  1) |
            (fields.innerconservativerasen            <<  3) |
            (fields.unk4                              <<  4) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(...) pack_A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_PATH_RENDERING_CNTL {
    bool							unk0;
    bool							linelengthen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GRAS_SU_PATH_RENDERING_CNTL(struct A6XX_GRAS_SU_PATH_RENDERING_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000809a,
        .value =
            (fields.unk0                              <<  0) |
            (fields.linelengthen                      <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_PATH_RENDERING_CNTL(...) pack_A6XX_GRAS_SU_PATH_RENDERING_CNTL(__struct_cast(A6XX_GRAS_SU_PATH_RENDERING_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_VS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_VS_SIV_CNTL(struct A6XX_GRAS_SU_VS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000809b,
        .value =
            (fields.writes_layer                      <<  0) |
            (fields.writes_view                       <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_VS_SIV_CNTL(...) pack_A6XX_GRAS_SU_VS_SIV_CNTL(__struct_cast(A6XX_GRAS_SU_VS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_GS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_GS_SIV_CNTL(struct A6XX_GRAS_SU_GS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000809c,
        .value =
            (fields.writes_layer                      <<  0) |
            (fields.writes_view                       <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_GS_SIV_CNTL(...) pack_A6XX_GRAS_SU_GS_SIV_CNTL(__struct_cast(A6XX_GRAS_SU_GS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SU_DS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SU_DS_SIV_CNTL(struct A6XX_GRAS_SU_DS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000809d,
        .value =
            (fields.writes_layer                      <<  0) |
            (fields.writes_view                       <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SU_DS_SIV_CNTL(...) pack_A6XX_GRAS_SU_DS_SIV_CNTL(__struct_cast(A6XX_GRAS_SU_DS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_VS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_VS_SIV_CNTL(struct A8XX_GRAS_SU_VS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000820e,
        .value =
            (fields.writes_layer                      <<  0) |
            (fields.writes_view                       <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_VS_SIV_CNTL(...) pack_A8XX_GRAS_SU_VS_SIV_CNTL(__struct_cast(A8XX_GRAS_SU_VS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_GS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_GS_SIV_CNTL(struct A8XX_GRAS_SU_GS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000820f,
        .value =
            (fields.writes_layer                      <<  0) |
            (fields.writes_view                       <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_GS_SIV_CNTL(...) pack_A8XX_GRAS_SU_GS_SIV_CNTL(__struct_cast(A8XX_GRAS_SU_GS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SU_DS_SIV_CNTL {
    bool							writes_layer;
    bool							writes_view;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SU_DS_SIV_CNTL(struct A8XX_GRAS_SU_DS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008210,
        .value =
            (fields.writes_layer                      <<  0) |
            (fields.writes_view                       <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SU_DS_SIV_CNTL(...) pack_A8XX_GRAS_SU_DS_SIV_CNTL(__struct_cast(A8XX_GRAS_SU_DS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_RAST_CNTL(struct A8XX_GRAS_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008211,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_RAST_CNTL(...) pack_A8XX_GRAS_RAST_CNTL(__struct_cast(A8XX_GRAS_RAST_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_CNTL {
    uint32_t							ccusinglecachelinesize;
    enum a6xx_single_prim_mode					single_prim_mode;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    enum a6xx_sequenced_thread_dist				sequenced_thread_distribution;
    bool							unk9;
    uint32_t							rotation;
    bool							earlyvizouten;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_CNTL(struct A6XX_GRAS_SC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.ccusinglecachelinesize            & 0xfffffff8) == 0);
    assert((fields.single_prim_mode                  & 0xfffffffc) == 0);
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.raster_direction                  & 0xfffffffc) == 0);
    assert((fields.sequenced_thread_distribution     & 0xfffffffe) == 0);
    assert((fields.rotation                          & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00001fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a0,
        .value =
            (fields.ccusinglecachelinesize            <<  0) |
            (fields.single_prim_mode                  <<  3) |
            (fields.raster_mode                       <<  5) |
            (fields.raster_direction                  <<  6) |
            (fields.sequenced_thread_distribution     <<  8) |
            (fields.unk9                              <<  9) |
            (fields.rotation                          << 10) |
            (fields.earlyvizouten                     << 12) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_CNTL(...) pack_A6XX_GRAS_SC_CNTL(__struct_cast(A6XX_GRAS_SC_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_CNTL {
    uint32_t							ccusinglecachelinesize;
    enum a6xx_single_prim_mode					single_prim_mode;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    enum a6xx_sequenced_thread_dist				sequenced_thread_distribution;
    bool							unk9;
    uint32_t							rotation;
    bool							earlyvizouten;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_CNTL(struct A8XX_GRAS_SC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.ccusinglecachelinesize            & 0xfffffff8) == 0);
    assert((fields.single_prim_mode                  & 0xfffffffc) == 0);
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.raster_direction                  & 0xfffffffc) == 0);
    assert((fields.sequenced_thread_distribution     & 0xfffffffe) == 0);
    assert((fields.rotation                          & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00001fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008230,
        .value =
            (fields.ccusinglecachelinesize            <<  0) |
            (fields.single_prim_mode                  <<  3) |
            (fields.raster_mode                       <<  5) |
            (fields.raster_direction                  <<  6) |
            (fields.sequenced_thread_distribution     <<  8) |
            (fields.unk9                              <<  9) |
            (fields.rotation                          << 10) |
            (fields.earlyvizouten                     << 12) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_CNTL(...) pack_A8XX_GRAS_SC_CNTL(__struct_cast(A8XX_GRAS_SC_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_BIN_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    bool							force_lrz_write_dis;
    enum a6xx_buffers_location					buffers_location;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_dis;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_BIN_CNTL(struct A6XX_GRAS_SC_BIN_CNTL fields)
{
#ifndef NDEBUG
    assert(((fields.binw >> 5)                       & 0xffffffc0) == 0);
    assert(((fields.binh >> 4)                       & 0xffffff80) == 0);
    assert((fields.render_mode                       & 0xfffffff8) == 0);
    assert((fields.buffers_location                  & 0xfffffffc) == 0);
    assert((fields.lrz_feedback_zmode_mask           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0ffc7f3f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a1,
        .value =
            ((fields.binw >> 5)                       <<  0) |
            ((fields.binh >> 4)                       <<  8) |
            (fields.render_mode                       << 18) |
            (fields.force_lrz_write_dis               << 21) |
            (fields.buffers_location                  << 22) |
            (fields.lrz_feedback_zmode_mask           << 24) |
            (fields.force_lrz_dis                     << 27) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_BIN_CNTL(...) pack_A6XX_GRAS_SC_BIN_CNTL(__struct_cast(A6XX_GRAS_SC_BIN_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_BIN_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    bool							force_lrz_write_dis;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_dis;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_BIN_CNTL(struct A8XX_GRAS_SC_BIN_CNTL fields)
{
#ifndef NDEBUG
    assert(((fields.binw >> 5)                       & 0xfffffc00) == 0);
    assert(((fields.binh >> 4)                       & 0xfffff800) == 0);
    assert((fields.render_mode                       & 0xfffffff8) == 0);
    assert((fields.lrz_feedback_zmode_mask           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0xf7ff7bff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008231,
        .value =
            ((fields.binw >> 5)                       <<  0) |
            ((fields.binh >> 4)                       << 16) |
            (fields.render_mode                       << 11) |
            (fields.force_lrz_write_dis               << 14) |
            (fields.lrz_feedback_zmode_mask           << 28) |
            (fields.force_lrz_dis                     << 31) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_BIN_CNTL(...) pack_A8XX_GRAS_SC_BIN_CNTL(__struct_cast(A8XX_GRAS_SC_BIN_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_RAS_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    uint32_t							unk2;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_RAS_MSAA_CNTL(struct A6XX_GRAS_SC_RAS_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unk2                              & 0xfffffffe) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a2,
        .value =
            (fields.samples                           <<  0) |
            (fields.unk2                              <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_RAS_MSAA_CNTL(...) pack_A6XX_GRAS_SC_RAS_MSAA_CNTL(__struct_cast(A6XX_GRAS_SC_RAS_MSAA_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_RAS_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    uint32_t							unk2;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_RAS_MSAA_CNTL(struct A8XX_GRAS_SC_RAS_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unk2                              & 0xfffffffe) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008232,
        .value =
            (fields.samples                           <<  0) |
            (fields.unk2                              <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_RAS_MSAA_CNTL(...) pack_A8XX_GRAS_SC_RAS_MSAA_CNTL(__struct_cast(A8XX_GRAS_SC_RAS_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_DEST_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    bool							msaa_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_DEST_MSAA_CNTL(struct A6XX_GRAS_SC_DEST_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a3,
        .value =
            (fields.samples                           <<  0) |
            (fields.msaa_disable                      <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_DEST_MSAA_CNTL(...) pack_A6XX_GRAS_SC_DEST_MSAA_CNTL(__struct_cast(A6XX_GRAS_SC_DEST_MSAA_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_DEST_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    bool							msaa_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_DEST_MSAA_CNTL(struct A8XX_GRAS_SC_DEST_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008233,
        .value =
            (fields.samples                           <<  0) |
            (fields.msaa_disable                      <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_DEST_MSAA_CNTL(...) pack_A8XX_GRAS_SC_DEST_MSAA_CNTL(__struct_cast(A8XX_GRAS_SC_DEST_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL {
    uint32_t							unk0;
    bool							location_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(struct A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unk0                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a4,
        .value =
            (fields.unk0                              <<  0) |
            (fields.location_enable                   <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(...) pack_A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(__struct_cast(A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(struct A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a5,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(...) pack_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(__struct_cast(A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0) { __VA_ARGS__ })

struct A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(struct A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a6,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(...) pack_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(__struct_cast(A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1) { __VA_ARGS__ })

struct A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL {
    uint32_t							unk0;
    bool							location_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(struct A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unk0                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008237,
        .value =
            (fields.unk0                              <<  0) |
            (fields.location_enable                   <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(...) pack_A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL(__struct_cast(A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008238,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008239,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2(struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000823a,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2) { __VA_ARGS__ })

struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3(struct A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000823b,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3(...) pack_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3(__struct_cast(A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3) { __VA_ARGS__ })

struct A7XX_GRAS_ROTATION_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_ROTATION_CNTL(struct A7XX_GRAS_ROTATION_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080a7,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_ROTATION_CNTL(...) pack_A7XX_GRAS_ROTATION_CNTL(__struct_cast(A7XX_GRAS_ROTATION_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_ROTATION_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_ROTATION_CNTL(struct A8XX_GRAS_ROTATION_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008207,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_ROTATION_CNTL(...) pack_A8XX_GRAS_ROTATION_CNTL(__struct_cast(A8XX_GRAS_ROTATION_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL {
    bool							scissor_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL(struct A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080af,
        .value =
            (fields.scissor_disable                   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL(...) pack_A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL(__struct_cast(A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL {
    bool							scissor_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL(struct A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008234,
        .value =
            (fields.scissor_disable                   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL(...) pack_A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL(__struct_cast(A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_SCREEN_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_SCREEN_SCISSOR_TL(uint32_t __i, struct A6XX_GRAS_SC_SCREEN_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000080b0 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, ...) pack_A6XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, __struct_cast(A6XX_GRAS_SC_SCREEN_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_SCREEN_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_SCREEN_SCISSOR_BR(uint32_t __i, struct A6XX_GRAS_SC_SCREEN_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000080b1 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, ...) pack_A6XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, __struct_cast(A6XX_GRAS_SC_SCREEN_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_SCREEN_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_SCREEN_SCISSOR_TL(uint32_t __i, struct A8XX_GRAS_SC_SCREEN_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008240 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, ...) pack_A8XX_GRAS_SC_SCREEN_SCISSOR_TL(__i, __struct_cast(A8XX_GRAS_SC_SCREEN_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_SCREEN_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_SCREEN_SCISSOR_BR(uint32_t __i, struct A8XX_GRAS_SC_SCREEN_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008241 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, ...) pack_A8XX_GRAS_SC_SCREEN_SCISSOR_BR(__i, __struct_cast(A8XX_GRAS_SC_SCREEN_SCISSOR_BR) { __VA_ARGS__ })

struct A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL(uint32_t __i, struct A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000080d0 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, ...) pack_A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, __struct_cast(A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR(uint32_t __i, struct A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000080d1 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, ...) pack_A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, __struct_cast(A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL(uint32_t __i, struct A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008270 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, ...) pack_A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL(__i, __struct_cast(A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR(uint32_t __i, struct A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffff0000) == 0);
    assert((fields.y                                 & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008271 + 0x2*__i),
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, ...) pack_A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR(__i, __struct_cast(A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR) { __VA_ARGS__ })

struct A6XX_GRAS_SC_WINDOW_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_WINDOW_SCISSOR_TL(struct A6XX_GRAS_SC_WINDOW_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080f0,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_WINDOW_SCISSOR_TL(...) pack_A6XX_GRAS_SC_WINDOW_SCISSOR_TL(__struct_cast(A6XX_GRAS_SC_WINDOW_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_SC_WINDOW_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_SC_WINDOW_SCISSOR_BR(struct A6XX_GRAS_SC_WINDOW_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080f1,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_SC_WINDOW_SCISSOR_BR(...) pack_A6XX_GRAS_SC_WINDOW_SCISSOR_BR(__struct_cast(A6XX_GRAS_SC_WINDOW_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_WINDOW_SCISSOR_TL(struct A8XX_GRAS_SC_WINDOW_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008235,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_WINDOW_SCISSOR_TL(...) pack_A8XX_GRAS_SC_WINDOW_SCISSOR_TL(__struct_cast(A8XX_GRAS_SC_WINDOW_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_SC_WINDOW_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_SC_WINDOW_SCISSOR_BR(struct A8XX_GRAS_SC_WINDOW_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008236,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_SC_WINDOW_SCISSOR_BR(...) pack_A8XX_GRAS_SC_WINDOW_SCISSOR_BR(__struct_cast(A8XX_GRAS_SC_WINDOW_SCISSOR_BR) { __VA_ARGS__ })

struct A7XX_GRAS_QUALITY_BUFFER_INFO {
    bool							layered;
    enum a6xx_tile_mode						tile_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_QUALITY_BUFFER_INFO(struct A7XX_GRAS_QUALITY_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.tile_mode                         & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080f5,
        .value =
            (fields.layered                           <<  0) |
            (fields.tile_mode                         <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_QUALITY_BUFFER_INFO(...) pack_A7XX_GRAS_QUALITY_BUFFER_INFO(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_INFO) { __VA_ARGS__ })

struct A8XX_GRAS_QUALITY_BUFFER_INFO {
    bool							layered;
    enum a6xx_tile_mode						tile_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_QUALITY_BUFFER_INFO(struct A8XX_GRAS_QUALITY_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.tile_mode                         & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000808e,
        .value =
            (fields.layered                           <<  0) |
            (fields.tile_mode                         <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_QUALITY_BUFFER_INFO(...) pack_A8XX_GRAS_QUALITY_BUFFER_INFO(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_GRAS_QUALITY_BUFFER_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_QUALITY_BUFFER_DIMENSION(struct A7XX_GRAS_QUALITY_BUFFER_DIMENSION fields)
{
#ifndef NDEBUG
    assert((fields.width                             & 0xffff0000) == 0);
    assert((fields.height                            & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080f6,
        .value =
            (fields.width                             <<  0) |
            (fields.height                            << 16) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_QUALITY_BUFFER_DIMENSION(...) pack_A7XX_GRAS_QUALITY_BUFFER_DIMENSION(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_DIMENSION) { __VA_ARGS__ })

struct A8XX_GRAS_QUALITY_BUFFER_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_QUALITY_BUFFER_DIMENSION(struct A8XX_GRAS_QUALITY_BUFFER_DIMENSION fields)
{
#ifndef NDEBUG
    assert((fields.width                             & 0xffff0000) == 0);
    assert((fields.height                            & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000808f,
        .value =
            (fields.width                             <<  0) |
            (fields.height                            << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_QUALITY_BUFFER_DIMENSION(...) pack_A8XX_GRAS_QUALITY_BUFFER_DIMENSION(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_DIMENSION) { __VA_ARGS__ })

struct A7XX_GRAS_QUALITY_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_QUALITY_BUFFER_BASE(struct A7XX_GRAS_QUALITY_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080f8,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A7XX_GRAS_QUALITY_BUFFER_BASE(...) pack_A7XX_GRAS_QUALITY_BUFFER_BASE(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_GRAS_QUALITY_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_QUALITY_BUFFER_BASE(struct A8XX_GRAS_QUALITY_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008090,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A8XX_GRAS_QUALITY_BUFFER_BASE(...) pack_A8XX_GRAS_QUALITY_BUFFER_BASE(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A7XX_GRAS_QUALITY_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_QUALITY_BUFFER_PITCH(struct A7XX_GRAS_QUALITY_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xffffff00) == 0);
    assert(((fields.array_pitch >> 6)                & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x1ffffcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000080fa,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 6)                << 10) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_QUALITY_BUFFER_PITCH(...) pack_A7XX_GRAS_QUALITY_BUFFER_PITCH(__struct_cast(A7XX_GRAS_QUALITY_BUFFER_PITCH) { __VA_ARGS__ })

struct A8XX_GRAS_QUALITY_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_QUALITY_BUFFER_PITCH(struct A8XX_GRAS_QUALITY_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xffffff00) == 0);
    assert(((fields.array_pitch >> 6)                & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x1ffffcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008092,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 6)                << 10) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_QUALITY_BUFFER_PITCH(...) pack_A8XX_GRAS_QUALITY_BUFFER_PITCH(__struct_cast(A8XX_GRAS_QUALITY_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_CNTL {
    bool							enable;
    bool							lrz_write;
    bool							greater;
    bool							fc_enable;
    bool							z_write_enable;
    bool							z_bounds_enable;
    enum a6xx_lrz_dir_status					dir;
    bool							dir_write;
    bool							disable_on_wrong_dir;
    enum adreno_compare_func					z_func;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_LRZ_CNTL(struct A6XX_GRAS_LRZ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.dir                               & 0xfffffffc) == 0);
    assert((fields.z_func                            & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x00003bff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008100,
        .value =
            (fields.enable                            <<  0) |
            (fields.lrz_write                         <<  1) |
            (fields.greater                           <<  2) |
            (fields.fc_enable                         <<  3) |
            (fields.z_write_enable                    <<  4) |
            (fields.z_bounds_enable                   <<  5) |
            (fields.dir                               <<  6) |
            (fields.dir_write                         <<  8) |
            (fields.disable_on_wrong_dir              <<  9) |
            (fields.z_func                            << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_CNTL(...) pack_A6XX_GRAS_LRZ_CNTL(__struct_cast(A6XX_GRAS_LRZ_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_CNTL {
    bool							enable;
    bool							lrz_write;
    bool							greater;
    bool							fc_enable;
    bool							z_write_enable;
    bool							z_bounds_enable;
    enum a6xx_lrz_dir_status					dir;
    bool							dir_write;
    bool							disable_on_wrong_dir;
    enum adreno_compare_func					z_func;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_CNTL(struct A8XX_GRAS_LRZ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.dir                               & 0xfffffffc) == 0);
    assert((fields.z_func                            & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x00003bff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008212,
        .value =
            (fields.enable                            <<  0) |
            (fields.lrz_write                         <<  1) |
            (fields.greater                           <<  2) |
            (fields.fc_enable                         <<  3) |
            (fields.z_write_enable                    <<  4) |
            (fields.z_bounds_enable                   <<  5) |
            (fields.dir                               <<  6) |
            (fields.dir_write                         <<  8) |
            (fields.disable_on_wrong_dir              <<  9) |
            (fields.z_func                            << 11) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_CNTL(...) pack_A8XX_GRAS_LRZ_CNTL(__struct_cast(A8XX_GRAS_LRZ_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_CB_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_LRZ_CB_CNTL(struct A7XX_GRAS_LRZ_CB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008007,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_LRZ_CB_CNTL(...) pack_A7XX_GRAS_LRZ_CB_CNTL(__struct_cast(A7XX_GRAS_LRZ_CB_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_CB_CNTL {
    uint32_t							double_buffer_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_CB_CNTL(struct A8XX_GRAS_LRZ_CB_CNTL fields)
{
#ifndef NDEBUG
    assert(((fields.double_buffer_pitch >> 8)        & 0xff000000) == 0);
    assert((fields.unknown                           & 0xffffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008101,
        .value =
            ((fields.double_buffer_pitch >> 8)        <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_CB_CNTL(...) pack_A8XX_GRAS_LRZ_CB_CNTL(__struct_cast(A8XX_GRAS_LRZ_CB_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_PS_INPUT_CNTL {
    bool							sampleid;
    enum a6xx_fragcoord_sample_mode				fragcoordsamplemode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_LRZ_PS_INPUT_CNTL(struct A6XX_GRAS_LRZ_PS_INPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.fragcoordsamplemode               & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008101,
        .value =
            (fields.sampleid                          <<  0) |
            (fields.fragcoordsamplemode               <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_PS_INPUT_CNTL(...) pack_A6XX_GRAS_LRZ_PS_INPUT_CNTL(__struct_cast(A6XX_GRAS_LRZ_PS_INPUT_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_PS_INPUT_CNTL {
    bool							sampleid;
    enum a6xx_fragcoord_sample_mode				fragcoordsamplemode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_PS_INPUT_CNTL(struct A8XX_GRAS_LRZ_PS_INPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.fragcoordsamplemode               & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008102,
        .value =
            (fields.sampleid                          <<  0) |
            (fields.fragcoordsamplemode               <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_PS_INPUT_CNTL(...) pack_A8XX_GRAS_LRZ_PS_INPUT_CNTL(__struct_cast(A8XX_GRAS_LRZ_PS_INPUT_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0 {
    enum a6xx_format						color_format;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0(struct A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0 fields)
{
#ifndef NDEBUG
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008102,
        .value =
            (fields.color_format                      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0(...) pack_A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0(__struct_cast(A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0 {
    enum a6xx_format						color_format;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0(struct A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0 fields)
{
#ifndef NDEBUG
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008103,
        .value =
            (fields.color_format                      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0(...) pack_A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0(__struct_cast(A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_LRZ_BUFFER_BASE(struct A6XX_GRAS_LRZ_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008103,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_GRAS_LRZ_BUFFER_BASE(...) pack_A6XX_GRAS_LRZ_BUFFER_BASE(__struct_cast(A6XX_GRAS_LRZ_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_GRAS_LRZ_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_BUFFER_BASE(struct A8XX_GRAS_LRZ_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008104,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A8XX_GRAS_LRZ_BUFFER_BASE(...) pack_A8XX_GRAS_LRZ_BUFFER_BASE(__struct_cast(A8XX_GRAS_LRZ_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_GRAS_LRZ_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_LRZ_BUFFER_PITCH(struct A6XX_GRAS_LRZ_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 5)                      & 0xffffff00) == 0);
    assert(((fields.array_pitch >> 8)                & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x1ffffcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008105,
        .value =
            ((fields.pitch >> 5)                      <<  0) |
            ((fields.array_pitch >> 8)                << 10) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_BUFFER_PITCH(...) pack_A6XX_GRAS_LRZ_BUFFER_PITCH(__struct_cast(A6XX_GRAS_LRZ_BUFFER_PITCH) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_BUFFER_PITCH(struct A8XX_GRAS_LRZ_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 5)                      & 0xffffff00) == 0);
    assert(((fields.array_pitch >> 8)                & 0xfff80000) == 0);
    assert((fields.unknown                           & 0x1ffffcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008108,
        .value =
            ((fields.pitch >> 5)                      <<  0) |
            ((fields.array_pitch >> 8)                << 10) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_BUFFER_PITCH(...) pack_A8XX_GRAS_LRZ_BUFFER_PITCH(__struct_cast(A8XX_GRAS_LRZ_BUFFER_PITCH) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_BUFFER_STRIDE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_BUFFER_STRIDE(struct A8XX_GRAS_LRZ_BUFFER_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000810e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_BUFFER_STRIDE(...) pack_A8XX_GRAS_LRZ_BUFFER_STRIDE(__struct_cast(A8XX_GRAS_LRZ_BUFFER_STRIDE) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE(struct A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008106,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE(...) pack_A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE(__struct_cast(A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL {
    bool							per_samp_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL(struct A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008109,
        .value =
            (fields.per_samp_mode                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL(...) pack_A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL(__struct_cast(A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_LRZ_VIEW_INFO {
    uint32_t							base_layer;
    uint32_t							layer_count;
    uint32_t							base_mip_level;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GRAS_LRZ_VIEW_INFO(struct A6XX_GRAS_LRZ_VIEW_INFO fields)
{
#ifndef NDEBUG
    assert((fields.base_layer                        & 0xfffff800) == 0);
    assert((fields.layer_count                       & 0xfffff800) == 0);
    assert((fields.base_mip_level                    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xf7ff07ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000810a,
        .value =
            (fields.base_layer                        <<  0) |
            (fields.layer_count                       << 16) |
            (fields.base_mip_level                    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_LRZ_VIEW_INFO(...) pack_A6XX_GRAS_LRZ_VIEW_INFO(__struct_cast(A6XX_GRAS_LRZ_VIEW_INFO) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_CNTL2 {
    bool							disable_on_wrong_dir;
    bool							fc_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_LRZ_CNTL2(struct A7XX_GRAS_LRZ_CNTL2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000810b,
        .value =
            (fields.disable_on_wrong_dir              <<  0) |
            (fields.fc_enable                         <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_LRZ_CNTL2(...) pack_A7XX_GRAS_LRZ_CNTL2(__struct_cast(A7XX_GRAS_LRZ_CNTL2) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH(struct A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008110,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH(...) pack_A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH(__struct_cast(A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH) { __VA_ARGS__ })

struct A6XX_GRAS_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_MODE_CNTL(struct A6XX_GRAS_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008110,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_MODE_CNTL(...) pack_A6XX_GRAS_MODE_CNTL(__struct_cast(A6XX_GRAS_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_MODE_CNTL(struct A8XX_GRAS_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008213,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_MODE_CNTL(...) pack_A8XX_GRAS_MODE_CNTL(__struct_cast(A8XX_GRAS_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_DEPTH_CLEAR {
    float							gras_lrz_depth_clear;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_LRZ_DEPTH_CLEAR(struct A7XX_GRAS_LRZ_DEPTH_CLEAR fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_lrz_depth_clear)         & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008111,
        .value =
            (fui(fields.gras_lrz_depth_clear)         <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_LRZ_DEPTH_CLEAR(...) pack_A7XX_GRAS_LRZ_DEPTH_CLEAR(__struct_cast(A7XX_GRAS_LRZ_DEPTH_CLEAR) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_DEPTH_CLEAR {
    float							gras_lrz_depth_clear;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_DEPTH_CLEAR(struct A8XX_GRAS_LRZ_DEPTH_CLEAR fields)
{
#ifndef NDEBUG
    assert((fui(fields.gras_lrz_depth_clear)         & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000810d,
        .value =
            (fui(fields.gras_lrz_depth_clear)         <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_DEPTH_CLEAR(...) pack_A8XX_GRAS_LRZ_DEPTH_CLEAR(__struct_cast(A8XX_GRAS_LRZ_DEPTH_CLEAR) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO(struct A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.depth_format                      & 0xfffffff8) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008113,
        .value =
            (fields.depth_format                      <<  0) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO(...) pack_A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO(__struct_cast(A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO(struct A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.depth_format                      & 0xfffffff8) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000810f,
        .value =
            (fields.depth_format                      <<  0) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO(...) pack_A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO(__struct_cast(A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(uint32_t __i, struct A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008120 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, ...) pack_A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, __struct_cast(A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG) { __VA_ARGS__ })

struct A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(uint32_t __i, struct A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008130 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, ...) pack_A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG(__i, __struct_cast(A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE_REG) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_BLT_CNTL {
    enum a6xx_rotation						rotate;
    bool							overwriteen;
    uint32_t							unk4;
    bool							solid_color;
    enum a6xx_format						color_format;
    bool							scissor;
    uint32_t							unk17;
    bool							d24s8;
    uint32_t							mask;
    enum a6xx_2d_ifmt						ifmt;
    bool							unk27;
    bool							unk28;
    enum a6xx_raster_mode					raster_mode;
    bool							copy;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_BLT_CNTL(struct A6XX_GRAS_A2D_BLT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.rotate                            & 0xfffffff8) == 0);
    assert((fields.unk4                              & 0xfffffff8) == 0);
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unk17                             & 0xfffffffc) == 0);
    assert((fields.mask                              & 0xfffffff0) == 0);
    assert((fields.ifmt                              & 0xfffffff8) == 0);
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x7fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008400,
        .value =
            (fields.rotate                            <<  0) |
            (fields.overwriteen                       <<  3) |
            (fields.unk4                              <<  4) |
            (fields.solid_color                       <<  7) |
            (fields.color_format                      <<  8) |
            (fields.scissor                           << 16) |
            (fields.unk17                             << 17) |
            (fields.d24s8                             << 19) |
            (fields.mask                              << 20) |
            (fields.ifmt                              << 24) |
            (fields.unk27                             << 27) |
            (fields.unk28                             << 28) |
            (fields.raster_mode                       << 29) |
            (fields.copy                              << 30) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_BLT_CNTL(...) pack_A6XX_GRAS_A2D_BLT_CNTL(__struct_cast(A6XX_GRAS_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_XMIN {
    int32_t							gras_a2d_src_xmin;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_SRC_XMIN(struct A6XX_GRAS_A2D_SRC_XMIN fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_xmin                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008401,
        .value =
            (fields.gras_a2d_src_xmin                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_SRC_XMIN(...) pack_A6XX_GRAS_A2D_SRC_XMIN(__struct_cast(A6XX_GRAS_A2D_SRC_XMIN) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_XMAX {
    int32_t							gras_a2d_src_xmax;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_SRC_XMAX(struct A6XX_GRAS_A2D_SRC_XMAX fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_xmax                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008402,
        .value =
            (fields.gras_a2d_src_xmax                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_SRC_XMAX(...) pack_A6XX_GRAS_A2D_SRC_XMAX(__struct_cast(A6XX_GRAS_A2D_SRC_XMAX) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_YMIN {
    int32_t							gras_a2d_src_ymin;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_SRC_YMIN(struct A6XX_GRAS_A2D_SRC_YMIN fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_ymin                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008403,
        .value =
            (fields.gras_a2d_src_ymin                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_SRC_YMIN(...) pack_A6XX_GRAS_A2D_SRC_YMIN(__struct_cast(A6XX_GRAS_A2D_SRC_YMIN) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SRC_YMAX {
    int32_t							gras_a2d_src_ymax;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_SRC_YMAX(struct A6XX_GRAS_A2D_SRC_YMAX fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_ymax                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008404,
        .value =
            (fields.gras_a2d_src_ymax                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_SRC_YMAX(...) pack_A6XX_GRAS_A2D_SRC_YMAX(__struct_cast(A6XX_GRAS_A2D_SRC_YMAX) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_DEST_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_DEST_TL(struct A6XX_GRAS_A2D_DEST_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008405,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_DEST_TL(...) pack_A6XX_GRAS_A2D_DEST_TL(__struct_cast(A6XX_GRAS_A2D_DEST_TL) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_DEST_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_DEST_BR(struct A6XX_GRAS_A2D_DEST_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008406,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_DEST_BR(...) pack_A6XX_GRAS_A2D_DEST_BR(__struct_cast(A6XX_GRAS_A2D_DEST_BR) { __VA_ARGS__ })

struct A6XX_GRAS_2D_UNKNOWN_8407 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GRAS_2D_UNKNOWN_8407(struct A6XX_GRAS_2D_UNKNOWN_8407 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008407,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_2D_UNKNOWN_8407(...) pack_A6XX_GRAS_2D_UNKNOWN_8407(__struct_cast(A6XX_GRAS_2D_UNKNOWN_8407) { __VA_ARGS__ })

struct A6XX_GRAS_2D_UNKNOWN_8408 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GRAS_2D_UNKNOWN_8408(struct A6XX_GRAS_2D_UNKNOWN_8408 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008408,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_2D_UNKNOWN_8408(...) pack_A6XX_GRAS_2D_UNKNOWN_8408(__struct_cast(A6XX_GRAS_2D_UNKNOWN_8408) { __VA_ARGS__ })

struct A6XX_GRAS_2D_UNKNOWN_8409 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_GRAS_2D_UNKNOWN_8409(struct A6XX_GRAS_2D_UNKNOWN_8409 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008409,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_2D_UNKNOWN_8409(...) pack_A6XX_GRAS_2D_UNKNOWN_8409(__struct_cast(A6XX_GRAS_2D_UNKNOWN_8409) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_SCISSOR_TL(struct A6XX_GRAS_A2D_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000840a,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_SCISSOR_TL(...) pack_A6XX_GRAS_A2D_SCISSOR_TL(__struct_cast(A6XX_GRAS_A2D_SCISSOR_TL) { __VA_ARGS__ })

struct A6XX_GRAS_A2D_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_A2D_SCISSOR_BR(struct A6XX_GRAS_A2D_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000840b,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_A2D_SCISSOR_BR(...) pack_A6XX_GRAS_A2D_SCISSOR_BR(__struct_cast(A6XX_GRAS_A2D_SCISSOR_BR) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_BLT_CNTL {
    enum a6xx_rotation						rotate;
    bool							overwriteen;
    uint32_t							unk4;
    bool							solid_color;
    enum a6xx_format						color_format;
    bool							scissor;
    uint32_t							unk17;
    bool							d24s8;
    uint32_t							mask;
    enum a6xx_2d_ifmt						ifmt;
    bool							unk27;
    bool							unk28;
    enum a6xx_raster_mode					raster_mode;
    bool							copy;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_BLT_CNTL(struct A8XX_GRAS_A2D_BLT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.rotate                            & 0xfffffff8) == 0);
    assert((fields.unk4                              & 0xfffffff8) == 0);
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unk17                             & 0xfffffffc) == 0);
    assert((fields.mask                              & 0xfffffff0) == 0);
    assert((fields.ifmt                              & 0xfffffff8) == 0);
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x7fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008500,
        .value =
            (fields.rotate                            <<  0) |
            (fields.overwriteen                       <<  3) |
            (fields.unk4                              <<  4) |
            (fields.solid_color                       <<  7) |
            (fields.color_format                      <<  8) |
            (fields.scissor                           << 16) |
            (fields.unk17                             << 17) |
            (fields.d24s8                             << 19) |
            (fields.mask                              << 20) |
            (fields.ifmt                              << 24) |
            (fields.unk27                             << 27) |
            (fields.unk28                             << 28) |
            (fields.raster_mode                       << 29) |
            (fields.copy                              << 30) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_BLT_CNTL(...) pack_A8XX_GRAS_A2D_BLT_CNTL(__struct_cast(A8XX_GRAS_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_XMIN {
    int32_t							gras_a2d_src_xmin;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_SRC_XMIN(struct A8XX_GRAS_A2D_SRC_XMIN fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_xmin                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008501,
        .value =
            (fields.gras_a2d_src_xmin                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_SRC_XMIN(...) pack_A8XX_GRAS_A2D_SRC_XMIN(__struct_cast(A8XX_GRAS_A2D_SRC_XMIN) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_XMAX {
    int32_t							gras_a2d_src_xmax;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_SRC_XMAX(struct A8XX_GRAS_A2D_SRC_XMAX fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_xmax                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008502,
        .value =
            (fields.gras_a2d_src_xmax                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_SRC_XMAX(...) pack_A8XX_GRAS_A2D_SRC_XMAX(__struct_cast(A8XX_GRAS_A2D_SRC_XMAX) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_YMIN {
    int32_t							gras_a2d_src_ymin;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_SRC_YMIN(struct A8XX_GRAS_A2D_SRC_YMIN fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_ymin                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008503,
        .value =
            (fields.gras_a2d_src_ymin                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_SRC_YMIN(...) pack_A8XX_GRAS_A2D_SRC_YMIN(__struct_cast(A8XX_GRAS_A2D_SRC_YMIN) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SRC_YMAX {
    int32_t							gras_a2d_src_ymax;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_SRC_YMAX(struct A8XX_GRAS_A2D_SRC_YMAX fields)
{
#ifndef NDEBUG
    assert((fields.gras_a2d_src_ymax                 & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x01ffff00) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008504,
        .value =
            (fields.gras_a2d_src_ymax                 <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_SRC_YMAX(...) pack_A8XX_GRAS_A2D_SRC_YMAX(__struct_cast(A8XX_GRAS_A2D_SRC_YMAX) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_DEST_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_DEST_TL(struct A8XX_GRAS_A2D_DEST_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008505,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_DEST_TL(...) pack_A8XX_GRAS_A2D_DEST_TL(__struct_cast(A8XX_GRAS_A2D_DEST_TL) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_DEST_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_DEST_BR(struct A8XX_GRAS_A2D_DEST_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008506,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_DEST_BR(...) pack_A8XX_GRAS_A2D_DEST_BR(__struct_cast(A8XX_GRAS_A2D_DEST_BR) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SCISSOR_TL {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_SCISSOR_TL(struct A8XX_GRAS_A2D_SCISSOR_TL fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008507,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_SCISSOR_TL(...) pack_A8XX_GRAS_A2D_SCISSOR_TL(__struct_cast(A8XX_GRAS_A2D_SCISSOR_TL) { __VA_ARGS__ })

struct A8XX_GRAS_A2D_SCISSOR_BR {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_A2D_SCISSOR_BR(struct A8XX_GRAS_A2D_SCISSOR_BR fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008508,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_A2D_SCISSOR_BR(...) pack_A8XX_GRAS_A2D_SCISSOR_BR(__struct_cast(A8XX_GRAS_A2D_SCISSOR_BR) { __VA_ARGS__ })

struct A6XX_GRAS_DBG_ECO_CNTL {
    bool							unk7;
    bool							lrzcachelockdis;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_DBG_ECO_CNTL(struct A6XX_GRAS_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000880) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008600,
        .value =
            (fields.unk7                              <<  7) |
            (fields.lrzcachelockdis                   << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_DBG_ECO_CNTL(...) pack_A6XX_GRAS_DBG_ECO_CNTL(__struct_cast(A6XX_GRAS_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_TSEFE_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_TSEFE_DBG_ECO_CNTL(struct A8XX_GRAS_TSEFE_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008600,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_TSEFE_DBG_ECO_CNTL(...) pack_A8XX_GRAS_TSEFE_DBG_ECO_CNTL(__struct_cast(A8XX_GRAS_TSEFE_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_DBG_ECO_CNTL(struct A8XX_GRAS_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008702,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_DBG_ECO_CNTL(...) pack_A8XX_GRAS_DBG_ECO_CNTL(__struct_cast(A8XX_GRAS_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_ADDR_MODE_CNTL {
    enum a5xx_address_mode					gras_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_ADDR_MODE_CNTL(struct A6XX_GRAS_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.gras_addr_mode_cntl               & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008601,
        .value =
            (fields.gras_addr_mode_cntl               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_ADDR_MODE_CNTL(...) pack_A6XX_GRAS_ADDR_MODE_CNTL(__struct_cast(A6XX_GRAS_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_GRAS_NC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_GRAS_NC_MODE_CNTL(struct A7XX_GRAS_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008602,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_GRAS_NC_MODE_CNTL(...) pack_A7XX_GRAS_NC_MODE_CNTL(__struct_cast(A7XX_GRAS_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_GRAS_NC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_NC_MODE_CNTL(struct A8XX_GRAS_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008700,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_NC_MODE_CNTL(...) pack_A8XX_GRAS_NC_MODE_CNTL(__struct_cast(A8XX_GRAS_NC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_GRAS_PERFCTR_TSE_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_PERFCTR_TSE_SEL_REG(uint32_t __i, struct A6XX_GRAS_PERFCTR_TSE_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008610 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_PERFCTR_TSE_SEL_REG(__i, ...) pack_A6XX_GRAS_PERFCTR_TSE_SEL_REG(__i, __struct_cast(A6XX_GRAS_PERFCTR_TSE_SEL_REG) { __VA_ARGS__ })

struct A6XX_GRAS_PERFCTR_RAS_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_PERFCTR_RAS_SEL_REG(uint32_t __i, struct A6XX_GRAS_PERFCTR_RAS_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008614 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_PERFCTR_RAS_SEL_REG(__i, ...) pack_A6XX_GRAS_PERFCTR_RAS_SEL_REG(__i, __struct_cast(A6XX_GRAS_PERFCTR_RAS_SEL_REG) { __VA_ARGS__ })

struct A6XX_GRAS_PERFCTR_LRZ_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_GRAS_PERFCTR_LRZ_SEL_REG(uint32_t __i, struct A6XX_GRAS_PERFCTR_LRZ_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008618 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, ...) pack_A6XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, __struct_cast(A6XX_GRAS_PERFCTR_LRZ_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_TSEFE_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_PERFCTR_TSEFE_SEL_REG(uint32_t __i, struct A8XX_GRAS_PERFCTR_TSEFE_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008610 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_PERFCTR_TSEFE_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_TSEFE_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_TSEFE_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_TSE_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_PERFCTR_TSE_SEL_REG(uint32_t __i, struct A8XX_GRAS_PERFCTR_TSE_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008710 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_PERFCTR_TSE_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_TSE_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_TSE_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_RAS_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_PERFCTR_RAS_SEL_REG(uint32_t __i, struct A8XX_GRAS_PERFCTR_RAS_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008720 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_PERFCTR_RAS_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_RAS_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_RAS_SEL_REG) { __VA_ARGS__ })

struct A8XX_GRAS_PERFCTR_LRZ_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_GRAS_PERFCTR_LRZ_SEL_REG(uint32_t __i, struct A8XX_GRAS_PERFCTR_LRZ_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008730 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, ...) pack_A8XX_GRAS_PERFCTR_LRZ_SEL_REG(__i, __struct_cast(A8XX_GRAS_PERFCTR_LRZ_SEL_REG) { __VA_ARGS__ })

struct A6XX_RB_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    bool							force_lrz_write_dis;
    enum a6xx_buffers_location					buffers_location;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_dis;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_CNTL(struct A6XX_RB_CNTL fields)
{
#ifndef NDEBUG
    assert(((fields.binw >> 5)                       & 0xffffffc0) == 0);
    assert(((fields.binh >> 4)                       & 0xffffff80) == 0);
    assert((fields.render_mode                       & 0xfffffff8) == 0);
    assert((fields.buffers_location                  & 0xfffffffc) == 0);
    assert((fields.lrz_feedback_zmode_mask           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x0ffc7f3f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008800,
        .value =
            ((fields.binw >> 5)                       <<  0) |
            ((fields.binh >> 4)                       <<  8) |
            (fields.render_mode                       << 18) |
            (fields.force_lrz_write_dis               << 21) |
            (fields.buffers_location                  << 22) |
            (fields.lrz_feedback_zmode_mask           << 24) |
            (fields.force_lrz_dis                     << 27) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_CNTL(...) pack_A6XX_RB_CNTL(__struct_cast(A6XX_RB_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CNTL {
    uint32_t							binw;
    uint32_t							binh;
    enum a6xx_render_mode					render_mode;
    bool							force_lrz_write_dis;
    enum a6xx_lrz_feedback_mask					lrz_feedback_zmode_mask;
    bool							force_lrz_dis;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_CNTL(struct A8XX_RB_CNTL fields)
{
#ifndef NDEBUG
    assert(((fields.binw >> 5)                       & 0xfffffc00) == 0);
    assert(((fields.binh >> 4)                       & 0xfffff800) == 0);
    assert((fields.render_mode                       & 0xfffffff8) == 0);
    assert((fields.lrz_feedback_zmode_mask           & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0xf7ff7bff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008800,
        .value =
            ((fields.binw >> 5)                       <<  0) |
            ((fields.binh >> 4)                       << 16) |
            (fields.render_mode                       << 11) |
            (fields.force_lrz_write_dis               << 14) |
            (fields.lrz_feedback_zmode_mask           << 28) |
            (fields.force_lrz_dis                     << 31) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_CNTL(...) pack_A8XX_RB_CNTL(__struct_cast(A8XX_RB_CNTL) { __VA_ARGS__ })

struct A6XX_RB_RENDER_CNTL {
    uint32_t							ccusinglecachelinesize;
    bool							earlyvizouten;
    bool							fs_disable;
    uint32_t							unk8;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    bool							conservativerasen;
    bool							innerconservativerasen;
    bool							flag_depth;
    uint32_t							flag_mrts;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_RENDER_CNTL(struct A6XX_RB_RENDER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.ccusinglecachelinesize            & 0xfffffff8) == 0);
    assert((fields.unk8                              & 0xfffffff8) == 0);
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.raster_direction                  & 0xfffffffc) == 0);
    assert((fields.flag_mrts                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ff5ff8) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008801,
        .value =
            (fields.ccusinglecachelinesize            <<  3) |
            (fields.earlyvizouten                     <<  6) |
            (fields.fs_disable                        <<  7) |
            (fields.unk8                              <<  8) |
            (fields.raster_mode                       <<  8) |
            (fields.raster_direction                  <<  9) |
            (fields.conservativerasen                 << 11) |
            (fields.innerconservativerasen            << 12) |
            (fields.flag_depth                        << 14) |
            (fields.flag_mrts                         << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RENDER_CNTL(...) pack_A6XX_RB_RENDER_CNTL(__struct_cast(A6XX_RB_RENDER_CNTL) { __VA_ARGS__ })

struct A7XX_RB_RENDER_CNTL {
    bool							earlyvizouten;
    bool							fs_disable;
    enum a6xx_raster_mode					raster_mode;
    enum a6xx_raster_direction					raster_direction;
    bool							conservativerasen;
    bool							innerconservativerasen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_RENDER_CNTL(struct A7XX_RB_RENDER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.raster_direction                  & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00001fc0) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008801,
        .value =
            (fields.earlyvizouten                     <<  6) |
            (fields.fs_disable                        <<  7) |
            (fields.raster_mode                       <<  8) |
            (fields.raster_direction                  <<  9) |
            (fields.conservativerasen                 << 11) |
            (fields.innerconservativerasen            << 12) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_RENDER_CNTL(...) pack_A7XX_RB_RENDER_CNTL(__struct_cast(A7XX_RB_RENDER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_RAS_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    uint32_t							unk2;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RAS_MSAA_CNTL(struct A6XX_RB_RAS_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unk2                              & 0xfffffffe) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008802,
        .value =
            (fields.samples                           <<  0) |
            (fields.unk2                              <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RAS_MSAA_CNTL(...) pack_A6XX_RB_RAS_MSAA_CNTL(__struct_cast(A6XX_RB_RAS_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DEST_MSAA_CNTL {
    enum a3xx_msaa_samples					samples;
    bool							msaa_disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEST_MSAA_CNTL(struct A6XX_RB_DEST_MSAA_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008803,
        .value =
            (fields.samples                           <<  0) |
            (fields.msaa_disable                      <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEST_MSAA_CNTL(...) pack_A6XX_RB_DEST_MSAA_CNTL(__struct_cast(A6XX_RB_DEST_MSAA_CNTL) { __VA_ARGS__ })

struct A6XX_RB_MSAA_SAMPLE_POS_CNTL {
    uint32_t							unk0;
    bool							location_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MSAA_SAMPLE_POS_CNTL(struct A6XX_RB_MSAA_SAMPLE_POS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unk0                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008804,
        .value =
            (fields.unk0                              <<  0) |
            (fields.location_enable                   <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MSAA_SAMPLE_POS_CNTL(...) pack_A6XX_RB_MSAA_SAMPLE_POS_CNTL(__struct_cast(A6XX_RB_MSAA_SAMPLE_POS_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PROGRAMMABLE_MSAA_POS_0 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_0(struct A6XX_RB_PROGRAMMABLE_MSAA_POS_0 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008805,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0(...) pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_0(__struct_cast(A6XX_RB_PROGRAMMABLE_MSAA_POS_0) { __VA_ARGS__ })

struct A6XX_RB_PROGRAMMABLE_MSAA_POS_1 {
    float							sample_0_x;
    float							sample_0_y;
    float							sample_1_x;
    float							sample_1_y;
    float							sample_2_x;
    float							sample_2_y;
    float							sample_3_x;
    float							sample_3_y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_1(struct A6XX_RB_PROGRAMMABLE_MSAA_POS_1 fields)
{
#ifndef NDEBUG
    assert((((int32_t)(fields.sample_0_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_0_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_1_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_2_y * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_x * 16.0))    & 0xfffffff0) == 0);
    assert((((int32_t)(fields.sample_3_y * 16.0))    & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008806,
        .value =
            (((int32_t)(fields.sample_0_x * 16.0))    <<  0) |
            (((int32_t)(fields.sample_0_y * 16.0))    <<  4) |
            (((int32_t)(fields.sample_1_x * 16.0))    <<  8) |
            (((int32_t)(fields.sample_1_y * 16.0))    << 12) |
            (((int32_t)(fields.sample_2_x * 16.0))    << 16) |
            (((int32_t)(fields.sample_2_y * 16.0))    << 20) |
            (((int32_t)(fields.sample_3_x * 16.0))    << 24) |
            (((int32_t)(fields.sample_3_y * 16.0))    << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1(...) pack_A6XX_RB_PROGRAMMABLE_MSAA_POS_1(__struct_cast(A6XX_RB_PROGRAMMABLE_MSAA_POS_1) { __VA_ARGS__ })

struct A6XX_RB_INTERP_CNTL {
    bool							ij_persp_pixel;
    bool							ij_persp_centroid;
    bool							ij_persp_sample;
    bool							ij_linear_pixel;
    bool							ij_linear_centroid;
    bool							ij_linear_sample;
    uint32_t							coord_mask;
    bool							unk10;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_INTERP_CNTL(struct A6XX_RB_INTERP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.coord_mask                        & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008809,
        .value =
            (fields.ij_persp_pixel                    <<  0) |
            (fields.ij_persp_centroid                 <<  1) |
            (fields.ij_persp_sample                   <<  2) |
            (fields.ij_linear_pixel                   <<  3) |
            (fields.ij_linear_centroid                <<  4) |
            (fields.ij_linear_sample                  <<  5) |
            (fields.coord_mask                        <<  6) |
            (fields.unk10                             << 10) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_INTERP_CNTL(...) pack_A6XX_RB_INTERP_CNTL(__struct_cast(A6XX_RB_INTERP_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_INPUT_CNTL {
    bool							samplemask;
    bool							postdepthcoverage;
    bool							faceness;
    bool							sampleid;
    enum a6xx_fragcoord_sample_mode				fragcoordsamplemode;
    bool							centerrhw;
    bool							linelengthen;
    bool							foveation;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PS_INPUT_CNTL(struct A6XX_RB_PS_INPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.fragcoordsamplemode               & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000001ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880a,
        .value =
            (fields.samplemask                        <<  0) |
            (fields.postdepthcoverage                 <<  1) |
            (fields.faceness                          <<  2) |
            (fields.sampleid                          <<  3) |
            (fields.fragcoordsamplemode               <<  4) |
            (fields.centerrhw                         <<  6) |
            (fields.linelengthen                      <<  7) |
            (fields.foveation                         <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_INPUT_CNTL(...) pack_A6XX_RB_PS_INPUT_CNTL(__struct_cast(A6XX_RB_PS_INPUT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_OUTPUT_CNTL {
    bool							dual_color_in_enable;
    bool							frag_writes_z;
    bool							frag_writes_sampmask;
    bool							frag_writes_stencilref;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PS_OUTPUT_CNTL(struct A6XX_RB_PS_OUTPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880b,
        .value =
            (fields.dual_color_in_enable              <<  0) |
            (fields.frag_writes_z                     <<  1) |
            (fields.frag_writes_sampmask              <<  2) |
            (fields.frag_writes_stencilref            <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_OUTPUT_CNTL(...) pack_A6XX_RB_PS_OUTPUT_CNTL(__struct_cast(A6XX_RB_PS_OUTPUT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_MRT_CNTL {
    uint32_t							mrt;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PS_MRT_CNTL(struct A6XX_RB_PS_MRT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mrt                               & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880c,
        .value =
            (fields.mrt                               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_MRT_CNTL(...) pack_A6XX_RB_PS_MRT_CNTL(__struct_cast(A6XX_RB_PS_MRT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_OUTPUT_MASK {
    uint32_t							rt0;
    uint32_t							rt1;
    uint32_t							rt2;
    uint32_t							rt3;
    uint32_t							rt4;
    uint32_t							rt5;
    uint32_t							rt6;
    uint32_t							rt7;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PS_OUTPUT_MASK(struct A6XX_RB_PS_OUTPUT_MASK fields)
{
#ifndef NDEBUG
    assert((fields.rt0                               & 0xfffffff0) == 0);
    assert((fields.rt1                               & 0xfffffff0) == 0);
    assert((fields.rt2                               & 0xfffffff0) == 0);
    assert((fields.rt3                               & 0xfffffff0) == 0);
    assert((fields.rt4                               & 0xfffffff0) == 0);
    assert((fields.rt5                               & 0xfffffff0) == 0);
    assert((fields.rt6                               & 0xfffffff0) == 0);
    assert((fields.rt7                               & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880d,
        .value =
            (fields.rt0                               <<  0) |
            (fields.rt1                               <<  4) |
            (fields.rt2                               <<  8) |
            (fields.rt3                               << 12) |
            (fields.rt4                               << 16) |
            (fields.rt5                               << 20) |
            (fields.rt6                               << 24) |
            (fields.rt7                               << 28) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_OUTPUT_MASK(...) pack_A6XX_RB_PS_OUTPUT_MASK(__struct_cast(A6XX_RB_PS_OUTPUT_MASK) { __VA_ARGS__ })

struct A6XX_RB_DITHER_CNTL {
    enum adreno_rb_dither_mode					dither_mode_mrt0;
    enum adreno_rb_dither_mode					dither_mode_mrt1;
    enum adreno_rb_dither_mode					dither_mode_mrt2;
    enum adreno_rb_dither_mode					dither_mode_mrt3;
    enum adreno_rb_dither_mode					dither_mode_mrt4;
    enum adreno_rb_dither_mode					dither_mode_mrt5;
    enum adreno_rb_dither_mode					dither_mode_mrt6;
    enum adreno_rb_dither_mode					dither_mode_mrt7;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DITHER_CNTL(struct A6XX_RB_DITHER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.dither_mode_mrt0                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt1                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt2                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt3                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt4                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt5                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt6                  & 0xfffffffc) == 0);
    assert((fields.dither_mode_mrt7                  & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880e,
        .value =
            (fields.dither_mode_mrt0                  <<  0) |
            (fields.dither_mode_mrt1                  <<  2) |
            (fields.dither_mode_mrt2                  <<  4) |
            (fields.dither_mode_mrt3                  <<  6) |
            (fields.dither_mode_mrt4                  <<  8) |
            (fields.dither_mode_mrt5                  << 10) |
            (fields.dither_mode_mrt6                  << 12) |
            (fields.dither_mode_mrt7                  << 14) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DITHER_CNTL(...) pack_A6XX_RB_DITHER_CNTL(__struct_cast(A6XX_RB_DITHER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_SRGB_CNTL {
    bool							srgb_mrt0;
    bool							srgb_mrt1;
    bool							srgb_mrt2;
    bool							srgb_mrt3;
    bool							srgb_mrt4;
    bool							srgb_mrt5;
    bool							srgb_mrt6;
    bool							srgb_mrt7;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_SRGB_CNTL(struct A6XX_RB_SRGB_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000880f,
        .value =
            (fields.srgb_mrt0                         <<  0) |
            (fields.srgb_mrt1                         <<  1) |
            (fields.srgb_mrt2                         <<  2) |
            (fields.srgb_mrt3                         <<  3) |
            (fields.srgb_mrt4                         <<  4) |
            (fields.srgb_mrt5                         <<  5) |
            (fields.srgb_mrt6                         <<  6) |
            (fields.srgb_mrt7                         <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SRGB_CNTL(...) pack_A6XX_RB_SRGB_CNTL(__struct_cast(A6XX_RB_SRGB_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PS_SAMPLEFREQ_CNTL {
    bool							per_samp_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PS_SAMPLEFREQ_CNTL(struct A6XX_RB_PS_SAMPLEFREQ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008810,
        .value =
            (fields.per_samp_mode                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PS_SAMPLEFREQ_CNTL(...) pack_A6XX_RB_PS_SAMPLEFREQ_CNTL(__struct_cast(A6XX_RB_PS_SAMPLEFREQ_CNTL) { __VA_ARGS__ })

struct A6XX_RB_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MODE_CNTL(struct A6XX_RB_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008811,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MODE_CNTL(...) pack_A6XX_RB_MODE_CNTL(__struct_cast(A6XX_RB_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RB_BUFFER_CNTL {
    bool							z_sysmem;
    bool							s_sysmem;
    bool							rt0_sysmem;
    bool							rt1_sysmem;
    bool							rt2_sysmem;
    bool							rt3_sysmem;
    bool							rt4_sysmem;
    bool							rt5_sysmem;
    bool							rt6_sysmem;
    bool							rt7_sysmem;
    bool							z_full_in_gmem;
    bool							s_full_in_gmem;
    bool							rt0_full_in_gmem;
    bool							rt1_full_in_gmem;
    bool							rt2_full_in_gmem;
    bool							rt3_full_in_gmem;
    bool							rt4_full_in_gmem;
    bool							rt5_full_in_gmem;
    bool							rt6_full_in_gmem;
    bool							rt7_full_in_gmem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_BUFFER_CNTL(struct A7XX_RB_BUFFER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x000fffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008812,
        .value =
            (fields.z_sysmem                          <<  0) |
            (fields.s_sysmem                          <<  1) |
            (fields.rt0_sysmem                        <<  2) |
            (fields.rt1_sysmem                        <<  3) |
            (fields.rt2_sysmem                        <<  4) |
            (fields.rt3_sysmem                        <<  5) |
            (fields.rt4_sysmem                        <<  6) |
            (fields.rt5_sysmem                        <<  7) |
            (fields.rt6_sysmem                        <<  8) |
            (fields.rt7_sysmem                        <<  9) |
            (fields.z_full_in_gmem                    << 10) |
            (fields.s_full_in_gmem                    << 11) |
            (fields.rt0_full_in_gmem                  << 12) |
            (fields.rt1_full_in_gmem                  << 13) |
            (fields.rt2_full_in_gmem                  << 14) |
            (fields.rt3_full_in_gmem                  << 15) |
            (fields.rt4_full_in_gmem                  << 16) |
            (fields.rt5_full_in_gmem                  << 17) |
            (fields.rt6_full_in_gmem                  << 18) |
            (fields.rt7_full_in_gmem                  << 19) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_BUFFER_CNTL(...) pack_A7XX_RB_BUFFER_CNTL(__struct_cast(A7XX_RB_BUFFER_CNTL) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_CR_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_RESOLVE_CR_CNTL(struct A8XX_RB_RESOLVE_CR_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008816,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_RESOLVE_CR_CNTL(...) pack_A8XX_RB_RESOLVE_CR_CNTL(__struct_cast(A8XX_RB_RESOLVE_CR_CNTL) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8818 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8818(struct A6XX_RB_UNKNOWN_8818 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008818,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8818(...) pack_A6XX_RB_UNKNOWN_8818(__struct_cast(A6XX_RB_UNKNOWN_8818) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8819 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8819(struct A6XX_RB_UNKNOWN_8819 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008819,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8819(...) pack_A6XX_RB_UNKNOWN_8819(__struct_cast(A6XX_RB_UNKNOWN_8819) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881A {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881A(struct A6XX_RB_UNKNOWN_881A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881A(...) pack_A6XX_RB_UNKNOWN_881A(__struct_cast(A6XX_RB_UNKNOWN_881A) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881B {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881B(struct A6XX_RB_UNKNOWN_881B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881B(...) pack_A6XX_RB_UNKNOWN_881B(__struct_cast(A6XX_RB_UNKNOWN_881B) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881C {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881C(struct A6XX_RB_UNKNOWN_881C fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881C(...) pack_A6XX_RB_UNKNOWN_881C(__struct_cast(A6XX_RB_UNKNOWN_881C) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881D {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881D(struct A6XX_RB_UNKNOWN_881D fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881D(...) pack_A6XX_RB_UNKNOWN_881D(__struct_cast(A6XX_RB_UNKNOWN_881D) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_881E {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_881E(struct A6XX_RB_UNKNOWN_881E fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000881e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_881E(...) pack_A6XX_RB_UNKNOWN_881E(__struct_cast(A6XX_RB_UNKNOWN_881E) { __VA_ARGS__ })

struct A6XX_RB_MRT_CONTROL {
    bool							blend;
    bool							blend2;
    bool							rop_enable;
    enum a3xx_rop_code						rop_code;
    uint32_t							component_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MRT_CONTROL(uint32_t __i, struct A6XX_RB_MRT_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.rop_code                          & 0xfffffff0) == 0);
    assert((fields.component_enable                  & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008820 + 0x8*__i),
        .value =
            (fields.blend                             <<  0) |
            (fields.blend2                            <<  1) |
            (fields.rop_enable                        <<  2) |
            (fields.rop_code                          <<  3) |
            (fields.component_enable                  <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_CONTROL(__i, ...) pack_A6XX_RB_MRT_CONTROL(__i, __struct_cast(A6XX_RB_MRT_CONTROL) { __VA_ARGS__ })

struct A6XX_RB_MRT_BLEND_CONTROL {
    enum adreno_rb_blend_factor					rgb_src_factor;
    enum a3xx_rb_blend_opcode					rgb_blend_opcode;
    enum adreno_rb_blend_factor					rgb_dest_factor;
    enum adreno_rb_blend_factor					alpha_src_factor;
    enum a3xx_rb_blend_opcode					alpha_blend_opcode;
    enum adreno_rb_blend_factor					alpha_dest_factor;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MRT_BLEND_CONTROL(uint32_t __i, struct A6XX_RB_MRT_BLEND_CONTROL fields)
{
#ifndef NDEBUG
    assert((fields.rgb_src_factor                    & 0xffffffe0) == 0);
    assert((fields.rgb_blend_opcode                  & 0xfffffff8) == 0);
    assert((fields.rgb_dest_factor                   & 0xffffffe0) == 0);
    assert((fields.alpha_src_factor                  & 0xffffffe0) == 0);
    assert((fields.alpha_blend_opcode                & 0xfffffff8) == 0);
    assert((fields.alpha_dest_factor                 & 0xffffffe0) == 0);
    assert((fields.unknown                           & 0x1fff1fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008821 + 0x8*__i),
        .value =
            (fields.rgb_src_factor                    <<  0) |
            (fields.rgb_blend_opcode                  <<  5) |
            (fields.rgb_dest_factor                   <<  8) |
            (fields.alpha_src_factor                  << 16) |
            (fields.alpha_blend_opcode                << 21) |
            (fields.alpha_dest_factor                 << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_BLEND_CONTROL(__i, ...) pack_A6XX_RB_MRT_BLEND_CONTROL(__i, __struct_cast(A6XX_RB_MRT_BLEND_CONTROL) { __VA_ARGS__ })

struct A6XX_RB_MRT_BUF_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						color_tile_mode;
    uint32_t							unk10;
    enum a3xx_color_swap					color_swap;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_MRT_BUF_INFO(uint32_t __i, struct A6XX_RB_MRT_BUF_INFO fields)
{
#ifndef NDEBUG
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.color_tile_mode                   & 0xfffffffc) == 0);
    assert((fields.unk10                             & 0xfffffffe) == 0);
    assert((fields.color_swap                        & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000067ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008822 + 0x8*__i),
        .value =
            (fields.color_format                      <<  0) |
            (fields.color_tile_mode                   <<  8) |
            (fields.unk10                             << 10) |
            (fields.color_swap                        << 13) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_BUF_INFO(__i, ...) pack_A6XX_RB_MRT_BUF_INFO(__i, __struct_cast(A6XX_RB_MRT_BUF_INFO) { __VA_ARGS__ })

struct A7XX_RB_MRT_BUF_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						color_tile_mode;
    uint32_t							unk10;
    bool							losslesscompen;
    enum a3xx_color_swap					color_swap;
    bool							mutableen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_MRT_BUF_INFO(uint32_t __i, struct A7XX_RB_MRT_BUF_INFO fields)
{
#ifndef NDEBUG
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.color_tile_mode                   & 0xfffffffc) == 0);
    assert((fields.unk10                             & 0xfffffffe) == 0);
    assert((fields.color_swap                        & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00016fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008822 + 0x8*__i),
        .value =
            (fields.color_format                      <<  0) |
            (fields.color_tile_mode                   <<  8) |
            (fields.unk10                             << 10) |
            (fields.losslesscompen                    << 11) |
            (fields.color_swap                        << 13) |
            (fields.mutableen                         << 16) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_MRT_BUF_INFO(__i, ...) pack_A7XX_RB_MRT_BUF_INFO(__i, __struct_cast(A7XX_RB_MRT_BUF_INFO) { __VA_ARGS__ })

struct A6XX_RB_MRT_PITCH {
    uint32_t							rb_mrt_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MRT_PITCH(uint32_t __i, struct A6XX_RB_MRT_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_mrt_pitch >> 6)               & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008823 + 0x8*__i),
        .value =
            ((fields.rb_mrt_pitch >> 6)               <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_PITCH(__i, ...) pack_A6XX_RB_MRT_PITCH(__i, __struct_cast(A6XX_RB_MRT_PITCH) { __VA_ARGS__ })

struct A6XX_RB_MRT_ARRAY_PITCH {
    uint32_t							rb_mrt_array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MRT_ARRAY_PITCH(uint32_t __i, struct A6XX_RB_MRT_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_mrt_array_pitch >> 6)         & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008824 + 0x8*__i),
        .value =
            ((fields.rb_mrt_array_pitch >> 6)         <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_ARRAY_PITCH(__i, ...) pack_A6XX_RB_MRT_ARRAY_PITCH(__i, __struct_cast(A6XX_RB_MRT_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_MRT_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MRT_BASE(uint32_t __i, struct A6XX_RB_MRT_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008825 + 0x8*__i),
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_MRT_BASE(__i, ...) pack_A6XX_RB_MRT_BASE(__i, __struct_cast(A6XX_RB_MRT_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_MRT_BASE_GMEM {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_MRT_BASE_GMEM(uint32_t __i, struct A6XX_RB_MRT_BASE_GMEM fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008827 + 0x8*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_MRT_BASE_GMEM(__i, ...) pack_A6XX_RB_MRT_BASE_GMEM(__i, __struct_cast(A6XX_RB_MRT_BASE_GMEM) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_RED_FP32 {
    float							rb_blend_constant_red_fp32;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_RED_FP32(struct A6XX_RB_BLEND_CONSTANT_RED_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_red_fp32)   & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008860,
        .value =
            (fui(fields.rb_blend_constant_red_fp32)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_RED_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_RED_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_RED_FP32) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_GREEN_FP32 {
    float							rb_blend_constant_green_fp32;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_GREEN_FP32(struct A6XX_RB_BLEND_CONSTANT_GREEN_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_green_fp32) & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008861,
        .value =
            (fui(fields.rb_blend_constant_green_fp32) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_GREEN_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_GREEN_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_GREEN_FP32) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_BLUE_FP32 {
    float							rb_blend_constant_blue_fp32;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_BLUE_FP32(struct A6XX_RB_BLEND_CONSTANT_BLUE_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_blue_fp32)  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008862,
        .value =
            (fui(fields.rb_blend_constant_blue_fp32)  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_BLUE_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_BLUE_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_BLUE_FP32) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CONSTANT_ALPHA_FP32 {
    float							rb_blend_constant_alpha_fp32;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CONSTANT_ALPHA_FP32(struct A6XX_RB_BLEND_CONSTANT_ALPHA_FP32 fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_blend_constant_alpha_fp32) & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008863,
        .value =
            (fui(fields.rb_blend_constant_alpha_fp32) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CONSTANT_ALPHA_FP32(...) pack_A6XX_RB_BLEND_CONSTANT_ALPHA_FP32(__struct_cast(A6XX_RB_BLEND_CONSTANT_ALPHA_FP32) { __VA_ARGS__ })

struct A6XX_RB_ALPHA_TEST_CNTL {
    uint32_t							alpha_ref;
    bool							alpha_test;
    enum adreno_compare_func					alpha_test_func;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_ALPHA_TEST_CNTL(struct A6XX_RB_ALPHA_TEST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.alpha_ref                         & 0xffffff00) == 0);
    assert((fields.alpha_test_func                   & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008864,
        .value =
            (fields.alpha_ref                         <<  0) |
            (fields.alpha_test                        <<  8) |
            (fields.alpha_test_func                   <<  9) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_ALPHA_TEST_CNTL(...) pack_A6XX_RB_ALPHA_TEST_CNTL(__struct_cast(A6XX_RB_ALPHA_TEST_CNTL) { __VA_ARGS__ })

struct A6XX_RB_BLEND_CNTL {
    uint32_t							blend_reads_dest;
    bool							independent_blend;
    bool							dual_color_in_enable;
    bool							alpha_to_coverage;
    bool							alpha_to_one;
    uint32_t							sample_mask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_BLEND_CNTL(struct A6XX_RB_BLEND_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.blend_reads_dest                  & 0xffffff00) == 0);
    assert((fields.sample_mask                       & 0xffff0000) == 0);
    assert((fields.unknown                           & 0xffff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008865,
        .value =
            (fields.blend_reads_dest                  <<  0) |
            (fields.independent_blend                 <<  8) |
            (fields.dual_color_in_enable              <<  9) |
            (fields.alpha_to_coverage                 << 10) |
            (fields.alpha_to_one                      << 11) |
            (fields.sample_mask                       << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_BLEND_CNTL(...) pack_A6XX_RB_BLEND_CNTL(__struct_cast(A6XX_RB_BLEND_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_PLANE_CNTL {
    enum a6xx_ztest_mode					z_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_PLANE_CNTL(struct A6XX_RB_DEPTH_PLANE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.z_mode                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008870,
        .value =
            (fields.z_mode                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_PLANE_CNTL(...) pack_A6XX_RB_DEPTH_PLANE_CNTL(__struct_cast(A6XX_RB_DEPTH_PLANE_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_CNTL {
    bool							z_test_enable;
    bool							z_write_enable;
    enum adreno_compare_func					zfunc;
    bool							z_clamp_enable;
    bool							z_read_enable;
    bool							z_bounds_enable;
    bool							o_depth_01_clamp_en;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_CNTL(struct A6XX_RB_DEPTH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.zfunc                             & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x000001ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008871,
        .value =
            (fields.z_test_enable                     <<  0) |
            (fields.z_write_enable                    <<  1) |
            (fields.zfunc                             <<  2) |
            (fields.z_clamp_enable                    <<  5) |
            (fields.z_read_enable                     <<  6) |
            (fields.z_bounds_enable                   <<  7) |
            (fields.o_depth_01_clamp_en               <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_CNTL(...) pack_A6XX_RB_DEPTH_CNTL(__struct_cast(A6XX_RB_DEPTH_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    uint32_t							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_DEPTH_BUFFER_INFO(struct A6XX_RB_DEPTH_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.depth_format                      & 0xfffffff8) == 0);
    assert((fields.unk3                              & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008872,
        .value =
            (fields.depth_format                      <<  0) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BUFFER_INFO(...) pack_A6XX_RB_DEPTH_BUFFER_INFO(__struct_cast(A6XX_RB_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_RB_DEPTH_BUFFER_INFO {
    enum a6xx_depth_format					depth_format;
    uint32_t							unk3;
    enum a6xx_tile_mode						tilemode;
    bool							losslesscompen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_DEPTH_BUFFER_INFO(struct A7XX_RB_DEPTH_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.depth_format                      & 0xfffffff8) == 0);
    assert((fields.unk3                              & 0xfffffffc) == 0);
    assert((fields.tilemode                          & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008872,
        .value =
            (fields.depth_format                      <<  0) |
            (fields.unk3                              <<  3) |
            (fields.tilemode                          <<  5) |
            (fields.losslesscompen                    <<  7) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_DEPTH_BUFFER_INFO(...) pack_A7XX_RB_DEPTH_BUFFER_INFO(__struct_cast(A7XX_RB_DEPTH_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_PITCH {
    uint32_t							rb_depth_buffer_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BUFFER_PITCH(struct A6XX_RB_DEPTH_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_depth_buffer_pitch >> 6)      & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x00003fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008873,
        .value =
            ((fields.rb_depth_buffer_pitch >> 6)      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BUFFER_PITCH(...) pack_A6XX_RB_DEPTH_BUFFER_PITCH(__struct_cast(A6XX_RB_DEPTH_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH {
    uint32_t							rb_depth_buffer_array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH(struct A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_depth_buffer_array_pitch >> 6) & 0xf0000000) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008874,
        .value =
            ((fields.rb_depth_buffer_array_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH(...) pack_A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH(__struct_cast(A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BUFFER_BASE(struct A6XX_RB_DEPTH_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008875,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_DEPTH_BUFFER_BASE(...) pack_A6XX_RB_DEPTH_BUFFER_BASE(__struct_cast(A6XX_RB_DEPTH_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_DEPTH_GMEM_BASE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_GMEM_BASE(struct A6XX_RB_DEPTH_GMEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008877,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_GMEM_BASE(...) pack_A6XX_RB_DEPTH_GMEM_BASE(__struct_cast(A6XX_RB_DEPTH_GMEM_BASE) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BOUND_MIN {
    float							rb_depth_bound_min;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BOUND_MIN(struct A6XX_RB_DEPTH_BOUND_MIN fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_depth_bound_min)           & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008878,
        .value =
            (fui(fields.rb_depth_bound_min)           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BOUND_MIN(...) pack_A6XX_RB_DEPTH_BOUND_MIN(__struct_cast(A6XX_RB_DEPTH_BOUND_MIN) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_BOUND_MAX {
    float							rb_depth_bound_max;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_BOUND_MAX(struct A6XX_RB_DEPTH_BOUND_MAX fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_depth_bound_max)           & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008879,
        .value =
            (fui(fields.rb_depth_bound_max)           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_BOUND_MAX(...) pack_A6XX_RB_DEPTH_BOUND_MAX(__struct_cast(A6XX_RB_DEPTH_BOUND_MAX) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_CNTL {
    bool							stencil_enable;
    bool							stencil_enable_bf;
    bool							stencil_read;
    enum adreno_compare_func					func;
    enum adreno_stencil_op					fail;
    enum adreno_stencil_op					zpass;
    enum adreno_stencil_op					zfail;
    enum adreno_compare_func					func_bf;
    enum adreno_stencil_op					fail_bf;
    enum adreno_stencil_op					zpass_bf;
    enum adreno_stencil_op					zfail_bf;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_CNTL(struct A6XX_RB_STENCIL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.func                              & 0xfffffff8) == 0);
    assert((fields.fail                              & 0xfffffff8) == 0);
    assert((fields.zpass                             & 0xfffffff8) == 0);
    assert((fields.zfail                             & 0xfffffff8) == 0);
    assert((fields.func_bf                           & 0xfffffff8) == 0);
    assert((fields.fail_bf                           & 0xfffffff8) == 0);
    assert((fields.zpass_bf                          & 0xfffffff8) == 0);
    assert((fields.zfail_bf                          & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0xffffff07) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008880,
        .value =
            (fields.stencil_enable                    <<  0) |
            (fields.stencil_enable_bf                 <<  1) |
            (fields.stencil_read                      <<  2) |
            (fields.func                              <<  8) |
            (fields.fail                              << 11) |
            (fields.zpass                             << 14) |
            (fields.zfail                             << 17) |
            (fields.func_bf                           << 20) |
            (fields.fail_bf                           << 23) |
            (fields.zpass_bf                          << 26) |
            (fields.zfail_bf                          << 29) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_CNTL(...) pack_A6XX_RB_STENCIL_CNTL(__struct_cast(A6XX_RB_STENCIL_CNTL) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_INFO {
    bool							separate_stencil;
    bool							unk1;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_STENCIL_BUFFER_INFO(struct A6XX_RB_STENCIL_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008881,
        .value =
            (fields.separate_stencil                  <<  0) |
            (fields.unk1                              <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_BUFFER_INFO(...) pack_A6XX_RB_STENCIL_BUFFER_INFO(__struct_cast(A6XX_RB_STENCIL_BUFFER_INFO) { __VA_ARGS__ })

struct A7XX_RB_STENCIL_BUFFER_INFO {
    bool							separate_stencil;
    bool							unk1;
    enum a6xx_tile_mode						tilemode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_STENCIL_BUFFER_INFO(struct A7XX_RB_STENCIL_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.tilemode                          & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008881,
        .value =
            (fields.separate_stencil                  <<  0) |
            (fields.unk1                              <<  1) |
            (fields.tilemode                          <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_STENCIL_BUFFER_INFO(...) pack_A7XX_RB_STENCIL_BUFFER_INFO(__struct_cast(A7XX_RB_STENCIL_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_PITCH {
    uint32_t							rb_stencil_buffer_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_BUFFER_PITCH(struct A6XX_RB_STENCIL_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_stencil_buffer_pitch >> 6)    & 0xfffff000) == 0);
    assert((fields.unknown                           & 0x00000fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008882,
        .value =
            ((fields.rb_stencil_buffer_pitch >> 6)    <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_BUFFER_PITCH(...) pack_A6XX_RB_STENCIL_BUFFER_PITCH(__struct_cast(A6XX_RB_STENCIL_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH {
    uint32_t							rb_stencil_buffer_array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH(struct A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_stencil_buffer_array_pitch >> 6) & 0xff000000) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008883,
        .value =
            ((fields.rb_stencil_buffer_array_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH(...) pack_A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH(__struct_cast(A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_BUFFER_BASE(struct A6XX_RB_STENCIL_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008884,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_STENCIL_BUFFER_BASE(...) pack_A6XX_RB_STENCIL_BUFFER_BASE(__struct_cast(A6XX_RB_STENCIL_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_STENCIL_GMEM_BASE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_GMEM_BASE(struct A6XX_RB_STENCIL_GMEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008886,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_GMEM_BASE(...) pack_A6XX_RB_STENCIL_GMEM_BASE(__struct_cast(A6XX_RB_STENCIL_GMEM_BASE) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_REF_CNTL {
    uint32_t							ref;
    uint32_t							bfref;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_REF_CNTL(struct A6XX_RB_STENCIL_REF_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.ref                               & 0xffffff00) == 0);
    assert((fields.bfref                             & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008887,
        .value =
            (fields.ref                               <<  0) |
            (fields.bfref                             <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_REF_CNTL(...) pack_A6XX_RB_STENCIL_REF_CNTL(__struct_cast(A6XX_RB_STENCIL_REF_CNTL) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_MASK {
    uint32_t							mask;
    uint32_t							bfmask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_MASK(struct A6XX_RB_STENCIL_MASK fields)
{
#ifndef NDEBUG
    assert((fields.mask                              & 0xffffff00) == 0);
    assert((fields.bfmask                            & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008888,
        .value =
            (fields.mask                              <<  0) |
            (fields.bfmask                            <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_MASK(...) pack_A6XX_RB_STENCIL_MASK(__struct_cast(A6XX_RB_STENCIL_MASK) { __VA_ARGS__ })

struct A6XX_RB_STENCIL_WRITE_MASK {
    uint32_t							wrmask;
    uint32_t							bfwrmask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_STENCIL_WRITE_MASK(struct A6XX_RB_STENCIL_WRITE_MASK fields)
{
#ifndef NDEBUG
    assert((fields.wrmask                            & 0xffffff00) == 0);
    assert((fields.bfwrmask                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008889,
        .value =
            (fields.wrmask                            <<  0) |
            (fields.bfwrmask                          <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_STENCIL_WRITE_MASK(...) pack_A6XX_RB_STENCIL_WRITE_MASK(__struct_cast(A6XX_RB_STENCIL_WRITE_MASK) { __VA_ARGS__ })

struct A6XX_RB_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_WINDOW_OFFSET(struct A6XX_RB_WINDOW_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008890,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_WINDOW_OFFSET(...) pack_A6XX_RB_WINDOW_OFFSET(__struct_cast(A6XX_RB_WINDOW_OFFSET) { __VA_ARGS__ })

struct A6XX_RB_SAMPLE_COUNTER_CNTL {
    bool							disable;
    bool							copy;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_SAMPLE_COUNTER_CNTL(struct A6XX_RB_SAMPLE_COUNTER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008891,
        .value =
            (fields.disable                           <<  0) |
            (fields.copy                              <<  1) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SAMPLE_COUNTER_CNTL(...) pack_A6XX_RB_SAMPLE_COUNTER_CNTL(__struct_cast(A6XX_RB_SAMPLE_COUNTER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_LRZ_CNTL {
    bool							enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_LRZ_CNTL(struct A6XX_RB_LRZ_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008898,
        .value =
            (fields.enable                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_LRZ_CNTL(...) pack_A6XX_RB_LRZ_CNTL(__struct_cast(A6XX_RB_LRZ_CNTL) { __VA_ARGS__ })

struct A7XX_RB_UNKNOWN_8899 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_UNKNOWN_8899(struct A7XX_RB_UNKNOWN_8899 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008899,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_UNKNOWN_8899(...) pack_A7XX_RB_UNKNOWN_8899(__struct_cast(A7XX_RB_UNKNOWN_8899) { __VA_ARGS__ })

struct A6XX_RB_VIEWPORT_ZCLAMP_MIN {
    float							rb_viewport_zclamp_min;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_VIEWPORT_ZCLAMP_MIN(struct A6XX_RB_VIEWPORT_ZCLAMP_MIN fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_viewport_zclamp_min)       & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088c0,
        .value =
            (fui(fields.rb_viewport_zclamp_min)       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_VIEWPORT_ZCLAMP_MIN(...) pack_A6XX_RB_VIEWPORT_ZCLAMP_MIN(__struct_cast(A6XX_RB_VIEWPORT_ZCLAMP_MIN) { __VA_ARGS__ })

struct A6XX_RB_VIEWPORT_ZCLAMP_MAX {
    float							rb_viewport_zclamp_max;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_VIEWPORT_ZCLAMP_MAX(struct A6XX_RB_VIEWPORT_ZCLAMP_MAX fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_viewport_zclamp_max)       & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088c1,
        .value =
            (fui(fields.rb_viewport_zclamp_max)       <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_VIEWPORT_ZCLAMP_MAX(...) pack_A6XX_RB_VIEWPORT_ZCLAMP_MAX(__struct_cast(A6XX_RB_VIEWPORT_ZCLAMP_MAX) { __VA_ARGS__ })

struct A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG {
    float							rb_viewport_zclamp_min_reg;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG(uint32_t __i, struct A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_viewport_zclamp_min_reg)   & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000088b0 + 0x1*__i),
        .value =
            (fui(fields.rb_viewport_zclamp_min_reg)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG(__i, ...) pack_A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG(__i, __struct_cast(A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG) { __VA_ARGS__ })

struct A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG {
    float							rb_viewport_zclamp_max_reg;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG(uint32_t __i, struct A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG fields)
{
#ifndef NDEBUG
    assert((fui(fields.rb_viewport_zclamp_max_reg)   & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x000088c0 + 0x1*__i),
        .value =
            (fui(fields.rb_viewport_zclamp_max_reg)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG(__i, ...) pack_A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG(__i, __struct_cast(A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_0 {
    uint32_t							unk0;
    uint32_t							unk16;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CNTL_0(struct A6XX_RB_RESOLVE_CNTL_0 fields)
{
#ifndef NDEBUG
    assert((fields.unk0                              & 0xffffe000) == 0);
    assert((fields.unk16                             & 0xfffff800) == 0);
    assert((fields.unknown                           & 0x07ff1fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d0,
        .value =
            (fields.unk0                              <<  0) |
            (fields.unk16                             << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CNTL_0(...) pack_A6XX_RB_RESOLVE_CNTL_0(__struct_cast(A6XX_RB_RESOLVE_CNTL_0) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_1 {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CNTL_1(struct A6XX_RB_RESOLVE_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d1,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CNTL_1(...) pack_A6XX_RB_RESOLVE_CNTL_1(__struct_cast(A6XX_RB_RESOLVE_CNTL_1) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_2 {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CNTL_2(struct A6XX_RB_RESOLVE_CNTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d2,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CNTL_2(...) pack_A6XX_RB_RESOLVE_CNTL_2(__struct_cast(A6XX_RB_RESOLVE_CNTL_2) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CNTL_3 {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CNTL_3(struct A6XX_RB_RESOLVE_CNTL_3 fields)
{
#ifndef NDEBUG
    assert(((fields.binw >> 5)                       & 0xffffffc0) == 0);
    assert(((fields.binh >> 4)                       & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x00007f3f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d3,
        .value =
            ((fields.binw >> 5)                       <<  0) |
            ((fields.binh >> 4)                       <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CNTL_3(...) pack_A6XX_RB_RESOLVE_CNTL_3(__struct_cast(A6XX_RB_RESOLVE_CNTL_3) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_CNTL_3 {
    uint32_t							binw;
    uint32_t							binh;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_RESOLVE_CNTL_3(struct A8XX_RB_RESOLVE_CNTL_3 fields)
{
#ifndef NDEBUG
    assert(((fields.binw >> 5)                       & 0xfffffc00) == 0);
    assert(((fields.binh >> 4)                       & 0xfffff800) == 0);
    assert((fields.unknown                           & 0x07ff03ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d3,
        .value =
            ((fields.binw >> 5)                       <<  0) |
            ((fields.binh >> 4)                       << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_RESOLVE_CNTL_3(...) pack_A8XX_RB_RESOLVE_CNTL_3(__struct_cast(A8XX_RB_RESOLVE_CNTL_3) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_WINDOW_OFFSET {
    uint32_t							x;
    uint32_t							y;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_WINDOW_OFFSET(struct A6XX_RB_RESOLVE_WINDOW_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.x                                 & 0xffffc000) == 0);
    assert((fields.y                                 & 0xffffc000) == 0);
    assert((fields.unknown                           & 0x3fff3fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d4,
        .value =
            (fields.x                                 <<  0) |
            (fields.y                                 << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_WINDOW_OFFSET(...) pack_A6XX_RB_RESOLVE_WINDOW_OFFSET(__struct_cast(A6XX_RB_RESOLVE_WINDOW_OFFSET) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_GMEM_BUFFER_INFO {
    enum a3xx_msaa_samples					samples;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_GMEM_BUFFER_INFO(struct A6XX_RB_RESOLVE_GMEM_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000018) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d5,
        .value =
            (fields.samples                           <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_GMEM_BUFFER_INFO(...) pack_A6XX_RB_RESOLVE_GMEM_BUFFER_INFO(__struct_cast(A6XX_RB_RESOLVE_GMEM_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_GMEM_BUFFER_BASE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_GMEM_BUFFER_BASE(struct A6XX_RB_RESOLVE_GMEM_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d6,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_GMEM_BUFFER_BASE(...) pack_A6XX_RB_RESOLVE_GMEM_BUFFER_BASE(__struct_cast(A6XX_RB_RESOLVE_GMEM_BUFFER_BASE) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO {
    enum a6xx_tile_mode						tile_mode;
    bool							flags;
    enum a3xx_msaa_samples					samples;
    enum a3xx_color_swap					color_swap;
    enum a6xx_format						color_format;
    bool							unk15;
    bool							mutableen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.tile_mode                         & 0xfffffffc) == 0);
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.color_swap                        & 0xfffffffc) == 0);
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0001ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d7,
        .value =
            (fields.tile_mode                         <<  0) |
            (fields.flags                             <<  2) |
            (fields.samples                           <<  3) |
            (fields.color_swap                        <<  5) |
            (fields.color_format                      <<  7) |
            (fields.unk15                             << 15) |
            (fields.mutableen                         << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088d8,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH {
    uint32_t							rb_resolve_system_buffer_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_resolve_system_buffer_pitch >> 6) & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088da,
        .value =
            ((fields.rb_resolve_system_buffer_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH {
    uint32_t							rb_resolve_system_buffer_array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH(struct A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_resolve_system_buffer_array_pitch >> 6) & 0xe0000000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088db,
        .value =
            ((fields.rb_resolve_system_buffer_array_pitch >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH(...) pack_A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE(struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088dc,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE(...) pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH(struct A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xfffff800) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088de,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW0(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088df,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW0(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW0(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW0) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW1(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW1(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW1(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW1) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW2(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e1,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW2(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW2(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW2) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW3(struct A6XX_RB_RESOLVE_CLEAR_COLOR_DW3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e2,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_CLEAR_COLOR_DW3(...) pack_A6XX_RB_RESOLVE_CLEAR_COLOR_DW3(__struct_cast(A6XX_RB_RESOLVE_CLEAR_COLOR_DW3) { __VA_ARGS__ })

struct A6XX_RB_RESOLVE_OPERATION {
    enum a6xx_blit_event_type					type;
    bool							sample_0;
    bool							depth;
    uint32_t							clear_mask;
    uint32_t							last;
    uint32_t							buffer_id;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RESOLVE_OPERATION(struct A6XX_RB_RESOLVE_OPERATION fields)
{
#ifndef NDEBUG
    assert((fields.type                              & 0xfffffffc) == 0);
    assert((fields.clear_mask                        & 0xfffffff0) == 0);
    assert((fields.last                              & 0xfffffffc) == 0);
    assert((fields.buffer_id                         & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0000f3ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e3,
        .value =
            (fields.type                              <<  0) |
            (fields.sample_0                          <<  2) |
            (fields.depth                             <<  3) |
            (fields.clear_mask                        <<  4) |
            (fields.last                              <<  8) |
            (fields.buffer_id                         << 12) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RESOLVE_OPERATION(...) pack_A6XX_RB_RESOLVE_OPERATION(__struct_cast(A6XX_RB_RESOLVE_OPERATION) { __VA_ARGS__ })

struct A7XX_RB_CLEAR_TARGET {
    enum a7xx_blit_clear_mode					clear_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_CLEAR_TARGET(struct A7XX_RB_CLEAR_TARGET fields)
{
#ifndef NDEBUG
    assert((fields.clear_mode                        & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e4,
        .value =
            (fields.clear_mode                        <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_CLEAR_TARGET(...) pack_A7XX_RB_CLEAR_TARGET(__struct_cast(A7XX_RB_CLEAR_TARGET) { __VA_ARGS__ })

struct A7XX_RB_CCU_CACHE_CNTL {
    uint32_t							depth_offset_hi;
    uint32_t							color_offset_hi;
    enum a6xx_ccu_cache_size					depth_cache_size;
    uint32_t							depth_offset;
    enum a6xx_ccu_cache_size					color_cache_size;
    uint32_t							color_offset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_CCU_CACHE_CNTL(struct A7XX_RB_CCU_CACHE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.depth_offset_hi                   & 0xfffffffe) == 0);
    assert((fields.color_offset_hi                   & 0xfffffffe) == 0);
    assert((fields.depth_cache_size                  & 0xfffffffc) == 0);
    assert(((fields.depth_offset >> 12)              & 0xfffffe00) == 0);
    assert((fields.color_cache_size                  & 0xfffffffc) == 0);
    assert(((fields.color_offset >> 12)              & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0xfffffc05) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e5,
        .value =
            (fields.depth_offset_hi                   <<  0) |
            (fields.color_offset_hi                   <<  2) |
            (fields.depth_cache_size                  << 10) |
            ((fields.depth_offset >> 12)              << 12) |
            (fields.color_cache_size                  << 21) |
            ((fields.color_offset >> 12)              << 23) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_CCU_CACHE_CNTL(...) pack_A7XX_RB_CCU_CACHE_CNTL(__struct_cast(A7XX_RB_CCU_CACHE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CCU_CACHE_CNTL {
    uint32_t							color_offset;
    enum a6xx_ccu_cache_size					color_cache_size;
    uint32_t							depth_offset;
    enum a6xx_ccu_cache_size					depth_cache_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_CCU_CACHE_CNTL(struct A8XX_RB_CCU_CACHE_CNTL fields)
{
#ifndef NDEBUG
    assert(((fields.color_offset >> 12)              & 0xffffc000) == 0);
    assert((fields.color_cache_size                  & 0xfffffffc) == 0);
    assert(((fields.depth_offset >> 12)              & 0xffffc000) == 0);
    assert((fields.depth_cache_size                  & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e5,
        .value =
            ((fields.color_offset >> 12)              <<  0) |
            (fields.color_cache_size                  << 14) |
            ((fields.depth_offset >> 12)              << 16) |
            (fields.depth_cache_size                  << 30) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_CCU_CACHE_CNTL(...) pack_A8XX_RB_CCU_CACHE_CNTL(__struct_cast(A8XX_RB_CCU_CACHE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL {
    bool							full_in_gmem;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL(struct A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088e6,
        .value =
            (fields.full_in_gmem                      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL(...) pack_A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL(__struct_cast(A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_88F0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_88F0(struct A6XX_RB_UNKNOWN_88F0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088f0,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_88F0(...) pack_A6XX_RB_UNKNOWN_88F0(__struct_cast(A6XX_RB_UNKNOWN_88F0) { __VA_ARGS__ })

struct A6XX_RB_UNK_FLAG_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNK_FLAG_BUFFER_BASE(struct A6XX_RB_UNK_FLAG_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088f1,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_UNK_FLAG_BUFFER_BASE(...) pack_A6XX_RB_UNK_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_UNK_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_UNK_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_UNK_FLAG_BUFFER_PITCH(struct A6XX_RB_UNK_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xfffff800) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088f3,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNK_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_UNK_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_UNK_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_VRS_CONFIG {
    bool							unk2;
    bool							pipeline_fsr_enable;
    bool							attachment_fsr_enable;
    bool							primitive_fsr_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_VRS_CONFIG(struct A6XX_RB_VRS_CONFIG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00040034) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088f4,
        .value =
            (fields.unk2                              <<  2) |
            (fields.pipeline_fsr_enable               <<  4) |
            (fields.attachment_fsr_enable             <<  5) |
            (fields.primitive_fsr_enable              << 18) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_VRS_CONFIG(...) pack_A6XX_RB_VRS_CONFIG(__struct_cast(A6XX_RB_VRS_CONFIG) { __VA_ARGS__ })

struct A7XX_RB_BIN_FOVEAT {
    bool							binscaleen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_BIN_FOVEAT(struct A7XX_RB_BIN_FOVEAT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000040) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000088f5,
        .value =
            (fields.binscaleen                        <<  6) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_BIN_FOVEAT(...) pack_A7XX_RB_BIN_FOVEAT(__struct_cast(A7XX_RB_BIN_FOVEAT) { __VA_ARGS__ })

struct A6XX_RB_DEPTH_FLAG_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_FLAG_BUFFER_BASE(struct A6XX_RB_DEPTH_FLAG_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008900,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_DEPTH_FLAG_BUFFER_BASE(...) pack_A6XX_RB_DEPTH_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_DEPTH_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_DEPTH_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							unk8;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DEPTH_FLAG_BUFFER_PITCH(struct A6XX_RB_DEPTH_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xffffff80) == 0);
    assert((fields.unk8                              & 0xfffffff8) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffe0000) == 0);
    assert((fields.unknown                           & 0x0fffff7f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008902,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            (fields.unk8                              <<  8) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_DEPTH_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_DEPTH_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_COLOR_FLAG_BUFFER_ADDR {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_COLOR_FLAG_BUFFER_ADDR(uint32_t __i, struct A6XX_RB_COLOR_FLAG_BUFFER_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008903 + 0x3*__i),
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_COLOR_FLAG_BUFFER_ADDR(__i, ...) pack_A6XX_RB_COLOR_FLAG_BUFFER_ADDR(__i, __struct_cast(A6XX_RB_COLOR_FLAG_BUFFER_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_COLOR_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_COLOR_FLAG_BUFFER_PITCH(uint32_t __i, struct A6XX_RB_COLOR_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xfffff800) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008905 + 0x3*__i),
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_COLOR_FLAG_BUFFER_PITCH(__i, ...) pack_A6XX_RB_COLOR_FLAG_BUFFER_PITCH(__i, __struct_cast(A6XX_RB_COLOR_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_SAMPLE_COUNTER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_SAMPLE_COUNTER_BASE(struct A6XX_RB_SAMPLE_COUNTER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008927,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_SAMPLE_COUNTER_BASE(...) pack_A6XX_RB_SAMPLE_COUNTER_BASE(__struct_cast(A6XX_RB_SAMPLE_COUNTER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_RB_DEPTH_GMEM_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_DEPTH_GMEM_DIMENSION(struct A8XX_RB_DEPTH_GMEM_DIMENSION fields)
{
#ifndef NDEBUG
    assert((fields.width                             & 0xffff8000) == 0);
    assert((fields.height                            & 0xffff8000) == 0);
    assert((fields.unknown                           & 0x7fff7fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008813,
        .value =
            (fields.width                             <<  0) |
            (fields.height                            << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_DEPTH_GMEM_DIMENSION(...) pack_A8XX_RB_DEPTH_GMEM_DIMENSION(__struct_cast(A8XX_RB_DEPTH_GMEM_DIMENSION) { __VA_ARGS__ })

struct A8XX_RB_STENCIL_GMEM_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_STENCIL_GMEM_DIMENSION(struct A8XX_RB_STENCIL_GMEM_DIMENSION fields)
{
#ifndef NDEBUG
    assert((fields.width                             & 0xffff8000) == 0);
    assert((fields.height                            & 0xffff8000) == 0);
    assert((fields.unknown                           & 0x7fff7fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008814,
        .value =
            (fields.width                             <<  0) |
            (fields.height                            << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_STENCIL_GMEM_DIMENSION(...) pack_A8XX_RB_STENCIL_GMEM_DIMENSION(__struct_cast(A8XX_RB_STENCIL_GMEM_DIMENSION) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_GMEM_DIMENSION {
    uint32_t							width;
    uint32_t							height;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_RESOLVE_GMEM_DIMENSION(struct A8XX_RB_RESOLVE_GMEM_DIMENSION fields)
{
#ifndef NDEBUG
    assert((fields.width                             & 0xffff8000) == 0);
    assert((fields.height                            & 0xffff8000) == 0);
    assert((fields.unknown                           & 0x7fff7fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008815,
        .value =
            (fields.width                             <<  0) |
            (fields.height                            << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_RESOLVE_GMEM_DIMENSION(...) pack_A8XX_RB_RESOLVE_GMEM_DIMENSION(__struct_cast(A8XX_RB_RESOLVE_GMEM_DIMENSION) { __VA_ARGS__ })

struct A8XX_RB_MRT_GMEM_DIMENSION_REG {
    uint32_t							width;
    uint32_t							height;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_MRT_GMEM_DIMENSION_REG(uint32_t __i, struct A8XX_RB_MRT_GMEM_DIMENSION_REG fields)
{
#ifndef NDEBUG
    assert((fields.width                             & 0xffff8000) == 0);
    assert((fields.height                            & 0xffff8000) == 0);
    assert((fields.unknown                           & 0x7fff7fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008930 + 0x1*__i),
        .value =
            (fields.width                             <<  0) |
            (fields.height                            << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_MRT_GMEM_DIMENSION_REG(__i, ...) pack_A8XX_RB_MRT_GMEM_DIMENSION_REG(__i, __struct_cast(A8XX_RB_MRT_GMEM_DIMENSION_REG) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A00 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8A00(struct A6XX_RB_UNKNOWN_8A00 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008a00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8A00(...) pack_A6XX_RB_UNKNOWN_8A00(__struct_cast(A6XX_RB_UNKNOWN_8A00) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A10 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8A10(struct A6XX_RB_UNKNOWN_8A10 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008a10,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8A10(...) pack_A6XX_RB_UNKNOWN_8A10(__struct_cast(A6XX_RB_UNKNOWN_8A10) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A20 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8A20(struct A6XX_RB_UNKNOWN_8A20 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008a20,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8A20(...) pack_A6XX_RB_UNKNOWN_8A20(__struct_cast(A6XX_RB_UNKNOWN_8A20) { __VA_ARGS__ })

struct A6XX_RB_UNKNOWN_8A30 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_UNKNOWN_8A30(struct A6XX_RB_UNKNOWN_8A30 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008a30,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_UNKNOWN_8A30(...) pack_A6XX_RB_UNKNOWN_8A30(__struct_cast(A6XX_RB_UNKNOWN_8A30) { __VA_ARGS__ })

struct A6XX_RB_A2D_BLT_CNTL {
    enum a6xx_rotation						rotate;
    bool							overwriteen;
    uint32_t							unk4;
    bool							solid_color;
    enum a6xx_format						color_format;
    bool							scissor;
    uint32_t							unk17;
    bool							d24s8;
    uint32_t							mask;
    enum a6xx_2d_ifmt						ifmt;
    bool							unk27;
    bool							unk28;
    enum a6xx_raster_mode					raster_mode;
    bool							copy;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_BLT_CNTL(struct A6XX_RB_A2D_BLT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.rotate                            & 0xfffffff8) == 0);
    assert((fields.unk4                              & 0xfffffff8) == 0);
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.unk17                             & 0xfffffffc) == 0);
    assert((fields.mask                              & 0xfffffff0) == 0);
    assert((fields.ifmt                              & 0xfffffff8) == 0);
    assert((fields.raster_mode                       & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x7fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c00,
        .value =
            (fields.rotate                            <<  0) |
            (fields.overwriteen                       <<  3) |
            (fields.unk4                              <<  4) |
            (fields.solid_color                       <<  7) |
            (fields.color_format                      <<  8) |
            (fields.scissor                           << 16) |
            (fields.unk17                             << 17) |
            (fields.d24s8                             << 19) |
            (fields.mask                              << 20) |
            (fields.ifmt                              << 24) |
            (fields.unk27                             << 27) |
            (fields.unk28                             << 28) |
            (fields.raster_mode                       << 29) |
            (fields.copy                              << 30) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_BLT_CNTL(...) pack_A6XX_RB_A2D_BLT_CNTL(__struct_cast(A6XX_RB_A2D_BLT_CNTL) { __VA_ARGS__ })

struct A6XX_RB_A2D_PIXEL_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_PIXEL_CNTL(struct A6XX_RB_A2D_PIXEL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_PIXEL_CNTL(...) pack_A6XX_RB_A2D_PIXEL_CNTL(__struct_cast(A6XX_RB_A2D_PIXEL_CNTL) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_INFO {
    enum a6xx_format						color_format;
    enum a6xx_tile_mode						tile_mode;
    enum a3xx_color_swap					color_swap;
    bool							flags;
    bool							srgb;
    enum a3xx_msaa_samples					samples;
    bool							mutableen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_INFO(struct A6XX_RB_A2D_DEST_BUFFER_INFO fields)
{
#ifndef NDEBUG
    assert((fields.color_format                      & 0xffffff00) == 0);
    assert((fields.tile_mode                         & 0xfffffffc) == 0);
    assert((fields.color_swap                        & 0xfffffffc) == 0);
    assert((fields.samples                           & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0002ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c17,
        .value =
            (fields.color_format                      <<  0) |
            (fields.tile_mode                         <<  8) |
            (fields.color_swap                        << 10) |
            (fields.flags                             << 12) |
            (fields.srgb                              << 13) |
            (fields.samples                           << 14) |
            (fields.mutableen                         << 17) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_INFO(...) pack_A6XX_RB_A2D_DEST_BUFFER_INFO(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_INFO) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_BASE(struct A6XX_RB_A2D_DEST_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c18,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_BASE(...) pack_A6XX_RB_A2D_DEST_BUFFER_BASE(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_BUFFER_PITCH {
    uint32_t							rb_a2d_dest_buffer_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_PITCH(struct A6XX_RB_A2D_DEST_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.rb_a2d_dest_buffer_pitch >> 6)   & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1a,
        .value =
            ((fields.rb_a2d_dest_buffer_pitch >> 6)   <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_PITCH(...) pack_A6XX_RB_A2D_DEST_BUFFER_PITCH(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_BASE_1 {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_BASE_1(struct A6XX_RB_A2D_DEST_BUFFER_BASE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1b,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_BASE_1(...) pack_A6XX_RB_A2D_DEST_BUFFER_BASE_1(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_BASE_1) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_BUFFER_PITCH_1 {
    uint32_t							rb_a2d_dest_buffer_pitch_1;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_PITCH_1(struct A6XX_RB_A2D_DEST_BUFFER_PITCH_1 fields)
{
#ifndef NDEBUG
    assert(((fields.rb_a2d_dest_buffer_pitch_1 >> 6) & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1d,
        .value =
            ((fields.rb_a2d_dest_buffer_pitch_1 >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_PITCH_1(...) pack_A6XX_RB_A2D_DEST_BUFFER_PITCH_1(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_PITCH_1) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_BUFFER_BASE_2 {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_BUFFER_BASE_2(struct A6XX_RB_A2D_DEST_BUFFER_BASE_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c1e,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_A2D_DEST_BUFFER_BASE_2(...) pack_A6XX_RB_A2D_DEST_BUFFER_BASE_2(__struct_cast(A6XX_RB_A2D_DEST_BUFFER_BASE_2) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c20,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH {
    uint32_t							pitch;
    uint32_t							array_pitch;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH fields)
{
#ifndef NDEBUG
    assert(((fields.pitch >> 6)                      & 0xfffff800) == 0);
    assert(((fields.array_pitch >> 7)                & 0xfffc0000) == 0);
    assert((fields.unknown                           & 0x1fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c22,
        .value =
            ((fields.pitch >> 6)                      <<  0) |
            ((fields.array_pitch >> 7)                << 11) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH) { __VA_ARGS__ })

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1 {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c23,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1 {
    uint32_t							rb_a2d_dest_flag_buffer_pitch_1;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1(struct A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1 fields)
{
#ifndef NDEBUG
    assert(((fields.rb_a2d_dest_flag_buffer_pitch_1 >> 6) & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c25,
        .value =
            ((fields.rb_a2d_dest_flag_buffer_pitch_1 >> 6) <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1(...) pack_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1(__struct_cast(A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW0 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW0(struct A6XX_RB_A2D_CLEAR_COLOR_DW0 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2c,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW0(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW0(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW0) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW1(struct A6XX_RB_A2D_CLEAR_COLOR_DW1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW1(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW1(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW1) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW2(struct A6XX_RB_A2D_CLEAR_COLOR_DW2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2e,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW2(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW2(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW2) { __VA_ARGS__ })

struct A6XX_RB_A2D_CLEAR_COLOR_DW3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_A2D_CLEAR_COLOR_DW3(struct A6XX_RB_A2D_CLEAR_COLOR_DW3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c2f,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_A2D_CLEAR_COLOR_DW3(...) pack_A6XX_RB_A2D_CLEAR_COLOR_DW3(__struct_cast(A6XX_RB_A2D_CLEAR_COLOR_DW3) { __VA_ARGS__ })

struct A7XX_RB_UNKNOWN_8C34 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_UNKNOWN_8C34(struct A7XX_RB_UNKNOWN_8C34 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008c34,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_UNKNOWN_8C34(...) pack_A7XX_RB_UNKNOWN_8C34(__struct_cast(A7XX_RB_UNKNOWN_8C34) { __VA_ARGS__ })

struct A6XX_RB_RBP_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_RBP_CNTL(struct A6XX_RB_RBP_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_RBP_CNTL(...) pack_A6XX_RB_RBP_CNTL(__struct_cast(A6XX_RB_RBP_CNTL) { __VA_ARGS__ })

struct A6XX_RB_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_DBG_ECO_CNTL(struct A6XX_RB_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e04,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_DBG_ECO_CNTL(...) pack_A6XX_RB_DBG_ECO_CNTL(__struct_cast(A6XX_RB_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_RB_ADDR_MODE_CNTL {
    enum a5xx_address_mode					rb_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_ADDR_MODE_CNTL(struct A6XX_RB_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.rb_addr_mode_cntl                 & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e05,
        .value =
            (fields.rb_addr_mode_cntl                 <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_ADDR_MODE_CNTL(...) pack_A6XX_RB_ADDR_MODE_CNTL(__struct_cast(A6XX_RB_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RB_CCU_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_CCU_DBG_ECO_CNTL(struct A7XX_RB_CCU_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e06,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_CCU_DBG_ECO_CNTL(...) pack_A7XX_RB_CCU_DBG_ECO_CNTL(__struct_cast(A7XX_RB_CCU_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_RB_CCU_CNTL {
    bool							gmem_fast_clear_disable;
    bool							concurrent_resolve;
    uint32_t							depth_offset_hi;
    uint32_t							color_offset_hi;
    enum a6xx_ccu_cache_size					depth_cache_size;
    uint32_t							depth_offset;
    enum a6xx_ccu_cache_size					color_cache_size;
    uint32_t							color_offset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_CCU_CNTL(struct A6XX_RB_CCU_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.depth_offset_hi                   & 0xfffffffe) == 0);
    assert((fields.color_offset_hi                   & 0xfffffffe) == 0);
    assert((fields.depth_cache_size                  & 0xfffffffc) == 0);
    assert(((fields.depth_offset >> 12)              & 0xfffffe00) == 0);
    assert((fields.color_cache_size                  & 0xfffffffc) == 0);
    assert(((fields.color_offset >> 12)              & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0xfffffe85) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e07,
        .value =
            (fields.gmem_fast_clear_disable           <<  0) |
            (fields.concurrent_resolve                <<  2) |
            (fields.depth_offset_hi                   <<  7) |
            (fields.color_offset_hi                   <<  9) |
            (fields.depth_cache_size                  << 10) |
            ((fields.depth_offset >> 12)              << 12) |
            (fields.color_cache_size                  << 21) |
            ((fields.color_offset >> 12)              << 23) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_CCU_CNTL(...) pack_A6XX_RB_CCU_CNTL(__struct_cast(A6XX_RB_CCU_CNTL) { __VA_ARGS__ })

struct A7XX_RB_CCU_CNTL {
    bool							gmem_fast_clear_disable;
    enum a7xx_concurrent_resolve_mode				concurrent_resolve_mode;
    enum a7xx_concurrent_unresolve_mode				concurrent_unresolve_mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_CCU_CNTL(struct A7XX_RB_CCU_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.concurrent_resolve_mode           & 0xfffffffc) == 0);
    assert((fields.concurrent_unresolve_mode         & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000006d) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e07,
        .value =
            (fields.gmem_fast_clear_disable           <<  0) |
            (fields.concurrent_resolve_mode           <<  2) |
            (fields.concurrent_unresolve_mode         <<  5) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_CCU_CNTL(...) pack_A7XX_RB_CCU_CNTL(__struct_cast(A7XX_RB_CCU_CNTL) { __VA_ARGS__ })

struct A6XX_RB_NC_MODE_CNTL {
    bool							mode;
    uint32_t							lower_bit;
    bool							min_access_length;
    bool							amsbc;
    uint32_t							upper_bit;
    bool							rgb565_predicator;
    uint32_t							unk12;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_NC_MODE_CNTL(struct A6XX_RB_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.lower_bit                         & 0xfffffffc) == 0);
    assert((fields.upper_bit                         & 0xfffffffe) == 0);
    assert((fields.unk12                             & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00003c1f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e08,
        .value =
            (fields.mode                              <<  0) |
            (fields.lower_bit                         <<  1) |
            (fields.min_access_length                 <<  3) |
            (fields.amsbc                             <<  4) |
            (fields.upper_bit                         << 10) |
            (fields.rgb565_predicator                 << 11) |
            (fields.unk12                             << 12) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_NC_MODE_CNTL(...) pack_A6XX_RB_NC_MODE_CNTL(__struct_cast(A6XX_RB_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CCU_NC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_CCU_NC_MODE_CNTL(struct A8XX_RB_CCU_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e08,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_CCU_NC_MODE_CNTL(...) pack_A8XX_RB_CCU_NC_MODE_CNTL(__struct_cast(A8XX_RB_CCU_NC_MODE_CNTL) { __VA_ARGS__ })

struct A7XX_RB_UNKNOWN_8E09 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_UNKNOWN_8E09(struct A7XX_RB_UNKNOWN_8E09 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e09,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_UNKNOWN_8E09(...) pack_A7XX_RB_UNKNOWN_8E09(__struct_cast(A7XX_RB_UNKNOWN_8E09) { __VA_ARGS__ })

struct A8XX_RB_GC_GMEM_PROTECT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_GC_GMEM_PROTECT(struct A8XX_RB_GC_GMEM_PROTECT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e09,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_GC_GMEM_PROTECT(...) pack_A8XX_RB_GC_GMEM_PROTECT(__struct_cast(A8XX_RB_GC_GMEM_PROTECT) { __VA_ARGS__ })

struct A8XX_RB_LPAC_GMEM_PROTECT {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_LPAC_GMEM_PROTECT(struct A8XX_RB_LPAC_GMEM_PROTECT fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e0a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_LPAC_GMEM_PROTECT(...) pack_A8XX_RB_LPAC_GMEM_PROTECT(__struct_cast(A8XX_RB_LPAC_GMEM_PROTECT) { __VA_ARGS__ })

struct A6XX_RB_PERFCTR_RB_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PERFCTR_RB_SEL_REG(uint32_t __i, struct A6XX_RB_PERFCTR_RB_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008e10 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PERFCTR_RB_SEL_REG(__i, ...) pack_A6XX_RB_PERFCTR_RB_SEL_REG(__i, __struct_cast(A6XX_RB_PERFCTR_RB_SEL_REG) { __VA_ARGS__ })

struct A6XX_RB_PERFCTR_CCU_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_PERFCTR_CCU_SEL_REG(uint32_t __i, struct A6XX_RB_PERFCTR_CCU_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008e18 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PERFCTR_CCU_SEL_REG(__i, ...) pack_A6XX_RB_PERFCTR_CCU_SEL_REG(__i, __struct_cast(A6XX_RB_PERFCTR_CCU_SEL_REG) { __VA_ARGS__ })

struct A8XX_RB_CMP_NC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_CMP_NC_MODE_CNTL(struct A8XX_RB_CMP_NC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008f00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_CMP_NC_MODE_CNTL(...) pack_A8XX_RB_CMP_NC_MODE_CNTL(__struct_cast(A8XX_RB_CMP_NC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_RB_RESOLVE_PREFETCH_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_RESOLVE_PREFETCH_CNTL(struct A8XX_RB_RESOLVE_PREFETCH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008f01,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_RESOLVE_PREFETCH_CNTL(...) pack_A8XX_RB_RESOLVE_PREFETCH_CNTL(__struct_cast(A8XX_RB_RESOLVE_PREFETCH_CNTL) { __VA_ARGS__ })

struct A8XX_RB_CMP_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_CMP_DBG_ECO_CNTL(struct A8XX_RB_CMP_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008f02,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_CMP_DBG_ECO_CNTL(...) pack_A8XX_RB_CMP_DBG_ECO_CNTL(__struct_cast(A8XX_RB_CMP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_RB_UNSLICE_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_UNSLICE_STATUS(struct A8XX_RB_UNSLICE_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008f03,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_UNSLICE_STATUS(...) pack_A8XX_RB_UNSLICE_STATUS(__struct_cast(A8XX_RB_UNSLICE_STATUS) { __VA_ARGS__ })

struct A6XX_RB_CMP_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_CMP_DBG_ECO_CNTL(struct A6XX_RB_CMP_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e28,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_CMP_DBG_ECO_CNTL(...) pack_A6XX_RB_CMP_DBG_ECO_CNTL(__struct_cast(A6XX_RB_CMP_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_RB_PERFCTR_CMP_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_RB_PERFCTR_CMP_SEL_REG(uint32_t __i, struct A6XX_RB_PERFCTR_CMP_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008e2c + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_PERFCTR_CMP_SEL_REG(__i, ...) pack_A6XX_RB_PERFCTR_CMP_SEL_REG(__i, __struct_cast(A6XX_RB_PERFCTR_CMP_SEL_REG) { __VA_ARGS__ })

struct A7XX_RB_PERFCTR_UFC_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_PERFCTR_UFC_SEL_REG(uint32_t __i, struct A7XX_RB_PERFCTR_UFC_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008e30 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_PERFCTR_UFC_SEL_REG(__i, ...) pack_A7XX_RB_PERFCTR_UFC_SEL_REG(__i, __struct_cast(A7XX_RB_PERFCTR_UFC_SEL_REG) { __VA_ARGS__ })

struct A8XX_RB_PERFCTR_CMP_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_PERFCTR_CMP_SEL_REG(uint32_t __i, struct A8XX_RB_PERFCTR_CMP_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008f04 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_PERFCTR_CMP_SEL_REG(__i, ...) pack_A8XX_RB_PERFCTR_CMP_SEL_REG(__i, __struct_cast(A8XX_RB_PERFCTR_CMP_SEL_REG) { __VA_ARGS__ })

struct A8XX_RB_PERFCTR_UFC_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_PERFCTR_UFC_SEL_REG(uint32_t __i, struct A8XX_RB_PERFCTR_UFC_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00008f10 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_PERFCTR_UFC_SEL_REG(__i, ...) pack_A8XX_RB_PERFCTR_UFC_SEL_REG(__i, __struct_cast(A8XX_RB_PERFCTR_UFC_SEL_REG) { __VA_ARGS__ })

struct A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST(struct A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e3b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST(...) pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST(__struct_cast(A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST) { __VA_ARGS__ })

struct A6XX_RB_SUB_BLOCK_SEL_CNTL_CD {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_CD(struct A6XX_RB_SUB_BLOCK_SEL_CNTL_CD fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e3d,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_SUB_BLOCK_SEL_CNTL_CD(...) pack_A6XX_RB_SUB_BLOCK_SEL_CNTL_CD(__struct_cast(A6XX_RB_SUB_BLOCK_SEL_CNTL_CD) { __VA_ARGS__ })

struct A8XX_RB_UFC_DBG_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_UFC_DBG_CNTL(struct A8XX_RB_UFC_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008f29,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_UFC_DBG_CNTL(...) pack_A8XX_RB_UFC_DBG_CNTL(__struct_cast(A8XX_RB_UFC_DBG_CNTL) { __VA_ARGS__ })

struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE {
    bool							rb_context_switch_gmem_save_restore_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE(struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e50,
        .value =
            (fields.rb_context_switch_gmem_save_restore_enable <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE(...) pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE(__struct_cast(A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE) { __VA_ARGS__ })

struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR(struct A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e51,
        .value =
            fields.unknown | fields.dword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR(...) pack_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR(__struct_cast(A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_RB_SLICE_UFC_PREFETCH_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_SLICE_UFC_PREFETCH_CNTL(struct A8XX_RB_SLICE_UFC_PREFETCH_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e77,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_SLICE_UFC_PREFETCH_CNTL(...) pack_A8XX_RB_SLICE_UFC_PREFETCH_CNTL(__struct_cast(A8XX_RB_SLICE_UFC_PREFETCH_CNTL) { __VA_ARGS__ })

struct A8XX_RB_SLICE_UFC_DBG_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_RB_SLICE_UFC_DBG_CNTL(struct A8XX_RB_SLICE_UFC_DBG_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e78,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_RB_SLICE_UFC_DBG_CNTL(...) pack_A8XX_RB_SLICE_UFC_DBG_CNTL(__struct_cast(A8XX_RB_SLICE_UFC_DBG_CNTL) { __VA_ARGS__ })

struct A7XX_RB_UNKNOWN_8E79 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_RB_UNKNOWN_8E79(struct A7XX_RB_UNKNOWN_8E79 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00008e79,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_RB_UNKNOWN_8E79(...) pack_A7XX_RB_UNKNOWN_8E79(__struct_cast(A7XX_RB_UNKNOWN_8E79) { __VA_ARGS__ })

struct A6XX_VPC_GS_PARAM {
    uint32_t							linelengthloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_GS_PARAM(struct A6XX_VPC_GS_PARAM fields)
{
#ifndef NDEBUG
    assert((fields.linelengthloc                     & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009100,
        .value =
            (fields.linelengthloc                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_GS_PARAM(...) pack_A6XX_VPC_GS_PARAM(__struct_cast(A6XX_VPC_GS_PARAM) { __VA_ARGS__ })

struct A6XX_VPC_VS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VS_CLIP_CULL_CNTL(struct A6XX_VPC_VS_CLIP_CULL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009101,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VS_CLIP_CULL_CNTL(...) pack_A6XX_VPC_VS_CLIP_CULL_CNTL(__struct_cast(A6XX_VPC_VS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_GS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_GS_CLIP_CULL_CNTL(struct A6XX_VPC_GS_CLIP_CULL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009102,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_GS_CLIP_CULL_CNTL(...) pack_A6XX_VPC_GS_CLIP_CULL_CNTL(__struct_cast(A6XX_VPC_GS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_DS_CLIP_CULL_CNTL(struct A6XX_VPC_DS_CLIP_CULL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009103,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_DS_CLIP_CULL_CNTL(...) pack_A6XX_VPC_DS_CLIP_CULL_CNTL(__struct_cast(A6XX_VPC_DS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_VS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_VS_CLIP_CULL_CNTL(struct A8XX_VPC_VS_CLIP_CULL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009307,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_VS_CLIP_CULL_CNTL(...) pack_A8XX_VPC_VS_CLIP_CULL_CNTL(__struct_cast(A8XX_VPC_VS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_GS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_GS_CLIP_CULL_CNTL(struct A8XX_VPC_GS_CLIP_CULL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009308,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_GS_CLIP_CULL_CNTL(...) pack_A8XX_VPC_GS_CLIP_CULL_CNTL(__struct_cast(A8XX_VPC_GS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DS_CLIP_CULL_CNTL {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_DS_CLIP_CULL_CNTL(struct A8XX_VPC_DS_CLIP_CULL_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009309,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_DS_CLIP_CULL_CNTL(...) pack_A8XX_VPC_DS_CLIP_CULL_CNTL(__struct_cast(A8XX_VPC_DS_CLIP_CULL_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VS_CLIP_CULL_CNTL_V2 {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VS_CLIP_CULL_CNTL_V2(struct A6XX_VPC_VS_CLIP_CULL_CNTL_V2 fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009311,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2(...) pack_A6XX_VPC_VS_CLIP_CULL_CNTL_V2(__struct_cast(A6XX_VPC_VS_CLIP_CULL_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_GS_CLIP_CULL_CNTL_V2 {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_GS_CLIP_CULL_CNTL_V2(struct A6XX_VPC_GS_CLIP_CULL_CNTL_V2 fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009312,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2(...) pack_A6XX_VPC_GS_CLIP_CULL_CNTL_V2(__struct_cast(A6XX_VPC_GS_CLIP_CULL_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_DS_CLIP_CULL_CNTL_V2 {
    uint32_t							clip_mask;
    uint32_t							clip_dist_03_loc;
    uint32_t							clip_dist_47_loc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_DS_CLIP_CULL_CNTL_V2(struct A6XX_VPC_DS_CLIP_CULL_CNTL_V2 fields)
{
#ifndef NDEBUG
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.clip_dist_03_loc                  & 0xffffff00) == 0);
    assert((fields.clip_dist_47_loc                  & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009313,
        .value =
            (fields.clip_mask                         <<  0) |
            (fields.clip_dist_03_loc                  <<  8) |
            (fields.clip_dist_47_loc                  << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2(...) pack_A6XX_VPC_DS_CLIP_CULL_CNTL_V2(__struct_cast(A6XX_VPC_DS_CLIP_CULL_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_VS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VS_SIV_CNTL(struct A6XX_VPC_VS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009104,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VS_SIV_CNTL(...) pack_A6XX_VPC_VS_SIV_CNTL(__struct_cast(A6XX_VPC_VS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_GS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_GS_SIV_CNTL(struct A6XX_VPC_GS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009105,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_GS_SIV_CNTL(...) pack_A6XX_VPC_GS_SIV_CNTL(__struct_cast(A6XX_VPC_GS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_DS_SIV_CNTL(struct A6XX_VPC_DS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009106,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_DS_SIV_CNTL(...) pack_A6XX_VPC_DS_SIV_CNTL(__struct_cast(A6XX_VPC_DS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_VS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_VS_SIV_CNTL(struct A8XX_VPC_VS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000930a,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_VS_SIV_CNTL(...) pack_A8XX_VPC_VS_SIV_CNTL(__struct_cast(A8XX_VPC_VS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_GS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_GS_SIV_CNTL(struct A8XX_VPC_GS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000930b,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_GS_SIV_CNTL(...) pack_A8XX_VPC_GS_SIV_CNTL(__struct_cast(A8XX_VPC_GS_SIV_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DS_SIV_CNTL {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_DS_SIV_CNTL(struct A8XX_VPC_DS_SIV_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000930c,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_DS_SIV_CNTL(...) pack_A8XX_VPC_DS_SIV_CNTL(__struct_cast(A8XX_VPC_DS_SIV_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VS_SIV_CNTL_V2 {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VS_SIV_CNTL_V2(struct A6XX_VPC_VS_SIV_CNTL_V2 fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009314,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VS_SIV_CNTL_V2(...) pack_A6XX_VPC_VS_SIV_CNTL_V2(__struct_cast(A6XX_VPC_VS_SIV_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_GS_SIV_CNTL_V2 {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_GS_SIV_CNTL_V2(struct A6XX_VPC_GS_SIV_CNTL_V2 fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009315,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_GS_SIV_CNTL_V2(...) pack_A6XX_VPC_GS_SIV_CNTL_V2(__struct_cast(A6XX_VPC_GS_SIV_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_DS_SIV_CNTL_V2 {
    uint32_t							layerloc;
    uint32_t							viewloc;
    uint32_t							shadingrateloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_DS_SIV_CNTL_V2(struct A6XX_VPC_DS_SIV_CNTL_V2 fields)
{
#ifndef NDEBUG
    assert((fields.layerloc                          & 0xffffff00) == 0);
    assert((fields.viewloc                           & 0xffffff00) == 0);
    assert((fields.shadingrateloc                    & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009316,
        .value =
            (fields.layerloc                          <<  0) |
            (fields.viewloc                           <<  8) |
            (fields.shadingrateloc                    << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_DS_SIV_CNTL_V2(...) pack_A6XX_VPC_DS_SIV_CNTL_V2(__struct_cast(A6XX_VPC_DS_SIV_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_RAST_STREAM_CNTL {
    uint32_t							stream;
    bool							discard;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_RAST_STREAM_CNTL(struct A6XX_VPC_RAST_STREAM_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stream                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009980,
        .value =
            (fields.stream                            <<  0) |
            (fields.discard                           <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_RAST_STREAM_CNTL(...) pack_A6XX_VPC_RAST_STREAM_CNTL(__struct_cast(A6XX_VPC_RAST_STREAM_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_RAST_STREAM_CNTL {
    uint32_t							stream;
    bool							discard;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_RAST_STREAM_CNTL(struct A7XX_VPC_RAST_STREAM_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stream                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009107,
        .value =
            (fields.stream                            <<  0) |
            (fields.discard                           <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_RAST_STREAM_CNTL(...) pack_A7XX_VPC_RAST_STREAM_CNTL(__struct_cast(A7XX_VPC_RAST_STREAM_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_RAST_STREAM_CNTL {
    uint32_t							stream;
    bool							discard;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_RAST_STREAM_CNTL(struct A8XX_VPC_RAST_STREAM_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stream                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000930d,
        .value =
            (fields.stream                            <<  0) |
            (fields.discard                           <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_RAST_STREAM_CNTL(...) pack_A8XX_VPC_RAST_STREAM_CNTL(__struct_cast(A8XX_VPC_RAST_STREAM_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_RAST_STREAM_CNTL_V2 {
    uint32_t							stream;
    bool							discard;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_RAST_STREAM_CNTL_V2(struct A7XX_VPC_RAST_STREAM_CNTL_V2 fields)
{
#ifndef NDEBUG
    assert((fields.stream                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000007) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009317,
        .value =
            (fields.stream                            <<  0) |
            (fields.discard                           <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_RAST_STREAM_CNTL_V2(...) pack_A7XX_VPC_RAST_STREAM_CNTL_V2(__struct_cast(A7XX_VPC_RAST_STREAM_CNTL_V2) { __VA_ARGS__ })

struct A6XX_VPC_UNKNOWN_9107 {
    bool							raster_discard;
    bool							unk2;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_UNKNOWN_9107(struct A6XX_VPC_UNKNOWN_9107 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000005) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009107,
        .value =
            (fields.raster_discard                    <<  0) |
            (fields.unk2                              <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_UNKNOWN_9107(...) pack_A6XX_VPC_UNKNOWN_9107(__struct_cast(A6XX_VPC_UNKNOWN_9107) { __VA_ARGS__ })

struct A6XX_VPC_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_RAST_CNTL(struct A6XX_VPC_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009108,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_RAST_CNTL(...) pack_A6XX_VPC_RAST_CNTL(__struct_cast(A6XX_VPC_RAST_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_RAST_CNTL(struct A8XX_VPC_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000930e,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_RAST_CNTL(...) pack_A8XX_VPC_RAST_CNTL(__struct_cast(A8XX_VPC_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_PC_CNTL(struct A7XX_VPC_PC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009109,
        .value =
            (fields.primitive_restart                 <<  0) |
            (fields.provoking_vtx_last                <<  1) |
            (fields.d3d_vertex_ordering               <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_PC_CNTL(...) pack_A7XX_VPC_PC_CNTL(__struct_cast(A7XX_VPC_PC_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_PC_CNTL(struct A8XX_VPC_PC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000930f,
        .value =
            (fields.primitive_restart                 <<  0) |
            (fields.provoking_vtx_last                <<  1) |
            (fields.d3d_vertex_ordering               <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_PC_CNTL(...) pack_A8XX_VPC_PC_CNTL(__struct_cast(A8XX_VPC_PC_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_GS_PARAM_0(struct A7XX_VPC_GS_PARAM_0 fields)
{
#ifndef NDEBUG
    assert((fields.gs_vertices_out                   & 0xffffff00) == 0);
    assert((fields.gs_invocations                    & 0xffffffe0) == 0);
    assert((fields.gs_output                         & 0xfffffffc) == 0);
    assert((fields.unk18                             & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0007fcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000910a,
        .value =
            (fields.gs_vertices_out                   <<  0) |
            (fields.gs_invocations                    << 10) |
            (fields.linelengthen                      << 15) |
            (fields.gs_output                         << 16) |
            (fields.unk18                             << 18) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_GS_PARAM_0(...) pack_A7XX_VPC_GS_PARAM_0(__struct_cast(A7XX_VPC_GS_PARAM_0) { __VA_ARGS__ })

struct A8XX_VPC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_GS_PARAM_0(struct A8XX_VPC_GS_PARAM_0 fields)
{
#ifndef NDEBUG
    assert((fields.gs_vertices_out                   & 0xffffff00) == 0);
    assert((fields.gs_invocations                    & 0xffffffe0) == 0);
    assert((fields.gs_output                         & 0xfffffffc) == 0);
    assert((fields.unk18                             & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0007fcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000090c0,
        .value =
            (fields.gs_vertices_out                   <<  0) |
            (fields.gs_invocations                    << 10) |
            (fields.linelengthen                      << 15) |
            (fields.gs_output                         << 16) |
            (fields.unk18                             << 18) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_GS_PARAM_0(...) pack_A8XX_VPC_GS_PARAM_0(__struct_cast(A8XX_VPC_GS_PARAM_0) { __VA_ARGS__ })

struct A7XX_VPC_STEREO_RENDERING_VIEWMASK {
    uint32_t							vpc_stereo_rendering_viewmask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_STEREO_RENDERING_VIEWMASK(struct A7XX_VPC_STEREO_RENDERING_VIEWMASK fields)
{
#ifndef NDEBUG
    assert((fields.vpc_stereo_rendering_viewmask     & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000910b,
        .value =
            (fields.vpc_stereo_rendering_viewmask     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_STEREO_RENDERING_VIEWMASK(...) pack_A7XX_VPC_STEREO_RENDERING_VIEWMASK(__struct_cast(A7XX_VPC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A8XX_VPC_STEREO_RENDERING_VIEWMASK {
    uint32_t							vpc_stereo_rendering_viewmask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_STEREO_RENDERING_VIEWMASK(struct A8XX_VPC_STEREO_RENDERING_VIEWMASK fields)
{
#ifndef NDEBUG
    assert((fields.vpc_stereo_rendering_viewmask     & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x000090c1,
        .value =
            (fields.vpc_stereo_rendering_viewmask     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_STEREO_RENDERING_VIEWMASK(...) pack_A8XX_VPC_STEREO_RENDERING_VIEWMASK(__struct_cast(A8XX_VPC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A7XX_VPC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_STEREO_RENDERING_CNTL(struct A7XX_VPC_STEREO_RENDERING_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.views                             & 0xffffffe0) == 0);
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000910c,
        .value =
            (fields.enable                            <<  0) |
            (fields.disablemultipos                   <<  1) |
            (fields.views                             <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_STEREO_RENDERING_CNTL(...) pack_A7XX_VPC_STEREO_RENDERING_CNTL(__struct_cast(A7XX_VPC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_STEREO_RENDERING_CNTL(struct A8XX_VPC_STEREO_RENDERING_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.views                             & 0xffffffe0) == 0);
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000931a,
        .value =
            (fields.enable                            <<  0) |
            (fields.disablemultipos                   <<  1) |
            (fields.views                             <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_STEREO_RENDERING_CNTL(...) pack_A8XX_VPC_STEREO_RENDERING_CNTL(__struct_cast(A8XX_VPC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VARYING_INTERP_MODE_MODE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VARYING_INTERP_MODE_MODE(uint32_t __i, struct A6XX_VPC_VARYING_INTERP_MODE_MODE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009200 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VARYING_INTERP_MODE_MODE(__i, ...) pack_A6XX_VPC_VARYING_INTERP_MODE_MODE(__i, __struct_cast(A6XX_VPC_VARYING_INTERP_MODE_MODE) { __VA_ARGS__ })

struct A6XX_VPC_VARYING_REPLACE_MODE_MODE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VARYING_REPLACE_MODE_MODE(uint32_t __i, struct A6XX_VPC_VARYING_REPLACE_MODE_MODE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009208 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VARYING_REPLACE_MODE_MODE(__i, ...) pack_A6XX_VPC_VARYING_REPLACE_MODE_MODE(__i, __struct_cast(A6XX_VPC_VARYING_REPLACE_MODE_MODE) { __VA_ARGS__ })

struct A8XX_VPC_VARYING_INTERP_MODE_MODE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_VARYING_INTERP_MODE_MODE(uint32_t __i, struct A8XX_VPC_VARYING_INTERP_MODE_MODE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009240 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_VARYING_INTERP_MODE_MODE(__i, ...) pack_A8XX_VPC_VARYING_INTERP_MODE_MODE(__i, __struct_cast(A8XX_VPC_VARYING_INTERP_MODE_MODE) { __VA_ARGS__ })

struct A8XX_VPC_VARYING_REPLACE_MODE_MODE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_VARYING_REPLACE_MODE_MODE(uint32_t __i, struct A8XX_VPC_VARYING_REPLACE_MODE_MODE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009248 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_VARYING_REPLACE_MODE_MODE(__i, ...) pack_A8XX_VPC_VARYING_REPLACE_MODE_MODE(__i, __struct_cast(A8XX_VPC_VARYING_REPLACE_MODE_MODE) { __VA_ARGS__ })

struct A6XX_VPC_UNKNOWN_9210 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_UNKNOWN_9210(struct A6XX_VPC_UNKNOWN_9210 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009210,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_UNKNOWN_9210(...) pack_A6XX_VPC_UNKNOWN_9210(__struct_cast(A6XX_VPC_UNKNOWN_9210) { __VA_ARGS__ })

struct A6XX_VPC_UNKNOWN_9211 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_UNKNOWN_9211(struct A6XX_VPC_UNKNOWN_9211 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009211,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_UNKNOWN_9211(...) pack_A6XX_VPC_UNKNOWN_9211(__struct_cast(A6XX_VPC_UNKNOWN_9211) { __VA_ARGS__ })

struct A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(uint32_t __i, struct A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009212 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, ...) pack_A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, __struct_cast(A6XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE) { __VA_ARGS__ })

struct A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(uint32_t __i, struct A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009252 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, ...) pack_A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE(__i, __struct_cast(A8XX_VPC_VARYING_LM_TRANSFER_CNTL_DISABLE) { __VA_ARGS__ })

struct A6XX_VPC_SO_MAPPING_WPTR {
    uint32_t							addr;
    bool							reset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_MAPPING_WPTR(struct A6XX_VPC_SO_MAPPING_WPTR fields)
{
#ifndef NDEBUG
    assert((fields.addr                              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000100ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009216,
        .value =
            (fields.addr                              <<  0) |
            (fields.reset                             << 16) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_SO_MAPPING_WPTR(...) pack_A6XX_VPC_SO_MAPPING_WPTR(__struct_cast(A6XX_VPC_SO_MAPPING_WPTR) { __VA_ARGS__ })

struct A8XX_VPC_SO_MAPPING_WPTR {
    uint32_t							addr;
    bool							reset;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_MAPPING_WPTR(struct A8XX_VPC_SO_MAPPING_WPTR fields)
{
#ifndef NDEBUG
    assert((fields.addr                              & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000100ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009180,
        .value =
            (fields.addr                              <<  0) |
            (fields.reset                             << 16) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_SO_MAPPING_WPTR(...) pack_A8XX_VPC_SO_MAPPING_WPTR(__struct_cast(A8XX_VPC_SO_MAPPING_WPTR) { __VA_ARGS__ })

struct A6XX_VPC_SO_MAPPING_PORT {
    uint32_t							a_buf;
    uint32_t							a_off;
    bool							a_en;
    uint32_t							b_buf;
    uint32_t							b_off;
    bool							b_en;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_MAPPING_PORT(struct A6XX_VPC_SO_MAPPING_PORT fields)
{
#ifndef NDEBUG
    assert((fields.a_buf                             & 0xfffffffc) == 0);
    assert(((fields.a_off >> 2)                      & 0xfffffe00) == 0);
    assert((fields.b_buf                             & 0xfffffffc) == 0);
    assert(((fields.b_off >> 2)                      & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009217,
        .value =
            (fields.a_buf                             <<  0) |
            ((fields.a_off >> 2)                      <<  2) |
            (fields.a_en                              << 11) |
            (fields.b_buf                             << 12) |
            ((fields.b_off >> 2)                      << 14) |
            (fields.b_en                              << 23) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_SO_MAPPING_PORT(...) pack_A6XX_VPC_SO_MAPPING_PORT(__struct_cast(A6XX_VPC_SO_MAPPING_PORT) { __VA_ARGS__ })

struct A8XX_VPC_SO_MAPPING_PORT {
    uint32_t							a_buf;
    uint32_t							a_off;
    bool							a_en;
    uint32_t							b_buf;
    uint32_t							b_off;
    bool							b_en;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_MAPPING_PORT(struct A8XX_VPC_SO_MAPPING_PORT fields)
{
#ifndef NDEBUG
    assert((fields.a_buf                             & 0xfffffffc) == 0);
    assert(((fields.a_off >> 2)                      & 0xfffffe00) == 0);
    assert((fields.b_buf                             & 0xfffffffc) == 0);
    assert(((fields.b_off >> 2)                      & 0xfffffe00) == 0);
    assert((fields.unknown                           & 0x00ffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009181,
        .value =
            (fields.a_buf                             <<  0) |
            ((fields.a_off >> 2)                      <<  2) |
            (fields.a_en                              << 11) |
            (fields.b_buf                             << 12) |
            ((fields.b_off >> 2)                      << 14) |
            (fields.b_en                              << 23) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_SO_MAPPING_PORT(...) pack_A8XX_VPC_SO_MAPPING_PORT(__struct_cast(A8XX_VPC_SO_MAPPING_PORT) { __VA_ARGS__ })

struct A6XX_VPC_SO_QUERY_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_QUERY_BASE(struct A6XX_VPC_SO_QUERY_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009218,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_VPC_SO_QUERY_BASE(...) pack_A6XX_VPC_SO_QUERY_BASE(__struct_cast(A6XX_VPC_SO_QUERY_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_SO_QUERY_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_QUERY_BASE(struct A8XX_VPC_SO_QUERY_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009182,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A8XX_VPC_SO_QUERY_BASE(...) pack_A8XX_VPC_SO_QUERY_BASE(__struct_cast(A8XX_VPC_SO_QUERY_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VPC_SO_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_BUFFER_BASE(uint32_t __i, struct A6XX_VPC_SO_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000921a + 0x7*__i),
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_VPC_SO_BUFFER_BASE(__i, ...) pack_A6XX_VPC_SO_BUFFER_BASE(__i, __struct_cast(A6XX_VPC_SO_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VPC_SO_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_BUFFER_SIZE(uint32_t __i, struct A6XX_VPC_SO_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000921c + 0x7*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_SO_BUFFER_SIZE(__i, ...) pack_A6XX_VPC_SO_BUFFER_SIZE(__i, __struct_cast(A6XX_VPC_SO_BUFFER_SIZE) { __VA_ARGS__ })

struct A6XX_VPC_SO_BUFFER_STRIDE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_BUFFER_STRIDE(uint32_t __i, struct A6XX_VPC_SO_BUFFER_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000921d + 0x7*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_SO_BUFFER_STRIDE(__i, ...) pack_A6XX_VPC_SO_BUFFER_STRIDE(__i, __struct_cast(A6XX_VPC_SO_BUFFER_STRIDE) { __VA_ARGS__ })

struct A6XX_VPC_SO_BUFFER_OFFSET {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_BUFFER_OFFSET(uint32_t __i, struct A6XX_VPC_SO_BUFFER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000921e + 0x7*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_SO_BUFFER_OFFSET(__i, ...) pack_A6XX_VPC_SO_BUFFER_OFFSET(__i, __struct_cast(A6XX_VPC_SO_BUFFER_OFFSET) { __VA_ARGS__ })

struct A6XX_VPC_SO_FLUSH_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_FLUSH_BASE(uint32_t __i, struct A6XX_VPC_SO_FLUSH_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000921f + 0x7*__i),
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_VPC_SO_FLUSH_BASE(__i, ...) pack_A6XX_VPC_SO_FLUSH_BASE(__i, __struct_cast(A6XX_VPC_SO_FLUSH_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_SO_BUFFER_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_BUFFER_BASE(uint32_t __i, struct A8XX_VPC_SO_BUFFER_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009184 + 0x7*__i),
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A8XX_VPC_SO_BUFFER_BASE(__i, ...) pack_A8XX_VPC_SO_BUFFER_BASE(__i, __struct_cast(A8XX_VPC_SO_BUFFER_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_SO_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_BUFFER_SIZE(uint32_t __i, struct A8XX_VPC_SO_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009186 + 0x7*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_SO_BUFFER_SIZE(__i, ...) pack_A8XX_VPC_SO_BUFFER_SIZE(__i, __struct_cast(A8XX_VPC_SO_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_VPC_SO_BUFFER_STRIDE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_BUFFER_STRIDE(uint32_t __i, struct A8XX_VPC_SO_BUFFER_STRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009187 + 0x7*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_SO_BUFFER_STRIDE(__i, ...) pack_A8XX_VPC_SO_BUFFER_STRIDE(__i, __struct_cast(A8XX_VPC_SO_BUFFER_STRIDE) { __VA_ARGS__ })

struct A8XX_VPC_SO_BUFFER_OFFSET {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_BUFFER_OFFSET(uint32_t __i, struct A8XX_VPC_SO_BUFFER_OFFSET fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009188 + 0x7*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_SO_BUFFER_OFFSET(__i, ...) pack_A8XX_VPC_SO_BUFFER_OFFSET(__i, __struct_cast(A8XX_VPC_SO_BUFFER_OFFSET) { __VA_ARGS__ })

struct A8XX_VPC_SO_FLUSH_BASE {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_FLUSH_BASE(uint32_t __i, struct A8XX_VPC_SO_FLUSH_BASE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009189 + 0x7*__i),
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A8XX_VPC_SO_FLUSH_BASE(__i, ...) pack_A8XX_VPC_SO_FLUSH_BASE(__i, __struct_cast(A8XX_VPC_SO_FLUSH_BASE) { __VA_ARGS__ }), { .reg = 0 }

struct A6XX_VPC_REPLACE_MODE_CNTL {
    bool							invert;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_REPLACE_MODE_CNTL(struct A6XX_VPC_REPLACE_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009236,
        .value =
            (fields.invert                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_REPLACE_MODE_CNTL(...) pack_A6XX_VPC_REPLACE_MODE_CNTL(__struct_cast(A6XX_VPC_REPLACE_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_REPLACE_MODE_CNTL {
    bool							invert;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_REPLACE_MODE_CNTL(struct A8XX_VPC_REPLACE_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009310,
        .value =
            (fields.invert                            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_REPLACE_MODE_CNTL(...) pack_A8XX_VPC_REPLACE_MODE_CNTL(__struct_cast(A8XX_VPC_REPLACE_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_ROTATION_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_ROTATION_CNTL(struct A6XX_VPC_ROTATION_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009300,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_ROTATION_CNTL(...) pack_A6XX_VPC_ROTATION_CNTL(__struct_cast(A6XX_VPC_ROTATION_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_ROTATION_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_ROTATION_CNTL(struct A8XX_VPC_ROTATION_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009312,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_ROTATION_CNTL(...) pack_A8XX_VPC_ROTATION_CNTL(__struct_cast(A8XX_VPC_ROTATION_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_VS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_VS_CNTL(struct A6XX_VPC_VS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.positionloc                       & 0xffffff00) == 0);
    assert((fields.psizeloc                          & 0xffffff00) == 0);
    assert((fields.extrapos                          & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009301,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.positionloc                       <<  8) |
            (fields.psizeloc                          << 16) |
            (fields.extrapos                          << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_VS_CNTL(...) pack_A6XX_VPC_VS_CNTL(__struct_cast(A6XX_VPC_VS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_GS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_GS_CNTL(struct A6XX_VPC_GS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.positionloc                       & 0xffffff00) == 0);
    assert((fields.psizeloc                          & 0xffffff00) == 0);
    assert((fields.extrapos                          & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009302,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.positionloc                       <<  8) |
            (fields.psizeloc                          << 16) |
            (fields.extrapos                          << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_GS_CNTL(...) pack_A6XX_VPC_GS_CNTL(__struct_cast(A6XX_VPC_GS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_DS_CNTL(struct A6XX_VPC_DS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.positionloc                       & 0xffffff00) == 0);
    assert((fields.psizeloc                          & 0xffffff00) == 0);
    assert((fields.extrapos                          & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009303,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.positionloc                       <<  8) |
            (fields.psizeloc                          << 16) |
            (fields.extrapos                          << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_DS_CNTL(...) pack_A6XX_VPC_DS_CNTL(__struct_cast(A6XX_VPC_DS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_VS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_VS_CNTL(struct A8XX_VPC_VS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.positionloc                       & 0xffffff00) == 0);
    assert((fields.psizeloc                          & 0xffffff00) == 0);
    assert((fields.extrapos                          & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009300,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.positionloc                       <<  8) |
            (fields.psizeloc                          << 16) |
            (fields.extrapos                          << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_VS_CNTL(...) pack_A8XX_VPC_VS_CNTL(__struct_cast(A8XX_VPC_VS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_GS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_GS_CNTL(struct A8XX_VPC_GS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.positionloc                       & 0xffffff00) == 0);
    assert((fields.psizeloc                          & 0xffffff00) == 0);
    assert((fields.extrapos                          & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009301,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.positionloc                       <<  8) |
            (fields.psizeloc                          << 16) |
            (fields.extrapos                          << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_GS_CNTL(...) pack_A8XX_VPC_GS_CNTL(__struct_cast(A8XX_VPC_GS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DS_CNTL {
    uint32_t							stride_in_vpc;
    uint32_t							positionloc;
    uint32_t							psizeloc;
    uint32_t							extrapos;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_DS_CNTL(struct A8XX_VPC_DS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.positionloc                       & 0xffffff00) == 0);
    assert((fields.psizeloc                          & 0xffffff00) == 0);
    assert((fields.extrapos                          & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x0fffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009302,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.positionloc                       <<  8) |
            (fields.psizeloc                          << 16) |
            (fields.extrapos                          << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_DS_CNTL(...) pack_A8XX_VPC_DS_CNTL(__struct_cast(A8XX_VPC_DS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_PS_CNTL {
    uint32_t							numnonposvar;
    uint32_t							primidloc;
    bool							varying;
    uint32_t							viewidloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_PS_CNTL(struct A6XX_VPC_PS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.numnonposvar                      & 0xffffff00) == 0);
    assert((fields.primidloc                         & 0xffffff00) == 0);
    assert((fields.viewidloc                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff01ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009304,
        .value =
            (fields.numnonposvar                      <<  0) |
            (fields.primidloc                         <<  8) |
            (fields.varying                           << 16) |
            (fields.viewidloc                         << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_PS_CNTL(...) pack_A6XX_VPC_PS_CNTL(__struct_cast(A6XX_VPC_PS_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_PS_CNTL {
    uint32_t							numnonposvar;
    uint32_t							primidloc;
    bool							varying;
    uint32_t							viewidloc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_PS_CNTL(struct A8XX_VPC_PS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.numnonposvar                      & 0xffffff00) == 0);
    assert((fields.primidloc                         & 0xffffff00) == 0);
    assert((fields.viewidloc                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0xff01ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009303,
        .value =
            (fields.numnonposvar                      <<  0) |
            (fields.primidloc                         <<  8) |
            (fields.varying                           << 16) |
            (fields.viewidloc                         << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_PS_CNTL(...) pack_A8XX_VPC_PS_CNTL(__struct_cast(A8XX_VPC_PS_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_SO_CNTL {
    uint32_t							buf0_stream;
    uint32_t							buf1_stream;
    uint32_t							buf2_stream;
    uint32_t							buf3_stream;
    uint32_t							stream_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_CNTL(struct A6XX_VPC_SO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.buf0_stream                       & 0xfffffff8) == 0);
    assert((fields.buf1_stream                       & 0xfffffff8) == 0);
    assert((fields.buf2_stream                       & 0xfffffff8) == 0);
    assert((fields.buf3_stream                       & 0xfffffff8) == 0);
    assert((fields.stream_enable                     & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x00078fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009305,
        .value =
            (fields.buf0_stream                       <<  0) |
            (fields.buf1_stream                       <<  3) |
            (fields.buf2_stream                       <<  6) |
            (fields.buf3_stream                       <<  9) |
            (fields.stream_enable                     << 15) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_SO_CNTL(...) pack_A6XX_VPC_SO_CNTL(__struct_cast(A6XX_VPC_SO_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_SO_CNTL {
    uint32_t							buf0_stream;
    uint32_t							buf1_stream;
    uint32_t							buf2_stream;
    uint32_t							buf3_stream;
    uint32_t							stream_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_CNTL(struct A8XX_VPC_SO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.buf0_stream                       & 0xfffffff8) == 0);
    assert((fields.buf1_stream                       & 0xfffffff8) == 0);
    assert((fields.buf2_stream                       & 0xfffffff8) == 0);
    assert((fields.buf3_stream                       & 0xfffffff8) == 0);
    assert((fields.stream_enable                     & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x00078fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009304,
        .value =
            (fields.buf0_stream                       <<  0) |
            (fields.buf1_stream                       <<  3) |
            (fields.buf2_stream                       <<  6) |
            (fields.buf3_stream                       <<  9) |
            (fields.stream_enable                     << 15) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_SO_CNTL(...) pack_A8XX_VPC_SO_CNTL(__struct_cast(A8XX_VPC_SO_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_SO_OVERRIDE {
    bool							disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_SO_OVERRIDE(struct A6XX_VPC_SO_OVERRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009306,
        .value =
            (fields.disable                           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_SO_OVERRIDE(...) pack_A6XX_VPC_SO_OVERRIDE(__struct_cast(A6XX_VPC_SO_OVERRIDE) { __VA_ARGS__ })

struct A8XX_VPC_SO_OVERRIDE {
    bool							disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_SO_OVERRIDE(struct A8XX_VPC_SO_OVERRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009305,
        .value =
            (fields.disable                           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_SO_OVERRIDE(...) pack_A8XX_VPC_SO_OVERRIDE(__struct_cast(A8XX_VPC_SO_OVERRIDE) { __VA_ARGS__ })

struct A7XX_PC_DGEN_SO_OVERRIDE {
    bool							disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_PC_DGEN_SO_OVERRIDE(struct A7XX_PC_DGEN_SO_OVERRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009807,
        .value =
            (fields.disable                           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_PC_DGEN_SO_OVERRIDE(...) pack_A7XX_PC_DGEN_SO_OVERRIDE(__struct_cast(A7XX_PC_DGEN_SO_OVERRIDE) { __VA_ARGS__ })

struct A8XX_PC_DGEN_SO_OVERRIDE {
    bool							disable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DGEN_SO_OVERRIDE(struct A8XX_PC_DGEN_SO_OVERRIDE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b0a,
        .value =
            (fields.disable                           <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DGEN_SO_OVERRIDE(...) pack_A8XX_PC_DGEN_SO_OVERRIDE(__struct_cast(A8XX_PC_DGEN_SO_OVERRIDE) { __VA_ARGS__ })

struct A6XX_VPC_PS_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_PS_RAST_CNTL(struct A6XX_VPC_PS_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009307,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_PS_RAST_CNTL(...) pack_A6XX_VPC_PS_RAST_CNTL(__struct_cast(A6XX_VPC_PS_RAST_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_PS_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_PS_RAST_CNTL(struct A8XX_VPC_PS_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009306,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_PS_RAST_CNTL(...) pack_A8XX_VPC_PS_RAST_CNTL(__struct_cast(A8XX_VPC_PS_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_VPC_ATTR_BUF_GMEM_SIZE {
    uint32_t							vpc_attr_buf_gmem_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_ATTR_BUF_GMEM_SIZE(struct A7XX_VPC_ATTR_BUF_GMEM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.vpc_attr_buf_gmem_size            & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009308,
        .value =
            (fields.vpc_attr_buf_gmem_size            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_ATTR_BUF_GMEM_SIZE(...) pack_A7XX_VPC_ATTR_BUF_GMEM_SIZE(__struct_cast(A7XX_VPC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A7XX_VPC_ATTR_BUF_GMEM_BASE {
    uint32_t							vpc_attr_buf_gmem_base;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_ATTR_BUF_GMEM_BASE(struct A7XX_VPC_ATTR_BUF_GMEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.vpc_attr_buf_gmem_base            & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009309,
        .value =
            (fields.vpc_attr_buf_gmem_base            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_ATTR_BUF_GMEM_BASE(...) pack_A7XX_VPC_ATTR_BUF_GMEM_BASE(__struct_cast(A7XX_VPC_ATTR_BUF_GMEM_BASE) { __VA_ARGS__ })

struct A8XX_VPC_ATTR_BUF_GMEM_SIZE {
    uint32_t							vpc_attr_buf_gmem_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_ATTR_BUF_GMEM_SIZE(struct A8XX_VPC_ATTR_BUF_GMEM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.vpc_attr_buf_gmem_size            & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009314,
        .value =
            (fields.vpc_attr_buf_gmem_size            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_ATTR_BUF_GMEM_SIZE(...) pack_A8XX_VPC_ATTR_BUF_GMEM_SIZE(__struct_cast(A8XX_VPC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_VPC_ATTR_BUF_GMEM_BASE {
    uint32_t							vpc_attr_buf_gmem_base;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_ATTR_BUF_GMEM_BASE(struct A8XX_VPC_ATTR_BUF_GMEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.vpc_attr_buf_gmem_base            & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009315,
        .value =
            (fields.vpc_attr_buf_gmem_base            <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_ATTR_BUF_GMEM_BASE(...) pack_A8XX_VPC_ATTR_BUF_GMEM_BASE(__struct_cast(A8XX_VPC_ATTR_BUF_GMEM_BASE) { __VA_ARGS__ })

struct A8XX_VPC_POS_BUF_GMEM_SIZE {
    uint32_t							vpc_pos_buf_gmem_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_POS_BUF_GMEM_SIZE(struct A8XX_VPC_POS_BUF_GMEM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.vpc_pos_buf_gmem_size             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009316,
        .value =
            (fields.vpc_pos_buf_gmem_size             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_POS_BUF_GMEM_SIZE(...) pack_A8XX_VPC_POS_BUF_GMEM_SIZE(__struct_cast(A8XX_VPC_POS_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_VPC_POS_BUF_GMEM_BASE {
    uint32_t							vpc_pos_buf_gmem_base;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_POS_BUF_GMEM_BASE(struct A8XX_VPC_POS_BUF_GMEM_BASE fields)
{
#ifndef NDEBUG
    assert((fields.vpc_pos_buf_gmem_base             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009317,
        .value =
            (fields.vpc_pos_buf_gmem_base             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_POS_BUF_GMEM_BASE(...) pack_A8XX_VPC_POS_BUF_GMEM_BASE(__struct_cast(A8XX_VPC_POS_BUF_GMEM_BASE) { __VA_ARGS__ })

struct A7XX_PC_ATTR_BUF_GMEM_SIZE {
    uint32_t							pc_attr_buf_gmem_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_PC_ATTR_BUF_GMEM_SIZE(struct A7XX_PC_ATTR_BUF_GMEM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.pc_attr_buf_gmem_size             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b09,
        .value =
            (fields.pc_attr_buf_gmem_size             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_PC_ATTR_BUF_GMEM_SIZE(...) pack_A7XX_PC_ATTR_BUF_GMEM_SIZE(__struct_cast(A7XX_PC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_PC_ATTR_BUF_GMEM_SIZE {
    uint32_t							pc_attr_buf_gmem_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_ATTR_BUF_GMEM_SIZE(struct A8XX_PC_ATTR_BUF_GMEM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.pc_attr_buf_gmem_size             & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b16,
        .value =
            (fields.pc_attr_buf_gmem_size             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_ATTR_BUF_GMEM_SIZE(...) pack_A8XX_PC_ATTR_BUF_GMEM_SIZE(__struct_cast(A8XX_PC_ATTR_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A8XX_PC_POS_BUF_GMEM_SIZE {
    uint32_t							pc_pos_buf_gmem_size;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_POS_BUF_GMEM_SIZE(struct A8XX_PC_POS_BUF_GMEM_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.pc_pos_buf_gmem_size              & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b17,
        .value =
            (fields.pc_pos_buf_gmem_size              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_POS_BUF_GMEM_SIZE(...) pack_A8XX_PC_POS_BUF_GMEM_SIZE(__struct_cast(A8XX_PC_POS_BUF_GMEM_SIZE) { __VA_ARGS__ })

struct A7XX_VPC_UNKNOWN_930A {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_UNKNOWN_930A(struct A7XX_VPC_UNKNOWN_930A fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000930a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_UNKNOWN_930A(...) pack_A7XX_VPC_UNKNOWN_930A(__struct_cast(A7XX_VPC_UNKNOWN_930A) { __VA_ARGS__ })

struct A8XX_VPC_UNKNOWN_9313 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_UNKNOWN_9313(struct A8XX_VPC_UNKNOWN_9313 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009313,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_UNKNOWN_9313(...) pack_A8XX_VPC_UNKNOWN_9313(__struct_cast(A8XX_VPC_UNKNOWN_9313) { __VA_ARGS__ })

struct A8XX_PC_UNKNOWN_9E17 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_UNKNOWN_9E17(struct A8XX_PC_UNKNOWN_9E17 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009e17,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_UNKNOWN_9E17(...) pack_A8XX_PC_UNKNOWN_9E17(__struct_cast(A8XX_PC_UNKNOWN_9E17) { __VA_ARGS__ })

struct A7XX_VPC_FLATSHADE_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_FLATSHADE_MODE_CNTL(struct A7XX_VPC_FLATSHADE_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000960a,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_FLATSHADE_MODE_CNTL(...) pack_A7XX_VPC_FLATSHADE_MODE_CNTL(__struct_cast(A7XX_VPC_FLATSHADE_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_FLATSHADE_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_FLATSHADE_MODE_CNTL(struct A8XX_VPC_FLATSHADE_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009741,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_FLATSHADE_MODE_CNTL(...) pack_A8XX_VPC_FLATSHADE_MODE_CNTL(__struct_cast(A8XX_VPC_FLATSHADE_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_DBG_ECO_CNTL(struct A6XX_VPC_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009600,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_DBG_ECO_CNTL(...) pack_A6XX_VPC_DBG_ECO_CNTL(__struct_cast(A6XX_VPC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_ADDR_MODE_CNTL {
    enum a5xx_address_mode					vpc_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_ADDR_MODE_CNTL(struct A6XX_VPC_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.vpc_addr_mode_cntl                & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009601,
        .value =
            (fields.vpc_addr_mode_cntl                <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_ADDR_MODE_CNTL(...) pack_A6XX_VPC_ADDR_MODE_CNTL(__struct_cast(A6XX_VPC_ADDR_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_DBG_ECO_CNTL(struct A8XX_VPC_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009680,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_DBG_ECO_CNTL(...) pack_A8XX_VPC_DBG_ECO_CNTL(__struct_cast(A8XX_VPC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_DBG_ECO_CNTL_2(struct A8XX_VPC_DBG_ECO_CNTL_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009604,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_DBG_ECO_CNTL_2(...) pack_A8XX_VPC_DBG_ECO_CNTL_2(__struct_cast(A8XX_VPC_DBG_ECO_CNTL_2) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_DBG_ECO_CNTL_1(struct A8XX_VPC_DBG_ECO_CNTL_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009742,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_DBG_ECO_CNTL_1(...) pack_A8XX_VPC_DBG_ECO_CNTL_1(__struct_cast(A8XX_VPC_DBG_ECO_CNTL_1) { __VA_ARGS__ })

struct A8XX_VPC_DBG_ECO_CNTL_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_DBG_ECO_CNTL_3(struct A8XX_VPC_DBG_ECO_CNTL_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009745,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_DBG_ECO_CNTL_3(...) pack_A8XX_VPC_DBG_ECO_CNTL_3(__struct_cast(A8XX_VPC_DBG_ECO_CNTL_3) { __VA_ARGS__ })

struct A6XX_VPC_LB_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_LB_MODE_CNTL(struct A6XX_VPC_LB_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009602,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_LB_MODE_CNTL(...) pack_A6XX_VPC_LB_MODE_CNTL(__struct_cast(A6XX_VPC_LB_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_VPC_LB_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_LB_MODE_CNTL(struct A8XX_VPC_LB_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009740,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_LB_MODE_CNTL(...) pack_A8XX_VPC_LB_MODE_CNTL(__struct_cast(A8XX_VPC_LB_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_VPC_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_STATUS(struct A6XX_VPC_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009603,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_STATUS(...) pack_A6XX_VPC_STATUS(__struct_cast(A6XX_VPC_STATUS) { __VA_ARGS__ })

struct A8XX_VPC_STATUS {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_STATUS(struct A8XX_VPC_STATUS fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009600,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_STATUS(...) pack_A8XX_VPC_STATUS(__struct_cast(A8XX_VPC_STATUS) { __VA_ARGS__ })

struct A6XX_VPC_PERFCTR_VPC_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_PERFCTR_VPC_SEL_REG(uint32_t __i, struct A6XX_VPC_PERFCTR_VPC_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009604 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_VPC_PERFCTR_VPC_SEL_REG(__i, ...) pack_A6XX_VPC_PERFCTR_VPC_SEL_REG(__i, __struct_cast(A6XX_VPC_PERFCTR_VPC_SEL_REG) { __VA_ARGS__ })

struct A7XX_VPC_PERFCTR_VPC_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_VPC_PERFCTR_VPC_SEL_REG(uint32_t __i, struct A7XX_VPC_PERFCTR_VPC_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x0000960b + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_VPC_PERFCTR_VPC_SEL_REG(__i, ...) pack_A7XX_VPC_PERFCTR_VPC_SEL_REG(__i, __struct_cast(A7XX_VPC_PERFCTR_VPC_SEL_REG) { __VA_ARGS__ })

struct A8XX_VPC_PERFCTR_VPC_SEL_2_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_PERFCTR_VPC_SEL_2_REG(uint32_t __i, struct A8XX_VPC_PERFCTR_VPC_SEL_2_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009670 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_PERFCTR_VPC_SEL_2_REG(__i, ...) pack_A8XX_VPC_PERFCTR_VPC_SEL_2_REG(__i, __struct_cast(A8XX_VPC_PERFCTR_VPC_SEL_2_REG) { __VA_ARGS__ })

struct A8XX_VPC_PERFCTR_VPC_SEL_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_PERFCTR_VPC_SEL_REG(uint32_t __i, struct A8XX_VPC_PERFCTR_VPC_SEL_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009690 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_PERFCTR_VPC_SEL_REG(__i, ...) pack_A8XX_VPC_PERFCTR_VPC_SEL_REG(__i, __struct_cast(A8XX_VPC_PERFCTR_VPC_SEL_REG) { __VA_ARGS__ })

struct A8XX_VPC_PERFCTR_VPC_SEL_1_REG {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_PERFCTR_VPC_SEL_1_REG(uint32_t __i, struct A8XX_VPC_PERFCTR_VPC_SEL_1_REG fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)(0x00009750 + 0x1*__i),
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_VPC_PERFCTR_VPC_SEL_1_REG(__i, ...) pack_A8XX_VPC_PERFCTR_VPC_SEL_1_REG(__i, __struct_cast(A8XX_VPC_PERFCTR_VPC_SEL_1_REG) { __VA_ARGS__ })

struct A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(struct A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009634,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(...) pack_A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(__struct_cast(A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR {
    __bo_type							bo;
    uint32_t							bo_offset;
    uint64_t							unknown;
    uint64_t							qword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(struct A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0xffffffffffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009602,
        .value =
            fields.unknown | fields.qword,
        .bo = fields.bo,
        .is_address = true,
        .bo_write = true,
        .bo_offset = fields.bo_offset,
        .bo_shift = 0,
        .bo_low = 0,
    };

}

#define A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(...) pack_A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR(__struct_cast(A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR) { __VA_ARGS__ }), { .reg = 0 }

struct A8XX_PC_UNKNOWN_980B {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_UNKNOWN_980B(struct A8XX_PC_UNKNOWN_980B fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000980b,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_UNKNOWN_980B(...) pack_A8XX_PC_UNKNOWN_980B(__struct_cast(A8XX_PC_UNKNOWN_980B) { __VA_ARGS__ })

struct A6XX_PC_HS_PARAM_0 {
    uint32_t							pc_hs_param_0;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_HS_PARAM_0(struct A6XX_PC_HS_PARAM_0 fields)
{
#ifndef NDEBUG
    assert((fields.pc_hs_param_0                     & 0xffffffc0) == 0);
    assert((fields.unknown                           & 0x0000003f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009800,
        .value =
            (fields.pc_hs_param_0                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_HS_PARAM_0(...) pack_A6XX_PC_HS_PARAM_0(__struct_cast(A6XX_PC_HS_PARAM_0) { __VA_ARGS__ })

struct A8XX_PC_HS_PARAM_0 {
    uint32_t							pc_hs_param_0;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_HS_PARAM_0(struct A8XX_PC_HS_PARAM_0 fields)
{
#ifndef NDEBUG
    assert((fields.pc_hs_param_0                     & 0xffffffc0) == 0);
    assert((fields.unknown                           & 0x0000003f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b10,
        .value =
            (fields.pc_hs_param_0                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_HS_PARAM_0(...) pack_A8XX_PC_HS_PARAM_0(__struct_cast(A8XX_PC_HS_PARAM_0) { __VA_ARGS__ })

struct A6XX_PC_HS_PARAM_1 {
    uint32_t							size;
    uint32_t							unk13;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_HS_PARAM_1(struct A6XX_PC_HS_PARAM_1 fields)
{
#ifndef NDEBUG
    assert((fields.size                              & 0xfffff800) == 0);
    assert((fields.unk13                             & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x000027ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009801,
        .value =
            (fields.size                              <<  0) |
            (fields.unk13                             << 13) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_HS_PARAM_1(...) pack_A6XX_PC_HS_PARAM_1(__struct_cast(A6XX_PC_HS_PARAM_1) { __VA_ARGS__ })

struct A8XX_PC_HS_PARAM_1 {
    uint32_t							size;
    uint32_t							unk13;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_HS_PARAM_1(struct A8XX_PC_HS_PARAM_1 fields)
{
#ifndef NDEBUG
    assert((fields.size                              & 0xfffff800) == 0);
    assert((fields.unk13                             & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x000027ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b11,
        .value =
            (fields.size                              <<  0) |
            (fields.unk13                             << 13) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_HS_PARAM_1(...) pack_A8XX_PC_HS_PARAM_1(__struct_cast(A8XX_PC_HS_PARAM_1) { __VA_ARGS__ })

struct A6XX_PC_DS_PARAM {
    enum a6xx_tess_spacing					spacing;
    enum a6xx_tess_output					output;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_DS_PARAM(struct A6XX_PC_DS_PARAM fields)
{
#ifndef NDEBUG
    assert((fields.spacing                           & 0xfffffffc) == 0);
    assert((fields.output                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009802,
        .value =
            (fields.spacing                           <<  0) |
            (fields.output                            <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_DS_PARAM(...) pack_A6XX_PC_DS_PARAM(__struct_cast(A6XX_PC_DS_PARAM) { __VA_ARGS__ })

struct A8XX_PC_DS_PARAM {
    enum a6xx_tess_spacing					spacing;
    enum a6xx_tess_output					output;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DS_PARAM(struct A8XX_PC_DS_PARAM fields)
{
#ifndef NDEBUG
    assert((fields.spacing                           & 0xfffffffc) == 0);
    assert((fields.output                            & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b12,
        .value =
            (fields.spacing                           <<  0) |
            (fields.output                            <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DS_PARAM(...) pack_A8XX_PC_DS_PARAM(__struct_cast(A8XX_PC_DS_PARAM) { __VA_ARGS__ })

struct A6XX_PC_RESTART_INDEX {
    uint32_t							pc_restart_index;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_RESTART_INDEX(struct A6XX_PC_RESTART_INDEX fields)
{
#ifndef NDEBUG
    assert((fields.pc_restart_index                  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009803,
        .value =
            (fields.pc_restart_index                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_RESTART_INDEX(...) pack_A6XX_PC_RESTART_INDEX(__struct_cast(A6XX_PC_RESTART_INDEX) { __VA_ARGS__ })

struct A8XX_PC_RESTART_INDEX {
    uint32_t							pc_restart_index;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_RESTART_INDEX(struct A8XX_PC_RESTART_INDEX fields)
{
#ifndef NDEBUG
    assert((fields.pc_restart_index                  & 0x00000000) == 0);
    assert((fields.unknown                           & 0xffffffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b15,
        .value =
            (fields.pc_restart_index                  <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_RESTART_INDEX(...) pack_A8XX_PC_RESTART_INDEX(__struct_cast(A8XX_PC_RESTART_INDEX) { __VA_ARGS__ })

struct A6XX_PC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_MODE_CNTL(struct A6XX_PC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009804,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_MODE_CNTL(...) pack_A6XX_PC_MODE_CNTL(__struct_cast(A6XX_PC_MODE_CNTL) { __VA_ARGS__ })

struct A8XX_PC_MODE_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_MODE_CNTL(struct A8XX_PC_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_MODE_CNTL(...) pack_A8XX_PC_MODE_CNTL(__struct_cast(A8XX_PC_MODE_CNTL) { __VA_ARGS__ })

struct A6XX_PC_POWER_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_PC_POWER_CNTL(struct A6XX_PC_POWER_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009805,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_POWER_CNTL(...) pack_A6XX_PC_POWER_CNTL(__struct_cast(A6XX_PC_POWER_CNTL) { __VA_ARGS__ })

struct A6XX_PC_PS_CNTL {
    bool							primitiveiden;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_PS_CNTL(struct A6XX_PC_PS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009806,
        .value =
            (fields.primitiveiden                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_PS_CNTL(...) pack_A6XX_PC_PS_CNTL(__struct_cast(A6XX_PC_PS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_PS_CNTL {
    bool							primitiveiden;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_PS_CNTL(struct A8XX_PC_PS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b06,
        .value =
            (fields.primitiveiden                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_PS_CNTL(...) pack_A8XX_PC_PS_CNTL(__struct_cast(A8XX_PC_PS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DGEN_SO_CNTL {
    uint32_t							stream_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_DGEN_SO_CNTL(struct A6XX_PC_DGEN_SO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stream_enable                     & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x00078000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009808,
        .value =
            (fields.stream_enable                     << 15) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_DGEN_SO_CNTL(...) pack_A6XX_PC_DGEN_SO_CNTL(__struct_cast(A6XX_PC_DGEN_SO_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DGEN_SO_CNTL {
    uint32_t							stream_enable;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DGEN_SO_CNTL(struct A8XX_PC_DGEN_SO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stream_enable                     & 0xfffffff0) == 0);
    assert((fields.unknown                           & 0x00078000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b0b,
        .value =
            (fields.stream_enable                     << 15) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DGEN_SO_CNTL(...) pack_A8XX_PC_DGEN_SO_CNTL(__struct_cast(A8XX_PC_DGEN_SO_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(struct A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x0000980a,
        .value =
            (fields.conservativerasen                 <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(...) pack_A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL {
    bool							conservativerasen;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(struct A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000001) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b08,
        .value =
            (fields.conservativerasen                 <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(...) pack_A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL(__struct_cast(A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_VS_INPUT_CNTL {
    uint32_t							instr_cnt;
    uint32_t							sideband_cnt;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_VS_INPUT_CNTL(struct A8XX_PC_VS_INPUT_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.instr_cnt                         & 0xffffffc0) == 0);
    assert((fields.sideband_cnt                      & 0xfffffff8) == 0);
    assert((fields.unknown                           & 0x000001ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b0c,
        .value =
            (fields.instr_cnt                         <<  0) |
            (fields.sideband_cnt                      <<  6) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_VS_INPUT_CNTL(...) pack_A8XX_PC_VS_INPUT_CNTL(__struct_cast(A8XX_PC_VS_INPUT_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DRAW_INITIATOR {
    uint32_t							state_id;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_DRAW_INITIATOR(struct A6XX_PC_DRAW_INITIATOR fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009840,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_DRAW_INITIATOR(...) pack_A6XX_PC_DRAW_INITIATOR(__struct_cast(A6XX_PC_DRAW_INITIATOR) { __VA_ARGS__ })

struct A6XX_PC_KERNEL_INITIATOR {
    uint32_t							state_id;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_KERNEL_INITIATOR(struct A6XX_PC_KERNEL_INITIATOR fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009841,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_KERNEL_INITIATOR(...) pack_A6XX_PC_KERNEL_INITIATOR(__struct_cast(A6XX_PC_KERNEL_INITIATOR) { __VA_ARGS__ })

struct A8XX_PC_DRAW_INITIATOR {
    uint32_t							state_id;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DRAW_INITIATOR(struct A8XX_PC_DRAW_INITIATOR fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009800,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DRAW_INITIATOR(...) pack_A8XX_PC_DRAW_INITIATOR(__struct_cast(A8XX_PC_DRAW_INITIATOR) { __VA_ARGS__ })

struct A8XX_PC_KERNEL_INITIATOR {
    uint32_t							state_id;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_KERNEL_INITIATOR(struct A8XX_PC_KERNEL_INITIATOR fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x000000ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009801,
        .value =
            (fields.state_id                          <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_KERNEL_INITIATOR(...) pack_A8XX_PC_KERNEL_INITIATOR(__struct_cast(A8XX_PC_KERNEL_INITIATOR) { __VA_ARGS__ })

struct A6XX_PC_EVENT_INITIATOR {
    uint32_t							state_id;
    enum vgt_event_type						event;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_EVENT_INITIATOR(struct A6XX_PC_EVENT_INITIATOR fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.event                             & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x00ff007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009842,
        .value =
            (fields.state_id                          << 16) |
            (fields.event                             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_EVENT_INITIATOR(...) pack_A6XX_PC_EVENT_INITIATOR(__struct_cast(A6XX_PC_EVENT_INITIATOR) { __VA_ARGS__ })

struct A8XX_PC_EVENT_INITIATOR {
    uint32_t							state_id;
    enum vgt_event_type						event;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_EVENT_INITIATOR(struct A8XX_PC_EVENT_INITIATOR fields)
{
#ifndef NDEBUG
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.event                             & 0xffffff80) == 0);
    assert((fields.unknown                           & 0x00ff007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009802,
        .value =
            (fields.state_id                          << 16) |
            (fields.event                             <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_EVENT_INITIATOR(...) pack_A8XX_PC_EVENT_INITIATOR(__struct_cast(A8XX_PC_EVENT_INITIATOR) { __VA_ARGS__ })

struct A6XX_PC_MARKER {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_PC_MARKER(struct A6XX_PC_MARKER fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009880,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_MARKER(...) pack_A6XX_PC_MARKER(__struct_cast(A6XX_PC_MARKER) { __VA_ARGS__ })

struct A6XX_PC_DGEN_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_DGEN_RAST_CNTL(struct A6XX_PC_DGEN_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009981,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_DGEN_RAST_CNTL(...) pack_A6XX_PC_DGEN_RAST_CNTL(__struct_cast(A6XX_PC_DGEN_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_PC_DGEN_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_PC_DGEN_RAST_CNTL(struct A7XX_PC_DGEN_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009809,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A7XX_PC_DGEN_RAST_CNTL(...) pack_A7XX_PC_DGEN_RAST_CNTL(__struct_cast(A7XX_PC_DGEN_RAST_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DGEN_RAST_CNTL {
    enum a6xx_polygon_mode					mode;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DGEN_RAST_CNTL(struct A8XX_PC_DGEN_RAST_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.mode                              & 0xfffffffc) == 0);
    assert((fields.unknown                           & 0x00000003) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009812,
        .value =
            (fields.mode                              <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DGEN_RAST_CNTL(...) pack_A8XX_PC_DGEN_RAST_CNTL(__struct_cast(A8XX_PC_DGEN_RAST_CNTL) { __VA_ARGS__ })

struct A7XX_PC_HS_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_PC_HS_BUFFER_SIZE(struct A7XX_PC_HS_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009885,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_PC_HS_BUFFER_SIZE(...) pack_A7XX_PC_HS_BUFFER_SIZE(__struct_cast(A7XX_PC_HS_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_PC_HS_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_HS_BUFFER_SIZE(struct A8XX_PC_HS_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009814,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_HS_BUFFER_SIZE(...) pack_A8XX_PC_HS_BUFFER_SIZE(__struct_cast(A8XX_PC_HS_BUFFER_SIZE) { __VA_ARGS__ })

struct A7XX_PC_TF_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A7XX_PC_TF_BUFFER_SIZE(struct A7XX_PC_TF_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009886,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A7XX_PC_TF_BUFFER_SIZE(...) pack_A7XX_PC_TF_BUFFER_SIZE(__struct_cast(A7XX_PC_TF_BUFFER_SIZE) { __VA_ARGS__ })

struct A8XX_PC_TF_BUFFER_SIZE {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_TF_BUFFER_SIZE(struct A8XX_PC_TF_BUFFER_SIZE fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009815,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_TF_BUFFER_SIZE(...) pack_A8XX_PC_TF_BUFFER_SIZE(__struct_cast(A8XX_PC_TF_BUFFER_SIZE) { __VA_ARGS__ })

struct A6XX_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_CNTL(struct A6XX_PC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b00,
        .value =
            (fields.primitive_restart                 <<  0) |
            (fields.provoking_vtx_last                <<  1) |
            (fields.d3d_vertex_ordering               <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_CNTL(...) pack_A6XX_PC_CNTL(__struct_cast(A6XX_PC_CNTL) { __VA_ARGS__ })

struct A8XX_PC_CNTL {
    bool							primitive_restart;
    bool							provoking_vtx_last;
    bool							d3d_vertex_ordering;
    bool							unk3;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_CNTL(struct A8XX_PC_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x0000000f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b01,
        .value =
            (fields.primitive_restart                 <<  0) |
            (fields.provoking_vtx_last                <<  1) |
            (fields.d3d_vertex_ordering               <<  2) |
            (fields.unk3                              <<  3) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_CNTL(...) pack_A8XX_PC_CNTL(__struct_cast(A8XX_PC_CNTL) { __VA_ARGS__ })

struct A6XX_PC_VS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_VS_CNTL(struct A6XX_PC_VS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b01,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_VS_CNTL(...) pack_A6XX_PC_VS_CNTL(__struct_cast(A6XX_PC_VS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_GS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_GS_CNTL(struct A6XX_PC_GS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b02,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_GS_CNTL(...) pack_A6XX_PC_GS_CNTL(__struct_cast(A6XX_PC_GS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_HS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_HS_CNTL(struct A6XX_PC_HS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b03,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_HS_CNTL(...) pack_A6XX_PC_HS_CNTL(__struct_cast(A6XX_PC_HS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_DS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_DS_CNTL(struct A6XX_PC_DS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b04,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_DS_CNTL(...) pack_A6XX_PC_DS_CNTL(__struct_cast(A6XX_PC_DS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_VS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_VS_CNTL(struct A8XX_PC_VS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b02,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_VS_CNTL(...) pack_A8XX_PC_VS_CNTL(__struct_cast(A8XX_PC_VS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_GS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_GS_CNTL(struct A8XX_PC_GS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b03,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_GS_CNTL(...) pack_A8XX_PC_GS_CNTL(__struct_cast(A8XX_PC_GS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_HS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_HS_CNTL(struct A8XX_PC_HS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b04,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_HS_CNTL(...) pack_A8XX_PC_HS_CNTL(__struct_cast(A8XX_PC_HS_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DS_CNTL {
    uint32_t							stride_in_vpc;
    bool							psize;
    bool							layer;
    bool							view;
    bool							primitive_id;
    uint32_t							clip_mask;
    bool							shadingrate;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DS_CNTL(struct A8XX_PC_DS_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xffffff00) == 0);
    assert((fields.clip_mask                         & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x01ff0fff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b05,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            (fields.psize                             <<  8) |
            (fields.layer                             <<  9) |
            (fields.view                              << 10) |
            (fields.primitive_id                      << 11) |
            (fields.clip_mask                         << 16) |
            (fields.shadingrate                       << 24) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DS_CNTL(...) pack_A8XX_PC_DS_CNTL(__struct_cast(A8XX_PC_DS_CNTL) { __VA_ARGS__ })

struct A6XX_PC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_GS_PARAM_0(struct A6XX_PC_GS_PARAM_0 fields)
{
#ifndef NDEBUG
    assert((fields.gs_vertices_out                   & 0xffffff00) == 0);
    assert((fields.gs_invocations                    & 0xffffffe0) == 0);
    assert((fields.gs_output                         & 0xfffffffc) == 0);
    assert((fields.unk18                             & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0007fcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b05,
        .value =
            (fields.gs_vertices_out                   <<  0) |
            (fields.gs_invocations                    << 10) |
            (fields.linelengthen                      << 15) |
            (fields.gs_output                         << 16) |
            (fields.unk18                             << 18) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_GS_PARAM_0(...) pack_A6XX_PC_GS_PARAM_0(__struct_cast(A6XX_PC_GS_PARAM_0) { __VA_ARGS__ })

struct A8XX_PC_GS_PARAM_0 {
    uint32_t							gs_vertices_out;
    uint32_t							gs_invocations;
    bool							linelengthen;
    enum a6xx_tess_output					gs_output;
    uint32_t							unk18;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_GS_PARAM_0(struct A8XX_PC_GS_PARAM_0 fields)
{
#ifndef NDEBUG
    assert((fields.gs_vertices_out                   & 0xffffff00) == 0);
    assert((fields.gs_invocations                    & 0xffffffe0) == 0);
    assert((fields.gs_output                         & 0xfffffffc) == 0);
    assert((fields.unk18                             & 0xfffffffe) == 0);
    assert((fields.unknown                           & 0x0007fcff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b13,
        .value =
            (fields.gs_vertices_out                   <<  0) |
            (fields.gs_invocations                    << 10) |
            (fields.linelengthen                      << 15) |
            (fields.gs_output                         << 16) |
            (fields.unk18                             << 18) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_GS_PARAM_0(...) pack_A8XX_PC_GS_PARAM_0(__struct_cast(A8XX_PC_GS_PARAM_0) { __VA_ARGS__ })

struct A6XX_PC_PRIMITIVE_CNTL_6 {
    uint32_t							stride_in_vpc;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_PRIMITIVE_CNTL_6(struct A6XX_PC_PRIMITIVE_CNTL_6 fields)
{
#ifndef NDEBUG
    assert((fields.stride_in_vpc                     & 0xfffff800) == 0);
    assert((fields.unknown                           & 0x000007ff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b06,
        .value =
            (fields.stride_in_vpc                     <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_PRIMITIVE_CNTL_6(...) pack_A6XX_PC_PRIMITIVE_CNTL_6(__struct_cast(A6XX_PC_PRIMITIVE_CNTL_6) { __VA_ARGS__ })

struct A6XX_PC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_STEREO_RENDERING_CNTL(struct A6XX_PC_STEREO_RENDERING_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.views                             & 0xffffffe0) == 0);
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b07,
        .value =
            (fields.enable                            <<  0) |
            (fields.disablemultipos                   <<  1) |
            (fields.views                             <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_STEREO_RENDERING_CNTL(...) pack_A6XX_PC_STEREO_RENDERING_CNTL(__struct_cast(A6XX_PC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A8XX_PC_STEREO_RENDERING_CNTL {
    bool							enable;
    bool							disablemultipos;
    uint32_t							views;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_STEREO_RENDERING_CNTL(struct A8XX_PC_STEREO_RENDERING_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.views                             & 0xffffffe0) == 0);
    assert((fields.unknown                           & 0x0000007f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b09,
        .value =
            (fields.enable                            <<  0) |
            (fields.disablemultipos                   <<  1) |
            (fields.views                             <<  2) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_STEREO_RENDERING_CNTL(...) pack_A8XX_PC_STEREO_RENDERING_CNTL(__struct_cast(A8XX_PC_STEREO_RENDERING_CNTL) { __VA_ARGS__ })

struct A6XX_PC_STEREO_RENDERING_VIEWMASK {
    uint32_t							pc_stereo_rendering_viewmask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_STEREO_RENDERING_VIEWMASK(struct A6XX_PC_STEREO_RENDERING_VIEWMASK fields)
{
#ifndef NDEBUG
    assert((fields.pc_stereo_rendering_viewmask      & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b08,
        .value =
            (fields.pc_stereo_rendering_viewmask      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_STEREO_RENDERING_VIEWMASK(...) pack_A6XX_PC_STEREO_RENDERING_VIEWMASK(__struct_cast(A6XX_PC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A8XX_PC_STEREO_RENDERING_VIEWMASK {
    uint32_t							pc_stereo_rendering_viewmask;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_STEREO_RENDERING_VIEWMASK(struct A8XX_PC_STEREO_RENDERING_VIEWMASK fields)
{
#ifndef NDEBUG
    assert((fields.pc_stereo_rendering_viewmask      & 0xffff0000) == 0);
    assert((fields.unknown                           & 0x0000ffff) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009b0d,
        .value =
            (fields.pc_stereo_rendering_viewmask      <<  0) |
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_STEREO_RENDERING_VIEWMASK(...) pack_A8XX_PC_STEREO_RENDERING_VIEWMASK(__struct_cast(A8XX_PC_STEREO_RENDERING_VIEWMASK) { __VA_ARGS__ })

struct A6XX_PC_2D_EVENT_CMD {
    enum vgt_event_type						event;
    uint32_t							state_id;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline struct fd_reg_pair
pack_A6XX_PC_2D_EVENT_CMD(struct A6XX_PC_2D_EVENT_CMD fields)
{
#ifndef NDEBUG
    assert((fields.event                             & 0xffffff80) == 0);
    assert((fields.state_id                          & 0xffffff00) == 0);
    assert((fields.unknown                           & 0x0000ff7f) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009c00,
        .value =
            (fields.event                             <<  0) |
            (fields.state_id                          <<  8) |
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_2D_EVENT_CMD(...) pack_A6XX_PC_2D_EVENT_CMD(__struct_cast(A6XX_PC_2D_EVENT_CMD) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_1 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_CHICKEN_BITS_1(struct A8XX_PC_CHICKEN_BITS_1 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009e50,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_CHICKEN_BITS_1(...) pack_A8XX_PC_CHICKEN_BITS_1(__struct_cast(A8XX_PC_CHICKEN_BITS_1) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_2 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_CHICKEN_BITS_2(struct A8XX_PC_CHICKEN_BITS_2 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009f20,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_CHICKEN_BITS_2(...) pack_A8XX_PC_CHICKEN_BITS_2(__struct_cast(A8XX_PC_CHICKEN_BITS_2) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_3 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_CHICKEN_BITS_3(struct A8XX_PC_CHICKEN_BITS_3 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009e22,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_CHICKEN_BITS_3(...) pack_A8XX_PC_CHICKEN_BITS_3(__struct_cast(A8XX_PC_CHICKEN_BITS_3) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_4 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_CHICKEN_BITS_4(struct A8XX_PC_CHICKEN_BITS_4 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009e23,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_CHICKEN_BITS_4(...) pack_A8XX_PC_CHICKEN_BITS_4(__struct_cast(A8XX_PC_CHICKEN_BITS_4) { __VA_ARGS__ })

struct A8XX_PC_CHICKEN_BITS_5 {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_CHICKEN_BITS_5(struct A8XX_PC_CHICKEN_BITS_5 fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009f23,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_CHICKEN_BITS_5(...) pack_A8XX_PC_CHICKEN_BITS_5(__struct_cast(A8XX_PC_CHICKEN_BITS_5) { __VA_ARGS__ })

struct A6XX_PC_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_DBG_ECO_CNTL(struct A6XX_PC_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009e00,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A6XX_PC_DBG_ECO_CNTL(...) pack_A6XX_PC_DBG_ECO_CNTL(__struct_cast(A6XX_PC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A8XX_PC_DBG_ECO_CNTL {
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A8XX_PC_DBG_ECO_CNTL(struct A8XX_PC_DBG_ECO_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.unknown                           & 0x00000000) == 0);
#endif

    return (struct fd_reg_pair) {
        .reg = (uint32_t)0x00009e53,
        .value =
            fields.unknown | fields.dword,
    };

}

#define A8XX_PC_DBG_ECO_CNTL(...) pack_A8XX_PC_DBG_ECO_CNTL(__struct_cast(A8XX_PC_DBG_ECO_CNTL) { __VA_ARGS__ })

struct A6XX_PC_ADDR_MODE_CNTL {
    enum a5xx_address_mode					pc_addr_mode_cntl;
    uint32_t							unknown;
    uint32_t							dword;
};

static inline FD_DEPRECATED struct fd_reg_pair
pack_A6XX_PC_ADDR_MODE_CNTL(struct A6XX_PC_ADDR_MODE_CNTL fields)
{
#ifndef NDEBUG
    assert((fields.pc_addr_mode_cntl                 & 0x00000000) == 0);
    assert((fields.unknown    