/*
 * Copyright 2021 Alyssa Rosenzweig
 * SPDX-License-Identifier: MIT
 */

#include "agx_opcodes.h"



const struct agx_opcode_info agx_opcodes_info[AGX_NUM_OPCODES] = {

   [AGX_OPCODE_FLOOR] = {
      "floor", 1, 1, 0,
      { 0xa, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_SRSQRT] = {
      "srsqrt", 1, 1, 0,
      { 0x1000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_DFDX] = {
      "dfdx", 1, 1, 0,
      { 0x4000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_COVERAGE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_DFDY] = {
      "dfdy", 1, 1, 0,
      { 0x6000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_COVERAGE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_RCP] = {
      "rcp", 1, 1, 0,
      { 0x8000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_RSQRT] = {
      "rsqrt", 1, 1, 0,
      { 0x9000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_SIN_PT_1] = {
      "sin_pt_1", 1, 1, 0,
      { 0xa000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_LOG2] = {
      "log2", 1, 1, 0,
      { 0xc000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_EXP2] = {
      "exp2", 1, 1, 0,
      { 0xd000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_SIN_PT_2] = {
      "sin_pt_2", 1, 1, 0,
      { 0xe000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_CEIL] = {
      "ceil", 1, 1, 0,
      { 0x10000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_TRUNC] = {
      "trunc", 1, 1, 0,
      { 0x20000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_ROUNDEVEN] = {
      "roundeven", 1, 1, 0,
      { 0x30000000a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_BITREV] = {
      "bitrev", 1, 1, 0,
      { 0x400003e, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_POPCOUNT] = {
      "popcount", 1, 1, 0,
      { 0x800003e, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_FFS] = {
      "ffs", 1, 1, 0,
      { 0xc00003e, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_FADD] = {
      "fadd", 2, 1, 0,
      { 0x2a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_FFMA] = {
      "ffma", 3, 1, 0,
      { 0x3a, 6, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_FMUL] = {
      "fmul", 2, 1, 0,
      { 0x1a, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_HADD] = {
      "hadd", 2, 1, 0,
      { 0x26, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_HFMA] = {
      "hfma", 3, 1, 0,
      { 0x36, 6, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_HMUL] = {
      "hmul", 2, 1, 0,
      { 0x16, 4, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      1,
      1,
      1,
   },

   [AGX_OPCODE_MOV_IMM] = {
      "mov_imm", 0, 1, AGX_IMMEDIATE_IMM,
      { 0x62, 6, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_IADD] = {
      "iadd", 2, 1, AGX_IMMEDIATE_SHIFT,
      { 0xe, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_IMAD] = {
      "imad", 3, 1, AGX_IMMEDIATE_SHIFT,
      { 0x1e, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_BFI] = {
      "bfi", 3, 1, AGX_IMMEDIATE_BFI_MASK,
      { 0x2e, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_BFEIL] = {
      "bfeil", 3, 1, AGX_IMMEDIATE_BFI_MASK,
      { 0x802e, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_EXTR] = {
      "extr", 3, 1, AGX_IMMEDIATE_BFI_MASK,
      { 0x400002e, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ASR] = {
      "asr", 2, 1, 0,
      { 0x400802e, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ICMPSEL] = {
      "icmpsel", 4, 1, AGX_IMMEDIATE_ICOND,
      { 0x12, 8, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_FCMPSEL] = {
      "fcmpsel", 4, 1, AGX_IMMEDIATE_FCOND,
      { 0x2, 8, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_QUAD_REDUCE] = {
      "quad_reduce", 1, 1, AGX_IMMEDIATE_SIMD_OP,
      { 0x806f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SIMD_REDUCE] = {
      "simd_reduce", 1, 1, AGX_IMMEDIATE_SIMD_OP,
      { 0x2000806f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_QUAD_PREFIX] = {
      "quad_prefix", 1, 1, AGX_IMMEDIATE_SIMD_OP,
      { 0x4000806f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SIMD_PREFIX] = {
      "simd_prefix", 1, 1, AGX_IMMEDIATE_SIMD_OP,
      { 0x6000806f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_QUAD_SHUFFLE] = {
      "quad_shuffle", 2, 1, 0,
      { 0x6f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_QUAD_SHUFFLE_XOR] = {
      "quad_shuffle_xor", 2, 1, 0,
      { 0x400000006f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_QUAD_SHUFFLE_UP] = {
      "quad_shuffle_up", 2, 1, 0,
      { 0x800000006f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_QUAD_SHUFFLE_DOWN] = {
      "quad_shuffle_down", 2, 1, 0,
      { 0xc00000006f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_QUAD_BALLOT] = {
      "quad_ballot", 1, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_FCMP_QUAD_BALLOT] = {
      "fcmp_quad_ballot", 2, 1, AGX_IMMEDIATE_FCOND | AGX_IMMEDIATE_INVERT_COND,
      { 0x22, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ICMP_QUAD_BALLOT] = {
      "icmp_quad_ballot", 2, 1, AGX_IMMEDIATE_ICOND | AGX_IMMEDIATE_INVERT_COND,
      { 0x32, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SHUFFLE] = {
      "shuffle", 2, 1, 0,
      { 0x400006f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SHUFFLE_XOR] = {
      "shuffle_xor", 2, 1, 0,
      { 0x400400006f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SHUFFLE_UP] = {
      "shuffle_up", 2, 1, 0,
      { 0x800400006f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SHUFFLE_DOWN] = {
      "shuffle_down", 2, 1, 0,
      { 0xc00400006f, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_BALLOT] = {
      "ballot", 1, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_FCMP_BALLOT] = {
      "fcmp_ballot", 2, 1, AGX_IMMEDIATE_FCOND | AGX_IMMEDIATE_INVERT_COND,
      { 0x1000000000022, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ICMP_BALLOT] = {
      "icmp_ballot", 2, 1, AGX_IMMEDIATE_ICOND | AGX_IMMEDIATE_INVERT_COND,
      { 0x1000000000032, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ICMP] = {
      "icmp", 2, 1, AGX_IMMEDIATE_ICOND | AGX_IMMEDIATE_INVERT_COND,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_FCMP] = {
      "fcmp", 2, 1, AGX_IMMEDIATE_FCOND | AGX_IMMEDIATE_INVERT_COND,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_TEXTURE_SAMPLE] = {
      "texture_sample", 6, 1, AGX_IMMEDIATE_DIM | AGX_IMMEDIATE_LOD_MODE | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_SCOREBOARD | AGX_IMMEDIATE_OFFSET | AGX_IMMEDIATE_SHADOW | AGX_IMMEDIATE_QUERY_LOD | AGX_IMMEDIATE_GATHER | AGX_IMMEDIATE_SPARSE,
      { 0x31, 8, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_TEXTURE_LOAD] = {
      "texture_load", 6, 1, AGX_IMMEDIATE_DIM | AGX_IMMEDIATE_LOD_MODE | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_SCOREBOARD | AGX_IMMEDIATE_OFFSET | AGX_IMMEDIATE_SPARSE,
      { 0x71, 8, 1 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_IMAGE_LOAD] = {
      "image_load", 6, 1, AGX_IMMEDIATE_DIM | AGX_IMMEDIATE_LOD_MODE | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_SCOREBOARD | AGX_IMMEDIATE_OFFSET | AGX_IMMEDIATE_SPARSE | AGX_IMMEDIATE_COHERENT,
      { 0x71, 8, 1 },
      AGX_SCHEDULE_CLASS_LOAD,
      0,
      1,
      0,
   },

   [AGX_OPCODE_DEVICE_LOAD] = {
      "device_load", 2, 1, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_SHIFT | AGX_IMMEDIATE_SCOREBOARD | AGX_IMMEDIATE_COHERENT,
      { 0x5, 6, 1 },
      AGX_SCHEDULE_CLASS_LOAD,
      0,
      1,
      0,
   },

   [AGX_OPCODE_LOCAL_LOAD] = {
      "local_load", 2, 1, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK,
      { 0x69, 6, 1 },
      AGX_SCHEDULE_CLASS_LOAD,
      0,
      1,
      0,
   },

   [AGX_OPCODE_DEVICE_STORE] = {
      "device_store", 3, 0, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_SHIFT | AGX_IMMEDIATE_SCOREBOARD | AGX_IMMEDIATE_COHERENT,
      { 0x800000000045, 8, 0 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_LOCAL_STORE] = {
      "local_store", 3, 0, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK,
      { 0x29, 6, 1 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_UNIFORM_STORE] = {
      "uniform_store", 2, 0, AGX_IMMEDIATE_MASK,
      { 0x800038000045, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_TEX_STATE_STORE] = {
      "tex_state_store", 2, 0, AGX_IMMEDIATE_IMM | AGX_IMMEDIATE_SCOREBOARD,
      { 0x1000ed, 8, 0 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_SAMPLER_STATE_STORE] = {
      "sampler_state_store", 2, 0, AGX_IMMEDIATE_IMM | AGX_IMMEDIATE_SCOREBOARD,
      { 0x1000ad, 8, 0 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_ATOMIC] = {
      "atomic", 3, 1, AGX_IMMEDIATE_ATOMIC_OPC | AGX_IMMEDIATE_SCOREBOARD,
      { 0x500084000015, 8, 0 },
      AGX_SCHEDULE_CLASS_ATOMIC,
      0,
      0,
      1,
   },

   [AGX_OPCODE_LOCAL_ATOMIC] = {
      "local_atomic", 3, 1, AGX_IMMEDIATE_ATOMIC_OPC,
      { 0x801000008019, 10, 0 },
      AGX_SCHEDULE_CLASS_ATOMIC,
      0,
      0,
      1,
   },

   [AGX_OPCODE_WAIT] = {
      "wait", 0, 0, AGX_IMMEDIATE_SCOREBOARD,
      { 0x38, 2, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_GET_SR] = {
      "get_sr", 0, 1, AGX_IMMEDIATE_SR,
      { 0x72, 4, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_GET_SR_COVERAGE] = {
      "get_sr_coverage", 0, 1, AGX_IMMEDIATE_SR,
      { 0x72, 4, 0 },
      AGX_SCHEDULE_CLASS_COVERAGE,
      0,
      1,
      0,
   },

   [AGX_OPCODE_GET_SR_BARRIER] = {
      "get_sr_barrier", 0, 1, AGX_IMMEDIATE_SR,
      { 0x72, 4, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      1,
      0,
   },

   [AGX_OPCODE_SAMPLE_MASK] = {
      "sample_mask", 2, 0, 0,
      { 0x7fc1, 6, 0 },
      AGX_SCHEDULE_CLASS_COVERAGE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_ZS_EMIT] = {
      "zs_emit", 2, 0, AGX_IMMEDIATE_ZS,
      { 0x41, 4, 0 },
      AGX_SCHEDULE_CLASS_COVERAGE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_LD_TILE] = {
      "ld_tile", 2, 1, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_PIXEL_OFFSET | AGX_IMMEDIATE_EXPLICIT_COORDS,
      { 0x49, 8, 0 },
      AGX_SCHEDULE_CLASS_COVERAGE,
      0,
      1,
      0,
   },

   [AGX_OPCODE_ST_TILE] = {
      "st_tile", 3, 0, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_PIXEL_OFFSET | AGX_IMMEDIATE_EXPLICIT_COORDS,
      { 0x9, 8, 0 },
      AGX_SCHEDULE_CLASS_COVERAGE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_JMP_EXEC_ANY] = {
      "jmp_exec_any", 0, 0, AGX_IMMEDIATE_TARGET,
      { 0xc000, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_JMP_EXEC_NONE] = {
      "jmp_exec_none", 0, 0, AGX_IMMEDIATE_TARGET,
      { 0xc020, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_JMP_EXEC_NONE_AFTER] = {
      "jmp_exec_none_after", 0, 0, AGX_IMMEDIATE_TARGET,
      { 0xc020, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_POP_EXEC] = {
      "pop_exec", 0, 0, AGX_IMMEDIATE_NEST,
      { 0x652, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_IF_ICMP] = {
      "if_icmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_ICOND | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_TARGET,
      { 0x52, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_ELSE_ICMP] = {
      "else_icmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_ICOND | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_TARGET,
      { 0x252, 6, 0 },
      AGX_SCHEDULE_CLASS_PRELOAD,
      0,
      0,
      1,
   },

   [AGX_OPCODE_WHILE_ICMP] = {
      "while_icmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_ICOND | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_TARGET,
      { 0x452, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_IF_FCMP] = {
      "if_fcmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_FCOND | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_TARGET,
      { 0x42, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      1,
      0,
      1,
   },

   [AGX_OPCODE_ELSE_FCMP] = {
      "else_fcmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_FCOND | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_TARGET,
      { 0x242, 6, 0 },
      AGX_SCHEDULE_CLASS_PRELOAD,
      1,
      0,
      1,
   },

   [AGX_OPCODE_WHILE_FCMP] = {
      "while_fcmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_FCOND | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_TARGET,
      { 0x442, 6, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      1,
      0,
      1,
   },

   [AGX_OPCODE_BITOP] = {
      "bitop", 2, 1, AGX_IMMEDIATE_TRUTH_TABLE,
      { 0x7e, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_INTL] = {
      "intl", 2, 1, 0,
      { 0x3e, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_CONVERT] = {
      "convert", 2, 1, AGX_IMMEDIATE_ROUND,
      { 0x803e, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ITER] = {
      "iter", 2, 1, AGX_IMMEDIATE_CHANNELS | AGX_IMMEDIATE_INTERPOLATION,
      { 0x21, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ITERPROJ] = {
      "iterproj", 3, 1, AGX_IMMEDIATE_CHANNELS | AGX_IMMEDIATE_INTERPOLATION,
      { 0x21, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_LDCF] = {
      "ldcf", 1, 1, AGX_IMMEDIATE_CHANNELS,
      { 0xa1, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_ST_VARY] = {
      "st_vary", 2, 0, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_NO_VARYINGS] = {
      "no_varyings", 0, 0, 0,
      { 0x80000051, 4, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_STOP] = {
      "stop", 0, 0, 0,
      { 0x88, 2, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_TRAP] = {
      "trap", 0, 0, 0,
      { 0x8, 2, 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_WAIT_PIX] = {
      "wait_pix", 0, 0, AGX_IMMEDIATE_WRITEOUT,
      { 0x48, 4, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_SIGNAL_PIX] = {
      "signal_pix", 0, 0, AGX_IMMEDIATE_WRITEOUT,
      { 0x58, 4, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_IMAGE_WRITE] = {
      "image_write", 5, 0, AGX_IMMEDIATE_DIM | AGX_IMMEDIATE_COHERENT,
      { 0x8000f1, 6, 1 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_BLOCK_IMAGE_STORE] = {
      "block_image_store", 4, 0, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_DIM | AGX_IMMEDIATE_EXPLICIT_COORDS,
      { 0xb1, 10, 0 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_THREADGROUP_BARRIER] = {
      "threadgroup_barrier", 0, 0, 0,
      { 0x68, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_MEMORY_BARRIER] = {
      "memory_barrier", 0, 0, 0,
      { 0x96f5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_IMAGE_BARRIER_1] = {
      "image_barrier_1", 0, 0, 0,
      { 0xaaf5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_IMAGE_BARRIER_2] = {
      "image_barrier_2", 0, 0, 0,
      { 0xaef5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_IMAGE_BARRIER_3] = {
      "image_barrier_3", 0, 0, 0,
      { 0xa9f5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_IMAGE_BARRIER_4] = {
      "image_barrier_4", 0, 0, 0,
      { 0xadf5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_FLUSH_MEMORY_TO_TEXTURE] = {
      "flush_memory_to_texture", 0, 0, 0,
      { 0x40f5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_MEMORY_BARRIER_2] = {
      "memory_barrier_2", 0, 0, 0,
      { 0x9af5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_MEMORY_BARRIER_3] = {
      "memory_barrier_3", 0, 0, 0,
      { 0x99f5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_UNKNOWN_BARRIER_1] = {
      "unknown_barrier_1", 0, 0, 0,
      { 0x33f5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_UNKNOWN_BARRIER_2] = {
      "unknown_barrier_2", 0, 0, 0,
      { 0x3f5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_DEVICE_BARRIER_1] = {
      "device_barrier_1", 0, 0, 0,
      { 0x9df5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_DEVICE_BARRIER_2] = {
      "device_barrier_2", 0, 0, 0,
      { 0x9ef5, 2, 0 },
      AGX_SCHEDULE_CLASS_BARRIER,
      0,
      0,
      1,
   },

   [AGX_OPCODE_DOORBELL] = {
      "doorbell", 0, 0, AGX_IMMEDIATE_IMM,
      { 0x2800060020, 6, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      0,
   },

   [AGX_OPCODE_STACK_UNMAP] = {
      "stack_unmap", 0, 1, AGX_IMMEDIATE_IMM,
      { 0x75, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      0,
   },

   [AGX_OPCODE_STACK_MAP] = {
      "stack_map", 1, 0, AGX_IMMEDIATE_IMM,
      { 0x10075, 8, 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      0,
   },

   [AGX_OPCODE_STACK_ADJUST] = {
      "stack_adjust", 0, 0, AGX_IMMEDIATE_STACK_SIZE,
      { 0x10100b5, 8, 0 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      0,
   },

   [AGX_OPCODE_STACK_LOAD] = {
      "stack_load", 1, 1, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_SCOREBOARD,
      { 0x35, 6, 1 },
      AGX_SCHEDULE_CLASS_LOAD,
      0,
      1,
      0,
   },

   [AGX_OPCODE_STACK_STORE] = {
      "stack_store", 2, 0, AGX_IMMEDIATE_FORMAT | AGX_IMMEDIATE_MASK | AGX_IMMEDIATE_SCOREBOARD,
      { 0xb5, 6, 1 },
      AGX_SCHEDULE_CLASS_STORE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_MOV] = {
      "mov", 1, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_NOT] = {
      "not", 1, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SIGNEXT] = {
      "signext", 1, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_COLLECT] = {
      "collect", 0, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SPLIT] = {
      "split", 1, 0, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_PHI] = {
      "phi", 0, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_PRELOAD,
      0,
      1,
      1,
   },

   [AGX_OPCODE_SWAP] = {
      "swap", 2, 0, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      1,
      1,
   },

   [AGX_OPCODE_UNIT_TEST] = {
      "unit_test", 1, 0, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_PRELOAD] = {
      "preload", 1, 1, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_PRELOAD,
      0,
      1,
      1,
   },

   [AGX_OPCODE_EXPORT] = {
      "export", 1, 0, AGX_IMMEDIATE_IMM,
      { 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_BEGIN_CF] = {
      "begin_cf", 0, 0, 0,
      { 0 },
      AGX_SCHEDULE_CLASS_NONE,
      0,
      0,
      1,
   },

   [AGX_OPCODE_BREAK] = {
      "break", 0, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_TARGET,
      { 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_BREAK_IF_ICMP] = {
      "break_if_icmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_ICOND | AGX_IMMEDIATE_TARGET,
      { 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },

   [AGX_OPCODE_BREAK_IF_FCMP] = {
      "break_if_fcmp", 2, 0, AGX_IMMEDIATE_NEST | AGX_IMMEDIATE_INVERT_COND | AGX_IMMEDIATE_FCOND | AGX_IMMEDIATE_TARGET,
      { 0 },
      AGX_SCHEDULE_CLASS_INVALID,
      0,
      0,
      1,
   },
};

