/* Bezier.c generated by valac 0.56.18, the Vala compiler
 * generated from Bezier.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BEZIER (bezier_get_type ())
#define BEZIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BEZIER, Bezier))
#define BEZIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BEZIER, BezierClass))
#define IS_BEZIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BEZIER))
#define IS_BEZIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BEZIER))
#define BEZIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BEZIER, BezierClass))

typedef struct _Bezier Bezier;
typedef struct _BezierClass BezierClass;
typedef struct _BezierPrivate BezierPrivate;

#define BEZIER_TYPE_POINT (bezier_point_get_type ())
#define BEZIER_POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BEZIER_TYPE_POINT, BezierPoint))
#define BEZIER_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BEZIER_TYPE_POINT, BezierPointClass))
#define BEZIER_IS_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BEZIER_TYPE_POINT))
#define BEZIER_IS_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BEZIER_TYPE_POINT))
#define BEZIER_POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BEZIER_TYPE_POINT, BezierPointClass))

typedef struct _BezierPoint BezierPoint;
typedef struct _BezierPointClass BezierPointClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _bezier_point_unref0(var) ((var == NULL) ? NULL : (var = (bezier_point_unref (var), NULL)))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _BezierPointPrivate BezierPointPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BezierParamSpecPoint BezierParamSpecPoint;
typedef struct _ParamSpecBezier ParamSpecBezier;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Bezier {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BezierPrivate * priv;
};

struct _BezierClass {
	GTypeClass parent_class;
	void (*finalize) (Bezier *self);
};

struct _BezierPrivate {
	GArray* _points;
	GArray* _apoints;
	BezierPoint* _from;
	BezierPoint* _to;
};

struct _BezierPoint {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BezierPointPrivate * priv;
};

struct _BezierPointClass {
	GTypeClass parent_class;
	void (*finalize) (BezierPoint *self);
};

struct _BezierPointPrivate {
	DrawArea* _da;
	gdouble _x;
	gdouble _y;
};

struct _BezierParamSpecPoint {
	GParamSpec parent_instance;
};

struct _ParamSpecBezier {
	GParamSpec parent_instance;
};

static gint Bezier_private_offset;
static gpointer bezier_parent_class = NULL;
static gint BezierPoint_private_offset;
static gpointer bezier_point_parent_class = NULL;

VALA_EXTERN gpointer bezier_ref (gpointer instance);
VALA_EXTERN void bezier_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_bezier (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_bezier (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_bezier (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_bezier (const GValue* value);
VALA_EXTERN GType bezier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bezier, bezier_unref)
static gpointer bezier_point_ref (gpointer instance);
static void bezier_point_unref (gpointer instance);
static GParamSpec* bezier_param_spec_point (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags) G_GNUC_UNUSED ;
static void bezier_value_set_point (GValue* value,
                             gpointer v_object) G_GNUC_UNUSED ;
static void bezier_value_take_point (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED ;
static gpointer bezier_value_get_point (const GValue* value) G_GNUC_UNUSED ;
static GType bezier_point_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BezierPoint, bezier_point_unref)
static void _bezier_point_unref0_ (gpointer var);
static void _vala_BezierPoint_free_function_content_of (gpointer data);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN Bezier* bezier_new (DrawArea* da);
VALA_EXTERN Bezier* bezier_construct (GType object_type,
                          DrawArea* da);
static BezierPoint* bezier_point_new (DrawArea* da);
static BezierPoint* bezier_point_construct (GType object_type,
                                     DrawArea* da);
VALA_EXTERN Bezier* bezier_new_with_endpoints (DrawArea* da,
                                   gdouble x0,
                                   gdouble y0,
                                   gdouble x1,
                                   gdouble y1);
VALA_EXTERN Bezier* bezier_construct_with_endpoints (GType object_type,
                                         DrawArea* da,
                                         gdouble x0,
                                         gdouble y0,
                                         gdouble x1,
                                         gdouble y1);
static void bezier_point_set_coordinate (BezierPoint* self,
                                  gdouble a,
                                  gdouble b);
VALA_EXTERN void bezier_copy (Bezier* self,
                  Bezier* b);
static gdouble bezier_point_get_x (BezierPoint* self);
static gdouble bezier_point_get_y (BezierPoint* self);
VALA_EXTERN void bezier_get_point (Bezier* self,
                       gint pindex,
                       gdouble* x,
                       gdouble* y);
VALA_EXTERN void bezier_get_from_point (Bezier* self,
                            gdouble* x,
                            gdouble* y);
VALA_EXTERN void bezier_get_to_point (Bezier* self,
                          gdouble* x,
                          gdouble* y);
VALA_EXTERN void bezier_get_drag_point (Bezier* self,
                            gdouble* x,
                            gdouble* y);
VALA_EXTERN void bezier_set_point (Bezier* self,
                       gint pindex,
                       gdouble x,
                       gdouble y);
VALA_EXTERN void bezier_update_control_from_drag_handle (Bezier* self,
                                             gdouble x,
                                             gdouble y);
static gboolean bezier_is_t_within_range (Bezier* self,
                                   gdouble t);
static void bezier_align_point (Bezier* self,
                         gint pindex,
                         gdouble a,
                         gdouble tx,
                         gdouble ty);
static void bezier_align (Bezier* self,
                   gdouble lx0,
                   gdouble ly0,
                   gdouble lx1,
                   gdouble ly1);
static void bezier_get_roots (Bezier* self,
                       gdouble axis,
                       gboolean axis_is_x,
                       GArray** roots);
static gdouble* _double_dup (gdouble* self);
static gdouble bezier_get_axis (Bezier* self,
                         gdouble t,
                         gboolean axis_is_x);
VALA_EXTERN gboolean bezier_within_range (Bezier* self,
                              gdouble x,
                              gdouble y);
static void _g_free0_ (gpointer var);
static void _vala_gdouble_free_function_content_of (gpointer data);
VALA_EXTERN gdouble* bezier_get_intersecting_point (Bezier* self,
                                        gdouble axis,
                                        gboolean axis_is_x,
                                        gboolean from);
VALA_EXTERN void bezier_set_connect_point (Bezier* self,
                               gboolean from,
                               gdouble top,
                               gdouble bottom,
                               gdouble left,
                               gdouble right);
static BezierPoint* bezier_point_new_with_coordinate (DrawArea* da,
                                               gdouble a,
                                               gdouble b);
static BezierPoint* bezier_point_construct_with_coordinate (GType object_type,
                                                     DrawArea* da,
                                                     gdouble a,
                                                     gdouble b);
static void bezier_point_set_x (BezierPoint* self,
                         gdouble value);
static void bezier_point_set_y (BezierPoint* self,
                         gdouble value);
VALA_EXTERN gdouble draw_area_get_origin_x (DrawArea* self);
VALA_EXTERN gdouble draw_area_get_origin_y (DrawArea* self);
static void bezier_point_finalize (BezierPoint * obj);
static GType bezier_point_get_type_once (void);
static void bezier_finalize (Bezier * obj);
static GType bezier_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
bezier_get_instance_private (Bezier* self)
{
	return G_STRUCT_MEMBER_P (self, Bezier_private_offset);
}

static void
_bezier_point_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (bezier_point_unref (var), NULL));
}

static void
_vala_BezierPoint_free_function_content_of (gpointer data)
{
	BezierPoint* self;
	self = *((BezierPoint**) data);
	_bezier_point_unref0_ (self);
}

Bezier*
bezier_construct (GType object_type,
                  DrawArea* da)
{
	Bezier* self = NULL;
	BezierPoint* _tmp0_;
	BezierPoint* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (Bezier*) g_type_create_instance (object_type);
	_tmp0_ = bezier_point_new (da);
	_bezier_point_unref0 (self->priv->_from);
	self->priv->_from = _tmp0_;
	_tmp1_ = bezier_point_new (da);
	_bezier_point_unref0 (self->priv->_to);
	self->priv->_to = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				BezierPoint* _tmp5_;
				GArray* _tmp6_;
				BezierPoint* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				_tmp4_ = self->priv->_points;
				_tmp5_ = bezier_point_new (da);
				g_array_append_val (_tmp4_, _tmp5_);
				_tmp6_ = self->priv->_apoints;
				_tmp7_ = bezier_point_new (da);
				g_array_append_val (_tmp6_, _tmp7_);
			}
		}
	}
	return self;
}

Bezier*
bezier_new (DrawArea* da)
{
	return bezier_construct (TYPE_BEZIER, da);
}

Bezier*
bezier_construct_with_endpoints (GType object_type,
                                 DrawArea* da,
                                 gdouble x0,
                                 gdouble y0,
                                 gdouble x1,
                                 gdouble y1)
{
	Bezier* self = NULL;
	BezierPoint* _tmp0_;
	BezierPoint* _tmp1_;
	GArray* _tmp8_;
	BezierPoint* _tmp9_;
	GArray* _tmp10_;
	BezierPoint* _tmp11_;
	GArray* _tmp12_;
	BezierPoint* _tmp13_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (Bezier*) g_type_create_instance (object_type);
	_tmp0_ = bezier_point_new (da);
	_bezier_point_unref0 (self->priv->_from);
	self->priv->_from = _tmp0_;
	_tmp1_ = bezier_point_new (da);
	_bezier_point_unref0 (self->priv->_to);
	self->priv->_to = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				BezierPoint* _tmp5_;
				GArray* _tmp6_;
				BezierPoint* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				_tmp4_ = self->priv->_points;
				_tmp5_ = bezier_point_new (da);
				g_array_append_val (_tmp4_, _tmp5_);
				_tmp6_ = self->priv->_apoints;
				_tmp7_ = bezier_point_new (da);
				g_array_append_val (_tmp6_, _tmp7_);
			}
		}
	}
	_tmp8_ = self->priv->_points;
	_tmp9_ = g_array_index (_tmp8_, BezierPoint*, (guint) 0);
	bezier_point_set_coordinate (_tmp9_, x0, y0);
	_tmp10_ = self->priv->_points;
	_tmp11_ = g_array_index (_tmp10_, BezierPoint*, (guint) 1);
	bezier_point_set_coordinate (_tmp11_, (x0 + x1) * 0.5, (y0 + y1) * 0.5);
	_tmp12_ = self->priv->_points;
	_tmp13_ = g_array_index (_tmp12_, BezierPoint*, (guint) 2);
	bezier_point_set_coordinate (_tmp13_, x1, y1);
	return self;
}

Bezier*
bezier_new_with_endpoints (DrawArea* da,
                           gdouble x0,
                           gdouble y0,
                           gdouble x1,
                           gdouble y1)
{
	return bezier_construct_with_endpoints (TYPE_BEZIER, da, x0, y0, x1, y1);
}

void
bezier_copy (Bezier* self,
             Bezier* b)
{
	BezierPoint* _tmp22_;
	BezierPoint* _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	BezierPoint* _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	BezierPoint* _tmp29_;
	BezierPoint* _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	BezierPoint* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				BezierPoint* _tmp3_;
				GArray* _tmp4_;
				BezierPoint* _tmp5_;
				gdouble _tmp6_;
				gdouble _tmp7_;
				GArray* _tmp8_;
				BezierPoint* _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
				GArray* _tmp12_;
				BezierPoint* _tmp13_;
				GArray* _tmp14_;
				BezierPoint* _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp17_;
				GArray* _tmp18_;
				BezierPoint* _tmp19_;
				gdouble _tmp20_;
				gdouble _tmp21_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				_tmp2_ = self->priv->_points;
				_tmp3_ = g_array_index (_tmp2_, BezierPoint*, (guint) i);
				_tmp4_ = b->priv->_points;
				_tmp5_ = g_array_index (_tmp4_, BezierPoint*, (guint) i);
				_tmp6_ = bezier_point_get_x (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = b->priv->_points;
				_tmp9_ = g_array_index (_tmp8_, BezierPoint*, (guint) i);
				_tmp10_ = bezier_point_get_y (_tmp9_);
				_tmp11_ = _tmp10_;
				bezier_point_set_coordinate (_tmp3_, _tmp7_, _tmp11_);
				_tmp12_ = self->priv->_apoints;
				_tmp13_ = g_array_index (_tmp12_, BezierPoint*, (guint) i);
				_tmp14_ = b->priv->_apoints;
				_tmp15_ = g_array_index (_tmp14_, BezierPoint*, (guint) i);
				_tmp16_ = bezier_point_get_x (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = b->priv->_apoints;
				_tmp19_ = g_array_index (_tmp18_, BezierPoint*, (guint) i);
				_tmp20_ = bezier_point_get_y (_tmp19_);
				_tmp21_ = _tmp20_;
				bezier_point_set_coordinate (_tmp13_, _tmp17_, _tmp21_);
			}
		}
	}
	_tmp22_ = self->priv->_from;
	_tmp23_ = b->priv->_from;
	_tmp24_ = bezier_point_get_x (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = b->priv->_from;
	_tmp27_ = bezier_point_get_y (_tmp26_);
	_tmp28_ = _tmp27_;
	bezier_point_set_coordinate (_tmp22_, _tmp25_, _tmp28_);
	_tmp29_ = self->priv->_to;
	_tmp30_ = b->priv->_to;
	_tmp31_ = bezier_point_get_x (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = b->priv->_to;
	_tmp34_ = bezier_point_get_y (_tmp33_);
	_tmp35_ = _tmp34_;
	bezier_point_set_coordinate (_tmp29_, _tmp32_, _tmp35_);
}

void
bezier_get_point (Bezier* self,
                  gint pindex,
                  gdouble* x,
                  gdouble* y)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	GArray* _tmp0_;
	BezierPoint* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GArray* _tmp4_;
	BezierPoint* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_points;
	_tmp1_ = g_array_index (_tmp0_, BezierPoint*, (guint) pindex);
	_tmp2_ = bezier_point_get_x (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_x = _tmp3_;
	_tmp4_ = self->priv->_points;
	_tmp5_ = g_array_index (_tmp4_, BezierPoint*, (guint) pindex);
	_tmp6_ = bezier_point_get_y (_tmp5_);
	_tmp7_ = _tmp6_;
	_vala_y = _tmp7_;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

void
bezier_get_from_point (Bezier* self,
                       gdouble* x,
                       gdouble* y)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	BezierPoint* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BezierPoint* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_from;
	_tmp1_ = bezier_point_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_x = _tmp2_;
	_tmp3_ = self->priv->_from;
	_tmp4_ = bezier_point_get_y (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_y = _tmp5_;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

void
bezier_get_to_point (Bezier* self,
                     gdouble* x,
                     gdouble* y)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	BezierPoint* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BezierPoint* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_to;
	_tmp1_ = bezier_point_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_x = _tmp2_;
	_tmp3_ = self->priv->_to;
	_tmp4_ = bezier_point_get_y (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_y = _tmp5_;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

void
bezier_get_drag_point (Bezier* self,
                       gdouble* x,
                       gdouble* y)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	GArray* _tmp0_;
	BezierPoint* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GArray* _tmp4_;
	BezierPoint* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	GArray* _tmp8_;
	BezierPoint* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GArray* _tmp12_;
	BezierPoint* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	GArray* _tmp16_;
	BezierPoint* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	GArray* _tmp20_;
	BezierPoint* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_points;
	_tmp1_ = g_array_index (_tmp0_, BezierPoint*, (guint) 1);
	_tmp2_ = bezier_point_get_x (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_points;
	_tmp5_ = g_array_index (_tmp4_, BezierPoint*, (guint) 0);
	_tmp6_ = bezier_point_get_x (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_points;
	_tmp9_ = g_array_index (_tmp8_, BezierPoint*, (guint) 2);
	_tmp10_ = bezier_point_get_x (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_x = ((_tmp3_ / 2) + (_tmp7_ / 4)) + (_tmp11_ / 4);
	_tmp12_ = self->priv->_points;
	_tmp13_ = g_array_index (_tmp12_, BezierPoint*, (guint) 1);
	_tmp14_ = bezier_point_get_y (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->_points;
	_tmp17_ = g_array_index (_tmp16_, BezierPoint*, (guint) 0);
	_tmp18_ = bezier_point_get_y (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->_points;
	_tmp21_ = g_array_index (_tmp20_, BezierPoint*, (guint) 2);
	_tmp22_ = bezier_point_get_y (_tmp21_);
	_tmp23_ = _tmp22_;
	_vala_y = ((_tmp15_ / 2) + (_tmp19_ / 4)) + (_tmp23_ / 4);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

void
bezier_set_point (Bezier* self,
                  gint pindex,
                  gdouble x,
                  gdouble y)
{
	GArray* _tmp0_;
	BezierPoint* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_points;
	_tmp1_ = g_array_index (_tmp0_, BezierPoint*, (guint) pindex);
	bezier_point_set_coordinate (_tmp1_, x, y);
}

void
bezier_update_control_from_drag_handle (Bezier* self,
                                        gdouble x,
                                        gdouble y)
{
	gdouble cx = 0.0;
	GArray* _tmp0_;
	BezierPoint* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GArray* _tmp4_;
	BezierPoint* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble cy = 0.0;
	GArray* _tmp8_;
	BezierPoint* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GArray* _tmp12_;
	BezierPoint* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_points;
	_tmp1_ = g_array_index (_tmp0_, BezierPoint*, (guint) 0);
	_tmp2_ = bezier_point_get_x (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_points;
	_tmp5_ = g_array_index (_tmp4_, BezierPoint*, (guint) 2);
	_tmp6_ = bezier_point_get_x (_tmp5_);
	_tmp7_ = _tmp6_;
	cx = x - (((_tmp3_ + _tmp7_) * 0.5) - x);
	_tmp8_ = self->priv->_points;
	_tmp9_ = g_array_index (_tmp8_, BezierPoint*, (guint) 0);
	_tmp10_ = bezier_point_get_y (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_points;
	_tmp13_ = g_array_index (_tmp12_, BezierPoint*, (guint) 2);
	_tmp14_ = bezier_point_get_y (_tmp13_);
	_tmp15_ = _tmp14_;
	cy = y - (((_tmp11_ + _tmp15_) * 0.5) - y);
	bezier_set_point (self, 1, cx, cy);
}

static gboolean
bezier_is_t_within_range (Bezier* self,
                          gdouble t)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (((gdouble) 0) <= t) {
		_tmp0_ = t <= ((gdouble) 1);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
bezier_align_point (Bezier* self,
                    gint pindex,
                    gdouble a,
                    gdouble tx,
                    gdouble ty)
{
	gdouble x = 0.0;
	GArray* _tmp0_;
	BezierPoint* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GArray* _tmp4_;
	BezierPoint* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble y = 0.0;
	GArray* _tmp8_;
	BezierPoint* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GArray* _tmp12_;
	BezierPoint* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	GArray* _tmp16_;
	BezierPoint* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_points;
	_tmp1_ = g_array_index (_tmp0_, BezierPoint*, (guint) pindex);
	_tmp2_ = bezier_point_get_x (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_points;
	_tmp5_ = g_array_index (_tmp4_, BezierPoint*, (guint) pindex);
	_tmp6_ = bezier_point_get_y (_tmp5_);
	_tmp7_ = _tmp6_;
	x = ((_tmp3_ - tx) * cos (a)) - ((_tmp7_ - ty) * sin (a));
	_tmp8_ = self->priv->_points;
	_tmp9_ = g_array_index (_tmp8_, BezierPoint*, (guint) pindex);
	_tmp10_ = bezier_point_get_x (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_points;
	_tmp13_ = g_array_index (_tmp12_, BezierPoint*, (guint) pindex);
	_tmp14_ = bezier_point_get_y (_tmp13_);
	_tmp15_ = _tmp14_;
	y = ((_tmp11_ - tx) * sin (a)) + ((_tmp15_ - ty) * cos (a));
	_tmp16_ = self->priv->_apoints;
	_tmp17_ = g_array_index (_tmp16_, BezierPoint*, (guint) pindex);
	bezier_point_set_coordinate (_tmp17_, x, y);
}

static void
bezier_align (Bezier* self,
              gdouble lx0,
              gdouble ly0,
              gdouble lx1,
              gdouble ly1)
{
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gdouble a = 0.0;
	g_return_if_fail (self != NULL);
	tx = lx0;
	ty = ly0;
	a = -atan2 (ly1 - ty, lx1 - tx);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				bezier_align_point (self, i, a, tx, ty);
			}
		}
	}
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

static void
bezier_get_roots (Bezier* self,
                  gdouble axis,
                  gboolean axis_is_x,
                  GArray** roots)
{
	gdouble _tmp0_ = 0.0;
	gdouble lx0 = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble ly0 = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble lx1 = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble ly1 = 0.0;
	gdouble a = 0.0;
	GArray* _tmp4_;
	BezierPoint* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble b = 0.0;
	GArray* _tmp8_;
	BezierPoint* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble c = 0.0;
	GArray* _tmp12_;
	BezierPoint* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble d = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*roots != NULL);
	if (axis_is_x) {
		_tmp0_ = axis;
	} else {
		_tmp0_ = (gdouble) 0;
	}
	lx0 = _tmp0_;
	if (axis_is_x) {
		_tmp1_ = (gdouble) 0;
	} else {
		_tmp1_ = axis;
	}
	ly0 = _tmp1_;
	if (axis_is_x) {
		_tmp2_ = axis;
	} else {
		_tmp2_ = (gdouble) 1000000;
	}
	lx1 = _tmp2_;
	if (axis_is_x) {
		_tmp3_ = (gdouble) 1000000;
	} else {
		_tmp3_ = axis;
	}
	ly1 = _tmp3_;
	bezier_align (self, lx0, ly0, lx1, ly1);
	_tmp4_ = self->priv->_apoints;
	_tmp5_ = g_array_index (_tmp4_, BezierPoint*, (guint) 0);
	_tmp6_ = bezier_point_get_y (_tmp5_);
	_tmp7_ = _tmp6_;
	a = _tmp7_;
	_tmp8_ = self->priv->_apoints;
	_tmp9_ = g_array_index (_tmp8_, BezierPoint*, (guint) 1);
	_tmp10_ = bezier_point_get_y (_tmp9_);
	_tmp11_ = _tmp10_;
	b = _tmp11_;
	_tmp12_ = self->priv->_apoints;
	_tmp13_ = g_array_index (_tmp12_, BezierPoint*, (guint) 2);
	_tmp14_ = bezier_point_get_y (_tmp13_);
	_tmp15_ = _tmp14_;
	c = _tmp15_;
	d = (a - (2 * b)) + c;
	if (d != ((gdouble) 0)) {
		gdouble m1 = 0.0;
		gdouble m2 = 0.0;
		gdouble v1 = 0.0;
		gdouble v2 = 0.0;
		m1 = -sqrt ((b * b) - (a * c));
		m2 = (-a) + b;
		v1 = (-(m1 + m2)) / d;
		v2 = (-((-m1) + m2)) / d;
		if (bezier_is_t_within_range (self, v1)) {
			gdouble* _tmp16_;
			_tmp16_ = __double_dup0 (&v1);
			g_array_append_val (*roots, _tmp16_);
		}
		if (bezier_is_t_within_range (self, v2)) {
			gdouble* _tmp17_;
			_tmp17_ = __double_dup0 (&v2);
			g_array_append_val (*roots, _tmp17_);
		}
	} else {
		if (b != c) {
			gdouble v = 0.0;
			v = ((2 * b) - c) / (2 * (b - c));
			if (bezier_is_t_within_range (self, v)) {
				gdouble* _tmp18_;
				_tmp18_ = __double_dup0 (&v);
				g_array_append_val (*roots, _tmp18_);
			}
		}
	}
}

static gdouble
bezier_get_axis (Bezier* self,
                 gdouble t,
                 gboolean axis_is_x)
{
	gdouble mt = 0.0;
	gdouble mt2 = 0.0;
	gdouble t2 = 0.0;
	gdouble a = 0.0;
	gdouble b = 0.0;
	gdouble c = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble axis = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	mt = 1 - t;
	mt2 = mt * mt;
	t2 = t * t;
	a = mt2;
	b = (mt * t) * 2;
	c = t2;
	if (axis_is_x) {
		GArray* _tmp1_;
		BezierPoint* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		_tmp1_ = self->priv->_points;
		_tmp2_ = g_array_index (_tmp1_, BezierPoint*, (guint) 0);
		_tmp3_ = bezier_point_get_y (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		GArray* _tmp5_;
		BezierPoint* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		_tmp5_ = self->priv->_points;
		_tmp6_ = g_array_index (_tmp5_, BezierPoint*, (guint) 0);
		_tmp7_ = bezier_point_get_x (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_;
	}
	if (axis_is_x) {
		GArray* _tmp10_;
		BezierPoint* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		_tmp10_ = self->priv->_points;
		_tmp11_ = g_array_index (_tmp10_, BezierPoint*, (guint) 1);
		_tmp12_ = bezier_point_get_y (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_;
	} else {
		GArray* _tmp14_;
		BezierPoint* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		_tmp14_ = self->priv->_points;
		_tmp15_ = g_array_index (_tmp14_, BezierPoint*, (guint) 1);
		_tmp16_ = bezier_point_get_x (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp9_ = _tmp17_;
	}
	if (axis_is_x) {
		GArray* _tmp19_;
		BezierPoint* _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		_tmp19_ = self->priv->_points;
		_tmp20_ = g_array_index (_tmp19_, BezierPoint*, (guint) 2);
		_tmp21_ = bezier_point_get_y (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_;
	} else {
		GArray* _tmp23_;
		BezierPoint* _tmp24_;
		gdouble _tmp25_;
		gdouble _tmp26_;
		_tmp23_ = self->priv->_points;
		_tmp24_ = g_array_index (_tmp23_, BezierPoint*, (guint) 2);
		_tmp25_ = bezier_point_get_x (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp18_ = _tmp26_;
	}
	axis = ((a * _tmp0_) + (b * _tmp9_)) + (c * _tmp18_);
	result = axis;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static void
_vala_gdouble_free_function_content_of (gpointer data)
{
	gdouble* self;
	self = *((gdouble**) data);
	_g_free0_ (self);
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gboolean
bezier_within_range (Bezier* self,
                     gdouble x,
                     gdouble y)
{
	GArray* roots = NULL;
	GArray* _tmp0_;
	gdouble tolerance = 0.0;
	GArray* _tmp1_;
	GArray* _tmp7_;
	GArray* _tmp8_;
	gint _tmp9_ = 0;
	gpointer* _tmp10_;
	gdouble** _tmp11_;
	gint _tmp11__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gdouble*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_gdouble_free_function_content_of);
	roots = _tmp0_;
	tolerance = (gdouble) 10;
	bezier_get_roots (self, x, TRUE, &roots);
	_tmp1_ = roots;
	if (_tmp1_->len > ((guint) 0)) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GArray* _tmp4_;
					gdouble curve_y = 0.0;
					GArray* _tmp5_;
					gboolean _tmp6_ = FALSE;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = roots;
					if (!(((guint) i) < _tmp4_->len)) {
						break;
					}
					_tmp5_ = roots;
					curve_y = bezier_get_axis (self, *g_array_index (_tmp5_, gdouble*, (guint) i), TRUE);
					if ((curve_y - tolerance) <= y) {
						_tmp6_ = y <= (curve_y + tolerance);
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						result = TRUE;
						_g_array_unref0 (roots);
						return result;
					}
				}
			}
		}
	}
	_tmp7_ = roots;
	_tmp8_ = roots;
	_tmp10_ = vala_g_array_remove_range (_tmp7_, (guint) 0, _tmp8_->len, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	bezier_get_roots (self, y, FALSE, &roots);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GArray* _tmp14_;
				gdouble curve_x = 0.0;
				GArray* _tmp15_;
				gboolean _tmp16_ = FALSE;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = roots;
				if (!(((guint) i) < _tmp14_->len)) {
					break;
				}
				_tmp15_ = roots;
				curve_x = bezier_get_axis (self, *g_array_index (_tmp15_, gdouble*, (guint) i), FALSE);
				if ((curve_x - tolerance) <= x) {
					_tmp16_ = x <= (curve_x + tolerance);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					result = TRUE;
					_g_array_unref0 (roots);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_array_unref0 (roots);
	return result;
}

gdouble*
bezier_get_intersecting_point (Bezier* self,
                               gdouble axis,
                               gboolean axis_is_x,
                               gboolean from)
{
	GArray* roots = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	gdouble* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gdouble*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_gdouble_free_function_content_of);
	roots = _tmp0_;
	bezier_get_roots (self, axis, axis_is_x, &roots);
	_tmp1_ = roots;
	switch (_tmp1_->len) {
		case 0:
		{
			result = NULL;
			_g_array_unref0 (roots);
			return result;
		}
		case 1:
		{
			GArray* _tmp2_;
			gdouble _tmp3_;
			gdouble* _tmp4_;
			_tmp2_ = roots;
			_tmp3_ = bezier_get_axis (self, *g_array_index (_tmp2_, gdouble*, (guint) 0), axis_is_x);
			_tmp4_ = __double_dup0 (&_tmp3_);
			result = _tmp4_;
			_g_array_unref0 (roots);
			return result;
		}
		default:
		{
			if (from) {
				gdouble max = 0.0;
				gdouble _tmp10_;
				gdouble* _tmp11_;
				max = (gdouble) 1000000;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							GArray* _tmp7_;
							GArray* _tmp8_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = i;
								i = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = roots;
							if (!(((guint) i) < _tmp7_->len)) {
								break;
							}
							_tmp8_ = roots;
							if ((*g_array_index (_tmp8_, gdouble*, (guint) i)) < max) {
								GArray* _tmp9_;
								_tmp9_ = roots;
								max = *g_array_index (_tmp9_, gdouble*, (guint) i);
							}
						}
					}
				}
				_tmp10_ = bezier_get_axis (self, max, axis_is_x);
				_tmp11_ = __double_dup0 (&_tmp10_);
				result = _tmp11_;
				_g_array_unref0 (roots);
				return result;
			} else {
				gdouble min = 0.0;
				gdouble _tmp17_;
				gdouble* _tmp18_;
				min = (gdouble) 0;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							GArray* _tmp14_;
							GArray* _tmp15_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = i;
								i = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = roots;
							if (!(((guint) i) < _tmp14_->len)) {
								break;
							}
							_tmp15_ = roots;
							if ((*g_array_index (_tmp15_, gdouble*, (guint) i)) > min) {
								GArray* _tmp16_;
								_tmp16_ = roots;
								min = *g_array_index (_tmp16_, gdouble*, (guint) i);
							}
						}
					}
				}
				_tmp17_ = bezier_get_axis (self, min, axis_is_x);
				_tmp18_ = __double_dup0 (&_tmp17_);
				result = _tmp18_;
				_g_array_unref0 (roots);
				return result;
			}
		}
	}
}

void
bezier_set_connect_point (Bezier* self,
                          gboolean from,
                          gdouble top,
                          gdouble bottom,
                          gdouble left,
                          gdouble right)
{
	gdouble* isect = NULL;
	gdouble* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gdouble* _tmp3_;
	gdouble* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gdouble* _tmp13_;
	gdouble* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gdouble* _tmp23_;
	gdouble* _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gdouble* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bezier_get_intersecting_point (self, top, FALSE, from);
	_g_free0 (isect);
	isect = _tmp0_;
	_tmp3_ = isect;
	if (_tmp3_ != NULL) {
		gdouble* _tmp4_;
		_tmp4_ = isect;
		_tmp2_ = left <= (*_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gdouble* _tmp5_;
		_tmp5_ = isect;
		_tmp1_ = (*_tmp5_) <= right;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (from) {
			BezierPoint* _tmp6_;
			gdouble* _tmp7_;
			_tmp6_ = self->priv->_from;
			_tmp7_ = isect;
			bezier_point_set_coordinate (_tmp6_, *_tmp7_, top);
		} else {
			BezierPoint* _tmp8_;
			gdouble* _tmp9_;
			_tmp8_ = self->priv->_to;
			_tmp9_ = isect;
			bezier_point_set_coordinate (_tmp8_, *_tmp9_, top);
		}
		_g_free0 (isect);
		return;
	}
	_tmp10_ = bezier_get_intersecting_point (self, bottom, FALSE, from);
	_g_free0 (isect);
	isect = _tmp10_;
	_tmp13_ = isect;
	if (_tmp13_ != NULL) {
		gdouble* _tmp14_;
		_tmp14_ = isect;
		_tmp12_ = left <= (*_tmp14_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gdouble* _tmp15_;
		_tmp15_ = isect;
		_tmp11_ = (*_tmp15_) <= right;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		if (from) {
			BezierPoint* _tmp16_;
			gdouble* _tmp17_;
			_tmp16_ = self->priv->_from;
			_tmp17_ = isect;
			bezier_point_set_coordinate (_tmp16_, *_tmp17_, bottom);
		} else {
			BezierPoint* _tmp18_;
			gdouble* _tmp19_;
			_tmp18_ = self->priv->_to;
			_tmp19_ = isect;
			bezier_point_set_coordinate (_tmp18_, *_tmp19_, bottom);
		}
		_g_free0 (isect);
		return;
	}
	_tmp20_ = bezier_get_intersecting_point (self, left, TRUE, from);
	_g_free0 (isect);
	isect = _tmp20_;
	_tmp23_ = isect;
	if (_tmp23_ != NULL) {
		gdouble* _tmp24_;
		_tmp24_ = isect;
		_tmp22_ = top <= (*_tmp24_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gdouble* _tmp25_;
		_tmp25_ = isect;
		_tmp21_ = (*_tmp25_) <= bottom;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		if (from) {
			BezierPoint* _tmp26_;
			gdouble* _tmp27_;
			_tmp26_ = self->priv->_from;
			_tmp27_ = isect;
			bezier_point_set_coordinate (_tmp26_, left, *_tmp27_);
		} else {
			BezierPoint* _tmp28_;
			gdouble* _tmp29_;
			_tmp28_ = self->priv->_to;
			_tmp29_ = isect;
			bezier_point_set_coordinate (_tmp28_, left, *_tmp29_);
		}
		_g_free0 (isect);
		return;
	}
	_tmp30_ = bezier_get_intersecting_point (self, right, TRUE, from);
	_g_free0 (isect);
	isect = _tmp30_;
	_tmp33_ = isect;
	if (_tmp33_ != NULL) {
		gdouble* _tmp34_;
		_tmp34_ = isect;
		_tmp32_ = top <= (*_tmp34_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gdouble* _tmp35_;
		_tmp35_ = isect;
		_tmp31_ = (*_tmp35_) <= bottom;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		if (from) {
			BezierPoint* _tmp36_;
			gdouble* _tmp37_;
			_tmp36_ = self->priv->_from;
			_tmp37_ = isect;
			bezier_point_set_coordinate (_tmp36_, right, *_tmp37_);
		} else {
			BezierPoint* _tmp38_;
			gdouble* _tmp39_;
			_tmp38_ = self->priv->_to;
			_tmp39_ = isect;
			bezier_point_set_coordinate (_tmp38_, right, *_tmp39_);
		}
		_g_free0 (isect);
		return;
	}
	if (from) {
		BezierPoint* _tmp40_;
		GArray* _tmp41_;
		BezierPoint* _tmp42_;
		gdouble _tmp43_;
		gdouble _tmp44_;
		GArray* _tmp45_;
		BezierPoint* _tmp46_;
		gdouble _tmp47_;
		gdouble _tmp48_;
		_tmp40_ = self->priv->_from;
		_tmp41_ = self->priv->_points;
		_tmp42_ = g_array_index (_tmp41_, BezierPoint*, (guint) 0);
		_tmp43_ = bezier_point_get_x (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = self->priv->_points;
		_tmp46_ = g_array_index (_tmp45_, BezierPoint*, (guint) 0);
		_tmp47_ = bezier_point_get_y (_tmp46_);
		_tmp48_ = _tmp47_;
		bezier_point_set_coordinate (_tmp40_, _tmp44_, _tmp48_);
	} else {
		BezierPoint* _tmp49_;
		GArray* _tmp50_;
		BezierPoint* _tmp51_;
		gdouble _tmp52_;
		gdouble _tmp53_;
		GArray* _tmp54_;
		BezierPoint* _tmp55_;
		gdouble _tmp56_;
		gdouble _tmp57_;
		_tmp49_ = self->priv->_to;
		_tmp50_ = self->priv->_points;
		_tmp51_ = g_array_index (_tmp50_, BezierPoint*, (guint) 2);
		_tmp52_ = bezier_point_get_x (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = self->priv->_points;
		_tmp55_ = g_array_index (_tmp54_, BezierPoint*, (guint) 2);
		_tmp56_ = bezier_point_get_y (_tmp55_);
		_tmp57_ = _tmp56_;
		bezier_point_set_coordinate (_tmp49_, _tmp53_, _tmp57_);
	}
	_g_free0 (isect);
}

static inline gpointer
bezier_point_get_instance_private (BezierPoint* self)
{
	return G_STRUCT_MEMBER_P (self, BezierPoint_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static BezierPoint*
bezier_point_construct (GType object_type,
                        DrawArea* da)
{
	BezierPoint* self = NULL;
	DrawArea* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (BezierPoint*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	return self;
}

static BezierPoint*
bezier_point_new (DrawArea* da)
{
	return bezier_point_construct (BEZIER_TYPE_POINT, da);
}

static BezierPoint*
bezier_point_construct_with_coordinate (GType object_type,
                                        DrawArea* da,
                                        gdouble a,
                                        gdouble b)
{
	BezierPoint* self = NULL;
	DrawArea* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (BezierPoint*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	bezier_point_set_x (self, a);
	bezier_point_set_y (self, b);
	return self;
}

static BezierPoint*
bezier_point_new_with_coordinate (DrawArea* da,
                                  gdouble a,
                                  gdouble b)
{
	return bezier_point_construct_with_coordinate (BEZIER_TYPE_POINT, da, a, b);
}

static void
bezier_point_set_coordinate (BezierPoint* self,
                             gdouble a,
                             gdouble b)
{
	g_return_if_fail (self != NULL);
	bezier_point_set_x (self, a);
	bezier_point_set_y (self, b);
}

static gdouble
bezier_point_get_x (BezierPoint* self)
{
	gdouble result;
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_x (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->_x + _tmp2_;
	return result;
}

static void
bezier_point_set_x (BezierPoint* self,
                    gdouble value)
{
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_x (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_x = value - _tmp2_;
}

static gdouble
bezier_point_get_y (BezierPoint* self)
{
	gdouble result;
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_y (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->_y + _tmp2_;
	return result;
}

static void
bezier_point_set_y (BezierPoint* self,
                    gdouble value)
{
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_y (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_y = value - _tmp2_;
}

static void
bezier_value_point_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bezier_value_point_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bezier_point_unref (value->data[0].v_pointer);
	}
}

static void
bezier_value_point_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bezier_point_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bezier_value_point_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bezier_value_point_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BezierPoint * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bezier_point_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bezier_value_point_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	BezierPoint ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bezier_point_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
bezier_param_spec_point (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	BezierParamSpecPoint* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BEZIER_TYPE_POINT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
bezier_value_get_point (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BEZIER_TYPE_POINT), NULL);
	return value->data[0].v_pointer;
}

static void
bezier_value_set_point (GValue* value,
                        gpointer v_object)
{
	BezierPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BEZIER_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BEZIER_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bezier_point_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bezier_point_unref (old);
	}
}

static void
bezier_value_take_point (GValue* value,
                         gpointer v_object)
{
	BezierPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BEZIER_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BEZIER_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bezier_point_unref (old);
	}
}

static void
bezier_point_class_init (BezierPointClass * klass,
                         gpointer klass_data)
{
	bezier_point_parent_class = g_type_class_peek_parent (klass);
	((BezierPointClass *) klass)->finalize = bezier_point_finalize;
	g_type_class_adjust_private_offset (klass, &BezierPoint_private_offset);
}

static void
bezier_point_instance_init (BezierPoint * self,
                            gpointer klass)
{
	self->priv = bezier_point_get_instance_private (self);
	self->priv->_x = (gdouble) 0;
	self->priv->_y = (gdouble) 0;
	self->ref_count = 1;
}

static void
bezier_point_finalize (BezierPoint * obj)
{
	BezierPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BEZIER_TYPE_POINT, BezierPoint);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_da);
}

static GType
bezier_point_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bezier_value_point_init, bezier_value_point_free_value, bezier_value_point_copy_value, bezier_value_point_peek_pointer, "p", bezier_value_point_collect_value, "p", bezier_value_point_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BezierPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bezier_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BezierPoint), 0, (GInstanceInitFunc) bezier_point_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bezier_point_type_id;
	bezier_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BezierPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BezierPoint_private_offset = g_type_add_instance_private (bezier_point_type_id, sizeof (BezierPointPrivate));
	return bezier_point_type_id;
}

static GType
bezier_point_get_type (void)
{
	static volatile gsize bezier_point_type_id__once = 0;
	if (g_once_init_enter (&bezier_point_type_id__once)) {
		GType bezier_point_type_id;
		bezier_point_type_id = bezier_point_get_type_once ();
		g_once_init_leave (&bezier_point_type_id__once, bezier_point_type_id);
	}
	return bezier_point_type_id__once;
}

static gpointer
bezier_point_ref (gpointer instance)
{
	BezierPoint * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
bezier_point_unref (gpointer instance)
{
	BezierPoint * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BEZIER_POINT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_bezier_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_bezier_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bezier_unref (value->data[0].v_pointer);
	}
}

static void
value_bezier_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bezier_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_bezier_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_bezier_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Bezier * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bezier_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_bezier_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Bezier ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bezier_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_bezier (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecBezier* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BEZIER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_bezier (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BEZIER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_bezier (GValue* value,
                  gpointer v_object)
{
	Bezier * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BEZIER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BEZIER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bezier_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bezier_unref (old);
	}
}

void
value_take_bezier (GValue* value,
                   gpointer v_object)
{
	Bezier * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BEZIER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BEZIER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bezier_unref (old);
	}
}

static void
bezier_class_init (BezierClass * klass,
                   gpointer klass_data)
{
	bezier_parent_class = g_type_class_peek_parent (klass);
	((BezierClass *) klass)->finalize = bezier_finalize;
	g_type_class_adjust_private_offset (klass, &Bezier_private_offset);
}

static void
bezier_instance_init (Bezier * self,
                      gpointer klass)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	self->priv = bezier_get_instance_private (self);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (BezierPoint*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_BezierPoint_free_function_content_of);
	self->priv->_points = _tmp0_;
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (BezierPoint*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_BezierPoint_free_function_content_of);
	self->priv->_apoints = _tmp1_;
	self->ref_count = 1;
}

static void
bezier_finalize (Bezier * obj)
{
	Bezier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BEZIER, Bezier);
	g_signal_handlers_destroy (self);
	_g_array_unref0 (self->priv->_points);
	_g_array_unref0 (self->priv->_apoints);
	_bezier_point_unref0 (self->priv->_from);
	_bezier_point_unref0 (self->priv->_to);
}

static GType
bezier_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_bezier_init, value_bezier_free_value, value_bezier_copy_value, value_bezier_peek_pointer, "p", value_bezier_collect_value, "p", value_bezier_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BezierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bezier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bezier), 0, (GInstanceInitFunc) bezier_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bezier_type_id;
	bezier_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Bezier", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Bezier_private_offset = g_type_add_instance_private (bezier_type_id, sizeof (BezierPrivate));
	return bezier_type_id;
}

GType
bezier_get_type (void)
{
	static volatile gsize bezier_type_id__once = 0;
	if (g_once_init_enter (&bezier_type_id__once)) {
		GType bezier_type_id;
		bezier_type_id = bezier_get_type_once ();
		g_once_init_leave (&bezier_type_id__once, bezier_type_id);
	}
	return bezier_type_id__once;
}

gpointer
bezier_ref (gpointer instance)
{
	Bezier * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bezier_unref (gpointer instance)
{
	Bezier * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BEZIER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

