/* UndoTextDelete.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoTextDelete.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
typedef struct _UndoItemPrivate UndoItemPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_TEXT_ITEM (undo_text_item_get_type ())
#define UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItem))
#define UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))
#define IS_UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_ITEM))
#define IS_UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_ITEM))
#define UNDO_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))

typedef struct _UndoTextItem UndoTextItem;
typedef struct _UndoTextItemClass UndoTextItemClass;
typedef struct _UndoTextItemPrivate UndoTextItemPrivate;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_TEXT_DELETE (undo_text_delete_get_type ())
#define UNDO_TEXT_DELETE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_DELETE, UndoTextDelete))
#define UNDO_TEXT_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_DELETE, UndoTextDeleteClass))
#define IS_UNDO_TEXT_DELETE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_DELETE))
#define IS_UNDO_TEXT_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_DELETE))
#define UNDO_TEXT_DELETE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_DELETE, UndoTextDeleteClass))

typedef struct _UndoTextDelete UndoTextDelete;
typedef struct _UndoTextDeleteClass UndoTextDeleteClass;
typedef struct _UndoTextDeletePrivate UndoTextDeletePrivate;

#define TYPE_UNDO_TAG_INFO (undo_tag_info_get_type ())
#define UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfo))
#define UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))
#define IS_UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TAG_INFO))
#define IS_UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TAG_INFO))
#define UNDO_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))

typedef struct _UndoTagInfo UndoTagInfo;
typedef struct _UndoTagInfoClass UndoTagInfoClass;
enum  {
	UNDO_TEXT_DELETE_0_PROPERTY,
	UNDO_TEXT_DELETE_TEXT_PROPERTY,
	UNDO_TEXT_DELETE_START_PROPERTY,
	UNDO_TEXT_DELETE_TAGS_PROPERTY,
	UNDO_TEXT_DELETE_NUM_PROPERTIES
};
static GParamSpec* undo_text_delete_properties[UNDO_TEXT_DELETE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef enum  {
	UNDO_TEXT_OP_INSERT = 0,
	UNDO_TEXT_OP_DELETE,
	UNDO_TEXT_OP_REPLACE,
	UNDO_TEXT_OP_TAGADD,
	UNDO_TEXT_OP_TAGDEL,
	UNDO_TEXT_OP_TAGCLEAR
} UndoTextOp;

#define TYPE_UNDO_TEXT_OP (undo_text_op_get_type ())

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _UndoItem {
	GObject parent_instance;
	UndoItemPrivate * priv;
};

struct _UndoItemClass {
	GObjectClass parent_class;
	void (*undo) (UndoItem* self, DrawArea* da);
	void (*redo) (UndoItem* self, DrawArea* da);
	gboolean (*matches) (UndoItem* self, UndoItem* item);
	void (*replace_with_item) (UndoItem* self, UndoItem* item);
	gchar* (*to_string) (UndoItem* self);
};

struct _UndoTextItem {
	UndoItem parent_instance;
	UndoTextItemPrivate * priv;
};

struct _UndoTextItemClass {
	UndoItemClass parent_class;
	gboolean (*merge) (UndoTextItem* self, CanvasText* ct, UndoTextItem* item);
	void (*undo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
	void (*redo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
};

struct _UndoTextDelete {
	UndoTextItem parent_instance;
	UndoTextDeletePrivate * priv;
};

struct _UndoTextDeleteClass {
	UndoTextItemClass parent_class;
};

struct _UndoTextDeletePrivate {
	gchar* _text;
	gint _start;
	GArray* _tags;
};

static gint UndoTextDelete_private_offset;
static gpointer undo_text_delete_parent_class = NULL;

VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextItem, g_object_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_text_delete_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextDelete, g_object_unref)
VALA_EXTERN gpointer undo_tag_info_ref (gpointer instance);
VALA_EXTERN void undo_tag_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo_tag_info (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_undo_tag_info (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_undo_tag_info (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_undo_tag_info (const GValue* value);
VALA_EXTERN GType undo_tag_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTagInfo, undo_tag_info_unref)
VALA_EXTERN void undo_text_item_undo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN void undo_text_item_redo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN gboolean undo_text_item_merge (UndoTextItem* self,
                               CanvasText* ct,
                               UndoTextItem* item);
VALA_EXTERN UndoTextDelete* undo_text_delete_new (const gchar* text,
                                      gint start,
                                      GArray* tags,
                                      gint start_cursor,
                                      gint end_cursor);
VALA_EXTERN UndoTextDelete* undo_text_delete_construct (GType object_type,
                                            const gchar* text,
                                            gint start,
                                            GArray* tags,
                                            gint start_cursor,
                                            gint end_cursor);
VALA_EXTERN GType undo_text_op_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UndoTextItem* undo_text_item_new (const gchar* name,
                                  UndoTextOp op,
                                  gint start_cursor,
                                  gint end_cursor);
VALA_EXTERN UndoTextItem* undo_text_item_construct (GType object_type,
                                        const gchar* name,
                                        UndoTextOp op,
                                        gint start_cursor,
                                        gint end_cursor);
static void undo_text_delete_set_text (UndoTextDelete* self,
                                const gchar* value);
static void undo_text_delete_set_start (UndoTextDelete* self,
                                 gint value);
static void undo_text_delete_set_tags (UndoTextDelete* self,
                                GArray* value);
static void undo_text_delete_real_undo_text (UndoTextItem* base,
                                      DrawArea* da,
                                      CanvasText* ct);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN void formatted_text_insert_text (FormattedText* self,
                                 gint index,
                                 const gchar* str);
VALA_EXTERN gint undo_text_delete_get_start (UndoTextDelete* self);
VALA_EXTERN const gchar* undo_text_delete_get_text (UndoTextDelete* self);
VALA_EXTERN void formatted_text_apply_tags (FormattedText* self,
                                GArray* tags,
                                gint start);
VALA_EXTERN GArray* undo_text_delete_get_tags (UndoTextDelete* self);
VALA_EXTERN void canvas_text_set_cursor_only (CanvasText* self,
                                  gint cursor);
VALA_EXTERN gint undo_text_item_get_start_cursor (UndoTextItem* self);
static void undo_text_delete_real_redo_text (UndoTextItem* base,
                                      DrawArea* da,
                                      CanvasText* ct);
VALA_EXTERN void formatted_text_remove_text (FormattedText* self,
                                 gint index,
                                 gint chars);
VALA_EXTERN gint undo_text_item_get_end_cursor (UndoTextItem* self);
static gboolean undo_text_delete_real_merge (UndoTextItem* base,
                                      CanvasText* ct,
                                      UndoTextItem* item);
VALA_EXTERN UndoTextOp undo_text_item_get_op (UndoTextItem* self);
VALA_EXTERN void undo_text_item_set_end_cursor (UndoTextItem* self,
                                    gint value);
static void undo_text_delete_finalize (GObject * obj);
static GType undo_text_delete_get_type_once (void);
static void _vala_undo_text_delete_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_undo_text_delete_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
undo_text_delete_get_instance_private (UndoTextDelete* self)
{
	return G_STRUCT_MEMBER_P (self, UndoTextDelete_private_offset);
}

UndoTextDelete*
undo_text_delete_construct (GType object_type,
                            const gchar* text,
                            gint start,
                            GArray* tags,
                            gint start_cursor,
                            gint end_cursor)
{
	UndoTextDelete * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (tags != NULL, NULL);
	self = (UndoTextDelete*) undo_text_item_construct (object_type, _ ("text deletion"), UNDO_TEXT_OP_DELETE, start_cursor, end_cursor);
	undo_text_delete_set_text (self, text);
	undo_text_delete_set_start (self, start);
	undo_text_delete_set_tags (self, tags);
	return self;
}

UndoTextDelete*
undo_text_delete_new (const gchar* text,
                      gint start,
                      GArray* tags,
                      gint start_cursor,
                      gint end_cursor)
{
	return undo_text_delete_construct (TYPE_UNDO_TEXT_DELETE, text, start, tags, start_cursor, end_cursor);
}

static void
undo_text_delete_real_undo_text (UndoTextItem* base,
                                 DrawArea* da,
                                 CanvasText* ct)
{
	UndoTextDelete * self;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	FormattedText* _tmp4_;
	FormattedText* _tmp5_;
	GArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	self = (UndoTextDelete*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_start;
	_tmp3_ = self->priv->_text;
	formatted_text_insert_text (_tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = canvas_text_get_text (ct);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_tags;
	_tmp7_ = self->priv->_start;
	formatted_text_apply_tags (_tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = undo_text_item_get_start_cursor ((UndoTextItem*) self);
	_tmp9_ = _tmp8_;
	canvas_text_set_cursor_only (ct, _tmp9_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static void
undo_text_delete_real_redo_text (UndoTextItem* base,
                                 DrawArea* da,
                                 CanvasText* ct)
{
	UndoTextDelete * self;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	self = (UndoTextDelete*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_start;
	_tmp3_ = self->priv->_text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	formatted_text_remove_text (_tmp1_, _tmp2_, _tmp5_);
	_tmp6_ = undo_text_item_get_end_cursor ((UndoTextItem*) self);
	_tmp7_ = _tmp6_;
	canvas_text_set_cursor_only (ct, _tmp7_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
undo_text_delete_real_merge (UndoTextItem* base,
                             CanvasText* ct,
                             UndoTextItem* item)
{
	UndoTextDelete * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	self = (UndoTextDelete*) base;
	g_return_val_if_fail (ct != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = undo_text_item_get_end_cursor ((UndoTextItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = undo_text_item_get_start_cursor (item);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == _tmp4_) {
		UndoTextOp _tmp5_;
		UndoTextOp _tmp6_;
		_tmp5_ = undo_text_item_get_op (item);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == UNDO_TEXT_OP_DELETE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		UndoTextDelete* delete = NULL;
		UndoTextDelete* _tmp7_;
		UndoTextDelete* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		UndoTextDelete* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		UndoTextDelete* _tmp16_;
		gint _tmp17_;
		_tmp7_ = _g_object_ref0 (IS_UNDO_TEXT_DELETE (item) ? ((UndoTextDelete*) item) : NULL);
		delete = _tmp7_;
		_tmp8_ = delete;
		_tmp9_ = undo_text_item_get_end_cursor ((UndoTextItem*) _tmp8_);
		_tmp10_ = _tmp9_;
		undo_text_item_set_end_cursor ((UndoTextItem*) self, _tmp10_);
		_tmp11_ = delete;
		_tmp12_ = _tmp11_->priv->_text;
		_tmp13_ = self->priv->_text;
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		undo_text_delete_set_text (self, _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = delete;
		_tmp17_ = _tmp16_->priv->_start;
		undo_text_delete_set_start (self, _tmp17_);
		result = TRUE;
		_g_object_unref0 (delete);
		return result;
	}
	result = FALSE;
	return result;
}

const gchar*
undo_text_delete_get_text (UndoTextDelete* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
undo_text_delete_set_text (UndoTextDelete* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_delete_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_delete_properties[UNDO_TEXT_DELETE_TEXT_PROPERTY]);
	}
}

gint
undo_text_delete_get_start (UndoTextDelete* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start;
	return result;
}

static void
undo_text_delete_set_start (UndoTextDelete* self,
                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_delete_get_start (self);
	if (old_value != value) {
		self->priv->_start = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_delete_properties[UNDO_TEXT_DELETE_START_PROPERTY]);
	}
}

GArray*
undo_text_delete_get_tags (UndoTextDelete* self)
{
	GArray* result;
	GArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tags;
	result = _tmp0_;
	return result;
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static void
undo_text_delete_set_tags (UndoTextDelete* self,
                           GArray* value)
{
	GArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_delete_get_tags (self);
	if (old_value != value) {
		GArray* _tmp0_;
		_tmp0_ = _g_array_ref0 (value);
		_g_array_unref0 (self->priv->_tags);
		self->priv->_tags = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_delete_properties[UNDO_TEXT_DELETE_TAGS_PROPERTY]);
	}
}

static void
undo_text_delete_class_init (UndoTextDeleteClass * klass,
                             gpointer klass_data)
{
	undo_text_delete_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoTextDelete_private_offset);
	((UndoTextItemClass *) klass)->undo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_delete_real_undo_text;
	((UndoTextItemClass *) klass)->redo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_delete_real_redo_text;
	((UndoTextItemClass *) klass)->merge = (gboolean (*) (UndoTextItem*, CanvasText*, UndoTextItem*)) undo_text_delete_real_merge;
	G_OBJECT_CLASS (klass)->get_property = _vala_undo_text_delete_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_undo_text_delete_set_property;
	G_OBJECT_CLASS (klass)->finalize = undo_text_delete_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_DELETE_TEXT_PROPERTY, undo_text_delete_properties[UNDO_TEXT_DELETE_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_DELETE_START_PROPERTY, undo_text_delete_properties[UNDO_TEXT_DELETE_START_PROPERTY] = g_param_spec_int ("start", "start", "start", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_DELETE_TAGS_PROPERTY, undo_text_delete_properties[UNDO_TEXT_DELETE_TAGS_PROPERTY] = g_param_spec_boxed ("tags", "tags", "tags", G_TYPE_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
undo_text_delete_instance_init (UndoTextDelete * self,
                                gpointer klass)
{
	self->priv = undo_text_delete_get_instance_private (self);
}

static void
undo_text_delete_finalize (GObject * obj)
{
	UndoTextDelete * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_TEXT_DELETE, UndoTextDelete);
	_g_free0 (self->priv->_text);
	_g_array_unref0 (self->priv->_tags);
	G_OBJECT_CLASS (undo_text_delete_parent_class)->finalize (obj);
}

static GType
undo_text_delete_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoTextDeleteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_text_delete_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoTextDelete), 0, (GInstanceInitFunc) undo_text_delete_instance_init, NULL };
	GType undo_text_delete_type_id;
	undo_text_delete_type_id = g_type_register_static (TYPE_UNDO_TEXT_ITEM, "UndoTextDelete", &g_define_type_info, 0);
	UndoTextDelete_private_offset = g_type_add_instance_private (undo_text_delete_type_id, sizeof (UndoTextDeletePrivate));
	return undo_text_delete_type_id;
}

GType
undo_text_delete_get_type (void)
{
	static volatile gsize undo_text_delete_type_id__once = 0;
	if (g_once_init_enter (&undo_text_delete_type_id__once)) {
		GType undo_text_delete_type_id;
		undo_text_delete_type_id = undo_text_delete_get_type_once ();
		g_once_init_leave (&undo_text_delete_type_id__once, undo_text_delete_type_id);
	}
	return undo_text_delete_type_id__once;
}

static void
_vala_undo_text_delete_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	UndoTextDelete * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_DELETE, UndoTextDelete);
	switch (property_id) {
		case UNDO_TEXT_DELETE_TEXT_PROPERTY:
		g_value_set_string (value, undo_text_delete_get_text (self));
		break;
		case UNDO_TEXT_DELETE_START_PROPERTY:
		g_value_set_int (value, undo_text_delete_get_start (self));
		break;
		case UNDO_TEXT_DELETE_TAGS_PROPERTY:
		g_value_set_boxed (value, undo_text_delete_get_tags (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_undo_text_delete_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	UndoTextDelete * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_DELETE, UndoTextDelete);
	switch (property_id) {
		case UNDO_TEXT_DELETE_TEXT_PROPERTY:
		undo_text_delete_set_text (self, g_value_get_string (value));
		break;
		case UNDO_TEXT_DELETE_START_PROPERTY:
		undo_text_delete_set_start (self, g_value_get_int (value));
		break;
		case UNDO_TEXT_DELETE_TAGS_PROPERTY:
		undo_text_delete_set_tags (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

