use glib::{Object, Properties, prelude::*, subclass::*};
use gtk4::{Accessible, Box, Buildable, CompositeTemplate, ConstraintTarget, Widget, subclass::prelude::*};
use once_cell::sync::Lazy;
use std::cell::RefCell;

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate, Properties)]
    #[properties(wrapper_type = super::AddErrorWidget)]
    #[template(file = "data/resources/ui_templates/add_dialog/error.blp")]
    pub struct AddErrorWidget {
        #[property(get, set)]
        pub error: RefCell<String>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for AddErrorWidget {
        const NAME: &'static str = "AddErrorWidget";
        type ParentType = Box;
        type Type = super::AddErrorWidget;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
            klass.bind_template_callbacks();
        }

        fn instance_init(obj: &InitializingObject<Self>) {
            obj.init_template();
        }
    }

    #[glib::derived_properties]
    impl ObjectImpl for AddErrorWidget {
        fn signals() -> &'static [Signal] {
            static SIGNALS: Lazy<Vec<Signal>> = Lazy::new(|| vec![Signal::builder("try-again").build()]);
            SIGNALS.as_ref()
        }
    }

    impl WidgetImpl for AddErrorWidget {}

    impl BoxImpl for AddErrorWidget {}

    #[gtk4::template_callbacks]
    impl AddErrorWidget {
        #[template_callback]
        fn on_try_again(&self) {
            self.obj().emit_by_name::<()>("try-again", &[])
        }
    }
}

glib::wrapper! {
    pub struct AddErrorWidget(ObjectSubclass<imp::AddErrorWidget>)
        @extends Widget, Box,
        @implements Accessible, Buildable, ConstraintTarget;
}

impl Default for AddErrorWidget {
    fn default() -> Self {
        Object::new::<Self>()
    }
}
