/* palette.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from palette.vala, do not modify */

/* palette.vala
 *
 * Copyright 2019-2025 Zander Brown
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <graphene-gobject.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>

#define PACKAGE_VERSION "3.0.0"
#define GETTEXT_PACKAGE "org.gnome.design.Palette"
#define LOCALE_DIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ZBROWN_TYPE_PALETTE_BUTTON (zbrown_palette_button_get_type ())
#define ZBROWN_PALETTE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZBROWN_TYPE_PALETTE_BUTTON, ZBrownPaletteButton))
#define ZBROWN_PALETTE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZBROWN_TYPE_PALETTE_BUTTON, ZBrownPaletteButtonClass))
#define ZBROWN_IS_PALETTE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZBROWN_TYPE_PALETTE_BUTTON))
#define ZBROWN_IS_PALETTE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZBROWN_TYPE_PALETTE_BUTTON))
#define ZBROWN_PALETTE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZBROWN_TYPE_PALETTE_BUTTON, ZBrownPaletteButtonClass))

typedef struct _ZBrownPaletteButton ZBrownPaletteButton;
typedef struct _ZBrownPaletteButtonClass ZBrownPaletteButtonClass;
typedef struct _ZBrownPaletteButtonPrivate ZBrownPaletteButtonPrivate;
enum  {
	ZBROWN_PALETTE_BUTTON_0_PROPERTY,
	ZBROWN_PALETTE_BUTTON_SECTION_NAME_PROPERTY,
	ZBROWN_PALETTE_BUTTON_SECTION_INDEX_PROPERTY,
	ZBROWN_PALETTE_BUTTON_HEX_PROPERTY,
	ZBROWN_PALETTE_BUTTON_LIGHT_PROPERTY,
	ZBROWN_PALETTE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZBROWN_TYPE_PALETTE (zbrown_palette_get_type ())
#define ZBROWN_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZBROWN_TYPE_PALETTE, ZBrownPalette))
#define ZBROWN_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZBROWN_TYPE_PALETTE, ZBrownPaletteClass))
#define ZBROWN_IS_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZBROWN_TYPE_PALETTE))
#define ZBROWN_IS_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZBROWN_TYPE_PALETTE))
#define ZBROWN_PALETTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZBROWN_TYPE_PALETTE, ZBrownPaletteClass))

typedef struct _ZBrownPalette ZBrownPalette;
typedef struct _ZBrownPaletteClass ZBrownPaletteClass;
typedef struct _ZBrownPalettePrivate ZBrownPalettePrivate;
enum  {
	ZBROWN_PALETTE_0_PROPERTY,
	ZBROWN_PALETTE_NUM_PROPERTIES
};
static GParamSpec* zbrown_palette_properties[ZBROWN_PALETTE_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);

#define ZBROWN_TYPE_APPLICATION (zbrown_application_get_type ())
#define ZBROWN_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZBROWN_TYPE_APPLICATION, ZBrownApplication))
#define ZBROWN_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZBROWN_TYPE_APPLICATION, ZBrownApplicationClass))
#define ZBROWN_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZBROWN_TYPE_APPLICATION))
#define ZBROWN_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZBROWN_TYPE_APPLICATION))
#define ZBROWN_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZBROWN_TYPE_APPLICATION, ZBrownApplicationClass))

typedef struct _ZBrownApplication ZBrownApplication;
typedef struct _ZBrownApplicationClass ZBrownApplicationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZbrownPaletteGuidelinesData ZbrownPaletteGuidelinesData;
typedef struct _ZbrownPaletteExportData ZbrownPaletteExportData;
typedef struct _ZBrownApplicationPrivate ZBrownApplicationPrivate;
enum  {
	ZBROWN_APPLICATION_0_PROPERTY,
	ZBROWN_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* zbrown_application_properties[ZBROWN_APPLICATION_NUM_PROPERTIES];

struct _ZBrownPaletteButton {
	GtkButton parent_instance;
	ZBrownPaletteButtonPrivate * priv;
};

struct _ZBrownPaletteButtonClass {
	GtkButtonClass parent_class;
};

struct _ZBrownPaletteButtonPrivate {
	GtkStack* image_stack;
	guint timeout_id;
	gchar* _section_name;
	gint _section_index;
	gchar* _hex;
};

struct _ZBrownPalette {
	AdwApplicationWindow parent_instance;
	ZBrownPalettePrivate * priv;
};

struct _ZBrownPaletteClass {
	AdwApplicationWindowClass parent_class;
};

struct _ZbrownPaletteGuidelinesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZBrownPalette* self;
	GtkUriLauncher* launcher;
	GtkUriLauncher* _tmp0_;
	GError* e;
	AdwAlertDialog* dlg;
	GError* _tmp1_;
	const gchar* _tmp2_;
	AdwAlertDialog* _tmp3_;
	AdwAlertDialog* _tmp4_;
	AdwAlertDialog* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _ZbrownPaletteExportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZBrownPalette* self;
	GtkFileDialog* dialog;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkFileDialog* _tmp3_;
	GFile* palette_file;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GtkFileDialog* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GError* e;
	AdwAlertDialog* dlg;
	GError* _tmp9_;
	const gchar* _tmp10_;
	AdwAlertDialog* _tmp11_;
	AdwAlertDialog* _tmp12_;
	AdwAlertDialog* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

struct _ZBrownApplication {
	AdwApplication parent_instance;
	ZBrownApplicationPrivate * priv;
};

struct _ZBrownApplicationClass {
	AdwApplicationClass parent_class;
};

static gint ZBrownPaletteButton_private_offset;
static gpointer zbrown_palette_button_parent_class = NULL;
static gpointer zbrown_palette_parent_class = NULL;
static gpointer zbrown_application_parent_class = NULL;

VALA_EXTERN GType zbrown_palette_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZBrownPaletteButton, g_object_unref)
static GdkContentProvider* zbrown_palette_button_get_content (ZBrownPaletteButton* self);
VALA_EXTERN const gchar* zbrown_palette_button_get_hex (ZBrownPaletteButton* self);
static gchar* zbrown_palette_button_build_tooltip (ZBrownPaletteButton* self,
                                            const gchar* section_name,
                                            gint section_index,
                                            const gchar* hex);
static void zbrown_palette_button_motion_enter (ZBrownPaletteButton* self);
static void _zbrown_palette_button_motion_enter_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                            gdouble x,
                                                                            gdouble y,
                                                                            gpointer self);
static void zbrown_palette_button_motion_leave (ZBrownPaletteButton* self);
static void _zbrown_palette_button_motion_leave_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                            gpointer self);
static GdkContentProvider* zbrown_palette_button_drag_prepare (ZBrownPaletteButton* self,
                                                        GtkDragSource* source,
                                                        gdouble x,
                                                        gdouble y);
static GdkContentProvider* _zbrown_palette_button_drag_prepare_gtk_drag_source_prepare (GtkDragSource* _sender,
                                                                                 gdouble x,
                                                                                 gdouble y,
                                                                                 gpointer self);
static void zbrown_palette_button_drag_begin (ZBrownPaletteButton* self,
                                       GtkDragSource* source,
                                       GdkDrag* drag);
static void _zbrown_palette_button_drag_begin_gtk_drag_source_drag_begin (GtkDragSource* _sender,
                                                                   GdkDrag* drag,
                                                                   gpointer self);
static void zbrown_palette_button_real_clicked (GtkButton* base);
static void __lambda4_ (ZBrownPaletteButton* self);
static void ___lambda4__gsource_once_func (gpointer self);
static void zbrown_palette_button_real_snapshot (GtkWidget* base,
                                          GtkSnapshot* snapshot);
VALA_EXTERN ZBrownPaletteButton* zbrown_palette_button_new (void);
VALA_EXTERN ZBrownPaletteButton* zbrown_palette_button_construct (GType object_type);
VALA_EXTERN const gchar* zbrown_palette_button_get_section_name (ZBrownPaletteButton* self);
VALA_EXTERN void zbrown_palette_button_set_section_name (ZBrownPaletteButton* self,
                                             const gchar* value);
VALA_EXTERN gint zbrown_palette_button_get_section_index (ZBrownPaletteButton* self);
VALA_EXTERN void zbrown_palette_button_set_section_index (ZBrownPaletteButton* self,
                                              gint value);
VALA_EXTERN void zbrown_palette_button_set_hex (ZBrownPaletteButton* self,
                                    const gchar* value);
VALA_EXTERN gboolean zbrown_palette_button_get_light (ZBrownPaletteButton* self);
VALA_EXTERN void zbrown_palette_button_set_light (ZBrownPaletteButton* self,
                                      gboolean value);
static void zbrown_palette_button_finalize (GObject * obj);
static GType zbrown_palette_button_get_type_once (void);
static void _vala_zbrown_palette_button_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_zbrown_palette_button_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
VALA_EXTERN GType zbrown_palette_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZBrownPalette, g_object_unref)
static void zbrown_palette_guidelines_action (ZBrownPalette* self);
static void _zbrown_palette_guidelines_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void zbrown_palette_export_action (ZBrownPalette* self);
static void _zbrown_palette_export_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void zbrown_palette_about (ZBrownPalette* self);
static void _zbrown_palette_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
VALA_EXTERN GType zbrown_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZBrownApplication, g_object_unref)
VALA_EXTERN ZBrownPalette* zbrown_palette_new (ZBrownApplication* app);
VALA_EXTERN ZBrownPalette* zbrown_palette_construct (GType object_type,
                                         ZBrownApplication* app);
static void zbrown_palette_guidelines (ZBrownPalette* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static void zbrown_palette_guidelines_finish (ZBrownPalette* self,
                                       GAsyncResult* _res_);
static void zbrown_palette_export (ZBrownPalette* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
static void zbrown_palette_export_finish (ZBrownPalette* self,
                                   GAsyncResult* _res_);
static void zbrown_palette_guidelines_data_free (gpointer _data);
static gboolean zbrown_palette_guidelines_co (ZbrownPaletteGuidelinesData* _data_);
static void zbrown_palette_guidelines_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void zbrown_palette_export_data_free (gpointer _data);
static gboolean zbrown_palette_export_co (ZbrownPaletteExportData* _data_);
static void zbrown_palette_export_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static GObject * zbrown_palette_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static GType zbrown_palette_get_type_once (void);
static void zbrown_application_real_activate (GApplication* base);
static void zbrown_application_real_startup (GApplication* base);
VALA_EXTERN ZBrownApplication* zbrown_application_new (void);
VALA_EXTERN ZBrownApplication* zbrown_application_construct (GType object_type);
static GObject * zbrown_application_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static GType zbrown_application_get_type_once (void);
static gint zbrown_main (gchar** args,
                  gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry ZBROWN_PALETTE_entries[3] = {{"guidelines", _zbrown_palette_guidelines_action_gsimple_action_activate_callback}, {"export", _zbrown_palette_export_action_gsimple_action_activate_callback}, {"about", _zbrown_palette_about_gsimple_action_activate_callback}};

static inline gpointer
zbrown_palette_button_get_instance_private (ZBrownPaletteButton* self)
{
	return G_STRUCT_MEMBER_P (self, ZBrownPaletteButton_private_offset);
}

static GdkContentProvider*
zbrown_palette_button_get_content (ZBrownPaletteButton* self)
{
	GdkRGBA colour = {0};
	GdkRGBA _tmp0_ = {0};
	const gchar* _tmp1_;
	GdkRGBA _tmp2_;
	GValue _tmp3_ = {0};
	GdkContentProvider* _tmp4_;
	const gchar* _tmp5_;
	GValue _tmp6_ = {0};
	GdkContentProvider* _tmp7_;
	GdkContentProvider** _tmp8_;
	GdkContentProvider* _tmp9_;
	GdkContentProvider* _tmp10_;
	GdkContentProvider* result;
	g_return_val_if_fail (self != NULL, NULL);
	colour = _tmp0_;
	_tmp1_ = self->priv->_hex;
	gdk_rgba_parse (&colour, _tmp1_);
	_tmp2_ = colour;
	g_value_init (&_tmp3_, gdk_rgba_get_type ());
	g_value_set_boxed (&_tmp3_, &_tmp2_);
	_tmp4_ = gdk_content_provider_new_for_value (&_tmp3_);
	_tmp5_ = self->priv->_hex;
	g_value_init (&_tmp6_, G_TYPE_STRING);
	g_value_set_string (&_tmp6_, _tmp5_);
	_tmp7_ = gdk_content_provider_new_for_value (&_tmp6_);
	_tmp8_ = g_new0 (GdkContentProvider*, 2 + 1);
	_tmp8_[0] = _tmp4_;
	_tmp8_[1] = _tmp7_;
	_tmp9_ = gdk_content_provider_new_union (_tmp8_, 2);
	_tmp10_ = _tmp9_;
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
	result = _tmp10_;
	return result;
}

static gchar*
zbrown_palette_button_build_tooltip (ZBrownPaletteButton* self,
                                     const gchar* section_name,
                                     gint section_index,
                                     const gchar* hex)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("<b>%s %i</b>\n" \
"<span size='125%%' font_features='tnum, zero' overline='single' overli" \
"ne_color='%s'>%s</span>", section_name, section_index, hex, hex);
	result = _tmp0_;
	return result;
}

static void
zbrown_palette_button_motion_enter (ZBrownPaletteButton* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->image_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "copy");
}

static void
_zbrown_palette_button_motion_enter_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                       gdouble x,
                                                                       gdouble y,
                                                                       gpointer self)
{
	zbrown_palette_button_motion_enter ((ZBrownPaletteButton*) self);
}

static void
zbrown_palette_button_motion_leave (ZBrownPaletteButton* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->image_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "empty");
}

static void
_zbrown_palette_button_motion_leave_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                       gpointer self)
{
	zbrown_palette_button_motion_leave ((ZBrownPaletteButton*) self);
}

static GdkContentProvider*
zbrown_palette_button_drag_prepare (ZBrownPaletteButton* self,
                                    GtkDragSource* source,
                                    gdouble x,
                                    gdouble y)
{
	GdkContentProvider* _tmp0_;
	GdkContentProvider* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	gtk_gesture_set_state ((GtkGesture*) source, GTK_EVENT_SEQUENCE_CLAIMED);
	_tmp0_ = zbrown_palette_button_get_content (self);
	result = _tmp0_;
	return result;
}

static GdkContentProvider*
_zbrown_palette_button_drag_prepare_gtk_drag_source_prepare (GtkDragSource* _sender,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self)
{
	GdkContentProvider* result;
	result = zbrown_palette_button_drag_prepare ((ZBrownPaletteButton*) self, _sender, x, y);
	return result;
}

static void
zbrown_palette_button_drag_begin (ZBrownPaletteButton* self,
                                  GtkDragSource* source,
                                  GdkDrag* drag)
{
	GtkWidgetPaintable* _tmp0_;
	GtkWidgetPaintable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (drag != NULL);
	_tmp0_ = (GtkWidgetPaintable*) gtk_widget_paintable_new ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	gtk_drag_source_set_icon (source, (GdkPaintable*) _tmp1_, 0, 0);
	_g_object_unref0 (_tmp1_);
}

static void
_zbrown_palette_button_drag_begin_gtk_drag_source_drag_begin (GtkDragSource* _sender,
                                                              GdkDrag* drag,
                                                              gpointer self)
{
	zbrown_palette_button_drag_begin ((ZBrownPaletteButton*) self, _sender, drag);
}

static void
__lambda4_ (ZBrownPaletteButton* self)
{
	GtkStack* _tmp0_;
	_tmp0_ = self->priv->image_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "empty");
	self->priv->timeout_id = (guint) 0;
}

static void
___lambda4__gsource_once_func (gpointer self)
{
	__lambda4_ ((ZBrownPaletteButton*) self);
}

static void
zbrown_palette_button_real_clicked (GtkButton* base)
{
	ZBrownPaletteButton * self;
	GtkStack* _tmp0_;
	GdkClipboard* _tmp1_;
	GdkContentProvider* _tmp2_;
	GdkContentProvider* _tmp3_;
	self = (ZBrownPaletteButton*) base;
	_tmp0_ = self->priv->image_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "ok");
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
	}
	self->priv->timeout_id = g_timeout_add_seconds_once ((guint) 3, ___lambda4__gsource_once_func, self);
	_tmp1_ = gtk_widget_get_clipboard ((GtkWidget*) self);
	_tmp2_ = zbrown_palette_button_get_content (self);
	_tmp3_ = _tmp2_;
	gdk_clipboard_set_content (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static void
zbrown_palette_button_real_snapshot (GtkWidget* base,
                                     GtkSnapshot* snapshot)
{
	ZBrownPaletteButton * self;
	GdkRGBA colour = {0};
	GdkRGBA _tmp0_ = {0};
	graphene_rect_t bounds = {0};
	const gchar* _tmp1_;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	graphene_rect_t _tmp2_ = {0};
	GdkRGBA _tmp3_;
	graphene_rect_t _tmp4_;
	self = (ZBrownPaletteButton*) base;
	g_return_if_fail (snapshot != NULL);
	colour = _tmp0_;
	_tmp1_ = self->priv->_hex;
	gdk_rgba_parse (&colour, _tmp1_);
	width = (gfloat) gtk_widget_get_width ((GtkWidget*) self);
	height = (gfloat) gtk_widget_get_height ((GtkWidget*) self);
	_tmp2_.origin = (graphene_point_t) {(gfloat) 0.0, (gfloat) 0.0};
	_tmp2_.size = (graphene_size_t) {width, height};
	bounds = _tmp2_;
	_tmp3_ = colour;
	_tmp4_ = bounds;
	gtk_snapshot_append_color (snapshot, &_tmp3_, &_tmp4_);
	GTK_WIDGET_CLASS (zbrown_palette_button_parent_class)->snapshot ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), snapshot);
}

ZBrownPaletteButton*
zbrown_palette_button_construct (GType object_type)
{
	ZBrownPaletteButton * self = NULL;
	self = (ZBrownPaletteButton*) g_object_new (object_type, NULL);
	return self;
}

ZBrownPaletteButton*
zbrown_palette_button_new (void)
{
	return zbrown_palette_button_construct (ZBROWN_TYPE_PALETTE_BUTTON);
}

const gchar*
zbrown_palette_button_get_section_name (ZBrownPaletteButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_section_name;
	result = _tmp0_;
	return result;
}

void
zbrown_palette_button_set_section_name (ZBrownPaletteButton* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zbrown_palette_button_get_section_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_section_name);
		self->priv->_section_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_SECTION_NAME_PROPERTY]);
	}
}

gint
zbrown_palette_button_get_section_index (ZBrownPaletteButton* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_section_index;
	return result;
}

void
zbrown_palette_button_set_section_index (ZBrownPaletteButton* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = zbrown_palette_button_get_section_index (self);
	if (old_value != value) {
		self->priv->_section_index = value;
		g_object_notify_by_pspec ((GObject *) self, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_SECTION_INDEX_PROPERTY]);
	}
}

const gchar*
zbrown_palette_button_get_hex (ZBrownPaletteButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hex;
	result = _tmp0_;
	return result;
}

void
zbrown_palette_button_set_hex (ZBrownPaletteButton* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zbrown_palette_button_get_hex (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_hex);
		self->priv->_hex = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_HEX_PROPERTY]);
	}
}

gboolean
zbrown_palette_button_get_light (ZBrownPaletteButton* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_widget_has_css_class ((GtkWidget*) self, "light");
	return result;
}

void
zbrown_palette_button_set_light (ZBrownPaletteButton* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		gtk_widget_add_css_class ((GtkWidget*) self, "light");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "light");
	}
	g_object_notify_by_pspec ((GObject *) self, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_LIGHT_PROPERTY]);
}

static void
zbrown_palette_button_class_init (ZBrownPaletteButtonClass * klass,
                                  gpointer klass_data)
{
	zbrown_palette_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZBrownPaletteButton_private_offset);
	((GtkButtonClass *) klass)->clicked = (void (*) (GtkButton*)) zbrown_palette_button_real_clicked;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) zbrown_palette_button_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_zbrown_palette_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zbrown_palette_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = zbrown_palette_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZBROWN_PALETTE_BUTTON_SECTION_NAME_PROPERTY, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_SECTION_NAME_PROPERTY] = g_param_spec_string ("section-name", "section-name", "section-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZBROWN_PALETTE_BUTTON_SECTION_INDEX_PROPERTY, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_SECTION_INDEX_PROPERTY] = g_param_spec_int ("section-index", "section-index", "section-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZBROWN_PALETTE_BUTTON_HEX_PROPERTY, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_HEX_PROPERTY] = g_param_spec_string ("hex", "hex", "hex", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZBROWN_PALETTE_BUTTON_LIGHT_PROPERTY, zbrown_palette_button_properties[ZBROWN_PALETTE_BUTTON_LIGHT_PROPERTY] = g_param_spec_boolean ("light", "light", "light", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/design/Palette/palette-button.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_stack", FALSE, ZBrownPaletteButton_private_offset + G_STRUCT_OFFSET (ZBrownPaletteButtonPrivate, image_stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "build_tooltip", G_CALLBACK(zbrown_palette_button_build_tooltip));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "motion_enter", G_CALLBACK(_zbrown_palette_button_motion_enter_gtk_event_controller_motion_enter));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "motion_leave", G_CALLBACK(_zbrown_palette_button_motion_leave_gtk_event_controller_motion_leave));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "drag_prepare", G_CALLBACK(_zbrown_palette_button_drag_prepare_gtk_drag_source_prepare));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "drag_begin", G_CALLBACK(_zbrown_palette_button_drag_begin_gtk_drag_source_drag_begin));
}

static void
zbrown_palette_button_instance_init (ZBrownPaletteButton * self,
                                     gpointer klass)
{
	self->priv = zbrown_palette_button_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
zbrown_palette_button_finalize (GObject * obj)
{
	ZBrownPaletteButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZBROWN_TYPE_PALETTE_BUTTON, ZBrownPaletteButton);
	_g_free0 (self->priv->_section_name);
	_g_free0 (self->priv->_hex);
	G_OBJECT_CLASS (zbrown_palette_button_parent_class)->finalize (obj);
}

static GType
zbrown_palette_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZBrownPaletteButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zbrown_palette_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZBrownPaletteButton), 0, (GInstanceInitFunc) zbrown_palette_button_instance_init, NULL };
	GType zbrown_palette_button_type_id;
	zbrown_palette_button_type_id = g_type_register_static (gtk_button_get_type (), "ZBrownPaletteButton", &g_define_type_info, 0);
	ZBrownPaletteButton_private_offset = g_type_add_instance_private (zbrown_palette_button_type_id, sizeof (ZBrownPaletteButtonPrivate));
	return zbrown_palette_button_type_id;
}

GType
zbrown_palette_button_get_type (void)
{
	static volatile gsize zbrown_palette_button_type_id__once = 0;
	if (g_once_init_enter (&zbrown_palette_button_type_id__once)) {
		GType zbrown_palette_button_type_id;
		zbrown_palette_button_type_id = zbrown_palette_button_get_type_once ();
		g_once_init_leave (&zbrown_palette_button_type_id__once, zbrown_palette_button_type_id);
	}
	return zbrown_palette_button_type_id__once;
}

static void
_vala_zbrown_palette_button_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ZBrownPaletteButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZBROWN_TYPE_PALETTE_BUTTON, ZBrownPaletteButton);
	switch (property_id) {
		case ZBROWN_PALETTE_BUTTON_SECTION_NAME_PROPERTY:
		g_value_set_string (value, zbrown_palette_button_get_section_name (self));
		break;
		case ZBROWN_PALETTE_BUTTON_SECTION_INDEX_PROPERTY:
		g_value_set_int (value, zbrown_palette_button_get_section_index (self));
		break;
		case ZBROWN_PALETTE_BUTTON_HEX_PROPERTY:
		g_value_set_string (value, zbrown_palette_button_get_hex (self));
		break;
		case ZBROWN_PALETTE_BUTTON_LIGHT_PROPERTY:
		g_value_set_boolean (value, zbrown_palette_button_get_light (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zbrown_palette_button_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ZBrownPaletteButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZBROWN_TYPE_PALETTE_BUTTON, ZBrownPaletteButton);
	switch (property_id) {
		case ZBROWN_PALETTE_BUTTON_SECTION_NAME_PROPERTY:
		zbrown_palette_button_set_section_name (self, g_value_get_string (value));
		break;
		case ZBROWN_PALETTE_BUTTON_SECTION_INDEX_PROPERTY:
		zbrown_palette_button_set_section_index (self, g_value_get_int (value));
		break;
		case ZBROWN_PALETTE_BUTTON_HEX_PROPERTY:
		zbrown_palette_button_set_hex (self, g_value_get_string (value));
		break;
		case ZBROWN_PALETTE_BUTTON_LIGHT_PROPERTY:
		zbrown_palette_button_set_light (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_zbrown_palette_guidelines_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	zbrown_palette_guidelines_action ((ZBrownPalette*) self);
}

static void
_zbrown_palette_export_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	zbrown_palette_export_action ((ZBrownPalette*) self);
}

static void
_zbrown_palette_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	zbrown_palette_about ((ZBrownPalette*) self);
}

ZBrownPalette*
zbrown_palette_construct (GType object_type,
                          ZBrownApplication* app)
{
	ZBrownPalette * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	self = (ZBrownPalette*) g_object_new (object_type, "application", app, NULL);
	return self;
}

ZBrownPalette*
zbrown_palette_new (ZBrownApplication* app)
{
	return zbrown_palette_construct (ZBROWN_TYPE_PALETTE, app);
}

static void
zbrown_palette_guidelines_action (ZBrownPalette* self)
{
	g_return_if_fail (self != NULL);
	zbrown_palette_guidelines (self, NULL, NULL);
}

static void
zbrown_palette_export_action (ZBrownPalette* self)
{
	g_return_if_fail (self != NULL);
	zbrown_palette_export (self, NULL, NULL);
}

static void
zbrown_palette_guidelines_data_free (gpointer _data)
{
	ZbrownPaletteGuidelinesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ZbrownPaletteGuidelinesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
zbrown_palette_guidelines (ZBrownPalette* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	ZbrownPaletteGuidelinesData* _data_;
	ZBrownPalette* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ZbrownPaletteGuidelinesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zbrown_palette_guidelines_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	zbrown_palette_guidelines_co (_data_);
}

static void
zbrown_palette_guidelines_finish (ZBrownPalette* self,
                                  GAsyncResult* _res_)
{
	ZbrownPaletteGuidelinesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
zbrown_palette_guidelines_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	ZbrownPaletteGuidelinesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zbrown_palette_guidelines_co (_data_);
}

static gboolean
zbrown_palette_guidelines_co (ZbrownPaletteGuidelinesData* _data_)
{
	static const char uri[] = "https://developer.gnome.org/hig/guidelines/app-icons.html";
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gtk_uri_launcher_new (uri);
	_data_->launcher = _data_->_tmp0_;
	{
		_data_->_state_ = 1;
		gtk_uri_launcher_launch (_data_->launcher, (GtkWindow*) _data_->self, NULL, zbrown_palette_guidelines_ready, _data_);
		return FALSE;
		_state_1:
		gtk_uri_launcher_launch_finish (_data_->launcher, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->e;
		_data_->_tmp2_ = _data_->_tmp1_->message;
		_data_->_tmp3_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Launch Failed"), _data_->_tmp2_);
		g_object_ref_sink (_data_->_tmp3_);
		_data_->dlg = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->dlg;
		adw_alert_dialog_add_response (_data_->_tmp4_, "close", _ ("Close"));
		_data_->_tmp5_ = _data_->dlg;
		adw_dialog_present ((AdwDialog*) _data_->_tmp5_, (GtkWidget*) _data_->self);
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = g_quark_to_string (_data_->_tmp6_->domain);
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("palette.vala:146: %s (%i): %s", _data_->_tmp7_, _data_->_tmp8_->code, _data_->_tmp10_);
		_g_object_unref0 (_data_->dlg);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->launcher);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->launcher);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zbrown_palette_export_data_free (gpointer _data)
{
	ZbrownPaletteExportData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ZbrownPaletteExportData, _data_);
}

static void
zbrown_palette_export (ZBrownPalette* self,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	ZbrownPaletteExportData* _data_;
	ZBrownPalette* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ZbrownPaletteExportData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zbrown_palette_export_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	zbrown_palette_export_co (_data_);
}

static void
zbrown_palette_export_finish (ZBrownPalette* self,
                              GAsyncResult* _res_)
{
	ZbrownPaletteExportData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
zbrown_palette_export_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	ZbrownPaletteExportData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zbrown_palette_export_co (_data_);
}

static gboolean
zbrown_palette_export_co (ZbrownPaletteExportData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("GNOME HIG.gpl");
	_data_->_tmp1_ = g_strdup (_ ("Export the Palette"));
	_data_->_tmp2_ = g_strdup (_ ("Export"));
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_initial_name (_data_->_tmp3_, _data_->_tmp0_);
	_g_free0 (_data_->_tmp0_);
	gtk_file_dialog_set_title (_data_->_tmp3_, _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	gtk_file_dialog_set_accept_label (_data_->_tmp3_, _data_->_tmp2_);
	_g_free0 (_data_->_tmp2_);
	_data_->dialog = _data_->_tmp3_;
	_data_->_tmp4_ = g_file_new_for_uri ("resource:///org/gnome/design/Palette/palette.gpl");
	_data_->palette_file = _data_->_tmp4_;
	{
		_data_->_tmp6_ = _data_->dialog;
		_data_->_state_ = 1;
		gtk_file_dialog_save (_data_->_tmp6_, (GtkWindow*) _data_->self, NULL, zbrown_palette_export_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = gtk_file_dialog_save_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, GTK_DIALOG_ERROR, GTK_DIALOG_ERROR_DISMISSED)) {
				goto __catch0_gtk_dialog_error_dismissed;
			}
			if (g_error_matches (_data_->_inner_error0_, GTK_DIALOG_ERROR, GTK_DIALOG_ERROR_CANCELLED)) {
				goto __catch0_gtk_dialog_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp8_ = _data_->palette_file;
		g_file_copy (_data_->_tmp8_, _data_->_tmp5_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp5_);
			if (g_error_matches (_data_->_inner_error0_, GTK_DIALOG_ERROR, GTK_DIALOG_ERROR_DISMISSED)) {
				goto __catch0_gtk_dialog_error_dismissed;
			}
			if (g_error_matches (_data_->_inner_error0_, GTK_DIALOG_ERROR, GTK_DIALOG_ERROR_CANCELLED)) {
				goto __catch0_gtk_dialog_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->_tmp5_);
	}
	goto __finally0;
	__catch0_gtk_dialog_error_dismissed:
	{
		g_clear_error (&_data_->_inner_error0_);
		_g_object_unref0 (_data_->palette_file);
		_g_object_unref0 (_data_->dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_gtk_dialog_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
		_g_object_unref0 (_data_->palette_file);
		_g_object_unref0 (_data_->dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		_data_->_tmp11_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Export Failed"), _data_->_tmp10_);
		g_object_ref_sink (_data_->_tmp11_);
		_data_->dlg = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->dlg;
		adw_alert_dialog_add_response (_data_->_tmp12_, "close", _ ("Close"));
		_data_->_tmp13_ = _data_->dlg;
		adw_dialog_present ((AdwDialog*) _data_->_tmp13_, (GtkWidget*) _data_->self);
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = g_quark_to_string (_data_->_tmp14_->domain);
		_data_->_tmp16_ = _data_->e;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		g_warning ("palette.vala:169: %s (%i): %s", _data_->_tmp15_, _data_->_tmp16_->code, _data_->_tmp18_);
		_g_object_unref0 (_data_->dlg);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->palette_file);
		_g_object_unref0 (_data_->dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->palette_file);
		_g_object_unref0 (_data_->dialog);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->palette_file);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
zbrown_palette_about (ZBrownPalette* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint artists_length1;
	gint _artists_size_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar* _tmp15_;
	AdwAboutDialog* _tmp16_ = NULL;
	AdwAboutDialog* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Zander Brown");
	_tmp1_ = g_strdup ("Bilal Elmoussaoui");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Tobias Bernard");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	artists = _tmp4_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp5_ = g_get_application_name ();
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = gtk_window_get_default_icon_name ();
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = g_strdup (PACKAGE_VERSION);
	_tmp10_ = g_strdup (_ ("© 2018-2025 Zander Brown"));
	_tmp11_ = g_strdup ("Zander Brown");
	_tmp12_ = (authors != NULL) ? _vala_array_dup1 (authors, authors_length1) : authors;
	_tmp12__length1 = authors_length1;
	_tmp13_ = (artists != NULL) ? _vala_array_dup2 (artists, artists_length1) : artists;
	_tmp13__length1 = artists_length1;
	_tmp14_ = g_strdup (_ ("translator-credits"));
	_tmp15_ = g_strdup ("https://gitlab.gnome.org/World/design/palette/-/issues/new");
	_tmp16_ = (AdwAboutDialog*) adw_about_dialog_new ();
	adw_about_dialog_set_application_name (_tmp16_, _tmp6_);
	_g_free0 (_tmp6_);
	adw_about_dialog_set_application_icon (_tmp16_, _tmp8_);
	_g_free0 (_tmp8_);
	adw_about_dialog_set_version (_tmp16_, _tmp9_);
	_g_free0 (_tmp9_);
	adw_about_dialog_set_copyright (_tmp16_, _tmp10_);
	_g_free0 (_tmp10_);
	adw_about_dialog_set_license_type (_tmp16_, GTK_LICENSE_GPL_3_0);
	adw_about_dialog_set_developer_name (_tmp16_, _tmp11_);
	_g_free0 (_tmp11_);
	adw_about_dialog_set_developers (_tmp16_, _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_designers (_tmp16_, _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_translator_credits (_tmp16_, _tmp14_);
	_g_free0 (_tmp14_);
	adw_about_dialog_set_issue_url (_tmp16_, _tmp15_);
	_g_free0 (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	adw_dialog_present ((AdwDialog*) _tmp17_, (GtkWidget*) self);
	_g_object_unref0 (_tmp17_);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static GObject *
zbrown_palette_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZBrownPalette * self;
	parent_class = G_OBJECT_CLASS (zbrown_palette_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZBROWN_TYPE_PALETTE, ZBrownPalette);
	g_action_map_add_action_entries ((GActionMap*) self, ZBROWN_PALETTE_entries, (gint) G_N_ELEMENTS (ZBROWN_PALETTE_entries), self);
	return obj;
}

static void
zbrown_palette_class_init (ZBrownPaletteClass * klass,
                           gpointer klass_data)
{
	zbrown_palette_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = zbrown_palette_constructor;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/design/Palette/palette.ui");
}

static void
zbrown_palette_instance_init (ZBrownPalette * self,
                              gpointer klass)
{
	gtk_widget_init_template (GTK_WIDGET (self));
}

static GType
zbrown_palette_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZBrownPaletteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zbrown_palette_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZBrownPalette), 0, (GInstanceInitFunc) zbrown_palette_instance_init, NULL };
	GType zbrown_palette_type_id;
	zbrown_palette_type_id = g_type_register_static (adw_application_window_get_type (), "ZBrownPalette", &g_define_type_info, 0);
	return zbrown_palette_type_id;
}

GType
zbrown_palette_get_type (void)
{
	static volatile gsize zbrown_palette_type_id__once = 0;
	if (g_once_init_enter (&zbrown_palette_type_id__once)) {
		GType zbrown_palette_type_id;
		zbrown_palette_type_id = zbrown_palette_get_type_once ();
		g_once_init_leave (&zbrown_palette_type_id__once, zbrown_palette_type_id);
	}
	return zbrown_palette_type_id__once;
}

static void
zbrown_application_real_activate (GApplication* base)
{
	ZBrownApplication * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	self = (ZBrownApplication*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkWindow* _tmp2_;
		GtkWindow* _tmp3_;
		_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp3_ = _tmp2_;
		gtk_window_present (_tmp3_);
	} else {
		ZBrownPalette* _tmp4_;
		ZBrownPalette* _tmp5_;
		_tmp4_ = zbrown_palette_new (self);
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		gtk_window_present ((GtkWindow*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
}

static void
zbrown_application_real_startup (GApplication* base)
{
	ZBrownApplication * self;
	AdwStyleManager* _tmp0_;
	self = (ZBrownApplication*) base;
	G_APPLICATION_CLASS (zbrown_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = adw_style_manager_get_default ();
	adw_style_manager_set_color_scheme (_tmp0_, ADW_COLOR_SCHEME_FORCE_DARK);
}

ZBrownApplication*
zbrown_application_construct (GType object_type)
{
	ZBrownApplication * self = NULL;
	self = (ZBrownApplication*) g_object_new (object_type, NULL);
	return self;
}

ZBrownApplication*
zbrown_application_new (void)
{
	return zbrown_application_construct (ZBROWN_TYPE_APPLICATION);
}

static GObject *
zbrown_application_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZBrownApplication * self;
	parent_class = G_OBJECT_CLASS (zbrown_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZBROWN_TYPE_APPLICATION, ZBrownApplication);
	g_application_set_flags ((GApplication*) self, G_APPLICATION_DEFAULT_FLAGS);
	g_application_set_application_id ((GApplication*) self, "org.gnome.design.Palette");
	return obj;
}

static void
zbrown_application_base_init (ZBrownApplicationClass * klass)
{
	g_type_ensure (ZBROWN_TYPE_PALETTE_BUTTON);
}

static void
zbrown_application_class_init (ZBrownApplicationClass * klass,
                               gpointer klass_data)
{
	zbrown_application_parent_class = g_type_class_peek_parent (klass);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) zbrown_application_real_activate;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) zbrown_application_real_startup;
	G_OBJECT_CLASS (klass)->constructor = zbrown_application_constructor;
}

static void
zbrown_application_instance_init (ZBrownApplication * self,
                                  gpointer klass)
{
}

static GType
zbrown_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZBrownApplicationClass), (GBaseInitFunc) zbrown_application_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zbrown_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZBrownApplication), 0, (GInstanceInitFunc) zbrown_application_instance_init, NULL };
	GType zbrown_application_type_id;
	zbrown_application_type_id = g_type_register_static (adw_application_get_type (), "ZBrownApplication", &g_define_type_info, 0);
	return zbrown_application_type_id;
}

GType
zbrown_application_get_type (void)
{
	static volatile gsize zbrown_application_type_id__once = 0;
	if (g_once_init_enter (&zbrown_application_type_id__once)) {
		GType zbrown_application_type_id;
		zbrown_application_type_id = zbrown_application_get_type_once ();
		g_once_init_leave (&zbrown_application_type_id__once, zbrown_application_type_id);
	}
	return zbrown_application_type_id__once;
}

static gint
zbrown_main (gchar** args,
             gint args_length1)
{
	ZBrownApplication* _tmp0_;
	ZBrownApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	gtk_window_set_default_icon_name ("org.gnome.design.Palette");
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (_ ("Color Palette"));
	_tmp0_ = zbrown_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return zbrown_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

