/* fuzzy-search-project.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from fuzzy-search-project.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. <https://elementary.io>
 *
 * Authored by: Marvin Ahlgrimm
 * Authored by: Colin Kiama <colinkiama@gmail.com>
 */

#include "fuzzy-search.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "codecore.h"
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _scratch_services_search_project_unref0(var) ((var == NULL) ? NULL : (var = (scratch_services_search_project_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _ScratchServicesSearchProjectParseAsyncData ScratchServicesSearchProjectParseAsyncData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScratchServicesSearchProjectAddDirectoryAsyncData ScratchServicesSearchProjectAddDirectoryAsyncData;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ScratchServicesSearchProjectParseAsyncInternalData ScratchServicesSearchProjectParseAsyncInternalData;
typedef struct _ScratchServicesParamSpecSearchProject ScratchServicesParamSpecSearchProject;

struct _ScratchServicesSearchProjectPrivate {
	gchar* _root_path;
	GeeHashSet* _relative_file_paths;
	ScratchServicesMonitoredRepository* monitored_repo;
};

struct _Block12Data {
	int _ref_count_;
	ScratchServicesSearchProject* self;
	gchar* path;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _ScratchServicesSearchProjectParseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesSearchProject* self;
	gchar* path;
	GCancellable* cancellable;
	Block12Data* _data12_;
	GThread* _tmp0_;
	GThread* _tmp1_;
};

struct _ScratchServicesSearchProjectAddDirectoryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesSearchProject* self;
	gchar* path;
	GCancellable* cancellable;
};

struct _ScratchServicesSearchProjectParseAsyncInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchServicesSearchProject* self;
	gchar* path;
	GCancellable* cancellable;
	gchar* path_basename;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	ScratchServicesMonitoredRepository* _tmp4_;
	gboolean _tmp5_;
	ScratchServicesMonitoredRepository* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GDir* dir;
	GDir* _tmp9_;
	gchar* name;
	GDir* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* new_search_path;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GDir* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* subpath;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GeeHashSet* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _inner_error0_;
};

struct _ScratchServicesParamSpecSearchProject {
	GParamSpec parent_instance;
};

static gint ScratchServicesSearchProject_private_offset;
static gpointer scratch_services_search_project_parent_class = NULL;
static GType scratch_services_search_project_type_id = 0;

static void scratch_services_search_project_set_root_path (ScratchServicesSearchProject* self,
                                                    const gchar* value);
static void scratch_services_search_project_set_relative_file_paths (ScratchServicesSearchProject* self,
                                                              GeeHashSet* value);
static void scratch_services_search_project_parse_async_data_free (gpointer _data);
static gboolean scratch_services_search_project_parse_async_co (ScratchServicesSearchProjectParseAsyncData* _data_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda4_ (Block12Data* _data12_);
static void scratch_services_search_project_parse_async_internal (ScratchServicesSearchProject* self,
                                                           const gchar* path,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void scratch_services_search_project_parse_async_internal_finish (ScratchServicesSearchProject* self,
                                                                  GAsyncResult* _res_);
static void __lambda6_ (ScratchServicesSearchProject* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static gboolean _scratch_services_search_project_parse_async_co_gsource_func (gpointer self);
static gpointer ___lambda4__gthread_func (gpointer self);
static void scratch_services_search_project_add_directory_async_data_free (gpointer _data);
static gboolean scratch_services_search_project_add_directory_async_co (ScratchServicesSearchProjectAddDirectoryAsyncData* _data_);
static void __lambda7_ (ScratchServicesSearchProject* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void scratch_services_search_project_parse_async_internal_data_free (gpointer _data);
static gboolean scratch_services_search_project_parse_async_internal_co (ScratchServicesSearchProjectParseAsyncInternalData* _data_);
static void ____lambda5_ (ScratchServicesSearchProject* self,
                   GObject* obj,
                   GAsyncResult* res);
static void _____lambda5__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean scratch_services_search_project_check_if_valid_path_to_add (ScratchServicesSearchProject* self,
                                                                     const gchar* path);
static void scratch_services_search_project_finalize (ScratchServicesSearchProject * obj);

static inline gpointer
scratch_services_search_project_get_instance_private (ScratchServicesSearchProject* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesSearchProject_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ScratchServicesSearchProject*
scratch_services_search_project_construct (GType object_type,
                                           const gchar* root,
                                           ScratchServicesMonitoredRepository* repo)
{
	ScratchServicesSearchProject* self = NULL;
	ScratchServicesMonitoredRepository* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	g_return_val_if_fail (root != NULL, NULL);
	self = (ScratchServicesSearchProject*) g_type_create_instance (object_type);
	scratch_services_search_project_set_root_path (self, root);
	_tmp0_ = _g_object_ref0 (repo);
	_g_object_unref0 (self->priv->monitored_repo);
	self->priv->monitored_repo = _tmp0_;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp2_ = _tmp1_;
	scratch_services_search_project_set_relative_file_paths (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	return self;
}

ScratchServicesSearchProject*
scratch_services_search_project_new (const gchar* root,
                                     ScratchServicesMonitoredRepository* repo)
{
	return scratch_services_search_project_construct (SCRATCH_SERVICES_TYPE_SEARCH_PROJECT, root, repo);
}

static void
scratch_services_search_project_parse_async_data_free (gpointer _data)
{
	ScratchServicesSearchProjectParseAsyncData* _data_;
	_data_ = _data;
	_scratch_services_search_project_unref0 (_data_->self);
	g_slice_free (ScratchServicesSearchProjectParseAsyncData, _data_);
}

static gpointer
_scratch_services_search_project_ref0 (gpointer self)
{
	return self ? scratch_services_search_project_ref (self) : NULL;
}

void
scratch_services_search_project_parse_async (ScratchServicesSearchProject* self,
                                             const gchar* path,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	ScratchServicesSearchProjectParseAsyncData* _data_;
	ScratchServicesSearchProject* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (ScratchServicesSearchProjectParseAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_search_project_parse_async_data_free);
	_tmp0_ = _scratch_services_search_project_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	scratch_services_search_project_parse_async_co (_data_);
}

void
scratch_services_search_project_parse_finish (ScratchServicesSearchProject* self,
                                              GAsyncResult* _res_)
{
	ScratchServicesSearchProjectParseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ScratchServicesSearchProject* self;
		self = _data12_->self;
		_g_free0 (_data12_->path);
		_g_object_unref0 (_data12_->cancellable);
		_scratch_services_search_project_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda6_ (ScratchServicesSearchProject* self,
            GObject* obj,
            GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	scratch_services_search_project_parse_async_internal_finish (self, res);
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ ((ScratchServicesSearchProject*) self, source_object, res);
	scratch_services_search_project_unref (self);
}

static gboolean
_scratch_services_search_project_parse_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = scratch_services_search_project_parse_async_co (self);
	return result;
}

static void
__lambda4_ (Block12Data* _data12_)
{
	ScratchServicesSearchProject* self;
	self = _data12_->self;
	scratch_services_search_project_parse_async_internal (self, _data12_->path, _data12_->cancellable, ___lambda6__gasync_ready_callback, scratch_services_search_project_ref (self));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scratch_services_search_project_parse_async_co_gsource_func, _data12_->_async_data_, NULL);
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	__lambda4_ (self);
	result = NULL;
	block12_data_unref (self);
	return result;
}

static gboolean
scratch_services_search_project_parse_async_co (ScratchServicesSearchProjectParseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data12_ = g_slice_new0 (Block12Data);
	_data_->_data12_->_ref_count_ = 1;
	_data_->_data12_->self = scratch_services_search_project_ref (_data_->self);
	_g_free0 (_data_->_data12_->path);
	_data_->_data12_->path = _data_->path;
	_g_object_unref0 (_data_->_data12_->cancellable);
	_data_->_data12_->cancellable = _data_->cancellable;
	_data_->_data12_->_async_data_ = _data_;
	_data_->_tmp0_ = g_thread_new (NULL, ___lambda4__gthread_func, block12_data_ref (_data_->_data12_));
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_thread_unref0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block12_data_unref (_data_->_data12_);
	_data_->_data12_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
scratch_services_search_project_remove_file (ScratchServicesSearchProject* self,
                                             const gchar* path,
                                             GCancellable* cancellable)
{
	gchar* subpath = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* deleted_path = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	GeeHashSet* _tmp7_;
	const gchar* _tmp8_;
	GeeIterator* iter = NULL;
	GeeHashSet* _tmp11_;
	GeeIterator* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (cancellable != NULL);
	if (g_cancellable_is_cancelled (cancellable)) {
		return;
	}
	_tmp0_ = self->priv->_root_path;
	_tmp1_ = string_replace (path, _tmp0_, "");
	subpath = _tmp1_;
	_tmp2_ = subpath;
	_tmp3_ = subpath;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp2_, (glong) 1, (glong) (_tmp5_ - 1));
	deleted_path = _tmp6_;
	_tmp7_ = self->priv->_relative_file_paths;
	_tmp8_ = deleted_path;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_)) {
		GeeHashSet* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->_relative_file_paths;
		_tmp10_ = deleted_path;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp9_, _tmp10_);
		_g_free0 (deleted_path);
		_g_free0 (subpath);
		return;
	}
	_tmp11_ = self->priv->_relative_file_paths;
	_tmp12_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp11_);
	iter = _tmp12_;
	while (TRUE) {
		GeeIterator* _tmp13_;
		gchar* relative_path = NULL;
		GeeIterator* _tmp14_;
		gpointer _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp13_ = iter;
		if (!gee_iterator_next (_tmp13_)) {
			break;
		}
		_tmp14_ = iter;
		_tmp15_ = gee_iterator_get (_tmp14_);
		relative_path = (gchar*) _tmp15_;
		_tmp16_ = relative_path;
		_tmp17_ = deleted_path;
		if (g_str_has_prefix (_tmp16_, _tmp17_)) {
			GeeIterator* _tmp18_;
			_tmp18_ = iter;
			gee_iterator_remove (_tmp18_);
		}
		_g_free0 (relative_path);
	}
	_g_object_unref0 (iter);
	_g_free0 (deleted_path);
	_g_free0 (subpath);
}

void
scratch_services_search_project_add_file (ScratchServicesSearchProject* self,
                                          const gchar* path,
                                          GCancellable* cancellable)
{
	gchar* subpath = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GeeHashSet* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (cancellable != NULL);
	if (g_cancellable_is_cancelled (cancellable)) {
		return;
	}
	{
		gboolean _tmp0_ = FALSE;
		ScratchServicesMonitoredRepository* _tmp1_;
		_tmp1_ = self->priv->monitored_repo;
		if (_tmp1_ != NULL) {
			gboolean _tmp2_ = FALSE;
			ScratchServicesMonitoredRepository* _tmp3_;
			_tmp3_ = self->priv->monitored_repo;
			_tmp2_ = scratch_services_monitored_repository_path_is_ignored (_tmp3_, path, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp0_ = _tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			return;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("fuzzy-search-project.vala:69: An error occurred while checking if item" \
" '%s' is git-ignored: %s", path, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = self->priv->_root_path;
	_tmp7_ = string_replace (path, _tmp6_, "");
	subpath = _tmp7_;
	_tmp8_ = self->priv->_relative_file_paths;
	_tmp9_ = subpath;
	_tmp10_ = subpath;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_substring (_tmp9_, (glong) 1, (glong) (_tmp12_ - 1));
	_tmp14_ = _tmp13_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (subpath);
}

static void
scratch_services_search_project_add_directory_async_data_free (gpointer _data)
{
	ScratchServicesSearchProjectAddDirectoryAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_scratch_services_search_project_unref0 (_data_->self);
	g_slice_free (ScratchServicesSearchProjectAddDirectoryAsyncData, _data_);
}

void
scratch_services_search_project_add_directory_async (ScratchServicesSearchProject* self,
                                                     const gchar* path,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	ScratchServicesSearchProjectAddDirectoryAsyncData* _data_;
	ScratchServicesSearchProject* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (ScratchServicesSearchProjectAddDirectoryAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_search_project_add_directory_async_data_free);
	_tmp0_ = _scratch_services_search_project_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	scratch_services_search_project_add_directory_async_co (_data_);
}

void
scratch_services_search_project_add_directory_finish (ScratchServicesSearchProject* self,
                                                      GAsyncResult* _res_)
{
	ScratchServicesSearchProjectAddDirectoryAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
__lambda7_ (ScratchServicesSearchProject* self,
            GObject* obj,
            GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	scratch_services_search_project_parse_async_internal_finish (self, res);
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda7_ ((ScratchServicesSearchProject*) self, source_object, res);
	scratch_services_search_project_unref (self);
}

static gboolean
scratch_services_search_project_add_directory_async_co (ScratchServicesSearchProjectAddDirectoryAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	scratch_services_search_project_parse_async_internal (_data_->self, _data_->path, _data_->cancellable, ___lambda7__gasync_ready_callback, scratch_services_search_project_ref (_data_->self));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
scratch_services_search_project_parse_async_internal_data_free (gpointer _data)
{
	ScratchServicesSearchProjectParseAsyncInternalData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_scratch_services_search_project_unref0 (_data_->self);
	g_slice_free (ScratchServicesSearchProjectParseAsyncInternalData, _data_);
}

static void
scratch_services_search_project_parse_async_internal (ScratchServicesSearchProject* self,
                                                      const gchar* path,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	ScratchServicesSearchProjectParseAsyncInternalData* _data_;
	ScratchServicesSearchProject* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (ScratchServicesSearchProjectParseAsyncInternalData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_services_search_project_parse_async_internal_data_free);
	_tmp0_ = _scratch_services_search_project_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	scratch_services_search_project_parse_async_internal_co (_data_);
}

static void
scratch_services_search_project_parse_async_internal_finish (ScratchServicesSearchProject* self,
                                                             GAsyncResult* _res_)
{
	ScratchServicesSearchProjectParseAsyncInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
____lambda5_ (ScratchServicesSearchProject* self,
              GObject* obj,
              GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	scratch_services_search_project_parse_async_internal_finish (self, res);
}

static void
_____lambda5__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	____lambda5_ ((ScratchServicesSearchProject*) self, source_object, res);
	scratch_services_search_project_unref (self);
}

static gboolean
scratch_services_search_project_parse_async_internal_co (ScratchServicesSearchProjectParseAsyncInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp0_ = g_path_get_basename (_data_->path);
		_data_->path_basename = _data_->_tmp0_;
		if (g_file_test (_data_->path, G_FILE_TEST_IS_DIR)) {
			_data_->_tmp2_ = _data_->path_basename;
			_data_->_tmp1_ = g_str_has_prefix (_data_->_tmp2_, ".");
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_g_free0 (_data_->path_basename);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp4_ = _data_->self->priv->monitored_repo;
			if (_data_->_tmp4_ != NULL) {
				_data_->_tmp6_ = _data_->self->priv->monitored_repo;
				_data_->_tmp5_ = scratch_services_monitored_repository_path_is_ignored (_data_->_tmp6_, _data_->path, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_data_->_tmp3_ = _data_->_tmp5_;
			} else {
				_data_->_tmp3_ = FALSE;
			}
			if (_data_->_tmp3_) {
				_g_free0 (_data_->path_basename);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp7_ = _data_->e;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			g_warning ("fuzzy-search-project.vala:100: An error occurred while checking if ite" \
"m '%s' is git-ignored: %s", _data_->path, _data_->_tmp8_);
			_g_error_free0 (_data_->e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->path_basename);
			if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp9_ = g_dir_open (_data_->path, (guint) 0, &_data_->_inner_error0_);
		_data_->dir = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->path_basename);
			if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = _data_->dir;
		_data_->_tmp11_ = g_dir_read_name (_data_->_tmp10_);
		_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
		_data_->name = _data_->_tmp12_;
		while (TRUE) {
			_data_->_tmp13_ = _data_->name;
			if (!(_data_->_tmp13_ != NULL)) {
				break;
			}
			if (g_cancellable_is_cancelled (_data_->cancellable)) {
				_g_free0 (_data_->name);
				_g_dir_close0 (_data_->dir);
				_g_free0 (_data_->path_basename);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp14_ = g_strdup ("");
			_data_->new_search_path = _data_->_tmp14_;
			if (g_str_has_suffix (_data_->path, G_DIR_SEPARATOR_S)) {
				_data_->_tmp15_ = strlen (_data_->path);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = string_substring (_data_->path, (glong) 0, (glong) (_data_->_tmp16_ - 1));
				_g_free0 (_data_->new_search_path);
				_data_->new_search_path = _data_->_tmp17_;
			} else {
				_data_->_tmp18_ = g_strdup (_data_->path);
				_g_free0 (_data_->new_search_path);
				_data_->new_search_path = _data_->_tmp18_;
			}
			_data_->_tmp19_ = _data_->new_search_path;
			_data_->_tmp20_ = g_strconcat (_data_->_tmp19_, G_DIR_SEPARATOR_S, NULL);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_tmp22_ = _data_->name;
			_data_->_tmp23_ = g_strconcat (_data_->_tmp21_, _data_->_tmp22_, NULL);
			_data_->_tmp24_ = _data_->_tmp23_;
			scratch_services_search_project_parse_async_internal (_data_->self, _data_->_tmp24_, _data_->cancellable, _____lambda5__gasync_ready_callback, scratch_services_search_project_ref (_data_->self));
			_g_free0 (_data_->_tmp24_);
			_g_free0 (_data_->_tmp21_);
			_data_->_tmp25_ = _data_->dir;
			_data_->_tmp26_ = g_dir_read_name (_data_->_tmp25_);
			_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
			_g_free0 (_data_->name);
			_data_->name = _data_->_tmp27_;
			_g_free0 (_data_->new_search_path);
		}
		_g_free0 (_data_->name);
		_g_dir_close0 (_data_->dir);
		_g_free0 (_data_->path_basename);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		if (scratch_services_search_project_check_if_valid_path_to_add (_data_->self, _data_->path)) {
			_data_->_tmp28_ = _data_->self->priv->_root_path;
			_data_->_tmp29_ = string_replace (_data_->path, _data_->_tmp28_, "");
			_data_->subpath = _data_->_tmp29_;
			_data_->_tmp30_ = _data_->self->priv->_relative_file_paths;
			_data_->_tmp31_ = _data_->subpath;
			_data_->_tmp32_ = _data_->subpath;
			_data_->_tmp33_ = strlen (_data_->_tmp32_);
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = string_substring (_data_->_tmp31_, (glong) 1, (glong) (_data_->_tmp34_ - 1));
			_data_->_tmp36_ = _data_->_tmp35_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp30_, _data_->_tmp36_);
			_g_free0 (_data_->_tmp36_);
			_g_free0 (_data_->subpath);
		}
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
scratch_services_search_project_check_if_valid_path_to_add (ScratchServicesSearchProject* self,
                                                            const gchar* path)
{
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFileInfo* file_info = NULL;
		GFileInfo* _tmp1_;
		_tmp0_ = g_file_new_for_path (path);
		file = _tmp0_;
		_tmp1_ = g_file_query_info (file, "standard::*", 0, NULL, &_inner_error0_);
		file_info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		result = scratch_utils_check_if_valid_text_file (path, file_info);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp2_;
}

const gchar*
scratch_services_search_project_get_root_path (ScratchServicesSearchProject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root_path;
	result = _tmp0_;
	return result;
}

static void
scratch_services_search_project_set_root_path (ScratchServicesSearchProject* self,
                                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_root_path);
	self->priv->_root_path = _tmp0_;
}

GeeHashSet*
scratch_services_search_project_get_relative_file_paths (ScratchServicesSearchProject* self)
{
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_relative_file_paths;
	result = _tmp0_;
	return result;
}

static void
scratch_services_search_project_set_relative_file_paths (ScratchServicesSearchProject* self,
                                                         GeeHashSet* value)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_relative_file_paths);
	self->priv->_relative_file_paths = _tmp0_;
}

static void
scratch_services_value_search_project_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
scratch_services_value_search_project_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		scratch_services_search_project_unref (value->data[0].v_pointer);
	}
}

static void
scratch_services_value_search_project_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scratch_services_search_project_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
scratch_services_value_search_project_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
scratch_services_value_search_project_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ScratchServicesSearchProject * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scratch_services_search_project_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
scratch_services_value_search_project_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	ScratchServicesSearchProject ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scratch_services_search_project_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
scratch_services_param_spec_search_project (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	ScratchServicesParamSpecSearchProject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
scratch_services_value_get_search_project (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT), NULL);
	return value->data[0].v_pointer;
}

void
scratch_services_value_set_search_project (GValue* value,
                                           gpointer v_object)
{
	ScratchServicesSearchProject * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scratch_services_search_project_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scratch_services_search_project_unref (old);
	}
}

void
scratch_services_value_take_search_project (GValue* value,
                                            gpointer v_object)
{
	ScratchServicesSearchProject * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scratch_services_search_project_unref (old);
	}
}

static void
scratch_services_search_project_class_init (ScratchServicesSearchProjectClass * klass,
                                            gpointer klass_data)
{
	scratch_services_search_project_parent_class = g_type_class_peek_parent (klass);
	((ScratchServicesSearchProjectClass *) klass)->finalize = scratch_services_search_project_finalize;
	g_type_class_adjust_private_offset (klass, &ScratchServicesSearchProject_private_offset);
}

static void
scratch_services_search_project_instance_init (ScratchServicesSearchProject * self,
                                               gpointer klass)
{
	self->priv = scratch_services_search_project_get_instance_private (self);
	self->ref_count = 1;
}

static void
scratch_services_search_project_finalize (ScratchServicesSearchProject * obj)
{
	ScratchServicesSearchProject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_SEARCH_PROJECT, ScratchServicesSearchProject);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_root_path);
	_g_object_unref0 (self->priv->_relative_file_paths);
	_g_object_unref0 (self->priv->monitored_repo);
}

GType
scratch_services_search_project_get_type (void)
{
	return scratch_services_search_project_type_id;
}

GType
scratch_services_search_project_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { scratch_services_value_search_project_init, scratch_services_value_search_project_free_value, scratch_services_value_search_project_copy_value, scratch_services_value_search_project_peek_pointer, "p", scratch_services_value_search_project_collect_value, "p", scratch_services_value_search_project_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesSearchProjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_search_project_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesSearchProject), 0, (GInstanceInitFunc) scratch_services_search_project_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	scratch_services_search_project_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScratchServicesSearchProject", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ScratchServicesSearchProject_private_offset = sizeof (ScratchServicesSearchProjectPrivate);
	return scratch_services_search_project_type_id;
}

gpointer
scratch_services_search_project_ref (gpointer instance)
{
	ScratchServicesSearchProject * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
scratch_services_search_project_unref (gpointer instance)
{
	ScratchServicesSearchProject * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCRATCH_SERVICES_SEARCH_PROJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

