/* Thumbnailer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Thumbnailer.vala, do not modify */

/***
    Copyright (c) 2016-2018 elementary LLC <https://elementary.io>

    Largely transcribed from marlin-thumbnailer
    Copyright (c) 2009-2011 Jannis Pohlmann <jannis@xfce.org>
    Originaly Written in gtk+: gtkcellrendererpixbuf

    Pantheon Files is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Pantheon Files is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; see the Timeoutfile COPYING.  If not,
    write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1335 USA.

    Author(s):  Jeremy Wootten <jeremywootten@gmail.com>

***/

#include "pantheon-files-core.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_THUMBNAILER_DAEMON_STARTED_SIGNAL,
	FILES_THUMBNAILER_DAEMON_FINISHED_SIGNAL,
	FILES_THUMBNAILER_DAEMON_READY_SIGNAL,
	FILES_THUMBNAILER_DAEMON_ERROR_SIGNAL,
	FILES_THUMBNAILER_DAEMON_NUM_SIGNALS
};
static guint files_thumbnailer_daemon_signals[FILES_THUMBNAILER_DAEMON_NUM_SIGNALS] = {0};
typedef GDBusProxy FilesThumbnailerDaemonProxy;
typedef GDBusProxyClass FilesThumbnailerDaemonProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FilesThumbnailerDaemonQueueReadyData FilesThumbnailerDaemonQueueReadyData;
typedef struct _FilesThumbnailerDaemonDequeueReadyData FilesThumbnailerDaemonDequeueReadyData;
enum  {
	FILES_THUMBNAILER_0_PROPERTY,
	FILES_THUMBNAILER_NUM_PROPERTIES
};
static GParamSpec* files_thumbnailer_properties[FILES_THUMBNAILER_NUM_PROPERTIES];

#define FILES_THUMBNAILER_TYPE_IDLE (files_thumbnailer_idle_get_type ())
typedef struct _FilesThumbnailerIdle FilesThumbnailerIdle;
typedef enum  {
	FILES_THUMBNAILER_IDLE_TYPE_ERROR,
	FILES_THUMBNAILER_IDLE_TYPE_READY,
	FILES_THUMBNAILER_IDLE_TYPE_STARTED,
	FILES_THUMBNAILER_IDLE_TYPE_FINISHED
} FilesThumbnailerIdleType;

#define FILES_THUMBNAILER_TYPE_IDLE_TYPE (files_thumbnailer_idle_type_get_type ())
#define _files_thumbnailer_idle_free0(var) ((var == NULL) ? NULL : (var = (files_thumbnailer_idle_free (var), NULL)))

#define FILES_THUMBNAILER_TYPE_URI_LIST (files_thumbnailer_uri_list_get_type ())
typedef struct _FilesThumbnailerUriList FilesThumbnailerUriList;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
enum  {
	FILES_THUMBNAILER_FINISHED_SIGNAL,
	FILES_THUMBNAILER_NUM_SIGNALS
};
static guint files_thumbnailer_signals[FILES_THUMBNAILER_NUM_SIGNALS] = {0};

struct _FilesThumbnailerDaemonQueueReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** uris;
	gint uris_length1;
	gchar** mime_types;
	gint mime_types_length1;
	gchar* flavor;
	gchar* scheduler;
	guint handle_to_unqueue;
};

struct _FilesThumbnailerDaemonDequeueReadyData {
	GDBusMethodInvocation* _invocation_;
	guint handle;
};

struct _FilesThumbnailerPrivate {
	FilesThumbnailerDaemon* proxy;
	gchar** supported_schemes;
	gint supported_schemes_length1;
	gint _supported_schemes_size_;
	gchar** supported_types;
	gint supported_types_length1;
	gint _supported_types_size_;
	guint last_request;
};

struct _FilesThumbnailerIdle {
	guint id;
	FilesThumbnailerIdleType type;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	guint handle;
};

struct _FilesThumbnailerUriList {
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
};

struct _Block18Data {
	int _ref_count_;
	FilesThumbnailer* self;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	guint this_request;
	GList* files;
};

struct _Block19Data {
	int _ref_count_;
	FilesThumbnailerIdle idle;
};

struct _Block20Data {
	int _ref_count_;
	FilesThumbnailerIdle idle;
};

struct _Block21Data {
	int _ref_count_;
	FilesThumbnailerIdle idle;
};

static gint FilesThumbnailer_private_offset;
static gpointer files_thumbnailer_parent_class = NULL;
static GMutex files_thumbnailer_thumbnailer_lock;
static GList* files_thumbnailer_idles;
static FilesThumbnailer* files_thumbnailer_instance;
static FilesThumbnailer* files_thumbnailer_instance = NULL;
static GMutex files_thumbnailer_thumbnailer_lock = {0};
static GHashTable* files_thumbnailer_request_handle_mapping;
static GHashTable* files_thumbnailer_request_handle_mapping = NULL;
static GHashTable* files_thumbnailer_handle_request_mapping;
static GHashTable* files_thumbnailer_handle_request_mapping = NULL;
static GHashTable* files_thumbnailer_handle_uris_mapping;
static GHashTable* files_thumbnailer_handle_uris_mapping = NULL;
static GList* files_thumbnailer_idles = NULL;

static void g_cclosure_user_marshal_VOID__UINT_BOXED_INT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_BOXED_INT_INT_STRING (GClosure * closure,
                                                              GValue * return_value,
                                                              guint n_param_values,
                                                              const GValue * param_values,
                                                              gpointer invocation_hint,
                                                              gpointer marshal_data);
static GType files_thumbnailer_daemon_get_type_once (void);
static void files_thumbnailer_daemon_proxy_g_signal (GDBusProxy* proxy,
                                              const gchar* sender_name,
                                              const gchar* signal_name,
                                              GVariant* parameters);
static void _dbus_handle_files_thumbnailer_daemon_started (FilesThumbnailerDaemon* self,
                                                    GVariant* parameters);
static void _dbus_handle_files_thumbnailer_daemon_finished (FilesThumbnailerDaemon* self,
                                                     GVariant* parameters);
static void _dbus_handle_files_thumbnailer_daemon_ready (FilesThumbnailerDaemon* self,
                                                  GVariant* parameters);
static void _dbus_handle_files_thumbnailer_daemon_error (FilesThumbnailerDaemon* self,
                                                  GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void files_thumbnailer_daemon_proxy_queue_async (FilesThumbnailerDaemon* self,
                                                 gchar** uris,
                                                 gint uris_length1,
                                                 gchar** mime_types,
                                                 gint mime_types_length1,
                                                 const gchar* flavor,
                                                 const gchar* scheduler,
                                                 guint handle_to_unqueue,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static guint files_thumbnailer_daemon_proxy_queue_finish (FilesThumbnailerDaemon* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static void files_thumbnailer_daemon_proxy_dequeue_async (FilesThumbnailerDaemon* self,
                                                   guint handle,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void files_thumbnailer_daemon_proxy_dequeue_finish (FilesThumbnailerDaemon* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void files_thumbnailer_daemon_proxy_get_supported (FilesThumbnailerDaemon* self,
                                                   gchar*** uri_schemes,
                                                   gint* uri_schemes_length1,
                                                   gchar*** mime_types,
                                                   gint* mime_types_length1,
                                                   GError** error);
static void files_thumbnailer_daemon_proxy_files_thumbnailer_daemon_interface_init (FilesThumbnailerDaemonIface* iface);
static void _dbus_files_thumbnailer_daemon_queue (FilesThumbnailerDaemon* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_files_thumbnailer_daemon_queue_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_);
static void _dbus_files_thumbnailer_daemon_dequeue (FilesThumbnailerDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_files_thumbnailer_daemon_dequeue_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_);
static void _dbus_files_thumbnailer_daemon_get_supported (FilesThumbnailerDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void files_thumbnailer_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* files_thumbnailer_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static gboolean files_thumbnailer_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _dbus_files_thumbnailer_daemon_started (GObject* _sender,
                                             guint handle,
                                             gpointer* _data);
static void _dbus_files_thumbnailer_daemon_finished (GObject* _sender,
                                              guint handle,
                                              gpointer* _data);
static void _dbus_files_thumbnailer_daemon_ready (GObject* _sender,
                                           guint handle,
                                           gchar** uris,
                                           gint uris_length1,
                                           gpointer* _data);
static void _dbus_files_thumbnailer_daemon_error (GObject* _sender,
                                           guint handle,
                                           gchar** failed_uris,
                                           gint failed_uris_length1,
                                           gint error_code,
                                           const gchar* message,
                                           gpointer* _data);
static void _files_thumbnailer_daemon_unregister_object (gpointer user_data);
static GType files_thumbnailer_idle_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType files_thumbnailer_idle_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static FilesThumbnailerIdle* files_thumbnailer_idle_dup (const FilesThumbnailerIdle* self);
static void files_thumbnailer_idle_free (FilesThumbnailerIdle* self);
static void files_thumbnailer_idle_copy (const FilesThumbnailerIdle* self,
                                  FilesThumbnailerIdle* dest);
static void files_thumbnailer_idle_destroy (FilesThumbnailerIdle* self);
static GType files_thumbnailer_uri_list_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static FilesThumbnailerUriList* files_thumbnailer_uri_list_dup (const FilesThumbnailerUriList* self);
static void files_thumbnailer_uri_list_free (FilesThumbnailerUriList* self);
static void files_thumbnailer_uri_list_copy (const FilesThumbnailerUriList* self,
                                      FilesThumbnailerUriList* dest);
static void files_thumbnailer_uri_list_destroy (FilesThumbnailerUriList* self);
static FilesThumbnailer* files_thumbnailer_new (void);
static FilesThumbnailer* files_thumbnailer_construct (GType object_type);
static void files_thumbnailer_init (FilesThumbnailer* self);
static void files_thumbnailer_on_proxy_started (guint handle);
static void _files_thumbnailer_on_proxy_started_files_thumbnailer_daemon_started (FilesThumbnailerDaemon* _sender,
                                                                           guint handle,
                                                                           gpointer self);
static void files_thumbnailer_on_proxy_finished (guint handle);
static void _files_thumbnailer_on_proxy_finished_files_thumbnailer_daemon_finished (FilesThumbnailerDaemon* _sender,
                                                                             guint handle,
                                                                             gpointer self);
static void files_thumbnailer_on_proxy_ready (guint handle,
                                       gchar** ready_uris,
                                       gint ready_uris_length1);
static void _files_thumbnailer_on_proxy_ready_files_thumbnailer_daemon_ready (FilesThumbnailerDaemon* _sender,
                                                                       guint handle,
                                                                       gchar** uris,
                                                                       gint uris_length1,
                                                                       gpointer self);
static void files_thumbnailer_on_proxy_error (guint handle,
                                       gchar** failed_uris,
                                       gint failed_uris_length1,
                                       gint error_code,
                                       const gchar* msg);
static void _files_thumbnailer_on_proxy_error_files_thumbnailer_daemon_error (FilesThumbnailerDaemon* _sender,
                                                                       guint handle,
                                                                       gchar** failed_uris,
                                                                       gint failed_uris_length1,
                                                                       gint error_code,
                                                                       const gchar* message,
                                                                       gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static gboolean files_thumbnailer_is_supported (FilesThumbnailer* self,
                                         FilesFile* file);
static void __lambda39_ (Block18Data* _data18_,
                  GObject* obj,
                  GAsyncResult* res);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void ___lambda39__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static gboolean __lambda38_ (Block19Data* _data19_);
static void files_thumbnailer_handle_error_idle (FilesThumbnailerIdle* error_idle);
static gboolean ___lambda38__gsource_func (gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static gboolean ___lambda37_ (Block20Data* _data20_);
static void files_thumbnailer_handle_ready_idle (FilesThumbnailerIdle* ready_idle);
static gboolean ____lambda37__gsource_func (gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gboolean __lambda36_ (Block21Data* _data21_);
static void files_thumbnailer_handle_finished_idle (FilesThumbnailerIdle* finished_idle);
static gboolean ___lambda36__gsource_func (gpointer self);
static void files_thumbnailer_update_file_thumbstate (const gchar* uri,
                                               FilesFileThumbState state);
static void _files_thumbnailer_idle_free0_ (gpointer var);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void files_thumbnailer_finalize (GObject * obj);
static GType files_thumbnailer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_queue_uris = {-1, "uris", "as", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_queue_mime_types = {-1, "mime_types", "as", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_queue_flavor = {-1, "flavor", "s", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_queue_scheduler = {-1, "scheduler", "s", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_queue_handle_to_unqueue = {-1, "handle_to_unqueue", "u", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_queue_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_queue_in[] = {&_files_thumbnailer_daemon_dbus_arg_info_queue_uris, &_files_thumbnailer_daemon_dbus_arg_info_queue_mime_types, &_files_thumbnailer_daemon_dbus_arg_info_queue_flavor, &_files_thumbnailer_daemon_dbus_arg_info_queue_scheduler, &_files_thumbnailer_daemon_dbus_arg_info_queue_handle_to_unqueue, NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_queue_out[] = {&_files_thumbnailer_daemon_dbus_arg_info_queue_result, NULL};
static const GDBusMethodInfo _files_thumbnailer_daemon_dbus_method_info_queue = {-1, "Queue", (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_queue_in), (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_queue_out), NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_dequeue_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_dequeue_in[] = {&_files_thumbnailer_daemon_dbus_arg_info_dequeue_handle, NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_dequeue_out[] = {NULL};
static const GDBusMethodInfo _files_thumbnailer_daemon_dbus_method_info_dequeue = {-1, "Dequeue", (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_dequeue_in), (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_dequeue_out), NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_get_supported_uri_schemes = {-1, "uri_schemes", "as", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_get_supported_mime_types = {-1, "mime_types", "as", NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_get_supported_in[] = {NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_get_supported_out[] = {&_files_thumbnailer_daemon_dbus_arg_info_get_supported_uri_schemes, &_files_thumbnailer_daemon_dbus_arg_info_get_supported_mime_types, NULL};
static const GDBusMethodInfo _files_thumbnailer_daemon_dbus_method_info_get_supported = {-1, "GetSupported", (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_get_supported_in), (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_get_supported_out), NULL};
static const GDBusMethodInfo * const _files_thumbnailer_daemon_dbus_method_info[] = {&_files_thumbnailer_daemon_dbus_method_info_queue, &_files_thumbnailer_daemon_dbus_method_info_dequeue, &_files_thumbnailer_daemon_dbus_method_info_get_supported, NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_started_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_started[] = {&_files_thumbnailer_daemon_dbus_arg_info_started_handle, NULL};
static const GDBusSignalInfo _files_thumbnailer_daemon_dbus_signal_info_started = {-1, "Started", (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_started), NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_finished_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_finished[] = {&_files_thumbnailer_daemon_dbus_arg_info_finished_handle, NULL};
static const GDBusSignalInfo _files_thumbnailer_daemon_dbus_signal_info_finished = {-1, "Finished", (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_finished), NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_ready_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_ready_uris = {-1, "uris", "as", NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_ready[] = {&_files_thumbnailer_daemon_dbus_arg_info_ready_handle, &_files_thumbnailer_daemon_dbus_arg_info_ready_uris, NULL};
static const GDBusSignalInfo _files_thumbnailer_daemon_dbus_signal_info_ready = {-1, "Ready", (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_ready), NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_error_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_error_failed_uris = {-1, "failed_uris", "as", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_error_error_code = {-1, "error_code", "i", NULL};
static const GDBusArgInfo _files_thumbnailer_daemon_dbus_arg_info_error_message = {-1, "message", "s", NULL};
static const GDBusArgInfo * const _files_thumbnailer_daemon_dbus_arg_info_error[] = {&_files_thumbnailer_daemon_dbus_arg_info_error_handle, &_files_thumbnailer_daemon_dbus_arg_info_error_failed_uris, &_files_thumbnailer_daemon_dbus_arg_info_error_error_code, &_files_thumbnailer_daemon_dbus_arg_info_error_message, NULL};
static const GDBusSignalInfo _files_thumbnailer_daemon_dbus_signal_info_error = {-1, "Error", (GDBusArgInfo **) (&_files_thumbnailer_daemon_dbus_arg_info_error), NULL};
static const GDBusSignalInfo * const _files_thumbnailer_daemon_dbus_signal_info[] = {&_files_thumbnailer_daemon_dbus_signal_info_started, &_files_thumbnailer_daemon_dbus_signal_info_finished, &_files_thumbnailer_daemon_dbus_signal_info_ready, &_files_thumbnailer_daemon_dbus_signal_info_error, NULL};
static const GDBusPropertyInfo * const _files_thumbnailer_daemon_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _files_thumbnailer_daemon_dbus_interface_info = {-1, "org.freedesktop.thumbnails.Thumbnailer1", (GDBusMethodInfo **) (&_files_thumbnailer_daemon_dbus_method_info), (GDBusSignalInfo **) (&_files_thumbnailer_daemon_dbus_signal_info), (GDBusPropertyInfo **) (&_files_thumbnailer_daemon_dbus_property_info), NULL};
static const GDBusInterfaceVTable _files_thumbnailer_daemon_dbus_interface_vtable = {files_thumbnailer_daemon_dbus_interface_method_call, files_thumbnailer_daemon_dbus_interface_get_property, files_thumbnailer_daemon_dbus_interface_set_property};

void
files_thumbnailer_daemon_queue (FilesThumbnailerDaemon* self,
                                gchar** uris,
                                gint uris_length1,
                                gchar** mime_types,
                                gint mime_types_length1,
                                const gchar* flavor,
                                const gchar* scheduler,
                                guint handle_to_unqueue,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	FilesThumbnailerDaemonIface* _iface_;
	_iface_ = FILES_THUMBNAILER_DAEMON_GET_INTERFACE (self);
	if (_iface_->queue) {
		_iface_->queue (self, uris, uris_length1, mime_types, mime_types_length1, flavor, scheduler, handle_to_unqueue, _callback_, _user_data_);
	}
}

guint
files_thumbnailer_daemon_queue_finish (FilesThumbnailerDaemon* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	FilesThumbnailerDaemonIface* _iface_;
	_iface_ = FILES_THUMBNAILER_DAEMON_GET_INTERFACE (self);
	if (_iface_->queue_finish) {
		return _iface_->queue_finish (self, _res_, error);
	}
	return 0U;
}

void
files_thumbnailer_daemon_dequeue (FilesThumbnailerDaemon* self,
                                  guint handle,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	FilesThumbnailerDaemonIface* _iface_;
	_iface_ = FILES_THUMBNAILER_DAEMON_GET_INTERFACE (self);
	if (_iface_->dequeue) {
		_iface_->dequeue (self, handle, _callback_, _user_data_);
	}
}

void
files_thumbnailer_daemon_dequeue_finish (FilesThumbnailerDaemon* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	FilesThumbnailerDaemonIface* _iface_;
	_iface_ = FILES_THUMBNAILER_DAEMON_GET_INTERFACE (self);
	if (_iface_->dequeue_finish) {
		_iface_->dequeue_finish (self, _res_, error);
	}
}

void
files_thumbnailer_daemon_get_supported (FilesThumbnailerDaemon* self,
                                        gchar*** uri_schemes,
                                        gint* uri_schemes_length1,
                                        gchar*** mime_types,
                                        gint* mime_types_length1,
                                        GError** error)
{
	FilesThumbnailerDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FILES_THUMBNAILER_DAEMON_GET_INTERFACE (self);
	if (_iface_->get_supported) {
		_iface_->get_supported (self, uri_schemes, uri_schemes_length1, mime_types, mime_types_length1, error);
	}
}

static void
g_cclosure_user_marshal_VOID__UINT_BOXED_INT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_BOXED_INT) (gpointer data1, guint arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_VOID__UINT_BOXED_INT_INT_STRING (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_BOXED_INT_INT_STRING) (gpointer data1, guint arg_1, gpointer arg_2, gint arg_3, gint arg_4, const char* arg_5, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED_INT_INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED_INT_INT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), g_value_get_string (param_values + 5), data2);
}

static void
files_thumbnailer_daemon_default_init (FilesThumbnailerDaemonIface * iface,
                                       gpointer iface_data)
{
	files_thumbnailer_daemon_signals[FILES_THUMBNAILER_DAEMON_STARTED_SIGNAL] = g_signal_new ("started", FILES_TYPE_THUMBNAILER_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	files_thumbnailer_daemon_signals[FILES_THUMBNAILER_DAEMON_FINISHED_SIGNAL] = g_signal_new ("finished", FILES_TYPE_THUMBNAILER_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	files_thumbnailer_daemon_signals[FILES_THUMBNAILER_DAEMON_READY_SIGNAL] = g_signal_new ("ready", FILES_TYPE_THUMBNAILER_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED_INT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_STRV, G_TYPE_INT);
	files_thumbnailer_daemon_signals[FILES_THUMBNAILER_DAEMON_ERROR_SIGNAL] = g_signal_new ("error", FILES_TYPE_THUMBNAILER_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED_INT_INT_STRING, G_TYPE_NONE, 5, G_TYPE_UINT, G_TYPE_STRV, G_TYPE_INT, G_TYPE_INT, G_TYPE_STRING);
}

 G_GNUC_NO_INLINE static GType
files_thumbnailer_daemon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesThumbnailerDaemonIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_thumbnailer_daemon_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType files_thumbnailer_daemon_type_id;
	files_thumbnailer_daemon_type_id = g_type_register_static (G_TYPE_INTERFACE, "FilesThumbnailerDaemon", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (files_thumbnailer_daemon_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (files_thumbnailer_daemon_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) files_thumbnailer_daemon_proxy_get_type);
	g_type_set_qdata (files_thumbnailer_daemon_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.thumbnails.Thumbnailer1");
	g_type_set_qdata (files_thumbnailer_daemon_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_files_thumbnailer_daemon_dbus_interface_info));
	g_type_set_qdata (files_thumbnailer_daemon_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) files_thumbnailer_daemon_register_object);
	return files_thumbnailer_daemon_type_id;
}

GType
files_thumbnailer_daemon_get_type (void)
{
	static volatile gsize files_thumbnailer_daemon_type_id__once = 0;
	if (g_once_init_enter (&files_thumbnailer_daemon_type_id__once)) {
		GType files_thumbnailer_daemon_type_id;
		files_thumbnailer_daemon_type_id = files_thumbnailer_daemon_get_type_once ();
		g_once_init_leave (&files_thumbnailer_daemon_type_id__once, files_thumbnailer_daemon_type_id);
	}
	return files_thumbnailer_daemon_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (FilesThumbnailerDaemonProxy, files_thumbnailer_daemon_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (FILES_TYPE_THUMBNAILER_DAEMON, files_thumbnailer_daemon_proxy_files_thumbnailer_daemon_interface_init) )
static void
files_thumbnailer_daemon_proxy_class_init (FilesThumbnailerDaemonProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = files_thumbnailer_daemon_proxy_g_signal;
}

static void
_dbus_handle_files_thumbnailer_daemon_started (FilesThumbnailerDaemon* self,
                                               GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint handle = 0U;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	handle = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "started", handle);
}

static void
_dbus_handle_files_thumbnailer_daemon_finished (FilesThumbnailerDaemon* self,
                                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint handle = 0U;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	handle = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "finished", handle);
}

static void
_dbus_handle_files_thumbnailer_daemon_ready (FilesThumbnailerDaemon* self,
                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint handle = 0U;
	GVariant* _tmp2_;
	gchar** uris = NULL;
	gint uris_length1;
	GVariant* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length;
	gint _tmp4__size;
	gint _tmp4__length1;
	GVariantIter _tmp5_;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	handle = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	uris_length1 = 0;
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp4_ = g_new (gchar*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
	g_variant_iter_init (&_tmp5_, _tmp3_);
	for (; (_tmp6_ = g_variant_iter_next_value (&_tmp5_)) != NULL; _tmp4__length1++) {
		if (_tmp4__size == _tmp4__length) {
			_tmp4__size = 2 * _tmp4__size;
			_tmp4_ = g_renew (gchar*, _tmp4_, _tmp4__size + 1);
		}
		_tmp4_[_tmp4__length++] = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
	}
	uris_length1 = _tmp4__length1;
	_tmp4_[_tmp4__length] = NULL;
	uris = _tmp4_;
	g_variant_unref (_tmp3_);
	g_signal_emit_by_name (self, "ready", handle, uris, uris_length1);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}

static void
_dbus_handle_files_thumbnailer_daemon_error (FilesThumbnailerDaemon* self,
                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint handle = 0U;
	GVariant* _tmp7_;
	gchar** failed_uris = NULL;
	gint failed_uris_length1;
	GVariant* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length;
	gint _tmp9__size;
	gint _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	gint error_code = 0;
	GVariant* _tmp12_;
	gchar* message = NULL;
	GVariant* _tmp13_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	handle = g_variant_get_uint32 (_tmp7_);
	g_variant_unref (_tmp7_);
	failed_uris_length1 = 0;
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (gchar*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (gchar*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_dup_string (_tmp11_, NULL);
		g_variant_unref (_tmp11_);
	}
	failed_uris_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	failed_uris = _tmp9_;
	g_variant_unref (_tmp8_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	error_code = g_variant_get_int32 (_tmp12_);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	message = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	g_signal_emit_by_name (self, "error", handle, failed_uris, failed_uris_length1, error_code, message);
	failed_uris = (_vala_array_free (failed_uris, failed_uris_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (message);
}

static void
files_thumbnailer_daemon_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters)
{
	if (strcmp (signal_name, "Started") == 0) {
		_dbus_handle_files_thumbnailer_daemon_started ((FilesThumbnailerDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "Finished") == 0) {
		_dbus_handle_files_thumbnailer_daemon_finished ((FilesThumbnailerDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "Ready") == 0) {
		_dbus_handle_files_thumbnailer_daemon_ready ((FilesThumbnailerDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "Error") == 0) {
		_dbus_handle_files_thumbnailer_daemon_error ((FilesThumbnailerDaemon*) proxy, parameters);
	}
}

static void
files_thumbnailer_daemon_proxy_init (FilesThumbnailerDaemonProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_files_thumbnailer_daemon_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
files_thumbnailer_daemon_proxy_queue_async (FilesThumbnailerDaemon* self,
                                            gchar** uris,
                                            gint uris_length1,
                                            gchar** mime_types,
                                            gint mime_types_length1,
                                            const gchar* flavor,
                                            const gchar* scheduler,
                                            guint handle_to_unqueue,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp14_;
	GVariantBuilder _tmp15_;
	gint _tmp16_;
	gchar** _tmp17_;
	GVariantBuilder _tmp18_;
	gint _tmp19_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.thumbnails.Thumbnailer1", "Queue");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp14_ = uris;
	g_variant_builder_init (&_tmp15_, G_VARIANT_TYPE ("as"));
	for (_tmp16_ = 0; _tmp16_ < uris_length1; _tmp16_++) {
		g_variant_builder_add_value (&_tmp15_, g_variant_new_string (*_tmp14_));
		_tmp14_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp15_));
	_tmp17_ = mime_types;
	g_variant_builder_init (&_tmp18_, G_VARIANT_TYPE ("as"));
	for (_tmp19_ = 0; _tmp19_ < mime_types_length1; _tmp19_++) {
		g_variant_builder_add_value (&_tmp18_, g_variant_new_string (*_tmp17_));
		_tmp17_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp18_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (flavor));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (scheduler));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle_to_unqueue));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static guint
files_thumbnailer_daemon_proxy_queue_finish (FilesThumbnailerDaemon* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _result = 0U;
	GVariant* _tmp22_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		guint _tmp20_ = 0U;
		return _tmp20_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint _tmp21_ = 0U;
		g_object_unref (_reply_message);
		return _tmp21_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp22_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp22_);
	g_variant_unref (_tmp22_);
	g_object_unref (_reply_message);
	return _result;
}

static void
files_thumbnailer_daemon_proxy_dequeue_async (FilesThumbnailerDaemon* self,
                                              guint handle,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.thumbnails.Thumbnailer1", "Dequeue");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
files_thumbnailer_daemon_proxy_dequeue_finish (FilesThumbnailerDaemon* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
files_thumbnailer_daemon_proxy_get_supported (FilesThumbnailerDaemon* self,
                                              gchar*** uri_schemes,
                                              gint* uri_schemes_length1,
                                              gchar*** mime_types,
                                              gint* mime_types_length1,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _vala_uri_schemes = NULL;
	gint _vala_uri_schemes_length1;
	GVariant* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length;
	gint _tmp24__size;
	gint _tmp24__length1;
	GVariantIter _tmp25_;
	GVariant* _tmp26_;
	gchar** _vala_mime_types = NULL;
	gint _vala_mime_types_length1;
	GVariant* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length;
	gint _tmp28__size;
	gint _tmp28__length1;
	GVariantIter _tmp29_;
	GVariant* _tmp30_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.thumbnails.Thumbnailer1", "GetSupported");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_uri_schemes_length1 = 0;
	_tmp23_ = g_variant_iter_next_value (&_reply_iter);
	_tmp24_ = g_new (gchar*, 5);
	_tmp24__length = 0;
	_tmp24__size = 4;
	_tmp24__length1 = 0;
	g_variant_iter_init (&_tmp25_, _tmp23_);
	for (; (_tmp26_ = g_variant_iter_next_value (&_tmp25_)) != NULL; _tmp24__length1++) {
		if (_tmp24__size == _tmp24__length) {
			_tmp24__size = 2 * _tmp24__size;
			_tmp24_ = g_renew (gchar*, _tmp24_, _tmp24__size + 1);
		}
		_tmp24_[_tmp24__length++] = g_variant_dup_string (_tmp26_, NULL);
		g_variant_unref (_tmp26_);
	}
	_vala_uri_schemes_length1 = _tmp24__length1;
	_tmp24_[_tmp24__length] = NULL;
	_vala_uri_schemes = _tmp24_;
	g_variant_unref (_tmp23_);
	*uri_schemes = _vala_uri_schemes;
	*uri_schemes_length1 = _vala_uri_schemes_length1;
	_vala_mime_types_length1 = 0;
	_tmp27_ = g_variant_iter_next_value (&_reply_iter);
	_tmp28_ = g_new (gchar*, 5);
	_tmp28__length = 0;
	_tmp28__size = 4;
	_tmp28__length1 = 0;
	g_variant_iter_init (&_tmp29_, _tmp27_);
	for (; (_tmp30_ = g_variant_iter_next_value (&_tmp29_)) != NULL; _tmp28__length1++) {
		if (_tmp28__size == _tmp28__length) {
			_tmp28__size = 2 * _tmp28__size;
			_tmp28_ = g_renew (gchar*, _tmp28_, _tmp28__size + 1);
		}
		_tmp28_[_tmp28__length++] = g_variant_dup_string (_tmp30_, NULL);
		g_variant_unref (_tmp30_);
	}
	_vala_mime_types_length1 = _tmp28__length1;
	_tmp28_[_tmp28__length] = NULL;
	_vala_mime_types = _tmp28_;
	g_variant_unref (_tmp27_);
	*mime_types = _vala_mime_types;
	*mime_types_length1 = _vala_mime_types_length1;
	g_object_unref (_reply_message);
}

static void
files_thumbnailer_daemon_proxy_files_thumbnailer_daemon_interface_init (FilesThumbnailerDaemonIface* iface)
{
	iface->queue = files_thumbnailer_daemon_proxy_queue_async;
	iface->queue_finish = files_thumbnailer_daemon_proxy_queue_finish;
	iface->dequeue = files_thumbnailer_daemon_proxy_dequeue_async;
	iface->dequeue_finish = files_thumbnailer_daemon_proxy_dequeue_finish;
	iface->get_supported = files_thumbnailer_daemon_proxy_get_supported;
}

static void
_dbus_files_thumbnailer_daemon_queue (FilesThumbnailerDaemon* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	FilesThumbnailerDaemonQueueReadyData* _ready_data;
	GVariant* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length;
	gint _tmp32__size;
	gint _tmp32__length1;
	GVariantIter _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length;
	gint _tmp36__size;
	gint _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	GVariant* _tmp39_;
	GVariant* _tmp40_;
	GVariant* _tmp41_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (FilesThumbnailerDaemonQueueReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp32_ = g_new (gchar*, 5);
	_tmp32__length = 0;
	_tmp32__size = 4;
	_tmp32__length1 = 0;
	g_variant_iter_init (&_tmp33_, _tmp31_);
	for (; (_tmp34_ = g_variant_iter_next_value (&_tmp33_)) != NULL; _tmp32__length1++) {
		if (_tmp32__size == _tmp32__length) {
			_tmp32__size = 2 * _tmp32__size;
			_tmp32_ = g_renew (gchar*, _tmp32_, _tmp32__size + 1);
		}
		_tmp32_[_tmp32__length++] = g_variant_dup_string (_tmp34_, NULL);
		g_variant_unref (_tmp34_);
	}
	_ready_data->uris_length1 = _tmp32__length1;
	_tmp32_[_tmp32__length] = NULL;
	_ready_data->uris = _tmp32_;
	g_variant_unref (_tmp31_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	_ready_data->mime_types_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	_ready_data->mime_types = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flavor = g_variant_dup_string (_tmp39_, NULL);
	g_variant_unref (_tmp39_);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->scheduler = g_variant_dup_string (_tmp40_, NULL);
	g_variant_unref (_tmp40_);
	_tmp41_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->handle_to_unqueue = g_variant_get_uint32 (_tmp41_);
	g_variant_unref (_tmp41_);
	files_thumbnailer_daemon_queue (self, _ready_data->uris, _ready_data->uris_length1, _ready_data->mime_types, _ready_data->mime_types_length1, _ready_data->flavor, _ready_data->scheduler, _ready_data->handle_to_unqueue, (GAsyncReadyCallback) _dbus_files_thumbnailer_daemon_queue_ready, _ready_data);
	_error:
	;
}

static void
_dbus_files_thumbnailer_daemon_queue_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_)
{
	FilesThumbnailerDaemonQueueReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = files_thumbnailer_daemon_queue_finish ((FilesThumbnailerDaemon*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->uris = (_vala_array_free (_ready_data->uris, _ready_data->uris_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->mime_types = (_vala_array_free (_ready_data->mime_types, _ready_data->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_ready_data->flavor);
	_g_free0 (_ready_data->scheduler);
	g_slice_free (FilesThumbnailerDaemonQueueReadyData, _ready_data);
}

static void
_dbus_files_thumbnailer_daemon_dequeue (FilesThumbnailerDaemon* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	FilesThumbnailerDaemonDequeueReadyData* _ready_data;
	GVariant* _tmp42_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (FilesThumbnailerDaemonDequeueReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp42_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->handle = g_variant_get_uint32 (_tmp42_);
	g_variant_unref (_tmp42_);
	files_thumbnailer_daemon_dequeue (self, _ready_data->handle, (GAsyncReadyCallback) _dbus_files_thumbnailer_daemon_dequeue_ready, _ready_data);
}

static void
_dbus_files_thumbnailer_daemon_dequeue_ready (GObject * source_object,
                                              GAsyncResult * _res_,
                                              gpointer _user_data_)
{
	FilesThumbnailerDaemonDequeueReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	files_thumbnailer_daemon_dequeue_finish ((FilesThumbnailerDaemon*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (FilesThumbnailerDaemonDequeueReadyData, _ready_data);
}

static void
_dbus_files_thumbnailer_daemon_get_supported (FilesThumbnailerDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** uri_schemes = NULL;
	gint uri_schemes_length1 = 0;
	gchar** _tmp43_;
	GVariantBuilder _tmp44_;
	gint _tmp45_;
	gchar** mime_types = NULL;
	gint mime_types_length1 = 0;
	gchar** _tmp46_;
	GVariantBuilder _tmp47_;
	gint _tmp48_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	files_thumbnailer_daemon_get_supported (self, &uri_schemes, &uri_schemes_length1, &mime_types, &mime_types_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp43_ = uri_schemes;
	g_variant_builder_init (&_tmp44_, G_VARIANT_TYPE ("as"));
	for (_tmp45_ = 0; _tmp45_ < uri_schemes_length1; _tmp45_++) {
		g_variant_builder_add_value (&_tmp44_, g_variant_new_string (*_tmp43_));
		_tmp43_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp44_));
	_tmp46_ = mime_types;
	g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE ("as"));
	for (_tmp48_ = 0; _tmp48_ < mime_types_length1; _tmp48_++) {
		g_variant_builder_add_value (&_tmp47_, g_variant_new_string (*_tmp46_));
		_tmp46_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp47_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	uri_schemes = (_vala_array_free (uri_schemes, uri_schemes_length1, (GDestroyNotify) g_free), NULL);
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
}

static void
files_thumbnailer_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Queue") == 0) {
		_dbus_files_thumbnailer_daemon_queue (object, parameters, invocation);
	} else if (strcmp (method_name, "Dequeue") == 0) {
		_dbus_files_thumbnailer_daemon_dequeue (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSupported") == 0) {
		_dbus_files_thumbnailer_daemon_get_supported (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
files_thumbnailer_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
files_thumbnailer_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_files_thumbnailer_daemon_started (GObject* _sender,
                                        guint handle,
                                        gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.thumbnails.Thumbnailer1", "Started", _arguments, NULL);
}

static void
_dbus_files_thumbnailer_daemon_finished (GObject* _sender,
                                         guint handle,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.thumbnails.Thumbnailer1", "Finished", _arguments, NULL);
}

static void
_dbus_files_thumbnailer_daemon_ready (GObject* _sender,
                                      guint handle,
                                      gchar** uris,
                                      gint uris_length1,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp49_;
	GVariantBuilder _tmp50_;
	gint _tmp51_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_tmp49_ = uris;
	g_variant_builder_init (&_tmp50_, G_VARIANT_TYPE ("as"));
	for (_tmp51_ = 0; _tmp51_ < uris_length1; _tmp51_++) {
		g_variant_builder_add_value (&_tmp50_, g_variant_new_string (*_tmp49_));
		_tmp49_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp50_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.thumbnails.Thumbnailer1", "Ready", _arguments, NULL);
}

static void
_dbus_files_thumbnailer_daemon_error (GObject* _sender,
                                      guint handle,
                                      gchar** failed_uris,
                                      gint failed_uris_length1,
                                      gint error_code,
                                      const gchar* message,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp52_;
	GVariantBuilder _tmp53_;
	gint _tmp54_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_tmp52_ = failed_uris;
	g_variant_builder_init (&_tmp53_, G_VARIANT_TYPE ("as"));
	for (_tmp54_ = 0; _tmp54_ < failed_uris_length1; _tmp54_++) {
		g_variant_builder_add_value (&_tmp53_, g_variant_new_string (*_tmp52_));
		_tmp52_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp53_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (error_code));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (message));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.thumbnails.Thumbnailer1", "Error", _arguments, NULL);
}

guint
files_thumbnailer_daemon_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_files_thumbnailer_daemon_dbus_interface_info), &_files_thumbnailer_daemon_dbus_interface_vtable, data, _files_thumbnailer_daemon_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "started", (GCallback) _dbus_files_thumbnailer_daemon_started, data);
	g_signal_connect (object, "finished", (GCallback) _dbus_files_thumbnailer_daemon_finished, data);
	g_signal_connect (object, "ready", (GCallback) _dbus_files_thumbnailer_daemon_ready, data);
	g_signal_connect (object, "error", (GCallback) _dbus_files_thumbnailer_daemon_error, data);
	return result;
}

static void
_files_thumbnailer_daemon_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_files_thumbnailer_daemon_started, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_files_thumbnailer_daemon_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_files_thumbnailer_daemon_ready, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_files_thumbnailer_daemon_error, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
files_thumbnailer_get_instance_private (FilesThumbnailer* self)
{
	return G_STRUCT_MEMBER_P (self, FilesThumbnailer_private_offset);
}

static gpointer
_files_thumbnailer_idle_dup0 (gpointer self)
{
	return self ? files_thumbnailer_idle_dup (self) : NULL;
}

 G_GNUC_NO_INLINE static GType
files_thumbnailer_idle_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_THUMBNAILER_IDLE_TYPE_ERROR, "FILES_THUMBNAILER_IDLE_TYPE_ERROR", "error"}, {FILES_THUMBNAILER_IDLE_TYPE_READY, "FILES_THUMBNAILER_IDLE_TYPE_READY", "ready"}, {FILES_THUMBNAILER_IDLE_TYPE_STARTED, "FILES_THUMBNAILER_IDLE_TYPE_STARTED", "started"}, {FILES_THUMBNAILER_IDLE_TYPE_FINISHED, "FILES_THUMBNAILER_IDLE_TYPE_FINISHED", "finished"}, {0, NULL, NULL}};
	GType files_thumbnailer_idle_type_type_id;
	files_thumbnailer_idle_type_type_id = g_enum_register_static ("FilesThumbnailerIdleType", values);
	return files_thumbnailer_idle_type_type_id;
}

static GType
files_thumbnailer_idle_type_get_type (void)
{
	static volatile gsize files_thumbnailer_idle_type_type_id__once = 0;
	if (g_once_init_enter (&files_thumbnailer_idle_type_type_id__once)) {
		GType files_thumbnailer_idle_type_type_id;
		files_thumbnailer_idle_type_type_id = files_thumbnailer_idle_type_get_type_once ();
		g_once_init_leave (&files_thumbnailer_idle_type_type_id__once, files_thumbnailer_idle_type_type_id);
	}
	return files_thumbnailer_idle_type_type_id__once;
}

static FilesThumbnailer*
files_thumbnailer_construct (GType object_type)
{
	FilesThumbnailer * self = NULL;
	GHashTable* _tmp0_;
	self = (FilesThumbnailer*) g_object_new (object_type, NULL);
	_tmp0_ = files_thumbnailer_request_handle_mapping;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		GHashFunc _tmp4_;
		GEqualFunc _tmp5_;
		GHashTable* _tmp6_;
		GHashFunc _tmp7_;
		GEqualFunc _tmp8_;
		GHashTable* _tmp9_;
		_tmp1_ = g_direct_hash;
		_tmp2_ = g_direct_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, NULL);
		_g_hash_table_unref0 (files_thumbnailer_request_handle_mapping);
		files_thumbnailer_request_handle_mapping = _tmp3_;
		_tmp4_ = g_direct_hash;
		_tmp5_ = g_direct_equal;
		_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, NULL, NULL);
		_g_hash_table_unref0 (files_thumbnailer_handle_request_mapping);
		files_thumbnailer_handle_request_mapping = _tmp6_;
		_tmp7_ = g_direct_hash;
		_tmp8_ = g_direct_equal;
		_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, NULL);
		_g_hash_table_unref0 (files_thumbnailer_handle_uris_mapping);
		files_thumbnailer_handle_uris_mapping = _tmp9_;
		_vala_clear_GMutex (&files_thumbnailer_thumbnailer_lock);
		g_mutex_init (&files_thumbnailer_thumbnailer_lock);
	}
	return self;
}

static FilesThumbnailer*
files_thumbnailer_new (void)
{
	return files_thumbnailer_construct (FILES_TYPE_THUMBNAILER);
}

static void
_files_thumbnailer_on_proxy_started_files_thumbnailer_daemon_started (FilesThumbnailerDaemon* _sender,
                                                                      guint handle,
                                                                      gpointer self)
{
	files_thumbnailer_on_proxy_started (handle);
}

static void
_files_thumbnailer_on_proxy_finished_files_thumbnailer_daemon_finished (FilesThumbnailerDaemon* _sender,
                                                                        guint handle,
                                                                        gpointer self)
{
	files_thumbnailer_on_proxy_finished (handle);
}

static void
_files_thumbnailer_on_proxy_ready_files_thumbnailer_daemon_ready (FilesThumbnailerDaemon* _sender,
                                                                  guint handle,
                                                                  gchar** uris,
                                                                  gint uris_length1,
                                                                  gpointer self)
{
	files_thumbnailer_on_proxy_ready (handle, uris, uris_length1);
}

static void
_files_thumbnailer_on_proxy_error_files_thumbnailer_daemon_error (FilesThumbnailerDaemon* _sender,
                                                                  guint handle,
                                                                  gchar** failed_uris,
                                                                  gint failed_uris_length1,
                                                                  gint error_code,
                                                                  const gchar* message,
                                                                  gpointer self)
{
	files_thumbnailer_on_proxy_error (handle, failed_uris, failed_uris_length1, error_code, message);
}

static void
files_thumbnailer_init (FilesThumbnailer* self)
{
	FilesThumbnailerDaemon* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy;
	if (_tmp0_ == NULL) {
		FilesThumbnailerDaemon* _tmp6_;
		{
			FilesThumbnailerDaemon* _tmp1_ = NULL;
			FilesThumbnailerDaemon* _tmp2_;
			FilesThumbnailerDaemon* _tmp3_;
			_tmp2_ = (FilesThumbnailerDaemon*) g_initable_new (FILES_TYPE_THUMBNAILER_DAEMON_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.thumbnails.Thumbnailer1", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/thumbnails/Thumbnailer1", "g-interface-name", "org.freedesktop.thumbnails.Thumbnailer1", NULL);
			_tmp1_ = (FilesThumbnailerDaemon*) _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->proxy);
			self->priv->proxy = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("Thumbnailer.vala:139: Failed to connect to system thumbnailing service" \
" (tumbler): %s", _tmp5_);
			_g_object_unref0 (self->priv->proxy);
			self->priv->proxy = NULL;
			_g_error_free0 (e);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = self->priv->proxy;
		if (_tmp6_ != NULL) {
			FilesThumbnailerDaemon* _tmp7_;
			FilesThumbnailerDaemon* _tmp8_;
			FilesThumbnailerDaemon* _tmp9_;
			FilesThumbnailerDaemon* _tmp10_;
			_tmp7_ = self->priv->proxy;
			g_signal_connect (_tmp7_, "started", (GCallback) _files_thumbnailer_on_proxy_started_files_thumbnailer_daemon_started, NULL);
			_tmp8_ = self->priv->proxy;
			g_signal_connect (_tmp8_, "finished", (GCallback) _files_thumbnailer_on_proxy_finished_files_thumbnailer_daemon_finished, NULL);
			_tmp9_ = self->priv->proxy;
			g_signal_connect (_tmp9_, "ready", (GCallback) _files_thumbnailer_on_proxy_ready_files_thumbnailer_daemon_ready, NULL);
			_tmp10_ = self->priv->proxy;
			g_signal_connect (_tmp10_, "error", (GCallback) _files_thumbnailer_on_proxy_error_files_thumbnailer_daemon_error, NULL);
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FilesThumbnailer*
files_thumbnailer_get (void)
{
	FilesThumbnailer* _tmp0_;
	FilesThumbnailer* _tmp3_;
	FilesThumbnailer* _tmp4_;
	FilesThumbnailer* result;
	_tmp0_ = files_thumbnailer_instance;
	if (_tmp0_ == NULL) {
		FilesThumbnailer* _tmp1_;
		FilesThumbnailer* _tmp2_;
		_tmp1_ = files_thumbnailer_new ();
		_g_object_unref0 (files_thumbnailer_instance);
		files_thumbnailer_instance = _tmp1_;
		_tmp2_ = files_thumbnailer_instance;
		files_thumbnailer_init (_tmp2_);
	}
	_tmp3_ = files_thumbnailer_instance;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

gboolean
files_thumbnailer_queue_file (FilesThumbnailer* self,
                              FilesFile* file,
                              gint* request)
{
	gint _vala_request = 0;
	GList* files = NULL;
	FilesFile* _tmp0_;
	gint this_request = 0;
	gboolean success = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	files = NULL;
	_tmp0_ = _g_object_ref0 (file);
	files = g_list_append (files, _tmp0_);
	_tmp2_ = files_thumbnailer_queue_files (self, files, &_tmp1_);
	this_request = _tmp1_;
	success = _tmp2_;
	_vala_request = this_request;
	result = success;
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
	if (request) {
		*request = _vala_request;
	}
	return result;
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		FilesThumbnailer* self;
		self = _data18_->self;
		_data18_->uris = (_vala_array_free (_data18_->uris, _data18_->uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gpointer
_files_thumbnailer_uri_list_dup0 (gpointer self)
{
	return self ? files_thumbnailer_uri_list_dup (self) : NULL;
}

static void
__lambda39_ (Block18Data* _data18_,
             GObject* obj,
             GAsyncResult* res)
{
	FilesThumbnailer* self;
	GError* _inner_error0_ = NULL;
	self = _data18_->self;
	g_return_if_fail (res != NULL);
	{
		guint handle = 0U;
		guint _tmp0_ = 0U;
		FilesThumbnailerDaemon* _tmp1_;
		GHashTable* _tmp2_;
		GHashTable* _tmp3_;
		FilesThumbnailerUriList uri_list = {0};
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gint _tmp5__length1;
		FilesThumbnailerUriList _tmp6_ = {0};
		GHashTable* _tmp7_;
		FilesThumbnailerUriList _tmp8_;
		FilesThumbnailerUriList _tmp9_;
		FilesThumbnailerUriList* _tmp10_;
		_tmp1_ = self->priv->proxy;
		_tmp0_ = files_thumbnailer_daemon_queue_finish (_tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		handle = _tmp0_;
		_tmp2_ = files_thumbnailer_request_handle_mapping;
		g_hash_table_insert (_tmp2_, (gpointer) ((guintptr) _data18_->this_request), (gpointer) ((guintptr) handle));
		_tmp3_ = files_thumbnailer_handle_request_mapping;
		g_hash_table_insert (_tmp3_, (gpointer) ((guintptr) handle), (gpointer) ((guintptr) _data18_->this_request));
		_tmp4_ = _data18_->uris;
		_tmp4__length1 = _data18_->uris_length1;
		_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		memset (&_tmp6_, 0, sizeof (FilesThumbnailerUriList));
		_tmp6_.uris = (_vala_array_free (_tmp6_.uris, _tmp6_.uris_length1, (GDestroyNotify) g_free), NULL);
		_tmp6_.uris = _tmp5_;
		_tmp6_.uris_length1 = _tmp5__length1;
		_tmp6_._uris_size_ = _tmp6_.uris_length1;
		uri_list = _tmp6_;
		_tmp7_ = files_thumbnailer_handle_uris_mapping;
		_tmp8_ = uri_list;
		_tmp9_ = _tmp8_;
		_tmp10_ = _files_thumbnailer_uri_list_dup0 (&_tmp9_);
		g_hash_table_insert (_tmp7_, (gpointer) ((guintptr) handle), _tmp10_);
		files_thumbnailer_uri_list_destroy (&uri_list);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_debug ("Thumbnailer.vala:229: Thumbnailer proxy request %u failed: %s", _data18_->this_request, _tmp12_);
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _data18_->files;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				FilesFile* _tmp13_;
				FilesFile* file = NULL;
				_tmp13_ = _g_object_ref0 ((FilesFile*) file_it->data);
				file = _tmp13_;
				{
					FilesFile* _tmp14_;
					FilesFile* _tmp15_;
					_tmp14_ = file;
					_tmp14_->thumbstate = (guint) FILES_FILE_THUMB_STATE_NONE;
					_tmp15_ = file;
					files_file_update_icon (_tmp15_, -1, -1);
					_g_object_unref0 (file);
				}
			}
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda39__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda39_ (self, source_object, res);
	block18_data_unref (self);
}

gboolean
files_thumbnailer_queue_files (FilesThumbnailer* self,
                               GList* files,
                               gint* request)
{
	gint _vala_request = 0;
	Block18Data* _data18_;
	FilesThumbnailerDaemon* _tmp0_;
	GList* supported_files = NULL;
	guint file_count = 0U;
	gchar** _tmp8_;
	gchar** mime_hints = NULL;
	gchar** _tmp9_;
	gint mime_hints_length1;
	gint _mime_hints_size_;
	guint index = 0U;
	GList* _tmp10_;
	guint _tmp22_;
	gchar* scheduler = NULL;
	gchar* _tmp23_;
	FilesThumbnailerDaemon* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_data18_->files = files;
	_vala_request = -1;
	_tmp0_ = self->priv->proxy;
	if (_tmp0_ == NULL) {
		result = FALSE;
		block18_data_unref (_data18_);
		_data18_ = NULL;
		if (request) {
			*request = _vala_request;
		}
		return result;
	}
	supported_files = NULL;
	file_count = (guint) 0;
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _data18_->files;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			FilesFile* _tmp1_;
			FilesFile* file = NULL;
			_tmp1_ = _g_object_ref0 ((FilesFile*) file_it->data);
			file = _tmp1_;
			{
				FilesFile* _tmp2_;
				_tmp2_ = file;
				if (files_thumbnailer_is_supported (self, _tmp2_)) {
					FilesFile* _tmp3_;
					FilesFile* _tmp4_;
					FilesFile* _tmp5_;
					guint _tmp6_;
					_tmp3_ = file;
					_tmp4_ = _g_object_ref0 (_tmp3_);
					supported_files = g_list_prepend (supported_files, _tmp4_);
					_tmp5_ = file;
					_tmp5_->thumbstate = (guint) FILES_FILE_THUMB_STATE_LOADING;
					_tmp6_ = file_count;
					file_count = _tmp6_ + 1;
				} else {
					FilesFile* _tmp7_;
					_tmp7_ = file;
					_tmp7_->thumbstate = (guint) FILES_FILE_THUMB_STATE_NONE;
				}
				_g_object_unref0 (file);
			}
		}
	}
	if (file_count == ((guint) 0)) {
		result = FALSE;
		(supported_files == NULL) ? NULL : (supported_files = (_g_list_free__g_object_unref0_ (supported_files), NULL));
		block18_data_unref (_data18_);
		_data18_ = NULL;
		if (request) {
			*request = _vala_request;
		}
		return result;
	}
	_tmp8_ = g_new0 (gchar*, file_count + 1);
	_data18_->uris = _tmp8_;
	_data18_->uris_length1 = file_count;
	_data18_->_uris_size_ = _data18_->uris_length1;
	_tmp9_ = g_new0 (gchar*, file_count + 1);
	mime_hints = _tmp9_;
	mime_hints_length1 = file_count;
	_mime_hints_size_ = mime_hints_length1;
	supported_files = g_list_reverse (supported_files);
	index = (guint) 0;
	_tmp10_ = supported_files;
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp10_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			FilesFile* _tmp11_;
			FilesFile* file = NULL;
			_tmp11_ = _g_object_ref0 ((FilesFile*) file_it->data);
			file = _tmp11_;
			{
				gchar** _tmp12_;
				gint _tmp12__length1;
				FilesFile* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				FilesFile* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				guint _tmp21_;
				_tmp12_ = _data18_->uris;
				_tmp12__length1 = _data18_->uris_length1;
				_tmp13_ = file;
				_tmp14_ = files_file_get_uri (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_tmp12_[index]);
				_tmp12_[index] = _tmp16_;
				_tmp17_ = mime_hints;
				_tmp17__length1 = mime_hints_length1;
				_tmp18_ = file;
				_tmp19_ = files_file_get_ftype (_tmp18_);
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (_tmp17_[index]);
				_tmp17_[index] = _tmp20_;
				_tmp21_ = index;
				index = _tmp21_ + 1;
				_g_object_unref0 (file);
			}
		}
	}
	self->priv->last_request = self->priv->last_request + 1;
	_tmp22_ = self->priv->last_request;
	_data18_->this_request = _tmp22_;
	_tmp23_ = g_strdup ("foreground");
	scheduler = _tmp23_;
	_tmp24_ = self->priv->proxy;
	_tmp25_ = _data18_->uris;
	_tmp25__length1 = _data18_->uris_length1;
	_tmp26_ = mime_hints;
	_tmp26__length1 = mime_hints_length1;
	_tmp27_ = scheduler;
	files_thumbnailer_daemon_queue (_tmp24_, _tmp25_, (gint) _tmp25__length1, _tmp26_, (gint) _tmp26__length1, "large", _tmp27_, (guint) 0, ___lambda39__gasync_ready_callback, block18_data_ref (_data18_));
	_vala_request = (gint) _data18_->this_request;
	result = TRUE;
	_g_free0 (scheduler);
	mime_hints = (_vala_array_free (mime_hints, mime_hints_length1, (GDestroyNotify) g_free), NULL);
	(supported_files == NULL) ? NULL : (supported_files = (_g_list_free__g_object_unref0_ (supported_files), NULL));
	block18_data_unref (_data18_);
	_data18_ = NULL;
	if (request) {
		*request = _vala_request;
	}
	return result;
}

void
files_thumbnailer_dequeue (FilesThumbnailer* self,
                           gint request)
{
	FilesThumbnailerDaemon* _tmp0_;
	guint req = 0U;
	guint handle = 0U;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	FilesThumbnailerDaemon* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy;
	if (_tmp0_ == NULL) {
		return;
	}
	req = (guint) request;
	g_mutex_lock (&files_thumbnailer_thumbnailer_lock);
	_tmp1_ = files_thumbnailer_request_handle_mapping;
	_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) req));
	handle = (guint) ((guintptr) _tmp2_);
	g_mutex_unlock (&files_thumbnailer_thumbnailer_lock);
	_tmp3_ = self->priv->proxy;
	files_thumbnailer_daemon_dequeue (_tmp3_, handle, NULL, NULL);
}

static gboolean
files_thumbnailer_is_supported (FilesThumbnailer* self,
                                FilesFile* file)
{
	gchar* ftype = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	FilesThumbnailerDaemon* _tmp3_;
	gboolean supported = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp12_ = FALSE;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = files_file_get_ftype (file);
	_tmp1_ = g_strdup (_tmp0_);
	ftype = _tmp1_;
	_tmp3_ = self->priv->proxy;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = ftype;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_free0 (ftype);
		return result;
	}
	supported = FALSE;
	_tmp5_ = self->priv->supported_schemes;
	_tmp5__length1 = self->priv->supported_schemes_length1;
	if (_tmp5_ == NULL) {
		{
			FilesThumbnailerDaemon* _tmp6_;
			gchar** _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gchar** _tmp9_ = NULL;
			gint _tmp10_ = 0;
			_tmp6_ = self->priv->proxy;
			files_thumbnailer_daemon_get_supported (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_inner_error0_);
			self->priv->supported_schemes = (_vala_array_free (self->priv->supported_schemes, self->priv->supported_schemes_length1, (GDestroyNotify) g_free), NULL);
			self->priv->supported_schemes = _tmp7_;
			self->priv->supported_schemes_length1 = _tmp8_;
			self->priv->_supported_schemes_size_ = self->priv->supported_schemes_length1;
			self->priv->supported_types = (_vala_array_free (self->priv->supported_types, self->priv->supported_types_length1, (GDestroyNotify) g_free), NULL);
			self->priv->supported_types = _tmp9_;
			self->priv->supported_types_length1 = _tmp10_;
			self->priv->_supported_types_size_ = self->priv->supported_types_length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_debug ("Thumbnailer.vala:268: Thumbnailer failed to get supported file list");
			result = FALSE;
			_g_free0 (ftype);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			_g_free0 (ftype);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	}
	_tmp13_ = self->priv->supported_schemes;
	_tmp13__length1 = self->priv->supported_schemes_length1;
	if (_tmp13_ != NULL) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = self->priv->supported_types;
		_tmp14__length1 = self->priv->supported_types_length1;
		_tmp12_ = _tmp14_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		guint index = 0U;
		gchar** _tmp15_;
		gint _tmp15__length1;
		index = (guint) 0;
		_tmp15_ = self->priv->supported_schemes;
		_tmp15__length1 = self->priv->supported_schemes_length1;
		{
			gchar** scheme_collection = NULL;
			gint scheme_collection_length1 = 0;
			gint _scheme_collection_size_ = 0;
			gint scheme_it = 0;
			scheme_collection = _tmp15_;
			scheme_collection_length1 = _tmp15__length1;
			for (scheme_it = 0; scheme_it < scheme_collection_length1; scheme_it = scheme_it + 1) {
				gchar* _tmp16_;
				gchar* scheme = NULL;
				_tmp16_ = g_strdup (scheme_collection[scheme_it]);
				scheme = _tmp16_;
				{
					gboolean _tmp17_ = FALSE;
					GFile* _tmp18_;
					GFile* _tmp19_;
					const gchar* _tmp20_;
					guint _tmp24_;
					_tmp18_ = files_file_get_location (file);
					_tmp19_ = _tmp18_;
					_tmp20_ = scheme;
					if (g_file_has_uri_scheme (_tmp19_, _tmp20_)) {
						const gchar* _tmp21_;
						gchar** _tmp22_;
						gint _tmp22__length1;
						const gchar* _tmp23_;
						_tmp21_ = ftype;
						_tmp22_ = self->priv->supported_types;
						_tmp22__length1 = self->priv->supported_types_length1;
						_tmp23_ = _tmp22_[index];
						_tmp17_ = g_content_type_is_a (_tmp21_, _tmp23_);
					} else {
						_tmp17_ = FALSE;
					}
					if (_tmp17_) {
						supported = TRUE;
						_g_free0 (scheme);
						break;
					}
					_tmp24_ = index;
					index = _tmp24_ + 1;
					_g_free0 (scheme);
				}
			}
		}
	} else {
		g_debug ("Thumbnailer.vala:284: No supported schemes or types returned by proxy");
	}
	result = supported;
	_g_free0 (ftype);
	return result;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		files_thumbnailer_idle_destroy (&_data19_->idle);
		g_slice_free (Block19Data, _data19_);
	}
}

static gboolean
__lambda38_ (Block19Data* _data19_)
{
	FilesThumbnailerIdle _tmp0_;
	gboolean result;
	_tmp0_ = _data19_->idle;
	files_thumbnailer_handle_error_idle (&_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ (self);
	return result;
}

static void
files_thumbnailer_on_proxy_error (guint handle,
                                  gchar** failed_uris,
                                  gint failed_uris_length1,
                                  gint error_code,
                                  const gchar* msg)
{
	Block19Data* _data19_;
	gchar** _tmp0_;
	gchar** _tmp1_;
	FilesThumbnailerIdle _tmp2_;
	FilesThumbnailerIdle _tmp3_;
	FilesThumbnailerIdle* _tmp4_;
	g_return_if_fail (msg != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	memset (&_data19_->idle, 0, sizeof (FilesThumbnailerIdle));
	_data19_->idle.type = FILES_THUMBNAILER_IDLE_TYPE_ERROR;
	_tmp1_ = _tmp0_ = g_strdupv (failed_uris);
	_data19_->idle.uris = (_vala_array_free (_data19_->idle.uris, _data19_->idle.uris_length1, (GDestroyNotify) g_free), NULL);
	_data19_->idle.uris = _tmp1_;
	_data19_->idle.uris_length1 = _vala_array_length (_tmp0_);
	_data19_->idle._uris_size_ = _data19_->idle.uris_length1;
	_tmp2_ = _data19_->idle;
	_tmp3_ = _tmp2_;
	_tmp4_ = _files_thumbnailer_idle_dup0 (&_tmp3_);
	files_thumbnailer_idles = g_list_prepend (files_thumbnailer_idles, _tmp4_);
	_data19_->idle.id = g_idle_add_full (G_PRIORITY_LOW, ___lambda38__gsource_func, block19_data_ref (_data19_), block19_data_unref);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

static void
files_thumbnailer_on_proxy_started (guint handle)
{
	g_debug ("Thumbnailer.vala:307: started %u", handle);
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		files_thumbnailer_idle_destroy (&_data20_->idle);
		g_slice_free (Block20Data, _data20_);
	}
}

static gboolean
___lambda37_ (Block20Data* _data20_)
{
	FilesThumbnailerIdle _tmp0_;
	gboolean result;
	_tmp0_ = _data20_->idle;
	files_thumbnailer_handle_ready_idle (&_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda37__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda37_ (self);
	return result;
}

static void
files_thumbnailer_on_proxy_ready (guint handle,
                                  gchar** ready_uris,
                                  gint ready_uris_length1)
{
	if (ready_uris != NULL) {
		Block20Data* _data20_;
		gchar** _tmp0_;
		gchar** _tmp1_;
		FilesThumbnailerIdle _tmp2_;
		FilesThumbnailerIdle _tmp3_;
		FilesThumbnailerIdle* _tmp4_;
		_data20_ = g_slice_new0 (Block20Data);
		_data20_->_ref_count_ = 1;
		memset (&_data20_->idle, 0, sizeof (FilesThumbnailerIdle));
		_data20_->idle.type = FILES_THUMBNAILER_IDLE_TYPE_READY;
		_tmp1_ = _tmp0_ = g_strdupv (ready_uris);
		_data20_->idle.uris = (_vala_array_free (_data20_->idle.uris, _data20_->idle.uris_length1, (GDestroyNotify) g_free), NULL);
		_data20_->idle.uris = _tmp1_;
		_data20_->idle.uris_length1 = _vala_array_length (_tmp0_);
		_data20_->idle._uris_size_ = _data20_->idle.uris_length1;
		_data20_->idle.handle = handle;
		_tmp2_ = _data20_->idle;
		_tmp3_ = _tmp2_;
		_tmp4_ = _files_thumbnailer_idle_dup0 (&_tmp3_);
		files_thumbnailer_idles = g_list_prepend (files_thumbnailer_idles, _tmp4_);
		_data20_->idle.id = g_idle_add_full (G_PRIORITY_HIGH, ____lambda37__gsource_func, block20_data_ref (_data20_), block20_data_unref);
		block20_data_unref (_data20_);
		_data20_ = NULL;
	} else {
		g_debug ("Thumbnailer.vala:325: no ready uris");
	}
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		files_thumbnailer_idle_destroy (&_data21_->idle);
		g_slice_free (Block21Data, _data21_);
	}
}

static gboolean
__lambda36_ (Block21Data* _data21_)
{
	FilesThumbnailerIdle _tmp0_;
	gboolean result;
	_tmp0_ = _data21_->idle;
	files_thumbnailer_handle_finished_idle (&_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda36__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda36_ (self);
	return result;
}

static void
files_thumbnailer_on_proxy_finished (guint handle)
{
	Block21Data* _data21_;
	FilesThumbnailerIdle _tmp0_;
	FilesThumbnailerIdle _tmp1_;
	FilesThumbnailerIdle* _tmp2_;
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	memset (&_data21_->idle, 0, sizeof (FilesThumbnailerIdle));
	_data21_->idle.type = FILES_THUMBNAILER_IDLE_TYPE_FINISHED;
	_data21_->idle.handle = handle;
	_tmp0_ = _data21_->idle;
	_tmp1_ = _tmp0_;
	_tmp2_ = _files_thumbnailer_idle_dup0 (&_tmp1_);
	files_thumbnailer_idles = g_list_prepend (files_thumbnailer_idles, _tmp2_);
	_data21_->idle.id = g_idle_add_full (G_PRIORITY_LOW, ___lambda36__gsource_func, block21_data_ref (_data21_), block21_data_unref);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
_files_thumbnailer_idle_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (files_thumbnailer_idle_free (var), NULL));
}

static void
files_thumbnailer_handle_error_idle (FilesThumbnailerIdle* error_idle)
{
	FilesThumbnailerIdle _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	FilesThumbnailerIdle _tmp4_;
	g_return_if_fail (error_idle != NULL);
	_tmp0_ = *error_idle;
	_tmp1_ = _tmp0_.uris;
	_tmp1__length1 = _tmp0_.uris_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp1_;
		uri_collection_length1 = _tmp1__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp2_;
			gchar* uri = NULL;
			_tmp2_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp2_;
			{
				const gchar* _tmp3_;
				_tmp3_ = uri;
				files_thumbnailer_update_file_thumbstate (_tmp3_, FILES_FILE_THUMB_STATE_NONE);
				_g_free0 (uri);
			}
		}
	}
	g_mutex_lock (&files_thumbnailer_thumbnailer_lock);
	_tmp4_ = *error_idle;
	files_thumbnailer_idles = vala_g_list_remove_full (files_thumbnailer_idles, &_tmp4_, _files_thumbnailer_idle_free0_);
	g_mutex_unlock (&files_thumbnailer_thumbnailer_lock);
}

static void
files_thumbnailer_handle_ready_idle (FilesThumbnailerIdle* ready_idle)
{
	FilesThumbnailerIdle _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	FilesThumbnailerIdle _tmp4_;
	g_return_if_fail (ready_idle != NULL);
	_tmp0_ = *ready_idle;
	_tmp1_ = _tmp0_.uris;
	_tmp1__length1 = _tmp0_.uris_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp1_;
		uri_collection_length1 = _tmp1__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp2_;
			gchar* uri = NULL;
			_tmp2_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp2_;
			{
				const gchar* _tmp3_;
				_tmp3_ = uri;
				files_thumbnailer_update_file_thumbstate (_tmp3_, FILES_FILE_THUMB_STATE_READY);
				_g_free0 (uri);
			}
		}
	}
	g_mutex_lock (&files_thumbnailer_thumbnailer_lock);
	_tmp4_ = *ready_idle;
	files_thumbnailer_idles = vala_g_list_remove_full (files_thumbnailer_idles, &_tmp4_, _files_thumbnailer_idle_free0_);
	g_mutex_unlock (&files_thumbnailer_thumbnailer_lock);
}

static void
files_thumbnailer_handle_finished_idle (FilesThumbnailerIdle* finished_idle)
{
	guint handle = 0U;
	FilesThumbnailerIdle _tmp0_;
	FilesThumbnailerUriList* uri_list = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	FilesThumbnailerUriList* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	guint request = 0U;
	GHashTable* _tmp11_;
	gconstpointer _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	FilesThumbnailer* _tmp15_;
	FilesThumbnailer* _tmp16_;
	g_return_if_fail (finished_idle != NULL);
	_tmp0_ = *finished_idle;
	handle = _tmp0_.handle;
	_tmp1_ = files_thumbnailer_handle_uris_mapping;
	_tmp2_ = g_hash_table_lookup (_tmp1_, (gpointer) ((guintptr) handle));
	uri_list = (FilesThumbnailerUriList*) _tmp2_;
	_tmp3_ = uri_list;
	_tmp4_ = (*_tmp3_).uris;
	_tmp4__length1 = (*_tmp3_).uris_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp4_;
		uri_collection_length1 = _tmp4__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp5_;
			gchar* uri = NULL;
			_tmp5_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp5_;
			{
				FilesFile* goffile = NULL;
				const gchar* _tmp6_;
				FilesFile* _tmp7_;
				FilesFile* _tmp8_;
				_tmp6_ = uri;
				_tmp7_ = files_file_get_by_uri (_tmp6_);
				goffile = _tmp7_;
				_tmp8_ = goffile;
				if (_tmp8_->thumbstate == ((guint) FILES_FILE_THUMB_STATE_LOADING)) {
					FilesFile* _tmp9_;
					FilesFile* _tmp10_;
					_tmp9_ = goffile;
					_tmp9_->thumbstate = (guint) FILES_FILE_THUMB_STATE_NONE;
					_tmp10_ = goffile;
					files_file_update_icon (_tmp10_, -1, -1);
				}
				_g_object_unref0 (goffile);
				_g_free0 (uri);
			}
		}
	}
	g_mutex_lock (&files_thumbnailer_thumbnailer_lock);
	_tmp11_ = files_thumbnailer_handle_request_mapping;
	_tmp12_ = g_hash_table_lookup (_tmp11_, (gpointer) ((guintptr) handle));
	request = (guint) ((guintptr) _tmp12_);
	_tmp13_ = files_thumbnailer_request_handle_mapping;
	g_hash_table_remove (_tmp13_, (gpointer) ((guintptr) request));
	_tmp14_ = files_thumbnailer_handle_request_mapping;
	g_hash_table_remove (_tmp14_, (gpointer) ((guintptr) handle));
	g_mutex_unlock (&files_thumbnailer_thumbnailer_lock);
	_tmp15_ = files_thumbnailer_get ();
	_tmp16_ = _tmp15_;
	g_signal_emit (_tmp16_, files_thumbnailer_signals[FILES_THUMBNAILER_FINISHED_SIGNAL], 0, request);
	_g_object_unref0 (_tmp16_);
}

static void
files_thumbnailer_update_file_thumbstate (const gchar* uri,
                                          FilesFileThumbState state)
{
	FilesFile* goffile = NULL;
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	g_return_if_fail (uri != NULL);
	_tmp0_ = files_file_get_by_uri (uri);
	goffile = _tmp0_;
	_tmp1_ = goffile;
	if (_tmp1_ != NULL) {
		FilesFile* _tmp2_;
		FilesFile* _tmp3_;
		_tmp2_ = goffile;
		_tmp2_->thumbstate = (guint) state;
		_tmp3_ = goffile;
		files_file_update_icon (_tmp3_, -1, -1);
	}
	_g_object_unref0 (goffile);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
files_thumbnailer_idle_copy (const FilesThumbnailerIdle* self,
                             FilesThumbnailerIdle* dest)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	(*dest).id = (*self).id;
	(*dest).type = (*self).type;
	_tmp0_ = (*self).uris;
	_tmp0__length1 = (*self).uris_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).uris = (_vala_array_free ((*dest).uris, (*dest).uris_length1, (GDestroyNotify) g_free), NULL);
	(*dest).uris = _tmp1_;
	(*dest).uris_length1 = _tmp1__length1;
	(*dest)._uris_size_ = (*dest).uris_length1;
	(*dest).handle = (*self).handle;
}

static void
files_thumbnailer_idle_destroy (FilesThumbnailerIdle* self)
{
	(*self).uris = (_vala_array_free ((*self).uris, (*self).uris_length1, (GDestroyNotify) g_free), NULL);
}

static FilesThumbnailerIdle*
files_thumbnailer_idle_dup (const FilesThumbnailerIdle* self)
{
	FilesThumbnailerIdle* dup;
	dup = g_new0 (FilesThumbnailerIdle, 1);
	files_thumbnailer_idle_copy (self, dup);
	return dup;
}

static void
files_thumbnailer_idle_free (FilesThumbnailerIdle* self)
{
	files_thumbnailer_idle_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
files_thumbnailer_idle_get_type_once (void)
{
	GType files_thumbnailer_idle_type_id;
	files_thumbnailer_idle_type_id = g_boxed_type_register_static ("FilesThumbnailerIdle", (GBoxedCopyFunc) files_thumbnailer_idle_dup, (GBoxedFreeFunc) files_thumbnailer_idle_free);
	return files_thumbnailer_idle_type_id;
}

static GType
files_thumbnailer_idle_get_type (void)
{
	static volatile gsize files_thumbnailer_idle_type_id__once = 0;
	if (g_once_init_enter (&files_thumbnailer_idle_type_id__once)) {
		GType files_thumbnailer_idle_type_id;
		files_thumbnailer_idle_type_id = files_thumbnailer_idle_get_type_once ();
		g_once_init_leave (&files_thumbnailer_idle_type_id__once, files_thumbnailer_idle_type_id);
	}
	return files_thumbnailer_idle_type_id__once;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
files_thumbnailer_uri_list_copy (const FilesThumbnailerUriList* self,
                                 FilesThumbnailerUriList* dest)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = (*self).uris;
	_tmp0__length1 = (*self).uris_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).uris = (_vala_array_free ((*dest).uris, (*dest).uris_length1, (GDestroyNotify) g_free), NULL);
	(*dest).uris = _tmp1_;
	(*dest).uris_length1 = _tmp1__length1;
	(*dest)._uris_size_ = (*dest).uris_length1;
}

static void
files_thumbnailer_uri_list_destroy (FilesThumbnailerUriList* self)
{
	(*self).uris = (_vala_array_free ((*self).uris, (*self).uris_length1, (GDestroyNotify) g_free), NULL);
}

static FilesThumbnailerUriList*
files_thumbnailer_uri_list_dup (const FilesThumbnailerUriList* self)
{
	FilesThumbnailerUriList* dup;
	dup = g_new0 (FilesThumbnailerUriList, 1);
	files_thumbnailer_uri_list_copy (self, dup);
	return dup;
}

static void
files_thumbnailer_uri_list_free (FilesThumbnailerUriList* self)
{
	files_thumbnailer_uri_list_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
files_thumbnailer_uri_list_get_type_once (void)
{
	GType files_thumbnailer_uri_list_type_id;
	files_thumbnailer_uri_list_type_id = g_boxed_type_register_static ("FilesThumbnailerUriList", (GBoxedCopyFunc) files_thumbnailer_uri_list_dup, (GBoxedFreeFunc) files_thumbnailer_uri_list_free);
	return files_thumbnailer_uri_list_type_id;
}

static GType
files_thumbnailer_uri_list_get_type (void)
{
	static volatile gsize files_thumbnailer_uri_list_type_id__once = 0;
	if (g_once_init_enter (&files_thumbnailer_uri_list_type_id__once)) {
		GType files_thumbnailer_uri_list_type_id;
		files_thumbnailer_uri_list_type_id = files_thumbnailer_uri_list_get_type_once ();
		g_once_init_leave (&files_thumbnailer_uri_list_type_id__once, files_thumbnailer_uri_list_type_id);
	}
	return files_thumbnailer_uri_list_type_id__once;
}

static void
files_thumbnailer_class_init (FilesThumbnailerClass * klass,
                              gpointer klass_data)
{
	files_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesThumbnailer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = files_thumbnailer_finalize;
	files_thumbnailer_signals[FILES_THUMBNAILER_FINISHED_SIGNAL] = g_signal_new ("finished", FILES_TYPE_THUMBNAILER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}

static void
files_thumbnailer_instance_init (FilesThumbnailer * self,
                                 gpointer klass)
{
	self->priv = files_thumbnailer_get_instance_private (self);
	self->priv->supported_schemes = NULL;
	self->priv->supported_schemes_length1 = 0;
	self->priv->_supported_schemes_size_ = self->priv->supported_schemes_length1;
	self->priv->supported_types = NULL;
	self->priv->supported_types_length1 = 0;
	self->priv->_supported_types_size_ = self->priv->supported_types_length1;
	self->priv->last_request = (guint) 0;
}

static void
files_thumbnailer_finalize (GObject * obj)
{
	FilesThumbnailer * self;
	GList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_THUMBNAILER, FilesThumbnailer);
	g_mutex_lock (&files_thumbnailer_thumbnailer_lock);
	_tmp0_ = files_thumbnailer_idles;
	{
		GList* idle_collection = NULL;
		GList* idle_it = NULL;
		idle_collection = _tmp0_;
		for (idle_it = idle_collection; idle_it != NULL; idle_it = idle_it->next) {
			FilesThumbnailerIdle* _tmp1_;
			FilesThumbnailerIdle* idle = NULL;
			_tmp1_ = _files_thumbnailer_idle_dup0 ((FilesThumbnailerIdle*) idle_it->data);
			idle = _tmp1_;
			{
				FilesThumbnailerIdle* _tmp2_;
				_tmp2_ = idle;
				g_source_remove ((*_tmp2_).id);
				_files_thumbnailer_idle_free0 (idle);
			}
		}
	}
	g_mutex_unlock (&files_thumbnailer_thumbnailer_lock);
	_g_object_unref0 (self->priv->proxy);
	self->priv->supported_schemes = (_vala_array_free (self->priv->supported_schemes, self->priv->supported_schemes_length1, (GDestroyNotify) g_free), NULL);
	self->priv->supported_types = (_vala_array_free (self->priv->supported_types, self->priv->supported_types_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (files_thumbnailer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_thumbnailer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesThumbnailer), 0, (GInstanceInitFunc) files_thumbnailer_instance_init, NULL };
	GType files_thumbnailer_type_id;
	files_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesThumbnailer", &g_define_type_info, 0);
	FilesThumbnailer_private_offset = g_type_add_instance_private (files_thumbnailer_type_id, sizeof (FilesThumbnailerPrivate));
	return files_thumbnailer_type_id;
}

GType
files_thumbnailer_get_type (void)
{
	static volatile gsize files_thumbnailer_type_id__once = 0;
	if (g_once_init_enter (&files_thumbnailer_type_id__once)) {
		GType files_thumbnailer_type_id;
		files_thumbnailer_type_id = files_thumbnailer_get_type_once ();
		g_once_init_leave (&files_thumbnailer_type_id__once, files_thumbnailer_type_id);
	}
	return files_thumbnailer_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

