/* ContactManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ContactManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_CONTACT_MANAGER (mail_contact_manager_get_type ())
#define MAIL_CONTACT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONTACT_MANAGER, MailContactManager))
#define MAIL_CONTACT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONTACT_MANAGER, MailContactManagerClass))
#define MAIL_IS_CONTACT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONTACT_MANAGER))
#define MAIL_IS_CONTACT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONTACT_MANAGER))
#define MAIL_CONTACT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONTACT_MANAGER, MailContactManagerClass))

typedef struct _MailContactManager MailContactManager;
typedef struct _MailContactManagerClass MailContactManagerClass;
typedef struct _MailContactManagerPrivate MailContactManagerPrivate;
enum  {
	MAIL_CONTACT_MANAGER_0_PROPERTY,
	MAIL_CONTACT_MANAGER_LIST_STORE_PROPERTY,
	MAIL_CONTACT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* mail_contact_manager_properties[MAIL_CONTACT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _MailContactManagerRememberMailAddressData MailContactManagerRememberMailAddressData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _MailContactManagerLoadContactData MailContactManagerLoadContactData;

struct _MailContactManager {
	GObject parent_instance;
	MailContactManagerPrivate * priv;
};

struct _MailContactManagerClass {
	GObjectClass parent_class;
};

struct _MailContactManagerPrivate {
	GtkListStore* _list_store;
	GeeTreeSet* email_addresses;
	FolksIndividualAggregator* individual_aggregator;
	gchar* current_key;
	gchar* real_key;
};

struct _Block25Data {
	int _ref_count_;
	MailContactManager* self;
	GtkEntry* entry;
};

struct _Block26Data {
	int _ref_count_;
	MailContactManager* self;
	gchar* address;
	gchar* name;
	gpointer _async_data_;
};

struct _Block27Data {
	int _ref_count_;
	Block26Data * _data26_;
	gulong handler;
};

struct _MailContactManagerRememberMailAddressData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailContactManager* self;
	gchar* address;
	gchar* name;
	Block26Data* _data26_;
	const gchar* _tmp0_;
	GeeTreeSet* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FolksIndividualAggregator* _tmp8_;
	FolksPersonaStore* _tmp9_;
	FolksPersonaStore* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	Block27Data* _data27_;
	FolksIndividualAggregator* _tmp13_;
	FolksPersonaStore* _tmp14_;
	FolksPersonaStore* _tmp15_;
	gulong _tmp16_;
	GHashTable* details;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	GeeHashSet* address_set;
	GeeHashSet* _tmp20_;
	GeeHashSet* _tmp21_;
	FolksEmailFieldDetails* _tmp22_;
	FolksEmailFieldDetails* _tmp23_;
	GValue address_val;
	GValue _tmp24_;
	GeeHashSet* _tmp25_;
	GValue name_val;
	GValue _tmp26_;
	GHashTable* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GValue _tmp30_;
	GValue _tmp31_;
	GValue* _tmp32_;
	GHashTable* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GValue _tmp36_;
	GValue _tmp37_;
	GValue* _tmp38_;
	FolksIndividualAggregator* _tmp39_;
	FolksIndividualAggregator* _tmp40_;
	FolksPersonaStore* _tmp41_;
	FolksPersonaStore* _tmp42_;
	GHashTable* _tmp43_;
	FolksPersona* _tmp44_;
	FolksPersona* _tmp45_;
	GError* e;
	GError* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GError* _tmp50_;
	const gchar* _tmp51_;
	GError* _inner_error0_;
};

struct _MailContactManagerLoadContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailContactManager* self;
	FolksIndividualAggregator* _tmp0_;
	GeeIterator* _individual_it;
	FolksIndividualAggregator* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	FolksIndividual* individual;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	FolksIndividual* _tmp12_;
	FolksIndividualAggregator* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

static gint MailContactManager_private_offset;
static gpointer mail_contact_manager_parent_class = NULL;
static MailContactManager* mail_contact_manager_instance;
static MailContactManager* mail_contact_manager_instance = NULL;

VALA_EXTERN GType mail_contact_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailContactManager, g_object_unref)
VALA_EXTERN MailContactManager* mail_contact_manager_get_default (void);
VALA_EXTERN MailContactManager* mail_contact_manager_new (void);
VALA_EXTERN MailContactManager* mail_contact_manager_construct (GType object_type);
VALA_EXTERN void mail_contact_manager_setup_entry (MailContactManager* self,
                                       GtkEntry* entry);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
VALA_EXTERN GtkListStore* mail_contact_manager_get_list_store (MailContactManager* self);
static gboolean mail_contact_manager_entry_completion (MailContactManager* self,
                                                GtkEntryCompletion* completion,
                                                const gchar* key,
                                                GtkTreeIter* iter);
static gboolean _mail_contact_manager_entry_completion_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                                 const gchar* key,
                                                                                 GtkTreeIter* iter,
                                                                                 gpointer self);
static void mail_contact_manager_layout_text (MailContactManager* self,
                                       GtkCellLayout* cell_layout,
                                       GtkCellRenderer* cell,
                                       GtkTreeModel* tree_model,
                                       GtkTreeIter* iter);
static void _mail_contact_manager_layout_text_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                                  GtkCellRenderer* cell,
                                                                  GtkTreeModel* tree_model,
                                                                  GtkTreeIter* iter,
                                                                  gpointer self);
static gboolean __lambda93_ (Block25Data* _data25_,
                      GtkTreeModel* model,
                      GtkTreeIter* iter);
static gboolean ___lambda93__gtk_entry_completion_match_selected (GtkEntryCompletion* _sender,
                                                           GtkTreeModel* model,
                                                           GtkTreeIter* iter,
                                                           gpointer self);
static void mail_contact_manager_remember_mail_address_data_free (gpointer _data);
VALA_EXTERN void mail_contact_manager_remember_mail_address (MailContactManager* self,
                                                 const gchar* address,
                                                 const gchar* name,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void mail_contact_manager_remember_mail_address_finish (MailContactManager* self,
                                                        GAsyncResult* _res_);
static gboolean mail_contact_manager_remember_mail_address_co (MailContactManagerRememberMailAddressData* _data_);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
VALA_EXTERN void mail_main_window_send_error_message (const gchar* title,
                                          const gchar* description,
                                          const gchar* icon_name,
                                          const gchar* error_details);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void ____lambda94_ (Block27Data* _data27_);
static void _____lambda94__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void mail_contact_manager_remember_mail_address_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void mail_contact_manager_load_contact_data_free (gpointer _data);
static void mail_contact_manager_load_contact (MailContactManager* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void mail_contact_manager_load_contact_finish (MailContactManager* self,
                                               GAsyncResult* _res_);
static gboolean mail_contact_manager_load_contact_co (MailContactManagerLoadContactData* _data_);
static void __lambda95_ (MailContactManager* self,
                  GeeMultiMap* changes);
static void mail_contact_manager_add_individual (MailContactManager* self,
                                          FolksIndividual* individual);
static void ___lambda95__folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                            GeeMultiMap* changes,
                                                                            gpointer self);
static void mail_contact_manager_load_contact_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static gint mail_contact_manager_list_store_sort_func (GtkTreeModel* model,
                                                GtkTreeIter* a,
                                                GtkTreeIter* b);
static void mail_contact_manager_set_list_store (MailContactManager* self,
                                          GtkListStore* value);
static GObject * mail_contact_manager_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static gint _mail_contact_manager_list_store_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                            GtkTreeIter* a,
                                                                            GtkTreeIter* b,
                                                                            gpointer self);
static void mail_contact_manager_finalize (GObject * obj);
static GType mail_contact_manager_get_type_once (void);
static void _vala_mail_contact_manager_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_mail_contact_manager_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mail_contact_manager_get_instance_private (MailContactManager* self)
{
	return G_STRUCT_MEMBER_P (self, MailContactManager_private_offset);
}

MailContactManager*
mail_contact_manager_get_default (void)
{
	MailContactManager* _tmp0_;
	MailContactManager* _tmp2_;
	MailContactManager* result;
	_tmp0_ = mail_contact_manager_instance;
	if (_tmp0_ == NULL) {
		MailContactManager* _tmp1_;
		_tmp1_ = mail_contact_manager_new ();
		_g_object_unref0 (mail_contact_manager_instance);
		mail_contact_manager_instance = _tmp1_;
	}
	_tmp2_ = mail_contact_manager_instance;
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		MailContactManager* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static gboolean
_mail_contact_manager_entry_completion_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                        const gchar* key,
                                                                        GtkTreeIter* iter,
                                                                        gpointer self)
{
	gboolean result;
	result = mail_contact_manager_entry_completion ((MailContactManager*) self, completion, key, iter);
	return result;
}

static void
_mail_contact_manager_layout_text_gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                                             GtkCellRenderer* cell,
                                                             GtkTreeModel* tree_model,
                                                             GtkTreeIter* iter,
                                                             gpointer self)
{
	mail_contact_manager_layout_text ((MailContactManager*) self, cell_layout, cell, tree_model, iter);
}

static gboolean
__lambda93_ (Block25Data* _data25_,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	MailContactManager* self;
	gchar* name = NULL;
	gchar* email = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** parts = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint parts_length1;
	gint _parts_size_;
	gchar* text = NULL;
	gchar* _tmp8_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean result;
	self = _data25_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->_list_store;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, 0, &_tmp2_, 1, &_tmp3_, -1);
	_g_free0 (name);
	name = _tmp2_;
	_g_free0 (email);
	email = _tmp3_;
	_tmp4_ = gtk_entry_get_text (_data25_->entry);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	parts = _tmp7_;
	parts_length1 = _vala_array_length (_tmp6_);
	_parts_size_ = parts_length1;
	_tmp8_ = g_strdup ("");
	text = _tmp8_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				if (!_tmp9_) {
					guint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = parts;
				_tmp11__length1 = parts_length1;
				if (!(i < ((guint) (_tmp11__length1 - 1)))) {
					break;
				}
				_tmp12_ = text;
				_tmp13_ = parts;
				_tmp13__length1 = parts_length1;
				_tmp14_ = _tmp13_[i];
				_tmp15_ = g_strdup_printf ("%s%s, ", _tmp12_, _tmp14_);
				_g_free0 (text);
				text = _tmp15_;
			}
		}
	}
	_tmp16_ = name;
	_tmp17_ = email;
	if (g_strcmp0 (_tmp16_, _tmp17_) != 0) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp18_ = text;
		_tmp19_ = name;
		_tmp20_ = email;
		_tmp21_ = g_strdup_printf ("%s <%s>, ", _tmp19_, _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp18_, _tmp22_, NULL);
		_g_free0 (text);
		text = _tmp23_;
		_g_free0 (_tmp22_);
	} else {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = text;
		_tmp25_ = email;
		_tmp26_ = g_strdup_printf ("%s, ", _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
		_g_free0 (text);
		text = _tmp28_;
		_g_free0 (_tmp27_);
	}
	_tmp29_ = text;
	gtk_entry_set_text (_data25_->entry, _tmp29_);
	_tmp30_ = text;
	g_object_get (_data25_->entry, "cursor-position", &_tmp31_, NULL);
	_tmp32_ = _tmp31_;
	g_signal_emit_by_name (_data25_->entry, "move-cursor", GTK_MOVEMENT_VISUAL_POSITIONS, g_utf8_strlen (_tmp30_, (gssize) -1) - _tmp32_, FALSE, NULL);
	result = TRUE;
	_g_free0 (text);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (email);
	_g_free0 (name);
	return result;
}

static gboolean
___lambda93__gtk_entry_completion_match_selected (GtkEntryCompletion* _sender,
                                                  GtkTreeModel* model,
                                                  GtkTreeIter* iter,
                                                  gpointer self)
{
	gboolean result;
	result = __lambda93_ (self, model, iter);
	return result;
}

void
mail_contact_manager_setup_entry (MailContactManager* self,
                                  GtkEntry* entry)
{
	Block25Data* _data25_;
	GtkEntry* _tmp0_;
	GtkCellRendererText* name_cell = NULL;
	GtkCellRendererText* _tmp1_;
	GtkEntryCompletion* completion = NULL;
	GtkEntryCompletion* _tmp2_;
	GtkListStore* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (entry);
	_g_object_unref0 (_data25_->entry);
	_data25_->entry = _tmp0_;
	_tmp1_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp1_);
	name_cell = _tmp1_;
	_tmp2_ = gtk_entry_completion_new ();
	completion = _tmp2_;
	_tmp3_ = self->priv->_list_store;
	gtk_entry_completion_set_model (completion, (GtkTreeModel*) _tmp3_);
	gtk_entry_completion_set_match_func (completion, _mail_contact_manager_entry_completion_gtk_entry_completion_match_func, g_object_ref (self), g_object_unref);
	gtk_cell_layout_pack_start ((GtkCellLayout*) completion, (GtkCellRenderer*) name_cell, TRUE);
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) completion, (GtkCellRenderer*) name_cell, _mail_contact_manager_layout_text_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	g_signal_connect_data (completion, "match-selected", (GCallback) ___lambda93__gtk_entry_completion_match_selected, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	gtk_entry_set_completion (_data25_->entry, completion);
	_g_object_unref0 (completion);
	_g_object_unref0 (name_cell);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static void
mail_contact_manager_remember_mail_address_data_free (gpointer _data)
{
	MailContactManagerRememberMailAddressData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailContactManagerRememberMailAddressData, _data_);
}

void
mail_contact_manager_remember_mail_address (MailContactManager* self,
                                            const gchar* address,
                                            const gchar* name,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	MailContactManagerRememberMailAddressData* _data_;
	MailContactManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	_data_ = g_slice_new0 (MailContactManagerRememberMailAddressData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_contact_manager_remember_mail_address_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (address);
	_g_free0 (_data_->address);
	_data_->address = _tmp1_;
	_tmp2_ = g_strdup (name);
	_g_free0 (_data_->name);
	_data_->name = _tmp2_;
	mail_contact_manager_remember_mail_address_co (_data_);
}

void
mail_contact_manager_remember_mail_address_finish (MailContactManager* self,
                                                   GAsyncResult* _res_)
{
	MailContactManagerRememberMailAddressData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		MailContactManager* self;
		self = _data26_->self;
		_g_free0 (_data26_->address);
		_g_free0 (_data26_->name);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		MailContactManager* self;
		self = _data27_->_data26_->self;
		block26_data_unref (_data27_->_data26_);
		_data27_->_data26_ = NULL;
		g_slice_free (Block27Data, _data27_);
	}
}

static void
____lambda94_ (Block27Data* _data27_)
{
	Block26Data* _data26_;
	MailContactManager* self;
	FolksIndividualAggregator* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	_data26_ = _data27_->_data26_;
	self = _data26_->self;
	mail_contact_manager_remember_mail_address (self, _data26_->address, _data26_->name, NULL, NULL);
	_tmp0_ = self->priv->individual_aggregator;
	_tmp1_ = folks_individual_aggregator_get_primary_store (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_handler_disconnect ((GObject*) _tmp2_, _data27_->handler);
}

static void
_____lambda94__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	____lambda94_ (self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
mail_contact_manager_remember_mail_address_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	MailContactManagerRememberMailAddressData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_contact_manager_remember_mail_address_co (_data_);
}

static gboolean
mail_contact_manager_remember_mail_address_co (MailContactManagerRememberMailAddressData* _data_)
{
	gchar* _tmp1_;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data26_ = g_slice_new0 (Block26Data);
	_data_->_data26_->_ref_count_ = 1;
	_data_->_data26_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data26_->address);
	_data_->_data26_->address = _data_->address;
	_g_free0 (_data_->_data26_->name);
	_data_->_data26_->name = _data_->name;
	_data_->_data26_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->_data26_->name;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp0_ = _data_->_data26_->address;
	}
	_tmp1_ = g_strdup (_data_->_tmp0_);
	_g_free0 (_data_->_data26_->name);
	_data_->_data26_->name = _tmp1_;
	if (!granite_services_system_history_is_enabled ()) {
		g_debug ("ContactManager.vala:77: History disabled, don't remember email address" \
"es.");
		block26_data_unref (_data_->_data26_);
		_data_->_data26_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->email_addresses;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp2_, _data_->_data26_->address)) {
		g_debug ("ContactManager.vala:82: Mail address already in addressbook.");
		block26_data_unref (_data_->_data26_);
		_data_->_data26_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->individual_aggregator;
	_data_->_tmp4_ = folks_individual_aggregator_get_primary_store (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = g_strdup_printf (_ ("Couldn't add “%s” to addressbook"), _data_->_data26_->name);
		_data_->_tmp7_ = _data_->_tmp6_;
		mail_main_window_send_error_message (_data_->_tmp7_, _ ("No addressbook available."), "avatar-default", NULL);
		_g_free0 (_data_->_tmp7_);
		block26_data_unref (_data_->_data26_);
		_data_->_data26_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp8_ = _data_->self->priv->individual_aggregator;
		_data_->_tmp9_ = folks_individual_aggregator_get_primary_store (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = folks_persona_store_get_is_prepared (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		if (!_data_->_tmp12_) {
			_data_->_data27_ = g_slice_new0 (Block27Data);
			_data_->_data27_->_ref_count_ = 1;
			_data_->_data27_->_data26_ = block26_data_ref (_data_->_data26_);
			_data_->_data27_->handler = (gulong) 0;
			_data_->_tmp13_ = _data_->self->priv->individual_aggregator;
			_data_->_tmp14_ = folks_individual_aggregator_get_primary_store (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = g_signal_connect_data ((GObject*) _data_->_tmp15_, "notify::is-prepared", (GCallback) _____lambda94__g_object_notify, block27_data_ref (_data_->_data27_), (GClosureNotify) block27_data_unref, 0);
			_data_->_data27_->handler = _data_->_tmp16_;
			block27_data_unref (_data_->_data27_);
			_data_->_data27_ = NULL;
			block26_data_unref (_data_->_data26_);
			_data_->_data26_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp17_ = g_str_hash;
	_data_->_tmp18_ = g_str_equal;
	_data_->_tmp19_ = g_hash_table_new_full (_data_->_tmp17_, _data_->_tmp18_, _g_free0_, __vala_GValue_free0_);
	_data_->details = _data_->_tmp19_;
	_data_->_tmp20_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->address_set = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->address_set;
	_data_->_tmp22_ = folks_email_field_details_new (_data_->_data26_->address, NULL);
	_data_->_tmp23_ = _data_->_tmp22_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp21_, _data_->_tmp23_);
	_g_object_unref0 (_data_->_tmp23_);
	memset (&_data_->_tmp24_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp24_, GEE_TYPE_SET);
	_data_->address_val = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->address_set;
	g_value_set_object (&_data_->address_val, (GObject*) _data_->_tmp25_);
	memset (&_data_->_tmp26_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp26_, G_TYPE_STRING);
	_data_->name_val = _data_->_tmp26_;
	g_value_set_string (&_data_->name_val, _data_->_data26_->name);
	_data_->_tmp27_ = _data_->details;
	_data_->_tmp28_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
	_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
	_data_->_tmp30_ = _data_->address_val;
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_tmp32_ = __g_value_dup0 (&_data_->_tmp31_);
	g_hash_table_insert (_data_->_tmp27_, _data_->_tmp29_, _data_->_tmp32_);
	_data_->_tmp33_ = _data_->details;
	_data_->_tmp34_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	_data_->_tmp35_ = g_strdup (_data_->_tmp34_);
	_data_->_tmp36_ = _data_->name_val;
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = __g_value_dup0 (&_data_->_tmp37_);
	g_hash_table_insert (_data_->_tmp33_, _data_->_tmp35_, _data_->_tmp38_);
	{
		g_debug ("ContactManager.vala:117: Remember '%s' with email address '%s'.", _data_->_data26_->name, _data_->_data26_->address);
		_data_->_tmp39_ = _data_->self->priv->individual_aggregator;
		_data_->_tmp40_ = _data_->self->priv->individual_aggregator;
		_data_->_tmp41_ = folks_individual_aggregator_get_primary_store (_data_->_tmp40_);
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_tmp43_ = _data_->details;
		_data_->_state_ = 1;
		folks_individual_aggregator_add_persona_from_details (_data_->_tmp39_, NULL, _data_->_tmp42_, _data_->_tmp43_, mail_contact_manager_remember_mail_address_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp44_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->_tmp39_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp45_ = _data_->_tmp44_;
		_g_object_unref0 (_data_->_tmp45_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp46_ = _data_->e;
		_data_->_tmp47_ = _data_->_tmp46_->message;
		g_warning ("ContactManager.vala:120: Failed to add mail address: %s", _data_->_tmp47_);
		_data_->_tmp48_ = g_strdup_printf (_ ("Couldn't add “%s” to addressbook"), _data_->_data26_->name);
		_data_->_tmp49_ = _data_->_tmp48_;
		_data_->_tmp50_ = _data_->e;
		_data_->_tmp51_ = _data_->_tmp50_->message;
		mail_main_window_send_error_message (_data_->_tmp49_, _ ("Operation failed."), "avatar-default", _data_->_tmp51_);
		_g_free0 (_data_->_tmp49_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		G_IS_VALUE (&_data_->name_val) ? (g_value_unset (&_data_->name_val), NULL) : NULL;
		G_IS_VALUE (&_data_->address_val) ? (g_value_unset (&_data_->address_val), NULL) : NULL;
		_g_object_unref0 (_data_->address_set);
		_g_hash_table_unref0 (_data_->details);
		block26_data_unref (_data_->_data26_);
		_data_->_data26_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	G_IS_VALUE (&_data_->name_val) ? (g_value_unset (&_data_->name_val), NULL) : NULL;
	G_IS_VALUE (&_data_->address_val) ? (g_value_unset (&_data_->address_val), NULL) : NULL;
	_g_object_unref0 (_data_->address_set);
	_g_hash_table_unref0 (_data_->details);
	block26_data_unref (_data_->_data26_);
	_data_->_data26_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
mail_contact_manager_entry_completion (MailContactManager* self,
                                       GtkEntryCompletion* completion,
                                       const gchar* key,
                                       GtkTreeIter* iter)
{
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	gchar* name = NULL;
	gchar* address = NULL;
	GtkListStore* _tmp9_;
	GtkTreeIter _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (completion != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->current_key;
	if (g_strcmp0 (_tmp0_, key) != 0) {
		gchar* _tmp1_;
		gchar** parts = NULL;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = g_strdup (key);
		_g_free0 (self->priv->current_key);
		self->priv->current_key = _tmp1_;
		_tmp3_ = _tmp2_ = g_strsplit (key, ",", 0);
		parts = _tmp3_;
		parts_length1 = _vala_array_length (_tmp2_);
		_parts_size_ = parts_length1;
		_tmp4_ = parts;
		_tmp4__length1 = parts_length1;
		_tmp5_ = parts;
		_tmp5__length1 = parts_length1;
		_tmp6_ = _tmp4_[_tmp5__length1 - 1];
		_tmp7_ = string_strip (_tmp6_);
		_g_free0 (self->priv->real_key);
		self->priv->real_key = _tmp7_;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp8_ = self->priv->real_key;
	if (g_strcmp0 (_tmp8_, "") == 0) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->_list_store;
	_tmp10_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp9_, &_tmp10_, 0, &_tmp11_, 1, &_tmp12_, -1);
	_g_free0 (name);
	name = _tmp11_;
	_g_free0 (address);
	address = _tmp12_;
	_tmp14_ = address;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = address;
		_tmp13_ = string_contains (key, _tmp15_);
	}
	if (_tmp13_) {
		result = FALSE;
		_g_free0 (address);
		_g_free0 (name);
		return result;
	}
	_tmp16_ = name;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gboolean _tmp23_;
		_tmp17_ = name;
		_tmp18_ = g_utf8_normalize (_tmp17_, (gssize) -1, G_NORMALIZE_DEFAULT);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_utf8_casefold (_tmp19_, (gssize) -1);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->real_key;
		_tmp23_ = string_contains (_tmp21_, _tmp22_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		result = _tmp23_;
		_g_free0 (address);
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (address);
	_g_free0 (name);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
mail_contact_manager_layout_text (MailContactManager* self,
                                  GtkCellLayout* cell_layout,
                                  GtkCellRenderer* cell,
                                  GtkTreeModel* tree_model,
                                  GtkTreeIter* iter)
{
	gchar* name = NULL;
	gchar* address = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* new_text = NULL;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (tree_model, &_tmp0_, 0, &_tmp1_, 1, &_tmp2_, -1);
	_g_free0 (name);
	name = _tmp1_;
	_g_free0 (address);
	address = _tmp2_;
	_tmp3_ = address;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->real_key;
	_tmp7_ = self->priv->real_key;
	_tmp8_ = g_markup_escape_text (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("<b>%s</b>", _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_replace (_tmp5_, _tmp6_, _tmp11_);
	_g_free0 (address);
	address = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	_tmp13_ = name;
	_tmp14_ = g_markup_escape_text (_tmp13_, (gssize) -1);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->real_key;
	_tmp17_ = self->priv->real_key;
	_tmp18_ = g_markup_escape_text (_tmp17_, (gssize) -1);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("<b>%s</b>", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_replace (_tmp15_, _tmp16_, _tmp21_);
	_g_free0 (name);
	name = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp15_);
	_tmp23_ = name;
	_tmp24_ = address;
	if (g_strcmp0 (_tmp23_, _tmp24_) == 0) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = address;
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (new_text);
		new_text = _tmp26_;
	} else {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp27_ = name;
		_tmp28_ = address;
		_tmp29_ = g_strdup_printf ("%s <span size=\"smaller\">%s</span>", _tmp27_, _tmp28_);
		_g_free0 (new_text);
		new_text = _tmp29_;
	}
	_tmp30_ = new_text;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "markup", _tmp30_, NULL);
	_g_free0 (new_text);
	_g_free0 (address);
	_g_free0 (name);
}

static void
mail_contact_manager_load_contact_data_free (gpointer _data)
{
	MailContactManagerLoadContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailContactManagerLoadContactData, _data_);
}

static void
mail_contact_manager_load_contact (MailContactManager* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	MailContactManagerLoadContactData* _data_;
	MailContactManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailContactManagerLoadContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_contact_manager_load_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_contact_manager_load_contact_co (_data_);
}

static void
mail_contact_manager_load_contact_finish (MailContactManager* self,
                                          GAsyncResult* _res_)
{
	MailContactManagerLoadContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
__lambda95_ (MailContactManager* self,
             GeeMultiMap* changes)
{
	g_return_if_fail (changes != NULL);
	{
		GeeIterator* _individual_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = gee_multi_map_get (changes, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_individual_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksIndividual* _tmp7_;
			_tmp4_ = _individual_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _individual_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			individual = (FolksIndividual*) _tmp6_;
			_tmp7_ = individual;
			mail_contact_manager_add_individual (self, _tmp7_);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
}

static void
___lambda95__folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                       GeeMultiMap* changes,
                                                                       gpointer self)
{
	__lambda95_ ((MailContactManager*) self, changes);
}

static void
mail_contact_manager_load_contact_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	MailContactManagerLoadContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_contact_manager_load_contact_co (_data_);
}

static gboolean
mail_contact_manager_load_contact_co (MailContactManagerLoadContactData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->individual_aggregator;
	g_signal_connect_object (_data_->_tmp0_, "individuals-changed-detailed", (GCallback) ___lambda95__folks_individual_aggregator_individuals_changed_detailed, _data_->self, 0);
	{
		_data_->_tmp1_ = _data_->self->priv->individual_aggregator;
		_data_->_tmp2_ = folks_individual_aggregator_get_individuals (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = gee_map_get_values (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp6_);
		_data_->_individual_it = _data_->_tmp8_;
		while (TRUE) {
			_data_->_tmp9_ = _data_->_individual_it;
			if (!gee_iterator_next (_data_->_tmp9_)) {
				break;
			}
			_data_->_tmp10_ = _data_->_individual_it;
			_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
			_data_->individual = (FolksIndividual*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->individual;
			mail_contact_manager_add_individual (_data_->self, _data_->_tmp12_);
			_g_object_unref0 (_data_->individual);
		}
		_g_object_unref0 (_data_->_individual_it);
	}
	{
		_data_->_tmp13_ = _data_->self->priv->individual_aggregator;
		_data_->_state_ = 1;
		folks_individual_aggregator_prepare (_data_->_tmp13_, mail_contact_manager_load_contact_ready, _data_);
		return FALSE;
		_state_1:
		folks_individual_aggregator_prepare_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_critical ("ContactManager.vala:185: %s", _data_->_tmp15_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_contact_manager_add_individual (MailContactManager* self,
                                     FolksIndividual* individual)
{
	gchar* individual_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* individual_collate = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = folks_individual_get_display_name (individual);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	individual_name = _tmp2_;
	_tmp3_ = individual_name;
	_tmp4_ = g_utf8_collate_key (_tmp3_, (gssize) -1);
	individual_collate = _tmp4_;
	{
		GeeIterator* _email_object_it = NULL;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp5_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) individual);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_email_object_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			FolksEmailFieldDetails* email_object = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			gchar* email = NULL;
			FolksEmailFieldDetails* _tmp11_;
			gconstpointer _tmp12_;
			gconstpointer _tmp13_;
			gchar* _tmp14_;
			GeeTreeSet* _tmp15_;
			const gchar* _tmp16_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp19_;
			GtkTreeIter _tmp20_ = {0};
			gchar* collation_key = NULL;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			GtkListStore* _tmp30_;
			GtkTreeIter _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			_tmp8_ = _email_object_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _email_object_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			email_object = (FolksEmailFieldDetails*) _tmp10_;
			_tmp11_ = email_object;
			_tmp12_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup ((const gchar*) _tmp13_);
			email = _tmp14_;
			_tmp15_ = self->priv->email_addresses;
			_tmp16_ = email;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp15_, _tmp16_)) {
				GeeTreeSet* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = self->priv->email_addresses;
				_tmp18_ = email;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
			}
			_tmp19_ = self->priv->_list_store;
			gtk_list_store_append (_tmp19_, &_tmp20_);
			iter = _tmp20_;
			_tmp21_ = individual_name;
			_tmp22_ = email;
			if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp23_ = email;
				_tmp24_ = g_utf8_collate_key (_tmp23_, (gssize) -1);
				_g_free0 (collation_key);
				collation_key = _tmp24_;
			} else {
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp25_ = individual_collate;
				_tmp26_ = email;
				_tmp27_ = g_utf8_collate_key (_tmp26_, (gssize) -1);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp25_, _tmp28_, NULL);
				_g_free0 (collation_key);
				collation_key = _tmp29_;
				_g_free0 (_tmp28_);
			}
			_tmp30_ = self->priv->_list_store;
			_tmp31_ = iter;
			_tmp32_ = individual_name;
			_tmp33_ = email;
			_tmp34_ = collation_key;
			gtk_list_store_set (_tmp30_, &_tmp31_, 0, _tmp32_, 1, _tmp33_, 2, _tmp34_, -1);
			_g_free0 (collation_key);
			_g_free0 (email);
			_g_object_unref0 (email_object);
		}
		_g_object_unref0 (_email_object_it);
	}
	_g_free0 (individual_collate);
	_g_free0 (individual_name);
}

static gint
mail_contact_manager_list_store_sort_func (GtkTreeModel* model,
                                           GtkTreeIter* a,
                                           GtkTreeIter* b)
{
	gchar* key_a = NULL;
	gchar* key_b = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	GtkTreeIter _tmp2_;
	gchar* _tmp3_ = NULL;
	GCompareFunc _tmp4_;
	gint result;
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *a;
	gtk_tree_model_get (model, &_tmp0_, 2, &_tmp1_, -1);
	_g_free0 (key_a);
	key_a = _tmp1_;
	_tmp2_ = *b;
	gtk_tree_model_get (model, &_tmp2_, 2, &_tmp3_, -1);
	_g_free0 (key_b);
	key_b = _tmp3_;
	_tmp4_ = ((GCompareFunc) g_strcmp0);
	result = _tmp4_ (key_a, key_b);
	_g_free0 (key_b);
	_g_free0 (key_a);
	return result;
}

MailContactManager*
mail_contact_manager_construct (GType object_type)
{
	MailContactManager * self = NULL;
	self = (MailContactManager*) g_object_new (object_type, NULL);
	return self;
}

MailContactManager*
mail_contact_manager_new (void)
{
	return mail_contact_manager_construct (MAIL_TYPE_CONTACT_MANAGER);
}

GtkListStore*
mail_contact_manager_get_list_store (MailContactManager* self)
{
	GtkListStore* result;
	GtkListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_list_store;
	result = _tmp0_;
	return result;
}

static void
mail_contact_manager_set_list_store (MailContactManager* self,
                                     GtkListStore* value)
{
	GtkListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_contact_manager_get_list_store (self);
	if (old_value != value) {
		GtkListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list_store);
		self->priv->_list_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_contact_manager_properties[MAIL_CONTACT_MANAGER_LIST_STORE_PROPERTY]);
	}
}

static gint
_mail_contact_manager_list_store_sort_func_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                       GtkTreeIter* a,
                                                                       GtkTreeIter* b,
                                                                       gpointer self)
{
	gint result;
	result = mail_contact_manager_list_store_sort_func (model, a, b);
	return result;
}

static GObject *
mail_contact_manager_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailContactManager * self;
	GeeTreeSet* _tmp0_;
	GtkListStore* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	parent_class = G_OBJECT_CLASS (mail_contact_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONTACT_MANAGER, MailContactManager);
	_tmp0_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->email_addresses);
	self->priv->email_addresses = _tmp0_;
	_tmp1_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
	_tmp2_ = _tmp1_;
	mail_contact_manager_set_list_store (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_list_store;
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) _tmp3_, _mail_contact_manager_list_store_sort_func_gtk_tree_iter_compare_func, NULL, NULL);
	_tmp4_ = self->priv->_list_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp4_, 2, GTK_SORT_ASCENDING);
	_tmp5_ = folks_individual_aggregator_dup ();
	_g_object_unref0 (self->priv->individual_aggregator);
	self->priv->individual_aggregator = _tmp5_;
	mail_contact_manager_load_contact (self, NULL, NULL);
	return obj;
}

static void
mail_contact_manager_class_init (MailContactManagerClass * klass,
                                 gpointer klass_data)
{
	mail_contact_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailContactManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_contact_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_contact_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_contact_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_contact_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONTACT_MANAGER_LIST_STORE_PROPERTY, mail_contact_manager_properties[MAIL_CONTACT_MANAGER_LIST_STORE_PROPERTY] = g_param_spec_object ("list-store", "list-store", "list-store", gtk_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
mail_contact_manager_instance_init (MailContactManager * self,
                                    gpointer klass)
{
	self->priv = mail_contact_manager_get_instance_private (self);
	self->priv->current_key = NULL;
	self->priv->real_key = NULL;
}

static void
mail_contact_manager_finalize (GObject * obj)
{
	MailContactManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONTACT_MANAGER, MailContactManager);
	_g_object_unref0 (self->priv->_list_store);
	_g_object_unref0 (self->priv->email_addresses);
	_g_object_unref0 (self->priv->individual_aggregator);
	_g_free0 (self->priv->current_key);
	_g_free0 (self->priv->real_key);
	G_OBJECT_CLASS (mail_contact_manager_parent_class)->finalize (obj);
}

static GType
mail_contact_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailContactManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_contact_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailContactManager), 0, (GInstanceInitFunc) mail_contact_manager_instance_init, NULL };
	GType mail_contact_manager_type_id;
	mail_contact_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "MailContactManager", &g_define_type_info, 0);
	MailContactManager_private_offset = g_type_add_instance_private (mail_contact_manager_type_id, sizeof (MailContactManagerPrivate));
	return mail_contact_manager_type_id;
}

GType
mail_contact_manager_get_type (void)
{
	static volatile gsize mail_contact_manager_type_id__once = 0;
	if (g_once_init_enter (&mail_contact_manager_type_id__once)) {
		GType mail_contact_manager_type_id;
		mail_contact_manager_type_id = mail_contact_manager_get_type_once ();
		g_once_init_leave (&mail_contact_manager_type_id__once, mail_contact_manager_type_id);
	}
	return mail_contact_manager_type_id__once;
}

static void
_vala_mail_contact_manager_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	MailContactManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_CONTACT_MANAGER, MailContactManager);
	switch (property_id) {
		case MAIL_CONTACT_MANAGER_LIST_STORE_PROPERTY:
		g_value_set_object (value, mail_contact_manager_get_list_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_contact_manager_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	MailContactManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_CONTACT_MANAGER, MailContactManager);
	switch (property_id) {
		case MAIL_CONTACT_MANAGER_LIST_STORE_PROPERTY:
		mail_contact_manager_set_list_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

