/* SignatureDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SignatureDialog.vala, do not modify */

/*
* Copyright (c) 2017-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>
*
* Authored by: Leonhard Kargl <leo.kargl@proton.me>
*/

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <webkit2/webkit2.h>
#include <granite.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <camel/camel.h>
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define MAIL_SIGNATURE_DIALOG_ACTION_GROUP_PREFIX "win"
#define MAIL_SIGNATURE_DIALOG_ACTION_PREFIX MAIL_SIGNATURE_DIALOG_ACTION_GROUP_PREFIX "."
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_SIGNATURE_DIALOG (mail_signature_dialog_get_type ())
#define MAIL_SIGNATURE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialog))
#define MAIL_SIGNATURE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialogClass))
#define MAIL_IS_SIGNATURE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_SIGNATURE_DIALOG))
#define MAIL_IS_SIGNATURE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_SIGNATURE_DIALOG))
#define MAIL_SIGNATURE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialogClass))

typedef struct _MailSignatureDialog MailSignatureDialog;
typedef struct _MailSignatureDialogClass MailSignatureDialogClass;
typedef struct _MailSignatureDialogPrivate MailSignatureDialogPrivate;

#define MAIL_TYPE_WEB_VIEW (mail_web_view_get_type ())
#define MAIL_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_WEB_VIEW, MailWebView))
#define MAIL_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_WEB_VIEW, MailWebViewClass))
#define MAIL_IS_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_WEB_VIEW))
#define MAIL_IS_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_WEB_VIEW))
#define MAIL_WEB_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_WEB_VIEW, MailWebViewClass))

typedef struct _MailWebView MailWebView;
typedef struct _MailWebViewClass MailWebViewClass;

#define MAIL_TYPE_SIGNATURE (mail_signature_get_type ())
#define MAIL_SIGNATURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_SIGNATURE, MailSignature))
#define MAIL_SIGNATURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_SIGNATURE, MailSignatureClass))
#define MAIL_IS_SIGNATURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_SIGNATURE))
#define MAIL_IS_SIGNATURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_SIGNATURE))
#define MAIL_SIGNATURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_SIGNATURE, MailSignatureClass))

typedef struct _MailSignature MailSignature;
typedef struct _MailSignatureClass MailSignatureClass;
enum  {
	MAIL_SIGNATURE_DIALOG_0_PROPERTY,
	MAIL_SIGNATURE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* mail_signature_dialog_properties[MAIL_SIGNATURE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MailSignatureDialogFinishData MailSignatureDialogFinishData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _MailSignatureDialogSetSelectedSignatureData MailSignatureDialogSetSelectedSignatureData;
typedef struct _MailSignatureDialogLoadSignaturesData MailSignatureDialogLoadSignaturesData;
typedef struct _MailSignatureDialogCreateNewSignatureData MailSignatureDialogCreateNewSignatureData;
typedef struct _Block39Data Block39Data;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MailSignatureDialog {
	HdyApplicationWindow parent_instance;
	MailSignatureDialogPrivate * priv;
};

struct _MailSignatureDialogClass {
	HdyApplicationWindowClass parent_class;
};

struct _MailSignatureDialogPrivate {
	GtkListBox* signature_list;
	GtkEntry* title_entry;
	MailWebView* web_view;
	MailSignature* current_signature;
	MailSignature* last_deleted_signature;
	GraniteWidgetsToast* toast;
	gboolean selection_change_ongoing;
};

struct _MailSignatureDialogFinishData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailSignatureDialog* self;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* child_collection;
	GList* child_it;
	GtkWidget* child;
	MailSignature* signature;
	GtkWidget* _tmp2_;
	MailSignature* _tmp3_;
	MailSignature* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	MailSignature* _tmp7_;
};

struct _MailSignatureDialogSetSelectedSignatureData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailSignatureDialog* self;
	MailSignature* signature;
	MailSignature* _tmp0_;
	MailSignature* _tmp1_;
	MailWebView* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	MailSignature* _tmp5_;
	MailSignature* _tmp6_;
	GtkEntry* _tmp7_;
	MailWebView* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	MailWebView* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	MailBackendSession* session;
	MailBackendSession* _tmp15_;
	GeeLinkedList* _account_list;
	MailBackendSession* _tmp16_;
	GeeLinkedList* _tmp17_;
	gint _account_size;
	GeeLinkedList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _account_index;
	gint _tmp21_;
	gint _tmp22_;
	MailBackendAccount* account;
	GeeLinkedList* _tmp23_;
	gpointer _tmp24_;
	ESource* identity_source;
	MailBackendSession* _tmp25_;
	MailBackendAccount* _tmp26_;
	CamelService* _tmp27_;
	CamelService* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	ESource* _tmp31_;
	ESourceMailIdentity* identity_extension;
	ESource* _tmp32_;
	ESourceExtension* _tmp33_;
	ESourceMailIdentity* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	MailBackendAccount* _tmp39_;
	CamelService* _tmp40_;
	CamelService* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GVariant* _tmp44_;
	MailBackendAccount* _tmp45_;
	CamelService* _tmp46_;
	CamelService* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	GVariant* _tmp50_;
};

struct _MailSignatureDialogLoadSignaturesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailSignatureDialog* self;
	MailBackendSession* _tmp0_;
	GList* _tmp1_;
	GList* signature_source_collection;
	GList* signature_source_it;
	ESource* _tmp2_;
	ESource* signature_source;
	MailSignature* signature;
	ESource* _tmp3_;
	MailSignature* _tmp4_;
	GtkListBox* _tmp5_;
	MailSignature* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBoxRow* _tmp9_;
};

struct _MailSignatureDialogCreateNewSignatureData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailSignatureDialog* self;
	ESource* new_signature_source;
	MailBackendSession* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	MailSignature* new_signature;
	ESource* _tmp3_;
	MailSignature* _tmp4_;
	GtkListBox* _tmp5_;
	MailSignature* _tmp6_;
	GtkListBox* _tmp7_;
	MailSignature* _tmp8_;
};

struct _Block39Data {
	int _ref_count_;
	MailSignatureDialog* self;
	GtkButton* delete_button;
	GtkMenuButton* default_menubutton;
};

static gint MailSignatureDialog_private_offset;
static gpointer mail_signature_dialog_parent_class = NULL;

VALA_EXTERN GType mail_signature_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSignatureDialog, g_object_unref)
VALA_EXTERN GType mail_web_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailWebView, g_object_unref)
VALA_EXTERN GType mail_signature_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSignature, g_object_unref)
static gboolean mail_signature_dialog_filter_func (MailSignature* signature);
VALA_EXTERN gboolean mail_signature_get_is_deleted (MailSignature* self);
static void mail_signature_dialog_finish_data_free (gpointer _data);
static void mail_signature_dialog_finish (MailSignatureDialog* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static void mail_signature_dialog_finish_finish (MailSignatureDialog* self,
                                          GAsyncResult* _res_);
static gboolean mail_signature_dialog_finish_co (MailSignatureDialogFinishData* _data_);
static void mail_signature_dialog_set_selected_signature (MailSignatureDialog* self,
                                                   MailSignature* signature,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void mail_signature_dialog_set_selected_signature_finish (MailSignatureDialog* self,
                                                          GAsyncResult* _res_);
static void mail_signature_dialog_finish_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN void mail_signature_finish_delete_signature (MailSignature* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void mail_signature_finish_delete_signature_finish (MailSignature* self,
                                                    GAsyncResult* _res_);
static void mail_signature_dialog_set_selected_signature_data_free (gpointer _data);
static gboolean mail_signature_dialog_set_selected_signature_co (MailSignatureDialogSetSelectedSignatureData* _data_);
VALA_EXTERN void mail_web_view_get_body_html (MailWebView* self,
                                  gboolean clean_for_sending,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN gchar* mail_web_view_get_body_html_finish (MailWebView* self,
                                           GAsyncResult* _res_);
static void mail_signature_dialog_set_selected_signature_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
VALA_EXTERN void mail_signature_set_content (MailSignature* self,
                                 const gchar* value);
VALA_EXTERN void mail_signature_save (MailSignature* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void mail_signature_save_finish (MailSignature* self,
                                 GAsyncResult* _res_);
VALA_EXTERN void mail_web_view_set_content_of_element (MailWebView* self,
                                           const gchar* element,
                                           const gchar* content);
VALA_EXTERN const gchar* mail_signature_get_title (MailSignature* self);
VALA_EXTERN const gchar* mail_signature_get_content (MailSignature* self);
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
VALA_EXTERN GeeLinkedList* mail_backend_session_get_accounts (MailBackendSession* self);
VALA_EXTERN ESource* mail_backend_session_get_identity_source_for_account_uid (MailBackendSession* self,
                                                                   const gchar* account_uid);
VALA_EXTERN CamelService* mail_backend_account_get_service (MailBackendAccount* self);
VALA_EXTERN const gchar* mail_signature_get_uid (MailSignature* self);
static GVariant* _variant_new16 (gboolean value);
static GVariant* _variant_new17 (gboolean value);
static void mail_signature_dialog_load_signatures_data_free (gpointer _data);
static void mail_signature_dialog_load_signatures (MailSignatureDialog* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void mail_signature_dialog_load_signatures_finish (MailSignatureDialog* self,
                                                   GAsyncResult* _res_);
static gboolean mail_signature_dialog_load_signatures_co (MailSignatureDialogLoadSignaturesData* _data_);
VALA_EXTERN GList* mail_backend_session_get_all_signature_sources (MailBackendSession* self);
VALA_EXTERN void mail_signature_new (ESource* signature_source,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_);
VALA_EXTERN MailSignature* mail_signature_new_finish (GAsyncResult* _res_);
VALA_EXTERN void mail_signature_construct (GType object_type,
                               ESource* signature_source,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN MailSignature* mail_signature_construct_finish (GAsyncResult* _res_);
static void mail_signature_dialog_load_signatures_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void mail_signature_dialog_populate_default_menu (MailSignatureDialog* self,
                                                  GMenu* menu);
static GVariant* _variant_new18 (gboolean value);
static void mail_signature_dialog_update_default_signature (MailSignatureDialog* self,
                                                     const gchar* account_uid,
                                                     GVariant* set_default);
VALA_EXTERN void mail_backend_session_set_signature_uid_for_account_uid (MailBackendSession* self,
                                                             const gchar* account_uid,
                                                             const gchar* signature_uid,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void mail_backend_session_set_signature_uid_for_account_uid_finish (MailBackendSession* self,
                                                                    GAsyncResult* _res_);
static void mail_signature_dialog_create_new_signature_data_free (gpointer _data);
static void mail_signature_dialog_create_new_signature (MailSignatureDialog* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void mail_signature_dialog_create_new_signature_finish (MailSignatureDialog* self,
                                                        GAsyncResult* _res_);
static gboolean mail_signature_dialog_create_new_signature_co (MailSignatureDialogCreateNewSignatureData* _data_);
VALA_EXTERN void mail_backend_session_create_new_signature (MailBackendSession* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN ESource* mail_backend_session_create_new_signature_finish (MailBackendSession* self,
                                                           GAsyncResult* _res_);
static void mail_signature_dialog_create_new_signature_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void mail_signature_dialog_delete_selected_signature (MailSignatureDialog* self);
VALA_EXTERN void mail_signature_delete_signature (MailSignature* self);
VALA_EXTERN MailSignatureDialog* mail_signature_dialog_new (void);
VALA_EXTERN MailSignatureDialog* mail_signature_dialog_construct (GType object_type);
static GObject * mail_signature_dialog_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
VALA_EXTERN MailWebView* mail_web_view_new (void);
VALA_EXTERN MailWebView* mail_web_view_construct (GType object_type);
VALA_EXTERN void mail_web_view_load_html (MailWebView* self,
                              const gchar* body);
static void _mail_signature_dialog_update_default_signature_g_action_group_action_state_changed (GActionGroup* _sender,
                                                                                          const gchar* action_name,
                                                                                          GVariant* state,
                                                                                          gpointer self);
static void _mail_signature_dialog___lambda142_ (MailSignatureDialog* self);
static void __mail_signature_dialog___lambda142__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _mail_signature_dialog___lambda143_ (MailSignatureDialog* self);
VALA_EXTERN void mail_signature_set_title (MailSignature* self,
                               const gchar* value);
static void __mail_signature_dialog___lambda143__gtk_editable_changed (GtkEditable* _sender,
                                                                gpointer self);
static void _mail_signature_dialog_delete_selected_signature_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static void _mail_signature_dialog___lambda144_ (MailSignatureDialog* self);
VALA_EXTERN void mail_signature_undo_delete (MailSignature* self);
static void __mail_signature_dialog___lambda144__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                                gpointer self);
static void _mail_signature_dialog___lambda145_ (Block39Data* _data39_,
                                          GtkListBoxRow* row);
static void __mail_signature_dialog___lambda145__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                     GtkListBoxRow* row,
                                                                     gpointer self);
static gboolean _mail_signature_dialog___lambda146_ (MailSignatureDialog* self);
static void __lambda147_ (MailSignatureDialog* self);
static void ___lambda147__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean __mail_signature_dialog___lambda146__gtk_widget_delete_event (GtkWidget* _sender,
                                                                       GdkEventAny* event,
                                                                       gpointer self);
static void mail_signature_dialog_finalize (GObject * obj);
static GType mail_signature_dialog_get_type_once (void);

static inline gpointer
mail_signature_dialog_get_instance_private (MailSignatureDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MailSignatureDialog_private_offset);
}

static gboolean
mail_signature_dialog_filter_func (MailSignature* signature)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (signature != NULL, FALSE);
	_tmp0_ = mail_signature_get_is_deleted (signature);
	_tmp1_ = _tmp0_;
	result = !_tmp1_;
	return result;
}

static void
mail_signature_dialog_finish_data_free (gpointer _data)
{
	MailSignatureDialogFinishData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailSignatureDialogFinishData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mail_signature_dialog_finish (MailSignatureDialog* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	MailSignatureDialogFinishData* _data_;
	MailSignatureDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailSignatureDialogFinishData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_signature_dialog_finish_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_signature_dialog_finish_co (_data_);
}

static void
mail_signature_dialog_finish_finish (MailSignatureDialog* self,
                                     GAsyncResult* _res_)
{
	MailSignatureDialogFinishData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_signature_dialog_finish_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	MailSignatureDialogFinishData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_signature_dialog_finish_co (_data_);
}

static gboolean
mail_signature_dialog_finish_co (MailSignatureDialogFinishData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	mail_signature_dialog_set_selected_signature (_data_->self, NULL, mail_signature_dialog_finish_ready, _data_);
	return FALSE;
	_state_1:
	mail_signature_dialog_set_selected_signature_finish (_data_->self, _data_->_res_);
	_data_->_tmp0_ = _data_->self->priv->signature_list;
	_data_->_tmp1_ = gtk_container_get_children ((GtkContainer*) _data_->_tmp0_);
	{
		_data_->child_collection = _data_->_tmp1_;
		for (_data_->child_it = _data_->child_collection; _data_->child_it != NULL; _data_->child_it = _data_->child_it->next) {
			_data_->child = (GtkWidget*) _data_->child_it->data;
			{
				_data_->_tmp2_ = _data_->child;
				_data_->_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, MAIL_TYPE_SIGNATURE, MailSignature));
				_data_->signature = _data_->_tmp3_;
				_data_->_tmp4_ = _data_->signature;
				_data_->_tmp5_ = mail_signature_get_is_deleted (_data_->_tmp4_);
				_data_->_tmp6_ = _data_->_tmp5_;
				if (_data_->_tmp6_) {
					_data_->_tmp7_ = _data_->signature;
					_data_->_state_ = 2;
					mail_signature_finish_delete_signature (_data_->_tmp7_, mail_signature_dialog_finish_ready, _data_);
					return FALSE;
					_state_2:
					mail_signature_finish_delete_signature_finish (_data_->_tmp7_, _data_->_res_);
				}
				_g_object_unref0 (_data_->signature);
			}
		}
		(_data_->child_collection == NULL) ? NULL : (_data_->child_collection = (g_list_free (_data_->child_collection), NULL));
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_signature_dialog_set_selected_signature_data_free (gpointer _data)
{
	MailSignatureDialogSetSelectedSignatureData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->signature);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailSignatureDialogSetSelectedSignatureData, _data_);
}

static void
mail_signature_dialog_set_selected_signature (MailSignatureDialog* self,
                                              MailSignature* signature,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	MailSignatureDialogSetSelectedSignatureData* _data_;
	MailSignatureDialog* _tmp0_;
	MailSignature* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailSignatureDialogSetSelectedSignatureData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_signature_dialog_set_selected_signature_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (signature);
	_g_object_unref0 (_data_->signature);
	_data_->signature = _tmp1_;
	mail_signature_dialog_set_selected_signature_co (_data_);
}

static void
mail_signature_dialog_set_selected_signature_finish (MailSignatureDialog* self,
                                                     GAsyncResult* _res_)
{
	MailSignatureDialogSetSelectedSignatureData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_signature_dialog_set_selected_signature_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	MailSignatureDialogSetSelectedSignatureData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_signature_dialog_set_selected_signature_co (_data_);
}

static GVariant*
_variant_new16 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new17 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gboolean
mail_signature_dialog_set_selected_signature_co (MailSignatureDialogSetSelectedSignatureData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_signature;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->self->priv->current_signature;
		_data_->_tmp2_ = _data_->self->priv->web_view;
		_data_->_state_ = 1;
		mail_web_view_get_body_html (_data_->_tmp2_, FALSE, mail_signature_dialog_set_selected_signature_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = mail_web_view_get_body_html_finish (_data_->_tmp2_, _data_->_res_);
		_data_->_tmp4_ = _data_->_tmp3_;
		mail_signature_set_content (_data_->_tmp1_, _data_->_tmp4_);
		_g_free0 (_data_->_tmp4_);
		_data_->_tmp5_ = _data_->self->priv->current_signature;
		_data_->_state_ = 2;
		mail_signature_save (_data_->_tmp5_, mail_signature_dialog_set_selected_signature_ready, _data_);
		return FALSE;
		_state_2:
		mail_signature_save_finish (_data_->_tmp5_, _data_->_res_);
	}
	_data_->_tmp6_ = _g_object_ref0 (_data_->signature);
	_g_object_unref0 (_data_->self->priv->current_signature);
	_data_->self->priv->current_signature = _data_->_tmp6_;
	if (_data_->signature == NULL) {
		_data_->_tmp7_ = _data_->self->priv->title_entry;
		gtk_entry_set_text (_data_->_tmp7_, "");
		_data_->_tmp8_ = _data_->self->priv->web_view;
		mail_web_view_set_content_of_element (_data_->_tmp8_, "body", "");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->selection_change_ongoing = TRUE;
	_data_->_tmp9_ = _data_->self->priv->title_entry;
	_data_->_tmp10_ = mail_signature_get_title (_data_->signature);
	_data_->_tmp11_ = _data_->_tmp10_;
	gtk_entry_set_text (_data_->_tmp9_, _data_->_tmp11_);
	_data_->_tmp12_ = _data_->self->priv->web_view;
	_data_->_tmp13_ = mail_signature_get_content (_data_->signature);
	_data_->_tmp14_ = _data_->_tmp13_;
	mail_web_view_set_content_of_element (_data_->_tmp12_, "body", _data_->_tmp14_);
	_data_->_tmp15_ = mail_backend_session_get_default ();
	_data_->session = _data_->_tmp15_;
	{
		_data_->_tmp16_ = _data_->session;
		_data_->_tmp17_ = mail_backend_session_get_accounts (_data_->_tmp16_);
		_data_->_account_list = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->_account_list;
		_data_->_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_account_size = _data_->_tmp20_;
		_data_->_account_index = -1;
		while (TRUE) {
			_data_->_account_index = _data_->_account_index + 1;
			_data_->_tmp21_ = _data_->_account_index;
			_data_->_tmp22_ = _data_->_account_size;
			if (!(_data_->_tmp21_ < _data_->_tmp22_)) {
				break;
			}
			_data_->_tmp23_ = _data_->_account_list;
			_data_->_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp23_, _data_->_account_index);
			_data_->account = (MailBackendAccount*) _data_->_tmp24_;
			_data_->_tmp25_ = _data_->session;
			_data_->_tmp26_ = _data_->account;
			_data_->_tmp27_ = mail_backend_account_get_service (_data_->_tmp26_);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp29_ = camel_service_get_uid (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = mail_backend_session_get_identity_source_for_account_uid (_data_->_tmp25_, _data_->_tmp30_);
			_data_->identity_source = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->identity_source;
			_data_->_tmp33_ = e_source_get_extension (_data_->_tmp32_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
			_data_->identity_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp33_, e_source_mail_identity_get_type (), ESourceMailIdentity);
			_data_->_tmp34_ = _data_->identity_extension;
			_data_->_tmp35_ = e_source_mail_identity_get_signature_uid (_data_->_tmp34_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_data_->_tmp37_ = mail_signature_get_uid (_data_->signature);
			_data_->_tmp38_ = _data_->_tmp37_;
			if (g_strcmp0 (_data_->_tmp36_, _data_->_tmp38_) == 0) {
				_data_->_tmp39_ = _data_->account;
				_data_->_tmp40_ = mail_backend_account_get_service (_data_->_tmp39_);
				_data_->_tmp41_ = _data_->_tmp40_;
				_data_->_tmp42_ = camel_service_get_uid (_data_->_tmp41_);
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp44_ = _variant_new16 (TRUE);
				g_action_group_change_action_state ((GActionGroup*) _data_->self, _data_->_tmp43_, _data_->_tmp44_);
				_g_variant_unref0 (_data_->_tmp44_);
			} else {
				_data_->_tmp45_ = _data_->account;
				_data_->_tmp46_ = mail_backend_account_get_service (_data_->_tmp45_);
				_data_->_tmp47_ = _data_->_tmp46_;
				_data_->_tmp48_ = camel_service_get_uid (_data_->_tmp47_);
				_data_->_tmp49_ = _data_->_tmp48_;
				_data_->_tmp50_ = _variant_new17 (FALSE);
				g_action_group_change_action_state ((GActionGroup*) _data_->self, _data_->_tmp49_, _data_->_tmp50_);
				_g_variant_unref0 (_data_->_tmp50_);
			}
			_g_object_unref0 (_data_->identity_source);
			_g_object_unref0 (_data_->account);
		}
		_g_object_unref0 (_data_->_account_list);
	}
	_data_->self->priv->selection_change_ongoing = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_signature_dialog_load_signatures_data_free (gpointer _data)
{
	MailSignatureDialogLoadSignaturesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailSignatureDialogLoadSignaturesData, _data_);
}

static void
mail_signature_dialog_load_signatures (MailSignatureDialog* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	MailSignatureDialogLoadSignaturesData* _data_;
	MailSignatureDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailSignatureDialogLoadSignaturesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_signature_dialog_load_signatures_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_signature_dialog_load_signatures_co (_data_);
}

static void
mail_signature_dialog_load_signatures_finish (MailSignatureDialog* self,
                                              GAsyncResult* _res_)
{
	MailSignatureDialogLoadSignaturesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_signature_dialog_load_signatures_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	MailSignatureDialogLoadSignaturesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_signature_dialog_load_signatures_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
mail_signature_dialog_load_signatures_co (MailSignatureDialogLoadSignaturesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_backend_session_get_default ();
	_data_->_tmp1_ = mail_backend_session_get_all_signature_sources (_data_->_tmp0_);
	{
		_data_->signature_source_collection = _data_->_tmp1_;
		for (_data_->signature_source_it = _data_->signature_source_collection; _data_->signature_source_it != NULL; _data_->signature_source_it = _data_->signature_source_it->next) {
			_data_->_tmp2_ = _g_object_ref0 ((ESource*) _data_->signature_source_it->data);
			_data_->signature_source = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->signature_source;
				_data_->_state_ = 1;
				mail_signature_new (_data_->_tmp3_, mail_signature_dialog_load_signatures_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp4_ = mail_signature_new_finish (_data_->_res_);
				g_object_ref_sink (_data_->_tmp4_);
				_data_->signature = _data_->_tmp4_;
				_data_->_tmp5_ = _data_->self->priv->signature_list;
				_data_->_tmp6_ = _data_->signature;
				gtk_container_add ((GtkContainer*) _data_->_tmp5_, (GtkWidget*) _data_->_tmp6_);
				_g_object_unref0 (_data_->signature);
				_g_object_unref0 (_data_->signature_source);
			}
		}
		(_data_->signature_source_collection == NULL) ? NULL : (_data_->signature_source_collection = (_g_list_free__g_object_unref0_ (_data_->signature_source_collection), NULL));
	}
	_data_->_tmp7_ = _data_->self->priv->signature_list;
	_data_->_tmp8_ = _data_->self->priv->signature_list;
	_data_->_tmp9_ = gtk_list_box_get_row_at_index (_data_->_tmp8_, 0);
	gtk_list_box_select_row (_data_->_tmp7_, _data_->_tmp9_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GVariant*
_variant_new18 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
mail_signature_dialog_populate_default_menu (MailSignatureDialog* self,
                                             GMenu* menu)
{
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = mail_backend_session_get_default ();
	session = _tmp0_;
	{
		GeeLinkedList* _account_list = NULL;
		MailBackendSession* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _account_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _account_index = 0;
		_tmp1_ = session;
		_tmp2_ = mail_backend_session_get_accounts (_tmp1_);
		_account_list = _tmp2_;
		_tmp3_ = _account_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_account_size = _tmp5_;
		_account_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			MailBackendAccount* account = NULL;
			GeeLinkedList* _tmp8_;
			gpointer _tmp9_;
			GSimpleAction* action = NULL;
			MailBackendAccount* _tmp10_;
			CamelService* _tmp11_;
			CamelService* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			GVariant* _tmp15_;
			GSimpleAction* _tmp16_;
			GSimpleAction* _tmp17_;
			GSimpleAction* _tmp18_;
			MailBackendAccount* _tmp19_;
			CamelService* _tmp20_;
			CamelService* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			MailBackendAccount* _tmp24_;
			CamelService* _tmp25_;
			CamelService* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_account_index = _account_index + 1;
			_tmp6_ = _account_index;
			_tmp7_ = _account_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _account_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _account_index);
			account = (MailBackendAccount*) _tmp9_;
			_tmp10_ = account;
			_tmp11_ = mail_backend_account_get_service (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = camel_service_get_uid (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _variant_new18 (FALSE);
			_tmp16_ = g_simple_action_new_stateful (_tmp14_, NULL, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_variant_unref0 (_tmp15_);
			action = _tmp17_;
			_tmp18_ = action;
			g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp18_);
			_tmp19_ = account;
			_tmp20_ = mail_backend_account_get_service (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = camel_service_get_display_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = account;
			_tmp25_ = mail_backend_account_get_service (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = camel_service_get_uid (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (MAIL_SIGNATURE_DIALOG_ACTION_PREFIX, _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			g_menu_append (menu, _tmp23_, _tmp30_);
			_g_free0 (_tmp30_);
			_g_object_unref0 (action);
			_g_object_unref0 (account);
		}
		_g_object_unref0 (_account_list);
	}
}

static void
mail_signature_dialog_update_default_signature (MailSignatureDialog* self,
                                                const gchar* account_uid,
                                                GVariant* set_default)
{
	gboolean _tmp0_ = FALSE;
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account_uid != NULL);
	if (self->priv->selection_change_ongoing) {
		_tmp0_ = TRUE;
	} else {
		MailSignature* _tmp1_;
		_tmp1_ = self->priv->current_signature;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = mail_backend_session_get_default ();
	session = _tmp2_;
	if (g_variant_get_boolean (set_default)) {
		MailBackendSession* _tmp3_;
		MailSignature* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = session;
		_tmp4_ = self->priv->current_signature;
		_tmp5_ = mail_signature_get_uid (_tmp4_);
		_tmp6_ = _tmp5_;
		mail_backend_session_set_signature_uid_for_account_uid (_tmp3_, account_uid, _tmp6_, NULL, NULL);
	} else {
		MailBackendSession* _tmp7_;
		_tmp7_ = session;
		mail_backend_session_set_signature_uid_for_account_uid (_tmp7_, account_uid, "none", NULL, NULL);
	}
}

static void
mail_signature_dialog_create_new_signature_data_free (gpointer _data)
{
	MailSignatureDialogCreateNewSignatureData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailSignatureDialogCreateNewSignatureData, _data_);
}

static void
mail_signature_dialog_create_new_signature (MailSignatureDialog* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	MailSignatureDialogCreateNewSignatureData* _data_;
	MailSignatureDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailSignatureDialogCreateNewSignatureData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_signature_dialog_create_new_signature_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_signature_dialog_create_new_signature_co (_data_);
}

static void
mail_signature_dialog_create_new_signature_finish (MailSignatureDialog* self,
                                                   GAsyncResult* _res_)
{
	MailSignatureDialogCreateNewSignatureData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_signature_dialog_create_new_signature_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	MailSignatureDialogCreateNewSignatureData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_signature_dialog_create_new_signature_co (_data_);
}

static gboolean
mail_signature_dialog_create_new_signature_co (MailSignatureDialogCreateNewSignatureData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_backend_session_get_default ();
	_data_->_state_ = 1;
	mail_backend_session_create_new_signature (_data_->_tmp0_, mail_signature_dialog_create_new_signature_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = mail_backend_session_create_new_signature_finish (_data_->_tmp0_, _data_->_res_);
	_data_->new_signature_source = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->new_signature_source;
	if (_data_->_tmp2_ == NULL) {
		_g_object_unref0 (_data_->new_signature_source);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->new_signature_source;
	_data_->_state_ = 2;
	mail_signature_new (_data_->_tmp3_, mail_signature_dialog_create_new_signature_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp4_ = mail_signature_new_finish (_data_->_res_);
	g_object_ref_sink (_data_->_tmp4_);
	_data_->new_signature = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->signature_list;
	_data_->_tmp6_ = _data_->new_signature;
	gtk_container_add ((GtkContainer*) _data_->_tmp5_, (GtkWidget*) _data_->_tmp6_);
	_data_->_tmp7_ = _data_->self->priv->signature_list;
	_data_->_tmp8_ = _data_->new_signature;
	gtk_list_box_select_row (_data_->_tmp7_, (GtkListBoxRow*) _data_->_tmp8_);
	_g_object_unref0 (_data_->new_signature);
	_g_object_unref0 (_data_->new_signature_source);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_signature_dialog_delete_selected_signature (MailSignatureDialog* self)
{
	MailSignature* signature = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	MailSignature* _tmp2_;
	gint index = 0;
	MailSignature* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBoxRow* _tmp7_;
	GraniteWidgetsToast* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GraniteWidgetsToast* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->signature_list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, MAIL_TYPE_SIGNATURE, MailSignature));
	signature = _tmp2_;
	index = gtk_list_box_row_get_index ((GtkListBoxRow*) signature) + 1;
	_tmp3_ = _g_object_ref0 (signature);
	_g_object_unref0 (self->priv->last_deleted_signature);
	self->priv->last_deleted_signature = _tmp3_;
	mail_signature_delete_signature (signature);
	_tmp4_ = self->priv->signature_list;
	gtk_list_box_invalidate_filter (_tmp4_);
	_tmp5_ = self->priv->signature_list;
	_tmp6_ = self->priv->signature_list;
	_tmp7_ = gtk_list_box_get_row_at_index (_tmp6_, index);
	gtk_list_box_select_row (_tmp5_, _tmp7_);
	_tmp8_ = self->priv->toast;
	_tmp9_ = mail_signature_get_title (signature);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf (_ ("'%s' deleted"), _tmp10_);
	_tmp12_ = _tmp11_;
	granite_widgets_toast_set_title (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->toast;
	granite_widgets_toast_send_notification (_tmp13_);
	_g_object_unref0 (signature);
}

MailSignatureDialog*
mail_signature_dialog_construct (GType object_type)
{
	MailSignatureDialog * self = NULL;
	self = (MailSignatureDialog*) g_object_new (object_type, NULL);
	return self;
}

MailSignatureDialog*
mail_signature_dialog_new (void)
{
	return mail_signature_dialog_construct (MAIL_TYPE_SIGNATURE_DIALOG);
}

static Block39Data*
block39_data_ref (Block39Data* _data39_)
{
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}

static void
block39_data_unref (void * _userdata_)
{
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		MailSignatureDialog* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->default_menubutton);
		_g_object_unref0 (_data39_->delete_button);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}

static void
_mail_signature_dialog_update_default_signature_g_action_group_action_state_changed (GActionGroup* _sender,
                                                                                     const gchar* action_name,
                                                                                     GVariant* state,
                                                                                     gpointer self)
{
	mail_signature_dialog_update_default_signature ((MailSignatureDialog*) self, action_name, state);
}

static void
_mail_signature_dialog___lambda142_ (MailSignatureDialog* self)
{
	mail_signature_dialog_create_new_signature (self, NULL, NULL);
}

static void
__mail_signature_dialog___lambda142__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_mail_signature_dialog___lambda142_ ((MailSignatureDialog*) self);
}

static void
_mail_signature_dialog___lambda143_ (MailSignatureDialog* self)
{
	gboolean _tmp0_ = FALSE;
	if (!self->priv->selection_change_ongoing) {
		GtkListBox* _tmp1_;
		GtkListBoxRow* _tmp2_;
		_tmp1_ = self->priv->signature_list;
		_tmp2_ = gtk_list_box_get_selected_row (_tmp1_);
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GtkEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = self->priv->signature_list;
		_tmp4_ = gtk_list_box_get_selected_row (_tmp3_);
		_tmp5_ = self->priv->title_entry;
		_tmp6_ = gtk_entry_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		mail_signature_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, MAIL_TYPE_SIGNATURE, MailSignature), _tmp7_);
	}
}

static void
__mail_signature_dialog___lambda143__gtk_editable_changed (GtkEditable* _sender,
                                                           gpointer self)
{
	_mail_signature_dialog___lambda143_ ((MailSignatureDialog*) self);
}

static void
_mail_signature_dialog_delete_selected_signature_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	mail_signature_dialog_delete_selected_signature ((MailSignatureDialog*) self);
}

static void
_mail_signature_dialog___lambda144_ (MailSignatureDialog* self)
{
	MailSignature* _tmp0_;
	GtkListBox* _tmp1_;
	_tmp0_ = self->priv->last_deleted_signature;
	mail_signature_undo_delete (_tmp0_);
	_tmp1_ = self->priv->signature_list;
	gtk_list_box_invalidate_filter (_tmp1_);
}

static void
__mail_signature_dialog___lambda144__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                           gpointer self)
{
	_mail_signature_dialog___lambda144_ ((MailSignatureDialog*) self);
}

static void
_mail_signature_dialog___lambda145_ (Block39Data* _data39_,
                                     GtkListBoxRow* row)
{
	MailSignatureDialog* self;
	GtkEntry* _tmp0_;
	MailWebView* _tmp1_;
	GtkButton* _tmp2_;
	GtkMenuButton* _tmp3_;
	self = _data39_->self;
	_tmp0_ = self->priv->title_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, row != NULL);
	_tmp1_ = self->priv->web_view;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, row != NULL);
	_tmp2_ = _data39_->delete_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, row != NULL);
	_tmp3_ = _data39_->default_menubutton;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, row != NULL);
	mail_signature_dialog_set_selected_signature (self, G_TYPE_CHECK_INSTANCE_CAST (row, MAIL_TYPE_SIGNATURE, MailSignature), NULL, NULL);
}

static void
__mail_signature_dialog___lambda145__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                GtkListBoxRow* row,
                                                                gpointer self)
{
	_mail_signature_dialog___lambda145_ (self, row);
}

static void
__lambda147_ (MailSignatureDialog* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda147__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda147_ ((MailSignatureDialog*) self);
	g_object_unref (self);
}

static gboolean
_mail_signature_dialog___lambda146_ (MailSignatureDialog* self)
{
	gboolean result;
	mail_signature_dialog_finish (self, ___lambda147__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__mail_signature_dialog___lambda146__gtk_widget_delete_event (GtkWidget* _sender,
                                                              GdkEventAny* event,
                                                              gpointer self)
{
	gboolean result;
	result = _mail_signature_dialog___lambda146_ ((MailSignatureDialog*) self);
	return result;
}

static GObject *
mail_signature_dialog_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailSignatureDialog * self;
	Block39Data* _data39_;
	HdyHeaderBar* start_header = NULL;
	HdyHeaderBar* _tmp0_ = NULL;
	HdyHeaderBar* _tmp1_;
	GtkStyleContext* _tmp2_;
	HdyHeaderBar* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkLabel* placeholder_title = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* placeholder_description = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkLabel* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkBox* placeholder = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_;
	GtkLabel* _tmp13_;
	GtkBox* _tmp14_;
	GtkLabel* _tmp15_;
	GtkBox* _tmp16_;
	GtkListBox* _tmp17_ = NULL;
	GtkListBox* _tmp18_;
	GtkListBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* add_box = NULL;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkImage* _tmp23_;
	GtkImage* _tmp24_;
	GtkBox* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp28_;
	GtkWidget* _tmp29_;
	GtkButton* _tmp30_ = NULL;
	GtkButton* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkActionBar* start_actionbar = NULL;
	GtkActionBar* _tmp33_;
	GtkActionBar* _tmp34_;
	GtkStyleContext* _tmp35_;
	GtkActionBar* _tmp36_;
	GtkButton* _tmp37_;
	GtkBox* start_box = NULL;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkStyleContext* _tmp40_;
	GtkBox* _tmp41_;
	HdyHeaderBar* _tmp42_;
	GtkBox* _tmp43_;
	GtkListBox* _tmp44_;
	GtkBox* _tmp45_;
	GtkActionBar* _tmp46_;
	GraniteHeaderLabel* title = NULL;
	GraniteHeaderLabel* _tmp47_ = NULL;
	HdyHeaderBar* end_header = NULL;
	HdyHeaderBar* _tmp48_ = NULL;
	HdyHeaderBar* _tmp49_;
	GtkStyleContext* _tmp50_;
	HdyHeaderBar* _tmp51_;
	GtkStyleContext* _tmp52_;
	HdyHeaderBar* _tmp53_;
	GraniteHeaderLabel* _tmp54_;
	gchar* _tmp55_;
	GtkEntry* _tmp56_ = NULL;
	MailWebView* _tmp57_ = NULL;
	GtkFrame* frame = NULL;
	MailWebView* _tmp65_;
	GtkWidget* _tmp66_;
	GtkFrame* _tmp67_ = NULL;
	gchar* _tmp68_;
	GtkButton* _tmp69_ = NULL;
	GtkButton* _tmp70_;
	GtkStyleContext* _tmp71_;
	GtkButton* _tmp72_;
	GtkStyleContext* _tmp73_;
	GMenu* default_menu = NULL;
	GMenu* _tmp74_;
	GtkImage* _tmp75_;
	GMenu* _tmp76_;
	GMenuModel* _tmp77_;
	gchar* _tmp78_;
	GtkMenuButton* _tmp79_ = NULL;
	GtkBox* end_actionbar = NULL;
	GtkBox* _tmp80_ = NULL;
	GtkBox* _tmp81_;
	GtkButton* _tmp82_;
	GtkBox* _tmp83_;
	GtkMenuButton* _tmp84_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkBox* _tmp86_;
	GtkEntry* _tmp87_;
	GtkBox* _tmp88_;
	GraniteHeaderLabel* _tmp89_ = NULL;
	GraniteHeaderLabel* _tmp90_;
	GtkBox* _tmp91_;
	GtkFrame* _tmp92_;
	GtkBox* _tmp93_;
	GtkBox* _tmp94_;
	GtkBox* end_box = NULL;
	GtkBox* _tmp95_;
	GtkBox* _tmp96_;
	GtkStyleContext* _tmp97_;
	GtkBox* _tmp98_;
	HdyHeaderBar* _tmp99_;
	GtkBox* _tmp100_;
	GtkBox* _tmp101_;
	GtkPaned* paned = NULL;
	GtkPaned* _tmp102_ = NULL;
	GtkPaned* _tmp103_;
	GtkBox* _tmp104_;
	GtkPaned* _tmp105_;
	GtkBox* _tmp106_;
	GraniteWidgetsToast* _tmp107_;
	GraniteWidgetsToast* _tmp108_;
	GtkOverlay* overlay = NULL;
	GtkPaned* _tmp109_;
	GtkWidget* _tmp110_;
	GtkOverlay* _tmp111_ = NULL;
	GtkOverlay* _tmp112_;
	GraniteWidgetsToast* _tmp113_;
	HdyHeaderGroup* header_group = NULL;
	HdyHeaderGroup* _tmp114_;
	HdyHeaderGroup* _tmp115_;
	HdyHeaderBar* _tmp116_;
	HdyHeaderGroup* _tmp117_;
	HdyHeaderBar* _tmp118_;
	GtkOverlay* _tmp119_;
	GMenu* _tmp120_;
	GtkButton* _tmp121_;
	GtkEntry* _tmp122_;
	GtkButton* _tmp123_;
	GraniteWidgetsToast* _tmp124_;
	GtkListBox* _tmp125_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (mail_signature_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialog);
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	_tmp0_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	start_header = _tmp0_;
	_tmp1_ = start_header;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_FLAT);
	_tmp3_ = start_header;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "default-decoration");
	_tmp5_ = (GtkLabel*) gtk_label_new (_ ("No Signatures"));
	gtk_label_set_xalign (_tmp5_, (gfloat) 0);
	g_object_ref_sink (_tmp5_);
	placeholder_title = _tmp5_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("Add signatures using the button in the toolbar below"));
	g_object_set (_tmp6_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp6_, (gfloat) 0);
	g_object_ref_sink (_tmp6_);
	placeholder_description = _tmp6_;
	_tmp7_ = placeholder_description;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp9_ = placeholder_description;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp11_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp11_, 12);
	g_object_ref_sink (_tmp11_);
	placeholder = _tmp11_;
	_tmp12_ = placeholder;
	_tmp13_ = placeholder_title;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = placeholder;
	_tmp15_ = placeholder_description;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = placeholder;
	gtk_widget_show_all ((GtkWidget*) _tmp16_);
	_tmp17_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp17_, TRUE);
	gtk_list_box_set_selection_mode (_tmp17_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->signature_list);
	self->priv->signature_list = _tmp17_;
	_tmp18_ = self->priv->signature_list;
	gtk_list_box_set_filter_func (_tmp18_, (GtkListBoxFilterFunc) mail_signature_dialog_filter_func, NULL, NULL);
	_tmp19_ = self->priv->signature_list;
	_tmp20_ = placeholder;
	gtk_list_box_set_placeholder (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp21_);
	add_box = _tmp21_;
	_tmp22_ = add_box;
	_tmp23_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = add_box;
	_tmp26_ = (GtkLabel*) gtk_label_new (_ ("Create Signature"));
	g_object_ref_sink (_tmp26_);
	_tmp27_ = _tmp26_;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = add_box;
	_tmp29_ = _g_object_ref0 ((GtkWidget*) _tmp28_);
	_tmp30_ = (GtkButton*) gtk_button_new ();
	g_object_set ((GtkContainer*) _tmp30_, "child", _tmp29_, NULL);
	_g_object_unref0 (_tmp29_);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp30_, 2);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp30_, 2);
	g_object_ref_sink (_tmp30_);
	add_button = _tmp30_;
	_tmp31_ = add_button;
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
	gtk_style_context_add_class (_tmp32_, "image-button");
	_tmp33_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp33_);
	start_actionbar = _tmp33_;
	_tmp34_ = start_actionbar;
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
	gtk_style_context_add_class (_tmp35_, GTK_STYLE_CLASS_FLAT);
	_tmp36_ = start_actionbar;
	_tmp37_ = add_button;
	gtk_action_bar_pack_start (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp38_);
	start_box = _tmp38_;
	_tmp39_ = start_box;
	_tmp40_ = gtk_widget_get_style_context ((GtkWidget*) _tmp39_);
	gtk_style_context_add_class (_tmp40_, GTK_STYLE_CLASS_SIDEBAR);
	_tmp41_ = start_box;
	_tmp42_ = start_header;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = start_box;
	_tmp44_ = self->priv->signature_list;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = start_box;
	_tmp46_ = start_actionbar;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = granite_header_label_new (_ ("Title"));
	gtk_widget_set_margin_start ((GtkWidget*) _tmp47_, 9);
	g_object_ref_sink (_tmp47_);
	title = _tmp47_;
	_tmp48_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp48_, TRUE);
	g_object_ref_sink (_tmp48_);
	end_header = _tmp48_;
	_tmp49_ = end_header;
	_tmp50_ = gtk_widget_get_style_context ((GtkWidget*) _tmp49_);
	gtk_style_context_add_class (_tmp50_, GTK_STYLE_CLASS_FLAT);
	_tmp51_ = end_header;
	_tmp52_ = gtk_widget_get_style_context ((GtkWidget*) _tmp51_);
	gtk_style_context_add_class (_tmp52_, "default-decoration");
	_tmp53_ = end_header;
	_tmp54_ = title;
	hdy_header_bar_pack_start (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = g_strdup (_ ("For example “Work” or “Personal”"));
	_tmp56_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp56_, 2);
	gtk_entry_set_placeholder_text (_tmp56_, _tmp55_);
	_g_free0 (_tmp55_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, FALSE);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->title_entry);
	self->priv->title_entry = _tmp56_;
	_tmp57_ = mail_web_view_new ();
	g_object_set ((WebKitWebView*) _tmp57_, "editable", TRUE, NULL);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp57_, FALSE);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->web_view);
	self->priv->web_view = _tmp57_;
	{
		GBytes* template = NULL;
		GBytes* _tmp58_;
		MailWebView* _tmp59_;
		GBytes* _tmp60_;
		gsize _tmp61_ = 0;
		guint8* _tmp62_;
		_tmp58_ = g_resources_lookup_data ("/io/elementary/mail/blank-editor-template.html", G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		template = _tmp58_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp59_ = self->priv->web_view;
		_tmp60_ = template;
		_tmp62_ = g_bytes_get_data (_tmp60_, &_tmp61_);
		mail_web_view_load_html (_tmp59_, (const gchar*) _tmp62_);
		_g_bytes_unref0 (template);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp63_;
		const gchar* _tmp64_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp63_ = e;
		_tmp64_ = _tmp63_->message;
		g_warning ("SignatureDialog.vala:112: Failed to load blank editor template: %s", _tmp64_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (end_header);
		_g_object_unref0 (title);
		_g_object_unref0 (start_box);
		_g_object_unref0 (start_actionbar);
		_g_object_unref0 (add_button);
		_g_object_unref0 (add_box);
		_g_object_unref0 (placeholder);
		_g_object_unref0 (placeholder_description);
		_g_object_unref0 (placeholder_title);
		_g_object_unref0 (start_header);
		block39_data_unref (_data39_);
		_data39_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp65_ = self->priv->web_view;
	_tmp66_ = _g_object_ref0 ((GtkWidget*) _tmp65_);
	_tmp67_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp67_, 12);
	g_object_set ((GtkContainer*) _tmp67_, "child", _tmp66_, NULL);
	_g_object_unref0 (_tmp66_);
	g_object_ref_sink (_tmp67_);
	frame = _tmp67_;
	_tmp68_ = g_strdup (_ ("Delete"));
	_tmp69_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_widget_set_halign ((GtkWidget*) _tmp69_, GTK_ALIGN_START);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp69_, _tmp68_);
	_g_free0 (_tmp68_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp69_, FALSE);
	g_object_ref_sink (_tmp69_);
	_data39_->delete_button = _tmp69_;
	_tmp70_ = _data39_->delete_button;
	_tmp71_ = gtk_widget_get_style_context ((GtkWidget*) _tmp70_);
	gtk_style_context_add_class (_tmp71_, GTK_STYLE_CLASS_ERROR);
	_tmp72_ = _data39_->delete_button;
	_tmp73_ = gtk_widget_get_style_context ((GtkWidget*) _tmp72_);
	gtk_style_context_remove_class (_tmp73_, "image-button");
	_tmp74_ = g_menu_new ();
	default_menu = _tmp74_;
	_tmp75_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp75_);
	_tmp76_ = default_menu;
	_tmp77_ = _g_object_ref0 ((GMenuModel*) _tmp76_);
	_tmp78_ = g_strdup (_ ("Set Default For…"));
	_tmp79_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_always_show_image ((GtkButton*) _tmp79_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp79_, GTK_ALIGN_END);
	gtk_button_set_image ((GtkButton*) _tmp79_, (GtkWidget*) _tmp75_);
	_g_object_unref0 (_tmp75_);
	gtk_button_set_image_position ((GtkButton*) _tmp79_, GTK_POS_RIGHT);
	gtk_menu_button_set_menu_model (_tmp79_, _tmp77_);
	_g_object_unref0 (_tmp77_);
	gtk_button_set_label ((GtkButton*) _tmp79_, _tmp78_);
	_g_free0 (_tmp78_);
	gtk_menu_button_set_use_popover (_tmp79_, FALSE);
	gtk_menu_button_set_direction (_tmp79_, GTK_ARROW_UP);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp79_, FALSE);
	g_object_ref_sink (_tmp79_);
	_data39_->default_menubutton = _tmp79_;
	_tmp80_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp80_, 12);
	g_object_ref_sink (_tmp80_);
	end_actionbar = _tmp80_;
	_tmp81_ = end_actionbar;
	_tmp82_ = _data39_->delete_button;
	gtk_box_pack_start (_tmp81_, (GtkWidget*) _tmp82_, TRUE, TRUE, (guint) 0);
	_tmp83_ = end_actionbar;
	_tmp84_ = _data39_->default_menubutton;
	gtk_box_pack_end (_tmp83_, (GtkWidget*) _tmp84_, TRUE, TRUE, (guint) 0);
	_tmp85_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp85_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp85_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp85_, 12);
	g_object_ref_sink (_tmp85_);
	content_box = _tmp85_;
	_tmp86_ = content_box;
	_tmp87_ = self->priv->title_entry;
	gtk_container_add ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp87_);
	_tmp88_ = content_box;
	_tmp89_ = granite_header_label_new (_ ("Signature"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp89_, 6);
	g_object_ref_sink (_tmp89_);
	_tmp90_ = _tmp89_;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp90_);
	_g_object_unref0 (_tmp90_);
	_tmp91_ = content_box;
	_tmp92_ = frame;
	gtk_container_add ((GtkContainer*) _tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = content_box;
	_tmp94_ = end_actionbar;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp95_);
	end_box = _tmp95_;
	_tmp96_ = end_box;
	_tmp97_ = gtk_widget_get_style_context ((GtkWidget*) _tmp96_);
	gtk_style_context_add_class (_tmp97_, GTK_STYLE_CLASS_VIEW);
	_tmp98_ = end_box;
	_tmp99_ = end_header;
	gtk_container_add ((GtkContainer*) _tmp98_, (GtkWidget*) _tmp99_);
	_tmp100_ = end_box;
	_tmp101_ = content_box;
	gtk_container_add ((GtkContainer*) _tmp100_, (GtkWidget*) _tmp101_);
	_tmp102_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_paned_set_position (_tmp102_, 140);
	g_object_ref_sink (_tmp102_);
	paned = _tmp102_;
	_tmp103_ = paned;
	_tmp104_ = start_box;
	gtk_paned_pack1 (_tmp103_, (GtkWidget*) _tmp104_, FALSE, FALSE);
	_tmp105_ = paned;
	_tmp106_ = end_box;
	gtk_paned_pack2 (_tmp105_, (GtkWidget*) _tmp106_, TRUE, FALSE);
	_tmp107_ = granite_widgets_toast_new ("");
	g_object_ref_sink (_tmp107_);
	_g_object_unref0 (self->priv->toast);
	self->priv->toast = _tmp107_;
	_tmp108_ = self->priv->toast;
	granite_widgets_toast_set_default_action (_tmp108_, _ ("Undo"));
	_tmp109_ = paned;
	_tmp110_ = _g_object_ref0 ((GtkWidget*) _tmp109_);
	_tmp111_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_set ((GtkContainer*) _tmp111_, "child", _tmp110_, NULL);
	_g_object_unref0 (_tmp110_);
	g_object_ref_sink (_tmp111_);
	overlay = _tmp111_;
	_tmp112_ = overlay;
	_tmp113_ = self->priv->toast;
	gtk_overlay_add_overlay (_tmp112_, (GtkWidget*) _tmp113_);
	_tmp114_ = hdy_header_group_new ();
	header_group = _tmp114_;
	_tmp115_ = header_group;
	_tmp116_ = start_header;
	hdy_header_group_add_header_bar (_tmp115_, _tmp116_);
	_tmp117_ = header_group;
	_tmp118_ = end_header;
	hdy_header_group_add_header_bar (_tmp117_, _tmp118_);
	g_object_set ((GtkWindow*) self, "default-height", 300, NULL);
	g_object_set ((GtkWindow*) self, "default-width", 500, NULL);
	_tmp119_ = overlay;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp119_);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_window_present ((GtkWindow*) self);
	mail_signature_dialog_load_signatures (self, NULL, NULL);
	_tmp120_ = default_menu;
	mail_signature_dialog_populate_default_menu (self, _tmp120_);
	g_signal_connect_object ((GActionGroup*) self, "action-state-changed", (GCallback) _mail_signature_dialog_update_default_signature_g_action_group_action_state_changed, self, 0);
	_tmp121_ = add_button;
	g_signal_connect_object (_tmp121_, "clicked", (GCallback) __mail_signature_dialog___lambda142__gtk_button_clicked, self, 0);
	_tmp122_ = self->priv->title_entry;
	g_signal_connect_object ((GtkEditable*) _tmp122_, "changed", (GCallback) __mail_signature_dialog___lambda143__gtk_editable_changed, self, 0);
	_tmp123_ = _data39_->delete_button;
	g_signal_connect_object (_tmp123_, "clicked", (GCallback) _mail_signature_dialog_delete_selected_signature_gtk_button_clicked, self, 0);
	_tmp124_ = self->priv->toast;
	g_signal_connect_object (_tmp124_, "default-action", (GCallback) __mail_signature_dialog___lambda144__granite_widgets_toast_default_action, self, 0);
	_tmp125_ = self->priv->signature_list;
	g_signal_connect_data (_tmp125_, "row-selected", (GCallback) __mail_signature_dialog___lambda145__gtk_list_box_row_selected, block39_data_ref (_data39_), (GClosureNotify) block39_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __mail_signature_dialog___lambda146__gtk_widget_delete_event, self, 0);
	_g_object_unref0 (header_group);
	_g_object_unref0 (overlay);
	_g_object_unref0 (paned);
	_g_object_unref0 (end_box);
	_g_object_unref0 (content_box);
	_g_object_unref0 (end_actionbar);
	_g_object_unref0 (default_menu);
	_g_object_unref0 (frame);
	_g_object_unref0 (end_header);
	_g_object_unref0 (title);
	_g_object_unref0 (start_box);
	_g_object_unref0 (start_actionbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_box);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (placeholder_description);
	_g_object_unref0 (placeholder_title);
	_g_object_unref0 (start_header);
	block39_data_unref (_data39_);
	_data39_ = NULL;
	return obj;
}

static void
mail_signature_dialog_class_init (MailSignatureDialogClass * klass,
                                  gpointer klass_data)
{
	mail_signature_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailSignatureDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = mail_signature_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_signature_dialog_finalize;
}

static void
mail_signature_dialog_instance_init (MailSignatureDialog * self,
                                     gpointer klass)
{
	self->priv = mail_signature_dialog_get_instance_private (self);
	self->priv->selection_change_ongoing = FALSE;
}

static void
mail_signature_dialog_finalize (GObject * obj)
{
	MailSignatureDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_SIGNATURE_DIALOG, MailSignatureDialog);
	_g_object_unref0 (self->priv->signature_list);
	_g_object_unref0 (self->priv->title_entry);
	_g_object_unref0 (self->priv->web_view);
	_g_object_unref0 (self->priv->current_signature);
	_g_object_unref0 (self->priv->last_deleted_signature);
	_g_object_unref0 (self->priv->toast);
	G_OBJECT_CLASS (mail_signature_dialog_parent_class)->finalize (obj);
}

static GType
mail_signature_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailSignatureDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_signature_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailSignatureDialog), 0, (GInstanceInitFunc) mail_signature_dialog_instance_init, NULL };
	GType mail_signature_dialog_type_id;
	mail_signature_dialog_type_id = g_type_register_static (hdy_application_window_get_type (), "MailSignatureDialog", &g_define_type_info, 0);
	MailSignatureDialog_private_offset = g_type_add_instance_private (mail_signature_dialog_type_id, sizeof (MailSignatureDialogPrivate));
	return mail_signature_dialog_type_id;
}

GType
mail_signature_dialog_get_type (void)
{
	static volatile gsize mail_signature_dialog_type_id__once = 0;
	if (g_once_init_enter (&mail_signature_dialog_type_id__once)) {
		GType mail_signature_dialog_type_id;
		mail_signature_dialog_type_id = mail_signature_dialog_get_type_once ();
		g_once_init_leave (&mail_signature_dialog_type_id__once, mail_signature_dialog_type_id);
	}
	return mail_signature_dialog_type_id__once;
}

