/**
 *
 * @file cpucblk_cpack.h
 *
 * Precision dependent routines to pack and unpack cblks.
 *
 * @copyright 2021-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Nolan Bredel
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/kernels/cpucblk_zpack.h, normal z -> c, Tue Dec 16 21:22:40 2025
 *
 **/

#ifndef _cpucblk_cpack_h_
#define _cpucblk_cpack_h_

size_t cpublok_ccompute_size_lr( pastix_coefside_t  side,
                                 pastix_int_t       N,
                                 const SolverBlok  *blok );

pastix_uint_t cpucblk_ccompute_size_lr( pastix_coefside_t  side,
                                        const SolverCblk  *cblk );

size_t cpucblk_ccompute_size( pastix_coefside_t  side,
                              const SolverCblk  *cblk );

char *cpublok_cpack_lr( pastix_coefside_t  side,
                        pastix_uint_t      N,
                        const SolverBlok  *blok,
                        char *             buffer );

void *cpucblk_cpack_lr( pastix_coefside_t  side,
                        SolverCblk        *cblk,
                        size_t             size );

char *cpublok_cunpack_lr( pastix_coefside_t  side,
                          pastix_int_t       N,
                          SolverBlok        *blok,
                          char              *buffer );

void cpucblk_cunpack_lr( pastix_coefside_t  side,
                         SolverCblk        *cblk,
                         void              *buffer );

void *cpucblk_cpack_fr( pastix_coefside_t  side,
                        const SolverCblk  *cblk );

void cpucblk_cunpack_fr( pastix_coefside_t   side,
                         SolverCblk         *cblk,
                         pastix_complex32_t *buffer );

void *cpucblk_cpack( pastix_coefside_t  side,
                     SolverCblk        *cblk,
                     size_t             size );

void cpucblk_cunpack( pastix_coefside_t  side,
                      SolverCblk        *cblk,
                      void              *buffer );

#endif /* _cpucblk_cpack_h_ */
