/* image.c generated by valac 0.56.17, the Vala compiler
 * generated from image.vala, do not modify */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#define PDFPC_PATHS_SOURCE_PATH "/build/pdfpc/src/pdfpc-4.7.0"
#define PDFPC_PATHS_SHARE_PATH "/usr/share/pdfpc"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PDFPC_RENDERER_TYPE_IMAGE (pdfpc_renderer_image_get_type ())
#define PDFPC_RENDERER_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_IMAGE, pdfpcRendererImage))
#define PDFPC_RENDERER_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_IMAGE, pdfpcRendererImageClass))
#define PDFPC_RENDERER_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_IMAGE))
#define PDFPC_RENDERER_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_IMAGE))
#define PDFPC_RENDERER_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_IMAGE, pdfpcRendererImageClass))

typedef struct _pdfpcRendererImage pdfpcRendererImage;
typedef struct _pdfpcRendererImageClass pdfpcRendererImageClass;
typedef struct _pdfpcRendererImagePrivate pdfpcRendererImagePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _pdfpcRendererParamSpecImage pdfpcRendererParamSpecImage;

struct _pdfpcRendererImage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	pdfpcRendererImagePrivate * priv;
};

struct _pdfpcRendererImageClass {
	GTypeClass parent_class;
	void (*finalize) (pdfpcRendererImage *self);
};

struct _pdfpcRendererParamSpecImage {
	GParamSpec parent_instance;
};

static gpointer pdfpc_renderer_image_parent_class = NULL;
VALA_EXTERN gboolean pdfpc_options_no_install;
VALA_EXTERN gchar* pdfpc_options_pointer_color;

VALA_EXTERN gpointer pdfpc_renderer_image_ref (gpointer instance);
VALA_EXTERN void pdfpc_renderer_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* pdfpc_renderer_param_spec_image (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void pdfpc_renderer_value_set_image (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void pdfpc_renderer_value_take_image (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer pdfpc_renderer_value_get_image (const GValue* value);
VALA_EXTERN GType pdfpc_renderer_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererImage, pdfpc_renderer_image_unref)
VALA_EXTERN cairo_surface_t* pdfpc_renderer_image_render (const gchar* filename,
                                              gint width,
                                              gint height);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
VALA_EXTERN pdfpcRendererImage* pdfpc_renderer_image_new (void);
VALA_EXTERN pdfpcRendererImage* pdfpc_renderer_image_construct (GType object_type);
static void pdfpc_renderer_image_finalize (pdfpcRendererImage * obj);
static GType pdfpc_renderer_image_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
         * Load an (SVG) image, replacing a substring in it in special cases
         */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

cairo_surface_t*
pdfpc_renderer_image_render (const gchar* filename,
                             gint width,
                             gint height)
{
	gchar* load_icon_path = NULL;
	GFile* icon_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	cairo_surface_t* result;
	g_return_val_if_fail (filename != NULL, NULL);
	if (pdfpc_options_no_install) {
		gchar* _tmp0_;
		_tmp0_ = g_build_filename (PDFPC_PATHS_SOURCE_PATH, "icons", filename, NULL);
		_g_free0 (load_icon_path);
		load_icon_path = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_build_filename (PDFPC_PATHS_SHARE_PATH, "icons", filename, NULL);
		_g_free0 (load_icon_path);
		load_icon_path = _tmp1_;
	}
	_tmp2_ = load_icon_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	icon_file = _tmp3_;
	{
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp28_;
		cairo_surface_t* _tmp29_;
		if (g_strcmp0 (filename, "highlight.svg") == 0) {
			guint8* contents = NULL;
			gint contents_length1 = 0;
			gint _contents_size_ = 0;
			gchar* etag_out = NULL;
			GFile* _tmp4_;
			guint8* _tmp5_ = NULL;
			gsize _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
			gchar* buf = NULL;
			guint8* _tmp8_;
			gint _tmp8__length1;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GMemoryInputStream* stream = NULL;
			const gchar* _tmp13_;
			guint8* _tmp14_;
			gint _tmp14__length1;
			gint _tmp15_ = 0;
			guint8* _tmp16_;
			gint _tmp16__length1;
			guint8* _tmp17_;
			gint _tmp17__length1;
			GDestroyNotify _tmp18_;
			GMemoryInputStream* _tmp19_;
			GdkPixbuf* _tmp20_ = NULL;
			GMemoryInputStream* _tmp21_;
			GdkPixbuf* _tmp22_;
			GdkPixbuf* _tmp23_;
			_tmp4_ = icon_file;
			g_file_load_contents (_tmp4_, NULL, &_tmp5_, &_tmp6_, &_tmp7_, &_inner_error0_);
			contents = (g_free (contents), NULL);
			contents = _tmp5_;
			contents_length1 = _tmp6_;
			_contents_size_ = contents_length1;
			_g_free0 (etag_out);
			etag_out = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (etag_out);
				contents = (g_free (contents), NULL);
				_g_object_unref0 (pixbuf);
				goto __catch0_g_error;
			}
			_tmp8_ = contents;
			_tmp8__length1 = contents_length1;
			_tmp9_ = g_strdup ((const gchar*) _tmp8_);
			buf = _tmp9_;
			_tmp10_ = buf;
			_tmp11_ = pdfpc_options_pointer_color;
			_tmp12_ = string_replace (_tmp10_, "pointer_color", _tmp11_);
			_g_free0 (buf);
			buf = _tmp12_;
			_tmp13_ = buf;
			_tmp14_ = string_get_data (_tmp13_, &_tmp15_);
			_tmp14__length1 = _tmp15_;
			_tmp16_ = _tmp14_;
			_tmp16__length1 = _tmp14__length1;
			_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup1 (_tmp16_, _tmp16__length1) : _tmp16_;
			_tmp17__length1 = _tmp16__length1;
			_tmp18_ = g_free;
			_tmp19_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp17_, _tmp17__length1, _tmp18_);
			stream = _tmp19_;
			_tmp21_ = stream;
			_tmp22_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) _tmp21_, width, width, TRUE, NULL, &_inner_error0_);
			_tmp20_ = _tmp22_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_free0 (buf);
				_g_free0 (etag_out);
				contents = (g_free (contents), NULL);
				_g_object_unref0 (pixbuf);
				goto __catch0_g_error;
			}
			_tmp23_ = _tmp20_;
			_tmp20_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp23_;
			_g_object_unref0 (_tmp20_);
			_g_object_unref0 (stream);
			_g_free0 (buf);
			_g_free0 (etag_out);
			contents = (g_free (contents), NULL);
		} else {
			GdkPixbuf* _tmp24_ = NULL;
			const gchar* _tmp25_;
			GdkPixbuf* _tmp26_;
			GdkPixbuf* _tmp27_;
			_tmp25_ = load_icon_path;
			_tmp26_ = gdk_pixbuf_new_from_file_at_scale (_tmp25_, width, width, TRUE, &_inner_error0_);
			_tmp24_ = _tmp26_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (pixbuf);
				goto __catch0_g_error;
			}
			_tmp27_ = _tmp24_;
			_tmp24_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp27_;
			_g_object_unref0 (_tmp24_);
		}
		_tmp28_ = pixbuf;
		_tmp29_ = gdk_cairo_surface_create_from_pixbuf (_tmp28_, 0, NULL);
		result = _tmp29_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (icon_file);
		_g_free0 (load_icon_path);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = load_icon_path;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_printerr ("Warning: Could not load image %s (%s)\n", _tmp30_, _tmp32_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (icon_file);
		_g_free0 (load_icon_path);
		return result;
	}
	__finally0:
	_g_object_unref0 (icon_file);
	_g_free0 (load_icon_path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

pdfpcRendererImage*
pdfpc_renderer_image_construct (GType object_type)
{
	pdfpcRendererImage* self = NULL;
	self = (pdfpcRendererImage*) g_type_create_instance (object_type);
	return self;
}

pdfpcRendererImage*
pdfpc_renderer_image_new (void)
{
	return pdfpc_renderer_image_construct (PDFPC_RENDERER_TYPE_IMAGE);
}

static void
pdfpc_renderer_value_image_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
pdfpc_renderer_value_image_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pdfpc_renderer_image_unref (value->data[0].v_pointer);
	}
}

static void
pdfpc_renderer_value_image_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pdfpc_renderer_image_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
pdfpc_renderer_value_image_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
pdfpc_renderer_value_image_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		pdfpcRendererImage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pdfpc_renderer_image_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
pdfpc_renderer_value_image_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	pdfpcRendererImage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pdfpc_renderer_image_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
pdfpc_renderer_param_spec_image (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	pdfpcRendererParamSpecImage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PDFPC_RENDERER_TYPE_IMAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
pdfpc_renderer_value_get_image (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PDFPC_RENDERER_TYPE_IMAGE), NULL);
	return value->data[0].v_pointer;
}

void
pdfpc_renderer_value_set_image (GValue* value,
                                gpointer v_object)
{
	pdfpcRendererImage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PDFPC_RENDERER_TYPE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PDFPC_RENDERER_TYPE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pdfpc_renderer_image_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdfpc_renderer_image_unref (old);
	}
}

void
pdfpc_renderer_value_take_image (GValue* value,
                                 gpointer v_object)
{
	pdfpcRendererImage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PDFPC_RENDERER_TYPE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PDFPC_RENDERER_TYPE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdfpc_renderer_image_unref (old);
	}
}

static void
pdfpc_renderer_image_class_init (pdfpcRendererImageClass * klass,
                                 gpointer klass_data)
{
	pdfpc_renderer_image_parent_class = g_type_class_peek_parent (klass);
	((pdfpcRendererImageClass *) klass)->finalize = pdfpc_renderer_image_finalize;
}

static void
pdfpc_renderer_image_instance_init (pdfpcRendererImage * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
pdfpc_renderer_image_finalize (pdfpcRendererImage * obj)
{
	pdfpcRendererImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_RENDERER_TYPE_IMAGE, pdfpcRendererImage);
	g_signal_handlers_destroy (self);
}

static GType
pdfpc_renderer_image_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { pdfpc_renderer_value_image_init, pdfpc_renderer_value_image_free_value, pdfpc_renderer_value_image_copy_value, pdfpc_renderer_value_image_peek_pointer, "p", pdfpc_renderer_value_image_collect_value, "p", pdfpc_renderer_value_image_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcRendererImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_renderer_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcRendererImage), 0, (GInstanceInitFunc) pdfpc_renderer_image_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pdfpc_renderer_image_type_id;
	pdfpc_renderer_image_type_id = g_type_register_fundamental (g_type_fundamental_next (), "pdfpcRendererImage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return pdfpc_renderer_image_type_id;
}

GType
pdfpc_renderer_image_get_type (void)
{
	static volatile gsize pdfpc_renderer_image_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_renderer_image_type_id__once)) {
		GType pdfpc_renderer_image_type_id;
		pdfpc_renderer_image_type_id = pdfpc_renderer_image_get_type_once ();
		g_once_init_leave (&pdfpc_renderer_image_type_id__once, pdfpc_renderer_image_type_id);
	}
	return pdfpc_renderer_image_type_id__once;
}

gpointer
pdfpc_renderer_image_ref (gpointer instance)
{
	pdfpcRendererImage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pdfpc_renderer_image_unref (gpointer instance)
{
	pdfpcRendererImage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PDFPC_RENDERER_IMAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

