// PDF Slicer
// Copyright (C) 2018 Julián Unrrein

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef SLICER_CONFIG_HPP
#define SLICER_CONFIG_HPP

#include <string>

namespace Slicer::config {

static const std::string APPLICATION_NAME = "PDF Slicer";
static const std::string APPLICATION_ID = "com.github.junrrein.PDFSlicer";
static const std::string APPLICATION_WEBSITE = "https://junrrein.github.io/pdfslicer/";
static const std::string GETEXT_PACKAGE = "com.github.junrrein.PDFSlicer";
static const std::string LINUX_LOCALE_DIR = "/usr/share/locale/";
static const std::string VERSION = "1.8.8";

void setupLocalization();
std::string getConfigDirPath();
std::string getTempDirPath();
void createSlicerDirsIfNotExistent();
}

#endif // SLICER_CONFIG_H
