/* BatteryDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from BatteryDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2018 Faissal Bensefia*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <plank.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define DOCKY_BATTERY_DOCK_ITEM_BAT_BASE_PATH "/sys/class/power_supply"
#define DOCKY_BATTERY_DOCK_ITEM_BAT_CAPACITY DOCKY_BATTERY_DOCK_ITEM_BAT_BASE_PATH "/%s/capacity"
#define DOCKY_BATTERY_DOCK_ITEM_BAT_CAPACITY_LEVEL DOCKY_BATTERY_DOCK_ITEM_BAT_BASE_PATH "/%s/capacity_level"
#define DOCKY_BATTERY_DOCK_ITEM_BAT_STATUS DOCKY_BATTERY_DOCK_ITEM_BAT_BASE_PATH "/%s/status"
#define DOCKY_BATTERY_DOCK_ITEM_BAT_CHARGE_NOW DOCKY_BATTERY_DOCK_ITEM_BAT_BASE_PATH "/%s/charge_now"
#define DOCKY_BATTERY_DOCK_ITEM_BAT_ALARM DOCKY_BATTERY_DOCK_ITEM_BAT_BASE_PATH "/%s/alarm"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define DOCKY_TYPE_BATTERY_DOCK_ITEM (docky_battery_dock_item_get_type ())
#define DOCKY_BATTERY_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_BATTERY_DOCK_ITEM, DockyBatteryDockItem))
#define DOCKY_BATTERY_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCKY_TYPE_BATTERY_DOCK_ITEM, DockyBatteryDockItemClass))
#define DOCKY_IS_BATTERY_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_BATTERY_DOCK_ITEM))
#define DOCKY_IS_BATTERY_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCKY_TYPE_BATTERY_DOCK_ITEM))
#define DOCKY_BATTERY_DOCK_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCKY_TYPE_BATTERY_DOCK_ITEM, DockyBatteryDockItemClass))

typedef struct _DockyBatteryDockItem DockyBatteryDockItem;
typedef struct _DockyBatteryDockItemClass DockyBatteryDockItemClass;
typedef struct _DockyBatteryDockItemPrivate DockyBatteryDockItemPrivate;
enum  {
	DOCKY_BATTERY_DOCK_ITEM_0_PROPERTY,
	DOCKY_BATTERY_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* docky_battery_dock_item_properties[DOCKY_BATTERY_DOCK_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DockyBatteryDockItem {
	PlankDockletItem parent_instance;
	DockyBatteryDockItemPrivate * priv;
};

struct _DockyBatteryDockItemClass {
	PlankDockletItemClass parent_class;
};

struct _DockyBatteryDockItemPrivate {
	gchar* current_battery;
	guint timer_id;
};

static gint DockyBatteryDockItem_private_offset;
static gpointer docky_battery_dock_item_parent_class = NULL;

VALA_EXTERN GType docky_battery_dock_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyBatteryDockItem, g_object_unref)
VALA_EXTERN DockyBatteryDockItem* docky_battery_dock_item_new_with_dockitem_file (GFile* file);
VALA_EXTERN DockyBatteryDockItem* docky_battery_dock_item_construct_with_dockitem_file (GType object_type,
                                                                            GFile* file);
static gint docky_battery_dock_item_get_capacity (DockyBatteryDockItem* self,
                                           GError** error);
static gchar* docky_battery_dock_item_get_capacity_level (DockyBatteryDockItem* self,
                                                   GError** error);
static gchar* docky_battery_dock_item_get_status (DockyBatteryDockItem* self,
                                           GError** error);
static gboolean docky_battery_dock_item_update (DockyBatteryDockItem* self);
VALA_EXTERN DockyBatteryDockItem* docky_battery_dock_item_new (void);
VALA_EXTERN DockyBatteryDockItem* docky_battery_dock_item_construct (GType object_type);
static GObject * docky_battery_dock_item_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void docky_battery_dock_item_finalize (GObject * obj);
static GType docky_battery_dock_item_get_type_once (void);

static inline gpointer
docky_battery_dock_item_get_instance_private (DockyBatteryDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, DockyBatteryDockItem_private_offset);
}

/**
 * {@inheritDoc}
 */
DockyBatteryDockItem*
docky_battery_dock_item_construct_with_dockitem_file (GType object_type,
                                                      GFile* file)
{
	DockyBatteryDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_file (file);
	_tmp1_ = _tmp0_;
	self = (DockyBatteryDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

DockyBatteryDockItem*
docky_battery_dock_item_new_with_dockitem_file (GFile* file)
{
	return docky_battery_dock_item_construct_with_dockitem_file (DOCKY_TYPE_BATTERY_DOCK_ITEM, file);
}

static gint
docky_battery_dock_item_get_capacity (DockyBatteryDockItem* self,
                                      GError** error)
{
	gchar* s = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current_battery;
	_tmp1_ = g_strdup_printf (DOCKY_BATTERY_DOCK_ITEM_BAT_CAPACITY, _tmp0_);
	_tmp2_ = _tmp1_;
	g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error0_);
	_g_free0 (s);
	s = _tmp3_;
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_FILE_ERROR) {
			gint _tmp4_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (s);
			return _tmp4_;
		} else {
			gint _tmp5_ = -1;
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = atoi (s);
	_g_free0 (s);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
docky_battery_dock_item_get_capacity_level (DockyBatteryDockItem* self,
                                            GError** error)
{
	gchar* s = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_battery;
	_tmp1_ = g_strdup_printf (DOCKY_BATTERY_DOCK_ITEM_BAT_CAPACITY_LEVEL, _tmp0_);
	_tmp2_ = _tmp1_;
	g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error0_);
	_g_free0 (s);
	s = _tmp3_;
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (s);
			return NULL;
		} else {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = string_strip (s);
	result = _tmp4_;
	_g_free0 (s);
	return result;
}

static gchar*
docky_battery_dock_item_get_status (DockyBatteryDockItem* self,
                                    GError** error)
{
	gchar* s = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_battery;
	_tmp1_ = g_strdup_printf (DOCKY_BATTERY_DOCK_ITEM_BAT_STATUS, _tmp0_);
	_tmp2_ = _tmp1_;
	g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error0_);
	_g_free0 (s);
	s = _tmp3_;
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (s);
			return NULL;
		} else {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = string_strip (s);
	result = _tmp4_;
	_g_free0 (s);
	return result;
}

static gboolean
docky_battery_dock_item_update (DockyBatteryDockItem* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gchar* new_icon = NULL;
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* status = NULL;
		gchar* _tmp2_;
		gint capacity = 0;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* capacity_level = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GQuark _tmp9_ = 0U;
		static GQuark _tmp8_label0 = 0;
		static GQuark _tmp8_label1 = 0;
		static GQuark _tmp8_label2 = 0;
		static GQuark _tmp8_label3 = 0;
		static GQuark _tmp8_label4 = 0;
		static GQuark _tmp8_label5 = 0;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GQuark _tmp19_ = 0U;
		static GQuark _tmp18_label0 = 0;
		static GQuark _tmp18_label1 = 0;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp1_ = docky_battery_dock_item_get_status (self, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_icon);
			goto __catch0_g_error;
		}
		_tmp2_ = g_utf8_strdown (_tmp0_, (gssize) -1);
		status = _tmp2_;
		capacity = docky_battery_dock_item_get_capacity (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (status);
			_g_free0 (_tmp0_);
			_g_free0 (new_icon);
			goto __catch0_g_error;
		}
		_tmp4_ = docky_battery_dock_item_get_capacity_level (self, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (status);
			_g_free0 (_tmp0_);
			_g_free0 (new_icon);
			goto __catch0_g_error;
		}
		_tmp5_ = g_utf8_strdown (_tmp3_, (gssize) -1);
		capacity_level = _tmp5_;
		_tmp6_ = capacity_level;
		_tmp7_ = _tmp6_;
		_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
		if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("full")))) {
			switch (0) {
				default:
				{
					gchar* _tmp10_;
					_tmp10_ = g_strdup ("battery-full");
					_g_free0 (new_icon);
					new_icon = _tmp10_;
					break;
				}
			}
		} else if ((_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("high")))) || (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("normal"))))) {
			switch (0) {
				default:
				{
					gchar* _tmp11_;
					_tmp11_ = g_strdup ("battery-good");
					_g_free0 (new_icon);
					new_icon = _tmp11_;
					break;
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label3) ? _tmp8_label3 : (_tmp8_label3 = g_quark_from_static_string ("low")))) {
			switch (0) {
				default:
				{
					gchar* _tmp12_;
					_tmp12_ = g_strdup ("battery-low");
					_g_free0 (new_icon);
					new_icon = _tmp12_;
					break;
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label4) ? _tmp8_label4 : (_tmp8_label4 = g_quark_from_static_string ("critical")))) {
			switch (0) {
				default:
				{
					gchar* _tmp13_;
					_tmp13_ = g_strdup ("battery-caution");
					_g_free0 (new_icon);
					new_icon = _tmp13_;
					break;
				}
			}
		} else if (_tmp9_ == ((0 != _tmp8_label5) ? _tmp8_label5 : (_tmp8_label5 = g_quark_from_static_string ("unknown")))) {
			switch (0) {
				default:
				{
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("battery-empty");
					_g_free0 (new_icon);
					new_icon = _tmp14_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("battery-missing");
					_g_free0 (new_icon);
					new_icon = _tmp15_;
					break;
				}
			}
		}
		_tmp16_ = status;
		_tmp17_ = _tmp16_;
		_tmp19_ = (NULL == _tmp17_) ? 0 : g_quark_from_string (_tmp17_);
		if ((_tmp19_ == ((0 != _tmp18_label0) ? _tmp18_label0 : (_tmp18_label0 = g_quark_from_static_string ("charging")))) || (_tmp19_ == ((0 != _tmp18_label1) ? _tmp18_label1 : (_tmp18_label1 = g_quark_from_static_string ("full"))))) {
			switch (0) {
				default:
				{
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = new_icon;
					_tmp21_ = g_strconcat (_tmp20_, "-charging", NULL);
					_g_free0 (new_icon);
					new_icon = _tmp21_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
		_tmp22_ = new_icon;
		plank_dock_item_set_Icon ((PlankDockItem*) self, _tmp22_);
		_tmp23_ = g_strdup_printf ("%i%%", capacity);
		_tmp24_ = _tmp23_;
		plank_dock_element_set_Text ((PlankDockElement*) self, _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (capacity_level);
		_g_free0 (_tmp3_);
		_g_free0 (status);
		_g_free0 (_tmp0_);
		_g_free0 (new_icon);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		plank_dock_item_set_Icon ((PlankDockItem*) self, "battery-missing");
		plank_dock_element_set_Text ((PlankDockElement*) self, _ ("No battery"));
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp25_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp25_;
	}
	result = TRUE;
	return result;
}

DockyBatteryDockItem*
docky_battery_dock_item_construct (GType object_type)
{
	DockyBatteryDockItem * self = NULL;
	self = (DockyBatteryDockItem*) plank_docklet_item_construct (object_type);
	return self;
}

DockyBatteryDockItem*
docky_battery_dock_item_new (void)
{
	return docky_battery_dock_item_construct (DOCKY_TYPE_BATTERY_DOCK_ITEM);
}

static GObject *
docky_battery_dock_item_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DockyBatteryDockItem * self;
	parent_class = G_OBJECT_CLASS (docky_battery_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_BATTERY_DOCK_ITEM, DockyBatteryDockItem);
	plank_dock_item_set_Icon ((PlankDockItem*) self, "battery-missing");
	plank_dock_element_set_Text ((PlankDockElement*) self, _ ("No battery"));
	docky_battery_dock_item_update (self);
	self->priv->timer_id = gdk_threads_add_timeout ((guint) (60 * 1000), (GSourceFunc) docky_battery_dock_item_update, self);
	return obj;
}

static void
docky_battery_dock_item_class_init (DockyBatteryDockItemClass * klass,
                                    gpointer klass_data)
{
	docky_battery_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DockyBatteryDockItem_private_offset);
	G_OBJECT_CLASS (klass)->constructor = docky_battery_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = docky_battery_dock_item_finalize;
}

static void
docky_battery_dock_item_instance_init (DockyBatteryDockItem * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	self->priv = docky_battery_dock_item_get_instance_private (self);
	_tmp0_ = g_strdup ("BAT0");
	self->priv->current_battery = _tmp0_;
	self->priv->timer_id = 0U;
}

static void
docky_battery_dock_item_finalize (GObject * obj)
{
	DockyBatteryDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_BATTERY_DOCK_ITEM, DockyBatteryDockItem);
	if (self->priv->timer_id > 0U) {
		g_source_remove (self->priv->timer_id);
	}
	_g_free0 (self->priv->current_battery);
	G_OBJECT_CLASS (docky_battery_dock_item_parent_class)->finalize (obj);
}

static GType
docky_battery_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DockyBatteryDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) docky_battery_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockyBatteryDockItem), 0, (GInstanceInitFunc) docky_battery_dock_item_instance_init, NULL };
	GType docky_battery_dock_item_type_id;
	docky_battery_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCKLET_ITEM, "DockyBatteryDockItem", &g_define_type_info, 0);
	DockyBatteryDockItem_private_offset = g_type_add_instance_private (docky_battery_dock_item_type_id, sizeof (DockyBatteryDockItemPrivate));
	return docky_battery_dock_item_type_id;
}

GType
docky_battery_dock_item_get_type (void)
{
	static volatile gsize docky_battery_dock_item_type_id__once = 0;
	if (g_once_init_enter (&docky_battery_dock_item_type_id__once)) {
		GType docky_battery_dock_item_type_id;
		docky_battery_dock_item_type_id = docky_battery_dock_item_get_type_once ();
		g_once_init_leave (&docky_battery_dock_item_type_id__once, docky_battery_dock_item_type_id);
	}
	return docky_battery_dock_item_type_id__once;
}

