/* DockTheme.c generated by valac 0.56.17, the Vala compiler
 * generated from DockTheme.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define PLANK_DOCK_THEME_MIN_INDICATOR_SIZE 0.0
#define PLANK_DOCK_THEME_MAX_INDICATOR_SIZE 10.0
#define PLANK_DOCK_THEME_MAX_ICON_SHADOW_SIZE 5.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_THEME_0_PROPERTY,
	PLANK_DOCK_THEME_HORIZ_PADDING_PROPERTY,
	PLANK_DOCK_THEME_TOP_PADDING_PROPERTY,
	PLANK_DOCK_THEME_BOTTOM_PADDING_PROPERTY,
	PLANK_DOCK_THEME_ITEM_PADDING_PROPERTY,
	PLANK_DOCK_THEME_INDICATOR_SIZE_PROPERTY,
	PLANK_DOCK_THEME_ICON_SHADOW_SIZE_PROPERTY,
	PLANK_DOCK_THEME_URGENT_BOUNCE_HEIGHT_PROPERTY,
	PLANK_DOCK_THEME_LAUNCH_BOUNCE_HEIGHT_PROPERTY,
	PLANK_DOCK_THEME_FADE_OPACITY_PROPERTY,
	PLANK_DOCK_THEME_CLICK_TIME_PROPERTY,
	PLANK_DOCK_THEME_URGENT_BOUNCE_TIME_PROPERTY,
	PLANK_DOCK_THEME_LAUNCH_BOUNCE_TIME_PROPERTY,
	PLANK_DOCK_THEME_ACTIVE_TIME_PROPERTY,
	PLANK_DOCK_THEME_SLIDE_TIME_PROPERTY,
	PLANK_DOCK_THEME_FADE_TIME_PROPERTY,
	PLANK_DOCK_THEME_HIDE_TIME_PROPERTY,
	PLANK_DOCK_THEME_GLOW_SIZE_PROPERTY,
	PLANK_DOCK_THEME_GLOW_TIME_PROPERTY,
	PLANK_DOCK_THEME_GLOW_PULSE_TIME_PROPERTY,
	PLANK_DOCK_THEME_URGENT_HUE_SHIFT_PROPERTY,
	PLANK_DOCK_THEME_ITEM_MOVE_TIME_PROPERTY,
	PLANK_DOCK_THEME_CASCADE_HIDE_PROPERTY,
	PLANK_DOCK_THEME_BADGE_COLOR_PROPERTY,
	PLANK_DOCK_THEME_NUM_PROPERTIES
};
static GParamSpec* plank_dock_theme_properties[PLANK_DOCK_THEME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PlankDockThemePrivate {
	gdouble _HorizPadding;
	gdouble _TopPadding;
	gdouble _BottomPadding;
	gdouble _ItemPadding;
	gdouble _IndicatorSize;
	gdouble _IconShadowSize;
	gdouble _UrgentBounceHeight;
	gdouble _LaunchBounceHeight;
	gdouble _FadeOpacity;
	gint _ClickTime;
	gint _UrgentBounceTime;
	gint _LaunchBounceTime;
	gint _ActiveTime;
	gint _SlideTime;
	gint _FadeTime;
	gint _HideTime;
	gint _GlowSize;
	gint _GlowTime;
	gint _GlowPulseTime;
	gint _UrgentHueShift;
	gint _ItemMoveTime;
	gboolean _CascadeHide;
	PlankColor _BadgeColor;
};

static gint PlankDockTheme_private_offset;
static gpointer plank_dock_theme_parent_class = NULL;

static void plank_dock_theme_real_reset_properties (PlankPreferences* base);
static void plank_dock_theme_real_verify (PlankPreferences* base,
                                   const gchar* prop);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static void plank_dock_theme_finalize (GObject * obj);
static GType plank_dock_theme_get_type_once (void);
static void _vala_plank_dock_theme_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_plank_dock_theme_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
plank_dock_theme_get_instance_private (PlankDockTheme* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockTheme_private_offset);
}

PlankDockTheme*
plank_dock_theme_construct (GType object_type,
                            const gchar* name)
{
	PlankDockTheme * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (PlankDockTheme*) plank_theme_construct_with_name (object_type, name);
	return self;
}

PlankDockTheme*
plank_dock_theme_new (const gchar* name)
{
	return plank_dock_theme_construct (PLANK_TYPE_DOCK_THEME, name);
}

/**
 * {@inheritDoc}
 */
static void
plank_dock_theme_real_reset_properties (PlankPreferences* base)
{
	PlankDockTheme * self;
	PlankColor _tmp0_ = {0};
	self = (PlankDockTheme*) base;
	PLANK_PREFERENCES_CLASS (plank_dock_theme_parent_class)->reset_properties ((PlankPreferences*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_THEME, PlankTheme));
	plank_theme_set_TopRoundness ((PlankTheme*) self, 4);
	plank_theme_set_BottomRoundness ((PlankTheme*) self, 0);
	plank_dock_theme_set_HorizPadding (self, 0.0);
	plank_dock_theme_set_TopPadding (self, -11.0);
	plank_dock_theme_set_BottomPadding (self, 2.5);
	plank_dock_theme_set_ItemPadding (self, 2.5);
	plank_dock_theme_set_IndicatorSize (self, 5.0);
	plank_dock_theme_set_IconShadowSize (self, 1.0);
	plank_dock_theme_set_UrgentBounceHeight (self, 5.0 / 3.0);
	plank_dock_theme_set_LaunchBounceHeight (self, 0.625);
	plank_dock_theme_set_FadeOpacity (self, 1.0);
	plank_dock_theme_set_ClickTime (self, 300);
	plank_dock_theme_set_UrgentBounceTime (self, 600);
	plank_dock_theme_set_LaunchBounceTime (self, 600);
	plank_dock_theme_set_ActiveTime (self, 300);
	plank_dock_theme_set_SlideTime (self, 300);
	plank_dock_theme_set_FadeTime (self, 250);
	plank_dock_theme_set_HideTime (self, 250);
	plank_dock_theme_set_GlowSize (self, 30);
	plank_dock_theme_set_GlowTime (self, 10000);
	plank_dock_theme_set_GlowPulseTime (self, 2000);
	plank_dock_theme_set_UrgentHueShift (self, 150);
	plank_dock_theme_set_ItemMoveTime (self, 450);
	plank_dock_theme_set_CascadeHide (self, TRUE);
	_tmp0_.red = 0.0;
	_tmp0_.green = 0.0;
	_tmp0_.blue = 0.0;
	_tmp0_.alpha = 0.0;
	plank_dock_theme_set_BadgeColor (self, &_tmp0_);
}

/**
 * Creates a surface for the dock background.
 *
 * @param width the width of the background
 * @param height the height of the background
 * @param position the position of the dock
 * @param model existing surface to use as basis of new surface
 * @return a new surface with the background drawn on it
 */
PlankSurface*
plank_dock_theme_create_background (PlankDockTheme* self,
                                    gint width,
                                    gint height,
                                    GtkPositionType position,
                                    PlankSurface* model)
{
	PlankSurface* surface = NULL;
	PlankSurface* _tmp0_;
	PlankSurface* _tmp1_;
	gboolean _tmp2_ = FALSE;
	PlankSurface* temp = NULL;
	PlankSurface* _tmp8_;
	cairo_t* cr = NULL;
	PlankSurface* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	gdouble rotate = 0.0;
	gdouble x_offset = 0.0;
	gdouble y_offset = 0.0;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	PlankSurface* _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_surface_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	plank_logger_verbose ("DockTheme.create_background (width = %i, height = %i)", width, height, NULL);
	_tmp0_ = plank_surface_new_with_surface (width, height, model);
	surface = _tmp0_;
	_tmp1_ = surface;
	plank_surface_clear (_tmp1_);
	if (width <= 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = height <= 0;
	}
	if (_tmp2_) {
		result = surface;
		return result;
	}
	if (position == GTK_POS_BOTTOM) {
		PlankSurface* _tmp3_;
		_tmp3_ = surface;
		plank_theme_draw_background ((PlankTheme*) self, _tmp3_);
		result = surface;
		return result;
	}
	if (position == GTK_POS_TOP) {
		PlankSurface* _tmp4_;
		PlankSurface* _tmp5_;
		_tmp4_ = surface;
		_tmp5_ = plank_surface_new_with_surface (width, height, _tmp4_);
		_g_object_unref0 (temp);
		temp = _tmp5_;
	} else {
		PlankSurface* _tmp6_;
		PlankSurface* _tmp7_;
		_tmp6_ = surface;
		_tmp7_ = plank_surface_new_with_surface (height, width, _tmp6_);
		_g_object_unref0 (temp);
		temp = _tmp7_;
	}
	_tmp8_ = temp;
	plank_theme_draw_background ((PlankTheme*) self, _tmp8_);
	_tmp9_ = surface;
	_tmp10_ = plank_surface_get_Context (_tmp9_);
	_tmp11_ = _tmp10_;
	cr = _tmp11_;
	rotate = 0.0;
	x_offset = 0.0;
	y_offset = 0.0;
	switch (position) {
		default:
		case GTK_POS_BOTTOM:
		{
			break;
		}
		case GTK_POS_TOP:
		{
			rotate = G_PI;
			x_offset = (gdouble) (-width);
			y_offset = (gdouble) (-height);
			break;
		}
		case GTK_POS_LEFT:
		{
			rotate = G_PI_2;
			y_offset = (gdouble) (-width);
			break;
		}
		case GTK_POS_RIGHT:
		{
			rotate = -G_PI_2;
			x_offset = (gdouble) (-height);
			break;
		}
	}
	_tmp12_ = cr;
	cairo_save (_tmp12_);
	_tmp13_ = cr;
	cairo_rotate (_tmp13_, rotate);
	_tmp14_ = cr;
	_tmp15_ = temp;
	_tmp16_ = plank_surface_get_Internal (_tmp15_);
	_tmp17_ = _tmp16_;
	cairo_set_source_surface (_tmp14_, _tmp17_, x_offset, y_offset);
	_tmp18_ = cr;
	cairo_paint (_tmp18_);
	_tmp19_ = cr;
	cairo_restore (_tmp19_);
	result = surface;
	_g_object_unref0 (temp);
	return result;
}

/**
 * Creates a surface for an indicator.
 *
 * @param size the size of the indicator
 * @param color the color of the indicator
 * @param model existing surface to use as basis of new surface
 * @return a new surface with the indicator drawn on it
 */
PlankSurface*
plank_dock_theme_create_indicator (PlankDockTheme* self,
                                   gint size,
                                   PlankColor* color,
                                   PlankSurface* model)
{
	PlankSurface* surface = NULL;
	PlankSurface* _tmp0_;
	PlankSurface* _tmp1_;
	cairo_t* cr = NULL;
	PlankSurface* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	gint x = 0;
	gint y = 0;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_pattern_t* rg = NULL;
	cairo_pattern_t* _tmp8_;
	cairo_pattern_t* _tmp9_;
	cairo_pattern_t* _tmp10_;
	PlankColor _tmp11_;
	PlankColor _tmp12_;
	PlankColor _tmp13_;
	cairo_pattern_t* _tmp14_;
	PlankColor _tmp15_;
	PlankColor _tmp16_;
	PlankColor _tmp17_;
	cairo_pattern_t* _tmp18_;
	PlankColor _tmp19_;
	PlankColor _tmp20_;
	PlankColor _tmp21_;
	cairo_pattern_t* _tmp22_;
	PlankColor _tmp23_;
	PlankColor _tmp24_;
	PlankColor _tmp25_;
	cairo_pattern_t* _tmp26_;
	PlankColor _tmp27_;
	PlankColor _tmp28_;
	PlankColor _tmp29_;
	cairo_t* _tmp30_;
	cairo_pattern_t* _tmp31_;
	cairo_t* _tmp32_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	plank_logger_verbose ("DockTheme.create_indicator (size = %i)", size, NULL);
	_tmp0_ = plank_surface_new_with_surface (size, size, model);
	surface = _tmp0_;
	_tmp1_ = surface;
	plank_surface_clear (_tmp1_);
	if (size <= 0) {
		result = surface;
		return result;
	}
	_tmp2_ = surface;
	_tmp3_ = plank_surface_get_Context (_tmp2_);
	_tmp4_ = _tmp3_;
	cr = _tmp4_;
	x = size / 2;
	y = x;
	_tmp5_ = cr;
	cairo_move_to (_tmp5_, (gdouble) x, (gdouble) y);
	_tmp6_ = cr;
	cairo_arc (_tmp6_, (gdouble) x, (gdouble) y, (gdouble) (size / 2), (gdouble) 0, G_PI * 2);
	_tmp7_ = cr;
	cairo_close_path (_tmp7_);
	_tmp8_ = cairo_pattern_create_radial ((gdouble) x, (gdouble) y, (gdouble) 0, (gdouble) x, (gdouble) y, (gdouble) (size / 2));
	rg = _tmp8_;
	_tmp9_ = rg;
	cairo_pattern_add_color_stop_rgba (_tmp9_, (gdouble) 0, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp10_ = rg;
	_tmp11_ = *color;
	_tmp12_ = *color;
	_tmp13_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp10_, 0.1, _tmp11_.red, _tmp12_.green, _tmp13_.blue, (gdouble) 1);
	_tmp14_ = rg;
	_tmp15_ = *color;
	_tmp16_ = *color;
	_tmp17_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp14_, 0.2, _tmp15_.red, _tmp16_.green, _tmp17_.blue, 0.6);
	_tmp18_ = rg;
	_tmp19_ = *color;
	_tmp20_ = *color;
	_tmp21_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp18_, 0.25, _tmp19_.red, _tmp20_.green, _tmp21_.blue, 0.25);
	_tmp22_ = rg;
	_tmp23_ = *color;
	_tmp24_ = *color;
	_tmp25_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp22_, 0.5, _tmp23_.red, _tmp24_.green, _tmp25_.blue, 0.15);
	_tmp26_ = rg;
	_tmp27_ = *color;
	_tmp28_ = *color;
	_tmp29_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp26_, 1.0, _tmp27_.red, _tmp28_.green, _tmp29_.blue, 0.0);
	_tmp30_ = cr;
	_tmp31_ = rg;
	cairo_set_source (_tmp30_, _tmp31_);
	_tmp32_ = cr;
	cairo_fill (_tmp32_);
	result = surface;
	_cairo_pattern_destroy0 (rg);
	return result;
}

/**
 * Creates a surface for an urgent glow.
 *
 * @param size the size of the urgent glow
 * @param color the color of the urgent glow
 * @param model existing surface to use as basis of new surface
 * @return a new surface with the urgent glow drawn on it
 */
PlankSurface*
plank_dock_theme_create_urgent_glow (PlankDockTheme* self,
                                     gint size,
                                     PlankColor* color,
                                     PlankSurface* model)
{
	PlankSurface* surface = NULL;
	PlankSurface* _tmp0_;
	PlankSurface* _tmp1_;
	cairo_t* cr = NULL;
	PlankSurface* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	gdouble x = 0.0;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_pattern_t* rg = NULL;
	cairo_pattern_t* _tmp8_;
	cairo_pattern_t* _tmp9_;
	cairo_pattern_t* _tmp10_;
	PlankColor _tmp11_;
	PlankColor _tmp12_;
	PlankColor _tmp13_;
	cairo_pattern_t* _tmp14_;
	PlankColor _tmp15_;
	PlankColor _tmp16_;
	PlankColor _tmp17_;
	cairo_pattern_t* _tmp18_;
	PlankColor _tmp19_;
	PlankColor _tmp20_;
	PlankColor _tmp21_;
	cairo_t* _tmp22_;
	cairo_pattern_t* _tmp23_;
	cairo_t* _tmp24_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	plank_logger_verbose ("DockTheme.create_urgent_glow (size = %i)", size, NULL);
	_tmp0_ = plank_surface_new_with_surface (size, size, model);
	surface = _tmp0_;
	_tmp1_ = surface;
	plank_surface_clear (_tmp1_);
	if (size <= 0) {
		result = surface;
		return result;
	}
	_tmp2_ = surface;
	_tmp3_ = plank_surface_get_Context (_tmp2_);
	_tmp4_ = _tmp3_;
	cr = _tmp4_;
	x = size / 2.0;
	_tmp5_ = cr;
	cairo_move_to (_tmp5_, x, x);
	_tmp6_ = cr;
	cairo_arc (_tmp6_, x, x, (gdouble) (size / 2), (gdouble) 0, G_PI * 2);
	_tmp7_ = cr;
	cairo_close_path (_tmp7_);
	_tmp8_ = cairo_pattern_create_radial (x, x, (gdouble) 0, x, x, (gdouble) (size / 2));
	rg = _tmp8_;
	_tmp9_ = rg;
	cairo_pattern_add_color_stop_rgba (_tmp9_, (gdouble) 0, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp10_ = rg;
	_tmp11_ = *color;
	_tmp12_ = *color;
	_tmp13_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp10_, 0.33, _tmp11_.red, _tmp12_.green, _tmp13_.blue, 0.66);
	_tmp14_ = rg;
	_tmp15_ = *color;
	_tmp16_ = *color;
	_tmp17_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp14_, 0.66, _tmp15_.red, _tmp16_.green, _tmp17_.blue, 0.33);
	_tmp18_ = rg;
	_tmp19_ = *color;
	_tmp20_ = *color;
	_tmp21_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp18_, 1.0, _tmp19_.red, _tmp20_.green, _tmp21_.blue, 0.0);
	_tmp22_ = cr;
	_tmp23_ = rg;
	cairo_set_source (_tmp22_, _tmp23_);
	_tmp24_ = cr;
	cairo_fill (_tmp24_);
	result = surface;
	_cairo_pattern_destroy0 (rg);
	return result;
}

/**
 * Draws an active glow for an item.
 *
 * @param surface the surface to draw onto
 * @param clip_rect the rect to clip the glow to
 * @param rect the rect for the glow
 * @param color the color of the glow
 * @param opacity the opacity of the glow
 * @param pos the dock's position
 */
void
plank_dock_theme_draw_active_glow (PlankDockTheme* self,
                                   PlankSurface* surface,
                                   GdkRectangle* clip_rect,
                                   GdkRectangle* rect,
                                   PlankColor* color,
                                   gdouble opacity,
                                   GtkPositionType pos)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_t* cr = NULL;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	gdouble rotate = 0.0;
	gdouble xoffset = 0.0;
	gdouble yoffset = 0.0;
	cairo_pattern_t* gradient = NULL;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	gboolean _tmp35_ = FALSE;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	cairo_t* _tmp46_;
	cairo_pattern_t* _tmp47_;
	PlankColor _tmp48_;
	PlankColor _tmp49_;
	PlankColor _tmp50_;
	cairo_pattern_t* _tmp51_;
	PlankColor _tmp52_;
	PlankColor _tmp53_;
	PlankColor _tmp54_;
	cairo_t* _tmp55_;
	GdkRectangle _tmp56_;
	GdkRectangle _tmp57_;
	GdkRectangle _tmp58_;
	GdkRectangle _tmp59_;
	cairo_t* _tmp60_;
	cairo_pattern_t* _tmp61_;
	cairo_t* _tmp62_;
	cairo_t* _tmp63_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (clip_rect != NULL);
	g_return_if_fail (rect != NULL);
	g_return_if_fail (color != NULL);
	if (opacity <= 0.0) {
		_tmp1_ = TRUE;
	} else {
		GdkRectangle _tmp2_;
		_tmp2_ = *rect;
		_tmp1_ = _tmp2_.width <= 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GdkRectangle _tmp3_;
		_tmp3_ = *rect;
		_tmp0_ = _tmp3_.height <= 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = plank_surface_get_Context (surface);
	_tmp5_ = _tmp4_;
	cr = _tmp5_;
	rotate = 0.0;
	xoffset = 0.0;
	yoffset = 0.0;
	gradient = NULL;
	switch (pos) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp6_;
			GdkRectangle _tmp7_;
			GdkRectangle _tmp8_;
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			cairo_pattern_t* _tmp11_;
			_tmp6_ = *clip_rect;
			xoffset = (gdouble) _tmp6_.x;
			_tmp7_ = *clip_rect;
			yoffset = (gdouble) _tmp7_.y;
			_tmp8_ = *rect;
			_tmp9_ = *rect;
			_tmp10_ = *rect;
			_tmp11_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) _tmp8_.y, (gdouble) 0, (gdouble) (_tmp9_.y + _tmp10_.height));
			_cairo_pattern_destroy0 (gradient);
			gradient = _tmp11_;
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp12_;
			GdkRectangle _tmp13_;
			GdkRectangle _tmp14_;
			GdkRectangle _tmp15_;
			GdkRectangle _tmp16_;
			GdkRectangle _tmp17_;
			cairo_pattern_t* _tmp18_;
			rotate = G_PI;
			_tmp12_ = *clip_rect;
			_tmp13_ = *clip_rect;
			xoffset = (gdouble) ((-_tmp12_.x) - _tmp13_.width);
			_tmp14_ = *clip_rect;
			yoffset = (gdouble) (-_tmp14_.height);
			_tmp15_ = *rect;
			_tmp16_ = *rect;
			_tmp17_ = *rect;
			_tmp18_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) (_tmp15_.y + _tmp16_.height), (gdouble) 0, (gdouble) _tmp17_.y);
			_cairo_pattern_destroy0 (gradient);
			gradient = _tmp18_;
			break;
		}
		case GTK_POS_LEFT:
		{
			GdkRectangle _tmp19_;
			GdkRectangle _tmp20_;
			GdkRectangle _tmp21_;
			GdkRectangle _tmp22_;
			GdkRectangle _tmp23_;
			cairo_pattern_t* _tmp24_;
			rotate = G_PI_2;
			_tmp19_ = *clip_rect;
			xoffset = (gdouble) _tmp19_.y;
			_tmp20_ = *clip_rect;
			yoffset = (gdouble) (-_tmp20_.width);
			_tmp21_ = *rect;
			_tmp22_ = *rect;
			_tmp23_ = *rect;
			_tmp24_ = cairo_pattern_create_linear ((gdouble) (_tmp21_.x + _tmp22_.width), (gdouble) 0, (gdouble) _tmp23_.x, (gdouble) 0);
			_cairo_pattern_destroy0 (gradient);
			gradient = _tmp24_;
			break;
		}
		case GTK_POS_RIGHT:
		{
			GdkRectangle _tmp25_;
			GdkRectangle _tmp26_;
			GdkRectangle _tmp27_;
			GdkRectangle _tmp28_;
			GdkRectangle _tmp29_;
			GdkRectangle _tmp30_;
			cairo_pattern_t* _tmp31_;
			rotate = -G_PI_2;
			_tmp25_ = *clip_rect;
			_tmp26_ = *clip_rect;
			xoffset = (gdouble) ((-_tmp25_.y) - _tmp26_.height);
			_tmp27_ = *clip_rect;
			yoffset = (gdouble) _tmp27_.x;
			_tmp28_ = *rect;
			_tmp29_ = *rect;
			_tmp30_ = *rect;
			_tmp31_ = cairo_pattern_create_linear ((gdouble) _tmp28_.x, (gdouble) 0, (gdouble) (_tmp29_.x + _tmp30_.width), (gdouble) 0);
			_cairo_pattern_destroy0 (gradient);
			gradient = _tmp31_;
			break;
		}
	}
	_tmp32_ = cr;
	cairo_save (_tmp32_);
	_tmp33_ = cr;
	cairo_rotate (_tmp33_, rotate);
	_tmp34_ = cr;
	cairo_translate (_tmp34_, xoffset, yoffset);
	if (pos == GTK_POS_BOTTOM) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = pos == GTK_POS_TOP;
	}
	if (_tmp35_) {
		cairo_t* _tmp36_;
		GdkRectangle _tmp37_;
		GdkRectangle _tmp38_;
		_tmp36_ = cr;
		_tmp37_ = *clip_rect;
		_tmp38_ = *clip_rect;
		plank_theme_draw_inner_rect ((PlankTheme*) self, _tmp36_, _tmp37_.width, _tmp38_.height);
	} else {
		cairo_t* _tmp39_;
		GdkRectangle _tmp40_;
		GdkRectangle _tmp41_;
		_tmp39_ = cr;
		_tmp40_ = *clip_rect;
		_tmp41_ = *clip_rect;
		plank_theme_draw_inner_rect ((PlankTheme*) self, _tmp39_, _tmp40_.height, _tmp41_.width);
	}
	_tmp42_ = cr;
	cairo_restore (_tmp42_);
	_tmp43_ = cr;
	_tmp44_ = plank_theme_get_LineWidth ((PlankTheme*) self);
	_tmp45_ = _tmp44_;
	cairo_set_line_width (_tmp43_, (gdouble) _tmp45_);
	_tmp46_ = cr;
	cairo_clip (_tmp46_);
	_tmp47_ = gradient;
	_tmp48_ = *color;
	_tmp49_ = *color;
	_tmp50_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp47_, (gdouble) 0, _tmp48_.red, _tmp49_.green, _tmp50_.blue, (gdouble) 0);
	_tmp51_ = gradient;
	_tmp52_ = *color;
	_tmp53_ = *color;
	_tmp54_ = *color;
	cairo_pattern_add_color_stop_rgba (_tmp51_, (gdouble) 1, _tmp52_.red, _tmp53_.green, _tmp54_.blue, 0.6 * opacity);
	_tmp55_ = cr;
	_tmp56_ = *rect;
	_tmp57_ = *rect;
	_tmp58_ = *rect;
	_tmp59_ = *rect;
	cairo_rectangle (_tmp55_, (gdouble) _tmp56_.x, (gdouble) _tmp57_.y, (gdouble) _tmp58_.width, (gdouble) _tmp59_.height);
	_tmp60_ = cr;
	_tmp61_ = gradient;
	cairo_set_source (_tmp60_, _tmp61_);
	_tmp62_ = cr;
	cairo_fill (_tmp62_);
	_tmp63_ = cr;
	cairo_reset_clip (_tmp63_);
	_cairo_pattern_destroy0 (gradient);
}

/**
 * Draws a badge for an item.
 *
 * @param surface the surface to draw the badge onto
 * @param icon_size the icon-size of the dock
 * @param color the color of the badge
 * @param count the number for the badge to show
 */
void
plank_dock_theme_draw_item_count (PlankDockTheme* self,
                                  PlankSurface* surface,
                                  gint icon_size,
                                  PlankColor* color,
                                  gint64 count)
{
	cairo_t* cr = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gdouble x = 0.0;
	gint _tmp2_;
	gint _tmp3_;
	gdouble y = 0.0;
	gint _tmp4_;
	gint _tmp5_;
	PlankColor badge_color_start = {0};
	PlankColor _tmp6_;
	PlankColor badge_color_middle = {0};
	PlankColor _tmp7_;
	PlankColor badge_color_end = {0};
	PlankColor _tmp8_;
	PlankColor stroke_color_start = {0};
	PlankColor _tmp9_;
	PlankColor stroke_color_end = {0};
	PlankColor _tmp10_;
	gboolean is_small = FALSE;
	gboolean is_large = FALSE;
	gdouble _tmp11_ = 0.0;
	gdouble padding = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble line_width = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble height = 0.0;
	gdouble width = 0.0;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gdouble _tmp20_;
	gdouble max_width = 0.0;
	cairo_t* _tmp21_;
	cairo_pattern_t* stroke = NULL;
	cairo_pattern_t* fill = NULL;
	PangoLayout* layout = NULL;
	PangoContext* _tmp53_;
	PangoContext* _tmp54_;
	PangoLayout* _tmp55_;
	PangoLayout* _tmp56_;
	PangoLayout* _tmp57_;
	PangoLayout* _tmp58_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp59_;
	PangoFontDescription* font_description = NULL;
	GtkStyleContext* _tmp60_;
	GtkStyleContext* _tmp61_;
	PangoFontDescription* _tmp62_;
	PangoFontDescription* _tmp63_;
	PangoFontDescription* _tmp64_;
	PangoLayout* _tmp65_;
	PangoFontDescription* _tmp66_;
	PangoLayout* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	PangoRectangle logical_rect = {0};
	PangoLayout* _tmp70_;
	PangoRectangle _tmp71_ = {0};
	gdouble scale = 0.0;
	PangoRectangle _tmp72_;
	PangoRectangle _tmp73_;
	cairo_t* _tmp76_;
	PangoRectangle _tmp77_;
	PangoRectangle _tmp78_;
	cairo_t* _tmp79_;
	cairo_t* _tmp81_;
	cairo_t* _tmp82_;
	PangoLayout* _tmp83_;
	cairo_t* _tmp84_;
	cairo_t* _tmp85_;
	cairo_t* _tmp86_;
	cairo_t* _tmp87_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = plank_surface_get_Context (surface);
	_tmp1_ = _tmp0_;
	cr = _tmp1_;
	_tmp2_ = plank_surface_get_Width (surface);
	_tmp3_ = _tmp2_;
	x = floor ((gdouble) ((_tmp3_ - icon_size) / 2));
	_tmp4_ = plank_surface_get_Height (surface);
	_tmp5_ = _tmp4_;
	y = floor ((gdouble) ((_tmp5_ - icon_size) / 2));
	_tmp6_ = *color;
	badge_color_start = _tmp6_;
	plank_color_brighten_val (&badge_color_start, 1.0);
	_tmp7_ = *color;
	badge_color_middle = _tmp7_;
	plank_color_set_sat (&badge_color_middle, 0.87);
	_tmp8_ = *color;
	badge_color_end = _tmp8_;
	plank_color_set_sat (&badge_color_end, 0.87);
	plank_color_darken_val (&badge_color_end, 0.7);
	_tmp9_ = *color;
	stroke_color_start = _tmp9_;
	plank_color_set_sat (&stroke_color_start, 0.9);
	_tmp10_ = *color;
	stroke_color_end = _tmp10_;
	plank_color_set_sat (&stroke_color_end, 0.9);
	plank_color_darken_val (&stroke_color_end, 0.9);
	is_small = icon_size < 32;
	is_large = icon_size > 54;
	if (is_small) {
		_tmp11_ = 1.0;
	} else {
		gdouble _tmp12_ = 0.0;
		if (is_large) {
			_tmp12_ = 4.5;
		} else {
			_tmp12_ = 2.0;
		}
		_tmp11_ = _tmp12_;
	}
	padding = _tmp11_;
	if (is_small) {
		_tmp13_ = 0.0;
	} else {
		gdouble _tmp14_ = 0.0;
		if (is_large) {
			_tmp14_ = 2.0;
		} else {
			_tmp14_ = 1.0;
		}
		_tmp13_ = _tmp14_;
	}
	line_width = _tmp13_;
	if (is_small) {
		_tmp15_ = 0.80;
	} else {
		_tmp15_ = 0.50;
	}
	height = floor ((_tmp15_ * icon_size) - (2.0 * line_width));
	_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, count);
	_tmp17_ = _tmp16_;
	_tmp18_ = strlen (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = floor ((0.75 + (0.25 * _tmp19_)) * height);
	_g_free0 (_tmp17_);
	width = _tmp20_;
	max_width = icon_size - (2.0 * line_width);
	if (width > max_width) {
		width = max_width;
	}
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL) {
		x += line_width + (line_width / 2.0);
	} else {
		x += (icon_size - width) - (1.5 * line_width);
	}
	y += line_width + (line_width / 2.0);
	_tmp21_ = cr;
	cairo_set_line_width (_tmp21_, line_width);
	if (!is_small) {
		cairo_pattern_t* _tmp22_;
		cairo_t* _tmp23_;
		cairo_pattern_t* _tmp24_;
		cairo_pattern_t* _tmp25_;
		cairo_pattern_t* _tmp26_;
		PlankColor _tmp27_;
		PlankColor _tmp28_;
		PlankColor _tmp29_;
		cairo_pattern_t* _tmp30_;
		PlankColor _tmp31_;
		PlankColor _tmp32_;
		PlankColor _tmp33_;
		cairo_pattern_t* _tmp34_;
		cairo_pattern_t* _tmp35_;
		PlankColor _tmp36_;
		PlankColor _tmp37_;
		PlankColor _tmp38_;
		cairo_pattern_t* _tmp39_;
		PlankColor _tmp40_;
		PlankColor _tmp41_;
		PlankColor _tmp42_;
		cairo_pattern_t* _tmp43_;
		PlankColor _tmp44_;
		PlankColor _tmp45_;
		PlankColor _tmp46_;
		cairo_t* _tmp47_;
		cairo_pattern_t* _tmp48_;
		cairo_pattern_t* _tmp49_;
		cairo_pattern_t* _tmp50_;
		cairo_t* _tmp51_;
		cairo_pattern_t* _tmp52_;
		_tmp22_ = cairo_pattern_create_rgba (0.2, 0.2, 0.2, 0.3);
		_cairo_pattern_destroy0 (stroke);
		stroke = _tmp22_;
		_tmp23_ = cr;
		_tmp24_ = stroke;
		plank_theme_draw_rounded_line (_tmp23_, x, y, width + line_width, height, TRUE, TRUE, _tmp24_, NULL);
		_tmp25_ = cairo_pattern_create_linear ((gdouble) 0, y, (gdouble) 0, y + height);
		_cairo_pattern_destroy0 (stroke);
		stroke = _tmp25_;
		_tmp26_ = stroke;
		_tmp27_ = stroke_color_start;
		_tmp28_ = stroke_color_start;
		_tmp29_ = stroke_color_start;
		cairo_pattern_add_color_stop_rgba (_tmp26_, 0.2, _tmp27_.red, _tmp28_.green, _tmp29_.blue, 0.8);
		_tmp30_ = stroke;
		_tmp31_ = stroke_color_end;
		_tmp32_ = stroke_color_end;
		_tmp33_ = stroke_color_end;
		cairo_pattern_add_color_stop_rgba (_tmp30_, 0.8, _tmp31_.red, _tmp32_.green, _tmp33_.blue, 0.8);
		_tmp34_ = cairo_pattern_create_linear ((gdouble) 0, y, (gdouble) 0, y + height);
		_cairo_pattern_destroy0 (fill);
		fill = _tmp34_;
		_tmp35_ = fill;
		_tmp36_ = badge_color_start;
		_tmp37_ = badge_color_start;
		_tmp38_ = badge_color_start;
		cairo_pattern_add_color_stop_rgba (_tmp35_, 0.1, _tmp36_.red, _tmp37_.green, _tmp38_.blue, 1.0);
		_tmp39_ = fill;
		_tmp40_ = badge_color_middle;
		_tmp41_ = badge_color_middle;
		_tmp42_ = badge_color_middle;
		cairo_pattern_add_color_stop_rgba (_tmp39_, 0.5, _tmp40_.red, _tmp41_.green, _tmp42_.blue, 1.0);
		_tmp43_ = fill;
		_tmp44_ = badge_color_end;
		_tmp45_ = badge_color_end;
		_tmp46_ = badge_color_end;
		cairo_pattern_add_color_stop_rgba (_tmp43_, 0.9, _tmp44_.red, _tmp45_.green, _tmp46_.blue, 1.0);
		_tmp47_ = cr;
		_tmp48_ = stroke;
		_tmp49_ = fill;
		plank_theme_draw_rounded_line (_tmp47_, x, y, width, height, TRUE, TRUE, _tmp48_, _tmp49_);
		_tmp50_ = cairo_pattern_create_rgba (0.9, 0.9, 0.9, 0.1);
		_cairo_pattern_destroy0 (stroke);
		stroke = _tmp50_;
		_tmp51_ = cr;
		_tmp52_ = stroke;
		plank_theme_draw_rounded_line (_tmp51_, x + line_width, y + line_width, width - (2 * line_width), height - (2 * line_width), TRUE, TRUE, _tmp52_, NULL);
	}
	_tmp53_ = gdk_pango_context_get ();
	_tmp54_ = _tmp53_;
	_tmp55_ = pango_layout_new (_tmp54_);
	_tmp56_ = _tmp55_;
	_g_object_unref0 (_tmp54_);
	layout = _tmp56_;
	_tmp57_ = layout;
	pango_layout_set_width (_tmp57_, (gint) (width * PANGO_SCALE));
	_tmp58_ = layout;
	pango_layout_set_ellipsize (_tmp58_, PANGO_ELLIPSIZE_NONE);
	_tmp59_ = plank_theme_get_style_context ((PlankTheme*) self);
	style_context = _tmp59_;
	_tmp60_ = style_context;
	_tmp61_ = style_context;
	_tmp62_ = gtk_style_context_get_font (_tmp60_, gtk_style_context_get_state (_tmp61_));
	font_description = _tmp62_;
	_tmp63_ = font_description;
	pango_font_description_set_absolute_size (_tmp63_, (gdouble) ((gint) (height * PANGO_SCALE)));
	_tmp64_ = font_description;
	pango_font_description_set_weight (_tmp64_, PANGO_WEIGHT_BOLD);
	_tmp65_ = layout;
	_tmp66_ = font_description;
	pango_layout_set_font_description (_tmp65_, _tmp66_);
	_tmp67_ = layout;
	_tmp68_ = g_strdup_printf ("%" G_GINT64_FORMAT, count);
	_tmp69_ = _tmp68_;
	pango_layout_set_text (_tmp67_, _tmp69_, -1);
	_g_free0 (_tmp69_);
	_tmp70_ = layout;
	pango_layout_get_pixel_extents (_tmp70_, NULL, &_tmp71_);
	logical_rect = _tmp71_;
	_tmp72_ = logical_rect;
	_tmp73_ = logical_rect;
	scale = MIN (1.0, MIN (((width - (2.0 * padding)) - (2.0 * line_width)) / ((gdouble) _tmp72_.width), (height - (2.0 * padding)) / ((gdouble) _tmp73_.height)));
	if (!is_small) {
		cairo_t* _tmp74_;
		_tmp74_ = cr;
		cairo_set_source_rgba (_tmp74_, 0.0, 0.0, 0.0, 0.2);
	} else {
		cairo_t* _tmp75_;
		_tmp75_ = cr;
		cairo_set_source_rgba (_tmp75_, 0.0, 0.0, 0.0, 0.6);
	}
	_tmp76_ = cr;
	_tmp77_ = logical_rect;
	_tmp78_ = logical_rect;
	cairo_move_to (_tmp76_, x + floor ((width / 2.0) - ((scale * _tmp77_.width) / 2.0)), y + floor ((height / 2.0) - ((scale * _tmp78_.height) / 2.0)));
	_tmp79_ = cr;
	cairo_save (_tmp79_);
	if (scale < ((gdouble) 1)) {
		cairo_t* _tmp80_;
		_tmp80_ = cr;
		cairo_scale (_tmp80_, scale, scale);
	}
	_tmp81_ = cr;
	cairo_set_line_width (_tmp81_, line_width);
	_tmp82_ = cr;
	_tmp83_ = layout;
	pango_cairo_layout_path (_tmp82_, _tmp83_);
	_tmp84_ = cr;
	cairo_stroke_preserve (_tmp84_);
	_tmp85_ = cr;
	cairo_set_source_rgba (_tmp85_, 1.0, 1.0, 1.0, 0.95);
	_tmp86_ = cr;
	cairo_fill (_tmp86_);
	_tmp87_ = cr;
	cairo_restore (_tmp87_);
	_g_object_unref0 (layout);
	_cairo_pattern_destroy0 (fill);
	_cairo_pattern_destroy0 (stroke);
}

/**
 * Draws a progress bar for an item.
 *
 * @param surface the surface to draw the progress onto
 * @param icon_size the icon-size of the dock
 * @param color the color of the progress
 * @param progress the value between 0.0 and 1.0
 */
void
plank_dock_theme_draw_item_progress (PlankDockTheme* self,
                                     PlankSurface* surface,
                                     gint icon_size,
                                     PlankColor* color,
                                     gdouble progress)
{
	cairo_t* cr = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gdouble x = 0.0;
	gint _tmp2_;
	gint _tmp3_;
	gdouble y = 0.0;
	gint _tmp4_;
	gint _tmp5_;
	gdouble line_width = 0.0;
	gdouble padding = 0.0;
	gdouble width = 0.0;
	gdouble height = 0.0;
	cairo_t* _tmp6_;
	cairo_pattern_t* stroke = NULL;
	cairo_pattern_t* fill = NULL;
	cairo_pattern_t* _tmp7_;
	cairo_pattern_t* _tmp8_;
	cairo_pattern_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	cairo_pattern_t* _tmp12_;
	cairo_pattern_t* _tmp13_;
	cairo_pattern_t* _tmp14_;
	cairo_pattern_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_pattern_t* _tmp17_;
	cairo_pattern_t* _tmp18_;
	gdouble finished_width = 0.0;
	cairo_pattern_t* _tmp19_;
	cairo_pattern_t* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (color != NULL);
	if (progress < ((gdouble) 0)) {
		return;
	}
	if (progress > 1.0) {
		progress = 1.0;
	}
	_tmp0_ = plank_surface_get_Context (surface);
	_tmp1_ = _tmp0_;
	cr = _tmp1_;
	_tmp2_ = plank_surface_get_Width (surface);
	_tmp3_ = _tmp2_;
	x = floor ((gdouble) ((_tmp3_ - icon_size) / 2));
	_tmp4_ = plank_surface_get_Height (surface);
	_tmp5_ = _tmp4_;
	y = floor ((gdouble) ((_tmp5_ - icon_size) / 2));
	line_width = 1.0;
	padding = 4.0;
	width = icon_size - (2.0 * padding);
	height = floor (MIN (18.0, (gdouble) ((gint) (0.15 * icon_size))));
	x += padding;
	y += (icon_size - height) - padding;
	_tmp6_ = cr;
	cairo_set_line_width (_tmp6_, line_width);
	_tmp7_ = cairo_pattern_create_linear ((gdouble) 0, y, (gdouble) 0, y + height);
	_cairo_pattern_destroy0 (stroke);
	stroke = _tmp7_;
	_tmp8_ = stroke;
	cairo_pattern_add_color_stop_rgba (_tmp8_, 0.5, 0.5, 0.5, 0.5, 0.1);
	_tmp9_ = stroke;
	cairo_pattern_add_color_stop_rgba (_tmp9_, 0.9, 0.8, 0.8, 0.8, 0.4);
	_tmp10_ = cr;
	_tmp11_ = stroke;
	plank_theme_draw_rounded_line (_tmp10_, x + (line_width / 2.0), y + (line_width / 2.0), width, height, TRUE, TRUE, _tmp11_, NULL);
	x += line_width;
	y += line_width;
	width -= 2.0 * line_width;
	height -= 2.0 * line_width;
	_tmp12_ = cairo_pattern_create_rgba (0.20, 0.20, 0.20, 0.9);
	_cairo_pattern_destroy0 (stroke);
	stroke = _tmp12_;
	_tmp13_ = cairo_pattern_create_linear ((gdouble) 0, y, (gdouble) 0, y + height);
	_cairo_pattern_destroy0 (fill);
	fill = _tmp13_;
	_tmp14_ = fill;
	cairo_pattern_add_color_stop_rgba (_tmp14_, 0.4, 0.25, 0.25, 0.25, 1.0);
	_tmp15_ = fill;
	cairo_pattern_add_color_stop_rgba (_tmp15_, 0.9, 0.35, 0.35, 0.35, 1.0);
	_tmp16_ = cr;
	_tmp17_ = stroke;
	_tmp18_ = fill;
	plank_theme_draw_rounded_line (_tmp16_, x + (line_width / 2.0), y + (line_width / 2.0), width, height, TRUE, TRUE, _tmp17_, _tmp18_);
	x += line_width;
	y += line_width;
	width -= 2.0 * line_width;
	height -= 2.0 * line_width;
	finished_width = ceil (progress * width);
	_tmp19_ = cairo_pattern_create_rgba (0.8, 0.8, 0.8, 1.0);
	_cairo_pattern_destroy0 (stroke);
	stroke = _tmp19_;
	_tmp20_ = cairo_pattern_create_rgba (0.9, 0.9, 0.9, 1.0);
	_cairo_pattern_destroy0 (fill);
	fill = _tmp20_;
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL) {
		cairo_t* _tmp21_;
		cairo_pattern_t* _tmp22_;
		cairo_pattern_t* _tmp23_;
		_tmp21_ = cr;
		_tmp22_ = stroke;
		_tmp23_ = fill;
		plank_theme_draw_rounded_line (_tmp21_, ((x + (line_width / 2.0)) + width) - finished_width, y + (line_width / 2.0), finished_width, height, TRUE, TRUE, _tmp22_, _tmp23_);
	} else {
		cairo_t* _tmp24_;
		cairo_pattern_t* _tmp25_;
		cairo_pattern_t* _tmp26_;
		_tmp24_ = cr;
		_tmp25_ = stroke;
		_tmp26_ = fill;
		plank_theme_draw_rounded_line (_tmp24_, x + (line_width / 2.0), y + (line_width / 2.0), finished_width, height, TRUE, TRUE, _tmp25_, _tmp26_);
	}
	_cairo_pattern_destroy0 (fill);
	_cairo_pattern_destroy0 (stroke);
}

/**
 * {@inheritDoc}
 */
static void
plank_dock_theme_real_verify (PlankPreferences* base,
                              const gchar* prop)
{
	PlankDockTheme * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	static GQuark _tmp1_label17 = 0;
	static GQuark _tmp1_label18 = 0;
	static GQuark _tmp1_label19 = 0;
	static GQuark _tmp1_label20 = 0;
	self = (PlankDockTheme*) base;
	g_return_if_fail (prop != NULL);
	PLANK_PREFERENCES_CLASS (plank_dock_theme_parent_class)->verify ((PlankPreferences*) G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_THEME, PlankTheme), prop);
	_tmp0_ = prop;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("HorizPadding")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("TopPadding")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("BottomPadding")))) {
		switch (0) {
			default:
			{
				gdouble _tmp3_;
				_tmp3_ = self->priv->_BottomPadding;
				if (_tmp3_ < ((gdouble) 0)) {
					plank_dock_theme_set_BottomPadding (self, (gdouble) 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("ItemPadding")))) {
		switch (0) {
			default:
			{
				gdouble _tmp4_;
				_tmp4_ = self->priv->_ItemPadding;
				if (_tmp4_ < ((gdouble) 0)) {
					plank_dock_theme_set_ItemPadding (self, (gdouble) 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("IndicatorSize")))) {
		switch (0) {
			default:
			{
				gdouble _tmp5_;
				_tmp5_ = self->priv->_IndicatorSize;
				if (_tmp5_ < PLANK_DOCK_THEME_MIN_INDICATOR_SIZE) {
					plank_dock_theme_set_IndicatorSize (self, PLANK_DOCK_THEME_MIN_INDICATOR_SIZE);
				} else {
					gdouble _tmp6_;
					_tmp6_ = self->priv->_IndicatorSize;
					if (_tmp6_ > PLANK_DOCK_THEME_MAX_INDICATOR_SIZE) {
						plank_dock_theme_set_IndicatorSize (self, PLANK_DOCK_THEME_MAX_INDICATOR_SIZE);
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("IconShadowSize")))) {
		switch (0) {
			default:
			{
				gdouble _tmp7_;
				_tmp7_ = self->priv->_IconShadowSize;
				if (_tmp7_ < ((gdouble) 0)) {
					plank_dock_theme_set_IconShadowSize (self, (gdouble) 0);
				} else {
					gdouble _tmp8_;
					_tmp8_ = self->priv->_IconShadowSize;
					if (_tmp8_ > PLANK_DOCK_THEME_MAX_ICON_SHADOW_SIZE) {
						plank_dock_theme_set_IconShadowSize (self, PLANK_DOCK_THEME_MAX_ICON_SHADOW_SIZE);
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("UrgentBounceHeight")))) {
		switch (0) {
			default:
			{
				gdouble _tmp9_;
				_tmp9_ = self->priv->_UrgentBounceHeight;
				if (_tmp9_ < ((gdouble) 0)) {
					plank_dock_theme_set_UrgentBounceHeight (self, (gdouble) 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("LaunchBounceHeight")))) {
		switch (0) {
			default:
			{
				gdouble _tmp10_;
				_tmp10_ = self->priv->_LaunchBounceHeight;
				if (_tmp10_ < ((gdouble) 0)) {
					plank_dock_theme_set_LaunchBounceHeight (self, (gdouble) 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("FadeOpacity")))) {
		switch (0) {
			default:
			{
				gdouble _tmp11_;
				_tmp11_ = self->priv->_FadeOpacity;
				if (_tmp11_ < ((gdouble) 0)) {
					plank_dock_theme_set_FadeOpacity (self, (gdouble) 0);
				} else {
					gdouble _tmp12_;
					_tmp12_ = self->priv->_FadeOpacity;
					if (_tmp12_ > ((gdouble) 1)) {
						plank_dock_theme_set_FadeOpacity (self, (gdouble) 1);
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("ClickTime")))) {
		switch (0) {
			default:
			{
				gint _tmp13_;
				_tmp13_ = self->priv->_ClickTime;
				if (_tmp13_ < 0) {
					plank_dock_theme_set_ClickTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("UrgentBounceTime")))) {
		switch (0) {
			default:
			{
				gint _tmp14_;
				_tmp14_ = self->priv->_UrgentBounceTime;
				if (_tmp14_ < 0) {
					plank_dock_theme_set_UrgentBounceTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("LaunchBounceTime")))) {
		switch (0) {
			default:
			{
				gint _tmp15_;
				_tmp15_ = self->priv->_LaunchBounceTime;
				if (_tmp15_ < 0) {
					plank_dock_theme_set_LaunchBounceTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("ActiveTime")))) {
		switch (0) {
			default:
			{
				gint _tmp16_;
				_tmp16_ = self->priv->_ActiveTime;
				if (_tmp16_ < 0) {
					plank_dock_theme_set_ActiveTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("SlideTime")))) {
		switch (0) {
			default:
			{
				gint _tmp17_;
				_tmp17_ = self->priv->_SlideTime;
				if (_tmp17_ < 0) {
					plank_dock_theme_set_SlideTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("FadeTime")))) {
		switch (0) {
			default:
			{
				gint _tmp18_;
				_tmp18_ = self->priv->_FadeTime;
				if (_tmp18_ < 0) {
					plank_dock_theme_set_FadeTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("HideTime")))) {
		switch (0) {
			default:
			{
				gint _tmp19_;
				_tmp19_ = self->priv->_HideTime;
				if (_tmp19_ < 0) {
					plank_dock_theme_set_HideTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("GlowSize")))) {
		switch (0) {
			default:
			{
				gint _tmp20_;
				_tmp20_ = self->priv->_GlowSize;
				if (_tmp20_ < 0) {
					plank_dock_theme_set_GlowSize (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("GlowTime")))) {
		switch (0) {
			default:
			{
				gint _tmp21_;
				_tmp21_ = self->priv->_GlowTime;
				if (_tmp21_ < 0) {
					plank_dock_theme_set_GlowTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("GlowPulseTime")))) {
		switch (0) {
			default:
			{
				gint _tmp22_;
				_tmp22_ = self->priv->_GlowPulseTime;
				if (_tmp22_ < 0) {
					plank_dock_theme_set_GlowPulseTime (self, 0);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label19) ? _tmp1_label19 : (_tmp1_label19 = g_quark_from_static_string ("UrgentHueShift")))) {
		switch (0) {
			default:
			{
				gint _tmp23_;
				_tmp23_ = self->priv->_UrgentHueShift;
				if (_tmp23_ < -180) {
					plank_dock_theme_set_UrgentHueShift (self, -180);
				} else {
					gint _tmp24_;
					_tmp24_ = self->priv->_UrgentHueShift;
					if (_tmp24_ > 180) {
						plank_dock_theme_set_UrgentHueShift (self, 180);
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label20) ? _tmp1_label20 : (_tmp1_label20 = g_quark_from_static_string ("BadgeColor")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

gdouble
plank_dock_theme_get_HorizPadding (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_HorizPadding;
	return result;
}

void
plank_dock_theme_set_HorizPadding (PlankDockTheme* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_HorizPadding (self);
	if (old_value != value) {
		self->priv->_HorizPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_HORIZ_PADDING_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_TopPadding (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_TopPadding;
	return result;
}

void
plank_dock_theme_set_TopPadding (PlankDockTheme* self,
                                 gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_TopPadding (self);
	if (old_value != value) {
		self->priv->_TopPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_TOP_PADDING_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_BottomPadding (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_BottomPadding;
	return result;
}

void
plank_dock_theme_set_BottomPadding (PlankDockTheme* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_BottomPadding (self);
	if (old_value != value) {
		self->priv->_BottomPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_BOTTOM_PADDING_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_ItemPadding (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_ItemPadding;
	return result;
}

void
plank_dock_theme_set_ItemPadding (PlankDockTheme* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_ItemPadding (self);
	if (old_value != value) {
		self->priv->_ItemPadding = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_ITEM_PADDING_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_IndicatorSize (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_IndicatorSize;
	return result;
}

void
plank_dock_theme_set_IndicatorSize (PlankDockTheme* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_IndicatorSize (self);
	if (old_value != value) {
		self->priv->_IndicatorSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_INDICATOR_SIZE_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_IconShadowSize (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_IconShadowSize;
	return result;
}

void
plank_dock_theme_set_IconShadowSize (PlankDockTheme* self,
                                     gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_IconShadowSize (self);
	if (old_value != value) {
		self->priv->_IconShadowSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_ICON_SHADOW_SIZE_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_UrgentBounceHeight (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_UrgentBounceHeight;
	return result;
}

void
plank_dock_theme_set_UrgentBounceHeight (PlankDockTheme* self,
                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_UrgentBounceHeight (self);
	if (old_value != value) {
		self->priv->_UrgentBounceHeight = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_URGENT_BOUNCE_HEIGHT_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_LaunchBounceHeight (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_LaunchBounceHeight;
	return result;
}

void
plank_dock_theme_set_LaunchBounceHeight (PlankDockTheme* self,
                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_LaunchBounceHeight (self);
	if (old_value != value) {
		self->priv->_LaunchBounceHeight = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_LAUNCH_BOUNCE_HEIGHT_PROPERTY]);
	}
}

gdouble
plank_dock_theme_get_FadeOpacity (PlankDockTheme* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_FadeOpacity;
	return result;
}

void
plank_dock_theme_set_FadeOpacity (PlankDockTheme* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_FadeOpacity (self);
	if (old_value != value) {
		self->priv->_FadeOpacity = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_FADE_OPACITY_PROPERTY]);
	}
}

gint
plank_dock_theme_get_ClickTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ClickTime;
	return result;
}

void
plank_dock_theme_set_ClickTime (PlankDockTheme* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_ClickTime (self);
	if (old_value != value) {
		self->priv->_ClickTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_CLICK_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_UrgentBounceTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_UrgentBounceTime;
	return result;
}

void
plank_dock_theme_set_UrgentBounceTime (PlankDockTheme* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_UrgentBounceTime (self);
	if (old_value != value) {
		self->priv->_UrgentBounceTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_URGENT_BOUNCE_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_LaunchBounceTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_LaunchBounceTime;
	return result;
}

void
plank_dock_theme_set_LaunchBounceTime (PlankDockTheme* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_LaunchBounceTime (self);
	if (old_value != value) {
		self->priv->_LaunchBounceTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_LAUNCH_BOUNCE_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_ActiveTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ActiveTime;
	return result;
}

void
plank_dock_theme_set_ActiveTime (PlankDockTheme* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_ActiveTime (self);
	if (old_value != value) {
		self->priv->_ActiveTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_ACTIVE_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_SlideTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_SlideTime;
	return result;
}

void
plank_dock_theme_set_SlideTime (PlankDockTheme* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_SlideTime (self);
	if (old_value != value) {
		self->priv->_SlideTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_SLIDE_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_FadeTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_FadeTime;
	return result;
}

void
plank_dock_theme_set_FadeTime (PlankDockTheme* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_FadeTime (self);
	if (old_value != value) {
		self->priv->_FadeTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_FADE_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_HideTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_HideTime;
	return result;
}

void
plank_dock_theme_set_HideTime (PlankDockTheme* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_HideTime (self);
	if (old_value != value) {
		self->priv->_HideTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_HIDE_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_GlowSize (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_GlowSize;
	return result;
}

void
plank_dock_theme_set_GlowSize (PlankDockTheme* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_GlowSize (self);
	if (old_value != value) {
		self->priv->_GlowSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_GLOW_SIZE_PROPERTY]);
	}
}

gint
plank_dock_theme_get_GlowTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_GlowTime;
	return result;
}

void
plank_dock_theme_set_GlowTime (PlankDockTheme* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_GlowTime (self);
	if (old_value != value) {
		self->priv->_GlowTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_GLOW_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_GlowPulseTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_GlowPulseTime;
	return result;
}

void
plank_dock_theme_set_GlowPulseTime (PlankDockTheme* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_GlowPulseTime (self);
	if (old_value != value) {
		self->priv->_GlowPulseTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_GLOW_PULSE_TIME_PROPERTY]);
	}
}

gint
plank_dock_theme_get_UrgentHueShift (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_UrgentHueShift;
	return result;
}

void
plank_dock_theme_set_UrgentHueShift (PlankDockTheme* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_UrgentHueShift (self);
	if (old_value != value) {
		self->priv->_UrgentHueShift = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_URGENT_HUE_SHIFT_PROPERTY]);
	}
}

gint
plank_dock_theme_get_ItemMoveTime (PlankDockTheme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ItemMoveTime;
	return result;
}

void
plank_dock_theme_set_ItemMoveTime (PlankDockTheme* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_ItemMoveTime (self);
	if (old_value != value) {
		self->priv->_ItemMoveTime = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_ITEM_MOVE_TIME_PROPERTY]);
	}
}

gboolean
plank_dock_theme_get_CascadeHide (PlankDockTheme* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_CascadeHide;
	return result;
}

void
plank_dock_theme_set_CascadeHide (PlankDockTheme* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_theme_get_CascadeHide (self);
	if (old_value != value) {
		self->priv->_CascadeHide = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_CASCADE_HIDE_PROPERTY]);
	}
}

void
plank_dock_theme_get_BadgeColor (PlankDockTheme* self,
                                 PlankColor * result)
{
	PlankColor _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_BadgeColor;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
plank_dock_theme_set_BadgeColor (PlankDockTheme* self,
                                 PlankColor * value)
{
	PlankColor old_value;
	g_return_if_fail (self != NULL);
	plank_dock_theme_get_BadgeColor (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		PlankColor _tmp0_;
		_tmp0_ = *value;
		self->priv->_BadgeColor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_theme_properties[PLANK_DOCK_THEME_BADGE_COLOR_PROPERTY]);
	}
}

static void
plank_dock_theme_class_init (PlankDockThemeClass * klass,
                             gpointer klass_data)
{
	plank_dock_theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockTheme_private_offset);
	((PlankPreferencesClass *) klass)->reset_properties = (void (*) (PlankPreferences*)) plank_dock_theme_real_reset_properties;
	((PlankPreferencesClass *) klass)->verify = (void (*) (PlankPreferences*, const gchar*)) plank_dock_theme_real_verify;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_theme_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dock_theme_set_property;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_theme_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_HORIZ_PADDING_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_HORIZ_PADDING_PROPERTY] = g_param_spec_double ("HorizPadding", "horizontal-padding", "The padding on the left/right dock edges, in tenths of a percent of IconSize.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_TOP_PADDING_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_TOP_PADDING_PROPERTY] = g_param_spec_double ("TopPadding", "top-padding", "The padding on the top dock edge, in tenths of a percent of IconSize.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_BOTTOM_PADDING_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_BOTTOM_PADDING_PROPERTY] = g_param_spec_double ("BottomPadding", "bottom-padding", "The padding on the bottom dock edge, in tenths of a percent of IconSize.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_ITEM_PADDING_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_ITEM_PADDING_PROPERTY] = g_param_spec_double ("ItemPadding", "item-padding", "The padding between items on the dock, in tenths of a percent of IconSize.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_INDICATOR_SIZE_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_INDICATOR_SIZE_PROPERTY] = g_param_spec_double ("IndicatorSize", "indicator-size", "The size of item indicators, in tenths of a percent of IconSize.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_ICON_SHADOW_SIZE_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_ICON_SHADOW_SIZE_PROPERTY] = g_param_spec_double ("IconShadowSize", "icon-shadow-size", "The size of the icon-shadow behind every item, in tenths of a percent of IconSize.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_URGENT_BOUNCE_HEIGHT_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_URGENT_BOUNCE_HEIGHT_PROPERTY] = g_param_spec_double ("UrgentBounceHeight", "urgent-bounce", "The height (in percent of IconSize) to bounce an icon when the application sets urgent.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_LAUNCH_BOUNCE_HEIGHT_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_LAUNCH_BOUNCE_HEIGHT_PROPERTY] = g_param_spec_double ("LaunchBounceHeight", "launch-bounce", "The height (in percent of IconSize) to bounce an icon when launching an application.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_FADE_OPACITY_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_FADE_OPACITY_PROPERTY] = g_param_spec_double ("FadeOpacity", "fade-opacity", "The opacity value (0 to 1) to fade the dock to when hiding it.", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_CLICK_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_CLICK_TIME_PROPERTY] = g_param_spec_int ("ClickTime", "click-time", "The amount of time (in ms) for click animations.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_URGENT_BOUNCE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_URGENT_BOUNCE_TIME_PROPERTY] = g_param_spec_int ("UrgentBounceTime", "urgent-bounce-time", "The amount of time (in ms) to bounce an urgent icon.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_LAUNCH_BOUNCE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_LAUNCH_BOUNCE_TIME_PROPERTY] = g_param_spec_int ("LaunchBounceTime", "launch-bounce-time", "The amount of time (in ms) to bounce an icon when launching an application.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_ACTIVE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_ACTIVE_TIME_PROPERTY] = g_param_spec_int ("ActiveTime", "active-time", "The amount of time (in ms) for active window indicator animations.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_SLIDE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_SLIDE_TIME_PROPERTY] = g_param_spec_int ("SlideTime", "slide-time", "The amount of time (in ms) to slide icons into/out of the dock.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_FADE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_FADE_TIME_PROPERTY] = g_param_spec_int ("FadeTime", "fade-time", "The time (in ms) to fade the dock in/out on a hide (if FadeOpacity is < 1).", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_HIDE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_HIDE_TIME_PROPERTY] = g_param_spec_int ("HideTime", "hide-time", "The time (in ms) to slide the dock in/out on a hide (if FadeOpacity is 1).", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_GLOW_SIZE_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_GLOW_SIZE_PROPERTY] = g_param_spec_int ("GlowSize", "glow-size", "The size of the urgent glow (shown when dock is hidden), in tenths of a percent of IconSize.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_GLOW_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_GLOW_TIME_PROPERTY] = g_param_spec_int ("GlowTime", "glow-time", "The total time (in ms) to show the hidden-dock urgent glow.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_GLOW_PULSE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_GLOW_PULSE_TIME_PROPERTY] = g_param_spec_int ("GlowPulseTime", "glow-pulse-time", "The time (in ms) of each pulse of the hidden-dock urgent glow.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_URGENT_HUE_SHIFT_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_URGENT_HUE_SHIFT_PROPERTY] = g_param_spec_int ("UrgentHueShift", "urgent-hue-shift", "The hue-shift (-180 to 180) of the urgent indicator color.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_ITEM_MOVE_TIME_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_ITEM_MOVE_TIME_PROPERTY] = g_param_spec_int ("ItemMoveTime", "item-move-time", "The time (in ms) to move an item to its new position or its addition/removal to/from the dock.", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_CASCADE_HIDE_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_CASCADE_HIDE_PROPERTY] = g_param_spec_boolean ("CascadeHide", "cascade-hide", "Whether background and icons will unhide/hide with different speeds. The top-border of both will leave/hit the screen-edge at the same time.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_THEME_BADGE_COLOR_PROPERTY, plank_dock_theme_properties[PLANK_DOCK_THEME_BADGE_COLOR_PROPERTY] = g_param_spec_boxed ("BadgeColor", "badge-color", "The color (RGBA) of the badge displaying urgent count", PLANK_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
plank_dock_theme_instance_init (PlankDockTheme * self,
                                gpointer klass)
{
	self->priv = plank_dock_theme_get_instance_private (self);
}

static void
plank_dock_theme_finalize (GObject * obj)
{
	PlankDockTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_THEME, PlankDockTheme);
	G_OBJECT_CLASS (plank_dock_theme_parent_class)->finalize (obj);
}

/**
 * A themed renderer for dock windows.
 */
static GType
plank_dock_theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockTheme), 0, (GInstanceInitFunc) plank_dock_theme_instance_init, NULL };
	GType plank_dock_theme_type_id;
	plank_dock_theme_type_id = g_type_register_static (PLANK_TYPE_THEME, "PlankDockTheme", &g_define_type_info, 0);
	PlankDockTheme_private_offset = g_type_add_instance_private (plank_dock_theme_type_id, sizeof (PlankDockThemePrivate));
	return plank_dock_theme_type_id;
}

GType
plank_dock_theme_get_type (void)
{
	static volatile gsize plank_dock_theme_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_theme_type_id__once)) {
		GType plank_dock_theme_type_id;
		plank_dock_theme_type_id = plank_dock_theme_get_type_once ();
		g_once_init_leave (&plank_dock_theme_type_id__once, plank_dock_theme_type_id);
	}
	return plank_dock_theme_type_id__once;
}

static void
_vala_plank_dock_theme_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PlankDockTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_THEME, PlankDockTheme);
	switch (property_id) {
		case PLANK_DOCK_THEME_HORIZ_PADDING_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_HorizPadding (self));
		break;
		case PLANK_DOCK_THEME_TOP_PADDING_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_TopPadding (self));
		break;
		case PLANK_DOCK_THEME_BOTTOM_PADDING_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_BottomPadding (self));
		break;
		case PLANK_DOCK_THEME_ITEM_PADDING_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_ItemPadding (self));
		break;
		case PLANK_DOCK_THEME_INDICATOR_SIZE_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_IndicatorSize (self));
		break;
		case PLANK_DOCK_THEME_ICON_SHADOW_SIZE_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_IconShadowSize (self));
		break;
		case PLANK_DOCK_THEME_URGENT_BOUNCE_HEIGHT_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_UrgentBounceHeight (self));
		break;
		case PLANK_DOCK_THEME_LAUNCH_BOUNCE_HEIGHT_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_LaunchBounceHeight (self));
		break;
		case PLANK_DOCK_THEME_FADE_OPACITY_PROPERTY:
		g_value_set_double (value, plank_dock_theme_get_FadeOpacity (self));
		break;
		case PLANK_DOCK_THEME_CLICK_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_ClickTime (self));
		break;
		case PLANK_DOCK_THEME_URGENT_BOUNCE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_UrgentBounceTime (self));
		break;
		case PLANK_DOCK_THEME_LAUNCH_BOUNCE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_LaunchBounceTime (self));
		break;
		case PLANK_DOCK_THEME_ACTIVE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_ActiveTime (self));
		break;
		case PLANK_DOCK_THEME_SLIDE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_SlideTime (self));
		break;
		case PLANK_DOCK_THEME_FADE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_FadeTime (self));
		break;
		case PLANK_DOCK_THEME_HIDE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_HideTime (self));
		break;
		case PLANK_DOCK_THEME_GLOW_SIZE_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_GlowSize (self));
		break;
		case PLANK_DOCK_THEME_GLOW_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_GlowTime (self));
		break;
		case PLANK_DOCK_THEME_GLOW_PULSE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_GlowPulseTime (self));
		break;
		case PLANK_DOCK_THEME_URGENT_HUE_SHIFT_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_UrgentHueShift (self));
		break;
		case PLANK_DOCK_THEME_ITEM_MOVE_TIME_PROPERTY:
		g_value_set_int (value, plank_dock_theme_get_ItemMoveTime (self));
		break;
		case PLANK_DOCK_THEME_CASCADE_HIDE_PROPERTY:
		g_value_set_boolean (value, plank_dock_theme_get_CascadeHide (self));
		break;
		case PLANK_DOCK_THEME_BADGE_COLOR_PROPERTY:
		{
			PlankColor boxed;
			plank_dock_theme_get_BadgeColor (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dock_theme_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	PlankDockTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_THEME, PlankDockTheme);
	switch (property_id) {
		case PLANK_DOCK_THEME_HORIZ_PADDING_PROPERTY:
		plank_dock_theme_set_HorizPadding (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_TOP_PADDING_PROPERTY:
		plank_dock_theme_set_TopPadding (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_BOTTOM_PADDING_PROPERTY:
		plank_dock_theme_set_BottomPadding (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_ITEM_PADDING_PROPERTY:
		plank_dock_theme_set_ItemPadding (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_INDICATOR_SIZE_PROPERTY:
		plank_dock_theme_set_IndicatorSize (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_ICON_SHADOW_SIZE_PROPERTY:
		plank_dock_theme_set_IconShadowSize (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_URGENT_BOUNCE_HEIGHT_PROPERTY:
		plank_dock_theme_set_UrgentBounceHeight (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_LAUNCH_BOUNCE_HEIGHT_PROPERTY:
		plank_dock_theme_set_LaunchBounceHeight (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_FADE_OPACITY_PROPERTY:
		plank_dock_theme_set_FadeOpacity (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_THEME_CLICK_TIME_PROPERTY:
		plank_dock_theme_set_ClickTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_URGENT_BOUNCE_TIME_PROPERTY:
		plank_dock_theme_set_UrgentBounceTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_LAUNCH_BOUNCE_TIME_PROPERTY:
		plank_dock_theme_set_LaunchBounceTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_ACTIVE_TIME_PROPERTY:
		plank_dock_theme_set_ActiveTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_SLIDE_TIME_PROPERTY:
		plank_dock_theme_set_SlideTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_FADE_TIME_PROPERTY:
		plank_dock_theme_set_FadeTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_HIDE_TIME_PROPERTY:
		plank_dock_theme_set_HideTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_GLOW_SIZE_PROPERTY:
		plank_dock_theme_set_GlowSize (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_GLOW_TIME_PROPERTY:
		plank_dock_theme_set_GlowTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_GLOW_PULSE_TIME_PROPERTY:
		plank_dock_theme_set_GlowPulseTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_URGENT_HUE_SHIFT_PROPERTY:
		plank_dock_theme_set_UrgentHueShift (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_ITEM_MOVE_TIME_PROPERTY:
		plank_dock_theme_set_ItemMoveTime (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_THEME_CASCADE_HIDE_PROPERTY:
		plank_dock_theme_set_CascadeHide (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_THEME_BADGE_COLOR_PROPERTY:
		plank_dock_theme_set_BadgeColor (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

