/* FileDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from FileDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include "plank-internal.h"

#define PLANK_FILE_DOCK_ITEM_DEFAULT_ICONS "inode-directory;;folder"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_FILE_DOCK_ITEM_0_PROPERTY,
	PLANK_FILE_DOCK_ITEM_OWNED_FILE_PROPERTY,
	PLANK_FILE_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* plank_file_dock_item_properties[PLANK_FILE_DOCK_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;

struct _PlankFileDockItemPrivate {
	GFile* _OwnedFile;
	GFileMonitor* dir_monitor;
};

struct _Block11Data {
	int _ref_count_;
	PlankFileDockItem* self;
	GeeHashMap* icons;
	GeeArrayList* keys;
};

struct _Block12Data {
	int _ref_count_;
	PlankFileDockItem* self;
	GeeHashMap* menu_items;
	GeeArrayList* keys;
};

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	GFile* file;
};

static gint PlankFileDockItem_private_offset;
static gpointer plank_file_dock_item_parent_class = NULL;

static void plank_file_dock_item_stop_monitor (PlankFileDockItem* self);
static void plank_file_dock_item_real_load_from_launcher (PlankDockItem* base);
static gchar* plank_file_dock_item_get_display_name (GFile* file);
static void plank_file_dock_item_handle_dir_changed (GFile* f,
                                              GFile* other,
                                              GFileMonitorEvent event,
                                              PlankFileDockItem* self);
static void _plank_file_dock_item_handle_dir_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                      GFile* file,
                                                                      GFile* other_file,
                                                                      GFileMonitorEvent event_type,
                                                                      gpointer self);
static gboolean plank_file_dock_item_has_default_icon_match (PlankFileDockItem* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void plank_file_dock_item_real_draw_icon_fast (PlankDockItem* base,
                                               PlankSurface* surface);
static void plank_file_dock_item_real_draw_icon (PlankDockItem* base,
                                          PlankSurface* surface);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static GeeHashMap* plank_file_dock_item_get_files (GFile* file);
static gboolean __lambda16_ (Block11Data* _data11_,
                      const gchar* display_name,
                      GFile* file);
static gboolean ___lambda16__gee_forall_map_func (gconstpointer k,
                                           gconstpointer v,
                                           gpointer self);
static PlankAnimationType plank_file_dock_item_real_on_clicked (PlankDockElement* base,
                                                         PlankPopupButton button,
                                                         GdkModifierType mod,
                                                         guint32 event_time);
static GeeArrayList* plank_file_dock_item_real_get_menu_items (PlankDockElement* base);
static GeeArrayList* plank_file_dock_item_get_dir_menu_items (PlankFileDockItem* self);
static GeeArrayList* plank_file_dock_item_get_file_menu_items (PlankFileDockItem* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean __lambda17_ (Block12Data* _data12_,
                      const gchar* display_name,
                      GFile* file);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void ___lambda18_ (Block13Data* _data13_);
static void ____lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda19_ (Block13Data* _data13_);
static void ____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static gboolean ___lambda17__gee_forall_map_func (gconstpointer k,
                                           gconstpointer v,
                                           gpointer self);
static void ___lambda20_ (PlankFileDockItem* self);
static void ____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void __lambda21_ (PlankFileDockItem* self);
static void ___lambda21__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void ___lambda22_ (PlankFileDockItem* self);
static void ____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void _plank_file_dock_item_launch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self);
static void __lambda23_ (PlankFileDockItem* self);
static void ___lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static GObject * plank_file_dock_item_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void plank_file_dock_item_finalize (GObject * obj);
static GType plank_file_dock_item_get_type_once (void);
static void _vala_plank_file_dock_item_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_plank_file_dock_item_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
plank_file_dock_item_get_instance_private (PlankFileDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, PlankFileDockItem_private_offset);
}

/**
 * {@inheritDoc}
 */
PlankFileDockItem*
plank_file_dock_item_construct_with_file (GType object_type,
                                          GFile* file)
{
	PlankFileDockItem * self = NULL;
	PlankDockItemPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new ();
	prefs = _tmp0_;
	_tmp1_ = g_file_get_uri (file);
	_tmp2_ = _tmp1_;
	plank_dock_item_preferences_set_Launcher (prefs, _tmp2_);
	_g_free0 (_tmp2_);
	self = (PlankFileDockItem*) g_object_new (object_type, "Prefs", prefs, "OwnedFile", file, NULL);
	_g_object_unref0 (prefs);
	return self;
}

PlankFileDockItem*
plank_file_dock_item_new_with_file (GFile* file)
{
	return plank_file_dock_item_construct_with_file (PLANK_TYPE_FILE_DOCK_ITEM, file);
}

/**
 * {@inheritDoc}
 */
PlankFileDockItem*
plank_file_dock_item_construct_with_dockitem_file (GType object_type,
                                                   GFile* file)
{
	PlankFileDockItem * self = NULL;
	PlankDockItemPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_file (file);
	prefs = _tmp0_;
	_tmp1_ = plank_dock_item_preferences_get_Launcher (prefs);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	self = (PlankFileDockItem*) g_object_new (object_type, "Prefs", prefs, "OwnedFile", _tmp4_, NULL);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (prefs);
	return self;
}

PlankFileDockItem*
plank_file_dock_item_new_with_dockitem_file (GFile* file)
{
	return plank_file_dock_item_construct_with_dockitem_file (PLANK_TYPE_FILE_DOCK_ITEM, file);
}

/**
 * {@inheritDoc}
 */
PlankFileDockItem*
plank_file_dock_item_construct_with_dockitem_filename (GType object_type,
                                                       const gchar* filename)
{
	PlankFileDockItem * self = NULL;
	PlankDockItemPreferences* prefs = NULL;
	PlankDockItemPreferences* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_filename (filename);
	prefs = _tmp0_;
	_tmp1_ = plank_dock_item_preferences_get_Launcher (prefs);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	self = (PlankFileDockItem*) g_object_new (object_type, "Prefs", prefs, "OwnedFile", _tmp4_, NULL);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (prefs);
	return self;
}

PlankFileDockItem*
plank_file_dock_item_new_with_dockitem_filename (const gchar* filename)
{
	return plank_file_dock_item_construct_with_dockitem_filename (PLANK_TYPE_FILE_DOCK_ITEM, filename);
}

/**
 * {@inheritDoc}
 */
static void
_plank_file_dock_item_handle_dir_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                 GFile* file,
                                                                 GFile* other_file,
                                                                 GFileMonitorEvent event_type,
                                                                 gpointer self)
{
	plank_file_dock_item_handle_dir_changed (file, other_file, event_type, (PlankFileDockItem*) self);
}

static void
plank_file_dock_item_real_load_from_launcher (PlankDockItem* base)
{
	PlankFileDockItem * self;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	PlankDockItemPreferences* _tmp4_;
	PlankDockItemPreferences* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp14_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GFile* _tmp21_;
	GError* _inner_error0_ = NULL;
	self = (PlankFileDockItem*) base;
	plank_file_dock_item_stop_monitor (self);
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = plank_dock_item_preferences_get_Launcher (_tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		return;
	}
	_tmp4_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = plank_dock_item_preferences_get_Launcher (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_new_for_uri (_tmp7_);
	_tmp9_ = _tmp8_;
	plank_file_dock_item_set_OwnedFile (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp11_ = self->priv->_OwnedFile;
	_tmp12_ = plank_drawing_service_get_icon_from_file (_tmp11_);
	_tmp10_ = _tmp12_;
	if (_tmp10_ == NULL) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup (PLANK_FILE_DOCK_ITEM_DEFAULT_ICONS);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp13_;
	}
	plank_dock_item_set_Icon ((PlankDockItem*) self, _tmp10_);
	_tmp14_ = self->priv->_OwnedFile;
	if (!g_file_is_native (_tmp14_)) {
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = self->priv->_OwnedFile;
		_tmp16_ = g_file_get_uri (_tmp15_);
		_tmp17_ = _tmp16_;
		plank_dock_element_set_Text ((PlankDockElement*) self, _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp10_);
		return;
	}
	_tmp18_ = self->priv->_OwnedFile;
	_tmp19_ = plank_file_dock_item_get_display_name (_tmp18_);
	_tmp20_ = _tmp19_;
	plank_dock_element_set_Text ((PlankDockElement*) self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->_OwnedFile;
	if (g_file_query_file_type (_tmp21_, 0, NULL) == G_FILE_TYPE_DIRECTORY) {
		plank_dock_element_set_Button ((PlankDockElement*) self, PLANK_POPUP_BUTTON_RIGHT | PLANK_POPUP_BUTTON_LEFT);
		{
			GFileMonitor* _tmp22_ = NULL;
			GFile* _tmp23_;
			GFileMonitor* _tmp24_;
			GFileMonitor* _tmp25_;
			GFileMonitor* _tmp26_;
			_tmp23_ = self->priv->_OwnedFile;
			_tmp24_ = g_file_monitor_directory (_tmp23_, 0, NULL, &_inner_error0_);
			_tmp22_ = _tmp24_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp25_ = _tmp22_;
			_tmp22_ = NULL;
			_g_object_unref0 (self->priv->dir_monitor);
			self->priv->dir_monitor = _tmp25_;
			_tmp26_ = self->priv->dir_monitor;
			g_signal_connect_object (_tmp26_, "changed", (GCallback) _plank_file_dock_item_handle_dir_changed_g_file_monitor_changed, self, 0);
			_g_object_unref0 (_tmp22_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			gchar* _tmp27_ = NULL;
			GFile* _tmp28_;
			gchar* _tmp29_;
			g_clear_error (&_inner_error0_);
			_tmp28_ = self->priv->_OwnedFile;
			_tmp29_ = g_file_get_path (_tmp28_);
			_tmp27_ = _tmp29_;
			if (_tmp27_ == NULL) {
				gchar* _tmp30_;
				_tmp30_ = g_strdup ("");
				_g_free0 (_tmp27_);
				_tmp27_ = _tmp30_;
			}
			g_critical ("FileDockItem.vala:105: Unable to watch the stack directory '%s'.", _tmp27_);
			_g_free0 (_tmp27_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp10_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (_tmp10_);
}

static void
plank_file_dock_item_stop_monitor (PlankFileDockItem* self)
{
	GFileMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dir_monitor;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		guint _tmp2_;
		GFileMonitor* _tmp3_;
		_tmp1_ = self->priv->dir_monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_file_dock_item_handle_dir_changed_g_file_monitor_changed, self);
		_tmp3_ = self->priv->dir_monitor;
		g_file_monitor_cancel (_tmp3_);
		_g_object_unref0 (self->priv->dir_monitor);
		self->priv->dir_monitor = NULL;
	}
}

static void
plank_file_dock_item_handle_dir_changed (GFile* f,
                                         GFile* other,
                                         GFileMonitorEvent event,
                                         PlankFileDockItem* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	plank_dock_item_reset_icon_buffer ((PlankDockItem*) self);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
plank_file_dock_item_has_default_icon_match (PlankFileDockItem* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** default_icons = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint default_icons_length1;
	gint _default_icons_size_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = plank_dock_item_get_Icon ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, PLANK_FILE_DOCK_ITEM_DEFAULT_ICONS) == 0) {
		result = TRUE;
		return result;
	}
	_tmp3_ = _tmp2_ = g_strsplit (PLANK_FILE_DOCK_ITEM_DEFAULT_ICONS, ";;", 0);
	default_icons = _tmp3_;
	default_icons_length1 = _vala_array_length (_tmp2_);
	_default_icons_size_ = default_icons_length1;
	_tmp4_ = plank_dock_item_get_Icon ((PlankDockItem*) self);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ";;", 0);
	{
		gchar** icon_collection = NULL;
		gint icon_collection_length1 = 0;
		gint _icon_collection_size_ = 0;
		gint icon_it = 0;
		icon_collection = _tmp7_;
		icon_collection_length1 = _vala_array_length (_tmp6_);
		for (icon_it = 0; icon_it < icon_collection_length1; icon_it = icon_it + 1) {
			const gchar* icon = NULL;
			icon = icon_collection[icon_it];
			{
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp8_ = icon;
				_tmp9_ = default_icons;
				_tmp9__length1 = default_icons_length1;
				if (_vala_string_array_contains (_tmp9_, _tmp9__length1, _tmp8_)) {
					result = TRUE;
					icon_collection = (_vala_array_free (icon_collection, icon_collection_length1, (GDestroyNotify) g_free), NULL);
					default_icons = (_vala_array_free (default_icons, default_icons_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
		icon_collection = (_vala_array_free (icon_collection, icon_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	default_icons = (_vala_array_free (default_icons, default_icons_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
 * {@inheritDoc}
 */
static void
plank_file_dock_item_real_draw_icon_fast (PlankDockItem* base,
                                          PlankSurface* surface)
{
	PlankFileDockItem * self;
	cairo_t* cr = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint width = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint height = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint radius = 0;
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble line_width_half = 0.0;
	cairo_pattern_t* rg = NULL;
	cairo_pattern_t* _tmp10_;
	self = (PlankFileDockItem*) base;
	g_return_if_fail (surface != NULL);
	_tmp0_ = plank_surface_get_Context (surface);
	_tmp1_ = _tmp0_;
	cr = _tmp1_;
	_tmp2_ = plank_surface_get_Width (surface);
	_tmp3_ = _tmp2_;
	width = _tmp3_;
	_tmp4_ = plank_surface_get_Height (surface);
	_tmp5_ = _tmp4_;
	height = _tmp5_;
	radius = 3 + ((6 * height) / (128 - 48));
	x_scale = 1.0;
	y_scale = 1.0;
	_tmp6_ = plank_surface_get_Internal (surface);
	_tmp7_ = _tmp6_;
	cairo_surface_get_device_scale (_tmp7_, &_tmp8_, &_tmp9_);
	x_scale = _tmp8_;
	y_scale = _tmp9_;
	line_width_half = 0.5 * ((gint) MAX (x_scale, y_scale));
	cairo_move_to (cr, (gdouble) radius, line_width_half);
	cairo_arc (cr, (width - radius) - line_width_half, radius + line_width_half, (gdouble) radius, -G_PI_2, (gdouble) 0);
	cairo_arc (cr, (width - radius) - line_width_half, (height - radius) - line_width_half, (gdouble) radius, (gdouble) 0, G_PI_2);
	cairo_arc (cr, radius + line_width_half, (height - radius) - line_width_half, (gdouble) radius, G_PI_2, G_PI);
	cairo_arc (cr, radius + line_width_half, radius + line_width_half, (gdouble) radius, G_PI, -G_PI_2);
	cairo_close_path (cr);
	cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.6);
	cairo_set_line_width (cr, 2 * line_width_half);
	cairo_stroke_preserve (cr);
	_tmp10_ = cairo_pattern_create_radial ((gdouble) (width / 2), (gdouble) height, (gdouble) (height / 8), (gdouble) (width / 2), (gdouble) height, (gdouble) height);
	rg = _tmp10_;
	cairo_pattern_add_color_stop_rgba (rg, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	cairo_pattern_add_color_stop_rgba (rg, (gdouble) 1, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.6);
	cairo_set_source (cr, rg);
	cairo_fill (cr);
	_cairo_pattern_destroy0 (rg);
}

/**
 * {@inheritDoc}
 */
static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		PlankFileDockItem* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->keys);
		_g_object_unref0 (_data11_->icons);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
__lambda16_ (Block11Data* _data11_,
             const gchar* display_name,
             GFile* file)
{
	PlankFileDockItem* self;
	gchar* icon = NULL;
	gchar* text = NULL;
	gchar* uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* key = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GeeHashMap* _tmp14_;
	const gchar* _tmp15_;
	GeeArrayList* _tmp16_;
	gboolean result;
	self = _data11_->self;
	g_return_val_if_fail (display_name != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	_tmp1_ = uri;
	if (g_str_has_suffix (_tmp1_, ".desktop")) {
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = uri;
		plank_application_dock_item_parse_launcher (_tmp2_, &_tmp3_, &_tmp4_, NULL, NULL, NULL);
		_g_free0 (icon);
		icon = _tmp3_;
		_g_free0 (text);
		text = _tmp4_;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp6_ = plank_drawing_service_get_icon_from_file (file);
		_tmp5_ = _tmp6_;
		if (_tmp5_ == NULL) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp7_;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (icon);
		icon = _tmp8_;
		_tmp9_ = display_name;
		if (_tmp9_ == NULL) {
			_tmp9_ = "";
		}
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (text);
		text = _tmp10_;
		_g_free0 (_tmp5_);
	}
	_tmp11_ = text;
	_tmp12_ = uri;
	_tmp13_ = g_strdup_printf ("%s%s", _tmp11_, _tmp12_);
	key = _tmp13_;
	_tmp14_ = _data11_->icons;
	_tmp15_ = icon;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, key, _tmp15_);
	_tmp16_ = _data11_->keys;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, key);
	result = TRUE;
	_g_free0 (key);
	_g_free0 (uri);
	_g_free0 (text);
	_g_free0 (icon);
	return result;
}

static gboolean
___lambda16__gee_forall_map_func (gconstpointer k,
                                  gconstpointer v,
                                  gpointer self)
{
	gboolean result;
	result = __lambda16_ (self, (const gchar*) k, (GFile*) v);
	return result;
}

static void
plank_file_dock_item_real_draw_icon (PlankDockItem* base,
                                     PlankSurface* surface)
{
	PlankFileDockItem * self;
	Block11Data* _data11_;
	gboolean _tmp0_ = FALSE;
	cairo_t* cr = NULL;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	gint width = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint height = 0;
	gint _tmp5_;
	gint _tmp6_;
	gint radius = 0;
	GeeHashMap* _tmp7_;
	GeeArrayList* _tmp8_;
	GFile* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* _tmp11_;
	GeeMapIterator* _tmp12_;
	GeeMapIterator* _tmp13_;
	gint pos = 0;
	gint icon_width = 0;
	gint icon_height = 0;
	gint offset = 0;
	GeeArrayList* _tmp14_;
	self = (PlankFileDockItem*) base;
	g_return_if_fail (surface != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	if (!plank_dock_item_is_valid ((PlankDockItem*) self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !plank_file_dock_item_has_default_icon_match (self);
	}
	if (_tmp0_) {
		PLANK_DOCK_ITEM_CLASS (plank_file_dock_item_parent_class)->draw_icon (G_TYPE_CHECK_INSTANCE_CAST (self, PLANK_TYPE_DOCK_ITEM, PlankDockItem), surface);
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	_tmp1_ = plank_surface_get_Context (surface);
	_tmp2_ = _tmp1_;
	cr = _tmp2_;
	_tmp3_ = plank_surface_get_Width (surface);
	_tmp4_ = _tmp3_;
	width = _tmp4_;
	_tmp5_ = plank_surface_get_Height (surface);
	_tmp6_ = _tmp5_;
	height = _tmp6_;
	radius = 3 + ((6 * height) / (128 - 48));
	plank_dock_item_draw_icon_fast ((PlankDockItem*) self, surface);
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data11_->icons = _tmp7_;
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_data11_->keys = _tmp8_;
	_tmp9_ = self->priv->_OwnedFile;
	_tmp10_ = plank_file_dock_item_get_files (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	gee_map_iterator_foreach (_tmp13_, ___lambda16__gee_forall_map_func, _data11_);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (_tmp11_);
	pos = 0;
	icon_width = (gint) ((width - ((80 * radius) / 33.0)) / 2.0);
	icon_height = (gint) ((height - ((80 * radius) / 33.0)) / 2.0);
	offset = (gint) ((width - (2 * icon_width)) / 3.0);
	_tmp14_ = _data11_->keys;
	gee_list_sort ((GeeList*) _tmp14_, NULL, NULL, NULL);
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp15_;
		gint _s_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _s_index = 0;
		_tmp15_ = _data11_->keys;
		_s_list = _tmp15_;
		_tmp16_ = _s_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_s_size = _tmp18_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gchar* s = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			gint x = 0;
			gint y = 0;
			gint _tmp23_;
			GdkPixbuf* pbuf = NULL;
			GeeHashMap* _tmp24_;
			const gchar* _tmp25_;
			gpointer _tmp26_;
			gchar* _tmp27_;
			GdkPixbuf* _tmp28_;
			GdkPixbuf* _tmp29_;
			cairo_t* _tmp30_;
			GdkPixbuf* _tmp31_;
			GdkPixbuf* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			GdkPixbuf* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			cairo_t* _tmp38_;
			_s_index = _s_index + 1;
			_tmp19_ = _s_index;
			_tmp20_ = _s_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _s_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _s_index);
			s = (gchar*) _tmp22_;
			x = pos % 2;
			y = pos / 2;
			pos = pos + 1;
			_tmp23_ = pos;
			if (_tmp23_ > 4) {
				_g_free0 (s);
				break;
			}
			_tmp24_ = _data11_->icons;
			_tmp25_ = s;
			_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
			_tmp27_ = (gchar*) _tmp26_;
			_tmp28_ = plank_drawing_service_load_icon (_tmp27_, icon_width, icon_height);
			_tmp29_ = _tmp28_;
			_g_free0 (_tmp27_);
			pbuf = _tmp29_;
			_tmp30_ = cr;
			_tmp31_ = pbuf;
			_tmp32_ = pbuf;
			_tmp33_ = gdk_pixbuf_get_width (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = pbuf;
			_tmp36_ = gdk_pixbuf_get_height (_tmp35_);
			_tmp37_ = _tmp36_;
			gdk_cairo_set_source_pixbuf (_tmp30_, _tmp31_, (gdouble) (((x * (icon_width + offset)) + offset) + ((icon_width - _tmp34_) / 2)), (gdouble) (((y * (icon_height + offset)) + offset) + ((icon_height - _tmp37_) / 2)));
			_tmp38_ = cr;
			cairo_paint (_tmp38_);
			_g_object_unref0 (pbuf);
			_g_free0 (s);
		}
	}
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

/**
 * Launches the application associated with this item.
 */
void
plank_file_dock_item_launch (PlankFileDockItem* self)
{
	PlankSystem* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = self->priv->_OwnedFile;
	plank_system_open (_tmp0_, _tmp1_);
	plank_dock_element_set_ClickedAnimation ((PlankDockElement*) self, PLANK_ANIMATION_TYPE_BOUNCE);
	plank_dock_element_set_LastClicked ((PlankDockElement*) self, g_get_monotonic_time ());
}

/**
 * {@inheritDoc}
 */
static PlankAnimationType
plank_file_dock_item_real_on_clicked (PlankDockElement* base,
                                      PlankPopupButton button,
                                      GdkModifierType mod,
                                      guint32 event_time)
{
	PlankFileDockItem * self;
	PlankAnimationType result;
	self = (PlankFileDockItem*) base;
	if (button == PLANK_POPUP_BUTTON_MIDDLE) {
		plank_file_dock_item_launch (self);
		result = PLANK_ANIMATION_TYPE_BOUNCE;
		return result;
	}
	if (button == PLANK_POPUP_BUTTON_LEFT) {
		plank_file_dock_item_launch (self);
		result = PLANK_ANIMATION_TYPE_BOUNCE;
		return result;
	}
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeArrayList*
plank_file_dock_item_real_get_menu_items (PlankDockElement* base)
{
	PlankFileDockItem * self;
	GFile* _tmp0_;
	GeeArrayList* _tmp2_;
	GeeArrayList* result;
	self = (PlankFileDockItem*) base;
	_tmp0_ = self->priv->_OwnedFile;
	if (g_file_query_file_type (_tmp0_, 0, NULL) == G_FILE_TYPE_DIRECTORY) {
		GeeArrayList* _tmp1_;
		_tmp1_ = plank_file_dock_item_get_dir_menu_items (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = plank_file_dock_item_get_file_menu_items (self);
	result = _tmp2_;
	return result;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		PlankFileDockItem* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->keys);
		_g_object_unref0 (_data12_->menu_items);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		PlankFileDockItem* self;
		self = _data13_->_data12_->self;
		_g_object_unref0 (_data13_->file);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static void
___lambda18_ (Block13Data* _data13_)
{
	Block12Data* _data12_;
	PlankFileDockItem* self;
	PlankSystem* _tmp0_;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	_tmp0_ = plank_system_get_default ();
	plank_system_launch (_tmp0_, _data13_->file);
	plank_dock_element_set_ClickedAnimation ((PlankDockElement*) self, PLANK_ANIMATION_TYPE_BOUNCE);
	plank_dock_element_set_LastClicked ((PlankDockElement*) self, g_get_monotonic_time ());
}

static void
____lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda18_ (self);
}

static void
___lambda19_ (Block13Data* _data13_)
{
	Block12Data* _data12_;
	PlankFileDockItem* self;
	PlankSystem* _tmp0_;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	_tmp0_ = plank_system_get_default ();
	plank_system_open (_tmp0_, _data13_->file);
	plank_dock_element_set_ClickedAnimation ((PlankDockElement*) self, PLANK_ANIMATION_TYPE_BOUNCE);
	plank_dock_element_set_LastClicked ((PlankDockElement*) self, g_get_monotonic_time ());
}

static void
____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda19_ (self);
}

static gboolean
__lambda17_ (Block12Data* _data12_,
             const gchar* display_name,
             GFile* file)
{
	PlankFileDockItem* self;
	Block13Data* _data13_;
	GFile* _tmp0_;
	GtkMenuItem* item = NULL;
	gchar* icon = NULL;
	gchar* text = NULL;
	gchar* uri = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* key = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GeeHashMap* _tmp23_;
	GtkMenuItem* _tmp24_;
	GeeArrayList* _tmp25_;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (display_name != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->_data12_ = block12_data_ref (_data12_);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data13_->file);
	_data13_->file = _tmp0_;
	_tmp1_ = g_file_get_uri (_data13_->file);
	uri = _tmp1_;
	_tmp2_ = uri;
	if (g_str_has_suffix (_tmp2_, ".desktop")) {
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GtkMenuItem* _tmp8_;
		GtkMenuItem* _tmp9_;
		_tmp3_ = uri;
		plank_application_dock_item_parse_launcher (_tmp3_, &_tmp4_, &_tmp5_, NULL, NULL, NULL);
		_g_free0 (icon);
		icon = _tmp4_;
		_g_free0 (text);
		text = _tmp5_;
		_tmp6_ = text;
		_tmp7_ = icon;
		_tmp8_ = plank_dock_element_create_menu_item (_tmp6_, _tmp7_, TRUE);
		_g_object_unref0 (item);
		item = _tmp8_;
		_tmp9_ = item;
		g_signal_connect_data (_tmp9_, "activate", (GCallback) ____lambda18__gtk_menu_item_activate, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	} else {
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GtkMenuItem* _tmp18_;
		GtkMenuItem* _tmp19_;
		_tmp11_ = plank_drawing_service_get_icon_from_file (_data13_->file);
		_tmp10_ = _tmp11_;
		if (_tmp10_ == NULL) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("");
			_g_free0 (_tmp10_);
			_tmp10_ = _tmp12_;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_free0 (icon);
		icon = _tmp13_;
		_tmp14_ = display_name;
		if (_tmp14_ == NULL) {
			_tmp14_ = "";
		}
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (text);
		text = _tmp15_;
		_tmp16_ = text;
		_tmp17_ = icon;
		_tmp18_ = plank_dock_element_create_literal_menu_item (_tmp16_, _tmp17_, TRUE);
		_g_object_unref0 (item);
		item = _tmp18_;
		_tmp19_ = item;
		g_signal_connect_data (_tmp19_, "activate", (GCallback) ____lambda19__gtk_menu_item_activate, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		_g_free0 (_tmp10_);
	}
	_tmp20_ = text;
	_tmp21_ = uri;
	_tmp22_ = g_strdup_printf ("%s%s", _tmp20_, _tmp21_);
	key = _tmp22_;
	_tmp23_ = _data12_->menu_items;
	_tmp24_ = item;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, key, _tmp24_);
	_tmp25_ = _data12_->keys;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, key);
	result = TRUE;
	_g_free0 (key);
	_g_free0 (uri);
	_g_free0 (text);
	_g_free0 (icon);
	_g_object_unref0 (item);
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return result;
}

static gboolean
___lambda17__gee_forall_map_func (gconstpointer k,
                                  gconstpointer v,
                                  gpointer self)
{
	gboolean result;
	result = __lambda17_ (self, (const gchar*) k, (GFile*) v);
	return result;
}

static void
___lambda20_ (PlankFileDockItem* self)
{
	plank_dock_item_delete ((PlankDockItem*) self);
}

static void
____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda20_ ((PlankFileDockItem*) self);
}

static void
__lambda21_ (PlankFileDockItem* self)
{
	plank_file_dock_item_launch (self);
}

static void
___lambda21__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda21_ ((PlankFileDockItem*) self);
}

static GeeArrayList*
plank_file_dock_item_get_dir_menu_items (PlankFileDockItem* self)
{
	Block12Data* _data12_;
	GeeArrayList* items = NULL;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeArrayList* _tmp2_;
	GFile* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeMapIterator* _tmp6_;
	GeeMapIterator* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	PlankDefaultApplicationDockItemProvider* default_provider = NULL;
	PlankDockContainer* _tmp28_;
	PlankDockContainer* _tmp29_;
	gboolean _tmp30_ = FALSE;
	PlankDefaultApplicationDockItemProvider* _tmp31_;
	GtkMenuItem* item = NULL;
	GtkMenuItem* _tmp42_;
	GeeArrayList* _tmp43_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	items = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data12_->menu_items = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_data12_->keys = _tmp2_;
	_tmp3_ = self->priv->_OwnedFile;
	_tmp4_ = plank_file_dock_item_get_files (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	gee_map_iterator_foreach (_tmp7_, ___lambda17__gee_forall_map_func, _data12_);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_tmp8_ = _data12_->keys;
	gee_list_sort ((GeeList*) _tmp8_, NULL, NULL, NULL);
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp9_;
		gint _s_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _s_index = 0;
		_tmp9_ = _data12_->keys;
		_s_list = _tmp9_;
		_tmp10_ = _s_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_s_size = _tmp12_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gchar* s = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			GeeArrayList* _tmp17_;
			GeeHashMap* _tmp18_;
			const gchar* _tmp19_;
			gpointer _tmp20_;
			GtkMenuItem* _tmp21_;
			_s_index = _s_index + 1;
			_tmp13_ = _s_index;
			_tmp14_ = _s_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _s_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _s_index);
			s = (gchar*) _tmp16_;
			_tmp17_ = items;
			_tmp18_ = _data12_->menu_items;
			_tmp19_ = s;
			_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp19_);
			_tmp21_ = (GtkMenuItem*) _tmp20_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp21_);
			_g_object_unref0 (_tmp21_);
			_g_free0 (s);
		}
	}
	_tmp22_ = _data12_->keys;
	_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > 0) {
		GeeArrayList* _tmp25_;
		GtkSeparatorMenuItem* _tmp26_;
		GtkSeparatorMenuItem* _tmp27_;
		_tmp25_ = items;
		_tmp26_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp26_);
		_tmp27_ = _tmp26_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (GtkMenuItem*) _tmp27_);
		_g_object_unref0 (_tmp27_);
	}
	_tmp28_ = plank_dock_element_get_Container ((PlankDockElement*) self);
	_tmp29_ = _tmp28_;
	default_provider = PLANK_IS_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER (_tmp29_) ? ((PlankDefaultApplicationDockItemProvider*) _tmp29_) : NULL;
	_tmp31_ = default_provider;
	if (_tmp31_ != NULL) {
		PlankDefaultApplicationDockItemProvider* _tmp32_;
		PlankDockPreferences* _tmp33_;
		PlankDockPreferences* _tmp34_;
		gboolean _tmp35_;
		gboolean _tmp36_;
		_tmp32_ = default_provider;
		_tmp33_ = plank_default_application_dock_item_provider_get_Prefs (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = plank_dock_preferences_get_LockItems (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp30_ = !_tmp36_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GtkCheckMenuItem* delete_item = NULL;
		GtkCheckMenuItem* _tmp37_;
		GtkCheckMenuItem* _tmp38_;
		GtkCheckMenuItem* _tmp39_;
		GeeArrayList* _tmp40_;
		GtkCheckMenuItem* _tmp41_;
		_tmp37_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_mnemonic (_ ("_Keep in Dock"));
		g_object_ref_sink (_tmp37_);
		delete_item = _tmp37_;
		_tmp38_ = delete_item;
		gtk_check_menu_item_set_active (_tmp38_, TRUE);
		_tmp39_ = delete_item;
		g_signal_connect_object ((GtkMenuItem*) _tmp39_, "activate", (GCallback) ____lambda20__gtk_menu_item_activate, self, 0);
		_tmp40_ = items;
		_tmp41_ = delete_item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, (GtkMenuItem*) _tmp41_);
		_g_object_unref0 (delete_item);
	}
	_tmp42_ = plank_dock_element_create_menu_item (_ ("_Open in File Browser"), "gtk-open", FALSE);
	item = _tmp42_;
	g_signal_connect_object (item, "activate", (GCallback) ___lambda21__gtk_menu_item_activate, self, 0);
	_tmp43_ = items;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, item);
	result = items;
	_g_object_unref0 (item);
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return result;
}

static void
___lambda22_ (PlankFileDockItem* self)
{
	plank_dock_item_delete ((PlankDockItem*) self);
}

static void
____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda22_ ((PlankFileDockItem*) self);
}

static void
_plank_file_dock_item_launch_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self)
{
	plank_file_dock_item_launch ((PlankFileDockItem*) self);
}

static void
__lambda23_ (PlankFileDockItem* self)
{
	PlankSystem* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = self->priv->_OwnedFile;
	_tmp2_ = g_file_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	plank_system_open (_tmp0_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	plank_dock_element_set_ClickedAnimation ((PlankDockElement*) self, PLANK_ANIMATION_TYPE_BOUNCE);
	plank_dock_element_set_LastClicked ((PlankDockElement*) self, g_get_monotonic_time ());
}

static void
___lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda23_ ((PlankFileDockItem*) self);
}

static GeeArrayList*
plank_file_dock_item_get_file_menu_items (PlankFileDockItem* self)
{
	GeeArrayList* items = NULL;
	GeeArrayList* _tmp0_;
	PlankDefaultApplicationDockItemProvider* default_provider = NULL;
	PlankDockContainer* _tmp1_;
	PlankDockContainer* _tmp2_;
	gboolean _tmp3_ = FALSE;
	PlankDefaultApplicationDockItemProvider* _tmp4_;
	GtkMenuItem* item = NULL;
	GtkMenuItem* _tmp15_;
	GtkMenuItem* _tmp16_;
	GeeArrayList* _tmp17_;
	GtkMenuItem* _tmp18_;
	GtkMenuItem* _tmp19_;
	GtkMenuItem* _tmp20_;
	GeeArrayList* _tmp21_;
	GtkMenuItem* _tmp22_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	items = _tmp0_;
	_tmp1_ = plank_dock_element_get_Container ((PlankDockElement*) self);
	_tmp2_ = _tmp1_;
	default_provider = PLANK_IS_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER (_tmp2_) ? ((PlankDefaultApplicationDockItemProvider*) _tmp2_) : NULL;
	_tmp4_ = default_provider;
	if (_tmp4_ != NULL) {
		PlankDefaultApplicationDockItemProvider* _tmp5_;
		PlankDockPreferences* _tmp6_;
		PlankDockPreferences* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp5_ = default_provider;
		_tmp6_ = plank_default_application_dock_item_provider_get_Prefs (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = plank_dock_preferences_get_LockItems (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = !_tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkCheckMenuItem* delete_item = NULL;
		GtkCheckMenuItem* _tmp10_;
		GtkCheckMenuItem* _tmp11_;
		GtkCheckMenuItem* _tmp12_;
		GeeArrayList* _tmp13_;
		GtkCheckMenuItem* _tmp14_;
		_tmp10_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_mnemonic (_ ("_Keep in Dock"));
		g_object_ref_sink (_tmp10_);
		delete_item = _tmp10_;
		_tmp11_ = delete_item;
		gtk_check_menu_item_set_active (_tmp11_, TRUE);
		_tmp12_ = delete_item;
		g_signal_connect_object ((GtkMenuItem*) _tmp12_, "activate", (GCallback) ____lambda22__gtk_menu_item_activate, self, 0);
		_tmp13_ = items;
		_tmp14_ = delete_item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (GtkMenuItem*) _tmp14_);
		_g_object_unref0 (delete_item);
	}
	_tmp15_ = plank_dock_element_create_menu_item (_ ("_Open"), "gtk-open", FALSE);
	item = _tmp15_;
	_tmp16_ = item;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) _plank_file_dock_item_launch_gtk_menu_item_activate, self, 0);
	_tmp17_ = items;
	_tmp18_ = item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
	_tmp19_ = plank_dock_element_create_menu_item (_ ("Open Containing _Folder"), "folder", FALSE);
	_g_object_unref0 (item);
	item = _tmp19_;
	_tmp20_ = item;
	g_signal_connect_object (_tmp20_, "activate", (GCallback) ___lambda23__gtk_menu_item_activate, self, 0);
	_tmp21_ = items;
	_tmp22_ = item;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
	result = items;
	_g_object_unref0 (item);
	return result;
}

static GeeHashMap*
plank_file_dock_item_get_files (GFile* file)
{
	GeeHashMap* files = NULL;
	GeeHashMap* _tmp0_;
	guint count = 0U;
	GError* _inner_error0_ = NULL;
	GeeHashMap* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	files = _tmp0_;
	count = 0U;
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp1_;
		GFileInfo* info = NULL;
		_tmp1_ = g_file_enumerate_children (file, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ, 0, NULL, &_inner_error0_);
		enumerator = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp2_ = NULL;
			GFileEnumerator* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			guint _tmp8_;
			const gchar* name = NULL;
			GFileInfo* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_ = NULL;
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			GeeHashMap* _tmp17_;
			const gchar* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			_tmp3_ = enumerator;
			_tmp4_ = g_file_enumerator_next_file (_tmp3_, NULL, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (info);
			info = _tmp5_;
			_tmp6_ = info;
			if (!(_tmp6_ != NULL)) {
				_g_object_unref0 (_tmp2_);
				break;
			}
			_tmp7_ = info;
			if (g_file_info_get_is_hidden (_tmp7_)) {
				_g_object_unref0 (_tmp2_);
				continue;
			}
			_tmp8_ = count;
			count = _tmp8_ + 1;
			if (_tmp8_ >= PLANK_FOLDER_MAX_FILE_COUNT) {
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_file_get_path (file);
				_tmp10_ = _tmp9_;
				g_critical ("FileDockItem.vala:376: There are way too many files (%u+) in '%s'.", PLANK_FOLDER_MAX_FILE_COUNT, _tmp10_);
				_g_free0 (_tmp10_);
				_g_object_unref0 (_tmp2_);
				break;
			}
			_tmp11_ = info;
			_tmp12_ = g_file_info_get_name (_tmp11_);
			name = _tmp12_;
			_tmp14_ = info;
			_tmp15_ = g_file_info_get_display_name (_tmp14_);
			_tmp13_ = _tmp15_;
			if (_tmp13_ == NULL) {
				const gchar* _tmp16_;
				_tmp16_ = name;
				_tmp13_ = _tmp16_;
			}
			_tmp17_ = files;
			_tmp18_ = name;
			_tmp19_ = g_file_get_child (file, _tmp18_);
			_tmp20_ = _tmp19_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp13_, _tmp20_);
			_g_object_unref0 (_tmp20_);
			_g_object_unref0 (_tmp2_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = files;
	return result;
}

static gchar*
plank_file_dock_item_get_display_name (GFile* file)
{
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		gchar* _tmp4_;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, 0, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_info_get_display_name (info);
		_tmp1_ = _tmp2_;
		if (_tmp1_ == NULL) {
			const gchar* _tmp3_;
			_tmp3_ = g_file_info_get_name (info);
			_tmp1_ = _tmp3_;
		}
		_tmp4_ = g_strdup (_tmp1_);
		result = _tmp4_;
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = g_file_get_path (file);
	_tmp5_ = _tmp6_;
	if (_tmp5_ == NULL) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp7_;
	}
	g_debug ("FileDockItem.vala:395: Could not get display-name for '%s'", _tmp5_);
	_tmp8_ = g_strdup ("Unknown");
	result = _tmp8_;
	_g_free0 (_tmp5_);
	return result;
}

PlankFileDockItem*
plank_file_dock_item_construct (GType object_type)
{
	PlankFileDockItem * self = NULL;
	self = (PlankFileDockItem*) plank_dock_item_construct (object_type);
	return self;
}

PlankFileDockItem*
plank_file_dock_item_new (void)
{
	return plank_file_dock_item_construct (PLANK_TYPE_FILE_DOCK_ITEM);
}

GFile*
plank_file_dock_item_get_OwnedFile (PlankFileDockItem* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_OwnedFile;
	result = _tmp0_;
	return result;
}

void
plank_file_dock_item_set_OwnedFile (PlankFileDockItem* self,
                                    GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_file_dock_item_get_OwnedFile (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_OwnedFile);
		self->priv->_OwnedFile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_file_dock_item_properties[PLANK_FILE_DOCK_ITEM_OWNED_FILE_PROPERTY]);
	}
}

static GObject *
plank_file_dock_item_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankFileDockItem * self;
	parent_class = G_OBJECT_CLASS (plank_file_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_FILE_DOCK_ITEM, PlankFileDockItem);
	plank_dock_item_load_from_launcher ((PlankDockItem*) self);
	return obj;
}

static void
plank_file_dock_item_class_init (PlankFileDockItemClass * klass,
                                 gpointer klass_data)
{
	plank_file_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankFileDockItem_private_offset);
	((PlankDockItemClass *) klass)->load_from_launcher = (void (*) (PlankDockItem*)) plank_file_dock_item_real_load_from_launcher;
	((PlankDockItemClass *) klass)->draw_icon_fast = (void (*) (PlankDockItem*, PlankSurface*)) plank_file_dock_item_real_draw_icon_fast;
	((PlankDockItemClass *) klass)->draw_icon = (void (*) (PlankDockItem*, PlankSurface*)) plank_file_dock_item_real_draw_icon;
	((PlankDockElementClass *) klass)->on_clicked = (PlankAnimationType (*) (PlankDockElement*, PlankPopupButton, GdkModifierType, guint32)) plank_file_dock_item_real_on_clicked;
	((PlankDockElementClass *) klass)->get_menu_items = (GeeArrayList* (*) (PlankDockElement*)) plank_file_dock_item_real_get_menu_items;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_file_dock_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_file_dock_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_file_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_file_dock_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_FILE_DOCK_ITEM_OWNED_FILE_PROPERTY, plank_file_dock_item_properties[PLANK_FILE_DOCK_ITEM_OWNED_FILE_PROPERTY] = g_param_spec_object ("OwnedFile", "OwnedFile", "OwnedFile", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
plank_file_dock_item_instance_init (PlankFileDockItem * self,
                                    gpointer klass)
{
	self->priv = plank_file_dock_item_get_instance_private (self);
}

static void
plank_file_dock_item_finalize (GObject * obj)
{
	PlankFileDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_FILE_DOCK_ITEM, PlankFileDockItem);
	plank_file_dock_item_stop_monitor (self);
	_g_object_unref0 (self->priv->_OwnedFile);
	_g_object_unref0 (self->priv->dir_monitor);
	G_OBJECT_CLASS (plank_file_dock_item_parent_class)->finalize (obj);
}

/**
 * A dock item for files or folders on the dock.
 *
 * Folders act like stacks and display the contents of the folder in the
 * popup menu. Files just open the associated file.
 */
static GType
plank_file_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankFileDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_file_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankFileDockItem), 0, (GInstanceInitFunc) plank_file_dock_item_instance_init, NULL };
	GType plank_file_dock_item_type_id;
	plank_file_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCK_ITEM, "PlankFileDockItem", &g_define_type_info, 0);
	PlankFileDockItem_private_offset = g_type_add_instance_private (plank_file_dock_item_type_id, sizeof (PlankFileDockItemPrivate));
	return plank_file_dock_item_type_id;
}

GType
plank_file_dock_item_get_type (void)
{
	static volatile gsize plank_file_dock_item_type_id__once = 0;
	if (g_once_init_enter (&plank_file_dock_item_type_id__once)) {
		GType plank_file_dock_item_type_id;
		plank_file_dock_item_type_id = plank_file_dock_item_get_type_once ();
		g_once_init_leave (&plank_file_dock_item_type_id__once, plank_file_dock_item_type_id);
	}
	return plank_file_dock_item_type_id__once;
}

static void
_vala_plank_file_dock_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	PlankFileDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_FILE_DOCK_ITEM, PlankFileDockItem);
	switch (property_id) {
		case PLANK_FILE_DOCK_ITEM_OWNED_FILE_PROPERTY:
		g_value_set_object (value, plank_file_dock_item_get_OwnedFile (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_file_dock_item_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	PlankFileDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_FILE_DOCK_ITEM, PlankFileDockItem);
	switch (property_id) {
		case PLANK_FILE_DOCK_ITEM_OWNED_FILE_PROPERTY:
		plank_file_dock_item_set_OwnedFile (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

