/* Preferences.c generated by valac 0.56.17, the Vala compiler
 * generated from Preferences.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_PREFERENCES_0_PROPERTY,
	PLANK_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* plank_preferences_properties[PLANK_PREFERENCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	PLANK_PREFERENCES_DELETED_SIGNAL,
	PLANK_PREFERENCES_NUM_SIGNALS
};
static guint plank_preferences_signals[PLANK_PREFERENCES_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankPreferencesPrivate {
	GFile* backing_file;
	GFileMonitor* backing_monitor;
	gboolean read_only;
	gboolean is_delayed;
	gboolean is_delayed_internal;
	gboolean is_changed;
};

static gint PlankPreferences_private_offset;
static gpointer plank_preferences_parent_class = NULL;
static gchar** plank_preferences_TRANSITION_MAP;
static gint plank_preferences_TRANSITION_MAP_length1;
static gint plank_preferences_TRANSITION_MAP_length2;
static gchar** plank_preferences_TRANSITION_MAP = NULL;
static gint plank_preferences_TRANSITION_MAP_length1 = 0;
static gint plank_preferences_TRANSITION_MAP_length2 = 0;

static GType plank_serializable_get_type_once (void);
static void plank_preferences_handle_notify (PlankPreferences* self,
                                      GObject* sender,
                                      GParamSpec* property);
static void _plank_preferences_handle_notify_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void plank_preferences_stop_monitor (PlankPreferences* self);
static void plank_preferences_save_prefs (PlankPreferences* self);
static void plank_preferences_call_verify (PlankPreferences* self,
                                    const gchar* prop);
static void plank_preferences_handle_verify_notify (PlankPreferences* self,
                                             GObject* sender,
                                             GParamSpec* property);
static void _plank_preferences_handle_verify_notify_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void plank_preferences_real_verify (PlankPreferences* self,
                                    const gchar* prop);
static void plank_preferences_real_reset_properties (PlankPreferences* self);
static void plank_preferences_load_prefs (PlankPreferences* self);
static void plank_preferences_start_monitor (PlankPreferences* self);
static void plank_preferences_backing_file_changed (GFile* f,
                                             GFile* other,
                                             GFileMonitorEvent event,
                                             PlankPreferences* self);
static void _plank_preferences_backing_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                     GFile* file,
                                                                     GFile* other_file,
                                                                     GFileMonitorEvent event_type,
                                                                     gpointer self);
static GObject * plank_preferences_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void plank_preferences_finalize (GObject * obj);
static GType plank_preferences_get_type_once (void);

/**
 * Serializes the object into a string representation.
 *
 * @return the string representation of the object
 */
gchar*
plank_serializable_serialize (PlankSerializable* self)
{
	PlankSerializableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PLANK_SERIALIZABLE_GET_INTERFACE (self);
	if (_iface_->serialize) {
		return _iface_->serialize (self);
	}
	return NULL;
}

/**
 * De-serializes the object from a string representation.
 *
 * @param s the string representation of the object
 */
void
plank_serializable_deserialize (PlankSerializable* self,
                                const gchar* s)
{
	PlankSerializableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PLANK_SERIALIZABLE_GET_INTERFACE (self);
	if (_iface_->deserialize) {
		_iface_->deserialize (self, s);
	}
}

static void
plank_serializable_default_init (PlankSerializableIface * iface,
                                 gpointer iface_data)
{
}

/**
 * This interface is used by objects that need to be serialized in a Preferences.
 * The object must have a string representation and provide these methods to
 * translate between the string and object representations.
 */
static GType
plank_serializable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankSerializableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_serializable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plank_serializable_type_id;
	plank_serializable_type_id = g_type_register_static (G_TYPE_INTERFACE, "PlankSerializable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plank_serializable_type_id, G_TYPE_OBJECT);
	return plank_serializable_type_id;
}

GType
plank_serializable_get_type (void)
{
	static volatile gsize plank_serializable_type_id__once = 0;
	if (g_once_init_enter (&plank_serializable_type_id__once)) {
		GType plank_serializable_type_id;
		plank_serializable_type_id = plank_serializable_get_type_once ();
		g_once_init_leave (&plank_serializable_type_id__once, plank_serializable_type_id);
	}
	return plank_serializable_type_id__once;
}

static inline gpointer
plank_preferences_get_instance_private (PlankPreferences* self)
{
	return G_STRUCT_MEMBER_P (self, PlankPreferences_private_offset);
}

static void
_plank_preferences_handle_notify_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	plank_preferences_handle_notify ((PlankPreferences*) self, _sender, pspec);
}

/**
 * Creates a new preferences object with no backing file.
 */
PlankPreferences*
plank_preferences_construct (GType object_type)
{
	PlankPreferences * self = NULL;
	self = (PlankPreferences*) g_object_new (object_type, NULL);
	return self;
}

static void
plank_preferences_handle_notify (PlankPreferences* self,
                                 GObject* sender,
                                 GParamSpec* property)
{
	guint _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (property != NULL);
	if (self->priv->read_only) {
		return;
	}
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _plank_preferences_handle_notify_g_object_notify, self);
	g_object_freeze_notify ((GObject*) self);
	_tmp1_ = property->name;
	plank_logger_verbose ("property changed: %s", _tmp1_, NULL);
	self->priv->is_delayed_internal = TRUE;
	_tmp2_ = self->priv->backing_file;
	if (_tmp2_ != NULL) {
		plank_preferences_save_prefs (self);
	}
	_tmp3_ = property->name;
	plank_preferences_call_verify (self, _tmp3_);
	self->priv->is_delayed_internal = FALSE;
	if (!self->priv->is_delayed) {
		_tmp5_ = self->priv->is_changed;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GFile* _tmp6_;
		_tmp6_ = self->priv->backing_file;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		plank_preferences_save_prefs (self);
	}
	g_object_thaw_notify ((GObject*) self);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _plank_preferences_handle_notify_g_object_notify, self, 0);
}

static void
plank_preferences_handle_verify_notify (PlankPreferences* self,
                                        GObject* sender,
                                        GParamSpec* property)
{
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (property != NULL);
	plank_preferences_save_prefs (self);
	_tmp0_ = self->priv->backing_file;
	if (_tmp0_ != NULL) {
		gchar* _tmp1_ = NULL;
		GFile* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->backing_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp1_ = _tmp3_;
		if (_tmp1_ == NULL) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp4_;
		}
		_tmp5_ = property->name;
		g_warning ("Preferences.vala:113: Key '%s' failed verification in preferences file" \
" '%s', changing value", _tmp5_, _tmp1_);
		_g_free0 (_tmp1_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = property->name;
		g_warning ("Preferences.vala:115: Key '%s' failed verification, changing value", _tmp6_);
	}
}

static void
_plank_preferences_handle_verify_notify_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	plank_preferences_handle_verify_notify ((PlankPreferences*) self, _sender, pspec);
}

static void
plank_preferences_call_verify (PlankPreferences* self,
                               const gchar* prop)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	g_object_freeze_notify ((GObject*) self);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _plank_preferences_handle_verify_notify_g_object_notify, self, 0);
	plank_preferences_verify (self, prop);
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _plank_preferences_handle_verify_notify_g_object_notify, self);
	g_object_thaw_notify ((GObject*) self);
}

/**
 * This method will verify the value of a property.
 * If the value is wrong, this method should replace it with a sanitized value.
 *
 * @param prop the name of the property that needs verified
 */
static void
plank_preferences_real_verify (PlankPreferences* self,
                               const gchar* prop)
{
	g_return_if_fail (prop != NULL);
}

void
plank_preferences_verify (PlankPreferences* self,
                          const gchar* prop)
{
	PlankPreferencesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_PREFERENCES_GET_CLASS (self);
	if (_klass_->verify) {
		_klass_->verify (self, prop);
	}
}

/**
 * Resets all properties to their default values.  Called from construct and before
 * loading from the backing file.
 */
static void
plank_preferences_real_reset_properties (PlankPreferences* self)
{
	g_critical ("Type `%s' does not implement abstract method `plank_preferences_reset_properties'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
plank_preferences_reset_properties (PlankPreferences* self)
{
	PlankPreferencesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_PREFERENCES_GET_CLASS (self);
	if (_klass_->reset_properties) {
		_klass_->reset_properties (self);
	}
}

/**
 * Creates a preferences object with a backing file.
 *
 * @param file the {@link GLib.File} of the backing file for this preferences
 */
PlankPreferences*
plank_preferences_construct_with_file (GType object_type,
                                       GFile* file)
{
	PlankPreferences * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (PlankPreferences*) g_object_new (object_type, NULL);
	plank_preferences_init_from_file (self, file);
	return self;
}

/**
 * Creates a preferences object with a backing filename.
 *
 * @param filename of the backing file for this preferences
 */
PlankPreferences*
plank_preferences_construct_with_filename (GType object_type,
                                           const gchar* filename)
{
	PlankPreferences * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (PlankPreferences*) g_object_new (object_type, NULL);
	_tmp0_ = plank_paths_get_AppConfigFolder ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, filename);
	_tmp3_ = _tmp2_;
	plank_preferences_init_from_file (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

/**
 * Initializes this preferences with a backing file.
 *
 * @param file the {@link GLib.File} of the backing file for this preferences
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
plank_preferences_init_from_file (PlankPreferences* self,
                                  GFile* file)
{
	GFile* _tmp0_;
	gboolean file_exists = FALSE;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	plank_preferences_stop_monitor (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->backing_file);
	self->priv->backing_file = _tmp0_;
	_tmp1_ = self->priv->backing_file;
	file_exists = g_file_query_exists (_tmp1_, NULL);
	if (!self->priv->read_only) {
		{
			GFileInfo* info = NULL;
			gboolean _tmp11_ = FALSE;
			if (file_exists) {
				GFileInfo* _tmp2_ = NULL;
				GFileInfo* _tmp3_;
				GFileInfo* _tmp4_;
				_tmp3_ = g_file_query_info (file, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				_tmp2_ = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					goto __catch0_g_error;
				}
				_tmp4_ = _tmp2_;
				_tmp2_ = NULL;
				_g_object_unref0 (info);
				info = _tmp4_;
				_g_object_unref0 (_tmp2_);
			} else {
				GFileInfo* _tmp5_ = NULL;
				GFile* _tmp6_;
				GFile* _tmp7_;
				GFileInfo* _tmp8_;
				GFileInfo* _tmp9_;
				GFileInfo* _tmp10_;
				_tmp6_ = g_file_get_parent (file);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_file_query_info (_tmp7_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp7_);
				_tmp5_ = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					goto __catch0_g_error;
				}
				_tmp10_ = _tmp5_;
				_tmp5_ = NULL;
				_g_object_unref0 (info);
				info = _tmp10_;
				_g_object_unref0 (_tmp5_);
			}
			if (self->priv->read_only) {
				_tmp11_ = TRUE;
			} else {
				GFileInfo* _tmp12_;
				_tmp12_ = info;
				_tmp11_ = !g_file_info_get_attribute_boolean (_tmp12_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
			}
			self->priv->read_only = _tmp11_;
			if (self->priv->read_only) {
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp14_ = g_file_get_path (file);
				_tmp13_ = _tmp14_;
				if (_tmp13_ == NULL) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("");
					_g_free0 (_tmp13_);
					_tmp13_ = _tmp15_;
				}
				g_warning ("Preferences.vala:192: '%s' is read-only!", _tmp13_);
				_g_free0 (_tmp13_);
			}
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_warning ("Preferences.vala:194: %s", _tmp17_);
			self->priv->read_only = TRUE;
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (!file_exists) {
		plank_preferences_save_prefs (self);
	} else {
		plank_preferences_load_prefs (self);
	}
	plank_preferences_start_monitor (self);
}

/**
 * Initializes this preferences with a backing filename.
 *
 * @param filename of the backing file for this preferences
 */
void
plank_preferences_init_from_filename (PlankPreferences* self,
                                      const gchar* filename)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = plank_paths_get_AppConfigFolder ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, filename);
	_tmp3_ = _tmp2_;
	plank_preferences_init_from_file (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

/**
 * Delays saving changes to the backing file until apply() is called.
 */
void
plank_preferences_delay (PlankPreferences* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->read_only) {
		return;
	}
	if (self->priv->is_delayed) {
		return;
	}
	_tmp1_ = self->priv->backing_file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->backing_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->backing_file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		plank_logger_verbose ("Preferences.delay('%s')", _tmp7_, NULL);
		_g_free0 (_tmp7_);
	} else {
		plank_logger_verbose ("Preferences.delay()", NULL);
	}
	self->priv->is_delayed = TRUE;
}

/**
 * If any settings were changed, apply them now.
 */
void
plank_preferences_apply (PlankPreferences* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->read_only) {
		return;
	}
	if (!self->priv->is_delayed) {
		return;
	}
	_tmp1_ = self->priv->backing_file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->backing_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->backing_file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		plank_logger_verbose ("Preferences.apply('%s')", _tmp7_, NULL);
		_g_free0 (_tmp7_);
	} else {
		plank_logger_verbose ("Preferences.apply()", NULL);
	}
	self->priv->is_delayed = FALSE;
	if (self->priv->is_changed) {
		GFile* _tmp9_;
		_tmp9_ = self->priv->backing_file;
		_tmp8_ = _tmp9_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		plank_preferences_save_prefs (self);
	}
}

/**
 * Returns the filename of the backing file.
 *
 * @return the filename of the backing file
 */
gchar*
plank_preferences_get_filename (PlankPreferences* self)
{
	GFile* _tmp0_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->backing_file;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->backing_file;
	_tmp3_ = g_file_get_basename (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
 * Returns the backing file.
 *
 * @return the backing file
 */
GFile*
plank_preferences_get_backing_file (PlankPreferences* self)
{
	GFile* _tmp0_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->backing_file;
	result = _tmp0_;
	return result;
}

/**
 * This forces the deletion of the backing file for this preferences.
 */
void
plank_preferences_delete (PlankPreferences* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->read_only) {
		return;
	}
	self->priv->is_delayed = FALSE;
	self->priv->is_changed = FALSE;
	{
		gchar* _tmp0_ = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		GFile* _tmp4_;
		_tmp1_ = self->priv->backing_file;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp0_ = _tmp2_;
		if (_tmp0_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp3_;
		}
		plank_logger_verbose ("Preferences.delete ('%s')", _tmp0_, NULL);
		_tmp4_ = self->priv->backing_file;
		g_file_delete (_tmp4_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp5_ = NULL;
		GFile* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = self->priv->backing_file;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp5_ = _tmp7_;
		if (_tmp5_ == NULL) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp8_;
		}
		g_warning ("Preferences.vala:300: Unable to delete the preferences file '%s'", _tmp5_);
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_debug ("Preferences.vala:301: %s", _tmp10_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_plank_preferences_backing_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                GFile* file,
                                                                GFile* other_file,
                                                                GFileMonitorEvent event_type,
                                                                gpointer self)
{
	plank_preferences_backing_file_changed (file, other_file, event_type, (PlankPreferences*) self);
}

static void
plank_preferences_stop_monitor (PlankPreferences* self)
{
	GFileMonitor* _tmp0_;
	GFileMonitor* _tmp1_;
	guint _tmp2_;
	GFileMonitor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->backing_monitor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->backing_monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_preferences_backing_file_changed_g_file_monitor_changed, self);
	_tmp3_ = self->priv->backing_monitor;
	g_file_monitor_cancel (_tmp3_);
	_g_object_unref0 (self->priv->backing_monitor);
	self->priv->backing_monitor = NULL;
}

static void
plank_preferences_start_monitor (PlankPreferences* self)
{
	GFileMonitor* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->backing_monitor;
	if (_tmp0_ != NULL) {
		return;
	}
	{
		GFileMonitor* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp2_ = self->priv->backing_file;
		_tmp3_ = g_file_monitor_file (_tmp2_, 0, NULL, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->backing_monitor);
		self->priv->backing_monitor = _tmp4_;
		_tmp5_ = self->priv->backing_monitor;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _plank_preferences_backing_file_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp6_ = NULL;
		GFile* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = self->priv->backing_file;
		_tmp8_ = g_file_get_path (_tmp7_);
		_tmp6_ = _tmp8_;
		if (_tmp6_ == NULL) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("");
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp9_;
		}
		g_critical ("Preferences.vala:324: Unable to watch the preferences file '%s'", _tmp6_);
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_debug ("Preferences.vala:325: %s", _tmp11_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
plank_preferences_backing_file_changed (GFile* f,
                                        GFile* other,
                                        GFileMonitorEvent event,
                                        PlankPreferences* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			plank_preferences_load_prefs (self);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			if (!g_file_query_exists (f, NULL)) {
				g_signal_emit (self, plank_preferences_signals[PLANK_PREFERENCES_DELETED_SIGNAL], 0);
			}
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
plank_preferences_load_prefs (PlankPreferences* self)
{
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* backing_file_path = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean missing_keys = FALSE;
	guint _tmp6_;
	gboolean _tmp113_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->backing_file;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	backing_file_path = _tmp4_;
	_tmp5_ = backing_file_path;
	g_debug ("Preferences.vala:349: Loading preferences from file '%s'", _tmp5_);
	missing_keys = FALSE;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _plank_preferences_handle_notify_g_object_notify, self);
	g_object_freeze_notify ((GObject*) self);
	self->priv->is_delayed_internal = TRUE;
	{
		GKeyFile* file = NULL;
		GKeyFile* _tmp7_;
		GKeyFile* _tmp8_;
		const gchar* _tmp9_;
		GParamSpec** properties = NULL;
		GObjectClass* _tmp10_;
		guint _tmp11_ = 0;
		GParamSpec** _tmp12_;
		gint properties_length1;
		gint _properties_size_;
		GParamSpec** _tmp13_;
		gint _tmp13__length1;
		_tmp7_ = g_key_file_new ();
		file = _tmp7_;
		_tmp8_ = file;
		_tmp9_ = backing_file_path;
		g_key_file_load_from_file (_tmp8_, _tmp9_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp10_ = G_OBJECT_GET_CLASS ((GObject*) self);
		_tmp12_ = g_object_class_list_properties (_tmp10_, &_tmp11_);
		properties = _tmp12_;
		properties_length1 = _tmp11_;
		_properties_size_ = properties_length1;
		_tmp13_ = properties;
		_tmp13__length1 = properties_length1;
		{
			GParamSpec** prop_collection = NULL;
			gint prop_collection_length1 = 0;
			gint _prop_collection_size_ = 0;
			gint prop_it = 0;
			prop_collection = _tmp13_;
			prop_collection_length1 = _tmp13__length1;
			for (prop_it = 0; prop_it < prop_collection_length1; prop_it = prop_it + 1) {
				GParamSpec* prop = NULL;
				prop = prop_collection[prop_it];
				{
					const gchar* group_name = NULL;
					GParamSpec* _tmp14_;
					const gchar* _tmp15_;
					const gchar* prop_name = NULL;
					GParamSpec* _tmp16_;
					const gchar* _tmp17_;
					GKeyFile* _tmp18_;
					const gchar* _tmp19_;
					gboolean _tmp27_ = FALSE;
					GKeyFile* _tmp28_;
					const gchar* _tmp29_;
					GType type = 0UL;
					GParamSpec* _tmp37_;
					_tmp14_ = prop;
					_tmp15_ = g_type_name (_tmp14_->owner_type);
					group_name = _tmp15_;
					_tmp16_ = prop;
					_tmp17_ = g_param_spec_get_name (_tmp16_);
					prop_name = _tmp17_;
					_tmp18_ = file;
					_tmp19_ = group_name;
					if (!g_key_file_has_group (_tmp18_, _tmp19_)) {
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp20_ = FALSE;
								_tmp20_ = TRUE;
								while (TRUE) {
									gchar** _tmp22_;
									gint _tmp22__length1;
									gint _tmp22__length2;
									const gchar* _tmp23_;
									const gchar* _tmp24_;
									if (!_tmp20_) {
										gint _tmp21_;
										_tmp21_ = i;
										i = _tmp21_ + 1;
									}
									_tmp20_ = FALSE;
									if (!(i < 3)) {
										break;
									}
									_tmp22_ = plank_preferences_TRANSITION_MAP;
									_tmp22__length1 = plank_preferences_TRANSITION_MAP_length1;
									_tmp22__length2 = plank_preferences_TRANSITION_MAP_length2;
									_tmp23_ = _tmp22_[(i * _tmp22__length2) + 1];
									_tmp24_ = group_name;
									if (g_strcmp0 (_tmp23_, _tmp24_) == 0) {
										gchar** _tmp25_;
										gint _tmp25__length1;
										gint _tmp25__length2;
										const gchar* _tmp26_;
										_tmp25_ = plank_preferences_TRANSITION_MAP;
										_tmp25__length1 = plank_preferences_TRANSITION_MAP_length1;
										_tmp25__length2 = plank_preferences_TRANSITION_MAP_length2;
										_tmp26_ = _tmp25_[(i * _tmp25__length2) + 0];
										group_name = _tmp26_;
										missing_keys = TRUE;
										break;
									}
								}
							}
						}
					}
					_tmp28_ = file;
					_tmp29_ = group_name;
					if (!g_key_file_has_group (_tmp28_, _tmp29_)) {
						_tmp27_ = TRUE;
					} else {
						gboolean _tmp30_ = FALSE;
						GKeyFile* _tmp31_;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp31_ = file;
						_tmp32_ = group_name;
						_tmp33_ = prop_name;
						_tmp30_ = g_key_file_has_key (_tmp31_, _tmp32_, _tmp33_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							properties = (g_free (properties), NULL);
							_g_key_file_unref0 (file);
							goto __catch0_g_error;
						}
						_tmp27_ = !_tmp30_;
					}
					if (_tmp27_) {
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						_tmp34_ = prop_name;
						_tmp35_ = group_name;
						_tmp36_ = backing_file_path;
						g_warning ("Preferences.vala:378: Missing key '%s' for group '%s' in preferences f" \
"ile '%s' - using default value", _tmp34_, _tmp35_, _tmp36_);
						missing_keys = TRUE;
						continue;
					}
					_tmp37_ = prop;
					type = _tmp37_->value_type;
					{
						const gchar* _tmp105_;
						if (type == G_TYPE_INT) {
							gint old_val = 0;
							const gchar* _tmp38_;
							gint _tmp39_ = 0;
							gint new_val = 0;
							GKeyFile* _tmp40_;
							const gchar* _tmp41_;
							const gchar* _tmp42_;
							const gchar* _tmp43_;
							_tmp38_ = prop_name;
							g_object_get ((GObject*) self, _tmp38_, &_tmp39_, NULL);
							old_val = _tmp39_;
							_tmp40_ = file;
							_tmp41_ = group_name;
							_tmp42_ = prop_name;
							new_val = g_key_file_get_integer (_tmp40_, _tmp41_, _tmp42_, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
									goto __catch1_g_key_file_error;
								}
								properties = (g_free (properties), NULL);
								_g_key_file_unref0 (file);
								_g_free0 (backing_file_path);
								_g_free0 (_tmp0_);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							if (old_val == new_val) {
								continue;
							}
							_tmp43_ = prop_name;
							g_object_set ((GObject*) self, _tmp43_, new_val, NULL);
						} else {
							if (type == G_TYPE_UINT) {
								guint old_val = 0U;
								const gchar* _tmp44_;
								guint _tmp45_ = 0U;
								gint _tmp46_ = 0;
								GKeyFile* _tmp47_;
								const gchar* _tmp48_;
								const gchar* _tmp49_;
								guint new_val = 0U;
								const gchar* _tmp50_;
								_tmp44_ = prop_name;
								g_object_get ((GObject*) self, _tmp44_, &_tmp45_, NULL);
								old_val = _tmp45_;
								_tmp47_ = file;
								_tmp48_ = group_name;
								_tmp49_ = prop_name;
								_tmp46_ = g_key_file_get_integer (_tmp47_, _tmp48_, _tmp49_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
										goto __catch1_g_key_file_error;
									}
									properties = (g_free (properties), NULL);
									_g_key_file_unref0 (file);
									_g_free0 (backing_file_path);
									_g_free0 (_tmp0_);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
								new_val = (guint) _tmp46_;
								if (old_val == new_val) {
									continue;
								}
								_tmp50_ = prop_name;
								g_object_set ((GObject*) self, _tmp50_, new_val, NULL);
							} else {
								if (type == G_TYPE_DOUBLE) {
									gdouble old_val = 0.0;
									const gchar* _tmp51_;
									gdouble _tmp52_ = 0.0;
									gdouble new_val = 0.0;
									GKeyFile* _tmp53_;
									const gchar* _tmp54_;
									const gchar* _tmp55_;
									const gchar* _tmp56_;
									_tmp51_ = prop_name;
									g_object_get ((GObject*) self, _tmp51_, &_tmp52_, NULL);
									old_val = _tmp52_;
									_tmp53_ = file;
									_tmp54_ = group_name;
									_tmp55_ = prop_name;
									new_val = g_key_file_get_double (_tmp53_, _tmp54_, _tmp55_, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch1_g_key_file_error;
										}
										properties = (g_free (properties), NULL);
										_g_key_file_unref0 (file);
										_g_free0 (backing_file_path);
										_g_free0 (_tmp0_);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									if (old_val == new_val) {
										continue;
									}
									_tmp56_ = prop_name;
									g_object_set ((GObject*) self, _tmp56_, new_val, NULL);
								} else {
									if (type == G_TYPE_STRING) {
										gchar* old_val = NULL;
										const gchar* _tmp57_;
										gchar* _tmp58_ = NULL;
										gchar* new_val = NULL;
										GKeyFile* _tmp59_;
										const gchar* _tmp60_;
										const gchar* _tmp61_;
										gchar* _tmp62_;
										const gchar* _tmp63_;
										const gchar* _tmp64_;
										const gchar* _tmp65_;
										const gchar* _tmp66_;
										_tmp57_ = prop_name;
										g_object_get ((GObject*) self, _tmp57_, &_tmp58_, NULL);
										_g_free0 (old_val);
										old_val = _tmp58_;
										_tmp59_ = file;
										_tmp60_ = group_name;
										_tmp61_ = prop_name;
										_tmp62_ = g_key_file_get_string (_tmp59_, _tmp60_, _tmp61_, &_inner_error0_);
										new_val = _tmp62_;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_free0 (old_val);
											if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
												goto __catch1_g_key_file_error;
											}
											properties = (g_free (properties), NULL);
											_g_key_file_unref0 (file);
											_g_free0 (backing_file_path);
											_g_free0 (_tmp0_);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										_tmp63_ = old_val;
										_tmp64_ = new_val;
										if (g_strcmp0 (_tmp63_, _tmp64_) == 0) {
											_g_free0 (new_val);
											_g_free0 (old_val);
											continue;
										}
										_tmp65_ = prop_name;
										_tmp66_ = new_val;
										g_object_set ((GObject*) self, _tmp65_, _tmp66_, NULL);
										_g_free0 (new_val);
										_g_free0 (old_val);
									} else {
										if (type == G_TYPE_BOOLEAN) {
											gboolean old_val = FALSE;
											const gchar* _tmp67_;
											gboolean _tmp68_ = FALSE;
											gboolean new_val = FALSE;
											GKeyFile* _tmp69_;
											const gchar* _tmp70_;
											const gchar* _tmp71_;
											const gchar* _tmp72_;
											_tmp67_ = prop_name;
											g_object_get ((GObject*) self, _tmp67_, &_tmp68_, NULL);
											old_val = _tmp68_;
											_tmp69_ = file;
											_tmp70_ = group_name;
											_tmp71_ = prop_name;
											new_val = g_key_file_get_boolean (_tmp69_, _tmp70_, _tmp71_, &_inner_error0_);
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
												if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
													goto __catch1_g_key_file_error;
												}
												properties = (g_free (properties), NULL);
												_g_key_file_unref0 (file);
												_g_free0 (backing_file_path);
												_g_free0 (_tmp0_);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
												g_clear_error (&_inner_error0_);
												return;
											}
											if (old_val == new_val) {
												continue;
											}
											_tmp72_ = prop_name;
											g_object_set ((GObject*) self, _tmp72_, new_val, NULL);
										} else {
											if (G_TYPE_IS_ENUM (type)) {
												gint old_val = 0;
												const gchar* _tmp73_;
												gint _tmp74_ = 0;
												gint new_val = 0;
												GKeyFile* _tmp75_;
												const gchar* _tmp76_;
												const gchar* _tmp77_;
												const gchar* _tmp78_;
												_tmp73_ = prop_name;
												g_object_get ((GObject*) self, _tmp73_, &_tmp74_, NULL);
												old_val = _tmp74_;
												_tmp75_ = file;
												_tmp76_ = group_name;
												_tmp77_ = prop_name;
												new_val = g_key_file_get_integer (_tmp75_, _tmp76_, _tmp77_, &_inner_error0_);
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
													if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
														goto __catch1_g_key_file_error;
													}
													properties = (g_free (properties), NULL);
													_g_key_file_unref0 (file);
													_g_free0 (backing_file_path);
													_g_free0 (_tmp0_);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
													g_clear_error (&_inner_error0_);
													return;
												}
												if (old_val == new_val) {
													continue;
												}
												_tmp78_ = prop_name;
												g_object_set ((GObject*) self, _tmp78_, new_val, NULL);
											} else {
												gboolean _tmp79_ = FALSE;
												if (g_type_is_a (type, PLANK_TYPE_COLOR)) {
													_tmp79_ = TRUE;
												} else {
													_tmp79_ = g_type_is_a (type, gdk_rgba_get_type ());
												}
												if (_tmp79_) {
													GValue val = {0};
													GValue _tmp80_ = {0};
													const gchar* _tmp81_;
													PlankColor* old_val = NULL;
													void* _tmp82_;
													gchar* old_val_string = NULL;
													gchar* _tmp83_;
													gchar* new_val_string = NULL;
													GKeyFile* _tmp84_;
													const gchar* _tmp85_;
													const gchar* _tmp86_;
													gchar* _tmp87_;
													const gchar* _tmp88_;
													const gchar* _tmp89_;
													PlankColor new_val = {0};
													const gchar* _tmp90_;
													PlankColor _tmp91_ = {0};
													const gchar* _tmp92_;
													GValue _tmp93_;
													g_value_init (&_tmp80_, type);
													val = _tmp80_;
													_tmp81_ = prop_name;
													g_object_get_property ((GObject*) self, _tmp81_, &val);
													_tmp82_ = g_value_get_boxed (&val);
													old_val = _tmp82_;
													_tmp83_ = plank_color_to_prefs_string (old_val);
													old_val_string = _tmp83_;
													_tmp84_ = file;
													_tmp85_ = group_name;
													_tmp86_ = prop_name;
													_tmp87_ = g_key_file_get_string (_tmp84_, _tmp85_, _tmp86_, &_inner_error0_);
													new_val_string = _tmp87_;
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
														_g_free0 (old_val_string);
														G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
														if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
															goto __catch1_g_key_file_error;
														}
														properties = (g_free (properties), NULL);
														_g_key_file_unref0 (file);
														_g_free0 (backing_file_path);
														_g_free0 (_tmp0_);
														g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
														g_clear_error (&_inner_error0_);
														return;
													}
													_tmp88_ = old_val_string;
													_tmp89_ = new_val_string;
													if (g_strcmp0 (_tmp88_, _tmp89_) == 0) {
														_g_free0 (new_val_string);
														_g_free0 (old_val_string);
														G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
														continue;
													}
													_tmp90_ = new_val_string;
													plank_color_from_prefs_string (_tmp90_, &_tmp91_);
													new_val = _tmp91_;
													g_value_set_boxed (&val, &new_val);
													_tmp92_ = prop_name;
													_tmp93_ = val;
													g_object_set_property ((GObject*) self, _tmp92_, &_tmp93_);
													_g_free0 (new_val_string);
													_g_free0 (old_val_string);
													G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
												} else {
													if (g_type_is_a (type, PLANK_TYPE_SERIALIZABLE)) {
														PlankSerializable* val = NULL;
														const gchar* _tmp94_;
														PlankSerializable* _tmp95_ = NULL;
														gchar* _tmp96_ = NULL;
														GKeyFile* _tmp97_;
														const gchar* _tmp98_;
														const gchar* _tmp99_;
														gchar* _tmp100_;
														PlankSerializable* _tmp101_;
														_tmp94_ = prop_name;
														g_object_get ((GObject*) self, _tmp94_, &_tmp95_, NULL);
														_g_object_unref0 (val);
														val = _tmp95_;
														_tmp97_ = file;
														_tmp98_ = group_name;
														_tmp99_ = prop_name;
														_tmp100_ = g_key_file_get_string (_tmp97_, _tmp98_, _tmp99_, &_inner_error0_);
														_tmp96_ = _tmp100_;
														if (G_UNLIKELY (_inner_error0_ != NULL)) {
															_g_object_unref0 (val);
															if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
																goto __catch1_g_key_file_error;
															}
															properties = (g_free (properties), NULL);
															_g_key_file_unref0 (file);
															_g_free0 (backing_file_path);
															_g_free0 (_tmp0_);
															g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
															g_clear_error (&_inner_error0_);
															return;
														}
														_tmp101_ = val;
														plank_serializable_deserialize (_tmp101_, _tmp96_);
														_g_free0 (_tmp96_);
														_g_object_unref0 (val);
														continue;
													} else {
														const gchar* _tmp102_;
														const gchar* _tmp103_;
														const gchar* _tmp104_;
														_tmp102_ = g_type_name (type);
														_tmp103_ = prop_name;
														_tmp104_ = backing_file_path;
														g_debug ("Preferences.vala:445: Unsupported preferences type '%s' for property '" \
"%s' in file '%s'", _tmp102_, _tmp103_, _tmp104_);
														continue;
													}
												}
											}
										}
									}
								}
							}
						}
						_tmp105_ = prop_name;
						plank_preferences_call_verify (self, _tmp105_);
					}
					goto __finally1;
					__catch1_g_key_file_error:
					{
						GError* e = NULL;
						const gchar* _tmp106_;
						const gchar* _tmp107_;
						GError* _tmp108_;
						const gchar* _tmp109_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp106_ = backing_file_path;
						_tmp107_ = prop_name;
						g_warning ("Preferences.vala:451: Problem loading preferences from file '%s' for p" \
"roperty '%s'", _tmp106_, _tmp107_);
						_tmp108_ = e;
						_tmp109_ = _tmp108_->message;
						g_debug ("Preferences.vala:452: %s", _tmp109_);
						_g_error_free0 (e);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						properties = (g_free (properties), NULL);
						_g_key_file_unref0 (file);
						goto __catch0_g_error;
					}
				}
			}
		}
		properties = (g_free (properties), NULL);
		_g_key_file_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp110_;
		GError* _tmp111_;
		const gchar* _tmp112_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp110_ = backing_file_path;
		g_warning ("Preferences.vala:456: Unable to load preferences from file '%s'", _tmp110_);
		_tmp111_ = e;
		_tmp112_ = _tmp111_->message;
		g_debug ("Preferences.vala:457: %s", _tmp112_);
		g_signal_emit (self, plank_preferences_signals[PLANK_PREFERENCES_DELETED_SIGNAL], 0);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (backing_file_path);
		_g_free0 (_tmp0_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_thaw_notify ((GObject*) self);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _plank_preferences_handle_notify_g_object_notify, self, 0);
	self->priv->is_delayed_internal = FALSE;
	if (missing_keys) {
		_tmp113_ = TRUE;
	} else {
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_ = FALSE;
		if (!self->priv->is_delayed) {
			_tmp115_ = self->priv->is_changed;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			GFile* _tmp116_;
			_tmp116_ = self->priv->backing_file;
			_tmp114_ = _tmp116_ != NULL;
		} else {
			_tmp114_ = FALSE;
		}
		_tmp113_ = _tmp114_;
	}
	if (_tmp113_) {
		plank_preferences_save_prefs (self);
	}
	_g_free0 (backing_file_path);
	_g_free0 (_tmp0_);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
plank_preferences_save_prefs (PlankPreferences* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* backing_file_path = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GKeyFile* file = NULL;
	GKeyFile* _tmp8_;
	GParamSpec** properties = NULL;
	GObjectClass* _tmp16_;
	guint _tmp17_ = 0;
	GParamSpec** _tmp18_;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp88_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->backing_file;
	_vala_return_if_fail (_tmp0_ != NULL, "backing_file != null");
	if (self->priv->read_only) {
		return;
	}
	_tmp2_ = self->priv->backing_file;
	_tmp3_ = g_file_get_path (_tmp2_);
	_tmp1_ = _tmp3_;
	if (_tmp1_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = _tmp1_;
	_tmp1_ = NULL;
	backing_file_path = _tmp5_;
	if (self->priv->is_delayed) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = self->priv->is_delayed_internal;
	}
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = backing_file_path;
		plank_logger_verbose ("Preferences.save_prefs('%s') - delaying save", _tmp7_, NULL);
		self->priv->is_changed = TRUE;
		_g_free0 (backing_file_path);
		_g_free0 (_tmp1_);
		return;
	}
	plank_preferences_stop_monitor (self);
	g_object_freeze_notify ((GObject*) self);
	_tmp8_ = g_key_file_new ();
	file = _tmp8_;
	{
		GKeyFile* _tmp9_;
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = file;
		_tmp10_ = g_date_time_new_now_utc ();
		_tmp11_ = _tmp10_;
		_tmp12_ = g_date_time_to_string (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("This file auto-generated by Plank.\n%s", _tmp13_);
		_tmp15_ = _tmp14_;
		g_key_file_set_comment (_tmp9_, NULL, NULL, _tmp15_, &_inner_error0_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_date_time_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (file);
		_g_free0 (backing_file_path);
		_g_free0 (_tmp1_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp16_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp18_ = g_object_class_list_properties (_tmp16_, &_tmp17_);
	properties = _tmp18_;
	properties_length1 = _tmp17_;
	_properties_size_ = properties_length1;
	_tmp19_ = properties;
	_tmp19__length1 = properties_length1;
	{
		GParamSpec** prop_collection = NULL;
		gint prop_collection_length1 = 0;
		gint _prop_collection_size_ = 0;
		gint prop_it = 0;
		prop_collection = _tmp19_;
		prop_collection_length1 = _tmp19__length1;
		for (prop_it = 0; prop_it < prop_collection_length1; prop_it = prop_it + 1) {
			GParamSpec* prop = NULL;
			prop = prop_collection[prop_it];
			{
				const gchar* group_name = NULL;
				GParamSpec* _tmp20_;
				const gchar* _tmp21_;
				const gchar* prop_name = NULL;
				GParamSpec* _tmp22_;
				const gchar* _tmp23_;
				GType type = 0UL;
				GParamSpec* _tmp24_;
				const gchar* prop_blurb = NULL;
				GParamSpec* _tmp76_;
				const gchar* _tmp77_;
				gboolean _tmp78_ = FALSE;
				gboolean _tmp79_ = FALSE;
				const gchar* _tmp80_;
				_tmp20_ = prop;
				_tmp21_ = g_type_name (_tmp20_->owner_type);
				group_name = _tmp21_;
				_tmp22_ = prop;
				_tmp23_ = g_param_spec_get_name (_tmp22_);
				prop_name = _tmp23_;
				_tmp24_ = prop;
				type = _tmp24_->value_type;
				if (type == G_TYPE_INT) {
					gint new_val = 0;
					const gchar* _tmp25_;
					gint _tmp26_ = 0;
					GKeyFile* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp25_ = prop_name;
					g_object_get ((GObject*) self, _tmp25_, &_tmp26_, NULL);
					new_val = _tmp26_;
					_tmp27_ = file;
					_tmp28_ = group_name;
					_tmp29_ = prop_name;
					g_key_file_set_integer (_tmp27_, _tmp28_, _tmp29_, new_val);
				} else {
					if (type == G_TYPE_UINT) {
						guint new_val = 0U;
						const gchar* _tmp30_;
						guint _tmp31_ = 0U;
						GKeyFile* _tmp32_;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						_tmp30_ = prop_name;
						g_object_get ((GObject*) self, _tmp30_, &_tmp31_, NULL);
						new_val = _tmp31_;
						_tmp32_ = file;
						_tmp33_ = group_name;
						_tmp34_ = prop_name;
						g_key_file_set_integer (_tmp32_, _tmp33_, _tmp34_, (gint) new_val);
					} else {
						if (type == G_TYPE_DOUBLE) {
							gdouble new_val = 0.0;
							const gchar* _tmp35_;
							gdouble _tmp36_ = 0.0;
							GKeyFile* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							_tmp35_ = prop_name;
							g_object_get ((GObject*) self, _tmp35_, &_tmp36_, NULL);
							new_val = _tmp36_;
							_tmp37_ = file;
							_tmp38_ = group_name;
							_tmp39_ = prop_name;
							g_key_file_set_double (_tmp37_, _tmp38_, _tmp39_, new_val);
						} else {
							if (type == G_TYPE_STRING) {
								gchar* new_val = NULL;
								const gchar* _tmp40_;
								gchar* _tmp41_ = NULL;
								GKeyFile* _tmp42_;
								const gchar* _tmp43_;
								const gchar* _tmp44_;
								const gchar* _tmp45_;
								_tmp40_ = prop_name;
								g_object_get ((GObject*) self, _tmp40_, &_tmp41_, NULL);
								_g_free0 (new_val);
								new_val = _tmp41_;
								_tmp42_ = file;
								_tmp43_ = group_name;
								_tmp44_ = prop_name;
								_tmp45_ = new_val;
								g_key_file_set_string (_tmp42_, _tmp43_, _tmp44_, _tmp45_);
								_g_free0 (new_val);
							} else {
								if (type == G_TYPE_BOOLEAN) {
									gboolean new_val = FALSE;
									const gchar* _tmp46_;
									gboolean _tmp47_ = FALSE;
									GKeyFile* _tmp48_;
									const gchar* _tmp49_;
									const gchar* _tmp50_;
									_tmp46_ = prop_name;
									g_object_get ((GObject*) self, _tmp46_, &_tmp47_, NULL);
									new_val = _tmp47_;
									_tmp48_ = file;
									_tmp49_ = group_name;
									_tmp50_ = prop_name;
									g_key_file_set_boolean (_tmp48_, _tmp49_, _tmp50_, new_val);
								} else {
									if (G_TYPE_IS_ENUM (type)) {
										gint new_val = 0;
										const gchar* _tmp51_;
										gint _tmp52_ = 0;
										GKeyFile* _tmp53_;
										const gchar* _tmp54_;
										const gchar* _tmp55_;
										_tmp51_ = prop_name;
										g_object_get ((GObject*) self, _tmp51_, &_tmp52_, NULL);
										new_val = _tmp52_;
										_tmp53_ = file;
										_tmp54_ = group_name;
										_tmp55_ = prop_name;
										g_key_file_set_integer (_tmp53_, _tmp54_, _tmp55_, new_val);
									} else {
										gboolean _tmp56_ = FALSE;
										if (g_type_is_a (type, PLANK_TYPE_COLOR)) {
											_tmp56_ = TRUE;
										} else {
											_tmp56_ = g_type_is_a (type, gdk_rgba_get_type ());
										}
										if (_tmp56_) {
											GValue val = {0};
											GValue _tmp57_ = {0};
											const gchar* _tmp58_;
											PlankColor* color = NULL;
											void* _tmp59_;
											GKeyFile* _tmp60_;
											const gchar* _tmp61_;
											const gchar* _tmp62_;
											gchar* _tmp63_;
											gchar* _tmp64_;
											g_value_init (&_tmp57_, type);
											val = _tmp57_;
											_tmp58_ = prop_name;
											g_object_get_property ((GObject*) self, _tmp58_, &val);
											_tmp59_ = g_value_get_boxed (&val);
											color = _tmp59_;
											_tmp60_ = file;
											_tmp61_ = group_name;
											_tmp62_ = prop_name;
											_tmp63_ = plank_color_to_prefs_string (color);
											_tmp64_ = _tmp63_;
											g_key_file_set_string (_tmp60_, _tmp61_, _tmp62_, _tmp64_);
											_g_free0 (_tmp64_);
											G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
										} else {
											if (g_type_is_a (type, PLANK_TYPE_SERIALIZABLE)) {
												GValue val = {0};
												GValue _tmp65_ = {0};
												const gchar* _tmp66_;
												GKeyFile* _tmp67_;
												const gchar* _tmp68_;
												const gchar* _tmp69_;
												GObject* _tmp70_;
												gchar* _tmp71_;
												gchar* _tmp72_;
												g_value_init (&_tmp65_, type);
												val = _tmp65_;
												_tmp66_ = prop_name;
												g_object_get_property ((GObject*) self, _tmp66_, &val);
												_tmp67_ = file;
												_tmp68_ = group_name;
												_tmp69_ = prop_name;
												_tmp70_ = g_value_get_object (&val);
												_tmp71_ = plank_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, PLANK_TYPE_SERIALIZABLE, PlankSerializable));
												_tmp72_ = _tmp71_;
												g_key_file_set_string (_tmp67_, _tmp68_, _tmp69_, _tmp72_);
												_g_free0 (_tmp72_);
												G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
											} else {
												const gchar* _tmp73_;
												const gchar* _tmp74_;
												const gchar* _tmp75_;
												_tmp73_ = g_type_name (type);
												_tmp74_ = prop_name;
												_tmp75_ = backing_file_path;
												g_debug ("Preferences.vala:534: Unsupported preferences type '%s' for property '" \
"%s' in file '%s'", _tmp73_, _tmp74_, _tmp75_);
												continue;
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp76_ = prop;
				_tmp77_ = g_param_spec_get_blurb (_tmp76_);
				prop_blurb = _tmp77_;
				_tmp80_ = prop_blurb;
				if (_tmp80_ != NULL) {
					const gchar* _tmp81_;
					_tmp81_ = prop_blurb;
					_tmp79_ = g_strcmp0 (_tmp81_, "") != 0;
				} else {
					_tmp79_ = FALSE;
				}
				if (_tmp79_) {
					const gchar* _tmp82_;
					const gchar* _tmp83_;
					_tmp82_ = prop_blurb;
					_tmp83_ = prop_name;
					_tmp78_ = g_strcmp0 (_tmp82_, _tmp83_) != 0;
				} else {
					_tmp78_ = FALSE;
				}
				if (_tmp78_) {
					{
						GKeyFile* _tmp84_;
						const gchar* _tmp85_;
						const gchar* _tmp86_;
						const gchar* _tmp87_;
						_tmp84_ = file;
						_tmp85_ = group_name;
						_tmp86_ = prop_name;
						_tmp87_ = prop_blurb;
						g_key_file_set_comment (_tmp84_, _tmp85_, _tmp86_, _tmp87_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
					goto __finally1;
					__catch1_g_error:
					{
						g_clear_error (&_inner_error0_);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						properties = (g_free (properties), NULL);
						_g_key_file_unref0 (file);
						_g_free0 (backing_file_path);
						_g_free0 (_tmp1_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
	}
	_tmp88_ = backing_file_path;
	g_debug ("Preferences.vala:545: Saving preferences '%s'", _tmp88_);
	self->priv->is_changed = FALSE;
	{
		GFileOutputStream* _tmp89_ = NULL;
		GFile* _tmp90_;
		GFileOutputStream* _tmp91_;
		GDataOutputStream* stream = NULL;
		GDataOutputStream* _tmp92_;
		GDataOutputStream* _tmp93_;
		GKeyFile* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		GDataOutputStream* _tmp97_;
		_tmp90_ = self->priv->backing_file;
		_tmp91_ = g_file_replace (_tmp90_, NULL, FALSE, 0, NULL, &_inner_error0_);
		_tmp89_ = _tmp91_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp92_ = g_data_output_stream_new ((GOutputStream*) _tmp89_);
		stream = _tmp92_;
		_tmp93_ = stream;
		_tmp94_ = file;
		_tmp95_ = g_key_file_to_data (_tmp94_, NULL, NULL);
		_tmp96_ = _tmp95_;
		g_data_output_stream_put_string (_tmp93_, _tmp96_, NULL, &_inner_error0_);
		_g_free0 (_tmp96_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp89_);
			goto __catch2_g_error;
		}
		_tmp97_ = stream;
		g_output_stream_close ((GOutputStream*) _tmp97_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp89_);
			goto __catch2_g_error;
		}
		_g_object_unref0 (stream);
		_g_object_unref0 (_tmp89_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp98_;
		GError* _tmp99_;
		const gchar* _tmp100_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp98_ = backing_file_path;
		g_warning ("Preferences.vala:553: Unable to create the preferences file '%s'", _tmp98_);
		_tmp99_ = e;
		_tmp100_ = _tmp99_->message;
		g_debug ("Preferences.vala:554: %s", _tmp100_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		properties = (g_free (properties), NULL);
		_g_key_file_unref0 (file);
		_g_free0 (backing_file_path);
		_g_free0 (_tmp1_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_thaw_notify ((GObject*) self);
	plank_preferences_start_monitor (self);
	properties = (g_free (properties), NULL);
	_g_key_file_unref0 (file);
	_g_free0 (backing_file_path);
	_g_free0 (_tmp1_);
}

static GObject *
plank_preferences_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankPreferences * self;
	parent_class = G_OBJECT_CLASS (plank_preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_PREFERENCES, PlankPreferences);
	plank_preferences_reset_properties (self);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _plank_preferences_handle_notify_g_object_notify, self, 0);
	return obj;
}

static void
plank_preferences_class_init (PlankPreferencesClass * klass,
                              gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	plank_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankPreferences_private_offset);
	((PlankPreferencesClass *) klass)->verify = (void (*) (PlankPreferences*, const gchar*)) plank_preferences_real_verify;
	((PlankPreferencesClass *) klass)->reset_properties = (void (*) (PlankPreferences*)) plank_preferences_real_reset_properties;
	G_OBJECT_CLASS (klass)->constructor = plank_preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_preferences_finalize;
	/**
	 * This signal indicates that the backing file for this preferences was deleted.
	 */
	plank_preferences_signals[PLANK_PREFERENCES_DELETED_SIGNAL] = g_signal_new ("deleted", PLANK_TYPE_PREFERENCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("PlankItemsDockItemPreferences");
	_tmp1_ = g_strdup ("PlankDockItemPreferences");
	_tmp2_ = g_strdup ("PlankDrawingTheme");
	_tmp3_ = g_strdup ("PlankTheme");
	_tmp4_ = g_strdup ("PlankDrawingDockTheme");
	_tmp5_ = g_strdup ("PlankDockTheme");
	_tmp6_ = g_new0 (gchar*, (3 * 2) + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	plank_preferences_TRANSITION_MAP = _tmp6_;
	plank_preferences_TRANSITION_MAP_length1 = 3;
	plank_preferences_TRANSITION_MAP_length2 = 2;
}

static void
plank_preferences_instance_init (PlankPreferences * self,
                                 gpointer klass)
{
	self->priv = plank_preferences_get_instance_private (self);
	self->priv->read_only = FALSE;
	self->priv->is_delayed = FALSE;
	self->priv->is_delayed_internal = FALSE;
	self->priv->is_changed = FALSE;
}

static void
plank_preferences_finalize (GObject * obj)
{
	PlankPreferences * self;
	guint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_PREFERENCES, PlankPreferences);
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _plank_preferences_handle_notify_g_object_notify, self);
	plank_preferences_apply (self);
	plank_preferences_stop_monitor (self);
	_g_object_unref0 (self->priv->backing_file);
	_g_object_unref0 (self->priv->backing_monitor);
	G_OBJECT_CLASS (plank_preferences_parent_class)->finalize (obj);
}

/**
 * The base class for all preferences in the system.  Preferences are serialized to files.
 * The file is watched for changes and loads new values if the backing file changed.  When
 * any public property of a sub-class is changed, the public properties are serialized to
 * the backing file.
 */
static GType
plank_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankPreferences), 0, (GInstanceInitFunc) plank_preferences_instance_init, NULL };
	GType plank_preferences_type_id;
	plank_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankPreferences", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PlankPreferences_private_offset = g_type_add_instance_private (plank_preferences_type_id, sizeof (PlankPreferencesPrivate));
	return plank_preferences_type_id;
}

GType
plank_preferences_get_type (void)
{
	static volatile gsize plank_preferences_type_id__once = 0;
	if (g_once_init_enter (&plank_preferences_type_id__once)) {
		GType plank_preferences_type_id;
		plank_preferences_type_id = plank_preferences_get_type_once ();
		g_once_init_leave (&plank_preferences_type_id__once, plank_preferences_type_id);
	}
	return plank_preferences_type_id__once;
}

