/* System.c generated by valac 0.56.17, the Vala compiler
 * generated from System.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_SYSTEM_0_PROPERTY,
	PLANK_SYSTEM_CONTEXT_PROPERTY,
	PLANK_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* plank_system_properties[PLANK_SYSTEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PlankSystemPrivate {
	GAppLaunchContext* _context;
};

static gint PlankSystem_private_offset;
static gpointer plank_system_parent_class = NULL;
static PlankSystem* plank_system_instance;
static PlankSystem* plank_system_instance = NULL;

static void plank_system_on_launch_failed (PlankSystem* self,
                                    const gchar* startup_notify_id);
static void _plank_system_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                                        const gchar* startup_notify_id,
                                                                        gpointer self);
static void plank_system_on_launched (PlankSystem* self,
                               GAppInfo* info,
                               GVariant* platform_data);
static void _plank_system_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender,
                                                              GAppInfo* info,
                                                              GVariant* platform_data,
                                                              gpointer self);
static gboolean plank_system_path_is_mounted (const gchar* path);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void plank_system_internal_launch (PlankSystem* self,
                                   GFile* app,
                                   GList* files);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static GObject * plank_system_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void plank_system_finalize (GObject * obj);
static GType plank_system_get_type_once (void);
static void _vala_plank_system_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_plank_system_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
plank_system_get_instance_private (PlankSystem* self)
{
	return G_STRUCT_MEMBER_P (self, PlankSystem_private_offset);
}

static void
_plank_system_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                                   const gchar* startup_notify_id,
                                                                   gpointer self)
{
	plank_system_on_launch_failed ((PlankSystem*) self, startup_notify_id);
}

static void
_plank_system_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender,
                                                         GAppInfo* info,
                                                         GVariant* platform_data,
                                                         gpointer self)
{
	plank_system_on_launched ((PlankSystem*) self, info, platform_data);
}

PlankSystem*
plank_system_get_default (void)
{
	PlankSystem* _tmp0_;
	PlankSystem* _tmp5_;
	PlankSystem* result;
	_tmp0_ = plank_system_instance;
	if (_tmp0_ == NULL) {
		GdkDisplay* _tmp1_;
		GdkAppLaunchContext* _tmp2_;
		GdkAppLaunchContext* _tmp3_;
		PlankSystem* _tmp4_;
		_tmp1_ = gdk_display_get_default ();
		_tmp2_ = gdk_display_get_app_launch_context (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = plank_system_new ((GAppLaunchContext*) _tmp3_);
		_g_object_unref0 (plank_system_instance);
		plank_system_instance = _tmp4_;
		_g_object_unref0 (_tmp3_);
	}
	_tmp5_ = plank_system_instance;
	result = _tmp5_;
	return result;
}

PlankSystem*
plank_system_construct (GType object_type,
                        GAppLaunchContext* context)
{
	PlankSystem * self = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	self = (PlankSystem*) g_object_new (object_type, "context", context, NULL);
	return self;
}

PlankSystem*
plank_system_new (GAppLaunchContext* context)
{
	return plank_system_construct (PLANK_TYPE_SYSTEM, context);
}

static void
plank_system_on_launch_failed (PlankSystem* self,
                               const gchar* startup_notify_id)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (startup_notify_id != NULL);
	g_warning ("System.vala:58: Failed to launch '%s'", startup_notify_id);
}

static void
plank_system_on_launched (PlankSystem* self,
                          GAppInfo* info,
                          GVariant* platform_data)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (platform_data != NULL);
	_tmp0_ = g_app_info_get_name (info);
	_tmp1_ = g_app_info_get_executable (info);
	plank_logger_verbose ("Launched '%s' ('%s')", _tmp0_, _tmp1_, NULL);
}

/**
 * Opens a file based on a URI.
 *
 * @param uri the URI to open
 */
void
plank_system_open_uri (PlankSystem* self,
                       const gchar* uri)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	_tmp1_ = _tmp0_;
	plank_system_open (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

/**
 * Opens a file based on a {@link GLib.File}.
 *
 * @param file the {@link GLib.File} to open
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
plank_system_open (PlankSystem* self,
                   GFile* file)
{
	GFile* _tmp0_;
	GFile** _tmp1_;
	GFile** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = _g_object_ref0 (file);
	_tmp1_ = g_new0 (GFile*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	plank_system_launch_with_files (self, NULL, _tmp2_, (gint) 1);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_object_unref), NULL);
}

/**
 * Opens multiple files based on {@link GLib.File}.
 *
 * @param files the {@link GLib.File}s to open
 */
void
plank_system_open_files (PlankSystem* self,
                         GFile** files,
                         gint files_length1)
{
	g_return_if_fail (self != NULL);
	plank_system_launch_with_files (self, NULL, files, (gint) files_length1);
}

/**
 * Launches an application.
 *
 * @param app the application to launch
 */
void
plank_system_launch (PlankSystem* self,
                     GFile* app)
{
	GFile** _tmp0_;
	GFile** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	plank_system_launch_with_files (self, app, _tmp1_, (gint) 0);
	_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_object_unref), NULL);
}

/**
 * Launches an application and opens files.
 *
 * @param app the application to launch
 * @param files the files to open with the application
 */
static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
plank_system_launch_with_files (PlankSystem* self,
                                GFile* app,
                                GFile** files,
                                gint files_length1)
{
	gboolean _tmp0_ = FALSE;
	GList* mounted_files = NULL;
	gboolean _tmp23_ = FALSE;
	GList* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (app != NULL) {
		_tmp0_ = !g_file_query_exists (app, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp2_ = g_file_get_path (app);
		_tmp1_ = _tmp2_;
		if (_tmp1_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp3_;
		}
		g_warning ("System.vala:115: Application '%s' doesn't exist", _tmp1_);
		_g_free0 (_tmp1_);
		return;
	}
	mounted_files = NULL;
	{
		GFile** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = files;
		f_collection_length1 = files_length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			GFile* _tmp4_;
			GFile* f = NULL;
			_tmp4_ = _g_object_ref0 (f_collection[f_it]);
			f = _tmp4_;
			{
				gchar* path = NULL;
				GFile* _tmp5_;
				gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				const gchar* _tmp9_;
				_tmp5_ = f;
				_tmp6_ = g_file_get_path (_tmp5_);
				path = _tmp6_;
				_tmp9_ = path;
				if (_tmp9_ != NULL) {
					const gchar* _tmp10_;
					_tmp10_ = path;
					_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gboolean _tmp11_ = FALSE;
					GFile* _tmp12_;
					_tmp12_ = f;
					if (g_file_is_native (_tmp12_)) {
						_tmp11_ = TRUE;
					} else {
						const gchar* _tmp13_;
						_tmp13_ = path;
						_tmp11_ = plank_system_path_is_mounted (_tmp13_);
					}
					_tmp7_ = _tmp11_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					GFile* _tmp14_;
					GFile* _tmp15_;
					_tmp14_ = f;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					mounted_files = g_list_append (mounted_files, _tmp15_);
					_g_free0 (path);
					_g_object_unref0 (f);
					continue;
				}
				{
					GFile* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					GAppLaunchContext* _tmp19_;
					_tmp16_ = f;
					_tmp17_ = g_file_get_uri (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = self->priv->_context;
					g_app_info_launch_default_for_uri (_tmp18_, _tmp19_, &_inner_error0_);
					_g_free0 (_tmp18_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GFile* _tmp20_;
					GFile* _tmp21_;
					GFile* _tmp22_;
					g_clear_error (&_inner_error0_);
					_tmp20_ = f;
					g_file_mount_enclosing_volume (_tmp20_, 0, NULL, NULL, NULL, NULL);
					_tmp21_ = f;
					_tmp22_ = _g_object_ref0 (_tmp21_);
					mounted_files = g_list_append (mounted_files, _tmp22_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (path);
					_g_object_unref0 (f);
					(mounted_files == NULL) ? NULL : (mounted_files = (_g_list_free__g_object_unref0_ (mounted_files), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (path);
				_g_object_unref0 (f);
			}
		}
	}
	_tmp24_ = mounted_files;
	if (g_list_length (_tmp24_) > ((guint) 0)) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = files_length1 == 0;
	}
	if (_tmp23_) {
		GList* _tmp25_;
		_tmp25_ = mounted_files;
		plank_system_internal_launch (self, app, _tmp25_);
	}
	(mounted_files == NULL) ? NULL : (mounted_files = (_g_list_free__g_object_unref0_ (mounted_files), NULL));
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
plank_system_path_is_mounted (const gchar* path)
{
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_volume_monitor_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_volume_monitor_get_mounts (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp3_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			GMount* _tmp4_;
			GMount* m = NULL;
			_tmp4_ = _g_object_ref0 ((GMount*) m_it->data);
			m = _tmp4_;
			{
				GFile* m_root = NULL;
				GMount* _tmp5_;
				GFile* _tmp6_;
				GFile* _tmp7_;
				gchar* m_path = NULL;
				GFile* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
				_tmp5_ = m;
				_tmp6_ = g_mount_get_root (_tmp5_);
				m_root = _tmp6_;
				_tmp7_ = m_root;
				if (_tmp7_ == NULL) {
					_g_object_unref0 (m_root);
					_g_object_unref0 (m);
					continue;
				}
				_tmp8_ = m_root;
				_tmp9_ = g_file_get_path (_tmp8_);
				m_path = _tmp9_;
				_tmp11_ = m_path;
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					_tmp12_ = m_path;
					_tmp10_ = string_contains (path, _tmp12_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					result = TRUE;
					_g_free0 (m_path);
					_g_object_unref0 (m_root);
					_g_object_unref0 (m);
					(m_collection == NULL) ? NULL : (m_collection = (_g_list_free__g_object_unref0_ (m_collection), NULL));
					return result;
				}
				_g_free0 (m_path);
				_g_object_unref0 (m_root);
				_g_object_unref0 (m);
			}
		}
		(m_collection == NULL) ? NULL : (m_collection = (_g_list_free__g_object_unref0_ (m_collection), NULL));
	}
	result = FALSE;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
plank_system_internal_launch (PlankSystem* self,
                              GFile* app,
                              GList* files)
{
	gboolean _tmp0_ = FALSE;
	GAppInfo* info = NULL;
	GAppInfo* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (app == NULL) {
		_tmp0_ = g_list_length (files) == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	info = NULL;
	if (app != NULL) {
		GKeyFile* keyfile = NULL;
		gchar* launcher = NULL;
		gchar* _tmp1_;
		const gchar* _tmp24_;
		GDesktopAppInfo* _tmp25_;
		_tmp1_ = g_file_get_path (app);
		launcher = _tmp1_;
		{
			GKeyFile* _tmp2_;
			GKeyFile* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = g_key_file_new ();
			_g_key_file_unref0 (keyfile);
			keyfile = _tmp2_;
			_tmp3_ = keyfile;
			_tmp4_ = launcher;
			g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = launcher;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_critical ("System.vala:171: %s: %s", _tmp5_, _tmp7_);
			_g_error_free0 (e);
			_g_free0 (launcher);
			_g_key_file_unref0 (keyfile);
			_g_object_unref0 (info);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (launcher);
			_g_key_file_unref0 (keyfile);
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			gchar* type = NULL;
			GKeyFile* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			GQuark _tmp13_ = 0U;
			static GQuark _tmp12_label0 = 0;
			_tmp8_ = keyfile;
			_tmp9_ = g_key_file_get_string (_tmp8_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, &_inner_error0_);
			type = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				_g_free0 (launcher);
				_g_key_file_unref0 (keyfile);
				_g_object_unref0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp10_ = type;
			_tmp11_ = _tmp10_;
			_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
			if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string (G_KEY_FILE_DESKTOP_TYPE_LINK)))) {
				switch (0) {
					default:
					{
						{
							gchar* url = NULL;
							GKeyFile* _tmp14_;
							gchar* _tmp15_;
							const gchar* _tmp16_;
							GAppLaunchContext* _tmp17_;
							_tmp14_ = keyfile;
							_tmp15_ = g_key_file_get_string (_tmp14_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_URL, &_inner_error0_);
							url = _tmp15_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
							_tmp16_ = url;
							_tmp17_ = self->priv->_context;
							g_app_info_launch_default_for_uri (_tmp16_, _tmp17_, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_free0 (url);
								goto __catch2_g_error;
							}
							_g_free0 (url);
						}
						goto __finally2;
						__catch2_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp18_;
							GError* _tmp19_;
							const gchar* _tmp20_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp18_ = launcher;
							_tmp19_ = e;
							_tmp20_ = _tmp19_->message;
							g_critical ("System.vala:187: %s: %s", _tmp18_, _tmp20_);
							_g_error_free0 (e);
						}
						__finally2:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (type);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch1_g_key_file_error;
							}
							_g_free0 (launcher);
							_g_key_file_unref0 (keyfile);
							_g_object_unref0 (info);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_g_free0 (type);
						_g_free0 (launcher);
						_g_key_file_unref0 (keyfile);
						_g_object_unref0 (info);
						return;
					}
				}
			} else {
				switch (0) {
					default:
					{
						break;
					}
				}
			}
			_g_free0 (type);
		}
		goto __finally1;
		__catch1_g_key_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp21_ = launcher;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			g_critical ("System.vala:192: %s: %s", _tmp21_, _tmp23_);
			_g_error_free0 (e);
			_g_free0 (launcher);
			_g_key_file_unref0 (keyfile);
			_g_object_unref0 (info);
			return;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (launcher);
			_g_key_file_unref0 (keyfile);
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp24_ = launcher;
		_tmp25_ = g_desktop_app_info_new_from_filename (_tmp24_);
		_g_object_unref0 (info);
		info = (GAppInfo*) _tmp25_;
		_g_free0 (launcher);
		_g_key_file_unref0 (keyfile);
	} else {
		{
			GAppInfo* _tmp26_ = NULL;
			GList* _tmp27_;
			gconstpointer _tmp28_;
			GAppInfo* _tmp29_;
			GAppInfo* _tmp30_;
			_tmp27_ = g_list_first (files);
			_tmp28_ = _tmp27_->data;
			_tmp29_ = g_file_query_default_handler ((GFile*) _tmp28_, NULL, &_inner_error0_);
			_tmp26_ = _tmp29_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp30_ = _tmp26_;
			_tmp26_ = NULL;
			_g_object_unref0 (info);
			info = _tmp30_;
			_g_object_unref0 (_tmp26_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GError* _tmp31_;
			const gchar* _tmp32_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp31_ = e;
			_tmp32_ = _tmp31_->message;
			g_critical ("System.vala:201: %s", _tmp32_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp33_ = info;
	if (_tmp33_ == NULL) {
		gchar* _tmp34_ = NULL;
		if (app != NULL) {
			gchar* _tmp35_;
			_tmp35_ = g_file_get_path (app);
			_g_free0 (_tmp34_);
			_tmp34_ = _tmp35_;
		} else {
			GList* _tmp36_;
			gconstpointer _tmp37_;
			gchar* _tmp38_;
			_tmp36_ = g_list_first (files);
			_tmp37_ = _tmp36_->data;
			_tmp38_ = g_file_get_path ((GFile*) _tmp37_);
			_g_free0 (_tmp34_);
			_tmp34_ = _tmp38_;
		}
		g_critical ("System.vala:206: Unable to use application/file '%s' for execution.", _tmp34_);
		_g_free0 (_tmp34_);
		_g_object_unref0 (info);
		return;
	}
	{
		GAppInfo* _tmp39_;
		const gchar* _tmp40_;
		GAppInfo* _tmp41_;
		const gchar* _tmp42_;
		GAppInfo* _tmp45_;
		GAppInfo* _tmp48_;
		GAppInfo* _tmp55_;
		const gchar* _tmp56_;
		_tmp39_ = info;
		_tmp40_ = g_app_info_get_name (_tmp39_);
		_tmp41_ = info;
		_tmp42_ = g_app_info_get_executable (_tmp41_);
		plank_logger_verbose ("Launch '%s' ('%s')", _tmp40_, _tmp42_, NULL);
		if (g_list_length (files) == ((guint) 0)) {
			GAppInfo* _tmp43_;
			GAppLaunchContext* _tmp44_;
			_tmp43_ = info;
			_tmp44_ = self->priv->_context;
			g_app_info_launch (_tmp43_, NULL, _tmp44_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
			_g_object_unref0 (info);
			return;
		}
		_tmp45_ = info;
		if (g_app_info_supports_files (_tmp45_)) {
			GAppInfo* _tmp46_;
			GAppLaunchContext* _tmp47_;
			_tmp46_ = info;
			_tmp47_ = self->priv->_context;
			g_app_info_launch (_tmp46_, files, _tmp47_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
			_g_object_unref0 (info);
			return;
		}
		_tmp48_ = info;
		if (g_app_info_supports_uris (_tmp48_)) {
			GList* uris = NULL;
			GAppInfo* _tmp52_;
			GList* _tmp53_;
			GAppLaunchContext* _tmp54_;
			uris = NULL;
			{
				GList* f_collection = NULL;
				GList* f_it = NULL;
				f_collection = files;
				for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
					GFile* _tmp49_;
					GFile* f = NULL;
					_tmp49_ = _g_object_ref0 ((GFile*) f_it->data);
					f = _tmp49_;
					{
						GFile* _tmp50_;
						gchar* _tmp51_;
						_tmp50_ = f;
						_tmp51_ = g_file_get_uri (_tmp50_);
						uris = g_list_append (uris, _tmp51_);
						_g_object_unref0 (f);
					}
				}
			}
			_tmp52_ = info;
			_tmp53_ = uris;
			_tmp54_ = self->priv->_context;
			g_app_info_launch_uris (_tmp52_, _tmp53_, _tmp54_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				(uris == NULL) ? NULL : (uris = (_g_list_free__g_free0_ (uris), NULL));
				goto __catch4_g_error;
			}
			(uris == NULL) ? NULL : (uris = (_g_list_free__g_free0_ (uris), NULL));
			_g_object_unref0 (info);
			return;
		}
		_tmp55_ = info;
		_tmp56_ = g_app_info_get_name (_tmp55_);
		g_warning ("System.vala:232: The application '%s' doesn't support files/URIs or wa" \
"sn't found.", _tmp56_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_critical ("System.vala:234: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (info);
}

GAppLaunchContext*
plank_system_get_context (PlankSystem* self)
{
	GAppLaunchContext* result;
	GAppLaunchContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}

static void
plank_system_set_context (PlankSystem* self,
                          GAppLaunchContext* value)
{
	GAppLaunchContext* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_system_get_context (self);
	if (old_value != value) {
		GAppLaunchContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_context);
		self->priv->_context = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_system_properties[PLANK_SYSTEM_CONTEXT_PROPERTY]);
	}
}

static GObject *
plank_system_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankSystem * self;
	GAppLaunchContext* _tmp0_;
	GAppLaunchContext* _tmp1_;
	parent_class = G_OBJECT_CLASS (plank_system_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_SYSTEM, PlankSystem);
	_tmp0_ = self->priv->_context;
	g_signal_connect_object (_tmp0_, "launch-failed", (GCallback) _plank_system_on_launch_failed_g_app_launch_context_launch_failed, self, 0);
	_tmp1_ = self->priv->_context;
	g_signal_connect_object (_tmp1_, "launched", (GCallback) _plank_system_on_launched_g_app_launch_context_launched, self, 0);
	return obj;
}

static void
plank_system_class_init (PlankSystemClass * klass,
                         gpointer klass_data)
{
	plank_system_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankSystem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_system_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_system_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_system_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_system_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_SYSTEM_CONTEXT_PROPERTY, plank_system_properties[PLANK_SYSTEM_CONTEXT_PROPERTY] = g_param_spec_object ("context", "context", "context", g_app_launch_context_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
plank_system_instance_init (PlankSystem * self,
                            gpointer klass)
{
	self->priv = plank_system_get_instance_private (self);
}

static void
plank_system_finalize (GObject * obj)
{
	PlankSystem * self;
	GAppLaunchContext* _tmp0_;
	guint _tmp1_;
	GAppLaunchContext* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_SYSTEM, PlankSystem);
	_tmp0_ = self->priv->_context;
	g_signal_parse_name ("launch-failed", g_app_launch_context_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _plank_system_on_launch_failed_g_app_launch_context_launch_failed, self);
	_tmp2_ = self->priv->_context;
	g_signal_parse_name ("launched", g_app_launch_context_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _plank_system_on_launched_g_app_launch_context_launched, self);
	_g_object_unref0 (self->priv->_context);
	G_OBJECT_CLASS (plank_system_parent_class)->finalize (obj);
}

/**
 * A utility class for launching applications and opening files/URIs.
 */
static GType
plank_system_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankSystem), 0, (GInstanceInitFunc) plank_system_instance_init, NULL };
	GType plank_system_type_id;
	plank_system_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankSystem", &g_define_type_info, 0);
	PlankSystem_private_offset = g_type_add_instance_private (plank_system_type_id, sizeof (PlankSystemPrivate));
	return plank_system_type_id;
}

GType
plank_system_get_type (void)
{
	static volatile gsize plank_system_type_id__once = 0;
	if (g_once_init_enter (&plank_system_type_id__once)) {
		GType plank_system_type_id;
		plank_system_type_id = plank_system_get_type_once ();
		g_once_init_leave (&plank_system_type_id__once, plank_system_type_id);
	}
	return plank_system_type_id__once;
}

static void
_vala_plank_system_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	PlankSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_SYSTEM, PlankSystem);
	switch (property_id) {
		case PLANK_SYSTEM_CONTEXT_PROPERTY:
		g_value_set_object (value, plank_system_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_system_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	PlankSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_SYSTEM, PlankSystem);
	switch (property_id) {
		case PLANK_SYSTEM_CONTEXT_PROPERTY:
		plank_system_set_context (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

