/* Version.c generated by valac 0.56.17, the Vala compiler
 * generated from Version.vala, do not modify */

/**/
/*  Copyright (C) 2014 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

/**
 * Returns the major version number of the plank library.
 *
 * This function is in the library, so it represents the GTK+
 * library your code is are running against.
 *
 * @return the major version number of the plank library
 */
guint
plank_get_major_version (void)
{
	guint result;
	result = VERSION_MAJOR;
	return result;
}

/**
 * Returns the minor version number of the plank library.
 *
 * This function is in the library, so it represents the plank
 * library your code is are running against.
 *
 * @return the minor version number of the plank library
 */
guint
plank_get_minor_version (void)
{
	guint result;
	result = VERSION_MINOR;
	return result;
}

/**
 * Returns the micro version number of the plank library.
 *
 * This function is in the library, so it represents the plank
 * library your code is are running against.
 *
 * @return the micro version number of the plank library
 */
guint
plank_get_micro_version (void)
{
	guint result;
	result = VERSION_MICRO;
	return result;
}

/**
 * Returns the nano version number of the plank library.
 *
 * This function is in the library, so it represents the plank
 * library your code is are running against.
 *
 * @return the nano version number of the plank library
 */
guint
plank_get_nano_version (void)
{
	guint result;
	result = VERSION_NANO;
	return result;
}

/**
 * Checks that the plank library in use is compatible with the given version.
 *
 * This function is in the library, so it represents the plank
 * library your code is are running against.
 *
 * @param required_major the required major version
 * @param required_minor the required minor version
 * @param required_micro the required micro version
 * @return null if the plank library is compatible with the given version,
 * or a string describing the version mismatch.
 */
const gchar*
plank_check_version (guint required_major,
                     guint required_minor,
                     guint required_micro)
{
	guint effective_micro = 0U;
	guint required_effective_micro = 0U;
	const gchar* result;
	effective_micro = (100 * VERSION_MINOR) + VERSION_MICRO;
	required_effective_micro = (100 * required_minor) + required_micro;
	if (required_major > VERSION_MAJOR) {
		result = "plank version too old (major mismatch)";
		return result;
	}
	if (required_effective_micro > effective_micro) {
		result = "plank version too old (micro mismatch)";
		return result;
	}
	result = NULL;
	return result;
}

